# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogtailConfigsResult',
    'AwaitableGetLogtailConfigsResult',
    'get_logtail_configs',
    'get_logtail_configs_output',
]

@pulumi.output_type
class GetLogtailConfigsResult:
    """
    A collection of values returned by getLogtailConfigs.
    """
    def __init__(__self__, configs=None, id=None, ids=None, logstore_name=None, logtail_config_name=None, name_regex=None, names=None, offset=None, output_file=None, project_name=None, size=None):
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if logstore_name and not isinstance(logstore_name, str):
            raise TypeError("Expected argument 'logstore_name' to be a str")
        pulumi.set(__self__, "logstore_name", logstore_name)
        if logtail_config_name and not isinstance(logtail_config_name, str):
            raise TypeError("Expected argument 'logtail_config_name' to be a str")
        pulumi.set(__self__, "logtail_config_name", logtail_config_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if offset and not isinstance(offset, int):
            raise TypeError("Expected argument 'offset' to be a int")
        pulumi.set(__self__, "offset", offset)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetLogtailConfigsConfigResult']:
        """
        A list of Logtail Config Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Logtail Config IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> _builtins.str:
        return pulumi.get(self, "logstore_name")

    @_builtins.property
    @pulumi.getter(name="logtailConfigName")
    def logtail_config_name(self) -> Optional[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "logtail_config_name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Logtail Configs.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> _builtins.int:
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


class AwaitableGetLogtailConfigsResult(GetLogtailConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogtailConfigsResult(
            configs=self.configs,
            id=self.id,
            ids=self.ids,
            logstore_name=self.logstore_name,
            logtail_config_name=self.logtail_config_name,
            name_regex=self.name_regex,
            names=self.names,
            offset=self.offset,
            output_file=self.output_file,
            project_name=self.project_name,
            size=self.size)


def get_logtail_configs(ids: Optional[Sequence[_builtins.str]] = None,
                        logstore_name: Optional[_builtins.str] = None,
                        logtail_config_name: Optional[_builtins.str] = None,
                        name_regex: Optional[_builtins.str] = None,
                        offset: Optional[_builtins.int] = None,
                        output_file: Optional[_builtins.str] = None,
                        project_name: Optional[_builtins.str] = None,
                        size: Optional[_builtins.int] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogtailConfigsResult:
    """
    This data source provides Sls Logtail Config available to the user.[What is Logtail Config](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateConfig)

    > **NOTE:** Available since v1.259.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    default_integer = random.index.Integer("default",
        max=99999,
        min=10000)
    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tfaccsls62147"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "project-for-logtail-terraform"
    defaultu_a28z_s = alicloud.log.Project("defaultuA28zS", project_name=project_name)
    default_logtail_config = alicloud.sls.LogtailConfig("default",
        project_name=defaultu_a28z_s.project_name,
        output_detail={
            "endpoint": "cn-hangzhou-intranet.log.aliyuncs.com",
            "region": "cn-hangzhou",
            "logstore_name": "example",
        },
        output_type="LogService",
        input_detail=json.dumps({
            "adjustTimezone": False,
            "delayAlarmBytes": 0,
            "delaySkipBytes": 0,
            "discardNonUtf8": False,
            "discardUnmatch": True,
            "dockerFile": False,
            "enableRawLog": False,
            "enableTag": False,
            "fileEncoding": "utf8",
            "filePattern": "access*.log",
            "filterKey": ["key1"],
            "filterRegex": ["regex1"],
            "key": [
                "key1",
                "key2",
            ],
            "localStorage": True,
            "logBeginRegex": ".*",
            "logPath": "/var/log/httpd",
            "logTimezone": "",
            "logType": "common_reg_log",
            "maxDepth": 1000,
            "maxSendRate": -1,
            "mergeType": "topic",
            "preserve": True,
            "preserveDepth": 0,
            "priority": 0,
            "regex": "(w+)(s+)",
            "sendRateExpire": 0,
            "sensitive_keys": [],
            "tailExisted": False,
            "timeFormat": "%Y/%m/%d %H:%M:%S",
            "timeKey": "time",
            "topicFormat": "none",
        }),
        logtail_config_name="tfaccsls62147",
        input_type="file")
    default = default_logtail_config.logtail_config_name.apply(lambda logtail_config_name: alicloud.sls.get_logtail_configs_output(logtail_config_name=logtail_config_name,
        logstore_name="example",
        project_name=project_name,
        offset=0,
        size=100))
    pulumi.export("alicloudSlsLogtailConfigExampleId", default.configs[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Logtail Config IDs. The value is formulated as `<project_name>:<logtail_config_name>`.
    :param _builtins.str logstore_name: Logstore name.
    :param _builtins.str logtail_config_name: The name of the resource
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.int offset: Query start row. The default value is 0.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project name
    :param _builtins.int size: The number of rows per page set for a pagination query. The maximum value is 500.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logstoreName'] = logstore_name
    __args__['logtailConfigName'] = logtail_config_name
    __args__['nameRegex'] = name_regex
    __args__['offset'] = offset
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['size'] = size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:sls/getLogtailConfigs:getLogtailConfigs', __args__, opts=opts, typ=GetLogtailConfigsResult).value

    return AwaitableGetLogtailConfigsResult(
        configs=pulumi.get(__ret__, 'configs'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        logstore_name=pulumi.get(__ret__, 'logstore_name'),
        logtail_config_name=pulumi.get(__ret__, 'logtail_config_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        offset=pulumi.get(__ret__, 'offset'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        size=pulumi.get(__ret__, 'size'))
def get_logtail_configs_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                               logtail_config_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               offset: Optional[pulumi.Input[_builtins.int]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               project_name: Optional[pulumi.Input[_builtins.str]] = None,
                               size: Optional[pulumi.Input[_builtins.int]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogtailConfigsResult]:
    """
    This data source provides Sls Logtail Config available to the user.[What is Logtail Config](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateConfig)

    > **NOTE:** Available since v1.259.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    default_integer = random.index.Integer("default",
        max=99999,
        min=10000)
    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tfaccsls62147"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "project-for-logtail-terraform"
    defaultu_a28z_s = alicloud.log.Project("defaultuA28zS", project_name=project_name)
    default_logtail_config = alicloud.sls.LogtailConfig("default",
        project_name=defaultu_a28z_s.project_name,
        output_detail={
            "endpoint": "cn-hangzhou-intranet.log.aliyuncs.com",
            "region": "cn-hangzhou",
            "logstore_name": "example",
        },
        output_type="LogService",
        input_detail=json.dumps({
            "adjustTimezone": False,
            "delayAlarmBytes": 0,
            "delaySkipBytes": 0,
            "discardNonUtf8": False,
            "discardUnmatch": True,
            "dockerFile": False,
            "enableRawLog": False,
            "enableTag": False,
            "fileEncoding": "utf8",
            "filePattern": "access*.log",
            "filterKey": ["key1"],
            "filterRegex": ["regex1"],
            "key": [
                "key1",
                "key2",
            ],
            "localStorage": True,
            "logBeginRegex": ".*",
            "logPath": "/var/log/httpd",
            "logTimezone": "",
            "logType": "common_reg_log",
            "maxDepth": 1000,
            "maxSendRate": -1,
            "mergeType": "topic",
            "preserve": True,
            "preserveDepth": 0,
            "priority": 0,
            "regex": "(w+)(s+)",
            "sendRateExpire": 0,
            "sensitive_keys": [],
            "tailExisted": False,
            "timeFormat": "%Y/%m/%d %H:%M:%S",
            "timeKey": "time",
            "topicFormat": "none",
        }),
        logtail_config_name="tfaccsls62147",
        input_type="file")
    default = default_logtail_config.logtail_config_name.apply(lambda logtail_config_name: alicloud.sls.get_logtail_configs_output(logtail_config_name=logtail_config_name,
        logstore_name="example",
        project_name=project_name,
        offset=0,
        size=100))
    pulumi.export("alicloudSlsLogtailConfigExampleId", default.configs[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Logtail Config IDs. The value is formulated as `<project_name>:<logtail_config_name>`.
    :param _builtins.str logstore_name: Logstore name.
    :param _builtins.str logtail_config_name: The name of the resource
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.int offset: Query start row. The default value is 0.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project name
    :param _builtins.int size: The number of rows per page set for a pagination query. The maximum value is 500.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['logstoreName'] = logstore_name
    __args__['logtailConfigName'] = logtail_config_name
    __args__['nameRegex'] = name_regex
    __args__['offset'] = offset
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['size'] = size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:sls/getLogtailConfigs:getLogtailConfigs', __args__, opts=opts, typ=GetLogtailConfigsResult)
    return __ret__.apply(lambda __response__: GetLogtailConfigsResult(
        configs=pulumi.get(__response__, 'configs'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        logstore_name=pulumi.get(__response__, 'logstore_name'),
        logtail_config_name=pulumi.get(__response__, 'logtail_config_name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        offset=pulumi.get(__response__, 'offset'),
        output_file=pulumi.get(__response__, 'output_file'),
        project_name=pulumi.get(__response__, 'project_name'),
        size=pulumi.get(__response__, 'size')))
