# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMachineGroupsResult',
    'AwaitableGetMachineGroupsResult',
    'get_machine_groups',
    'get_machine_groups_output',
]

@pulumi.output_type
class GetMachineGroupsResult:
    """
    A collection of values returned by getMachineGroups.
    """
    def __init__(__self__, group_name=None, groups=None, id=None, ids=None, output_file=None, project_name=None):
        if group_name and not isinstance(group_name, str):
            raise TypeError("Expected argument 'group_name' to be a str")
        pulumi.set(__self__, "group_name", group_name)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[_builtins.str]:
        """
        Machine Group name
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetMachineGroupsGroupResult']:
        """
        A list of Machine Group Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Machine Group IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        return pulumi.get(self, "project_name")


class AwaitableGetMachineGroupsResult(GetMachineGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMachineGroupsResult(
            group_name=self.group_name,
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            project_name=self.project_name)


def get_machine_groups(group_name: Optional[_builtins.str] = None,
                       ids: Optional[Sequence[_builtins.str]] = None,
                       output_file: Optional[_builtins.str] = None,
                       project_name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMachineGroupsResult:
    """
    This data source provides Sls Machine Group available to the user.[What is Machine Group](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateMachineGroup)

    > **NOTE:** Available since v1.259.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "project-for-machine-group-terraform"
    defaulty_jqrue = alicloud.log.Project("defaultyJqrue",
        description="for terraform example",
        name=project_name)
    default_machine_group = alicloud.sls.MachineGroup("default",
        group_name="group1",
        project_name=project_name,
        machine_identify_type="ip",
        group_attribute={
            "group_topic": "example",
            "external_name": "example",
        },
        machine_lists=["192.168.1.1"])
    default = alicloud.sls.get_machine_groups_output(ids=[default_machine_group.id],
        group_name="group1",
        project_name=project_name)
    pulumi.export("alicloudSlsMachineGroupExampleId", default.groups[0].id)
    ```


    :param _builtins.str group_name: Machine Group name
    :param Sequence[_builtins.str] ids: A list of Machine Group IDs. The value is formulated as `<project_name>:<group_name>`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project name
    """
    __args__ = dict()
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:sls/getMachineGroups:getMachineGroups', __args__, opts=opts, typ=GetMachineGroupsResult).value

    return AwaitableGetMachineGroupsResult(
        group_name=pulumi.get(__ret__, 'group_name'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'))
def get_machine_groups_output(group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              project_name: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMachineGroupsResult]:
    """
    This data source provides Sls Machine Group available to the user.[What is Machine Group](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateMachineGroup)

    > **NOTE:** Available since v1.259.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    project_name = config.get("projectName")
    if project_name is None:
        project_name = "project-for-machine-group-terraform"
    defaulty_jqrue = alicloud.log.Project("defaultyJqrue",
        description="for terraform example",
        name=project_name)
    default_machine_group = alicloud.sls.MachineGroup("default",
        group_name="group1",
        project_name=project_name,
        machine_identify_type="ip",
        group_attribute={
            "group_topic": "example",
            "external_name": "example",
        },
        machine_lists=["192.168.1.1"])
    default = alicloud.sls.get_machine_groups_output(ids=[default_machine_group.id],
        group_name="group1",
        project_name=project_name)
    pulumi.export("alicloudSlsMachineGroupExampleId", default.groups[0].id)
    ```


    :param _builtins.str group_name: Machine Group name
    :param Sequence[_builtins.str] ids: A list of Machine Group IDs. The value is formulated as `<project_name>:<group_name>`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str project_name: Project name
    """
    __args__ = dict()
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:sls/getMachineGroups:getMachineGroups', __args__, opts=opts, typ=GetMachineGroupsResult)
    return __ret__.apply(lambda __response__: GetMachineGroupsResult(
        group_name=pulumi.get(__response__, 'group_name'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        project_name=pulumi.get(__response__, 'project_name')))
