# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogtailConfigArgs', 'LogtailConfig']

@pulumi.input_type
class LogtailConfigArgs:
    def __init__(__self__, *,
                 project_name: pulumi.Input[_builtins.str],
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 input_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 input_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modify_time: Optional[pulumi.Input[_builtins.int]] = None,
                 log_sample: Optional[pulumi.Input[_builtins.str]] = None,
                 logtail_config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_detail: Optional[pulumi.Input['LogtailConfigOutputDetailArgs']] = None,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogtailConfig resource.
        :param pulumi.Input[_builtins.str] project_name: Project name
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] input_detail: The detailed configuration entered by logtail.
        :param pulumi.Input[_builtins.str] input_type: Method of log entry
        :param pulumi.Input[_builtins.int] last_modify_time: Last modification time, unix timestamp
        :param pulumi.Input[_builtins.str] log_sample: Sample log
        :param pulumi.Input[_builtins.str] logtail_config_name: The name of the resource
        :param pulumi.Input['LogtailConfigOutputDetailArgs'] output_detail: Detailed configuration of logtail output See `output_detail` below.
        :param pulumi.Input[_builtins.str] output_type: Log output mode. You can only upload data to log service.
        """
        pulumi.set(__self__, "project_name", project_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if input_detail is not None:
            pulumi.set(__self__, "input_detail", input_detail)
        if input_type is not None:
            pulumi.set(__self__, "input_type", input_type)
        if last_modify_time is not None:
            pulumi.set(__self__, "last_modify_time", last_modify_time)
        if log_sample is not None:
            pulumi.set(__self__, "log_sample", log_sample)
        if logtail_config_name is not None:
            pulumi.set(__self__, "logtail_config_name", logtail_config_name)
        if output_detail is not None:
            pulumi.set(__self__, "output_detail", output_detail)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="inputDetail")
    def input_detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detailed configuration entered by logtail.
        """
        return pulumi.get(self, "input_detail")

    @input_detail.setter
    def input_detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_detail", value)

    @_builtins.property
    @pulumi.getter(name="inputType")
    def input_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Method of log entry
        """
        return pulumi.get(self, "input_type")

    @input_type.setter
    def input_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_type", value)

    @_builtins.property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Last modification time, unix timestamp
        """
        return pulumi.get(self, "last_modify_time")

    @last_modify_time.setter
    def last_modify_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modify_time", value)

    @_builtins.property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sample log
        """
        return pulumi.get(self, "log_sample")

    @log_sample.setter
    def log_sample(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_sample", value)

    @_builtins.property
    @pulumi.getter(name="logtailConfigName")
    def logtail_config_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "logtail_config_name")

    @logtail_config_name.setter
    def logtail_config_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logtail_config_name", value)

    @_builtins.property
    @pulumi.getter(name="outputDetail")
    def output_detail(self) -> Optional[pulumi.Input['LogtailConfigOutputDetailArgs']]:
        """
        Detailed configuration of logtail output See `output_detail` below.
        """
        return pulumi.get(self, "output_detail")

    @output_detail.setter
    def output_detail(self, value: Optional[pulumi.Input['LogtailConfigOutputDetailArgs']]):
        pulumi.set(self, "output_detail", value)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log output mode. You can only upload data to log service.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)


@pulumi.input_type
class _LogtailConfigState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 input_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 input_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modify_time: Optional[pulumi.Input[_builtins.int]] = None,
                 log_sample: Optional[pulumi.Input[_builtins.str]] = None,
                 logtail_config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_detail: Optional[pulumi.Input['LogtailConfigOutputDetailArgs']] = None,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogtailConfig resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] input_detail: The detailed configuration entered by logtail.
        :param pulumi.Input[_builtins.str] input_type: Method of log entry
        :param pulumi.Input[_builtins.int] last_modify_time: Last modification time, unix timestamp
        :param pulumi.Input[_builtins.str] log_sample: Sample log
        :param pulumi.Input[_builtins.str] logtail_config_name: The name of the resource
        :param pulumi.Input['LogtailConfigOutputDetailArgs'] output_detail: Detailed configuration of logtail output See `output_detail` below.
        :param pulumi.Input[_builtins.str] output_type: Log output mode. You can only upload data to log service.
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if input_detail is not None:
            pulumi.set(__self__, "input_detail", input_detail)
        if input_type is not None:
            pulumi.set(__self__, "input_type", input_type)
        if last_modify_time is not None:
            pulumi.set(__self__, "last_modify_time", last_modify_time)
        if log_sample is not None:
            pulumi.set(__self__, "log_sample", log_sample)
        if logtail_config_name is not None:
            pulumi.set(__self__, "logtail_config_name", logtail_config_name)
        if output_detail is not None:
            pulumi.set(__self__, "output_detail", output_detail)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="inputDetail")
    def input_detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detailed configuration entered by logtail.
        """
        return pulumi.get(self, "input_detail")

    @input_detail.setter
    def input_detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_detail", value)

    @_builtins.property
    @pulumi.getter(name="inputType")
    def input_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Method of log entry
        """
        return pulumi.get(self, "input_type")

    @input_type.setter
    def input_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_type", value)

    @_builtins.property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Last modification time, unix timestamp
        """
        return pulumi.get(self, "last_modify_time")

    @last_modify_time.setter
    def last_modify_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modify_time", value)

    @_builtins.property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sample log
        """
        return pulumi.get(self, "log_sample")

    @log_sample.setter
    def log_sample(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_sample", value)

    @_builtins.property
    @pulumi.getter(name="logtailConfigName")
    def logtail_config_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "logtail_config_name")

    @logtail_config_name.setter
    def logtail_config_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logtail_config_name", value)

    @_builtins.property
    @pulumi.getter(name="outputDetail")
    def output_detail(self) -> Optional[pulumi.Input['LogtailConfigOutputDetailArgs']]:
        """
        Detailed configuration of logtail output See `output_detail` below.
        """
        return pulumi.get(self, "output_detail")

    @output_detail.setter
    def output_detail(self, value: Optional[pulumi.Input['LogtailConfigOutputDetailArgs']]):
        pulumi.set(self, "output_detail", value)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log output mode. You can only upload data to log service.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)


@pulumi.type_token("alicloud:sls/logtailConfig:LogtailConfig")
class LogtailConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 input_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 input_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modify_time: Optional[pulumi.Input[_builtins.int]] = None,
                 log_sample: Optional[pulumi.Input[_builtins.str]] = None,
                 logtail_config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_detail: Optional[pulumi.Input[Union['LogtailConfigOutputDetailArgs', 'LogtailConfigOutputDetailArgsDict']]] = None,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Log Service (SLS) Logtail Config resource.

        For information about Log Service (SLS) Logtail Config and how to use it, see [What is Logtail Config](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateConfig).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfaccsls62147"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "project-for-logtail-terraform"
        defaultu_a28z_s = alicloud.log.Project("defaultuA28zS", project_name=project_name)
        default_logtail_config = alicloud.sls.LogtailConfig("default",
            project_name=defaultu_a28z_s.project_name,
            output_detail={
                "endpoint": "cn-hangzhou-intranet.log.aliyuncs.com",
                "region": "cn-hangzhou",
                "logstore_name": "example",
            },
            output_type="LogService",
            input_detail=json.dumps({
                "adjustTimezone": False,
                "delayAlarmBytes": 0,
                "delaySkipBytes": 0,
                "discardNonUtf8": False,
                "discardUnmatch": True,
                "dockerFile": False,
                "enableRawLog": False,
                "enableTag": False,
                "fileEncoding": "utf8",
                "filePattern": "access*.log",
                "filterKey": ["key1"],
                "filterRegex": ["regex1"],
                "key": [
                    "key1",
                    "key2",
                ],
                "localStorage": True,
                "logBeginRegex": ".*",
                "logPath": "/var/log/httpd",
                "logTimezone": "",
                "logType": "common_reg_log",
                "maxDepth": 1000,
                "maxSendRate": -1,
                "mergeType": "topic",
                "preserve": True,
                "preserveDepth": 0,
                "priority": 0,
                "regex": "(w+)(s+)",
                "sendRateExpire": 0,
                "sensitive_keys": [],
                "tailExisted": False,
                "timeFormat": "%Y/%m/%d %H:%M:%S",
                "timeKey": "time",
                "topicFormat": "none",
            }),
            logtail_config_name="tfaccsls62147",
            input_type="file")
        ```

        ## Import

        Log Service (SLS) Logtail Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/logtailConfig:LogtailConfig example <project_name>:<logtail_config_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] input_detail: The detailed configuration entered by logtail.
        :param pulumi.Input[_builtins.str] input_type: Method of log entry
        :param pulumi.Input[_builtins.int] last_modify_time: Last modification time, unix timestamp
        :param pulumi.Input[_builtins.str] log_sample: Sample log
        :param pulumi.Input[_builtins.str] logtail_config_name: The name of the resource
        :param pulumi.Input[Union['LogtailConfigOutputDetailArgs', 'LogtailConfigOutputDetailArgsDict']] output_detail: Detailed configuration of logtail output See `output_detail` below.
        :param pulumi.Input[_builtins.str] output_type: Log output mode. You can only upload data to log service.
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogtailConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Log Service (SLS) Logtail Config resource.

        For information about Log Service (SLS) Logtail Config and how to use it, see [What is Logtail Config](https://next.api.alibabacloud.com/document/Sls/2020-12-30/CreateConfig).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfaccsls62147"
        project_name = config.get("projectName")
        if project_name is None:
            project_name = "project-for-logtail-terraform"
        defaultu_a28z_s = alicloud.log.Project("defaultuA28zS", project_name=project_name)
        default_logtail_config = alicloud.sls.LogtailConfig("default",
            project_name=defaultu_a28z_s.project_name,
            output_detail={
                "endpoint": "cn-hangzhou-intranet.log.aliyuncs.com",
                "region": "cn-hangzhou",
                "logstore_name": "example",
            },
            output_type="LogService",
            input_detail=json.dumps({
                "adjustTimezone": False,
                "delayAlarmBytes": 0,
                "delaySkipBytes": 0,
                "discardNonUtf8": False,
                "discardUnmatch": True,
                "dockerFile": False,
                "enableRawLog": False,
                "enableTag": False,
                "fileEncoding": "utf8",
                "filePattern": "access*.log",
                "filterKey": ["key1"],
                "filterRegex": ["regex1"],
                "key": [
                    "key1",
                    "key2",
                ],
                "localStorage": True,
                "logBeginRegex": ".*",
                "logPath": "/var/log/httpd",
                "logTimezone": "",
                "logType": "common_reg_log",
                "maxDepth": 1000,
                "maxSendRate": -1,
                "mergeType": "topic",
                "preserve": True,
                "preserveDepth": 0,
                "priority": 0,
                "regex": "(w+)(s+)",
                "sendRateExpire": 0,
                "sensitive_keys": [],
                "tailExisted": False,
                "timeFormat": "%Y/%m/%d %H:%M:%S",
                "timeKey": "time",
                "topicFormat": "none",
            }),
            logtail_config_name="tfaccsls62147",
            input_type="file")
        ```

        ## Import

        Log Service (SLS) Logtail Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sls/logtailConfig:LogtailConfig example <project_name>:<logtail_config_name>
        ```

        :param str resource_name: The name of the resource.
        :param LogtailConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogtailConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 input_detail: Optional[pulumi.Input[_builtins.str]] = None,
                 input_type: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modify_time: Optional[pulumi.Input[_builtins.int]] = None,
                 log_sample: Optional[pulumi.Input[_builtins.str]] = None,
                 logtail_config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_detail: Optional[pulumi.Input[Union['LogtailConfigOutputDetailArgs', 'LogtailConfigOutputDetailArgsDict']]] = None,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogtailConfigArgs.__new__(LogtailConfigArgs)

            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["input_detail"] = input_detail
            __props__.__dict__["input_type"] = input_type
            __props__.__dict__["last_modify_time"] = last_modify_time
            __props__.__dict__["log_sample"] = log_sample
            __props__.__dict__["logtail_config_name"] = logtail_config_name
            __props__.__dict__["output_detail"] = output_detail
            __props__.__dict__["output_type"] = output_type
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
        super(LogtailConfig, __self__).__init__(
            'alicloud:sls/logtailConfig:LogtailConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            input_detail: Optional[pulumi.Input[_builtins.str]] = None,
            input_type: Optional[pulumi.Input[_builtins.str]] = None,
            last_modify_time: Optional[pulumi.Input[_builtins.int]] = None,
            log_sample: Optional[pulumi.Input[_builtins.str]] = None,
            logtail_config_name: Optional[pulumi.Input[_builtins.str]] = None,
            output_detail: Optional[pulumi.Input[Union['LogtailConfigOutputDetailArgs', 'LogtailConfigOutputDetailArgsDict']]] = None,
            output_type: Optional[pulumi.Input[_builtins.str]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogtailConfig':
        """
        Get an existing LogtailConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] input_detail: The detailed configuration entered by logtail.
        :param pulumi.Input[_builtins.str] input_type: Method of log entry
        :param pulumi.Input[_builtins.int] last_modify_time: Last modification time, unix timestamp
        :param pulumi.Input[_builtins.str] log_sample: Sample log
        :param pulumi.Input[_builtins.str] logtail_config_name: The name of the resource
        :param pulumi.Input[Union['LogtailConfigOutputDetailArgs', 'LogtailConfigOutputDetailArgsDict']] output_detail: Detailed configuration of logtail output See `output_detail` below.
        :param pulumi.Input[_builtins.str] output_type: Log output mode. You can only upload data to log service.
        :param pulumi.Input[_builtins.str] project_name: Project name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogtailConfigState.__new__(_LogtailConfigState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["input_detail"] = input_detail
        __props__.__dict__["input_type"] = input_type
        __props__.__dict__["last_modify_time"] = last_modify_time
        __props__.__dict__["log_sample"] = log_sample
        __props__.__dict__["logtail_config_name"] = logtail_config_name
        __props__.__dict__["output_detail"] = output_detail
        __props__.__dict__["output_type"] = output_type
        __props__.__dict__["project_name"] = project_name
        return LogtailConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="inputDetail")
    def input_detail(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The detailed configuration entered by logtail.
        """
        return pulumi.get(self, "input_detail")

    @_builtins.property
    @pulumi.getter(name="inputType")
    def input_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Method of log entry
        """
        return pulumi.get(self, "input_type")

    @_builtins.property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> pulumi.Output[_builtins.int]:
        """
        Last modification time, unix timestamp
        """
        return pulumi.get(self, "last_modify_time")

    @_builtins.property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sample log
        """
        return pulumi.get(self, "log_sample")

    @_builtins.property
    @pulumi.getter(name="logtailConfigName")
    def logtail_config_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "logtail_config_name")

    @_builtins.property
    @pulumi.getter(name="outputDetail")
    def output_detail(self) -> pulumi.Output[Optional['outputs.LogtailConfigOutputDetail']]:
        """
        Detailed configuration of logtail output See `output_detail` below.
        """
        return pulumi.get(self, "output_detail")

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Log output mode. You can only upload data to log service.
        """
        return pulumi.get(self, "output_type")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

