# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PcaCertificateArgs', 'PcaCertificate']

@pulumi.input_type
class PcaCertificateArgs:
    def __init__(__self__, *,
                 common_name: pulumi.Input[_builtins.str],
                 locality: pulumi.Input[_builtins.str],
                 organization: pulumi.Input[_builtins.str],
                 organization_unit: pulumi.Input[_builtins.str],
                 state: pulumi.Input[_builtins.str],
                 years: pulumi.Input[_builtins.int],
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PcaCertificate resource.
        :param pulumi.Input[_builtins.str] common_name: The common name or abbreviation of the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] locality: Name of the city where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization: The name of the organization (corresponding to your enterprise or company) associated with the root CA certificate. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization_unit: The name of the department or branch under the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] state: The name of the province, municipality, or autonomous region in which the organization is located. Support the use of Chinese, English characters. 
               Name of the province or state where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.int] years: The validity period of the root CA certificate, in years.
               > **NOTE:**  It is recommended to set to `5` to `10` years.
        :param pulumi.Input[_builtins.str] algorithm: The key algorithm type of the root CA certificate. The key algorithm is expressed using the '_< key length>' format. Value:
               - `RSA_1024`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_2048`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_4096`: The corresponding signature algorithm is Sha256WithRSA.
               - `ECC_256`: The signature algorithm is Sha256WithECDSA.
               - `ECC_384`: The corresponding signature algorithm is Sha256WithECDSA.
               - `ECC_512`: The signature algorithm is Sha256WithECDSA.
               - `SM2_256`: The corresponding signature algorithm is SM3WithSM2.
               The encryption algorithm of the root CA certificate must be the same as the **certificate algorithm** of the private Root CA you purchased. Example: If the **certificate algorithm** selected when you purchase a private Root CA is `RSA`, the key algorithm of the root CA certificate must be **RSA\\_1024**, **RSA\\_2048**, or **RSA\\_4096**.
        :param pulumi.Input[_builtins.str] country_code: The code of the country or region in which the organization is located, using a two-digit capital abbreviation. For example, `CN` represents China and `US` represents the United States.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "organization_unit", organization_unit)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "years", years)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        The common name or abbreviation of the organization. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the city where the organization is located. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the organization (corresponding to your enterprise or company) associated with the root CA certificate. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the department or branch under the organization. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "organization_unit")

    @organization_unit.setter
    def organization_unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_unit", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the province, municipality, or autonomous region in which the organization is located. Support the use of Chinese, English characters. 
        Name of the province or state where the organization is located. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def years(self) -> pulumi.Input[_builtins.int]:
        """
        The validity period of the root CA certificate, in years.
        > **NOTE:**  It is recommended to set to `5` to `10` years.
        """
        return pulumi.get(self, "years")

    @years.setter
    def years(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "years", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key algorithm type of the root CA certificate. The key algorithm is expressed using the '_< key length>' format. Value:
        - `RSA_1024`: The corresponding signature algorithm is Sha256WithRSA.
        - `RSA_2048`: The corresponding signature algorithm is Sha256WithRSA.
        - `RSA_4096`: The corresponding signature algorithm is Sha256WithRSA.
        - `ECC_256`: The signature algorithm is Sha256WithECDSA.
        - `ECC_384`: The corresponding signature algorithm is Sha256WithECDSA.
        - `ECC_512`: The signature algorithm is Sha256WithECDSA.
        - `SM2_256`: The corresponding signature algorithm is SM3WithSM2.
        The encryption algorithm of the root CA certificate must be the same as the **certificate algorithm** of the private Root CA you purchased. Example: If the **certificate algorithm** selected when you purchase a private Root CA is `RSA`, the key algorithm of the root CA certificate must be **RSA\\_1024**, **RSA\\_2048**, or **RSA\\_4096**.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the country or region in which the organization is located, using a two-digit capital abbreviation. For example, `CN` represents China and `US` represents the United States.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)


@pulumi.input_type
class _PcaCertificateState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 years: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PcaCertificate resources.
        :param pulumi.Input[_builtins.str] algorithm: The key algorithm type of the root CA certificate. The key algorithm is expressed using the '_< key length>' format. Value:
               - `RSA_1024`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_2048`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_4096`: The corresponding signature algorithm is Sha256WithRSA.
               - `ECC_256`: The signature algorithm is Sha256WithECDSA.
               - `ECC_384`: The corresponding signature algorithm is Sha256WithECDSA.
               - `ECC_512`: The signature algorithm is Sha256WithECDSA.
               - `SM2_256`: The corresponding signature algorithm is SM3WithSM2.
               The encryption algorithm of the root CA certificate must be the same as the **certificate algorithm** of the private Root CA you purchased. Example: If the **certificate algorithm** selected when you purchase a private Root CA is `RSA`, the key algorithm of the root CA certificate must be **RSA\\_1024**, **RSA\\_2048**, or **RSA\\_4096**.
        :param pulumi.Input[_builtins.str] common_name: The common name or abbreviation of the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] country_code: The code of the country or region in which the organization is located, using a two-digit capital abbreviation. For example, `CN` represents China and `US` represents the United States.
        :param pulumi.Input[_builtins.str] locality: Name of the city where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization: The name of the organization (corresponding to your enterprise or company) associated with the root CA certificate. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization_unit: The name of the department or branch under the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] state: The name of the province, municipality, or autonomous region in which the organization is located. Support the use of Chinese, English characters. 
               Name of the province or state where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] status: The status of the CA certificate.
        :param pulumi.Input[_builtins.int] years: The validity period of the root CA certificate, in years.
               > **NOTE:**  It is recommended to set to `5` to `10` years.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organization_unit is not None:
            pulumi.set(__self__, "organization_unit", organization_unit)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key algorithm type of the root CA certificate. The key algorithm is expressed using the '_< key length>' format. Value:
        - `RSA_1024`: The corresponding signature algorithm is Sha256WithRSA.
        - `RSA_2048`: The corresponding signature algorithm is Sha256WithRSA.
        - `RSA_4096`: The corresponding signature algorithm is Sha256WithRSA.
        - `ECC_256`: The signature algorithm is Sha256WithECDSA.
        - `ECC_384`: The corresponding signature algorithm is Sha256WithECDSA.
        - `ECC_512`: The signature algorithm is Sha256WithECDSA.
        - `SM2_256`: The corresponding signature algorithm is SM3WithSM2.
        The encryption algorithm of the root CA certificate must be the same as the **certificate algorithm** of the private Root CA you purchased. Example: If the **certificate algorithm** selected when you purchase a private Root CA is `RSA`, the key algorithm of the root CA certificate must be **RSA\\_1024**, **RSA\\_2048**, or **RSA\\_4096**.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The common name or abbreviation of the organization. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The code of the country or region in which the organization is located, using a two-digit capital abbreviation. For example, `CN` represents China and `US` represents the United States.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the city where the organization is located. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the organization (corresponding to your enterprise or company) associated with the root CA certificate. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the department or branch under the organization. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "organization_unit")

    @organization_unit.setter
    def organization_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_unit", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the province, municipality, or autonomous region in which the organization is located. Support the use of Chinese, English characters. 
        Name of the province or state where the organization is located. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the CA certificate.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def years(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The validity period of the root CA certificate, in years.
        > **NOTE:**  It is recommended to set to `5` to `10` years.
        """
        return pulumi.get(self, "years")

    @years.setter
    def years(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "years", value)


@pulumi.type_token("alicloud:sslcertificatesservice/pcaCertificate:PcaCertificate")
class PcaCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 years: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a SSL Certificates Pca Certificate resource.

        For information about SSL Certificates Pca Certificate and how to use it, see [What is Pca Certificate](https://next.api.alibabacloud.com/document/cas/2020-06-30/CreateRootCACertificate).

        > **NOTE:** Available since v1.257.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.sslcertificatesservice.PcaCertificate("default",
            organization="a",
            years=1,
            locality="a",
            organization_unit="a",
            state="a",
            country_code="cn",
            common_name="cbc.certqa.cn",
            algorithm="RSA_2048")
        ```

        ## Import

        SSL Certificates Pca Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sslcertificatesservice/pcaCertificate:PcaCertificate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: The key algorithm type of the root CA certificate. The key algorithm is expressed using the '_< key length>' format. Value:
               - `RSA_1024`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_2048`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_4096`: The corresponding signature algorithm is Sha256WithRSA.
               - `ECC_256`: The signature algorithm is Sha256WithECDSA.
               - `ECC_384`: The corresponding signature algorithm is Sha256WithECDSA.
               - `ECC_512`: The signature algorithm is Sha256WithECDSA.
               - `SM2_256`: The corresponding signature algorithm is SM3WithSM2.
               The encryption algorithm of the root CA certificate must be the same as the **certificate algorithm** of the private Root CA you purchased. Example: If the **certificate algorithm** selected when you purchase a private Root CA is `RSA`, the key algorithm of the root CA certificate must be **RSA\\_1024**, **RSA\\_2048**, or **RSA\\_4096**.
        :param pulumi.Input[_builtins.str] common_name: The common name or abbreviation of the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] country_code: The code of the country or region in which the organization is located, using a two-digit capital abbreviation. For example, `CN` represents China and `US` represents the United States.
        :param pulumi.Input[_builtins.str] locality: Name of the city where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization: The name of the organization (corresponding to your enterprise or company) associated with the root CA certificate. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization_unit: The name of the department or branch under the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] state: The name of the province, municipality, or autonomous region in which the organization is located. Support the use of Chinese, English characters. 
               Name of the province or state where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.int] years: The validity period of the root CA certificate, in years.
               > **NOTE:**  It is recommended to set to `5` to `10` years.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PcaCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SSL Certificates Pca Certificate resource.

        For information about SSL Certificates Pca Certificate and how to use it, see [What is Pca Certificate](https://next.api.alibabacloud.com/document/cas/2020-06-30/CreateRootCACertificate).

        > **NOTE:** Available since v1.257.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.sslcertificatesservice.PcaCertificate("default",
            organization="a",
            years=1,
            locality="a",
            organization_unit="a",
            state="a",
            country_code="cn",
            common_name="cbc.certqa.cn",
            algorithm="RSA_2048")
        ```

        ## Import

        SSL Certificates Pca Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:sslcertificatesservice/pcaCertificate:PcaCertificate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PcaCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PcaCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 years: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PcaCertificateArgs.__new__(PcaCertificateArgs)

            __props__.__dict__["algorithm"] = algorithm
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["country_code"] = country_code
            if locality is None and not opts.urn:
                raise TypeError("Missing required property 'locality'")
            __props__.__dict__["locality"] = locality
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if organization_unit is None and not opts.urn:
                raise TypeError("Missing required property 'organization_unit'")
            __props__.__dict__["organization_unit"] = organization_unit
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            if years is None and not opts.urn:
                raise TypeError("Missing required property 'years'")
            __props__.__dict__["years"] = years
            __props__.__dict__["status"] = None
        super(PcaCertificate, __self__).__init__(
            'alicloud:sslcertificatesservice/pcaCertificate:PcaCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            country_code: Optional[pulumi.Input[_builtins.str]] = None,
            locality: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            years: Optional[pulumi.Input[_builtins.int]] = None) -> 'PcaCertificate':
        """
        Get an existing PcaCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: The key algorithm type of the root CA certificate. The key algorithm is expressed using the '_< key length>' format. Value:
               - `RSA_1024`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_2048`: The corresponding signature algorithm is Sha256WithRSA.
               - `RSA_4096`: The corresponding signature algorithm is Sha256WithRSA.
               - `ECC_256`: The signature algorithm is Sha256WithECDSA.
               - `ECC_384`: The corresponding signature algorithm is Sha256WithECDSA.
               - `ECC_512`: The signature algorithm is Sha256WithECDSA.
               - `SM2_256`: The corresponding signature algorithm is SM3WithSM2.
               The encryption algorithm of the root CA certificate must be the same as the **certificate algorithm** of the private Root CA you purchased. Example: If the **certificate algorithm** selected when you purchase a private Root CA is `RSA`, the key algorithm of the root CA certificate must be **RSA\\_1024**, **RSA\\_2048**, or **RSA\\_4096**.
        :param pulumi.Input[_builtins.str] common_name: The common name or abbreviation of the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] country_code: The code of the country or region in which the organization is located, using a two-digit capital abbreviation. For example, `CN` represents China and `US` represents the United States.
        :param pulumi.Input[_builtins.str] locality: Name of the city where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization: The name of the organization (corresponding to your enterprise or company) associated with the root CA certificate. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] organization_unit: The name of the department or branch under the organization. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] state: The name of the province, municipality, or autonomous region in which the organization is located. Support the use of Chinese, English characters. 
               Name of the province or state where the organization is located. Support the use of Chinese, English characters.
        :param pulumi.Input[_builtins.str] status: The status of the CA certificate.
        :param pulumi.Input[_builtins.int] years: The validity period of the root CA certificate, in years.
               > **NOTE:**  It is recommended to set to `5` to `10` years.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PcaCertificateState.__new__(_PcaCertificateState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["country_code"] = country_code
        __props__.__dict__["locality"] = locality
        __props__.__dict__["organization"] = organization
        __props__.__dict__["organization_unit"] = organization_unit
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["years"] = years
        return PcaCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The key algorithm type of the root CA certificate. The key algorithm is expressed using the '_< key length>' format. Value:
        - `RSA_1024`: The corresponding signature algorithm is Sha256WithRSA.
        - `RSA_2048`: The corresponding signature algorithm is Sha256WithRSA.
        - `RSA_4096`: The corresponding signature algorithm is Sha256WithRSA.
        - `ECC_256`: The signature algorithm is Sha256WithECDSA.
        - `ECC_384`: The corresponding signature algorithm is Sha256WithECDSA.
        - `ECC_512`: The signature algorithm is Sha256WithECDSA.
        - `SM2_256`: The corresponding signature algorithm is SM3WithSM2.
        The encryption algorithm of the root CA certificate must be the same as the **certificate algorithm** of the private Root CA you purchased. Example: If the **certificate algorithm** selected when you purchase a private Root CA is `RSA`, the key algorithm of the root CA certificate must be **RSA\\_1024**, **RSA\\_2048**, or **RSA\\_4096**.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        The common name or abbreviation of the organization. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The code of the country or region in which the organization is located, using a two-digit capital abbreviation. For example, `CN` represents China and `US` represents the United States.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the city where the organization is located. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the organization (corresponding to your enterprise or company) associated with the root CA certificate. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the department or branch under the organization. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "organization_unit")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the province, municipality, or autonomous region in which the organization is located. Support the use of Chinese, English characters. 
        Name of the province or state where the organization is located. Support the use of Chinese, English characters.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the CA certificate.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def years(self) -> pulumi.Output[_builtins.int]:
        """
        The validity period of the root CA certificate, in years.
        > **NOTE:**  It is recommended to set to `5` to `10` years.
        """
        return pulumi.get(self, "years")

