# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CycleTaskArgs', 'CycleTask']

@pulumi.input_type
class CycleTaskArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[_builtins.int],
                 first_date_str: pulumi.Input[_builtins.int],
                 interval_period: pulumi.Input[_builtins.int],
                 period_unit: pulumi.Input[_builtins.str],
                 target_end_time: pulumi.Input[_builtins.int],
                 target_start_time: pulumi.Input[_builtins.int],
                 task_name: pulumi.Input[_builtins.str],
                 task_type: pulumi.Input[_builtins.str],
                 param: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CycleTask resource.
        :param pulumi.Input[_builtins.int] enable: Whether to enable. Value:
        :param pulumi.Input[_builtins.int] first_date_str: First execution time.
        :param pulumi.Input[_builtins.int] interval_period: Interval period.
        :param pulumi.Input[_builtins.str] period_unit: Unit of scan cycle, value:
        :param pulumi.Input[_builtins.int] target_end_time: Task end time (hours).
        :param pulumi.Input[_builtins.int] target_start_time: Task start time (hours).
        :param pulumi.Input[_builtins.str] task_name: The task name.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        :param pulumi.Input[_builtins.str] task_type: The task type.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        :param pulumi.Input[_builtins.str] param: Extended information field.
        :param pulumi.Input[_builtins.str] source: Added the source of the task.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "first_date_str", first_date_str)
        pulumi.set(__self__, "interval_period", interval_period)
        pulumi.set(__self__, "period_unit", period_unit)
        pulumi.set(__self__, "target_end_time", target_end_time)
        pulumi.set(__self__, "target_start_time", target_start_time)
        pulumi.set(__self__, "task_name", task_name)
        pulumi.set(__self__, "task_type", task_type)
        if param is not None:
            pulumi.set(__self__, "param", param)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Input[_builtins.int]:
        """
        Whether to enable. Value:
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="firstDateStr")
    def first_date_str(self) -> pulumi.Input[_builtins.int]:
        """
        First execution time.
        """
        return pulumi.get(self, "first_date_str")

    @first_date_str.setter
    def first_date_str(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "first_date_str", value)

    @_builtins.property
    @pulumi.getter(name="intervalPeriod")
    def interval_period(self) -> pulumi.Input[_builtins.int]:
        """
        Interval period.
        """
        return pulumi.get(self, "interval_period")

    @interval_period.setter
    def interval_period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "interval_period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Input[_builtins.str]:
        """
        Unit of scan cycle, value:
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="targetEndTime")
    def target_end_time(self) -> pulumi.Input[_builtins.int]:
        """
        Task end time (hours).
        """
        return pulumi.get(self, "target_end_time")

    @target_end_time.setter
    def target_end_time(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "target_end_time", value)

    @_builtins.property
    @pulumi.getter(name="targetStartTime")
    def target_start_time(self) -> pulumi.Input[_builtins.int]:
        """
        Task start time (hours).
        """
        return pulumi.get(self, "target_start_time")

    @target_start_time.setter
    def target_start_time(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "target_start_time", value)

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> pulumi.Input[_builtins.str]:
        """
        The task name.
        - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
        - **IMAGE_SCAN**: Image scan.
        - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        return pulumi.get(self, "task_name")

    @task_name.setter
    def task_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_name", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[_builtins.str]:
        """
        The task type.
        - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
        - **IMAGE_SCAN**: Image scan.
        - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter
    def param(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Extended information field.
        """
        return pulumi.get(self, "param")

    @param.setter
    def param(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Added the source of the task.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _CycleTaskState:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[_builtins.int]] = None,
                 first_date_str: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_period: Optional[pulumi.Input[_builtins.int]] = None,
                 param: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 target_end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 target_start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CycleTask resources.
        :param pulumi.Input[_builtins.int] enable: Whether to enable. Value:
        :param pulumi.Input[_builtins.int] first_date_str: First execution time.
        :param pulumi.Input[_builtins.int] interval_period: Interval period.
        :param pulumi.Input[_builtins.str] param: Extended information field.
        :param pulumi.Input[_builtins.str] period_unit: Unit of scan cycle, value:
        :param pulumi.Input[_builtins.str] source: Added the source of the task.
        :param pulumi.Input[_builtins.int] target_end_time: Task end time (hours).
        :param pulumi.Input[_builtins.int] target_start_time: Task start time (hours).
        :param pulumi.Input[_builtins.str] task_name: The task name.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        :param pulumi.Input[_builtins.str] task_type: The task type.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if first_date_str is not None:
            pulumi.set(__self__, "first_date_str", first_date_str)
        if interval_period is not None:
            pulumi.set(__self__, "interval_period", interval_period)
        if param is not None:
            pulumi.set(__self__, "param", param)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target_end_time is not None:
            pulumi.set(__self__, "target_end_time", target_end_time)
        if target_start_time is not None:
            pulumi.set(__self__, "target_start_time", target_start_time)
        if task_name is not None:
            pulumi.set(__self__, "task_name", task_name)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether to enable. Value:
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="firstDateStr")
    def first_date_str(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        First execution time.
        """
        return pulumi.get(self, "first_date_str")

    @first_date_str.setter
    def first_date_str(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "first_date_str", value)

    @_builtins.property
    @pulumi.getter(name="intervalPeriod")
    def interval_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval period.
        """
        return pulumi.get(self, "interval_period")

    @interval_period.setter
    def interval_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_period", value)

    @_builtins.property
    @pulumi.getter
    def param(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Extended information field.
        """
        return pulumi.get(self, "param")

    @param.setter
    def param(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unit of scan cycle, value:
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Added the source of the task.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="targetEndTime")
    def target_end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Task end time (hours).
        """
        return pulumi.get(self, "target_end_time")

    @target_end_time.setter
    def target_end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_end_time", value)

    @_builtins.property
    @pulumi.getter(name="targetStartTime")
    def target_start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Task start time (hours).
        """
        return pulumi.get(self, "target_start_time")

    @target_start_time.setter
    def target_start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_start_time", value)

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The task name.
        - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
        - **IMAGE_SCAN**: Image scan.
        - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        return pulumi.get(self, "task_name")

    @task_name.setter
    def task_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_name", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The task type.
        - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
        - **IMAGE_SCAN**: Image scan.
        - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_type", value)


@pulumi.type_token("alicloud:threatdetection/cycleTask:CycleTask")
class CycleTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable: Optional[pulumi.Input[_builtins.int]] = None,
                 first_date_str: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_period: Optional[pulumi.Input[_builtins.int]] = None,
                 param: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 target_end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 target_start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Threat Detection Cycle Task resource.

        Configure periodic tasks in Security Center.

        For information about Threat Detection Cycle Task and how to use it, see [What is Cycle Task](https://next.api.alibabacloud.com/document/Sas/2018-12-03/CreateCycleTask).

        > **NOTE:** Available since v1.253.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.CycleTask("default",
            target_end_time=6,
            task_type="VIRUS_VUL_SCHEDULE_SCAN",
            target_start_time=0,
            source="console_batch",
            task_name="VIRUS_VUL_SCHEDULE_SCAN",
            first_date_str=1650556800000,
            period_unit="day",
            interval_period=7,
            param=json.dumps({
                "targetInfo": [
                    {
                        "type": "groupId",
                        "name": "TI HOST",
                        "target": 10597,
                    },
                    {
                        "type": "groupId",
                        "name": "expense HOST",
                        "target": 10597,
                    },
                ],
            }),
            enable=1)
        ```

        ## Import

        Threat Detection Cycle Task can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/cycleTask:CycleTask example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] enable: Whether to enable. Value:
        :param pulumi.Input[_builtins.int] first_date_str: First execution time.
        :param pulumi.Input[_builtins.int] interval_period: Interval period.
        :param pulumi.Input[_builtins.str] param: Extended information field.
        :param pulumi.Input[_builtins.str] period_unit: Unit of scan cycle, value:
        :param pulumi.Input[_builtins.str] source: Added the source of the task.
        :param pulumi.Input[_builtins.int] target_end_time: Task end time (hours).
        :param pulumi.Input[_builtins.int] target_start_time: Task start time (hours).
        :param pulumi.Input[_builtins.str] task_name: The task name.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        :param pulumi.Input[_builtins.str] task_type: The task type.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CycleTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Threat Detection Cycle Task resource.

        Configure periodic tasks in Security Center.

        For information about Threat Detection Cycle Task and how to use it, see [What is Cycle Task](https://next.api.alibabacloud.com/document/Sas/2018-12-03/CreateCycleTask).

        > **NOTE:** Available since v1.253.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.CycleTask("default",
            target_end_time=6,
            task_type="VIRUS_VUL_SCHEDULE_SCAN",
            target_start_time=0,
            source="console_batch",
            task_name="VIRUS_VUL_SCHEDULE_SCAN",
            first_date_str=1650556800000,
            period_unit="day",
            interval_period=7,
            param=json.dumps({
                "targetInfo": [
                    {
                        "type": "groupId",
                        "name": "TI HOST",
                        "target": 10597,
                    },
                    {
                        "type": "groupId",
                        "name": "expense HOST",
                        "target": 10597,
                    },
                ],
            }),
            enable=1)
        ```

        ## Import

        Threat Detection Cycle Task can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/cycleTask:CycleTask example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CycleTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CycleTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable: Optional[pulumi.Input[_builtins.int]] = None,
                 first_date_str: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_period: Optional[pulumi.Input[_builtins.int]] = None,
                 param: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 target_end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 target_start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CycleTaskArgs.__new__(CycleTaskArgs)

            if enable is None and not opts.urn:
                raise TypeError("Missing required property 'enable'")
            __props__.__dict__["enable"] = enable
            if first_date_str is None and not opts.urn:
                raise TypeError("Missing required property 'first_date_str'")
            __props__.__dict__["first_date_str"] = first_date_str
            if interval_period is None and not opts.urn:
                raise TypeError("Missing required property 'interval_period'")
            __props__.__dict__["interval_period"] = interval_period
            __props__.__dict__["param"] = param
            if period_unit is None and not opts.urn:
                raise TypeError("Missing required property 'period_unit'")
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["source"] = source
            if target_end_time is None and not opts.urn:
                raise TypeError("Missing required property 'target_end_time'")
            __props__.__dict__["target_end_time"] = target_end_time
            if target_start_time is None and not opts.urn:
                raise TypeError("Missing required property 'target_start_time'")
            __props__.__dict__["target_start_time"] = target_start_time
            if task_name is None and not opts.urn:
                raise TypeError("Missing required property 'task_name'")
            __props__.__dict__["task_name"] = task_name
            if task_type is None and not opts.urn:
                raise TypeError("Missing required property 'task_type'")
            __props__.__dict__["task_type"] = task_type
        super(CycleTask, __self__).__init__(
            'alicloud:threatdetection/cycleTask:CycleTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable: Optional[pulumi.Input[_builtins.int]] = None,
            first_date_str: Optional[pulumi.Input[_builtins.int]] = None,
            interval_period: Optional[pulumi.Input[_builtins.int]] = None,
            param: Optional[pulumi.Input[_builtins.str]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            target_end_time: Optional[pulumi.Input[_builtins.int]] = None,
            target_start_time: Optional[pulumi.Input[_builtins.int]] = None,
            task_name: Optional[pulumi.Input[_builtins.str]] = None,
            task_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'CycleTask':
        """
        Get an existing CycleTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] enable: Whether to enable. Value:
        :param pulumi.Input[_builtins.int] first_date_str: First execution time.
        :param pulumi.Input[_builtins.int] interval_period: Interval period.
        :param pulumi.Input[_builtins.str] param: Extended information field.
        :param pulumi.Input[_builtins.str] period_unit: Unit of scan cycle, value:
        :param pulumi.Input[_builtins.str] source: Added the source of the task.
        :param pulumi.Input[_builtins.int] target_end_time: Task end time (hours).
        :param pulumi.Input[_builtins.int] target_start_time: Task start time (hours).
        :param pulumi.Input[_builtins.str] task_name: The task name.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        :param pulumi.Input[_builtins.str] task_type: The task type.
               - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
               - **IMAGE_SCAN**: Image scan.
               - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CycleTaskState.__new__(_CycleTaskState)

        __props__.__dict__["enable"] = enable
        __props__.__dict__["first_date_str"] = first_date_str
        __props__.__dict__["interval_period"] = interval_period
        __props__.__dict__["param"] = param
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["source"] = source
        __props__.__dict__["target_end_time"] = target_end_time
        __props__.__dict__["target_start_time"] = target_start_time
        __props__.__dict__["task_name"] = task_name
        __props__.__dict__["task_type"] = task_type
        return CycleTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[_builtins.int]:
        """
        Whether to enable. Value:
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="firstDateStr")
    def first_date_str(self) -> pulumi.Output[_builtins.int]:
        """
        First execution time.
        """
        return pulumi.get(self, "first_date_str")

    @_builtins.property
    @pulumi.getter(name="intervalPeriod")
    def interval_period(self) -> pulumi.Output[_builtins.int]:
        """
        Interval period.
        """
        return pulumi.get(self, "interval_period")

    @_builtins.property
    @pulumi.getter
    def param(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Extended information field.
        """
        return pulumi.get(self, "param")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[_builtins.str]:
        """
        Unit of scan cycle, value:
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Added the source of the task.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="targetEndTime")
    def target_end_time(self) -> pulumi.Output[_builtins.int]:
        """
        Task end time (hours).
        """
        return pulumi.get(self, "target_end_time")

    @_builtins.property
    @pulumi.getter(name="targetStartTime")
    def target_start_time(self) -> pulumi.Output[_builtins.int]:
        """
        Task start time (hours).
        """
        return pulumi.get(self, "target_start_time")

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> pulumi.Output[_builtins.str]:
        """
        The task name.
        - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
        - **IMAGE_SCAN**: Image scan.
        - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        return pulumi.get(self, "task_name")

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Output[_builtins.str]:
        """
        The task type.
        - **VIRUS_VUL_SCHEDULE_SCAN**: scans for viruses.
        - **IMAGE_SCAN**: Image scan.
        - **EMG_VUL_SCHEDULE_SCAN**: Emergency vulnerability scanning.
        """
        return pulumi.get(self, "task_type")

