# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAntiBruteForceRulesResult',
    'AwaitableGetAntiBruteForceRulesResult',
    'get_anti_brute_force_rules',
    'get_anti_brute_force_rules_output',
]

@pulumi.output_type
class GetAntiBruteForceRulesResult:
    """
    A collection of values returned by getAntiBruteForceRules.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, names=None, output_file=None, rules=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Anti Brute Force Rule IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Anti Brute Force Rules.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAntiBruteForceRulesRuleResult']:
        """
        A list of Anti Brute Force Rule Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "rules")


class AwaitableGetAntiBruteForceRulesResult(GetAntiBruteForceRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAntiBruteForceRulesResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            rules=self.rules)


def get_anti_brute_force_rules(ids: Optional[Sequence[_builtins.str]] = None,
                               name_regex: Optional[_builtins.str] = None,
                               output_file: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAntiBruteForceRulesResult:
    """
    This data source provides Threat Detection Anti Brute Force Rule available to the user.[What is Anti Brute Force Rule](https://www.alibabacloud.com/help/en/security-center/latest/api-sas-2018-12-03-createantibruteforcerule)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "example_value"
    default_anti_brute_force_rule = alicloud.threatdetection.AntiBruteForceRule("default",
        anti_brute_force_rule_name=name,
        forbidden_time=360,
        uuid_lists=["7567806c-4ec5-4597-9543-7c9543381a13"],
        fail_count=80,
        span=10)
    default = default_anti_brute_force_rule.id.apply(lambda id: alicloud.threatdetection.get_anti_brute_force_rules_output(ids=[id],
        name_regex=default_anti_brute_force_rule.name))
    pulumi.export("alicloudThreatDetectionAntiBruteForceRuleExampleId", default.rules[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Anti-Brute Force Rule IDs.
    :param _builtins.str name_regex: A regex string to filter results by the name of the defense rule.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:threatdetection/getAntiBruteForceRules:getAntiBruteForceRules', __args__, opts=opts, typ=GetAntiBruteForceRulesResult).value

    return AwaitableGetAntiBruteForceRulesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rules=pulumi.get(__ret__, 'rules'))
def get_anti_brute_force_rules_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                      name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAntiBruteForceRulesResult]:
    """
    This data source provides Threat Detection Anti Brute Force Rule available to the user.[What is Anti Brute Force Rule](https://www.alibabacloud.com/help/en/security-center/latest/api-sas-2018-12-03-createantibruteforcerule)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "example_value"
    default_anti_brute_force_rule = alicloud.threatdetection.AntiBruteForceRule("default",
        anti_brute_force_rule_name=name,
        forbidden_time=360,
        uuid_lists=["7567806c-4ec5-4597-9543-7c9543381a13"],
        fail_count=80,
        span=10)
    default = default_anti_brute_force_rule.id.apply(lambda id: alicloud.threatdetection.get_anti_brute_force_rules_output(ids=[id],
        name_regex=default_anti_brute_force_rule.name))
    pulumi.export("alicloudThreatDetectionAntiBruteForceRuleExampleId", default.rules[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Anti-Brute Force Rule IDs.
    :param _builtins.str name_regex: A regex string to filter results by the name of the defense rule.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:threatdetection/getAntiBruteForceRules:getAntiBruteForceRules', __args__, opts=opts, typ=GetAntiBruteForceRulesResult)
    return __ret__.apply(lambda __response__: GetAntiBruteForceRulesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        rules=pulumi.get(__response__, 'rules')))
