# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAssetsResult',
    'AwaitableGetAssetsResult',
    'get_assets',
    'get_assets_output',
]

@pulumi.output_type
class GetAssetsResult:
    """
    A collection of values returned by getAssets.
    """
    def __init__(__self__, assets=None, criteria=None, id=None, ids=None, importance=None, logical_exp=None, machine_types=None, no_group_trace=None, output_file=None, page_number=None, page_size=None):
        if assets and not isinstance(assets, list):
            raise TypeError("Expected argument 'assets' to be a list")
        pulumi.set(__self__, "assets", assets)
        if criteria and not isinstance(criteria, str):
            raise TypeError("Expected argument 'criteria' to be a str")
        pulumi.set(__self__, "criteria", criteria)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if importance and not isinstance(importance, int):
            raise TypeError("Expected argument 'importance' to be a int")
        pulumi.set(__self__, "importance", importance)
        if logical_exp and not isinstance(logical_exp, str):
            raise TypeError("Expected argument 'logical_exp' to be a str")
        pulumi.set(__self__, "logical_exp", logical_exp)
        if machine_types and not isinstance(machine_types, str):
            raise TypeError("Expected argument 'machine_types' to be a str")
        pulumi.set(__self__, "machine_types", machine_types)
        if no_group_trace and not isinstance(no_group_trace, bool):
            raise TypeError("Expected argument 'no_group_trace' to be a bool")
        pulumi.set(__self__, "no_group_trace", no_group_trace)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Sequence['outputs.GetAssetsAssetResult']:
        """
        A list of Asset Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "assets")

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Asset IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def importance(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "importance")

    @_builtins.property
    @pulumi.getter(name="logicalExp")
    def logical_exp(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "logical_exp")

    @_builtins.property
    @pulumi.getter(name="machineTypes")
    def machine_types(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "machine_types")

    @_builtins.property
    @pulumi.getter(name="noGroupTrace")
    def no_group_trace(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "no_group_trace")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")


class AwaitableGetAssetsResult(GetAssetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssetsResult(
            assets=self.assets,
            criteria=self.criteria,
            id=self.id,
            ids=self.ids,
            importance=self.importance,
            logical_exp=self.logical_exp,
            machine_types=self.machine_types,
            no_group_trace=self.no_group_trace,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size)


def get_assets(criteria: Optional[_builtins.str] = None,
               ids: Optional[Sequence[_builtins.str]] = None,
               importance: Optional[_builtins.int] = None,
               logical_exp: Optional[_builtins.str] = None,
               machine_types: Optional[_builtins.str] = None,
               no_group_trace: Optional[_builtins.bool] = None,
               output_file: Optional[_builtins.str] = None,
               page_number: Optional[_builtins.int] = None,
               page_size: Optional[_builtins.int] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssetsResult:
    """
    This data source provides Threat Detection Asset available to the user.[What is Asset](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describecloudcenterinstances)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.threatdetection.get_assets()
    pulumi.export("alicloudThreatDetectionAssetExampleId", default.assets[0].id)
    ```


    :param _builtins.str criteria: Set the conditions for searching assets. This parameter is in JSON format. Note the case when you enter the parameter. **NOTE:** You can search for assets by using conditions such as the instance ID, instance name, VPC ID, region, and public IP address of the asset.
    :param Sequence[_builtins.str] ids: A list of Asset IDs.
    :param _builtins.int importance: Set asset importance. Value:
           - **2**: Significant assets
           - **1**: General assets
           - **0**: Test asset
    :param _builtins.str logical_exp: Set the logical relationship between multiple search conditions. The default value is **OR**. Valid values:
           - **OR**: indicates that the relationship between multiple search conditions is **OR**.
           - **AND**: indicates that the relationship between multiple search conditions is **AND**.
    :param _builtins.str machine_types: The type of asset to query. Value:
           - **ecs**: server.
           - **cloud_product**: Cloud product.
    :param _builtins.bool no_group_trace: Specifies whether to internationalize the name of the default group. Default value: false
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['criteria'] = criteria
    __args__['ids'] = ids
    __args__['importance'] = importance
    __args__['logicalExp'] = logical_exp
    __args__['machineTypes'] = machine_types
    __args__['noGroupTrace'] = no_group_trace
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:threatdetection/getAssets:getAssets', __args__, opts=opts, typ=GetAssetsResult).value

    return AwaitableGetAssetsResult(
        assets=pulumi.get(__ret__, 'assets'),
        criteria=pulumi.get(__ret__, 'criteria'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        importance=pulumi.get(__ret__, 'importance'),
        logical_exp=pulumi.get(__ret__, 'logical_exp'),
        machine_types=pulumi.get(__ret__, 'machine_types'),
        no_group_trace=pulumi.get(__ret__, 'no_group_trace'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'))
def get_assets_output(criteria: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      importance: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      logical_exp: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      machine_types: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      no_group_trace: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAssetsResult]:
    """
    This data source provides Threat Detection Asset available to the user.[What is Asset](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describecloudcenterinstances)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.threatdetection.get_assets()
    pulumi.export("alicloudThreatDetectionAssetExampleId", default.assets[0].id)
    ```


    :param _builtins.str criteria: Set the conditions for searching assets. This parameter is in JSON format. Note the case when you enter the parameter. **NOTE:** You can search for assets by using conditions such as the instance ID, instance name, VPC ID, region, and public IP address of the asset.
    :param Sequence[_builtins.str] ids: A list of Asset IDs.
    :param _builtins.int importance: Set asset importance. Value:
           - **2**: Significant assets
           - **1**: General assets
           - **0**: Test asset
    :param _builtins.str logical_exp: Set the logical relationship between multiple search conditions. The default value is **OR**. Valid values:
           - **OR**: indicates that the relationship between multiple search conditions is **OR**.
           - **AND**: indicates that the relationship between multiple search conditions is **AND**.
    :param _builtins.str machine_types: The type of asset to query. Value:
           - **ecs**: server.
           - **cloud_product**: Cloud product.
    :param _builtins.bool no_group_trace: Specifies whether to internationalize the name of the default group. Default value: false
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['criteria'] = criteria
    __args__['ids'] = ids
    __args__['importance'] = importance
    __args__['logicalExp'] = logical_exp
    __args__['machineTypes'] = machine_types
    __args__['noGroupTrace'] = no_group_trace
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:threatdetection/getAssets:getAssets', __args__, opts=opts, typ=GetAssetsResult)
    return __ret__.apply(lambda __response__: GetAssetsResult(
        assets=pulumi.get(__response__, 'assets'),
        criteria=pulumi.get(__response__, 'criteria'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        importance=pulumi.get(__response__, 'importance'),
        logical_exp=pulumi.get(__response__, 'logical_exp'),
        machine_types=pulumi.get(__response__, 'machine_types'),
        no_group_trace=pulumi.get(__response__, 'no_group_trace'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size')))
