# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[_builtins.str],
                 buy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 post_paid_flag: Optional[pulumi.Input[_builtins.int]] = None,
                 post_pay_module_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 rasp_count: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sc: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_sdk: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch1: Optional[pulumi.Input[_builtins.str]] = None,
                 v_core: Optional[pulumi.Input[_builtins.str]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_count: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_switch: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] buy_number: Number of servers.
        :param pulumi.Input[_builtins.str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[_builtins.str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[_builtins.str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.int] post_paid_flag: Post-paid signage. Value:
        :param pulumi.Input[_builtins.str] post_pay_module_switch: Pay-as-you-go module switch mapping, in JsonString format. Valid values:
               - Key:
               - `VUL`: vulnerability repair module
               - `CSPM`: Cloud platform configuration check module
               - `AGENTLESS`: AGENTLESS detection module
               - `SERVERLESS`:Serverless asset module
               - `CTDR`: threat analysis and response module
               - `POST_HOST`: Host and container security module
               - Value:0 means off, 1 means on
               
               > **NOTE:**  The module value of the unpassed value will not change.
        :param pulumi.Input[_builtins.str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[15000,9999999999].
               
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 55000, that is, only multiples of 55000 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[_builtins.str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[_builtins.str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               1: Yes.
        :param pulumi.Input[_builtins.str] subscription_type: The subscription type. Value:
               - Subscription: Prepaid.
               - PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_flow: Threat analysis and response log access traffic. After ThreatAnalysisSwitch1 is selected, it must be selected. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  Step size is 100.
        :param pulumi.Input[_builtins.str] threat_analysis_sls_storage: Threat analysis and response log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 1000, that is, only multiples of 1000 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] threat_analysis_switch1: Threat analysis and response switch (new), values:
               - 0: No
               - 1: Yes
        :param pulumi.Input[_builtins.str] v_core: Number of cores.
        :param pulumi.Input[_builtins.str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[_builtins.str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[_builtins.str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        pulumi.set(__self__, "payment_type", payment_type)
        if buy_number is not None:
            pulumi.set(__self__, "buy_number", buy_number)
        if container_image_scan is not None:
            warnings.warn("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""", DeprecationWarning)
            pulumi.log.warn("""container_image_scan is deprecated: Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")
        if container_image_scan is not None:
            pulumi.set(__self__, "container_image_scan", container_image_scan)
        if container_image_scan_new is not None:
            pulumi.set(__self__, "container_image_scan_new", container_image_scan_new)
        if honeypot is not None:
            pulumi.set(__self__, "honeypot", honeypot)
        if honeypot_switch is not None:
            pulumi.set(__self__, "honeypot_switch", honeypot_switch)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if post_paid_flag is not None:
            pulumi.set(__self__, "post_paid_flag", post_paid_flag)
        if post_pay_module_switch is not None:
            pulumi.set(__self__, "post_pay_module_switch", post_pay_module_switch)
        if rasp_count is not None:
            pulumi.set(__self__, "rasp_count", rasp_count)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_period_unit is not None:
            pulumi.set(__self__, "renewal_period_unit", renewal_period_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if sas_anti_ransomware is not None:
            pulumi.set(__self__, "sas_anti_ransomware", sas_anti_ransomware)
        if sas_cspm is not None:
            pulumi.set(__self__, "sas_cspm", sas_cspm)
        if sas_cspm_switch is not None:
            pulumi.set(__self__, "sas_cspm_switch", sas_cspm_switch)
        if sas_sc is not None:
            pulumi.set(__self__, "sas_sc", sas_sc)
        if sas_sdk is not None:
            pulumi.set(__self__, "sas_sdk", sas_sdk)
        if sas_sdk_switch is not None:
            pulumi.set(__self__, "sas_sdk_switch", sas_sdk_switch)
        if sas_sls_storage is not None:
            pulumi.set(__self__, "sas_sls_storage", sas_sls_storage)
        if sas_webguard_boolean is not None:
            pulumi.set(__self__, "sas_webguard_boolean", sas_webguard_boolean)
        if sas_webguard_order_num is not None:
            pulumi.set(__self__, "sas_webguard_order_num", sas_webguard_order_num)
        if subscription_type is not None:
            pulumi.set(__self__, "subscription_type", subscription_type)
        if threat_analysis is not None:
            pulumi.set(__self__, "threat_analysis", threat_analysis)
        if threat_analysis_flow is not None:
            pulumi.set(__self__, "threat_analysis_flow", threat_analysis_flow)
        if threat_analysis_sls_storage is not None:
            pulumi.set(__self__, "threat_analysis_sls_storage", threat_analysis_sls_storage)
        if threat_analysis_switch is not None:
            pulumi.set(__self__, "threat_analysis_switch", threat_analysis_switch)
        if threat_analysis_switch1 is not None:
            pulumi.set(__self__, "threat_analysis_switch1", threat_analysis_switch1)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version_code is not None:
            pulumi.set(__self__, "version_code", version_code)
        if vul_count is not None:
            pulumi.set(__self__, "vul_count", vul_count)
        if vul_switch is not None:
            pulumi.set(__self__, "vul_switch", vul_switch)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="buyNumber")
    def buy_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of servers.
        """
        return pulumi.get(self, "buy_number")

    @buy_number.setter
    def buy_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "buy_number", value)

    @_builtins.property
    @pulumi.getter(name="containerImageScan")
    @_utilities.deprecated("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")
    def container_image_scan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].

        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan")

    @container_image_scan.setter
    def container_image_scan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_image_scan", value)

    @_builtins.property
    @pulumi.getter(name="containerImageScanNew")
    def container_image_scan_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].

        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan_new")

    @container_image_scan_new.setter
    def container_image_scan_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_image_scan_new", value)

    @_builtins.property
    @pulumi.getter
    def honeypot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of cloud honeypot licenses. Interval type, value interval:[20,500].

        > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        """
        return pulumi.get(self, "honeypot")

    @honeypot.setter
    def honeypot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honeypot", value)

    @_builtins.property
    @pulumi.getter(name="honeypotSwitch")
    def honeypot_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud honeypot. Value:
        - 1: Yes.
        - 2: No.
        """
        return pulumi.get(self, "honeypot_switch")

    @honeypot_switch.setter
    def honeypot_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honeypot_switch", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Change configuration type, value
        - Upgrade: Upgrade.
        - Downgrade: Downgrade.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.

        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="postPaidFlag")
    def post_paid_flag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Post-paid signage. Value:
        """
        return pulumi.get(self, "post_paid_flag")

    @post_paid_flag.setter
    def post_paid_flag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "post_paid_flag", value)

    @_builtins.property
    @pulumi.getter(name="postPayModuleSwitch")
    def post_pay_module_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pay-as-you-go module switch mapping, in JsonString format. Valid values:
        - Key:
        - `VUL`: vulnerability repair module
        - `CSPM`: Cloud platform configuration check module
        - `AGENTLESS`: AGENTLESS detection module
        - `SERVERLESS`:Serverless asset module
        - `CTDR`: threat analysis and response module
        - `POST_HOST`: Host and container security module
        - Value:0 means off, 1 means on

        > **NOTE:**  The module value of the unpassed value will not change.
        """
        return pulumi.get(self, "post_pay_module_switch")

    @post_pay_module_switch.setter
    def post_pay_module_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_pay_module_switch", value)

    @_builtins.property
    @pulumi.getter(name="raspCount")
    def rasp_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of application protection licenses. Interval type, value interval:[1,100000000].
        """
        return pulumi.get(self, "rasp_count")

    @rasp_count.setter
    def rasp_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rasp_count", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal cycle, in months.

        > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal period unit, value:
        - M: month.
        - Y: years.

        > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        """
        return pulumi.get(self, "renewal_period_unit")

    @renewal_period_unit.setter
    def renewal_period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_period_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status, value:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.

        Default ManualRenewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="sasAntiRansomware")
    def sas_anti_ransomware(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].

        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_anti_ransomware")

    @sas_anti_ransomware.setter
    def sas_anti_ransomware(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_anti_ransomware", value)

    @_builtins.property
    @pulumi.getter(name="sasCspm")
    def sas_cspm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud platform configuration check scan times, interval type, value range:[15000,9999999999].

        > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 55000, that is, only multiples of 55000 can be filled in.
        """
        return pulumi.get(self, "sas_cspm")

    @sas_cspm.setter
    def sas_cspm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_cspm", value)

    @_builtins.property
    @pulumi.getter(name="sasCspmSwitch")
    def sas_cspm_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud platform configuration check switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_cspm_switch")

    @sas_cspm_switch.setter
    def sas_cspm_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_cspm_switch", value)

    @_builtins.property
    @pulumi.getter(name="sasSc")
    def sas_sc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Security screen. Value:
        - true: Yes.
        - false: No.
        """
        return pulumi.get(self, "sas_sc")

    @sas_sc.setter
    def sas_sc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sas_sc", value)

    @_builtins.property
    @pulumi.getter(name="sasSdk")
    def sas_sdk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].

        > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sdk")

    @sas_sdk.setter
    def sas_sdk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_sdk", value)

    @_builtins.property
    @pulumi.getter(name="sasSdkSwitch")
    def sas_sdk_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Malicious file detection SDK.
        """
        return pulumi.get(self, "sas_sdk_switch")

    @sas_sdk_switch.setter
    def sas_sdk_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_sdk_switch", value)

    @_builtins.property
    @pulumi.getter(name="sasSlsStorage")
    def sas_sls_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].

        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sls_storage")

    @sas_sls_storage.setter
    def sas_sls_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_sls_storage", value)

    @_builtins.property
    @pulumi.getter(name="sasWebguardBoolean")
    def sas_webguard_boolean(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Web tamper-proof switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_boolean")

    @sas_webguard_boolean.setter
    def sas_webguard_boolean(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_webguard_boolean", value)

    @_builtins.property
    @pulumi.getter(name="sasWebguardOrderNum")
    def sas_webguard_order_num(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tamper-proof authorization number. Value:
        - 0: No
        1: Yes.
        """
        return pulumi.get(self, "sas_webguard_order_num")

    @sas_webguard_order_num.setter
    def sas_webguard_order_num(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_webguard_order_num", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription type. Value:
        - Subscription: Prepaid.
        - PayAsYouGo: Post-paid.
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_type", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysis")
    def threat_analysis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].

        > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "threat_analysis")

    @threat_analysis.setter
    def threat_analysis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisFlow")
    def threat_analysis_flow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis and response log access traffic. After ThreatAnalysisSwitch1 is selected, it must be selected. Interval type, value interval:[0,9999999999].

        > **NOTE:**  Step size is 100.
        """
        return pulumi.get(self, "threat_analysis_flow")

    @threat_analysis_flow.setter
    def threat_analysis_flow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_flow", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSlsStorage")
    def threat_analysis_sls_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis and response log storage capacity. Interval type, value interval:[0,9999999999].

        > **NOTE:**  The step size is 1000, that is, only multiples of 1000 can be filled in.
        """
        return pulumi.get(self, "threat_analysis_sls_storage")

    @threat_analysis_sls_storage.setter
    def threat_analysis_sls_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_sls_storage", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSwitch")
    def threat_analysis_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "threat_analysis_switch")

    @threat_analysis_switch.setter
    def threat_analysis_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_switch", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSwitch1")
    def threat_analysis_switch1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis and response switch (new), values:
        - 0: No
        - 1: Yes
        """
        return pulumi.get(self, "threat_analysis_switch1")

    @threat_analysis_switch1.setter
    def threat_analysis_switch1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_switch1", value)

    @_builtins.property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of cores.
        """
        return pulumi.get(self, "v_core")

    @v_core.setter
    def v_core(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "v_core", value)

    @_builtins.property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select the security center version. Value:
        - level7: Antivirus Edition.
        - level3: Premium version.
        - level2: Enterprise Edition.
        - level8: Ultimate.
        - level10: Purchase value-added services only.
        """
        return pulumi.get(self, "version_code")

    @version_code.setter
    def version_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_code", value)

    @_builtins.property
    @pulumi.getter(name="vulCount")
    def vul_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vulnerability repair times, interval type, value range:[20,100000000].

        > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_count")

    @vul_count.setter
    def vul_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vul_count", value)

    @_builtins.property
    @pulumi.getter(name="vulSwitch")
    def vul_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vulnerability fix switch. Value:
        - 0: No.
        - 1: Yes.

        > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_switch")

    @vul_switch.setter
    def vul_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vul_switch", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 buy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 post_paid_flag: Optional[pulumi.Input[_builtins.int]] = None,
                 post_pay_module_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 rasp_count: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sc: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_sdk: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch1: Optional[pulumi.Input[_builtins.str]] = None,
                 v_core: Optional[pulumi.Input[_builtins.str]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_count: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_switch: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] buy_number: Number of servers.
        :param pulumi.Input[_builtins.str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[_builtins.str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[_builtins.str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.int] post_paid_flag: Post-paid signage. Value:
        :param pulumi.Input[_builtins.str] post_pay_module_switch: Pay-as-you-go module switch mapping, in JsonString format. Valid values:
               - Key:
               - `VUL`: vulnerability repair module
               - `CSPM`: Cloud platform configuration check module
               - `AGENTLESS`: AGENTLESS detection module
               - `SERVERLESS`:Serverless asset module
               - `CTDR`: threat analysis and response module
               - `POST_HOST`: Host and container security module
               - Value:0 means off, 1 means on
               
               > **NOTE:**  The module value of the unpassed value will not change.
        :param pulumi.Input[_builtins.str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[15000,9999999999].
               
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 55000, that is, only multiples of 55000 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[_builtins.str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[_builtins.str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               1: Yes.
        :param pulumi.Input[_builtins.str] status: The resource attribute field representing the resource status.
        :param pulumi.Input[_builtins.str] subscription_type: The subscription type. Value:
               - Subscription: Prepaid.
               - PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_flow: Threat analysis and response log access traffic. After ThreatAnalysisSwitch1 is selected, it must be selected. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  Step size is 100.
        :param pulumi.Input[_builtins.str] threat_analysis_sls_storage: Threat analysis and response log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 1000, that is, only multiples of 1000 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] threat_analysis_switch1: Threat analysis and response switch (new), values:
               - 0: No
               - 1: Yes
        :param pulumi.Input[_builtins.str] v_core: Number of cores.
        :param pulumi.Input[_builtins.str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[_builtins.str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[_builtins.str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        if buy_number is not None:
            pulumi.set(__self__, "buy_number", buy_number)
        if container_image_scan is not None:
            warnings.warn("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""", DeprecationWarning)
            pulumi.log.warn("""container_image_scan is deprecated: Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")
        if container_image_scan is not None:
            pulumi.set(__self__, "container_image_scan", container_image_scan)
        if container_image_scan_new is not None:
            pulumi.set(__self__, "container_image_scan_new", container_image_scan_new)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if honeypot is not None:
            pulumi.set(__self__, "honeypot", honeypot)
        if honeypot_switch is not None:
            pulumi.set(__self__, "honeypot_switch", honeypot_switch)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if post_paid_flag is not None:
            pulumi.set(__self__, "post_paid_flag", post_paid_flag)
        if post_pay_module_switch is not None:
            pulumi.set(__self__, "post_pay_module_switch", post_pay_module_switch)
        if rasp_count is not None:
            pulumi.set(__self__, "rasp_count", rasp_count)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_period_unit is not None:
            pulumi.set(__self__, "renewal_period_unit", renewal_period_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if sas_anti_ransomware is not None:
            pulumi.set(__self__, "sas_anti_ransomware", sas_anti_ransomware)
        if sas_cspm is not None:
            pulumi.set(__self__, "sas_cspm", sas_cspm)
        if sas_cspm_switch is not None:
            pulumi.set(__self__, "sas_cspm_switch", sas_cspm_switch)
        if sas_sc is not None:
            pulumi.set(__self__, "sas_sc", sas_sc)
        if sas_sdk is not None:
            pulumi.set(__self__, "sas_sdk", sas_sdk)
        if sas_sdk_switch is not None:
            pulumi.set(__self__, "sas_sdk_switch", sas_sdk_switch)
        if sas_sls_storage is not None:
            pulumi.set(__self__, "sas_sls_storage", sas_sls_storage)
        if sas_webguard_boolean is not None:
            pulumi.set(__self__, "sas_webguard_boolean", sas_webguard_boolean)
        if sas_webguard_order_num is not None:
            pulumi.set(__self__, "sas_webguard_order_num", sas_webguard_order_num)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_type is not None:
            pulumi.set(__self__, "subscription_type", subscription_type)
        if threat_analysis is not None:
            pulumi.set(__self__, "threat_analysis", threat_analysis)
        if threat_analysis_flow is not None:
            pulumi.set(__self__, "threat_analysis_flow", threat_analysis_flow)
        if threat_analysis_sls_storage is not None:
            pulumi.set(__self__, "threat_analysis_sls_storage", threat_analysis_sls_storage)
        if threat_analysis_switch is not None:
            pulumi.set(__self__, "threat_analysis_switch", threat_analysis_switch)
        if threat_analysis_switch1 is not None:
            pulumi.set(__self__, "threat_analysis_switch1", threat_analysis_switch1)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version_code is not None:
            pulumi.set(__self__, "version_code", version_code)
        if vul_count is not None:
            pulumi.set(__self__, "vul_count", vul_count)
        if vul_switch is not None:
            pulumi.set(__self__, "vul_switch", vul_switch)

    @_builtins.property
    @pulumi.getter(name="buyNumber")
    def buy_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of servers.
        """
        return pulumi.get(self, "buy_number")

    @buy_number.setter
    def buy_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "buy_number", value)

    @_builtins.property
    @pulumi.getter(name="containerImageScan")
    @_utilities.deprecated("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")
    def container_image_scan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].

        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan")

    @container_image_scan.setter
    def container_image_scan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_image_scan", value)

    @_builtins.property
    @pulumi.getter(name="containerImageScanNew")
    def container_image_scan_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].

        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan_new")

    @container_image_scan_new.setter
    def container_image_scan_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_image_scan_new", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def honeypot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of cloud honeypot licenses. Interval type, value interval:[20,500].

        > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        """
        return pulumi.get(self, "honeypot")

    @honeypot.setter
    def honeypot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honeypot", value)

    @_builtins.property
    @pulumi.getter(name="honeypotSwitch")
    def honeypot_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud honeypot. Value:
        - 1: Yes.
        - 2: No.
        """
        return pulumi.get(self, "honeypot_switch")

    @honeypot_switch.setter
    def honeypot_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honeypot_switch", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Change configuration type, value
        - Upgrade: Upgrade.
        - Downgrade: Downgrade.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.

        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="postPaidFlag")
    def post_paid_flag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Post-paid signage. Value:
        """
        return pulumi.get(self, "post_paid_flag")

    @post_paid_flag.setter
    def post_paid_flag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "post_paid_flag", value)

    @_builtins.property
    @pulumi.getter(name="postPayModuleSwitch")
    def post_pay_module_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pay-as-you-go module switch mapping, in JsonString format. Valid values:
        - Key:
        - `VUL`: vulnerability repair module
        - `CSPM`: Cloud platform configuration check module
        - `AGENTLESS`: AGENTLESS detection module
        - `SERVERLESS`:Serverless asset module
        - `CTDR`: threat analysis and response module
        - `POST_HOST`: Host and container security module
        - Value:0 means off, 1 means on

        > **NOTE:**  The module value of the unpassed value will not change.
        """
        return pulumi.get(self, "post_pay_module_switch")

    @post_pay_module_switch.setter
    def post_pay_module_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_pay_module_switch", value)

    @_builtins.property
    @pulumi.getter(name="raspCount")
    def rasp_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of application protection licenses. Interval type, value interval:[1,100000000].
        """
        return pulumi.get(self, "rasp_count")

    @rasp_count.setter
    def rasp_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rasp_count", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal cycle, in months.

        > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal period unit, value:
        - M: month.
        - Y: years.

        > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        """
        return pulumi.get(self, "renewal_period_unit")

    @renewal_period_unit.setter
    def renewal_period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_period_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status, value:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.

        Default ManualRenewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="sasAntiRansomware")
    def sas_anti_ransomware(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].

        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_anti_ransomware")

    @sas_anti_ransomware.setter
    def sas_anti_ransomware(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_anti_ransomware", value)

    @_builtins.property
    @pulumi.getter(name="sasCspm")
    def sas_cspm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud platform configuration check scan times, interval type, value range:[15000,9999999999].

        > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 55000, that is, only multiples of 55000 can be filled in.
        """
        return pulumi.get(self, "sas_cspm")

    @sas_cspm.setter
    def sas_cspm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_cspm", value)

    @_builtins.property
    @pulumi.getter(name="sasCspmSwitch")
    def sas_cspm_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud platform configuration check switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_cspm_switch")

    @sas_cspm_switch.setter
    def sas_cspm_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_cspm_switch", value)

    @_builtins.property
    @pulumi.getter(name="sasSc")
    def sas_sc(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Security screen. Value:
        - true: Yes.
        - false: No.
        """
        return pulumi.get(self, "sas_sc")

    @sas_sc.setter
    def sas_sc(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sas_sc", value)

    @_builtins.property
    @pulumi.getter(name="sasSdk")
    def sas_sdk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].

        > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sdk")

    @sas_sdk.setter
    def sas_sdk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_sdk", value)

    @_builtins.property
    @pulumi.getter(name="sasSdkSwitch")
    def sas_sdk_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Malicious file detection SDK.
        """
        return pulumi.get(self, "sas_sdk_switch")

    @sas_sdk_switch.setter
    def sas_sdk_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_sdk_switch", value)

    @_builtins.property
    @pulumi.getter(name="sasSlsStorage")
    def sas_sls_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].

        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sls_storage")

    @sas_sls_storage.setter
    def sas_sls_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_sls_storage", value)

    @_builtins.property
    @pulumi.getter(name="sasWebguardBoolean")
    def sas_webguard_boolean(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Web tamper-proof switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_boolean")

    @sas_webguard_boolean.setter
    def sas_webguard_boolean(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_webguard_boolean", value)

    @_builtins.property
    @pulumi.getter(name="sasWebguardOrderNum")
    def sas_webguard_order_num(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tamper-proof authorization number. Value:
        - 0: No
        1: Yes.
        """
        return pulumi.get(self, "sas_webguard_order_num")

    @sas_webguard_order_num.setter
    def sas_webguard_order_num(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_webguard_order_num", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource attribute field representing the resource status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription type. Value:
        - Subscription: Prepaid.
        - PayAsYouGo: Post-paid.
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_type", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysis")
    def threat_analysis(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].

        > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "threat_analysis")

    @threat_analysis.setter
    def threat_analysis(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisFlow")
    def threat_analysis_flow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis and response log access traffic. After ThreatAnalysisSwitch1 is selected, it must be selected. Interval type, value interval:[0,9999999999].

        > **NOTE:**  Step size is 100.
        """
        return pulumi.get(self, "threat_analysis_flow")

    @threat_analysis_flow.setter
    def threat_analysis_flow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_flow", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSlsStorage")
    def threat_analysis_sls_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis and response log storage capacity. Interval type, value interval:[0,9999999999].

        > **NOTE:**  The step size is 1000, that is, only multiples of 1000 can be filled in.
        """
        return pulumi.get(self, "threat_analysis_sls_storage")

    @threat_analysis_sls_storage.setter
    def threat_analysis_sls_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_sls_storage", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSwitch")
    def threat_analysis_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "threat_analysis_switch")

    @threat_analysis_switch.setter
    def threat_analysis_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_switch", value)

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSwitch1")
    def threat_analysis_switch1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Threat analysis and response switch (new), values:
        - 0: No
        - 1: Yes
        """
        return pulumi.get(self, "threat_analysis_switch1")

    @threat_analysis_switch1.setter
    def threat_analysis_switch1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "threat_analysis_switch1", value)

    @_builtins.property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of cores.
        """
        return pulumi.get(self, "v_core")

    @v_core.setter
    def v_core(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "v_core", value)

    @_builtins.property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select the security center version. Value:
        - level7: Antivirus Edition.
        - level3: Premium version.
        - level2: Enterprise Edition.
        - level8: Ultimate.
        - level10: Purchase value-added services only.
        """
        return pulumi.get(self, "version_code")

    @version_code.setter
    def version_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_code", value)

    @_builtins.property
    @pulumi.getter(name="vulCount")
    def vul_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vulnerability repair times, interval type, value range:[20,100000000].

        > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_count")

    @vul_count.setter
    def vul_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vul_count", value)

    @_builtins.property
    @pulumi.getter(name="vulSwitch")
    def vul_switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vulnerability fix switch. Value:
        - 0: No.
        - 1: Yes.

        > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_switch")

    @vul_switch.setter
    def vul_switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vul_switch", value)


@pulumi.type_token("alicloud:threatdetection/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 post_paid_flag: Optional[pulumi.Input[_builtins.int]] = None,
                 post_pay_module_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 rasp_count: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sc: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_sdk: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch1: Optional[pulumi.Input[_builtins.str]] = None,
                 v_core: Optional[pulumi.Input[_builtins.str]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_count: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Threat Detection Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] buy_number: Number of servers.
        :param pulumi.Input[_builtins.str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[_builtins.str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[_builtins.str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.int] post_paid_flag: Post-paid signage. Value:
        :param pulumi.Input[_builtins.str] post_pay_module_switch: Pay-as-you-go module switch mapping, in JsonString format. Valid values:
               - Key:
               - `VUL`: vulnerability repair module
               - `CSPM`: Cloud platform configuration check module
               - `AGENTLESS`: AGENTLESS detection module
               - `SERVERLESS`:Serverless asset module
               - `CTDR`: threat analysis and response module
               - `POST_HOST`: Host and container security module
               - Value:0 means off, 1 means on
               
               > **NOTE:**  The module value of the unpassed value will not change.
        :param pulumi.Input[_builtins.str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[15000,9999999999].
               
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 55000, that is, only multiples of 55000 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[_builtins.str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[_builtins.str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               1: Yes.
        :param pulumi.Input[_builtins.str] subscription_type: The subscription type. Value:
               - Subscription: Prepaid.
               - PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_flow: Threat analysis and response log access traffic. After ThreatAnalysisSwitch1 is selected, it must be selected. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  Step size is 100.
        :param pulumi.Input[_builtins.str] threat_analysis_sls_storage: Threat analysis and response log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 1000, that is, only multiples of 1000 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] threat_analysis_switch1: Threat analysis and response switch (new), values:
               - 0: No
               - 1: Yes
        :param pulumi.Input[_builtins.str] v_core: Number of cores.
        :param pulumi.Input[_builtins.str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[_builtins.str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[_builtins.str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Threat Detection Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:threatdetection/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot: Optional[pulumi.Input[_builtins.str]] = None,
                 honeypot_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 post_paid_flag: Optional[pulumi.Input[_builtins.int]] = None,
                 post_pay_module_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 rasp_count: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sc: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_sdk: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_analysis_switch1: Optional[pulumi.Input[_builtins.str]] = None,
                 v_core: Optional[pulumi.Input[_builtins.str]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_count: Optional[pulumi.Input[_builtins.str]] = None,
                 vul_switch: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["buy_number"] = buy_number
            __props__.__dict__["container_image_scan"] = container_image_scan
            __props__.__dict__["container_image_scan_new"] = container_image_scan_new
            __props__.__dict__["honeypot"] = honeypot
            __props__.__dict__["honeypot_switch"] = honeypot_switch
            __props__.__dict__["modify_type"] = modify_type
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["post_paid_flag"] = post_paid_flag
            __props__.__dict__["post_pay_module_switch"] = post_pay_module_switch
            __props__.__dict__["rasp_count"] = rasp_count
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_period_unit"] = renewal_period_unit
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["sas_anti_ransomware"] = sas_anti_ransomware
            __props__.__dict__["sas_cspm"] = sas_cspm
            __props__.__dict__["sas_cspm_switch"] = sas_cspm_switch
            __props__.__dict__["sas_sc"] = sas_sc
            __props__.__dict__["sas_sdk"] = sas_sdk
            __props__.__dict__["sas_sdk_switch"] = sas_sdk_switch
            __props__.__dict__["sas_sls_storage"] = sas_sls_storage
            __props__.__dict__["sas_webguard_boolean"] = sas_webguard_boolean
            __props__.__dict__["sas_webguard_order_num"] = sas_webguard_order_num
            __props__.__dict__["subscription_type"] = subscription_type
            __props__.__dict__["threat_analysis"] = threat_analysis
            __props__.__dict__["threat_analysis_flow"] = threat_analysis_flow
            __props__.__dict__["threat_analysis_sls_storage"] = threat_analysis_sls_storage
            __props__.__dict__["threat_analysis_switch"] = threat_analysis_switch
            __props__.__dict__["threat_analysis_switch1"] = threat_analysis_switch1
            __props__.__dict__["v_core"] = v_core
            __props__.__dict__["version_code"] = version_code
            __props__.__dict__["vul_count"] = vul_count
            __props__.__dict__["vul_switch"] = vul_switch
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:threatdetection/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            buy_number: Optional[pulumi.Input[_builtins.str]] = None,
            container_image_scan: Optional[pulumi.Input[_builtins.str]] = None,
            container_image_scan_new: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            honeypot: Optional[pulumi.Input[_builtins.str]] = None,
            honeypot_switch: Optional[pulumi.Input[_builtins.str]] = None,
            modify_type: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            post_paid_flag: Optional[pulumi.Input[_builtins.int]] = None,
            post_pay_module_switch: Optional[pulumi.Input[_builtins.str]] = None,
            rasp_count: Optional[pulumi.Input[_builtins.str]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            sas_anti_ransomware: Optional[pulumi.Input[_builtins.str]] = None,
            sas_cspm: Optional[pulumi.Input[_builtins.str]] = None,
            sas_cspm_switch: Optional[pulumi.Input[_builtins.str]] = None,
            sas_sc: Optional[pulumi.Input[_builtins.bool]] = None,
            sas_sdk: Optional[pulumi.Input[_builtins.str]] = None,
            sas_sdk_switch: Optional[pulumi.Input[_builtins.str]] = None,
            sas_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
            sas_webguard_boolean: Optional[pulumi.Input[_builtins.str]] = None,
            sas_webguard_order_num: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
            threat_analysis: Optional[pulumi.Input[_builtins.str]] = None,
            threat_analysis_flow: Optional[pulumi.Input[_builtins.str]] = None,
            threat_analysis_sls_storage: Optional[pulumi.Input[_builtins.str]] = None,
            threat_analysis_switch: Optional[pulumi.Input[_builtins.str]] = None,
            threat_analysis_switch1: Optional[pulumi.Input[_builtins.str]] = None,
            v_core: Optional[pulumi.Input[_builtins.str]] = None,
            version_code: Optional[pulumi.Input[_builtins.str]] = None,
            vul_count: Optional[pulumi.Input[_builtins.str]] = None,
            vul_switch: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] buy_number: Number of servers.
        :param pulumi.Input[_builtins.str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[_builtins.str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[_builtins.str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[_builtins.int] post_paid_flag: Post-paid signage. Value:
        :param pulumi.Input[_builtins.str] post_pay_module_switch: Pay-as-you-go module switch mapping, in JsonString format. Valid values:
               - Key:
               - `VUL`: vulnerability repair module
               - `CSPM`: Cloud platform configuration check module
               - `AGENTLESS`: AGENTLESS detection module
               - `SERVERLESS`:Serverless asset module
               - `CTDR`: threat analysis and response module
               - `POST_HOST`: Host and container security module
               - Value:0 means off, 1 means on
               
               > **NOTE:**  The module value of the unpassed value will not change.
        :param pulumi.Input[_builtins.str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal cycle, in months.
               
               > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        :param pulumi.Input[_builtins.str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status, value:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
               
               Default ManualRenewal.
        :param pulumi.Input[_builtins.str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[15000,9999999999].
               
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 55000, that is, only multiples of 55000 can be filled in.
        :param pulumi.Input[_builtins.str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[_builtins.str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[_builtins.str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               1: Yes.
        :param pulumi.Input[_builtins.str] status: The resource attribute field representing the resource status.
        :param pulumi.Input[_builtins.str] subscription_type: The subscription type. Value:
               - Subscription: Prepaid.
               - PayAsYouGo: Post-paid.
        :param pulumi.Input[_builtins.str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_flow: Threat analysis and response log access traffic. After ThreatAnalysisSwitch1 is selected, it must be selected. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  Step size is 100.
        :param pulumi.Input[_builtins.str] threat_analysis_sls_storage: Threat analysis and response log storage capacity. Interval type, value interval:[0,9999999999].
               
               > **NOTE:**  The step size is 1000, that is, only multiples of 1000 can be filled in.
        :param pulumi.Input[_builtins.str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[_builtins.str] threat_analysis_switch1: Threat analysis and response switch (new), values:
               - 0: No
               - 1: Yes
        :param pulumi.Input[_builtins.str] v_core: Number of cores.
        :param pulumi.Input[_builtins.str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[_builtins.str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[_builtins.str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["buy_number"] = buy_number
        __props__.__dict__["container_image_scan"] = container_image_scan
        __props__.__dict__["container_image_scan_new"] = container_image_scan_new
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["honeypot"] = honeypot
        __props__.__dict__["honeypot_switch"] = honeypot_switch
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["post_paid_flag"] = post_paid_flag
        __props__.__dict__["post_pay_module_switch"] = post_pay_module_switch
        __props__.__dict__["rasp_count"] = rasp_count
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_period_unit"] = renewal_period_unit
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["sas_anti_ransomware"] = sas_anti_ransomware
        __props__.__dict__["sas_cspm"] = sas_cspm
        __props__.__dict__["sas_cspm_switch"] = sas_cspm_switch
        __props__.__dict__["sas_sc"] = sas_sc
        __props__.__dict__["sas_sdk"] = sas_sdk
        __props__.__dict__["sas_sdk_switch"] = sas_sdk_switch
        __props__.__dict__["sas_sls_storage"] = sas_sls_storage
        __props__.__dict__["sas_webguard_boolean"] = sas_webguard_boolean
        __props__.__dict__["sas_webguard_order_num"] = sas_webguard_order_num
        __props__.__dict__["status"] = status
        __props__.__dict__["subscription_type"] = subscription_type
        __props__.__dict__["threat_analysis"] = threat_analysis
        __props__.__dict__["threat_analysis_flow"] = threat_analysis_flow
        __props__.__dict__["threat_analysis_sls_storage"] = threat_analysis_sls_storage
        __props__.__dict__["threat_analysis_switch"] = threat_analysis_switch
        __props__.__dict__["threat_analysis_switch1"] = threat_analysis_switch1
        __props__.__dict__["v_core"] = v_core
        __props__.__dict__["version_code"] = version_code
        __props__.__dict__["vul_count"] = vul_count
        __props__.__dict__["vul_switch"] = vul_switch
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="buyNumber")
    def buy_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Number of servers.
        """
        return pulumi.get(self, "buy_number")

    @_builtins.property
    @pulumi.getter(name="containerImageScan")
    @_utilities.deprecated("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")
    def container_image_scan(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].

        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan")

    @_builtins.property
    @pulumi.getter(name="containerImageScanNew")
    def container_image_scan_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].

        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan_new")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def honeypot(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Number of cloud honeypot licenses. Interval type, value interval:[20,500].

        > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        """
        return pulumi.get(self, "honeypot")

    @_builtins.property
    @pulumi.getter(name="honeypotSwitch")
    def honeypot_switch(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud honeypot. Value:
        - 1: Yes.
        - 2: No.
        """
        return pulumi.get(self, "honeypot_switch")

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Change configuration type, value
        - Upgrade: Upgrade.
        - Downgrade: Downgrade.
        """
        return pulumi.get(self, "modify_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.

        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="postPaidFlag")
    def post_paid_flag(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Post-paid signage. Value:
        """
        return pulumi.get(self, "post_paid_flag")

    @_builtins.property
    @pulumi.getter(name="postPayModuleSwitch")
    def post_pay_module_switch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Pay-as-you-go module switch mapping, in JsonString format. Valid values:
        - Key:
        - `VUL`: vulnerability repair module
        - `CSPM`: Cloud platform configuration check module
        - `AGENTLESS`: AGENTLESS detection module
        - `SERVERLESS`:Serverless asset module
        - `CTDR`: threat analysis and response module
        - `POST_HOST`: Host and container security module
        - Value:0 means off, 1 means on

        > **NOTE:**  The module value of the unpassed value will not change.
        """
        return pulumi.get(self, "post_pay_module_switch")

    @_builtins.property
    @pulumi.getter(name="raspCount")
    def rasp_count(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Number of application protection licenses. Interval type, value interval:[1,100000000].
        """
        return pulumi.get(self, "rasp_count")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[_builtins.int]:
        """
        Automatic renewal cycle, in months.

        > **NOTE:**  When `RenewalStatus` is set to `AutoRenewal`, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> pulumi.Output[_builtins.str]:
        """
        Automatic renewal period unit, value:
        - M: month.
        - Y: years.

        > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        """
        return pulumi.get(self, "renewal_period_unit")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Automatic renewal status, value:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.

        Default ManualRenewal.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="sasAntiRansomware")
    def sas_anti_ransomware(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].

        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_anti_ransomware")

    @_builtins.property
    @pulumi.getter(name="sasCspm")
    def sas_cspm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cloud platform configuration check scan times, interval type, value range:[15000,9999999999].

        > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 55000, that is, only multiples of 55000 can be filled in.
        """
        return pulumi.get(self, "sas_cspm")

    @_builtins.property
    @pulumi.getter(name="sasCspmSwitch")
    def sas_cspm_switch(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud platform configuration check switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_cspm_switch")

    @_builtins.property
    @pulumi.getter(name="sasSc")
    def sas_sc(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Security screen. Value:
        - true: Yes.
        - false: No.
        """
        return pulumi.get(self, "sas_sc")

    @_builtins.property
    @pulumi.getter(name="sasSdk")
    def sas_sdk(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].

        > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sdk")

    @_builtins.property
    @pulumi.getter(name="sasSdkSwitch")
    def sas_sdk_switch(self) -> pulumi.Output[_builtins.str]:
        """
        Malicious file detection SDK.
        """
        return pulumi.get(self, "sas_sdk_switch")

    @_builtins.property
    @pulumi.getter(name="sasSlsStorage")
    def sas_sls_storage(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].

        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sls_storage")

    @_builtins.property
    @pulumi.getter(name="sasWebguardBoolean")
    def sas_webguard_boolean(self) -> pulumi.Output[_builtins.str]:
        """
        Web tamper-proof switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_boolean")

    @_builtins.property
    @pulumi.getter(name="sasWebguardOrderNum")
    def sas_webguard_order_num(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Tamper-proof authorization number. Value:
        - 0: No
        1: Yes.
        """
        return pulumi.get(self, "sas_webguard_order_num")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The resource attribute field representing the resource status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subscription type. Value:
        - Subscription: Prepaid.
        - PayAsYouGo: Post-paid.
        """
        return pulumi.get(self, "subscription_type")

    @_builtins.property
    @pulumi.getter(name="threatAnalysis")
    def threat_analysis(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].

        > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "threat_analysis")

    @_builtins.property
    @pulumi.getter(name="threatAnalysisFlow")
    def threat_analysis_flow(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Threat analysis and response log access traffic. After ThreatAnalysisSwitch1 is selected, it must be selected. Interval type, value interval:[0,9999999999].

        > **NOTE:**  Step size is 100.
        """
        return pulumi.get(self, "threat_analysis_flow")

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSlsStorage")
    def threat_analysis_sls_storage(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Threat analysis and response log storage capacity. Interval type, value interval:[0,9999999999].

        > **NOTE:**  The step size is 1000, that is, only multiples of 1000 can be filled in.
        """
        return pulumi.get(self, "threat_analysis_sls_storage")

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSwitch")
    def threat_analysis_switch(self) -> pulumi.Output[_builtins.str]:
        """
        Threat analysis. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "threat_analysis_switch")

    @_builtins.property
    @pulumi.getter(name="threatAnalysisSwitch1")
    def threat_analysis_switch1(self) -> pulumi.Output[_builtins.str]:
        """
        Threat analysis and response switch (new), values:
        - 0: No
        - 1: Yes
        """
        return pulumi.get(self, "threat_analysis_switch1")

    @_builtins.property
    @pulumi.getter(name="vCore")
    def v_core(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Number of cores.
        """
        return pulumi.get(self, "v_core")

    @_builtins.property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Select the security center version. Value:
        - level7: Antivirus Edition.
        - level3: Premium version.
        - level2: Enterprise Edition.
        - level8: Ultimate.
        - level10: Purchase value-added services only.
        """
        return pulumi.get(self, "version_code")

    @_builtins.property
    @pulumi.getter(name="vulCount")
    def vul_count(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Vulnerability repair times, interval type, value range:[20,100000000].

        > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_count")

    @_builtins.property
    @pulumi.getter(name="vulSwitch")
    def vul_switch(self) -> pulumi.Output[_builtins.str]:
        """
        Vulnerability fix switch. Value:
        - 0: No.
        - 1: Yes.

        > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_switch")

