# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PeerConnectionArgs', 'PeerConnection']

@pulumi.input_type
class PeerConnectionArgs:
    def __init__(__self__, *,
                 accepting_region_id: pulumi.Input[_builtins.str],
                 accepting_vpc_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 accepting_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PeerConnection resource.
        :param pulumi.Input[_builtins.str] accepting_region_id: The region ID of the accepter VPC of the VPC peering connection that you want to create.
               
               - To create an intra-region VPC peering connection, enter a region ID that is the same as that of the requester VPC.
               - To create an inter-region VPC peering connection, enter a region ID that is different from that of the requester VPC.
        :param pulumi.Input[_builtins.str] accepting_vpc_id: The ID of the accepter VPC.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the requester VPC or accepter VPC of the VPC peering connection that you want to query.
        :param pulumi.Input[_builtins.int] accepting_ali_uid: The ID of the Alibaba Cloud account to which the accepter VPC belongs.
               
               *   To create a VPC peering connection within your Alibaba Cloud account, enter the ID of your Alibaba Cloud account.
               *   To create a VPC peering connection between your Alibaba Cloud account and another Alibaba Cloud account, enter the ID of the peer Alibaba Cloud account.
               
               > **NOTE:**   If the accepter is a RAM user, set `AcceptingAliUid` to the ID of the Alibaba Cloud account that created the RAM user.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0. Before you specify this parameter, make sure that you create an inter-region VPC peering connection.
        :param pulumi.Input[_builtins.str] description: The description of the VPC peering connection.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] link_type: The link type of the VPC peering connection that you want to create. Valid values:
               - Platinum.
               - Gold: default value.
               
               > **NOTE:**
               
               > **NOTE:**  - If you need to specify this parameter, ensure that the VPC peering connection is an inter-region connection.
        :param pulumi.Input[_builtins.str] peer_connection_name: The name of the VPC peering connection.
               The name must be 2 to 128 characters in length, and can contain digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of VpcPeer.
        """
        pulumi.set(__self__, "accepting_region_id", accepting_region_id)
        pulumi.set(__self__, "accepting_vpc_id", accepting_vpc_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if accepting_ali_uid is not None:
            pulumi.set(__self__, "accepting_ali_uid", accepting_ali_uid)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if peer_connection_name is not None:
            pulumi.set(__self__, "peer_connection_name", peer_connection_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="acceptingRegionId")
    def accepting_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region ID of the accepter VPC of the VPC peering connection that you want to create.

        - To create an intra-region VPC peering connection, enter a region ID that is the same as that of the requester VPC.
        - To create an inter-region VPC peering connection, enter a region ID that is different from that of the requester VPC.
        """
        return pulumi.get(self, "accepting_region_id")

    @accepting_region_id.setter
    def accepting_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accepting_region_id", value)

    @_builtins.property
    @pulumi.getter(name="acceptingVpcId")
    def accepting_vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the accepter VPC.
        """
        return pulumi.get(self, "accepting_vpc_id")

    @accepting_vpc_id.setter
    def accepting_vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accepting_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the requester VPC or accepter VPC of the VPC peering connection that you want to query.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="acceptingAliUid")
    def accepting_ali_uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account to which the accepter VPC belongs.

        *   To create a VPC peering connection within your Alibaba Cloud account, enter the ID of your Alibaba Cloud account.
        *   To create a VPC peering connection between your Alibaba Cloud account and another Alibaba Cloud account, enter the ID of the peer Alibaba Cloud account.

        > **NOTE:**   If the accepter is a RAM user, set `AcceptingAliUid` to the ID of the Alibaba Cloud account that created the RAM user.
        """
        return pulumi.get(self, "accepting_ali_uid")

    @accepting_ali_uid.setter
    def accepting_ali_uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "accepting_ali_uid", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0. Before you specify this parameter, make sure that you create an inter-region VPC peering connection.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPC peering connection.
        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the VPC peering connection. Valid values:
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The link type of the VPC peering connection that you want to create. Valid values:
        - Platinum.
        - Gold: default value.

        > **NOTE:**

        > **NOTE:**  - If you need to specify this parameter, ensure that the VPC peering connection is an inter-region connection.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_type", value)

    @_builtins.property
    @pulumi.getter(name="peerConnectionName")
    def peer_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC peering connection.
        The name must be 2 to 128 characters in length, and can contain digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "peer_connection_name")

    @peer_connection_name.setter
    def peer_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_connection_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the new resource group.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of VpcPeer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PeerConnectionState:
    def __init__(__self__, *,
                 accepting_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 accepting_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accepting_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PeerConnection resources.
        :param pulumi.Input[_builtins.int] accepting_ali_uid: The ID of the Alibaba Cloud account to which the accepter VPC belongs.
               
               *   To create a VPC peering connection within your Alibaba Cloud account, enter the ID of your Alibaba Cloud account.
               *   To create a VPC peering connection between your Alibaba Cloud account and another Alibaba Cloud account, enter the ID of the peer Alibaba Cloud account.
               
               > **NOTE:**   If the accepter is a RAM user, set `AcceptingAliUid` to the ID of the Alibaba Cloud account that created the RAM user.
        :param pulumi.Input[_builtins.str] accepting_region_id: The region ID of the accepter VPC of the VPC peering connection that you want to create.
               
               - To create an intra-region VPC peering connection, enter a region ID that is the same as that of the requester VPC.
               - To create an inter-region VPC peering connection, enter a region ID that is different from that of the requester VPC.
        :param pulumi.Input[_builtins.str] accepting_vpc_id: The ID of the accepter VPC.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0. Before you specify this parameter, make sure that you create an inter-region VPC peering connection.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        :param pulumi.Input[_builtins.str] description: The description of the VPC peering connection.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] link_type: The link type of the VPC peering connection that you want to create. Valid values:
               - Platinum.
               - Gold: default value.
               
               > **NOTE:**
               
               > **NOTE:**  - If you need to specify this parameter, ensure that the VPC peering connection is an inter-region connection.
        :param pulumi.Input[_builtins.str] peer_connection_name: The name of the VPC peering connection.
               The name must be 2 to 128 characters in length, and can contain digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource to which you want to create and add tags.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of VpcPeer.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the requester VPC or accepter VPC of the VPC peering connection that you want to query.
        """
        if accepting_ali_uid is not None:
            pulumi.set(__self__, "accepting_ali_uid", accepting_ali_uid)
        if accepting_region_id is not None:
            pulumi.set(__self__, "accepting_region_id", accepting_region_id)
        if accepting_vpc_id is not None:
            pulumi.set(__self__, "accepting_vpc_id", accepting_vpc_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if peer_connection_name is not None:
            pulumi.set(__self__, "peer_connection_name", peer_connection_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="acceptingAliUid")
    def accepting_ali_uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account to which the accepter VPC belongs.

        *   To create a VPC peering connection within your Alibaba Cloud account, enter the ID of your Alibaba Cloud account.
        *   To create a VPC peering connection between your Alibaba Cloud account and another Alibaba Cloud account, enter the ID of the peer Alibaba Cloud account.

        > **NOTE:**   If the accepter is a RAM user, set `AcceptingAliUid` to the ID of the Alibaba Cloud account that created the RAM user.
        """
        return pulumi.get(self, "accepting_ali_uid")

    @accepting_ali_uid.setter
    def accepting_ali_uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "accepting_ali_uid", value)

    @_builtins.property
    @pulumi.getter(name="acceptingRegionId")
    def accepting_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the accepter VPC of the VPC peering connection that you want to create.

        - To create an intra-region VPC peering connection, enter a region ID that is the same as that of the requester VPC.
        - To create an inter-region VPC peering connection, enter a region ID that is different from that of the requester VPC.
        """
        return pulumi.get(self, "accepting_region_id")

    @accepting_region_id.setter
    def accepting_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accepting_region_id", value)

    @_builtins.property
    @pulumi.getter(name="acceptingVpcId")
    def accepting_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the accepter VPC.
        """
        return pulumi.get(self, "accepting_vpc_id")

    @accepting_vpc_id.setter
    def accepting_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accepting_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0. Before you specify this parameter, make sure that you create an inter-region VPC peering connection.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPC peering connection.
        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the VPC peering connection. Valid values:
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The link type of the VPC peering connection that you want to create. Valid values:
        - Platinum.
        - Gold: default value.

        > **NOTE:**

        > **NOTE:**  - If you need to specify this parameter, ensure that the VPC peering connection is an inter-region connection.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_type", value)

    @_builtins.property
    @pulumi.getter(name="peerConnectionName")
    def peer_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC peering connection.
        The name must be 2 to 128 characters in length, and can contain digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "peer_connection_name")

    @peer_connection_name.setter
    def peer_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_connection_name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource to which you want to create and add tags.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the new resource group.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of VpcPeer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the requester VPC or accepter VPC of the VPC peering connection that you want to query.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:vpc/peerConnection:PeerConnection")
class PeerConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accepting_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 accepting_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accepting_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vpc Peer Peer Connection resource.

        Vpc peer connection.

        For information about Vpc Peer Peer Connection and how to use it, see [What is Peer Connection](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createvpcpeer).

        > **NOTE:** Available since v1.186.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_account()
        config = pulumi.Config()
        accepting_region = config.get("acceptingRegion")
        if accepting_region is None:
            accepting_region = "cn-beijing"
        local_vpc = alicloud.vpc.Network("local_vpc",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        accepting_vpc = alicloud.vpc.Network("accepting_vpc",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_peer_connection = alicloud.vpc.PeerConnection("default",
            peer_connection_name="terraform-example",
            vpc_id=local_vpc.id,
            accepting_ali_uid=default.id,
            accepting_region_id=accepting_region,
            accepting_vpc_id=accepting_vpc.id,
            description="terraform-example")
        ```

        ## Import

        Vpc Peer Peer Connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/peerConnection:PeerConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] accepting_ali_uid: The ID of the Alibaba Cloud account to which the accepter VPC belongs.
               
               *   To create a VPC peering connection within your Alibaba Cloud account, enter the ID of your Alibaba Cloud account.
               *   To create a VPC peering connection between your Alibaba Cloud account and another Alibaba Cloud account, enter the ID of the peer Alibaba Cloud account.
               
               > **NOTE:**   If the accepter is a RAM user, set `AcceptingAliUid` to the ID of the Alibaba Cloud account that created the RAM user.
        :param pulumi.Input[_builtins.str] accepting_region_id: The region ID of the accepter VPC of the VPC peering connection that you want to create.
               
               - To create an intra-region VPC peering connection, enter a region ID that is the same as that of the requester VPC.
               - To create an inter-region VPC peering connection, enter a region ID that is different from that of the requester VPC.
        :param pulumi.Input[_builtins.str] accepting_vpc_id: The ID of the accepter VPC.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0. Before you specify this parameter, make sure that you create an inter-region VPC peering connection.
        :param pulumi.Input[_builtins.str] description: The description of the VPC peering connection.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] link_type: The link type of the VPC peering connection that you want to create. Valid values:
               - Platinum.
               - Gold: default value.
               
               > **NOTE:**
               
               > **NOTE:**  - If you need to specify this parameter, ensure that the VPC peering connection is an inter-region connection.
        :param pulumi.Input[_builtins.str] peer_connection_name: The name of the VPC peering connection.
               The name must be 2 to 128 characters in length, and can contain digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of VpcPeer.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the requester VPC or accepter VPC of the VPC peering connection that you want to query.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeerConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Peer Peer Connection resource.

        Vpc peer connection.

        For information about Vpc Peer Peer Connection and how to use it, see [What is Peer Connection](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createvpcpeer).

        > **NOTE:** Available since v1.186.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_account()
        config = pulumi.Config()
        accepting_region = config.get("acceptingRegion")
        if accepting_region is None:
            accepting_region = "cn-beijing"
        local_vpc = alicloud.vpc.Network("local_vpc",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        accepting_vpc = alicloud.vpc.Network("accepting_vpc",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_peer_connection = alicloud.vpc.PeerConnection("default",
            peer_connection_name="terraform-example",
            vpc_id=local_vpc.id,
            accepting_ali_uid=default.id,
            accepting_region_id=accepting_region,
            accepting_vpc_id=accepting_vpc.id,
            description="terraform-example")
        ```

        ## Import

        Vpc Peer Peer Connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/peerConnection:PeerConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PeerConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeerConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accepting_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 accepting_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 accepting_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeerConnectionArgs.__new__(PeerConnectionArgs)

            __props__.__dict__["accepting_ali_uid"] = accepting_ali_uid
            if accepting_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'accepting_region_id'")
            __props__.__dict__["accepting_region_id"] = accepting_region_id
            if accepting_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'accepting_vpc_id'")
            __props__.__dict__["accepting_vpc_id"] = accepting_vpc_id
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["link_type"] = link_type
            __props__.__dict__["peer_connection_name"] = peer_connection_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
        super(PeerConnection, __self__).__init__(
            'alicloud:vpc/peerConnection:PeerConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accepting_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
            accepting_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            accepting_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            link_type: Optional[pulumi.Input[_builtins.str]] = None,
            peer_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PeerConnection':
        """
        Get an existing PeerConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] accepting_ali_uid: The ID of the Alibaba Cloud account to which the accepter VPC belongs.
               
               *   To create a VPC peering connection within your Alibaba Cloud account, enter the ID of your Alibaba Cloud account.
               *   To create a VPC peering connection between your Alibaba Cloud account and another Alibaba Cloud account, enter the ID of the peer Alibaba Cloud account.
               
               > **NOTE:**   If the accepter is a RAM user, set `AcceptingAliUid` to the ID of the Alibaba Cloud account that created the RAM user.
        :param pulumi.Input[_builtins.str] accepting_region_id: The region ID of the accepter VPC of the VPC peering connection that you want to create.
               
               - To create an intra-region VPC peering connection, enter a region ID that is the same as that of the requester VPC.
               - To create an inter-region VPC peering connection, enter a region ID that is different from that of the requester VPC.
        :param pulumi.Input[_builtins.str] accepting_vpc_id: The ID of the accepter VPC.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0. Before you specify this parameter, make sure that you create an inter-region VPC peering connection.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        :param pulumi.Input[_builtins.str] description: The description of the VPC peering connection.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcefully delete the VPC peering connection. Valid values:
        :param pulumi.Input[_builtins.str] link_type: The link type of the VPC peering connection that you want to create. Valid values:
               - Platinum.
               - Gold: default value.
               
               > **NOTE:**
               
               > **NOTE:**  - If you need to specify this parameter, ensure that the VPC peering connection is an inter-region connection.
        :param pulumi.Input[_builtins.str] peer_connection_name: The name of the VPC peering connection.
               The name must be 2 to 128 characters in length, and can contain digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource to which you want to create and add tags.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of VpcPeer.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the requester VPC or accepter VPC of the VPC peering connection that you want to query.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeerConnectionState.__new__(_PeerConnectionState)

        __props__.__dict__["accepting_ali_uid"] = accepting_ali_uid
        __props__.__dict__["accepting_region_id"] = accepting_region_id
        __props__.__dict__["accepting_vpc_id"] = accepting_vpc_id
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["link_type"] = link_type
        __props__.__dict__["peer_connection_name"] = peer_connection_name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return PeerConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceptingAliUid")
    def accepting_ali_uid(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account to which the accepter VPC belongs.

        *   To create a VPC peering connection within your Alibaba Cloud account, enter the ID of your Alibaba Cloud account.
        *   To create a VPC peering connection between your Alibaba Cloud account and another Alibaba Cloud account, enter the ID of the peer Alibaba Cloud account.

        > **NOTE:**   If the accepter is a RAM user, set `AcceptingAliUid` to the ID of the Alibaba Cloud account that created the RAM user.
        """
        return pulumi.get(self, "accepting_ali_uid")

    @_builtins.property
    @pulumi.getter(name="acceptingRegionId")
    def accepting_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the accepter VPC of the VPC peering connection that you want to create.

        - To create an intra-region VPC peering connection, enter a region ID that is the same as that of the requester VPC.
        - To create an inter-region VPC peering connection, enter a region ID that is different from that of the requester VPC.
        """
        return pulumi.get(self, "accepting_region_id")

    @_builtins.property
    @pulumi.getter(name="acceptingVpcId")
    def accepting_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the accepter VPC.
        """
        return pulumi.get(self, "accepting_vpc_id")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth of the VPC peering connection. Unit: Mbit/s. The value must be an integer greater than 0. Before you specify this parameter, make sure that you create an inter-region VPC peering connection.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the VPC peer connection. Use UTC time in the format' YYYY-MM-DDThh:mm:ssZ '.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the VPC peering connection.
        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the VPC peering connection. Valid values:
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="linkType")
    def link_type(self) -> pulumi.Output[_builtins.str]:
        """
        The link type of the VPC peering connection that you want to create. Valid values:
        - Platinum.
        - Gold: default value.

        > **NOTE:**

        > **NOTE:**  - If you need to specify this parameter, ensure that the VPC peering connection is an inter-region connection.
        """
        return pulumi.get(self, "link_type")

    @_builtins.property
    @pulumi.getter(name="peerConnectionName")
    def peer_connection_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPC peering connection.
        The name must be 2 to 128 characters in length, and can contain digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "peer_connection_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource to which you want to create and add tags.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the new resource group.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags of VpcPeer.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the requester VPC or accepter VPC of the VPC peering connection that you want to query.
        """
        return pulumi.get(self, "vpc_id")

