# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnatEntryArgs', 'SnatEntry']

@pulumi.input_type
class SnatEntryArgs:
    def __init__(__self__, *,
                 snat_ip: pulumi.Input[_builtins.str],
                 snat_table_id: pulumi.Input[_builtins.str],
                 eip_affinity: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_entry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SnatEntry resource.
        :param pulumi.Input[_builtins.str] snat_ip: The IP of a SNAT entry. Separate multiple EIP or NAT IP addresses with commas (,). **NOTE:** From version 1.241.0, `snat_ip` can be modified.
        :param pulumi.Input[_builtins.str] snat_table_id: The ID of the SNAT table.
        :param pulumi.Input[_builtins.int] eip_affinity: Specifies whether to enable EIP affinity. Default value: `0`. Valid values:
        :param pulumi.Input[_builtins.str] snat_entry_name: The name of the SNAT entry. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block specified in the SNAT entry.
        :param pulumi.Input[_builtins.str] source_vswitch_id: The ID of the vSwitch.
        """
        pulumi.set(__self__, "snat_ip", snat_ip)
        pulumi.set(__self__, "snat_table_id", snat_table_id)
        if eip_affinity is not None:
            pulumi.set(__self__, "eip_affinity", eip_affinity)
        if snat_entry_name is not None:
            pulumi.set(__self__, "snat_entry_name", snat_entry_name)
        if source_cidr is not None:
            pulumi.set(__self__, "source_cidr", source_cidr)
        if source_vswitch_id is not None:
            pulumi.set(__self__, "source_vswitch_id", source_vswitch_id)

    @_builtins.property
    @pulumi.getter(name="snatIp")
    def snat_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The IP of a SNAT entry. Separate multiple EIP or NAT IP addresses with commas (,). **NOTE:** From version 1.241.0, `snat_ip` can be modified.
        """
        return pulumi.get(self, "snat_ip")

    @snat_ip.setter
    def snat_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snat_ip", value)

    @_builtins.property
    @pulumi.getter(name="snatTableId")
    def snat_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the SNAT table.
        """
        return pulumi.get(self, "snat_table_id")

    @snat_table_id.setter
    def snat_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snat_table_id", value)

    @_builtins.property
    @pulumi.getter(name="eipAffinity")
    def eip_affinity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable EIP affinity. Default value: `0`. Valid values:
        """
        return pulumi.get(self, "eip_affinity")

    @eip_affinity.setter
    def eip_affinity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_affinity", value)

    @_builtins.property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SNAT entry. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "snat_entry_name")

    @snat_entry_name.setter
    def snat_entry_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snat_entry_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source CIDR block specified in the SNAT entry.
        """
        return pulumi.get(self, "source_cidr")

    @source_cidr.setter
    def source_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr", value)

    @_builtins.property
    @pulumi.getter(name="sourceVswitchId")
    def source_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "source_vswitch_id")

    @source_vswitch_id.setter
    def source_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_vswitch_id", value)


@pulumi.input_type
class _SnatEntryState:
    def __init__(__self__, *,
                 eip_affinity: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_entry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SnatEntry resources.
        :param pulumi.Input[_builtins.int] eip_affinity: Specifies whether to enable EIP affinity. Default value: `0`. Valid values:
        :param pulumi.Input[_builtins.str] snat_entry_id: The id of the snat entry on the server.
        :param pulumi.Input[_builtins.str] snat_entry_name: The name of the SNAT entry. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] snat_ip: The IP of a SNAT entry. Separate multiple EIP or NAT IP addresses with commas (,). **NOTE:** From version 1.241.0, `snat_ip` can be modified.
        :param pulumi.Input[_builtins.str] snat_table_id: The ID of the SNAT table.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block specified in the SNAT entry.
        :param pulumi.Input[_builtins.str] source_vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[_builtins.str] status: (Available since v1.119.1) The ID of the SNAT entry.
        """
        if eip_affinity is not None:
            pulumi.set(__self__, "eip_affinity", eip_affinity)
        if snat_entry_id is not None:
            pulumi.set(__self__, "snat_entry_id", snat_entry_id)
        if snat_entry_name is not None:
            pulumi.set(__self__, "snat_entry_name", snat_entry_name)
        if snat_ip is not None:
            pulumi.set(__self__, "snat_ip", snat_ip)
        if snat_table_id is not None:
            pulumi.set(__self__, "snat_table_id", snat_table_id)
        if source_cidr is not None:
            pulumi.set(__self__, "source_cidr", source_cidr)
        if source_vswitch_id is not None:
            pulumi.set(__self__, "source_vswitch_id", source_vswitch_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="eipAffinity")
    def eip_affinity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable EIP affinity. Default value: `0`. Valid values:
        """
        return pulumi.get(self, "eip_affinity")

    @eip_affinity.setter
    def eip_affinity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_affinity", value)

    @_builtins.property
    @pulumi.getter(name="snatEntryId")
    def snat_entry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the snat entry on the server.
        """
        return pulumi.get(self, "snat_entry_id")

    @snat_entry_id.setter
    def snat_entry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snat_entry_id", value)

    @_builtins.property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SNAT entry. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "snat_entry_name")

    @snat_entry_name.setter
    def snat_entry_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snat_entry_name", value)

    @_builtins.property
    @pulumi.getter(name="snatIp")
    def snat_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP of a SNAT entry. Separate multiple EIP or NAT IP addresses with commas (,). **NOTE:** From version 1.241.0, `snat_ip` can be modified.
        """
        return pulumi.get(self, "snat_ip")

    @snat_ip.setter
    def snat_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snat_ip", value)

    @_builtins.property
    @pulumi.getter(name="snatTableId")
    def snat_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SNAT table.
        """
        return pulumi.get(self, "snat_table_id")

    @snat_table_id.setter
    def snat_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snat_table_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source CIDR block specified in the SNAT entry.
        """
        return pulumi.get(self, "source_cidr")

    @source_cidr.setter
    def source_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr", value)

    @_builtins.property
    @pulumi.getter(name="sourceVswitchId")
    def source_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "source_vswitch_id")

    @source_vswitch_id.setter
    def source_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_vswitch_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.119.1) The ID of the SNAT entry.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:vpc/snatEntry:SnatEntry")
class SnatEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_affinity: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_entry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a NAT Gateway Snat Entry resource.

        For information about NAT Gateway Snat Entry and how to use it, see [What is Snat Entry](https://www.alibabacloud.com/help/en/nat-gateway/developer-reference/api-vpc-2016-04-28-createsnatentry-natgws).

        > **NOTE:** Available since v1.119.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_nat_gateway = alicloud.vpc.NatGateway("default",
            vpc_id=default_network.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id,
            nat_type="Enhanced")
        default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
        default_eip_association = alicloud.ecs.EipAssociation("default",
            allocation_id=default_eip_address.id,
            instance_id=default_nat_gateway.id)
        default_snat_entry = alicloud.vpc.SnatEntry("default",
            snat_table_id=default_nat_gateway.snat_table_ids,
            source_vswitch_id=default_switch.id,
            snat_ip=default_eip_address.ip_address)
        ```

        ## Import

        NAT Gateway Snat Entry can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/snatEntry:SnatEntry example <snat_table_id>:<snat_entry_id>
        ```

        ```sh
        $ pulumi import alicloud:vpc/snatEntry:SnatEntry example <snat_entry_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] eip_affinity: Specifies whether to enable EIP affinity. Default value: `0`. Valid values:
        :param pulumi.Input[_builtins.str] snat_entry_name: The name of the SNAT entry. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] snat_ip: The IP of a SNAT entry. Separate multiple EIP or NAT IP addresses with commas (,). **NOTE:** From version 1.241.0, `snat_ip` can be modified.
        :param pulumi.Input[_builtins.str] snat_table_id: The ID of the SNAT table.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block specified in the SNAT entry.
        :param pulumi.Input[_builtins.str] source_vswitch_id: The ID of the vSwitch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnatEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NAT Gateway Snat Entry resource.

        For information about NAT Gateway Snat Entry and how to use it, see [What is Snat Entry](https://www.alibabacloud.com/help/en/nat-gateway/developer-reference/api-vpc-2016-04-28-createsnatentry-natgws).

        > **NOTE:** Available since v1.119.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_nat_gateway = alicloud.vpc.NatGateway("default",
            vpc_id=default_network.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id,
            nat_type="Enhanced")
        default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
        default_eip_association = alicloud.ecs.EipAssociation("default",
            allocation_id=default_eip_address.id,
            instance_id=default_nat_gateway.id)
        default_snat_entry = alicloud.vpc.SnatEntry("default",
            snat_table_id=default_nat_gateway.snat_table_ids,
            source_vswitch_id=default_switch.id,
            snat_ip=default_eip_address.ip_address)
        ```

        ## Import

        NAT Gateway Snat Entry can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/snatEntry:SnatEntry example <snat_table_id>:<snat_entry_id>
        ```

        ```sh
        $ pulumi import alicloud:vpc/snatEntry:SnatEntry example <snat_entry_id>
        ```

        :param str resource_name: The name of the resource.
        :param SnatEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnatEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_affinity: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_entry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 snat_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnatEntryArgs.__new__(SnatEntryArgs)

            __props__.__dict__["eip_affinity"] = eip_affinity
            __props__.__dict__["snat_entry_name"] = snat_entry_name
            if snat_ip is None and not opts.urn:
                raise TypeError("Missing required property 'snat_ip'")
            __props__.__dict__["snat_ip"] = snat_ip
            if snat_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'snat_table_id'")
            __props__.__dict__["snat_table_id"] = snat_table_id
            __props__.__dict__["source_cidr"] = source_cidr
            __props__.__dict__["source_vswitch_id"] = source_vswitch_id
            __props__.__dict__["snat_entry_id"] = None
            __props__.__dict__["status"] = None
        super(SnatEntry, __self__).__init__(
            'alicloud:vpc/snatEntry:SnatEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            eip_affinity: Optional[pulumi.Input[_builtins.int]] = None,
            snat_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
            snat_entry_name: Optional[pulumi.Input[_builtins.str]] = None,
            snat_ip: Optional[pulumi.Input[_builtins.str]] = None,
            snat_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            source_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'SnatEntry':
        """
        Get an existing SnatEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] eip_affinity: Specifies whether to enable EIP affinity. Default value: `0`. Valid values:
        :param pulumi.Input[_builtins.str] snat_entry_id: The id of the snat entry on the server.
        :param pulumi.Input[_builtins.str] snat_entry_name: The name of the SNAT entry. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] snat_ip: The IP of a SNAT entry. Separate multiple EIP or NAT IP addresses with commas (,). **NOTE:** From version 1.241.0, `snat_ip` can be modified.
        :param pulumi.Input[_builtins.str] snat_table_id: The ID of the SNAT table.
        :param pulumi.Input[_builtins.str] source_cidr: The source CIDR block specified in the SNAT entry.
        :param pulumi.Input[_builtins.str] source_vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[_builtins.str] status: (Available since v1.119.1) The ID of the SNAT entry.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnatEntryState.__new__(_SnatEntryState)

        __props__.__dict__["eip_affinity"] = eip_affinity
        __props__.__dict__["snat_entry_id"] = snat_entry_id
        __props__.__dict__["snat_entry_name"] = snat_entry_name
        __props__.__dict__["snat_ip"] = snat_ip
        __props__.__dict__["snat_table_id"] = snat_table_id
        __props__.__dict__["source_cidr"] = source_cidr
        __props__.__dict__["source_vswitch_id"] = source_vswitch_id
        __props__.__dict__["status"] = status
        return SnatEntry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="eipAffinity")
    def eip_affinity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies whether to enable EIP affinity. Default value: `0`. Valid values:
        """
        return pulumi.get(self, "eip_affinity")

    @_builtins.property
    @pulumi.getter(name="snatEntryId")
    def snat_entry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the snat entry on the server.
        """
        return pulumi.get(self, "snat_entry_id")

    @_builtins.property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the SNAT entry. The name must be `2` to `128` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "snat_entry_name")

    @_builtins.property
    @pulumi.getter(name="snatIp")
    def snat_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP of a SNAT entry. Separate multiple EIP or NAT IP addresses with commas (,). **NOTE:** From version 1.241.0, `snat_ip` can be modified.
        """
        return pulumi.get(self, "snat_ip")

    @_builtins.property
    @pulumi.getter(name="snatTableId")
    def snat_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the SNAT table.
        """
        return pulumi.get(self, "snat_table_id")

    @_builtins.property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The source CIDR block specified in the SNAT entry.
        """
        return pulumi.get(self, "source_cidr")

    @_builtins.property
    @pulumi.getter(name="sourceVswitchId")
    def source_vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "source_vswitch_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.119.1) The ID of the SNAT entry.
        """
        return pulumi.get(self, "status")

