# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DefenseRuleConfig',
    'DefenseRuleConfigAccountIdentifier',
    'DefenseRuleConfigCondition',
    'DefenseRuleConfigRateLimit',
    'DefenseRuleConfigRateLimitStatus',
    'DomainListen',
    'DomainRedirect',
    'DomainRedirectRequestHeader',
    'GetDomainsDomainResult',
    'GetDomainsDomainListenResult',
    'GetDomainsDomainRedirectResult',
    'GetDomainsDomainRedirectRequestHeaderResult',
    'GetInstancesInstanceResult',
]

@pulumi.output_type
class DefenseRuleConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abroadRegions":
            suggest = "abroad_regions"
        elif key == "accountIdentifiers":
            suggest = "account_identifiers"
        elif key == "bypassRegularRules":
            suggest = "bypass_regular_rules"
        elif key == "bypassRegularTypes":
            suggest = "bypass_regular_types"
        elif key == "bypassTags":
            suggest = "bypass_tags"
        elif key == "ccEffect":
            suggest = "cc_effect"
        elif key == "ccStatus":
            suggest = "cc_status"
        elif key == "cnRegions":
            suggest = "cn_regions"
        elif key == "rateLimit":
            suggest = "rate_limit"
        elif key == "remoteAddrs":
            suggest = "remote_addrs"
        elif key == "ruleAction":
            suggest = "rule_action"
        elif key == "throttleThrehold":
            suggest = "throttle_threhold"
        elif key == "throttleType":
            suggest = "throttle_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenseRuleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenseRuleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenseRuleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 abroad_regions: Optional[_builtins.str] = None,
                 account_identifiers: Optional[Sequence['outputs.DefenseRuleConfigAccountIdentifier']] = None,
                 bypass_regular_rules: Optional[Sequence[_builtins.str]] = None,
                 bypass_regular_types: Optional[Sequence[_builtins.str]] = None,
                 bypass_tags: Optional[Sequence[_builtins.str]] = None,
                 cc_effect: Optional[_builtins.str] = None,
                 cc_status: Optional[_builtins.int] = None,
                 cn_regions: Optional[_builtins.str] = None,
                 conditions: Optional[Sequence['outputs.DefenseRuleConfigCondition']] = None,
                 mode: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None,
                 rate_limit: Optional['outputs.DefenseRuleConfigRateLimit'] = None,
                 remote_addrs: Optional[Sequence[_builtins.str]] = None,
                 rule_action: Optional[_builtins.str] = None,
                 throttle_threhold: Optional[_builtins.int] = None,
                 throttle_type: Optional[_builtins.str] = None,
                 ua: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str abroad_regions: The regions outside China from which you want to block requests. Separate multiple region codes with commas (,). You can call the DescribeIpAbroadCountryInfos operation to query the countries and regions outside China that can be blocked.
        :param Sequence['DefenseRuleConfigAccountIdentifierArgs'] account_identifiers: The policies for account extraction. Up to five policies are supported. Each policy is a JSON string. For more information, see accountIdentifiers description. See `account_identifiers` below.
        :param Sequence[_builtins.str] bypass_regular_rules: The list of regular rule IDs that are not detected. The value is in the ["XX1", "XX2",...] format. This parameter is required only when the module to which the whitelist applies is set to specific regular rules in basic protection (BypassTags is set to regular_rule).
        :param Sequence[_builtins.str] bypass_regular_types: The regular rule type is not detected. This parameter is configured only when the whitelist module is configured as the Web application regular type (the value of the BypassTags parameter is regular_type). Value:
               - sqli: Indicates SQL injection.
               - xss: Indicates cross-site scripting (XSS).
               - cmdi: Indicates OS command injection.
               - expression_injection: Indicates expression injection.
               - java_deserialization: indicates Java deserialization.
               - dot_net_deserialization: Represents. net deserialization.
               - php_deserialization: indicates PHP deserialization.
               - code_exec: Indicates code execution.
               - ssrf: indicates SSRF (server-side request forgery).
               - path_traversal: indicates a Path Traversal.
               - arbitrary_file_uploading: Indicates to upload any file.
               - webshell: Represents a webshell.
               - rfilei: Indicates the remote file contains (RFI).
               - lfilei: Indicates that the local file contains (LFI).
               - protocol_violation: indicates a protocol violation.
               - scanner_behavior: Indicates scanner behavior.
               - logic_flaw: Indicates a business logic defect.
               - arbitrary_file_reading: Indicates arbitrary file reading.
               - arbitrary_file_download: Indicates an arbitrary file download.
               - xxe: Indicates external entity injection.
               - csrf: indicates cross-site request forgery.
               - crlf: indicates CRLF.
               - other: indicates other.
        :param Sequence[_builtins.str] bypass_tags: The modules to which the whitelist applies. The value is in the ["XX1", "XX2",...] format. Valid values:
               - waf: indicates all modules.
               - customrule: indicates custom rules.
               - blacklist: indicates IP blacklist.
               - antiscan: indicates scan protection.
               - regular: indicates basic protection rules.
               - regular_rule: indicates specific regular rules in basic protection.
               - regular_type: indicates specific regular rule types in basic protection.
               - major_protection: indicates major event support protection.
               - cc: indicates CC protection.
               - region_block: indicates Location Blacklist.
               - antibot_scene: indicates BOT scenario protection.
               - dlp: indicates information leakage prevention.
               - tamperproof: indicates web tamper-proofing.
               - spike_throttle: indicates peak traffic throttling.
        :param _builtins.str cc_effect: Set the effective range of the speed limit. This information is configured only when ccStatus is set to 1. Value:
               - service: indicates that the effective object is a protected object.
               - rule: indicates that the effective object is a single rule.
        :param _builtins.int cc_status: Whether to open the speed limit. Value:
               - 0: indicates that the speed limit is off.
               - 1: Indicates that the speed limit is on.
        :param _builtins.str cn_regions: The regions in China from which you want to block requests. If you specify "CN", requests from the Chinese mainland (excluding Hong Kong, Macao, and Taiwan) are blocked. Separate multiple regions with commas (,). For more information about region codes, see Description of region codes in China.
        :param Sequence['DefenseRuleConfigConditionArgs'] conditions: The traffic characteristics of ACL, which are described in JSON format. You can enter up to five matching conditions. For specific configuration information, see detailed configuration of conditions. See `conditions` below.
        :param _builtins.int mode: The HTTP flood protection mode. Valid values:
               - 0 (default): indicates normal protection.
               - 1: indicates emergency protection.
        :param _builtins.str protocol: The protocol type of the cached page address. Valid values: http, https.
        :param 'DefenseRuleConfigRateLimitArgs' rate_limit: The detailed speed limit configuration, which is described in the JSON string format. This information is configured only when CcStatus is set to 1. For specific configuration information, see detailed configuration of Ratelimit. See `rate_limit` below.
        :param Sequence[_builtins.str] remote_addrs: The IP addresses that you want to add to the blacklist. Specify the value of this parameter in the ["ip1","ip2",...] format.
        :param _builtins.str rule_action: Protection rule action. Value:
               - block: Indicates an intercept.
               - monitor: indicates observation.
               - js: indicates JS validation.
               - captcha: Indicates a slider.
               - captcha_strict: indicates a strict slider.
               - filter: filters sensitive information. This action applies only to scenarios that the Information leakage prevention rule include sensitive information match conditions.
               
               > **NOTE:**  For the supported protection rule actions, follow the rule actions displayed in the WAF console.
        :param _builtins.int throttle_threhold: The throttling threshold. Valid values:
               - The QPS throttling threshold ranges from 1 to 5000000. If you select QPS throttling (such as 500 QPS), traffic that meets the throttling conditions and exceeds 500 QPS will be blocked.
               - The percentage throttling threshold ranges from 1 to 99. If you select percentage throttling (such as 80%), only 80% of the traffic that meets the throttling conditions will be allowed.
        :param _builtins.str throttle_type: The throttling method. Valid values:
               - qps: indicates throttling based on queries per second (QPS).
               - ratio (default): indicates throttling based on percentage.
        :param _builtins.str ua: The User-Agent string that is allowed for access to the address.
        :param _builtins.str url: The address of the cached page.
        """
        if abroad_regions is not None:
            pulumi.set(__self__, "abroad_regions", abroad_regions)
        if account_identifiers is not None:
            pulumi.set(__self__, "account_identifiers", account_identifiers)
        if bypass_regular_rules is not None:
            pulumi.set(__self__, "bypass_regular_rules", bypass_regular_rules)
        if bypass_regular_types is not None:
            pulumi.set(__self__, "bypass_regular_types", bypass_regular_types)
        if bypass_tags is not None:
            pulumi.set(__self__, "bypass_tags", bypass_tags)
        if cc_effect is not None:
            pulumi.set(__self__, "cc_effect", cc_effect)
        if cc_status is not None:
            pulumi.set(__self__, "cc_status", cc_status)
        if cn_regions is not None:
            pulumi.set(__self__, "cn_regions", cn_regions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if remote_addrs is not None:
            pulumi.set(__self__, "remote_addrs", remote_addrs)
        if rule_action is not None:
            pulumi.set(__self__, "rule_action", rule_action)
        if throttle_threhold is not None:
            pulumi.set(__self__, "throttle_threhold", throttle_threhold)
        if throttle_type is not None:
            pulumi.set(__self__, "throttle_type", throttle_type)
        if ua is not None:
            pulumi.set(__self__, "ua", ua)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="abroadRegions")
    def abroad_regions(self) -> Optional[_builtins.str]:
        """
        The regions outside China from which you want to block requests. Separate multiple region codes with commas (,). You can call the DescribeIpAbroadCountryInfos operation to query the countries and regions outside China that can be blocked.
        """
        return pulumi.get(self, "abroad_regions")

    @_builtins.property
    @pulumi.getter(name="accountIdentifiers")
    def account_identifiers(self) -> Optional[Sequence['outputs.DefenseRuleConfigAccountIdentifier']]:
        """
        The policies for account extraction. Up to five policies are supported. Each policy is a JSON string. For more information, see accountIdentifiers description. See `account_identifiers` below.
        """
        return pulumi.get(self, "account_identifiers")

    @_builtins.property
    @pulumi.getter(name="bypassRegularRules")
    def bypass_regular_rules(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of regular rule IDs that are not detected. The value is in the ["XX1", "XX2",...] format. This parameter is required only when the module to which the whitelist applies is set to specific regular rules in basic protection (BypassTags is set to regular_rule).
        """
        return pulumi.get(self, "bypass_regular_rules")

    @_builtins.property
    @pulumi.getter(name="bypassRegularTypes")
    def bypass_regular_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The regular rule type is not detected. This parameter is configured only when the whitelist module is configured as the Web application regular type (the value of the BypassTags parameter is regular_type). Value:
        - sqli: Indicates SQL injection.
        - xss: Indicates cross-site scripting (XSS).
        - cmdi: Indicates OS command injection.
        - expression_injection: Indicates expression injection.
        - java_deserialization: indicates Java deserialization.
        - dot_net_deserialization: Represents. net deserialization.
        - php_deserialization: indicates PHP deserialization.
        - code_exec: Indicates code execution.
        - ssrf: indicates SSRF (server-side request forgery).
        - path_traversal: indicates a Path Traversal.
        - arbitrary_file_uploading: Indicates to upload any file.
        - webshell: Represents a webshell.
        - rfilei: Indicates the remote file contains (RFI).
        - lfilei: Indicates that the local file contains (LFI).
        - protocol_violation: indicates a protocol violation.
        - scanner_behavior: Indicates scanner behavior.
        - logic_flaw: Indicates a business logic defect.
        - arbitrary_file_reading: Indicates arbitrary file reading.
        - arbitrary_file_download: Indicates an arbitrary file download.
        - xxe: Indicates external entity injection.
        - csrf: indicates cross-site request forgery.
        - crlf: indicates CRLF.
        - other: indicates other.
        """
        return pulumi.get(self, "bypass_regular_types")

    @_builtins.property
    @pulumi.getter(name="bypassTags")
    def bypass_tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        The modules to which the whitelist applies. The value is in the ["XX1", "XX2",...] format. Valid values:
        - waf: indicates all modules.
        - customrule: indicates custom rules.
        - blacklist: indicates IP blacklist.
        - antiscan: indicates scan protection.
        - regular: indicates basic protection rules.
        - regular_rule: indicates specific regular rules in basic protection.
        - regular_type: indicates specific regular rule types in basic protection.
        - major_protection: indicates major event support protection.
        - cc: indicates CC protection.
        - region_block: indicates Location Blacklist.
        - antibot_scene: indicates BOT scenario protection.
        - dlp: indicates information leakage prevention.
        - tamperproof: indicates web tamper-proofing.
        - spike_throttle: indicates peak traffic throttling.
        """
        return pulumi.get(self, "bypass_tags")

    @_builtins.property
    @pulumi.getter(name="ccEffect")
    def cc_effect(self) -> Optional[_builtins.str]:
        """
        Set the effective range of the speed limit. This information is configured only when ccStatus is set to 1. Value:
        - service: indicates that the effective object is a protected object.
        - rule: indicates that the effective object is a single rule.
        """
        return pulumi.get(self, "cc_effect")

    @_builtins.property
    @pulumi.getter(name="ccStatus")
    def cc_status(self) -> Optional[_builtins.int]:
        """
        Whether to open the speed limit. Value:
        - 0: indicates that the speed limit is off.
        - 1: Indicates that the speed limit is on.
        """
        return pulumi.get(self, "cc_status")

    @_builtins.property
    @pulumi.getter(name="cnRegions")
    def cn_regions(self) -> Optional[_builtins.str]:
        """
        The regions in China from which you want to block requests. If you specify "CN", requests from the Chinese mainland (excluding Hong Kong, Macao, and Taiwan) are blocked. Separate multiple regions with commas (,). For more information about region codes, see Description of region codes in China.
        """
        return pulumi.get(self, "cn_regions")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DefenseRuleConfigCondition']]:
        """
        The traffic characteristics of ACL, which are described in JSON format. You can enter up to five matching conditions. For specific configuration information, see detailed configuration of conditions. See `conditions` below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        The HTTP flood protection mode. Valid values:
        - 0 (default): indicates normal protection.
        - 1: indicates emergency protection.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol type of the cached page address. Valid values: http, https.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional['outputs.DefenseRuleConfigRateLimit']:
        """
        The detailed speed limit configuration, which is described in the JSON string format. This information is configured only when CcStatus is set to 1. For specific configuration information, see detailed configuration of Ratelimit. See `rate_limit` below.
        """
        return pulumi.get(self, "rate_limit")

    @_builtins.property
    @pulumi.getter(name="remoteAddrs")
    def remote_addrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        The IP addresses that you want to add to the blacklist. Specify the value of this parameter in the ["ip1","ip2",...] format.
        """
        return pulumi.get(self, "remote_addrs")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> Optional[_builtins.str]:
        """
        Protection rule action. Value:
        - block: Indicates an intercept.
        - monitor: indicates observation.
        - js: indicates JS validation.
        - captcha: Indicates a slider.
        - captcha_strict: indicates a strict slider.
        - filter: filters sensitive information. This action applies only to scenarios that the Information leakage prevention rule include sensitive information match conditions.

        > **NOTE:**  For the supported protection rule actions, follow the rule actions displayed in the WAF console.
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="throttleThrehold")
    def throttle_threhold(self) -> Optional[_builtins.int]:
        """
        The throttling threshold. Valid values:
        - The QPS throttling threshold ranges from 1 to 5000000. If you select QPS throttling (such as 500 QPS), traffic that meets the throttling conditions and exceeds 500 QPS will be blocked.
        - The percentage throttling threshold ranges from 1 to 99. If you select percentage throttling (such as 80%), only 80% of the traffic that meets the throttling conditions will be allowed.
        """
        return pulumi.get(self, "throttle_threhold")

    @_builtins.property
    @pulumi.getter(name="throttleType")
    def throttle_type(self) -> Optional[_builtins.str]:
        """
        The throttling method. Valid values:
        - qps: indicates throttling based on queries per second (QPS).
        - ratio (default): indicates throttling based on percentage.
        """
        return pulumi.get(self, "throttle_type")

    @_builtins.property
    @pulumi.getter
    def ua(self) -> Optional[_builtins.str]:
        """
        The User-Agent string that is allowed for access to the address.
        """
        return pulumi.get(self, "ua")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        The address of the cached page.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DefenseRuleConfigAccountIdentifier(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "decodeType":
            suggest = "decode_type"
        elif key == "subKey":
            suggest = "sub_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenseRuleConfigAccountIdentifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenseRuleConfigAccountIdentifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenseRuleConfigAccountIdentifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decode_type: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 position: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 sub_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str decode_type: The authentication mode. Valid values:
               - plain: indicates plaintext.
               - basic: indicates Basic authentication.
               - jwt: indicates JWT authentication. For JWT authentication, you must specify the field that stores the decoded account information (position).
        :param _builtins.str key: Match field. Valid values: URL, URLPath, IP, Referer, User-Agent, Params, Cookie, Content-Type, Content-Length, X-Forwarded-For, Post-Body, Http-Method, Header, Host, HttpCode, and SensitiveInfo.
               
               > **NOTE:**  Support for matching fields is based on the display in the WAF console. HttpCode and SensitiveInfo are the matching fields supported by the information leakage prevention rule (dlp).
        :param _builtins.str position: The field that stores the decoded account information.
        :param _builtins.int priority: The priority of the current extraction configuration. Each traffic can match at most one extraction policy. Valid values: [0,20]. A smaller value indicates a higher priority. The priority value must be unique.
        :param _builtins.str sub_key: The characteristics of the statistical object. When the Target parameter is set to cookie, header, or queryarg, you must specify the corresponding information in the Subkey parameter.
        """
        if decode_type is not None:
            pulumi.set(__self__, "decode_type", decode_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if sub_key is not None:
            pulumi.set(__self__, "sub_key", sub_key)

    @_builtins.property
    @pulumi.getter(name="decodeType")
    def decode_type(self) -> Optional[_builtins.str]:
        """
        The authentication mode. Valid values:
        - plain: indicates plaintext.
        - basic: indicates Basic authentication.
        - jwt: indicates JWT authentication. For JWT authentication, you must specify the field that stores the decoded account information (position).
        """
        return pulumi.get(self, "decode_type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Match field. Valid values: URL, URLPath, IP, Referer, User-Agent, Params, Cookie, Content-Type, Content-Length, X-Forwarded-For, Post-Body, Http-Method, Header, Host, HttpCode, and SensitiveInfo.

        > **NOTE:**  Support for matching fields is based on the display in the WAF console. HttpCode and SensitiveInfo are the matching fields supported by the information leakage prevention rule (dlp).
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[_builtins.str]:
        """
        The field that stores the decoded account information.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority of the current extraction configuration. Each traffic can match at most one extraction policy. Valid values: [0,20]. A smaller value indicates a higher priority. The priority value must be unique.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="subKey")
    def sub_key(self) -> Optional[_builtins.str]:
        """
        The characteristics of the statistical object. When the Target parameter is set to cookie, header, or queryarg, you must specify the corresponding information in the Subkey parameter.
        """
        return pulumi.get(self, "sub_key")


@pulumi.output_type
class DefenseRuleConfigCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "opValue":
            suggest = "op_value"
        elif key == "subKey":
            suggest = "sub_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenseRuleConfigCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenseRuleConfigCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenseRuleConfigCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 op_value: Optional[_builtins.str] = None,
                 sub_key: Optional[_builtins.str] = None,
                 values: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Match field. Valid values: URL, URLPath, IP, Referer, User-Agent, Params, Cookie, Content-Type, Content-Length, X-Forwarded-For, Post-Body, Http-Method, Header, Host, HttpCode, and SensitiveInfo.
               
               > **NOTE:**  Support for matching fields is based on the display in the WAF console. HttpCode and SensitiveInfo are the matching fields supported by the information leakage prevention rule (dlp).
        :param _builtins.str op_value: Logical character. Value:
               - not-contain: does not contain.
               - contain: Indicates to contain.
               - none: It does not exist.
               - ne: means not equal.
               - eq: means equal.
               - lt: indicates that the value is less.
               - gt: indicates that the value is greater.
               - len-lt: indicates that the length is less.
               - len-eq: indicates that the length is equal.
               - len-gt: indicates that the length is greater.
               - not-match: indicates a mismatch.
               - match-one: means equal to one of the multiple values.
               - all-not-match: means not equal to any value.
               - all-not-contain: does not contain any value.
               - contain-one: Indicates that one of the multiple values is contained.
               - not-regex: Indicates a regular mismatch.
               - regex: Indicates a regular match.
               - all-not-regex: indicates that the regular expressions do not match.
               - regex-one: Represents a regular match for one of them.
               - prefix-match: Indicates a prefix match.
               - suffix-match: indicates a suffix match.
               - mpty: Indicates that the content is empty.
               - exists: Indicates that the field exists.
               - inl: indicates in the list.
               
               > **NOTE:**  Not all logical characters (opvalues) can be configured for the match field (key) of each custom rule. For the logical characters supported by different matching fields, please refer to the association relationship between the matching fields and the logical characters in the custom rules of the WAF console.
        :param _builtins.str sub_key: The characteristics of the statistical object. When the Target parameter is set to cookie, header, or queryarg, you must specify the corresponding information in the Subkey parameter.
        :param _builtins.str values: Match the content and fill in the corresponding content as needed.
               
               > **NOTE:**  The value range of the logical (opValue) and matching content (values) parameters in the matching condition parameter is related to the specified matching field (key).
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if op_value is not None:
            pulumi.set(__self__, "op_value", op_value)
        if sub_key is not None:
            pulumi.set(__self__, "sub_key", sub_key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Match field. Valid values: URL, URLPath, IP, Referer, User-Agent, Params, Cookie, Content-Type, Content-Length, X-Forwarded-For, Post-Body, Http-Method, Header, Host, HttpCode, and SensitiveInfo.

        > **NOTE:**  Support for matching fields is based on the display in the WAF console. HttpCode and SensitiveInfo are the matching fields supported by the information leakage prevention rule (dlp).
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="opValue")
    def op_value(self) -> Optional[_builtins.str]:
        """
        Logical character. Value:
        - not-contain: does not contain.
        - contain: Indicates to contain.
        - none: It does not exist.
        - ne: means not equal.
        - eq: means equal.
        - lt: indicates that the value is less.
        - gt: indicates that the value is greater.
        - len-lt: indicates that the length is less.
        - len-eq: indicates that the length is equal.
        - len-gt: indicates that the length is greater.
        - not-match: indicates a mismatch.
        - match-one: means equal to one of the multiple values.
        - all-not-match: means not equal to any value.
        - all-not-contain: does not contain any value.
        - contain-one: Indicates that one of the multiple values is contained.
        - not-regex: Indicates a regular mismatch.
        - regex: Indicates a regular match.
        - all-not-regex: indicates that the regular expressions do not match.
        - regex-one: Represents a regular match for one of them.
        - prefix-match: Indicates a prefix match.
        - suffix-match: indicates a suffix match.
        - mpty: Indicates that the content is empty.
        - exists: Indicates that the field exists.
        - inl: indicates in the list.

        > **NOTE:**  Not all logical characters (opvalues) can be configured for the match field (key) of each custom rule. For the logical characters supported by different matching fields, please refer to the association relationship between the matching fields and the logical characters in the custom rules of the WAF console.
        """
        return pulumi.get(self, "op_value")

    @_builtins.property
    @pulumi.getter(name="subKey")
    def sub_key(self) -> Optional[_builtins.str]:
        """
        The characteristics of the statistical object. When the Target parameter is set to cookie, header, or queryarg, you must specify the corresponding information in the Subkey parameter.
        """
        return pulumi.get(self, "sub_key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[_builtins.str]:
        """
        Match the content and fill in the corresponding content as needed.

        > **NOTE:**  The value range of the logical (opValue) and matching content (values) parameters in the matching condition parameter is related to the specified matching field (key).
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DefenseRuleConfigRateLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subKey":
            suggest = "sub_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenseRuleConfigRateLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenseRuleConfigRateLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenseRuleConfigRateLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: Optional[_builtins.int] = None,
                 status: Optional['outputs.DefenseRuleConfigRateLimitStatus'] = None,
                 sub_key: Optional[_builtins.str] = None,
                 target: Optional[_builtins.str] = None,
                 threshold: Optional[_builtins.int] = None,
                 ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.int interval: The statistical period, in seconds. This parameter specifies the period during which access counts are collected, and works with the Threshold parameter.
               Valid values: 1 to 1800 seconds.
        :param 'DefenseRuleConfigRateLimitStatusArgs' status: Response code frequency setting. The description is in the JSON string format. See `status` below.
        :param _builtins.str sub_key: The characteristics of the statistical object. When the Target parameter is set to cookie, header, or queryarg, you must specify the corresponding information in the Subkey parameter.
        :param _builtins.str target: The type of the statistical object. Valid values:
               - remote_addr (default): indicates IP.
               - cookie.acw_tc: indicates session.
               - header: indicates custom header. If you use custom headers, you must specify the headers in subkey.
               - queryarg: indicates custom parameters. If you use custom parameters, you must specify the parameters in subkey.
               - cookie: indicates custom cookies. If you use custom cookies, you must specify the cookies in subkey.
        :param _builtins.int threshold: The maximum number of requests that can be sent from a statistical object.
        :param _builtins.int ttl: The period of time during which you want the specified action to be valid. Unit: seconds.
               Valid values: 60 to 86400.
        """
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_key is not None:
            pulumi.set(__self__, "sub_key", sub_key)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        The statistical period, in seconds. This parameter specifies the period during which access counts are collected, and works with the Threshold parameter.
        Valid values: 1 to 1800 seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.DefenseRuleConfigRateLimitStatus']:
        """
        Response code frequency setting. The description is in the JSON string format. See `status` below.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subKey")
    def sub_key(self) -> Optional[_builtins.str]:
        """
        The characteristics of the statistical object. When the Target parameter is set to cookie, header, or queryarg, you must specify the corresponding information in the Subkey parameter.
        """
        return pulumi.get(self, "sub_key")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        The type of the statistical object. Valid values:
        - remote_addr (default): indicates IP.
        - cookie.acw_tc: indicates session.
        - header: indicates custom header. If you use custom headers, you must specify the headers in subkey.
        - queryarg: indicates custom parameters. If you use custom parameters, you must specify the parameters in subkey.
        - cookie: indicates custom cookies. If you use custom cookies, you must specify the cookies in subkey.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[_builtins.int]:
        """
        The maximum number of requests that can be sent from a statistical object.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        The period of time during which you want the specified action to be valid. Unit: seconds.
        Valid values: 60 to 86400.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class DefenseRuleConfigRateLimitStatus(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 count: Optional[_builtins.int] = None,
                 ratio: Optional[_builtins.int] = None):
        """
        :param _builtins.int code: Required. Specifies the response code.
        :param _builtins.int count: The threshold for the number of occurrences. When the number of occurrences of the specified HTTP status code exceeds this threshold, the protection rule is triggered. Valid values: 2 to 50000. You can specify Count or Ratio. You cannot specify the two parameters at the same time.
        :param _builtins.int ratio: The threshold for the proportion of occurrences (percentage). When the proportion of occurrences of the specified HTTP status code exceeds this threshold, the protection rule is triggered. Valid values: 1 to 100. You can specify Count or Ratio. You cannot specify the two parameters at the same time.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        Required. Specifies the response code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The threshold for the number of occurrences. When the number of occurrences of the specified HTTP status code exceeds this threshold, the protection rule is triggered. Valid values: 2 to 50000. You can specify Count or Ratio. You cannot specify the two parameters at the same time.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[_builtins.int]:
        """
        The threshold for the proportion of occurrences (percentage). When the proportion of occurrences of the specified HTTP status code exceeds this threshold, the protection rule is triggered. Valid values: 1 to 100. You can specify Count or Ratio. You cannot specify the two parameters at the same time.
        """
        return pulumi.get(self, "ratio")


@pulumi.output_type
class DomainListen(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certId":
            suggest = "cert_id"
        elif key == "cipherSuite":
            suggest = "cipher_suite"
        elif key == "customCiphers":
            suggest = "custom_ciphers"
        elif key == "enableTlsv3":
            suggest = "enable_tlsv3"
        elif key == "exclusiveIp":
            suggest = "exclusive_ip"
        elif key == "focusHttps":
            suggest = "focus_https"
        elif key == "http2Enabled":
            suggest = "http2_enabled"
        elif key == "httpPorts":
            suggest = "http_ports"
        elif key == "httpsPorts":
            suggest = "https_ports"
        elif key == "ipv6Enabled":
            suggest = "ipv6_enabled"
        elif key == "protectionResource":
            suggest = "protection_resource"
        elif key == "sm2AccessOnly":
            suggest = "sm2_access_only"
        elif key == "sm2CertId":
            suggest = "sm2_cert_id"
        elif key == "sm2Enabled":
            suggest = "sm2_enabled"
        elif key == "tlsVersion":
            suggest = "tls_version"
        elif key == "xffHeaderMode":
            suggest = "xff_header_mode"
        elif key == "xffHeaders":
            suggest = "xff_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainListen. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainListen.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainListen.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_id: Optional[_builtins.str] = None,
                 cipher_suite: Optional[_builtins.int] = None,
                 custom_ciphers: Optional[Sequence[_builtins.str]] = None,
                 enable_tlsv3: Optional[_builtins.bool] = None,
                 exclusive_ip: Optional[_builtins.bool] = None,
                 focus_https: Optional[_builtins.bool] = None,
                 http2_enabled: Optional[_builtins.bool] = None,
                 http_ports: Optional[Sequence[_builtins.int]] = None,
                 https_ports: Optional[Sequence[_builtins.int]] = None,
                 ipv6_enabled: Optional[_builtins.bool] = None,
                 protection_resource: Optional[_builtins.str] = None,
                 sm2_access_only: Optional[_builtins.bool] = None,
                 sm2_cert_id: Optional[_builtins.str] = None,
                 sm2_enabled: Optional[_builtins.bool] = None,
                 tls_version: Optional[_builtins.str] = None,
                 xff_header_mode: Optional[_builtins.int] = None,
                 xff_headers: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str cert_id: The ID of the certificate to be added. This parameter is used only if the value of `HttpsPorts` is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.int cipher_suite: The type of the cipher suites that you want to add. This parameter is available only if you specify `HttpsPorts`. Valid values:
        :param Sequence[_builtins.str] custom_ciphers: The specific custom encryption suite to add.
        :param _builtins.bool enable_tlsv3: Whether TSL1.3 version is supported. This parameter is used only if the value of `HttpsPorts` is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        :param _builtins.bool exclusive_ip: Specifies whether to enable the exclusive IP address feature. This parameter is available only if you set `IPv6Enabled` to false and `ProtectionResource` to `share`. Valid values:
        :param _builtins.bool focus_https: Specifies whether to enable force redirect from HTTP to HTTPS for received requests. This parameter is available only if you specify `HttpsPorts` and leave `HttpPorts` empty. Valid values:
        :param _builtins.bool http2_enabled: Specifies whether to enable HTTP/2. This parameter is available only if you specify `HttpsPorts`. Valid values:
        :param Sequence[_builtins.int] http_ports: The HTTP listener ports. Specify the value in the \\[**port1,port2,...**] format.
        :param Sequence[_builtins.int] https_ports: The HTTPS listener ports. Specify the value in the \\[**port1,port2,...**] format.
        :param _builtins.bool ipv6_enabled: Specifies whether to enable IPv6 protection. Valid values:
        :param _builtins.str protection_resource: The type of the protection resource. Valid values:
        :param _builtins.bool sm2_access_only: Specifies whether to allow access only from SM certificate-based clients. This parameter is available only if you set SM2Enabled to true.
               
               - true
               - false
        :param _builtins.str sm2_cert_id: The ID of the SM certificate that you want to add. This parameter is available only if you set SM2Enabled to true.
        :param _builtins.bool sm2_enabled: Specifies whether to add an SM certificate.
        :param _builtins.str tls_version: The version of TLS to add. This parameter is used only if the value of `HttpsPorts` is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        :param _builtins.int xff_header_mode: The method that is used to obtain the originating IP address of a client. Valid values:
        :param Sequence[_builtins.str] xff_headers: The custom header fields that are used to obtain the originating IP address of a client. Specify the value in the **\\["header1","header2",...]** format.
               
               > **NOTE:**   This parameter is required only if you set `XffHeaderMode` to 2.
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cipher_suite is not None:
            pulumi.set(__self__, "cipher_suite", cipher_suite)
        if custom_ciphers is not None:
            pulumi.set(__self__, "custom_ciphers", custom_ciphers)
        if enable_tlsv3 is not None:
            pulumi.set(__self__, "enable_tlsv3", enable_tlsv3)
        if exclusive_ip is not None:
            pulumi.set(__self__, "exclusive_ip", exclusive_ip)
        if focus_https is not None:
            pulumi.set(__self__, "focus_https", focus_https)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)
        if https_ports is not None:
            pulumi.set(__self__, "https_ports", https_ports)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if protection_resource is not None:
            pulumi.set(__self__, "protection_resource", protection_resource)
        if sm2_access_only is not None:
            pulumi.set(__self__, "sm2_access_only", sm2_access_only)
        if sm2_cert_id is not None:
            pulumi.set(__self__, "sm2_cert_id", sm2_cert_id)
        if sm2_enabled is not None:
            pulumi.set(__self__, "sm2_enabled", sm2_enabled)
        if tls_version is not None:
            pulumi.set(__self__, "tls_version", tls_version)
        if xff_header_mode is not None:
            pulumi.set(__self__, "xff_header_mode", xff_header_mode)
        if xff_headers is not None:
            pulumi.set(__self__, "xff_headers", xff_headers)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[_builtins.str]:
        """
        The ID of the certificate to be added. This parameter is used only if the value of `HttpsPorts` is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cert_id")

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> Optional[_builtins.int]:
        """
        The type of the cipher suites that you want to add. This parameter is available only if you specify `HttpsPorts`. Valid values:
        """
        return pulumi.get(self, "cipher_suite")

    @_builtins.property
    @pulumi.getter(name="customCiphers")
    def custom_ciphers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The specific custom encryption suite to add.
        """
        return pulumi.get(self, "custom_ciphers")

    @_builtins.property
    @pulumi.getter(name="enableTlsv3")
    def enable_tlsv3(self) -> Optional[_builtins.bool]:
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of `HttpsPorts` is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        """
        return pulumi.get(self, "enable_tlsv3")

    @_builtins.property
    @pulumi.getter(name="exclusiveIp")
    def exclusive_ip(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the exclusive IP address feature. This parameter is available only if you set `IPv6Enabled` to false and `ProtectionResource` to `share`. Valid values:
        """
        return pulumi.get(self, "exclusive_ip")

    @_builtins.property
    @pulumi.getter(name="focusHttps")
    def focus_https(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable force redirect from HTTP to HTTPS for received requests. This parameter is available only if you specify `HttpsPorts` and leave `HttpPorts` empty. Valid values:
        """
        return pulumi.get(self, "focus_https")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable HTTP/2. This parameter is available only if you specify `HttpsPorts`. Valid values:
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        The HTTP listener ports. Specify the value in the \\[**port1,port2,...**] format.
        """
        return pulumi.get(self, "http_ports")

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        The HTTPS listener ports. Specify the value in the \\[**port1,port2,...**] format.
        """
        return pulumi.get(self, "https_ports")

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable IPv6 protection. Valid values:
        """
        return pulumi.get(self, "ipv6_enabled")

    @_builtins.property
    @pulumi.getter(name="protectionResource")
    def protection_resource(self) -> Optional[_builtins.str]:
        """
        The type of the protection resource. Valid values:
        """
        return pulumi.get(self, "protection_resource")

    @_builtins.property
    @pulumi.getter(name="sm2AccessOnly")
    def sm2_access_only(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to allow access only from SM certificate-based clients. This parameter is available only if you set SM2Enabled to true.

        - true
        - false
        """
        return pulumi.get(self, "sm2_access_only")

    @_builtins.property
    @pulumi.getter(name="sm2CertId")
    def sm2_cert_id(self) -> Optional[_builtins.str]:
        """
        The ID of the SM certificate that you want to add. This parameter is available only if you set SM2Enabled to true.
        """
        return pulumi.get(self, "sm2_cert_id")

    @_builtins.property
    @pulumi.getter(name="sm2Enabled")
    def sm2_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to add an SM certificate.
        """
        return pulumi.get(self, "sm2_enabled")

    @_builtins.property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> Optional[_builtins.str]:
        """
        The version of TLS to add. This parameter is used only if the value of `HttpsPorts` is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        """
        return pulumi.get(self, "tls_version")

    @_builtins.property
    @pulumi.getter(name="xffHeaderMode")
    def xff_header_mode(self) -> Optional[_builtins.int]:
        """
        The method that is used to obtain the originating IP address of a client. Valid values:
        """
        return pulumi.get(self, "xff_header_mode")

    @_builtins.property
    @pulumi.getter(name="xffHeaders")
    def xff_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The custom header fields that are used to obtain the originating IP address of a client. Specify the value in the **\\["header1","header2",...]** format.

        > **NOTE:**   This parameter is required only if you set `XffHeaderMode` to 2.
        """
        return pulumi.get(self, "xff_headers")


@pulumi.output_type
class DomainRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupBackends":
            suggest = "backup_backends"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "focusHttpBackend":
            suggest = "focus_http_backend"
        elif key == "keepaliveRequests":
            suggest = "keepalive_requests"
        elif key == "keepaliveTimeout":
            suggest = "keepalive_timeout"
        elif key == "readTimeout":
            suggest = "read_timeout"
        elif key == "requestHeaders":
            suggest = "request_headers"
        elif key == "sniEnabled":
            suggest = "sni_enabled"
        elif key == "sniHost":
            suggest = "sni_host"
        elif key == "writeTimeout":
            suggest = "write_timeout"
        elif key == "xffProto":
            suggest = "xff_proto"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loadbalance: _builtins.str,
                 backends: Optional[Sequence[_builtins.str]] = None,
                 backup_backends: Optional[Sequence[_builtins.str]] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 focus_http_backend: Optional[_builtins.bool] = None,
                 keepalive: Optional[_builtins.bool] = None,
                 keepalive_requests: Optional[_builtins.int] = None,
                 keepalive_timeout: Optional[_builtins.int] = None,
                 read_timeout: Optional[_builtins.int] = None,
                 request_headers: Optional[Sequence['outputs.DomainRedirectRequestHeader']] = None,
                 retry: Optional[_builtins.bool] = None,
                 sni_enabled: Optional[_builtins.bool] = None,
                 sni_host: Optional[_builtins.str] = None,
                 write_timeout: Optional[_builtins.int] = None,
                 xff_proto: Optional[_builtins.bool] = None):
        """
        :param _builtins.str loadbalance: The load balancing algorithm that you want to use to forward requests to the origin server. Valid values:
        :param Sequence[_builtins.str] backends: The IP addresses or domain names of the origin server. You cannot specify both IP addresses and domain names. If you specify domain names, the domain names can be resolved only to IPv4 addresses.
               
               - If you specify IP addresses, specify the value in the **\\["ip1","ip2",...]** format. You can enter up to 20 IP addresses.
               - If you specify domain names, specify the value in the **\\["domain"]** format. You can enter up to 20 domain names.
        :param Sequence[_builtins.str] backup_backends: The secondary IP address or domain name of the origin server.
        :param _builtins.int connect_timeout: Connection timeout duration. Unit: seconds.
               Value range: 1~3600. Default value: 5.
        :param _builtins.bool focus_http_backend: Specifies whether to enable force redirect from HTTPS to HTTP for back-to-origin requests. This parameter is available only if you specify `HttpsPorts`. Valid values:
        :param _builtins.bool keepalive: Specifies whether to enable the persistent connection feature. Valid values:
        :param _builtins.int keepalive_requests: The number of reused persistent connections. Valid values: 60 to 1000. Default value: 1000
               
               
               > **NOTE:**   This parameter specifies the number of persistent connections that can be reused after you enable the persistent connection feature.
        :param _builtins.int keepalive_timeout: Idle long connection timeout, value range: 1~60, default 15, unit: seconds.
               
               > **NOTE:**  How long the multiplexed long connection is idle and then released.
        :param _builtins.int read_timeout: The timeout period of write connections. Unit: seconds. Valid values: 1 to 3600. Default value: 120.
        :param Sequence['DomainRedirectRequestHeaderArgs'] request_headers: The traffic marking field and value of the domain name, which is used to mark the traffic processed by WAF.
               By specifying custom request header fields and corresponding values, when the access traffic of the domain name passes through WAF, WAF automatically adds the set custom field value to the request header as a traffic mark, which facilitates the statistics of back-end services. See `request_headers` below.
        :param _builtins.bool retry: Specifies whether WAF retries if WAF fails to forward requests to the origin server. Valid values:
        :param _builtins.bool sni_enabled: Specifies whether to enable the Server Name Indication (SNI) feature for back-to-origin requests. This parameter is available only if you specify `HttpsPorts`. Valid values:
        :param _builtins.str sni_host: The custom value of the SNI field. If you do not specify this parameter, the value of the `Host` header field is automatically used. In most cases, you do not need to specify a custom value for the SNI field. However, if you want WAF to use an SNI field whose value is different from the value of the Host header field in back-to-origin requests, you can specify a custom value for the SNI field.
               
               > **NOTE:**   This parameter is required only if you set `SniEnabled` to true.
        :param _builtins.int write_timeout: The timeout period of write connections. Unit: seconds. Valid values: 1 to 3600. Default value: 120.
        :param _builtins.bool xff_proto: Specifies whether to use the X-Forward-For-Proto header field to pass the protocol used by WAF to forward requests to the origin server. Valid values:
        """
        pulumi.set(__self__, "loadbalance", loadbalance)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if backup_backends is not None:
            pulumi.set(__self__, "backup_backends", backup_backends)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if focus_http_backend is not None:
            pulumi.set(__self__, "focus_http_backend", focus_http_backend)
        if keepalive is not None:
            pulumi.set(__self__, "keepalive", keepalive)
        if keepalive_requests is not None:
            pulumi.set(__self__, "keepalive_requests", keepalive_requests)
        if keepalive_timeout is not None:
            pulumi.set(__self__, "keepalive_timeout", keepalive_timeout)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sni_enabled is not None:
            pulumi.set(__self__, "sni_enabled", sni_enabled)
        if sni_host is not None:
            pulumi.set(__self__, "sni_host", sni_host)
        if write_timeout is not None:
            pulumi.set(__self__, "write_timeout", write_timeout)
        if xff_proto is not None:
            pulumi.set(__self__, "xff_proto", xff_proto)

    @_builtins.property
    @pulumi.getter
    def loadbalance(self) -> _builtins.str:
        """
        The load balancing algorithm that you want to use to forward requests to the origin server. Valid values:
        """
        return pulumi.get(self, "loadbalance")

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[Sequence[_builtins.str]]:
        """
        The IP addresses or domain names of the origin server. You cannot specify both IP addresses and domain names. If you specify domain names, the domain names can be resolved only to IPv4 addresses.

        - If you specify IP addresses, specify the value in the **\\["ip1","ip2",...]** format. You can enter up to 20 IP addresses.
        - If you specify domain names, specify the value in the **\\["domain"]** format. You can enter up to 20 domain names.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="backupBackends")
    def backup_backends(self) -> Optional[Sequence[_builtins.str]]:
        """
        The secondary IP address or domain name of the origin server.
        """
        return pulumi.get(self, "backup_backends")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        Connection timeout duration. Unit: seconds.
        Value range: 1~3600. Default value: 5.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="focusHttpBackend")
    def focus_http_backend(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable force redirect from HTTPS to HTTP for back-to-origin requests. This parameter is available only if you specify `HttpsPorts`. Valid values:
        """
        return pulumi.get(self, "focus_http_backend")

    @_builtins.property
    @pulumi.getter
    def keepalive(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the persistent connection feature. Valid values:
        """
        return pulumi.get(self, "keepalive")

    @_builtins.property
    @pulumi.getter(name="keepaliveRequests")
    def keepalive_requests(self) -> Optional[_builtins.int]:
        """
        The number of reused persistent connections. Valid values: 60 to 1000. Default value: 1000


        > **NOTE:**   This parameter specifies the number of persistent connections that can be reused after you enable the persistent connection feature.
        """
        return pulumi.get(self, "keepalive_requests")

    @_builtins.property
    @pulumi.getter(name="keepaliveTimeout")
    def keepalive_timeout(self) -> Optional[_builtins.int]:
        """
        Idle long connection timeout, value range: 1~60, default 15, unit: seconds.

        > **NOTE:**  How long the multiplexed long connection is idle and then released.
        """
        return pulumi.get(self, "keepalive_timeout")

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[_builtins.int]:
        """
        The timeout period of write connections. Unit: seconds. Valid values: 1 to 3600. Default value: 120.
        """
        return pulumi.get(self, "read_timeout")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[Sequence['outputs.DomainRedirectRequestHeader']]:
        """
        The traffic marking field and value of the domain name, which is used to mark the traffic processed by WAF.
        By specifying custom request header fields and corresponding values, when the access traffic of the domain name passes through WAF, WAF automatically adds the set custom field value to the request header as a traffic mark, which facilitates the statistics of back-end services. See `request_headers` below.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> Optional[_builtins.bool]:
        """
        Specifies whether WAF retries if WAF fails to forward requests to the origin server. Valid values:
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter(name="sniEnabled")
    def sni_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the Server Name Indication (SNI) feature for back-to-origin requests. This parameter is available only if you specify `HttpsPorts`. Valid values:
        """
        return pulumi.get(self, "sni_enabled")

    @_builtins.property
    @pulumi.getter(name="sniHost")
    def sni_host(self) -> Optional[_builtins.str]:
        """
        The custom value of the SNI field. If you do not specify this parameter, the value of the `Host` header field is automatically used. In most cases, you do not need to specify a custom value for the SNI field. However, if you want WAF to use an SNI field whose value is different from the value of the Host header field in back-to-origin requests, you can specify a custom value for the SNI field.

        > **NOTE:**   This parameter is required only if you set `SniEnabled` to true.
        """
        return pulumi.get(self, "sni_host")

    @_builtins.property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> Optional[_builtins.int]:
        """
        The timeout period of write connections. Unit: seconds. Valid values: 1 to 3600. Default value: 120.
        """
        return pulumi.get(self, "write_timeout")

    @_builtins.property
    @pulumi.getter(name="xffProto")
    def xff_proto(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use the X-Forward-For-Proto header field to pass the protocol used by WAF to forward requests to the origin server. Valid values:
        """
        return pulumi.get(self, "xff_proto")


@pulumi.output_type
class DomainRedirectRequestHeader(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Specified custom request header fields
        :param _builtins.str value: Customize the value of the request header field.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Specified custom request header fields
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Customize the value of the request header field.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 cname: _builtins.str,
                 domain: _builtins.str,
                 id: _builtins.str,
                 listens: Sequence['outputs.GetDomainsDomainListenResult'],
                 redirects: Sequence['outputs.GetDomainsDomainRedirectResult'],
                 resource_manager_resource_group_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str cname: The CNAME assigned by WAF to the domain name.
        :param _builtins.str domain: The name of the domain name to query.
        :param _builtins.str id: The ID of the domain. It formats as `<instance_id>:<domain>`.
        :param Sequence['GetDomainsDomainListenArgs'] listens: Configure listening information
        :param Sequence['GetDomainsDomainRedirectArgs'] redirects: Configure forwarding information.
        :param _builtins.str resource_manager_resource_group_id: The ID of the resource group.
        :param _builtins.str status: The status of the domain.
        """
        pulumi.set(__self__, "cname", cname)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listens", listens)
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "resource_manager_resource_group_id", resource_manager_resource_group_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> _builtins.str:
        """
        The CNAME assigned by WAF to the domain name.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The name of the domain name to query.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the domain. It formats as `<instance_id>:<domain>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def listens(self) -> Sequence['outputs.GetDomainsDomainListenResult']:
        """
        Configure listening information
        """
        return pulumi.get(self, "listens")

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetDomainsDomainRedirectResult']:
        """
        Configure forwarding information.
        """
        return pulumi.get(self, "redirects")

    @_builtins.property
    @pulumi.getter(name="resourceManagerResourceGroupId")
    def resource_manager_resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_manager_resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the domain.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDomainsDomainListenResult(dict):
    def __init__(__self__, *,
                 cert_id: _builtins.str,
                 cipher_suite: _builtins.int,
                 custom_ciphers: Sequence[_builtins.str],
                 enable_tlsv3: _builtins.bool,
                 exclusive_ip: _builtins.bool,
                 focus_https: _builtins.bool,
                 http2_enabled: _builtins.bool,
                 http_ports: Sequence[_builtins.int],
                 https_ports: Sequence[_builtins.int],
                 ipv6_enabled: _builtins.bool,
                 protection_resource: _builtins.str,
                 tls_version: _builtins.str,
                 xff_header_mode: _builtins.int,
                 xff_headers: Sequence[_builtins.str]):
        """
        :param _builtins.str cert_id: The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.int cipher_suite: The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param Sequence[_builtins.str] custom_ciphers: The specific custom encryption suite to add.
        :param _builtins.bool enable_tlsv3: Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.bool exclusive_ip: Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used).
        :param _builtins.bool focus_https: Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol).
        :param _builtins.bool http2_enabled: Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param Sequence[_builtins.int] http_ports: The listening port of the HTTP protocol.
        :param Sequence[_builtins.int] https_ports: The listening port of the HTTPS protocol.
        :param _builtins.bool ipv6_enabled: Whether IPv6 is turned on.
        :param _builtins.str protection_resource: The type of protection resource to use.
        :param _builtins.str tls_version: The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.int xff_header_mode: WAF obtains the real IP address of the client.
        :param Sequence[_builtins.str] xff_headers: Set the list of custom fields used to obtain the client IP address.
        """
        pulumi.set(__self__, "cert_id", cert_id)
        pulumi.set(__self__, "cipher_suite", cipher_suite)
        pulumi.set(__self__, "custom_ciphers", custom_ciphers)
        pulumi.set(__self__, "enable_tlsv3", enable_tlsv3)
        pulumi.set(__self__, "exclusive_ip", exclusive_ip)
        pulumi.set(__self__, "focus_https", focus_https)
        pulumi.set(__self__, "http2_enabled", http2_enabled)
        pulumi.set(__self__, "http_ports", http_ports)
        pulumi.set(__self__, "https_ports", https_ports)
        pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        pulumi.set(__self__, "protection_resource", protection_resource)
        pulumi.set(__self__, "tls_version", tls_version)
        pulumi.set(__self__, "xff_header_mode", xff_header_mode)
        pulumi.set(__self__, "xff_headers", xff_headers)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> _builtins.str:
        """
        The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cert_id")

    @_builtins.property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> _builtins.int:
        """
        The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cipher_suite")

    @_builtins.property
    @pulumi.getter(name="customCiphers")
    def custom_ciphers(self) -> Sequence[_builtins.str]:
        """
        The specific custom encryption suite to add.
        """
        return pulumi.get(self, "custom_ciphers")

    @_builtins.property
    @pulumi.getter(name="enableTlsv3")
    def enable_tlsv3(self) -> _builtins.bool:
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "enable_tlsv3")

    @_builtins.property
    @pulumi.getter(name="exclusiveIp")
    def exclusive_ip(self) -> _builtins.bool:
        """
        Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used).
        """
        return pulumi.get(self, "exclusive_ip")

    @_builtins.property
    @pulumi.getter(name="focusHttps")
    def focus_https(self) -> _builtins.bool:
        """
        Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol).
        """
        return pulumi.get(self, "focus_https")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> _builtins.bool:
        """
        Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Sequence[_builtins.int]:
        """
        The listening port of the HTTP protocol.
        """
        return pulumi.get(self, "http_ports")

    @_builtins.property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Sequence[_builtins.int]:
        """
        The listening port of the HTTPS protocol.
        """
        return pulumi.get(self, "https_ports")

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> _builtins.bool:
        """
        Whether IPv6 is turned on.
        """
        return pulumi.get(self, "ipv6_enabled")

    @_builtins.property
    @pulumi.getter(name="protectionResource")
    def protection_resource(self) -> _builtins.str:
        """
        The type of protection resource to use.
        """
        return pulumi.get(self, "protection_resource")

    @_builtins.property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> _builtins.str:
        """
        The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "tls_version")

    @_builtins.property
    @pulumi.getter(name="xffHeaderMode")
    def xff_header_mode(self) -> _builtins.int:
        """
        WAF obtains the real IP address of the client.
        """
        return pulumi.get(self, "xff_header_mode")

    @_builtins.property
    @pulumi.getter(name="xffHeaders")
    def xff_headers(self) -> Sequence[_builtins.str]:
        """
        Set the list of custom fields used to obtain the client IP address.
        """
        return pulumi.get(self, "xff_headers")


@pulumi.output_type
class GetDomainsDomainRedirectResult(dict):
    def __init__(__self__, *,
                 backends: Sequence[_builtins.str],
                 connect_timeout: _builtins.int,
                 focus_http_backend: _builtins.bool,
                 keepalive: _builtins.bool,
                 keepalive_requests: _builtins.int,
                 keepalive_timeout: _builtins.int,
                 loadbalance: _builtins.str,
                 read_timeout: _builtins.int,
                 request_headers: Sequence['outputs.GetDomainsDomainRedirectRequestHeaderResult'],
                 retry: _builtins.bool,
                 sni_enabled: _builtins.bool,
                 sni_host: _builtins.str,
                 write_timeout: _builtins.int):
        """
        :param Sequence[_builtins.str] backends: The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        :param _builtins.int connect_timeout: Connection timeout, Unit: seconds, value range: 5~120.
        :param _builtins.bool focus_http_backend: Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.bool keepalive: Open long connection, default true.
        :param _builtins.int keepalive_requests: Number of long connections, default: `60`. range :60-1000.
        :param _builtins.int keepalive_timeout: Long connection over time, default: `15`. Range: 1-60.
        :param _builtins.str loadbalance: The load balancing algorithm used when returning to the source.
        :param _builtins.int read_timeout: Read timeout duration. Unit: seconds, Value range: 5~1800.
        :param Sequence['GetDomainsDomainRedirectRequestHeaderArgs'] request_headers: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param _builtins.bool retry: Back to Source Retry. default `true`, retry 3 times by default.
        :param _builtins.bool sni_enabled: Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param _builtins.str sni_host: Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        :param _builtins.int write_timeout: Write timeout duration. **Unit**: seconds, **Value range**:5~1800.
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "focus_http_backend", focus_http_backend)
        pulumi.set(__self__, "keepalive", keepalive)
        pulumi.set(__self__, "keepalive_requests", keepalive_requests)
        pulumi.set(__self__, "keepalive_timeout", keepalive_timeout)
        pulumi.set(__self__, "loadbalance", loadbalance)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "request_headers", request_headers)
        pulumi.set(__self__, "retry", retry)
        pulumi.set(__self__, "sni_enabled", sni_enabled)
        pulumi.set(__self__, "sni_host", sni_host)
        pulumi.set(__self__, "write_timeout", write_timeout)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Sequence[_builtins.str]:
        """
        The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> _builtins.int:
        """
        Connection timeout, Unit: seconds, value range: 5~120.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="focusHttpBackend")
    def focus_http_backend(self) -> _builtins.bool:
        """
        Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "focus_http_backend")

    @_builtins.property
    @pulumi.getter
    def keepalive(self) -> _builtins.bool:
        """
        Open long connection, default true.
        """
        return pulumi.get(self, "keepalive")

    @_builtins.property
    @pulumi.getter(name="keepaliveRequests")
    def keepalive_requests(self) -> _builtins.int:
        """
        Number of long connections, default: `60`. range :60-1000.
        """
        return pulumi.get(self, "keepalive_requests")

    @_builtins.property
    @pulumi.getter(name="keepaliveTimeout")
    def keepalive_timeout(self) -> _builtins.int:
        """
        Long connection over time, default: `15`. Range: 1-60.
        """
        return pulumi.get(self, "keepalive_timeout")

    @_builtins.property
    @pulumi.getter
    def loadbalance(self) -> _builtins.str:
        """
        The load balancing algorithm used when returning to the source.
        """
        return pulumi.get(self, "loadbalance")

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> _builtins.int:
        """
        Read timeout duration. Unit: seconds, Value range: 5~1800.
        """
        return pulumi.get(self, "read_timeout")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Sequence['outputs.GetDomainsDomainRedirectRequestHeaderResult']:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter
    def retry(self) -> _builtins.bool:
        """
        Back to Source Retry. default `true`, retry 3 times by default.
        """
        return pulumi.get(self, "retry")

    @_builtins.property
    @pulumi.getter(name="sniEnabled")
    def sni_enabled(self) -> _builtins.bool:
        """
        Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "sni_enabled")

    @_builtins.property
    @pulumi.getter(name="sniHost")
    def sni_host(self) -> _builtins.str:
        """
        Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        """
        return pulumi.get(self, "sni_host")

    @_builtins.property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> _builtins.int:
        """
        Write timeout duration. **Unit**: seconds, **Value range**:5~1800.
        """
        return pulumi.get(self, "write_timeout")


@pulumi.output_type
class GetDomainsDomainRedirectRequestHeaderResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param _builtins.str value: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str instance_id: The first ID of the resource.
        :param _builtins.str status: The status of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


