"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StageBase = exports.ApiBase = void 0;
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const core_1 = require("aws-cdk-lib/core");
const api_mapping_1 = require("./api-mapping");
/**
 * Base class representing an API
 * @internal
 */
class ApiBase extends core_1.Resource {
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/ApiGateway',
            metricName,
            dimensionsMap: { ApiId: this.apiId },
            ...props,
        }).attachTo(this);
    }
}
exports.ApiBase = ApiBase;
/**
 * Base class representing a Stage
 * @internal
 */
class StageBase extends core_1.Resource {
    /**
     * @internal
     */
    _addDomainMapping(domainMapping) {
        if (this._apiMapping) {
            throw new Error('Only one ApiMapping allowed per Stage');
        }
        this._apiMapping = new api_mapping_1.ApiMapping(this, `${domainMapping.domainName}${domainMapping.mappingKey}`, {
            api: this.baseApi,
            domainName: domainMapping.domainName,
            stage: this,
            apiMappingKey: domainMapping.mappingKey,
        });
        // ensure the dependency
        this.node.addDependency(domainMapping.domainName);
    }
    metric(metricName, props) {
        return this.baseApi.metric(metricName, props).with({
            dimensionsMap: { ApiId: this.baseApi.apiId, Stage: this.stageName },
        }).attachTo(this);
    }
}
exports.StageBase = StageBase;
//# sourceMappingURL=data:application/json;base64,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