"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcLink = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const core_1 = require("aws-cdk-lib/core");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a HTTP API to access resources in an Amazon Virtual Private Cloud (VPC).
 */
class VpcLink extends core_1.Resource {
    /**
     * Import a VPC Link by specifying its attributes.
     */
    static fromVpcLinkAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_VpcLinkAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcLinkAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcLinkId = attrs.vpcLinkId;
                this.vpc = attrs.vpc;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.subnets = new Array();
        this.securityGroups = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_VpcLinkProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcLink);
            }
            throw error;
        }
        this.vpc = props.vpc;
        const cfnResource = new aws_apigatewayv2_1.CfnVpcLink(this, 'Resource', {
            name: props.vpcLinkName || core_1.Lazy.string({ produce: () => core_1.Names.uniqueId(this) }),
            subnetIds: core_1.Lazy.list({ produce: () => this.renderSubnets() }),
            securityGroupIds: core_1.Lazy.list({ produce: () => this.renderSecurityGroups() }),
        });
        this.vpcLinkId = cfnResource.ref;
        const { subnets } = props.vpc.selectSubnets(props.subnets ?? { subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS });
        this.addSubnets(...subnets);
        if (props.securityGroups) {
            this.addSecurityGroups(...props.securityGroups);
        }
    }
    /**
     * Adds the provided subnets to the vpc link
     *
     * @param subnets
     */
    addSubnets(...subnets) {
        this.subnets.push(...subnets);
    }
    /**
     * Adds the provided security groups to the vpc link
     *
     * @param groups
     */
    addSecurityGroups(...groups) {
        this.securityGroups.push(...groups);
    }
    renderSubnets() {
        return this.subnets.map(subnet => subnet.subnetId);
    }
    renderSecurityGroups() {
        return this.securityGroups.map(sg => sg.securityGroupId);
    }
}
exports.VpcLink = VpcLink;
_a = JSII_RTTI_SYMBOL_1;
VpcLink[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.VpcLink", version: "2.102.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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