"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketNoneAuthorizer = exports.WebSocketAuthorizer = exports.WebSocketAuthorizerType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported Authorizer types
 */
var WebSocketAuthorizerType;
(function (WebSocketAuthorizerType) {
    /** Lambda Authorizer */
    WebSocketAuthorizerType["LAMBDA"] = "REQUEST";
    /** IAM Authorizer */
    WebSocketAuthorizerType["IAM"] = "AWS_IAM";
})(WebSocketAuthorizerType || (exports.WebSocketAuthorizerType = WebSocketAuthorizerType = {}));
/**
 * An authorizer for WebSocket Apis
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class WebSocketAuthorizer extends core_1.Resource {
    /**
     * Import an existing WebSocket Authorizer into this CDK app.
     */
    static fromWebSocketAuthorizerAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketAuthorizerAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketAuthorizerAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketAuthorizer);
            }
            throw error;
        }
        if (props.type === WebSocketAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: props.authorizerName ?? id,
            apiId: props.webSocketApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            authorizerUri: props.authorizerUri,
        });
        this.authorizerId = resource.ref;
    }
}
exports.WebSocketAuthorizer = WebSocketAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketAuthorizer", version: "2.102.0-alpha.0" };
/**
 * Explicitly configure no authorizers on specific WebSocket API routes.
 */
class WebSocketNoneAuthorizer {
    bind(_options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteAuthorizerBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.WebSocketNoneAuthorizer = WebSocketNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
WebSocketNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketNoneAuthorizer", version: "2.102.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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