import { Duration } from 'aws-cdk-lib';
import { Alarm } from 'aws-cdk-lib/aws-cloudwatch';
import { Cluster, IService } from 'aws-cdk-lib/aws-ecs';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { Function } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface EcsIsoServiceAutoscalerProps {
    /**
     * Optional IAM role to attach to the created lambda to adjust the desired count on the ECS Service
     *
     * Ensure this role has appropriate privileges. Example IAM policy statements:
     * ```json
     * {
     *  "PolicyDocument": {
     *    "Statement": [
     *      {
     *        "Action": "cloudwatch:DescribeAlarms",
     *        "Effect": "Allow",
     *        "Resource": "arn:${Partition}:cloudwatch:${Region}:${Account}:alarm:${AlarmName}"
     *      },
     *      {
     *        "Action": [
     *          "ecs:DescribeServices",
     *          "ecs:UpdateService"
     *        ],
     *        "Condition": {
     *          "StringEquals": {
     *            "ecs:cluster": "arn:${Partition}:ecs:${Region}:${Account}:cluster/${ClusterName}"
     *          }
     *        },
     *        "Effect": "Allow",
     *        "Resource": "arn:${Partition}:ecs:${Region}:${Account}:service/${ClusterName}/${ServiceName}"
     *      }
     *    ],
     *    "Version": "2012-10-17"
     *  }
     *}
     * ```
     * @default A role is created for you with least privilege IAM policy
     */
    readonly role?: IRole;
    /**
     * The cluster the service you wish to scale resides in.
     */
    readonly ecsCluster: Cluster;
    /**
     * The ECS service you wish to scale.
     */
    readonly ecsService: IService;
    /**
     * The minimum number of tasks the service will have.
     *
     * @default 1
     */
    readonly minimumTaskCount?: number;
    /**
     * The maximum number of tasks that the service will scale out to.
     * Note: This does not provide any protection from scaling out above the maximum allowed in your account, set this variable and manage account quotas appropriately.
     *
     * @default 10
     */
    readonly maximumTaskCount?: number;
    /**
     * The Cloudwatch Alarm that will cause scaling actions to be invoked, whether it's in or not in alarm will determine scale up and down actions.
     */
    readonly scaleAlarm: Alarm;
    /**
     * The number of tasks that will scale out on scale out alarm status
     *
     * @default 1
     */
    readonly scaleOutIncrement?: number;
    /**
     * The number of tasks that will scale in on scale in alarm status
     *
     * @default 1
     */
    readonly scaleInIncrement?: number;
    /**
     * How long will a the application wait before performing another scale out action.
     *
     * @default 60 seconds
     */
    readonly scaleOutCooldown?: Duration;
    /**
     * How long will the application wait before performing another scale in action
     *
     * @default 60 seconds
     */
    readonly scaleInCooldown?: Duration;
}
/**
 * Creates a EcsIsoServiceAutoscaler construct. This construct allows you to scale an ECS service in an ISO
 * region where classic ECS Autoscaling may not be available.
 *
 * @param scope The parent creating construct (usually `this`).
 * @param id The construct's name.
 * @param this A `EcsIsoServiceAutoscalerthis` interface.
 */
export declare class EcsIsoServiceAutoscaler extends Construct {
    readonly ecsScalingManagerFunction: Function;
    constructor(scope: Construct, id: string, props: EcsIsoServiceAutoscalerProps);
}
