import { IAspect } from 'aws-cdk-lib';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { IConstruct } from 'constructs';
/**
 * Whether an http-proxy or https-proxy
 */
export declare enum ProxyType {
    /**
     * --http-proxy
     */
    'HTTP' = 0,
    /**
     * --https-proxy
     */
    'HTTPS' = 1
}
/**
 * Properties for the proxy server to use with cfn helper commands
 */
export interface AddCfnInitProxyProps {
    /**
     * host of your proxy
     * @example example.com
     */
    readonly proxyHost: string;
    /**
     * proxy port
     * @example 8080
     */
    readonly proxyPort: number;
    /**
     * Proxy Type
     * @example ProxyType.HTTPS
     * @default ProxyType.HTTP
     */
    readonly proxyType?: ProxyType;
    /**
     * JSON secret containing `user` and `password` properties to use if your proxy requires credentials
     * `http://user:password@host:port` could contain sensitive data, so using a Secret.
     *
     * Note that while the `user` and `password` won't be visible in the cloudformation template
     * they **will** be in plain text inside your `UserData`
     *
     * @example
     * const secret = new Secret(stack, 'TestSecret', {
        secretObjectValue: {
          user: SecretValue,
          password: SecretValue,
        },
      });
     */
    readonly proxyCredentials?: ISecret;
}
/**
 * Add proxy configuration to Cloudformation helper functions
 *
 * @extends IAspect
 */
export declare class AddCfnInitProxy implements IAspect {
    private readonly _proxyHost;
    private readonly _proxyPort;
    private readonly _proxyType?;
    private readonly _proxyCredentials?;
    private readonly _initResourceTypes;
    private readonly _proxyValue;
    constructor(props: AddCfnInitProxyProps);
    visit(node: IConstruct): void;
    private determineProxyValue;
    private indexOfList;
}
