"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddPermissionBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const utils_1 = require("../utils/utils");
/**
 * A patch for Adding Permissions Boundaries to all IAM roles
 *
 * Additional options for adding prefixes to IAM role, policy and instance profile names
 *
 * Can account for non commercial partitions (e.g. aws-gov, aws-cn)
 */
class AddPermissionBoundary {
    constructor(props) {
        this._permissionsBoundaryPolicyName = props.permissionsBoundaryPolicyName;
        this._rolePrefix = props.rolePrefix || '';
        this._policyPrefix = props.policyPrefix || '';
        this._instanceProfilePrefix = props.instanceProfilePrefix || '';
    }
    checkAndOverride(node, prefix, length, cfnProp, cdkProp) {
        if (!cdkProp?.startsWith(prefix)) {
            const policySuffix = !aws_cdk_lib_1.Token.isUnresolved(cdkProp)
                ? cdkProp
                : utils_1.getResourceId(node.node.path);
            node.addPropertyOverride(cfnProp, `${prefix}${policySuffix.replace(/\s/g, '')}`.substring(0, length - 1));
        }
    }
    visit(node) {
        if (node instanceof aws_cdk_lib_1.CfnResource) {
            const cfnResourceNode = node;
            if (cfnResourceNode.cfnResourceType == 'AWS::IAM::Role') {
                const permissionsBoundaryPolicyArn = aws_cdk_lib_1.Stack.of(node).formatArn({
                    service: 'iam',
                    resource: 'policy',
                    region: '',
                    resourceName: this._permissionsBoundaryPolicyName,
                });
                node.addPropertyOverride('PermissionsBoundary', permissionsBoundaryPolicyArn);
                this.checkAndOverride(node, this._rolePrefix, 64, 'RoleName', cfnResourceNode.logicalId);
            }
        }
        if (node instanceof aws_iam_1.CfnRole) {
            const permissionsBoundaryPolicyArn = aws_cdk_lib_1.Stack.of(node).formatArn({
                service: 'iam',
                resource: 'policy',
                region: '',
                resourceName: this._permissionsBoundaryPolicyName,
            });
            node.addPropertyOverride('PermissionsBoundary', permissionsBoundaryPolicyArn);
            this.checkAndOverride(node, this._rolePrefix, 64, 'RoleName', node.roleName);
        }
        else if (node instanceof aws_iam_1.CfnPolicy) {
            this.checkAndOverride(node, this._policyPrefix, 128, 'PolicyName', node.policyName);
        }
        else if (node instanceof aws_iam_1.CfnManagedPolicy) {
            this.checkAndOverride(node, this._policyPrefix, 128, 'ManagedPolicyName', node.managedPolicyName);
        }
        else if (node instanceof aws_iam_1.CfnInstanceProfile) {
            this.checkAndOverride(node, this._instanceProfilePrefix, 128, 'InstanceProfileName', node.instanceProfileName);
        }
    }
}
exports.AddPermissionBoundary = AddPermissionBoundary;
_a = JSII_RTTI_SYMBOL_1;
AddPermissionBoundary[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.AddPermissionBoundary", version: "0.0.79" };
//# sourceMappingURL=data:application/json;base64,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