import { IAspect } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
export interface RemoveTagsProps {
    /**
     * Name of Cloudformation resource Type (e.g. 'AWS::Lambda::Function')
     */
    readonly cloudformationResource: string;
    /**
     * Name of the tag property to remove from the resource
     *
     * @default Tags
     */
    readonly tagPropertyName?: string;
}
/**
 * Patch for removing tags from a specific Cloudformation Resource
 *
 * In some regions, the 'Tags' property isn't supported in Cloudformation. This patch makes it easy to remove
 *
 * @example
 * // Remove tags on a resource
 * Aspects.of(stack).add(new RemoveTags({
 *   cloudformationResource: 'AWS::ECS::Cluster',
 * }));
 * // Remove tags without the standard 'Tags' name
 * Aspects.of(stack).add(new RemoveTags({
 *   cloudformationResource: 'AWS::Backup::BackupPlan',
 *    tagPropertyName: 'BackupPlanTags',
 * }));
 */
export declare class RemoveTags implements IAspect {
    private _cloudformationResource;
    private _tagPropertyName;
    constructor(props: RemoveTagsProps);
    visit(node: IConstruct): void;
}
