import { CfnResource } from 'aws-cdk-lib';
import { CloudFormationStackArtifact } from 'aws-cdk-lib/cx-api';
import { ResourceExtractorShareMethod } from './resourceExtractor';
import { FlatJson, Json } from './types';
export interface CfnStoreProps {
    readonly stackArtifacts: CloudFormationStackArtifact[];
    readonly valueShareMethod: ResourceExtractorShareMethod;
    readonly extractedStackName: string;
    readonly region: string;
}
export declare class CfnStore {
    readonly templates: Json;
    readonly flatTemplates: FlatJson;
    readonly extractedStackExports: FlatJson;
    constructor(props: CfnStoreProps);
    /**
     * Determine what the export value should be, for example if it should be a
     * `Ref` or `Fn::GetAtt`
     *
     * @param resource
     * @param flattendKey
     * @returns
     */
    determineExportValue(resource: CfnResource, flattendKey: string): string | false | import("aws-cdk-lib").Reference;
    /**
     * Retrieve a Stack Name from a given Logical ID
     *
     * @param logicalId the Logical ID of the Resource to find
     * @returns the Stack Name that the Logical ID is found to be in
     */
    getStackNameFromLogicalId(logicalId: string): string;
    /**
     * Retrieve a Resource Type from a given Logical ID
     *
     * @param logicalId the logical ID of the Resource to find
     * @returns the Resource Type of the provided Logical ID
     */
    getResourceTypeFromLogicalId(logicalId: string): string;
    /**
     * Performs a Describe Stack API call with the AWS SDK to determine what
     * the CloudFormation Exports are for a given Stack Name.
     *
     * @param stackName the CloudFormation stack name to query against
     * @param region the AWS region to target
     * @returns CloudFormation Stack object
     */
    private describeStack;
    /**
     * Builds an Export lookup table from the provided AWS SDK CloudFormation
     * stack object. This will be in the form of `{ 'MyExport': 'foobar' }`.
     *
     * @param stack
     * @returns
     */
    private createExportMap;
}
