import { CfnStore } from './cfnStore';
import { FlatJson } from './types';
export declare class MissingTransformError extends Error {
    constructor(resourceType: string);
}
export declare enum ResourceTransform {
    STACK_NAME = "ResourceTransform.STACK_NAME",
    LOGICAL_ID = "ResourceTransform.LOGICAL_ID"
}
export interface ResourceTransformerProps {
    readonly cfnStore: CfnStore;
    readonly additionalTransforms?: FlatJson;
}
export declare class ResourceTransformer {
    private readonly cfn;
    private readonly defaultTransforms;
    private readonly additionalTransforms?;
    constructor(props: ResourceTransformerProps);
    /**
     * Helper function that generates the beginning portion of an AWS Arn.
     */
    private generateArnPreamble;
    /**
     * Creates the Default Transformation function table that contains transform
     * functions for each CloudFormation Resource Type.
     *
     * This should be updated to support additional resource types.
     * In addition, it may need to be fixed if some of the transformations are
     * found to be incorrect or inconsistent.
     *
     * @returns object in the form of { 'AWS::S3::Bucket': transform function }
     */
    private createDefaultTransforms;
    /**
     * Transforms resource names to partial values (primarily ARNs) using
     * wildcards.
     *
     * Takes in a generated resource name from CDK and transforms it to a
     * partial value that is used to replace resource references that use
     * `Fn::GetAtt` from the generated resource name. This is mainly used to
     * avoid cyclical dependencies within CDK and ensure that Policies can be
     * correctly created without knowing the future value of a resource. This
     * relies on the assumption that the developer does NOT input the `name`
     * of the resource they are creating. In other words, you must let CDK
     * generate the resource name.
     *
     * @param logicalId the Logical ID of the Resource generated by CDK
     * @returns string of partial match value to use in IAM Policies
     */
    toPartial(logicalId: string): string;
}
