# coding: utf-8

"""
    College Football Data API

    This is an API for query various college football datasets and analytics. API keys can be acquired from the CollegeFootballData.com website.

    The version of the OpenAPI document: 5.9.5
    Contact: admin@collegefootballdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr

from typing import List, Optional, Union

from cfbd.models.advanced_game_stat import AdvancedGameStat
from cfbd.models.advanced_season_stat import AdvancedSeasonStat
from cfbd.models.player_stat import PlayerStat
from cfbd.models.season_type import SeasonType
from cfbd.models.team_stat import TeamStat

from cfbd.api_client import ApiClient
from cfbd.api_response import ApiResponse
from cfbd.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class StatsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_advanced_game_stats(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, week : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional week filter")] = None, opponent : Annotated[Optional[StrictStr], Field(description="Optional opponent filter")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Garbage time exclusion filter, defaults to false")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, **kwargs) -> List[AdvancedGameStat]:  # noqa: E501
        """get_advanced_game_stats  # noqa: E501

        Retrieves advanced statistics aggregated by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_advanced_game_stats(year, team, week, opponent, exclude_garbage_time, season_type, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param week: Optional week filter
        :type week: float
        :param opponent: Optional opponent filter
        :type opponent: str
        :param exclude_garbage_time: Garbage time exclusion filter, defaults to false
        :type exclude_garbage_time: bool
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[AdvancedGameStat]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_advanced_game_stats_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_advanced_game_stats_with_http_info(year, team, week, opponent, exclude_garbage_time, season_type, **kwargs)  # noqa: E501

    @validate_arguments
    def get_advanced_game_stats_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, week : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional week filter")] = None, opponent : Annotated[Optional[StrictStr], Field(description="Optional opponent filter")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Garbage time exclusion filter, defaults to false")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_advanced_game_stats  # noqa: E501

        Retrieves advanced statistics aggregated by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_advanced_game_stats_with_http_info(year, team, week, opponent, exclude_garbage_time, season_type, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param week: Optional week filter
        :type week: float
        :param opponent: Optional opponent filter
        :type opponent: str
        :param exclude_garbage_time: Garbage time exclusion filter, defaults to false
        :type exclude_garbage_time: bool
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[AdvancedGameStat], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'team',
            'week',
            'opponent',
            'exclude_garbage_time',
            'season_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_advanced_game_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('opponent') is not None:  # noqa: E501
            _query_params.append(('opponent', _params['opponent']))

        if _params.get('exclude_garbage_time') is not None:  # noqa: E501
            _query_params.append(('excludeGarbageTime', _params['exclude_garbage_time']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[AdvancedGameStat]",
        }

        return self.api_client.call_api(
            '/stats/game/advanced', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_advanced_season_stats(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Garbage time exclusion filter, defaults to false")] = None, start_week : Annotated[Optional[StrictInt], Field(description="Optional start week range filter")] = None, end_week : Annotated[Optional[StrictInt], Field(description="Optional end week range filter")] = None, **kwargs) -> List[AdvancedSeasonStat]:  # noqa: E501
        """get_advanced_season_stats  # noqa: E501

        Retrieves advanced season statistics for teams  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_advanced_season_stats(year, team, exclude_garbage_time, start_week, end_week, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param exclude_garbage_time: Garbage time exclusion filter, defaults to false
        :type exclude_garbage_time: bool
        :param start_week: Optional start week range filter
        :type start_week: int
        :param end_week: Optional end week range filter
        :type end_week: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[AdvancedSeasonStat]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_advanced_season_stats_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_advanced_season_stats_with_http_info(year, team, exclude_garbage_time, start_week, end_week, **kwargs)  # noqa: E501

    @validate_arguments
    def get_advanced_season_stats_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Garbage time exclusion filter, defaults to false")] = None, start_week : Annotated[Optional[StrictInt], Field(description="Optional start week range filter")] = None, end_week : Annotated[Optional[StrictInt], Field(description="Optional end week range filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_advanced_season_stats  # noqa: E501

        Retrieves advanced season statistics for teams  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_advanced_season_stats_with_http_info(year, team, exclude_garbage_time, start_week, end_week, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param exclude_garbage_time: Garbage time exclusion filter, defaults to false
        :type exclude_garbage_time: bool
        :param start_week: Optional start week range filter
        :type start_week: int
        :param end_week: Optional end week range filter
        :type end_week: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[AdvancedSeasonStat], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'team',
            'exclude_garbage_time',
            'start_week',
            'end_week'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_advanced_season_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('exclude_garbage_time') is not None:  # noqa: E501
            _query_params.append(('excludeGarbageTime', _params['exclude_garbage_time']))

        if _params.get('start_week') is not None:  # noqa: E501
            _query_params.append(('startWeek', _params['start_week']))

        if _params.get('end_week') is not None:  # noqa: E501
            _query_params.append(('endWeek', _params['end_week']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[AdvancedSeasonStat]",
        }

        return self.api_client.call_api(
            '/stats/season/advanced', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_categories(self, **kwargs) -> List[str]:  # noqa: E501
        """get_categories  # noqa: E501

        Gets team statistical categories  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_categories(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_categories_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_categories_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_categories_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_categories  # noqa: E501

        Gets team statistical categories  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_categories" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[str]",
        }

        return self.api_client.call_api(
            '/stats/categories', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_player_season_stats(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, start_week : Annotated[Optional[StrictInt], Field(description="Optional starting week range")] = None, end_week : Annotated[Optional[StrictInt], Field(description="Optional ending week range")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, category : Annotated[Optional[StrictStr], Field(description="Optional category filter")] = None, **kwargs) -> List[PlayerStat]:  # noqa: E501
        """get_player_season_stats  # noqa: E501

        Retrieves aggregated player statistics for a given season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_player_season_stats(year, conference, team, start_week, end_week, season_type, category, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param conference: Optional conference filter
        :type conference: str
        :param team: Optional team filter
        :type team: str
        :param start_week: Optional starting week range
        :type start_week: int
        :param end_week: Optional ending week range
        :type end_week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param category: Optional category filter
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlayerStat]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_player_season_stats_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_player_season_stats_with_http_info(year, conference, team, start_week, end_week, season_type, category, **kwargs)  # noqa: E501

    @validate_arguments
    def get_player_season_stats_with_http_info(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, start_week : Annotated[Optional[StrictInt], Field(description="Optional starting week range")] = None, end_week : Annotated[Optional[StrictInt], Field(description="Optional ending week range")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, category : Annotated[Optional[StrictStr], Field(description="Optional category filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_player_season_stats  # noqa: E501

        Retrieves aggregated player statistics for a given season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_player_season_stats_with_http_info(year, conference, team, start_week, end_week, season_type, category, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param conference: Optional conference filter
        :type conference: str
        :param team: Optional team filter
        :type team: str
        :param start_week: Optional starting week range
        :type start_week: int
        :param end_week: Optional ending week range
        :type end_week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param category: Optional category filter
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlayerStat], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'conference',
            'team',
            'start_week',
            'end_week',
            'season_type',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_player_season_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('start_week') is not None:  # noqa: E501
            _query_params.append(('startWeek', _params['start_week']))

        if _params.get('end_week') is not None:  # noqa: E501
            _query_params.append(('endWeek', _params['end_week']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PlayerStat]",
        }

        return self.api_client.call_api(
            '/stats/player/season', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_team_stats(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, start_week : Annotated[Optional[StrictInt], Field(description="Optional week start range filter")] = None, end_week : Annotated[Optional[StrictInt], Field(description="Optional week end range filter")] = None, **kwargs) -> List[TeamStat]:  # noqa: E501
        """get_team_stats  # noqa: E501

        Retrieves aggregated team season statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_team_stats(year, team, conference, start_week, end_week, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param start_week: Optional week start range filter
        :type start_week: int
        :param end_week: Optional week end range filter
        :type end_week: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[TeamStat]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_team_stats_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_team_stats_with_http_info(year, team, conference, start_week, end_week, **kwargs)  # noqa: E501

    @validate_arguments
    def get_team_stats_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, start_week : Annotated[Optional[StrictInt], Field(description="Optional week start range filter")] = None, end_week : Annotated[Optional[StrictInt], Field(description="Optional week end range filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_team_stats  # noqa: E501

        Retrieves aggregated team season statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_team_stats_with_http_info(year, team, conference, start_week, end_week, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param start_week: Optional week start range filter
        :type start_week: int
        :param end_week: Optional week end range filter
        :type end_week: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[TeamStat], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'team',
            'conference',
            'start_week',
            'end_week'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_team_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('start_week') is not None:  # noqa: E501
            _query_params.append(('startWeek', _params['start_week']))

        if _params.get('end_week') is not None:  # noqa: E501
            _query_params.append(('endWeek', _params['end_week']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[TeamStat]",
        }

        return self.api_client.call_api(
            '/stats/season', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
