from ...event import MonomeEvent
from ..event import ArcKeyEvent
from .ring import ArcUIRing


class ArcUIRotationEvent (MonomeEvent):
    def __init__(self, ring: ArcUIRing, position: int, delta: int):
        """
        Event generated by a rotational movement on Arc.

        Args:
            ring (ArcRing): The Ring object on the ArcUI.
            position (int): The position of the ring.
            delta (int): The change in position.
        """
        super().__init__()
        self.ring = ring
        self.position = position
        self.delta = delta
    
    def __repr__(self):
        return f"ArcUIRotationEvent(ring={self.ring}, position={self.position}, delta={self.delta})"
    
class ArcUIKeyEvent (ArcKeyEvent):
    pass