from ..event import MonomeEvent

class ArcRotationEvent (MonomeEvent):
    def __init__(self, ring: int, delta: int):
        """
        Event generated by a rotational movement on Arc.

        Args:
            ring (int): The ring number (0-3) on the Arc.
            delta (int) : The change in position.
        """
        super().__init__()
        self.ring = ring
        self.delta = delta
    
    def __repr__(self):
        return f"ArcRotationEvent(ring={self.ring}, delta={self.delta})"

class ArcKeyEvent (MonomeEvent):
    def __init__(self, key: int, down: bool):
        """
        Event generated by a rotational movement on Arc.

        Args:
            key (int): The key index on the Arc (currently always 0)
            down (bool): Whether the key is pressed down (True) or released (False).
        """
        super().__init__()
        self.key = key
        self.down = down
    
    def __repr__(self):
        return f"ArcKeyEvent(ring={self.ring}, key={self.key}, down={self.down})"
