from ..event import MonomeEvent

class GridKeyEvent (MonomeEvent):
    def __init__(self, x: int, y: int, down: bool):
        """
        Event generated by a Grid key up/down.

        Args:
            x (int): The x position of the key, where 0 == left.
            y (int): The y position of the key, where 0 == top.
            down (bool): Whether the key is pressed down (True) or released (False).
        """
        super().__init__()
        self.x = x
        self.y = y
        self.down = down

class GridUIKeyEvent (GridKeyEvent):
    def __init__(self, page, x: int, y: int, down: bool):
        """
        Event generated by a GridUI key up/down.
        This is identical to GridKeyEvent, but includes a reference to the GridPage that
        generated the event.

        Args:
            page (GridPage): The GridPage that generated the event.
            x (int): The x position of the key, where 0 == left.
            y (int): The y position of the key, where 0 == top.
            down (bool): Whether the key is pressed down (True) or released (False).
        """
        super().__init__(x, y, down)
        self.page = page

    def __repr__(self):
        return f"GridUIKeyEvent(page={self.page}, x={self.x}, y={self.y}, down={self.down})"

class GridUIMidiNoteEvent (GridUIKeyEvent):
    def __init__(self, page, x: int, y: int, down: bool, note: int):
        """
        Event generated by a GridUI key up/down with MIDI note information.

        Args:
            x (int): The x position of the key, where 0 == left.
            y (int): The y position of the key, where 0 == top.
            down (bool): Whether the key is pressed down (True) or released (False).
            note (int): The MIDI note number.
        """
        super().__init__(page, x, y, down)
        self.note = note

    def __repr__(self):
        return f"GridUIMidiNoteEvent(page={self.page}, x={self.x}, y={self.y}, down={self.down}, note={self.note})"