# Contributing to maybankforme

Thanks for considering a contribution! Please follow these quick steps.

## Standards and Workflow

- Read the code standards in `AGENTS.md` (style, typing, tests, security).
- Use trunk-based development with short-lived feature branches.
- Follow Conventional Commits for messages.

## Setup

```bash
uv sync --all-extras
```

## Before committing

```bash
# Lint
uv run ruff check src/ tests/

# Type-check
uv run mypy src/

# Tests
uv run pytest -q
```

## Run locally

```bash
uv run python -m maybankforme.server
# or
uv run uvicorn maybankforme.api:app --reload
```

Open a PR with a concise description and link any related issues.
Add tests and docs for user-visible changes.
