# -*- coding: UTF-8 -*-

from ._anndata_ import adata_map_df, adata_group
from ._scanpy_ import filter_data, get_difference_genes
from ._scvi_ import poisson_vi
from ._gsea_ import gsea_enrichr, get_gene_enrichment

from ._snapatac_ import (
    get_sc_atac,
    merge_sc_atac,
    get_gene_expression,
    get_peak_matrix,
    get_tf_data,
    get_difference_peaks
)

__all__ = [
    "poisson_vi",
    "gsea_enrichr",
    "get_gene_enrichment",
    "adata_map_df",
    "filter_data",
    "get_difference_genes",
    "adata_group",
    "get_sc_atac",
    "merge_sc_atac",
    "get_gene_expression",
    "get_peak_matrix",
    "get_tf_data",
    "get_difference_peaks"
]
