from enum import Enum

class AnsiParam(Enum):
    '''
    Contains raw ANSI control parameters
    '''

    RESET=0
    BOLD=1
    FAINT=2
    ITALIC=3
    UNDERLINE=4
    SLOW_BLINK=5
    RAPID_BLINK=6
    SWAP_BG_FG=7
    HIDE=8
    CROSSED_OUT=9
    DEFAULT_FONT=10
    ALT_FONT_1=11
    ALT_FONT_2=12
    ALT_FONT_3=13
    ALT_FONT_4=14
    ALT_FONT_5=15
    ALT_FONT_6=16
    ALT_FONT_7=17
    ALT_FONT_8=18
    ALT_FONT_9=19
    GOTHIC_FONT=20
    DOUBLE_UNDERLINE=21
    NO_BOLD_FAINT=22
    NO_ITALIC=23
    NO_UNDERLINE=24
    NO_BLINK=25
    PROPORTIONAL_SPACING=26
    NO_SWAP_BG_FG=27
    NO_HIDE=28
    NO_CROSSED_OUT=29
    NO_PROPORTIONAL_SPACING=50
    FRAMED=51
    ENCIRCLED=52
    OVERLINED=53
    NO_FRAMED_ENCIRCLED=54
    NO_OVERLINED=55
    SET_UNDERLINE_COLOR=58
    SET_UNDERLINE_COLOUR=SET_UNDERLINE_COLOR # Alias for my British English friends
    DEFAULT_UNDERLINE_COLOR=59
    DEFAULT_UNDERLINE_COLOUR=DEFAULT_UNDERLINE_COLOR # Alias for my British English friends

    FG_BLACK=30
    FG_RED=31
    FG_GREEN=32
    FG_YELLOW=33
    FG_BLUE=34
    FG_MAGENTA=35
    FG_CYAN=36
    FG_WHITE=37
    FG_SET=38
    FG_DEFAULT=39

    BG_BLACK=40
    BG_RED=41
    BG_GREEN=42
    BG_YELLOW=43
    BG_BLUE=44
    BG_MAGENTA=45
    BG_CYAN=46
    BG_WHITE=47
    BG_SET=48
    BG_DEFAULT=49
