# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerPolicyRuleArgs', 'ServerPolicyRule']

@pulumi.input_type
class ServerPolicyRuleArgs:
    def __init__(__self__, *,
                 auth_server_id: pulumi.Input[_builtins.str],
                 grant_type_whitelists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 policy_id: pulumi.Input[_builtins.str],
                 priority: pulumi.Input[_builtins.int],
                 access_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 group_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_hook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_token_window_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 scope_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServerPolicyRule resource.
        :param pulumi.Input[_builtins.str] auth_server_id: Auth server ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_type_whitelists: Accepted grant type values, `authorization_code`, `implicit`, `password`, `client_credentials`, `urn:ietf:params:oauth:grant-type:saml2-bearer` (*Early Access Property*), `urn:ietf:params:oauth:grant-type:token-exchange` (*Early Access Property*),`urn:ietf:params:oauth:grant-type:device_code` (*Early Access Property*), `interaction_code` (*OIE only*). For `implicit` value either `user_whitelist` or `group_whitelist` should be set.
        :param pulumi.Input[_builtins.str] policy_id: Auth server policy ID
        :param pulumi.Input[_builtins.int] priority: Priority of the auth server policy rule
        :param pulumi.Input[_builtins.int] access_token_lifetime_minutes: Lifetime of access token. Can be set to a value between 5 and 1440 minutes. Default is `60`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_blacklists: Specifies a set of Groups whose Users are to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_whitelists: Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: `EVERYONE`.
        :param pulumi.Input[_builtins.str] inline_hook_id: The ID of the inline token to trigger.
        :param pulumi.Input[_builtins.str] name: Auth server policy rule name
        :param pulumi.Input[_builtins.int] refresh_token_lifetime_minutes: Lifetime of refresh token.
        :param pulumi.Input[_builtins.int] refresh_token_window_minutes: Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes. Default is `10080` (7 days).`refresh_token_window_minutes` must be between `access_token_lifetime_minutes` and `refresh_token_lifetime_minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_whitelists: Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `*`
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] type: Auth server policy rule type, unlikely this will be anything other then the default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_blacklists: Specifies a set of Users to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_whitelists: Specifies a set of Users to be included.
        """
        pulumi.set(__self__, "auth_server_id", auth_server_id)
        pulumi.set(__self__, "grant_type_whitelists", grant_type_whitelists)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "priority", priority)
        if access_token_lifetime_minutes is not None:
            pulumi.set(__self__, "access_token_lifetime_minutes", access_token_lifetime_minutes)
        if group_blacklists is not None:
            pulumi.set(__self__, "group_blacklists", group_blacklists)
        if group_whitelists is not None:
            pulumi.set(__self__, "group_whitelists", group_whitelists)
        if inline_hook_id is not None:
            pulumi.set(__self__, "inline_hook_id", inline_hook_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_token_lifetime_minutes is not None:
            pulumi.set(__self__, "refresh_token_lifetime_minutes", refresh_token_lifetime_minutes)
        if refresh_token_window_minutes is not None:
            pulumi.set(__self__, "refresh_token_window_minutes", refresh_token_window_minutes)
        if scope_whitelists is not None:
            pulumi.set(__self__, "scope_whitelists", scope_whitelists)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_blacklists is not None:
            pulumi.set(__self__, "user_blacklists", user_blacklists)
        if user_whitelists is not None:
            pulumi.set(__self__, "user_whitelists", user_whitelists)

    @_builtins.property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> pulumi.Input[_builtins.str]:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @auth_server_id.setter
    def auth_server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_server_id", value)

    @_builtins.property
    @pulumi.getter(name="grantTypeWhitelists")
    def grant_type_whitelists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Accepted grant type values, `authorization_code`, `implicit`, `password`, `client_credentials`, `urn:ietf:params:oauth:grant-type:saml2-bearer` (*Early Access Property*), `urn:ietf:params:oauth:grant-type:token-exchange` (*Early Access Property*),`urn:ietf:params:oauth:grant-type:device_code` (*Early Access Property*), `interaction_code` (*OIE only*). For `implicit` value either `user_whitelist` or `group_whitelist` should be set.
        """
        return pulumi.get(self, "grant_type_whitelists")

    @grant_type_whitelists.setter
    def grant_type_whitelists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "grant_type_whitelists", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Auth server policy ID
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        Priority of the auth server policy rule
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="accessTokenLifetimeMinutes")
    def access_token_lifetime_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of access token. Can be set to a value between 5 and 1440 minutes. Default is `60`.
        """
        return pulumi.get(self, "access_token_lifetime_minutes")

    @access_token_lifetime_minutes.setter
    def access_token_lifetime_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "access_token_lifetime_minutes", value)

    @_builtins.property
    @pulumi.getter(name="groupBlacklists")
    def group_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Groups whose Users are to be excluded.
        """
        return pulumi.get(self, "group_blacklists")

    @group_blacklists.setter
    def group_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_blacklists", value)

    @_builtins.property
    @pulumi.getter(name="groupWhitelists")
    def group_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: `EVERYONE`.
        """
        return pulumi.get(self, "group_whitelists")

    @group_whitelists.setter
    def group_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_whitelists", value)

    @_builtins.property
    @pulumi.getter(name="inlineHookId")
    def inline_hook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the inline token to trigger.
        """
        return pulumi.get(self, "inline_hook_id")

    @inline_hook_id.setter
    def inline_hook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inline_hook_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auth server policy rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="refreshTokenLifetimeMinutes")
    def refresh_token_lifetime_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of refresh token.
        """
        return pulumi.get(self, "refresh_token_lifetime_minutes")

    @refresh_token_lifetime_minutes.setter
    def refresh_token_lifetime_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_token_lifetime_minutes", value)

    @_builtins.property
    @pulumi.getter(name="refreshTokenWindowMinutes")
    def refresh_token_window_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes. Default is `10080` (7 days).`refresh_token_window_minutes` must be between `access_token_lifetime_minutes` and `refresh_token_lifetime_minutes`.
        """
        return pulumi.get(self, "refresh_token_window_minutes")

    @refresh_token_window_minutes.setter
    def refresh_token_window_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_token_window_minutes", value)

    @_builtins.property
    @pulumi.getter(name="scopeWhitelists")
    def scope_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `*`
        """
        return pulumi.get(self, "scope_whitelists")

    @scope_whitelists.setter
    def scope_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_whitelists", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auth server policy rule type, unlikely this will be anything other then the default
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userBlacklists")
    def user_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Users to be excluded.
        """
        return pulumi.get(self, "user_blacklists")

    @user_blacklists.setter
    def user_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_blacklists", value)

    @_builtins.property
    @pulumi.getter(name="userWhitelists")
    def user_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Users to be included.
        """
        return pulumi.get(self, "user_whitelists")

    @user_whitelists.setter
    def user_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_whitelists", value)


@pulumi.input_type
class _ServerPolicyRuleState:
    def __init__(__self__, *,
                 access_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 auth_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 grant_type_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_hook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_token_window_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 scope_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ServerPolicyRule resources.
        :param pulumi.Input[_builtins.int] access_token_lifetime_minutes: Lifetime of access token. Can be set to a value between 5 and 1440 minutes. Default is `60`.
        :param pulumi.Input[_builtins.str] auth_server_id: Auth server ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_type_whitelists: Accepted grant type values, `authorization_code`, `implicit`, `password`, `client_credentials`, `urn:ietf:params:oauth:grant-type:saml2-bearer` (*Early Access Property*), `urn:ietf:params:oauth:grant-type:token-exchange` (*Early Access Property*),`urn:ietf:params:oauth:grant-type:device_code` (*Early Access Property*), `interaction_code` (*OIE only*). For `implicit` value either `user_whitelist` or `group_whitelist` should be set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_blacklists: Specifies a set of Groups whose Users are to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_whitelists: Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: `EVERYONE`.
        :param pulumi.Input[_builtins.str] inline_hook_id: The ID of the inline token to trigger.
        :param pulumi.Input[_builtins.str] name: Auth server policy rule name
        :param pulumi.Input[_builtins.str] policy_id: Auth server policy ID
        :param pulumi.Input[_builtins.int] priority: Priority of the auth server policy rule
        :param pulumi.Input[_builtins.int] refresh_token_lifetime_minutes: Lifetime of refresh token.
        :param pulumi.Input[_builtins.int] refresh_token_window_minutes: Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes. Default is `10080` (7 days).`refresh_token_window_minutes` must be between `access_token_lifetime_minutes` and `refresh_token_lifetime_minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_whitelists: Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `*`
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.bool] system: The rule is the system (default) rule for its associated policy
        :param pulumi.Input[_builtins.str] type: Auth server policy rule type, unlikely this will be anything other then the default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_blacklists: Specifies a set of Users to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_whitelists: Specifies a set of Users to be included.
        """
        if access_token_lifetime_minutes is not None:
            pulumi.set(__self__, "access_token_lifetime_minutes", access_token_lifetime_minutes)
        if auth_server_id is not None:
            pulumi.set(__self__, "auth_server_id", auth_server_id)
        if grant_type_whitelists is not None:
            pulumi.set(__self__, "grant_type_whitelists", grant_type_whitelists)
        if group_blacklists is not None:
            pulumi.set(__self__, "group_blacklists", group_blacklists)
        if group_whitelists is not None:
            pulumi.set(__self__, "group_whitelists", group_whitelists)
        if inline_hook_id is not None:
            pulumi.set(__self__, "inline_hook_id", inline_hook_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if refresh_token_lifetime_minutes is not None:
            pulumi.set(__self__, "refresh_token_lifetime_minutes", refresh_token_lifetime_minutes)
        if refresh_token_window_minutes is not None:
            pulumi.set(__self__, "refresh_token_window_minutes", refresh_token_window_minutes)
        if scope_whitelists is not None:
            pulumi.set(__self__, "scope_whitelists", scope_whitelists)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_blacklists is not None:
            pulumi.set(__self__, "user_blacklists", user_blacklists)
        if user_whitelists is not None:
            pulumi.set(__self__, "user_whitelists", user_whitelists)

    @_builtins.property
    @pulumi.getter(name="accessTokenLifetimeMinutes")
    def access_token_lifetime_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of access token. Can be set to a value between 5 and 1440 minutes. Default is `60`.
        """
        return pulumi.get(self, "access_token_lifetime_minutes")

    @access_token_lifetime_minutes.setter
    def access_token_lifetime_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "access_token_lifetime_minutes", value)

    @_builtins.property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @auth_server_id.setter
    def auth_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_server_id", value)

    @_builtins.property
    @pulumi.getter(name="grantTypeWhitelists")
    def grant_type_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Accepted grant type values, `authorization_code`, `implicit`, `password`, `client_credentials`, `urn:ietf:params:oauth:grant-type:saml2-bearer` (*Early Access Property*), `urn:ietf:params:oauth:grant-type:token-exchange` (*Early Access Property*),`urn:ietf:params:oauth:grant-type:device_code` (*Early Access Property*), `interaction_code` (*OIE only*). For `implicit` value either `user_whitelist` or `group_whitelist` should be set.
        """
        return pulumi.get(self, "grant_type_whitelists")

    @grant_type_whitelists.setter
    def grant_type_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "grant_type_whitelists", value)

    @_builtins.property
    @pulumi.getter(name="groupBlacklists")
    def group_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Groups whose Users are to be excluded.
        """
        return pulumi.get(self, "group_blacklists")

    @group_blacklists.setter
    def group_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_blacklists", value)

    @_builtins.property
    @pulumi.getter(name="groupWhitelists")
    def group_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: `EVERYONE`.
        """
        return pulumi.get(self, "group_whitelists")

    @group_whitelists.setter
    def group_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_whitelists", value)

    @_builtins.property
    @pulumi.getter(name="inlineHookId")
    def inline_hook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the inline token to trigger.
        """
        return pulumi.get(self, "inline_hook_id")

    @inline_hook_id.setter
    def inline_hook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inline_hook_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auth server policy rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auth server policy ID
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of the auth server policy rule
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="refreshTokenLifetimeMinutes")
    def refresh_token_lifetime_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of refresh token.
        """
        return pulumi.get(self, "refresh_token_lifetime_minutes")

    @refresh_token_lifetime_minutes.setter
    def refresh_token_lifetime_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_token_lifetime_minutes", value)

    @_builtins.property
    @pulumi.getter(name="refreshTokenWindowMinutes")
    def refresh_token_window_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes. Default is `10080` (7 days).`refresh_token_window_minutes` must be between `access_token_lifetime_minutes` and `refresh_token_lifetime_minutes`.
        """
        return pulumi.get(self, "refresh_token_window_minutes")

    @refresh_token_window_minutes.setter
    def refresh_token_window_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_token_window_minutes", value)

    @_builtins.property
    @pulumi.getter(name="scopeWhitelists")
    def scope_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `*`
        """
        return pulumi.get(self, "scope_whitelists")

    @scope_whitelists.setter
    def scope_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scope_whitelists", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The rule is the system (default) rule for its associated policy
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auth server policy rule type, unlikely this will be anything other then the default
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userBlacklists")
    def user_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Users to be excluded.
        """
        return pulumi.get(self, "user_blacklists")

    @user_blacklists.setter
    def user_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_blacklists", value)

    @_builtins.property
    @pulumi.getter(name="userWhitelists")
    def user_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of Users to be included.
        """
        return pulumi.get(self, "user_whitelists")

    @user_whitelists.setter
    def user_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_whitelists", value)


@pulumi.type_token("okta:auth/serverPolicyRule:ServerPolicyRule")
class ServerPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 auth_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 grant_type_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_hook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_token_window_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 scope_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.ServerPolicyRule("example",
            auth_server_id="<auth server id>",
            policy_id="<auth server policy id>",
            status="ACTIVE",
            name="example",
            priority=1,
            group_whitelists=["<group ids>"],
            grant_type_whitelists=["implicit"])
        ```

        ## Import

        ```sh
        $ pulumi import okta:auth/serverPolicyRule:ServerPolicyRule example <auth_server_id>/<policy_id>/<policy_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] access_token_lifetime_minutes: Lifetime of access token. Can be set to a value between 5 and 1440 minutes. Default is `60`.
        :param pulumi.Input[_builtins.str] auth_server_id: Auth server ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_type_whitelists: Accepted grant type values, `authorization_code`, `implicit`, `password`, `client_credentials`, `urn:ietf:params:oauth:grant-type:saml2-bearer` (*Early Access Property*), `urn:ietf:params:oauth:grant-type:token-exchange` (*Early Access Property*),`urn:ietf:params:oauth:grant-type:device_code` (*Early Access Property*), `interaction_code` (*OIE only*). For `implicit` value either `user_whitelist` or `group_whitelist` should be set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_blacklists: Specifies a set of Groups whose Users are to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_whitelists: Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: `EVERYONE`.
        :param pulumi.Input[_builtins.str] inline_hook_id: The ID of the inline token to trigger.
        :param pulumi.Input[_builtins.str] name: Auth server policy rule name
        :param pulumi.Input[_builtins.str] policy_id: Auth server policy ID
        :param pulumi.Input[_builtins.int] priority: Priority of the auth server policy rule
        :param pulumi.Input[_builtins.int] refresh_token_lifetime_minutes: Lifetime of refresh token.
        :param pulumi.Input[_builtins.int] refresh_token_window_minutes: Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes. Default is `10080` (7 days).`refresh_token_window_minutes` must be between `access_token_lifetime_minutes` and `refresh_token_lifetime_minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_whitelists: Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `*`
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] type: Auth server policy rule type, unlikely this will be anything other then the default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_blacklists: Specifies a set of Users to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_whitelists: Specifies a set of Users to be included.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.auth.ServerPolicyRule("example",
            auth_server_id="<auth server id>",
            policy_id="<auth server policy id>",
            status="ACTIVE",
            name="example",
            priority=1,
            group_whitelists=["<group ids>"],
            grant_type_whitelists=["implicit"])
        ```

        ## Import

        ```sh
        $ pulumi import okta:auth/serverPolicyRule:ServerPolicyRule example <auth_server_id>/<policy_id>/<policy_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param ServerPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 auth_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 grant_type_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_hook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_token_window_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 scope_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerPolicyRuleArgs.__new__(ServerPolicyRuleArgs)

            __props__.__dict__["access_token_lifetime_minutes"] = access_token_lifetime_minutes
            if auth_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'auth_server_id'")
            __props__.__dict__["auth_server_id"] = auth_server_id
            if grant_type_whitelists is None and not opts.urn:
                raise TypeError("Missing required property 'grant_type_whitelists'")
            __props__.__dict__["grant_type_whitelists"] = grant_type_whitelists
            __props__.__dict__["group_blacklists"] = group_blacklists
            __props__.__dict__["group_whitelists"] = group_whitelists
            __props__.__dict__["inline_hook_id"] = inline_hook_id
            __props__.__dict__["name"] = name
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["refresh_token_lifetime_minutes"] = refresh_token_lifetime_minutes
            __props__.__dict__["refresh_token_window_minutes"] = refresh_token_window_minutes
            __props__.__dict__["scope_whitelists"] = scope_whitelists
            __props__.__dict__["status"] = status
            __props__.__dict__["type"] = type
            __props__.__dict__["user_blacklists"] = user_blacklists
            __props__.__dict__["user_whitelists"] = user_whitelists
            __props__.__dict__["system"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="okta:auth/serverPolicyClaim:ServerPolicyClaim")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ServerPolicyRule, __self__).__init__(
            'okta:auth/serverPolicyRule:ServerPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            auth_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            grant_type_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            group_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            group_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            inline_hook_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            refresh_token_lifetime_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            refresh_token_window_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            scope_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ServerPolicyRule':
        """
        Get an existing ServerPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] access_token_lifetime_minutes: Lifetime of access token. Can be set to a value between 5 and 1440 minutes. Default is `60`.
        :param pulumi.Input[_builtins.str] auth_server_id: Auth server ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_type_whitelists: Accepted grant type values, `authorization_code`, `implicit`, `password`, `client_credentials`, `urn:ietf:params:oauth:grant-type:saml2-bearer` (*Early Access Property*), `urn:ietf:params:oauth:grant-type:token-exchange` (*Early Access Property*),`urn:ietf:params:oauth:grant-type:device_code` (*Early Access Property*), `interaction_code` (*OIE only*). For `implicit` value either `user_whitelist` or `group_whitelist` should be set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_blacklists: Specifies a set of Groups whose Users are to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_whitelists: Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: `EVERYONE`.
        :param pulumi.Input[_builtins.str] inline_hook_id: The ID of the inline token to trigger.
        :param pulumi.Input[_builtins.str] name: Auth server policy rule name
        :param pulumi.Input[_builtins.str] policy_id: Auth server policy ID
        :param pulumi.Input[_builtins.int] priority: Priority of the auth server policy rule
        :param pulumi.Input[_builtins.int] refresh_token_lifetime_minutes: Lifetime of refresh token.
        :param pulumi.Input[_builtins.int] refresh_token_window_minutes: Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes. Default is `10080` (7 days).`refresh_token_window_minutes` must be between `access_token_lifetime_minutes` and `refresh_token_lifetime_minutes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scope_whitelists: Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `*`
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.bool] system: The rule is the system (default) rule for its associated policy
        :param pulumi.Input[_builtins.str] type: Auth server policy rule type, unlikely this will be anything other then the default
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_blacklists: Specifies a set of Users to be excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_whitelists: Specifies a set of Users to be included.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerPolicyRuleState.__new__(_ServerPolicyRuleState)

        __props__.__dict__["access_token_lifetime_minutes"] = access_token_lifetime_minutes
        __props__.__dict__["auth_server_id"] = auth_server_id
        __props__.__dict__["grant_type_whitelists"] = grant_type_whitelists
        __props__.__dict__["group_blacklists"] = group_blacklists
        __props__.__dict__["group_whitelists"] = group_whitelists
        __props__.__dict__["inline_hook_id"] = inline_hook_id
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["priority"] = priority
        __props__.__dict__["refresh_token_lifetime_minutes"] = refresh_token_lifetime_minutes
        __props__.__dict__["refresh_token_window_minutes"] = refresh_token_window_minutes
        __props__.__dict__["scope_whitelists"] = scope_whitelists
        __props__.__dict__["status"] = status
        __props__.__dict__["system"] = system
        __props__.__dict__["type"] = type
        __props__.__dict__["user_blacklists"] = user_blacklists
        __props__.__dict__["user_whitelists"] = user_whitelists
        return ServerPolicyRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessTokenLifetimeMinutes")
    def access_token_lifetime_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Lifetime of access token. Can be set to a value between 5 and 1440 minutes. Default is `60`.
        """
        return pulumi.get(self, "access_token_lifetime_minutes")

    @_builtins.property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        Auth server ID
        """
        return pulumi.get(self, "auth_server_id")

    @_builtins.property
    @pulumi.getter(name="grantTypeWhitelists")
    def grant_type_whitelists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Accepted grant type values, `authorization_code`, `implicit`, `password`, `client_credentials`, `urn:ietf:params:oauth:grant-type:saml2-bearer` (*Early Access Property*), `urn:ietf:params:oauth:grant-type:token-exchange` (*Early Access Property*),`urn:ietf:params:oauth:grant-type:device_code` (*Early Access Property*), `interaction_code` (*OIE only*). For `implicit` value either `user_whitelist` or `group_whitelist` should be set.
        """
        return pulumi.get(self, "grant_type_whitelists")

    @_builtins.property
    @pulumi.getter(name="groupBlacklists")
    def group_blacklists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a set of Groups whose Users are to be excluded.
        """
        return pulumi.get(self, "group_blacklists")

    @_builtins.property
    @pulumi.getter(name="groupWhitelists")
    def group_whitelists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a set of Groups whose Users are to be included. Can be set to Group ID or to the following: `EVERYONE`.
        """
        return pulumi.get(self, "group_whitelists")

    @_builtins.property
    @pulumi.getter(name="inlineHookId")
    def inline_hook_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the inline token to trigger.
        """
        return pulumi.get(self, "inline_hook_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Auth server policy rule name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Auth server policy ID
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Priority of the auth server policy rule
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="refreshTokenLifetimeMinutes")
    def refresh_token_lifetime_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Lifetime of refresh token.
        """
        return pulumi.get(self, "refresh_token_lifetime_minutes")

    @_builtins.property
    @pulumi.getter(name="refreshTokenWindowMinutes")
    def refresh_token_window_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Window in which a refresh token can be used. It can be a value between 5 and 2628000 (5 years) minutes. Default is `10080` (7 days).`refresh_token_window_minutes` must be between `access_token_lifetime_minutes` and `refresh_token_lifetime_minutes`.
        """
        return pulumi.get(self, "refresh_token_window_minutes")

    @_builtins.property
    @pulumi.getter(name="scopeWhitelists")
    def scope_whitelists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Scopes allowed for this policy rule. They can be whitelisted by name or all can be whitelisted with `*`
        """
        return pulumi.get(self, "scope_whitelists")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def system(self) -> pulumi.Output[_builtins.bool]:
        """
        The rule is the system (default) rule for its associated policy
        """
        return pulumi.get(self, "system")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Auth server policy rule type, unlikely this will be anything other then the default
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userBlacklists")
    def user_blacklists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a set of Users to be excluded.
        """
        return pulumi.get(self, "user_blacklists")

    @_builtins.property
    @pulumi.getter(name="userWhitelists")
    def user_whitelists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a set of Users to be included.
        """
        return pulumi.get(self, "user_whitelists")

