# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AuthenticatorArgs', 'Authenticator']

@pulumi.input_type
class AuthenticatorArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 legacy_ignore_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auth_port: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_host: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_integration_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_json: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Authenticator resource.
        :param pulumi.Input[_builtins.str] key: A human-readable string that identifies the authenticator. Some authenticators are available by feature flag on the organization. Possible values inclue: `duo`, `external_idp`, `google_otp`, `okta_email`, `okta_password`, `okta_verify`, `onprem_mfa`, `phone_number`, `rsa_token`, `security_question`, `webauthn`
        :param pulumi.Input[_builtins.bool] legacy_ignore_name: Name does not trigger change detection (legacy behavior)
        :param pulumi.Input[_builtins.str] name: Display name of the Authenticator
        :param pulumi.Input[_builtins.int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_host: (DUO specific) - The Duo Security API hostname. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_hostname: Server host name or IP address. Default is `localhost`. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_integration_key: (DUO specific) - The Duo Security integration key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_json: Provider JSON allows for expressive providervalues. This argument conflicts with the other 'provider_xxx' arguments. The [CreateProvider](https://developer.okta.com/docs/reference/api/authenticators-admin/#request) illustrates detailed provider values for a Duo authenticator. [Provider values](https://developer.okta.com/docs/reference/api/authenticators-admin/#authenticators-administration-api-object)are listed in Okta API.
        :param pulumi.Input[_builtins.str] provider_secret_key: (DUO specific) - The Duo Security secret key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] settings: Settings for the authenticator. The settings JSON contains values based on Authenticator key. It is not used for authenticators with type `security_key`
        :param pulumi.Input[_builtins.str] status: Authenticator status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        pulumi.set(__self__, "key", key)
        if legacy_ignore_name is not None:
            pulumi.set(__self__, "legacy_ignore_name", legacy_ignore_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_auth_port is not None:
            pulumi.set(__self__, "provider_auth_port", provider_auth_port)
        if provider_host is not None:
            pulumi.set(__self__, "provider_host", provider_host)
        if provider_hostname is not None:
            pulumi.set(__self__, "provider_hostname", provider_hostname)
        if provider_integration_key is not None:
            pulumi.set(__self__, "provider_integration_key", provider_integration_key)
        if provider_json is not None:
            pulumi.set(__self__, "provider_json", provider_json)
        if provider_secret_key is not None:
            pulumi.set(__self__, "provider_secret_key", provider_secret_key)
        if provider_shared_secret is not None:
            pulumi.set(__self__, "provider_shared_secret", provider_shared_secret)
        if provider_user_name_template is not None:
            pulumi.set(__self__, "provider_user_name_template", provider_user_name_template)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        A human-readable string that identifies the authenticator. Some authenticators are available by feature flag on the organization. Possible values inclue: `duo`, `external_idp`, `google_otp`, `okta_email`, `okta_password`, `okta_verify`, `onprem_mfa`, `phone_number`, `rsa_token`, `security_question`, `webauthn`
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="legacyIgnoreName")
    def legacy_ignore_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Name does not trigger change detection (legacy behavior)
        """
        return pulumi.get(self, "legacy_ignore_name")

    @legacy_ignore_name.setter
    def legacy_ignore_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "legacy_ignore_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the Authenticator
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_auth_port")

    @provider_auth_port.setter
    def provider_auth_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provider_auth_port", value)

    @_builtins.property
    @pulumi.getter(name="providerHost")
    def provider_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (DUO specific) - The Duo Security API hostname. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_host")

    @provider_host.setter
    def provider_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_host", value)

    @_builtins.property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server host name or IP address. Default is `localhost`. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_hostname")

    @provider_hostname.setter
    def provider_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_hostname", value)

    @_builtins.property
    @pulumi.getter(name="providerIntegrationKey")
    def provider_integration_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (DUO specific) - The Duo Security integration key.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_integration_key")

    @provider_integration_key.setter
    def provider_integration_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_integration_key", value)

    @_builtins.property
    @pulumi.getter(name="providerJson")
    def provider_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider JSON allows for expressive providervalues. This argument conflicts with the other 'provider_xxx' arguments. The [CreateProvider](https://developer.okta.com/docs/reference/api/authenticators-admin/#request) illustrates detailed provider values for a Duo authenticator. [Provider values](https://developer.okta.com/docs/reference/api/authenticators-admin/#authenticators-administration-api-object)are listed in Okta API.
        """
        return pulumi.get(self, "provider_json")

    @provider_json.setter
    def provider_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_json", value)

    @_builtins.property
    @pulumi.getter(name="providerSecretKey")
    def provider_secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (DUO specific) - The Duo Security secret key.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_secret_key")

    @provider_secret_key.setter
    def provider_secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_secret_key", value)

    @_builtins.property
    @pulumi.getter(name="providerSharedSecret")
    def provider_shared_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_shared_secret")

    @provider_shared_secret.setter
    def provider_shared_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_shared_secret", value)

    @_builtins.property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template expected by the provider. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_user_name_template")

    @provider_user_name_template.setter
    def provider_user_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_user_name_template", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Settings for the authenticator. The settings JSON contains values based on Authenticator key. It is not used for authenticators with type `security_key`
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authenticator status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AuthenticatorState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 legacy_ignore_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auth_port: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_host: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_integration_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_json: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Authenticator resources.
        :param pulumi.Input[_builtins.str] key: A human-readable string that identifies the authenticator. Some authenticators are available by feature flag on the organization. Possible values inclue: `duo`, `external_idp`, `google_otp`, `okta_email`, `okta_password`, `okta_verify`, `onprem_mfa`, `phone_number`, `rsa_token`, `security_question`, `webauthn`
        :param pulumi.Input[_builtins.bool] legacy_ignore_name: Name does not trigger change detection (legacy behavior)
        :param pulumi.Input[_builtins.str] name: Display name of the Authenticator
        :param pulumi.Input[_builtins.int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_host: (DUO specific) - The Duo Security API hostname. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_hostname: Server host name or IP address. Default is `localhost`. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_instance_id: App Instance ID.
        :param pulumi.Input[_builtins.str] provider_integration_key: (DUO specific) - The Duo Security integration key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_json: Provider JSON allows for expressive providervalues. This argument conflicts with the other 'provider_xxx' arguments. The [CreateProvider](https://developer.okta.com/docs/reference/api/authenticators-admin/#request) illustrates detailed provider values for a Duo authenticator. [Provider values](https://developer.okta.com/docs/reference/api/authenticators-admin/#authenticators-administration-api-object)are listed in Okta API.
        :param pulumi.Input[_builtins.str] provider_secret_key: (DUO specific) - The Duo Security secret key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_type: Provider type. Supported value for Duo: `DUO`. Supported value for Custom App: `PUSH`
        :param pulumi.Input[_builtins.str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] settings: Settings for the authenticator. The settings JSON contains values based on Authenticator key. It is not used for authenticators with type `security_key`
        :param pulumi.Input[_builtins.str] status: Authenticator status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] type: he type of Authenticator. Values include: `password`, `security_question`, `phone`, `email`, `app`, `federated`, and `security_key`.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if legacy_ignore_name is not None:
            pulumi.set(__self__, "legacy_ignore_name", legacy_ignore_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_auth_port is not None:
            pulumi.set(__self__, "provider_auth_port", provider_auth_port)
        if provider_host is not None:
            pulumi.set(__self__, "provider_host", provider_host)
        if provider_hostname is not None:
            pulumi.set(__self__, "provider_hostname", provider_hostname)
        if provider_instance_id is not None:
            pulumi.set(__self__, "provider_instance_id", provider_instance_id)
        if provider_integration_key is not None:
            pulumi.set(__self__, "provider_integration_key", provider_integration_key)
        if provider_json is not None:
            pulumi.set(__self__, "provider_json", provider_json)
        if provider_secret_key is not None:
            pulumi.set(__self__, "provider_secret_key", provider_secret_key)
        if provider_shared_secret is not None:
            pulumi.set(__self__, "provider_shared_secret", provider_shared_secret)
        if provider_type is not None:
            pulumi.set(__self__, "provider_type", provider_type)
        if provider_user_name_template is not None:
            pulumi.set(__self__, "provider_user_name_template", provider_user_name_template)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable string that identifies the authenticator. Some authenticators are available by feature flag on the organization. Possible values inclue: `duo`, `external_idp`, `google_otp`, `okta_email`, `okta_password`, `okta_verify`, `onprem_mfa`, `phone_number`, `rsa_token`, `security_question`, `webauthn`
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="legacyIgnoreName")
    def legacy_ignore_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Name does not trigger change detection (legacy behavior)
        """
        return pulumi.get(self, "legacy_ignore_name")

    @legacy_ignore_name.setter
    def legacy_ignore_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "legacy_ignore_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the Authenticator
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_auth_port")

    @provider_auth_port.setter
    def provider_auth_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provider_auth_port", value)

    @_builtins.property
    @pulumi.getter(name="providerHost")
    def provider_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (DUO specific) - The Duo Security API hostname. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_host")

    @provider_host.setter
    def provider_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_host", value)

    @_builtins.property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server host name or IP address. Default is `localhost`. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_hostname")

    @provider_hostname.setter
    def provider_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_hostname", value)

    @_builtins.property
    @pulumi.getter(name="providerInstanceId")
    def provider_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App Instance ID.
        """
        return pulumi.get(self, "provider_instance_id")

    @provider_instance_id.setter
    def provider_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="providerIntegrationKey")
    def provider_integration_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (DUO specific) - The Duo Security integration key.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_integration_key")

    @provider_integration_key.setter
    def provider_integration_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_integration_key", value)

    @_builtins.property
    @pulumi.getter(name="providerJson")
    def provider_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider JSON allows for expressive providervalues. This argument conflicts with the other 'provider_xxx' arguments. The [CreateProvider](https://developer.okta.com/docs/reference/api/authenticators-admin/#request) illustrates detailed provider values for a Duo authenticator. [Provider values](https://developer.okta.com/docs/reference/api/authenticators-admin/#authenticators-administration-api-object)are listed in Okta API.
        """
        return pulumi.get(self, "provider_json")

    @provider_json.setter
    def provider_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_json", value)

    @_builtins.property
    @pulumi.getter(name="providerSecretKey")
    def provider_secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (DUO specific) - The Duo Security secret key.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_secret_key")

    @provider_secret_key.setter
    def provider_secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_secret_key", value)

    @_builtins.property
    @pulumi.getter(name="providerSharedSecret")
    def provider_shared_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_shared_secret")

    @provider_shared_secret.setter
    def provider_shared_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_shared_secret", value)

    @_builtins.property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider type. Supported value for Duo: `DUO`. Supported value for Custom App: `PUSH`
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_type", value)

    @_builtins.property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template expected by the provider. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_user_name_template")

    @provider_user_name_template.setter
    def provider_user_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_user_name_template", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Settings for the authenticator. The settings JSON contains values based on Authenticator key. It is not used for authenticators with type `security_key`
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authenticator status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        he type of Authenticator. Values include: `password`, `security_question`, `phone`, `email`, `app`, `federated`, and `security_key`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("okta:index/authenticator:Authenticator")
class Authenticator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 legacy_ignore_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auth_port: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_host: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_integration_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_json: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

        This resource allows you to configure different authenticators.

        > **Create:** The Okta API has an odd notion of create for authenticators. If
        the authenticator doesn't exist then a one time 'POST /api/v1/authenticators' to
        create the authenticator (hard create) will be performed. Thereafter, that
        authenticator is never deleted, it is only deactivated (soft delete). Therefore,
        if the authenticator already exists create is just a soft import of an existing
        authenticator. This does not apply to custom_otp authenticator. There can be
        multiple custom_otp authenticator. To create new custom_otp authenticator, a new
        name and key = custom_otp is required. If an old name is used, it will simply
        reactivate the old custom_otp authenticator

        > **Update:** custom_otp authenticator cannot be updated

        > **Delete:** Authenticators can not be truly deleted therefore delete is soft.
        Delete will attempt to deativate the authenticator. An authenticator can only be
        deactivated if it's not in use by any other policy.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.Authenticator("test",
            name="Security Question",
            key="security_question",
            settings=json.dumps({
                "allowedFor": "recovery",
            }))
        otp = okta.Authenticator("otp",
            name="Custom OTP",
            key="custom_otp",
            status="ACTIVE",
            settings=json.dumps({
                "protocol": "TOTP",
                "acceptableAdjacentIntervals": 3,
                "timeIntervalInSeconds": 30,
                "encoding": "base32",
                "algorithm": "HMacSHA256",
                "passCodeLength": 6,
            }),
            legacy_ignore_name=False)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/authenticator:Authenticator example <authenticator_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key: A human-readable string that identifies the authenticator. Some authenticators are available by feature flag on the organization. Possible values inclue: `duo`, `external_idp`, `google_otp`, `okta_email`, `okta_password`, `okta_verify`, `onprem_mfa`, `phone_number`, `rsa_token`, `security_question`, `webauthn`
        :param pulumi.Input[_builtins.bool] legacy_ignore_name: Name does not trigger change detection (legacy behavior)
        :param pulumi.Input[_builtins.str] name: Display name of the Authenticator
        :param pulumi.Input[_builtins.int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_host: (DUO specific) - The Duo Security API hostname. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_hostname: Server host name or IP address. Default is `localhost`. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_integration_key: (DUO specific) - The Duo Security integration key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_json: Provider JSON allows for expressive providervalues. This argument conflicts with the other 'provider_xxx' arguments. The [CreateProvider](https://developer.okta.com/docs/reference/api/authenticators-admin/#request) illustrates detailed provider values for a Duo authenticator. [Provider values](https://developer.okta.com/docs/reference/api/authenticators-admin/#authenticators-administration-api-object)are listed in Okta API.
        :param pulumi.Input[_builtins.str] provider_secret_key: (DUO specific) - The Duo Security secret key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] settings: Settings for the authenticator. The settings JSON contains values based on Authenticator key. It is not used for authenticators with type `security_key`
        :param pulumi.Input[_builtins.str] status: Authenticator status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

        This resource allows you to configure different authenticators.

        > **Create:** The Okta API has an odd notion of create for authenticators. If
        the authenticator doesn't exist then a one time 'POST /api/v1/authenticators' to
        create the authenticator (hard create) will be performed. Thereafter, that
        authenticator is never deleted, it is only deactivated (soft delete). Therefore,
        if the authenticator already exists create is just a soft import of an existing
        authenticator. This does not apply to custom_otp authenticator. There can be
        multiple custom_otp authenticator. To create new custom_otp authenticator, a new
        name and key = custom_otp is required. If an old name is used, it will simply
        reactivate the old custom_otp authenticator

        > **Update:** custom_otp authenticator cannot be updated

        > **Delete:** Authenticators can not be truly deleted therefore delete is soft.
        Delete will attempt to deativate the authenticator. An authenticator can only be
        deactivated if it's not in use by any other policy.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.Authenticator("test",
            name="Security Question",
            key="security_question",
            settings=json.dumps({
                "allowedFor": "recovery",
            }))
        otp = okta.Authenticator("otp",
            name="Custom OTP",
            key="custom_otp",
            status="ACTIVE",
            settings=json.dumps({
                "protocol": "TOTP",
                "acceptableAdjacentIntervals": 3,
                "timeIntervalInSeconds": 30,
                "encoding": "base32",
                "algorithm": "HMacSHA256",
                "passCodeLength": 6,
            }),
            legacy_ignore_name=False)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/authenticator:Authenticator example <authenticator_id>
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 legacy_ignore_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_auth_port: Optional[pulumi.Input[_builtins.int]] = None,
                 provider_host: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_integration_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_json: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticatorArgs.__new__(AuthenticatorArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["legacy_ignore_name"] = legacy_ignore_name
            __props__.__dict__["name"] = name
            __props__.__dict__["provider_auth_port"] = provider_auth_port
            __props__.__dict__["provider_host"] = provider_host
            __props__.__dict__["provider_hostname"] = provider_hostname
            __props__.__dict__["provider_integration_key"] = provider_integration_key
            __props__.__dict__["provider_json"] = provider_json
            __props__.__dict__["provider_secret_key"] = provider_secret_key
            __props__.__dict__["provider_shared_secret"] = None if provider_shared_secret is None else pulumi.Output.secret(provider_shared_secret)
            __props__.__dict__["provider_user_name_template"] = provider_user_name_template
            __props__.__dict__["settings"] = settings
            __props__.__dict__["status"] = status
            __props__.__dict__["provider_instance_id"] = None
            __props__.__dict__["provider_type"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["providerSharedSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Authenticator, __self__).__init__(
            'okta:index/authenticator:Authenticator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            legacy_ignore_name: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            provider_auth_port: Optional[pulumi.Input[_builtins.int]] = None,
            provider_host: Optional[pulumi.Input[_builtins.str]] = None,
            provider_hostname: Optional[pulumi.Input[_builtins.str]] = None,
            provider_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            provider_integration_key: Optional[pulumi.Input[_builtins.str]] = None,
            provider_json: Optional[pulumi.Input[_builtins.str]] = None,
            provider_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            provider_shared_secret: Optional[pulumi.Input[_builtins.str]] = None,
            provider_type: Optional[pulumi.Input[_builtins.str]] = None,
            provider_user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Authenticator':
        """
        Get an existing Authenticator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key: A human-readable string that identifies the authenticator. Some authenticators are available by feature flag on the organization. Possible values inclue: `duo`, `external_idp`, `google_otp`, `okta_email`, `okta_password`, `okta_verify`, `onprem_mfa`, `phone_number`, `rsa_token`, `security_question`, `webauthn`
        :param pulumi.Input[_builtins.bool] legacy_ignore_name: Name does not trigger change detection (legacy behavior)
        :param pulumi.Input[_builtins.str] name: Display name of the Authenticator
        :param pulumi.Input[_builtins.int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_host: (DUO specific) - The Duo Security API hostname. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_hostname: Server host name or IP address. Default is `localhost`. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_instance_id: App Instance ID.
        :param pulumi.Input[_builtins.str] provider_integration_key: (DUO specific) - The Duo Security integration key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_json: Provider JSON allows for expressive providervalues. This argument conflicts with the other 'provider_xxx' arguments. The [CreateProvider](https://developer.okta.com/docs/reference/api/authenticators-admin/#request) illustrates detailed provider values for a Duo authenticator. [Provider values](https://developer.okta.com/docs/reference/api/authenticators-admin/#authenticators-administration-api-object)are listed in Okta API.
        :param pulumi.Input[_builtins.str] provider_secret_key: (DUO specific) - The Duo Security secret key.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] provider_type: Provider type. Supported value for Duo: `DUO`. Supported value for Custom App: `PUSH`
        :param pulumi.Input[_builtins.str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        :param pulumi.Input[_builtins.str] settings: Settings for the authenticator. The settings JSON contains values based on Authenticator key. It is not used for authenticators with type `security_key`
        :param pulumi.Input[_builtins.str] status: Authenticator status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] type: he type of Authenticator. Values include: `password`, `security_question`, `phone`, `email`, `app`, `federated`, and `security_key`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticatorState.__new__(_AuthenticatorState)

        __props__.__dict__["key"] = key
        __props__.__dict__["legacy_ignore_name"] = legacy_ignore_name
        __props__.__dict__["name"] = name
        __props__.__dict__["provider_auth_port"] = provider_auth_port
        __props__.__dict__["provider_host"] = provider_host
        __props__.__dict__["provider_hostname"] = provider_hostname
        __props__.__dict__["provider_instance_id"] = provider_instance_id
        __props__.__dict__["provider_integration_key"] = provider_integration_key
        __props__.__dict__["provider_json"] = provider_json
        __props__.__dict__["provider_secret_key"] = provider_secret_key
        __props__.__dict__["provider_shared_secret"] = provider_shared_secret
        __props__.__dict__["provider_type"] = provider_type
        __props__.__dict__["provider_user_name_template"] = provider_user_name_template
        __props__.__dict__["settings"] = settings
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return Authenticator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable string that identifies the authenticator. Some authenticators are available by feature flag on the organization. Possible values inclue: `duo`, `external_idp`, `google_otp`, `okta_email`, `okta_password`, `okta_verify`, `onprem_mfa`, `phone_number`, `rsa_token`, `security_question`, `webauthn`
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="legacyIgnoreName")
    def legacy_ignore_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Name does not trigger change detection (legacy behavior)
        """
        return pulumi.get(self, "legacy_ignore_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name of the Authenticator
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_auth_port")

    @_builtins.property
    @pulumi.getter(name="providerHost")
    def provider_host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (DUO specific) - The Duo Security API hostname. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_host")

    @_builtins.property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Server host name or IP address. Default is `localhost`. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_hostname")

    @_builtins.property
    @pulumi.getter(name="providerInstanceId")
    def provider_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        App Instance ID.
        """
        return pulumi.get(self, "provider_instance_id")

    @_builtins.property
    @pulumi.getter(name="providerIntegrationKey")
    def provider_integration_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (DUO specific) - The Duo Security integration key.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_integration_key")

    @_builtins.property
    @pulumi.getter(name="providerJson")
    def provider_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provider JSON allows for expressive providervalues. This argument conflicts with the other 'provider_xxx' arguments. The [CreateProvider](https://developer.okta.com/docs/reference/api/authenticators-admin/#request) illustrates detailed provider values for a Duo authenticator. [Provider values](https://developer.okta.com/docs/reference/api/authenticators-admin/#authenticators-administration-api-object)are listed in Okta API.
        """
        return pulumi.get(self, "provider_json")

    @_builtins.property
    @pulumi.getter(name="providerSecretKey")
    def provider_secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (DUO specific) - The Duo Security secret key.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_secret_key")

    @_builtins.property
    @pulumi.getter(name="providerSharedSecret")
    def provider_shared_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `security_key`. Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_shared_secret")

    @_builtins.property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Output[_builtins.str]:
        """
        Provider type. Supported value for Duo: `DUO`. Supported value for Custom App: `PUSH`
        """
        return pulumi.get(self, "provider_type")

    @_builtins.property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username template expected by the provider. Used only for authenticators with type `security_key`.  Conflicts with `provider_json` argument.
        """
        return pulumi.get(self, "provider_user_name_template")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Settings for the authenticator. The settings JSON contains values based on Authenticator key. It is not used for authenticators with type `security_key`
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Authenticator status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        he type of Authenticator. Values include: `password`, `security_question`, `phone`, `email`, `app`, `federated`, and `security_key`.
        """
        return pulumi.get(self, "type")

