# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAppSignonPolicyResult',
    'AwaitableGetAppSignonPolicyResult',
    'get_app_signon_policy',
    'get_app_signon_policy_output',
]

@pulumi.output_type
class GetAppSignonPolicyResult:
    """
    A collection of values returned by getAppSignonPolicy.
    """
    def __init__(__self__, app_id=None, id=None, name=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        App ID
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Policy name
        """
        return pulumi.get(self, "name")


class AwaitableGetAppSignonPolicyResult(GetAppSignonPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppSignonPolicyResult(
            app_id=self.app_id,
            id=self.id,
            name=self.name)


def get_app_signon_policy(app_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppSignonPolicyResult:
    """
    Get a sign-on policy for the application.

    > **WARNING:** This feature is only available as a part of the
    Identity Engine. Contact support
    for further information.

    > Inside the product a sign-on policy is referenced as an _authentication
    policy_, in the public API the policy is of type
    [`ACCESS_POLICY`](https://developer.okta.com/docs/reference/api/policy/#policy-object).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_app_signon_policy(app_id="app_id")
    ```


    :param _builtins.str app_id: App ID
    """
    __args__ = dict()
    __args__['appId'] = app_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getAppSignonPolicy:getAppSignonPolicy', __args__, opts=opts, typ=GetAppSignonPolicyResult).value

    return AwaitableGetAppSignonPolicyResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_app_signon_policy_output(app_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppSignonPolicyResult]:
    """
    Get a sign-on policy for the application.

    > **WARNING:** This feature is only available as a part of the
    Identity Engine. Contact support
    for further information.

    > Inside the product a sign-on policy is referenced as an _authentication
    policy_, in the public API the policy is of type
    [`ACCESS_POLICY`](https://developer.okta.com/docs/reference/api/policy/#policy-object).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_app_signon_policy(app_id="app_id")
    ```


    :param _builtins.str app_id: App ID
    """
    __args__ = dict()
    __args__['appId'] = app_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getAppSignonPolicy:getAppSignonPolicy', __args__, opts=opts, typ=GetAppSignonPolicyResult)
    return __ret__.apply(lambda __response__: GetAppSignonPolicyResult(
        app_id=pulumi.get(__response__, 'app_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
