# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAppUserAssignmentsResult',
    'AwaitableGetAppUserAssignmentsResult',
    'get_app_user_assignments',
    'get_app_user_assignments_output',
]

@pulumi.output_type
class GetAppUserAssignmentsResult:
    """
    A collection of values returned by getAppUserAssignments.
    """
    def __init__(__self__, id=None, users=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the Okta App being queried for groups
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence[_builtins.str]:
        """
        List of user IDs assigned to the app
        """
        return pulumi.get(self, "users")


class AwaitableGetAppUserAssignmentsResult(GetAppUserAssignmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppUserAssignmentsResult(
            id=self.id,
            users=self.users)


def get_app_user_assignments(id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppUserAssignmentsResult:
    """
    Get a set of users assigned to an Okta application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_app_user_assignments(id=test_okta_app_oauth["id"])
    ```


    :param _builtins.str id: ID of the Okta App being queried for groups
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getAppUserAssignments:getAppUserAssignments', __args__, opts=opts, typ=GetAppUserAssignmentsResult).value

    return AwaitableGetAppUserAssignmentsResult(
        id=pulumi.get(__ret__, 'id'),
        users=pulumi.get(__ret__, 'users'))
def get_app_user_assignments_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppUserAssignmentsResult]:
    """
    Get a set of users assigned to an Okta application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_app_user_assignments(id=test_okta_app_oauth["id"])
    ```


    :param _builtins.str id: ID of the Okta App being queried for groups
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getAppUserAssignments:getAppUserAssignments', __args__, opts=opts, typ=GetAppUserAssignmentsResult)
    return __ret__.apply(lambda __response__: GetAppUserAssignmentsResult(
        id=pulumi.get(__response__, 'id'),
        users=pulumi.get(__response__, 'users')))
