# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetRealmAssignmentResult',
    'AwaitableGetRealmAssignmentResult',
    'get_realm_assignment',
    'get_realm_assignment_output',
]

@pulumi.output_type
class GetRealmAssignmentResult:
    """
    A collection of values returned by getRealmAssignment.
    """
    def __init__(__self__, condition_expression=None, id=None, is_default=None, name=None, priority=None, profile_source_id=None, realm_id=None, status=None):
        if condition_expression and not isinstance(condition_expression, str):
            raise TypeError("Expected argument 'condition_expression' to be a str")
        pulumi.set(__self__, "condition_expression", condition_expression)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if profile_source_id and not isinstance(profile_source_id, str):
            raise TypeError("Expected argument 'profile_source_id' to be a str")
        pulumi.set(__self__, "profile_source_id", profile_source_id)
        if realm_id and not isinstance(realm_id, str):
            raise TypeError("Expected argument 'realm_id' to be a str")
        pulumi.set(__self__, "realm_id", realm_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="conditionExpression")
    def condition_expression(self) -> _builtins.str:
        """
        Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        """
        return pulumi.get(self, "condition_expression")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Realm Assignment ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Indicates whether the realm assignment is the default.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Okta Realm Assignment.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The Priority of the Realm Assignment. The lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="profileSourceId")
    def profile_source_id(self) -> _builtins.str:
        """
        The ID of the Profile Source.
        """
        return pulumi.get(self, "profile_source_id")

    @_builtins.property
    @pulumi.getter(name="realmId")
    def realm_id(self) -> _builtins.str:
        """
        The ID of the Realm asscociated with the Realm Assignment.
        """
        return pulumi.get(self, "realm_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        return pulumi.get(self, "status")


class AwaitableGetRealmAssignmentResult(GetRealmAssignmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRealmAssignmentResult(
            condition_expression=self.condition_expression,
            id=self.id,
            is_default=self.is_default,
            name=self.name,
            priority=self.priority,
            profile_source_id=self.profile_source_id,
            realm_id=self.realm_id,
            status=self.status)


def get_realm_assignment(name: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRealmAssignmentResult:
    """
    Get a realm assignment from Okta.


    :param _builtins.str name: The name of the Okta Realm Assignment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getRealmAssignment:getRealmAssignment', __args__, opts=opts, typ=GetRealmAssignmentResult).value

    return AwaitableGetRealmAssignmentResult(
        condition_expression=pulumi.get(__ret__, 'condition_expression'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        name=pulumi.get(__ret__, 'name'),
        priority=pulumi.get(__ret__, 'priority'),
        profile_source_id=pulumi.get(__ret__, 'profile_source_id'),
        realm_id=pulumi.get(__ret__, 'realm_id'),
        status=pulumi.get(__ret__, 'status'))
def get_realm_assignment_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRealmAssignmentResult]:
    """
    Get a realm assignment from Okta.


    :param _builtins.str name: The name of the Okta Realm Assignment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getRealmAssignment:getRealmAssignment', __args__, opts=opts, typ=GetRealmAssignmentResult)
    return __ret__.apply(lambda __response__: GetRealmAssignmentResult(
        condition_expression=pulumi.get(__response__, 'condition_expression'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        name=pulumi.get(__response__, 'name'),
        priority=pulumi.get(__response__, 'priority'),
        profile_source_id=pulumi.get(__response__, 'profile_source_id'),
        realm_id=pulumi.get(__response__, 'realm_id'),
        status=pulumi.get(__response__, 'status')))
