# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTemplatesResult',
    'AwaitableGetTemplatesResult',
    'get_templates',
    'get_templates_output',
]

@pulumi.output_type
class GetTemplatesResult:
    """
    A collection of values returned by getTemplates.
    """
    def __init__(__self__, brand_id=None, email_templates=None, id=None):
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if email_templates and not isinstance(email_templates, list):
            raise TypeError("Expected argument 'email_templates' to be a list")
        pulumi.set(__self__, "email_templates", email_templates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> _builtins.str:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @_builtins.property
    @pulumi.getter(name="emailTemplates")
    def email_templates(self) -> Sequence['outputs.GetTemplatesEmailTemplateResult']:
        """
        List of `get_template` belonging to a brand in the organization
        """
        return pulumi.get(self, "email_templates")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetTemplatesResult(GetTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplatesResult(
            brand_id=self.brand_id,
            email_templates=self.email_templates,
            id=self.id)


def get_templates(brand_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplatesResult:
    """
    Get the email templates belonging to a brand in an Okta organization.


    :param _builtins.str brand_id: Brand ID
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getTemplates:getTemplates', __args__, opts=opts, typ=GetTemplatesResult).value

    return AwaitableGetTemplatesResult(
        brand_id=pulumi.get(__ret__, 'brand_id'),
        email_templates=pulumi.get(__ret__, 'email_templates'),
        id=pulumi.get(__ret__, 'id'))
def get_templates_output(brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTemplatesResult]:
    """
    Get the email templates belonging to a brand in an Okta organization.


    :param _builtins.str brand_id: Brand ID
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getTemplates:getTemplates', __args__, opts=opts, typ=GetTemplatesResult)
    return __ret__.apply(lambda __response__: GetTemplatesResult(
        brand_id=pulumi.get(__response__, 'brand_id'),
        email_templates=pulumi.get(__response__, 'email_templates'),
        id=pulumi.get(__response__, 'id')))
