# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 role_type: pulumi.Input[_builtins.str],
                 disable_notifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_app_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[_builtins.str] group_id: ID of group to attach admin roles to
        :param pulumi.Input[_builtins.str] role_type: Admin role assigned to the group. It can be any one of the following values:
               	"API_ADMIN",
               	"APP_ADMIN",
               	"CUSTOM",
               	"GROUP_MEMBERSHIP_ADMIN",
               	"HELP_DESK_ADMIN",
               	"MOBILE_ADMIN",
               	"ORG_ADMIN",
               	"READ_ONLY_ADMIN",
               	"REPORT_ADMIN",
               	"SUPER_ADMIN",
               	"USER_ADMIN"
               	. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles).
               	- "USER_ADMIN" is the Group Administrator.
        :param pulumi.Input[_builtins.bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        :param pulumi.Input[_builtins.str] resource_set_id: Resource Set ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[_builtins.str] role_id: Role ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_app_lists: A list of app names (name represents set of app instances, like 'salesforce' or 'facebook'), or a combination of app name and app instance ID (like 'facebook.0oapsqQ6dv19pqyEo0g3') you would like as the targets of the admin role. - Only supported when used with the role type `APP_ADMIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_group_lists: A list of group IDs you would like as the targets of the admin role. - Only supported when used with the role types: `GROUP_MEMBERSHIP_ADMIN`, `HELP_DESK_ADMIN`, or `USER_ADMIN`.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "role_type", role_type)
        if disable_notifications is not None:
            pulumi.set(__self__, "disable_notifications", disable_notifications)
        if resource_set_id is not None:
            pulumi.set(__self__, "resource_set_id", resource_set_id)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if target_app_lists is not None:
            pulumi.set(__self__, "target_app_lists", target_app_lists)
        if target_group_lists is not None:
            pulumi.set(__self__, "target_group_lists", target_group_lists)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of group to attach admin roles to
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Input[_builtins.str]:
        """
        Admin role assigned to the group. It can be any one of the following values:
        	"API_ADMIN",
        	"APP_ADMIN",
        	"CUSTOM",
        	"GROUP_MEMBERSHIP_ADMIN",
        	"HELP_DESK_ADMIN",
        	"MOBILE_ADMIN",
        	"ORG_ADMIN",
        	"READ_ONLY_ADMIN",
        	"REPORT_ADMIN",
        	"SUPER_ADMIN",
        	"USER_ADMIN"
        	. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles).
        	- "USER_ADMIN" is the Group Administrator.
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter(name="disableNotifications")
    def disable_notifications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        """
        return pulumi.get(self, "disable_notifications")

    @disable_notifications.setter
    def disable_notifications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_notifications", value)

    @_builtins.property
    @pulumi.getter(name="resourceSetId")
    def resource_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Set ID. Required for role_type = `CUSTOM`
        """
        return pulumi.get(self, "resource_set_id")

    @resource_set_id.setter
    def resource_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_set_id", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role ID. Required for role_type = `CUSTOM`
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="targetAppLists")
    def target_app_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of app names (name represents set of app instances, like 'salesforce' or 'facebook'), or a combination of app name and app instance ID (like 'facebook.0oapsqQ6dv19pqyEo0g3') you would like as the targets of the admin role. - Only supported when used with the role type `APP_ADMIN`.
        """
        return pulumi.get(self, "target_app_lists")

    @target_app_lists.setter
    def target_app_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_app_lists", value)

    @_builtins.property
    @pulumi.getter(name="targetGroupLists")
    def target_group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of group IDs you would like as the targets of the admin role. - Only supported when used with the role types: `GROUP_MEMBERSHIP_ADMIN`, `HELP_DESK_ADMIN`, or `USER_ADMIN`.
        """
        return pulumi.get(self, "target_group_lists")

    @target_group_lists.setter
    def target_group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_group_lists", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 disable_notifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_app_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[_builtins.bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        :param pulumi.Input[_builtins.str] group_id: ID of group to attach admin roles to
        :param pulumi.Input[_builtins.str] resource_set_id: Resource Set ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[_builtins.str] role_id: Role ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[_builtins.str] role_type: Admin role assigned to the group. It can be any one of the following values:
               	"API_ADMIN",
               	"APP_ADMIN",
               	"CUSTOM",
               	"GROUP_MEMBERSHIP_ADMIN",
               	"HELP_DESK_ADMIN",
               	"MOBILE_ADMIN",
               	"ORG_ADMIN",
               	"READ_ONLY_ADMIN",
               	"REPORT_ADMIN",
               	"SUPER_ADMIN",
               	"USER_ADMIN"
               	. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles).
               	- "USER_ADMIN" is the Group Administrator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_app_lists: A list of app names (name represents set of app instances, like 'salesforce' or 'facebook'), or a combination of app name and app instance ID (like 'facebook.0oapsqQ6dv19pqyEo0g3') you would like as the targets of the admin role. - Only supported when used with the role type `APP_ADMIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_group_lists: A list of group IDs you would like as the targets of the admin role. - Only supported when used with the role types: `GROUP_MEMBERSHIP_ADMIN`, `HELP_DESK_ADMIN`, or `USER_ADMIN`.
        """
        if disable_notifications is not None:
            pulumi.set(__self__, "disable_notifications", disable_notifications)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if resource_set_id is not None:
            pulumi.set(__self__, "resource_set_id", resource_set_id)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if target_app_lists is not None:
            pulumi.set(__self__, "target_app_lists", target_app_lists)
        if target_group_lists is not None:
            pulumi.set(__self__, "target_group_lists", target_group_lists)

    @_builtins.property
    @pulumi.getter(name="disableNotifications")
    def disable_notifications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        """
        return pulumi.get(self, "disable_notifications")

    @disable_notifications.setter
    def disable_notifications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_notifications", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of group to attach admin roles to
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceSetId")
    def resource_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Set ID. Required for role_type = `CUSTOM`
        """
        return pulumi.get(self, "resource_set_id")

    @resource_set_id.setter
    def resource_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_set_id", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role ID. Required for role_type = `CUSTOM`
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Admin role assigned to the group. It can be any one of the following values:
        	"API_ADMIN",
        	"APP_ADMIN",
        	"CUSTOM",
        	"GROUP_MEMBERSHIP_ADMIN",
        	"HELP_DESK_ADMIN",
        	"MOBILE_ADMIN",
        	"ORG_ADMIN",
        	"READ_ONLY_ADMIN",
        	"REPORT_ADMIN",
        	"SUPER_ADMIN",
        	"USER_ADMIN"
        	. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles).
        	- "USER_ADMIN" is the Group Administrator.
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter(name="targetAppLists")
    def target_app_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of app names (name represents set of app instances, like 'salesforce' or 'facebook'), or a combination of app name and app instance ID (like 'facebook.0oapsqQ6dv19pqyEo0g3') you would like as the targets of the admin role. - Only supported when used with the role type `APP_ADMIN`.
        """
        return pulumi.get(self, "target_app_lists")

    @target_app_lists.setter
    def target_app_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_app_lists", value)

    @_builtins.property
    @pulumi.getter(name="targetGroupLists")
    def target_group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of group IDs you would like as the targets of the admin role. - Only supported when used with the role types: `GROUP_MEMBERSHIP_ADMIN`, `HELP_DESK_ADMIN`, or `USER_ADMIN`.
        """
        return pulumi.get(self, "target_group_lists")

    @target_group_lists.setter
    def target_group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_group_lists", value)


@pulumi.type_token("okta:group/role:Role")
class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_notifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_app_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Assigns Admin roles to Okta Groups. This resource allows you to assign Okta administrator roles to Okta Groups. This resource provides a one-to-one interface between the Okta group and the admin role.

        ## Import

        ```sh
        $ pulumi import okta:group/role:Role example <group_id>/<role_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        :param pulumi.Input[_builtins.str] group_id: ID of group to attach admin roles to
        :param pulumi.Input[_builtins.str] resource_set_id: Resource Set ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[_builtins.str] role_id: Role ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[_builtins.str] role_type: Admin role assigned to the group. It can be any one of the following values:
               	"API_ADMIN",
               	"APP_ADMIN",
               	"CUSTOM",
               	"GROUP_MEMBERSHIP_ADMIN",
               	"HELP_DESK_ADMIN",
               	"MOBILE_ADMIN",
               	"ORG_ADMIN",
               	"READ_ONLY_ADMIN",
               	"REPORT_ADMIN",
               	"SUPER_ADMIN",
               	"USER_ADMIN"
               	. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles).
               	- "USER_ADMIN" is the Group Administrator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_app_lists: A list of app names (name represents set of app instances, like 'salesforce' or 'facebook'), or a combination of app name and app instance ID (like 'facebook.0oapsqQ6dv19pqyEo0g3') you would like as the targets of the admin role. - Only supported when used with the role type `APP_ADMIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_group_lists: A list of group IDs you would like as the targets of the admin role. - Only supported when used with the role types: `GROUP_MEMBERSHIP_ADMIN`, `HELP_DESK_ADMIN`, or `USER_ADMIN`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Assigns Admin roles to Okta Groups. This resource allows you to assign Okta administrator roles to Okta Groups. This resource provides a one-to-one interface between the Okta group and the admin role.

        ## Import

        ```sh
        $ pulumi import okta:group/role:Role example <group_id>/<role_id>
        ```

        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_notifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_app_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            __props__.__dict__["disable_notifications"] = disable_notifications
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["resource_set_id"] = resource_set_id
            __props__.__dict__["role_id"] = role_id
            if role_type is None and not opts.urn:
                raise TypeError("Missing required property 'role_type'")
            __props__.__dict__["role_type"] = role_type
            __props__.__dict__["target_app_lists"] = target_app_lists
            __props__.__dict__["target_group_lists"] = target_group_lists
        super(Role, __self__).__init__(
            'okta:group/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disable_notifications: Optional[pulumi.Input[_builtins.bool]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_type: Optional[pulumi.Input[_builtins.str]] = None,
            target_app_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disable_notifications: When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        :param pulumi.Input[_builtins.str] group_id: ID of group to attach admin roles to
        :param pulumi.Input[_builtins.str] resource_set_id: Resource Set ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[_builtins.str] role_id: Role ID. Required for role_type = `CUSTOM`
        :param pulumi.Input[_builtins.str] role_type: Admin role assigned to the group. It can be any one of the following values:
               	"API_ADMIN",
               	"APP_ADMIN",
               	"CUSTOM",
               	"GROUP_MEMBERSHIP_ADMIN",
               	"HELP_DESK_ADMIN",
               	"MOBILE_ADMIN",
               	"ORG_ADMIN",
               	"READ_ONLY_ADMIN",
               	"REPORT_ADMIN",
               	"SUPER_ADMIN",
               	"USER_ADMIN"
               	. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles).
               	- "USER_ADMIN" is the Group Administrator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_app_lists: A list of app names (name represents set of app instances, like 'salesforce' or 'facebook'), or a combination of app name and app instance ID (like 'facebook.0oapsqQ6dv19pqyEo0g3') you would like as the targets of the admin role. - Only supported when used with the role type `APP_ADMIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_group_lists: A list of group IDs you would like as the targets of the admin role. - Only supported when used with the role types: `GROUP_MEMBERSHIP_ADMIN`, `HELP_DESK_ADMIN`, or `USER_ADMIN`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["disable_notifications"] = disable_notifications
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["resource_set_id"] = resource_set_id
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["role_type"] = role_type
        __props__.__dict__["target_app_lists"] = target_app_lists
        __props__.__dict__["target_group_lists"] = target_group_lists
        return Role(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="disableNotifications")
    def disable_notifications(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When this setting is enabled, the admins won't receive any of the default Okta administrator emails. These admins also won't have access to contact Okta Support and open support cases on behalf of your org.
        """
        return pulumi.get(self, "disable_notifications")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of group to attach admin roles to
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="resourceSetId")
    def resource_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource Set ID. Required for role_type = `CUSTOM`
        """
        return pulumi.get(self, "resource_set_id")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Role ID. Required for role_type = `CUSTOM`
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Output[_builtins.str]:
        """
        Admin role assigned to the group. It can be any one of the following values:
        	"API_ADMIN",
        	"APP_ADMIN",
        	"CUSTOM",
        	"GROUP_MEMBERSHIP_ADMIN",
        	"HELP_DESK_ADMIN",
        	"MOBILE_ADMIN",
        	"ORG_ADMIN",
        	"READ_ONLY_ADMIN",
        	"REPORT_ADMIN",
        	"SUPER_ADMIN",
        	"USER_ADMIN"
        	. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles).
        	- "USER_ADMIN" is the Group Administrator.
        """
        return pulumi.get(self, "role_type")

    @_builtins.property
    @pulumi.getter(name="targetAppLists")
    def target_app_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of app names (name represents set of app instances, like 'salesforce' or 'facebook'), or a combination of app name and app instance ID (like 'facebook.0oapsqQ6dv19pqyEo0g3') you would like as the targets of the admin role. - Only supported when used with the role type `APP_ADMIN`.
        """
        return pulumi.get(self, "target_app_lists")

    @_builtins.property
    @pulumi.getter(name="targetGroupLists")
    def target_group_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of group IDs you would like as the targets of the admin role. - Only supported when used with the role types: `GROUP_MEMBERSHIP_ADMIN`, `HELP_DESK_ADMIN`, or `USER_ADMIN`.
        """
        return pulumi.get(self, "target_group_lists")

