# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DeviceAssuranceWindowsArgs', 'DeviceAssuranceWindows']

@pulumi.input_type
class DeviceAssuranceWindowsArgs:
    def __init__(__self__, *,
                 disk_encryption_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_hardware_present: Optional[pulumi.Input[_builtins.bool]] = None,
                 third_party_signal_providers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_browser_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_builtin_dns_client_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_chrome_remote_desktop_app_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_crowd_strike_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_crowd_strike_customer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_device_enrollment_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_key_trust_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_os_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_password_proctection_warning_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_realtime_url_check_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_safe_browsing_protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_screen_lock_secured: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_site_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_third_party_blocking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_windows_machine_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_windows_user_domain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DeviceAssuranceWindows resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_encryption_types: List of disk encryption type, can be `ALL_INTERNAL_VOLUMES`
        :param pulumi.Input[_builtins.str] name: Name of the device assurance policy.
        :param pulumi.Input[_builtins.str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        :param pulumi.Input[_builtins.bool] secure_hardware_present: Is the device secure with hardware in the device assurance policy.
        :param pulumi.Input[_builtins.bool] third_party_signal_providers: Check to include third party signal provider
        :param pulumi.Input[_builtins.str] tpsp_browser_version: Third party signal provider minimum browser version
        :param pulumi.Input[_builtins.bool] tpsp_builtin_dns_client_enabled: Third party signal provider builtin dns client enable
        :param pulumi.Input[_builtins.bool] tpsp_chrome_remote_desktop_app_blocked: Third party signal provider chrome remote desktop app blocked
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_agent_id: Third party signal provider crowdstrike agent id
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_customer_id: Third party signal provider crowdstrike user id
        :param pulumi.Input[_builtins.str] tpsp_device_enrollment_domain: Third party signal provider device enrollment domain
        :param pulumi.Input[_builtins.bool] tpsp_disk_encrypted: Third party signal provider disk encrypted
        :param pulumi.Input[_builtins.str] tpsp_key_trust_level: Third party signal provider key trust level
        :param pulumi.Input[_builtins.bool] tpsp_os_firewall: Third party signal provider os firewall
        :param pulumi.Input[_builtins.str] tpsp_os_version: Third party signal provider minimum os version
        :param pulumi.Input[_builtins.str] tpsp_password_proctection_warning_trigger: Third party signal provider password protection warning trigger
        :param pulumi.Input[_builtins.bool] tpsp_realtime_url_check_mode: Third party signal provider realtime url check mode
        :param pulumi.Input[_builtins.str] tpsp_safe_browsing_protection_level: Third party signal provider safe browsing protection level
        :param pulumi.Input[_builtins.bool] tpsp_screen_lock_secured: Third party signal provider screen lock secure
        :param pulumi.Input[_builtins.bool] tpsp_secure_boot_enabled: Third party signal provider secure boot enabled
        :param pulumi.Input[_builtins.bool] tpsp_site_isolation_enabled: Third party signal provider site isolation enabled
        :param pulumi.Input[_builtins.bool] tpsp_third_party_blocking_enabled: Third party signal provider third party blocking enabled
        :param pulumi.Input[_builtins.str] tpsp_windows_machine_domain: Third party signal provider windows machine domain
        :param pulumi.Input[_builtins.str] tpsp_windows_user_domain: Third party signal provider windows user domain
        """
        if disk_encryption_types is not None:
            pulumi.set(__self__, "disk_encryption_types", disk_encryption_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if screenlock_types is not None:
            pulumi.set(__self__, "screenlock_types", screenlock_types)
        if secure_hardware_present is not None:
            pulumi.set(__self__, "secure_hardware_present", secure_hardware_present)
        if third_party_signal_providers is not None:
            pulumi.set(__self__, "third_party_signal_providers", third_party_signal_providers)
        if tpsp_browser_version is not None:
            pulumi.set(__self__, "tpsp_browser_version", tpsp_browser_version)
        if tpsp_builtin_dns_client_enabled is not None:
            pulumi.set(__self__, "tpsp_builtin_dns_client_enabled", tpsp_builtin_dns_client_enabled)
        if tpsp_chrome_remote_desktop_app_blocked is not None:
            pulumi.set(__self__, "tpsp_chrome_remote_desktop_app_blocked", tpsp_chrome_remote_desktop_app_blocked)
        if tpsp_crowd_strike_agent_id is not None:
            pulumi.set(__self__, "tpsp_crowd_strike_agent_id", tpsp_crowd_strike_agent_id)
        if tpsp_crowd_strike_customer_id is not None:
            pulumi.set(__self__, "tpsp_crowd_strike_customer_id", tpsp_crowd_strike_customer_id)
        if tpsp_device_enrollment_domain is not None:
            pulumi.set(__self__, "tpsp_device_enrollment_domain", tpsp_device_enrollment_domain)
        if tpsp_disk_encrypted is not None:
            pulumi.set(__self__, "tpsp_disk_encrypted", tpsp_disk_encrypted)
        if tpsp_key_trust_level is not None:
            pulumi.set(__self__, "tpsp_key_trust_level", tpsp_key_trust_level)
        if tpsp_os_firewall is not None:
            pulumi.set(__self__, "tpsp_os_firewall", tpsp_os_firewall)
        if tpsp_os_version is not None:
            pulumi.set(__self__, "tpsp_os_version", tpsp_os_version)
        if tpsp_password_proctection_warning_trigger is not None:
            pulumi.set(__self__, "tpsp_password_proctection_warning_trigger", tpsp_password_proctection_warning_trigger)
        if tpsp_realtime_url_check_mode is not None:
            pulumi.set(__self__, "tpsp_realtime_url_check_mode", tpsp_realtime_url_check_mode)
        if tpsp_safe_browsing_protection_level is not None:
            pulumi.set(__self__, "tpsp_safe_browsing_protection_level", tpsp_safe_browsing_protection_level)
        if tpsp_screen_lock_secured is not None:
            pulumi.set(__self__, "tpsp_screen_lock_secured", tpsp_screen_lock_secured)
        if tpsp_secure_boot_enabled is not None:
            pulumi.set(__self__, "tpsp_secure_boot_enabled", tpsp_secure_boot_enabled)
        if tpsp_site_isolation_enabled is not None:
            pulumi.set(__self__, "tpsp_site_isolation_enabled", tpsp_site_isolation_enabled)
        if tpsp_third_party_blocking_enabled is not None:
            pulumi.set(__self__, "tpsp_third_party_blocking_enabled", tpsp_third_party_blocking_enabled)
        if tpsp_windows_machine_domain is not None:
            pulumi.set(__self__, "tpsp_windows_machine_domain", tpsp_windows_machine_domain)
        if tpsp_windows_user_domain is not None:
            pulumi.set(__self__, "tpsp_windows_user_domain", tpsp_windows_user_domain)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionTypes")
    def disk_encryption_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of disk encryption type, can be `ALL_INTERNAL_VOLUMES`
        """
        return pulumi.get(self, "disk_encryption_types")

    @disk_encryption_types.setter
    def disk_encryption_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_encryption_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the device assurance policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum os version of the device in the device assurance policy.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_version", value)

    @_builtins.property
    @pulumi.getter(name="screenlockTypes")
    def screenlock_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        return pulumi.get(self, "screenlock_types")

    @screenlock_types.setter
    def screenlock_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "screenlock_types", value)

    @_builtins.property
    @pulumi.getter(name="secureHardwarePresent")
    def secure_hardware_present(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the device secure with hardware in the device assurance policy.
        """
        return pulumi.get(self, "secure_hardware_present")

    @secure_hardware_present.setter
    def secure_hardware_present(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure_hardware_present", value)

    @_builtins.property
    @pulumi.getter(name="thirdPartySignalProviders")
    def third_party_signal_providers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check to include third party signal provider
        """
        return pulumi.get(self, "third_party_signal_providers")

    @third_party_signal_providers.setter
    def third_party_signal_providers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "third_party_signal_providers", value)

    @_builtins.property
    @pulumi.getter(name="tpspBrowserVersion")
    def tpsp_browser_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider minimum browser version
        """
        return pulumi.get(self, "tpsp_browser_version")

    @tpsp_browser_version.setter
    def tpsp_browser_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_browser_version", value)

    @_builtins.property
    @pulumi.getter(name="tpspBuiltinDnsClientEnabled")
    def tpsp_builtin_dns_client_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider builtin dns client enable
        """
        return pulumi.get(self, "tpsp_builtin_dns_client_enabled")

    @tpsp_builtin_dns_client_enabled.setter
    def tpsp_builtin_dns_client_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_builtin_dns_client_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspChromeRemoteDesktopAppBlocked")
    def tpsp_chrome_remote_desktop_app_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider chrome remote desktop app blocked
        """
        return pulumi.get(self, "tpsp_chrome_remote_desktop_app_blocked")

    @tpsp_chrome_remote_desktop_app_blocked.setter
    def tpsp_chrome_remote_desktop_app_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_chrome_remote_desktop_app_blocked", value)

    @_builtins.property
    @pulumi.getter(name="tpspCrowdStrikeAgentId")
    def tpsp_crowd_strike_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider crowdstrike agent id
        """
        return pulumi.get(self, "tpsp_crowd_strike_agent_id")

    @tpsp_crowd_strike_agent_id.setter
    def tpsp_crowd_strike_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_crowd_strike_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="tpspCrowdStrikeCustomerId")
    def tpsp_crowd_strike_customer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider crowdstrike user id
        """
        return pulumi.get(self, "tpsp_crowd_strike_customer_id")

    @tpsp_crowd_strike_customer_id.setter
    def tpsp_crowd_strike_customer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_crowd_strike_customer_id", value)

    @_builtins.property
    @pulumi.getter(name="tpspDeviceEnrollmentDomain")
    def tpsp_device_enrollment_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider device enrollment domain
        """
        return pulumi.get(self, "tpsp_device_enrollment_domain")

    @tpsp_device_enrollment_domain.setter
    def tpsp_device_enrollment_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_device_enrollment_domain", value)

    @_builtins.property
    @pulumi.getter(name="tpspDiskEncrypted")
    def tpsp_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider disk encrypted
        """
        return pulumi.get(self, "tpsp_disk_encrypted")

    @tpsp_disk_encrypted.setter
    def tpsp_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="tpspKeyTrustLevel")
    def tpsp_key_trust_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider key trust level
        """
        return pulumi.get(self, "tpsp_key_trust_level")

    @tpsp_key_trust_level.setter
    def tpsp_key_trust_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_key_trust_level", value)

    @_builtins.property
    @pulumi.getter(name="tpspOsFirewall")
    def tpsp_os_firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider os firewall
        """
        return pulumi.get(self, "tpsp_os_firewall")

    @tpsp_os_firewall.setter
    def tpsp_os_firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_os_firewall", value)

    @_builtins.property
    @pulumi.getter(name="tpspOsVersion")
    def tpsp_os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider minimum os version
        """
        return pulumi.get(self, "tpsp_os_version")

    @tpsp_os_version.setter
    def tpsp_os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_os_version", value)

    @_builtins.property
    @pulumi.getter(name="tpspPasswordProctectionWarningTrigger")
    def tpsp_password_proctection_warning_trigger(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider password protection warning trigger
        """
        return pulumi.get(self, "tpsp_password_proctection_warning_trigger")

    @tpsp_password_proctection_warning_trigger.setter
    def tpsp_password_proctection_warning_trigger(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_password_proctection_warning_trigger", value)

    @_builtins.property
    @pulumi.getter(name="tpspRealtimeUrlCheckMode")
    def tpsp_realtime_url_check_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider realtime url check mode
        """
        return pulumi.get(self, "tpsp_realtime_url_check_mode")

    @tpsp_realtime_url_check_mode.setter
    def tpsp_realtime_url_check_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_realtime_url_check_mode", value)

    @_builtins.property
    @pulumi.getter(name="tpspSafeBrowsingProtectionLevel")
    def tpsp_safe_browsing_protection_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider safe browsing protection level
        """
        return pulumi.get(self, "tpsp_safe_browsing_protection_level")

    @tpsp_safe_browsing_protection_level.setter
    def tpsp_safe_browsing_protection_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_safe_browsing_protection_level", value)

    @_builtins.property
    @pulumi.getter(name="tpspScreenLockSecured")
    def tpsp_screen_lock_secured(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider screen lock secure
        """
        return pulumi.get(self, "tpsp_screen_lock_secured")

    @tpsp_screen_lock_secured.setter
    def tpsp_screen_lock_secured(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_screen_lock_secured", value)

    @_builtins.property
    @pulumi.getter(name="tpspSecureBootEnabled")
    def tpsp_secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider secure boot enabled
        """
        return pulumi.get(self, "tpsp_secure_boot_enabled")

    @tpsp_secure_boot_enabled.setter
    def tpsp_secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspSiteIsolationEnabled")
    def tpsp_site_isolation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider site isolation enabled
        """
        return pulumi.get(self, "tpsp_site_isolation_enabled")

    @tpsp_site_isolation_enabled.setter
    def tpsp_site_isolation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_site_isolation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspThirdPartyBlockingEnabled")
    def tpsp_third_party_blocking_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider third party blocking enabled
        """
        return pulumi.get(self, "tpsp_third_party_blocking_enabled")

    @tpsp_third_party_blocking_enabled.setter
    def tpsp_third_party_blocking_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_third_party_blocking_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspWindowsMachineDomain")
    def tpsp_windows_machine_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider windows machine domain
        """
        return pulumi.get(self, "tpsp_windows_machine_domain")

    @tpsp_windows_machine_domain.setter
    def tpsp_windows_machine_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_windows_machine_domain", value)

    @_builtins.property
    @pulumi.getter(name="tpspWindowsUserDomain")
    def tpsp_windows_user_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider windows user domain
        """
        return pulumi.get(self, "tpsp_windows_user_domain")

    @tpsp_windows_user_domain.setter
    def tpsp_windows_user_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_windows_user_domain", value)


@pulumi.input_type
class _DeviceAssuranceWindowsState:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_update: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_hardware_present: Optional[pulumi.Input[_builtins.bool]] = None,
                 third_party_signal_providers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_browser_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_builtin_dns_client_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_chrome_remote_desktop_app_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_crowd_strike_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_crowd_strike_customer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_device_enrollment_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_key_trust_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_os_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_password_proctection_warning_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_realtime_url_check_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_safe_browsing_protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_screen_lock_secured: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_site_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_third_party_blocking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_windows_machine_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_windows_user_domain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DeviceAssuranceWindows resources.
        :param pulumi.Input[_builtins.str] created_by: Created by
        :param pulumi.Input[_builtins.str] created_date: Created date
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_encryption_types: List of disk encryption type, can be `ALL_INTERNAL_VOLUMES`
        :param pulumi.Input[_builtins.str] last_update: Last update
        :param pulumi.Input[_builtins.str] last_updated_by: Last updated by
        :param pulumi.Input[_builtins.str] name: Name of the device assurance policy.
        :param pulumi.Input[_builtins.str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[_builtins.str] platform: Policy device assurance platform
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        :param pulumi.Input[_builtins.bool] secure_hardware_present: Is the device secure with hardware in the device assurance policy.
        :param pulumi.Input[_builtins.bool] third_party_signal_providers: Check to include third party signal provider
        :param pulumi.Input[_builtins.str] tpsp_browser_version: Third party signal provider minimum browser version
        :param pulumi.Input[_builtins.bool] tpsp_builtin_dns_client_enabled: Third party signal provider builtin dns client enable
        :param pulumi.Input[_builtins.bool] tpsp_chrome_remote_desktop_app_blocked: Third party signal provider chrome remote desktop app blocked
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_agent_id: Third party signal provider crowdstrike agent id
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_customer_id: Third party signal provider crowdstrike user id
        :param pulumi.Input[_builtins.str] tpsp_device_enrollment_domain: Third party signal provider device enrollment domain
        :param pulumi.Input[_builtins.bool] tpsp_disk_encrypted: Third party signal provider disk encrypted
        :param pulumi.Input[_builtins.str] tpsp_key_trust_level: Third party signal provider key trust level
        :param pulumi.Input[_builtins.bool] tpsp_os_firewall: Third party signal provider os firewall
        :param pulumi.Input[_builtins.str] tpsp_os_version: Third party signal provider minimum os version
        :param pulumi.Input[_builtins.str] tpsp_password_proctection_warning_trigger: Third party signal provider password protection warning trigger
        :param pulumi.Input[_builtins.bool] tpsp_realtime_url_check_mode: Third party signal provider realtime url check mode
        :param pulumi.Input[_builtins.str] tpsp_safe_browsing_protection_level: Third party signal provider safe browsing protection level
        :param pulumi.Input[_builtins.bool] tpsp_screen_lock_secured: Third party signal provider screen lock secure
        :param pulumi.Input[_builtins.bool] tpsp_secure_boot_enabled: Third party signal provider secure boot enabled
        :param pulumi.Input[_builtins.bool] tpsp_site_isolation_enabled: Third party signal provider site isolation enabled
        :param pulumi.Input[_builtins.bool] tpsp_third_party_blocking_enabled: Third party signal provider third party blocking enabled
        :param pulumi.Input[_builtins.str] tpsp_windows_machine_domain: Third party signal provider windows machine domain
        :param pulumi.Input[_builtins.str] tpsp_windows_user_domain: Third party signal provider windows user domain
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if disk_encryption_types is not None:
            pulumi.set(__self__, "disk_encryption_types", disk_encryption_types)
        if last_update is not None:
            pulumi.set(__self__, "last_update", last_update)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if screenlock_types is not None:
            pulumi.set(__self__, "screenlock_types", screenlock_types)
        if secure_hardware_present is not None:
            pulumi.set(__self__, "secure_hardware_present", secure_hardware_present)
        if third_party_signal_providers is not None:
            pulumi.set(__self__, "third_party_signal_providers", third_party_signal_providers)
        if tpsp_browser_version is not None:
            pulumi.set(__self__, "tpsp_browser_version", tpsp_browser_version)
        if tpsp_builtin_dns_client_enabled is not None:
            pulumi.set(__self__, "tpsp_builtin_dns_client_enabled", tpsp_builtin_dns_client_enabled)
        if tpsp_chrome_remote_desktop_app_blocked is not None:
            pulumi.set(__self__, "tpsp_chrome_remote_desktop_app_blocked", tpsp_chrome_remote_desktop_app_blocked)
        if tpsp_crowd_strike_agent_id is not None:
            pulumi.set(__self__, "tpsp_crowd_strike_agent_id", tpsp_crowd_strike_agent_id)
        if tpsp_crowd_strike_customer_id is not None:
            pulumi.set(__self__, "tpsp_crowd_strike_customer_id", tpsp_crowd_strike_customer_id)
        if tpsp_device_enrollment_domain is not None:
            pulumi.set(__self__, "tpsp_device_enrollment_domain", tpsp_device_enrollment_domain)
        if tpsp_disk_encrypted is not None:
            pulumi.set(__self__, "tpsp_disk_encrypted", tpsp_disk_encrypted)
        if tpsp_key_trust_level is not None:
            pulumi.set(__self__, "tpsp_key_trust_level", tpsp_key_trust_level)
        if tpsp_os_firewall is not None:
            pulumi.set(__self__, "tpsp_os_firewall", tpsp_os_firewall)
        if tpsp_os_version is not None:
            pulumi.set(__self__, "tpsp_os_version", tpsp_os_version)
        if tpsp_password_proctection_warning_trigger is not None:
            pulumi.set(__self__, "tpsp_password_proctection_warning_trigger", tpsp_password_proctection_warning_trigger)
        if tpsp_realtime_url_check_mode is not None:
            pulumi.set(__self__, "tpsp_realtime_url_check_mode", tpsp_realtime_url_check_mode)
        if tpsp_safe_browsing_protection_level is not None:
            pulumi.set(__self__, "tpsp_safe_browsing_protection_level", tpsp_safe_browsing_protection_level)
        if tpsp_screen_lock_secured is not None:
            pulumi.set(__self__, "tpsp_screen_lock_secured", tpsp_screen_lock_secured)
        if tpsp_secure_boot_enabled is not None:
            pulumi.set(__self__, "tpsp_secure_boot_enabled", tpsp_secure_boot_enabled)
        if tpsp_site_isolation_enabled is not None:
            pulumi.set(__self__, "tpsp_site_isolation_enabled", tpsp_site_isolation_enabled)
        if tpsp_third_party_blocking_enabled is not None:
            pulumi.set(__self__, "tpsp_third_party_blocking_enabled", tpsp_third_party_blocking_enabled)
        if tpsp_windows_machine_domain is not None:
            pulumi.set(__self__, "tpsp_windows_machine_domain", tpsp_windows_machine_domain)
        if tpsp_windows_user_domain is not None:
            pulumi.set(__self__, "tpsp_windows_user_domain", tpsp_windows_user_domain)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created by
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created date
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionTypes")
    def disk_encryption_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of disk encryption type, can be `ALL_INTERNAL_VOLUMES`
        """
        return pulumi.get(self, "disk_encryption_types")

    @disk_encryption_types.setter
    def disk_encryption_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_encryption_types", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update
        """
        return pulumi.get(self, "last_update")

    @last_update.setter
    def last_update(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last updated by
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the device assurance policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum os version of the device in the device assurance policy.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_version", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy device assurance platform
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="screenlockTypes")
    def screenlock_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        return pulumi.get(self, "screenlock_types")

    @screenlock_types.setter
    def screenlock_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "screenlock_types", value)

    @_builtins.property
    @pulumi.getter(name="secureHardwarePresent")
    def secure_hardware_present(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the device secure with hardware in the device assurance policy.
        """
        return pulumi.get(self, "secure_hardware_present")

    @secure_hardware_present.setter
    def secure_hardware_present(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure_hardware_present", value)

    @_builtins.property
    @pulumi.getter(name="thirdPartySignalProviders")
    def third_party_signal_providers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check to include third party signal provider
        """
        return pulumi.get(self, "third_party_signal_providers")

    @third_party_signal_providers.setter
    def third_party_signal_providers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "third_party_signal_providers", value)

    @_builtins.property
    @pulumi.getter(name="tpspBrowserVersion")
    def tpsp_browser_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider minimum browser version
        """
        return pulumi.get(self, "tpsp_browser_version")

    @tpsp_browser_version.setter
    def tpsp_browser_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_browser_version", value)

    @_builtins.property
    @pulumi.getter(name="tpspBuiltinDnsClientEnabled")
    def tpsp_builtin_dns_client_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider builtin dns client enable
        """
        return pulumi.get(self, "tpsp_builtin_dns_client_enabled")

    @tpsp_builtin_dns_client_enabled.setter
    def tpsp_builtin_dns_client_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_builtin_dns_client_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspChromeRemoteDesktopAppBlocked")
    def tpsp_chrome_remote_desktop_app_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider chrome remote desktop app blocked
        """
        return pulumi.get(self, "tpsp_chrome_remote_desktop_app_blocked")

    @tpsp_chrome_remote_desktop_app_blocked.setter
    def tpsp_chrome_remote_desktop_app_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_chrome_remote_desktop_app_blocked", value)

    @_builtins.property
    @pulumi.getter(name="tpspCrowdStrikeAgentId")
    def tpsp_crowd_strike_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider crowdstrike agent id
        """
        return pulumi.get(self, "tpsp_crowd_strike_agent_id")

    @tpsp_crowd_strike_agent_id.setter
    def tpsp_crowd_strike_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_crowd_strike_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="tpspCrowdStrikeCustomerId")
    def tpsp_crowd_strike_customer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider crowdstrike user id
        """
        return pulumi.get(self, "tpsp_crowd_strike_customer_id")

    @tpsp_crowd_strike_customer_id.setter
    def tpsp_crowd_strike_customer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_crowd_strike_customer_id", value)

    @_builtins.property
    @pulumi.getter(name="tpspDeviceEnrollmentDomain")
    def tpsp_device_enrollment_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider device enrollment domain
        """
        return pulumi.get(self, "tpsp_device_enrollment_domain")

    @tpsp_device_enrollment_domain.setter
    def tpsp_device_enrollment_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_device_enrollment_domain", value)

    @_builtins.property
    @pulumi.getter(name="tpspDiskEncrypted")
    def tpsp_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider disk encrypted
        """
        return pulumi.get(self, "tpsp_disk_encrypted")

    @tpsp_disk_encrypted.setter
    def tpsp_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="tpspKeyTrustLevel")
    def tpsp_key_trust_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider key trust level
        """
        return pulumi.get(self, "tpsp_key_trust_level")

    @tpsp_key_trust_level.setter
    def tpsp_key_trust_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_key_trust_level", value)

    @_builtins.property
    @pulumi.getter(name="tpspOsFirewall")
    def tpsp_os_firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider os firewall
        """
        return pulumi.get(self, "tpsp_os_firewall")

    @tpsp_os_firewall.setter
    def tpsp_os_firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_os_firewall", value)

    @_builtins.property
    @pulumi.getter(name="tpspOsVersion")
    def tpsp_os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider minimum os version
        """
        return pulumi.get(self, "tpsp_os_version")

    @tpsp_os_version.setter
    def tpsp_os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_os_version", value)

    @_builtins.property
    @pulumi.getter(name="tpspPasswordProctectionWarningTrigger")
    def tpsp_password_proctection_warning_trigger(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider password protection warning trigger
        """
        return pulumi.get(self, "tpsp_password_proctection_warning_trigger")

    @tpsp_password_proctection_warning_trigger.setter
    def tpsp_password_proctection_warning_trigger(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_password_proctection_warning_trigger", value)

    @_builtins.property
    @pulumi.getter(name="tpspRealtimeUrlCheckMode")
    def tpsp_realtime_url_check_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider realtime url check mode
        """
        return pulumi.get(self, "tpsp_realtime_url_check_mode")

    @tpsp_realtime_url_check_mode.setter
    def tpsp_realtime_url_check_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_realtime_url_check_mode", value)

    @_builtins.property
    @pulumi.getter(name="tpspSafeBrowsingProtectionLevel")
    def tpsp_safe_browsing_protection_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider safe browsing protection level
        """
        return pulumi.get(self, "tpsp_safe_browsing_protection_level")

    @tpsp_safe_browsing_protection_level.setter
    def tpsp_safe_browsing_protection_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_safe_browsing_protection_level", value)

    @_builtins.property
    @pulumi.getter(name="tpspScreenLockSecured")
    def tpsp_screen_lock_secured(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider screen lock secure
        """
        return pulumi.get(self, "tpsp_screen_lock_secured")

    @tpsp_screen_lock_secured.setter
    def tpsp_screen_lock_secured(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_screen_lock_secured", value)

    @_builtins.property
    @pulumi.getter(name="tpspSecureBootEnabled")
    def tpsp_secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider secure boot enabled
        """
        return pulumi.get(self, "tpsp_secure_boot_enabled")

    @tpsp_secure_boot_enabled.setter
    def tpsp_secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspSiteIsolationEnabled")
    def tpsp_site_isolation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider site isolation enabled
        """
        return pulumi.get(self, "tpsp_site_isolation_enabled")

    @tpsp_site_isolation_enabled.setter
    def tpsp_site_isolation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_site_isolation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspThirdPartyBlockingEnabled")
    def tpsp_third_party_blocking_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Third party signal provider third party blocking enabled
        """
        return pulumi.get(self, "tpsp_third_party_blocking_enabled")

    @tpsp_third_party_blocking_enabled.setter
    def tpsp_third_party_blocking_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tpsp_third_party_blocking_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tpspWindowsMachineDomain")
    def tpsp_windows_machine_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider windows machine domain
        """
        return pulumi.get(self, "tpsp_windows_machine_domain")

    @tpsp_windows_machine_domain.setter
    def tpsp_windows_machine_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_windows_machine_domain", value)

    @_builtins.property
    @pulumi.getter(name="tpspWindowsUserDomain")
    def tpsp_windows_user_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Third party signal provider windows user domain
        """
        return pulumi.get(self, "tpsp_windows_user_domain")

    @tpsp_windows_user_domain.setter
    def tpsp_windows_user_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tpsp_windows_user_domain", value)


@pulumi.type_token("okta:policy/deviceAssuranceWindows:DeviceAssuranceWindows")
class DeviceAssuranceWindows(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_encryption_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_hardware_present: Optional[pulumi.Input[_builtins.bool]] = None,
                 third_party_signal_providers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_browser_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_builtin_dns_client_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_chrome_remote_desktop_app_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_crowd_strike_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_crowd_strike_customer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_device_enrollment_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_key_trust_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_os_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_password_proctection_warning_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_realtime_url_check_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_safe_browsing_protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_screen_lock_secured: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_site_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_third_party_blocking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_windows_machine_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_windows_user_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a device assurance policy for windows.

        ## Import

        ```sh
        $ pulumi import okta:policy/deviceAssuranceWindows:DeviceAssuranceWindows example <device_assurance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_encryption_types: List of disk encryption type, can be `ALL_INTERNAL_VOLUMES`
        :param pulumi.Input[_builtins.str] name: Name of the device assurance policy.
        :param pulumi.Input[_builtins.str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        :param pulumi.Input[_builtins.bool] secure_hardware_present: Is the device secure with hardware in the device assurance policy.
        :param pulumi.Input[_builtins.bool] third_party_signal_providers: Check to include third party signal provider
        :param pulumi.Input[_builtins.str] tpsp_browser_version: Third party signal provider minimum browser version
        :param pulumi.Input[_builtins.bool] tpsp_builtin_dns_client_enabled: Third party signal provider builtin dns client enable
        :param pulumi.Input[_builtins.bool] tpsp_chrome_remote_desktop_app_blocked: Third party signal provider chrome remote desktop app blocked
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_agent_id: Third party signal provider crowdstrike agent id
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_customer_id: Third party signal provider crowdstrike user id
        :param pulumi.Input[_builtins.str] tpsp_device_enrollment_domain: Third party signal provider device enrollment domain
        :param pulumi.Input[_builtins.bool] tpsp_disk_encrypted: Third party signal provider disk encrypted
        :param pulumi.Input[_builtins.str] tpsp_key_trust_level: Third party signal provider key trust level
        :param pulumi.Input[_builtins.bool] tpsp_os_firewall: Third party signal provider os firewall
        :param pulumi.Input[_builtins.str] tpsp_os_version: Third party signal provider minimum os version
        :param pulumi.Input[_builtins.str] tpsp_password_proctection_warning_trigger: Third party signal provider password protection warning trigger
        :param pulumi.Input[_builtins.bool] tpsp_realtime_url_check_mode: Third party signal provider realtime url check mode
        :param pulumi.Input[_builtins.str] tpsp_safe_browsing_protection_level: Third party signal provider safe browsing protection level
        :param pulumi.Input[_builtins.bool] tpsp_screen_lock_secured: Third party signal provider screen lock secure
        :param pulumi.Input[_builtins.bool] tpsp_secure_boot_enabled: Third party signal provider secure boot enabled
        :param pulumi.Input[_builtins.bool] tpsp_site_isolation_enabled: Third party signal provider site isolation enabled
        :param pulumi.Input[_builtins.bool] tpsp_third_party_blocking_enabled: Third party signal provider third party blocking enabled
        :param pulumi.Input[_builtins.str] tpsp_windows_machine_domain: Third party signal provider windows machine domain
        :param pulumi.Input[_builtins.str] tpsp_windows_user_domain: Third party signal provider windows user domain
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DeviceAssuranceWindowsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a device assurance policy for windows.

        ## Import

        ```sh
        $ pulumi import okta:policy/deviceAssuranceWindows:DeviceAssuranceWindows example <device_assurance_id>
        ```

        :param str resource_name: The name of the resource.
        :param DeviceAssuranceWindowsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceAssuranceWindowsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_encryption_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_hardware_present: Optional[pulumi.Input[_builtins.bool]] = None,
                 third_party_signal_providers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_browser_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_builtin_dns_client_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_chrome_remote_desktop_app_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_crowd_strike_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_crowd_strike_customer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_device_enrollment_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_key_trust_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_os_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_password_proctection_warning_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_realtime_url_check_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_safe_browsing_protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_screen_lock_secured: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_site_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_third_party_blocking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tpsp_windows_machine_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tpsp_windows_user_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceAssuranceWindowsArgs.__new__(DeviceAssuranceWindowsArgs)

            __props__.__dict__["disk_encryption_types"] = disk_encryption_types
            __props__.__dict__["name"] = name
            __props__.__dict__["os_version"] = os_version
            __props__.__dict__["screenlock_types"] = screenlock_types
            __props__.__dict__["secure_hardware_present"] = secure_hardware_present
            __props__.__dict__["third_party_signal_providers"] = third_party_signal_providers
            __props__.__dict__["tpsp_browser_version"] = tpsp_browser_version
            __props__.__dict__["tpsp_builtin_dns_client_enabled"] = tpsp_builtin_dns_client_enabled
            __props__.__dict__["tpsp_chrome_remote_desktop_app_blocked"] = tpsp_chrome_remote_desktop_app_blocked
            __props__.__dict__["tpsp_crowd_strike_agent_id"] = tpsp_crowd_strike_agent_id
            __props__.__dict__["tpsp_crowd_strike_customer_id"] = tpsp_crowd_strike_customer_id
            __props__.__dict__["tpsp_device_enrollment_domain"] = tpsp_device_enrollment_domain
            __props__.__dict__["tpsp_disk_encrypted"] = tpsp_disk_encrypted
            __props__.__dict__["tpsp_key_trust_level"] = tpsp_key_trust_level
            __props__.__dict__["tpsp_os_firewall"] = tpsp_os_firewall
            __props__.__dict__["tpsp_os_version"] = tpsp_os_version
            __props__.__dict__["tpsp_password_proctection_warning_trigger"] = tpsp_password_proctection_warning_trigger
            __props__.__dict__["tpsp_realtime_url_check_mode"] = tpsp_realtime_url_check_mode
            __props__.__dict__["tpsp_safe_browsing_protection_level"] = tpsp_safe_browsing_protection_level
            __props__.__dict__["tpsp_screen_lock_secured"] = tpsp_screen_lock_secured
            __props__.__dict__["tpsp_secure_boot_enabled"] = tpsp_secure_boot_enabled
            __props__.__dict__["tpsp_site_isolation_enabled"] = tpsp_site_isolation_enabled
            __props__.__dict__["tpsp_third_party_blocking_enabled"] = tpsp_third_party_blocking_enabled
            __props__.__dict__["tpsp_windows_machine_domain"] = tpsp_windows_machine_domain
            __props__.__dict__["tpsp_windows_user_domain"] = tpsp_windows_user_domain
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["last_update"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["platform"] = None
        super(DeviceAssuranceWindows, __self__).__init__(
            'okta:policy/deviceAssuranceWindows:DeviceAssuranceWindows',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            last_update: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_version: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            screenlock_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secure_hardware_present: Optional[pulumi.Input[_builtins.bool]] = None,
            third_party_signal_providers: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_browser_version: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_builtin_dns_client_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_chrome_remote_desktop_app_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_crowd_strike_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_crowd_strike_customer_id: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_device_enrollment_domain: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_key_trust_level: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_os_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_os_version: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_password_proctection_warning_trigger: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_realtime_url_check_mode: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_safe_browsing_protection_level: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_screen_lock_secured: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_site_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_third_party_blocking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tpsp_windows_machine_domain: Optional[pulumi.Input[_builtins.str]] = None,
            tpsp_windows_user_domain: Optional[pulumi.Input[_builtins.str]] = None) -> 'DeviceAssuranceWindows':
        """
        Get an existing DeviceAssuranceWindows resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: Created by
        :param pulumi.Input[_builtins.str] created_date: Created date
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_encryption_types: List of disk encryption type, can be `ALL_INTERNAL_VOLUMES`
        :param pulumi.Input[_builtins.str] last_update: Last update
        :param pulumi.Input[_builtins.str] last_updated_by: Last updated by
        :param pulumi.Input[_builtins.str] name: Name of the device assurance policy.
        :param pulumi.Input[_builtins.str] os_version: Minimum os version of the device in the device assurance policy.
        :param pulumi.Input[_builtins.str] platform: Policy device assurance platform
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] screenlock_types: List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        :param pulumi.Input[_builtins.bool] secure_hardware_present: Is the device secure with hardware in the device assurance policy.
        :param pulumi.Input[_builtins.bool] third_party_signal_providers: Check to include third party signal provider
        :param pulumi.Input[_builtins.str] tpsp_browser_version: Third party signal provider minimum browser version
        :param pulumi.Input[_builtins.bool] tpsp_builtin_dns_client_enabled: Third party signal provider builtin dns client enable
        :param pulumi.Input[_builtins.bool] tpsp_chrome_remote_desktop_app_blocked: Third party signal provider chrome remote desktop app blocked
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_agent_id: Third party signal provider crowdstrike agent id
        :param pulumi.Input[_builtins.str] tpsp_crowd_strike_customer_id: Third party signal provider crowdstrike user id
        :param pulumi.Input[_builtins.str] tpsp_device_enrollment_domain: Third party signal provider device enrollment domain
        :param pulumi.Input[_builtins.bool] tpsp_disk_encrypted: Third party signal provider disk encrypted
        :param pulumi.Input[_builtins.str] tpsp_key_trust_level: Third party signal provider key trust level
        :param pulumi.Input[_builtins.bool] tpsp_os_firewall: Third party signal provider os firewall
        :param pulumi.Input[_builtins.str] tpsp_os_version: Third party signal provider minimum os version
        :param pulumi.Input[_builtins.str] tpsp_password_proctection_warning_trigger: Third party signal provider password protection warning trigger
        :param pulumi.Input[_builtins.bool] tpsp_realtime_url_check_mode: Third party signal provider realtime url check mode
        :param pulumi.Input[_builtins.str] tpsp_safe_browsing_protection_level: Third party signal provider safe browsing protection level
        :param pulumi.Input[_builtins.bool] tpsp_screen_lock_secured: Third party signal provider screen lock secure
        :param pulumi.Input[_builtins.bool] tpsp_secure_boot_enabled: Third party signal provider secure boot enabled
        :param pulumi.Input[_builtins.bool] tpsp_site_isolation_enabled: Third party signal provider site isolation enabled
        :param pulumi.Input[_builtins.bool] tpsp_third_party_blocking_enabled: Third party signal provider third party blocking enabled
        :param pulumi.Input[_builtins.str] tpsp_windows_machine_domain: Third party signal provider windows machine domain
        :param pulumi.Input[_builtins.str] tpsp_windows_user_domain: Third party signal provider windows user domain
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceAssuranceWindowsState.__new__(_DeviceAssuranceWindowsState)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["disk_encryption_types"] = disk_encryption_types
        __props__.__dict__["last_update"] = last_update
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["name"] = name
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["platform"] = platform
        __props__.__dict__["screenlock_types"] = screenlock_types
        __props__.__dict__["secure_hardware_present"] = secure_hardware_present
        __props__.__dict__["third_party_signal_providers"] = third_party_signal_providers
        __props__.__dict__["tpsp_browser_version"] = tpsp_browser_version
        __props__.__dict__["tpsp_builtin_dns_client_enabled"] = tpsp_builtin_dns_client_enabled
        __props__.__dict__["tpsp_chrome_remote_desktop_app_blocked"] = tpsp_chrome_remote_desktop_app_blocked
        __props__.__dict__["tpsp_crowd_strike_agent_id"] = tpsp_crowd_strike_agent_id
        __props__.__dict__["tpsp_crowd_strike_customer_id"] = tpsp_crowd_strike_customer_id
        __props__.__dict__["tpsp_device_enrollment_domain"] = tpsp_device_enrollment_domain
        __props__.__dict__["tpsp_disk_encrypted"] = tpsp_disk_encrypted
        __props__.__dict__["tpsp_key_trust_level"] = tpsp_key_trust_level
        __props__.__dict__["tpsp_os_firewall"] = tpsp_os_firewall
        __props__.__dict__["tpsp_os_version"] = tpsp_os_version
        __props__.__dict__["tpsp_password_proctection_warning_trigger"] = tpsp_password_proctection_warning_trigger
        __props__.__dict__["tpsp_realtime_url_check_mode"] = tpsp_realtime_url_check_mode
        __props__.__dict__["tpsp_safe_browsing_protection_level"] = tpsp_safe_browsing_protection_level
        __props__.__dict__["tpsp_screen_lock_secured"] = tpsp_screen_lock_secured
        __props__.__dict__["tpsp_secure_boot_enabled"] = tpsp_secure_boot_enabled
        __props__.__dict__["tpsp_site_isolation_enabled"] = tpsp_site_isolation_enabled
        __props__.__dict__["tpsp_third_party_blocking_enabled"] = tpsp_third_party_blocking_enabled
        __props__.__dict__["tpsp_windows_machine_domain"] = tpsp_windows_machine_domain
        __props__.__dict__["tpsp_windows_user_domain"] = tpsp_windows_user_domain
        return DeviceAssuranceWindows(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Created by
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        Created date
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionTypes")
    def disk_encryption_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of disk encryption type, can be `ALL_INTERNAL_VOLUMES`
        """
        return pulumi.get(self, "disk_encryption_types")

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> pulumi.Output[_builtins.str]:
        """
        Last update
        """
        return pulumi.get(self, "last_update")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        Last updated by
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the device assurance policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Minimum os version of the device in the device assurance policy.
        """
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        Policy device assurance platform
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="screenlockTypes")
    def screenlock_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        return pulumi.get(self, "screenlock_types")

    @_builtins.property
    @pulumi.getter(name="secureHardwarePresent")
    def secure_hardware_present(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the device secure with hardware in the device assurance policy.
        """
        return pulumi.get(self, "secure_hardware_present")

    @_builtins.property
    @pulumi.getter(name="thirdPartySignalProviders")
    def third_party_signal_providers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Check to include third party signal provider
        """
        return pulumi.get(self, "third_party_signal_providers")

    @_builtins.property
    @pulumi.getter(name="tpspBrowserVersion")
    def tpsp_browser_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider minimum browser version
        """
        return pulumi.get(self, "tpsp_browser_version")

    @_builtins.property
    @pulumi.getter(name="tpspBuiltinDnsClientEnabled")
    def tpsp_builtin_dns_client_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider builtin dns client enable
        """
        return pulumi.get(self, "tpsp_builtin_dns_client_enabled")

    @_builtins.property
    @pulumi.getter(name="tpspChromeRemoteDesktopAppBlocked")
    def tpsp_chrome_remote_desktop_app_blocked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider chrome remote desktop app blocked
        """
        return pulumi.get(self, "tpsp_chrome_remote_desktop_app_blocked")

    @_builtins.property
    @pulumi.getter(name="tpspCrowdStrikeAgentId")
    def tpsp_crowd_strike_agent_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider crowdstrike agent id
        """
        return pulumi.get(self, "tpsp_crowd_strike_agent_id")

    @_builtins.property
    @pulumi.getter(name="tpspCrowdStrikeCustomerId")
    def tpsp_crowd_strike_customer_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider crowdstrike user id
        """
        return pulumi.get(self, "tpsp_crowd_strike_customer_id")

    @_builtins.property
    @pulumi.getter(name="tpspDeviceEnrollmentDomain")
    def tpsp_device_enrollment_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider device enrollment domain
        """
        return pulumi.get(self, "tpsp_device_enrollment_domain")

    @_builtins.property
    @pulumi.getter(name="tpspDiskEncrypted")
    def tpsp_disk_encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider disk encrypted
        """
        return pulumi.get(self, "tpsp_disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="tpspKeyTrustLevel")
    def tpsp_key_trust_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider key trust level
        """
        return pulumi.get(self, "tpsp_key_trust_level")

    @_builtins.property
    @pulumi.getter(name="tpspOsFirewall")
    def tpsp_os_firewall(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider os firewall
        """
        return pulumi.get(self, "tpsp_os_firewall")

    @_builtins.property
    @pulumi.getter(name="tpspOsVersion")
    def tpsp_os_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider minimum os version
        """
        return pulumi.get(self, "tpsp_os_version")

    @_builtins.property
    @pulumi.getter(name="tpspPasswordProctectionWarningTrigger")
    def tpsp_password_proctection_warning_trigger(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider password protection warning trigger
        """
        return pulumi.get(self, "tpsp_password_proctection_warning_trigger")

    @_builtins.property
    @pulumi.getter(name="tpspRealtimeUrlCheckMode")
    def tpsp_realtime_url_check_mode(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider realtime url check mode
        """
        return pulumi.get(self, "tpsp_realtime_url_check_mode")

    @_builtins.property
    @pulumi.getter(name="tpspSafeBrowsingProtectionLevel")
    def tpsp_safe_browsing_protection_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider safe browsing protection level
        """
        return pulumi.get(self, "tpsp_safe_browsing_protection_level")

    @_builtins.property
    @pulumi.getter(name="tpspScreenLockSecured")
    def tpsp_screen_lock_secured(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider screen lock secure
        """
        return pulumi.get(self, "tpsp_screen_lock_secured")

    @_builtins.property
    @pulumi.getter(name="tpspSecureBootEnabled")
    def tpsp_secure_boot_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider secure boot enabled
        """
        return pulumi.get(self, "tpsp_secure_boot_enabled")

    @_builtins.property
    @pulumi.getter(name="tpspSiteIsolationEnabled")
    def tpsp_site_isolation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider site isolation enabled
        """
        return pulumi.get(self, "tpsp_site_isolation_enabled")

    @_builtins.property
    @pulumi.getter(name="tpspThirdPartyBlockingEnabled")
    def tpsp_third_party_blocking_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Third party signal provider third party blocking enabled
        """
        return pulumi.get(self, "tpsp_third_party_blocking_enabled")

    @_builtins.property
    @pulumi.getter(name="tpspWindowsMachineDomain")
    def tpsp_windows_machine_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider windows machine domain
        """
        return pulumi.get(self, "tpsp_windows_machine_domain")

    @_builtins.property
    @pulumi.getter(name="tpspWindowsUserDomain")
    def tpsp_windows_user_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Third party signal provider windows user domain
        """
        return pulumi.get(self, "tpsp_windows_user_domain")

