# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RealmAssignmentArgs', 'RealmAssignment']

@pulumi.input_type
class RealmAssignmentArgs:
    def __init__(__self__, *,
                 profile_source_id: pulumi.Input[_builtins.str],
                 realm_id: pulumi.Input[_builtins.str],
                 condition_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RealmAssignment resource.
        :param pulumi.Input[_builtins.str] profile_source_id: The ID of the Profile Source.
        :param pulumi.Input[_builtins.str] realm_id: The ID of the Realm asscociated with the Realm Assignment.
        :param pulumi.Input[_builtins.str] condition_expression: Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm Assignment.
        :param pulumi.Input[_builtins.int] priority: The Priority of the Realm Assignment. The lower the number, the higher the priority.
        :param pulumi.Input[_builtins.str] status: Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        pulumi.set(__self__, "profile_source_id", profile_source_id)
        pulumi.set(__self__, "realm_id", realm_id)
        if condition_expression is not None:
            pulumi.set(__self__, "condition_expression", condition_expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="profileSourceId")
    def profile_source_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Profile Source.
        """
        return pulumi.get(self, "profile_source_id")

    @profile_source_id.setter
    def profile_source_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "profile_source_id", value)

    @_builtins.property
    @pulumi.getter(name="realmId")
    def realm_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Realm asscociated with the Realm Assignment.
        """
        return pulumi.get(self, "realm_id")

    @realm_id.setter
    def realm_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "realm_id", value)

    @_builtins.property
    @pulumi.getter(name="conditionExpression")
    def condition_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        """
        return pulumi.get(self, "condition_expression")

    @condition_expression.setter
    def condition_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Okta Realm Assignment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Priority of the Realm Assignment. The lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _RealmAssignmentState:
    def __init__(__self__, *,
                 condition_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 realm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RealmAssignment resources.
        :param pulumi.Input[_builtins.str] condition_expression: Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        :param pulumi.Input[_builtins.bool] is_default: Indicates whether the realm assignment is the default.
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm Assignment.
        :param pulumi.Input[_builtins.int] priority: The Priority of the Realm Assignment. The lower the number, the higher the priority.
        :param pulumi.Input[_builtins.str] profile_source_id: The ID of the Profile Source.
        :param pulumi.Input[_builtins.str] realm_id: The ID of the Realm asscociated with the Realm Assignment.
        :param pulumi.Input[_builtins.str] status: Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        if condition_expression is not None:
            pulumi.set(__self__, "condition_expression", condition_expression)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if profile_source_id is not None:
            pulumi.set(__self__, "profile_source_id", profile_source_id)
        if realm_id is not None:
            pulumi.set(__self__, "realm_id", realm_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="conditionExpression")
    def condition_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        """
        return pulumi.get(self, "condition_expression")

    @condition_expression.setter
    def condition_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_expression", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the realm assignment is the default.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Okta Realm Assignment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Priority of the Realm Assignment. The lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="profileSourceId")
    def profile_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Profile Source.
        """
        return pulumi.get(self, "profile_source_id")

    @profile_source_id.setter
    def profile_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_source_id", value)

    @_builtins.property
    @pulumi.getter(name="realmId")
    def realm_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Realm asscociated with the Realm Assignment.
        """
        return pulumi.get(self, "realm_id")

    @realm_id.setter
    def realm_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "realm_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("okta:index/realmAssignment:RealmAssignment")
class RealmAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 realm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an Okta Realm Assignment. This resource allows you to create and configure an Okta Realm Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Realm("example",
            name="Example Realm",
            realm_type="DEFAULT")
        test = okta.RealmAssignment("test",
            name="Example Realm Assignment",
            priority=55,
            status="ACTIVE",
            profile_source_id=test_okta_idp_saml["id"],
            condition_expression="user.profile.login.contains(\\"@example.com\\")",
            realm_id=example.id)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/realmAssignment:RealmAssignment example <realm_assignment_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] condition_expression: Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm Assignment.
        :param pulumi.Input[_builtins.int] priority: The Priority of the Realm Assignment. The lower the number, the higher the priority.
        :param pulumi.Input[_builtins.str] profile_source_id: The ID of the Profile Source.
        :param pulumi.Input[_builtins.str] realm_id: The ID of the Realm asscociated with the Realm Assignment.
        :param pulumi.Input[_builtins.str] status: Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RealmAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Okta Realm Assignment. This resource allows you to create and configure an Okta Realm Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Realm("example",
            name="Example Realm",
            realm_type="DEFAULT")
        test = okta.RealmAssignment("test",
            name="Example Realm Assignment",
            priority=55,
            status="ACTIVE",
            profile_source_id=test_okta_idp_saml["id"],
            condition_expression="user.profile.login.contains(\\"@example.com\\")",
            realm_id=example.id)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/realmAssignment:RealmAssignment example <realm_assignment_id>
        ```

        :param str resource_name: The name of the resource.
        :param RealmAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RealmAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 realm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RealmAssignmentArgs.__new__(RealmAssignmentArgs)

            __props__.__dict__["condition_expression"] = condition_expression
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            if profile_source_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_source_id'")
            __props__.__dict__["profile_source_id"] = profile_source_id
            if realm_id is None and not opts.urn:
                raise TypeError("Missing required property 'realm_id'")
            __props__.__dict__["realm_id"] = realm_id
            __props__.__dict__["status"] = status
            __props__.__dict__["is_default"] = None
        super(RealmAssignment, __self__).__init__(
            'okta:index/realmAssignment:RealmAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition_expression: Optional[pulumi.Input[_builtins.str]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            profile_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            realm_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'RealmAssignment':
        """
        Get an existing RealmAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] condition_expression: Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        :param pulumi.Input[_builtins.bool] is_default: Indicates whether the realm assignment is the default.
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm Assignment.
        :param pulumi.Input[_builtins.int] priority: The Priority of the Realm Assignment. The lower the number, the higher the priority.
        :param pulumi.Input[_builtins.str] profile_source_id: The ID of the Profile Source.
        :param pulumi.Input[_builtins.str] realm_id: The ID of the Realm asscociated with the Realm Assignment.
        :param pulumi.Input[_builtins.str] status: Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RealmAssignmentState.__new__(_RealmAssignmentState)

        __props__.__dict__["condition_expression"] = condition_expression
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["profile_source_id"] = profile_source_id
        __props__.__dict__["realm_id"] = realm_id
        __props__.__dict__["status"] = status
        return RealmAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="conditionExpression")
    def condition_expression(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Condition expression for the Realm Assignment in Okta Expression Language. Example: `user.profile.role =="Manager"` or `user.profile.state.contains("example")`.
        """
        return pulumi.get(self, "condition_expression")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the realm assignment is the default.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Okta Realm Assignment.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The Priority of the Realm Assignment. The lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="profileSourceId")
    def profile_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Profile Source.
        """
        return pulumi.get(self, "profile_source_id")

    @_builtins.property
    @pulumi.getter(name="realmId")
    def realm_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Realm asscociated with the Realm Assignment.
        """
        return pulumi.get(self, "realm_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Defines whether the Realm Assignment is active or not. Valid values: `ACTIVE` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

