/*
 * This file is part of MULTEM.
 * Copyright 2020 Ivan Lobato <Ivanlh20@gmail.com>
 *
 * MULTEM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * MULTEM is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MULTEM. If not, see <http:// www.gnu.org/licenses/>.
 */

#ifndef FXEG_DATA_H
#define FXEG_DATA_H

#ifdef _MSC_VER
#pragma once
#endif// _MSC_VER

#include "math.cuh"
#include "types.cuh"

class fxeg_Tabulated_Data{
	public:
		void ReadTabData(int Z_i, int Type_i, int dng_i, int &n_o, double *g_o, double *g2_o, double *fx_o, double *fe_o)
		{

			switch(Type_i)
			{
				case 0:
				{
					fxegActaCrys(Z_i);
				}
				break;
				case 1:
				{
					fxegRez(Z_i);
				}
				break;
				case 2:
				{
					fxegKirkland(Z_i);
				}
				break;
				case 3:
				{
					fxegLobato(Z_i);
				}
				break;
			}

			if(dng_i == 0 ) 
			{
				dng_i = 1;
			}

			int i = 0, j = 0;

			while (j<g.size())
			{
				g_o[i] = g[j];
				g2_o[i] = g2[j];
				fx_o[i] = fxg[j];
				fe_o[i] = feg[j];
				j = j + dng_i;
				i++;
			}
			n_o = i;
		}

	private:
		void fxegActaCrys(int Z)
		{

		}

		void fxegRez(int Z)
		{

		}

		void fxegKirkland(int Z)
		{
			int ng = 241;

			g.resize(ng);
			g2.resize(ng);
			fxg.resize(ng);
			feg.resize(ng);

			switch(Z)
			{
				case 1:
					g[0] = 0.0000000000; fxg[0] = 1.0000000000000000; 	feg[0] = 0.5291772107781780;
					g[1] = 0.0500000000; fxg[1] = 0.9863230588214690; 	feg[1] = 0.5237428372161040;
					g[2] = 0.1000000000; fxg[2] = 0.9469344943152280; 	feg[2] = 0.5080207288834000;
					g[3] = 0.1500000000; fxg[3] = 0.8863388826640460; 	feg[3] = 0.4836136262538300;
					g[4] = 0.2000000000; fxg[4] = 0.8108175100562500; 	feg[4] = 0.4527829575587190;
					g[5] = 0.2500000000; fxg[5] = 0.7271093517161240; 	feg[5] = 0.4180014244889680;
					g[6] = 0.3000000000; fxg[6] = 0.6412928461210550; 	feg[6] = 0.3815633514710150;
					g[7] = 0.3500000000; fxg[7] = 0.5581142007677230; 	feg[7] = 0.3453369765174250;
					g[8] = 0.4000000000; fxg[8] = 0.4807806952641210; 	feg[8] = 0.3106704702028640;
					g[9] = 0.4500000000; fxg[9] = 0.4110911652366620; 	feg[9] = 0.2784147040569190;
					g[10] = 0.5000000000; fxg[10] = 0.3497375217422580; feg[10] = 0.2490105871278440;
					g[11] = 0.5500000000; fxg[11] = 0.2966438979758530; feg[11] = 0.2225968461002530;
					g[12] = 0.6000000000; fxg[12] = 0.2512654191134340; feg[12] = 0.1991106623857140;
					g[13] = 0.6500000000; fxg[13] = 0.2128160598854920; feg[13] = 0.1783686962646300;
					g[14] = 0.7000000000; fxg[14] = 0.1804245821877020; feg[14] = 0.1601260423547410;
					g[15] = 0.7500000000; fxg[15] = 0.1532311406356990; feg[15] = 0.1441157603494550;
					g[16] = 0.8000000000; fxg[16] = 0.1304405640049090; feg[16] = 0.1300733795844480;
					g[17] = 0.8500000000; fxg[17] = 0.1113467189758550; feg[17] = 0.1177507341012150;
					g[18] = 0.9000000000; fxg[18] = 0.0953390497337590; feg[18] = 0.1069227085213640;
					g[19] = 0.9500000000; fxg[19] = 0.0818990491912698; feg[19] = 0.0973895485517276;
					g[20] = 1.0000000000; fxg[20] = 0.0705917066780706; feg[20] = 0.0889765719766198;
					g[21] = 1.0500000000; fxg[21] = 0.0610550106456276; feg[21] = 0.0815324845125078;
					g[22] = 1.1000000000; fxg[22] = 0.0529892608700334; feg[22] = 0.0749270544276030;
					g[23] = 1.1500000000; fxg[23] = 0.0461471025604675; feg[23] = 0.0690485954226915;
					g[24] = 1.2000000000; fxg[24] = 0.0403246860380649; feg[24] = 0.0638015100130415;
					g[25] = 1.2500000000; fxg[25] = 0.0353540647097047; feg[25] = 0.0591040224521555;
					g[26] = 1.3000000000; fxg[26] = 0.0310967891438462; feg[26] = 0.0548861561193329;
					g[27] = 1.3500000000; fxg[27] = 0.0274385816285073; feg[27] = 0.0510879676462981;
					g[28] = 1.4000000000; fxg[28] = 0.0242849488422774; feg[28] = 0.0476580270138183;
					g[29] = 1.4500000000; fxg[29] = 0.0215575887598075; feg[29] = 0.0445521216614986;
					g[30] = 1.5000000000; fxg[30] = 0.0191914588829814; feg[30] = 0.0417321583975215;
					g[31] = 1.5500000000; fxg[31] = 0.0171323890202617; feg[31] = 0.0391652365096552;
					g[32] = 1.6000000000; fxg[32] = 0.0153351391284261; feg[32] = 0.0368228671065616;
					g[33] = 1.6500000000; fxg[33] = 0.0137618191468905; feg[33] = 0.0346803162611325;
					g[34] = 1.7000000000; fxg[34] = 0.0123806023870672; feg[34] = 0.0327160523583220;
					g[35] = 1.7500000000; fxg[35] = 0.0111646766020165; feg[35] = 0.0309112808285917;
					g[36] = 1.8000000000; fxg[36] = 0.0100913873927691; feg[36] = 0.0292495520054893;
					g[37] = 1.8500000000; fxg[37] = 0.0091415372965884; feg[37] = 0.0277164301120464;
					ng = 38;
					break;
				case 2:
					g[0] = 0.0000000000; fxg[0] = 2.0000000000; feg[0] = 0.4180000000;
					g[1] = 0.0500000000; fxg[1] = 1.9891000000; feg[1] = 0.4161000000;
					g[2] = 0.1000000000; fxg[2] = 1.9571000000; feg[2] = 0.4105000000;
					g[3] = 0.1500000000; fxg[3] = 1.9056000000; feg[3] = 0.4015000000;
					g[4] = 0.2000000000; fxg[4] = 1.8372000000; feg[4] = 0.3896000000;
					g[5] = 0.2500000000; fxg[5] = 1.7551000000; feg[5] = 0.3752000000;
					g[6] = 0.3000000000; fxg[6] = 1.6626000000; feg[6] = 0.3589000000;
					g[7] = 0.3500000000; fxg[7] = 1.5633000000; feg[7] = 0.3413000000;
					g[8] = 0.4000000000; fxg[8] = 1.4604000000; feg[8] = 0.3229000000;
					g[9] = 0.4500000000; fxg[9] = 1.3566000000; feg[9] = 0.3042000000;
					g[10] = 0.5000000000; fxg[10] = 1.2542000000; feg[10] = 0.2856000000;
					g[11] = 0.5500000000; fxg[11] = 1.1550000000; feg[11] = 0.2674000000;
					g[12] = 0.6000000000; fxg[12] = 1.0602000000; feg[12] = 0.2499000000;
					g[13] = 0.6500000000; fxg[13] = 0.9708000000; feg[13] = 0.2332000000;
					g[14] = 0.7000000000; fxg[14] = 0.8873000000; feg[14] = 0.2174000000;
					g[15] = 0.7500000000; fxg[15] = 0.8098000000; feg[15] = 0.2026000000;
					g[16] = 0.8000000000; fxg[16] = 0.7384000000; feg[16] = 0.1887000000;
					g[17] = 0.8500000000; fxg[17] = 0.6729000000; feg[17] = 0.1759000000;
					g[18] = 0.9000000000; fxg[18] = 0.6130000000; feg[18] = 0.1639000000;
					g[19] = 0.9500000000; fxg[19] = 0.5585000000; feg[19] = 0.1529000000;
					g[20] = 1.0000000000; fxg[20] = 0.5089000000; feg[20] = 0.1427000000;
					g[21] = 1.0500000000; fxg[21] = 0.4640000000; feg[21] = 0.1334000000;
					g[22] = 1.1000000000; fxg[22] = 0.4232000000; feg[22] = 0.1248000000;
					g[23] = 1.1500000000; fxg[23] = 0.3863000000; feg[23] = 0.1168000000;
					g[24] = 1.2000000000; fxg[24] = 0.3529000000; feg[24] = 0.1095000000;
					g[25] = 1.2500000000; fxg[25] = 0.3227000000; feg[25] = 0.1028000000;
					g[26] = 1.3000000000; fxg[26] = 0.2953000000; feg[26] = 0.0966000000;
					g[27] = 1.3500000000; fxg[27] = 0.2705000000; feg[27] = 0.0908000000;
					g[28] = 1.4000000000; fxg[28] = 0.2481000000; feg[28] = 0.0856000000;
					g[29] = 1.4500000000; fxg[29] = 0.2277000000; feg[29] = 0.0807000000;
					g[30] = 1.5000000000; fxg[30] = 0.2093000000; feg[30] = 0.0762000000;
					g[31] = 1.5500000000; fxg[31] = 0.1925000000; feg[31] = 0.0720000000;
					g[32] = 1.6000000000; fxg[32] = 0.1773000000; feg[32] = 0.0682000000;
					g[33] = 1.6500000000; fxg[33] = 0.1634000000; feg[33] = 0.0646000000;
					g[34] = 1.7000000000; fxg[34] = 0.1508000000; feg[34] = 0.0613000000;
					g[35] = 1.7500000000; fxg[35] = 0.1393000000; feg[35] = 0.0582000000;
					g[36] = 1.8000000000; fxg[36] = 0.1289000000; feg[36] = 0.0553000000;
					g[37] = 1.8500000000; fxg[37] = 0.1193000000; feg[37] = 0.0526000000;
					g[38] = 1.9000000000; fxg[38] = 0.1106000000; feg[38] = 0.0501000000;
					g[39] = 1.9500000000; fxg[39] = 0.1026000000; feg[39] = 0.0478000000;
					g[40] = 2.0000000000; fxg[40] = 0.0953000000; feg[40] = 0.0456000000;
					g[41] = 2.0500000000; fxg[41] = 0.0886000000; feg[41] = 0.0435000000;
					g[42] = 2.1000000000; fxg[42] = 0.0824000000; feg[42] = 0.0416000000;
					g[43] = 2.1500000000; fxg[43] = 0.0768000000; feg[43] = 0.0398000000;
					g[44] = 2.2000000000; fxg[44] = 0.0716000000; feg[44] = 0.0381000000;
					g[45] = 2.2500000000; fxg[45] = 0.0668000000; feg[45] = 0.0366000000;
					g[46] = 2.3000000000; fxg[46] = 0.0624000000; feg[46] = 0.0351000000;
					g[47] = 2.3500000000; fxg[47] = 0.0583000000; feg[47] = 0.0337000000;
					g[48] = 2.4000000000; fxg[48] = 0.0546000000; feg[48] = 0.0323000000;
					g[49] = 2.4500000000; fxg[49] = 0.0511000000; feg[49] = 0.0311000000;
					g[50] = 2.5000000000; fxg[50] = 0.0479000000; feg[50] = 0.0299000000;
					g[51] = 2.5500000000; fxg[51] = 0.0449000000; feg[51] = 0.0288000000;
					g[52] = 2.6000000000; fxg[52] = 0.0422000000; feg[52] = 0.0277000000;
					g[53] = 2.6500000000; fxg[53] = 0.0397000000; feg[53] = 0.0267000000;
					g[54] = 2.7000000000; fxg[54] = 0.0373000000; feg[54] = 0.0258000000;
					g[55] = 2.7500000000; fxg[55] = 0.0351000000; feg[55] = 0.0249000000;
					g[56] = 2.8000000000; fxg[56] = 0.0331000000; feg[56] = 0.0240000000;
					g[57] = 2.8500000000; fxg[57] = 0.0312000000; feg[57] = 0.0232000000;
					g[58] = 2.9000000000; fxg[58] = 0.0294000000; feg[58] = 0.0224000000;
					g[59] = 2.9500000000; fxg[59] = 0.0277000000; feg[59] = 0.0217000000;
					g[60] = 3.0000000000; fxg[60] = 0.0262000000; feg[60] = 0.0210000000;
					g[61] = 3.0500000000; fxg[61] = 0.0248000000; feg[61] = 0.0203000000;
					g[62] = 3.1000000000; fxg[62] = 0.0234000000; feg[62] = 0.0197000000;
					g[63] = 3.1500000000; fxg[63] = 0.0222000000; feg[63] = 0.0191000000;
					g[64] = 3.2000000000; fxg[64] = 0.0210000000; feg[64] = 0.0185000000;
					g[65] = 3.2500000000; fxg[65] = 0.0199000000; feg[65] = 0.0179000000;
					g[66] = 3.3000000000; fxg[66] = 0.0189000000; feg[66] = 0.0174000000;
					g[67] = 3.3500000000; fxg[67] = 0.0179000000; feg[67] = 0.0169000000;
					g[68] = 3.4000000000; fxg[68] = 0.0170000000; feg[68] = 0.0164000000;
					g[69] = 3.4500000000; fxg[69] = 0.0161000000; feg[69] = 0.0160000000;
					g[70] = 3.5000000000; fxg[70] = 0.0153000000; feg[70] = 0.0155000000;
					g[71] = 3.5500000000; fxg[71] = 0.0146000000; feg[71] = 0.0151000000;
					g[72] = 3.6000000000; fxg[72] = 0.0139000000; feg[72] = 0.0147000000;
					g[73] = 3.6500000000; fxg[73] = 0.0132000000; feg[73] = 0.0143000000;
					g[74] = 3.7000000000; fxg[74] = 0.0126000000; feg[74] = 0.0139000000;
					g[75] = 3.7500000000; fxg[75] = 0.0120000000; feg[75] = 0.0135000000;
					g[76] = 3.8000000000; fxg[76] = 0.0114000000; feg[76] = 0.0132000000;
					g[77] = 3.8500000000; fxg[77] = 0.0109000000; feg[77] = 0.0128000000;
					g[78] = 3.9000000000; fxg[78] = 0.0104000000; feg[78] = 0.0125000000;
					g[79] = 3.9500000000; fxg[79] = 0.0100000000; feg[79] = 0.0122000000;
					ng = 80;
					break;
				case 3:
					g[0] = 0.0000000000; fxg[0] = 3.0000000000; feg[0] = 3.2860000000;
					g[1] = 0.0500000000; fxg[1] = 2.9177000000; feg[1] = 3.1524000000;
					g[2] = 0.1000000000; fxg[2] = 2.7075000000; feg[2] = 2.7999000000;
					g[3] = 0.1500000000; fxg[3] = 2.4501000000; feg[3] = 2.3396000000;
					g[4] = 0.2000000000; fxg[4] = 2.2151000000; feg[4] = 1.8786000000;
					g[5] = 0.2500000000; fxg[5] = 2.0332000000; feg[5] = 1.4809000000;
					g[6] = 0.3000000000; fxg[6] = 1.9036000000; feg[6] = 1.1662000000;
					g[7] = 0.3500000000; fxg[7] = 1.8116000000; feg[7] = 0.9287000000;
					g[8] = 0.4000000000; fxg[8] = 1.7416000000; feg[8] = 0.7530000000;
					g[9] = 0.4500000000; fxg[9] = 1.6820000000; feg[9] = 0.6231000000;
					g[10] = 0.5000000000; fxg[10] = 1.6260000000; feg[10] = 0.5262000000;
					g[11] = 0.5500000000; fxg[11] = 1.5700000000; feg[11] = 0.4526000000;
					g[12] = 0.6000000000; fxg[12] = 1.5127000000; feg[12] = 0.3955000000;
					g[13] = 0.6500000000; fxg[13] = 1.4536000000; feg[13] = 0.3504000000;
					g[14] = 0.7000000000; fxg[14] = 1.3931000000; feg[14] = 0.3139000000;
					g[15] = 0.7500000000; fxg[15] = 1.3319000000; feg[15] = 0.2839000000;
					g[16] = 0.8000000000; fxg[16] = 1.2704000000; feg[16] = 0.2587000000;
					g[17] = 0.8500000000; fxg[17] = 1.2093000000; feg[17] = 0.2373000000;
					g[18] = 0.9000000000; fxg[18] = 1.1490000000; feg[18] = 0.2188000000;
					g[19] = 0.9500000000; fxg[19] = 1.0900000000; feg[19] = 0.2026000000;
					g[20] = 1.0000000000; fxg[20] = 1.0326000000; feg[20] = 0.1883000000;
					g[21] = 1.0500000000; fxg[21] = 0.9771000000; feg[21] = 0.1757000000;
					g[22] = 1.1000000000; fxg[22] = 0.9236000000; feg[22] = 0.1643000000;
					g[23] = 1.1500000000; fxg[23] = 0.8723000000; feg[23] = 0.1540000000;
					g[24] = 1.2000000000; fxg[24] = 0.8233000000; feg[24] = 0.1447000000;
					g[25] = 1.2500000000; fxg[25] = 0.7766000000; feg[25] = 0.1362000000;
					g[26] = 1.3000000000; fxg[26] = 0.7323000000; feg[26] = 0.1285000000;
					g[27] = 1.3500000000; fxg[27] = 0.6902000000; feg[27] = 0.1213000000;
					g[28] = 1.4000000000; fxg[28] = 0.6504000000; feg[28] = 0.1148000000;
					g[29] = 1.4500000000; fxg[29] = 0.6128000000; feg[29] = 0.1087000000;
					g[30] = 1.5000000000; fxg[30] = 0.5773000000; feg[30] = 0.1031000000;
					g[31] = 1.5500000000; fxg[31] = 0.5439000000; feg[31] = 0.0979000000;
					g[32] = 1.6000000000; fxg[32] = 0.5124000000; feg[32] = 0.0930000000;
					g[33] = 1.6500000000; fxg[33] = 0.4828000000; feg[33] = 0.0885000000;
					g[34] = 1.7000000000; fxg[34] = 0.4549000000; feg[34] = 0.0843000000;
					g[35] = 1.7500000000; fxg[35] = 0.4288000000; feg[35] = 0.0804000000;
					g[36] = 1.8000000000; fxg[36] = 0.4043000000; feg[36] = 0.0767000000;
					g[37] = 1.8500000000; fxg[37] = 0.3812000000; feg[37] = 0.0733000000;
					g[38] = 1.9000000000; fxg[38] = 0.3595000000; feg[38] = 0.0700000000;
					g[39] = 1.9500000000; fxg[39] = 0.3392000000; feg[39] = 0.0670000000;
					g[40] = 2.0000000000; fxg[40] = 0.3203000000; feg[40] = 0.0641000000;
					g[41] = 2.0500000000; fxg[41] = 0.3025000000; feg[41] = 0.0615000000;
					g[42] = 2.1000000000; fxg[42] = 0.2855000000; feg[42] = 0.0589000000;
					g[43] = 2.1500000000; fxg[43] = 0.2698000000; feg[43] = 0.0565000000;
					g[44] = 2.2000000000; fxg[44] = 0.2552000000; feg[44] = 0.0543000000;
					g[45] = 2.2500000000; fxg[45] = 0.2415000000; feg[45] = 0.0522000000;
					g[46] = 2.3000000000; fxg[46] = 0.2283000000; feg[46] = 0.0502000000;
					g[47] = 2.3500000000; fxg[47] = 0.2158000000; feg[47] = 0.0483000000;
					g[48] = 2.4000000000; fxg[48] = 0.2044000000; feg[48] = 0.0465000000;
					g[49] = 2.4500000000; fxg[49] = 0.1940000000; feg[49] = 0.0448000000;
					g[50] = 2.5000000000; fxg[50] = 0.1840000000; feg[50] = 0.0431000000;
					g[51] = 2.5500000000; fxg[51] = 0.1741000000; feg[51] = 0.0416000000;
					g[52] = 2.6000000000; fxg[52] = 0.1648000000; feg[52] = 0.0402000000;
					g[53] = 2.6500000000; fxg[53] = 0.1565000000; feg[53] = 0.0388000000;
					g[54] = 2.7000000000; fxg[54] = 0.1490000000; feg[54] = 0.0374000000;
					g[55] = 2.7500000000; fxg[55] = 0.1419000000; feg[55] = 0.0362000000;
					g[56] = 2.8000000000; fxg[56] = 0.1346000000; feg[56] = 0.0350000000;
					g[57] = 2.8500000000; fxg[57] = 0.1274000000; feg[57] = 0.0339000000;
					g[58] = 2.9000000000; fxg[58] = 0.1208000000; feg[58] = 0.0328000000;
					g[59] = 2.9500000000; fxg[59] = 0.1154000000; feg[59] = 0.0317000000;
					g[60] = 3.0000000000; fxg[60] = 0.1105000000; feg[60] = 0.0307000000;
					g[61] = 3.0500000000; fxg[61] = 0.1055000000; feg[61] = 0.0298000000;
					g[62] = 3.1000000000; fxg[62] = 0.1001000000; feg[62] = 0.0289000000;
					g[63] = 3.1500000000; fxg[63] = 0.0947000000; feg[63] = 0.0280000000;
					g[64] = 3.2000000000; fxg[64] = 0.0899000000; feg[64] = 0.0272000000;
					g[65] = 3.2500000000; fxg[65] = 0.0860000000; feg[65] = 0.0264000000;
					g[66] = 3.3000000000; fxg[66] = 0.0829000000; feg[66] = 0.0256000000;
					g[67] = 3.3500000000; fxg[67] = 0.0798000000; feg[67] = 0.0249000000;
					g[68] = 3.4000000000; fxg[68] = 0.0761000000; feg[68] = 0.0242000000;
					g[69] = 3.4500000000; fxg[69] = 0.0720000000; feg[69] = 0.0236000000;
					g[70] = 3.5000000000; fxg[70] = 0.0680000000; feg[70] = 0.0229000000;
					g[71] = 3.5500000000; fxg[71] = 0.0647000000; feg[71] = 0.0223000000;
					g[72] = 3.6000000000; fxg[72] = 0.0624000000; feg[72] = 0.0217000000;
					g[73] = 3.6500000000; fxg[73] = 0.0607000000; feg[73] = 0.0211000000;
					g[74] = 3.7000000000; fxg[74] = 0.0588000000; feg[74] = 0.0206000000;
					g[75] = 3.7500000000; fxg[75] = 0.0563000000; feg[75] = 0.0200000000;
					g[76] = 3.8000000000; fxg[76] = 0.0532000000; feg[76] = 0.0195000000;
					g[77] = 3.8500000000; fxg[77] = 0.0501000000; feg[77] = 0.0191000000;
					g[78] = 3.9000000000; fxg[78] = 0.0473000000; feg[78] = 0.0186000000;
					g[79] = 3.9500000000; fxg[79] = 0.0454000000; feg[79] = 0.0181000000;
					g[80] = 4.0000000000; fxg[80] = 0.0445000000; feg[80] = 0.0177000000;
					g[81] = 4.0500000000; fxg[81] = 0.0438000000; feg[81] = 0.0173000000;
					g[82] = 4.1000000000; fxg[82] = 0.0426000000; feg[82] = 0.0168000000;
					g[83] = 4.1500000000; fxg[83] = 0.0407000000; feg[83] = 0.0164000000;
					g[84] = 4.2000000000; fxg[84] = 0.0384000000; feg[84] = 0.0161000000;
					g[85] = 4.2500000000; fxg[85] = 0.0360000000; feg[85] = 0.0157000000;
					g[86] = 4.3000000000; fxg[86] = 0.0338000000; feg[86] = 0.0154000000;
					g[87] = 4.3500000000; fxg[87] = 0.0323000000; feg[87] = 0.0150000000;
					g[88] = 4.4000000000; fxg[88] = 0.0317000000; feg[88] = 0.0147000000;
					g[89] = 4.4500000000; fxg[89] = 0.0317000000; feg[89] = 0.0144000000;
					g[90] = 4.5000000000; fxg[90] = 0.0315000000; feg[90] = 0.0140000000;
					g[91] = 4.5500000000; fxg[91] = 0.0305000000; feg[91] = 0.0137000000;
					g[92] = 4.6000000000; fxg[92] = 0.0289000000; feg[92] = 0.0134000000;
					g[93] = 4.6500000000; fxg[93] = 0.0272000000; feg[93] = 0.0132000000;
					g[94] = 4.7000000000; fxg[94] = 0.0255000000; feg[94] = 0.0129000000;
					g[95] = 4.7500000000; fxg[95] = 0.0237000000; feg[95] = 0.0126000000;
					g[96] = 4.8000000000; fxg[96] = 0.0224000000; feg[96] = 0.0124000000;
					g[97] = 4.8500000000; fxg[97] = 0.0220000000; feg[97] = 0.0121000000;
					g[98] = 4.9000000000; fxg[98] = 0.0225000000; feg[98] = 0.0119000000;
					g[99] = 4.9500000000; fxg[99] = 0.0229000000; feg[99] = 0.0116000000;
					g[100] = 5.0000000000; fxg[100] = 0.0225000000; feg[100] = 0.0114000000;
					g[101] = 5.0500000000; fxg[101] = 0.0214000000; feg[101] = 0.0112000000;
					g[102] = 5.1000000000; fxg[102] = 0.0202000000; feg[102] = 0.0110000000;
					g[103] = 5.1500000000; fxg[103] = 0.0190000000; feg[103] = 0.0108000000;
					g[104] = 5.2000000000; fxg[104] = 0.0178000000; feg[104] = 0.0106000000;
					g[105] = 5.2500000000; fxg[105] = 0.0164000000; feg[105] = 0.0104000000;
					g[106] = 5.3000000000; fxg[106] = 0.0153000000; feg[106] = 0.0102000000;
					g[107] = 5.3500000000; fxg[107] = 0.0149000000; feg[107] = 0.0100000000;
					g[108] = 5.4000000000; fxg[108] = 0.0155000000; feg[108] = 0.0098000000;
					g[109] = 5.4500000000; fxg[109] = 0.0164000000; feg[109] = 0.0096000000;
					g[110] = 5.5000000000; fxg[110] = 0.0166000000; feg[110] = 0.0094000000;
					g[111] = 5.5500000000; fxg[111] = 0.0159000000; feg[111] = 0.0093000000;
					g[112] = 5.6000000000; fxg[112] = 0.0148000000; feg[112] = 0.0091000000;
					g[113] = 5.6500000000; fxg[113] = 0.0139000000; feg[113] = 0.0090000000;
					g[114] = 5.7000000000; fxg[114] = 0.0133000000; feg[114] = 0.0088000000;
					g[115] = 5.7500000000; fxg[115] = 0.0125000000; feg[115] = 0.0087000000;
					g[116] = 5.8000000000; fxg[116] = 0.0114000000; feg[116] = 0.0085000000;
					g[117] = 5.8500000000; fxg[117] = 0.0102000000; feg[117] = 0.0084000000;
					g[118] = 5.9000000000; fxg[118] = 0.0097000000; feg[118] = 0.0082000000;
					ng = 119;
					break;
				case 4:
					g[0] = 0.0000000000; fxg[0] = 4.0000000000; feg[0] = 3.0539000000;
					g[1] = 0.0500000000; fxg[1] = 3.9219000000; feg[1] = 2.9891000000;
					g[2] = 0.1000000000; fxg[2] = 3.7067000000; feg[2] = 2.8078000000;
					g[3] = 0.1500000000; fxg[3] = 3.4023000000; feg[3] = 2.5433000000;
					g[4] = 0.2000000000; fxg[4] = 3.0653000000; feg[4] = 2.2372000000;
					g[5] = 0.2500000000; fxg[5] = 2.7426000000; feg[5] = 1.9260000000;
					g[6] = 0.3000000000; fxg[6] = 2.4626000000; feg[6] = 1.6354000000;
					g[7] = 0.3500000000; fxg[7] = 2.2356000000; feg[7] = 1.3789000000;
					g[8] = 0.4000000000; fxg[8] = 2.0598000000; feg[8] = 1.1609000000;
					g[9] = 0.4500000000; fxg[9] = 1.9272000000; feg[9] = 0.9800000000;
					g[10] = 0.5000000000; fxg[10] = 1.8277000000; feg[10] = 0.8319000000;
					g[11] = 0.5500000000; fxg[11] = 1.7520000000; feg[11] = 0.7115000000;
					g[12] = 0.6000000000; fxg[12] = 1.6923000000; feg[12] = 0.6137000000;
					g[13] = 0.6500000000; fxg[13] = 1.6429000000; feg[13] = 0.5341000000;
					g[14] = 0.7000000000; fxg[14] = 1.5996000000; feg[14] = 0.4690000000;
					g[15] = 0.7500000000; fxg[15] = 1.5594000000; feg[15] = 0.4154000000;
					g[16] = 0.8000000000; fxg[16] = 1.5205000000; feg[16] = 0.3709000000;
					g[17] = 0.8500000000; fxg[17] = 1.4818000000; feg[17] = 0.3337000000;
					g[18] = 0.9000000000; fxg[18] = 1.4427000000; feg[18] = 0.3023000000;
					g[19] = 0.9500000000; fxg[19] = 1.4029000000; feg[19] = 0.2755000000;
					g[20] = 1.0000000000; fxg[20] = 1.3623000000; feg[20] = 0.2525000000;
					g[21] = 1.0500000000; fxg[21] = 1.3211000000; feg[21] = 0.2326000000;
					g[22] = 1.1000000000; fxg[22] = 1.2794000000; feg[22] = 0.2152000000;
					g[23] = 1.1500000000; fxg[23] = 1.2374000000; feg[23] = 0.2000000000;
					g[24] = 1.2000000000; fxg[24] = 1.1953000000; feg[24] = 0.1865000000;
					g[25] = 1.2500000000; fxg[25] = 1.1534000000; feg[25] = 0.1744000000;
					g[26] = 1.3000000000; fxg[26] = 1.1117000000; feg[26] = 0.1636000000;
					g[27] = 1.3500000000; fxg[27] = 1.0705000000; feg[27] = 0.1539000000;
					g[28] = 1.4000000000; fxg[28] = 1.0299000000; feg[28] = 0.1451000000;
					g[29] = 1.4500000000; fxg[29] = 0.9901000000; feg[29] = 0.1371000000;
					g[30] = 1.5000000000; fxg[30] = 0.9512000000; feg[30] = 0.1297000000;
					g[31] = 1.5500000000; fxg[31] = 0.9133000000; feg[31] = 0.1230000000;
					g[32] = 1.6000000000; fxg[32] = 0.8764000000; feg[32] = 0.1168000000;
					g[33] = 1.6500000000; fxg[33] = 0.8405000000; feg[33] = 0.1111000000;
					g[34] = 1.7000000000; fxg[34] = 0.8058000000; feg[34] = 0.1058000000;
					g[35] = 1.7500000000; fxg[35] = 0.7723000000; feg[35] = 0.1009000000;
					g[36] = 1.8000000000; fxg[36] = 0.7399000000; feg[36] = 0.0963000000;
					g[37] = 1.8500000000; fxg[37] = 0.7088000000; feg[37] = 0.0921000000;
					g[38] = 1.9000000000; fxg[38] = 0.6787000000; feg[38] = 0.0881000000;
					g[39] = 1.9500000000; fxg[39] = 0.6499000000; feg[39] = 0.0843000000;
					g[40] = 2.0000000000; fxg[40] = 0.6222000000; feg[40] = 0.0808000000;
					g[41] = 2.0500000000; fxg[41] = 0.5956000000; feg[41] = 0.0776000000;
					g[42] = 2.1000000000; fxg[42] = 0.5701000000; feg[42] = 0.0745000000;
					g[43] = 2.1500000000; fxg[43] = 0.5457000000; feg[43] = 0.0715000000;
					g[44] = 2.2000000000; fxg[44] = 0.5223000000; feg[44] = 0.0688000000;
					g[45] = 2.2500000000; fxg[45] = 0.5000000000; feg[45] = 0.0662000000;
					g[46] = 2.3000000000; fxg[46] = 0.4785000000; feg[46] = 0.0637000000;
					g[47] = 2.3500000000; fxg[47] = 0.4581000000; feg[47] = 0.0614000000;
					g[48] = 2.4000000000; fxg[48] = 0.4386000000; feg[48] = 0.0592000000;
					g[49] = 2.4500000000; fxg[49] = 0.4200000000; feg[49] = 0.0571000000;
					g[50] = 2.5000000000; fxg[50] = 0.4021000000; feg[50] = 0.0551000000;
					g[51] = 2.5500000000; fxg[51] = 0.3850000000; feg[51] = 0.0532000000;
					g[52] = 2.6000000000; fxg[52] = 0.3687000000; feg[52] = 0.0514000000;
					g[53] = 2.6500000000; fxg[53] = 0.3533000000; feg[53] = 0.0497000000;
					g[54] = 2.7000000000; fxg[54] = 0.3386000000; feg[54] = 0.0481000000;
					g[55] = 2.7500000000; fxg[55] = 0.3245000000; feg[55] = 0.0465000000;
					g[56] = 2.8000000000; fxg[56] = 0.3110000000; feg[56] = 0.0450000000;
					g[57] = 2.8500000000; fxg[57] = 0.2979000000; feg[57] = 0.0436000000;
					g[58] = 2.9000000000; fxg[58] = 0.2856000000; feg[58] = 0.0423000000;
					g[59] = 2.9500000000; fxg[59] = 0.2741000000; feg[59] = 0.0410000000;
					g[60] = 3.0000000000; fxg[60] = 0.2631000000; feg[60] = 0.0397000000;
					g[61] = 3.0500000000; fxg[61] = 0.2525000000; feg[61] = 0.0386000000;
					g[62] = 3.1000000000; fxg[62] = 0.2421000000; feg[62] = 0.0374000000;
					g[63] = 3.1500000000; fxg[63] = 0.2321000000; feg[63] = 0.0364000000;
					g[64] = 3.2000000000; fxg[64] = 0.2227000000; feg[64] = 0.0353000000;
					g[65] = 3.2500000000; fxg[65] = 0.2141000000; feg[65] = 0.0343000000;
					g[66] = 3.3000000000; fxg[66] = 0.2060000000; feg[66] = 0.0334000000;
					g[67] = 3.3500000000; fxg[67] = 0.1982000000; feg[67] = 0.0324000000;
					g[68] = 3.4000000000; fxg[68] = 0.1903000000; feg[68] = 0.0316000000;
					g[69] = 3.4500000000; fxg[69] = 0.1825000000; feg[69] = 0.0307000000;
					g[70] = 3.5000000000; fxg[70] = 0.1750000000; feg[70] = 0.0299000000;
					g[71] = 3.5500000000; fxg[71] = 0.1682000000; feg[71] = 0.0291000000;
					g[72] = 3.6000000000; fxg[72] = 0.1622000000; feg[72] = 0.0283000000;
					g[73] = 3.6500000000; fxg[73] = 0.1566000000; feg[73] = 0.0276000000;
					g[74] = 3.7000000000; fxg[74] = 0.1511000000; feg[74] = 0.0269000000;
					g[75] = 3.7500000000; fxg[75] = 0.1454000000; feg[75] = 0.0262000000;
					g[76] = 3.8000000000; fxg[76] = 0.1394000000; feg[76] = 0.0256000000;
					g[77] = 3.8500000000; fxg[77] = 0.1336000000; feg[77] = 0.0250000000;
					g[78] = 3.9000000000; fxg[78] = 0.1283000000; feg[78] = 0.0244000000;
					g[79] = 3.9500000000; fxg[79] = 0.1238000000; feg[79] = 0.0238000000;
					g[80] = 4.0000000000; fxg[80] = 0.1200000000; feg[80] = 0.0232000000;
					g[81] = 4.0500000000; fxg[81] = 0.1165000000; feg[81] = 0.0227000000;
					g[82] = 4.1000000000; fxg[82] = 0.1127000000; feg[82] = 0.0221000000;
					g[83] = 4.1500000000; fxg[83] = 0.1085000000; feg[83] = 0.0216000000;
					g[84] = 4.2000000000; fxg[84] = 0.1040000000; feg[84] = 0.0211000000;
					g[85] = 4.2500000000; fxg[85] = 0.0995000000; feg[85] = 0.0207000000;
					g[86] = 4.3000000000; fxg[86] = 0.0954000000; feg[86] = 0.0202000000;
					g[87] = 4.3500000000; fxg[87] = 0.0921000000; feg[87] = 0.0198000000;
					g[88] = 4.4000000000; fxg[88] = 0.0896000000; feg[88] = 0.0193000000;
					g[89] = 4.4500000000; fxg[89] = 0.0875000000; feg[89] = 0.0189000000;
					g[90] = 4.5000000000; fxg[90] = 0.0854000000; feg[90] = 0.0185000000;
					g[91] = 4.5500000000; fxg[91] = 0.0827000000; feg[91] = 0.0181000000;
					g[92] = 4.6000000000; fxg[92] = 0.0796000000; feg[92] = 0.0177000000;
					g[93] = 4.6500000000; fxg[93] = 0.0760000000; feg[93] = 0.0174000000;
					g[94] = 4.7000000000; fxg[94] = 0.0724000000; feg[94] = 0.0170000000;
					g[95] = 4.7500000000; fxg[95] = 0.0693000000; feg[95] = 0.0167000000;
					g[96] = 4.8000000000; fxg[96] = 0.0669000000; feg[96] = 0.0163000000;
					g[97] = 4.8500000000; fxg[97] = 0.0653000000; feg[97] = 0.0160000000;
					g[98] = 4.9000000000; fxg[98] = 0.0644000000; feg[98] = 0.0157000000;
					g[99] = 4.9500000000; fxg[99] = 0.0635000000; feg[99] = 0.0154000000;
					g[100] = 5.0000000000; fxg[100] = 0.0621000000; feg[100] = 0.0151000000;
					g[101] = 5.0500000000; fxg[101] = 0.0601000000; feg[101] = 0.0148000000;
					g[102] = 5.1000000000; fxg[102] = 0.0575000000; feg[102] = 0.0145000000;
					g[103] = 5.1500000000; fxg[103] = 0.0547000000; feg[103] = 0.0142000000;
					g[104] = 5.2000000000; fxg[104] = 0.0518000000; feg[104] = 0.0140000000;
					g[105] = 5.2500000000; fxg[105] = 0.0493000000; feg[105] = 0.0137000000;
					g[106] = 5.3000000000; fxg[106] = 0.0475000000; feg[106] = 0.0135000000;
					g[107] = 5.3500000000; fxg[107] = 0.0466000000; feg[107] = 0.0132000000;
					g[108] = 5.4000000000; fxg[108] = 0.0464000000; feg[108] = 0.0130000000;
					g[109] = 5.4500000000; fxg[109] = 0.0465000000; feg[109] = 0.0127000000;
					g[110] = 5.5000000000; fxg[110] = 0.0461000000; feg[110] = 0.0125000000;
					g[111] = 5.5500000000; fxg[111] = 0.0451000000; feg[111] = 0.0123000000;
					g[112] = 5.6000000000; fxg[112] = 0.0434000000; feg[112] = 0.0121000000;
					g[113] = 5.6500000000; fxg[113] = 0.0412000000; feg[113] = 0.0119000000;
					g[114] = 5.7000000000; fxg[114] = 0.0389000000; feg[114] = 0.0117000000;
					g[115] = 5.7500000000; fxg[115] = 0.0366000000; feg[115] = 0.0115000000;
					g[116] = 5.8000000000; fxg[116] = 0.0346000000; feg[116] = 0.0113000000;
					g[117] = 5.8500000000; fxg[117] = 0.0331000000; feg[117] = 0.0111000000;
					g[118] = 5.9000000000; fxg[118] = 0.0325000000; feg[118] = 0.0109000000;
					g[119] = 5.9500000000; fxg[119] = 0.0327000000; feg[119] = 0.0107000000;
					g[120] = 6.0000000000; fxg[120] = 0.0334000000; feg[120] = 0.0105000000;
					g[121] = 6.0500000000; fxg[121] = 0.0338000000; feg[121] = 0.0104000000;
					g[122] = 6.1000000000; fxg[122] = 0.0337000000; feg[122] = 0.0102000000;
					g[123] = 6.1500000000; fxg[123] = 0.0327000000; feg[123] = 0.0100000000;
					g[124] = 6.2000000000; fxg[124] = 0.0312000000; feg[124] = 0.0099000000;
					g[125] = 6.2500000000; fxg[125] = 0.0295000000; feg[125] = 0.0097000000;
					g[126] = 6.3000000000; fxg[126] = 0.0277000000; feg[126] = 0.0096000000;
					g[127] = 6.3500000000; fxg[127] = 0.0258000000; feg[127] = 0.0094000000;
					g[128] = 6.4000000000; fxg[128] = 0.0240000000; feg[128] = 0.0093000000;
					g[129] = 6.4500000000; fxg[129] = 0.0226000000; feg[129] = 0.0092000000;
					g[130] = 6.5000000000; fxg[130] = 0.0219000000; feg[130] = 0.0090000000;
					g[131] = 6.5500000000; fxg[131] = 0.0221000000; feg[131] = 0.0089000000;
					g[132] = 6.6000000000; fxg[132] = 0.0231000000; feg[132] = 0.0087000000;
					g[133] = 6.6500000000; fxg[133] = 0.0242000000; feg[133] = 0.0086000000;
					g[134] = 6.7000000000; fxg[134] = 0.0249000000; feg[134] = 0.0085000000;
					g[135] = 6.7500000000; fxg[135] = 0.0248000000; feg[135] = 0.0084000000;
					g[136] = 6.8000000000; fxg[136] = 0.0239000000; feg[136] = 0.0082000000;
					g[137] = 6.8500000000; fxg[137] = 0.0226000000; feg[137] = 0.0081000000;
					g[138] = 6.9000000000; fxg[138] = 0.0212000000; feg[138] = 0.0080000000;
					g[139] = 6.9500000000; fxg[139] = 0.0199000000; feg[139] = 0.0079000000;
					g[140] = 7.0000000000; fxg[140] = 0.0185000000; feg[140] = 0.0078000000;
					g[141] = 7.0500000000; fxg[141] = 0.0170000000; feg[141] = 0.0077000000;
					g[142] = 7.1000000000; fxg[142] = 0.0156000000; feg[142] = 0.0076000000;
					g[143] = 7.1500000000; fxg[143] = 0.0145000000; feg[143] = 0.0075000000;
					g[144] = 7.2000000000; fxg[144] = 0.0141000000; feg[144] = 0.0074000000;
					g[145] = 7.2500000000; fxg[145] = 0.0148000000; feg[145] = 0.0073000000;
					g[146] = 7.3000000000; fxg[146] = 0.0161000000; feg[146] = 0.0072000000;
					g[147] = 7.3500000000; fxg[147] = 0.0176000000; feg[147] = 0.0071000000;
					g[148] = 7.4000000000; fxg[148] = 0.0185000000; feg[148] = 0.0070000000;
					g[149] = 7.4500000000; fxg[149] = 0.0186000000; feg[149] = 0.0069000000;
					g[150] = 7.5000000000; fxg[150] = 0.0178000000; feg[150] = 0.0068000000;
					g[151] = 7.5500000000; fxg[151] = 0.0166000000; feg[151] = 0.0067000000;
					g[152] = 7.6000000000; fxg[152] = 0.0155000000; feg[152] = 0.0066000000;
					g[153] = 7.6500000000; fxg[153] = 0.0145000000; feg[153] = 0.0065000000;
					g[154] = 7.7000000000; fxg[154] = 0.0137000000; feg[154] = 0.0064000000;
					g[155] = 7.7500000000; fxg[155] = 0.0127000000; feg[155] = 0.0064000000;
					g[156] = 7.8000000000; fxg[156] = 0.0115000000; feg[156] = 0.0063000000;
					g[157] = 7.8500000000; fxg[157] = 0.0101000000; feg[157] = 0.0062000000;
					g[158] = 7.9000000000; fxg[158] = 0.0090000000; feg[158] = 0.0061000000;
					ng = 159;
					break;
				case 5:
					g[0] = 0.0000000000; fxg[0] = 5.0000000000; feg[0] = 2.7949000000;
					g[1] = 0.0500000000; fxg[1] = 4.9281000000; feg[1] = 2.7541000000;
					g[2] = 0.1000000000; fxg[2] = 4.7244000000; feg[2] = 2.6381000000;
					g[3] = 0.1500000000; fxg[3] = 4.4212000000; feg[3] = 2.4629000000;
					g[4] = 0.2000000000; fxg[4] = 4.0599000000; feg[4] = 2.2500000000;
					g[5] = 0.2500000000; fxg[5] = 3.6810000000; feg[5] = 2.0204000000;
					g[6] = 0.3000000000; fxg[6] = 3.3160000000; feg[6] = 1.7913000000;
					g[7] = 0.3500000000; fxg[7] = 2.9853000000; feg[7] = 1.5745000000;
					g[8] = 0.4000000000; fxg[8] = 2.6989000000; feg[8] = 1.3769000000;
					g[9] = 0.4500000000; fxg[9] = 2.4589000000; feg[9] = 1.2013000000;
					g[10] = 0.5000000000; fxg[10] = 2.2627000000; feg[10] = 1.0482000000;
					g[11] = 0.5500000000; fxg[11] = 2.1048000000; feg[11] = 0.9163000000;
					g[12] = 0.6000000000; fxg[12] = 1.9790000000; feg[12] = 0.8034000000;
					g[13] = 0.6500000000; fxg[13] = 1.8789000000; feg[13] = 0.7072000000;
					g[14] = 0.7000000000; fxg[14] = 1.7989000000; feg[14] = 0.6254000000;
					g[15] = 0.7500000000; fxg[15] = 1.7342000000; feg[15] = 0.5558000000;
					g[16] = 0.8000000000; fxg[16] = 1.6808000000; feg[16] = 0.4965000000;
					g[17] = 0.8500000000; fxg[17] = 1.6354000000; feg[17] = 0.4458000000;
					g[18] = 0.9000000000; fxg[18] = 1.5958000000; feg[18] = 0.4023000000;
					g[19] = 0.9500000000; fxg[19] = 1.5599000000; feg[19] = 0.3649000000;
					g[20] = 1.0000000000; fxg[20] = 1.5265000000; feg[20] = 0.3325000000;
					g[21] = 1.0500000000; fxg[21] = 1.4946000000; feg[21] = 0.3044000000;
					g[22] = 1.1000000000; fxg[22] = 1.4634000000; feg[22] = 0.2798000000;
					g[23] = 1.1500000000; fxg[23] = 1.4325000000; feg[23] = 0.2582000000;
					g[24] = 1.2000000000; fxg[24] = 1.4017000000; feg[24] = 0.2392000000;
					g[25] = 1.2500000000; fxg[25] = 1.3706000000; feg[25] = 0.2224000000;
					g[26] = 1.3000000000; fxg[26] = 1.3393000000; feg[26] = 0.2074000000;
					g[27] = 1.3500000000; fxg[27] = 1.3077000000; feg[27] = 0.1940000000;
					g[28] = 1.4000000000; fxg[28] = 1.2758000000; feg[28] = 0.1819000000;
					g[29] = 1.4500000000; fxg[29] = 1.2438000000; feg[29] = 0.1710000000;
					g[30] = 1.5000000000; fxg[30] = 1.2116000000; feg[30] = 0.1612000000;
					g[31] = 1.5500000000; fxg[31] = 1.1793000000; feg[31] = 0.1522000000;
					g[32] = 1.6000000000; fxg[32] = 1.1472000000; feg[32] = 0.1441000000;
					g[33] = 1.6500000000; fxg[33] = 1.1151000000; feg[33] = 0.1366000000;
					g[34] = 1.7000000000; fxg[34] = 1.0832000000; feg[34] = 0.1297000000;
					g[35] = 1.7500000000; fxg[35] = 1.0517000000; feg[35] = 0.1234000000;
					g[36] = 1.8000000000; fxg[36] = 1.0205000000; feg[36] = 0.1176000000;
					g[37] = 1.8500000000; fxg[37] = 0.9897000000; feg[37] = 0.1122000000;
					g[38] = 1.9000000000; fxg[38] = 0.9594000000; feg[38] = 0.1072000000;
					g[39] = 1.9500000000; fxg[39] = 0.9296000000; feg[39] = 0.1025000000;
					g[40] = 2.0000000000; fxg[40] = 0.9004000000; feg[40] = 0.0981000000;
					g[41] = 2.0500000000; fxg[41] = 0.8718000000; feg[41] = 0.0940000000;
					g[42] = 2.1000000000; fxg[42] = 0.8438000000; feg[42] = 0.0902000000;
					g[43] = 2.1500000000; fxg[43] = 0.8165000000; feg[43] = 0.0866000000;
					g[44] = 2.2000000000; fxg[44] = 0.7898000000; feg[44] = 0.0833000000;
					g[45] = 2.2500000000; fxg[45] = 0.7639000000; feg[45] = 0.0801000000;
					g[46] = 2.3000000000; fxg[46] = 0.7386000000; feg[46] = 0.0771000000;
					g[47] = 2.3500000000; fxg[47] = 0.7141000000; feg[47] = 0.0743000000;
					g[48] = 2.4000000000; fxg[48] = 0.6902000000; feg[48] = 0.0716000000;
					g[49] = 2.4500000000; fxg[49] = 0.6671000000; feg[49] = 0.0691000000;
					g[50] = 2.5000000000; fxg[50] = 0.6447000000; feg[50] = 0.0667000000;
					g[51] = 2.5500000000; fxg[51] = 0.6229000000; feg[51] = 0.0644000000;
					g[52] = 2.6000000000; fxg[52] = 0.6018000000; feg[52] = 0.0623000000;
					g[53] = 2.6500000000; fxg[53] = 0.5815000000; feg[53] = 0.0602000000;
					g[54] = 2.7000000000; fxg[54] = 0.5618000000; feg[54] = 0.0583000000;
					g[55] = 2.7500000000; fxg[55] = 0.5428000000; feg[55] = 0.0564000000;
					g[56] = 2.8000000000; fxg[56] = 0.5243000000; feg[56] = 0.0547000000;
					g[57] = 2.8500000000; fxg[57] = 0.5065000000; feg[57] = 0.0530000000;
					g[58] = 2.9000000000; fxg[58] = 0.4893000000; feg[58] = 0.0513000000;
					g[59] = 2.9500000000; fxg[59] = 0.4727000000; feg[59] = 0.0498000000;
					g[60] = 3.0000000000; fxg[60] = 0.4568000000; feg[60] = 0.0483000000;
					g[61] = 3.0500000000; fxg[61] = 0.4413000000; feg[61] = 0.0469000000;
					g[62] = 3.1000000000; fxg[62] = 0.4263000000; feg[62] = 0.0456000000;
					g[63] = 3.1500000000; fxg[63] = 0.4118000000; feg[63] = 0.0443000000;
					g[64] = 3.2000000000; fxg[64] = 0.3979000000; feg[64] = 0.0430000000;
					g[65] = 3.2500000000; fxg[65] = 0.3847000000; feg[65] = 0.0418000000;
					g[66] = 3.3000000000; fxg[66] = 0.3719000000; feg[66] = 0.0407000000;
					g[67] = 3.3500000000; fxg[67] = 0.3596000000; feg[67] = 0.0396000000;
					g[68] = 3.4000000000; fxg[68] = 0.3475000000; feg[68] = 0.0385000000;
					g[69] = 3.4500000000; fxg[69] = 0.3358000000; feg[69] = 0.0375000000;
					g[70] = 3.5000000000; fxg[70] = 0.3244000000; feg[70] = 0.0365000000;
					g[71] = 3.5500000000; fxg[71] = 0.3137000000; feg[71] = 0.0356000000;
					g[72] = 3.6000000000; fxg[72] = 0.3036000000; feg[72] = 0.0347000000;
					g[73] = 3.6500000000; fxg[73] = 0.2939000000; feg[73] = 0.0338000000;
					g[74] = 3.7000000000; fxg[74] = 0.2844000000; feg[74] = 0.0330000000;
					g[75] = 3.7500000000; fxg[75] = 0.2751000000; feg[75] = 0.0322000000;
					g[76] = 3.8000000000; fxg[76] = 0.2659000000; feg[76] = 0.0314000000;
					g[77] = 3.8500000000; fxg[77] = 0.2569000000; feg[77] = 0.0306000000;
					g[78] = 3.9000000000; fxg[78] = 0.2485000000; feg[78] = 0.0299000000;
					g[79] = 3.9500000000; fxg[79] = 0.2407000000; feg[79] = 0.0292000000;
					g[80] = 4.0000000000; fxg[80] = 0.2333000000; feg[80] = 0.0285000000;
					g[81] = 4.0500000000; fxg[81] = 0.2263000000; feg[81] = 0.0279000000;
					g[82] = 4.1000000000; fxg[82] = 0.2194000000; feg[82] = 0.0272000000;
					g[83] = 4.1500000000; fxg[83] = 0.2123000000; feg[83] = 0.0266000000;
					g[84] = 4.2000000000; fxg[84] = 0.2052000000; feg[84] = 0.0260000000;
					g[85] = 4.2500000000; fxg[85] = 0.1983000000; feg[85] = 0.0255000000;
					g[86] = 4.3000000000; fxg[86] = 0.1918000000; feg[86] = 0.0249000000;
					g[87] = 4.3500000000; fxg[87] = 0.1859000000; feg[87] = 0.0244000000;
					g[88] = 4.4000000000; fxg[88] = 0.1806000000; feg[88] = 0.0238000000;
					g[89] = 4.4500000000; fxg[89] = 0.1757000000; feg[89] = 0.0233000000;
					g[90] = 4.5000000000; fxg[90] = 0.1708000000; feg[90] = 0.0228000000;
					g[91] = 4.5500000000; fxg[91] = 0.1658000000; feg[91] = 0.0224000000;
					g[92] = 4.6000000000; fxg[92] = 0.1604000000; feg[92] = 0.0219000000;
					g[93] = 4.6500000000; fxg[93] = 0.1550000000; feg[93] = 0.0215000000;
					g[94] = 4.7000000000; fxg[94] = 0.1496000000; feg[94] = 0.0210000000;
					g[95] = 4.7500000000; fxg[95] = 0.1447000000; feg[95] = 0.0206000000;
					g[96] = 4.8000000000; fxg[96] = 0.1404000000; feg[96] = 0.0202000000;
					g[97] = 4.8500000000; fxg[97] = 0.1367000000; feg[97] = 0.0198000000;
					g[98] = 4.9000000000; fxg[98] = 0.1335000000; feg[98] = 0.0194000000;
					g[99] = 4.9500000000; fxg[99] = 0.1304000000; feg[99] = 0.0190000000;
					g[100] = 5.0000000000; fxg[100] = 0.1271000000; feg[100] = 0.0187000000;
					g[101] = 5.0500000000; fxg[101] = 0.1233000000; feg[101] = 0.0183000000;
					g[102] = 5.1000000000; fxg[102] = 0.1192000000; feg[102] = 0.0180000000;
					g[103] = 5.1500000000; fxg[103] = 0.1150000000; feg[103] = 0.0176000000;
					g[104] = 5.2000000000; fxg[104] = 0.1108000000; feg[104] = 0.0173000000;
					g[105] = 5.2500000000; fxg[105] = 0.1071000000; feg[105] = 0.0170000000;
					g[106] = 5.3000000000; fxg[106] = 0.1039000000; feg[106] = 0.0167000000;
					g[107] = 5.3500000000; fxg[107] = 0.1015000000; feg[107] = 0.0164000000;
					g[108] = 5.4000000000; fxg[108] = 0.0996000000; feg[108] = 0.0161000000;
					g[109] = 5.4500000000; fxg[109] = 0.0979000000; feg[109] = 0.0158000000;
					g[110] = 5.5000000000; fxg[110] = 0.0960000000; feg[110] = 0.0155000000;
					g[111] = 5.5500000000; fxg[111] = 0.0937000000; feg[111] = 0.0152000000;
					g[112] = 5.6000000000; fxg[112] = 0.0908000000; feg[112] = 0.0150000000;
					g[113] = 5.6500000000; fxg[113] = 0.0875000000; feg[113] = 0.0147000000;
					g[114] = 5.7000000000; fxg[114] = 0.0841000000; feg[114] = 0.0145000000;
					g[115] = 5.7500000000; fxg[115] = 0.0808000000; feg[115] = 0.0142000000;
					g[116] = 5.8000000000; fxg[116] = 0.0779000000; feg[116] = 0.0140000000;
					g[117] = 5.8500000000; fxg[117] = 0.0755000000; feg[117] = 0.0138000000;
					g[118] = 5.9000000000; fxg[118] = 0.0740000000; feg[118] = 0.0135000000;
					g[119] = 5.9500000000; fxg[119] = 0.0730000000; feg[119] = 0.0133000000;
					g[120] = 6.0000000000; fxg[120] = 0.0724000000; feg[120] = 0.0131000000;
					g[121] = 6.0500000000; fxg[121] = 0.0717000000; feg[121] = 0.0129000000;
					g[122] = 6.1000000000; fxg[122] = 0.0706000000; feg[122] = 0.0127000000;
					g[123] = 6.1500000000; fxg[123] = 0.0688000000; feg[123] = 0.0125000000;
					g[124] = 6.2000000000; fxg[124] = 0.0665000000; feg[124] = 0.0123000000;
					g[125] = 6.2500000000; fxg[125] = 0.0639000000; feg[125] = 0.0121000000;
					g[126] = 6.3000000000; fxg[126] = 0.0611000000; feg[126] = 0.0119000000;
					g[127] = 6.3500000000; fxg[127] = 0.0584000000; feg[127] = 0.0117000000;
					g[128] = 6.4000000000; fxg[128] = 0.0559000000; feg[128] = 0.0116000000;
					g[129] = 6.4500000000; fxg[129] = 0.0540000000; feg[129] = 0.0114000000;
					g[130] = 6.5000000000; fxg[130] = 0.0528000000; feg[130] = 0.0112000000;
					g[131] = 6.5500000000; fxg[131] = 0.0523000000; feg[131] = 0.0110000000;
					g[132] = 6.6000000000; fxg[132] = 0.0524000000; feg[132] = 0.0109000000;
					g[133] = 6.6500000000; fxg[133] = 0.0527000000; feg[133] = 0.0107000000;
					g[134] = 6.7000000000; fxg[134] = 0.0527000000; feg[134] = 0.0106000000;
					g[135] = 6.7500000000; fxg[135] = 0.0520000000; feg[135] = 0.0104000000;
					g[136] = 6.8000000000; fxg[136] = 0.0507000000; feg[136] = 0.0102000000;
					g[137] = 6.8500000000; fxg[137] = 0.0489000000; feg[137] = 0.0101000000;
					g[138] = 6.9000000000; fxg[138] = 0.0468000000; feg[138] = 0.0100000000;
					g[139] = 6.9500000000; fxg[139] = 0.0445000000; feg[139] = 0.0098000000;
					g[140] = 7.0000000000; fxg[140] = 0.0422000000; feg[140] = 0.0097000000;
					g[141] = 7.0500000000; fxg[141] = 0.0400000000; feg[141] = 0.0096000000;
					g[142] = 7.1000000000; fxg[142] = 0.0381000000; feg[142] = 0.0094000000;
					g[143] = 7.1500000000; fxg[143] = 0.0369000000; feg[143] = 0.0093000000;
					g[144] = 7.2000000000; fxg[144] = 0.0363000000; feg[144] = 0.0092000000;
					g[145] = 7.2500000000; fxg[145] = 0.0366000000; feg[145] = 0.0090000000;
					g[146] = 7.3000000000; fxg[146] = 0.0374000000; feg[146] = 0.0089000000;
					g[147] = 7.3500000000; fxg[147] = 0.0383000000; feg[147] = 0.0088000000;
					g[148] = 7.4000000000; fxg[148] = 0.0388000000; feg[148] = 0.0087000000;
					g[149] = 7.4500000000; fxg[149] = 0.0387000000; feg[149] = 0.0086000000;
					g[150] = 7.5000000000; fxg[150] = 0.0378000000; feg[150] = 0.0084000000;
					g[151] = 7.5500000000; fxg[151] = 0.0364000000; feg[151] = 0.0083000000;
					g[152] = 7.6000000000; fxg[152] = 0.0347000000; feg[152] = 0.0082000000;
					g[153] = 7.6500000000; fxg[153] = 0.0329000000; feg[153] = 0.0081000000;
					g[154] = 7.7000000000; fxg[154] = 0.0311000000; feg[154] = 0.0080000000;
					g[155] = 7.7500000000; fxg[155] = 0.0292000000; feg[155] = 0.0079000000;
					g[156] = 7.8000000000; fxg[156] = 0.0274000000; feg[156] = 0.0078000000;
					g[157] = 7.8500000000; fxg[157] = 0.0257000000; feg[157] = 0.0077000000;
					g[158] = 7.9000000000; fxg[158] = 0.0246000000; feg[158] = 0.0076000000;
					g[159] = 7.9500000000; fxg[159] = 0.0242000000; feg[159] = 0.0075000000;
					g[160] = 8.0000000000; fxg[160] = 0.0247000000; feg[160] = 0.0074000000;
					g[161] = 8.0500000000; fxg[161] = 0.0258000000; feg[161] = 0.0073000000;
					g[162] = 8.1000000000; fxg[162] = 0.0272000000; feg[162] = 0.0073000000;
					g[163] = 8.1500000000; fxg[163] = 0.0284000000; feg[163] = 0.0072000000;
					g[164] = 8.2000000000; fxg[164] = 0.0290000000; feg[164] = 0.0071000000;
					g[165] = 8.2500000000; fxg[165] = 0.0287000000; feg[165] = 0.0070000000;
					g[166] = 8.3000000000; fxg[166] = 0.0278000000; feg[166] = 0.0069000000;
					g[167] = 8.3500000000; fxg[167] = 0.0265000000; feg[167] = 0.0068000000;
					g[168] = 8.4000000000; fxg[168] = 0.0251000000; feg[168] = 0.0067000000;
					g[169] = 8.4500000000; fxg[169] = 0.0237000000; feg[169] = 0.0067000000;
					g[170] = 8.5000000000; fxg[170] = 0.0223000000; feg[170] = 0.0066000000;
					g[171] = 8.5500000000; fxg[171] = 0.0208000000; feg[171] = 0.0065000000;
					g[172] = 8.6000000000; fxg[172] = 0.0192000000; feg[172] = 0.0064000000;
					g[173] = 8.6500000000; fxg[173] = 0.0176000000; feg[173] = 0.0064000000;
					g[174] = 8.7000000000; fxg[174] = 0.0163000000; feg[174] = 0.0063000000;
					g[175] = 8.7500000000; fxg[175] = 0.0154000000; feg[175] = 0.0062000000;
					g[176] = 8.8000000000; fxg[176] = 0.0154000000; feg[176] = 0.0062000000;
					g[177] = 8.8500000000; fxg[177] = 0.0162000000; feg[177] = 0.0061000000;
					g[178] = 8.9000000000; fxg[178] = 0.0177000000; feg[178] = 0.0060000000;
					g[179] = 8.9500000000; fxg[179] = 0.0194000000; feg[179] = 0.0060000000;
					g[180] = 9.0000000000; fxg[180] = 0.0210000000; feg[180] = 0.0059000000;
					g[181] = 9.0500000000; fxg[181] = 0.0219000000; feg[181] = 0.0058000000;
					g[182] = 9.1000000000; fxg[182] = 0.0219000000; feg[182] = 0.0058000000;
					g[183] = 9.1500000000; fxg[183] = 0.0212000000; feg[183] = 0.0057000000;
					g[184] = 9.2000000000; fxg[184] = 0.0200000000; feg[184] = 0.0056000000;
					g[185] = 9.2500000000; fxg[185] = 0.0187000000; feg[185] = 0.0056000000;
					g[186] = 9.3000000000; fxg[186] = 0.0176000000; feg[186] = 0.0055000000;
					g[187] = 9.3500000000; fxg[187] = 0.0166000000; feg[187] = 0.0055000000;
					g[188] = 9.4000000000; fxg[188] = 0.0156000000; feg[188] = 0.0054000000;
					g[189] = 9.4500000000; fxg[189] = 0.0146000000; feg[189] = 0.0053000000;
					g[190] = 9.5000000000; fxg[190] = 0.0133000000; feg[190] = 0.0053000000;
					g[191] = 9.5500000000; fxg[191] = 0.0118000000; feg[191] = 0.0052000000;
					g[192] = 9.6000000000; fxg[192] = 0.0104000000; feg[192] = 0.0052000000;
					g[193] = 9.6500000000; fxg[193] = 0.0093000000; feg[193] = 0.0051000000;
					ng = 194;
					break;
				case 6:
					g[0] = 0.0000000000; fxg[0] = 6.0000000000; feg[0] = 2.5097000000;
					g[1] = 0.0500000000; fxg[1] = 5.9352000000; feg[1] = 2.4830000000;
					g[2] = 0.1000000000; fxg[2] = 5.7487000000; feg[2] = 2.4060000000;
					g[3] = 0.1500000000; fxg[3] = 5.4625000000; feg[3] = 2.2871000000;
					g[4] = 0.2000000000; fxg[4] = 5.1068000000; feg[4] = 2.1379000000;
					g[5] = 0.2500000000; fxg[5] = 4.7134000000; feg[5] = 1.9707000000;
					g[6] = 0.3000000000; fxg[6] = 4.3110000000; feg[6] = 1.7966000000;
					g[7] = 0.3500000000; fxg[7] = 3.9215000000; feg[7] = 1.6244000000;
					g[8] = 0.4000000000; fxg[8] = 3.5598000000; feg[8] = 1.4601000000;
					g[9] = 0.4500000000; fxg[9] = 3.2343000000; feg[9] = 1.3075000000;
					g[10] = 0.5000000000; fxg[10] = 2.9486000000; feg[10] = 1.1685000000;
					g[11] = 0.5500000000; fxg[11] = 2.7024000000; feg[11] = 1.0436000000;
					g[12] = 0.6000000000; fxg[12] = 2.4933000000; feg[12] = 0.9325000000;
					g[13] = 0.6500000000; fxg[13] = 2.3175000000; feg[13] = 0.8344000000;
					g[14] = 0.7000000000; fxg[14] = 2.1710000000; feg[14] = 0.7481000000;
					g[15] = 0.7500000000; fxg[15] = 2.0492000000; feg[15] = 0.6724000000;
					g[16] = 0.8000000000; fxg[16] = 1.9483000000; feg[16] = 0.6061000000;
					g[17] = 0.8500000000; fxg[17] = 1.8643000000; feg[17] = 0.5480000000;
					g[18] = 0.9000000000; fxg[18] = 1.7943000000; feg[18] = 0.4971000000;
					g[19] = 0.9500000000; fxg[19] = 1.7352000000; feg[19] = 0.4524000000;
					g[20] = 1.0000000000; fxg[20] = 1.6849000000; feg[20] = 0.4131000000;
					g[21] = 1.0500000000; fxg[21] = 1.6413000000; feg[21] = 0.3785000000;
					g[22] = 1.1000000000; fxg[22] = 1.6029000000; feg[22] = 0.3479000000;
					g[23] = 1.1500000000; fxg[23] = 1.5684000000; feg[23] = 0.3208000000;
					g[24] = 1.2000000000; fxg[24] = 1.5368000000; feg[24] = 0.2967000000;
					g[25] = 1.2500000000; fxg[25] = 1.5073000000; feg[25] = 0.2753000000;
					g[26] = 1.3000000000; fxg[26] = 1.4792000000; feg[26] = 0.2561000000;
					g[27] = 1.3500000000; fxg[27] = 1.4522000000; feg[27] = 0.2389000000;
					g[28] = 1.4000000000; fxg[28] = 1.4258000000; feg[28] = 0.2234000000;
					g[29] = 1.4500000000; fxg[29] = 1.3998000000; feg[29] = 0.2095000000;
					g[30] = 1.5000000000; fxg[30] = 1.3739000000; feg[30] = 0.1968000000;
					g[31] = 1.5500000000; fxg[31] = 1.3482000000; feg[31] = 0.1854000000;
					g[32] = 1.6000000000; fxg[32] = 1.3224000000; feg[32] = 0.1749000000;
					g[33] = 1.6500000000; fxg[33] = 1.2965000000; feg[33] = 0.1654000000;
					g[34] = 1.7000000000; fxg[34] = 1.2706000000; feg[34] = 0.1567000000;
					g[35] = 1.7500000000; fxg[35] = 1.2446000000; feg[35] = 0.1487000000;
					g[36] = 1.8000000000; fxg[36] = 1.2186000000; feg[36] = 0.1413000000;
					g[37] = 1.8500000000; fxg[37] = 1.1925000000; feg[37] = 0.1345000000;
					g[38] = 1.9000000000; fxg[38] = 1.1664000000; feg[38] = 0.1282000000;
					g[39] = 1.9500000000; fxg[39] = 1.1403000000; feg[39] = 0.1224000000;
					g[40] = 2.0000000000; fxg[40] = 1.1144000000; feg[40] = 0.1169000000;
					g[41] = 2.0500000000; fxg[41] = 1.0885000000; feg[41] = 0.1119000000;
					g[42] = 2.1000000000; fxg[42] = 1.0628000000; feg[42] = 0.1072000000;
					g[43] = 2.1500000000; fxg[43] = 1.0373000000; feg[43] = 0.1028000000;
					g[44] = 2.2000000000; fxg[44] = 1.0120000000; feg[44] = 0.0987000000;
					g[45] = 2.2500000000; fxg[45] = 0.9870000000; feg[45] = 0.0948000000;
					g[46] = 2.3000000000; fxg[46] = 0.9623000000; feg[46] = 0.0912000000;
					g[47] = 2.3500000000; fxg[47] = 0.9379000000; feg[47] = 0.0878000000;
					g[48] = 2.4000000000; fxg[48] = 0.9139000000; feg[48] = 0.0845000000;
					g[49] = 2.4500000000; fxg[49] = 0.8903000000; feg[49] = 0.0815000000;
					g[50] = 2.5000000000; fxg[50] = 0.8670000000; feg[50] = 0.0786000000;
					g[51] = 2.5500000000; fxg[51] = 0.8441000000; feg[51] = 0.0759000000;
					g[52] = 2.6000000000; fxg[52] = 0.8217000000; feg[52] = 0.0733000000;
					g[53] = 2.6500000000; fxg[53] = 0.7997000000; feg[53] = 0.0709000000;
					g[54] = 2.7000000000; fxg[54] = 0.7782000000; feg[54] = 0.0686000000;
					g[55] = 2.7500000000; fxg[55] = 0.7571000000; feg[55] = 0.0664000000;
					g[56] = 2.8000000000; fxg[56] = 0.7365000000; feg[56] = 0.0643000000;
					g[57] = 2.8500000000; fxg[57] = 0.7163000000; feg[57] = 0.0623000000;
					g[58] = 2.9000000000; fxg[58] = 0.6966000000; feg[58] = 0.0604000000;
					g[59] = 2.9500000000; fxg[59] = 0.6774000000; feg[59] = 0.0586000000;
					g[60] = 3.0000000000; fxg[60] = 0.6587000000; feg[60] = 0.0568000000;
					g[61] = 3.0500000000; fxg[61] = 0.6404000000; feg[61] = 0.0552000000;
					g[62] = 3.1000000000; fxg[62] = 0.6225000000; feg[62] = 0.0536000000;
					g[63] = 3.1500000000; fxg[63] = 0.6051000000; feg[63] = 0.0521000000;
					g[64] = 3.2000000000; fxg[64] = 0.5882000000; feg[64] = 0.0506000000;
					g[65] = 3.2500000000; fxg[65] = 0.5717000000; feg[65] = 0.0492000000;
					g[66] = 3.3000000000; fxg[66] = 0.5558000000; feg[66] = 0.0479000000;
					g[67] = 3.3500000000; fxg[67] = 0.5402000000; feg[67] = 0.0466000000;
					g[68] = 3.4000000000; fxg[68] = 0.5250000000; feg[68] = 0.0453000000;
					g[69] = 3.4500000000; fxg[69] = 0.5102000000; feg[69] = 0.0442000000;
					g[70] = 3.5000000000; fxg[70] = 0.4958000000; feg[70] = 0.0430000000;
					g[71] = 3.5500000000; fxg[71] = 0.4819000000; feg[71] = 0.0419000000;
					g[72] = 3.6000000000; fxg[72] = 0.4684000000; feg[72] = 0.0409000000;
					g[73] = 3.6500000000; fxg[73] = 0.4554000000; feg[73] = 0.0398000000;
					g[74] = 3.7000000000; fxg[74] = 0.4427000000; feg[74] = 0.0389000000;
					g[75] = 3.7500000000; fxg[75] = 0.4303000000; feg[75] = 0.0379000000;
					g[76] = 3.8000000000; fxg[76] = 0.4181000000; feg[76] = 0.0370000000;
					g[77] = 3.8500000000; fxg[77] = 0.4063000000; feg[77] = 0.0361000000;
					g[78] = 3.9000000000; fxg[78] = 0.3949000000; feg[78] = 0.0353000000;
					g[79] = 3.9500000000; fxg[79] = 0.3840000000; feg[79] = 0.0345000000;
					g[80] = 4.0000000000; fxg[80] = 0.3735000000; feg[80] = 0.0337000000;
					g[81] = 4.0500000000; fxg[81] = 0.3633000000; feg[81] = 0.0329000000;
					g[82] = 4.1000000000; fxg[82] = 0.3534000000; feg[82] = 0.0322000000;
					g[83] = 4.1500000000; fxg[83] = 0.3435000000; feg[83] = 0.0314000000;
					g[84] = 4.2000000000; fxg[84] = 0.3338000000; feg[84] = 0.0308000000;
					g[85] = 4.2500000000; fxg[85] = 0.3243000000; feg[85] = 0.0301000000;
					g[86] = 4.3000000000; fxg[86] = 0.3153000000; feg[86] = 0.0294000000;
					g[87] = 4.3500000000; fxg[87] = 0.3067000000; feg[87] = 0.0288000000;
					g[88] = 4.4000000000; fxg[88] = 0.2986000000; feg[88] = 0.0282000000;
					g[89] = 4.4500000000; fxg[89] = 0.2909000000; feg[89] = 0.0276000000;
					g[90] = 4.5000000000; fxg[90] = 0.2832000000; feg[90] = 0.0270000000;
					g[91] = 4.5500000000; fxg[91] = 0.2756000000; feg[91] = 0.0265000000;
					g[92] = 4.6000000000; fxg[92] = 0.2680000000; feg[92] = 0.0259000000;
					g[93] = 4.6500000000; fxg[93] = 0.2604000000; feg[93] = 0.0254000000;
					g[94] = 4.7000000000; fxg[94] = 0.2530000000; feg[94] = 0.0249000000;
					g[95] = 4.7500000000; fxg[95] = 0.2460000000; feg[95] = 0.0244000000;
					g[96] = 4.8000000000; fxg[96] = 0.2395000000; feg[96] = 0.0239000000;
					g[97] = 4.8500000000; fxg[97] = 0.2335000000; feg[97] = 0.0235000000;
					g[98] = 4.9000000000; fxg[98] = 0.2278000000; feg[98] = 0.0230000000;
					g[99] = 4.9500000000; fxg[99] = 0.2223000000; feg[99] = 0.0226000000;
					g[100] = 5.0000000000; fxg[100] = 0.2167000000; feg[100] = 0.0221000000;
					g[101] = 5.0500000000; fxg[101] = 0.2110000000; feg[101] = 0.0217000000;
					g[102] = 5.1000000000; fxg[102] = 0.2051000000; feg[102] = 0.0213000000;
					g[103] = 5.1500000000; fxg[103] = 0.1992000000; feg[103] = 0.0209000000;
					g[104] = 5.2000000000; fxg[104] = 0.1935000000; feg[104] = 0.0206000000;
					g[105] = 5.2500000000; fxg[105] = 0.1881000000; feg[105] = 0.0202000000;
					g[106] = 5.3000000000; fxg[106] = 0.1833000000; feg[106] = 0.0198000000;
					g[107] = 5.3500000000; fxg[107] = 0.1790000000; feg[107] = 0.0195000000;
					g[108] = 5.4000000000; fxg[108] = 0.1751000000; feg[108] = 0.0191000000;
					g[109] = 5.4500000000; fxg[109] = 0.1713000000; feg[109] = 0.0188000000;
					g[110] = 5.5000000000; fxg[110] = 0.1675000000; feg[110] = 0.0185000000;
					g[111] = 5.5500000000; fxg[111] = 0.1635000000; feg[111] = 0.0181000000;
					g[112] = 5.6000000000; fxg[112] = 0.1591000000; feg[112] = 0.0178000000;
					g[113] = 5.6500000000; fxg[113] = 0.1546000000; feg[113] = 0.0175000000;
					g[114] = 5.7000000000; fxg[114] = 0.1500000000; feg[114] = 0.0172000000;
					g[115] = 5.7500000000; fxg[115] = 0.1455000000; feg[115] = 0.0170000000;
					g[116] = 5.8000000000; fxg[116] = 0.1414000000; feg[116] = 0.0167000000;
					g[117] = 5.8500000000; fxg[117] = 0.1378000000; feg[117] = 0.0164000000;
					g[118] = 5.9000000000; fxg[118] = 0.1348000000; feg[118] = 0.0161000000;
					g[119] = 5.9500000000; fxg[119] = 0.1323000000; feg[119] = 0.0159000000;
					g[120] = 6.0000000000; fxg[120] = 0.1300000000; feg[120] = 0.0156000000;
					g[121] = 6.0500000000; fxg[121] = 0.1277000000; feg[121] = 0.0154000000;
					g[122] = 6.1000000000; fxg[122] = 0.1252000000; feg[122] = 0.0151000000;
					g[123] = 6.1500000000; fxg[123] = 0.1222000000; feg[123] = 0.0149000000;
					g[124] = 6.2000000000; fxg[124] = 0.1189000000; feg[124] = 0.0146000000;
					g[125] = 6.2500000000; fxg[125] = 0.1153000000; feg[125] = 0.0144000000;
					g[126] = 6.3000000000; fxg[126] = 0.1116000000; feg[126] = 0.0142000000;
					g[127] = 6.3500000000; fxg[127] = 0.1081000000; feg[127] = 0.0140000000;
					g[128] = 6.4000000000; fxg[128] = 0.1048000000; feg[128] = 0.0138000000;
					g[129] = 6.4500000000; fxg[129] = 0.1020000000; feg[129] = 0.0136000000;
					g[130] = 6.5000000000; fxg[130] = 0.0999000000; feg[130] = 0.0134000000;
					g[131] = 6.5500000000; fxg[131] = 0.0983000000; feg[131] = 0.0132000000;
					g[132] = 6.6000000000; fxg[132] = 0.0971000000; feg[132] = 0.0130000000;
					g[133] = 6.6500000000; fxg[133] = 0.0961000000; feg[133] = 0.0128000000;
					g[134] = 6.7000000000; fxg[134] = 0.0948000000; feg[134] = 0.0126000000;
					g[135] = 6.7500000000; fxg[135] = 0.0932000000; feg[135] = 0.0124000000;
					g[136] = 6.8000000000; fxg[136] = 0.0911000000; feg[136] = 0.0122000000;
					g[137] = 6.8500000000; fxg[137] = 0.0885000000; feg[137] = 0.0121000000;
					g[138] = 6.9000000000; fxg[138] = 0.0857000000; feg[138] = 0.0119000000;
					g[139] = 6.9500000000; fxg[139] = 0.0827000000; feg[139] = 0.0117000000;
					g[140] = 7.0000000000; fxg[140] = 0.0797000000; feg[140] = 0.0116000000;
					g[141] = 7.0500000000; fxg[141] = 0.0769000000; feg[141] = 0.0114000000;
					g[142] = 7.1000000000; fxg[142] = 0.0746000000; feg[142] = 0.0113000000;
					g[143] = 7.1500000000; fxg[143] = 0.0727000000; feg[143] = 0.0111000000;
					g[144] = 7.2000000000; fxg[144] = 0.0715000000; feg[144] = 0.0109000000;
					g[145] = 7.2500000000; fxg[145] = 0.0710000000; feg[145] = 0.0108000000;
					g[146] = 7.3000000000; fxg[146] = 0.0708000000; feg[146] = 0.0107000000;
					g[147] = 7.3500000000; fxg[147] = 0.0707000000; feg[147] = 0.0105000000;
					g[148] = 7.4000000000; fxg[148] = 0.0703000000; feg[148] = 0.0104000000;
					g[149] = 7.4500000000; fxg[149] = 0.0695000000; feg[149] = 0.0102000000;
					g[150] = 7.5000000000; fxg[150] = 0.0681000000; feg[150] = 0.0101000000;
					g[151] = 7.5500000000; fxg[151] = 0.0663000000; feg[151] = 0.0100000000;
					g[152] = 7.6000000000; fxg[152] = 0.0640000000; feg[152] = 0.0098000000;
					g[153] = 7.6500000000; fxg[153] = 0.0616000000; feg[153] = 0.0097000000;
					g[154] = 7.7000000000; fxg[154] = 0.0591000000; feg[154] = 0.0096000000;
					g[155] = 7.7500000000; fxg[155] = 0.0567000000; feg[155] = 0.0095000000;
					g[156] = 7.8000000000; fxg[156] = 0.0544000000; feg[156] = 0.0094000000;
					g[157] = 7.8500000000; fxg[157] = 0.0525000000; feg[157] = 0.0092000000;
					g[158] = 7.9000000000; fxg[158] = 0.0511000000; feg[158] = 0.0091000000;
					g[159] = 7.9500000000; fxg[159] = 0.0503000000; feg[159] = 0.0090000000;
					g[160] = 8.0000000000; fxg[160] = 0.0503000000; feg[160] = 0.0089000000;
					g[161] = 8.0500000000; fxg[161] = 0.0507000000; feg[161] = 0.0088000000;
					g[162] = 8.1000000000; fxg[162] = 0.0514000000; feg[162] = 0.0087000000;
					g[163] = 8.1500000000; fxg[163] = 0.0519000000; feg[163] = 0.0086000000;
					g[164] = 8.2000000000; fxg[164] = 0.0520000000; feg[164] = 0.0085000000;
					g[165] = 8.2500000000; fxg[165] = 0.0514000000; feg[165] = 0.0084000000;
					g[166] = 8.3000000000; fxg[166] = 0.0503000000; feg[166] = 0.0083000000;
					g[167] = 8.3500000000; fxg[167] = 0.0487000000; feg[167] = 0.0082000000;
					g[168] = 8.4000000000; fxg[168] = 0.0468000000; feg[168] = 0.0081000000;
					g[169] = 8.4500000000; fxg[169] = 0.0448000000; feg[169] = 0.0080000000;
					g[170] = 8.5000000000; fxg[170] = 0.0428000000; feg[170] = 0.0079000000;
					g[171] = 8.5500000000; fxg[171] = 0.0407000000; feg[171] = 0.0078000000;
					g[172] = 8.6000000000; fxg[172] = 0.0386000000; feg[172] = 0.0077000000;
					g[173] = 8.6500000000; fxg[173] = 0.0368000000; feg[173] = 0.0076000000;
					g[174] = 8.7000000000; fxg[174] = 0.0353000000; feg[174] = 0.0075000000;
					g[175] = 8.7500000000; fxg[175] = 0.0344000000; feg[175] = 0.0075000000;
					g[176] = 8.8000000000; fxg[176] = 0.0343000000; feg[176] = 0.0074000000;
					g[177] = 8.8500000000; fxg[177] = 0.0348000000; feg[177] = 0.0073000000;
					g[178] = 8.9000000000; fxg[178] = 0.0358000000; feg[178] = 0.0072000000;
					g[179] = 8.9500000000; fxg[179] = 0.0370000000; feg[179] = 0.0071000000;
					g[180] = 9.0000000000; fxg[180] = 0.0381000000; feg[180] = 0.0070000000;
					g[181] = 9.0500000000; fxg[181] = 0.0387000000; feg[181] = 0.0070000000;
					g[182] = 9.1000000000; fxg[182] = 0.0386000000; feg[182] = 0.0069000000;
					g[183] = 9.1500000000; fxg[183] = 0.0379000000; feg[183] = 0.0068000000;
					g[184] = 9.2000000000; fxg[184] = 0.0367000000; feg[184] = 0.0067000000;
					g[185] = 9.2500000000; fxg[185] = 0.0352000000; feg[185] = 0.0067000000;
					g[186] = 9.3000000000; fxg[186] = 0.0336000000; feg[186] = 0.0066000000;
					g[187] = 9.3500000000; fxg[187] = 0.0319000000; feg[187] = 0.0065000000;
					g[188] = 9.4000000000; fxg[188] = 0.0302000000; feg[188] = 0.0065000000;
					g[189] = 9.4500000000; fxg[189] = 0.0285000000; feg[189] = 0.0064000000;
					g[190] = 9.5000000000; fxg[190] = 0.0267000000; feg[190] = 0.0063000000;
					g[191] = 9.5500000000; fxg[191] = 0.0250000000; feg[191] = 0.0063000000;
					g[192] = 9.6000000000; fxg[192] = 0.0236000000; feg[192] = 0.0062000000;
					g[193] = 9.6500000000; fxg[193] = 0.0226000000; feg[193] = 0.0061000000;
					g[194] = 9.7000000000; fxg[194] = 0.0222000000; feg[194] = 0.0061000000;
					g[195] = 9.7500000000; fxg[195] = 0.0226000000; feg[195] = 0.0060000000;
					g[196] = 9.8000000000; fxg[196] = 0.0237000000; feg[196] = 0.0060000000;
					g[197] = 9.8500000000; fxg[197] = 0.0252000000; feg[197] = 0.0059000000;
					g[198] = 9.9000000000; fxg[198] = 0.0269000000; feg[198] = 0.0058000000;
					g[199] = 9.9500000000; fxg[199] = 0.0283000000; feg[199] = 0.0058000000;
					g[200] = 10.0000000000; fxg[200] = 0.0292000000; feg[200] = 0.0057000000;
					g[201] = 10.0500000000; fxg[201] = 0.0293000000; feg[201] = 0.0057000000;
					g[202] = 10.1000000000; fxg[202] = 0.0288000000; feg[202] = 0.0056000000;
					g[203] = 10.1500000000; fxg[203] = 0.0277000000; feg[203] = 0.0055000000;
					g[204] = 10.2000000000; fxg[204] = 0.0264000000; feg[204] = 0.0055000000;
					g[205] = 10.2500000000; fxg[205] = 0.0250000000; feg[205] = 0.0054000000;
					g[206] = 10.3000000000; fxg[206] = 0.0237000000; feg[206] = 0.0054000000;
					g[207] = 10.3500000000; fxg[207] = 0.0224000000; feg[207] = 0.0053000000;
					g[208] = 10.4000000000; fxg[208] = 0.0211000000; feg[208] = 0.0053000000;
					g[209] = 10.4500000000; fxg[209] = 0.0197000000; feg[209] = 0.0052000000;
					g[210] = 10.5000000000; fxg[210] = 0.0182000000; feg[210] = 0.0052000000;
					g[211] = 10.5500000000; fxg[211] = 0.0166000000; feg[211] = 0.0051000000;
					g[212] = 10.6000000000; fxg[212] = 0.0151000000; feg[212] = 0.0051000000;
					g[213] = 10.6500000000; fxg[213] = 0.0140000000; feg[213] = 0.0051000000;
					g[214] = 10.7000000000; fxg[214] = 0.0134000000; feg[214] = 0.0050000000;
					g[215] = 10.7500000000; fxg[215] = 0.0135000000; feg[215] = 0.0050000000;
					g[216] = 10.8000000000; fxg[216] = 0.0144000000; feg[216] = 0.0049000000;
					g[217] = 10.8500000000; fxg[217] = 0.0160000000; feg[217] = 0.0049000000;
					g[218] = 10.9000000000; fxg[218] = 0.0179000000; feg[218] = 0.0048000000;
					g[219] = 10.9500000000; fxg[219] = 0.0199000000; feg[219] = 0.0048000000;
					g[220] = 11.0000000000; fxg[220] = 0.0215000000; feg[220] = 0.0047000000;
					g[221] = 11.0500000000; fxg[221] = 0.0225000000; feg[221] = 0.0047000000;
					g[222] = 11.1000000000; fxg[222] = 0.0227000000; feg[222] = 0.0046000000;
					g[223] = 11.1500000000; fxg[223] = 0.0222000000; feg[223] = 0.0046000000;
					g[224] = 11.2000000000; fxg[224] = 0.0212000000; feg[224] = 0.0046000000;
					g[225] = 11.2500000000; fxg[225] = 0.0199000000; feg[225] = 0.0045000000;
					g[226] = 11.3000000000; fxg[226] = 0.0186000000; feg[226] = 0.0045000000;
					g[227] = 11.3500000000; fxg[227] = 0.0175000000; feg[227] = 0.0044000000;
					g[228] = 11.4000000000; fxg[228] = 0.0165000000; feg[228] = 0.0044000000;
					g[229] = 11.4500000000; fxg[229] = 0.0157000000; feg[229] = 0.0044000000;
					g[230] = 11.5000000000; fxg[230] = 0.0148000000; feg[230] = 0.0043000000;
					g[231] = 11.5500000000; fxg[231] = 0.0138000000; feg[231] = 0.0043000000;
					g[232] = 11.6000000000; fxg[232] = 0.0125000000; feg[232] = 0.0043000000;
					g[233] = 11.6500000000; fxg[233] = 0.0111000000; feg[233] = 0.0042000000;
					g[234] = 11.7000000000; fxg[234] = 0.0096000000; feg[234] = 0.0042000000;
					ng = 235;
					break;
				case 7:
					g[0] = 0.0000000000; fxg[0] = 7.0000000000; feg[0] = 2.2488000000;
					g[1] = 0.0500000000; fxg[1] = 6.9417000000; feg[1] = 2.2307000000;
					g[2] = 0.1000000000; fxg[2] = 6.7725000000; feg[2] = 2.1781000000;
					g[3] = 0.1500000000; fxg[3] = 6.5075000000; feg[3] = 2.0954000000;
					g[4] = 0.2000000000; fxg[4] = 6.1689000000; feg[4] = 1.9892000000;
					g[5] = 0.2500000000; fxg[5] = 5.7813000000; feg[5] = 1.8668000000;
					g[6] = 0.3000000000; fxg[6] = 5.3686000000; feg[6] = 1.7353000000;
					g[7] = 0.3500000000; fxg[7] = 4.9515000000; feg[7] = 1.6009000000;
					g[8] = 0.4000000000; fxg[8] = 4.5460000000; feg[8] = 1.4683000000;
					g[9] = 0.4500000000; fxg[9] = 4.1634000000; feg[9] = 1.3410000000;
					g[10] = 0.5000000000; fxg[10] = 3.8109000000; feg[10] = 1.2212000000;
					g[11] = 0.5500000000; fxg[11] = 3.4920000000; feg[11] = 1.1102000000;
					g[12] = 0.6000000000; fxg[12] = 3.2079000000; feg[12] = 1.0084000000;
					g[13] = 0.6500000000; fxg[13] = 2.9578000000; feg[13] = 0.9159000000;
					g[14] = 0.7000000000; fxg[14] = 2.7396000000; feg[14] = 0.8324000000;
					g[15] = 0.7500000000; fxg[15] = 2.5507000000; feg[15] = 0.7573000000;
					g[16] = 0.8000000000; fxg[16] = 2.3880000000; feg[16] = 0.6899000000;
					g[17] = 0.8500000000; fxg[17] = 2.2486000000; feg[17] = 0.6296000000;
					g[18] = 0.9000000000; fxg[18] = 2.1293000000; feg[18] = 0.5757000000;
					g[19] = 0.9500000000; fxg[19] = 2.0274000000; feg[19] = 0.5275000000;
					g[20] = 1.0000000000; fxg[20] = 1.9403000000; feg[20] = 0.4844000000;
					g[21] = 1.0500000000; fxg[21] = 1.8656000000; feg[21] = 0.4458000000;
					g[22] = 1.1000000000; fxg[22] = 1.8013000000; feg[22] = 0.4113000000;
					g[23] = 1.1500000000; fxg[23] = 1.7457000000; feg[23] = 0.3804000000;
					g[24] = 1.2000000000; fxg[24] = 1.6972000000; feg[24] = 0.3525000000;
					g[25] = 1.2500000000; fxg[25] = 1.6545000000; feg[25] = 0.3275000000;
					g[26] = 1.3000000000; fxg[26] = 1.6165000000; feg[26] = 0.3050000000;
					g[27] = 1.3500000000; fxg[27] = 1.5823000000; feg[27] = 0.2846000000;
					g[28] = 1.4000000000; fxg[28] = 1.5511000000; feg[28] = 0.2661000000;
					g[29] = 1.4500000000; fxg[29] = 1.5222000000; feg[29] = 0.2494000000;
					g[30] = 1.5000000000; fxg[30] = 1.4953000000; feg[30] = 0.2342000000;
					g[31] = 1.5500000000; fxg[31] = 1.4697000000; feg[31] = 0.2204000000;
					g[32] = 1.6000000000; fxg[32] = 1.4453000000; feg[32] = 0.2077000000;
					g[33] = 1.6500000000; fxg[33] = 1.4216000000; feg[33] = 0.1962000000;
					g[34] = 1.7000000000; fxg[34] = 1.3985000000; feg[34] = 0.1856000000;
					g[35] = 1.7500000000; fxg[35] = 1.3758000000; feg[35] = 0.1758000000;
					g[36] = 1.8000000000; fxg[36] = 1.3534000000; feg[36] = 0.1668000000;
					g[37] = 1.8500000000; fxg[37] = 1.3312000000; feg[37] = 0.1586000000;
					g[38] = 1.9000000000; fxg[38] = 1.3092000000; feg[38] = 0.1509000000;
					g[39] = 1.9500000000; fxg[39] = 1.2871000000; feg[39] = 0.1438000000;
					g[40] = 2.0000000000; fxg[40] = 1.2651000000; feg[40] = 0.1373000000;
					g[41] = 2.0500000000; fxg[41] = 1.2432000000; feg[41] = 0.1311000000;
					g[42] = 2.1000000000; fxg[42] = 1.2212000000; feg[42] = 0.1254000000;
					g[43] = 2.1500000000; fxg[43] = 1.1992000000; feg[43] = 0.1201000000;
					g[44] = 2.2000000000; fxg[44] = 1.1773000000; feg[44] = 0.1152000000;
					g[45] = 2.2500000000; fxg[45] = 1.1554000000; feg[45] = 0.1105000000;
					g[46] = 2.3000000000; fxg[46] = 1.1335000000; feg[46] = 0.1062000000;
					g[47] = 2.3500000000; fxg[47] = 1.1117000000; feg[47] = 0.1021000000;
					g[48] = 2.4000000000; fxg[48] = 1.0900000000; feg[48] = 0.0982000000;
					g[49] = 2.4500000000; fxg[49] = 1.0684000000; feg[49] = 0.0946000000;
					g[50] = 2.5000000000; fxg[50] = 1.0469000000; feg[50] = 0.0912000000;
					g[51] = 2.5500000000; fxg[51] = 1.0256000000; feg[51] = 0.0880000000;
					g[52] = 2.6000000000; fxg[52] = 1.0044000000; feg[52] = 0.0849000000;
					g[53] = 2.6500000000; fxg[53] = 0.9834000000; feg[53] = 0.0820000000;
					g[54] = 2.7000000000; fxg[54] = 0.9626000000; feg[54] = 0.0793000000;
					g[55] = 2.7500000000; fxg[55] = 0.9421000000; feg[55] = 0.0767000000;
					g[56] = 2.8000000000; fxg[56] = 0.9217000000; feg[56] = 0.0742000000;
					g[57] = 2.8500000000; fxg[57] = 0.9016000000; feg[57] = 0.0719000000;
					g[58] = 2.9000000000; fxg[58] = 0.8818000000; feg[58] = 0.0696000000;
					g[59] = 2.9500000000; fxg[59] = 0.8623000000; feg[59] = 0.0675000000;
					g[60] = 3.0000000000; fxg[60] = 0.8430000000; feg[60] = 0.0655000000;
					g[61] = 3.0500000000; fxg[61] = 0.8241000000; feg[61] = 0.0636000000;
					g[62] = 3.1000000000; fxg[62] = 0.8054000000; feg[62] = 0.0617000000;
					g[63] = 3.1500000000; fxg[63] = 0.7870000000; feg[63] = 0.0599000000;
					g[64] = 3.2000000000; fxg[64] = 0.7690000000; feg[64] = 0.0583000000;
					g[65] = 3.2500000000; fxg[65] = 0.7513000000; feg[65] = 0.0566000000;
					g[66] = 3.3000000000; fxg[66] = 0.7340000000; feg[66] = 0.0551000000;
					g[67] = 3.3500000000; fxg[67] = 0.7169000000; feg[67] = 0.0536000000;
					g[68] = 3.4000000000; fxg[68] = 0.7002000000; feg[68] = 0.0522000000;
					g[69] = 3.4500000000; fxg[69] = 0.6837000000; feg[69] = 0.0508000000;
					g[70] = 3.5000000000; fxg[70] = 0.6676000000; feg[70] = 0.0495000000;
					g[71] = 3.5500000000; fxg[71] = 0.6519000000; feg[71] = 0.0482000000;
					g[72] = 3.6000000000; fxg[72] = 0.6366000000; feg[72] = 0.0470000000;
					g[73] = 3.6500000000; fxg[73] = 0.6215000000; feg[73] = 0.0458000000;
					g[74] = 3.7000000000; fxg[74] = 0.6068000000; feg[74] = 0.0447000000;
					g[75] = 3.7500000000; fxg[75] = 0.5924000000; feg[75] = 0.0436000000;
					g[76] = 3.8000000000; fxg[76] = 0.5782000000; feg[76] = 0.0426000000;
					g[77] = 3.8500000000; fxg[77] = 0.5643000000; feg[77] = 0.0416000000;
					g[78] = 3.9000000000; fxg[78] = 0.5508000000; feg[78] = 0.0406000000;
					g[79] = 3.9500000000; fxg[79] = 0.5377000000; feg[79] = 0.0397000000;
					g[80] = 4.0000000000; fxg[80] = 0.5250000000; feg[80] = 0.0387000000;
					g[81] = 4.0500000000; fxg[81] = 0.5125000000; feg[81] = 0.0379000000;
					g[82] = 4.1000000000; fxg[82] = 0.5003000000; feg[82] = 0.0370000000;
					g[83] = 4.1500000000; fxg[83] = 0.4882000000; feg[83] = 0.0362000000;
					g[84] = 4.2000000000; fxg[84] = 0.4764000000; feg[84] = 0.0354000000;
					g[85] = 4.2500000000; fxg[85] = 0.4649000000; feg[85] = 0.0346000000;
					g[86] = 4.3000000000; fxg[86] = 0.4537000000; feg[86] = 0.0339000000;
					g[87] = 4.3500000000; fxg[87] = 0.4429000000; feg[87] = 0.0332000000;
					g[88] = 4.4000000000; fxg[88] = 0.4325000000; feg[88] = 0.0325000000;
					g[89] = 4.4500000000; fxg[89] = 0.4224000000; feg[89] = 0.0318000000;
					g[90] = 4.5000000000; fxg[90] = 0.4124000000; feg[90] = 0.0311000000;
					g[91] = 4.5500000000; fxg[91] = 0.4026000000; feg[91] = 0.0305000000;
					g[92] = 4.6000000000; fxg[92] = 0.3929000000; feg[92] = 0.0299000000;
					g[93] = 4.6500000000; fxg[93] = 0.3834000000; feg[93] = 0.0293000000;
					g[94] = 4.7000000000; fxg[94] = 0.3740000000; feg[94] = 0.0287000000;
					g[95] = 4.7500000000; fxg[95] = 0.3651000000; feg[95] = 0.0282000000;
					g[96] = 4.8000000000; fxg[96] = 0.3565000000; feg[96] = 0.0276000000;
					g[97] = 4.8500000000; fxg[97] = 0.3483000000; feg[97] = 0.0271000000;
					g[98] = 4.9000000000; fxg[98] = 0.3404000000; feg[98] = 0.0266000000;
					g[99] = 4.9500000000; fxg[99] = 0.3326000000; feg[99] = 0.0261000000;
					g[100] = 5.0000000000; fxg[100] = 0.3250000000; feg[100] = 0.0256000000;
					g[101] = 5.0500000000; fxg[101] = 0.3173000000; feg[101] = 0.0251000000;
					g[102] = 5.1000000000; fxg[102] = 0.3096000000; feg[102] = 0.0246000000;
					g[103] = 5.1500000000; fxg[103] = 0.3021000000; feg[103] = 0.0242000000;
					g[104] = 5.2000000000; fxg[104] = 0.2947000000; feg[104] = 0.0237000000;
					g[105] = 5.2500000000; fxg[105] = 0.2876000000; feg[105] = 0.0233000000;
					g[106] = 5.3000000000; fxg[106] = 0.2810000000; feg[106] = 0.0229000000;
					g[107] = 5.3500000000; fxg[107] = 0.2748000000; feg[107] = 0.0225000000;
					g[108] = 5.4000000000; fxg[108] = 0.2689000000; feg[108] = 0.0221000000;
					g[109] = 5.4500000000; fxg[109] = 0.2631000000; feg[109] = 0.0217000000;
					g[110] = 5.5000000000; fxg[110] = 0.2574000000; feg[110] = 0.0213000000;
					g[111] = 5.5500000000; fxg[111] = 0.2516000000; feg[111] = 0.0210000000;
					g[112] = 5.6000000000; fxg[112] = 0.2457000000; feg[112] = 0.0206000000;
					g[113] = 5.6500000000; fxg[113] = 0.2397000000; feg[113] = 0.0203000000;
					g[114] = 5.7000000000; fxg[114] = 0.2338000000; feg[114] = 0.0199000000;
					g[115] = 5.7500000000; fxg[115] = 0.2280000000; feg[115] = 0.0196000000;
					g[116] = 5.8000000000; fxg[116] = 0.2226000000; feg[116] = 0.0193000000;
					g[117] = 5.8500000000; fxg[117] = 0.2175000000; feg[117] = 0.0190000000;
					g[118] = 5.9000000000; fxg[118] = 0.2130000000; feg[118] = 0.0187000000;
					g[119] = 5.9500000000; fxg[119] = 0.2087000000; feg[119] = 0.0184000000;
					g[120] = 6.0000000000; fxg[120] = 0.2047000000; feg[120] = 0.0181000000;
					g[121] = 6.0500000000; fxg[121] = 0.2008000000; feg[121] = 0.0178000000;
					g[122] = 6.1000000000; fxg[122] = 0.1967000000; feg[122] = 0.0175000000;
					g[123] = 6.1500000000; fxg[123] = 0.1923000000; feg[123] = 0.0172000000;
					g[124] = 6.2000000000; fxg[124] = 0.1878000000; feg[124] = 0.0170000000;
					g[125] = 6.2500000000; fxg[125] = 0.1831000000; feg[125] = 0.0167000000;
					g[126] = 6.3000000000; fxg[126] = 0.1784000000; feg[126] = 0.0165000000;
					g[127] = 6.3500000000; fxg[127] = 0.1739000000; feg[127] = 0.0162000000;
					g[128] = 6.4000000000; fxg[128] = 0.1696000000; feg[128] = 0.0160000000;
					g[129] = 6.4500000000; fxg[129] = 0.1658000000; feg[129] = 0.0157000000;
					g[130] = 6.5000000000; fxg[130] = 0.1624000000; feg[130] = 0.0155000000;
					g[131] = 6.5500000000; fxg[131] = 0.1595000000; feg[131] = 0.0153000000;
					g[132] = 6.6000000000; fxg[132] = 0.1569000000; feg[132] = 0.0150000000;
					g[133] = 6.6500000000; fxg[133] = 0.1544000000; feg[133] = 0.0148000000;
					g[134] = 6.7000000000; fxg[134] = 0.1518000000; feg[134] = 0.0146000000;
					g[135] = 6.7500000000; fxg[135] = 0.1490000000; feg[135] = 0.0144000000;
					g[136] = 6.8000000000; fxg[136] = 0.1458000000; feg[136] = 0.0142000000;
					g[137] = 6.8500000000; fxg[137] = 0.1423000000; feg[137] = 0.0140000000;
					g[138] = 6.9000000000; fxg[138] = 0.1387000000; feg[138] = 0.0138000000;
					g[139] = 6.9500000000; fxg[139] = 0.1349000000; feg[139] = 0.0136000000;
					g[140] = 7.0000000000; fxg[140] = 0.1312000000; feg[140] = 0.0134000000;
					g[141] = 7.0500000000; fxg[141] = 0.1277000000; feg[141] = 0.0132000000;
					g[142] = 7.1000000000; fxg[142] = 0.1246000000; feg[142] = 0.0131000000;
					g[143] = 7.1500000000; fxg[143] = 0.1220000000; feg[143] = 0.0129000000;
					g[144] = 7.2000000000; fxg[144] = 0.1199000000; feg[144] = 0.0127000000;
					g[145] = 7.2500000000; fxg[145] = 0.1182000000; feg[145] = 0.0125000000;
					g[146] = 7.3000000000; fxg[146] = 0.1168000000; feg[146] = 0.0124000000;
					g[147] = 7.3500000000; fxg[147] = 0.1156000000; feg[147] = 0.0122000000;
					g[148] = 7.4000000000; fxg[148] = 0.1141000000; feg[148] = 0.0120000000;
					g[149] = 7.4500000000; fxg[149] = 0.1124000000; feg[149] = 0.0119000000;
					g[150] = 7.5000000000; fxg[150] = 0.1102000000; feg[150] = 0.0117000000;
					g[151] = 7.5500000000; fxg[151] = 0.1077000000; feg[151] = 0.0116000000;
					g[152] = 7.6000000000; fxg[152] = 0.1049000000; feg[152] = 0.0114000000;
					g[153] = 7.6500000000; fxg[153] = 0.1018000000; feg[153] = 0.0113000000;
					g[154] = 7.7000000000; fxg[154] = 0.0988000000; feg[154] = 0.0111000000;
					g[155] = 7.7500000000; fxg[155] = 0.0958000000; feg[155] = 0.0110000000;
					g[156] = 7.8000000000; fxg[156] = 0.0930000000; feg[156] = 0.0109000000;
					g[157] = 7.8500000000; fxg[157] = 0.0906000000; feg[157] = 0.0107000000;
					g[158] = 7.9000000000; fxg[158] = 0.0887000000; feg[158] = 0.0106000000;
					g[159] = 7.9500000000; fxg[159] = 0.0873000000; feg[159] = 0.0105000000;
					g[160] = 8.0000000000; fxg[160] = 0.0865000000; feg[160] = 0.0103000000;
					g[161] = 8.0500000000; fxg[161] = 0.0860000000; feg[161] = 0.0102000000;
					g[162] = 8.1000000000; fxg[162] = 0.0857000000; feg[162] = 0.0101000000;
					g[163] = 8.1500000000; fxg[163] = 0.0853000000; feg[163] = 0.0100000000;
					g[164] = 8.2000000000; fxg[164] = 0.0846000000; feg[164] = 0.0098000000;
					g[165] = 8.2500000000; fxg[165] = 0.0835000000; feg[165] = 0.0097000000;
					g[166] = 8.3000000000; fxg[166] = 0.0819000000; feg[166] = 0.0096000000;
					g[167] = 8.3500000000; fxg[167] = 0.0799000000; feg[167] = 0.0095000000;
					g[168] = 8.4000000000; fxg[168] = 0.0775000000; feg[168] = 0.0094000000;
					g[169] = 8.4500000000; fxg[169] = 0.0751000000; feg[169] = 0.0093000000;
					g[170] = 8.5000000000; fxg[170] = 0.0725000000; feg[170] = 0.0092000000;
					g[171] = 8.5500000000; fxg[171] = 0.0700000000; feg[171] = 0.0091000000;
					g[172] = 8.6000000000; fxg[172] = 0.0675000000; feg[172] = 0.0090000000;
					g[173] = 8.6500000000; fxg[173] = 0.0654000000; feg[173] = 0.0089000000;
					g[174] = 8.7000000000; fxg[174] = 0.0637000000; feg[174] = 0.0088000000;
					g[175] = 8.7500000000; fxg[175] = 0.0625000000; feg[175] = 0.0087000000;
					g[176] = 8.8000000000; fxg[176] = 0.0619000000; feg[176] = 0.0086000000;
					g[177] = 8.8500000000; fxg[177] = 0.0618000000; feg[177] = 0.0085000000;
					g[178] = 8.9000000000; fxg[178] = 0.0621000000; feg[178] = 0.0084000000;
					g[179] = 8.9500000000; fxg[179] = 0.0626000000; feg[179] = 0.0083000000;
					g[180] = 9.0000000000; fxg[180] = 0.0630000000; feg[180] = 0.0082000000;
					g[181] = 9.0500000000; fxg[181] = 0.0630000000; feg[181] = 0.0081000000;
					g[182] = 9.1000000000; fxg[182] = 0.0626000000; feg[182] = 0.0080000000;
					g[183] = 9.1500000000; fxg[183] = 0.0616000000; feg[183] = 0.0079000000;
					g[184] = 9.2000000000; fxg[184] = 0.0601000000; feg[184] = 0.0078000000;
					g[185] = 9.2500000000; fxg[185] = 0.0583000000; feg[185] = 0.0078000000;
					g[186] = 9.3000000000; fxg[186] = 0.0563000000; feg[186] = 0.0077000000;
					g[187] = 9.3500000000; fxg[187] = 0.0542000000; feg[187] = 0.0076000000;
					g[188] = 9.4000000000; fxg[188] = 0.0520000000; feg[188] = 0.0075000000;
					g[189] = 9.4500000000; fxg[189] = 0.0499000000; feg[189] = 0.0075000000;
					g[190] = 9.5000000000; fxg[190] = 0.0478000000; feg[190] = 0.0074000000;
					g[191] = 9.5500000000; fxg[191] = 0.0459000000; feg[191] = 0.0073000000;
					g[192] = 9.6000000000; fxg[192] = 0.0443000000; feg[192] = 0.0072000000;
					g[193] = 9.6500000000; fxg[193] = 0.0432000000; feg[193] = 0.0072000000;
					g[194] = 9.7000000000; fxg[194] = 0.0427000000; feg[194] = 0.0071000000;
					g[195] = 9.7500000000; fxg[195] = 0.0428000000; feg[195] = 0.0070000000;
					g[196] = 9.8000000000; fxg[196] = 0.0434000000; feg[196] = 0.0069000000;
					g[197] = 9.8500000000; fxg[197] = 0.0445000000; feg[197] = 0.0069000000;
					g[198] = 9.9000000000; fxg[198] = 0.0456000000; feg[198] = 0.0068000000;
					g[199] = 9.9500000000; fxg[199] = 0.0465000000; feg[199] = 0.0067000000;
					g[200] = 10.0000000000; fxg[200] = 0.0470000000; feg[200] = 0.0067000000;
					g[201] = 10.0500000000; fxg[201] = 0.0469000000; feg[201] = 0.0066000000;
					g[202] = 10.1000000000; fxg[202] = 0.0463000000; feg[202] = 0.0065000000;
					g[203] = 10.1500000000; fxg[203] = 0.0452000000; feg[203] = 0.0065000000;
					g[204] = 10.2000000000; fxg[204] = 0.0437000000; feg[204] = 0.0064000000;
					g[205] = 10.2500000000; fxg[205] = 0.0421000000; feg[205] = 0.0063000000;
					g[206] = 10.3000000000; fxg[206] = 0.0403000000; feg[206] = 0.0063000000;
					g[207] = 10.3500000000; fxg[207] = 0.0385000000; feg[207] = 0.0062000000;
					g[208] = 10.4000000000; fxg[208] = 0.0367000000; feg[208] = 0.0062000000;
					g[209] = 10.4500000000; fxg[209] = 0.0349000000; feg[209] = 0.0061000000;
					g[210] = 10.5000000000; fxg[210] = 0.0331000000; feg[210] = 0.0060000000;
					g[211] = 10.5500000000; fxg[211] = 0.0313000000; feg[211] = 0.0060000000;
					g[212] = 10.6000000000; fxg[212] = 0.0298000000; feg[212] = 0.0059000000;
					g[213] = 10.6500000000; fxg[213] = 0.0287000000; feg[213] = 0.0059000000;
					g[214] = 10.7000000000; fxg[214] = 0.0282000000; feg[214] = 0.0058000000;
					g[215] = 10.7500000000; fxg[215] = 0.0282000000; feg[215] = 0.0058000000;
					g[216] = 10.8000000000; fxg[216] = 0.0289000000; feg[216] = 0.0057000000;
					g[217] = 10.8500000000; fxg[217] = 0.0302000000; feg[217] = 0.0057000000;
					g[218] = 10.9000000000; fxg[218] = 0.0317000000; feg[218] = 0.0056000000;
					g[219] = 10.9500000000; fxg[219] = 0.0333000000; feg[219] = 0.0056000000;
					g[220] = 11.0000000000; fxg[220] = 0.0346000000; feg[220] = 0.0055000000;
					g[221] = 11.0500000000; fxg[221] = 0.0354000000; feg[221] = 0.0055000000;
					g[222] = 11.1000000000; fxg[222] = 0.0356000000; feg[222] = 0.0054000000;
					g[223] = 11.1500000000; fxg[223] = 0.0352000000; feg[223] = 0.0054000000;
					g[224] = 11.2000000000; fxg[224] = 0.0343000000; feg[224] = 0.0053000000;
					g[225] = 11.2500000000; fxg[225] = 0.0330000000; feg[225] = 0.0053000000;
					g[226] = 11.3000000000; fxg[226] = 0.0316000000; feg[226] = 0.0052000000;
					g[227] = 11.3500000000; fxg[227] = 0.0301000000; feg[227] = 0.0052000000;
					g[228] = 11.4000000000; fxg[228] = 0.0287000000; feg[228] = 0.0051000000;
					g[229] = 11.4500000000; fxg[229] = 0.0272000000; feg[229] = 0.0051000000;
					g[230] = 11.5000000000; fxg[230] = 0.0258000000; feg[230] = 0.0050000000;
					g[231] = 11.5500000000; fxg[231] = 0.0242000000; feg[231] = 0.0050000000;
					g[232] = 11.6000000000; fxg[232] = 0.0226000000; feg[232] = 0.0050000000;
					g[233] = 11.6500000000; fxg[233] = 0.0210000000; feg[233] = 0.0049000000;
					g[234] = 11.7000000000; fxg[234] = 0.0195000000; feg[234] = 0.0049000000;
					g[235] = 11.7500000000; fxg[235] = 0.0183000000; feg[235] = 0.0048000000;
					g[236] = 11.8000000000; fxg[236] = 0.0175000000; feg[236] = 0.0048000000;
					g[237] = 11.8500000000; fxg[237] = 0.0173000000; feg[237] = 0.0048000000;
					g[238] = 11.9000000000; fxg[238] = 0.0177000000; feg[238] = 0.0047000000;
					g[239] = 11.9500000000; fxg[239] = 0.0188000000; feg[239] = 0.0047000000;
					g[240] = 12.0000000000; fxg[240] = 0.0205000000; feg[240] = 0.0046000000;
					break;
				case 8:
					g[0] = 0.0000000000; fxg[0] = 8.0000000000; feg[0] = 2.0291000000;
					g[1] = 0.0500000000; fxg[1] = 7.9473000000; feg[1] = 2.0163000000;
					g[2] = 0.1000000000; fxg[2] = 7.7933000000; feg[2] = 1.9788000000;
					g[3] = 0.1500000000; fxg[3] = 7.5489000000; feg[3] = 1.9193000000;
					g[4] = 0.2000000000; fxg[4] = 7.2305000000; feg[4] = 1.8416000000;
					g[5] = 0.2500000000; fxg[5] = 6.8573000000; feg[5] = 1.7503000000;
					g[6] = 0.3000000000; fxg[6] = 6.4490000000; feg[6] = 1.6498000000;
					g[7] = 0.3500000000; fxg[7] = 6.0235000000; feg[7] = 1.5446000000;
					g[8] = 0.4000000000; fxg[8] = 5.5964000000; feg[8] = 1.4382000000;
					g[9] = 0.4500000000; fxg[9] = 5.1798000000; feg[9] = 1.3333000000;
					g[10] = 0.5000000000; fxg[10] = 4.7825000000; feg[10] = 1.2321000000;
					g[11] = 0.5500000000; fxg[11] = 4.4105000000; feg[11] = 1.1360000000;
					g[12] = 0.6000000000; fxg[12] = 4.0674000000; feg[12] = 1.0458000000;
					g[13] = 0.6500000000; fxg[13] = 3.7546000000; feg[13] = 0.9620000000;
					g[14] = 0.7000000000; fxg[14] = 3.4722000000; feg[14] = 0.8846000000;
					g[15] = 0.7500000000; fxg[15] = 3.2195000000; feg[15] = 0.8136000000;
					g[16] = 0.8000000000; fxg[16] = 2.9947000000; feg[16] = 0.7487000000;
					g[17] = 0.8500000000; fxg[17] = 2.7959000000; feg[17] = 0.6896000000;
					g[18] = 0.9000000000; fxg[18] = 2.6208000000; feg[18] = 0.6358000000;
					g[19] = 0.9500000000; fxg[19] = 2.4672000000; feg[19] = 0.5869000000;
					g[20] = 1.0000000000; fxg[20] = 2.3327000000; feg[20] = 0.5426000000;
					g[21] = 1.0500000000; fxg[21] = 2.2151000000; feg[21] = 0.5023000000;
					g[22] = 1.1000000000; fxg[22] = 2.1123000000; feg[22] = 0.4658000000;
					g[23] = 1.1500000000; fxg[23] = 2.0226000000; feg[23] = 0.4327000000;
					g[24] = 1.2000000000; fxg[24] = 1.9441000000; feg[24] = 0.4026000000;
					g[25] = 1.2500000000; fxg[25] = 1.8753000000; feg[25] = 0.3753000000;
					g[26] = 1.3000000000; fxg[26] = 1.8149000000; feg[26] = 0.3504000000;
					g[27] = 1.3500000000; fxg[27] = 1.7616000000; feg[27] = 0.3277000000;
					g[28] = 1.4000000000; fxg[28] = 1.7143000000; feg[28] = 0.3070000000;
					g[29] = 1.4500000000; fxg[29] = 1.6721000000; feg[29] = 0.2881000000;
					g[30] = 1.5000000000; fxg[30] = 1.6342000000; feg[30] = 0.2709000000;
					g[31] = 1.5500000000; fxg[31] = 1.5999000000; feg[31] = 0.2550000000;
					g[32] = 1.6000000000; fxg[32] = 1.5685000000; feg[32] = 0.2405000000;
					g[33] = 1.6500000000; fxg[33] = 1.5397000000; feg[33] = 0.2272000000;
					g[34] = 1.7000000000; fxg[34] = 1.5129000000; feg[34] = 0.2149000000;
					g[35] = 1.7500000000; fxg[35] = 1.4877000000; feg[35] = 0.2036000000;
					g[36] = 1.8000000000; fxg[36] = 1.4639000000; feg[36] = 0.1931000000;
					g[37] = 1.8500000000; fxg[37] = 1.4412000000; feg[37] = 0.1835000000;
					g[38] = 1.9000000000; fxg[38] = 1.4193000000; feg[38] = 0.1745000000;
					g[39] = 1.9500000000; fxg[39] = 1.3981000000; feg[39] = 0.1662000000;
					g[40] = 2.0000000000; fxg[40] = 1.3775000000; feg[40] = 0.1585000000;
					g[41] = 2.0500000000; fxg[41] = 1.3573000000; feg[41] = 0.1513000000;
					g[42] = 2.1000000000; fxg[42] = 1.3374000000; feg[42] = 0.1446000000;
					g[43] = 2.1500000000; fxg[43] = 1.3178000000; feg[43] = 0.1384000000;
					g[44] = 2.2000000000; fxg[44] = 1.2983000000; feg[44] = 0.1326000000;
					g[45] = 2.2500000000; fxg[45] = 1.2790000000; feg[45] = 0.1271000000;
					g[46] = 2.3000000000; fxg[46] = 1.2598000000; feg[46] = 0.1220000000;
					g[47] = 2.3500000000; fxg[47] = 1.2407000000; feg[47] = 0.1172000000;
					g[48] = 2.4000000000; fxg[48] = 1.2216000000; feg[48] = 0.1127000000;
					g[49] = 2.4500000000; fxg[49] = 1.2026000000; feg[49] = 0.1084000000;
					g[50] = 2.5000000000; fxg[50] = 1.1836000000; feg[50] = 0.1044000000;
					g[51] = 2.5500000000; fxg[51] = 1.1647000000; feg[51] = 0.1006000000;
					g[52] = 2.6000000000; fxg[52] = 1.1458000000; feg[52] = 0.0971000000;
					g[53] = 2.6500000000; fxg[53] = 1.1269000000; feg[53] = 0.0937000000;
					g[54] = 2.7000000000; fxg[54] = 1.1082000000; feg[54] = 0.0905000000;
					g[55] = 2.7500000000; fxg[55] = 1.0895000000; feg[55] = 0.0875000000;
					g[56] = 2.8000000000; fxg[56] = 1.0708000000; feg[56] = 0.0846000000;
					g[57] = 2.8500000000; fxg[57] = 1.0523000000; feg[57] = 0.0819000000;
					g[58] = 2.9000000000; fxg[58] = 1.0339000000; feg[58] = 0.0793000000;
					g[59] = 2.9500000000; fxg[59] = 1.0156000000; feg[59] = 0.0768000000;
					g[60] = 3.0000000000; fxg[60] = 0.9974000000; feg[60] = 0.0745000000;
					g[61] = 3.0500000000; fxg[61] = 0.9794000000; feg[61] = 0.0723000000;
					g[62] = 3.1000000000; fxg[62] = 0.9615000000; feg[62] = 0.0701000000;
					g[63] = 3.1500000000; fxg[63] = 0.9437000000; feg[63] = 0.0681000000;
					g[64] = 3.2000000000; fxg[64] = 0.9262000000; feg[64] = 0.0661000000;
					g[65] = 3.2500000000; fxg[65] = 0.9088000000; feg[65] = 0.0643000000;
					g[66] = 3.3000000000; fxg[66] = 0.8916000000; feg[66] = 0.0625000000;
					g[67] = 3.3500000000; fxg[67] = 0.8746000000; feg[67] = 0.0608000000;
					g[68] = 3.4000000000; fxg[68] = 0.8578000000; feg[68] = 0.0591000000;
					g[69] = 3.4500000000; fxg[69] = 0.8411000000; feg[69] = 0.0576000000;
					g[70] = 3.5000000000; fxg[70] = 0.8248000000; feg[70] = 0.0561000000;
					g[71] = 3.5500000000; fxg[71] = 0.8086000000; feg[71] = 0.0546000000;
					g[72] = 3.6000000000; fxg[72] = 0.7927000000; feg[72] = 0.0532000000;
					g[73] = 3.6500000000; fxg[73] = 0.7770000000; feg[73] = 0.0519000000;
					g[74] = 3.7000000000; fxg[74] = 0.7616000000; feg[74] = 0.0506000000;
					g[75] = 3.7500000000; fxg[75] = 0.7463000000; feg[75] = 0.0494000000;
					g[76] = 3.8000000000; fxg[76] = 0.7313000000; feg[76] = 0.0482000000;
					g[77] = 3.8500000000; fxg[77] = 0.7165000000; feg[77] = 0.0470000000;
					g[78] = 3.9000000000; fxg[78] = 0.7020000000; feg[78] = 0.0459000000;
					g[79] = 3.9500000000; fxg[79] = 0.6878000000; feg[79] = 0.0449000000;
					g[80] = 4.0000000000; fxg[80] = 0.6738000000; feg[80] = 0.0438000000;
					g[81] = 4.0500000000; fxg[81] = 0.6601000000; feg[81] = 0.0428000000;
					g[82] = 4.1000000000; fxg[82] = 0.6466000000; feg[82] = 0.0419000000;
					g[83] = 4.1500000000; fxg[83] = 0.6333000000; feg[83] = 0.0409000000;
					g[84] = 4.2000000000; fxg[84] = 0.6202000000; feg[84] = 0.0401000000;
					g[85] = 4.2500000000; fxg[85] = 0.6073000000; feg[85] = 0.0392000000;
					g[86] = 4.3000000000; fxg[86] = 0.5947000000; feg[86] = 0.0383000000;
					g[87] = 4.3500000000; fxg[87] = 0.5825000000; feg[87] = 0.0375000000;
					g[88] = 4.4000000000; fxg[88] = 0.5705000000; feg[88] = 0.0367000000;
					g[89] = 4.4500000000; fxg[89] = 0.5587000000; feg[89] = 0.0360000000;
					g[90] = 4.5000000000; fxg[90] = 0.5472000000; feg[90] = 0.0352000000;
					g[91] = 4.5500000000; fxg[91] = 0.5358000000; feg[91] = 0.0345000000;
					g[92] = 4.6000000000; fxg[92] = 0.5246000000; feg[92] = 0.0338000000;
					g[93] = 4.6500000000; fxg[93] = 0.5135000000; feg[93] = 0.0331000000;
					g[94] = 4.7000000000; fxg[94] = 0.5027000000; feg[94] = 0.0325000000;
					g[95] = 4.7500000000; fxg[95] = 0.4922000000; feg[95] = 0.0319000000;
					g[96] = 4.8000000000; fxg[96] = 0.4820000000; feg[96] = 0.0312000000;
					g[97] = 4.8500000000; fxg[97] = 0.4721000000; feg[97] = 0.0306000000;
					g[98] = 4.9000000000; fxg[98] = 0.4624000000; feg[98] = 0.0301000000;
					g[99] = 4.9500000000; fxg[99] = 0.4529000000; feg[99] = 0.0295000000;
					g[100] = 5.0000000000; fxg[100] = 0.4436000000; feg[100] = 0.0289000000;
					g[101] = 5.0500000000; fxg[101] = 0.4343000000; feg[101] = 0.0284000000;
					g[102] = 5.1000000000; fxg[102] = 0.4251000000; feg[102] = 0.0279000000;
					g[103] = 5.1500000000; fxg[103] = 0.4161000000; feg[103] = 0.0274000000;
					g[104] = 5.2000000000; fxg[104] = 0.4072000000; feg[104] = 0.0269000000;
					g[105] = 5.2500000000; fxg[105] = 0.3987000000; feg[105] = 0.0264000000;
					g[106] = 5.3000000000; fxg[106] = 0.3905000000; feg[106] = 0.0259000000;
					g[107] = 5.3500000000; fxg[107] = 0.3826000000; feg[107] = 0.0255000000;
					g[108] = 5.4000000000; fxg[108] = 0.3749000000; feg[108] = 0.0250000000;
					g[109] = 5.4500000000; fxg[109] = 0.3674000000; feg[109] = 0.0246000000;
					g[110] = 5.5000000000; fxg[110] = 0.3601000000; feg[110] = 0.0242000000;
					g[111] = 5.5500000000; fxg[111] = 0.3527000000; feg[111] = 0.0238000000;
					g[112] = 5.6000000000; fxg[112] = 0.3453000000; feg[112] = 0.0234000000;
					g[113] = 5.6500000000; fxg[113] = 0.3380000000; feg[113] = 0.0230000000;
					g[114] = 5.7000000000; fxg[114] = 0.3307000000; feg[114] = 0.0226000000;
					g[115] = 5.7500000000; fxg[115] = 0.3236000000; feg[115] = 0.0222000000;
					g[116] = 5.8000000000; fxg[116] = 0.3168000000; feg[116] = 0.0219000000;
					g[117] = 5.8500000000; fxg[117] = 0.3104000000; feg[117] = 0.0215000000;
					g[118] = 5.9000000000; fxg[118] = 0.3043000000; feg[118] = 0.0212000000;
					g[119] = 5.9500000000; fxg[119] = 0.2985000000; feg[119] = 0.0208000000;
					g[120] = 6.0000000000; fxg[120] = 0.2928000000; feg[120] = 0.0205000000;
					g[121] = 6.0500000000; fxg[121] = 0.2873000000; feg[121] = 0.0202000000;
					g[122] = 6.1000000000; fxg[122] = 0.2817000000; feg[122] = 0.0199000000;
					g[123] = 6.1500000000; fxg[123] = 0.2760000000; feg[123] = 0.0196000000;
					g[124] = 6.2000000000; fxg[124] = 0.2702000000; feg[124] = 0.0193000000;
					g[125] = 6.2500000000; fxg[125] = 0.2644000000; feg[125] = 0.0190000000;
					g[126] = 6.3000000000; fxg[126] = 0.2586000000; feg[126] = 0.0187000000;
					g[127] = 6.3500000000; fxg[127] = 0.2530000000; feg[127] = 0.0184000000;
					g[128] = 6.4000000000; fxg[128] = 0.2477000000; feg[128] = 0.0181000000;
					g[129] = 6.4500000000; fxg[129] = 0.2427000000; feg[129] = 0.0179000000;
					g[130] = 6.5000000000; fxg[130] = 0.2380000000; feg[130] = 0.0176000000;
					g[131] = 6.5500000000; fxg[131] = 0.2337000000; feg[131] = 0.0173000000;
					g[132] = 6.6000000000; fxg[132] = 0.2297000000; feg[132] = 0.0171000000;
					g[133] = 6.6500000000; fxg[133] = 0.2258000000; feg[133] = 0.0168000000;
					g[134] = 6.7000000000; fxg[134] = 0.2218000000; feg[134] = 0.0166000000;
					g[135] = 6.7500000000; fxg[135] = 0.2177000000; feg[135] = 0.0164000000;
					g[136] = 6.8000000000; fxg[136] = 0.2135000000; feg[136] = 0.0161000000;
					g[137] = 6.8500000000; fxg[137] = 0.2090000000; feg[137] = 0.0159000000;
					g[138] = 6.9000000000; fxg[138] = 0.2044000000; feg[138] = 0.0157000000;
					g[139] = 6.9500000000; fxg[139] = 0.1998000000; feg[139] = 0.0155000000;
					g[140] = 7.0000000000; fxg[140] = 0.1953000000; feg[140] = 0.0152000000;
					g[141] = 7.0500000000; fxg[141] = 0.1910000000; feg[141] = 0.0150000000;
					g[142] = 7.1000000000; fxg[142] = 0.1870000000; feg[142] = 0.0148000000;
					g[143] = 7.1500000000; fxg[143] = 0.1834000000; feg[143] = 0.0146000000;
					g[144] = 7.2000000000; fxg[144] = 0.1803000000; feg[144] = 0.0144000000;
					g[145] = 7.2500000000; fxg[145] = 0.1774000000; feg[145] = 0.0142000000;
					g[146] = 7.3000000000; fxg[146] = 0.1749000000; feg[146] = 0.0141000000;
					g[147] = 7.3500000000; fxg[147] = 0.1724000000; feg[147] = 0.0139000000;
					g[148] = 7.4000000000; fxg[148] = 0.1698000000; feg[148] = 0.0137000000;
					g[149] = 7.4500000000; fxg[149] = 0.1670000000; feg[149] = 0.0135000000;
					g[150] = 7.5000000000; fxg[150] = 0.1639000000; feg[150] = 0.0133000000;
					g[151] = 7.5500000000; fxg[151] = 0.1606000000; feg[151] = 0.0132000000;
					g[152] = 7.6000000000; fxg[152] = 0.1570000000; feg[152] = 0.0130000000;
					g[153] = 7.6500000000; fxg[153] = 0.1534000000; feg[153] = 0.0128000000;
					g[154] = 7.7000000000; fxg[154] = 0.1497000000; feg[154] = 0.0127000000;
					g[155] = 7.7500000000; fxg[155] = 0.1461000000; feg[155] = 0.0125000000;
					g[156] = 7.8000000000; fxg[156] = 0.1427000000; feg[156] = 0.0124000000;
					g[157] = 7.8500000000; fxg[157] = 0.1397000000; feg[157] = 0.0122000000;
					g[158] = 7.9000000000; fxg[158] = 0.1371000000; feg[158] = 0.0121000000;
					g[159] = 7.9500000000; fxg[159] = 0.1349000000; feg[159] = 0.0119000000;
					g[160] = 8.0000000000; fxg[160] = 0.1331000000; feg[160] = 0.0118000000;
					g[161] = 8.0500000000; fxg[161] = 0.1317000000; feg[161] = 0.0116000000;
					g[162] = 8.1000000000; fxg[162] = 0.1304000000; feg[162] = 0.0115000000;
					g[163] = 8.1500000000; fxg[163] = 0.1290000000; feg[163] = 0.0113000000;
					g[164] = 8.2000000000; fxg[164] = 0.1274000000; feg[164] = 0.0112000000;
					g[165] = 8.2500000000; fxg[165] = 0.1255000000; feg[165] = 0.0111000000;
					g[166] = 8.3000000000; fxg[166] = 0.1232000000; feg[166] = 0.0109000000;
					g[167] = 8.3500000000; fxg[167] = 0.1206000000; feg[167] = 0.0108000000;
					g[168] = 8.4000000000; fxg[168] = 0.1178000000; feg[168] = 0.0107000000;
					g[169] = 8.4500000000; fxg[169] = 0.1148000000; feg[169] = 0.0106000000;
					g[170] = 8.5000000000; fxg[170] = 0.1118000000; feg[170] = 0.0105000000;
					g[171] = 8.5500000000; fxg[171] = 0.1088000000; feg[171] = 0.0103000000;
					g[172] = 8.6000000000; fxg[172] = 0.1060000000; feg[172] = 0.0102000000;
					g[173] = 8.6500000000; fxg[173] = 0.1034000000; feg[173] = 0.0101000000;
					g[174] = 8.7000000000; fxg[174] = 0.1013000000; feg[174] = 0.0100000000;
					g[175] = 8.7500000000; fxg[175] = 0.0996000000; feg[175] = 0.0099000000;
					g[176] = 8.8000000000; fxg[176] = 0.0984000000; feg[176] = 0.0098000000;
					g[177] = 8.8500000000; fxg[177] = 0.0976000000; feg[177] = 0.0097000000;
					g[178] = 8.9000000000; fxg[178] = 0.0971000000; feg[178] = 0.0096000000;
					g[179] = 8.9500000000; fxg[179] = 0.0967000000; feg[179] = 0.0094000000;
					g[180] = 9.0000000000; fxg[180] = 0.0963000000; feg[180] = 0.0093000000;
					g[181] = 9.0500000000; fxg[181] = 0.0956000000; feg[181] = 0.0092000000;
					g[182] = 9.1000000000; fxg[182] = 0.0946000000; feg[182] = 0.0091000000;
					g[183] = 9.1500000000; fxg[183] = 0.0931000000; feg[183] = 0.0090000000;
					g[184] = 9.2000000000; fxg[184] = 0.0912000000; feg[184] = 0.0089000000;
					g[185] = 9.2500000000; fxg[185] = 0.0891000000; feg[185] = 0.0089000000;
					g[186] = 9.3000000000; fxg[186] = 0.0867000000; feg[186] = 0.0088000000;
					g[187] = 9.3500000000; fxg[187] = 0.0842000000; feg[187] = 0.0087000000;
					g[188] = 9.4000000000; fxg[188] = 0.0816000000; feg[188] = 0.0086000000;
					g[189] = 9.4500000000; fxg[189] = 0.0791000000; feg[189] = 0.0085000000;
					g[190] = 9.5000000000; fxg[190] = 0.0768000000; feg[190] = 0.0084000000;
					g[191] = 9.5500000000; fxg[191] = 0.0746000000; feg[191] = 0.0083000000;
					g[192] = 9.6000000000; fxg[192] = 0.0728000000; feg[192] = 0.0082000000;
					g[193] = 9.6500000000; fxg[193] = 0.0714000000; feg[193] = 0.0082000000;
					g[194] = 9.7000000000; fxg[194] = 0.0705000000; feg[194] = 0.0081000000;
					g[195] = 9.7500000000; fxg[195] = 0.0702000000; feg[195] = 0.0080000000;
					g[196] = 9.8000000000; fxg[196] = 0.0702000000; feg[196] = 0.0079000000;
					g[197] = 9.8500000000; fxg[197] = 0.0706000000; feg[197] = 0.0078000000;
					g[198] = 9.9000000000; fxg[198] = 0.0710000000; feg[198] = 0.0077000000;
					g[199] = 9.9500000000; fxg[199] = 0.0713000000; feg[199] = 0.0077000000;
					g[200] = 10.0000000000; fxg[200] = 0.0713000000; feg[200] = 0.0076000000;
					g[201] = 10.0500000000; fxg[201] = 0.0708000000; feg[201] = 0.0075000000;
					g[202] = 10.1000000000; fxg[202] = 0.0699000000; feg[202] = 0.0074000000;
					g[203] = 10.1500000000; fxg[203] = 0.0686000000; feg[203] = 0.0074000000;
					g[204] = 10.2000000000; fxg[204] = 0.0669000000; feg[204] = 0.0073000000;
					g[205] = 10.2500000000; fxg[205] = 0.0650000000; feg[205] = 0.0072000000;
					g[206] = 10.3000000000; fxg[206] = 0.0629000000; feg[206] = 0.0072000000;
					g[207] = 10.3500000000; fxg[207] = 0.0607000000; feg[207] = 0.0071000000;
					g[208] = 10.4000000000; fxg[208] = 0.0586000000; feg[208] = 0.0070000000;
					g[209] = 10.4500000000; fxg[209] = 0.0564000000; feg[209] = 0.0070000000;
					g[210] = 10.5000000000; fxg[210] = 0.0543000000; feg[210] = 0.0069000000;
					g[211] = 10.5500000000; fxg[211] = 0.0524000000; feg[211] = 0.0068000000;
					g[212] = 10.6000000000; fxg[212] = 0.0508000000; feg[212] = 0.0068000000;
					g[213] = 10.6500000000; fxg[213] = 0.0496000000; feg[213] = 0.0067000000;
					g[214] = 10.7000000000; fxg[214] = 0.0489000000; feg[214] = 0.0066000000;
					g[215] = 10.7500000000; fxg[215] = 0.0488000000; feg[215] = 0.0066000000;
					g[216] = 10.8000000000; fxg[216] = 0.0491000000; feg[216] = 0.0065000000;
					g[217] = 10.8500000000; fxg[217] = 0.0499000000; feg[217] = 0.0065000000;
					g[218] = 10.9000000000; fxg[218] = 0.0509000000; feg[218] = 0.0064000000;
					g[219] = 10.9500000000; fxg[219] = 0.0520000000; feg[219] = 0.0063000000;
					g[220] = 11.0000000000; fxg[220] = 0.0528000000; feg[220] = 0.0063000000;
					g[221] = 11.0500000000; fxg[221] = 0.0533000000; feg[221] = 0.0062000000;
					g[222] = 11.1000000000; fxg[222] = 0.0532000000; feg[222] = 0.0062000000;
					g[223] = 11.1500000000; fxg[223] = 0.0527000000; feg[223] = 0.0061000000;
					g[224] = 11.2000000000; fxg[224] = 0.0517000000; feg[224] = 0.0061000000;
					g[225] = 11.2500000000; fxg[225] = 0.0503000000; feg[225] = 0.0060000000;
					g[226] = 11.3000000000; fxg[226] = 0.0488000000; feg[226] = 0.0060000000;
					g[227] = 11.3500000000; fxg[227] = 0.0470000000; feg[227] = 0.0059000000;
					g[228] = 11.4000000000; fxg[228] = 0.0452000000; feg[228] = 0.0059000000;
					g[229] = 11.4500000000; fxg[229] = 0.0434000000; feg[229] = 0.0058000000;
					g[230] = 11.5000000000; fxg[230] = 0.0416000000; feg[230] = 0.0058000000;
					g[231] = 11.5500000000; fxg[231] = 0.0397000000; feg[231] = 0.0057000000;
					g[232] = 11.6000000000; fxg[232] = 0.0379000000; feg[232] = 0.0057000000;
					g[233] = 11.6500000000; fxg[233] = 0.0361000000; feg[233] = 0.0056000000;
					g[234] = 11.7000000000; fxg[234] = 0.0346000000; feg[234] = 0.0056000000;
					g[235] = 11.7500000000; fxg[235] = 0.0334000000; feg[235] = 0.0055000000;
					g[236] = 11.8000000000; fxg[236] = 0.0326000000; feg[236] = 0.0055000000;
					g[237] = 11.8500000000; fxg[237] = 0.0323000000; feg[237] = 0.0054000000;
					g[238] = 11.9000000000; fxg[238] = 0.0327000000; feg[238] = 0.0054000000;
					g[239] = 11.9500000000; fxg[239] = 0.0336000000; feg[239] = 0.0053000000;
					g[240] = 12.0000000000; fxg[240] = 0.0349000000; feg[240] = 0.0053000000;
					break;
				case 9:
					g[0] = 0.0000000000; fxg[0] = 9.0000000000; feg[0] = 1.8248000000;
					g[1] = 0.0500000000; fxg[1] = 8.9526000000; feg[1] = 1.8157000000;
					g[2] = 0.1000000000; fxg[2] = 8.8131000000; feg[2] = 1.7891000000;
					g[3] = 0.1500000000; fxg[3] = 8.5896000000; feg[3] = 1.7463000000;
					g[4] = 0.2000000000; fxg[4] = 8.2940000000; feg[4] = 1.6896000000;
					g[5] = 0.2500000000; fxg[5] = 7.9412000000; feg[5] = 1.6219000000;
					g[6] = 0.3000000000; fxg[6] = 7.5467000000; feg[6] = 1.5459000000;
					g[7] = 0.3500000000; fxg[7] = 7.1259000000; feg[7] = 1.4646000000;
					g[8] = 0.4000000000; fxg[8] = 6.6927000000; feg[8] = 1.3806000000;
					g[9] = 0.4500000000; fxg[9] = 6.2589000000; feg[9] = 1.2959000000;
					g[10] = 0.5000000000; fxg[10] = 5.8340000000; feg[10] = 1.2124000000;
					g[11] = 0.5500000000; fxg[11] = 5.4254000000; feg[11] = 1.1313000000;
					g[12] = 0.6000000000; fxg[12] = 5.0381000000; feg[12] = 1.0536000000;
					g[13] = 0.6500000000; fxg[13] = 4.6754000000; feg[13] = 0.9799000000;
					g[14] = 0.7000000000; fxg[14] = 4.3393000000; feg[14] = 0.9106000000;
					g[15] = 0.7500000000; fxg[15] = 4.0304000000; feg[15] = 0.8458000000;
					g[16] = 0.8000000000; fxg[16] = 3.7484000000; feg[16] = 0.7856000000;
					g[17] = 0.8500000000; fxg[17] = 3.4927000000; feg[17] = 0.7297000000;
					g[18] = 0.9000000000; fxg[18] = 3.2619000000; feg[18] = 0.6782000000;
					g[19] = 0.9500000000; fxg[19] = 3.0544000000; feg[19] = 0.6307000000;
					g[20] = 1.0000000000; fxg[20] = 2.8686000000; feg[20] = 0.5870000000;
					g[21] = 1.0500000000; fxg[21] = 2.7026000000; feg[21] = 0.5468000000;
					g[22] = 1.1000000000; fxg[22] = 2.5548000000; feg[22] = 0.5099000000;
					g[23] = 1.1500000000; fxg[23] = 2.4232000000; feg[23] = 0.4761000000;
					g[24] = 1.2000000000; fxg[24] = 2.3063000000; feg[24] = 0.4450000000;
					g[25] = 1.2500000000; fxg[25] = 2.2025000000; feg[25] = 0.4165000000;
					g[26] = 1.3000000000; fxg[26] = 2.1103000000; feg[26] = 0.3903000000;
					g[27] = 1.3500000000; fxg[27] = 2.0284000000; feg[27] = 0.3662000000;
					g[28] = 1.4000000000; fxg[28] = 1.9556000000; feg[28] = 0.3441000000;
					g[29] = 1.4500000000; fxg[29] = 1.8907000000; feg[29] = 0.3237000000;
					g[30] = 1.5000000000; fxg[30] = 1.8328000000; feg[30] = 0.3050000000;
					g[31] = 1.5500000000; fxg[31] = 1.7810000000; feg[31] = 0.2877000000;
					g[32] = 1.6000000000; fxg[32] = 1.7345000000; feg[32] = 0.2717000000;
					g[33] = 1.6500000000; fxg[33] = 1.6925000000; feg[33] = 0.2570000000;
					g[34] = 1.7000000000; fxg[34] = 1.6545000000; feg[34] = 0.2433000000;
					g[35] = 1.7500000000; fxg[35] = 1.6199000000; feg[35] = 0.2307000000;
					g[36] = 1.8000000000; fxg[36] = 1.5882000000; feg[36] = 0.2190000000;
					g[37] = 1.8500000000; fxg[37] = 1.5589000000; feg[37] = 0.2081000000;
					g[38] = 1.9000000000; fxg[38] = 1.5318000000; feg[38] = 0.1981000000;
					g[39] = 1.9500000000; fxg[39] = 1.5065000000; feg[39] = 0.1887000000;
					g[40] = 2.0000000000; fxg[40] = 1.4827000000; feg[40] = 0.1799000000;
					g[41] = 2.0500000000; fxg[41] = 1.4601000000; feg[41] = 0.1718000000;
					g[42] = 2.1000000000; fxg[42] = 1.4387000000; feg[42] = 0.1641000000;
					g[43] = 2.1500000000; fxg[43] = 1.4181000000; feg[43] = 0.1570000000;
					g[44] = 2.2000000000; fxg[44] = 1.3983000000; feg[44] = 0.1504000000;
					g[45] = 2.2500000000; fxg[45] = 1.3790000000; feg[45] = 0.1441000000;
					g[46] = 2.3000000000; fxg[46] = 1.3603000000; feg[46] = 0.1383000000;
					g[47] = 2.3500000000; fxg[47] = 1.3420000000; feg[47] = 0.1328000000;
					g[48] = 2.4000000000; fxg[48] = 1.3241000000; feg[48] = 0.1276000000;
					g[49] = 2.4500000000; fxg[49] = 1.3064000000; feg[49] = 0.1227000000;
					g[50] = 2.5000000000; fxg[50] = 1.2889000000; feg[50] = 0.1181000000;
					g[51] = 2.5500000000; fxg[51] = 1.2716000000; feg[51] = 0.1138000000;
					g[52] = 2.6000000000; fxg[52] = 1.2544000000; feg[52] = 0.1097000000;
					g[53] = 2.6500000000; fxg[53] = 1.2374000000; feg[53] = 0.1058000000;
					g[54] = 2.7000000000; fxg[54] = 1.2205000000; feg[54] = 0.1022000000;
					g[55] = 2.7500000000; fxg[55] = 1.2036000000; feg[55] = 0.0987000000;
					g[56] = 2.8000000000; fxg[56] = 1.1869000000; feg[56] = 0.0954000000;
					g[57] = 2.8500000000; fxg[57] = 1.1701000000; feg[57] = 0.0923000000;
					g[58] = 2.9000000000; fxg[58] = 1.1535000000; feg[58] = 0.0893000000;
					g[59] = 2.9500000000; fxg[59] = 1.1369000000; feg[59] = 0.0865000000;
					g[60] = 3.0000000000; fxg[60] = 1.1204000000; feg[60] = 0.0838000000;
					g[61] = 3.0500000000; fxg[61] = 1.1039000000; feg[61] = 0.0813000000;
					g[62] = 3.1000000000; fxg[62] = 1.0875000000; feg[62] = 0.0788000000;
					g[63] = 3.1500000000; fxg[63] = 1.0711000000; feg[63] = 0.0765000000;
					g[64] = 3.2000000000; fxg[64] = 1.0549000000; feg[64] = 0.0743000000;
					g[65] = 3.2500000000; fxg[65] = 1.0387000000; feg[65] = 0.0722000000;
					g[66] = 3.3000000000; fxg[66] = 1.0226000000; feg[66] = 0.0701000000;
					g[67] = 3.3500000000; fxg[67] = 1.0066000000; feg[67] = 0.0682000000;
					g[68] = 3.4000000000; fxg[68] = 0.9907000000; feg[68] = 0.0663000000;
					g[69] = 3.4500000000; fxg[69] = 0.9749000000; feg[69] = 0.0645000000;
					g[70] = 3.5000000000; fxg[70] = 0.9592000000; feg[70] = 0.0628000000;
					g[71] = 3.5500000000; fxg[71] = 0.9437000000; feg[71] = 0.0612000000;
					g[72] = 3.6000000000; fxg[72] = 0.9283000000; feg[72] = 0.0596000000;
					g[73] = 3.6500000000; fxg[73] = 0.9130000000; feg[73] = 0.0581000000;
					g[74] = 3.7000000000; fxg[74] = 0.8978000000; feg[74] = 0.0567000000;
					g[75] = 3.7500000000; fxg[75] = 0.8828000000; feg[75] = 0.0553000000;
					g[76] = 3.8000000000; fxg[76] = 0.8679000000; feg[76] = 0.0539000000;
					g[77] = 3.8500000000; fxg[77] = 0.8532000000; feg[77] = 0.0526000000;
					g[78] = 3.9000000000; fxg[78] = 0.8387000000; feg[78] = 0.0514000000;
					g[79] = 3.9500000000; fxg[79] = 0.8243000000; feg[79] = 0.0502000000;
					g[80] = 4.0000000000; fxg[80] = 0.8101000000; feg[80] = 0.0490000000;
					g[81] = 4.0500000000; fxg[81] = 0.7961000000; feg[81] = 0.0479000000;
					g[82] = 4.1000000000; fxg[82] = 0.7822000000; feg[82] = 0.0468000000;
					g[83] = 4.1500000000; fxg[83] = 0.7685000000; feg[83] = 0.0458000000;
					g[84] = 4.2000000000; fxg[84] = 0.7550000000; feg[84] = 0.0447000000;
					g[85] = 4.2500000000; fxg[85] = 0.7416000000; feg[85] = 0.0438000000;
					g[86] = 4.3000000000; fxg[86] = 0.7284000000; feg[86] = 0.0428000000;
					g[87] = 4.3500000000; fxg[87] = 0.7155000000; feg[87] = 0.0419000000;
					g[88] = 4.4000000000; fxg[88] = 0.7028000000; feg[88] = 0.0410000000;
					g[89] = 4.4500000000; fxg[89] = 0.6902000000; feg[89] = 0.0402000000;
					g[90] = 4.5000000000; fxg[90] = 0.6779000000; feg[90] = 0.0393000000;
					g[91] = 4.5500000000; fxg[91] = 0.6657000000; feg[91] = 0.0385000000;
					g[92] = 4.6000000000; fxg[92] = 0.6536000000; feg[92] = 0.0378000000;
					g[93] = 4.6500000000; fxg[93] = 0.6417000000; feg[93] = 0.0370000000;
					g[94] = 4.7000000000; fxg[94] = 0.6300000000; feg[94] = 0.0363000000;
					g[95] = 4.7500000000; fxg[95] = 0.6185000000; feg[95] = 0.0356000000;
					g[96] = 4.8000000000; fxg[96] = 0.6073000000; feg[96] = 0.0349000000;
					g[97] = 4.8500000000; fxg[97] = 0.5962000000; feg[97] = 0.0342000000;
					g[98] = 4.9000000000; fxg[98] = 0.5854000000; feg[98] = 0.0336000000;
					g[99] = 4.9500000000; fxg[99] = 0.5748000000; feg[99] = 0.0329000000;
					g[100] = 5.0000000000; fxg[100] = 0.5643000000; feg[100] = 0.0323000000;
					g[101] = 5.0500000000; fxg[101] = 0.5539000000; feg[101] = 0.0317000000;
					g[102] = 5.1000000000; fxg[102] = 0.5436000000; feg[102] = 0.0311000000;
					g[103] = 5.1500000000; fxg[103] = 0.5335000000; feg[103] = 0.0306000000;
					g[104] = 5.2000000000; fxg[104] = 0.5236000000; feg[104] = 0.0300000000;
					g[105] = 5.2500000000; fxg[105] = 0.5139000000; feg[105] = 0.0295000000;
					g[106] = 5.3000000000; fxg[106] = 0.5045000000; feg[106] = 0.0290000000;
					g[107] = 5.3500000000; fxg[107] = 0.4953000000; feg[107] = 0.0284000000;
					g[108] = 5.4000000000; fxg[108] = 0.4863000000; feg[108] = 0.0280000000;
					g[109] = 5.4500000000; fxg[109] = 0.4775000000; feg[109] = 0.0275000000;
					g[110] = 5.5000000000; fxg[110] = 0.4688000000; feg[110] = 0.0270000000;
					g[111] = 5.5500000000; fxg[111] = 0.4602000000; feg[111] = 0.0265000000;
					g[112] = 5.6000000000; fxg[112] = 0.4516000000; feg[112] = 0.0261000000;
					g[113] = 5.6500000000; fxg[113] = 0.4432000000; feg[113] = 0.0257000000;
					g[114] = 5.7000000000; fxg[114] = 0.4348000000; feg[114] = 0.0252000000;
					g[115] = 5.7500000000; fxg[115] = 0.4266000000; feg[115] = 0.0248000000;
					g[116] = 5.8000000000; fxg[116] = 0.4187000000; feg[116] = 0.0244000000;
					g[117] = 5.8500000000; fxg[117] = 0.4110000000; feg[117] = 0.0240000000;
					g[118] = 5.9000000000; fxg[118] = 0.4036000000; feg[118] = 0.0236000000;
					g[119] = 5.9500000000; fxg[119] = 0.3964000000; feg[119] = 0.0233000000;
					g[120] = 6.0000000000; fxg[120] = 0.3894000000; feg[120] = 0.0229000000;
					g[121] = 6.0500000000; fxg[121] = 0.3825000000; feg[121] = 0.0225000000;
					g[122] = 6.1000000000; fxg[122] = 0.3756000000; feg[122] = 0.0222000000;
					g[123] = 6.1500000000; fxg[123] = 0.3687000000; feg[123] = 0.0218000000;
					g[124] = 6.2000000000; fxg[124] = 0.3618000000; feg[124] = 0.0215000000;
					g[125] = 6.2500000000; fxg[125] = 0.3550000000; feg[125] = 0.0212000000;
					g[126] = 6.3000000000; fxg[126] = 0.3482000000; feg[126] = 0.0209000000;
					g[127] = 6.3500000000; fxg[127] = 0.3416000000; feg[127] = 0.0206000000;
					g[128] = 6.4000000000; fxg[128] = 0.3352000000; feg[128] = 0.0203000000;
					g[129] = 6.4500000000; fxg[129] = 0.3290000000; feg[129] = 0.0200000000;
					g[130] = 6.5000000000; fxg[130] = 0.3232000000; feg[130] = 0.0197000000;
					g[131] = 6.5500000000; fxg[131] = 0.3177000000; feg[131] = 0.0194000000;
					g[132] = 6.6000000000; fxg[132] = 0.3123000000; feg[132] = 0.0191000000;
					g[133] = 6.6500000000; fxg[133] = 0.3071000000; feg[133] = 0.0188000000;
					g[134] = 6.7000000000; fxg[134] = 0.3018000000; feg[134] = 0.0186000000;
					g[135] = 6.7500000000; fxg[135] = 0.2966000000; feg[135] = 0.0183000000;
					g[136] = 6.8000000000; fxg[136] = 0.2912000000; feg[136] = 0.0180000000;
					g[137] = 6.8500000000; fxg[137] = 0.2858000000; feg[137] = 0.0178000000;
					g[138] = 6.9000000000; fxg[138] = 0.2803000000; feg[138] = 0.0175000000;
					g[139] = 6.9500000000; fxg[139] = 0.2748000000; feg[139] = 0.0173000000;
					g[140] = 7.0000000000; fxg[140] = 0.2695000000; feg[140] = 0.0171000000;
					g[141] = 7.0500000000; fxg[141] = 0.2644000000; feg[141] = 0.0168000000;
					g[142] = 7.1000000000; fxg[142] = 0.2595000000; feg[142] = 0.0166000000;
					g[143] = 7.1500000000; fxg[143] = 0.2549000000; feg[143] = 0.0164000000;
					g[144] = 7.2000000000; fxg[144] = 0.2507000000; feg[144] = 0.0162000000;
					g[145] = 7.2500000000; fxg[145] = 0.2467000000; feg[145] = 0.0159000000;
					g[146] = 7.3000000000; fxg[146] = 0.2429000000; feg[146] = 0.0157000000;
					g[147] = 7.3500000000; fxg[147] = 0.2392000000; feg[147] = 0.0155000000;
					g[148] = 7.4000000000; fxg[148] = 0.2355000000; feg[148] = 0.0153000000;
					g[149] = 7.4500000000; fxg[149] = 0.2316000000; feg[149] = 0.0151000000;
					g[150] = 7.5000000000; fxg[150] = 0.2276000000; feg[150] = 0.0149000000;
					g[151] = 7.5500000000; fxg[151] = 0.2235000000; feg[151] = 0.0147000000;
					g[152] = 7.6000000000; fxg[152] = 0.2191000000; feg[152] = 0.0146000000;
					g[153] = 7.6500000000; fxg[153] = 0.2148000000; feg[153] = 0.0144000000;
					g[154] = 7.7000000000; fxg[154] = 0.2104000000; feg[154] = 0.0142000000;
					g[155] = 7.7500000000; fxg[155] = 0.2062000000; feg[155] = 0.0140000000;
					g[156] = 7.8000000000; fxg[156] = 0.2022000000; feg[156] = 0.0138000000;
					g[157] = 7.8500000000; fxg[157] = 0.1984000000; feg[157] = 0.0137000000;
					g[158] = 7.9000000000; fxg[158] = 0.1950000000; feg[158] = 0.0135000000;
					g[159] = 7.9500000000; fxg[159] = 0.1920000000; feg[159] = 0.0133000000;
					g[160] = 8.0000000000; fxg[160] = 0.1893000000; feg[160] = 0.0132000000;
					g[161] = 8.0500000000; fxg[161] = 0.1868000000; feg[161] = 0.0130000000;
					g[162] = 8.1000000000; fxg[162] = 0.1844000000; feg[162] = 0.0129000000;
					g[163] = 8.1500000000; fxg[163] = 0.1820000000; feg[163] = 0.0127000000;
					g[164] = 8.2000000000; fxg[164] = 0.1795000000; feg[164] = 0.0126000000;
					g[165] = 8.2500000000; fxg[165] = 0.1767000000; feg[165] = 0.0124000000;
					g[166] = 8.3000000000; fxg[166] = 0.1737000000; feg[166] = 0.0123000000;
					g[167] = 8.3500000000; fxg[167] = 0.1705000000; feg[167] = 0.0121000000;
					g[168] = 8.4000000000; fxg[168] = 0.1671000000; feg[168] = 0.0120000000;
					g[169] = 8.4500000000; fxg[169] = 0.1636000000; feg[169] = 0.0118000000;
					g[170] = 8.5000000000; fxg[170] = 0.1601000000; feg[170] = 0.0117000000;
					g[171] = 8.5500000000; fxg[171] = 0.1566000000; feg[171] = 0.0116000000;
					g[172] = 8.6000000000; fxg[172] = 0.1533000000; feg[172] = 0.0115000000;
					g[173] = 8.6500000000; fxg[173] = 0.1503000000; feg[173] = 0.0113000000;
					g[174] = 8.7000000000; fxg[174] = 0.1476000000; feg[174] = 0.0112000000;
					g[175] = 8.7500000000; fxg[175] = 0.1453000000; feg[175] = 0.0111000000;
					g[176] = 8.8000000000; fxg[176] = 0.1433000000; feg[176] = 0.0109000000;
					g[177] = 8.8500000000; fxg[177] = 0.1417000000; feg[177] = 0.0108000000;
					g[178] = 8.9000000000; fxg[178] = 0.1404000000; feg[178] = 0.0107000000;
					g[179] = 8.9500000000; fxg[179] = 0.1391000000; feg[179] = 0.0106000000;
					g[180] = 9.0000000000; fxg[180] = 0.1378000000; feg[180] = 0.0105000000;
					g[181] = 9.0500000000; fxg[181] = 0.1363000000; feg[181] = 0.0104000000;
					g[182] = 9.1000000000; fxg[182] = 0.1346000000; feg[182] = 0.0102000000;
					g[183] = 9.1500000000; fxg[183] = 0.1326000000; feg[183] = 0.0101000000;
					g[184] = 9.2000000000; fxg[184] = 0.1302000000; feg[184] = 0.0100000000;
					g[185] = 9.2500000000; fxg[185] = 0.1276000000; feg[185] = 0.0099000000;
					g[186] = 9.3000000000; fxg[186] = 0.1249000000; feg[186] = 0.0098000000;
					g[187] = 9.3500000000; fxg[187] = 0.1220000000; feg[187] = 0.0097000000;
					g[188] = 9.4000000000; fxg[188] = 0.1190000000; feg[188] = 0.0096000000;
					g[189] = 9.4500000000; fxg[189] = 0.1162000000; feg[189] = 0.0095000000;
					g[190] = 9.5000000000; fxg[190] = 0.1135000000; feg[190] = 0.0094000000;
					g[191] = 9.5500000000; fxg[191] = 0.1110000000; feg[191] = 0.0093000000;
					g[192] = 9.6000000000; fxg[192] = 0.1088000000; feg[192] = 0.0092000000;
					g[193] = 9.6500000000; fxg[193] = 0.1071000000; feg[193] = 0.0091000000;
					g[194] = 9.7000000000; fxg[194] = 0.1057000000; feg[194] = 0.0090000000;
					g[195] = 9.7500000000; fxg[195] = 0.1048000000; feg[195] = 0.0090000000;
					g[196] = 9.8000000000; fxg[196] = 0.1042000000; feg[196] = 0.0089000000;
					g[197] = 9.8500000000; fxg[197] = 0.1038000000; feg[197] = 0.0088000000;
					g[198] = 9.9000000000; fxg[198] = 0.1034000000; feg[198] = 0.0087000000;
					g[199] = 9.9500000000; fxg[199] = 0.1030000000; feg[199] = 0.0086000000;
					g[200] = 10.0000000000; fxg[200] = 0.1024000000; feg[200] = 0.0085000000;
					g[201] = 10.0500000000; fxg[201] = 0.1014000000; feg[201] = 0.0084000000;
					g[202] = 10.1000000000; fxg[202] = 0.1001000000; feg[202] = 0.0084000000;
					g[203] = 10.1500000000; fxg[203] = 0.0984000000; feg[203] = 0.0083000000;
					g[204] = 10.2000000000; fxg[204] = 0.0964000000; feg[204] = 0.0082000000;
					g[205] = 10.2500000000; fxg[205] = 0.0942000000; feg[205] = 0.0081000000;
					g[206] = 10.3000000000; fxg[206] = 0.0918000000; feg[206] = 0.0080000000;
					g[207] = 10.3500000000; fxg[207] = 0.0893000000; feg[207] = 0.0080000000;
					g[208] = 10.4000000000; fxg[208] = 0.0869000000; feg[208] = 0.0079000000;
					g[209] = 10.4500000000; fxg[209] = 0.0844000000; feg[209] = 0.0078000000;
					g[210] = 10.5000000000; fxg[210] = 0.0821000000; feg[210] = 0.0077000000;
					g[211] = 10.5500000000; fxg[211] = 0.0800000000; feg[211] = 0.0077000000;
					g[212] = 10.6000000000; fxg[212] = 0.0783000000; feg[212] = 0.0076000000;
					g[213] = 10.6500000000; fxg[213] = 0.0768000000; feg[213] = 0.0075000000;
					g[214] = 10.7000000000; fxg[214] = 0.0759000000; feg[214] = 0.0075000000;
					g[215] = 10.7500000000; fxg[215] = 0.0753000000; feg[215] = 0.0074000000;
					g[216] = 10.8000000000; fxg[216] = 0.0752000000; feg[216] = 0.0073000000;
					g[217] = 10.8500000000; fxg[217] = 0.0754000000; feg[217] = 0.0073000000;
					g[218] = 10.9000000000; fxg[218] = 0.0758000000; feg[218] = 0.0072000000;
					g[219] = 10.9500000000; fxg[219] = 0.0763000000; feg[219] = 0.0071000000;
					g[220] = 11.0000000000; fxg[220] = 0.0765000000; feg[220] = 0.0071000000;
					g[221] = 11.0500000000; fxg[221] = 0.0765000000; feg[221] = 0.0070000000;
					g[222] = 11.1000000000; fxg[222] = 0.0761000000; feg[222] = 0.0069000000;
					g[223] = 11.1500000000; fxg[223] = 0.0753000000; feg[223] = 0.0069000000;
					g[224] = 11.2000000000; fxg[224] = 0.0741000000; feg[224] = 0.0068000000;
					g[225] = 11.2500000000; fxg[225] = 0.0726000000; feg[225] = 0.0068000000;
					g[226] = 11.3000000000; fxg[226] = 0.0708000000; feg[226] = 0.0067000000;
					g[227] = 11.3500000000; fxg[227] = 0.0689000000; feg[227] = 0.0066000000;
					g[228] = 11.4000000000; fxg[228] = 0.0668000000; feg[228] = 0.0066000000;
					g[229] = 11.4500000000; fxg[229] = 0.0647000000; feg[229] = 0.0065000000;
					g[230] = 11.5000000000; fxg[230] = 0.0626000000; feg[230] = 0.0065000000;
					g[231] = 11.5500000000; fxg[231] = 0.0605000000; feg[231] = 0.0064000000;
					g[232] = 11.6000000000; fxg[232] = 0.0584000000; feg[232] = 0.0064000000;
					g[233] = 11.6500000000; fxg[233] = 0.0566000000; feg[233] = 0.0063000000;
					g[234] = 11.7000000000; fxg[234] = 0.0549000000; feg[234] = 0.0063000000;
					g[235] = 11.7500000000; fxg[235] = 0.0536000000; feg[235] = 0.0062000000;
					g[236] = 11.8000000000; fxg[236] = 0.0528000000; feg[236] = 0.0062000000;
					g[237] = 11.8500000000; fxg[237] = 0.0524000000; feg[237] = 0.0061000000;
					g[238] = 11.9000000000; fxg[238] = 0.0525000000; feg[238] = 0.0060000000;
					g[239] = 11.9500000000; fxg[239] = 0.0530000000; feg[239] = 0.0060000000;
					g[240] = 12.0000000000; fxg[240] = 0.0538000000; feg[240] = 0.0059000000;
					break;
				case 10:
					g[0] = 0.0000000000; fxg[0] = 10.0000000000; feg[0] = 1.6518490000;
					g[1] = 0.0500000000; fxg[1] = 9.9570000000; feg[1] = 1.6452000000;
					g[2] = 0.1000000000; fxg[2] = 9.8302000000; feg[2] = 1.6258000000;
					g[3] = 0.1500000000; fxg[3] = 9.6253000000; feg[3] = 1.5943000000;
					g[4] = 0.2000000000; fxg[4] = 9.3515000000; feg[4] = 1.5522000000;
					g[5] = 0.2500000000; fxg[5] = 9.0200000000; feg[5] = 1.5011000000;
					g[6] = 0.3000000000; fxg[6] = 8.6434000000; feg[6] = 1.4431000000;
					g[7] = 0.3500000000; fxg[7] = 8.2343000000; feg[7] = 1.3799000000;
					g[8] = 0.4000000000; fxg[8] = 7.8050000000; feg[8] = 1.3133000000;
					g[9] = 0.4500000000; fxg[9] = 7.3663000000; feg[9] = 1.2451000000;
					g[10] = 0.5000000000; fxg[10] = 6.9276000000; feg[10] = 1.1765000000;
					g[11] = 0.5500000000; fxg[11] = 6.4966000000; feg[11] = 1.1087000000;
					g[12] = 0.6000000000; fxg[12] = 6.0793000000; feg[12] = 1.0426000000;
					g[13] = 0.6500000000; fxg[13] = 5.6801000000; feg[13] = 0.9789000000;
					g[14] = 0.7000000000; fxg[14] = 5.3022000000; feg[14] = 0.9178000000;
					g[15] = 0.7500000000; fxg[15] = 4.9475000000; feg[15] = 0.8599000000;
					g[16] = 0.8000000000; fxg[16] = 4.6170000000; feg[16] = 0.8052000000;
					g[17] = 0.8500000000; fxg[17] = 4.3110000000; feg[17] = 0.7538000000;
					g[18] = 0.9000000000; fxg[18] = 4.0292000000; feg[18] = 0.7057000000;
					g[19] = 0.9500000000; fxg[19] = 3.7709000000; feg[19] = 0.6608000000;
					g[20] = 1.0000000000; fxg[20] = 3.5350000000; feg[20] = 0.6189000000;
					g[21] = 1.0500000000; fxg[21] = 3.3204000000; feg[21] = 0.5800000000;
					g[22] = 1.1000000000; fxg[22] = 3.1256000000; feg[22] = 0.5439000000;
					g[23] = 1.1500000000; fxg[23] = 2.9493000000; feg[23] = 0.5104000000;
					g[24] = 1.2000000000; fxg[24] = 2.7899000000; feg[24] = 0.4793000000;
					g[25] = 1.2500000000; fxg[25] = 2.6462000000; feg[25] = 0.4506000000;
					g[26] = 1.3000000000; fxg[26] = 2.5168000000; feg[26] = 0.4239000000;
					g[27] = 1.3500000000; fxg[27] = 2.4003000000; feg[27] = 0.3992000000;
					g[28] = 1.4000000000; fxg[28] = 2.2954000000; feg[28] = 0.3763000000;
					g[29] = 1.4500000000; fxg[29] = 2.2012000000; feg[29] = 0.3551000000;
					g[30] = 1.5000000000; fxg[30] = 2.1164000000; feg[30] = 0.3354000000;
					g[31] = 1.5500000000; fxg[31] = 2.0400000000; feg[31] = 0.3172000000;
					g[32] = 1.6000000000; fxg[32] = 1.9713000000; feg[32] = 0.3002000000;
					g[33] = 1.6500000000; fxg[33] = 1.9093000000; feg[33] = 0.2845000000;
					g[34] = 1.7000000000; fxg[34] = 1.8533000000; feg[34] = 0.2699000000;
					g[35] = 1.7500000000; fxg[35] = 1.8026000000; feg[35] = 0.2563000000;
					g[36] = 1.8000000000; fxg[36] = 1.7566000000; feg[36] = 0.2436000000;
					g[37] = 1.8500000000; fxg[37] = 1.7148000000; feg[37] = 0.2318000000;
					g[38] = 1.9000000000; fxg[38] = 1.6766000000; feg[38] = 0.2207000000;
					g[39] = 1.9500000000; fxg[39] = 1.6416000000; feg[39] = 0.2104000000;
					g[40] = 2.0000000000; fxg[40] = 1.6094000000; feg[40] = 0.2008000000;
					g[41] = 2.0500000000; fxg[41] = 1.5796000000; feg[41] = 0.1918000000;
					g[42] = 2.1000000000; fxg[42] = 1.5520000000; feg[42] = 0.1834000000;
					g[43] = 2.1500000000; fxg[43] = 1.5263000000; feg[43] = 0.1755000000;
					g[44] = 2.2000000000; fxg[44] = 1.5021000000; feg[44] = 0.1681000000;
					g[45] = 2.2500000000; fxg[45] = 1.4794000000; feg[45] = 0.1611000000;
					g[46] = 2.3000000000; fxg[46] = 1.4578000000; feg[46] = 0.1546000000;
					g[47] = 2.3500000000; fxg[47] = 1.4373000000; feg[47] = 0.1484000000;
					g[48] = 2.4000000000; fxg[48] = 1.4177000000; feg[48] = 0.1426000000;
					g[49] = 2.4500000000; fxg[49] = 1.3988000000; feg[49] = 0.1372000000;
					g[50] = 2.5000000000; fxg[50] = 1.3806000000; feg[50] = 0.1320000000;
					g[51] = 2.5500000000; fxg[51] = 1.3630000000; feg[51] = 0.1272000000;
					g[52] = 2.6000000000; fxg[52] = 1.3458000000; feg[52] = 0.1226000000;
					g[53] = 2.6500000000; fxg[53] = 1.3290000000; feg[53] = 0.1182000000;
					g[54] = 2.7000000000; fxg[54] = 1.3126000000; feg[54] = 0.1141000000;
					g[55] = 2.7500000000; fxg[55] = 1.2964000000; feg[55] = 0.1102000000;
					g[56] = 2.8000000000; fxg[56] = 1.2805000000; feg[56] = 0.1065000000;
					g[57] = 2.8500000000; fxg[57] = 1.2647000000; feg[57] = 0.1030000000;
					g[58] = 2.9000000000; fxg[58] = 1.2492000000; feg[58] = 0.0996000000;
					g[59] = 2.9500000000; fxg[59] = 1.2338000000; feg[59] = 0.0964000000;
					g[60] = 3.0000000000; fxg[60] = 1.2185000000; feg[60] = 0.0934000000;
					g[61] = 3.0500000000; fxg[61] = 1.2033000000; feg[61] = 0.0905000000;
					g[62] = 3.1000000000; fxg[62] = 1.1882000000; feg[62] = 0.0878000000;
					g[63] = 3.1500000000; fxg[63] = 1.1732000000; feg[63] = 0.0852000000;
					g[64] = 3.2000000000; fxg[64] = 1.1583000000; feg[64] = 0.0827000000;
					g[65] = 3.2500000000; fxg[65] = 1.1435000000; feg[65] = 0.0803000000;
					g[66] = 3.3000000000; fxg[66] = 1.1287000000; feg[66] = 0.0780000000;
					g[67] = 3.3500000000; fxg[67] = 1.1139000000; feg[67] = 0.0758000000;
					g[68] = 3.4000000000; fxg[68] = 1.0993000000; feg[68] = 0.0737000000;
					g[69] = 3.4500000000; fxg[69] = 1.0846000000; feg[69] = 0.0717000000;
					g[70] = 3.5000000000; fxg[70] = 1.0701000000; feg[70] = 0.0698000000;
					g[71] = 3.5500000000; fxg[71] = 1.0556000000; feg[71] = 0.0679000000;
					g[72] = 3.6000000000; fxg[72] = 1.0412000000; feg[72] = 0.0662000000;
					g[73] = 3.6500000000; fxg[73] = 1.0269000000; feg[73] = 0.0645000000;
					g[74] = 3.7000000000; fxg[74] = 1.0126000000; feg[74] = 0.0628000000;
					g[75] = 3.7500000000; fxg[75] = 0.9984000000; feg[75] = 0.0613000000;
					g[76] = 3.8000000000; fxg[76] = 0.9843000000; feg[76] = 0.0598000000;
					g[77] = 3.8500000000; fxg[77] = 0.9703000000; feg[77] = 0.0583000000;
					g[78] = 3.9000000000; fxg[78] = 0.9564000000; feg[78] = 0.0569000000;
					g[79] = 3.9500000000; fxg[79] = 0.9426000000; feg[79] = 0.0556000000;
					g[80] = 4.0000000000; fxg[80] = 0.9289000000; feg[80] = 0.0543000000;
					g[81] = 4.0500000000; fxg[81] = 0.9153000000; feg[81] = 0.0530000000;
					g[82] = 4.1000000000; fxg[82] = 0.9017000000; feg[82] = 0.0518000000;
					g[83] = 4.1500000000; fxg[83] = 0.8883000000; feg[83] = 0.0506000000;
					g[84] = 4.2000000000; fxg[84] = 0.8750000000; feg[84] = 0.0495000000;
					g[85] = 4.2500000000; fxg[85] = 0.8619000000; feg[85] = 0.0484000000;
					g[86] = 4.3000000000; fxg[86] = 0.8488000000; feg[86] = 0.0474000000;
					g[87] = 4.3500000000; fxg[87] = 0.8359000000; feg[87] = 0.0464000000;
					g[88] = 4.4000000000; fxg[88] = 0.8231000000; feg[88] = 0.0454000000;
					g[89] = 4.4500000000; fxg[89] = 0.8105000000; feg[89] = 0.0444000000;
					g[90] = 4.5000000000; fxg[90] = 0.7980000000; feg[90] = 0.0435000000;
					g[91] = 4.5500000000; fxg[91] = 0.7856000000; feg[91] = 0.0426000000;
					g[92] = 4.6000000000; fxg[92] = 0.7733000000; feg[92] = 0.0417000000;
					g[93] = 4.6500000000; fxg[93] = 0.7612000000; feg[93] = 0.0409000000;
					g[94] = 4.7000000000; fxg[94] = 0.7492000000; feg[94] = 0.0401000000;
					g[95] = 4.7500000000; fxg[95] = 0.7373000000; feg[95] = 0.0393000000;
					g[96] = 4.8000000000; fxg[96] = 0.7257000000; feg[96] = 0.0385000000;
					g[97] = 4.8500000000; fxg[97] = 0.7142000000; feg[97] = 0.0378000000;
					g[98] = 4.9000000000; fxg[98] = 0.7028000000; feg[98] = 0.0371000000;
					g[99] = 4.9500000000; fxg[99] = 0.6916000000; feg[99] = 0.0364000000;
					g[100] = 5.0000000000; fxg[100] = 0.6805000000; feg[100] = 0.0357000000;
					g[101] = 5.0500000000; fxg[101] = 0.6696000000; feg[101] = 0.0350000000;
					g[102] = 5.1000000000; fxg[102] = 0.6587000000; feg[102] = 0.0344000000;
					g[103] = 5.1500000000; fxg[103] = 0.6480000000; feg[103] = 0.0338000000;
					g[104] = 5.2000000000; fxg[104] = 0.6374000000; feg[104] = 0.0331000000;
					g[105] = 5.2500000000; fxg[105] = 0.6271000000; feg[105] = 0.0326000000;
					g[106] = 5.3000000000; fxg[106] = 0.6169000000; feg[106] = 0.0320000000;
					g[107] = 5.3500000000; fxg[107] = 0.6069000000; feg[107] = 0.0314000000;
					g[108] = 5.4000000000; fxg[108] = 0.5971000000; feg[108] = 0.0309000000;
					g[109] = 5.4500000000; fxg[109] = 0.5874000000; feg[109] = 0.0303000000;
					g[110] = 5.5000000000; fxg[110] = 0.5778000000; feg[110] = 0.0298000000;
					g[111] = 5.5500000000; fxg[111] = 0.5683000000; feg[111] = 0.0293000000;
					g[112] = 5.6000000000; fxg[112] = 0.5590000000; feg[112] = 0.0288000000;
					g[113] = 5.6500000000; fxg[113] = 0.5497000000; feg[113] = 0.0283000000;
					g[114] = 5.7000000000; fxg[114] = 0.5405000000; feg[114] = 0.0279000000;
					g[115] = 5.7500000000; fxg[115] = 0.5315000000; feg[115] = 0.0274000000;
					g[116] = 5.8000000000; fxg[116] = 0.5227000000; feg[116] = 0.0270000000;
					g[117] = 5.8500000000; fxg[117] = 0.5141000000; feg[117] = 0.0265000000;
					g[118] = 5.9000000000; fxg[118] = 0.5057000000; feg[118] = 0.0261000000;
					g[119] = 5.9500000000; fxg[119] = 0.4975000000; feg[119] = 0.0257000000;
					g[120] = 6.0000000000; fxg[120] = 0.4895000000; feg[120] = 0.0253000000;
					g[121] = 6.0500000000; fxg[121] = 0.4815000000; feg[121] = 0.0249000000;
					g[122] = 6.1000000000; fxg[122] = 0.4736000000; feg[122] = 0.0245000000;
					g[123] = 6.1500000000; fxg[123] = 0.4658000000; feg[123] = 0.0241000000;
					g[124] = 6.2000000000; fxg[124] = 0.4580000000; feg[124] = 0.0238000000;
					g[125] = 6.2500000000; fxg[125] = 0.4503000000; feg[125] = 0.0234000000;
					g[126] = 6.3000000000; fxg[126] = 0.4426000000; feg[126] = 0.0231000000;
					g[127] = 6.3500000000; fxg[127] = 0.4352000000; feg[127] = 0.0227000000;
					g[128] = 6.4000000000; fxg[128] = 0.4279000000; feg[128] = 0.0224000000;
					g[129] = 6.4500000000; fxg[129] = 0.4208000000; feg[129] = 0.0220000000;
					g[130] = 6.5000000000; fxg[130] = 0.4140000000; feg[130] = 0.0217000000;
					g[131] = 6.5500000000; fxg[131] = 0.4074000000; feg[131] = 0.0214000000;
					g[132] = 6.6000000000; fxg[132] = 0.4009000000; feg[132] = 0.0211000000;
					g[133] = 6.6500000000; fxg[133] = 0.3946000000; feg[133] = 0.0208000000;
					g[134] = 6.7000000000; fxg[134] = 0.3883000000; feg[134] = 0.0205000000;
					g[135] = 6.7500000000; fxg[135] = 0.3820000000; feg[135] = 0.0202000000;
					g[136] = 6.8000000000; fxg[136] = 0.3757000000; feg[136] = 0.0199000000;
					g[137] = 6.8500000000; fxg[137] = 0.3694000000; feg[137] = 0.0196000000;
					g[138] = 6.9000000000; fxg[138] = 0.3630000000; feg[138] = 0.0194000000;
					g[139] = 6.9500000000; fxg[139] = 0.3568000000; feg[139] = 0.0191000000;
					g[140] = 7.0000000000; fxg[140] = 0.3507000000; feg[140] = 0.0189000000;
					g[141] = 7.0500000000; fxg[141] = 0.3447000000; feg[141] = 0.0186000000;
					g[142] = 7.1000000000; fxg[142] = 0.3390000000; feg[142] = 0.0183000000;
					g[143] = 7.1500000000; fxg[143] = 0.3335000000; feg[143] = 0.0181000000;
					g[144] = 7.2000000000; fxg[144] = 0.3283000000; feg[144] = 0.0179000000;
					g[145] = 7.2500000000; fxg[145] = 0.3232000000; feg[145] = 0.0176000000;
					g[146] = 7.3000000000; fxg[146] = 0.3184000000; feg[146] = 0.0174000000;
					g[147] = 7.3500000000; fxg[147] = 0.3136000000; feg[147] = 0.0172000000;
					g[148] = 7.4000000000; fxg[148] = 0.3088000000; feg[148] = 0.0169000000;
					g[149] = 7.4500000000; fxg[149] = 0.3040000000; feg[149] = 0.0167000000;
					g[150] = 7.5000000000; fxg[150] = 0.2991000000; feg[150] = 0.0165000000;
					g[151] = 7.5500000000; fxg[151] = 0.2941000000; feg[151] = 0.0163000000;
					g[152] = 7.6000000000; fxg[152] = 0.2891000000; feg[152] = 0.0161000000;
					g[153] = 7.6500000000; fxg[153] = 0.2840000000; feg[153] = 0.0159000000;
					g[154] = 7.7000000000; fxg[154] = 0.2790000000; feg[154] = 0.0157000000;
					g[155] = 7.7500000000; fxg[155] = 0.2741000000; feg[155] = 0.0155000000;
					g[156] = 7.8000000000; fxg[156] = 0.2694000000; feg[156] = 0.0153000000;
					g[157] = 7.8500000000; fxg[157] = 0.2650000000; feg[157] = 0.0151000000;
					g[158] = 7.9000000000; fxg[158] = 0.2608000000; feg[158] = 0.0149000000;
					g[159] = 7.9500000000; fxg[159] = 0.2569000000; feg[159] = 0.0148000000;
					g[160] = 8.0000000000; fxg[160] = 0.2532000000; feg[160] = 0.0146000000;
					g[161] = 8.0500000000; fxg[161] = 0.2497000000; feg[161] = 0.0144000000;
					g[162] = 8.1000000000; fxg[162] = 0.2463000000; feg[162] = 0.0142000000;
					g[163] = 8.1500000000; fxg[163] = 0.2429000000; feg[163] = 0.0141000000;
					g[164] = 8.2000000000; fxg[164] = 0.2395000000; feg[164] = 0.0139000000;
					g[165] = 8.2500000000; fxg[165] = 0.2359000000; feg[165] = 0.0137000000;
					g[166] = 8.3000000000; fxg[166] = 0.2322000000; feg[166] = 0.0136000000;
					g[167] = 8.3500000000; fxg[167] = 0.2283000000; feg[167] = 0.0134000000;
					g[168] = 8.4000000000; fxg[168] = 0.2243000000; feg[168] = 0.0133000000;
					g[169] = 8.4500000000; fxg[169] = 0.2203000000; feg[169] = 0.0131000000;
					g[170] = 8.5000000000; fxg[170] = 0.2162000000; feg[170] = 0.0130000000;
					g[171] = 8.5500000000; fxg[171] = 0.2122000000; feg[171] = 0.0128000000;
					g[172] = 8.6000000000; fxg[172] = 0.2084000000; feg[172] = 0.0127000000;
					g[173] = 8.6500000000; fxg[173] = 0.2048000000; feg[173] = 0.0125000000;
					g[174] = 8.7000000000; fxg[174] = 0.2016000000; feg[174] = 0.0124000000;
					g[175] = 8.7500000000; fxg[175] = 0.1986000000; feg[175] = 0.0123000000;
					g[176] = 8.8000000000; fxg[176] = 0.1959000000; feg[176] = 0.0121000000;
					g[177] = 8.8500000000; fxg[177] = 0.1934000000; feg[177] = 0.0120000000;
					g[178] = 8.9000000000; fxg[178] = 0.1912000000; feg[178] = 0.0119000000;
					g[179] = 8.9500000000; fxg[179] = 0.1890000000; feg[179] = 0.0117000000;
					g[180] = 9.0000000000; fxg[180] = 0.1869000000; feg[180] = 0.0116000000;
					g[181] = 9.0500000000; fxg[181] = 0.1846000000; feg[181] = 0.0115000000;
					g[182] = 9.1000000000; fxg[182] = 0.1822000000; feg[182] = 0.0114000000;
					g[183] = 9.1500000000; fxg[183] = 0.1795000000; feg[183] = 0.0112000000;
					g[184] = 9.2000000000; fxg[184] = 0.1766000000; feg[184] = 0.0111000000;
					g[185] = 9.2500000000; fxg[185] = 0.1735000000; feg[185] = 0.0110000000;
					g[186] = 9.3000000000; fxg[186] = 0.1703000000; feg[186] = 0.0109000000;
					g[187] = 9.3500000000; fxg[187] = 0.1670000000; feg[187] = 0.0108000000;
					g[188] = 9.4000000000; fxg[188] = 0.1637000000; feg[188] = 0.0107000000;
					g[189] = 9.4500000000; fxg[189] = 0.1604000000; feg[189] = 0.0105000000;
					g[190] = 9.5000000000; fxg[190] = 0.1574000000; feg[190] = 0.0104000000;
					g[191] = 9.5500000000; fxg[191] = 0.1545000000; feg[191] = 0.0103000000;
					g[192] = 9.6000000000; fxg[192] = 0.1519000000; feg[192] = 0.0102000000;
					g[193] = 9.6500000000; fxg[193] = 0.1497000000; feg[193] = 0.0101000000;
					g[194] = 9.7000000000; fxg[194] = 0.1478000000; feg[194] = 0.0100000000;
					g[195] = 9.7500000000; fxg[195] = 0.1462000000; feg[195] = 0.0099000000;
					g[196] = 9.8000000000; fxg[196] = 0.1448000000; feg[196] = 0.0098000000;
					g[197] = 9.8500000000; fxg[197] = 0.1437000000; feg[197] = 0.0097000000;
					g[198] = 9.9000000000; fxg[198] = 0.1426000000; feg[198] = 0.0096000000;
					g[199] = 9.9500000000; fxg[199] = 0.1414000000; feg[199] = 0.0095000000;
					g[200] = 10.0000000000; fxg[200] = 0.1401000000; feg[200] = 0.0094000000;
					g[201] = 10.0500000000; fxg[201] = 0.1386000000; feg[201] = 0.0093000000;
					g[202] = 10.1000000000; fxg[202] = 0.1367000000; feg[202] = 0.0093000000;
					g[203] = 10.1500000000; fxg[203] = 0.1346000000; feg[203] = 0.0092000000;
					g[204] = 10.2000000000; fxg[204] = 0.1323000000; feg[204] = 0.0091000000;
					g[205] = 10.2500000000; fxg[205] = 0.1297000000; feg[205] = 0.0090000000;
					g[206] = 10.3000000000; fxg[206] = 0.1270000000; feg[206] = 0.0089000000;
					g[207] = 10.3500000000; fxg[207] = 0.1243000000; feg[207] = 0.0088000000;
					g[208] = 10.4000000000; fxg[208] = 0.1215000000; feg[208] = 0.0087000000;
					g[209] = 10.4500000000; fxg[209] = 0.1188000000; feg[209] = 0.0087000000;
					g[210] = 10.5000000000; fxg[210] = 0.1163000000; feg[210] = 0.0086000000;
					g[211] = 10.5500000000; fxg[211] = 0.1139000000; feg[211] = 0.0085000000;
					g[212] = 10.6000000000; fxg[212] = 0.1119000000; feg[212] = 0.0084000000;
					g[213] = 10.6500000000; fxg[213] = 0.1102000000; feg[213] = 0.0083000000;
					g[214] = 10.7000000000; fxg[214] = 0.1088000000; feg[214] = 0.0083000000;
					g[215] = 10.7500000000; fxg[215] = 0.1078000000; feg[215] = 0.0082000000;
					g[216] = 10.8000000000; fxg[216] = 0.1072000000; feg[216] = 0.0081000000;
					g[217] = 10.8500000000; fxg[217] = 0.1068000000; feg[217] = 0.0080000000;
					g[218] = 10.9000000000; fxg[218] = 0.1065000000; feg[218] = 0.0080000000;
					g[219] = 10.9500000000; fxg[219] = 0.1063000000; feg[219] = 0.0079000000;
					g[220] = 11.0000000000; fxg[220] = 0.1059000000; feg[220] = 0.0078000000;
					g[221] = 11.0500000000; fxg[221] = 0.1054000000; feg[221] = 0.0078000000;
					g[222] = 11.1000000000; fxg[222] = 0.1046000000; feg[222] = 0.0077000000;
					g[223] = 11.1500000000; fxg[223] = 0.1034000000; feg[223] = 0.0076000000;
					g[224] = 11.2000000000; fxg[224] = 0.1019000000; feg[224] = 0.0076000000;
					g[225] = 11.2500000000; fxg[225] = 0.1001000000; feg[225] = 0.0075000000;
					g[226] = 11.3000000000; fxg[226] = 0.0981000000; feg[226] = 0.0074000000;
					g[227] = 11.3500000000; fxg[227] = 0.0959000000; feg[227] = 0.0074000000;
					g[228] = 11.4000000000; fxg[228] = 0.0936000000; feg[228] = 0.0073000000;
					g[229] = 11.4500000000; fxg[229] = 0.0913000000; feg[229] = 0.0072000000;
					g[230] = 11.5000000000; fxg[230] = 0.0889000000; feg[230] = 0.0072000000;
					g[231] = 11.5500000000; fxg[231] = 0.0866000000; feg[231] = 0.0071000000;
					g[232] = 11.6000000000; fxg[232] = 0.0844000000; feg[232] = 0.0071000000;
					g[233] = 11.6500000000; fxg[233] = 0.0824000000; feg[233] = 0.0070000000;
					g[234] = 11.7000000000; fxg[234] = 0.0806000000; feg[234] = 0.0069000000;
					g[235] = 11.7500000000; fxg[235] = 0.0792000000; feg[235] = 0.0069000000;
					g[236] = 11.8000000000; fxg[236] = 0.0781000000; feg[236] = 0.0068000000;
					g[237] = 11.8500000000; fxg[237] = 0.0774000000; feg[237] = 0.0068000000;
					g[238] = 11.9000000000; fxg[238] = 0.0772000000; feg[238] = 0.0067000000;
					g[239] = 11.9500000000; fxg[239] = 0.0772000000; feg[239] = 0.0067000000;
					g[240] = 12.0000000000; fxg[240] = 0.0776000000; feg[240] = 0.0066000000;
					break;
				case 11:
					g[0] = 0.0000000000; fxg[0] = 11.0000000000; feg[0] = 4.7795110000;
					g[1] = 0.0500000000; fxg[1] = 10.8798000000; feg[1] = 4.6016000000;
					g[2] = 0.1000000000; fxg[2] = 10.5678000000; feg[2] = 4.1381000000;
					g[3] = 0.1500000000; fxg[3] = 10.1667000000; feg[3] = 3.5457000000;
					g[4] = 0.2000000000; fxg[4] = 9.7601000000; feg[4] = 2.9674000000;
					g[5] = 0.2500000000; fxg[5] = 9.3812000000; feg[5] = 2.4797000000;
					g[6] = 0.3000000000; fxg[6] = 9.0267000000; feg[6] = 2.0990000000;
					g[7] = 0.3500000000; fxg[7] = 8.6821000000; feg[7] = 1.8114000000;
					g[8] = 0.4000000000; fxg[8] = 8.3354000000; feg[8] = 1.5943000000;
					g[9] = 0.4500000000; fxg[9] = 7.9810000000; feg[9] = 1.4273000000;
					g[10] = 0.5000000000; fxg[10] = 7.6184000000; feg[10] = 1.2949000000;
					g[11] = 0.5500000000; fxg[11] = 7.2504000000; feg[11] = 1.1867000000;
					g[12] = 0.6000000000; fxg[12] = 6.8811000000; feg[12] = 1.0953000000;
					g[13] = 0.6500000000; fxg[13] = 6.5148000000; feg[13] = 1.0163000000;
					g[14] = 0.7000000000; fxg[14] = 6.1556000000; feg[14] = 0.9465000000;
					g[15] = 0.7500000000; fxg[15] = 5.8068000000; feg[15] = 0.8839000000;
					g[16] = 0.8000000000; fxg[16] = 5.4713000000; feg[16] = 0.8270000000;
					g[17] = 0.8500000000; fxg[17] = 5.1510000000; feg[17] = 0.7750000000;
					g[18] = 0.9000000000; fxg[18] = 4.8474000000; feg[18] = 0.7272000000;
					g[19] = 0.9500000000; fxg[19] = 4.5613000000; feg[19] = 0.6830000000;
					g[20] = 1.0000000000; fxg[20] = 4.2932000000; feg[20] = 0.6421000000;
					g[21] = 1.0500000000; fxg[21] = 4.0431000000; feg[21] = 0.6041000000;
					g[22] = 1.1000000000; fxg[22] = 3.8108000000; feg[22] = 0.5688000000;
					g[23] = 1.1500000000; fxg[23] = 3.5958000000; feg[23] = 0.5360000000;
					g[24] = 1.2000000000; fxg[24] = 3.3974000000; feg[24] = 0.5054000000;
					g[25] = 1.2500000000; fxg[25] = 3.2148000000; feg[25] = 0.4770000000;
					g[26] = 1.3000000000; fxg[26] = 3.0472000000; feg[26] = 0.4505000000;
					g[27] = 1.3500000000; fxg[27] = 2.8938000000; feg[27] = 0.4258000000;
					g[28] = 1.4000000000; fxg[28] = 2.7534000000; feg[28] = 0.4028000000;
					g[29] = 1.4500000000; fxg[29] = 2.6253000000; feg[29] = 0.3813000000;
					g[30] = 1.5000000000; fxg[30] = 2.5084000000; feg[30] = 0.3613000000;
					g[31] = 1.5500000000; fxg[31] = 2.4019000000; feg[31] = 0.3426000000;
					g[32] = 1.6000000000; fxg[32] = 2.3049000000; feg[32] = 0.3252000000;
					g[33] = 1.6500000000; fxg[33] = 2.2167000000; feg[33] = 0.3089000000;
					g[34] = 1.7000000000; fxg[34] = 2.1364000000; feg[34] = 0.2936000000;
					g[35] = 1.7500000000; fxg[35] = 2.0632000000; feg[35] = 0.2794000000;
					g[36] = 1.8000000000; fxg[36] = 1.9968000000; feg[36] = 0.2660000000;
					g[37] = 1.8500000000; fxg[37] = 1.9361000000; feg[37] = 0.2535000000;
					g[38] = 1.9000000000; fxg[38] = 1.8807000000; feg[38] = 0.2418000000;
					g[39] = 1.9500000000; fxg[39] = 1.8301000000; feg[39] = 0.2309000000;
					g[40] = 2.0000000000; fxg[40] = 1.7841000000; feg[40] = 0.2206000000;
					g[41] = 2.0500000000; fxg[41] = 1.7418000000; feg[41] = 0.2109000000;
					g[42] = 2.1000000000; fxg[42] = 1.7027000000; feg[42] = 0.2018000000;
					g[43] = 2.1500000000; fxg[43] = 1.6668000000; feg[43] = 0.1933000000;
					g[44] = 2.2000000000; fxg[44] = 1.6341000000; feg[44] = 0.1853000000;
					g[45] = 2.2500000000; fxg[45] = 1.6037000000; feg[45] = 0.1777000000;
					g[46] = 2.3000000000; fxg[46] = 1.5750000000; feg[46] = 0.1706000000;
					g[47] = 2.3500000000; fxg[47] = 1.5482000000; feg[47] = 0.1639000000;
					g[48] = 2.4000000000; fxg[48] = 1.5235000000; feg[48] = 0.1575000000;
					g[49] = 2.4500000000; fxg[49] = 1.5007000000; feg[49] = 0.1515000000;
					g[50] = 2.5000000000; fxg[50] = 1.4789000000; feg[50] = 0.1458000000;
					g[51] = 2.5500000000; fxg[51] = 1.4577000000; feg[51] = 0.1405000000;
					g[52] = 2.6000000000; fxg[52] = 1.4374000000; feg[52] = 0.1354000000;
					g[53] = 2.6500000000; fxg[53] = 1.4187000000; feg[53] = 0.1306000000;
					g[54] = 2.7000000000; fxg[54] = 1.4013000000; feg[54] = 0.1261000000;
					g[55] = 2.7500000000; fxg[55] = 1.3843000000; feg[55] = 0.1217000000;
					g[56] = 2.8000000000; fxg[56] = 1.3671000000; feg[56] = 0.1176000000;
					g[57] = 2.8500000000; fxg[57] = 1.3501000000; feg[57] = 0.1137000000;
					g[58] = 2.9000000000; fxg[58] = 1.3339000000; feg[58] = 0.1100000000;
					g[59] = 2.9500000000; fxg[59] = 1.3189000000; feg[59] = 0.1065000000;
					g[60] = 3.0000000000; fxg[60] = 1.3047000000; feg[60] = 0.1031000000;
					g[61] = 3.0500000000; fxg[61] = 1.2902000000; feg[61] = 0.0999000000;
					g[62] = 3.1000000000; fxg[62] = 1.2751000000; feg[62] = 0.0969000000;
					g[63] = 3.1500000000; fxg[63] = 1.2598000000; feg[63] = 0.0940000000;
					g[64] = 3.2000000000; fxg[64] = 1.2451000000; feg[64] = 0.0912000000;
					g[65] = 3.2500000000; fxg[65] = 1.2315000000; feg[65] = 0.0885000000;
					g[66] = 3.3000000000; fxg[66] = 1.2187000000; feg[66] = 0.0860000000;
					g[67] = 3.3500000000; fxg[67] = 1.2057000000; feg[67] = 0.0836000000;
					g[68] = 3.4000000000; fxg[68] = 1.1919000000; feg[68] = 0.0812000000;
					g[69] = 3.4500000000; fxg[69] = 1.1774000000; feg[69] = 0.0790000000;
					g[70] = 3.5000000000; fxg[70] = 1.1630000000; feg[70] = 0.0769000000;
					g[71] = 3.5500000000; fxg[71] = 1.1492000000; feg[71] = 0.0748000000;
					g[72] = 3.6000000000; fxg[72] = 1.1365000000; feg[72] = 0.0729000000;
					g[73] = 3.6500000000; fxg[73] = 1.1244000000; feg[73] = 0.0710000000;
					g[74] = 3.7000000000; fxg[74] = 1.1120000000; feg[74] = 0.0691000000;
					g[75] = 3.7500000000; fxg[75] = 1.0988000000; feg[75] = 0.0674000000;
					g[76] = 3.8000000000; fxg[76] = 1.0848000000; feg[76] = 0.0657000000;
					g[77] = 3.8500000000; fxg[77] = 1.0708000000; feg[77] = 0.0641000000;
					g[78] = 3.9000000000; fxg[78] = 1.0570000000; feg[78] = 0.0626000000;
					g[79] = 3.9500000000; fxg[79] = 1.0441000000; feg[79] = 0.0611000000;
					g[80] = 4.0000000000; fxg[80] = 1.0323000000; feg[80] = 0.0596000000;
					g[81] = 4.0500000000; fxg[81] = 1.0208000000; feg[81] = 0.0582000000;
					g[82] = 4.1000000000; fxg[82] = 1.0086000000; feg[82] = 0.0569000000;
					g[83] = 4.1500000000; fxg[83] = 0.9956000000; feg[83] = 0.0556000000;
					g[84] = 4.2000000000; fxg[84] = 0.9822000000; feg[84] = 0.0544000000;
					g[85] = 4.2500000000; fxg[85] = 0.9687000000; feg[85] = 0.0532000000;
					g[86] = 4.3000000000; fxg[86] = 0.9554000000; feg[86] = 0.0520000000;
					g[87] = 4.3500000000; fxg[87] = 0.9427000000; feg[87] = 0.0509000000;
					g[88] = 4.4000000000; fxg[88] = 0.9311000000; feg[88] = 0.0498000000;
					g[89] = 4.4500000000; fxg[89] = 0.9203000000; feg[89] = 0.0487000000;
					g[90] = 4.5000000000; fxg[90] = 0.9091000000; feg[90] = 0.0477000000;
					g[91] = 4.5500000000; fxg[91] = 0.8971000000; feg[91] = 0.0467000000;
					g[92] = 4.6000000000; fxg[92] = 0.8845000000; feg[92] = 0.0458000000;
					g[93] = 4.6500000000; fxg[93] = 0.8719000000; feg[93] = 0.0448000000;
					g[94] = 4.7000000000; fxg[94] = 0.8594000000; feg[94] = 0.0439000000;
					g[95] = 4.7500000000; fxg[95] = 0.8469000000; feg[95] = 0.0431000000;
					g[96] = 4.8000000000; fxg[96] = 0.8347000000; feg[96] = 0.0422000000;
					g[97] = 4.8500000000; fxg[97] = 0.8236000000; feg[97] = 0.0414000000;
					g[98] = 4.9000000000; fxg[98] = 0.8136000000; feg[98] = 0.0406000000;
					g[99] = 4.9500000000; fxg[99] = 0.8037000000; feg[99] = 0.0398000000;
					g[100] = 5.0000000000; fxg[100] = 0.7928000000; feg[100] = 0.0391000000;
					g[101] = 5.0500000000; fxg[101] = 0.7812000000; feg[101] = 0.0384000000;
					g[102] = 5.1000000000; fxg[102] = 0.7696000000; feg[102] = 0.0377000000;
					g[103] = 5.1500000000; fxg[103] = 0.7583000000; feg[103] = 0.0370000000;
					g[104] = 5.2000000000; fxg[104] = 0.7471000000; feg[104] = 0.0363000000;
					g[105] = 5.2500000000; fxg[105] = 0.7357000000; feg[105] = 0.0357000000;
					g[106] = 5.3000000000; fxg[106] = 0.7244000000; feg[106] = 0.0350000000;
					g[107] = 5.3500000000; fxg[107] = 0.7141000000; feg[107] = 0.0344000000;
					g[108] = 5.4000000000; fxg[108] = 0.7051000000; feg[108] = 0.0338000000;
					g[109] = 5.4500000000; fxg[109] = 0.6965000000; feg[109] = 0.0332000000;
					g[110] = 5.5000000000; fxg[110] = 0.6872000000; feg[110] = 0.0326000000;
					g[111] = 5.5500000000; fxg[111] = 0.6768000000; feg[111] = 0.0321000000;
					g[112] = 5.6000000000; fxg[112] = 0.6662000000; feg[112] = 0.0315000000;
					g[113] = 5.6500000000; fxg[113] = 0.6560000000; feg[113] = 0.0310000000;
					g[114] = 5.7000000000; fxg[114] = 0.6465000000; feg[114] = 0.0305000000;
					g[115] = 5.7500000000; fxg[115] = 0.6368000000; feg[115] = 0.0300000000;
					g[116] = 5.8000000000; fxg[116] = 0.6267000000; feg[116] = 0.0295000000;
					g[117] = 5.8500000000; fxg[117] = 0.6165000000; feg[117] = 0.0290000000;
					g[118] = 5.9000000000; fxg[118] = 0.6072000000; feg[118] = 0.0286000000;
					g[119] = 5.9500000000; fxg[119] = 0.5991000000; feg[119] = 0.0281000000;
					g[120] = 6.0000000000; fxg[120] = 0.5919000000; feg[120] = 0.0277000000;
					g[121] = 6.0500000000; fxg[121] = 0.5844000000; feg[121] = 0.0272000000;
					g[122] = 6.1000000000; fxg[122] = 0.5758000000; feg[122] = 0.0268000000;
					g[123] = 6.1500000000; fxg[123] = 0.5664000000; feg[123] = 0.0264000000;
					g[124] = 6.2000000000; fxg[124] = 0.5571000000; feg[124] = 0.0260000000;
					g[125] = 6.2500000000; fxg[125] = 0.5486000000; feg[125] = 0.0256000000;
					g[126] = 6.3000000000; fxg[126] = 0.5408000000; feg[126] = 0.0252000000;
					g[127] = 6.3500000000; fxg[127] = 0.5329000000; feg[127] = 0.0249000000;
					g[128] = 6.4000000000; fxg[128] = 0.5243000000; feg[128] = 0.0245000000;
					g[129] = 6.4500000000; fxg[129] = 0.5155000000; feg[129] = 0.0241000000;
					g[130] = 6.5000000000; fxg[130] = 0.5070000000; feg[130] = 0.0238000000;
					g[131] = 6.5500000000; fxg[131] = 0.4997000000; feg[131] = 0.0234000000;
					g[132] = 6.6000000000; fxg[132] = 0.4936000000; feg[132] = 0.0231000000;
					g[133] = 6.6500000000; fxg[133] = 0.4879000000; feg[133] = 0.0228000000;
					g[134] = 6.7000000000; fxg[134] = 0.4816000000; feg[134] = 0.0224000000;
					g[135] = 6.7500000000; fxg[135] = 0.4741000000; feg[135] = 0.0221000000;
					g[136] = 6.8000000000; fxg[136] = 0.4658000000; feg[136] = 0.0218000000;
					g[137] = 6.8500000000; fxg[137] = 0.4579000000; feg[137] = 0.0215000000;
					g[138] = 6.9000000000; fxg[138] = 0.4509000000; feg[138] = 0.0212000000;
					g[139] = 6.9500000000; fxg[139] = 0.4447000000; feg[139] = 0.0209000000;
					g[140] = 7.0000000000; fxg[140] = 0.4385000000; feg[140] = 0.0206000000;
					g[141] = 7.0500000000; fxg[141] = 0.4318000000; feg[141] = 0.0204000000;
					g[142] = 7.1000000000; fxg[142] = 0.4244000000; feg[142] = 0.0201000000;
					g[143] = 7.1500000000; fxg[143] = 0.4170000000; feg[143] = 0.0198000000;
					g[144] = 7.2000000000; fxg[144] = 0.4102000000; feg[144] = 0.0196000000;
					g[145] = 7.2500000000; fxg[145] = 0.4045000000; feg[145] = 0.0193000000;
					g[146] = 7.3000000000; fxg[146] = 0.4000000000; feg[146] = 0.0190000000;
					g[147] = 7.3500000000; fxg[147] = 0.3957000000; feg[147] = 0.0188000000;
					g[148] = 7.4000000000; fxg[148] = 0.3908000000; feg[148] = 0.0185000000;
					g[149] = 7.4500000000; fxg[149] = 0.3847000000; feg[149] = 0.0183000000;
					g[150] = 7.5000000000; fxg[150] = 0.3779000000; feg[150] = 0.0181000000;
					g[151] = 7.5500000000; fxg[151] = 0.3710000000; feg[151] = 0.0179000000;
					g[152] = 7.6000000000; fxg[152] = 0.3649000000; feg[152] = 0.0176000000;
					g[153] = 7.6500000000; fxg[153] = 0.3599000000; feg[153] = 0.0174000000;
					g[154] = 7.7000000000; fxg[154] = 0.3554000000; feg[154] = 0.0172000000;
					g[155] = 7.7500000000; fxg[155] = 0.3505000000; feg[155] = 0.0170000000;
					g[156] = 7.8000000000; fxg[156] = 0.3450000000; feg[156] = 0.0168000000;
					g[157] = 7.8500000000; fxg[157] = 0.3390000000; feg[157] = 0.0166000000;
					g[158] = 7.9000000000; fxg[158] = 0.3329000000; feg[158] = 0.0164000000;
					g[159] = 7.9500000000; fxg[159] = 0.3273000000; feg[159] = 0.0162000000;
					g[160] = 8.0000000000; fxg[160] = 0.3226000000; feg[160] = 0.0160000000;
					g[161] = 8.0500000000; fxg[161] = 0.3191000000; feg[161] = 0.0158000000;
					g[162] = 8.1000000000; fxg[162] = 0.3162000000; feg[162] = 0.0156000000;
					g[163] = 8.1500000000; fxg[163] = 0.3129000000; feg[163] = 0.0154000000;
					g[164] = 8.2000000000; fxg[164] = 0.3088000000; feg[164] = 0.0152000000;
					g[165] = 8.2500000000; fxg[165] = 0.3036000000; feg[165] = 0.0150000000;
					g[166] = 8.3000000000; fxg[166] = 0.2979000000; feg[166] = 0.0149000000;
					g[167] = 8.3500000000; fxg[167] = 0.2923000000; feg[167] = 0.0147000000;
					g[168] = 8.4000000000; fxg[168] = 0.2875000000; feg[168] = 0.0145000000;
					g[169] = 8.4500000000; fxg[169] = 0.2838000000; feg[169] = 0.0144000000;
					g[170] = 8.5000000000; fxg[170] = 0.2804000000; feg[170] = 0.0142000000;
					g[171] = 8.5500000000; fxg[171] = 0.2768000000; feg[171] = 0.0140000000;
					g[172] = 8.6000000000; fxg[172] = 0.2727000000; feg[172] = 0.0139000000;
					g[173] = 8.6500000000; fxg[173] = 0.2681000000; feg[173] = 0.0137000000;
					g[174] = 8.7000000000; fxg[174] = 0.2633000000; feg[174] = 0.0136000000;
					g[175] = 8.7500000000; fxg[175] = 0.2586000000; feg[175] = 0.0134000000;
					g[176] = 8.8000000000; fxg[176] = 0.2543000000; feg[176] = 0.0133000000;
					g[177] = 8.8500000000; fxg[177] = 0.2510000000; feg[177] = 0.0131000000;
					g[178] = 8.9000000000; fxg[178] = 0.2487000000; feg[178] = 0.0130000000;
					g[179] = 8.9500000000; fxg[179] = 0.2469000000; feg[179] = 0.0129000000;
					g[180] = 9.0000000000; fxg[180] = 0.2448000000; feg[180] = 0.0127000000;
					g[181] = 9.0500000000; fxg[181] = 0.2419000000; feg[181] = 0.0126000000;
					g[182] = 9.1000000000; fxg[182] = 0.2382000000; feg[182] = 0.0124000000;
					g[183] = 9.1500000000; fxg[183] = 0.2337000000; feg[183] = 0.0123000000;
					g[184] = 9.2000000000; fxg[184] = 0.2290000000; feg[184] = 0.0122000000;
					g[185] = 9.2500000000; fxg[185] = 0.2247000000; feg[185] = 0.0121000000;
					g[186] = 9.3000000000; fxg[186] = 0.2214000000; feg[186] = 0.0119000000;
					g[187] = 9.3500000000; fxg[187] = 0.2188000000; feg[187] = 0.0118000000;
					g[188] = 9.4000000000; fxg[188] = 0.2164000000; feg[188] = 0.0117000000;
					g[189] = 9.4500000000; fxg[189] = 0.2136000000; feg[189] = 0.0116000000;
					g[190] = 9.5000000000; fxg[190] = 0.2103000000; feg[190] = 0.0114000000;
					g[191] = 9.5500000000; fxg[191] = 0.2068000000; feg[191] = 0.0113000000;
					g[192] = 9.6000000000; fxg[192] = 0.2032000000; feg[192] = 0.0112000000;
					g[193] = 9.6500000000; fxg[193] = 0.1995000000; feg[193] = 0.0111000000;
					g[194] = 9.7000000000; fxg[194] = 0.1961000000; feg[194] = 0.0110000000;
					g[195] = 9.7500000000; fxg[195] = 0.1932000000; feg[195] = 0.0109000000;
					g[196] = 9.8000000000; fxg[196] = 0.1913000000; feg[196] = 0.0108000000;
					g[197] = 9.8500000000; fxg[197] = 0.1902000000; feg[197] = 0.0107000000;
					g[198] = 9.9000000000; fxg[198] = 0.1893000000; feg[198] = 0.0106000000;
					g[199] = 9.9500000000; fxg[199] = 0.1880000000; feg[199] = 0.0105000000;
					g[200] = 10.0000000000; fxg[200] = 0.1860000000; feg[200] = 0.0104000000;
					g[201] = 10.0500000000; fxg[201] = 0.1833000000; feg[201] = 0.0103000000;
					g[202] = 10.1000000000; fxg[202] = 0.1801000000; feg[202] = 0.0102000000;
					g[203] = 10.1500000000; fxg[203] = 0.1763000000; feg[203] = 0.0101000000;
					g[204] = 10.2000000000; fxg[204] = 0.1727000000; feg[204] = 0.0100000000;
					g[205] = 10.2500000000; fxg[205] = 0.1696000000; feg[205] = 0.0099000000;
					g[206] = 10.3000000000; fxg[206] = 0.1675000000; feg[206] = 0.0098000000;
					g[207] = 10.3500000000; fxg[207] = 0.1658000000; feg[207] = 0.0097000000;
					g[208] = 10.4000000000; fxg[208] = 0.1639000000; feg[208] = 0.0096000000;
					g[209] = 10.4500000000; fxg[209] = 0.1616000000; feg[209] = 0.0095000000;
					g[210] = 10.5000000000; fxg[210] = 0.1588000000; feg[210] = 0.0094000000;
					g[211] = 10.5500000000; fxg[211] = 0.1561000000; feg[211] = 0.0093000000;
					g[212] = 10.6000000000; fxg[212] = 0.1534000000; feg[212] = 0.0092000000;
					g[213] = 10.6500000000; fxg[213] = 0.1508000000; feg[213] = 0.0092000000;
					g[214] = 10.7000000000; fxg[214] = 0.1481000000; feg[214] = 0.0091000000;
					g[215] = 10.7500000000; fxg[215] = 0.1458000000; feg[215] = 0.0090000000;
					g[216] = 10.8000000000; fxg[216] = 0.1442000000; feg[216] = 0.0089000000;
					g[217] = 10.8500000000; fxg[217] = 0.1434000000; feg[217] = 0.0088000000;
					g[218] = 10.9000000000; fxg[218] = 0.1432000000; feg[218] = 0.0087000000;
					g[219] = 10.9500000000; fxg[219] = 0.1431000000; feg[219] = 0.0087000000;
					g[220] = 11.0000000000; fxg[220] = 0.1424000000; feg[220] = 0.0086000000;
					g[221] = 11.0500000000; fxg[221] = 0.1411000000; feg[221] = 0.0085000000;
					g[222] = 11.1000000000; fxg[222] = 0.1394000000; feg[222] = 0.0084000000;
					g[223] = 11.1500000000; fxg[223] = 0.1371000000; feg[223] = 0.0084000000;
					g[224] = 11.2000000000; fxg[224] = 0.1344000000; feg[224] = 0.0083000000;
					g[225] = 11.2500000000; fxg[225] = 0.1313000000; feg[225] = 0.0082000000;
					g[226] = 11.3000000000; fxg[226] = 0.1286000000; feg[226] = 0.0082000000;
					g[227] = 11.3500000000; fxg[227] = 0.1265000000; feg[227] = 0.0081000000;
					g[228] = 11.4000000000; fxg[228] = 0.1250000000; feg[228] = 0.0080000000;
					g[229] = 11.4500000000; fxg[229] = 0.1238000000; feg[229] = 0.0079000000;
					g[230] = 11.5000000000; fxg[230] = 0.1222000000; feg[230] = 0.0079000000;
					g[231] = 11.5500000000; fxg[231] = 0.1202000000; feg[231] = 0.0078000000;
					g[232] = 11.6000000000; fxg[232] = 0.1178000000; feg[232] = 0.0077000000;
					g[233] = 11.6500000000; fxg[233] = 0.1155000000; feg[233] = 0.0077000000;
					g[234] = 11.7000000000; fxg[234] = 0.1135000000; feg[234] = 0.0076000000;
					g[235] = 11.7500000000; fxg[235] = 0.1117000000; feg[235] = 0.0076000000;
					g[236] = 11.8000000000; fxg[236] = 0.1098000000; feg[236] = 0.0075000000;
					g[237] = 11.8500000000; fxg[237] = 0.1080000000; feg[237] = 0.0074000000;
					g[238] = 11.9000000000; fxg[238] = 0.1066000000; feg[238] = 0.0074000000;
					g[239] = 11.9500000000; fxg[239] = 0.1059000000; feg[239] = 0.0073000000;
					g[240] = 12.0000000000; fxg[240] = 0.1059000000; feg[240] = 0.0072000000;
					break;
				case 12:
					g[0] = 0.0000000000; fxg[0] = 12.0000000000; feg[0] = 5.2091220000;
					g[1] = 0.0500000000; fxg[1] = 11.8674000000; feg[1] = 5.0776000000;
					g[2] = 0.1000000000; fxg[2] = 11.5073000000; feg[2] = 4.7170000000;
					g[3] = 0.1500000000; fxg[3] = 11.0102000000; feg[3] = 4.2116000000;
					g[4] = 0.2000000000; fxg[4] = 10.4723000000; feg[4] = 3.6562000000;
					g[5] = 0.2500000000; fxg[5] = 9.9602000000; feg[5] = 3.1245000000;
					g[6] = 0.3000000000; fxg[6] = 9.5019000000; feg[6] = 2.6573000000;
					g[7] = 0.3500000000; fxg[7] = 9.0979000000; feg[7] = 2.2680000000;
					g[8] = 0.4000000000; fxg[8] = 8.7355000000; feg[8] = 1.9533000000;
					g[9] = 0.4500000000; fxg[9] = 8.3996000000; feg[9] = 1.7022000000;
					g[10] = 0.5000000000; fxg[10] = 8.0777000000; feg[10] = 1.5020000000;
					g[11] = 0.5500000000; fxg[11] = 7.7615000000; feg[11] = 1.3414000000;
					g[12] = 0.6000000000; fxg[12] = 7.4466000000; feg[12] = 1.2109000000;
					g[13] = 0.6500000000; fxg[13] = 7.1316000000; feg[13] = 1.1031000000;
					g[14] = 0.7000000000; fxg[14] = 6.8169000000; feg[14] = 1.0127000000;
					g[15] = 0.7500000000; fxg[15] = 6.5038000000; feg[15] = 0.9354000000;
					g[16] = 0.8000000000; fxg[16] = 6.1945000000; feg[16] = 0.8684000000;
					g[17] = 0.8500000000; fxg[17] = 5.8910000000; feg[17] = 0.8095000000;
					g[18] = 0.9000000000; fxg[18] = 5.5952000000; feg[18] = 0.7570000000;
					g[19] = 0.9500000000; fxg[19] = 5.3089000000; feg[19] = 0.7098000000;
					g[20] = 1.0000000000; fxg[20] = 5.0336000000; feg[20] = 0.6669000000;
					g[21] = 1.0500000000; fxg[21] = 4.7702000000; feg[21] = 0.6278000000;
					g[22] = 1.1000000000; fxg[22] = 4.5196000000; feg[22] = 0.5918000000;
					g[23] = 1.1500000000; fxg[23] = 4.2823000000; feg[23] = 0.5587000000;
					g[24] = 1.2000000000; fxg[24] = 4.0585000000; feg[24] = 0.5280000000;
					g[25] = 1.2500000000; fxg[25] = 3.8483000000; feg[25] = 0.4995000000;
					g[26] = 1.3000000000; fxg[26] = 3.6514000000; feg[26] = 0.4729000000;
					g[27] = 1.3500000000; fxg[27] = 3.4676000000; feg[27] = 0.4482000000;
					g[28] = 1.4000000000; fxg[28] = 3.2965000000; feg[28] = 0.4251000000;
					g[29] = 1.4500000000; fxg[29] = 3.1376000000; feg[29] = 0.4035000000;
					g[30] = 1.5000000000; fxg[30] = 2.9903000000; feg[30] = 0.3834000000;
					g[31] = 1.5500000000; fxg[31] = 2.8541000000; feg[31] = 0.3644000000;
					g[32] = 1.6000000000; fxg[32] = 2.7283000000; feg[32] = 0.3467000000;
					g[33] = 1.6500000000; fxg[33] = 2.6122000000; feg[33] = 0.3301000000;
					g[34] = 1.7000000000; fxg[34] = 2.5053000000; feg[34] = 0.3145000000;
					g[35] = 1.7500000000; fxg[35] = 2.4069000000; feg[35] = 0.2999000000;
					g[36] = 1.8000000000; fxg[36] = 2.3164000000; feg[36] = 0.2861000000;
					g[37] = 1.8500000000; fxg[37] = 2.2332000000; feg[37] = 0.2732000000;
					g[38] = 1.9000000000; fxg[38] = 2.1567000000; feg[38] = 0.2610000000;
					g[39] = 1.9500000000; fxg[39] = 2.0865000000; feg[39] = 0.2496000000;
					g[40] = 2.0000000000; fxg[40] = 2.0220000000; feg[40] = 0.2388000000;
					g[41] = 2.0500000000; fxg[41] = 1.9627000000; feg[41] = 0.2287000000;
					g[42] = 2.1000000000; fxg[42] = 1.9081000000; feg[42] = 0.2191000000;
					g[43] = 2.1500000000; fxg[43] = 1.8579000000; feg[43] = 0.2100000000;
					g[44] = 2.2000000000; fxg[44] = 1.8118000000; feg[44] = 0.2015000000;
					g[45] = 2.2500000000; fxg[45] = 1.7692000000; feg[45] = 0.1935000000;
					g[46] = 2.3000000000; fxg[46] = 1.7297000000; feg[46] = 0.1859000000;
					g[47] = 2.3500000000; fxg[47] = 1.6932000000; feg[47] = 0.1787000000;
					g[48] = 2.4000000000; fxg[48] = 1.6595000000; feg[48] = 0.1719000000;
					g[49] = 2.4500000000; fxg[49] = 1.6284000000; feg[49] = 0.1654000000;
					g[50] = 2.5000000000; fxg[50] = 1.5993000000; feg[50] = 0.1593000000;
					g[51] = 2.5500000000; fxg[51] = 1.5718000000; feg[51] = 0.1535000000;
					g[52] = 2.6000000000; fxg[52] = 1.5461000000; feg[52] = 0.1480000000;
					g[53] = 2.6500000000; fxg[53] = 1.5224000000; feg[53] = 0.1428000000;
					g[54] = 2.7000000000; fxg[54] = 1.5003000000; feg[54] = 0.1379000000;
					g[55] = 2.7500000000; fxg[55] = 1.4793000000; feg[55] = 0.1332000000;
					g[56] = 2.8000000000; fxg[56] = 1.4589000000; feg[56] = 0.1287000000;
					g[57] = 2.8500000000; fxg[57] = 1.4393000000; feg[57] = 0.1245000000;
					g[58] = 2.9000000000; fxg[58] = 1.4209000000; feg[58] = 0.1204000000;
					g[59] = 2.9500000000; fxg[59] = 1.4039000000; feg[59] = 0.1166000000;
					g[60] = 3.0000000000; fxg[60] = 1.3877000000; feg[60] = 0.1129000000;
					g[61] = 3.0500000000; fxg[61] = 1.3718000000; feg[61] = 0.1094000000;
					g[62] = 3.1000000000; fxg[62] = 1.3558000000; feg[62] = 0.1060000000;
					g[63] = 3.1500000000; fxg[63] = 1.3399000000; feg[63] = 0.1029000000;
					g[64] = 3.2000000000; fxg[64] = 1.3249000000; feg[64] = 0.0998000000;
					g[65] = 3.2500000000; fxg[65] = 1.3111000000; feg[65] = 0.0969000000;
					g[66] = 3.3000000000; fxg[66] = 1.2980000000; feg[66] = 0.0941000000;
					g[67] = 3.3500000000; fxg[67] = 1.2849000000; feg[67] = 0.0914000000;
					g[68] = 3.4000000000; fxg[68] = 1.2713000000; feg[68] = 0.0889000000;
					g[69] = 3.4500000000; fxg[69] = 1.2571000000; feg[69] = 0.0864000000;
					g[70] = 3.5000000000; fxg[70] = 1.2432000000; feg[70] = 0.0841000000;
					g[71] = 3.5500000000; fxg[71] = 1.2301000000; feg[71] = 0.0818000000;
					g[72] = 3.6000000000; fxg[72] = 1.2181000000; feg[72] = 0.0796000000;
					g[73] = 3.6500000000; fxg[73] = 1.2068000000; feg[73] = 0.0776000000;
					g[74] = 3.7000000000; fxg[74] = 1.1951000000; feg[74] = 0.0756000000;
					g[75] = 3.7500000000; fxg[75] = 1.1826000000; feg[75] = 0.0736000000;
					g[76] = 3.8000000000; fxg[76] = 1.1693000000; feg[76] = 0.0718000000;
					g[77] = 3.8500000000; fxg[77] = 1.1559000000; feg[77] = 0.0700000000;
					g[78] = 3.9000000000; fxg[78] = 1.1430000000; feg[78] = 0.0683000000;
					g[79] = 3.9500000000; fxg[79] = 1.1312000000; feg[79] = 0.0667000000;
					g[80] = 4.0000000000; fxg[80] = 1.1205000000; feg[80] = 0.0651000000;
					g[81] = 4.0500000000; fxg[81] = 1.1100000000; feg[81] = 0.0636000000;
					g[82] = 4.1000000000; fxg[82] = 1.0989000000; feg[82] = 0.0621000000;
					g[83] = 4.1500000000; fxg[83] = 1.0867000000; feg[83] = 0.0607000000;
					g[84] = 4.2000000000; fxg[84] = 1.0737000000; feg[84] = 0.0593000000;
					g[85] = 4.2500000000; fxg[85] = 1.0605000000; feg[85] = 0.0580000000;
					g[86] = 4.3000000000; fxg[86] = 1.0477000000; feg[86] = 0.0567000000;
					g[87] = 4.3500000000; fxg[87] = 1.0360000000; feg[87] = 0.0555000000;
					g[88] = 4.4000000000; fxg[88] = 1.0255000000; feg[88] = 0.0543000000;
					g[89] = 4.4500000000; fxg[89] = 1.0157000000; feg[89] = 0.0531000000;
					g[90] = 4.5000000000; fxg[90] = 1.0056000000; feg[90] = 0.0520000000;
					g[91] = 4.5500000000; fxg[91] = 0.9945000000; feg[91] = 0.0509000000;
					g[92] = 4.6000000000; fxg[92] = 0.9824000000; feg[92] = 0.0498000000;
					g[93] = 4.6500000000; fxg[93] = 0.9697000000; feg[93] = 0.0488000000;
					g[94] = 4.7000000000; fxg[94] = 0.9568000000; feg[94] = 0.0479000000;
					g[95] = 4.7500000000; fxg[95] = 0.9444000000; feg[95] = 0.0469000000;
					g[96] = 4.8000000000; fxg[96] = 0.9329000000; feg[96] = 0.0460000000;
					g[97] = 4.8500000000; fxg[97] = 0.9227000000; feg[97] = 0.0451000000;
					g[98] = 4.9000000000; fxg[98] = 0.9136000000; feg[98] = 0.0442000000;
					g[99] = 4.9500000000; fxg[99] = 0.9044000000; feg[99] = 0.0434000000;
					g[100] = 5.0000000000; fxg[100] = 0.8944000000; feg[100] = 0.0425000000;
					g[101] = 5.0500000000; fxg[101] = 0.8834000000; feg[101] = 0.0417000000;
					g[102] = 5.1000000000; fxg[102] = 0.8715000000; feg[102] = 0.0410000000;
					g[103] = 5.1500000000; fxg[103] = 0.8595000000; feg[103] = 0.0402000000;
					g[104] = 5.2000000000; fxg[104] = 0.8473000000; feg[104] = 0.0395000000;
					g[105] = 5.2500000000; fxg[105] = 0.8355000000; feg[105] = 0.0388000000;
					g[106] = 5.3000000000; fxg[106] = 0.8245000000; feg[106] = 0.0381000000;
					g[107] = 5.3500000000; fxg[107] = 0.8148000000; feg[107] = 0.0374000000;
					g[108] = 5.4000000000; fxg[108] = 0.8064000000; feg[108] = 0.0367000000;
					g[109] = 5.4500000000; fxg[109] = 0.7983000000; feg[109] = 0.0361000000;
					g[110] = 5.5000000000; fxg[110] = 0.7896000000; feg[110] = 0.0355000000;
					g[111] = 5.5500000000; fxg[111] = 0.7798000000; feg[111] = 0.0349000000;
					g[112] = 5.6000000000; fxg[112] = 0.7691000000; feg[112] = 0.0343000000;
					g[113] = 5.6500000000; fxg[113] = 0.7581000000; feg[113] = 0.0337000000;
					g[114] = 5.7000000000; fxg[114] = 0.7472000000; feg[114] = 0.0332000000;
					g[115] = 5.7500000000; fxg[115] = 0.7362000000; feg[115] = 0.0326000000;
					g[116] = 5.8000000000; fxg[116] = 0.7252000000; feg[116] = 0.0321000000;
					g[117] = 5.8500000000; fxg[117] = 0.7149000000; feg[117] = 0.0316000000;
					g[118] = 5.9000000000; fxg[118] = 0.7058000000; feg[118] = 0.0311000000;
					g[119] = 5.9500000000; fxg[119] = 0.6981000000; feg[119] = 0.0306000000;
					g[120] = 6.0000000000; fxg[120] = 0.6912000000; feg[120] = 0.0301000000;
					g[121] = 6.0500000000; fxg[121] = 0.6841000000; feg[121] = 0.0296000000;
					g[122] = 6.1000000000; fxg[122] = 0.6758000000; feg[122] = 0.0291000000;
					g[123] = 6.1500000000; fxg[123] = 0.6664000000; feg[123] = 0.0287000000;
					g[124] = 6.2000000000; fxg[124] = 0.6566000000; feg[124] = 0.0283000000;
					g[125] = 6.2500000000; fxg[125] = 0.6469000000; feg[125] = 0.0278000000;
					g[126] = 6.3000000000; fxg[126] = 0.6375000000; feg[126] = 0.0274000000;
					g[127] = 6.3500000000; fxg[127] = 0.6280000000; feg[127] = 0.0270000000;
					g[128] = 6.4000000000; fxg[128] = 0.6183000000; feg[128] = 0.0266000000;
					g[129] = 6.4500000000; fxg[129] = 0.6088000000; feg[129] = 0.0262000000;
					g[130] = 6.5000000000; fxg[130] = 0.6001000000; feg[130] = 0.0258000000;
					g[131] = 6.5500000000; fxg[131] = 0.5929000000; feg[131] = 0.0255000000;
					g[132] = 6.6000000000; fxg[132] = 0.5871000000; feg[132] = 0.0251000000;
					g[133] = 6.6500000000; fxg[133] = 0.5816000000; feg[133] = 0.0247000000;
					g[134] = 6.7000000000; fxg[134] = 0.5754000000; feg[134] = 0.0244000000;
					g[135] = 6.7500000000; fxg[135] = 0.5678000000; feg[135] = 0.0240000000;
					g[136] = 6.8000000000; fxg[136] = 0.5593000000; feg[136] = 0.0237000000;
					g[137] = 6.8500000000; fxg[137] = 0.5505000000; feg[137] = 0.0234000000;
					g[138] = 6.9000000000; fxg[138] = 0.5423000000; feg[138] = 0.0230000000;
					g[139] = 6.9500000000; fxg[139] = 0.5347000000; feg[139] = 0.0227000000;
					g[140] = 7.0000000000; fxg[140] = 0.5270000000; feg[140] = 0.0224000000;
					g[141] = 7.0500000000; fxg[141] = 0.5189000000; feg[141] = 0.0221000000;
					g[142] = 7.1000000000; fxg[142] = 0.5104000000; feg[142] = 0.0218000000;
					g[143] = 7.1500000000; fxg[143] = 0.5021000000; feg[143] = 0.0215000000;
					g[144] = 7.2000000000; fxg[144] = 0.4950000000; feg[144] = 0.0212000000;
					g[145] = 7.2500000000; fxg[145] = 0.4893000000; feg[145] = 0.0210000000;
					g[146] = 7.3000000000; fxg[146] = 0.4849000000; feg[146] = 0.0207000000;
					g[147] = 7.3500000000; fxg[147] = 0.4808000000; feg[147] = 0.0204000000;
					g[148] = 7.4000000000; fxg[148] = 0.4759000000; feg[148] = 0.0201000000;
					g[149] = 7.4500000000; fxg[149] = 0.4696000000; feg[149] = 0.0199000000;
					g[150] = 7.5000000000; fxg[150] = 0.4622000000; feg[150] = 0.0196000000;
					g[151] = 7.5500000000; fxg[151] = 0.4544000000; feg[151] = 0.0194000000;
					g[152] = 7.6000000000; fxg[152] = 0.4474000000; feg[152] = 0.0191000000;
					g[153] = 7.6500000000; fxg[153] = 0.4411000000; feg[153] = 0.0189000000;
					g[154] = 7.7000000000; fxg[154] = 0.4354000000; feg[154] = 0.0187000000;
					g[155] = 7.7500000000; fxg[155] = 0.4293000000; feg[155] = 0.0184000000;
					g[156] = 7.8000000000; fxg[156] = 0.4226000000; feg[156] = 0.0182000000;
					g[157] = 7.8500000000; fxg[157] = 0.4154000000; feg[157] = 0.0180000000;
					g[158] = 7.9000000000; fxg[158] = 0.4082000000; feg[158] = 0.0178000000;
					g[159] = 7.9500000000; fxg[159] = 0.4019000000; feg[159] = 0.0176000000;
					g[160] = 8.0000000000; fxg[160] = 0.3971000000; feg[160] = 0.0174000000;
					g[161] = 8.0500000000; fxg[161] = 0.3937000000; feg[161] = 0.0171000000;
					g[162] = 8.1000000000; fxg[162] = 0.3910000000; feg[162] = 0.0169000000;
					g[163] = 8.1500000000; fxg[163] = 0.3878000000; feg[163] = 0.0167000000;
					g[164] = 8.2000000000; fxg[164] = 0.3834000000; feg[164] = 0.0165000000;
					g[165] = 8.2500000000; fxg[165] = 0.3776000000; feg[165] = 0.0163000000;
					g[166] = 8.3000000000; fxg[166] = 0.3709000000; feg[166] = 0.0162000000;
					g[167] = 8.3500000000; fxg[167] = 0.3643000000; feg[167] = 0.0160000000;
					g[168] = 8.4000000000; fxg[168] = 0.3586000000; feg[168] = 0.0158000000;
					g[169] = 8.4500000000; fxg[169] = 0.3540000000; feg[169] = 0.0156000000;
					g[170] = 8.5000000000; fxg[170] = 0.3499000000; feg[170] = 0.0154000000;
					g[171] = 8.5500000000; fxg[171] = 0.3456000000; feg[171] = 0.0153000000;
					g[172] = 8.6000000000; fxg[172] = 0.3406000000; feg[172] = 0.0151000000;
					g[173] = 8.6500000000; fxg[173] = 0.3348000000; feg[173] = 0.0149000000;
					g[174] = 8.7000000000; fxg[174] = 0.3286000000; feg[174] = 0.0148000000;
					g[175] = 8.7500000000; fxg[175] = 0.3227000000; feg[175] = 0.0146000000;
					g[176] = 8.8000000000; fxg[176] = 0.3178000000; feg[176] = 0.0144000000;
					g[177] = 8.8500000000; fxg[177] = 0.3143000000; feg[177] = 0.0143000000;
					g[178] = 8.9000000000; fxg[178] = 0.3121000000; feg[178] = 0.0141000000;
					g[179] = 8.9500000000; fxg[179] = 0.3106000000; feg[179] = 0.0140000000;
					g[180] = 9.0000000000; fxg[180] = 0.3087000000; feg[180] = 0.0138000000;
					g[181] = 9.0500000000; fxg[181] = 0.3056000000; feg[181] = 0.0137000000;
					g[182] = 9.1000000000; fxg[182] = 0.3011000000; feg[182] = 0.0135000000;
					g[183] = 9.1500000000; fxg[183] = 0.2955000000; feg[183] = 0.0134000000;
					g[184] = 9.2000000000; fxg[184] = 0.2897000000; feg[184] = 0.0132000000;
					g[185] = 9.2500000000; fxg[185] = 0.2844000000; feg[185] = 0.0131000000;
					g[186] = 9.3000000000; fxg[186] = 0.2804000000; feg[186] = 0.0130000000;
					g[187] = 9.3500000000; fxg[187] = 0.2774000000; feg[187] = 0.0128000000;
					g[188] = 9.4000000000; fxg[188] = 0.2748000000; feg[188] = 0.0127000000;
					g[189] = 9.4500000000; fxg[189] = 0.2718000000; feg[189] = 0.0126000000;
					g[190] = 9.5000000000; fxg[190] = 0.2680000000; feg[190] = 0.0124000000;
					g[191] = 9.5500000000; fxg[191] = 0.2635000000; feg[191] = 0.0123000000;
					g[192] = 9.6000000000; fxg[192] = 0.2584000000; feg[192] = 0.0122000000;
					g[193] = 9.6500000000; fxg[193] = 0.2534000000; feg[193] = 0.0121000000;
					g[194] = 9.7000000000; fxg[194] = 0.2489000000; feg[194] = 0.0120000000;
					g[195] = 9.7500000000; fxg[195] = 0.2455000000; feg[195] = 0.0118000000;
					g[196] = 9.8000000000; fxg[196] = 0.2435000000; feg[196] = 0.0117000000;
					g[197] = 9.8500000000; fxg[197] = 0.2426000000; feg[197] = 0.0116000000;
					g[198] = 9.9000000000; fxg[198] = 0.2421000000; feg[198] = 0.0115000000;
					g[199] = 9.9500000000; fxg[199] = 0.2411000000; feg[199] = 0.0114000000;
					g[200] = 10.0000000000; fxg[200] = 0.2389000000; feg[200] = 0.0113000000;
					g[201] = 10.0500000000; fxg[201] = 0.2354000000; feg[201] = 0.0112000000;
					g[202] = 10.1000000000; fxg[202] = 0.2307000000; feg[202] = 0.0110000000;
					g[203] = 10.1500000000; fxg[203] = 0.2257000000; feg[203] = 0.0109000000;
					g[204] = 10.2000000000; fxg[204] = 0.2209000000; feg[204] = 0.0108000000;
					g[205] = 10.2500000000; fxg[205] = 0.2173000000; feg[205] = 0.0107000000;
					g[206] = 10.3000000000; fxg[206] = 0.2149000000; feg[206] = 0.0106000000;
					g[207] = 10.3500000000; fxg[207] = 0.2133000000; feg[207] = 0.0105000000;
					g[208] = 10.4000000000; fxg[208] = 0.2117000000; feg[208] = 0.0104000000;
					g[209] = 10.4500000000; fxg[209] = 0.2096000000; feg[209] = 0.0103000000;
					g[210] = 10.5000000000; fxg[210] = 0.2067000000; feg[210] = 0.0102000000;
					g[211] = 10.5500000000; fxg[211] = 0.2032000000; feg[211] = 0.0101000000;
					g[212] = 10.6000000000; fxg[212] = 0.1992000000; feg[212] = 0.0101000000;
					g[213] = 10.6500000000; fxg[213] = 0.1951000000; feg[213] = 0.0100000000;
					g[214] = 10.7000000000; fxg[214] = 0.1912000000; feg[214] = 0.0099000000;
					g[215] = 10.7500000000; fxg[215] = 0.1880000000; feg[215] = 0.0098000000;
					g[216] = 10.8000000000; fxg[216] = 0.1860000000; feg[216] = 0.0097000000;
					g[217] = 10.8500000000; fxg[217] = 0.1853000000; feg[217] = 0.0096000000;
					g[218] = 10.9000000000; fxg[218] = 0.1855000000; feg[218] = 0.0095000000;
					g[219] = 10.9500000000; fxg[219] = 0.1858000000; feg[219] = 0.0094000000;
					g[220] = 11.0000000000; fxg[220] = 0.1854000000; feg[220] = 0.0093000000;
					g[221] = 11.0500000000; fxg[221] = 0.1839000000; feg[221] = 0.0093000000;
					g[222] = 11.1000000000; fxg[222] = 0.1813000000; feg[222] = 0.0092000000;
					g[223] = 11.1500000000; fxg[223] = 0.1776000000; feg[223] = 0.0091000000;
					g[224] = 11.2000000000; fxg[224] = 0.1734000000; feg[224] = 0.0090000000;
					g[225] = 11.2500000000; fxg[225] = 0.1692000000; feg[225] = 0.0089000000;
					g[226] = 11.3000000000; fxg[226] = 0.1657000000; feg[226] = 0.0089000000;
					g[227] = 11.3500000000; fxg[227] = 0.1634000000; feg[227] = 0.0088000000;
					g[228] = 11.4000000000; fxg[228] = 0.1622000000; feg[228] = 0.0087000000;
					g[229] = 11.4500000000; fxg[229] = 0.1615000000; feg[229] = 0.0086000000;
					g[230] = 11.5000000000; fxg[230] = 0.1606000000; feg[230] = 0.0086000000;
					g[231] = 11.5500000000; fxg[231] = 0.1591000000; feg[231] = 0.0085000000;
					g[232] = 11.6000000000; fxg[232] = 0.1568000000; feg[232] = 0.0084000000;
					g[233] = 11.6500000000; fxg[233] = 0.1541000000; feg[233] = 0.0084000000;
					g[234] = 11.7000000000; fxg[234] = 0.1510000000; feg[234] = 0.0083000000;
					g[235] = 11.7500000000; fxg[235] = 0.1478000000; feg[235] = 0.0082000000;
					g[236] = 11.8000000000; fxg[236] = 0.1446000000; feg[236] = 0.0082000000;
					g[237] = 11.8500000000; fxg[237] = 0.1417000000; feg[237] = 0.0081000000;
					g[238] = 11.9000000000; fxg[238] = 0.1396000000; feg[238] = 0.0080000000;
					g[239] = 11.9500000000; fxg[239] = 0.1386000000; feg[239] = 0.0080000000;
					g[240] = 12.0000000000; fxg[240] = 0.1388000000; feg[240] = 0.0079000000;
					break;
				case 13:
					g[0] = 0.0000000000; fxg[0] = 13.0000000000; feg[0] = 5.8898350000;
					g[1] = 0.0500000000; fxg[1] = 12.8498000000; feg[1] = 5.7513000000;
					g[2] = 0.1000000000; fxg[2] = 12.4390000000; feg[2] = 5.3708000000;
					g[3] = 0.1500000000; fxg[3] = 11.8638000000; feg[3] = 4.8343000000;
					g[4] = 0.2000000000; fxg[4] = 11.2295000000; feg[4] = 4.2374000000;
					g[5] = 0.2500000000; fxg[5] = 10.6143000000; feg[5] = 3.6543000000;
					g[6] = 0.3000000000; fxg[6] = 10.0592000000; feg[6] = 3.1282000000;
					g[7] = 0.3500000000; fxg[7] = 9.5758000000; feg[7] = 2.6760000000;
					g[8] = 0.4000000000; fxg[8] = 9.1581000000; feg[8] = 2.2988000000;
					g[9] = 0.4500000000; fxg[9] = 8.7927000000; feg[9] = 1.9891000000;
					g[10] = 0.5000000000; fxg[10] = 8.4648000000; feg[10] = 1.7367000000;
					g[11] = 0.5500000000; fxg[11] = 8.1615000000; feg[11] = 1.5313000000;
					g[12] = 0.6000000000; fxg[12] = 7.8730000000; feg[12] = 1.3634000000;
					g[13] = 0.6500000000; fxg[13] = 7.5925000000; feg[13] = 1.2253000000;
					g[14] = 0.7000000000; fxg[14] = 7.3157000000; feg[14] = 1.1106000000;
					g[15] = 0.7500000000; fxg[15] = 7.0405000000; feg[15] = 1.0143000000;
					g[16] = 0.8000000000; fxg[16] = 6.7663000000; feg[16] = 0.9325000000;
					g[17] = 0.8500000000; fxg[17] = 6.4934000000; feg[17] = 0.8622000000;
					g[18] = 0.9000000000; fxg[18] = 6.2226000000; feg[18] = 0.8010000000;
					g[19] = 0.9500000000; fxg[19] = 5.9552000000; feg[19] = 0.7473000000;
					g[20] = 1.0000000000; fxg[20] = 5.6924000000; feg[20] = 0.6996000000;
					g[21] = 1.0500000000; fxg[21] = 5.4357000000; feg[21] = 0.6568000000;
					g[22] = 1.1000000000; fxg[22] = 5.1861000000; feg[22] = 0.6182000000;
					g[23] = 1.1500000000; fxg[23] = 4.9448000000; feg[23] = 0.5831000000;
					g[24] = 1.2000000000; fxg[24] = 4.7124000000; feg[24] = 0.5510000000;
					g[25] = 1.2500000000; fxg[25] = 4.4896000000; feg[25] = 0.5214000000;
					g[26] = 1.3000000000; fxg[26] = 4.2770000000; feg[26] = 0.4941000000;
					g[27] = 1.3500000000; fxg[27] = 4.0748000000; feg[27] = 0.4688000000;
					g[28] = 1.4000000000; fxg[28] = 3.8831000000; feg[28] = 0.4453000000;
					g[29] = 1.4500000000; fxg[29] = 3.7020000000; feg[29] = 0.4234000000;
					g[30] = 1.5000000000; fxg[30] = 3.5314000000; feg[30] = 0.4029000000;
					g[31] = 1.5500000000; fxg[31] = 3.3709000000; feg[31] = 0.3837000000;
					g[32] = 1.6000000000; fxg[32] = 3.2205000000; feg[32] = 0.3657000000;
					g[33] = 1.6500000000; fxg[33] = 3.0797000000; feg[33] = 0.3488000000;
					g[34] = 1.7000000000; fxg[34] = 2.9482000000; feg[34] = 0.3330000000;
					g[35] = 1.7500000000; fxg[35] = 2.8256000000; feg[35] = 0.3181000000;
					g[36] = 1.8000000000; fxg[36] = 2.7114000000; feg[36] = 0.3040000000;
					g[37] = 1.8500000000; fxg[37] = 2.6052000000; feg[37] = 0.2908000000;
					g[38] = 1.9000000000; fxg[38] = 2.5065000000; feg[38] = 0.2783000000;
					g[39] = 1.9500000000; fxg[39] = 2.4150000000; feg[39] = 0.2665000000;
					g[40] = 2.0000000000; fxg[40] = 2.3301000000; feg[40] = 0.2554000000;
					g[41] = 2.0500000000; fxg[41] = 2.2514000000; feg[41] = 0.2449000000;
					g[42] = 2.1000000000; fxg[42] = 2.1784000000; feg[42] = 0.2349000000;
					g[43] = 2.1500000000; fxg[43] = 2.1109000000; feg[43] = 0.2255000000;
					g[44] = 2.2000000000; fxg[44] = 2.0484000000; feg[44] = 0.2166000000;
					g[45] = 2.2500000000; fxg[45] = 1.9906000000; feg[45] = 0.2082000000;
					g[46] = 2.3000000000; fxg[46] = 1.9368000000; feg[46] = 0.2002000000;
					g[47] = 2.3500000000; fxg[47] = 1.8870000000; feg[47] = 0.1926000000;
					g[48] = 2.4000000000; fxg[48] = 1.8410000000; feg[48] = 0.1855000000;
					g[49] = 2.4500000000; fxg[49] = 1.7984000000; feg[49] = 0.1787000000;
					g[50] = 2.5000000000; fxg[50] = 1.7588000000; feg[50] = 0.1722000000;
					g[51] = 2.5500000000; fxg[51] = 1.7216000000; feg[51] = 0.1660000000;
					g[52] = 2.6000000000; fxg[52] = 1.6871000000; feg[52] = 0.1602000000;
					g[53] = 2.6500000000; fxg[53] = 1.6552000000; feg[53] = 0.1547000000;
					g[54] = 2.7000000000; fxg[54] = 1.6256000000; feg[54] = 0.1494000000;
					g[55] = 2.7500000000; fxg[55] = 1.5979000000; feg[55] = 0.1443000000;
					g[56] = 2.8000000000; fxg[56] = 1.5714000000; feg[56] = 0.1396000000;
					g[57] = 2.8500000000; fxg[57] = 1.5464000000; feg[57] = 0.1350000000;
					g[58] = 2.9000000000; fxg[58] = 1.5231000000; feg[58] = 0.1306000000;
					g[59] = 2.9500000000; fxg[59] = 1.5016000000; feg[59] = 0.1265000000;
					g[60] = 3.0000000000; fxg[60] = 1.4815000000; feg[60] = 0.1225000000;
					g[61] = 3.0500000000; fxg[61] = 1.4621000000; feg[61] = 0.1187000000;
					g[62] = 3.1000000000; fxg[62] = 1.4430000000; feg[62] = 0.1151000000;
					g[63] = 3.1500000000; fxg[63] = 1.4246000000; feg[63] = 0.1117000000;
					g[64] = 3.2000000000; fxg[64] = 1.4074000000; feg[64] = 0.1084000000;
					g[65] = 3.2500000000; fxg[65] = 1.3915000000; feg[65] = 0.1052000000;
					g[66] = 3.3000000000; fxg[66] = 1.3767000000; feg[66] = 0.1022000000;
					g[67] = 3.3500000000; fxg[67] = 1.3622000000; feg[67] = 0.0993000000;
					g[68] = 3.4000000000; fxg[68] = 1.3473000000; feg[68] = 0.0965000000;
					g[69] = 3.4500000000; fxg[69] = 1.3323000000; feg[69] = 0.0938000000;
					g[70] = 3.5000000000; fxg[70] = 1.3178000000; feg[70] = 0.0913000000;
					g[71] = 3.5500000000; fxg[71] = 1.3042000000; feg[71] = 0.0888000000;
					g[72] = 3.6000000000; fxg[72] = 1.2919000000; feg[72] = 0.0865000000;
					g[73] = 3.6500000000; fxg[73] = 1.2803000000; feg[73] = 0.0842000000;
					g[74] = 3.7000000000; fxg[74] = 1.2685000000; feg[74] = 0.0820000000;
					g[75] = 3.7500000000; fxg[75] = 1.2560000000; feg[75] = 0.0800000000;
					g[76] = 3.8000000000; fxg[76] = 1.2429000000; feg[76] = 0.0779000000;
					g[77] = 3.8500000000; fxg[77] = 1.2297000000; feg[77] = 0.0760000000;
					g[78] = 3.9000000000; fxg[78] = 1.2172000000; feg[78] = 0.0742000000;
					g[79] = 3.9500000000; fxg[79] = 1.2059000000; feg[79] = 0.0724000000;
					g[80] = 4.0000000000; fxg[80] = 1.1957000000; feg[80] = 0.0706000000;
					g[81] = 4.0500000000; fxg[81] = 1.1858000000; feg[81] = 0.0690000000;
					g[82] = 4.1000000000; fxg[82] = 1.1752000000; feg[82] = 0.0673000000;
					g[83] = 4.1500000000; fxg[83] = 1.1636000000; feg[83] = 0.0658000000;
					g[84] = 4.2000000000; fxg[84] = 1.1511000000; feg[84] = 0.0643000000;
					g[85] = 4.2500000000; fxg[85] = 1.1385000000; feg[85] = 0.0629000000;
					g[86] = 4.3000000000; fxg[86] = 1.1264000000; feg[86] = 0.0615000000;
					g[87] = 4.3500000000; fxg[87] = 1.1155000000; feg[87] = 0.0601000000;
					g[88] = 4.4000000000; fxg[88] = 1.1058000000; feg[88] = 0.0588000000;
					g[89] = 4.4500000000; fxg[89] = 1.0968000000; feg[89] = 0.0575000000;
					g[90] = 4.5000000000; fxg[90] = 1.0875000000; feg[90] = 0.0563000000;
					g[91] = 4.5500000000; fxg[91] = 1.0771000000; feg[91] = 0.0551000000;
					g[92] = 4.6000000000; fxg[92] = 1.0655000000; feg[92] = 0.0540000000;
					g[93] = 4.6500000000; fxg[93] = 1.0533000000; feg[93] = 0.0529000000;
					g[94] = 4.7000000000; fxg[94] = 1.0409000000; feg[94] = 0.0518000000;
					g[95] = 4.7500000000; fxg[95] = 1.0290000000; feg[95] = 0.0508000000;
					g[96] = 4.8000000000; fxg[96] = 1.0182000000; feg[96] = 0.0498000000;
					g[97] = 4.8500000000; fxg[97] = 1.0088000000; feg[97] = 0.0488000000;
					g[98] = 4.9000000000; fxg[98] = 1.0005000000; feg[98] = 0.0478000000;
					g[99] = 4.9500000000; fxg[99] = 0.9921000000; feg[99] = 0.0469000000;
					g[100] = 5.0000000000; fxg[100] = 0.9828000000; feg[100] = 0.0460000000;
					g[101] = 5.0500000000; fxg[101] = 0.9721000000; feg[101] = 0.0452000000;
					g[102] = 5.1000000000; fxg[102] = 0.9606000000; feg[102] = 0.0443000000;
					g[103] = 5.1500000000; fxg[103] = 0.9486000000; feg[103] = 0.0435000000;
					g[104] = 5.2000000000; fxg[104] = 0.9366000000; feg[104] = 0.0427000000;
					g[105] = 5.2500000000; fxg[105] = 0.9249000000; feg[105] = 0.0419000000;
					g[106] = 5.3000000000; fxg[106] = 0.9143000000; feg[106] = 0.0412000000;
					g[107] = 5.3500000000; fxg[107] = 0.9052000000; feg[107] = 0.0405000000;
					g[108] = 5.4000000000; fxg[108] = 0.8974000000; feg[108] = 0.0397000000;
					g[109] = 5.4500000000; fxg[109] = 0.8900000000; feg[109] = 0.0390000000;
					g[110] = 5.5000000000; fxg[110] = 0.8819000000; feg[110] = 0.0384000000;
					g[111] = 5.5500000000; fxg[111] = 0.8724000000; feg[111] = 0.0377000000;
					g[112] = 5.6000000000; fxg[112] = 0.8617000000; feg[112] = 0.0371000000;
					g[113] = 5.6500000000; fxg[113] = 0.8505000000; feg[113] = 0.0364000000;
					g[114] = 5.7000000000; fxg[114] = 0.8392000000; feg[114] = 0.0358000000;
					g[115] = 5.7500000000; fxg[115] = 0.8278000000; feg[115] = 0.0352000000;
					g[116] = 5.8000000000; fxg[116] = 0.8167000000; feg[116] = 0.0347000000;
					g[117] = 5.8500000000; fxg[117] = 0.8064000000; feg[117] = 0.0341000000;
					g[118] = 5.9000000000; fxg[118] = 0.7976000000; feg[118] = 0.0336000000;
					g[119] = 5.9500000000; fxg[119] = 0.7903000000; feg[119] = 0.0330000000;
					g[120] = 6.0000000000; fxg[120] = 0.7839000000; feg[120] = 0.0325000000;
					g[121] = 6.0500000000; fxg[121] = 0.7772000000; feg[121] = 0.0320000000;
					g[122] = 6.1000000000; fxg[122] = 0.7692000000; feg[122] = 0.0315000000;
					g[123] = 6.1500000000; fxg[123] = 0.7598000000; feg[123] = 0.0310000000;
					g[124] = 6.2000000000; fxg[124] = 0.7497000000; feg[124] = 0.0305000000;
					g[125] = 6.2500000000; fxg[125] = 0.7394000000; feg[125] = 0.0300000000;
					g[126] = 6.3000000000; fxg[126] = 0.7291000000; feg[126] = 0.0296000000;
					g[127] = 6.3500000000; fxg[127] = 0.7188000000; feg[127] = 0.0292000000;
					g[128] = 6.4000000000; fxg[128] = 0.7085000000; feg[128] = 0.0287000000;
					g[129] = 6.4500000000; fxg[129] = 0.6986000000; feg[129] = 0.0283000000;
					g[130] = 6.5000000000; fxg[130] = 0.6899000000; feg[130] = 0.0279000000;
					g[131] = 6.5500000000; fxg[131] = 0.6829000000; feg[131] = 0.0275000000;
					g[132] = 6.6000000000; fxg[132] = 0.6773000000; feg[132] = 0.0271000000;
					g[133] = 6.6500000000; fxg[133] = 0.6721000000; feg[133] = 0.0267000000;
					g[134] = 6.7000000000; fxg[134] = 0.6661000000; feg[134] = 0.0263000000;
					g[135] = 6.7500000000; fxg[135] = 0.6586000000; feg[135] = 0.0259000000;
					g[136] = 6.8000000000; fxg[136] = 0.6499000000; feg[136] = 0.0256000000;
					g[137] = 6.8500000000; fxg[137] = 0.6406000000; feg[137] = 0.0252000000;
					g[138] = 6.9000000000; fxg[138] = 0.6315000000; feg[138] = 0.0249000000;
					g[139] = 6.9500000000; fxg[139] = 0.6227000000; feg[139] = 0.0245000000;
					g[140] = 7.0000000000; fxg[140] = 0.6139000000; feg[140] = 0.0242000000;
					g[141] = 7.0500000000; fxg[141] = 0.6048000000; feg[141] = 0.0239000000;
					g[142] = 7.1000000000; fxg[142] = 0.5955000000; feg[142] = 0.0236000000;
					g[143] = 7.1500000000; fxg[143] = 0.5869000000; feg[143] = 0.0232000000;
					g[144] = 7.2000000000; fxg[144] = 0.5795000000; feg[144] = 0.0229000000;
					g[145] = 7.2500000000; fxg[145] = 0.5740000000; feg[145] = 0.0226000000;
					g[146] = 7.3000000000; fxg[146] = 0.5698000000; feg[146] = 0.0223000000;
					g[147] = 7.3500000000; fxg[147] = 0.5659000000; feg[147] = 0.0220000000;
					g[148] = 7.4000000000; fxg[148] = 0.5610000000; feg[148] = 0.0217000000;
					g[149] = 7.4500000000; fxg[149] = 0.5547000000; feg[149] = 0.0215000000;
					g[150] = 7.5000000000; fxg[150] = 0.5469000000; feg[150] = 0.0212000000;
					g[151] = 7.5500000000; fxg[151] = 0.5386000000; feg[151] = 0.0209000000;
					g[152] = 7.6000000000; fxg[152] = 0.5307000000; feg[152] = 0.0207000000;
					g[153] = 7.6500000000; fxg[153] = 0.5233000000; feg[153] = 0.0204000000;
					g[154] = 7.7000000000; fxg[154] = 0.5163000000; feg[154] = 0.0202000000;
					g[155] = 7.7500000000; fxg[155] = 0.5090000000; feg[155] = 0.0199000000;
					g[156] = 7.8000000000; fxg[156] = 0.5012000000; feg[156] = 0.0197000000;
					g[157] = 7.8500000000; fxg[157] = 0.4930000000; feg[157] = 0.0194000000;
					g[158] = 7.9000000000; fxg[158] = 0.4853000000; feg[158] = 0.0192000000;
					g[159] = 7.9500000000; fxg[159] = 0.4787000000; feg[159] = 0.0190000000;
					g[160] = 8.0000000000; fxg[160] = 0.4738000000; feg[160] = 0.0187000000;
					g[161] = 8.0500000000; fxg[161] = 0.4705000000; feg[161] = 0.0185000000;
					g[162] = 8.1000000000; fxg[162] = 0.4679000000; feg[162] = 0.0183000000;
					g[163] = 8.1500000000; fxg[163] = 0.4649000000; feg[163] = 0.0181000000;
					g[164] = 8.2000000000; fxg[164] = 0.4604000000; feg[164] = 0.0179000000;
					g[165] = 8.2500000000; fxg[165] = 0.4544000000; feg[165] = 0.0176000000;
					g[166] = 8.3000000000; fxg[166] = 0.4472000000; feg[166] = 0.0174000000;
					g[167] = 8.3500000000; fxg[167] = 0.4399000000; feg[167] = 0.0172000000;
					g[168] = 8.4000000000; fxg[168] = 0.4332000000; feg[168] = 0.0171000000;
					g[169] = 8.4500000000; fxg[169] = 0.4275000000; feg[169] = 0.0169000000;
					g[170] = 8.5000000000; fxg[170] = 0.4223000000; feg[170] = 0.0167000000;
					g[171] = 8.5500000000; fxg[171] = 0.4168000000; feg[171] = 0.0165000000;
					g[172] = 8.6000000000; fxg[172] = 0.4107000000; feg[172] = 0.0163000000;
					g[173] = 8.6500000000; fxg[173] = 0.4038000000; feg[173] = 0.0161000000;
					g[174] = 8.7000000000; fxg[174] = 0.3968000000; feg[174] = 0.0159000000;
					g[175] = 8.7500000000; fxg[175] = 0.3903000000; feg[175] = 0.0158000000;
					g[176] = 8.8000000000; fxg[176] = 0.3850000000; feg[176] = 0.0156000000;
					g[177] = 8.8500000000; fxg[177] = 0.3814000000; feg[177] = 0.0154000000;
					g[178] = 8.9000000000; fxg[178] = 0.3794000000; feg[178] = 0.0153000000;
					g[179] = 8.9500000000; fxg[179] = 0.3780000000; feg[179] = 0.0151000000;
					g[180] = 9.0000000000; fxg[180] = 0.3762000000; feg[180] = 0.0149000000;
					g[181] = 9.0500000000; fxg[181] = 0.3731000000; feg[181] = 0.0148000000;
					g[182] = 9.1000000000; fxg[182] = 0.3682000000; feg[182] = 0.0146000000;
					g[183] = 9.1500000000; fxg[183] = 0.3621000000; feg[183] = 0.0145000000;
					g[184] = 9.2000000000; fxg[184] = 0.3556000000; feg[184] = 0.0143000000;
					g[185] = 9.2500000000; fxg[185] = 0.3495000000; feg[185] = 0.0142000000;
					g[186] = 9.3000000000; fxg[186] = 0.3446000000; feg[186] = 0.0140000000;
					g[187] = 9.3500000000; fxg[187] = 0.3407000000; feg[187] = 0.0139000000;
					g[188] = 9.4000000000; fxg[188] = 0.3372000000; feg[188] = 0.0137000000;
					g[189] = 9.4500000000; fxg[189] = 0.3333000000; feg[189] = 0.0136000000;
					g[190] = 9.5000000000; fxg[190] = 0.3286000000; feg[190] = 0.0134000000;
					g[191] = 9.5500000000; fxg[191] = 0.3230000000; feg[191] = 0.0133000000;
					g[192] = 9.6000000000; fxg[192] = 0.3170000000; feg[192] = 0.0132000000;
					g[193] = 9.6500000000; fxg[193] = 0.3111000000; feg[193] = 0.0130000000;
					g[194] = 9.7000000000; fxg[194] = 0.3060000000; feg[194] = 0.0129000000;
					g[195] = 9.7500000000; fxg[195] = 0.3024000000; feg[195] = 0.0128000000;
					g[196] = 9.8000000000; fxg[196] = 0.3004000000; feg[196] = 0.0127000000;
					g[197] = 9.8500000000; fxg[197] = 0.2997000000; feg[197] = 0.0125000000;
					g[198] = 9.9000000000; fxg[198] = 0.2994000000; feg[198] = 0.0124000000;
					g[199] = 9.9500000000; fxg[199] = 0.2985000000; feg[199] = 0.0123000000;
					g[200] = 10.0000000000; fxg[200] = 0.2961000000; feg[200] = 0.0122000000;
					g[201] = 10.0500000000; fxg[201] = 0.2922000000; feg[201] = 0.0120000000;
					g[202] = 10.1000000000; fxg[202] = 0.2870000000; feg[202] = 0.0119000000;
					g[203] = 10.1500000000; fxg[203] = 0.2811000000; feg[203] = 0.0118000000;
					g[204] = 10.2000000000; fxg[204] = 0.2756000000; feg[204] = 0.0117000000;
					g[205] = 10.2500000000; fxg[205] = 0.2712000000; feg[205] = 0.0116000000;
					g[206] = 10.3000000000; fxg[206] = 0.2681000000; feg[206] = 0.0115000000;
					g[207] = 10.3500000000; fxg[207] = 0.2660000000; feg[207] = 0.0114000000;
					g[208] = 10.4000000000; fxg[208] = 0.2640000000; feg[208] = 0.0113000000;
					g[209] = 10.4500000000; fxg[209] = 0.2613000000; feg[209] = 0.0112000000;
					g[210] = 10.5000000000; fxg[210] = 0.2577000000; feg[210] = 0.0111000000;
					g[211] = 10.5500000000; fxg[211] = 0.2533000000; feg[211] = 0.0110000000;
					g[212] = 10.6000000000; fxg[212] = 0.2483000000; feg[212] = 0.0109000000;
					g[213] = 10.6500000000; fxg[213] = 0.2432000000; feg[213] = 0.0108000000;
					g[214] = 10.7000000000; fxg[214] = 0.2386000000; feg[214] = 0.0107000000;
					g[215] = 10.7500000000; fxg[215] = 0.2349000000; feg[215] = 0.0106000000;
					g[216] = 10.8000000000; fxg[216] = 0.2328000000; feg[216] = 0.0105000000;
					g[217] = 10.8500000000; fxg[217] = 0.2321000000; feg[217] = 0.0104000000;
					g[218] = 10.9000000000; fxg[218] = 0.2326000000; feg[218] = 0.0103000000;
					g[219] = 10.9500000000; fxg[219] = 0.2331000000; feg[219] = 0.0102000000;
					g[220] = 11.0000000000; fxg[220] = 0.2328000000; feg[220] = 0.0101000000;
					g[221] = 11.0500000000; fxg[221] = 0.2312000000; feg[221] = 0.0100000000;
					g[222] = 11.1000000000; fxg[222] = 0.2281000000; feg[222] = 0.0099000000;
					g[223] = 11.1500000000; fxg[223] = 0.2237000000; feg[223] = 0.0098000000;
					g[224] = 11.2000000000; fxg[224] = 0.2186000000; feg[224] = 0.0098000000;
					g[225] = 11.2500000000; fxg[225] = 0.2135000000; feg[225] = 0.0097000000;
					g[226] = 11.3000000000; fxg[226] = 0.2094000000; feg[226] = 0.0096000000;
					g[227] = 11.3500000000; fxg[227] = 0.2066000000; feg[227] = 0.0095000000;
					g[228] = 11.4000000000; fxg[228] = 0.2051000000; feg[228] = 0.0094000000;
					g[229] = 11.4500000000; fxg[229] = 0.2043000000; feg[229] = 0.0093000000;
					g[230] = 11.5000000000; fxg[230] = 0.2033000000; feg[230] = 0.0093000000;
					g[231] = 11.5500000000; fxg[231] = 0.2016000000; feg[231] = 0.0092000000;
					g[232] = 11.6000000000; fxg[232] = 0.1989000000; feg[232] = 0.0091000000;
					g[233] = 11.6500000000; fxg[233] = 0.1955000000; feg[233] = 0.0090000000;
					g[234] = 11.7000000000; fxg[234] = 0.1916000000; feg[234] = 0.0090000000;
					g[235] = 11.7500000000; fxg[235] = 0.1874000000; feg[235] = 0.0089000000;
					g[236] = 11.8000000000; fxg[236] = 0.1832000000; feg[236] = 0.0088000000;
					g[237] = 11.8500000000; fxg[237] = 0.1796000000; feg[237] = 0.0087000000;
					g[238] = 11.9000000000; fxg[238] = 0.1771000000; feg[238] = 0.0087000000;
					g[239] = 11.9500000000; fxg[239] = 0.1760000000; feg[239] = 0.0086000000;
					g[240] = 12.0000000000; fxg[240] = 0.1763000000; feg[240] = 0.0085000000;
					break;
				case 14:
					g[0] = 0.0000000000; fxg[0] = 14.0000000000; feg[0] = 5.8360000000;
					g[1] = 0.0500000000; fxg[1] = 13.8504000000; feg[1] = 5.7284000000;
					g[2] = 0.1000000000; fxg[2] = 13.4332000000; feg[2] = 5.4267000000;
					g[3] = 0.1500000000; fxg[3] = 12.8283000000; feg[3] = 4.9853000000;
					g[4] = 0.2000000000; fxg[4] = 12.1321000000; feg[4] = 4.4706000000;
					g[5] = 0.2500000000; fxg[5] = 11.4270000000; feg[5] = 3.9412000000;
					g[6] = 0.3000000000; fxg[6] = 10.7677000000; feg[6] = 3.4382000000;
					g[7] = 0.3500000000; fxg[7] = 10.1808000000; feg[7] = 2.9847000000;
					g[8] = 0.4000000000; fxg[8] = 9.6723000000; feg[8] = 2.5894000000;
					g[9] = 0.4500000000; fxg[9] = 9.2358000000; feg[9] = 2.2524000000;
					g[10] = 0.5000000000; fxg[10] = 8.8590000000; feg[10] = 1.9687000000;
					g[11] = 0.5500000000; fxg[11] = 8.5284000000; feg[11] = 1.7316000000;
					g[12] = 0.6000000000; fxg[12] = 8.2314000000; feg[12] = 1.5340000000;
					g[13] = 0.6500000000; fxg[13] = 7.9574000000; feg[13] = 1.3692000000;
					g[14] = 0.7000000000; fxg[14] = 7.6982000000; feg[14] = 1.2312000000;
					g[15] = 0.7500000000; fxg[15] = 7.4480000000; feg[15] = 1.1151000000;
					g[16] = 0.8000000000; fxg[16] = 7.2028000000; feg[16] = 1.0168000000;
					g[17] = 0.8500000000; fxg[17] = 6.9603000000; feg[17] = 0.9328000000;
					g[18] = 0.9000000000; fxg[18] = 6.7191000000; feg[18] = 0.8605000000;
					g[19] = 0.9500000000; fxg[19] = 6.4789000000; feg[19] = 0.7978000000;
					g[20] = 1.0000000000; fxg[20] = 6.2401000000; feg[20] = 0.7429000000;
					g[21] = 1.0500000000; fxg[21] = 6.0032000000; feg[21] = 0.6944000000;
					g[22] = 1.1000000000; fxg[22] = 5.7690000000; feg[22] = 0.6512000000;
					g[23] = 1.1500000000; fxg[23] = 5.5384000000; feg[23] = 0.6125000000;
					g[24] = 1.2000000000; fxg[24] = 5.3124000000; feg[24] = 0.5776000000;
					g[25] = 1.2500000000; fxg[25] = 5.0919000000; feg[25] = 0.5458000000;
					g[26] = 1.3000000000; fxg[26] = 4.8775000000; feg[26] = 0.5168000000;
					g[27] = 1.3500000000; fxg[27] = 4.6700000000; feg[27] = 0.4901000000;
					g[28] = 1.4000000000; fxg[28] = 4.4699000000; feg[28] = 0.4655000000;
					g[29] = 1.4500000000; fxg[29] = 4.2776000000; feg[29] = 0.4427000000;
					g[30] = 1.5000000000; fxg[30] = 4.0935000000; feg[30] = 0.4215000000;
					g[31] = 1.5500000000; fxg[31] = 3.9176000000; feg[31] = 0.4018000000;
					g[32] = 1.6000000000; fxg[32] = 3.7502000000; feg[32] = 0.3833000000;
					g[33] = 1.6500000000; fxg[33] = 3.5911000000; feg[33] = 0.3660000000;
					g[34] = 1.7000000000; fxg[34] = 3.4405000000; feg[34] = 0.3498000000;
					g[35] = 1.7500000000; fxg[35] = 3.2980000000; feg[35] = 0.3345000000;
					g[36] = 1.8000000000; fxg[36] = 3.1637000000; feg[36] = 0.3202000000;
					g[37] = 1.8500000000; fxg[37] = 3.0371000000; feg[37] = 0.3067000000;
					g[38] = 1.9000000000; fxg[38] = 2.9181000000; feg[38] = 0.2939000000;
					g[39] = 1.9500000000; fxg[39] = 2.8064000000; feg[39] = 0.2818000000;
					g[40] = 2.0000000000; fxg[40] = 2.7016000000; feg[40] = 0.2704000000;
					g[41] = 2.0500000000; fxg[41] = 2.6035000000; feg[41] = 0.2596000000;
					g[42] = 2.1000000000; fxg[42] = 2.5117000000; feg[42] = 0.2494000000;
					g[43] = 2.1500000000; fxg[43] = 2.4259000000; feg[43] = 0.2397000000;
					g[44] = 2.2000000000; fxg[44] = 2.3458000000; feg[44] = 0.2305000000;
					g[45] = 2.2500000000; fxg[45] = 2.2711000000; feg[45] = 0.2218000000;
					g[46] = 2.3000000000; fxg[46] = 2.2013000000; feg[46] = 0.2135000000;
					g[47] = 2.3500000000; fxg[47] = 2.1361000000; feg[47] = 0.2057000000;
					g[48] = 2.4000000000; fxg[48] = 2.0755000000; feg[48] = 0.1982000000;
					g[49] = 2.4500000000; fxg[49] = 2.0191000000; feg[49] = 0.1911000000;
					g[50] = 2.5000000000; fxg[50] = 1.9664000000; feg[50] = 0.1843000000;
					g[51] = 2.5500000000; fxg[51] = 1.9171000000; feg[51] = 0.1779000000;
					g[52] = 2.6000000000; fxg[52] = 1.8712000000; feg[52] = 0.1718000000;
					g[53] = 2.6500000000; fxg[53] = 1.8285000000; feg[53] = 0.1659000000;
					g[54] = 2.7000000000; fxg[54] = 1.7888000000; feg[54] = 0.1604000000;
					g[55] = 2.7500000000; fxg[55] = 1.7516000000; feg[55] = 0.1551000000;
					g[56] = 2.8000000000; fxg[56] = 1.7166000000; feg[56] = 0.1500000000;
					g[57] = 2.8500000000; fxg[57] = 1.6837000000; feg[57] = 0.1452000000;
					g[58] = 2.9000000000; fxg[58] = 1.6531000000; feg[58] = 0.1406000000;
					g[59] = 2.9500000000; fxg[59] = 1.6247000000; feg[59] = 0.1361000000;
					g[60] = 3.0000000000; fxg[60] = 1.5981000000; feg[60] = 0.1319000000;
					g[61] = 3.0500000000; fxg[61] = 1.5729000000; feg[61] = 0.1279000000;
					g[62] = 3.1000000000; fxg[62] = 1.5487000000; feg[62] = 0.1240000000;
					g[63] = 3.1500000000; fxg[63] = 1.5258000000; feg[63] = 0.1204000000;
					g[64] = 3.2000000000; fxg[64] = 1.5043000000; feg[64] = 0.1168000000;
					g[65] = 3.2500000000; fxg[65] = 1.4845000000; feg[65] = 0.1134000000;
					g[66] = 3.3000000000; fxg[66] = 1.4659000000; feg[66] = 0.1102000000;
					g[67] = 3.3500000000; fxg[67] = 1.4480000000; feg[67] = 0.1071000000;
					g[68] = 3.4000000000; fxg[68] = 1.4304000000; feg[68] = 0.1041000000;
					g[69] = 3.4500000000; fxg[69] = 1.4131000000; feg[69] = 0.1012000000;
					g[70] = 3.5000000000; fxg[70] = 1.3966000000; feg[70] = 0.0985000000;
					g[71] = 3.5500000000; fxg[71] = 1.3812000000; feg[71] = 0.0959000000;
					g[72] = 3.6000000000; fxg[72] = 1.3671000000; feg[72] = 0.0933000000;
					g[73] = 3.6500000000; fxg[73] = 1.3537000000; feg[73] = 0.0909000000;
					g[74] = 3.7000000000; fxg[74] = 1.3405000000; feg[74] = 0.0885000000;
					g[75] = 3.7500000000; fxg[75] = 1.3270000000; feg[75] = 0.0863000000;
					g[76] = 3.8000000000; fxg[76] = 1.3132000000; feg[76] = 0.0841000000;
					g[77] = 3.8500000000; fxg[77] = 1.2996000000; feg[77] = 0.0820000000;
					g[78] = 3.9000000000; fxg[78] = 1.2868000000; feg[78] = 0.0800000000;
					g[79] = 3.9500000000; fxg[79] = 1.2752000000; feg[79] = 0.0781000000;
					g[80] = 4.0000000000; fxg[80] = 1.2645000000; feg[80] = 0.0762000000;
					g[81] = 4.0500000000; fxg[81] = 1.2541000000; feg[81] = 0.0744000000;
					g[82] = 4.1000000000; fxg[82] = 1.2433000000; feg[82] = 0.0727000000;
					g[83] = 4.1500000000; fxg[83] = 1.2317000000; feg[83] = 0.0710000000;
					g[84] = 4.2000000000; fxg[84] = 1.2196000000; feg[84] = 0.0694000000;
					g[85] = 4.2500000000; fxg[85] = 1.2074000000; feg[85] = 0.0678000000;
					g[86] = 4.3000000000; fxg[86] = 1.1958000000; feg[86] = 0.0663000000;
					g[87] = 4.3500000000; fxg[87] = 1.1853000000; feg[87] = 0.0648000000;
					g[88] = 4.4000000000; fxg[88] = 1.1758000000; feg[88] = 0.0634000000;
					g[89] = 4.4500000000; fxg[89] = 1.1670000000; feg[89] = 0.0620000000;
					g[90] = 4.5000000000; fxg[90] = 1.1580000000; feg[90] = 0.0607000000;
					g[91] = 4.5500000000; fxg[91] = 1.1480000000; feg[91] = 0.0594000000;
					g[92] = 4.6000000000; fxg[92] = 1.1370000000; feg[92] = 0.0582000000;
					g[93] = 4.6500000000; fxg[93] = 1.1253000000; feg[93] = 0.0570000000;
					g[94] = 4.7000000000; fxg[94] = 1.1136000000; feg[94] = 0.0558000000;
					g[95] = 4.7500000000; fxg[95] = 1.1024000000; feg[95] = 0.0547000000;
					g[96] = 4.8000000000; fxg[96] = 1.0923000000; feg[96] = 0.0536000000;
					g[97] = 4.8500000000; fxg[97] = 1.0835000000; feg[97] = 0.0526000000;
					g[98] = 4.9000000000; fxg[98] = 1.0756000000; feg[98] = 0.0515000000;
					g[99] = 4.9500000000; fxg[99] = 1.0676000000; feg[99] = 0.0505000000;
					g[100] = 5.0000000000; fxg[100] = 1.0588000000; feg[100] = 0.0496000000;
					g[101] = 5.0500000000; fxg[101] = 1.0488000000; feg[101] = 0.0486000000;
					g[102] = 5.1000000000; fxg[102] = 1.0378000000; feg[102] = 0.0477000000;
					g[103] = 5.1500000000; fxg[103] = 1.0262000000; feg[103] = 0.0468000000;
					g[104] = 5.2000000000; fxg[104] = 1.0146000000; feg[104] = 0.0460000000;
					g[105] = 5.2500000000; fxg[105] = 1.0036000000; feg[105] = 0.0451000000;
					g[106] = 5.3000000000; fxg[106] = 0.9937000000; feg[106] = 0.0443000000;
					g[107] = 5.3500000000; fxg[107] = 0.9852000000; feg[107] = 0.0435000000;
					g[108] = 5.4000000000; fxg[108] = 0.9778000000; feg[108] = 0.0428000000;
					g[109] = 5.4500000000; fxg[109] = 0.9708000000; feg[109] = 0.0420000000;
					g[110] = 5.5000000000; fxg[110] = 0.9631000000; feg[110] = 0.0413000000;
					g[111] = 5.5500000000; fxg[111] = 0.9541000000; feg[111] = 0.0405000000;
					g[112] = 5.6000000000; fxg[112] = 0.9439000000; feg[112] = 0.0399000000;
					g[113] = 5.6500000000; fxg[113] = 0.9329000000; feg[113] = 0.0392000000;
					g[114] = 5.7000000000; fxg[114] = 0.9216000000; feg[114] = 0.0385000000;
					g[115] = 5.7500000000; fxg[115] = 0.9102000000; feg[115] = 0.0379000000;
					g[116] = 5.8000000000; fxg[116] = 0.8994000000; feg[116] = 0.0373000000;
					g[117] = 5.8500000000; fxg[117] = 0.8896000000; feg[117] = 0.0367000000;
					g[118] = 5.9000000000; fxg[118] = 0.8813000000; feg[118] = 0.0361000000;
					g[119] = 5.9500000000; fxg[119] = 0.8744000000; feg[119] = 0.0355000000;
					g[120] = 6.0000000000; fxg[120] = 0.8682000000; feg[120] = 0.0349000000;
					g[121] = 6.0500000000; fxg[121] = 0.8617000000; feg[121] = 0.0344000000;
					g[122] = 6.1000000000; fxg[122] = 0.8541000000; feg[122] = 0.0338000000;
					g[123] = 6.1500000000; fxg[123] = 0.8451000000; feg[123] = 0.0333000000;
					g[124] = 6.2000000000; fxg[124] = 0.8351000000; feg[124] = 0.0328000000;
					g[125] = 6.2500000000; fxg[125] = 0.8245000000; feg[125] = 0.0323000000;
					g[126] = 6.3000000000; fxg[126] = 0.8138000000; feg[126] = 0.0318000000;
					g[127] = 6.3500000000; fxg[127] = 0.8030000000; feg[127] = 0.0313000000;
					g[128] = 6.4000000000; fxg[128] = 0.7925000000; feg[128] = 0.0309000000;
					g[129] = 6.4500000000; fxg[129] = 0.7828000000; feg[129] = 0.0304000000;
					g[130] = 6.5000000000; fxg[130] = 0.7745000000; feg[130] = 0.0300000000;
					g[131] = 6.5500000000; fxg[131] = 0.7677000000; feg[131] = 0.0295000000;
					g[132] = 6.6000000000; fxg[132] = 0.7623000000; feg[132] = 0.0291000000;
					g[133] = 6.6500000000; fxg[133] = 0.7572000000; feg[133] = 0.0287000000;
					g[134] = 6.7000000000; fxg[134] = 0.7514000000; feg[134] = 0.0283000000;
					g[135] = 6.7500000000; fxg[135] = 0.7442000000; feg[135] = 0.0279000000;
					g[136] = 6.8000000000; fxg[136] = 0.7356000000; feg[136] = 0.0275000000;
					g[137] = 6.8500000000; fxg[137] = 0.7262000000; feg[137] = 0.0271000000;
					g[138] = 6.9000000000; fxg[138] = 0.7165000000; feg[138] = 0.0267000000;
					g[139] = 6.9500000000; fxg[139] = 0.7068000000; feg[139] = 0.0263000000;
					g[140] = 7.0000000000; fxg[140] = 0.6970000000; feg[140] = 0.0260000000;
					g[141] = 7.0500000000; fxg[141] = 0.6872000000; feg[141] = 0.0256000000;
					g[142] = 7.1000000000; fxg[142] = 0.6777000000; feg[142] = 0.0253000000;
					g[143] = 7.1500000000; fxg[143] = 0.6691000000; feg[143] = 0.0250000000;
					g[144] = 7.2000000000; fxg[144] = 0.6619000000; feg[144] = 0.0246000000;
					g[145] = 7.2500000000; fxg[145] = 0.6565000000; feg[145] = 0.0243000000;
					g[146] = 7.3000000000; fxg[146] = 0.6524000000; feg[146] = 0.0240000000;
					g[147] = 7.3500000000; fxg[147] = 0.6484000000; feg[147] = 0.0237000000;
					g[148] = 7.4000000000; fxg[148] = 0.6437000000; feg[148] = 0.0234000000;
					g[149] = 7.4500000000; fxg[149] = 0.6375000000; feg[149] = 0.0230000000;
					g[150] = 7.5000000000; fxg[150] = 0.6298000000; feg[150] = 0.0228000000;
					g[151] = 7.5500000000; fxg[151] = 0.6214000000; feg[151] = 0.0225000000;
					g[152] = 7.6000000000; fxg[152] = 0.6127000000; feg[152] = 0.0222000000;
					g[153] = 7.6500000000; fxg[153] = 0.6043000000; feg[153] = 0.0219000000;
					g[154] = 7.7000000000; fxg[154] = 0.5960000000; feg[154] = 0.0216000000;
					g[155] = 7.7500000000; fxg[155] = 0.5876000000; feg[155] = 0.0214000000;
					g[156] = 7.8000000000; fxg[156] = 0.5789000000; feg[156] = 0.0211000000;
					g[157] = 7.8500000000; fxg[157] = 0.5702000000; feg[157] = 0.0209000000;
					g[158] = 7.9000000000; fxg[158] = 0.5623000000; feg[158] = 0.0206000000;
					g[159] = 7.9500000000; fxg[159] = 0.5557000000; feg[159] = 0.0204000000;
					g[160] = 8.0000000000; fxg[160] = 0.5510000000; feg[160] = 0.0201000000;
					g[161] = 8.0500000000; fxg[161] = 0.5477000000; feg[161] = 0.0199000000;
					g[162] = 8.1000000000; fxg[162] = 0.5451000000; feg[162] = 0.0196000000;
					g[163] = 8.1500000000; fxg[163] = 0.5420000000; feg[163] = 0.0194000000;
					g[164] = 8.2000000000; fxg[164] = 0.5377000000; feg[164] = 0.0192000000;
					g[165] = 8.2500000000; fxg[165] = 0.5317000000; feg[165] = 0.0189000000;
					g[166] = 8.3000000000; fxg[166] = 0.5244000000; feg[166] = 0.0187000000;
					g[167] = 8.3500000000; fxg[167] = 0.5167000000; feg[167] = 0.0185000000;
					g[168] = 8.4000000000; fxg[168] = 0.5093000000; feg[168] = 0.0183000000;
					g[169] = 8.4500000000; fxg[169] = 0.5023000000; feg[169] = 0.0181000000;
					g[170] = 8.5000000000; fxg[170] = 0.4957000000; feg[170] = 0.0179000000;
					g[171] = 8.5500000000; fxg[171] = 0.4889000000; feg[171] = 0.0177000000;
					g[172] = 8.6000000000; fxg[172] = 0.4817000000; feg[172] = 0.0175000000;
					g[173] = 8.6500000000; fxg[173] = 0.4740000000; feg[173] = 0.0173000000;
					g[174] = 8.7000000000; fxg[174] = 0.4665000000; feg[174] = 0.0171000000;
					g[175] = 8.7500000000; fxg[175] = 0.4597000000; feg[175] = 0.0169000000;
					g[176] = 8.8000000000; fxg[176] = 0.4544000000; feg[176] = 0.0167000000;
					g[177] = 8.8500000000; fxg[177] = 0.4509000000; feg[177] = 0.0166000000;
					g[178] = 8.9000000000; fxg[178] = 0.4489000000; feg[178] = 0.0164000000;
					g[179] = 8.9500000000; fxg[179] = 0.4476000000; feg[179] = 0.0162000000;
					g[180] = 9.0000000000; fxg[180] = 0.4458000000; feg[180] = 0.0160000000;
					g[181] = 9.0500000000; fxg[181] = 0.4426000000; feg[181] = 0.0158000000;
					g[182] = 9.1000000000; fxg[182] = 0.4378000000; feg[182] = 0.0157000000;
					g[183] = 9.1500000000; fxg[183] = 0.4316000000; feg[183] = 0.0155000000;
					g[184] = 9.2000000000; fxg[184] = 0.4247000000; feg[184] = 0.0154000000;
					g[185] = 9.2500000000; fxg[185] = 0.4180000000; feg[185] = 0.0152000000;
					g[186] = 9.3000000000; fxg[186] = 0.4121000000; feg[186] = 0.0150000000;
					g[187] = 9.3500000000; fxg[187] = 0.4070000000; feg[187] = 0.0149000000;
					g[188] = 9.4000000000; fxg[188] = 0.4022000000; feg[188] = 0.0147000000;
					g[189] = 9.4500000000; fxg[189] = 0.3970000000; feg[189] = 0.0146000000;
					g[190] = 9.5000000000; fxg[190] = 0.3912000000; feg[190] = 0.0144000000;
					g[191] = 9.5500000000; fxg[191] = 0.3847000000; feg[191] = 0.0143000000;
					g[192] = 9.6000000000; fxg[192] = 0.3780000000; feg[192] = 0.0142000000;
					g[193] = 9.6500000000; fxg[193] = 0.3717000000; feg[193] = 0.0140000000;
					g[194] = 9.7000000000; fxg[194] = 0.3664000000; feg[194] = 0.0139000000;
					g[195] = 9.7500000000; fxg[195] = 0.3627000000; feg[195] = 0.0137000000;
					g[196] = 9.8000000000; fxg[196] = 0.3608000000; feg[196] = 0.0136000000;
					g[197] = 9.8500000000; fxg[197] = 0.3602000000; feg[197] = 0.0135000000;
					g[198] = 9.9000000000; fxg[198] = 0.3600000000; feg[198] = 0.0133000000;
					g[199] = 9.9500000000; fxg[199] = 0.3591000000; feg[199] = 0.0132000000;
					g[200] = 10.0000000000; fxg[200] = 0.3568000000; feg[200] = 0.0131000000;
					g[201] = 10.0500000000; fxg[201] = 0.3528000000; feg[201] = 0.0129000000;
					g[202] = 10.1000000000; fxg[202] = 0.3473000000; feg[202] = 0.0128000000;
					g[203] = 10.1500000000; fxg[203] = 0.3412000000; feg[203] = 0.0127000000;
					g[204] = 10.2000000000; fxg[204] = 0.3351000000; feg[204] = 0.0126000000;
					g[205] = 10.2500000000; fxg[205] = 0.3299000000; feg[205] = 0.0125000000;
					g[206] = 10.3000000000; fxg[206] = 0.3259000000; feg[206] = 0.0123000000;
					g[207] = 10.3500000000; fxg[207] = 0.3226000000; feg[207] = 0.0122000000;
					g[208] = 10.4000000000; fxg[208] = 0.3195000000; feg[208] = 0.0121000000;
					g[209] = 10.4500000000; fxg[209] = 0.3158000000; feg[209] = 0.0120000000;
					g[210] = 10.5000000000; fxg[210] = 0.3113000000; feg[210] = 0.0119000000;
					g[211] = 10.5500000000; fxg[211] = 0.3060000000; feg[211] = 0.0118000000;
					g[212] = 10.6000000000; fxg[212] = 0.3002000000; feg[212] = 0.0117000000;
					g[213] = 10.6500000000; fxg[213] = 0.2945000000; feg[213] = 0.0116000000;
					g[214] = 10.7000000000; fxg[214] = 0.2894000000; feg[214] = 0.0115000000;
					g[215] = 10.7500000000; fxg[215] = 0.2856000000; feg[215] = 0.0114000000;
					g[216] = 10.8000000000; fxg[216] = 0.2835000000; feg[216] = 0.0113000000;
					g[217] = 10.8500000000; fxg[217] = 0.2831000000; feg[217] = 0.0112000000;
					g[218] = 10.9000000000; fxg[218] = 0.2836000000; feg[218] = 0.0111000000;
					g[219] = 10.9500000000; fxg[219] = 0.2843000000; feg[219] = 0.0110000000;
					g[220] = 11.0000000000; fxg[220] = 0.2842000000; feg[220] = 0.0109000000;
					g[221] = 11.0500000000; fxg[221] = 0.2825000000; feg[221] = 0.0108000000;
					g[222] = 11.1000000000; fxg[222] = 0.2793000000; feg[222] = 0.0107000000;
					g[223] = 11.1500000000; fxg[223] = 0.2746000000; feg[223] = 0.0106000000;
					g[224] = 11.2000000000; fxg[224] = 0.2690000000; feg[224] = 0.0105000000;
					g[225] = 11.2500000000; fxg[225] = 0.2634000000; feg[225] = 0.0104000000;
					g[226] = 11.3000000000; fxg[226] = 0.2586000000; feg[226] = 0.0103000000;
					g[227] = 11.3500000000; fxg[227] = 0.2551000000; feg[227] = 0.0102000000;
					g[228] = 11.4000000000; fxg[228] = 0.2529000000; feg[228] = 0.0101000000;
					g[229] = 11.4500000000; fxg[229] = 0.2512000000; feg[229] = 0.0100000000;
					g[230] = 11.5000000000; fxg[230] = 0.2496000000; feg[230] = 0.0100000000;
					g[231] = 11.5500000000; fxg[231] = 0.2472000000; feg[231] = 0.0099000000;
					g[232] = 11.6000000000; fxg[232] = 0.2439000000; feg[232] = 0.0098000000;
					g[233] = 11.6500000000; fxg[233] = 0.2397000000; feg[233] = 0.0097000000;
					g[234] = 11.7000000000; fxg[234] = 0.2349000000; feg[234] = 0.0096000000;
					g[235] = 11.7500000000; fxg[235] = 0.2299000000; feg[235] = 0.0095000000;
					g[236] = 11.8000000000; fxg[236] = 0.2251000000; feg[236] = 0.0095000000;
					g[237] = 11.8500000000; fxg[237] = 0.2211000000; feg[237] = 0.0094000000;
					g[238] = 11.9000000000; fxg[238] = 0.2184000000; feg[238] = 0.0093000000;
					g[239] = 11.9500000000; fxg[239] = 0.2174000000; feg[239] = 0.0092000000;
					g[240] = 12.0000000000; fxg[240] = 0.2179000000; feg[240] = 0.0092000000;
					break;
				case 15:
					g[0] = 0.0000000000; fxg[0] = 15.0000000000; feg[0] = 5.5675000000;
					g[1] = 0.0500000000; fxg[1] = 14.8567000000; feg[1] = 5.4870000000;
					g[2] = 0.1000000000; fxg[2] = 14.4508000000; feg[2] = 5.2580000000;
					g[3] = 0.1500000000; fxg[3] = 13.8453000000; feg[3] = 4.9133000000;
					g[4] = 0.2000000000; fxg[4] = 13.1216000000; feg[4] = 4.4958000000;
					g[5] = 0.2500000000; fxg[5] = 12.3576000000; feg[5] = 4.0475000000;
					g[6] = 0.3000000000; fxg[6] = 11.6138000000; feg[6] = 3.6020000000;
					g[7] = 0.3500000000; fxg[7] = 10.9280000000; feg[7] = 3.1823000000;
					g[8] = 0.4000000000; fxg[8] = 10.3184000000; feg[8] = 2.8012000000;
					g[9] = 0.4500000000; fxg[9] = 9.7887000000; feg[9] = 2.4637000000;
					g[10] = 0.5000000000; fxg[10] = 9.3330000000; feg[10] = 2.1701000000;
					g[11] = 0.5500000000; fxg[11] = 8.9411000000; feg[11] = 1.9175000000;
					g[12] = 0.6000000000; fxg[12] = 8.6011000000; feg[12] = 1.7017000000;
					g[13] = 0.6500000000; fxg[13] = 8.3013000000; feg[13] = 1.5179000000;
					g[14] = 0.7000000000; fxg[14] = 8.0314000000; feg[14] = 1.3615000000;
					g[15] = 0.7500000000; fxg[15] = 7.7827000000; feg[15] = 1.2283000000;
					g[16] = 0.8000000000; fxg[16] = 7.5485000000; feg[16] = 1.1146000000;
					g[17] = 0.8500000000; fxg[17] = 7.3237000000; feg[17] = 1.0171000000;
					g[18] = 0.9000000000; fxg[18] = 7.1046000000; feg[18] = 0.9332000000;
					g[19] = 0.9500000000; fxg[19] = 6.8888000000; feg[19] = 0.8604000000;
					g[20] = 1.0000000000; fxg[20] = 6.6747000000; feg[20] = 0.7970000000;
					g[21] = 1.0500000000; fxg[21] = 6.4617000000; feg[21] = 0.7414000000;
					g[22] = 1.1000000000; fxg[22] = 6.2497000000; feg[22] = 0.6923000000;
					g[23] = 1.1500000000; fxg[23] = 6.0386000000; feg[23] = 0.6487000000;
					g[24] = 1.2000000000; fxg[24] = 5.8291000000; feg[24] = 0.6097000000;
					g[25] = 1.2500000000; fxg[25] = 5.6218000000; feg[25] = 0.5746000000;
					g[26] = 1.3000000000; fxg[26] = 5.4172000000; feg[26] = 0.5428000000;
					g[27] = 1.3500000000; fxg[27] = 5.2160000000; feg[27] = 0.5139000000;
					g[28] = 1.4000000000; fxg[28] = 5.0190000000; feg[28] = 0.4875000000;
					g[29] = 1.4500000000; fxg[29] = 4.8267000000; feg[29] = 0.4632000000;
					g[30] = 1.5000000000; fxg[30] = 4.6397000000; feg[30] = 0.4408000000;
					g[31] = 1.5500000000; fxg[31] = 4.4584000000; feg[31] = 0.4201000000;
					g[32] = 1.6000000000; fxg[32] = 4.2831000000; feg[32] = 0.4008000000;
					g[33] = 1.6500000000; fxg[33] = 4.1143000000; feg[33] = 0.3828000000;
					g[34] = 1.7000000000; fxg[34] = 3.9521000000; feg[34] = 0.3660000000;
					g[35] = 1.7500000000; fxg[35] = 3.7967000000; feg[35] = 0.3502000000;
					g[36] = 1.8000000000; fxg[36] = 3.6481000000; feg[36] = 0.3354000000;
					g[37] = 1.8500000000; fxg[37] = 3.5063000000; feg[37] = 0.3215000000;
					g[38] = 1.9000000000; fxg[38] = 3.3714000000; feg[38] = 0.3084000000;
					g[39] = 1.9500000000; fxg[39] = 3.2432000000; feg[39] = 0.2960000000;
					g[40] = 2.0000000000; fxg[40] = 3.1216000000; feg[40] = 0.2843000000;
					g[41] = 2.0500000000; fxg[41] = 3.0064000000; feg[41] = 0.2732000000;
					g[42] = 2.1000000000; fxg[42] = 2.8975000000; feg[42] = 0.2627000000;
					g[43] = 2.1500000000; fxg[43] = 2.7947000000; feg[43] = 0.2528000000;
					g[44] = 2.2000000000; fxg[44] = 2.6977000000; feg[44] = 0.2433000000;
					g[45] = 2.2500000000; fxg[45] = 2.6064000000; feg[45] = 0.2344000000;
					g[46] = 2.3000000000; fxg[46] = 2.5204000000; feg[46] = 0.2258000000;
					g[47] = 2.3500000000; fxg[47] = 2.4395000000; feg[47] = 0.2177000000;
					g[48] = 2.4000000000; fxg[48] = 2.3635000000; feg[48] = 0.2100000000;
					g[49] = 2.4500000000; fxg[49] = 2.2922000000; feg[49] = 0.2027000000;
					g[50] = 2.5000000000; fxg[50] = 2.2253000000; feg[50] = 0.1957000000;
					g[51] = 2.5500000000; fxg[51] = 2.1624000000; feg[51] = 0.1890000000;
					g[52] = 2.6000000000; fxg[52] = 2.1034000000; feg[52] = 0.1826000000;
					g[53] = 2.6500000000; fxg[53] = 2.0483000000; feg[53] = 0.1766000000;
					g[54] = 2.7000000000; fxg[54] = 1.9966000000; feg[54] = 0.1708000000;
					g[55] = 2.7500000000; fxg[55] = 1.9481000000; feg[55] = 0.1652000000;
					g[56] = 2.8000000000; fxg[56] = 1.9025000000; feg[56] = 0.1599000000;
					g[57] = 2.8500000000; fxg[57] = 1.8597000000; feg[57] = 0.1549000000;
					g[58] = 2.9000000000; fxg[58] = 1.8197000000; feg[58] = 0.1500000000;
					g[59] = 2.9500000000; fxg[59] = 1.7823000000; feg[59] = 0.1454000000;
					g[60] = 3.0000000000; fxg[60] = 1.7472000000; feg[60] = 0.1410000000;
					g[61] = 3.0500000000; fxg[61] = 1.7141000000; feg[61] = 0.1367000000;
					g[62] = 3.1000000000; fxg[62] = 1.6827000000; feg[62] = 0.1327000000;
					g[63] = 3.1500000000; fxg[63] = 1.6532000000; feg[63] = 0.1288000000;
					g[64] = 3.2000000000; fxg[64] = 1.6256000000; feg[64] = 0.1250000000;
					g[65] = 3.2500000000; fxg[65] = 1.5997000000; feg[65] = 0.1215000000;
					g[66] = 3.3000000000; fxg[66] = 1.5755000000; feg[66] = 0.1180000000;
					g[67] = 3.3500000000; fxg[67] = 1.5525000000; feg[67] = 0.1147000000;
					g[68] = 3.4000000000; fxg[68] = 1.5304000000; feg[68] = 0.1115000000;
					g[69] = 3.4500000000; fxg[69] = 1.5091000000; feg[69] = 0.1085000000;
					g[70] = 3.5000000000; fxg[70] = 1.4890000000; feg[70] = 0.1056000000;
					g[71] = 3.5500000000; fxg[71] = 1.4702000000; feg[71] = 0.1028000000;
					g[72] = 3.6000000000; fxg[72] = 1.4526000000; feg[72] = 0.1001000000;
					g[73] = 3.6500000000; fxg[73] = 1.4361000000; feg[73] = 0.0975000000;
					g[74] = 3.7000000000; fxg[74] = 1.4200000000; feg[74] = 0.0950000000;
					g[75] = 3.7500000000; fxg[75] = 1.4042000000; feg[75] = 0.0926000000;
					g[76] = 3.8000000000; fxg[76] = 1.3886000000; feg[76] = 0.0902000000;
					g[77] = 3.8500000000; fxg[77] = 1.3734000000; feg[77] = 0.0880000000;
					g[78] = 3.9000000000; fxg[78] = 1.3592000000; feg[78] = 0.0859000000;
					g[79] = 3.9500000000; fxg[79] = 1.3460000000; feg[79] = 0.0838000000;
					g[80] = 4.0000000000; fxg[80] = 1.3337000000; feg[80] = 0.0818000000;
					g[81] = 4.0500000000; fxg[81] = 1.3219000000; feg[81] = 0.0798000000;
					g[82] = 4.1000000000; fxg[82] = 1.3099000000; feg[82] = 0.0780000000;
					g[83] = 4.1500000000; fxg[83] = 1.2977000000; feg[83] = 0.0762000000;
					g[84] = 4.2000000000; fxg[84] = 1.2851000000; feg[84] = 0.0744000000;
					g[85] = 4.2500000000; fxg[85] = 1.2727000000; feg[85] = 0.0728000000;
					g[86] = 4.3000000000; fxg[86] = 1.2610000000; feg[86] = 0.0711000000;
					g[87] = 4.3500000000; fxg[87] = 1.2502000000; feg[87] = 0.0696000000;
					g[88] = 4.4000000000; fxg[88] = 1.2404000000; feg[88] = 0.0680000000;
					g[89] = 4.4500000000; fxg[89] = 1.2310000000; feg[89] = 0.0666000000;
					g[90] = 4.5000000000; fxg[90] = 1.2216000000; feg[90] = 0.0651000000;
					g[91] = 4.5500000000; fxg[91] = 1.2116000000; feg[91] = 0.0638000000;
					g[92] = 4.6000000000; fxg[92] = 1.2008000000; feg[92] = 0.0624000000;
					g[93] = 4.6500000000; fxg[93] = 1.1895000000; feg[93] = 0.0611000000;
					g[94] = 4.7000000000; fxg[94] = 1.1783000000; feg[94] = 0.0599000000;
					g[95] = 4.7500000000; fxg[95] = 1.1677000000; feg[95] = 0.0587000000;
					g[96] = 4.8000000000; fxg[96] = 1.1580000000; feg[96] = 0.0575000000;
					g[97] = 4.8500000000; fxg[97] = 1.1494000000; feg[97] = 0.0564000000;
					g[98] = 4.9000000000; fxg[98] = 1.1414000000; feg[98] = 0.0553000000;
					g[99] = 4.9500000000; fxg[99] = 1.1335000000; feg[99] = 0.0542000000;
					g[100] = 5.0000000000; fxg[100] = 1.1249000000; feg[100] = 0.0531000000;
					g[101] = 5.0500000000; fxg[101] = 1.1153000000; feg[101] = 0.0521000000;
					g[102] = 5.1000000000; fxg[102] = 1.1049000000; feg[102] = 0.0511000000;
					g[103] = 5.1500000000; fxg[103] = 1.0940000000; feg[103] = 0.0502000000;
					g[104] = 5.2000000000; fxg[104] = 1.0831000000; feg[104] = 0.0493000000;
					g[105] = 5.2500000000; fxg[105] = 1.0728000000; feg[105] = 0.0484000000;
					g[106] = 5.3000000000; fxg[106] = 1.0635000000; feg[106] = 0.0475000000;
					g[107] = 5.3500000000; fxg[107] = 1.0555000000; feg[107] = 0.0466000000;
					g[108] = 5.4000000000; fxg[108] = 1.0483000000; feg[108] = 0.0458000000;
					g[109] = 5.4500000000; fxg[109] = 1.0414000000; feg[109] = 0.0450000000;
					g[110] = 5.5000000000; fxg[110] = 1.0339000000; feg[110] = 0.0442000000;
					g[111] = 5.5500000000; fxg[111] = 1.0254000000; feg[111] = 0.0434000000;
					g[112] = 5.6000000000; fxg[112] = 1.0157000000; feg[112] = 0.0427000000;
					g[113] = 5.6500000000; fxg[113] = 1.0052000000; feg[113] = 0.0420000000;
					g[114] = 5.7000000000; fxg[114] = 0.9943000000; feg[114] = 0.0413000000;
					g[115] = 5.7500000000; fxg[115] = 0.9835000000; feg[115] = 0.0406000000;
					g[116] = 5.8000000000; fxg[116] = 0.9733000000; feg[116] = 0.0399000000;
					g[117] = 5.8500000000; fxg[117] = 0.9641000000; feg[117] = 0.0393000000;
					g[118] = 5.9000000000; fxg[118] = 0.9563000000; feg[118] = 0.0386000000;
					g[119] = 5.9500000000; fxg[119] = 0.9496000000; feg[119] = 0.0380000000;
					g[120] = 6.0000000000; fxg[120] = 0.9435000000; feg[120] = 0.0374000000;
					g[121] = 6.0500000000; fxg[121] = 0.9372000000; feg[121] = 0.0368000000;
					g[122] = 6.1000000000; fxg[122] = 0.9299000000; feg[122] = 0.0362000000;
					g[123] = 6.1500000000; fxg[123] = 0.9213000000; feg[123] = 0.0356000000;
					g[124] = 6.2000000000; fxg[124] = 0.9116000000; feg[124] = 0.0351000000;
					g[125] = 6.2500000000; fxg[125] = 0.9012000000; feg[125] = 0.0346000000;
					g[126] = 6.3000000000; fxg[126] = 0.8905000000; feg[126] = 0.0340000000;
					g[127] = 6.3500000000; fxg[127] = 0.8798000000; feg[127] = 0.0335000000;
					g[128] = 6.4000000000; fxg[128] = 0.8696000000; feg[128] = 0.0330000000;
					g[129] = 6.4500000000; fxg[129] = 0.8604000000; feg[129] = 0.0325000000;
					g[130] = 6.5000000000; fxg[130] = 0.8525000000; feg[130] = 0.0321000000;
					g[131] = 6.5500000000; fxg[131] = 0.8460000000; feg[131] = 0.0316000000;
					g[132] = 6.6000000000; fxg[132] = 0.8406000000; feg[132] = 0.0311000000;
					g[133] = 6.6500000000; fxg[133] = 0.8355000000; feg[133] = 0.0307000000;
					g[134] = 6.7000000000; fxg[134] = 0.8297000000; feg[134] = 0.0302000000;
					g[135] = 6.7500000000; fxg[135] = 0.8228000000; feg[135] = 0.0298000000;
					g[136] = 6.8000000000; fxg[136] = 0.8145000000; feg[136] = 0.0294000000;
					g[137] = 6.8500000000; fxg[137] = 0.8052000000; feg[137] = 0.0290000000;
					g[138] = 6.9000000000; fxg[138] = 0.7953000000; feg[138] = 0.0286000000;
					g[139] = 6.9500000000; fxg[139] = 0.7852000000; feg[139] = 0.0282000000;
					g[140] = 7.0000000000; fxg[140] = 0.7750000000; feg[140] = 0.0278000000;
					g[141] = 7.0500000000; fxg[141] = 0.7650000000; feg[141] = 0.0274000000;
					g[142] = 7.1000000000; fxg[142] = 0.7556000000; feg[142] = 0.0271000000;
					g[143] = 7.1500000000; fxg[143] = 0.7473000000; feg[143] = 0.0267000000;
					g[144] = 7.2000000000; fxg[144] = 0.7404000000; feg[144] = 0.0263000000;
					g[145] = 7.2500000000; fxg[145] = 0.7351000000; feg[145] = 0.0260000000;
					g[146] = 7.3000000000; fxg[146] = 0.7309000000; feg[146] = 0.0256000000;
					g[147] = 7.3500000000; fxg[147] = 0.7268000000; feg[147] = 0.0253000000;
					g[148] = 7.4000000000; fxg[148] = 0.7221000000; feg[148] = 0.0250000000;
					g[149] = 7.4500000000; fxg[149] = 0.7160000000; feg[149] = 0.0246000000;
					g[150] = 7.5000000000; fxg[150] = 0.7086000000; feg[150] = 0.0243000000;
					g[151] = 7.5500000000; fxg[151] = 0.7002000000; feg[151] = 0.0240000000;
					g[152] = 7.6000000000; fxg[152] = 0.6912000000; feg[152] = 0.0237000000;
					g[153] = 7.6500000000; fxg[153] = 0.6820000000; feg[153] = 0.0234000000;
					g[154] = 7.7000000000; fxg[154] = 0.6728000000; feg[154] = 0.0231000000;
					g[155] = 7.7500000000; fxg[155] = 0.6636000000; feg[155] = 0.0229000000;
					g[156] = 7.8000000000; fxg[156] = 0.6544000000; feg[156] = 0.0226000000;
					g[157] = 7.8500000000; fxg[157] = 0.6456000000; feg[157] = 0.0223000000;
					g[158] = 7.9000000000; fxg[158] = 0.6378000000; feg[158] = 0.0220000000;
					g[159] = 7.9500000000; fxg[159] = 0.6315000000; feg[159] = 0.0218000000;
					g[160] = 8.0000000000; fxg[160] = 0.6268000000; feg[160] = 0.0215000000;
					g[161] = 8.0500000000; fxg[161] = 0.6234000000; feg[161] = 0.0212000000;
					g[162] = 8.1000000000; fxg[162] = 0.6206000000; feg[162] = 0.0210000000;
					g[163] = 8.1500000000; fxg[163] = 0.6175000000; feg[163] = 0.0207000000;
					g[164] = 8.2000000000; fxg[164] = 0.6131000000; feg[164] = 0.0205000000;
					g[165] = 8.2500000000; fxg[165] = 0.6073000000; feg[165] = 0.0202000000;
					g[166] = 8.3000000000; fxg[166] = 0.6002000000; feg[166] = 0.0200000000;
					g[167] = 8.3500000000; fxg[167] = 0.5923000000; feg[167] = 0.0198000000;
					g[168] = 8.4000000000; fxg[168] = 0.5843000000; feg[168] = 0.0196000000;
					g[169] = 8.4500000000; fxg[169] = 0.5764000000; feg[169] = 0.0193000000;
					g[170] = 8.5000000000; fxg[170] = 0.5685000000; feg[170] = 0.0191000000;
					g[171] = 8.5500000000; fxg[171] = 0.5606000000; feg[171] = 0.0189000000;
					g[172] = 8.6000000000; fxg[172] = 0.5524000000; feg[172] = 0.0187000000;
					g[173] = 8.6500000000; fxg[173] = 0.5442000000; feg[173] = 0.0185000000;
					g[174] = 8.7000000000; fxg[174] = 0.5365000000; feg[174] = 0.0183000000;
					g[175] = 8.7500000000; fxg[175] = 0.5298000000; feg[175] = 0.0181000000;
					g[176] = 8.8000000000; fxg[176] = 0.5247000000; feg[176] = 0.0179000000;
					g[177] = 8.8500000000; fxg[177] = 0.5212000000; feg[177] = 0.0177000000;
					g[178] = 8.9000000000; fxg[178] = 0.5191000000; feg[178] = 0.0175000000;
					g[179] = 8.9500000000; fxg[179] = 0.5176000000; feg[179] = 0.0173000000;
					g[180] = 9.0000000000; fxg[180] = 0.5157000000; feg[180] = 0.0171000000;
					g[181] = 9.0500000000; fxg[181] = 0.5126000000; feg[181] = 0.0169000000;
					g[182] = 9.1000000000; fxg[182] = 0.5079000000; feg[182] = 0.0168000000;
					g[183] = 9.1500000000; fxg[183] = 0.5018000000; feg[183] = 0.0166000000;
					g[184] = 9.2000000000; fxg[184] = 0.4948000000; feg[184] = 0.0164000000;
					g[185] = 9.2500000000; fxg[185] = 0.4877000000; feg[185] = 0.0162000000;
					g[186] = 9.3000000000; fxg[186] = 0.4809000000; feg[186] = 0.0161000000;
					g[187] = 9.3500000000; fxg[187] = 0.4746000000; feg[187] = 0.0159000000;
					g[188] = 9.4000000000; fxg[188] = 0.4683000000; feg[188] = 0.0157000000;
					g[189] = 9.4500000000; fxg[189] = 0.4619000000; feg[189] = 0.0156000000;
					g[190] = 9.5000000000; fxg[190] = 0.4550000000; feg[190] = 0.0154000000;
					g[191] = 9.5500000000; fxg[191] = 0.4479000000; feg[191] = 0.0153000000;
					g[192] = 9.6000000000; fxg[192] = 0.4407000000; feg[192] = 0.0151000000;
					g[193] = 9.6500000000; fxg[193] = 0.4343000000; feg[193] = 0.0150000000;
					g[194] = 9.7000000000; fxg[194] = 0.4291000000; feg[194] = 0.0148000000;
					g[195] = 9.7500000000; fxg[195] = 0.4255000000; feg[195] = 0.0147000000;
					g[196] = 9.8000000000; fxg[196] = 0.4236000000; feg[196] = 0.0145000000;
					g[197] = 9.8500000000; fxg[197] = 0.4229000000; feg[197] = 0.0144000000;
					g[198] = 9.9000000000; fxg[198] = 0.4226000000; feg[198] = 0.0142000000;
					g[199] = 9.9500000000; fxg[199] = 0.4216000000; feg[199] = 0.0141000000;
					g[200] = 10.0000000000; fxg[200] = 0.4194000000; feg[200] = 0.0140000000;
					g[201] = 10.0500000000; fxg[201] = 0.4155000000; feg[201] = 0.0138000000;
					g[202] = 10.1000000000; fxg[202] = 0.4101000000; feg[202] = 0.0137000000;
					g[203] = 10.1500000000; fxg[203] = 0.4039000000; feg[203] = 0.0136000000;
					g[204] = 10.2000000000; fxg[204] = 0.3975000000; feg[204] = 0.0134000000;
					g[205] = 10.2500000000; fxg[205] = 0.3917000000; feg[205] = 0.0133000000;
					g[206] = 10.3000000000; fxg[206] = 0.3865000000; feg[206] = 0.0132000000;
					g[207] = 10.3500000000; fxg[207] = 0.3819000000; feg[207] = 0.0131000000;
					g[208] = 10.4000000000; fxg[208] = 0.3774000000; feg[208] = 0.0129000000;
					g[209] = 10.4500000000; fxg[209] = 0.3725000000; feg[209] = 0.0128000000;
					g[210] = 10.5000000000; fxg[210] = 0.3670000000; feg[210] = 0.0127000000;
					g[211] = 10.5500000000; fxg[211] = 0.3609000000; feg[211] = 0.0126000000;
					g[212] = 10.6000000000; fxg[212] = 0.3545000000; feg[212] = 0.0125000000;
					g[213] = 10.6500000000; fxg[213] = 0.3485000000; feg[213] = 0.0124000000;
					g[214] = 10.7000000000; fxg[214] = 0.3433000000; feg[214] = 0.0123000000;
					g[215] = 10.7500000000; fxg[215] = 0.3396000000; feg[215] = 0.0121000000;
					g[216] = 10.8000000000; fxg[216] = 0.3376000000; feg[216] = 0.0120000000;
					g[217] = 10.8500000000; fxg[217] = 0.3372000000; feg[217] = 0.0119000000;
					g[218] = 10.9000000000; fxg[218] = 0.3378000000; feg[218] = 0.0118000000;
					g[219] = 10.9500000000; fxg[219] = 0.3384000000; feg[219] = 0.0117000000;
					g[220] = 11.0000000000; fxg[220] = 0.3383000000; feg[220] = 0.0116000000;
					g[221] = 11.0500000000; fxg[221] = 0.3368000000; feg[221] = 0.0115000000;
					g[222] = 11.1000000000; fxg[222] = 0.3335000000; feg[222] = 0.0114000000;
					g[223] = 11.1500000000; fxg[223] = 0.3288000000; feg[223] = 0.0113000000;
					g[224] = 11.2000000000; fxg[224] = 0.3232000000; feg[224] = 0.0112000000;
					g[225] = 11.2500000000; fxg[225] = 0.3174000000; feg[225] = 0.0111000000;
					g[226] = 11.3000000000; fxg[226] = 0.3121000000; feg[226] = 0.0110000000;
					g[227] = 11.3500000000; fxg[227] = 0.3078000000; feg[227] = 0.0109000000;
					g[228] = 11.4000000000; fxg[228] = 0.3044000000; feg[228] = 0.0108000000;
					g[229] = 11.4500000000; fxg[229] = 0.3016000000; feg[229] = 0.0107000000;
					g[230] = 11.5000000000; fxg[230] = 0.2987000000; feg[230] = 0.0106000000;
					g[231] = 11.5500000000; fxg[231] = 0.2954000000; feg[231] = 0.0106000000;
					g[232] = 11.6000000000; fxg[232] = 0.2911000000; feg[232] = 0.0105000000;
					g[233] = 11.6500000000; fxg[233] = 0.2862000000; feg[233] = 0.0104000000;
					g[234] = 11.7000000000; fxg[234] = 0.2807000000; feg[234] = 0.0103000000;
					g[235] = 11.7500000000; fxg[235] = 0.2751000000; feg[235] = 0.0102000000;
					g[236] = 11.8000000000; fxg[236] = 0.2701000000; feg[236] = 0.0101000000;
					g[237] = 11.8500000000; fxg[237] = 0.2660000000; feg[237] = 0.0100000000;
					g[238] = 11.9000000000; fxg[238] = 0.2634000000; feg[238] = 0.0100000000;
					g[239] = 11.9500000000; fxg[239] = 0.2626000000; feg[239] = 0.0099000000;
					g[240] = 12.0000000000; fxg[240] = 0.2632000000; feg[240] = 0.0098000000;
					break;
				case 16:
					g[0] = 0.0000000000; fxg[0] = 16.0000000000; feg[0] = 5.2539000000;
					g[1] = 0.0500000000; fxg[1] = 15.8644000000; feg[1] = 5.1931000000;
					g[2] = 0.1000000000; fxg[2] = 15.4758000000; feg[2] = 5.0181000000;
					g[3] = 0.1500000000; fxg[3] = 14.8838000000; feg[3] = 4.7492000000;
					g[4] = 0.2000000000; fxg[4] = 14.1556000000; feg[4] = 4.4144000000;
					g[5] = 0.2500000000; fxg[5] = 13.3605000000; feg[5] = 4.0430000000;
					g[6] = 0.3000000000; fxg[6] = 12.5584000000; feg[6] = 3.6609000000;
					g[7] = 0.3500000000; fxg[7] = 11.7930000000; feg[7] = 3.2878000000;
					g[8] = 0.4000000000; fxg[8] = 11.0913000000; feg[8] = 2.9371000000;
					g[9] = 0.4500000000; fxg[9] = 10.4660000000; feg[9] = 2.6163000000;
					g[10] = 0.5000000000; fxg[10] = 9.9193000000; feg[10] = 2.3285000000;
					g[11] = 0.5500000000; fxg[11] = 9.4464000000; feg[11] = 2.0741000000;
					g[12] = 0.6000000000; fxg[12] = 9.0388000000; feg[12] = 1.8512000000;
					g[13] = 0.6500000000; fxg[13] = 8.6862000000; feg[13] = 1.6572000000;
					g[14] = 0.7000000000; fxg[14] = 8.3783000000; feg[14] = 1.4891000000;
					g[15] = 0.7500000000; fxg[15] = 8.1055000000; feg[15] = 1.3436000000;
					g[16] = 0.8000000000; fxg[16] = 7.8592000000; feg[16] = 1.2177000000;
					g[17] = 0.8500000000; fxg[17] = 7.6325000000; feg[17] = 1.1087000000;
					g[18] = 0.9000000000; fxg[18] = 7.4196000000; feg[18] = 1.0141000000;
					g[19] = 0.9500000000; fxg[19] = 7.2161000000; feg[19] = 0.9318000000;
					g[20] = 1.0000000000; fxg[20] = 7.0186000000; feg[20] = 0.8598000000;
					g[21] = 1.0500000000; fxg[21] = 6.8249000000; feg[21] = 0.7967000000;
					g[22] = 1.1000000000; fxg[22] = 6.6334000000; feg[22] = 0.7411000000;
					g[23] = 1.1500000000; fxg[23] = 6.4430000000; feg[23] = 0.6918000000;
					g[24] = 1.2000000000; fxg[24] = 6.2535000000; feg[24] = 0.6480000000;
					g[25] = 1.2500000000; fxg[25] = 6.0646000000; feg[25] = 0.6087000000;
					g[26] = 1.3000000000; fxg[26] = 5.8765000000; feg[26] = 0.5735000000;
					g[27] = 1.3500000000; fxg[27] = 5.6895000000; feg[27] = 0.5416000000;
					g[28] = 1.4000000000; fxg[28] = 5.5041000000; feg[28] = 0.5127000000;
					g[29] = 1.4500000000; fxg[29] = 5.3208000000; feg[29] = 0.4863000000;
					g[30] = 1.5000000000; fxg[30] = 5.1401000000; feg[30] = 0.4621000000;
					g[31] = 1.5500000000; fxg[31] = 4.9625000000; feg[31] = 0.4398000000;
					g[32] = 1.6000000000; fxg[32] = 4.7886000000; feg[32] = 0.4193000000;
					g[33] = 1.6500000000; fxg[33] = 4.6187000000; feg[33] = 0.4002000000;
					g[34] = 1.7000000000; fxg[34] = 4.4533000000; feg[34] = 0.3825000000;
					g[35] = 1.7500000000; fxg[35] = 4.2926000000; feg[35] = 0.3660000000;
					g[36] = 1.8000000000; fxg[36] = 4.1371000000; feg[36] = 0.3505000000;
					g[37] = 1.8500000000; fxg[37] = 3.9868000000; feg[37] = 0.3360000000;
					g[38] = 1.9000000000; fxg[38] = 3.8420000000; feg[38] = 0.3224000000;
					g[39] = 1.9500000000; fxg[39] = 3.7027000000; feg[39] = 0.3096000000;
					g[40] = 2.0000000000; fxg[40] = 3.5691000000; feg[40] = 0.2975000000;
					g[41] = 2.0500000000; fxg[41] = 3.4412000000; feg[41] = 0.2861000000;
					g[42] = 2.1000000000; fxg[42] = 3.3188000000; feg[42] = 0.2753000000;
					g[43] = 2.1500000000; fxg[43] = 3.2021000000; feg[43] = 0.2651000000;
					g[44] = 2.2000000000; fxg[44] = 3.0909000000; feg[44] = 0.2553000000;
					g[45] = 2.2500000000; fxg[45] = 2.9851000000; feg[45] = 0.2461000000;
					g[46] = 2.3000000000; fxg[46] = 2.8845000000; feg[46] = 0.2374000000;
					g[47] = 2.3500000000; fxg[47] = 2.7891000000; feg[47] = 0.2290000000;
					g[48] = 2.4000000000; fxg[48] = 2.6987000000; feg[48] = 0.2211000000;
					g[49] = 2.4500000000; fxg[49] = 2.6131000000; feg[49] = 0.2135000000;
					g[50] = 2.5000000000; fxg[50] = 2.5320000000; feg[50] = 0.2063000000;
					g[51] = 2.5500000000; fxg[51] = 2.4554000000; feg[51] = 0.1994000000;
					g[52] = 2.6000000000; fxg[52] = 2.3830000000; feg[52] = 0.1928000000;
					g[53] = 2.6500000000; fxg[53] = 2.3147000000; feg[53] = 0.1866000000;
					g[54] = 2.7000000000; fxg[54] = 2.2503000000; feg[54] = 0.1806000000;
					g[55] = 2.7500000000; fxg[55] = 2.1896000000; feg[55] = 0.1748000000;
					g[56] = 2.8000000000; fxg[56] = 2.1322000000; feg[56] = 0.1693000000;
					g[57] = 2.8500000000; fxg[57] = 2.0782000000; feg[57] = 0.1641000000;
					g[58] = 2.9000000000; fxg[58] = 2.0274000000; feg[58] = 0.1591000000;
					g[59] = 2.9500000000; fxg[59] = 1.9795000000; feg[59] = 0.1542000000;
					g[60] = 3.0000000000; fxg[60] = 1.9345000000; feg[60] = 0.1496000000;
					g[61] = 3.0500000000; fxg[61] = 1.8920000000; feg[61] = 0.1452000000;
					g[62] = 3.1000000000; fxg[62] = 1.8518000000; feg[62] = 0.1409000000;
					g[63] = 3.1500000000; fxg[63] = 1.8140000000; feg[63] = 0.1369000000;
					g[64] = 3.2000000000; fxg[64] = 1.7784000000; feg[64] = 0.1330000000;
					g[65] = 3.2500000000; fxg[65] = 1.7449000000; feg[65] = 0.1292000000;
					g[66] = 3.3000000000; fxg[66] = 1.7135000000; feg[66] = 0.1256000000;
					g[67] = 3.3500000000; fxg[67] = 1.6837000000; feg[67] = 0.1221000000;
					g[68] = 3.4000000000; fxg[68] = 1.6553000000; feg[68] = 0.1188000000;
					g[69] = 3.4500000000; fxg[69] = 1.6284000000; feg[69] = 0.1156000000;
					g[70] = 3.5000000000; fxg[70] = 1.6030000000; feg[70] = 0.1125000000;
					g[71] = 3.5500000000; fxg[71] = 1.5791000000; feg[71] = 0.1095000000;
					g[72] = 3.6000000000; fxg[72] = 1.5567000000; feg[72] = 0.1067000000;
					g[73] = 3.6500000000; fxg[73] = 1.5355000000; feg[73] = 0.1039000000;
					g[74] = 3.7000000000; fxg[74] = 1.5153000000; feg[74] = 0.1013000000;
					g[75] = 3.7500000000; fxg[75] = 1.4957000000; feg[75] = 0.0987000000;
					g[76] = 3.8000000000; fxg[76] = 1.4768000000; feg[76] = 0.0963000000;
					g[77] = 3.8500000000; fxg[77] = 1.4587000000; feg[77] = 0.0939000000;
					g[78] = 3.9000000000; fxg[78] = 1.4417000000; feg[78] = 0.0916000000;
					g[79] = 3.9500000000; fxg[79] = 1.4257000000; feg[79] = 0.0894000000;
					g[80] = 4.0000000000; fxg[80] = 1.4107000000; feg[80] = 0.0873000000;
					g[81] = 4.0500000000; fxg[81] = 1.3964000000; feg[81] = 0.0852000000;
					g[82] = 4.1000000000; fxg[82] = 1.3823000000; feg[82] = 0.0832000000;
					g[83] = 4.1500000000; fxg[83] = 1.3682000000; feg[83] = 0.0813000000;
					g[84] = 4.2000000000; fxg[84] = 1.3543000000; feg[84] = 0.0795000000;
					g[85] = 4.2500000000; fxg[85] = 1.3408000000; feg[85] = 0.0777000000;
					g[86] = 4.3000000000; fxg[86] = 1.3280000000; feg[86] = 0.0760000000;
					g[87] = 4.3500000000; fxg[87] = 1.3161000000; feg[87] = 0.0743000000;
					g[88] = 4.4000000000; fxg[88] = 1.3050000000; feg[88] = 0.0727000000;
					g[89] = 4.4500000000; fxg[89] = 1.2944000000; feg[89] = 0.0711000000;
					g[90] = 4.5000000000; fxg[90] = 1.2839000000; feg[90] = 0.0696000000;
					g[91] = 4.5500000000; fxg[91] = 1.2731000000; feg[91] = 0.0681000000;
					g[92] = 4.6000000000; fxg[92] = 1.2620000000; feg[92] = 0.0667000000;
					g[93] = 4.6500000000; fxg[93] = 1.2506000000; feg[93] = 0.0653000000;
					g[94] = 4.7000000000; fxg[94] = 1.2394000000; feg[94] = 0.0640000000;
					g[95] = 4.7500000000; fxg[95] = 1.2288000000; feg[95] = 0.0627000000;
					g[96] = 4.8000000000; fxg[96] = 1.2190000000; feg[96] = 0.0614000000;
					g[97] = 4.8500000000; fxg[97] = 1.2101000000; feg[97] = 0.0602000000;
					g[98] = 4.9000000000; fxg[98] = 1.2017000000; feg[98] = 0.0590000000;
					g[99] = 4.9500000000; fxg[99] = 1.1934000000; feg[99] = 0.0579000000;
					g[100] = 5.0000000000; fxg[100] = 1.1846000000; feg[100] = 0.0567000000;
					g[101] = 5.0500000000; fxg[101] = 1.1752000000; feg[101] = 0.0557000000;
					g[102] = 5.1000000000; fxg[102] = 1.1651000000; feg[102] = 0.0546000000;
					g[103] = 5.1500000000; fxg[103] = 1.1546000000; feg[103] = 0.0536000000;
					g[104] = 5.2000000000; fxg[104] = 1.1443000000; feg[104] = 0.0526000000;
					g[105] = 5.2500000000; fxg[105] = 1.1346000000; feg[105] = 0.0516000000;
					g[106] = 5.3000000000; fxg[106] = 1.1257000000; feg[106] = 0.0507000000;
					g[107] = 5.3500000000; fxg[107] = 1.1179000000; feg[107] = 0.0498000000;
					g[108] = 5.4000000000; fxg[108] = 1.1107000000; feg[108] = 0.0489000000;
					g[109] = 5.4500000000; fxg[109] = 1.1037000000; feg[109] = 0.0480000000;
					g[110] = 5.5000000000; fxg[110] = 1.0962000000; feg[110] = 0.0472000000;
					g[111] = 5.5500000000; fxg[111] = 1.0880000000; feg[111] = 0.0463000000;
					g[112] = 5.6000000000; fxg[112] = 1.0788000000; feg[112] = 0.0456000000;
					g[113] = 5.6500000000; fxg[113] = 1.0689000000; feg[113] = 0.0448000000;
					g[114] = 5.7000000000; fxg[114] = 1.0586000000; feg[114] = 0.0440000000;
					g[115] = 5.7500000000; fxg[115] = 1.0485000000; feg[115] = 0.0433000000;
					g[116] = 5.8000000000; fxg[116] = 1.0389000000; feg[116] = 0.0426000000;
					g[117] = 5.8500000000; fxg[117] = 1.0303000000; feg[117] = 0.0419000000;
					g[118] = 5.9000000000; fxg[118] = 1.0229000000; feg[118] = 0.0412000000;
					g[119] = 5.9500000000; fxg[119] = 1.0163000000; feg[119] = 0.0405000000;
					g[120] = 6.0000000000; fxg[120] = 1.0103000000; feg[120] = 0.0399000000;
					g[121] = 6.0500000000; fxg[121] = 1.0039000000; feg[121] = 0.0392000000;
					g[122] = 6.1000000000; fxg[122] = 0.9968000000; feg[122] = 0.0386000000;
					g[123] = 6.1500000000; fxg[123] = 0.9886000000; feg[123] = 0.0380000000;
					g[124] = 6.2000000000; fxg[124] = 0.9794000000; feg[124] = 0.0374000000;
					g[125] = 6.2500000000; fxg[125] = 0.9695000000; feg[125] = 0.0368000000;
					g[126] = 6.3000000000; fxg[126] = 0.9592000000; feg[126] = 0.0363000000;
					g[127] = 6.3500000000; fxg[127] = 0.9490000000; feg[127] = 0.0357000000;
					g[128] = 6.4000000000; fxg[128] = 0.9394000000; feg[128] = 0.0352000000;
					g[129] = 6.4500000000; fxg[129] = 0.9307000000; feg[129] = 0.0347000000;
					g[130] = 6.5000000000; fxg[130] = 0.9232000000; feg[130] = 0.0342000000;
					g[131] = 6.5500000000; fxg[131] = 0.9169000000; feg[131] = 0.0337000000;
					g[132] = 6.6000000000; fxg[132] = 0.9115000000; feg[132] = 0.0332000000;
					g[133] = 6.6500000000; fxg[133] = 0.9063000000; feg[133] = 0.0327000000;
					g[134] = 6.7000000000; fxg[134] = 0.9006000000; feg[134] = 0.0322000000;
					g[135] = 6.7500000000; fxg[135] = 0.8938000000; feg[135] = 0.0317000000;
					g[136] = 6.8000000000; fxg[136] = 0.8859000000; feg[136] = 0.0313000000;
					g[137] = 6.8500000000; fxg[137] = 0.8769000000; feg[137] = 0.0309000000;
					g[138] = 6.9000000000; fxg[138] = 0.8672000000; feg[138] = 0.0304000000;
					g[139] = 6.9500000000; fxg[139] = 0.8571000000; feg[139] = 0.0300000000;
					g[140] = 7.0000000000; fxg[140] = 0.8470000000; feg[140] = 0.0296000000;
					g[141] = 7.0500000000; fxg[141] = 0.8372000000; feg[141] = 0.0292000000;
					g[142] = 7.1000000000; fxg[142] = 0.8282000000; feg[142] = 0.0288000000;
					g[143] = 7.1500000000; fxg[143] = 0.8202000000; feg[143] = 0.0284000000;
					g[144] = 7.2000000000; fxg[144] = 0.8137000000; feg[144] = 0.0280000000;
					g[145] = 7.2500000000; fxg[145] = 0.8084000000; feg[145] = 0.0277000000;
					g[146] = 7.3000000000; fxg[146] = 0.8040000000; feg[146] = 0.0273000000;
					g[147] = 7.3500000000; fxg[147] = 0.7998000000; feg[147] = 0.0269000000;
					g[148] = 7.4000000000; fxg[148] = 0.7950000000; feg[148] = 0.0266000000;
					g[149] = 7.4500000000; fxg[149] = 0.7890000000; feg[149] = 0.0262000000;
					g[150] = 7.5000000000; fxg[150] = 0.7818000000; feg[150] = 0.0259000000;
					g[151] = 7.5500000000; fxg[151] = 0.7736000000; feg[151] = 0.0256000000;
					g[152] = 7.6000000000; fxg[152] = 0.7645000000; feg[152] = 0.0253000000;
					g[153] = 7.6500000000; fxg[153] = 0.7551000000; feg[153] = 0.0249000000;
					g[154] = 7.7000000000; fxg[154] = 0.7455000000; feg[154] = 0.0246000000;
					g[155] = 7.7500000000; fxg[155] = 0.7359000000; feg[155] = 0.0243000000;
					g[156] = 7.8000000000; fxg[156] = 0.7266000000; feg[156] = 0.0240000000;
					g[157] = 7.8500000000; fxg[157] = 0.7180000000; feg[157] = 0.0237000000;
					g[158] = 7.9000000000; fxg[158] = 0.7105000000; feg[158] = 0.0235000000;
					g[159] = 7.9500000000; fxg[159] = 0.7043000000; feg[159] = 0.0232000000;
					g[160] = 8.0000000000; fxg[160] = 0.6997000000; feg[160] = 0.0229000000;
					g[161] = 8.0500000000; fxg[161] = 0.6962000000; feg[161] = 0.0226000000;
					g[162] = 8.1000000000; fxg[162] = 0.6931000000; feg[162] = 0.0223000000;
					g[163] = 8.1500000000; fxg[163] = 0.6897000000; feg[163] = 0.0221000000;
					g[164] = 8.2000000000; fxg[164] = 0.6854000000; feg[164] = 0.0218000000;
					g[165] = 8.2500000000; fxg[165] = 0.6797000000; feg[165] = 0.0215000000;
					g[166] = 8.3000000000; fxg[166] = 0.6727000000; feg[166] = 0.0213000000;
					g[167] = 8.3500000000; fxg[167] = 0.6649000000; feg[167] = 0.0211000000;
					g[168] = 8.4000000000; fxg[168] = 0.6565000000; feg[168] = 0.0208000000;
					g[169] = 8.4500000000; fxg[169] = 0.6479000000; feg[169] = 0.0206000000;
					g[170] = 8.5000000000; fxg[170] = 0.6393000000; feg[170] = 0.0204000000;
					g[171] = 8.5500000000; fxg[171] = 0.6306000000; feg[171] = 0.0201000000;
					g[172] = 8.6000000000; fxg[172] = 0.6219000000; feg[172] = 0.0199000000;
					g[173] = 8.6500000000; fxg[173] = 0.6135000000; feg[173] = 0.0197000000;
					g[174] = 8.7000000000; fxg[174] = 0.6058000000; feg[174] = 0.0195000000;
					g[175] = 8.7500000000; fxg[175] = 0.5993000000; feg[175] = 0.0193000000;
					g[176] = 8.8000000000; fxg[176] = 0.5943000000; feg[176] = 0.0190000000;
					g[177] = 8.8500000000; fxg[177] = 0.5909000000; feg[177] = 0.0188000000;
					g[178] = 8.9000000000; fxg[178] = 0.5886000000; feg[178] = 0.0186000000;
					g[179] = 8.9500000000; fxg[179] = 0.5868000000; feg[179] = 0.0184000000;
					g[180] = 9.0000000000; fxg[180] = 0.5846000000; feg[180] = 0.0182000000;
					g[181] = 9.0500000000; fxg[181] = 0.5814000000; feg[181] = 0.0180000000;
					g[182] = 9.1000000000; fxg[182] = 0.5768000000; feg[182] = 0.0178000000;
					g[183] = 9.1500000000; fxg[183] = 0.5709000000; feg[183] = 0.0176000000;
					g[184] = 9.2000000000; fxg[184] = 0.5640000000; feg[184] = 0.0175000000;
					g[185] = 9.2500000000; fxg[185] = 0.5566000000; feg[185] = 0.0173000000;
					g[186] = 9.3000000000; fxg[186] = 0.5492000000; feg[186] = 0.0171000000;
					g[187] = 9.3500000000; fxg[187] = 0.5418000000; feg[187] = 0.0169000000;
					g[188] = 9.4000000000; fxg[188] = 0.5344000000; feg[188] = 0.0168000000;
					g[189] = 9.4500000000; fxg[189] = 0.5269000000; feg[189] = 0.0166000000;
					g[190] = 9.5000000000; fxg[190] = 0.5193000000; feg[190] = 0.0164000000;
					g[191] = 9.5500000000; fxg[191] = 0.5116000000; feg[191] = 0.0163000000;
					g[192] = 9.6000000000; fxg[192] = 0.5044000000; feg[192] = 0.0161000000;
					g[193] = 9.6500000000; fxg[193] = 0.4980000000; feg[193] = 0.0159000000;
					g[194] = 9.7000000000; fxg[194] = 0.4929000000; feg[194] = 0.0158000000;
					g[195] = 9.7500000000; fxg[195] = 0.4894000000; feg[195] = 0.0156000000;
					g[196] = 9.8000000000; fxg[196] = 0.4875000000; feg[196] = 0.0155000000;
					g[197] = 9.8500000000; fxg[197] = 0.4866000000; feg[197] = 0.0153000000;
					g[198] = 9.9000000000; fxg[198] = 0.4860000000; feg[198] = 0.0152000000;
					g[199] = 9.9500000000; fxg[199] = 0.4849000000; feg[199] = 0.0150000000;
					g[200] = 10.0000000000; fxg[200] = 0.4826000000; feg[200] = 0.0149000000;
					g[201] = 10.0500000000; fxg[201] = 0.4788000000; feg[201] = 0.0147000000;
					g[202] = 10.1000000000; fxg[202] = 0.4737000000; feg[202] = 0.0146000000;
					g[203] = 10.1500000000; fxg[203] = 0.4675000000; feg[203] = 0.0144000000;
					g[204] = 10.2000000000; fxg[204] = 0.4610000000; feg[204] = 0.0143000000;
					g[205] = 10.2500000000; fxg[205] = 0.4545000000; feg[205] = 0.0142000000;
					g[206] = 10.3000000000; fxg[206] = 0.4484000000; feg[206] = 0.0140000000;
					g[207] = 10.3500000000; fxg[207] = 0.4425000000; feg[207] = 0.0139000000;
					g[208] = 10.4000000000; fxg[208] = 0.4367000000; feg[208] = 0.0138000000;
					g[209] = 10.4500000000; fxg[209] = 0.4306000000; feg[209] = 0.0136000000;
					g[210] = 10.5000000000; fxg[210] = 0.4242000000; feg[210] = 0.0135000000;
					g[211] = 10.5500000000; fxg[211] = 0.4175000000; feg[211] = 0.0134000000;
					g[212] = 10.6000000000; fxg[212] = 0.4108000000; feg[212] = 0.0133000000;
					g[213] = 10.6500000000; fxg[213] = 0.4047000000; feg[213] = 0.0132000000;
					g[214] = 10.7000000000; fxg[214] = 0.3996000000; feg[214] = 0.0130000000;
					g[215] = 10.7500000000; fxg[215] = 0.3961000000; feg[215] = 0.0129000000;
					g[216] = 10.8000000000; fxg[216] = 0.3941000000; feg[216] = 0.0128000000;
					g[217] = 10.8500000000; fxg[217] = 0.3937000000; feg[217] = 0.0127000000;
					g[218] = 10.9000000000; fxg[218] = 0.3941000000; feg[218] = 0.0126000000;
					g[219] = 10.9500000000; fxg[219] = 0.3946000000; feg[219] = 0.0125000000;
					g[220] = 11.0000000000; fxg[220] = 0.3944000000; feg[220] = 0.0123000000;
					g[221] = 11.0500000000; fxg[221] = 0.3929000000; feg[221] = 0.0122000000;
					g[222] = 11.1000000000; fxg[222] = 0.3898000000; feg[222] = 0.0121000000;
					g[223] = 11.1500000000; fxg[223] = 0.3853000000; feg[223] = 0.0120000000;
					g[224] = 11.2000000000; fxg[224] = 0.3797000000; feg[224] = 0.0119000000;
					g[225] = 11.2500000000; fxg[225] = 0.3738000000; feg[225] = 0.0118000000;
					g[226] = 11.3000000000; fxg[226] = 0.3681000000; feg[226] = 0.0117000000;
					g[227] = 11.3500000000; fxg[227] = 0.3630000000; feg[227] = 0.0116000000;
					g[228] = 11.4000000000; fxg[228] = 0.3585000000; feg[228] = 0.0115000000;
					g[229] = 11.4500000000; fxg[229] = 0.3543000000; feg[229] = 0.0114000000;
					g[230] = 11.5000000000; fxg[230] = 0.3502000000; feg[230] = 0.0113000000;
					g[231] = 11.5500000000; fxg[231] = 0.3456000000; feg[231] = 0.0112000000;
					g[232] = 11.6000000000; fxg[232] = 0.3405000000; feg[232] = 0.0111000000;
					g[233] = 11.6500000000; fxg[233] = 0.3348000000; feg[233] = 0.0110000000;
					g[234] = 11.7000000000; fxg[234] = 0.3288000000; feg[234] = 0.0110000000;
					g[235] = 11.7500000000; fxg[235] = 0.3230000000; feg[235] = 0.0109000000;
					g[236] = 11.8000000000; fxg[236] = 0.3179000000; feg[236] = 0.0108000000;
					g[237] = 11.8500000000; fxg[237] = 0.3140000000; feg[237] = 0.0107000000;
					g[238] = 11.9000000000; fxg[238] = 0.3116000000; feg[238] = 0.0106000000;
					g[239] = 11.9500000000; fxg[239] = 0.3108000000; feg[239] = 0.0105000000;
					g[240] = 12.0000000000; fxg[240] = 0.3114000000; feg[240] = 0.0104000000;
					break;
				case 17:
					g[0] = 0.0000000000; fxg[0] = 17.0000000000; feg[0] = 4.9048000000;
					g[1] = 0.0500000000; fxg[1] = 16.8731000000; feg[1] = 4.8591000000;
					g[2] = 0.1000000000; fxg[2] = 16.5063000000; feg[2] = 4.7265000000;
					g[3] = 0.1500000000; fxg[3] = 15.9378000000; feg[3] = 4.5195000000;
					g[4] = 0.2000000000; fxg[4] = 15.2218000000; feg[4] = 4.2559000000;
					g[5] = 0.2500000000; fxg[5] = 14.4178000000; feg[5] = 3.9554000000;
					g[6] = 0.3000000000; fxg[6] = 13.5811000000; feg[6] = 3.6368000000;
					g[7] = 0.3500000000; fxg[7] = 12.7571000000; feg[7] = 3.3159000000;
					g[8] = 0.4000000000; fxg[8] = 11.9782000000; feg[8] = 3.0047000000;
					g[9] = 0.4500000000; fxg[9] = 11.2647000000; feg[9] = 2.7115000000;
					g[10] = 0.5000000000; fxg[10] = 10.6259000000; feg[10] = 2.4409000000;
					g[11] = 0.5500000000; fxg[11] = 10.0636000000; feg[11] = 2.1952000000;
					g[12] = 0.6000000000; fxg[12] = 9.5739000000; feg[12] = 1.9748000000;
					g[13] = 0.6500000000; fxg[13] = 9.1498000000; feg[13] = 1.7788000000;
					g[14] = 0.7000000000; fxg[14] = 8.7827000000; feg[14] = 1.6055000000;
					g[15] = 0.7500000000; fxg[15] = 8.4633000000; feg[15] = 1.4529000000;
					g[16] = 0.8000000000; fxg[16] = 8.1830000000; feg[16] = 1.3189000000;
					g[17] = 0.8500000000; fxg[17] = 7.9336000000; feg[17] = 1.2013000000;
					g[18] = 0.9000000000; fxg[18] = 7.7082000000; feg[18] = 1.0982000000;
					g[19] = 0.9500000000; fxg[19] = 7.5007000000; feg[19] = 1.0077000000;
					g[20] = 1.0000000000; fxg[20] = 7.3064000000; feg[20] = 0.9280000000;
					g[21] = 1.0500000000; fxg[21] = 7.1213000000; feg[21] = 0.8578000000;
					g[22] = 1.1000000000; fxg[22] = 6.9424000000; feg[22] = 0.7958000000;
					g[23] = 1.1500000000; fxg[23] = 6.7676000000; feg[23] = 0.7407000000;
					g[24] = 1.2000000000; fxg[24] = 6.5951000000; feg[24] = 0.6917000000;
					g[25] = 1.2500000000; fxg[25] = 6.4241000000; feg[25] = 0.6480000000;
					g[26] = 1.3000000000; fxg[26] = 6.2538000000; feg[26] = 0.6087000000;
					g[27] = 1.3500000000; fxg[27] = 6.0839000000; feg[27] = 0.5734000000;
					g[28] = 1.4000000000; fxg[28] = 5.9144000000; feg[28] = 0.5415000000;
					g[29] = 1.4500000000; fxg[29] = 5.7455000000; feg[29] = 0.5125000000;
					g[30] = 1.5000000000; fxg[30] = 5.5773000000; feg[30] = 0.4860000000;
					g[31] = 1.5500000000; fxg[31] = 5.4102000000; feg[31] = 0.4618000000;
					g[32] = 1.6000000000; fxg[32] = 5.2447000000; feg[32] = 0.4396000000;
					g[33] = 1.6500000000; fxg[33] = 5.0810000000; feg[33] = 0.4191000000;
					g[34] = 1.7000000000; fxg[34] = 4.9198000000; feg[34] = 0.4002000000;
					g[35] = 1.7500000000; fxg[35] = 4.7613000000; feg[35] = 0.3826000000;
					g[36] = 1.8000000000; fxg[36] = 4.6060000000; feg[36] = 0.3662000000;
					g[37] = 1.8500000000; fxg[37] = 4.4541000000; feg[37] = 0.3509000000;
					g[38] = 1.9000000000; fxg[38] = 4.3060000000; feg[38] = 0.3366000000;
					g[39] = 1.9500000000; fxg[39] = 4.1619000000; feg[39] = 0.3232000000;
					g[40] = 2.0000000000; fxg[40] = 4.0221000000; feg[40] = 0.3106000000;
					g[41] = 2.0500000000; fxg[41] = 3.8867000000; feg[41] = 0.2987000000;
					g[42] = 2.1000000000; fxg[42] = 3.7559000000; feg[42] = 0.2875000000;
					g[43] = 2.1500000000; fxg[43] = 3.6297000000; feg[43] = 0.2769000000;
					g[44] = 2.2000000000; fxg[44] = 3.5082000000; feg[44] = 0.2669000000;
					g[45] = 2.2500000000; fxg[45] = 3.3915000000; feg[45] = 0.2573000000;
					g[46] = 2.3000000000; fxg[46] = 3.2795000000; feg[46] = 0.2483000000;
					g[47] = 2.3500000000; fxg[47] = 3.1722000000; feg[47] = 0.2397000000;
					g[48] = 2.4000000000; fxg[48] = 3.0696000000; feg[48] = 0.2315000000;
					g[49] = 2.4500000000; fxg[49] = 2.9715000000; feg[49] = 0.2237000000;
					g[50] = 2.5000000000; fxg[50] = 2.8779000000; feg[50] = 0.2163000000;
					g[51] = 2.5500000000; fxg[51] = 2.7888000000; feg[51] = 0.2092000000;
					g[52] = 2.6000000000; fxg[52] = 2.7038000000; feg[52] = 0.2025000000;
					g[53] = 2.6500000000; fxg[53] = 2.6231000000; feg[53] = 0.1960000000;
					g[54] = 2.7000000000; fxg[54] = 2.5463000000; feg[54] = 0.1898000000;
					g[55] = 2.7500000000; fxg[55] = 2.4734000000; feg[55] = 0.1839000000;
					g[56] = 2.8000000000; fxg[56] = 2.4042000000; feg[56] = 0.1782000000;
					g[57] = 2.8500000000; fxg[57] = 2.3386000000; feg[57] = 0.1728000000;
					g[58] = 2.9000000000; fxg[58] = 2.2764000000; feg[58] = 0.1676000000;
					g[59] = 2.9500000000; fxg[59] = 2.2175000000; feg[59] = 0.1626000000;
					g[60] = 3.0000000000; fxg[60] = 2.1618000000; feg[60] = 0.1578000000;
					g[61] = 3.0500000000; fxg[61] = 2.1090000000; feg[61] = 0.1532000000;
					g[62] = 3.1000000000; fxg[62] = 2.0590000000; feg[62] = 0.1488000000;
					g[63] = 3.1500000000; fxg[63] = 2.0116000000; feg[63] = 0.1446000000;
					g[64] = 3.2000000000; fxg[64] = 1.9669000000; feg[64] = 0.1405000000;
					g[65] = 3.2500000000; fxg[65] = 1.9247000000; feg[65] = 0.1366000000;
					g[66] = 3.3000000000; fxg[66] = 1.8847000000; feg[66] = 0.1329000000;
					g[67] = 3.3500000000; fxg[67] = 1.8469000000; feg[67] = 0.1293000000;
					g[68] = 3.4000000000; fxg[68] = 1.8110000000; feg[68] = 0.1258000000;
					g[69] = 3.4500000000; fxg[69] = 1.7770000000; feg[69] = 0.1224000000;
					g[70] = 3.5000000000; fxg[70] = 1.7448000000; feg[70] = 0.1192000000;
					g[71] = 3.5500000000; fxg[71] = 1.7145000000; feg[71] = 0.1161000000;
					g[72] = 3.6000000000; fxg[72] = 1.6858000000; feg[72] = 0.1131000000;
					g[73] = 3.6500000000; fxg[73] = 1.6587000000; feg[73] = 0.1102000000;
					g[74] = 3.7000000000; fxg[74] = 1.6329000000; feg[74] = 0.1075000000;
					g[75] = 3.7500000000; fxg[75] = 1.6082000000; feg[75] = 0.1048000000;
					g[76] = 3.8000000000; fxg[76] = 1.5847000000; feg[76] = 0.1022000000;
					g[77] = 3.8500000000; fxg[77] = 1.5623000000; feg[77] = 0.0997000000;
					g[78] = 3.9000000000; fxg[78] = 1.5411000000; feg[78] = 0.0973000000;
					g[79] = 3.9500000000; fxg[79] = 1.5212000000; feg[79] = 0.0950000000;
					g[80] = 4.0000000000; fxg[80] = 1.5023000000; feg[80] = 0.0927000000;
					g[81] = 4.0500000000; fxg[81] = 1.4843000000; feg[81] = 0.0906000000;
					g[82] = 4.1000000000; fxg[82] = 1.4669000000; feg[82] = 0.0885000000;
					g[83] = 4.1500000000; fxg[83] = 1.4500000000; feg[83] = 0.0864000000;
					g[84] = 4.2000000000; fxg[84] = 1.4336000000; feg[84] = 0.0845000000;
					g[85] = 4.2500000000; fxg[85] = 1.4179000000; feg[85] = 0.0826000000;
					g[86] = 4.3000000000; fxg[86] = 1.4029000000; feg[86] = 0.0808000000;
					g[87] = 4.3500000000; fxg[87] = 1.3889000000; feg[87] = 0.0790000000;
					g[88] = 4.4000000000; fxg[88] = 1.3756000000; feg[88] = 0.0773000000;
					g[89] = 4.4500000000; fxg[89] = 1.3630000000; feg[89] = 0.0756000000;
					g[90] = 4.5000000000; fxg[90] = 1.3506000000; feg[90] = 0.0740000000;
					g[91] = 4.5500000000; fxg[91] = 1.3383000000; feg[91] = 0.0724000000;
					g[92] = 4.6000000000; fxg[92] = 1.3260000000; feg[92] = 0.0709000000;
					g[93] = 4.6500000000; fxg[93] = 1.3137000000; feg[93] = 0.0695000000;
					g[94] = 4.7000000000; fxg[94] = 1.3018000000; feg[94] = 0.0680000000;
					g[95] = 4.7500000000; fxg[95] = 1.2905000000; feg[95] = 0.0667000000;
					g[96] = 4.8000000000; fxg[96] = 1.2799000000; feg[96] = 0.0653000000;
					g[97] = 4.8500000000; fxg[97] = 1.2701000000; feg[97] = 0.0640000000;
					g[98] = 4.9000000000; fxg[98] = 1.2607000000; feg[98] = 0.0628000000;
					g[99] = 4.9500000000; fxg[99] = 1.2515000000; feg[99] = 0.0615000000;
					g[100] = 5.0000000000; fxg[100] = 1.2421000000; feg[100] = 0.0603000000;
					g[101] = 5.0500000000; fxg[101] = 1.2323000000; feg[101] = 0.0592000000;
					g[102] = 5.1000000000; fxg[102] = 1.2221000000; feg[102] = 0.0581000000;
					g[103] = 5.1500000000; fxg[103] = 1.2118000000; feg[103] = 0.0570000000;
					g[104] = 5.2000000000; fxg[104] = 1.2017000000; feg[104] = 0.0559000000;
					g[105] = 5.2500000000; fxg[105] = 1.1921000000; feg[105] = 0.0549000000;
					g[106] = 5.3000000000; fxg[106] = 1.1833000000; feg[106] = 0.0539000000;
					g[107] = 5.3500000000; fxg[107] = 1.1752000000; feg[107] = 0.0529000000;
					g[108] = 5.4000000000; fxg[108] = 1.1677000000; feg[108] = 0.0520000000;
					g[109] = 5.4500000000; fxg[109] = 1.1603000000; feg[109] = 0.0511000000;
					g[110] = 5.5000000000; fxg[110] = 1.1527000000; feg[110] = 0.0502000000;
					g[111] = 5.5500000000; fxg[111] = 1.1444000000; feg[111] = 0.0493000000;
					g[112] = 5.6000000000; fxg[112] = 1.1355000000; feg[112] = 0.0484000000;
					g[113] = 5.6500000000; fxg[113] = 1.1261000000; feg[113] = 0.0476000000;
					g[114] = 5.7000000000; fxg[114] = 1.1164000000; feg[114] = 0.0468000000;
					g[115] = 5.7500000000; fxg[115] = 1.1069000000; feg[115] = 0.0460000000;
					g[116] = 5.8000000000; fxg[116] = 1.0979000000; feg[116] = 0.0453000000;
					g[117] = 5.8500000000; fxg[117] = 1.0897000000; feg[117] = 0.0445000000;
					g[118] = 5.9000000000; fxg[118] = 1.0824000000; feg[118] = 0.0438000000;
					g[119] = 5.9500000000; fxg[119] = 1.0759000000; feg[119] = 0.0431000000;
					g[120] = 6.0000000000; fxg[120] = 1.0696000000; feg[120] = 0.0424000000;
					g[121] = 6.0500000000; fxg[121] = 1.0632000000; feg[121] = 0.0417000000;
					g[122] = 6.1000000000; fxg[122] = 1.0562000000; feg[122] = 0.0410000000;
					g[123] = 6.1500000000; fxg[123] = 1.0483000000; feg[123] = 0.0404000000;
					g[124] = 6.2000000000; fxg[124] = 1.0396000000; feg[124] = 0.0397000000;
					g[125] = 6.2500000000; fxg[125] = 1.0302000000; feg[125] = 0.0391000000;
					g[126] = 6.3000000000; fxg[126] = 1.0206000000; feg[126] = 0.0385000000;
					g[127] = 6.3500000000; fxg[127] = 1.0111000000; feg[127] = 0.0380000000;
					g[128] = 6.4000000000; fxg[128] = 1.0020000000; feg[128] = 0.0374000000;
					g[129] = 6.4500000000; fxg[129] = 0.9939000000; feg[129] = 0.0368000000;
					g[130] = 6.5000000000; fxg[130] = 0.9868000000; feg[130] = 0.0363000000;
					g[131] = 6.5500000000; fxg[131] = 0.9806000000; feg[131] = 0.0357000000;
					g[132] = 6.6000000000; fxg[132] = 0.9751000000; feg[132] = 0.0352000000;
					g[133] = 6.6500000000; fxg[133] = 0.9698000000; feg[133] = 0.0347000000;
					g[134] = 6.7000000000; fxg[134] = 0.9640000000; feg[134] = 0.0342000000;
					g[135] = 6.7500000000; fxg[135] = 0.9574000000; feg[135] = 0.0337000000;
					g[136] = 6.8000000000; fxg[136] = 0.9498000000; feg[136] = 0.0332000000;
					g[137] = 6.8500000000; fxg[137] = 0.9412000000; feg[137] = 0.0328000000;
					g[138] = 6.9000000000; fxg[138] = 0.9319000000; feg[138] = 0.0323000000;
					g[139] = 6.9500000000; fxg[139] = 0.9222000000; feg[139] = 0.0319000000;
					g[140] = 7.0000000000; fxg[140] = 0.9126000000; feg[140] = 0.0314000000;
					g[141] = 7.0500000000; fxg[141] = 0.9033000000; feg[141] = 0.0310000000;
					g[142] = 7.1000000000; fxg[142] = 0.8947000000; feg[142] = 0.0306000000;
					g[143] = 7.1500000000; fxg[143] = 0.8872000000; feg[143] = 0.0302000000;
					g[144] = 7.2000000000; fxg[144] = 0.8809000000; feg[144] = 0.0298000000;
					g[145] = 7.2500000000; fxg[145] = 0.8757000000; feg[145] = 0.0294000000;
					g[146] = 7.3000000000; fxg[146] = 0.8711000000; feg[146] = 0.0290000000;
					g[147] = 7.3500000000; fxg[147] = 0.8667000000; feg[147] = 0.0286000000;
					g[148] = 7.4000000000; fxg[148] = 0.8617000000; feg[148] = 0.0282000000;
					g[149] = 7.4500000000; fxg[149] = 0.8559000000; feg[149] = 0.0278000000;
					g[150] = 7.5000000000; fxg[150] = 0.8489000000; feg[150] = 0.0275000000;
					g[151] = 7.5500000000; fxg[151] = 0.8409000000; feg[151] = 0.0271000000;
					g[152] = 7.6000000000; fxg[152] = 0.8320000000; feg[152] = 0.0268000000;
					g[153] = 7.6500000000; fxg[153] = 0.8227000000; feg[153] = 0.0265000000;
					g[154] = 7.7000000000; fxg[154] = 0.8131000000; feg[154] = 0.0261000000;
					g[155] = 7.7500000000; fxg[155] = 0.8036000000; feg[155] = 0.0258000000;
					g[156] = 7.8000000000; fxg[156] = 0.7946000000; feg[156] = 0.0255000000;
					g[157] = 7.8500000000; fxg[157] = 0.7863000000; feg[157] = 0.0252000000;
					g[158] = 7.9000000000; fxg[158] = 0.7791000000; feg[158] = 0.0249000000;
					g[159] = 7.9500000000; fxg[159] = 0.7731000000; feg[159] = 0.0246000000;
					g[160] = 8.0000000000; fxg[160] = 0.7685000000; feg[160] = 0.0243000000;
					g[161] = 8.0500000000; fxg[161] = 0.7648000000; feg[161] = 0.0240000000;
					g[162] = 8.1000000000; fxg[162] = 0.7614000000; feg[162] = 0.0237000000;
					g[163] = 8.1500000000; fxg[163] = 0.7578000000; feg[163] = 0.0234000000;
					g[164] = 8.2000000000; fxg[164] = 0.7533000000; feg[164] = 0.0231000000;
					g[165] = 8.2500000000; fxg[165] = 0.7477000000; feg[165] = 0.0229000000;
					g[166] = 8.3000000000; fxg[166] = 0.7410000000; feg[166] = 0.0226000000;
					g[167] = 8.3500000000; fxg[167] = 0.7332000000; feg[167] = 0.0223000000;
					g[168] = 8.4000000000; fxg[168] = 0.7248000000; feg[168] = 0.0221000000;
					g[169] = 8.4500000000; fxg[169] = 0.7159000000; feg[169] = 0.0218000000;
					g[170] = 8.5000000000; fxg[170] = 0.7069000000; feg[170] = 0.0216000000;
					g[171] = 8.5500000000; fxg[171] = 0.6978000000; feg[171] = 0.0213000000;
					g[172] = 8.6000000000; fxg[172] = 0.6890000000; feg[172] = 0.0211000000;
					g[173] = 8.6500000000; fxg[173] = 0.6806000000; feg[173] = 0.0209000000;
					g[174] = 8.7000000000; fxg[174] = 0.6732000000; feg[174] = 0.0207000000;
					g[175] = 8.7500000000; fxg[175] = 0.6669000000; feg[175] = 0.0204000000;
					g[176] = 8.8000000000; fxg[176] = 0.6620000000; feg[176] = 0.0202000000;
					g[177] = 8.8500000000; fxg[177] = 0.6585000000; feg[177] = 0.0200000000;
					g[178] = 8.9000000000; fxg[178] = 0.6559000000; feg[178] = 0.0198000000;
					g[179] = 8.9500000000; fxg[179] = 0.6537000000; feg[179] = 0.0195000000;
					g[180] = 9.0000000000; fxg[180] = 0.6513000000; feg[180] = 0.0193000000;
					g[181] = 9.0500000000; fxg[181] = 0.6480000000; feg[181] = 0.0191000000;
					g[182] = 9.1000000000; fxg[182] = 0.6435000000; feg[182] = 0.0189000000;
					g[183] = 9.1500000000; fxg[183] = 0.6377000000; feg[183] = 0.0187000000;
					g[184] = 9.2000000000; fxg[184] = 0.6309000000; feg[184] = 0.0185000000;
					g[185] = 9.2500000000; fxg[185] = 0.6234000000; feg[185] = 0.0183000000;
					g[186] = 9.3000000000; fxg[186] = 0.6155000000; feg[186] = 0.0181000000;
					g[187] = 9.3500000000; fxg[187] = 0.6074000000; feg[187] = 0.0180000000;
					g[188] = 9.4000000000; fxg[188] = 0.5993000000; feg[188] = 0.0178000000;
					g[189] = 9.4500000000; fxg[189] = 0.5911000000; feg[189] = 0.0176000000;
					g[190] = 9.5000000000; fxg[190] = 0.5830000000; feg[190] = 0.0174000000;
					g[191] = 9.5500000000; fxg[191] = 0.5751000000; feg[191] = 0.0172000000;
					g[192] = 9.6000000000; fxg[192] = 0.5679000000; feg[192] = 0.0171000000;
					g[193] = 9.6500000000; fxg[193] = 0.5616000000; feg[193] = 0.0169000000;
					g[194] = 9.7000000000; fxg[194] = 0.5567000000; feg[194] = 0.0167000000;
					g[195] = 9.7500000000; fxg[195] = 0.5533000000; feg[195] = 0.0166000000;
					g[196] = 9.8000000000; fxg[196] = 0.5512000000; feg[196] = 0.0164000000;
					g[197] = 9.8500000000; fxg[197] = 0.5500000000; feg[197] = 0.0162000000;
					g[198] = 9.9000000000; fxg[198] = 0.5491000000; feg[198] = 0.0161000000;
					g[199] = 9.9500000000; fxg[199] = 0.5477000000; feg[199] = 0.0159000000;
					g[200] = 10.0000000000; fxg[200] = 0.5453000000; feg[200] = 0.0158000000;
					g[201] = 10.0500000000; fxg[201] = 0.5416000000; feg[201] = 0.0156000000;
					g[202] = 10.1000000000; fxg[202] = 0.5367000000; feg[202] = 0.0155000000;
					g[203] = 10.1500000000; fxg[203] = 0.5306000000; feg[203] = 0.0153000000;
					g[204] = 10.2000000000; fxg[204] = 0.5240000000; feg[204] = 0.0152000000;
					g[205] = 10.2500000000; fxg[205] = 0.5171000000; feg[205] = 0.0150000000;
					g[206] = 10.3000000000; fxg[206] = 0.5102000000; feg[206] = 0.0149000000;
					g[207] = 10.3500000000; fxg[207] = 0.5033000000; feg[207] = 0.0147000000;
					g[208] = 10.4000000000; fxg[208] = 0.4964000000; feg[208] = 0.0146000000;
					g[209] = 10.4500000000; fxg[209] = 0.4894000000; feg[209] = 0.0145000000;
					g[210] = 10.5000000000; fxg[210] = 0.4822000000; feg[210] = 0.0143000000;
					g[211] = 10.5500000000; fxg[211] = 0.4751000000; feg[211] = 0.0142000000;
					g[212] = 10.6000000000; fxg[212] = 0.4683000000; feg[212] = 0.0141000000;
					g[213] = 10.6500000000; fxg[213] = 0.4622000000; feg[213] = 0.0140000000;
					g[214] = 10.7000000000; fxg[214] = 0.4574000000; feg[214] = 0.0138000000;
					g[215] = 10.7500000000; fxg[215] = 0.4540000000; feg[215] = 0.0137000000;
					g[216] = 10.8000000000; fxg[216] = 0.4521000000; feg[216] = 0.0136000000;
					g[217] = 10.8500000000; fxg[217] = 0.4514000000; feg[217] = 0.0135000000;
					g[218] = 10.9000000000; fxg[218] = 0.4515000000; feg[218] = 0.0133000000;
					g[219] = 10.9500000000; fxg[219] = 0.4518000000; feg[219] = 0.0132000000;
					g[220] = 11.0000000000; fxg[220] = 0.4514000000; feg[220] = 0.0131000000;
					g[221] = 11.0500000000; fxg[221] = 0.4498000000; feg[221] = 0.0130000000;
					g[222] = 11.1000000000; fxg[222] = 0.4469000000; feg[222] = 0.0129000000;
					g[223] = 11.1500000000; fxg[223] = 0.4426000000; feg[223] = 0.0128000000;
					g[224] = 11.2000000000; fxg[224] = 0.4373000000; feg[224] = 0.0126000000;
					g[225] = 11.2500000000; fxg[225] = 0.4313000000; feg[225] = 0.0125000000;
					g[226] = 11.3000000000; fxg[226] = 0.4253000000; feg[226] = 0.0124000000;
					g[227] = 11.3500000000; fxg[227] = 0.4195000000; feg[227] = 0.0123000000;
					g[228] = 11.4000000000; fxg[228] = 0.4139000000; feg[228] = 0.0122000000;
					g[229] = 11.4500000000; fxg[229] = 0.4085000000; feg[229] = 0.0121000000;
					g[230] = 11.5000000000; fxg[230] = 0.4031000000; feg[230] = 0.0120000000;
					g[231] = 11.5500000000; fxg[231] = 0.3975000000; feg[231] = 0.0119000000;
					g[232] = 11.6000000000; fxg[232] = 0.3915000000; feg[232] = 0.0118000000;
					g[233] = 11.6500000000; fxg[233] = 0.3852000000; feg[233] = 0.0117000000;
					g[234] = 11.7000000000; fxg[234] = 0.3789000000; feg[234] = 0.0116000000;
					g[235] = 11.7500000000; fxg[235] = 0.3731000000; feg[235] = 0.0115000000;
					g[236] = 11.8000000000; fxg[236] = 0.3681000000; feg[236] = 0.0114000000;
					g[237] = 11.8500000000; fxg[237] = 0.3643000000; feg[237] = 0.0113000000;
					g[238] = 11.9000000000; fxg[238] = 0.3621000000; feg[238] = 0.0112000000;
					g[239] = 11.9500000000; fxg[239] = 0.3614000000; feg[239] = 0.0112000000;
					g[240] = 12.0000000000; fxg[240] = 0.3619000000; feg[240] = 0.0111000000;
					break;
				case 18:
					g[0] = 0.0000000000; fxg[0] = 18.0000000000; feg[0] = 4.5815230000;
					g[1] = 0.0500000000; fxg[1] = 17.8813000000; feg[1] = 4.5466000000;
					g[2] = 0.1000000000; fxg[2] = 17.5358000000; feg[2] = 4.4445000000;
					g[3] = 0.1500000000; fxg[3] = 16.9934000000; feg[3] = 4.2831000000;
					g[4] = 0.2000000000; fxg[4] = 16.2978000000; feg[4] = 4.0740000000;
					g[5] = 0.2500000000; fxg[5] = 15.4992000000; feg[5] = 3.8307000000;
					g[6] = 0.3000000000; fxg[6] = 14.6471000000; feg[6] = 3.5665000000;
					g[7] = 0.3500000000; fxg[7] = 13.7855000000; feg[7] = 3.2937000000;
					g[8] = 0.4000000000; fxg[8] = 12.9488000000; feg[8] = 3.0223000000;
					g[9] = 0.4500000000; fxg[9] = 12.1620000000; feg[9] = 2.7600000000;
					g[10] = 0.5000000000; fxg[10] = 11.4403000000; feg[10] = 2.5120000000;
					g[11] = 0.5500000000; fxg[11] = 10.7911000000; feg[11] = 2.2815000000;
					g[12] = 0.6000000000; fxg[12] = 10.2158000000; feg[12] = 2.0701000000;
					g[13] = 0.6500000000; fxg[13] = 9.7112000000; feg[13] = 1.8782000000;
					g[14] = 0.7000000000; fxg[14] = 9.2717000000; feg[14] = 1.7053000000;
					g[15] = 0.7500000000; fxg[15] = 8.8898000000; feg[15] = 1.5505000000;
					g[16] = 0.8000000000; fxg[16] = 8.5576000000; feg[16] = 1.4124000000;
					g[17] = 0.8500000000; fxg[17] = 8.2671000000; feg[17] = 1.2897000000;
					g[18] = 0.9000000000; fxg[18] = 8.0109000000; feg[18] = 1.1806000000;
					g[19] = 0.9500000000; fxg[19] = 7.7823000000; feg[19] = 1.0839000000;
					g[20] = 1.0000000000; fxg[20] = 7.5753000000; feg[20] = 0.9980000000;
					g[21] = 1.0500000000; fxg[21] = 7.3849000000; feg[21] = 0.9218000000;
					g[22] = 1.1000000000; fxg[22] = 7.2068000000; feg[22] = 0.8540000000;
					g[23] = 1.1500000000; fxg[23] = 7.0377000000; feg[23] = 0.7935000000;
					g[24] = 1.2000000000; fxg[24] = 6.8749000000; feg[24] = 0.7396000000;
					g[25] = 1.2500000000; fxg[25] = 6.7162000000; feg[25] = 0.6914000000;
					g[26] = 1.3000000000; fxg[26] = 6.5602000000; feg[26] = 0.6480000000;
					g[27] = 1.3500000000; fxg[27] = 6.4056000000; feg[27] = 0.6090000000;
					g[28] = 1.4000000000; fxg[28] = 6.2519000000; feg[28] = 0.5738000000;
					g[29] = 1.4500000000; fxg[29] = 6.0985000000; feg[29] = 0.5419000000;
					g[30] = 1.5000000000; fxg[30] = 5.9453000000; feg[30] = 0.5129000000;
					g[31] = 1.5500000000; fxg[31] = 5.7922000000; feg[31] = 0.4865000000;
					g[32] = 1.6000000000; fxg[32] = 5.6393000000; feg[32] = 0.4622000000;
					g[33] = 1.6500000000; fxg[33] = 5.4869000000; feg[33] = 0.4400000000;
					g[34] = 1.7000000000; fxg[34] = 5.3353000000; feg[34] = 0.4195000000;
					g[35] = 1.7500000000; fxg[35] = 5.1847000000; feg[35] = 0.4006000000;
					g[36] = 1.8000000000; fxg[36] = 5.0355000000; feg[36] = 0.3831000000;
					g[37] = 1.8500000000; fxg[37] = 4.8881000000; feg[37] = 0.3668000000;
					g[38] = 1.9000000000; fxg[38] = 4.7428000000; feg[38] = 0.3516000000;
					g[39] = 1.9500000000; fxg[39] = 4.5999000000; feg[39] = 0.3374000000;
					g[40] = 2.0000000000; fxg[40] = 4.4597000000; feg[40] = 0.3241000000;
					g[41] = 2.0500000000; fxg[41] = 4.3224000000; feg[41] = 0.3116000000;
					g[42] = 2.1000000000; fxg[42] = 4.1884000000; feg[42] = 0.2998000000;
					g[43] = 2.1500000000; fxg[43] = 4.0579000000; feg[43] = 0.2887000000;
					g[44] = 2.2000000000; fxg[44] = 3.9309000000; feg[44] = 0.2783000000;
					g[45] = 2.2500000000; fxg[45] = 3.8076000000; feg[45] = 0.2684000000;
					g[46] = 2.3000000000; fxg[46] = 3.6883000000; feg[46] = 0.2590000000;
					g[47] = 2.3500000000; fxg[47] = 3.5728000000; feg[47] = 0.2501000000;
					g[48] = 2.4000000000; fxg[48] = 3.4613000000; feg[48] = 0.2416000000;
					g[49] = 2.4500000000; fxg[49] = 3.3539000000; feg[49] = 0.2336000000;
					g[50] = 2.5000000000; fxg[50] = 3.2504000000; feg[50] = 0.2259000000;
					g[51] = 2.5500000000; fxg[51] = 3.1510000000; feg[51] = 0.2186000000;
					g[52] = 2.6000000000; fxg[52] = 3.0556000000; feg[52] = 0.2116000000;
					g[53] = 2.6500000000; fxg[53] = 2.9641000000; feg[53] = 0.2050000000;
					g[54] = 2.7000000000; fxg[54] = 2.8764000000; feg[54] = 0.1986000000;
					g[55] = 2.7500000000; fxg[55] = 2.7925000000; feg[55] = 0.1925000000;
					g[56] = 2.8000000000; fxg[56] = 2.7124000000; feg[56] = 0.1867000000;
					g[57] = 2.8500000000; fxg[57] = 2.6358000000; feg[57] = 0.1811000000;
					g[58] = 2.9000000000; fxg[58] = 2.5627000000; feg[58] = 0.1757000000;
					g[59] = 2.9500000000; fxg[59] = 2.4931000000; feg[59] = 0.1706000000;
					g[60] = 3.0000000000; fxg[60] = 2.4267000000; feg[60] = 0.1657000000;
					g[61] = 3.0500000000; fxg[61] = 2.3635000000; feg[61] = 0.1609000000;
					g[62] = 3.1000000000; fxg[62] = 2.3034000000; feg[62] = 0.1564000000;
					g[63] = 3.1500000000; fxg[63] = 2.2462000000; feg[63] = 0.1520000000;
					g[64] = 3.2000000000; fxg[64] = 2.1918000000; feg[64] = 0.1478000000;
					g[65] = 3.2500000000; fxg[65] = 2.1401000000; feg[65] = 0.1437000000;
					g[66] = 3.3000000000; fxg[66] = 2.0910000000; feg[66] = 0.1399000000;
					g[67] = 3.3500000000; fxg[67] = 2.0444000000; feg[67] = 0.1361000000;
					g[68] = 3.4000000000; fxg[68] = 2.0001000000; feg[68] = 0.1325000000;
					g[69] = 3.4500000000; fxg[69] = 1.9579000000; feg[69] = 0.1290000000;
					g[70] = 3.5000000000; fxg[70] = 1.9180000000; feg[70] = 0.1257000000;
					g[71] = 3.5500000000; fxg[71] = 1.8801000000; feg[71] = 0.1225000000;
					g[72] = 3.6000000000; fxg[72] = 1.8442000000; feg[72] = 0.1193000000;
					g[73] = 3.6500000000; fxg[73] = 1.8100000000; feg[73] = 0.1163000000;
					g[74] = 3.7000000000; fxg[74] = 1.7776000000; feg[74] = 0.1134000000;
					g[75] = 3.7500000000; fxg[75] = 1.7467000000; feg[75] = 0.1106000000;
					g[76] = 3.8000000000; fxg[76] = 1.7173000000; feg[76] = 0.1080000000;
					g[77] = 3.8500000000; fxg[77] = 1.6893000000; feg[77] = 0.1053000000;
					g[78] = 3.9000000000; fxg[78] = 1.6629000000; feg[78] = 0.1028000000;
					g[79] = 3.9500000000; fxg[79] = 1.6378000000; feg[79] = 0.1004000000;
					g[80] = 4.0000000000; fxg[80] = 1.6140000000; feg[80] = 0.0980000000;
					g[81] = 4.0500000000; fxg[81] = 1.5913000000; feg[81] = 0.0958000000;
					g[82] = 4.1000000000; fxg[82] = 1.5695000000; feg[82] = 0.0936000000;
					g[83] = 4.1500000000; fxg[83] = 1.5487000000; feg[83] = 0.0914000000;
					g[84] = 4.2000000000; fxg[84] = 1.5286000000; feg[84] = 0.0894000000;
					g[85] = 4.2500000000; fxg[85] = 1.5095000000; feg[85] = 0.0874000000;
					g[86] = 4.3000000000; fxg[86] = 1.4913000000; feg[86] = 0.0855000000;
					g[87] = 4.3500000000; fxg[87] = 1.4741000000; feg[87] = 0.0836000000;
					g[88] = 4.4000000000; fxg[88] = 1.4578000000; feg[88] = 0.0818000000;
					g[89] = 4.4500000000; fxg[89] = 1.4422000000; feg[89] = 0.0800000000;
					g[90] = 4.5000000000; fxg[90] = 1.4272000000; feg[90] = 0.0784000000;
					g[91] = 4.5500000000; fxg[91] = 1.4125000000; feg[91] = 0.0767000000;
					g[92] = 4.6000000000; fxg[92] = 1.3981000000; feg[92] = 0.0751000000;
					g[93] = 4.6500000000; fxg[93] = 1.3841000000; feg[93] = 0.0736000000;
					g[94] = 4.7000000000; fxg[94] = 1.3705000000; feg[94] = 0.0721000000;
					g[95] = 4.7500000000; fxg[95] = 1.3577000000; feg[95] = 0.0706000000;
					g[96] = 4.8000000000; fxg[96] = 1.3455000000; feg[96] = 0.0692000000;
					g[97] = 4.8500000000; fxg[97] = 1.3341000000; feg[97] = 0.0678000000;
					g[98] = 4.9000000000; fxg[98] = 1.3231000000; feg[98] = 0.0665000000;
					g[99] = 4.9500000000; fxg[99] = 1.3124000000; feg[99] = 0.0652000000;
					g[100] = 5.0000000000; fxg[100] = 1.3017000000; feg[100] = 0.0639000000;
					g[101] = 5.0500000000; fxg[101] = 1.2910000000; feg[101] = 0.0627000000;
					g[102] = 5.1000000000; fxg[102] = 1.2802000000; feg[102] = 0.0615000000;
					g[103] = 5.1500000000; fxg[103] = 1.2694000000; feg[103] = 0.0604000000;
					g[104] = 5.2000000000; fxg[104] = 1.2589000000; feg[104] = 0.0593000000;
					g[105] = 5.2500000000; fxg[105] = 1.2490000000; feg[105] = 0.0582000000;
					g[106] = 5.3000000000; fxg[106] = 1.2396000000; feg[106] = 0.0571000000;
					g[107] = 5.3500000000; fxg[107] = 1.2309000000; feg[107] = 0.0561000000;
					g[108] = 5.4000000000; fxg[108] = 1.2227000000; feg[108] = 0.0551000000;
					g[109] = 5.4500000000; fxg[109] = 1.2146000000; feg[109] = 0.0541000000;
					g[110] = 5.5000000000; fxg[110] = 1.2064000000; feg[110] = 0.0531000000;
					g[111] = 5.5500000000; fxg[111] = 1.1979000000; feg[111] = 0.0522000000;
					g[112] = 5.6000000000; fxg[112] = 1.1889000000; feg[112] = 0.0513000000;
					g[113] = 5.6500000000; fxg[113] = 1.1796000000; feg[113] = 0.0504000000;
					g[114] = 5.7000000000; fxg[114] = 1.1702000000; feg[114] = 0.0496000000;
					g[115] = 5.7500000000; fxg[115] = 1.1611000000; feg[115] = 0.0488000000;
					g[116] = 5.8000000000; fxg[116] = 1.1524000000; feg[116] = 0.0479000000;
					g[117] = 5.8500000000; fxg[117] = 1.1443000000; feg[117] = 0.0472000000;
					g[118] = 5.9000000000; fxg[118] = 1.1370000000; feg[118] = 0.0464000000;
					g[119] = 5.9500000000; fxg[119] = 1.1302000000; feg[119] = 0.0456000000;
					g[120] = 6.0000000000; fxg[120] = 1.1237000000; feg[120] = 0.0449000000;
					g[121] = 6.0500000000; fxg[121] = 1.1170000000; feg[121] = 0.0442000000;
					g[122] = 6.1000000000; fxg[122] = 1.1099000000; feg[122] = 0.0435000000;
					g[123] = 6.1500000000; fxg[123] = 1.1022000000; feg[123] = 0.0428000000;
					g[124] = 6.2000000000; fxg[124] = 1.0938000000; feg[124] = 0.0421000000;
					g[125] = 6.2500000000; fxg[125] = 1.0850000000; feg[125] = 0.0415000000;
					g[126] = 6.3000000000; fxg[126] = 1.0759000000; feg[126] = 0.0408000000;
					g[127] = 6.3500000000; fxg[127] = 1.0670000000; feg[127] = 0.0402000000;
					g[128] = 6.4000000000; fxg[128] = 1.0586000000; feg[128] = 0.0396000000;
					g[129] = 6.4500000000; fxg[129] = 1.0509000000; feg[129] = 0.0390000000;
					g[130] = 6.5000000000; fxg[130] = 1.0440000000; feg[130] = 0.0384000000;
					g[131] = 6.5500000000; fxg[131] = 1.0379000000; feg[131] = 0.0379000000;
					g[132] = 6.6000000000; fxg[132] = 1.0323000000; feg[132] = 0.0373000000;
					g[133] = 6.6500000000; fxg[133] = 1.0267000000; feg[133] = 0.0367000000;
					g[134] = 6.7000000000; fxg[134] = 1.0208000000; feg[134] = 0.0362000000;
					g[135] = 6.7500000000; fxg[135] = 1.0143000000; feg[135] = 0.0357000000;
					g[136] = 6.8000000000; fxg[136] = 1.0070000000; feg[136] = 0.0352000000;
					g[137] = 6.8500000000; fxg[137] = 0.9988000000; feg[137] = 0.0347000000;
					g[138] = 6.9000000000; fxg[138] = 0.9901000000; feg[138] = 0.0342000000;
					g[139] = 6.9500000000; fxg[139] = 0.9810000000; feg[139] = 0.0337000000;
					g[140] = 7.0000000000; fxg[140] = 0.9719000000; feg[140] = 0.0333000000;
					g[141] = 7.0500000000; fxg[141] = 0.9632000000; feg[141] = 0.0328000000;
					g[142] = 7.1000000000; fxg[142] = 0.9552000000; feg[142] = 0.0324000000;
					g[143] = 7.1500000000; fxg[143] = 0.9481000000; feg[143] = 0.0319000000;
					g[144] = 7.2000000000; fxg[144] = 0.9420000000; feg[144] = 0.0315000000;
					g[145] = 7.2500000000; fxg[145] = 0.9367000000; feg[145] = 0.0311000000;
					g[146] = 7.3000000000; fxg[146] = 0.9320000000; feg[146] = 0.0307000000;
					g[147] = 7.3500000000; fxg[147] = 0.9273000000; feg[147] = 0.0303000000;
					g[148] = 7.4000000000; fxg[148] = 0.9223000000; feg[148] = 0.0299000000;
					g[149] = 7.4500000000; fxg[149] = 0.9165000000; feg[149] = 0.0295000000;
					g[150] = 7.5000000000; fxg[150] = 0.9097000000; feg[150] = 0.0291000000;
					g[151] = 7.5500000000; fxg[151] = 0.9020000000; feg[151] = 0.0287000000;
					g[152] = 7.6000000000; fxg[152] = 0.8935000000; feg[152] = 0.0284000000;
					g[153] = 7.6500000000; fxg[153] = 0.8845000000; feg[153] = 0.0280000000;
					g[154] = 7.7000000000; fxg[154] = 0.8753000000; feg[154] = 0.0277000000;
					g[155] = 7.7500000000; fxg[155] = 0.8662000000; feg[155] = 0.0273000000;
					g[156] = 7.8000000000; fxg[156] = 0.8576000000; feg[156] = 0.0270000000;
					g[157] = 7.8500000000; fxg[157] = 0.8497000000; feg[157] = 0.0266000000;
					g[158] = 7.9000000000; fxg[158] = 0.8428000000; feg[158] = 0.0263000000;
					g[159] = 7.9500000000; fxg[159] = 0.8371000000; feg[159] = 0.0260000000;
					g[160] = 8.0000000000; fxg[160] = 0.8324000000; feg[160] = 0.0257000000;
					g[161] = 8.0500000000; fxg[161] = 0.8285000000; feg[161] = 0.0254000000;
					g[162] = 8.1000000000; fxg[162] = 0.8248000000; feg[162] = 0.0251000000;
					g[163] = 8.1500000000; fxg[163] = 0.8209000000; feg[163] = 0.0248000000;
					g[164] = 8.2000000000; fxg[164] = 0.8164000000; feg[164] = 0.0245000000;
					g[165] = 8.2500000000; fxg[165] = 0.8108000000; feg[165] = 0.0242000000;
					g[166] = 8.3000000000; fxg[166] = 0.8042000000; feg[166] = 0.0239000000;
					g[167] = 8.3500000000; fxg[167] = 0.7967000000; feg[167] = 0.0236000000;
					g[168] = 8.4000000000; fxg[168] = 0.7884000000; feg[168] = 0.0234000000;
					g[169] = 8.4500000000; fxg[169] = 0.7795000000; feg[169] = 0.0231000000;
					g[170] = 8.5000000000; fxg[170] = 0.7705000000; feg[170] = 0.0228000000;
					g[171] = 8.5500000000; fxg[171] = 0.7615000000; feg[171] = 0.0226000000;
					g[172] = 8.6000000000; fxg[172] = 0.7528000000; feg[172] = 0.0223000000;
					g[173] = 8.6500000000; fxg[173] = 0.7447000000; feg[173] = 0.0221000000;
					g[174] = 8.7000000000; fxg[174] = 0.7375000000; feg[174] = 0.0218000000;
					g[175] = 8.7500000000; fxg[175] = 0.7315000000; feg[175] = 0.0216000000;
					g[176] = 8.8000000000; fxg[176] = 0.7267000000; feg[176] = 0.0214000000;
					g[177] = 8.8500000000; fxg[177] = 0.7230000000; feg[177] = 0.0211000000;
					g[178] = 8.9000000000; fxg[178] = 0.7202000000; feg[178] = 0.0209000000;
					g[179] = 8.9500000000; fxg[179] = 0.7176000000; feg[179] = 0.0207000000;
					g[180] = 9.0000000000; fxg[180] = 0.7149000000; feg[180] = 0.0204000000;
					g[181] = 9.0500000000; fxg[181] = 0.7114000000; feg[181] = 0.0202000000;
					g[182] = 9.1000000000; fxg[182] = 0.7068000000; feg[182] = 0.0200000000;
					g[183] = 9.1500000000; fxg[183] = 0.7012000000; feg[183] = 0.0198000000;
					g[184] = 9.2000000000; fxg[184] = 0.6945000000; feg[184] = 0.0196000000;
					g[185] = 9.2500000000; fxg[185] = 0.6870000000; feg[185] = 0.0194000000;
					g[186] = 9.3000000000; fxg[186] = 0.6789000000; feg[186] = 0.0192000000;
					g[187] = 9.3500000000; fxg[187] = 0.6705000000; feg[187] = 0.0190000000;
					g[188] = 9.4000000000; fxg[188] = 0.6620000000; feg[188] = 0.0188000000;
					g[189] = 9.4500000000; fxg[189] = 0.6535000000; feg[189] = 0.0186000000;
					g[190] = 9.5000000000; fxg[190] = 0.6452000000; feg[190] = 0.0184000000;
					g[191] = 9.5500000000; fxg[191] = 0.6373000000; feg[191] = 0.0182000000;
					g[192] = 9.6000000000; fxg[192] = 0.6302000000; feg[192] = 0.0180000000;
					g[193] = 9.6500000000; fxg[193] = 0.6242000000; feg[193] = 0.0179000000;
					g[194] = 9.7000000000; fxg[194] = 0.6194000000; feg[194] = 0.0177000000;
					g[195] = 9.7500000000; fxg[195] = 0.6160000000; feg[195] = 0.0175000000;
					g[196] = 9.8000000000; fxg[196] = 0.6137000000; feg[196] = 0.0173000000;
					g[197] = 9.8500000000; fxg[197] = 0.6122000000; feg[197] = 0.0172000000;
					g[198] = 9.9000000000; fxg[198] = 0.6108000000; feg[198] = 0.0170000000;
					g[199] = 9.9500000000; fxg[199] = 0.6091000000; feg[199] = 0.0168000000;
					g[200] = 10.0000000000; fxg[200] = 0.6066000000; feg[200] = 0.0167000000;
					g[201] = 10.0500000000; fxg[201] = 0.6029000000; feg[201] = 0.0165000000;
					g[202] = 10.1000000000; fxg[202] = 0.5980000000; feg[202] = 0.0163000000;
					g[203] = 10.1500000000; fxg[203] = 0.5921000000; feg[203] = 0.0162000000;
					g[204] = 10.2000000000; fxg[204] = 0.5854000000; feg[204] = 0.0160000000;
					g[205] = 10.2500000000; fxg[205] = 0.5783000000; feg[205] = 0.0159000000;
					g[206] = 10.3000000000; fxg[206] = 0.5708000000; feg[206] = 0.0157000000;
					g[207] = 10.3500000000; fxg[207] = 0.5633000000; feg[207] = 0.0156000000;
					g[208] = 10.4000000000; fxg[208] = 0.5556000000; feg[208] = 0.0154000000;
					g[209] = 10.4500000000; fxg[209] = 0.5479000000; feg[209] = 0.0153000000;
					g[210] = 10.5000000000; fxg[210] = 0.5403000000; feg[210] = 0.0152000000;
					g[211] = 10.5500000000; fxg[211] = 0.5330000000; feg[211] = 0.0150000000;
					g[212] = 10.6000000000; fxg[212] = 0.5262000000; feg[212] = 0.0149000000;
					g[213] = 10.6500000000; fxg[213] = 0.5203000000; feg[213] = 0.0148000000;
					g[214] = 10.7000000000; fxg[214] = 0.5156000000; feg[214] = 0.0146000000;
					g[215] = 10.7500000000; fxg[215] = 0.5123000000; feg[215] = 0.0145000000;
					g[216] = 10.8000000000; fxg[216] = 0.5104000000; feg[216] = 0.0144000000;
					g[217] = 10.8500000000; fxg[217] = 0.5095000000; feg[217] = 0.0142000000;
					g[218] = 10.9000000000; fxg[218] = 0.5093000000; feg[218] = 0.0141000000;
					g[219] = 10.9500000000; fxg[219] = 0.5091000000; feg[219] = 0.0140000000;
					g[220] = 11.0000000000; fxg[220] = 0.5085000000; feg[220] = 0.0138000000;
					g[221] = 11.0500000000; fxg[221] = 0.5068000000; feg[221] = 0.0137000000;
					g[222] = 11.1000000000; fxg[222] = 0.5039000000; feg[222] = 0.0136000000;
					g[223] = 11.1500000000; fxg[223] = 0.4998000000; feg[223] = 0.0135000000;
					g[224] = 11.2000000000; fxg[224] = 0.4947000000; feg[224] = 0.0134000000;
					g[225] = 11.2500000000; fxg[225] = 0.4888000000; feg[225] = 0.0132000000;
					g[226] = 11.3000000000; fxg[226] = 0.4825000000; feg[226] = 0.0131000000;
					g[227] = 11.3500000000; fxg[227] = 0.4761000000; feg[227] = 0.0130000000;
					g[228] = 11.4000000000; fxg[228] = 0.4697000000; feg[228] = 0.0129000000;
					g[229] = 11.4500000000; fxg[229] = 0.4633000000; feg[229] = 0.0128000000;
					g[230] = 11.5000000000; fxg[230] = 0.4569000000; feg[230] = 0.0127000000;
					g[231] = 11.5500000000; fxg[231] = 0.4503000000; feg[231] = 0.0126000000;
					g[232] = 11.6000000000; fxg[232] = 0.4437000000; feg[232] = 0.0125000000;
					g[233] = 11.6500000000; fxg[233] = 0.4370000000; feg[233] = 0.0124000000;
					g[234] = 11.7000000000; fxg[234] = 0.4306000000; feg[234] = 0.0123000000;
					g[235] = 11.7500000000; fxg[235] = 0.4248000000; feg[235] = 0.0122000000;
					g[236] = 11.8000000000; fxg[236] = 0.4200000000; feg[236] = 0.0121000000;
					g[237] = 11.8500000000; fxg[237] = 0.4164000000; feg[237] = 0.0120000000;
					g[238] = 11.9000000000; fxg[238] = 0.4143000000; feg[238] = 0.0119000000;
					g[239] = 11.9500000000; fxg[239] = 0.4135000000; feg[239] = 0.0118000000;
					g[240] = 12.0000000000; fxg[240] = 0.4138000000; feg[240] = 0.0117000000;
					break;
				case 19:
					g[0] = 0.0000000000; fxg[0] = 19.0000000000; feg[0] = 8.9862020000;
					g[1] = 0.0500000000; fxg[1] = 18.7756000000; feg[1] = 8.5948000000;
					g[2] = 0.1000000000; fxg[2] = 18.2042000000; feg[2] = 7.6190000000;
					g[3] = 0.1500000000; fxg[3] = 17.4812000000; feg[3] = 6.4623000000;
					g[4] = 0.2000000000; fxg[4] = 16.7331000000; feg[4] = 5.4256000000;
					g[5] = 0.2500000000; fxg[5] = 15.9900000000; feg[5] = 4.6106000000;
					g[6] = 0.3000000000; fxg[6] = 15.2429000000; feg[6] = 3.9965000000;
					g[7] = 0.3500000000; fxg[7] = 14.4864000000; feg[7] = 3.5274000000;
					g[8] = 0.4000000000; fxg[8] = 13.7281000000; feg[8] = 3.1544000000;
					g[9] = 0.4500000000; fxg[9] = 12.9833000000; feg[9] = 2.8445000000;
					g[10] = 0.5000000000; fxg[10] = 12.2682000000; feg[10] = 2.5779000000;
					g[11] = 0.5500000000; fxg[11] = 11.5962000000; feg[11] = 2.3431000000;
					g[12] = 0.6000000000; fxg[12] = 10.9762000000; feg[12] = 2.1338000000;
					g[13] = 0.6500000000; fxg[13] = 10.4130000000; feg[13] = 1.9457000000;
					g[14] = 0.7000000000; fxg[14] = 9.9076000000; feg[14] = 1.7764000000;
					g[15] = 0.7500000000; fxg[15] = 9.4583000000; feg[15] = 1.6240000000;
					g[16] = 0.8000000000; fxg[16] = 9.0611000000; feg[16] = 1.4867000000;
					g[17] = 0.8500000000; fxg[17] = 8.7112000000; feg[17] = 1.3633000000;
					g[18] = 0.9000000000; fxg[18] = 8.4030000000; feg[18] = 1.2525000000;
					g[19] = 0.9500000000; fxg[19] = 8.1306000000; feg[19] = 1.1530000000;
					g[20] = 1.0000000000; fxg[20] = 7.8885000000; feg[20] = 1.0638000000;
					g[21] = 1.0500000000; fxg[21] = 7.6713000000; feg[21] = 0.9837000000;
					g[22] = 1.1000000000; fxg[22] = 7.4744000000; feg[22] = 0.9119000000;
					g[23] = 1.1500000000; fxg[23] = 7.2936000000; feg[23] = 0.8474000000;
					g[24] = 1.2000000000; fxg[24] = 7.1251000000; feg[24] = 0.7895000000;
					g[25] = 1.2500000000; fxg[25] = 6.9661000000; feg[25] = 0.7373000000;
					g[26] = 1.3000000000; fxg[26] = 6.8140000000; feg[26] = 0.6903000000;
					g[27] = 1.3500000000; fxg[27] = 6.6668000000; feg[27] = 0.6479000000;
					g[28] = 1.4000000000; fxg[28] = 6.5229000000; feg[28] = 0.6094000000;
					g[29] = 1.4500000000; fxg[29] = 6.3812000000; feg[29] = 0.5746000000;
					g[30] = 1.5000000000; fxg[30] = 6.2409000000; feg[30] = 0.5429000000;
					g[31] = 1.5500000000; fxg[31] = 6.1011000000; feg[31] = 0.5140000000;
					g[32] = 1.6000000000; fxg[32] = 5.9617000000; feg[32] = 0.4876000000;
					g[33] = 1.6500000000; fxg[33] = 5.8226000000; feg[33] = 0.4634000000;
					g[34] = 1.7000000000; fxg[34] = 5.6834000000; feg[34] = 0.4411000000;
					g[35] = 1.7500000000; fxg[35] = 5.5442000000; feg[35] = 0.4206000000;
					g[36] = 1.8000000000; fxg[36] = 5.4057000000; feg[36] = 0.4017000000;
					g[37] = 1.8500000000; fxg[37] = 5.2677000000; feg[37] = 0.3841000000;
					g[38] = 1.9000000000; fxg[38] = 5.1299000000; feg[38] = 0.3678000000;
					g[39] = 1.9500000000; fxg[39] = 4.9933000000; feg[39] = 0.3526000000;
					g[40] = 2.0000000000; fxg[40] = 4.8587000000; feg[40] = 0.3385000000;
					g[41] = 2.0500000000; fxg[41] = 4.7254000000; feg[41] = 0.3252000000;
					g[42] = 2.1000000000; fxg[42] = 4.5931000000; feg[42] = 0.3128000000;
					g[43] = 2.1500000000; fxg[43] = 4.4631000000; feg[43] = 0.3011000000;
					g[44] = 2.2000000000; fxg[44] = 4.3364000000; feg[44] = 0.2900000000;
					g[45] = 2.2500000000; fxg[45] = 4.2123000000; feg[45] = 0.2796000000;
					g[46] = 2.3000000000; fxg[46] = 4.0897000000; feg[46] = 0.2698000000;
					g[47] = 2.3500000000; fxg[47] = 3.9697000000; feg[47] = 0.2606000000;
					g[48] = 2.4000000000; fxg[48] = 3.8538000000; feg[48] = 0.2517000000;
					g[49] = 2.4500000000; fxg[49] = 3.7419000000; feg[49] = 0.2434000000;
					g[50] = 2.5000000000; fxg[50] = 3.6328000000; feg[50] = 0.2354000000;
					g[51] = 2.5500000000; fxg[51] = 3.5256000000; feg[51] = 0.2278000000;
					g[52] = 2.6000000000; fxg[52] = 3.4216000000; feg[52] = 0.2206000000;
					g[53] = 2.6500000000; fxg[53] = 3.3222000000; feg[53] = 0.2137000000;
					g[54] = 2.7000000000; fxg[54] = 3.2274000000; feg[54] = 0.2071000000;
					g[55] = 2.7500000000; fxg[55] = 3.1356000000; feg[55] = 0.2008000000;
					g[56] = 2.8000000000; fxg[56] = 3.0459000000; feg[56] = 0.1948000000;
					g[57] = 2.8500000000; fxg[57] = 2.9587000000; feg[57] = 0.1891000000;
					g[58] = 2.9000000000; fxg[58] = 2.8754000000; feg[58] = 0.1836000000;
					g[59] = 2.9500000000; fxg[59] = 2.7970000000; feg[59] = 0.1782000000;
					g[60] = 3.0000000000; fxg[60] = 2.7226000000; feg[60] = 0.1731000000;
					g[61] = 3.0500000000; fxg[61] = 2.6504000000; feg[61] = 0.1683000000;
					g[62] = 3.1000000000; fxg[62] = 2.5799000000; feg[62] = 0.1636000000;
					g[63] = 3.1500000000; fxg[63] = 2.5118000000; feg[63] = 0.1591000000;
					g[64] = 3.2000000000; fxg[64] = 2.4470000000; feg[64] = 0.1548000000;
					g[65] = 3.2500000000; fxg[65] = 2.3866000000; feg[65] = 0.1506000000;
					g[66] = 3.3000000000; fxg[66] = 2.3300000000; feg[66] = 0.1465000000;
					g[67] = 3.3500000000; fxg[67] = 2.2755000000; feg[67] = 0.1427000000;
					g[68] = 3.4000000000; fxg[68] = 2.2221000000; feg[68] = 0.1389000000;
					g[69] = 3.4500000000; fxg[69] = 2.1704000000; feg[69] = 0.1354000000;
					g[70] = 3.5000000000; fxg[70] = 2.1209000000; feg[70] = 0.1319000000;
					g[71] = 3.5500000000; fxg[71] = 2.0741000000; feg[71] = 0.1286000000;
					g[72] = 3.6000000000; fxg[72] = 2.0311000000; feg[72] = 0.1253000000;
					g[73] = 3.6500000000; fxg[73] = 1.9912000000; feg[73] = 0.1222000000;
					g[74] = 3.7000000000; fxg[74] = 1.9524000000; feg[74] = 0.1192000000;
					g[75] = 3.7500000000; fxg[75] = 1.9141000000; feg[75] = 0.1163000000;
					g[76] = 3.8000000000; fxg[76] = 1.8771000000; feg[76] = 0.1135000000;
					g[77] = 3.8500000000; fxg[77] = 1.8418000000; feg[77] = 0.1108000000;
					g[78] = 3.9000000000; fxg[78] = 1.8080000000; feg[78] = 0.1082000000;
					g[79] = 3.9500000000; fxg[79] = 1.7765000000; feg[79] = 0.1057000000;
					g[80] = 4.0000000000; fxg[80] = 1.7483000000; feg[80] = 0.1032000000;
					g[81] = 4.0500000000; fxg[81] = 1.7218000000; feg[81] = 0.1008000000;
					g[82] = 4.1000000000; fxg[82] = 1.6952000000; feg[82] = 0.0986000000;
					g[83] = 4.1500000000; fxg[83] = 1.6687000000; feg[83] = 0.0963000000;
					g[84] = 4.2000000000; fxg[84] = 1.6435000000; feg[84] = 0.0942000000;
					g[85] = 4.2500000000; fxg[85] = 1.6195000000; feg[85] = 0.0921000000;
					g[86] = 4.3000000000; fxg[86] = 1.5961000000; feg[86] = 0.0901000000;
					g[87] = 4.3500000000; fxg[87] = 1.5740000000; feg[87] = 0.0882000000;
					g[88] = 4.4000000000; fxg[88] = 1.5544000000; feg[88] = 0.0863000000;
					g[89] = 4.4500000000; fxg[89] = 1.5369000000; feg[89] = 0.0844000000;
					g[90] = 4.5000000000; fxg[90] = 1.5195000000; feg[90] = 0.0826000000;
					g[91] = 4.5500000000; fxg[91] = 1.5011000000; feg[91] = 0.0809000000;
					g[92] = 4.6000000000; fxg[92] = 1.4829000000; feg[92] = 0.0793000000;
					g[93] = 4.6500000000; fxg[93] = 1.4661000000; feg[93] = 0.0776000000;
					g[94] = 4.7000000000; fxg[94] = 1.4502000000; feg[94] = 0.0761000000;
					g[95] = 4.7500000000; fxg[95] = 1.4341000000; feg[95] = 0.0745000000;
					g[96] = 4.8000000000; fxg[96] = 1.4184000000; feg[96] = 0.0731000000;
					g[97] = 4.8500000000; fxg[97] = 1.4046000000; feg[97] = 0.0716000000;
					g[98] = 4.9000000000; fxg[98] = 1.3930000000; feg[98] = 0.0702000000;
					g[99] = 4.9500000000; fxg[99] = 1.3818000000; feg[99] = 0.0688000000;
					g[100] = 5.0000000000; fxg[100] = 1.3693000000; feg[100] = 0.0675000000;
					g[101] = 5.0500000000; fxg[101] = 1.3558000000; feg[101] = 0.0662000000;
					g[102] = 5.1000000000; fxg[102] = 1.3430000000; feg[102] = 0.0650000000;
					g[103] = 5.1500000000; fxg[103] = 1.3318000000; feg[103] = 0.0638000000;
					g[104] = 5.2000000000; fxg[104] = 1.3207000000; feg[104] = 0.0626000000;
					g[105] = 5.2500000000; fxg[105] = 1.3090000000; feg[105] = 0.0614000000;
					g[106] = 5.3000000000; fxg[106] = 1.2973000000; feg[106] = 0.0603000000;
					g[107] = 5.3500000000; fxg[107] = 1.2869000000; feg[107] = 0.0592000000;
					g[108] = 5.4000000000; fxg[108] = 1.2787000000; feg[108] = 0.0582000000;
					g[109] = 5.4500000000; fxg[109] = 1.2713000000; feg[109] = 0.0571000000;
					g[110] = 5.5000000000; fxg[110] = 1.2627000000; feg[110] = 0.0561000000;
					g[111] = 5.5500000000; fxg[111] = 1.2523000000; feg[111] = 0.0552000000;
					g[112] = 5.6000000000; fxg[112] = 1.2416000000; feg[112] = 0.0542000000;
					g[113] = 5.6500000000; fxg[113] = 1.2321000000; feg[113] = 0.0533000000;
					g[114] = 5.7000000000; fxg[114] = 1.2239000000; feg[114] = 0.0524000000;
					g[115] = 5.7500000000; fxg[115] = 1.2154000000; feg[115] = 0.0515000000;
					g[116] = 5.8000000000; fxg[116] = 1.2061000000; feg[116] = 0.0506000000;
					g[117] = 5.8500000000; fxg[117] = 1.1964000000; feg[117] = 0.0498000000;
					g[118] = 5.9000000000; fxg[118] = 1.1877000000; feg[118] = 0.0490000000;
					g[119] = 5.9500000000; fxg[119] = 1.1809000000; feg[119] = 0.0482000000;
					g[120] = 6.0000000000; fxg[120] = 1.1755000000; feg[120] = 0.0474000000;
					g[121] = 6.0500000000; fxg[121] = 1.1695000000; feg[121] = 0.0466000000;
					g[122] = 6.1000000000; fxg[122] = 1.1617000000; feg[122] = 0.0459000000;
					g[123] = 6.1500000000; fxg[123] = 1.1523000000; feg[123] = 0.0452000000;
					g[124] = 6.2000000000; fxg[124] = 1.1429000000; feg[124] = 0.0445000000;
					g[125] = 6.2500000000; fxg[125] = 1.1350000000; feg[125] = 0.0438000000;
					g[126] = 6.3000000000; fxg[126] = 1.1281000000; feg[126] = 0.0431000000;
					g[127] = 6.3500000000; fxg[127] = 1.1208000000; feg[127] = 0.0424000000;
					g[128] = 6.4000000000; fxg[128] = 1.1126000000; feg[128] = 0.0418000000;
					g[129] = 6.4500000000; fxg[129] = 1.1039000000; feg[129] = 0.0412000000;
					g[130] = 6.5000000000; fxg[130] = 1.0957000000; feg[130] = 0.0406000000;
					g[131] = 6.5500000000; fxg[131] = 1.0890000000; feg[131] = 0.0400000000;
					g[132] = 6.6000000000; fxg[132] = 1.0842000000; feg[132] = 0.0394000000;
					g[133] = 6.6500000000; fxg[133] = 1.0798000000; feg[133] = 0.0388000000;
					g[134] = 6.7000000000; fxg[134] = 1.0743000000; feg[134] = 0.0382000000;
					g[135] = 6.7500000000; fxg[135] = 1.0669000000; feg[135] = 0.0377000000;
					g[136] = 6.8000000000; fxg[136] = 1.0580000000; feg[136] = 0.0371000000;
					g[137] = 6.8500000000; fxg[137] = 1.0491000000; feg[137] = 0.0366000000;
					g[138] = 6.9000000000; fxg[138] = 1.0415000000; feg[138] = 0.0361000000;
					g[139] = 6.9500000000; fxg[139] = 1.0349000000; feg[139] = 0.0356000000;
					g[140] = 7.0000000000; fxg[140] = 1.0280000000; feg[140] = 0.0351000000;
					g[141] = 7.0500000000; fxg[141] = 1.0204000000; feg[141] = 0.0346000000;
					g[142] = 7.1000000000; fxg[142] = 1.0122000000; feg[142] = 0.0342000000;
					g[143] = 7.1500000000; fxg[143] = 1.0042000000; feg[143] = 0.0337000000;
					g[144] = 7.2000000000; fxg[144] = 0.9970000000; feg[144] = 0.0332000000;
					g[145] = 7.2500000000; fxg[145] = 0.9914000000; feg[145] = 0.0328000000;
					g[146] = 7.3000000000; fxg[146] = 0.9874000000; feg[146] = 0.0324000000;
					g[147] = 7.3500000000; fxg[147] = 0.9837000000; feg[147] = 0.0319000000;
					g[148] = 7.4000000000; fxg[148] = 0.9789000000; feg[148] = 0.0315000000;
					g[149] = 7.4500000000; fxg[149] = 0.9723000000; feg[149] = 0.0311000000;
					g[150] = 7.5000000000; fxg[150] = 0.9641000000; feg[150] = 0.0307000000;
					g[151] = 7.5500000000; fxg[151] = 0.9553000000; feg[151] = 0.0303000000;
					g[152] = 7.6000000000; fxg[152] = 0.9472000000; feg[152] = 0.0299000000;
					g[153] = 7.6500000000; fxg[153] = 0.9403000000; feg[153] = 0.0295000000;
					g[154] = 7.7000000000; fxg[154] = 0.9336000000; feg[154] = 0.0292000000;
					g[155] = 7.7500000000; fxg[155] = 0.9263000000; feg[155] = 0.0288000000;
					g[156] = 7.8000000000; fxg[156] = 0.9184000000; feg[156] = 0.0285000000;
					g[157] = 7.8500000000; fxg[157] = 0.9106000000; feg[157] = 0.0281000000;
					g[158] = 7.9000000000; fxg[158] = 0.9031000000; feg[158] = 0.0278000000;
					g[159] = 7.9500000000; fxg[159] = 0.8963000000; feg[159] = 0.0274000000;
					g[160] = 8.0000000000; fxg[160] = 0.8908000000; feg[160] = 0.0271000000;
					g[161] = 8.0500000000; fxg[161] = 0.8871000000; feg[161] = 0.0268000000;
					g[162] = 8.1000000000; fxg[162] = 0.8842000000; feg[162] = 0.0264000000;
					g[163] = 8.1500000000; fxg[163] = 0.8806000000; feg[163] = 0.0261000000;
					g[164] = 8.2000000000; fxg[164] = 0.8756000000; feg[164] = 0.0258000000;
					g[165] = 8.2500000000; fxg[165] = 0.8691000000; feg[165] = 0.0255000000;
					g[166] = 8.3000000000; fxg[166] = 0.8612000000; feg[166] = 0.0252000000;
					g[167] = 8.3500000000; fxg[167] = 0.8527000000; feg[167] = 0.0249000000;
					g[168] = 8.4000000000; fxg[168] = 0.8448000000; feg[168] = 0.0246000000;
					g[169] = 8.4500000000; fxg[169] = 0.8378000000; feg[169] = 0.0244000000;
					g[170] = 8.5000000000; fxg[170] = 0.8310000000; feg[170] = 0.0241000000;
					g[171] = 8.5500000000; fxg[171] = 0.8236000000; feg[171] = 0.0238000000;
					g[172] = 8.6000000000; fxg[172] = 0.8156000000; feg[172] = 0.0235000000;
					g[173] = 8.6500000000; fxg[173] = 0.8079000000; feg[173] = 0.0233000000;
					g[174] = 8.7000000000; fxg[174] = 0.8007000000; feg[174] = 0.0230000000;
					g[175] = 8.7500000000; fxg[175] = 0.7940000000; feg[175] = 0.0228000000;
					g[176] = 8.8000000000; fxg[176] = 0.7881000000; feg[176] = 0.0225000000;
					g[177] = 8.8500000000; fxg[177] = 0.7837000000; feg[177] = 0.0223000000;
					g[178] = 8.9000000000; fxg[178] = 0.7809000000; feg[178] = 0.0220000000;
					g[179] = 8.9500000000; fxg[179] = 0.7787000000; feg[179] = 0.0218000000;
					g[180] = 9.0000000000; fxg[180] = 0.7759000000; feg[180] = 0.0215000000;
					g[181] = 9.0500000000; fxg[181] = 0.7719000000; feg[181] = 0.0213000000;
					g[182] = 9.1000000000; fxg[182] = 0.7666000000; feg[182] = 0.0211000000;
					g[183] = 9.1500000000; fxg[183] = 0.7600000000; feg[183] = 0.0209000000;
					g[184] = 9.2000000000; fxg[184] = 0.7523000000; feg[184] = 0.0206000000;
					g[185] = 9.2500000000; fxg[185] = 0.7443000000; feg[185] = 0.0204000000;
					g[186] = 9.3000000000; fxg[186] = 0.7369000000; feg[186] = 0.0202000000;
					g[187] = 9.3500000000; fxg[187] = 0.7302000000; feg[187] = 0.0200000000;
					g[188] = 9.4000000000; fxg[188] = 0.7233000000; feg[188] = 0.0198000000;
					g[189] = 9.4500000000; fxg[189] = 0.7157000000; feg[189] = 0.0196000000;
					g[190] = 9.5000000000; fxg[190] = 0.7076000000; feg[190] = 0.0194000000;
					g[191] = 9.5500000000; fxg[191] = 0.7000000000; feg[191] = 0.0192000000;
					g[192] = 9.6000000000; fxg[192] = 0.6933000000; feg[192] = 0.0190000000;
					g[193] = 9.6500000000; fxg[193] = 0.6872000000; feg[193] = 0.0188000000;
					g[194] = 9.7000000000; fxg[194] = 0.6816000000; feg[194] = 0.0186000000;
					g[195] = 9.7500000000; fxg[195] = 0.6771000000; feg[195] = 0.0185000000;
					g[196] = 9.8000000000; fxg[196] = 0.6742000000; feg[196] = 0.0183000000;
					g[197] = 9.8500000000; fxg[197] = 0.6726000000; feg[197] = 0.0181000000;
					g[198] = 9.9000000000; fxg[198] = 0.6713000000; feg[198] = 0.0179000000;
					g[199] = 9.9500000000; fxg[199] = 0.6692000000; feg[199] = 0.0177000000;
					g[200] = 10.0000000000; fxg[200] = 0.6659000000; feg[200] = 0.0176000000;
					g[201] = 10.0500000000; fxg[201] = 0.6618000000; feg[201] = 0.0174000000;
					g[202] = 10.1000000000; fxg[202] = 0.6565000000; feg[202] = 0.0172000000;
					g[203] = 10.1500000000; fxg[203] = 0.6498000000; feg[203] = 0.0171000000;
					g[204] = 10.2000000000; fxg[204] = 0.6424000000; feg[204] = 0.0169000000;
					g[205] = 10.2500000000; fxg[205] = 0.6351000000; feg[205] = 0.0167000000;
					g[206] = 10.3000000000; fxg[206] = 0.6284000000; feg[206] = 0.0166000000;
					g[207] = 10.3500000000; fxg[207] = 0.6220000000; feg[207] = 0.0164000000;
					g[208] = 10.4000000000; fxg[208] = 0.6152000000; feg[208] = 0.0163000000;
					g[209] = 10.4500000000; fxg[209] = 0.6076000000; feg[209] = 0.0161000000;
					g[210] = 10.5000000000; fxg[210] = 0.5997000000; feg[210] = 0.0160000000;
					g[211] = 10.5500000000; fxg[211] = 0.5925000000; feg[211] = 0.0158000000;
					g[212] = 10.6000000000; fxg[212] = 0.5863000000; feg[212] = 0.0157000000;
					g[213] = 10.6500000000; fxg[213] = 0.5808000000; feg[213] = 0.0155000000;
					g[214] = 10.7000000000; fxg[214] = 0.5757000000; feg[214] = 0.0154000000;
					g[215] = 10.7500000000; fxg[215] = 0.5715000000; feg[215] = 0.0153000000;
					g[216] = 10.8000000000; fxg[216] = 0.5686000000; feg[216] = 0.0151000000;
					g[217] = 10.8500000000; fxg[217] = 0.5673000000; feg[217] = 0.0150000000;
					g[218] = 10.9000000000; fxg[218] = 0.5670000000; feg[218] = 0.0149000000;
					g[219] = 10.9500000000; fxg[219] = 0.5666000000; feg[219] = 0.0147000000;
					g[220] = 11.0000000000; fxg[220] = 0.5652000000; feg[220] = 0.0146000000;
					g[221] = 11.0500000000; fxg[221] = 0.5627000000; feg[221] = 0.0145000000;
					g[222] = 11.1000000000; fxg[222] = 0.5596000000; feg[222] = 0.0143000000;
					g[223] = 11.1500000000; fxg[223] = 0.5556000000; feg[223] = 0.0142000000;
					g[224] = 11.2000000000; fxg[224] = 0.5502000000; feg[224] = 0.0141000000;
					g[225] = 11.2500000000; fxg[225] = 0.5437000000; feg[225] = 0.0140000000;
					g[226] = 11.3000000000; fxg[226] = 0.5368000000; feg[226] = 0.0138000000;
					g[227] = 11.3500000000; fxg[227] = 0.5305000000; feg[227] = 0.0137000000;
					g[228] = 11.4000000000; fxg[228] = 0.5246000000; feg[228] = 0.0136000000;
					g[229] = 11.4500000000; fxg[229] = 0.5186000000; feg[229] = 0.0135000000;
					g[230] = 11.5000000000; fxg[230] = 0.5122000000; feg[230] = 0.0134000000;
					g[231] = 11.5500000000; fxg[231] = 0.5050000000; feg[231] = 0.0133000000;
					g[232] = 11.6000000000; fxg[232] = 0.4976000000; feg[232] = 0.0132000000;
					g[233] = 11.6500000000; fxg[233] = 0.4908000000; feg[233] = 0.0131000000;
					g[234] = 11.7000000000; fxg[234] = 0.4850000000; feg[234] = 0.0129000000;
					g[235] = 11.7500000000; fxg[235] = 0.4800000000; feg[235] = 0.0128000000;
					g[236] = 11.8000000000; fxg[236] = 0.4755000000; feg[236] = 0.0127000000;
					g[237] = 11.8500000000; fxg[237] = 0.4715000000; feg[237] = 0.0126000000;
					g[238] = 11.9000000000; fxg[238] = 0.4686000000; feg[238] = 0.0125000000;
					g[239] = 11.9500000000; fxg[239] = 0.4671000000; feg[239] = 0.0124000000;
					g[240] = 12.0000000000; fxg[240] = 0.4669000000; feg[240] = 0.0123000000;
					break;
				case 20:
					g[0] = 0.0000000000; fxg[0] = 20.0000000000; feg[0] = 9.9138280000;
					g[1] = 0.0500000000; fxg[1] = 19.7498000000; feg[1] = 9.5813000000;
					g[2] = 0.1000000000; fxg[2] = 19.0910000000; feg[2] = 8.7026000000;
					g[3] = 0.1500000000; fxg[3] = 18.2255000000; feg[3] = 7.5505000000;
					g[4] = 0.2000000000; fxg[4] = 17.3309000000; feg[4] = 6.3882000000;
					g[5] = 0.2500000000; fxg[5] = 16.4931000000; feg[5] = 5.3717000000;
					g[6] = 0.3000000000; fxg[6] = 15.7230000000; feg[6] = 4.5495000000;
					g[7] = 0.3500000000; fxg[7] = 15.0003000000; feg[7] = 3.9073000000;
					g[8] = 0.4000000000; fxg[8] = 14.3045000000; feg[8] = 3.4079000000;
					g[9] = 0.4500000000; fxg[9] = 13.6249000000; feg[9] = 3.0139000000;
					g[10] = 0.5000000000; fxg[10] = 12.9613000000; feg[10] = 2.6954000000;
					g[11] = 0.5500000000; fxg[11] = 12.3188000000; feg[11] = 2.4309000000;
					g[12] = 0.6000000000; fxg[12] = 11.7050000000; feg[12] = 2.2059000000;
					g[13] = 0.6500000000; fxg[13] = 11.1270000000; feg[13] = 2.0106000000;
					g[14] = 0.7000000000; fxg[14] = 10.5900000000; feg[14] = 1.8385000000;
					g[15] = 0.7500000000; fxg[15] = 10.0972000000; feg[15] = 1.6854000000;
					g[16] = 0.8000000000; fxg[16] = 9.6495000000; feg[16] = 1.5483000000;
					g[17] = 0.8500000000; fxg[17] = 9.2461000000; feg[17] = 1.4249000000;
					g[18] = 0.9000000000; fxg[18] = 8.8848000000; feg[18] = 1.3137000000;
					g[19] = 0.9500000000; fxg[19] = 8.5623000000; feg[19] = 1.2133000000;
					g[20] = 1.0000000000; fxg[20] = 8.2747000000; feg[20] = 1.1225000000;
					g[21] = 1.0500000000; fxg[21] = 8.0180000000; feg[21] = 1.0404000000;
					g[22] = 1.1000000000; fxg[22] = 7.7878000000; feg[22] = 0.9662000000;
					g[23] = 1.1500000000; fxg[23] = 7.5803000000; feg[23] = 0.8991000000;
					g[24] = 1.2000000000; fxg[24] = 7.3916000000; feg[24] = 0.8382000000;
					g[25] = 1.2500000000; fxg[25] = 7.2182000000; feg[25] = 0.7831000000;
					g[26] = 1.3000000000; fxg[26] = 7.0572000000; feg[26] = 0.7332000000;
					g[27] = 1.3500000000; fxg[27] = 6.9058000000; feg[27] = 0.6878000000;
					g[28] = 1.4000000000; fxg[28] = 6.7619000000; feg[28] = 0.6466000000;
					g[29] = 1.4500000000; fxg[29] = 6.6236000000; feg[29] = 0.6091000000;
					g[30] = 1.5000000000; fxg[30] = 6.4893000000; feg[30] = 0.5749000000;
					g[31] = 1.5500000000; fxg[31] = 6.3577000000; feg[31] = 0.5436000000;
					g[32] = 1.6000000000; fxg[32] = 6.2281000000; feg[32] = 0.5150000000;
					g[33] = 1.6500000000; fxg[33] = 6.0997000000; feg[33] = 0.4888000000;
					g[34] = 1.7000000000; fxg[34] = 5.9718000000; feg[34] = 0.4647000000;
					g[35] = 1.7500000000; fxg[35] = 5.8443000000; feg[35] = 0.4425000000;
					g[36] = 1.8000000000; fxg[36] = 5.7171000000; feg[36] = 0.4220000000;
					g[37] = 1.8500000000; fxg[37] = 5.5899000000; feg[37] = 0.4031000000;
					g[38] = 1.9000000000; fxg[38] = 5.4625000000; feg[38] = 0.3855000000;
					g[39] = 1.9500000000; fxg[39] = 5.3356000000; feg[39] = 0.3692000000;
					g[40] = 2.0000000000; fxg[40] = 5.2093000000; feg[40] = 0.3540000000;
					g[41] = 2.0500000000; fxg[41] = 5.0832000000; feg[41] = 0.3398000000;
					g[42] = 2.1000000000; fxg[42] = 4.9575000000; feg[42] = 0.3266000000;
					g[43] = 2.1500000000; fxg[43] = 4.8329000000; feg[43] = 0.3141000000;
					g[44] = 2.2000000000; fxg[44] = 4.7101000000; feg[44] = 0.3024000000;
					g[45] = 2.2500000000; fxg[45] = 4.5886000000; feg[45] = 0.2914000000;
					g[46] = 2.3000000000; fxg[46] = 4.4679000000; feg[46] = 0.2811000000;
					g[47] = 2.3500000000; fxg[47] = 4.3488000000; feg[47] = 0.2713000000;
					g[48] = 2.4000000000; fxg[48] = 4.2326000000; feg[48] = 0.2621000000;
					g[49] = 2.4500000000; fxg[49] = 4.1192000000; feg[49] = 0.2533000000;
					g[50] = 2.5000000000; fxg[50] = 4.0075000000; feg[50] = 0.2450000000;
					g[51] = 2.5500000000; fxg[51] = 3.8973000000; feg[51] = 0.2371000000;
					g[52] = 2.6000000000; fxg[52] = 3.7896000000; feg[52] = 0.2296000000;
					g[53] = 2.6500000000; fxg[53] = 3.6856000000; feg[53] = 0.2224000000;
					g[54] = 2.7000000000; fxg[54] = 3.5855000000; feg[54] = 0.2156000000;
					g[55] = 2.7500000000; fxg[55] = 3.4877000000; feg[55] = 0.2090000000;
					g[56] = 2.8000000000; fxg[56] = 3.3914000000; feg[56] = 0.2028000000;
					g[57] = 2.8500000000; fxg[57] = 3.2973000000; feg[57] = 0.1969000000;
					g[58] = 2.9000000000; fxg[58] = 3.2069000000; feg[58] = 0.1912000000;
					g[59] = 2.9500000000; fxg[59] = 3.1212000000; feg[59] = 0.1857000000;
					g[60] = 3.0000000000; fxg[60] = 3.0391000000; feg[60] = 0.1804000000;
					g[61] = 3.0500000000; fxg[61] = 2.9589000000; feg[61] = 0.1754000000;
					g[62] = 3.1000000000; fxg[62] = 2.8799000000; feg[62] = 0.1706000000;
					g[63] = 3.1500000000; fxg[63] = 2.8030000000; feg[63] = 0.1659000000;
					g[64] = 3.2000000000; fxg[64] = 2.7298000000; feg[64] = 0.1615000000;
					g[65] = 3.2500000000; fxg[65] = 2.6612000000; feg[65] = 0.1572000000;
					g[66] = 3.3000000000; fxg[66] = 2.5966000000; feg[66] = 0.1530000000;
					g[67] = 3.3500000000; fxg[67] = 2.5340000000; feg[67] = 0.1490000000;
					g[68] = 3.4000000000; fxg[68] = 2.4722000000; feg[68] = 0.1452000000;
					g[69] = 3.4500000000; fxg[69] = 2.4115000000; feg[69] = 0.1415000000;
					g[70] = 3.5000000000; fxg[70] = 2.3530000000; feg[70] = 0.1379000000;
					g[71] = 3.5500000000; fxg[71] = 2.2982000000; feg[71] = 0.1345000000;
					g[72] = 3.6000000000; fxg[72] = 2.2477000000; feg[72] = 0.1311000000;
					g[73] = 3.6500000000; fxg[73] = 2.2007000000; feg[73] = 0.1279000000;
					g[74] = 3.7000000000; fxg[74] = 2.1550000000; feg[74] = 0.1248000000;
					g[75] = 3.7500000000; fxg[75] = 2.1095000000; feg[75] = 0.1218000000;
					g[76] = 3.8000000000; fxg[76] = 2.0644000000; feg[76] = 0.1189000000;
					g[77] = 3.8500000000; fxg[77] = 2.0208000000; feg[77] = 0.1161000000;
					g[78] = 3.9000000000; fxg[78] = 1.9797000000; feg[78] = 0.1134000000;
					g[79] = 3.9500000000; fxg[79] = 1.9421000000; feg[79] = 0.1108000000;
					g[80] = 4.0000000000; fxg[80] = 1.9083000000; feg[80] = 0.1083000000;
					g[81] = 4.0500000000; fxg[81] = 1.8765000000; feg[81] = 0.1058000000;
					g[82] = 4.1000000000; fxg[82] = 1.8449000000; feg[82] = 0.1034000000;
					g[83] = 4.1500000000; fxg[83] = 1.8128000000; feg[83] = 0.1011000000;
					g[84] = 4.2000000000; fxg[84] = 1.7810000000; feg[84] = 0.0989000000;
					g[85] = 4.2500000000; fxg[85] = 1.7502000000; feg[85] = 0.0967000000;
					g[86] = 4.3000000000; fxg[86] = 1.7209000000; feg[86] = 0.0946000000;
					g[87] = 4.3500000000; fxg[87] = 1.6942000000; feg[87] = 0.0926000000;
					g[88] = 4.4000000000; fxg[88] = 1.6708000000; feg[88] = 0.0906000000;
					g[89] = 4.4500000000; fxg[89] = 1.6498000000; feg[89] = 0.0887000000;
					g[90] = 4.5000000000; fxg[90] = 1.6292000000; feg[90] = 0.0869000000;
					g[91] = 4.5500000000; fxg[91] = 1.6075000000; feg[91] = 0.0851000000;
					g[92] = 4.6000000000; fxg[92] = 1.5853000000; feg[92] = 0.0833000000;
					g[93] = 4.6500000000; fxg[93] = 1.5637000000; feg[93] = 0.0816000000;
					g[94] = 4.7000000000; fxg[94] = 1.5427000000; feg[94] = 0.0800000000;
					g[95] = 4.7500000000; fxg[95] = 1.5224000000; feg[95] = 0.0784000000;
					g[96] = 4.8000000000; fxg[96] = 1.5037000000; feg[96] = 0.0769000000;
					g[97] = 4.8500000000; fxg[97] = 1.4878000000; feg[97] = 0.0753000000;
					g[98] = 4.9000000000; fxg[98] = 1.4744000000; feg[98] = 0.0739000000;
					g[99] = 4.9500000000; fxg[99] = 1.4616000000; feg[99] = 0.0724000000;
					g[100] = 5.0000000000; fxg[100] = 1.4475000000; feg[100] = 0.0710000000;
					g[101] = 5.0500000000; fxg[101] = 1.4320000000; feg[101] = 0.0697000000;
					g[102] = 5.1000000000; fxg[102] = 1.4166000000; feg[102] = 0.0684000000;
					g[103] = 5.1500000000; fxg[103] = 1.4021000000; feg[103] = 0.0671000000;
					g[104] = 5.2000000000; fxg[104] = 1.3878000000; feg[104] = 0.0659000000;
					g[105] = 5.2500000000; fxg[105] = 1.3735000000; feg[105] = 0.0647000000;
					g[106] = 5.3000000000; fxg[106] = 1.3599000000; feg[106] = 0.0635000000;
					g[107] = 5.3500000000; fxg[107] = 1.3486000000; feg[107] = 0.0624000000;
					g[108] = 5.4000000000; fxg[108] = 1.3399000000; feg[108] = 0.0613000000;
					g[109] = 5.4500000000; fxg[109] = 1.3321000000; feg[109] = 0.0602000000;
					g[110] = 5.5000000000; fxg[110] = 1.3231000000; feg[110] = 0.0591000000;
					g[111] = 5.5500000000; fxg[111] = 1.3120000000; feg[111] = 0.0581000000;
					g[112] = 5.6000000000; fxg[112] = 1.3002000000; feg[112] = 0.0571000000;
					g[113] = 5.6500000000; fxg[113] = 1.2892000000; feg[113] = 0.0561000000;
					g[114] = 5.7000000000; fxg[114] = 1.2792000000; feg[114] = 0.0552000000;
					g[115] = 5.7500000000; fxg[115] = 1.2691000000; feg[115] = 0.0542000000;
					g[116] = 5.8000000000; fxg[116] = 1.2583000000; feg[116] = 0.0533000000;
					g[117] = 5.8500000000; fxg[117] = 1.2475000000; feg[117] = 0.0525000000;
					g[118] = 5.9000000000; fxg[118] = 1.2383000000; feg[118] = 0.0516000000;
					g[119] = 5.9500000000; fxg[119] = 1.2318000000; feg[119] = 0.0508000000;
					g[120] = 6.0000000000; fxg[120] = 1.2268000000; feg[120] = 0.0499000000;
					g[121] = 6.0500000000; fxg[121] = 1.2212000000; feg[121] = 0.0491000000;
					g[122] = 6.1000000000; fxg[122] = 1.2133000000; feg[122] = 0.0483000000;
					g[123] = 6.1500000000; fxg[123] = 1.2035000000; feg[123] = 0.0476000000;
					g[124] = 6.2000000000; fxg[124] = 1.1937000000; feg[124] = 0.0468000000;
					g[125] = 6.2500000000; fxg[125] = 1.1852000000; feg[125] = 0.0461000000;
					g[126] = 6.3000000000; fxg[126] = 1.1779000000; feg[126] = 0.0454000000;
					g[127] = 6.3500000000; fxg[127] = 1.1703000000; feg[127] = 0.0447000000;
					g[128] = 6.4000000000; fxg[128] = 1.1614000000; feg[128] = 0.0440000000;
					g[129] = 6.4500000000; fxg[129] = 1.1519000000; feg[129] = 0.0434000000;
					g[130] = 6.5000000000; fxg[130] = 1.1432000000; feg[130] = 0.0427000000;
					g[131] = 6.5500000000; fxg[131] = 1.1368000000; feg[131] = 0.0421000000;
					g[132] = 6.6000000000; fxg[132] = 1.1328000000; feg[132] = 0.0415000000;
					g[133] = 6.6500000000; fxg[133] = 1.1294000000; feg[133] = 0.0409000000;
					g[134] = 6.7000000000; fxg[134] = 1.1244000000; feg[134] = 0.0403000000;
					g[135] = 6.7500000000; fxg[135] = 1.1168000000; feg[135] = 0.0397000000;
					g[136] = 6.8000000000; fxg[136] = 1.1074000000; feg[136] = 0.0391000000;
					g[137] = 6.8500000000; fxg[137] = 1.0983000000; feg[137] = 0.0386000000;
					g[138] = 6.9000000000; fxg[138] = 1.0908000000; feg[138] = 0.0380000000;
					g[139] = 6.9500000000; fxg[139] = 1.0848000000; feg[139] = 0.0375000000;
					g[140] = 7.0000000000; fxg[140] = 1.0787000000; feg[140] = 0.0370000000;
					g[141] = 7.0500000000; fxg[141] = 1.0713000000; feg[141] = 0.0365000000;
					g[142] = 7.1000000000; fxg[142] = 1.0627000000; feg[142] = 0.0360000000;
					g[143] = 7.1500000000; fxg[143] = 1.0538000000; feg[143] = 0.0355000000;
					g[144] = 7.2000000000; fxg[144] = 1.0463000000; feg[144] = 0.0350000000;
					g[145] = 7.2500000000; fxg[145] = 1.0411000000; feg[145] = 0.0345000000;
					g[146] = 7.3000000000; fxg[146] = 1.0380000000; feg[146] = 0.0341000000;
					g[147] = 7.3500000000; fxg[147] = 1.0354000000; feg[147] = 0.0336000000;
					g[148] = 7.4000000000; fxg[148] = 1.0311000000; feg[148] = 0.0332000000;
					g[149] = 7.4500000000; fxg[149] = 1.0242000000; feg[149] = 0.0327000000;
					g[150] = 7.5000000000; fxg[150] = 1.0152000000; feg[150] = 0.0323000000;
					g[151] = 7.5500000000; fxg[151] = 1.0059000000; feg[151] = 0.0319000000;
					g[152] = 7.6000000000; fxg[152] = 0.9981000000; feg[152] = 0.0315000000;
					g[153] = 7.6500000000; fxg[153] = 0.9921000000; feg[153] = 0.0311000000;
					g[154] = 7.7000000000; fxg[154] = 0.9868000000; feg[154] = 0.0307000000;
					g[155] = 7.7500000000; fxg[155] = 0.9809000000; feg[155] = 0.0303000000;
					g[156] = 7.8000000000; fxg[156] = 0.9736000000; feg[156] = 0.0299000000;
					g[157] = 7.8500000000; fxg[157] = 0.9652000000; feg[157] = 0.0296000000;
					g[158] = 7.9000000000; fxg[158] = 0.9567000000; feg[158] = 0.0292000000;
					g[159] = 7.9500000000; fxg[159] = 0.9491000000; feg[159] = 0.0289000000;
					g[160] = 8.0000000000; fxg[160] = 0.9438000000; feg[160] = 0.0285000000;
					g[161] = 8.0500000000; fxg[161] = 0.9408000000; feg[161] = 0.0282000000;
					g[162] = 8.1000000000; fxg[162] = 0.9388000000; feg[162] = 0.0278000000;
					g[163] = 8.1500000000; fxg[163] = 0.9361000000; feg[163] = 0.0275000000;
					g[164] = 8.2000000000; fxg[164] = 0.9311000000; feg[164] = 0.0271000000;
					g[165] = 8.2500000000; fxg[165] = 0.9236000000; feg[165] = 0.0268000000;
					g[166] = 8.3000000000; fxg[166] = 0.9145000000; feg[166] = 0.0265000000;
					g[167] = 8.3500000000; fxg[167] = 0.9054000000; feg[167] = 0.0262000000;
					g[168] = 8.4000000000; fxg[168] = 0.8978000000; feg[168] = 0.0259000000;
					g[169] = 8.4500000000; fxg[169] = 0.8920000000; feg[169] = 0.0256000000;
					g[170] = 8.5000000000; fxg[170] = 0.8871000000; feg[170] = 0.0253000000;
					g[171] = 8.5500000000; fxg[171] = 0.8814000000; feg[171] = 0.0250000000;
					g[172] = 8.6000000000; fxg[172] = 0.8746000000; feg[172] = 0.0248000000;
					g[173] = 8.6500000000; fxg[173] = 0.8668000000; feg[173] = 0.0245000000;
					g[174] = 8.7000000000; fxg[174] = 0.8586000000; feg[174] = 0.0242000000;
					g[175] = 8.7500000000; fxg[175] = 0.8508000000; feg[175] = 0.0239000000;
					g[176] = 8.8000000000; fxg[176] = 0.8442000000; feg[176] = 0.0237000000;
					g[177] = 8.8500000000; fxg[177] = 0.8397000000; feg[177] = 0.0234000000;
					g[178] = 8.9000000000; fxg[178] = 0.8374000000; feg[178] = 0.0232000000;
					g[179] = 8.9500000000; fxg[179] = 0.8360000000; feg[179] = 0.0229000000;
					g[180] = 9.0000000000; fxg[180] = 0.8340000000; feg[180] = 0.0227000000;
					g[181] = 9.0500000000; fxg[181] = 0.8299000000; feg[181] = 0.0224000000;
					g[182] = 9.1000000000; fxg[182] = 0.8237000000; feg[182] = 0.0222000000;
					g[183] = 9.1500000000; fxg[183] = 0.8156000000; feg[183] = 0.0219000000;
					g[184] = 9.2000000000; fxg[184] = 0.8066000000; feg[184] = 0.0217000000;
					g[185] = 9.2500000000; fxg[185] = 0.7982000000; feg[185] = 0.0215000000;
					g[186] = 9.3000000000; fxg[186] = 0.7915000000; feg[186] = 0.0213000000;
					g[187] = 9.3500000000; fxg[187] = 0.7862000000; feg[187] = 0.0210000000;
					g[188] = 9.4000000000; fxg[188] = 0.7813000000; feg[188] = 0.0208000000;
					g[189] = 9.4500000000; fxg[189] = 0.7755000000; feg[189] = 0.0206000000;
					g[190] = 9.5000000000; fxg[190] = 0.7686000000; feg[190] = 0.0204000000;
					g[191] = 9.5500000000; fxg[191] = 0.7611000000; feg[191] = 0.0202000000;
					g[192] = 9.6000000000; fxg[192] = 0.7535000000; feg[192] = 0.0200000000;
					g[193] = 9.6500000000; fxg[193] = 0.7462000000; feg[193] = 0.0198000000;
					g[194] = 9.7000000000; fxg[194] = 0.7395000000; feg[194] = 0.0196000000;
					g[195] = 9.7500000000; fxg[195] = 0.7344000000; feg[195] = 0.0194000000;
					g[196] = 9.8000000000; fxg[196] = 0.7314000000; feg[196] = 0.0192000000;
					g[197] = 9.8500000000; fxg[197] = 0.7303000000; feg[197] = 0.0190000000;
					g[198] = 9.9000000000; fxg[198] = 0.7296000000; feg[198] = 0.0188000000;
					g[199] = 9.9500000000; fxg[199] = 0.7280000000; feg[199] = 0.0186000000;
					g[200] = 10.0000000000; fxg[200] = 0.7246000000; feg[200] = 0.0185000000;
					g[201] = 10.0500000000; fxg[201] = 0.7194000000; feg[201] = 0.0183000000;
					g[202] = 10.1000000000; fxg[202] = 0.7125000000; feg[202] = 0.0181000000;
					g[203] = 10.1500000000; fxg[203] = 0.7043000000; feg[203] = 0.0179000000;
					g[204] = 10.2000000000; fxg[204] = 0.6960000000; feg[204] = 0.0178000000;
					g[205] = 10.2500000000; fxg[205] = 0.6888000000; feg[205] = 0.0176000000;
					g[206] = 10.3000000000; fxg[206] = 0.6831000000; feg[206] = 0.0174000000;
					g[207] = 10.3500000000; fxg[207] = 0.6783000000; feg[207] = 0.0173000000;
					g[208] = 10.4000000000; fxg[208] = 0.6732000000; feg[208] = 0.0171000000;
					g[209] = 10.4500000000; fxg[209] = 0.6670000000; feg[209] = 0.0169000000;
					g[210] = 10.5000000000; fxg[210] = 0.6599000000; feg[210] = 0.0168000000;
					g[211] = 10.5500000000; fxg[211] = 0.6528000000; feg[211] = 0.0166000000;
					g[212] = 10.6000000000; fxg[212] = 0.6460000000; feg[212] = 0.0165000000;
					g[213] = 10.6500000000; fxg[213] = 0.6395000000; feg[213] = 0.0163000000;
					g[214] = 10.7000000000; fxg[214] = 0.6333000000; feg[214] = 0.0162000000;
					g[215] = 10.7500000000; fxg[215] = 0.6282000000; feg[215] = 0.0160000000;
					g[216] = 10.8000000000; fxg[216] = 0.6248000000; feg[216] = 0.0159000000;
					g[217] = 10.8500000000; fxg[217] = 0.6234000000; feg[217] = 0.0158000000;
					g[218] = 10.9000000000; fxg[218] = 0.6234000000; feg[218] = 0.0156000000;
					g[219] = 10.9500000000; fxg[219] = 0.6234000000; feg[219] = 0.0155000000;
					g[220] = 11.0000000000; fxg[220] = 0.6223000000; feg[220] = 0.0153000000;
					g[221] = 11.0500000000; fxg[221] = 0.6197000000; feg[221] = 0.0152000000;
					g[222] = 11.1000000000; fxg[222] = 0.6156000000; feg[222] = 0.0151000000;
					g[223] = 11.1500000000; fxg[223] = 0.6102000000; feg[223] = 0.0149000000;
					g[224] = 11.2000000000; fxg[224] = 0.6033000000; feg[224] = 0.0148000000;
					g[225] = 11.2500000000; fxg[225] = 0.5957000000; feg[225] = 0.0147000000;
					g[226] = 11.3000000000; fxg[226] = 0.5884000000; feg[226] = 0.0146000000;
					g[227] = 11.3500000000; fxg[227] = 0.5823000000; feg[227] = 0.0144000000;
					g[228] = 11.4000000000; fxg[228] = 0.5774000000; feg[228] = 0.0143000000;
					g[229] = 11.4500000000; fxg[229] = 0.5728000000; feg[229] = 0.0142000000;
					g[230] = 11.5000000000; fxg[230] = 0.5676000000; feg[230] = 0.0141000000;
					g[231] = 11.5500000000; fxg[231] = 0.5613000000; feg[231] = 0.0139000000;
					g[232] = 11.6000000000; fxg[232] = 0.5543000000; feg[232] = 0.0138000000;
					g[233] = 11.6500000000; fxg[233] = 0.5475000000; feg[233] = 0.0137000000;
					g[234] = 11.7000000000; fxg[234] = 0.5414000000; feg[234] = 0.0136000000;
					g[235] = 11.7500000000; fxg[235] = 0.5358000000; feg[235] = 0.0135000000;
					g[236] = 11.8000000000; fxg[236] = 0.5305000000; feg[236] = 0.0134000000;
					g[237] = 11.8500000000; fxg[237] = 0.5256000000; feg[237] = 0.0133000000;
					g[238] = 11.9000000000; fxg[238] = 0.5218000000; feg[238] = 0.0132000000;
					g[239] = 11.9500000000; fxg[239] = 0.5198000000; feg[239] = 0.0131000000;
					g[240] = 12.0000000000; fxg[240] = 0.5196000000; feg[240] = 0.0130000000;
					break;
				case 21:
					g[0] = 0.0000000000; fxg[0] = 21.0000000000; feg[0] = 9.3120000000;
					g[1] = 0.0500000000; fxg[1] = 20.7639000000; feg[1] = 9.0427000000;
					g[2] = 0.1000000000; fxg[2] = 20.1308000000; feg[2] = 8.3208000000;
					g[3] = 0.1500000000; fxg[3] = 19.2728000000; feg[3] = 7.3490000000;
					g[4] = 0.2000000000; fxg[4] = 18.3535000000; feg[4] = 6.3340000000;
					g[5] = 0.2500000000; fxg[5] = 17.4671000000; feg[5] = 5.4115000000;
					g[6] = 0.3000000000; fxg[6] = 16.6410000000; feg[6] = 4.6368000000;
					g[7] = 0.3500000000; fxg[7] = 15.8675000000; feg[7] = 4.0111000000;
					g[8] = 0.4000000000; fxg[8] = 15.1307000000; feg[8] = 3.5118000000;
					g[9] = 0.4500000000; fxg[9] = 14.4192000000; feg[9] = 3.1112000000;
					g[10] = 0.5000000000; fxg[10] = 13.7290000000; feg[10] = 2.7844000000;
					g[11] = 0.5500000000; fxg[11] = 13.0614000000; feg[11] = 2.5124000000;
					g[12] = 0.6000000000; fxg[12] = 12.4212000000; feg[12] = 2.2814000000;
					g[13] = 0.6500000000; fxg[13] = 11.8134000000; feg[13] = 2.0816000000;
					g[14] = 0.7000000000; fxg[14] = 11.2429000000; feg[14] = 1.9063000000;
					g[15] = 0.7500000000; fxg[15] = 10.7129000000; feg[15] = 1.7508000000;
					g[16] = 0.8000000000; fxg[16] = 10.2254000000; feg[16] = 1.6117000000;
					g[17] = 0.8500000000; fxg[17] = 9.7805000000; feg[17] = 1.4866000000;
					g[18] = 0.9000000000; fxg[18] = 9.3773000000; feg[18] = 1.3737000000;
					g[19] = 0.9500000000; fxg[19] = 9.0138000000; feg[19] = 1.2715000000;
					g[20] = 1.0000000000; fxg[20] = 8.6873000000; feg[20] = 1.1788000000;
					g[21] = 1.0500000000; fxg[21] = 8.3944000000; feg[21] = 1.0946000000;
					g[22] = 1.1000000000; fxg[22] = 8.1316000000; feg[22] = 1.0181000000;
					g[23] = 1.1500000000; fxg[23] = 7.8955000000; feg[23] = 0.9486000000;
					g[24] = 1.2000000000; fxg[24] = 7.6824000000; feg[24] = 0.8854000000;
					g[25] = 1.2500000000; fxg[25] = 7.4889000000; feg[25] = 0.8278000000;
					g[26] = 1.3000000000; fxg[26] = 7.3120000000; feg[26] = 0.7754000000;
					g[27] = 1.3500000000; fxg[27] = 7.1487000000; feg[27] = 0.7276000000;
					g[28] = 1.4000000000; fxg[28] = 6.9967000000; feg[28] = 0.6840000000;
					g[29] = 1.4500000000; fxg[29] = 6.8535000000; feg[29] = 0.6441000000;
					g[30] = 1.5000000000; fxg[30] = 6.7174000000; feg[30] = 0.6077000000;
					g[31] = 1.5500000000; fxg[31] = 6.5867000000; feg[31] = 0.5743000000;
					g[32] = 1.6000000000; fxg[32] = 6.4601000000; feg[32] = 0.5437000000;
					g[33] = 1.6500000000; fxg[33] = 6.3364000000; feg[33] = 0.5156000000;
					g[34] = 1.7000000000; fxg[34] = 6.2147000000; feg[34] = 0.4898000000;
					g[35] = 1.7500000000; fxg[35] = 6.0945000000; feg[35] = 0.4660000000;
					g[36] = 1.8000000000; fxg[36] = 5.9752000000; feg[36] = 0.4439000000;
					g[37] = 1.8500000000; fxg[37] = 5.8565000000; feg[37] = 0.4236000000;
					g[38] = 1.9000000000; fxg[38] = 5.7378000000; feg[38] = 0.4047000000;
					g[39] = 1.9500000000; fxg[39] = 5.6195000000; feg[39] = 0.3872000000;
					g[40] = 2.0000000000; fxg[40] = 5.5014000000; feg[40] = 0.3709000000;
					g[41] = 2.0500000000; fxg[41] = 5.3833000000; feg[41] = 0.3558000000;
					g[42] = 2.1000000000; fxg[42] = 5.2652000000; feg[42] = 0.3416000000;
					g[43] = 2.1500000000; fxg[43] = 5.1475000000; feg[43] = 0.3283000000;
					g[44] = 2.2000000000; fxg[44] = 5.0307000000; feg[44] = 0.3159000000;
					g[45] = 2.2500000000; fxg[45] = 4.9144000000; feg[45] = 0.3042000000;
					g[46] = 2.3000000000; fxg[46] = 4.7983000000; feg[46] = 0.2932000000;
					g[47] = 2.3500000000; fxg[47] = 4.6832000000; feg[47] = 0.2829000000;
					g[48] = 2.4000000000; fxg[48] = 4.5698000000; feg[48] = 0.2731000000;
					g[49] = 2.4500000000; fxg[49] = 4.4581000000; feg[49] = 0.2638000000;
					g[50] = 2.5000000000; fxg[50] = 4.3476000000; feg[50] = 0.2551000000;
					g[51] = 2.5500000000; fxg[51] = 4.2379000000; feg[51] = 0.2468000000;
					g[52] = 2.6000000000; fxg[52] = 4.1300000000; feg[52] = 0.2389000000;
					g[53] = 2.6500000000; fxg[53] = 4.0249000000; feg[53] = 0.2314000000;
					g[54] = 2.7000000000; fxg[54] = 3.9226000000; feg[54] = 0.2243000000;
					g[55] = 2.7500000000; fxg[55] = 3.8222000000; feg[55] = 0.2175000000;
					g[56] = 2.8000000000; fxg[56] = 3.7229000000; feg[56] = 0.2110000000;
					g[57] = 2.8500000000; fxg[57] = 3.6254000000; feg[57] = 0.2048000000;
					g[58] = 2.9000000000; fxg[58] = 3.5310000000; feg[58] = 0.1989000000;
					g[59] = 2.9500000000; fxg[59] = 3.4404000000; feg[59] = 0.1932000000;
					g[60] = 3.0000000000; fxg[60] = 3.3529000000; feg[60] = 0.1877000000;
					g[61] = 3.0500000000; fxg[61] = 3.2671000000; feg[61] = 0.1825000000;
					g[62] = 3.1000000000; fxg[62] = 3.1824000000; feg[62] = 0.1775000000;
					g[63] = 3.1500000000; fxg[63] = 3.0998000000; feg[63] = 0.1727000000;
					g[64] = 3.2000000000; fxg[64] = 3.0204000000; feg[64] = 0.1681000000;
					g[65] = 3.2500000000; fxg[65] = 2.9452000000; feg[65] = 0.1636000000;
					g[66] = 3.3000000000; fxg[66] = 2.8736000000; feg[66] = 0.1594000000;
					g[67] = 3.3500000000; fxg[67] = 2.8039000000; feg[67] = 0.1552000000;
					g[68] = 3.4000000000; fxg[68] = 2.7352000000; feg[68] = 0.1513000000;
					g[69] = 3.4500000000; fxg[69] = 2.6677000000; feg[69] = 0.1475000000;
					g[70] = 3.5000000000; fxg[70] = 2.6024000000; feg[70] = 0.1438000000;
					g[71] = 3.5500000000; fxg[71] = 2.5407000000; feg[71] = 0.1402000000;
					g[72] = 3.6000000000; fxg[72] = 2.4831000000; feg[72] = 0.1368000000;
					g[73] = 3.6500000000; fxg[73] = 2.4288000000; feg[73] = 0.1335000000;
					g[74] = 3.7000000000; fxg[74] = 2.3759000000; feg[74] = 0.1302000000;
					g[75] = 3.7500000000; fxg[75] = 2.3235000000; feg[75] = 0.1271000000;
					g[76] = 3.8000000000; fxg[76] = 2.2718000000; feg[76] = 0.1242000000;
					g[77] = 3.8500000000; fxg[77] = 2.2216000000; feg[77] = 0.1213000000;
					g[78] = 3.9000000000; fxg[78] = 2.1741000000; feg[78] = 0.1185000000;
					g[79] = 3.9500000000; fxg[79] = 2.1301000000; feg[79] = 0.1158000000;
					g[80] = 4.0000000000; fxg[80] = 2.0898000000; feg[80] = 0.1131000000;
					g[81] = 4.0500000000; fxg[81] = 2.0516000000; feg[81] = 0.1106000000;
					g[82] = 4.1000000000; fxg[82] = 2.0139000000; feg[82] = 0.1081000000;
					g[83] = 4.1500000000; fxg[83] = 1.9760000000; feg[83] = 0.1057000000;
					g[84] = 4.2000000000; fxg[84] = 1.9385000000; feg[84] = 0.1034000000;
					g[85] = 4.2500000000; fxg[85] = 1.9021000000; feg[85] = 0.1012000000;
					g[86] = 4.3000000000; fxg[86] = 1.8676000000; feg[86] = 0.0991000000;
					g[87] = 4.3500000000; fxg[87] = 1.8359000000; feg[87] = 0.0970000000;
					g[88] = 4.4000000000; fxg[88] = 1.8075000000; feg[88] = 0.0949000000;
					g[89] = 4.4500000000; fxg[89] = 1.7815000000; feg[89] = 0.0929000000;
					g[90] = 4.5000000000; fxg[90] = 1.7561000000; feg[90] = 0.0910000000;
					g[91] = 4.5500000000; fxg[91] = 1.7300000000; feg[91] = 0.0891000000;
					g[92] = 4.6000000000; fxg[92] = 1.7036000000; feg[92] = 0.0873000000;
					g[93] = 4.6500000000; fxg[93] = 1.6776000000; feg[93] = 0.0856000000;
					g[94] = 4.7000000000; fxg[94] = 1.6524000000; feg[94] = 0.0838000000;
					g[95] = 4.7500000000; fxg[95] = 1.6283000000; feg[95] = 0.0822000000;
					g[96] = 4.8000000000; fxg[96] = 1.6062000000; feg[96] = 0.0806000000;
					g[97] = 4.8500000000; fxg[97] = 1.5869000000; feg[97] = 0.0790000000;
					g[98] = 4.9000000000; fxg[98] = 1.5701000000; feg[98] = 0.0775000000;
					g[99] = 4.9500000000; fxg[99] = 1.5540000000; feg[99] = 0.0760000000;
					g[100] = 5.0000000000; fxg[100] = 1.5370000000; feg[100] = 0.0745000000;
					g[101] = 5.0500000000; fxg[101] = 1.5189000000; feg[101] = 0.0731000000;
					g[102] = 5.1000000000; fxg[102] = 1.5007000000; feg[102] = 0.0718000000;
					g[103] = 5.1500000000; fxg[103] = 1.4832000000; feg[103] = 0.0704000000;
					g[104] = 5.2000000000; fxg[104] = 1.4661000000; feg[104] = 0.0692000000;
					g[105] = 5.2500000000; fxg[105] = 1.4493000000; feg[105] = 0.0679000000;
					g[106] = 5.3000000000; fxg[106] = 1.4338000000; feg[106] = 0.0667000000;
					g[107] = 5.3500000000; fxg[107] = 1.4206000000; feg[107] = 0.0655000000;
					g[108] = 5.4000000000; fxg[108] = 1.4099000000; feg[108] = 0.0643000000;
					g[109] = 5.4500000000; fxg[109] = 1.4002000000; feg[109] = 0.0632000000;
					g[110] = 5.5000000000; fxg[110] = 1.3895000000; feg[110] = 0.0621000000;
					g[111] = 5.5500000000; fxg[111] = 1.3772000000; feg[111] = 0.0610000000;
					g[112] = 5.6000000000; fxg[112] = 1.3640000000; feg[112] = 0.0599000000;
					g[113] = 5.6500000000; fxg[113] = 1.3514000000; feg[113] = 0.0589000000;
					g[114] = 5.7000000000; fxg[114] = 1.3395000000; feg[114] = 0.0579000000;
					g[115] = 5.7500000000; fxg[115] = 1.3276000000; feg[115] = 0.0570000000;
					g[116] = 5.8000000000; fxg[116] = 1.3155000000; feg[116] = 0.0560000000;
					g[117] = 5.8500000000; fxg[117] = 1.3038000000; feg[117] = 0.0551000000;
					g[118] = 5.9000000000; fxg[118] = 1.2940000000; feg[118] = 0.0542000000;
					g[119] = 5.9500000000; fxg[119] = 1.2866000000; feg[119] = 0.0533000000;
					g[120] = 6.0000000000; fxg[120] = 1.2807000000; feg[120] = 0.0524000000;
					g[121] = 6.0500000000; fxg[121] = 1.2743000000; feg[121] = 0.0516000000;
					g[122] = 6.1000000000; fxg[122] = 1.2660000000; feg[122] = 0.0508000000;
					g[123] = 6.1500000000; fxg[123] = 1.2559000000; feg[123] = 0.0500000000;
					g[124] = 6.2000000000; fxg[124] = 1.2456000000; feg[124] = 0.0492000000;
					g[125] = 6.2500000000; fxg[125] = 1.2363000000; feg[125] = 0.0484000000;
					g[126] = 6.3000000000; fxg[126] = 1.2278000000; feg[126] = 0.0477000000;
					g[127] = 6.3500000000; fxg[127] = 1.2192000000; feg[127] = 0.0470000000;
					g[128] = 6.4000000000; fxg[128] = 1.2097000000; feg[128] = 0.0463000000;
					g[129] = 6.4500000000; fxg[129] = 1.2000000000; feg[129] = 0.0456000000;
					g[130] = 6.5000000000; fxg[130] = 1.1913000000; feg[130] = 0.0449000000;
					g[131] = 6.5500000000; fxg[131] = 1.1848000000; feg[131] = 0.0442000000;
					g[132] = 6.6000000000; fxg[132] = 1.1805000000; feg[132] = 0.0436000000;
					g[133] = 6.6500000000; fxg[133] = 1.1768000000; feg[133] = 0.0429000000;
					g[134] = 6.7000000000; fxg[134] = 1.1718000000; feg[134] = 0.0423000000;
					g[135] = 6.7500000000; fxg[135] = 1.1644000000; feg[135] = 0.0417000000;
					g[136] = 6.8000000000; fxg[136] = 1.1553000000; feg[136] = 0.0411000000;
					g[137] = 6.8500000000; fxg[137] = 1.1463000000; feg[137] = 0.0405000000;
					g[138] = 6.9000000000; fxg[138] = 1.1385000000; feg[138] = 0.0399000000;
					g[139] = 6.9500000000; fxg[139] = 1.1319000000; feg[139] = 0.0394000000;
					g[140] = 7.0000000000; fxg[140] = 1.1252000000; feg[140] = 0.0388000000;
					g[141] = 7.0500000000; fxg[141] = 1.1176000000; feg[141] = 0.0383000000;
					g[142] = 7.1000000000; fxg[142] = 1.1089000000; feg[142] = 0.0378000000;
					g[143] = 7.1500000000; fxg[143] = 1.1003000000; feg[143] = 0.0373000000;
					g[144] = 7.2000000000; fxg[144] = 1.0931000000; feg[144] = 0.0368000000;
					g[145] = 7.2500000000; fxg[145] = 1.0881000000; feg[145] = 0.0363000000;
					g[146] = 7.3000000000; fxg[146] = 1.0852000000; feg[146] = 0.0358000000;
					g[147] = 7.3500000000; fxg[147] = 1.0826000000; feg[147] = 0.0353000000;
					g[148] = 7.4000000000; fxg[148] = 1.0785000000; feg[148] = 0.0348000000;
					g[149] = 7.4500000000; fxg[149] = 1.0719000000; feg[149] = 0.0344000000;
					g[150] = 7.5000000000; fxg[150] = 1.0634000000; feg[150] = 0.0339000000;
					g[151] = 7.5500000000; fxg[151] = 1.0545000000; feg[151] = 0.0335000000;
					g[152] = 7.6000000000; fxg[152] = 1.0468000000; feg[152] = 0.0331000000;
					g[153] = 7.6500000000; fxg[153] = 1.0406000000; feg[153] = 0.0327000000;
					g[154] = 7.7000000000; fxg[154] = 1.0351000000; feg[154] = 0.0322000000;
					g[155] = 7.7500000000; fxg[155] = 1.0290000000; feg[155] = 0.0318000000;
					g[156] = 7.8000000000; fxg[156] = 1.0217000000; feg[156] = 0.0314000000;
					g[157] = 7.8500000000; fxg[157] = 1.0135000000; feg[157] = 0.0311000000;
					g[158] = 7.9000000000; fxg[158] = 1.0052000000; feg[158] = 0.0307000000;
					g[159] = 7.9500000000; fxg[159] = 0.9981000000; feg[159] = 0.0303000000;
					g[160] = 8.0000000000; fxg[160] = 0.9931000000; feg[160] = 0.0299000000;
					g[161] = 8.0500000000; fxg[161] = 0.9903000000; feg[161] = 0.0296000000;
					g[162] = 8.1000000000; fxg[162] = 0.9884000000; feg[162] = 0.0292000000;
					g[163] = 8.1500000000; fxg[163] = 0.9858000000; feg[163] = 0.0288000000;
					g[164] = 8.2000000000; fxg[164] = 0.9811000000; feg[164] = 0.0285000000;
					g[165] = 8.2500000000; fxg[165] = 0.9740000000; feg[165] = 0.0282000000;
					g[166] = 8.3000000000; fxg[166] = 0.9652000000; feg[166] = 0.0278000000;
					g[167] = 8.3500000000; fxg[167] = 0.9565000000; feg[167] = 0.0275000000;
					g[168] = 8.4000000000; fxg[168] = 0.9491000000; feg[168] = 0.0272000000;
					g[169] = 8.4500000000; fxg[169] = 0.9433000000; feg[169] = 0.0269000000;
					g[170] = 8.5000000000; fxg[170] = 0.9383000000; feg[170] = 0.0266000000;
					g[171] = 8.5500000000; fxg[171] = 0.9328000000; feg[171] = 0.0263000000;
					g[172] = 8.6000000000; fxg[172] = 0.9261000000; feg[172] = 0.0260000000;
					g[173] = 8.6500000000; fxg[173] = 0.9184000000; feg[173] = 0.0257000000;
					g[174] = 8.7000000000; fxg[174] = 0.9103000000; feg[174] = 0.0254000000;
					g[175] = 8.7500000000; fxg[175] = 0.9026000000; feg[175] = 0.0251000000;
					g[176] = 8.8000000000; fxg[176] = 0.8963000000; feg[176] = 0.0249000000;
					g[177] = 8.8500000000; fxg[177] = 0.8920000000; feg[177] = 0.0246000000;
					g[178] = 8.9000000000; fxg[178] = 0.8899000000; feg[178] = 0.0243000000;
					g[179] = 8.9500000000; fxg[179] = 0.8886000000; feg[179] = 0.0240000000;
					g[180] = 9.0000000000; fxg[180] = 0.8867000000; feg[180] = 0.0238000000;
					g[181] = 9.0500000000; fxg[181] = 0.8828000000; feg[181] = 0.0235000000;
					g[182] = 9.1000000000; fxg[182] = 0.8766000000; feg[182] = 0.0233000000;
					g[183] = 9.1500000000; fxg[183] = 0.8686000000; feg[183] = 0.0230000000;
					g[184] = 9.2000000000; fxg[184] = 0.8598000000; feg[184] = 0.0228000000;
					g[185] = 9.2500000000; fxg[185] = 0.8516000000; feg[185] = 0.0225000000;
					g[186] = 9.3000000000; fxg[186] = 0.8450000000; feg[186] = 0.0223000000;
					g[187] = 9.3500000000; fxg[187] = 0.8398000000; feg[187] = 0.0221000000;
					g[188] = 9.4000000000; fxg[188] = 0.8350000000; feg[188] = 0.0218000000;
					g[189] = 9.4500000000; fxg[189] = 0.8294000000; feg[189] = 0.0216000000;
					g[190] = 9.5000000000; fxg[190] = 0.8228000000; feg[190] = 0.0214000000;
					g[191] = 9.5500000000; fxg[191] = 0.8154000000; feg[191] = 0.0212000000;
					g[192] = 9.6000000000; fxg[192] = 0.8078000000; feg[192] = 0.0210000000;
					g[193] = 9.6500000000; fxg[193] = 0.8003000000; feg[193] = 0.0208000000;
					g[194] = 9.7000000000; fxg[194] = 0.7937000000; feg[194] = 0.0206000000;
					g[195] = 9.7500000000; fxg[195] = 0.7887000000; feg[195] = 0.0204000000;
					g[196] = 9.8000000000; fxg[196] = 0.7858000000; feg[196] = 0.0201000000;
					g[197] = 9.8500000000; fxg[197] = 0.7847000000; feg[197] = 0.0199000000;
					g[198] = 9.9000000000; fxg[198] = 0.7841000000; feg[198] = 0.0197000000;
					g[199] = 9.9500000000; fxg[199] = 0.7825000000; feg[199] = 0.0196000000;
					g[200] = 10.0000000000; fxg[200] = 0.7791000000; feg[200] = 0.0194000000;
					g[201] = 10.0500000000; fxg[201] = 0.7738000000; feg[201] = 0.0192000000;
					g[202] = 10.1000000000; fxg[202] = 0.7666000000; feg[202] = 0.0190000000;
					g[203] = 10.1500000000; fxg[203] = 0.7583000000; feg[203] = 0.0188000000;
					g[204] = 10.2000000000; fxg[204] = 0.7500000000; feg[204] = 0.0186000000;
					g[205] = 10.2500000000; fxg[205] = 0.7429000000; feg[205] = 0.0185000000;
					g[206] = 10.3000000000; fxg[206] = 0.7372000000; feg[206] = 0.0183000000;
					g[207] = 10.3500000000; fxg[207] = 0.7326000000; feg[207] = 0.0181000000;
					g[208] = 10.4000000000; fxg[208] = 0.7277000000; feg[208] = 0.0179000000;
					g[209] = 10.4500000000; fxg[209] = 0.7219000000; feg[209] = 0.0178000000;
					g[210] = 10.5000000000; fxg[210] = 0.7151000000; feg[210] = 0.0176000000;
					g[211] = 10.5500000000; fxg[211] = 0.7080000000; feg[211] = 0.0175000000;
					g[212] = 10.6000000000; fxg[212] = 0.7010000000; feg[212] = 0.0173000000;
					g[213] = 10.6500000000; fxg[213] = 0.6941000000; feg[213] = 0.0171000000;
					g[214] = 10.7000000000; fxg[214] = 0.6878000000; feg[214] = 0.0170000000;
					g[215] = 10.7500000000; fxg[215] = 0.6825000000; feg[215] = 0.0168000000;
					g[216] = 10.8000000000; fxg[216] = 0.6791000000; feg[216] = 0.0167000000;
					g[217] = 10.8500000000; fxg[217] = 0.6777000000; feg[217] = 0.0165000000;
					g[218] = 10.9000000000; fxg[218] = 0.6777000000; feg[218] = 0.0164000000;
					g[219] = 10.9500000000; fxg[219] = 0.6777000000; feg[219] = 0.0162000000;
					g[220] = 11.0000000000; fxg[220] = 0.6767000000; feg[220] = 0.0161000000;
					g[221] = 11.0500000000; fxg[221] = 0.6740000000; feg[221] = 0.0159000000;
					g[222] = 11.1000000000; fxg[222] = 0.6696000000; feg[222] = 0.0158000000;
					g[223] = 11.1500000000; fxg[223] = 0.6637000000; feg[223] = 0.0157000000;
					g[224] = 11.2000000000; fxg[224] = 0.6564000000; feg[224] = 0.0155000000;
					g[225] = 11.2500000000; fxg[225] = 0.6485000000; feg[225] = 0.0154000000;
					g[226] = 11.3000000000; fxg[226] = 0.6411000000; feg[226] = 0.0153000000;
					g[227] = 11.3500000000; fxg[227] = 0.6350000000; feg[227] = 0.0151000000;
					g[228] = 11.4000000000; fxg[228] = 0.6302000000; feg[228] = 0.0150000000;
					g[229] = 11.4500000000; fxg[229] = 0.6257000000; feg[229] = 0.0149000000;
					g[230] = 11.5000000000; fxg[230] = 0.6208000000; feg[230] = 0.0148000000;
					g[231] = 11.5500000000; fxg[231] = 0.6148000000; feg[231] = 0.0146000000;
					g[232] = 11.6000000000; fxg[232] = 0.6081000000; feg[232] = 0.0145000000;
					g[233] = 11.6500000000; fxg[233] = 0.6013000000; feg[233] = 0.0144000000;
					g[234] = 11.7000000000; fxg[234] = 0.5949000000; feg[234] = 0.0143000000;
					g[235] = 11.7500000000; fxg[235] = 0.5888000000; feg[235] = 0.0142000000;
					g[236] = 11.8000000000; fxg[236] = 0.5831000000; feg[236] = 0.0140000000;
					g[237] = 11.8500000000; fxg[237] = 0.5779000000; feg[237] = 0.0139000000;
					g[238] = 11.9000000000; fxg[238] = 0.5740000000; feg[238] = 0.0138000000;
					g[239] = 11.9500000000; fxg[239] = 0.5720000000; feg[239] = 0.0137000000;
					g[240] = 12.0000000000; fxg[240] = 0.5717000000; feg[240] = 0.0136000000;
					break;
				case 22:
					g[0] = 0.0000000000; fxg[0] = 22.0000000000; feg[0] = 8.7797000000;
					g[1] = 0.0500000000; fxg[1] = 21.7766000000; feg[1] = 8.5543000000;
					g[2] = 0.1000000000; fxg[2] = 21.1702000000; feg[2] = 7.9444000000;
					g[3] = 0.1500000000; fxg[3] = 20.3294000000; feg[3] = 7.1081000000;
					g[4] = 0.2000000000; fxg[4] = 19.4041000000; feg[4] = 6.2131000000;
					g[5] = 0.2500000000; fxg[5] = 18.4895000000; feg[5] = 5.3772000000;
					g[6] = 0.3000000000; fxg[6] = 17.6231000000; feg[6] = 4.6558000000;
					g[7] = 0.3500000000; fxg[7] = 16.8067000000; feg[7] = 4.0586000000;
					g[8] = 0.4000000000; fxg[8] = 16.0298000000; feg[8] = 3.5722000000;
					g[9] = 0.4500000000; fxg[9] = 15.2826000000; feg[9] = 3.1758000000;
					g[10] = 0.5000000000; fxg[10] = 14.5599000000; feg[10] = 2.8491000000;
					g[11] = 0.5500000000; fxg[11] = 13.8616000000; feg[11] = 2.5756000000;
					g[12] = 0.6000000000; fxg[12] = 13.1902000000; feg[12] = 2.3428000000;
					g[13] = 0.6500000000; fxg[13] = 12.5497000000; feg[13] = 2.1414000000;
					g[14] = 0.7000000000; fxg[14] = 11.9441000000; feg[14] = 1.9647000000;
					g[15] = 0.7500000000; fxg[15] = 11.3767000000; feg[15] = 1.8080000000;
					g[16] = 0.8000000000; fxg[16] = 10.8496000000; feg[16] = 1.6679000000;
					g[17] = 0.8500000000; fxg[17] = 10.3638000000; feg[17] = 1.5419000000;
					g[18] = 0.9000000000; fxg[18] = 9.9191000000; feg[18] = 1.4279000000;
					g[19] = 0.9500000000; fxg[19] = 9.5144000000; feg[19] = 1.3244000000;
					g[20] = 1.0000000000; fxg[20] = 9.1477000000; feg[20] = 1.2304000000;
					g[21] = 1.0500000000; fxg[21] = 8.8166000000; feg[21] = 1.1448000000;
					g[22] = 1.1000000000; fxg[22] = 8.5182000000; feg[22] = 1.0667000000;
					g[23] = 1.1500000000; fxg[23] = 8.2494000000; feg[23] = 0.9954000000;
					g[24] = 1.2000000000; fxg[24] = 8.0070000000; feg[24] = 0.9303000000;
					g[25] = 1.2500000000; fxg[25] = 7.7879000000; feg[25] = 0.8708000000;
					g[26] = 1.3000000000; fxg[26] = 7.5890000000; feg[26] = 0.8163000000;
					g[27] = 1.3500000000; fxg[27] = 7.4075000000; feg[27] = 0.7665000000;
					g[28] = 1.4000000000; fxg[28] = 7.2408000000; feg[28] = 0.7209000000;
					g[29] = 1.4500000000; fxg[29] = 7.0863000000; feg[29] = 0.6791000000;
					g[30] = 1.5000000000; fxg[30] = 6.9420000000; feg[30] = 0.6407000000;
					g[31] = 1.5500000000; fxg[31] = 6.8060000000; feg[31] = 0.6054000000;
					g[32] = 1.6000000000; fxg[32] = 6.6767000000; feg[32] = 0.5730000000;
					g[33] = 1.6500000000; fxg[33] = 6.5526000000; feg[33] = 0.5432000000;
					g[34] = 1.7000000000; fxg[34] = 6.4324000000; feg[34] = 0.5157000000;
					g[35] = 1.7500000000; fxg[35] = 6.3153000000; feg[35] = 0.4903000000;
					g[36] = 1.8000000000; fxg[36] = 6.2005000000; feg[36] = 0.4668000000;
					g[37] = 1.8500000000; fxg[37] = 6.0872000000; feg[37] = 0.4451000000;
					g[38] = 1.9000000000; fxg[38] = 5.9750000000; feg[38] = 0.4250000000;
					g[39] = 1.9500000000; fxg[39] = 5.8635000000; feg[39] = 0.4063000000;
					g[40] = 2.0000000000; fxg[40] = 5.7526000000; feg[40] = 0.3889000000;
					g[41] = 2.0500000000; fxg[41] = 5.6418000000; feg[41] = 0.3726000000;
					g[42] = 2.1000000000; fxg[42] = 5.5310000000; feg[42] = 0.3575000000;
					g[43] = 2.1500000000; fxg[43] = 5.4205000000; feg[43] = 0.3434000000;
					g[44] = 2.2000000000; fxg[44] = 5.3105000000; feg[44] = 0.3301000000;
					g[45] = 2.2500000000; fxg[45] = 5.2005000000; feg[45] = 0.3177000000;
					g[46] = 2.3000000000; fxg[46] = 5.0905000000; feg[46] = 0.3060000000;
					g[47] = 2.3500000000; fxg[47] = 4.9808000000; feg[47] = 0.2950000000;
					g[48] = 2.4000000000; fxg[48] = 4.8722000000; feg[48] = 0.2847000000;
					g[49] = 2.4500000000; fxg[49] = 4.7645000000; feg[49] = 0.2749000000;
					g[50] = 2.5000000000; fxg[50] = 4.6573000000; feg[50] = 0.2656000000;
					g[51] = 2.5500000000; fxg[51] = 4.5506000000; feg[51] = 0.2569000000;
					g[52] = 2.6000000000; fxg[52] = 4.4449000000; feg[52] = 0.2486000000;
					g[53] = 2.6500000000; fxg[53] = 4.3412000000; feg[53] = 0.2407000000;
					g[54] = 2.7000000000; fxg[54] = 4.2395000000; feg[54] = 0.2332000000;
					g[55] = 2.7500000000; fxg[55] = 4.1390000000; feg[55] = 0.2261000000;
					g[56] = 2.8000000000; fxg[56] = 4.0392000000; feg[56] = 0.2193000000;
					g[57] = 2.8500000000; fxg[57] = 3.9408000000; feg[57] = 0.2129000000;
					g[58] = 2.9000000000; fxg[58] = 3.8449000000; feg[58] = 0.2067000000;
					g[59] = 2.9500000000; fxg[59] = 3.7519000000; feg[59] = 0.2007000000;
					g[60] = 3.0000000000; fxg[60] = 3.6614000000; feg[60] = 0.1951000000;
					g[61] = 3.0500000000; fxg[61] = 3.5722000000; feg[61] = 0.1896000000;
					g[62] = 3.1000000000; fxg[62] = 3.4841000000; feg[62] = 0.1845000000;
					g[63] = 3.1500000000; fxg[63] = 3.3977000000; feg[63] = 0.1795000000;
					g[64] = 3.2000000000; fxg[64] = 3.3141000000; feg[64] = 0.1747000000;
					g[65] = 3.2500000000; fxg[65] = 3.2341000000; feg[65] = 0.1701000000;
					g[66] = 3.3000000000; fxg[66] = 3.1572000000; feg[66] = 0.1656000000;
					g[67] = 3.3500000000; fxg[67] = 3.0821000000; feg[67] = 0.1614000000;
					g[68] = 3.4000000000; fxg[68] = 3.0080000000; feg[68] = 0.1573000000;
					g[69] = 3.4500000000; fxg[69] = 2.9350000000; feg[69] = 0.1533000000;
					g[70] = 3.5000000000; fxg[70] = 2.8642000000; feg[70] = 0.1495000000;
					g[71] = 3.5500000000; fxg[71] = 2.7967000000; feg[71] = 0.1459000000;
					g[72] = 3.6000000000; fxg[72] = 2.7330000000; feg[72] = 0.1423000000;
					g[73] = 3.6500000000; fxg[73] = 2.6722000000; feg[73] = 0.1389000000;
					g[74] = 3.7000000000; fxg[74] = 2.6131000000; feg[74] = 0.1356000000;
					g[75] = 3.7500000000; fxg[75] = 2.5545000000; feg[75] = 0.1324000000;
					g[76] = 3.8000000000; fxg[76] = 2.4967000000; feg[76] = 0.1293000000;
					g[77] = 3.8500000000; fxg[77] = 2.4405000000; feg[77] = 0.1263000000;
					g[78] = 3.9000000000; fxg[78] = 2.3871000000; feg[78] = 0.1234000000;
					g[79] = 3.9500000000; fxg[79] = 2.3371000000; feg[79] = 0.1206000000;
					g[80] = 4.0000000000; fxg[80] = 2.2905000000; feg[80] = 0.1179000000;
					g[81] = 4.0500000000; fxg[81] = 2.2461000000; feg[81] = 0.1153000000;
					g[82] = 4.1000000000; fxg[82] = 2.2023000000; feg[82] = 0.1127000000;
					g[83] = 4.1500000000; fxg[83] = 2.1587000000; feg[83] = 0.1103000000;
					g[84] = 4.2000000000; fxg[84] = 2.1156000000; feg[84] = 0.1079000000;
					g[85] = 4.2500000000; fxg[85] = 2.0737000000; feg[85] = 0.1056000000;
					g[86] = 4.3000000000; fxg[86] = 2.0339000000; feg[86] = 0.1034000000;
					g[87] = 4.3500000000; fxg[87] = 1.9970000000; feg[87] = 0.1012000000;
					g[88] = 4.4000000000; fxg[88] = 1.9632000000; feg[88] = 0.0991000000;
					g[89] = 4.4500000000; fxg[89] = 1.9319000000; feg[89] = 0.0970000000;
					g[90] = 4.5000000000; fxg[90] = 1.9014000000; feg[90] = 0.0950000000;
					g[91] = 4.5500000000; fxg[91] = 1.8706000000; feg[91] = 0.0931000000;
					g[92] = 4.6000000000; fxg[92] = 1.8396000000; feg[92] = 0.0912000000;
					g[93] = 4.6500000000; fxg[93] = 1.8091000000; feg[93] = 0.0894000000;
					g[94] = 4.7000000000; fxg[94] = 1.7795000000; feg[94] = 0.0876000000;
					g[95] = 4.7500000000; fxg[95] = 1.7513000000; feg[95] = 0.0859000000;
					g[96] = 4.8000000000; fxg[96] = 1.7252000000; feg[96] = 0.0842000000;
					g[97] = 4.8500000000; fxg[97] = 1.7020000000; feg[97] = 0.0826000000;
					g[98] = 4.9000000000; fxg[98] = 1.6812000000; feg[98] = 0.0810000000;
					g[99] = 4.9500000000; fxg[99] = 1.6613000000; feg[99] = 0.0795000000;
					g[100] = 5.0000000000; fxg[100] = 1.6408000000; feg[100] = 0.0780000000;
					g[101] = 5.0500000000; fxg[101] = 1.6195000000; feg[101] = 0.0765000000;
					g[102] = 5.1000000000; fxg[102] = 1.5981000000; feg[102] = 0.0751000000;
					g[103] = 5.1500000000; fxg[103] = 1.5772000000; feg[103] = 0.0737000000;
					g[104] = 5.2000000000; fxg[104] = 1.5570000000; feg[104] = 0.0724000000;
					g[105] = 5.2500000000; fxg[105] = 1.5375000000; feg[105] = 0.0711000000;
					g[106] = 5.3000000000; fxg[106] = 1.5194000000; feg[106] = 0.0698000000;
					g[107] = 5.3500000000; fxg[107] = 1.5038000000; feg[107] = 0.0686000000;
					g[108] = 5.4000000000; fxg[108] = 1.4905000000; feg[108] = 0.0673000000;
					g[109] = 5.4500000000; fxg[109] = 1.4782000000; feg[109] = 0.0661000000;
					g[110] = 5.5000000000; fxg[110] = 1.4653000000; feg[110] = 0.0650000000;
					g[111] = 5.5500000000; fxg[111] = 1.4510000000; feg[111] = 0.0639000000;
					g[112] = 5.6000000000; fxg[112] = 1.4360000000; feg[112] = 0.0628000000;
					g[113] = 5.6500000000; fxg[113] = 1.4214000000; feg[113] = 0.0617000000;
					g[114] = 5.7000000000; fxg[114] = 1.4073000000; feg[114] = 0.0607000000;
					g[115] = 5.7500000000; fxg[115] = 1.3934000000; feg[115] = 0.0597000000;
					g[116] = 5.8000000000; fxg[116] = 1.3797000000; feg[116] = 0.0587000000;
					g[117] = 5.8500000000; fxg[117] = 1.3667000000; feg[117] = 0.0577000000;
					g[118] = 5.9000000000; fxg[118] = 1.3556000000; feg[118] = 0.0568000000;
					g[119] = 5.9500000000; fxg[119] = 1.3468000000; feg[119] = 0.0558000000;
					g[120] = 6.0000000000; fxg[120] = 1.3395000000; feg[120] = 0.0549000000;
					g[121] = 6.0500000000; fxg[121] = 1.3318000000; feg[121] = 0.0541000000;
					g[122] = 6.1000000000; fxg[122] = 1.3225000000; feg[122] = 0.0532000000;
					g[123] = 6.1500000000; fxg[123] = 1.3117000000; feg[123] = 0.0524000000;
					g[124] = 6.2000000000; fxg[124] = 1.3006000000; feg[124] = 0.0516000000;
					g[125] = 6.2500000000; fxg[125] = 1.2902000000; feg[125] = 0.0508000000;
					g[126] = 6.3000000000; fxg[126] = 1.2804000000; feg[126] = 0.0500000000;
					g[127] = 6.3500000000; fxg[127] = 1.2706000000; feg[127] = 0.0492000000;
					g[128] = 6.4000000000; fxg[128] = 1.2603000000; feg[128] = 0.0485000000;
					g[129] = 6.4500000000; fxg[129] = 1.2500000000; feg[129] = 0.0477000000;
					g[130] = 6.5000000000; fxg[130] = 1.2410000000; feg[130] = 0.0470000000;
					g[131] = 6.5500000000; fxg[131] = 1.2341000000; feg[131] = 0.0463000000;
					g[132] = 6.6000000000; fxg[132] = 1.2292000000; feg[132] = 0.0456000000;
					g[133] = 6.6500000000; fxg[133] = 1.2249000000; feg[133] = 0.0450000000;
					g[134] = 6.7000000000; fxg[134] = 1.2194000000; feg[134] = 0.0443000000;
					g[135] = 6.7500000000; fxg[135] = 1.2118000000; feg[135] = 0.0437000000;
					g[136] = 6.8000000000; fxg[136] = 1.2028000000; feg[136] = 0.0431000000;
					g[137] = 6.8500000000; fxg[137] = 1.1936000000; feg[137] = 0.0425000000;
					g[138] = 6.9000000000; fxg[138] = 1.1854000000; feg[138] = 0.0419000000;
					g[139] = 6.9500000000; fxg[139] = 1.1781000000; feg[139] = 0.0413000000;
					g[140] = 7.0000000000; fxg[140] = 1.1708000000; feg[140] = 0.0407000000;
					g[141] = 7.0500000000; fxg[141] = 1.1627000000; feg[141] = 0.0401000000;
					g[142] = 7.1000000000; fxg[142] = 1.1539000000; feg[142] = 0.0396000000;
					g[143] = 7.1500000000; fxg[143] = 1.1454000000; feg[143] = 0.0391000000;
					g[144] = 7.2000000000; fxg[144] = 1.1382000000; feg[144] = 0.0385000000;
					g[145] = 7.2500000000; fxg[145] = 1.1333000000; feg[145] = 0.0380000000;
					g[146] = 7.3000000000; fxg[146] = 1.1302000000; feg[146] = 0.0375000000;
					g[147] = 7.3500000000; fxg[147] = 1.1274000000; feg[147] = 0.0370000000;
					g[148] = 7.4000000000; fxg[148] = 1.1233000000; feg[148] = 0.0365000000;
					g[149] = 7.4500000000; fxg[149] = 1.1170000000; feg[149] = 0.0360000000;
					g[150] = 7.5000000000; fxg[150] = 1.1088000000; feg[150] = 0.0356000000;
					g[151] = 7.5500000000; fxg[151] = 1.1002000000; feg[151] = 0.0351000000;
					g[152] = 7.6000000000; fxg[152] = 1.0925000000; feg[152] = 0.0347000000;
					g[153] = 7.6500000000; fxg[153] = 1.0861000000; feg[153] = 0.0342000000;
					g[154] = 7.7000000000; fxg[154] = 1.0803000000; feg[154] = 0.0338000000;
					g[155] = 7.7500000000; fxg[155] = 1.0740000000; feg[155] = 0.0334000000;
					g[156] = 7.8000000000; fxg[156] = 1.0666000000; feg[156] = 0.0329000000;
					g[157] = 7.8500000000; fxg[157] = 1.0585000000; feg[157] = 0.0325000000;
					g[158] = 7.9000000000; fxg[158] = 1.0505000000; feg[158] = 0.0321000000;
					g[159] = 7.9500000000; fxg[159] = 1.0437000000; feg[159] = 0.0317000000;
					g[160] = 8.0000000000; fxg[160] = 1.0389000000; feg[160] = 0.0314000000;
					g[161] = 8.0500000000; fxg[161] = 1.0362000000; feg[161] = 0.0310000000;
					g[162] = 8.1000000000; fxg[162] = 1.0344000000; feg[162] = 0.0306000000;
					g[163] = 8.1500000000; fxg[163] = 1.0319000000; feg[163] = 0.0302000000;
					g[164] = 8.2000000000; fxg[164] = 1.0273000000; feg[164] = 0.0299000000;
					g[165] = 8.2500000000; fxg[165] = 1.0205000000; feg[165] = 0.0295000000;
					g[166] = 8.3000000000; fxg[166] = 1.0122000000; feg[166] = 0.0292000000;
					g[167] = 8.3500000000; fxg[167] = 1.0038000000; feg[167] = 0.0288000000;
					g[168] = 8.4000000000; fxg[168] = 0.9966000000; feg[168] = 0.0285000000;
					g[169] = 8.4500000000; fxg[169] = 0.9908000000; feg[169] = 0.0282000000;
					g[170] = 8.5000000000; fxg[170] = 0.9856000000; feg[170] = 0.0278000000;
					g[171] = 8.5500000000; fxg[171] = 0.9801000000; feg[171] = 0.0275000000;
					g[172] = 8.6000000000; fxg[172] = 0.9735000000; feg[172] = 0.0272000000;
					g[173] = 8.6500000000; fxg[173] = 0.9660000000; feg[173] = 0.0269000000;
					g[174] = 8.7000000000; fxg[174] = 0.9581000000; feg[174] = 0.0266000000;
					g[175] = 8.7500000000; fxg[175] = 0.9506000000; feg[175] = 0.0263000000;
					g[176] = 8.8000000000; fxg[176] = 0.9446000000; feg[176] = 0.0260000000;
					g[177] = 8.8500000000; fxg[177] = 0.9406000000; feg[177] = 0.0257000000;
					g[178] = 8.9000000000; fxg[178] = 0.9385000000; feg[178] = 0.0255000000;
					g[179] = 8.9500000000; fxg[179] = 0.9373000000; feg[179] = 0.0252000000;
					g[180] = 9.0000000000; fxg[180] = 0.9354000000; feg[180] = 0.0249000000;
					g[181] = 9.0500000000; fxg[181] = 0.9317000000; feg[181] = 0.0246000000;
					g[182] = 9.1000000000; fxg[182] = 0.9257000000; feg[182] = 0.0244000000;
					g[183] = 9.1500000000; fxg[183] = 0.9179000000; feg[183] = 0.0241000000;
					g[184] = 9.2000000000; fxg[184] = 0.9094000000; feg[184] = 0.0239000000;
					g[185] = 9.2500000000; fxg[185] = 0.9015000000; feg[185] = 0.0236000000;
					g[186] = 9.3000000000; fxg[186] = 0.8950000000; feg[186] = 0.0234000000;
					g[187] = 9.3500000000; fxg[187] = 0.8898000000; feg[187] = 0.0231000000;
					g[188] = 9.4000000000; fxg[188] = 0.8850000000; feg[188] = 0.0229000000;
					g[189] = 9.4500000000; fxg[189] = 0.8796000000; feg[189] = 0.0226000000;
					g[190] = 9.5000000000; fxg[190] = 0.8731000000; feg[190] = 0.0224000000;
					g[191] = 9.5500000000; fxg[191] = 0.8659000000; feg[191] = 0.0222000000;
					g[192] = 9.6000000000; fxg[192] = 0.8583000000; feg[192] = 0.0220000000;
					g[193] = 9.6500000000; fxg[193] = 0.8509000000; feg[193] = 0.0217000000;
					g[194] = 9.7000000000; fxg[194] = 0.8444000000; feg[194] = 0.0215000000;
					g[195] = 9.7500000000; fxg[195] = 0.8396000000; feg[195] = 0.0213000000;
					g[196] = 9.8000000000; fxg[196] = 0.8369000000; feg[196] = 0.0211000000;
					g[197] = 9.8500000000; fxg[197] = 0.8358000000; feg[197] = 0.0209000000;
					g[198] = 9.9000000000; fxg[198] = 0.8351000000; feg[198] = 0.0207000000;
					g[199] = 9.9500000000; fxg[199] = 0.8336000000; feg[199] = 0.0205000000;
					g[200] = 10.0000000000; fxg[200] = 0.8303000000; feg[200] = 0.0203000000;
					g[201] = 10.0500000000; fxg[201] = 0.8249000000; feg[201] = 0.0201000000;
					g[202] = 10.1000000000; fxg[202] = 0.8178000000; feg[202] = 0.0199000000;
					g[203] = 10.1500000000; fxg[203] = 0.8096000000; feg[203] = 0.0197000000;
					g[204] = 10.2000000000; fxg[204] = 0.8015000000; feg[204] = 0.0195000000;
					g[205] = 10.2500000000; fxg[205] = 0.7944000000; feg[205] = 0.0193000000;
					g[206] = 10.3000000000; fxg[206] = 0.7888000000; feg[206] = 0.0191000000;
					g[207] = 10.3500000000; fxg[207] = 0.7841000000; feg[207] = 0.0190000000;
					g[208] = 10.4000000000; fxg[208] = 0.7794000000; feg[208] = 0.0188000000;
					g[209] = 10.4500000000; fxg[209] = 0.7738000000; feg[209] = 0.0186000000;
					g[210] = 10.5000000000; fxg[210] = 0.7673000000; feg[210] = 0.0184000000;
					g[211] = 10.5500000000; fxg[211] = 0.7602000000; feg[211] = 0.0183000000;
					g[212] = 10.6000000000; fxg[212] = 0.7531000000; feg[212] = 0.0181000000;
					g[213] = 10.6500000000; fxg[213] = 0.7461000000; feg[213] = 0.0179000000;
					g[214] = 10.7000000000; fxg[214] = 0.7398000000; feg[214] = 0.0178000000;
					g[215] = 10.7500000000; fxg[215] = 0.7346000000; feg[215] = 0.0176000000;
					g[216] = 10.8000000000; fxg[216] = 0.7312000000; feg[216] = 0.0175000000;
					g[217] = 10.8500000000; fxg[217] = 0.7298000000; feg[217] = 0.0173000000;
					g[218] = 10.9000000000; fxg[218] = 0.7297000000; feg[218] = 0.0171000000;
					g[219] = 10.9500000000; fxg[219] = 0.7297000000; feg[219] = 0.0170000000;
					g[220] = 11.0000000000; fxg[220] = 0.7286000000; feg[220] = 0.0168000000;
					g[221] = 11.0500000000; fxg[221] = 0.7258000000; feg[221] = 0.0167000000;
					g[222] = 11.1000000000; fxg[222] = 0.7213000000; feg[222] = 0.0165000000;
					g[223] = 11.1500000000; fxg[223] = 0.7152000000; feg[223] = 0.0164000000;
					g[224] = 11.2000000000; fxg[224] = 0.7078000000; feg[224] = 0.0163000000;
					g[225] = 11.2500000000; fxg[225] = 0.6999000000; feg[225] = 0.0161000000;
					g[226] = 11.3000000000; fxg[226] = 0.6925000000; feg[226] = 0.0160000000;
					g[227] = 11.3500000000; fxg[227] = 0.6864000000; feg[227] = 0.0158000000;
					g[228] = 11.4000000000; fxg[228] = 0.6815000000; feg[228] = 0.0157000000;
					g[229] = 11.4500000000; fxg[229] = 0.6771000000; feg[229] = 0.0156000000;
					g[230] = 11.5000000000; fxg[230] = 0.6723000000; feg[230] = 0.0154000000;
					g[231] = 11.5500000000; fxg[231] = 0.6666000000; feg[231] = 0.0153000000;
					g[232] = 11.6000000000; fxg[232] = 0.6600000000; feg[232] = 0.0152000000;
					g[233] = 11.6500000000; fxg[233] = 0.6533000000; feg[233] = 0.0151000000;
					g[234] = 11.7000000000; fxg[234] = 0.6467000000; feg[234] = 0.0149000000;
					g[235] = 11.7500000000; fxg[235] = 0.6404000000; feg[235] = 0.0148000000;
					g[236] = 11.8000000000; fxg[236] = 0.6344000000; feg[236] = 0.0147000000;
					g[237] = 11.8500000000; fxg[237] = 0.6291000000; feg[237] = 0.0146000000;
					g[238] = 11.9000000000; fxg[238] = 0.6252000000; feg[238] = 0.0145000000;
					g[239] = 11.9500000000; fxg[239] = 0.6231000000; feg[239] = 0.0143000000;
					g[240] = 12.0000000000; fxg[240] = 0.6228000000; feg[240] = 0.0142000000;
					break;
				case 23:
					g[0] = 0.0000000000; fxg[0] = 23.0000000000; feg[0] = 8.3080000000;
					g[1] = 0.0500000000; fxg[1] = 22.7881000000; feg[1] = 8.1158000000;
					g[2] = 0.1000000000; fxg[2] = 22.2070000000; feg[2] = 7.5915000000;
					g[3] = 0.1500000000; fxg[3] = 21.3872000000; feg[3] = 6.8621000000;
					g[4] = 0.2000000000; fxg[4] = 20.4653000000; feg[4] = 6.0665000000;
					g[5] = 0.2500000000; fxg[5] = 19.5351000000; feg[5] = 5.3074000000;
					g[6] = 0.3000000000; fxg[6] = 18.6400000000; feg[6] = 4.6379000000;
					g[7] = 0.3500000000; fxg[7] = 17.7890000000; feg[7] = 4.0724000000;
					g[8] = 0.4000000000; fxg[8] = 16.9769000000; feg[8] = 3.6039000000;
					g[9] = 0.4500000000; fxg[9] = 16.1958000000; feg[9] = 3.2168000000;
					g[10] = 0.5000000000; fxg[10] = 15.4408000000; feg[10] = 2.8947000000;
					g[11] = 0.5500000000; fxg[11] = 14.7109000000; feg[11] = 2.6233000000;
					g[12] = 0.6000000000; fxg[12] = 14.0076000000; feg[12] = 2.3914000000;
					g[13] = 0.6500000000; fxg[13] = 13.3340000000; feg[13] = 2.1902000000;
					g[14] = 0.7000000000; fxg[14] = 12.6936000000; feg[14] = 2.0136000000;
					g[15] = 0.7500000000; fxg[15] = 12.0894000000; feg[15] = 1.8569000000;
					g[16] = 0.8000000000; fxg[16] = 11.5237000000; feg[16] = 1.7167000000;
					g[17] = 0.8500000000; fxg[17] = 10.9978000000; feg[17] = 1.5903000000;
					g[18] = 0.9000000000; fxg[18] = 10.5123000000; feg[18] = 1.4759000000;
					g[19] = 0.9500000000; fxg[19] = 10.0665000000; feg[19] = 1.3719000000;
					g[20] = 1.0000000000; fxg[20] = 9.6593000000; feg[20] = 1.2772000000;
					g[21] = 1.0500000000; fxg[21] = 9.2888000000; feg[21] = 1.1906000000;
					g[22] = 1.1000000000; fxg[22] = 8.9528000000; feg[22] = 1.1114000000;
					g[23] = 1.1500000000; fxg[23] = 8.6486000000; feg[23] = 1.0389000000;
					g[24] = 1.2000000000; fxg[24] = 8.3734000000; feg[24] = 0.9724000000;
					g[25] = 1.2500000000; fxg[25] = 8.1245000000; feg[25] = 0.9114000000;
					g[26] = 1.3000000000; fxg[26] = 7.8989000000; feg[26] = 0.8554000000;
					g[27] = 1.3500000000; fxg[27] = 7.6940000000; feg[27] = 0.8040000000;
					g[28] = 1.4000000000; fxg[28] = 7.5070000000; feg[28] = 0.7567000000;
					g[29] = 1.4500000000; fxg[29] = 7.3356000000; feg[29] = 0.7133000000;
					g[30] = 1.5000000000; fxg[30] = 7.1775000000; feg[30] = 0.6732000000;
					g[31] = 1.5500000000; fxg[31] = 7.0306000000; feg[31] = 0.6363000000;
					g[32] = 1.6000000000; fxg[32] = 6.8930000000; feg[32] = 0.6023000000;
					g[33] = 1.6500000000; fxg[33] = 6.7632000000; feg[33] = 0.5710000000;
					g[34] = 1.7000000000; fxg[34] = 6.6396000000; feg[34] = 0.5420000000;
					g[35] = 1.7500000000; fxg[35] = 6.5211000000; feg[35] = 0.5151000000;
					g[36] = 1.8000000000; fxg[36] = 6.4066000000; feg[36] = 0.4903000000;
					g[37] = 1.8500000000; fxg[37] = 6.2951000000; feg[37] = 0.4673000000;
					g[38] = 1.9000000000; fxg[38] = 6.1860000000; feg[38] = 0.4459000000;
					g[39] = 1.9500000000; fxg[39] = 6.0786000000; feg[39] = 0.4260000000;
					g[40] = 2.0000000000; fxg[40] = 5.9726000000; feg[40] = 0.4075000000;
					g[41] = 2.0500000000; fxg[41] = 5.8674000000; feg[41] = 0.3903000000;
					g[42] = 2.1000000000; fxg[42] = 5.7626000000; feg[42] = 0.3742000000;
					g[43] = 2.1500000000; fxg[43] = 5.6583000000; feg[43] = 0.3592000000;
					g[44] = 2.2000000000; fxg[44] = 5.5545000000; feg[44] = 0.3451000000;
					g[45] = 2.2500000000; fxg[45] = 5.4508000000; feg[45] = 0.3319000000;
					g[46] = 2.3000000000; fxg[46] = 5.3470000000; feg[46] = 0.3195000000;
					g[47] = 2.3500000000; fxg[47] = 5.2433000000; feg[47] = 0.3078000000;
					g[48] = 2.4000000000; fxg[48] = 5.1402000000; feg[48] = 0.2968000000;
					g[49] = 2.4500000000; fxg[49] = 5.0376000000; feg[49] = 0.2865000000;
					g[50] = 2.5000000000; fxg[50] = 4.9352000000; feg[50] = 0.2767000000;
					g[51] = 2.5500000000; fxg[51] = 4.8328000000; feg[51] = 0.2675000000;
					g[52] = 2.6000000000; fxg[52] = 4.7310000000; feg[52] = 0.2587000000;
					g[53] = 2.6500000000; fxg[53] = 4.6304000000; feg[53] = 0.2504000000;
					g[54] = 2.7000000000; fxg[54] = 4.5312000000; feg[54] = 0.2425000000;
					g[55] = 2.7500000000; fxg[55] = 4.4327000000; feg[55] = 0.2350000000;
					g[56] = 2.8000000000; fxg[56] = 4.3345000000; feg[56] = 0.2279000000;
					g[57] = 2.8500000000; fxg[57] = 4.2373000000; feg[57] = 0.2211000000;
					g[58] = 2.9000000000; fxg[58] = 4.1418000000; feg[58] = 0.2147000000;
					g[59] = 2.9500000000; fxg[59] = 4.0486000000; feg[59] = 0.2085000000;
					g[60] = 3.0000000000; fxg[60] = 3.9572000000; feg[60] = 0.2026000000;
					g[61] = 3.0500000000; fxg[61] = 3.8669000000; feg[61] = 0.1969000000;
					g[62] = 3.1000000000; fxg[62] = 3.7773000000; feg[62] = 0.1915000000;
					g[63] = 3.1500000000; fxg[63] = 3.6890000000; feg[63] = 0.1863000000;
					g[64] = 3.2000000000; fxg[64] = 3.6031000000; feg[64] = 0.1813000000;
					g[65] = 3.2500000000; fxg[65] = 3.5202000000; feg[65] = 0.1766000000;
					g[66] = 3.3000000000; fxg[66] = 3.4399000000; feg[66] = 0.1720000000;
					g[67] = 3.3500000000; fxg[67] = 3.3611000000; feg[67] = 0.1675000000;
					g[68] = 3.4000000000; fxg[68] = 3.2832000000; feg[68] = 0.1633000000;
					g[69] = 3.4500000000; fxg[69] = 3.2063000000; feg[69] = 0.1592000000;
					g[70] = 3.5000000000; fxg[70] = 3.1314000000; feg[70] = 0.1553000000;
					g[71] = 3.5500000000; fxg[71] = 3.0594000000; feg[71] = 0.1515000000;
					g[72] = 3.6000000000; fxg[72] = 2.9908000000; feg[72] = 0.1478000000;
					g[73] = 3.6500000000; fxg[73] = 2.9249000000; feg[73] = 0.1443000000;
					g[74] = 3.7000000000; fxg[74] = 2.8605000000; feg[74] = 0.1408000000;
					g[75] = 3.7500000000; fxg[75] = 2.7968000000; feg[75] = 0.1375000000;
					g[76] = 3.8000000000; fxg[76] = 2.7339000000; feg[76] = 0.1344000000;
					g[77] = 3.8500000000; fxg[77] = 2.6726000000; feg[77] = 0.1313000000;
					g[78] = 3.9000000000; fxg[78] = 2.6139000000; feg[78] = 0.1283000000;
					g[79] = 3.9500000000; fxg[79] = 2.5584000000; feg[79] = 0.1254000000;
					g[80] = 4.0000000000; fxg[80] = 2.5062000000; feg[80] = 0.1226000000;
					g[81] = 4.0500000000; fxg[81] = 2.4561000000; feg[81] = 0.1199000000;
					g[82] = 4.1000000000; fxg[82] = 2.4068000000; feg[82] = 0.1173000000;
					g[83] = 4.1500000000; fxg[83] = 2.3578000000; feg[83] = 0.1147000000;
					g[84] = 4.2000000000; fxg[84] = 2.3094000000; feg[84] = 0.1123000000;
					g[85] = 4.2500000000; fxg[85] = 2.2623000000; feg[85] = 0.1099000000;
					g[86] = 4.3000000000; fxg[86] = 2.2174000000; feg[86] = 0.1076000000;
					g[87] = 4.3500000000; fxg[87] = 2.1753000000; feg[87] = 0.1054000000;
					g[88] = 4.4000000000; fxg[88] = 2.1363000000; feg[88] = 0.1032000000;
					g[89] = 4.4500000000; fxg[89] = 2.0997000000; feg[89] = 0.1010000000;
					g[90] = 4.5000000000; fxg[90] = 2.0641000000; feg[90] = 0.0990000000;
					g[91] = 4.5500000000; fxg[91] = 2.0284000000; feg[91] = 0.0970000000;
					g[92] = 4.6000000000; fxg[92] = 1.9927000000; feg[92] = 0.0950000000;
					g[93] = 4.6500000000; fxg[93] = 1.9575000000; feg[93] = 0.0932000000;
					g[94] = 4.7000000000; fxg[94] = 1.9234000000; feg[94] = 0.0913000000;
					g[95] = 4.7500000000; fxg[95] = 1.8909000000; feg[95] = 0.0896000000;
					g[96] = 4.8000000000; fxg[96] = 1.8606000000; feg[96] = 0.0878000000;
					g[97] = 4.8500000000; fxg[97] = 1.8332000000; feg[97] = 0.0861000000;
					g[98] = 4.9000000000; fxg[98] = 1.8081000000; feg[98] = 0.0845000000;
					g[99] = 4.9500000000; fxg[99] = 1.7840000000; feg[99] = 0.0829000000;
					g[100] = 5.0000000000; fxg[100] = 1.7597000000; feg[100] = 0.0813000000;
					g[101] = 5.0500000000; fxg[101] = 1.7347000000; feg[101] = 0.0798000000;
					g[102] = 5.1000000000; fxg[102] = 1.7098000000; feg[102] = 0.0784000000;
					g[103] = 5.1500000000; fxg[103] = 1.6854000000; feg[103] = 0.0769000000;
					g[104] = 5.2000000000; fxg[104] = 1.6617000000; feg[104] = 0.0755000000;
					g[105] = 5.2500000000; fxg[105] = 1.6390000000; feg[105] = 0.0742000000;
					g[106] = 5.3000000000; fxg[106] = 1.6180000000; feg[106] = 0.0729000000;
					g[107] = 5.3500000000; fxg[107] = 1.5994000000; feg[107] = 0.0716000000;
					g[108] = 5.4000000000; fxg[108] = 1.5831000000; feg[108] = 0.0703000000;
					g[109] = 5.4500000000; fxg[109] = 1.5678000000; feg[109] = 0.0691000000;
					g[110] = 5.5000000000; fxg[110] = 1.5522000000; feg[110] = 0.0679000000;
					g[111] = 5.5500000000; fxg[111] = 1.5355000000; feg[111] = 0.0667000000;
					g[112] = 5.6000000000; fxg[112] = 1.5182000000; feg[112] = 0.0656000000;
					g[113] = 5.6500000000; fxg[113] = 1.5011000000; feg[113] = 0.0645000000;
					g[114] = 5.7000000000; fxg[114] = 1.4846000000; feg[114] = 0.0634000000;
					g[115] = 5.7500000000; fxg[115] = 1.4685000000; feg[115] = 0.0623000000;
					g[116] = 5.8000000000; fxg[116] = 1.4527000000; feg[116] = 0.0613000000;
					g[117] = 5.8500000000; fxg[117] = 1.4379000000; feg[117] = 0.0603000000;
					g[118] = 5.9000000000; fxg[118] = 1.4251000000; feg[118] = 0.0593000000;
					g[119] = 5.9500000000; fxg[119] = 1.4145000000; feg[119] = 0.0584000000;
					g[120] = 6.0000000000; fxg[120] = 1.4053000000; feg[120] = 0.0574000000;
					g[121] = 6.0500000000; fxg[121] = 1.3959000000; feg[121] = 0.0565000000;
					g[122] = 6.1000000000; fxg[122] = 1.3852000000; feg[122] = 0.0556000000;
					g[123] = 6.1500000000; fxg[123] = 1.3732000000; feg[123] = 0.0547000000;
					g[124] = 6.2000000000; fxg[124] = 1.3609000000; feg[124] = 0.0539000000;
					g[125] = 6.2500000000; fxg[125] = 1.3490000000; feg[125] = 0.0531000000;
					g[126] = 6.3000000000; fxg[126] = 1.3377000000; feg[126] = 0.0523000000;
					g[127] = 6.3500000000; fxg[127] = 1.3265000000; feg[127] = 0.0515000000;
					g[128] = 6.4000000000; fxg[128] = 1.3151000000; feg[128] = 0.0507000000;
					g[129] = 6.4500000000; fxg[129] = 1.3040000000; feg[129] = 0.0499000000;
					g[130] = 6.5000000000; fxg[130] = 1.2942000000; feg[130] = 0.0492000000;
					g[131] = 6.5500000000; fxg[131] = 1.2865000000; feg[131] = 0.0485000000;
					g[132] = 6.6000000000; fxg[132] = 1.2806000000; feg[132] = 0.0477000000;
					g[133] = 6.6500000000; fxg[133] = 1.2754000000; feg[133] = 0.0470000000;
					g[134] = 6.7000000000; fxg[134] = 1.2692000000; feg[134] = 0.0463000000;
					g[135] = 6.7500000000; fxg[135] = 1.2611000000; feg[135] = 0.0457000000;
					g[136] = 6.8000000000; fxg[136] = 1.2517000000; feg[136] = 0.0450000000;
					g[137] = 6.8500000000; fxg[137] = 1.2421000000; feg[137] = 0.0444000000;
					g[138] = 6.9000000000; fxg[138] = 1.2332000000; feg[138] = 0.0438000000;
					g[139] = 6.9500000000; fxg[139] = 1.2251000000; feg[139] = 0.0432000000;
					g[140] = 7.0000000000; fxg[140] = 1.2170000000; feg[140] = 0.0426000000;
					g[141] = 7.0500000000; fxg[141] = 1.2083000000; feg[141] = 0.0420000000;
					g[142] = 7.1000000000; fxg[142] = 1.1993000000; feg[142] = 0.0414000000;
					g[143] = 7.1500000000; fxg[143] = 1.1905000000; feg[143] = 0.0408000000;
					g[144] = 7.2000000000; fxg[144] = 1.1833000000; feg[144] = 0.0403000000;
					g[145] = 7.2500000000; fxg[145] = 1.1781000000; feg[145] = 0.0397000000;
					g[146] = 7.3000000000; fxg[146] = 1.1746000000; feg[146] = 0.0392000000;
					g[147] = 7.3500000000; fxg[147] = 1.1715000000; feg[147] = 0.0387000000;
					g[148] = 7.4000000000; fxg[148] = 1.1672000000; feg[148] = 0.0382000000;
					g[149] = 7.4500000000; fxg[149] = 1.1608000000; feg[149] = 0.0377000000;
					g[150] = 7.5000000000; fxg[150] = 1.1528000000; feg[150] = 0.0372000000;
					g[151] = 7.5500000000; fxg[151] = 1.1443000000; feg[151] = 0.0367000000;
					g[152] = 7.6000000000; fxg[152] = 1.1365000000; feg[152] = 0.0362000000;
					g[153] = 7.6500000000; fxg[153] = 1.1297000000; feg[153] = 0.0358000000;
					g[154] = 7.7000000000; fxg[154] = 1.1235000000; feg[154] = 0.0353000000;
					g[155] = 7.7500000000; fxg[155] = 1.1169000000; feg[155] = 0.0349000000;
					g[156] = 7.8000000000; fxg[156] = 1.1095000000; feg[156] = 0.0344000000;
					g[157] = 7.8500000000; fxg[157] = 1.1014000000; feg[157] = 0.0340000000;
					g[158] = 7.9000000000; fxg[158] = 1.0936000000; feg[158] = 0.0336000000;
					g[159] = 7.9500000000; fxg[159] = 1.0870000000; feg[159] = 0.0332000000;
					g[160] = 8.0000000000; fxg[160] = 1.0823000000; feg[160] = 0.0328000000;
					g[161] = 8.0500000000; fxg[161] = 1.0795000000; feg[161] = 0.0324000000;
					g[162] = 8.1000000000; fxg[162] = 1.0776000000; feg[162] = 0.0320000000;
					g[163] = 8.1500000000; fxg[163] = 1.0750000000; feg[163] = 0.0316000000;
					g[164] = 8.2000000000; fxg[164] = 1.0706000000; feg[164] = 0.0312000000;
					g[165] = 8.2500000000; fxg[165] = 1.0641000000; feg[165] = 0.0309000000;
					g[166] = 8.3000000000; fxg[166] = 1.0562000000; feg[166] = 0.0305000000;
					g[167] = 8.3500000000; fxg[167] = 1.0481000000; feg[167] = 0.0301000000;
					g[168] = 8.4000000000; fxg[168] = 1.0409000000; feg[168] = 0.0298000000;
					g[169] = 8.4500000000; fxg[169] = 1.0350000000; feg[169] = 0.0295000000;
					g[170] = 8.5000000000; fxg[170] = 1.0297000000; feg[170] = 0.0291000000;
					g[171] = 8.5500000000; fxg[171] = 1.0241000000; feg[171] = 0.0288000000;
					g[172] = 8.6000000000; fxg[172] = 1.0175000000; feg[172] = 0.0285000000;
					g[173] = 8.6500000000; fxg[173] = 1.0102000000; feg[173] = 0.0281000000;
					g[174] = 8.7000000000; fxg[174] = 1.0025000000; feg[174] = 0.0278000000;
					g[175] = 8.7500000000; fxg[175] = 0.9953000000; feg[175] = 0.0275000000;
					g[176] = 8.8000000000; fxg[176] = 0.9895000000; feg[176] = 0.0272000000;
					g[177] = 8.8500000000; fxg[177] = 0.9857000000; feg[177] = 0.0269000000;
					g[178] = 8.9000000000; fxg[178] = 0.9837000000; feg[178] = 0.0266000000;
					g[179] = 8.9500000000; fxg[179] = 0.9825000000; feg[179] = 0.0263000000;
					g[180] = 9.0000000000; fxg[180] = 0.9806000000; feg[180] = 0.0260000000;
					g[181] = 9.0500000000; fxg[181] = 0.9770000000; feg[181] = 0.0257000000;
					g[182] = 9.1000000000; fxg[182] = 0.9713000000; feg[182] = 0.0255000000;
					g[183] = 9.1500000000; fxg[183] = 0.9638000000; feg[183] = 0.0252000000;
					g[184] = 9.2000000000; fxg[184] = 0.9557000000; feg[184] = 0.0249000000;
					g[185] = 9.2500000000; fxg[185] = 0.9480000000; feg[185] = 0.0247000000;
					g[186] = 9.3000000000; fxg[186] = 0.9416000000; feg[186] = 0.0244000000;
					g[187] = 9.3500000000; fxg[187] = 0.9364000000; feg[187] = 0.0242000000;
					g[188] = 9.4000000000; fxg[188] = 0.9316000000; feg[188] = 0.0239000000;
					g[189] = 9.4500000000; fxg[189] = 0.9262000000; feg[189] = 0.0237000000;
					g[190] = 9.5000000000; fxg[190] = 0.9199000000; feg[190] = 0.0234000000;
					g[191] = 9.5500000000; fxg[191] = 0.9128000000; feg[191] = 0.0232000000;
					g[192] = 9.6000000000; fxg[192] = 0.9054000000; feg[192] = 0.0230000000;
					g[193] = 9.6500000000; fxg[193] = 0.8982000000; feg[193] = 0.0227000000;
					g[194] = 9.7000000000; fxg[194] = 0.8919000000; feg[194] = 0.0225000000;
					g[195] = 9.7500000000; fxg[195] = 0.8873000000; feg[195] = 0.0223000000;
					g[196] = 9.8000000000; fxg[196] = 0.8846000000; feg[196] = 0.0220000000;
					g[197] = 9.8500000000; fxg[197] = 0.8835000000; feg[197] = 0.0218000000;
					g[198] = 9.9000000000; fxg[198] = 0.8829000000; feg[198] = 0.0216000000;
					g[199] = 9.9500000000; fxg[199] = 0.8813000000; feg[199] = 0.0214000000;
					g[200] = 10.0000000000; fxg[200] = 0.8781000000; feg[200] = 0.0212000000;
					g[201] = 10.0500000000; fxg[201] = 0.8729000000; feg[201] = 0.0210000000;
					g[202] = 10.1000000000; fxg[202] = 0.8659000000; feg[202] = 0.0208000000;
					g[203] = 10.1500000000; fxg[203] = 0.8579000000; feg[203] = 0.0206000000;
					g[204] = 10.2000000000; fxg[204] = 0.8500000000; feg[204] = 0.0204000000;
					g[205] = 10.2500000000; fxg[205] = 0.8431000000; feg[205] = 0.0202000000;
					g[206] = 10.3000000000; fxg[206] = 0.8375000000; feg[206] = 0.0200000000;
					g[207] = 10.3500000000; fxg[207] = 0.8329000000; feg[207] = 0.0198000000;
					g[208] = 10.4000000000; fxg[208] = 0.8281000000; feg[208] = 0.0196000000;
					g[209] = 10.4500000000; fxg[209] = 0.8227000000; feg[209] = 0.0194000000;
					g[210] = 10.5000000000; fxg[210] = 0.8163000000; feg[210] = 0.0193000000;
					g[211] = 10.5500000000; fxg[211] = 0.8094000000; feg[211] = 0.0191000000;
					g[212] = 10.6000000000; fxg[212] = 0.8023000000; feg[212] = 0.0189000000;
					g[213] = 10.6500000000; fxg[213] = 0.7954000000; feg[213] = 0.0187000000;
					g[214] = 10.7000000000; fxg[214] = 0.7891000000; feg[214] = 0.0186000000;
					g[215] = 10.7500000000; fxg[215] = 0.7840000000; feg[215] = 0.0184000000;
					g[216] = 10.8000000000; fxg[216] = 0.7808000000; feg[216] = 0.0182000000;
					g[217] = 10.8500000000; fxg[217] = 0.7794000000; feg[217] = 0.0181000000;
					g[218] = 10.9000000000; fxg[218] = 0.7792000000; feg[218] = 0.0179000000;
					g[219] = 10.9500000000; fxg[219] = 0.7790000000; feg[219] = 0.0177000000;
					g[220] = 11.0000000000; fxg[220] = 0.7779000000; feg[220] = 0.0176000000;
					g[221] = 11.0500000000; fxg[221] = 0.7751000000; feg[221] = 0.0174000000;
					g[222] = 11.1000000000; fxg[222] = 0.7706000000; feg[222] = 0.0173000000;
					g[223] = 11.1500000000; fxg[223] = 0.7644000000; feg[223] = 0.0171000000;
					g[224] = 11.2000000000; fxg[224] = 0.7570000000; feg[224] = 0.0170000000;
					g[225] = 11.2500000000; fxg[225] = 0.7491000000; feg[225] = 0.0168000000;
					g[226] = 11.3000000000; fxg[226] = 0.7419000000; feg[226] = 0.0167000000;
					g[227] = 11.3500000000; fxg[227] = 0.7358000000; feg[227] = 0.0165000000;
					g[228] = 11.4000000000; fxg[228] = 0.7309000000; feg[228] = 0.0164000000;
					g[229] = 11.4500000000; fxg[229] = 0.7265000000; feg[229] = 0.0163000000;
					g[230] = 11.5000000000; fxg[230] = 0.7218000000; feg[230] = 0.0161000000;
					g[231] = 11.5500000000; fxg[231] = 0.7162000000; feg[231] = 0.0160000000;
					g[232] = 11.6000000000; fxg[232] = 0.7099000000; feg[232] = 0.0159000000;
					g[233] = 11.6500000000; fxg[233] = 0.7032000000; feg[233] = 0.0157000000;
					g[234] = 11.7000000000; fxg[234] = 0.6965000000; feg[234] = 0.0156000000;
					g[235] = 11.7500000000; fxg[235] = 0.6901000000; feg[235] = 0.0155000000;
					g[236] = 11.8000000000; fxg[236] = 0.6840000000; feg[236] = 0.0153000000;
					g[237] = 11.8500000000; fxg[237] = 0.6788000000; feg[237] = 0.0152000000;
					g[238] = 11.9000000000; fxg[238] = 0.6748000000; feg[238] = 0.0151000000;
					g[239] = 11.9500000000; fxg[239] = 0.6727000000; feg[239] = 0.0150000000;
					g[240] = 12.0000000000; fxg[240] = 0.6723000000; feg[240] = 0.0148000000;
					break;
				case 24:
					g[0] = 0.0000000000; fxg[0] = 24.0000000000; feg[0] = 7.4029000000;
					g[1] = 0.0500000000; fxg[1] = 23.8113000000; feg[1] = 7.2268000000;
					g[2] = 0.1000000000; fxg[2] = 23.2944000000; feg[2] = 6.7553000000;
					g[3] = 0.1500000000; fxg[3] = 22.5616000000; feg[3] = 6.1201000000;
					g[4] = 0.2000000000; fxg[4] = 21.7222000000; feg[4] = 5.4516000000;
					g[5] = 0.2500000000; fxg[5] = 20.8452000000; feg[5] = 4.8324000000;
					g[6] = 0.3000000000; fxg[6] = 19.9621000000; feg[6] = 4.2952000000;
					g[7] = 0.3500000000; fxg[7] = 19.0844000000; feg[7] = 3.8416000000;
					g[8] = 0.4000000000; fxg[8] = 18.2169000000; feg[8] = 3.4603000000;
					g[9] = 0.4500000000; fxg[9] = 17.3638000000; feg[9] = 3.1373000000;
					g[10] = 0.5000000000; fxg[10] = 16.5304000000; feg[10] = 2.8604000000;
					g[11] = 0.5500000000; fxg[11] = 15.7221000000; feg[11] = 2.6198000000;
					g[12] = 0.6000000000; fxg[12] = 14.9444000000; feg[12] = 2.4082000000;
					g[13] = 0.6500000000; fxg[13] = 14.2020000000; feg[13] = 2.2201000000;
					g[14] = 0.7000000000; fxg[14] = 13.4987000000; feg[14] = 2.0517000000;
					g[15] = 0.7500000000; fxg[15] = 12.8370000000; feg[15] = 1.8999000000;
					g[16] = 0.8000000000; fxg[16] = 12.2187000000; feg[16] = 1.7623000000;
					g[17] = 0.8500000000; fxg[17] = 11.6442000000; feg[17] = 1.6372000000;
					g[18] = 0.9000000000; fxg[18] = 11.1134000000; feg[18] = 1.5231000000;
					g[19] = 0.9500000000; fxg[19] = 10.6253000000; feg[19] = 1.4187000000;
					g[20] = 1.0000000000; fxg[20] = 10.1783000000; feg[20] = 1.3232000000;
					g[21] = 1.0500000000; fxg[21] = 9.7704000000; feg[21] = 1.2356000000;
					g[22] = 1.1000000000; fxg[22] = 9.3993000000; feg[22] = 1.1552000000;
					g[23] = 1.1500000000; fxg[23] = 9.0622000000; feg[23] = 1.0813000000;
					g[24] = 1.2000000000; fxg[24] = 8.7565000000; feg[24] = 1.0134000000;
					g[25] = 1.2500000000; fxg[25] = 8.4794000000; feg[25] = 0.9509000000;
					g[26] = 1.3000000000; fxg[26] = 8.2282000000; feg[26] = 0.8934000000;
					g[27] = 1.3500000000; fxg[27] = 7.9999000000; feg[27] = 0.8405000000;
					g[28] = 1.4000000000; fxg[28] = 7.7922000000; feg[28] = 0.7917000000;
					g[29] = 1.4500000000; fxg[29] = 7.6024000000; feg[29] = 0.7466000000;
					g[30] = 1.5000000000; fxg[30] = 7.4284000000; feg[30] = 0.7051000000;
					g[31] = 1.5500000000; fxg[31] = 7.2679000000; feg[31] = 0.6667000000;
					g[32] = 1.6000000000; fxg[32] = 7.1191000000; feg[32] = 0.6313000000;
					g[33] = 1.6500000000; fxg[33] = 6.9801000000; feg[33] = 0.5985000000;
					g[34] = 1.7000000000; fxg[34] = 6.8494000000; feg[34] = 0.5681000000;
					g[35] = 1.7500000000; fxg[35] = 6.7257000000; feg[35] = 0.5400000000;
					g[36] = 1.8000000000; fxg[36] = 6.6076000000; feg[36] = 0.5139000000;
					g[37] = 1.8500000000; fxg[37] = 6.4942000000; feg[37] = 0.4897000000;
					g[38] = 1.9000000000; fxg[38] = 6.3844000000; feg[38] = 0.4672000000;
					g[39] = 1.9500000000; fxg[39] = 6.2776000000; feg[39] = 0.4462000000;
					g[40] = 2.0000000000; fxg[40] = 6.1732000000; feg[40] = 0.4267000000;
					g[41] = 2.0500000000; fxg[41] = 6.0705000000; feg[41] = 0.4084000000;
					g[42] = 2.1000000000; fxg[42] = 5.9689000000; feg[42] = 0.3914000000;
					g[43] = 2.1500000000; fxg[43] = 5.8684000000; feg[43] = 0.3755000000;
					g[44] = 2.2000000000; fxg[44] = 5.7689000000; feg[44] = 0.3606000000;
					g[45] = 2.2500000000; fxg[45] = 5.6698000000; feg[45] = 0.3466000000;
					g[46] = 2.3000000000; fxg[46] = 5.5707000000; feg[46] = 0.3335000000;
					g[47] = 2.3500000000; fxg[47] = 5.4718000000; feg[47] = 0.3212000000;
					g[48] = 2.4000000000; fxg[48] = 5.3736000000; feg[48] = 0.3096000000;
					g[49] = 2.4500000000; fxg[49] = 5.2758000000; feg[49] = 0.2986000000;
					g[50] = 2.5000000000; fxg[50] = 5.1780000000; feg[50] = 0.2883000000;
					g[51] = 2.5500000000; fxg[51] = 5.0800000000; feg[51] = 0.2786000000;
					g[52] = 2.6000000000; fxg[52] = 4.9823000000; feg[52] = 0.2693000000;
					g[53] = 2.6500000000; fxg[53] = 4.8856000000; feg[53] = 0.2606000000;
					g[54] = 2.7000000000; fxg[54] = 4.7898000000; feg[54] = 0.2523000000;
					g[55] = 2.7500000000; fxg[55] = 4.6943000000; feg[55] = 0.2444000000;
					g[56] = 2.8000000000; fxg[56] = 4.5990000000; feg[56] = 0.2369000000;
					g[57] = 2.8500000000; fxg[57] = 4.5040000000; feg[57] = 0.2298000000;
					g[58] = 2.9000000000; fxg[58] = 4.4104000000; feg[58] = 0.2230000000;
					g[59] = 2.9500000000; fxg[59] = 4.3185000000; feg[59] = 0.2165000000;
					g[60] = 3.0000000000; fxg[60] = 4.2280000000; feg[60] = 0.2103000000;
					g[61] = 3.0500000000; fxg[61] = 4.1382000000; feg[61] = 0.2044000000;
					g[62] = 3.1000000000; fxg[62] = 4.0488000000; feg[62] = 0.1988000000;
					g[63] = 3.1500000000; fxg[63] = 3.9605000000; feg[63] = 0.1933000000;
					g[64] = 3.2000000000; fxg[64] = 3.8740000000; feg[64] = 0.1882000000;
					g[65] = 3.2500000000; fxg[65] = 3.7899000000; feg[65] = 0.1832000000;
					g[66] = 3.3000000000; fxg[66] = 3.7079000000; feg[66] = 0.1784000000;
					g[67] = 3.3500000000; fxg[67] = 3.6272000000; feg[67] = 0.1738000000;
					g[68] = 3.4000000000; fxg[68] = 3.5473000000; feg[68] = 0.1694000000;
					g[69] = 3.4500000000; fxg[69] = 3.4683000000; feg[69] = 0.1651000000;
					g[70] = 3.5000000000; fxg[70] = 3.3910000000; feg[70] = 0.1611000000;
					g[71] = 3.5500000000; fxg[71] = 3.3162000000; feg[71] = 0.1571000000;
					g[72] = 3.6000000000; fxg[72] = 3.2442000000; feg[72] = 0.1533000000;
					g[73] = 3.6500000000; fxg[73] = 3.1745000000; feg[73] = 0.1497000000;
					g[74] = 3.7000000000; fxg[74] = 3.1062000000; feg[74] = 0.1461000000;
					g[75] = 3.7500000000; fxg[75] = 3.0387000000; feg[75] = 0.1427000000;
					g[76] = 3.8000000000; fxg[76] = 2.9722000000; feg[76] = 0.1394000000;
					g[77] = 3.8500000000; fxg[77] = 2.9073000000; feg[77] = 0.1362000000;
					g[78] = 3.9000000000; fxg[78] = 2.8446000000; feg[78] = 0.1332000000;
					g[79] = 3.9500000000; fxg[79] = 2.7847000000; feg[79] = 0.1302000000;
					g[80] = 4.0000000000; fxg[80] = 2.7276000000; feg[80] = 0.1273000000;
					g[81] = 4.0500000000; fxg[81] = 2.6724000000; feg[81] = 0.1245000000;
					g[82] = 4.1000000000; fxg[82] = 2.6182000000; feg[82] = 0.1218000000;
					g[83] = 4.1500000000; fxg[83] = 2.5647000000; feg[83] = 0.1192000000;
					g[84] = 4.2000000000; fxg[84] = 2.5122000000; feg[84] = 0.1166000000;
					g[85] = 4.2500000000; fxg[85] = 2.4611000000; feg[85] = 0.1142000000;
					g[86] = 4.3000000000; fxg[86] = 2.4119000000; feg[86] = 0.1118000000;
					g[87] = 4.3500000000; fxg[87] = 2.3651000000; feg[87] = 0.1095000000;
					g[88] = 4.4000000000; fxg[88] = 2.3210000000; feg[88] = 0.1072000000;
					g[89] = 4.4500000000; fxg[89] = 2.2792000000; feg[89] = 0.1050000000;
					g[90] = 4.5000000000; fxg[90] = 2.2384000000; feg[90] = 0.1029000000;
					g[91] = 4.5500000000; fxg[91] = 2.1979000000; feg[91] = 0.1008000000;
					g[92] = 4.6000000000; fxg[92] = 2.1579000000; feg[92] = 0.0988000000;
					g[93] = 4.6500000000; fxg[93] = 2.1189000000; feg[93] = 0.0969000000;
					g[94] = 4.7000000000; fxg[94] = 2.0812000000; feg[94] = 0.0950000000;
					g[95] = 4.7500000000; fxg[95] = 2.0448000000; feg[95] = 0.0932000000;
					g[96] = 4.8000000000; fxg[96] = 2.0104000000; feg[96] = 0.0914000000;
					g[97] = 4.8500000000; fxg[97] = 1.9784000000; feg[97] = 0.0896000000;
					g[98] = 4.9000000000; fxg[98] = 1.9486000000; feg[98] = 0.0879000000;
					g[99] = 4.9500000000; fxg[99] = 1.9199000000; feg[99] = 0.0863000000;
					g[100] = 5.0000000000; fxg[100] = 1.8911000000; feg[100] = 0.0847000000;
					g[101] = 5.0500000000; fxg[101] = 1.8623000000; feg[101] = 0.0831000000;
					g[102] = 5.1000000000; fxg[102] = 1.8340000000; feg[102] = 0.0816000000;
					g[103] = 5.1500000000; fxg[103] = 1.8066000000; feg[103] = 0.0801000000;
					g[104] = 5.2000000000; fxg[104] = 1.7801000000; feg[104] = 0.0787000000;
					g[105] = 5.2500000000; fxg[105] = 1.7545000000; feg[105] = 0.0773000000;
					g[106] = 5.3000000000; fxg[106] = 1.7303000000; feg[106] = 0.0759000000;
					g[107] = 5.3500000000; fxg[107] = 1.7081000000; feg[107] = 0.0746000000;
					g[108] = 5.4000000000; fxg[108] = 1.6881000000; feg[108] = 0.0733000000;
					g[109] = 5.4500000000; fxg[109] = 1.6691000000; feg[109] = 0.0720000000;
					g[110] = 5.5000000000; fxg[110] = 1.6500000000; feg[110] = 0.0707000000;
					g[111] = 5.5500000000; fxg[111] = 1.6302000000; feg[111] = 0.0695000000;
					g[112] = 5.6000000000; fxg[112] = 1.6103000000; feg[112] = 0.0684000000;
					g[113] = 5.6500000000; fxg[113] = 1.5910000000; feg[113] = 0.0672000000;
					g[114] = 5.7000000000; fxg[114] = 1.5725000000; feg[114] = 0.0661000000;
					g[115] = 5.7500000000; fxg[115] = 1.5544000000; feg[115] = 0.0650000000;
					g[116] = 5.8000000000; fxg[116] = 1.5368000000; feg[116] = 0.0639000000;
					g[117] = 5.8500000000; fxg[117] = 1.5199000000; feg[117] = 0.0629000000;
					g[118] = 5.9000000000; fxg[118] = 1.5048000000; feg[118] = 0.0619000000;
					g[119] = 5.9500000000; fxg[119] = 1.4916000000; feg[119] = 0.0609000000;
					g[120] = 6.0000000000; fxg[120] = 1.4797000000; feg[120] = 0.0599000000;
					g[121] = 6.0500000000; fxg[121] = 1.4678000000; feg[121] = 0.0589000000;
					g[122] = 6.1000000000; fxg[122] = 1.4549000000; feg[122] = 0.0580000000;
					g[123] = 6.1500000000; fxg[123] = 1.4411000000; feg[123] = 0.0571000000;
					g[124] = 6.2000000000; fxg[124] = 1.4273000000; feg[124] = 0.0562000000;
					g[125] = 6.2500000000; fxg[125] = 1.4141000000; feg[125] = 0.0554000000;
					g[126] = 6.3000000000; fxg[126] = 1.4016000000; feg[126] = 0.0545000000;
					g[127] = 6.3500000000; fxg[127] = 1.3893000000; feg[127] = 0.0537000000;
					g[128] = 6.4000000000; fxg[128] = 1.3769000000; feg[128] = 0.0529000000;
					g[129] = 6.4500000000; fxg[129] = 1.3649000000; feg[129] = 0.0521000000;
					g[130] = 6.5000000000; fxg[130] = 1.3539000000; feg[130] = 0.0513000000;
					g[131] = 6.5500000000; fxg[131] = 1.3447000000; feg[131] = 0.0506000000;
					g[132] = 6.6000000000; fxg[132] = 1.3371000000; feg[132] = 0.0498000000;
					g[133] = 6.6500000000; fxg[133] = 1.3301000000; feg[133] = 0.0491000000;
					g[134] = 6.7000000000; fxg[134] = 1.3224000000; feg[134] = 0.0484000000;
					g[135] = 6.7500000000; fxg[135] = 1.3133000000; feg[135] = 0.0477000000;
					g[136] = 6.8000000000; fxg[136] = 1.3032000000; feg[136] = 0.0470000000;
					g[137] = 6.8500000000; fxg[137] = 1.2930000000; feg[137] = 0.0463000000;
					g[138] = 6.9000000000; fxg[138] = 1.2834000000; feg[138] = 0.0457000000;
					g[139] = 6.9500000000; fxg[139] = 1.2746000000; feg[139] = 0.0450000000;
					g[140] = 7.0000000000; fxg[140] = 1.2658000000; feg[140] = 0.0444000000;
					g[141] = 7.0500000000; fxg[141] = 1.2567000000; feg[141] = 0.0438000000;
					g[142] = 7.1000000000; fxg[142] = 1.2474000000; feg[142] = 0.0432000000;
					g[143] = 7.1500000000; fxg[143] = 1.2385000000; feg[143] = 0.0426000000;
					g[144] = 7.2000000000; fxg[144] = 1.2309000000; feg[144] = 0.0420000000;
					g[145] = 7.2500000000; fxg[145] = 1.2249000000; feg[145] = 0.0415000000;
					g[146] = 7.3000000000; fxg[146] = 1.2203000000; feg[146] = 0.0409000000;
					g[147] = 7.3500000000; fxg[147] = 1.2161000000; feg[147] = 0.0404000000;
					g[148] = 7.4000000000; fxg[148] = 1.2110000000; feg[148] = 0.0398000000;
					g[149] = 7.4500000000; fxg[149] = 1.2043000000; feg[149] = 0.0393000000;
					g[150] = 7.5000000000; fxg[150] = 1.1964000000; feg[150] = 0.0388000000;
					g[151] = 7.5500000000; fxg[151] = 1.1880000000; feg[151] = 0.0383000000;
					g[152] = 7.6000000000; fxg[152] = 1.1800000000; feg[152] = 0.0378000000;
					g[153] = 7.6500000000; fxg[153] = 1.1729000000; feg[153] = 0.0373000000;
					g[154] = 7.7000000000; fxg[154] = 1.1661000000; feg[154] = 0.0369000000;
					g[155] = 7.7500000000; fxg[155] = 1.1591000000; feg[155] = 0.0364000000;
					g[156] = 7.8000000000; fxg[156] = 1.1515000000; feg[156] = 0.0360000000;
					g[157] = 7.8500000000; fxg[157] = 1.1438000000; feg[157] = 0.0355000000;
					g[158] = 7.9000000000; fxg[158] = 1.1363000000; feg[158] = 0.0351000000;
					g[159] = 7.9500000000; fxg[159] = 1.1299000000; feg[159] = 0.0346000000;
					g[160] = 8.0000000000; fxg[160] = 1.1251000000; feg[160] = 0.0342000000;
					g[161] = 8.0500000000; fxg[161] = 1.1217000000; feg[161] = 0.0338000000;
					g[162] = 8.1000000000; fxg[162] = 1.1191000000; feg[162] = 0.0334000000;
					g[163] = 8.1500000000; fxg[163] = 1.1159000000; feg[163] = 0.0330000000;
					g[164] = 8.2000000000; fxg[164] = 1.1114000000; feg[164] = 0.0326000000;
					g[165] = 8.2500000000; fxg[165] = 1.1052000000; feg[165] = 0.0322000000;
					g[166] = 8.3000000000; fxg[166] = 1.0979000000; feg[166] = 0.0318000000;
					g[167] = 8.3500000000; fxg[167] = 1.0903000000; feg[167] = 0.0315000000;
					g[168] = 8.4000000000; fxg[168] = 1.0832000000; feg[168] = 0.0311000000;
					g[169] = 8.4500000000; fxg[169] = 1.0770000000; feg[169] = 0.0307000000;
					g[170] = 8.5000000000; fxg[170] = 1.0712000000; feg[170] = 0.0304000000;
					g[171] = 8.5500000000; fxg[171] = 1.0650000000; feg[171] = 0.0300000000;
					g[172] = 8.6000000000; fxg[172] = 1.0583000000; feg[172] = 0.0297000000;
					g[173] = 8.6500000000; fxg[173] = 1.0513000000; feg[173] = 0.0294000000;
					g[174] = 8.7000000000; fxg[174] = 1.0442000000; feg[174] = 0.0290000000;
					g[175] = 8.7500000000; fxg[175] = 1.0378000000; feg[175] = 0.0287000000;
					g[176] = 8.8000000000; fxg[176] = 1.0324000000; feg[176] = 0.0284000000;
					g[177] = 8.8500000000; fxg[177] = 1.0286000000; feg[177] = 0.0281000000;
					g[178] = 8.9000000000; fxg[178] = 1.0262000000; feg[178] = 0.0278000000;
					g[179] = 8.9500000000; fxg[179] = 1.0244000000; feg[179] = 0.0275000000;
					g[180] = 9.0000000000; fxg[180] = 1.0221000000; feg[180] = 0.0272000000;
					g[181] = 9.0500000000; fxg[181] = 1.0185000000; feg[181] = 0.0269000000;
					g[182] = 9.1000000000; fxg[182] = 1.0133000000; feg[182] = 0.0266000000;
					g[183] = 9.1500000000; fxg[183] = 1.0067000000; feg[183] = 0.0263000000;
					g[184] = 9.2000000000; fxg[184] = 0.9994000000; feg[184] = 0.0260000000;
					g[185] = 9.2500000000; fxg[185] = 0.9922000000; feg[185] = 0.0257000000;
					g[186] = 9.3000000000; fxg[186] = 0.9857000000; feg[186] = 0.0255000000;
					g[187] = 9.3500000000; fxg[187] = 0.9801000000; feg[187] = 0.0252000000;
					g[188] = 9.4000000000; fxg[188] = 0.9745000000; feg[188] = 0.0249000000;
					g[189] = 9.4500000000; fxg[189] = 0.9686000000; feg[189] = 0.0247000000;
					g[190] = 9.5000000000; fxg[190] = 0.9621000000; feg[190] = 0.0244000000;
					g[191] = 9.5500000000; fxg[191] = 0.9553000000; feg[191] = 0.0242000000;
					g[192] = 9.6000000000; fxg[192] = 0.9485000000; feg[192] = 0.0239000000;
					g[193] = 9.6500000000; fxg[193] = 0.9422000000; feg[193] = 0.0237000000;
					g[194] = 9.7000000000; fxg[194] = 0.9366000000; feg[194] = 0.0235000000;
					g[195] = 9.7500000000; fxg[195] = 0.9323000000; feg[195] = 0.0232000000;
					g[196] = 9.8000000000; fxg[196] = 0.9296000000; feg[196] = 0.0230000000;
					g[197] = 9.8500000000; fxg[197] = 0.9281000000; feg[197] = 0.0228000000;
					g[198] = 9.9000000000; fxg[198] = 0.9269000000; feg[198] = 0.0225000000;
					g[199] = 9.9500000000; fxg[199] = 0.9250000000; feg[199] = 0.0223000000;
					g[200] = 10.0000000000; fxg[200] = 0.9218000000; feg[200] = 0.0221000000;
					g[201] = 10.0500000000; fxg[201] = 0.9171000000; feg[201] = 0.0219000000;
					g[202] = 10.1000000000; fxg[202] = 0.9110000000; feg[202] = 0.0217000000;
					g[203] = 10.1500000000; fxg[203] = 0.9040000000; feg[203] = 0.0215000000;
					g[204] = 10.2000000000; fxg[204] = 0.8967000000; feg[204] = 0.0213000000;
					g[205] = 10.2500000000; fxg[205] = 0.8899000000; feg[205] = 0.0211000000;
					g[206] = 10.3000000000; fxg[206] = 0.8841000000; feg[206] = 0.0209000000;
					g[207] = 10.3500000000; fxg[207] = 0.8787000000; feg[207] = 0.0207000000;
					g[208] = 10.4000000000; fxg[208] = 0.8732000000; feg[208] = 0.0205000000;
					g[209] = 10.4500000000; fxg[209] = 0.8672000000; feg[209] = 0.0203000000;
					g[210] = 10.5000000000; fxg[210] = 0.8606000000; feg[210] = 0.0201000000;
					g[211] = 10.5500000000; fxg[211] = 0.8539000000; feg[211] = 0.0199000000;
					g[212] = 10.6000000000; fxg[212] = 0.8473000000; feg[212] = 0.0197000000;
					g[213] = 10.6500000000; fxg[213] = 0.8411000000; feg[213] = 0.0195000000;
					g[214] = 10.7000000000; fxg[214] = 0.8355000000; feg[214] = 0.0194000000;
					g[215] = 10.7500000000; fxg[215] = 0.8310000000; feg[215] = 0.0192000000;
					g[216] = 10.8000000000; fxg[216] = 0.8279000000; feg[216] = 0.0190000000;
					g[217] = 10.8500000000; fxg[217] = 0.8263000000; feg[217] = 0.0188000000;
					g[218] = 10.9000000000; fxg[218] = 0.8256000000; feg[218] = 0.0187000000;
					g[219] = 10.9500000000; fxg[219] = 0.8250000000; feg[219] = 0.0185000000;
					g[220] = 11.0000000000; fxg[220] = 0.8235000000; feg[220] = 0.0183000000;
					g[221] = 11.0500000000; fxg[221] = 0.8207000000; feg[221] = 0.0182000000;
					g[222] = 11.1000000000; fxg[222] = 0.8166000000; feg[222] = 0.0180000000;
					g[223] = 11.1500000000; fxg[223] = 0.8111000000; feg[223] = 0.0179000000;
					g[224] = 11.2000000000; fxg[224] = 0.8046000000; feg[224] = 0.0177000000;
					g[225] = 11.2500000000; fxg[225] = 0.7974000000; feg[225] = 0.0176000000;
					g[226] = 11.3000000000; fxg[226] = 0.7905000000; feg[226] = 0.0174000000;
					g[227] = 11.3500000000; fxg[227] = 0.7842000000; feg[227] = 0.0173000000;
					g[228] = 11.4000000000; fxg[228] = 0.7788000000; feg[228] = 0.0171000000;
					g[229] = 11.4500000000; fxg[229] = 0.7736000000; feg[229] = 0.0170000000;
					g[230] = 11.5000000000; fxg[230] = 0.7681000000; feg[230] = 0.0168000000;
					g[231] = 11.5500000000; fxg[231] = 0.7620000000; feg[231] = 0.0167000000;
					g[232] = 11.6000000000; fxg[232] = 0.7554000000; feg[232] = 0.0165000000;
					g[233] = 11.6500000000; fxg[233] = 0.7488000000; feg[233] = 0.0164000000;
					g[234] = 11.7000000000; fxg[234] = 0.7424000000; feg[234] = 0.0163000000;
					g[235] = 11.7500000000; fxg[235] = 0.7365000000; feg[235] = 0.0161000000;
					g[236] = 11.8000000000; fxg[236] = 0.7310000000; feg[236] = 0.0160000000;
					g[237] = 11.8500000000; fxg[237] = 0.7262000000; feg[237] = 0.0159000000;
					g[238] = 11.9000000000; fxg[238] = 0.7227000000; feg[238] = 0.0157000000;
					g[239] = 11.9500000000; fxg[239] = 0.7206000000; feg[239] = 0.0156000000;
					g[240] = 12.0000000000; fxg[240] = 0.7199000000; feg[240] = 0.0155000000;
					break;
				case 25:
					g[0] = 0.0000000000; fxg[0] = 25.0000000000; feg[0] = 7.5071000000;
					g[1] = 0.0500000000; fxg[1] = 24.8078000000; feg[1] = 7.3617000000;
					g[2] = 0.1000000000; fxg[2] = 24.2730000000; feg[2] = 6.9602000000;
					g[3] = 0.1500000000; fxg[3] = 23.4984000000; feg[3] = 6.3893000000;
					g[4] = 0.2000000000; fxg[4] = 22.5983000000; feg[4] = 5.7482000000;
					g[5] = 0.2500000000; fxg[5] = 21.6599000000; feg[5] = 5.1162000000;
					g[6] = 0.3000000000; fxg[6] = 20.7320000000; feg[6] = 4.5399000000;
					g[7] = 0.3500000000; fxg[7] = 19.8334000000; feg[7] = 4.0377000000;
					g[8] = 0.4000000000; fxg[8] = 18.9666000000; feg[8] = 3.6100000000;
					g[9] = 0.4500000000; fxg[9] = 18.1285000000; feg[9] = 3.2486000000;
					g[10] = 0.5000000000; fxg[10] = 17.3159000000; feg[10] = 2.9426000000;
					g[11] = 0.5500000000; fxg[11] = 16.5275000000; feg[11] = 2.6814000000;
					g[12] = 0.6000000000; fxg[12] = 15.7643000000; feg[12] = 2.4561000000;
					g[13] = 0.6500000000; fxg[13] = 15.0282000000; feg[13] = 2.2595000000;
					g[14] = 0.7000000000; fxg[14] = 14.3220000000; feg[14] = 2.0862000000;
					g[15] = 0.7500000000; fxg[15] = 13.6486000000; feg[15] = 1.9320000000;
					g[16] = 0.8000000000; fxg[16] = 13.0102000000; feg[16] = 1.7935000000;
					g[17] = 0.8500000000; fxg[17] = 12.4086000000; feg[17] = 1.6684000000;
					g[18] = 0.9000000000; fxg[18] = 11.8451000000; feg[18] = 1.5548000000;
					g[19] = 0.9500000000; fxg[19] = 11.3200000000; feg[19] = 1.4511000000;
					g[20] = 1.0000000000; fxg[20] = 10.8331000000; feg[20] = 1.3563000000;
					g[21] = 1.0500000000; fxg[21] = 10.3836000000; feg[21] = 1.2692000000;
					g[22] = 1.1000000000; fxg[22] = 9.9702000000; feg[22] = 1.1891000000;
					g[23] = 1.1500000000; fxg[23] = 9.5913000000; feg[23] = 1.1154000000;
					g[24] = 1.2000000000; fxg[24] = 9.2448000000; feg[24] = 1.0474000000;
					g[25] = 1.2500000000; fxg[25] = 8.9286000000; feg[25] = 0.9847000000;
					g[26] = 1.3000000000; fxg[26] = 8.6405000000; feg[26] = 0.9267000000;
					g[27] = 1.3500000000; fxg[27] = 8.3780000000; feg[27] = 0.8731000000;
					g[28] = 1.4000000000; fxg[28] = 8.1388000000; feg[28] = 0.8236000000;
					g[29] = 1.4500000000; fxg[29] = 7.9206000000; feg[29] = 0.7777000000;
					g[30] = 1.5000000000; fxg[30] = 7.7212000000; feg[30] = 0.7352000000;
					g[31] = 1.5500000000; fxg[31] = 7.5384000000; feg[31] = 0.6958000000;
					g[32] = 1.6000000000; fxg[32] = 7.3703000000; feg[32] = 0.6593000000;
					g[33] = 1.6500000000; fxg[33] = 7.2149000000; feg[33] = 0.6254000000;
					g[34] = 1.7000000000; fxg[34] = 7.0706000000; feg[34] = 0.5939000000;
					g[35] = 1.7500000000; fxg[35] = 6.9358000000; feg[35] = 0.5647000000;
					g[36] = 1.8000000000; fxg[36] = 6.8092000000; feg[36] = 0.5375000000;
					g[37] = 1.8500000000; fxg[37] = 6.6893000000; feg[37] = 0.5122000000;
					g[38] = 1.9000000000; fxg[38] = 6.5752000000; feg[38] = 0.4886000000;
					g[39] = 1.9500000000; fxg[39] = 6.4658000000; feg[39] = 0.4666000000;
					g[40] = 2.0000000000; fxg[40] = 6.3603000000; feg[40] = 0.4461000000;
					g[41] = 2.0500000000; fxg[41] = 6.2579000000; feg[41] = 0.4270000000;
					g[42] = 2.1000000000; fxg[42] = 6.1580000000; feg[42] = 0.4090000000;
					g[43] = 2.1500000000; fxg[43] = 6.0600000000; feg[43] = 0.3923000000;
					g[44] = 2.2000000000; fxg[44] = 5.9637000000; feg[44] = 0.3765000000;
					g[45] = 2.2500000000; fxg[45] = 5.8686000000; feg[45] = 0.3618000000;
					g[46] = 2.3000000000; fxg[46] = 5.7741000000; feg[46] = 0.3479000000;
					g[47] = 2.3500000000; fxg[47] = 5.6803000000; feg[47] = 0.3349000000;
					g[48] = 2.4000000000; fxg[48] = 5.5871000000; feg[48] = 0.3227000000;
					g[49] = 2.4500000000; fxg[49] = 5.4944000000; feg[49] = 0.3111000000;
					g[50] = 2.5000000000; fxg[50] = 5.4019000000; feg[50] = 0.3002000000;
					g[51] = 2.5500000000; fxg[51] = 5.3092000000; feg[51] = 0.2899000000;
					g[52] = 2.6000000000; fxg[52] = 5.2168000000; feg[52] = 0.2802000000;
					g[53] = 2.6500000000; fxg[53] = 5.1250000000; feg[53] = 0.2709000000;
					g[54] = 2.7000000000; fxg[54] = 5.0337000000; feg[54] = 0.2622000000;
					g[55] = 2.7500000000; fxg[55] = 4.9425000000; feg[55] = 0.2539000000;
					g[56] = 2.8000000000; fxg[56] = 4.8512000000; feg[56] = 0.2460000000;
					g[57] = 2.8500000000; fxg[57] = 4.7601000000; feg[57] = 0.2386000000;
					g[58] = 2.9000000000; fxg[58] = 4.6698000000; feg[58] = 0.2314000000;
					g[59] = 2.9500000000; fxg[59] = 4.5807000000; feg[59] = 0.2246000000;
					g[60] = 3.0000000000; fxg[60] = 4.4925000000; feg[60] = 0.2181000000;
					g[61] = 3.0500000000; fxg[61] = 4.4046000000; feg[61] = 0.2120000000;
					g[62] = 3.1000000000; fxg[62] = 4.3169000000; feg[62] = 0.2060000000;
					g[63] = 3.1500000000; fxg[63] = 4.2298000000; feg[63] = 0.2004000000;
					g[64] = 3.2000000000; fxg[64] = 4.1442000000; feg[64] = 0.1950000000;
					g[65] = 3.2500000000; fxg[65] = 4.0604000000; feg[65] = 0.1898000000;
					g[66] = 3.3000000000; fxg[66] = 3.9782000000; feg[66] = 0.1848000000;
					g[67] = 3.3500000000; fxg[67] = 3.8970000000; feg[67] = 0.1800000000;
					g[68] = 3.4000000000; fxg[68] = 3.8161000000; feg[68] = 0.1754000000;
					g[69] = 3.4500000000; fxg[69] = 3.7360000000; feg[69] = 0.1710000000;
					g[70] = 3.5000000000; fxg[70] = 3.6572000000; feg[70] = 0.1668000000;
					g[71] = 3.5500000000; fxg[71] = 3.5805000000; feg[71] = 0.1627000000;
					g[72] = 3.6000000000; fxg[72] = 3.5064000000; feg[72] = 0.1588000000;
					g[73] = 3.6500000000; fxg[73] = 3.4342000000; feg[73] = 0.1550000000;
					g[74] = 3.7000000000; fxg[74] = 3.3632000000; feg[74] = 0.1513000000;
					g[75] = 3.7500000000; fxg[75] = 3.2927000000; feg[75] = 0.1478000000;
					g[76] = 3.8000000000; fxg[76] = 3.2229000000; feg[76] = 0.1444000000;
					g[77] = 3.8500000000; fxg[77] = 3.1545000000; feg[77] = 0.1411000000;
					g[78] = 3.9000000000; fxg[78] = 3.0882000000; feg[78] = 0.1379000000;
					g[79] = 3.9500000000; fxg[79] = 3.0247000000; feg[79] = 0.1348000000;
					g[80] = 4.0000000000; fxg[80] = 2.9638000000; feg[80] = 0.1319000000;
					g[81] = 4.0500000000; fxg[81] = 2.9048000000; feg[81] = 0.1290000000;
					g[82] = 4.1000000000; fxg[82] = 2.8466000000; feg[82] = 0.1262000000;
					g[83] = 4.1500000000; fxg[83] = 2.7888000000; feg[83] = 0.1235000000;
					g[84] = 4.2000000000; fxg[84] = 2.7317000000; feg[84] = 0.1209000000;
					g[85] = 4.2500000000; fxg[85] = 2.6759000000; feg[85] = 0.1183000000;
					g[86] = 4.3000000000; fxg[86] = 2.6221000000; feg[86] = 0.1159000000;
					g[87] = 4.3500000000; fxg[87] = 2.5710000000; feg[87] = 0.1135000000;
					g[88] = 4.4000000000; fxg[88] = 2.5226000000; feg[88] = 0.1111000000;
					g[89] = 4.4500000000; fxg[89] = 2.4765000000; feg[89] = 0.1089000000;
					g[90] = 4.5000000000; fxg[90] = 2.4314000000; feg[90] = 0.1067000000;
					g[91] = 4.5500000000; fxg[91] = 2.3866000000; feg[91] = 0.1046000000;
					g[92] = 4.6000000000; fxg[92] = 2.3421000000; feg[92] = 0.1025000000;
					g[93] = 4.6500000000; fxg[93] = 2.2981000000; feg[93] = 0.1005000000;
					g[94] = 4.7000000000; fxg[94] = 2.2554000000; feg[94] = 0.0986000000;
					g[95] = 4.7500000000; fxg[95] = 2.2144000000; feg[95] = 0.0967000000;
					g[96] = 4.8000000000; fxg[96] = 2.1757000000; feg[96] = 0.0948000000;
					g[97] = 4.8500000000; fxg[97] = 2.1397000000; feg[97] = 0.0930000000;
					g[98] = 4.9000000000; fxg[98] = 2.1060000000; feg[98] = 0.0913000000;
					g[99] = 4.9500000000; fxg[99] = 2.0733000000; feg[99] = 0.0896000000;
					g[100] = 5.0000000000; fxg[100] = 2.0409000000; feg[100] = 0.0879000000;
					g[101] = 5.0500000000; fxg[101] = 2.0082000000; feg[101] = 0.0863000000;
					g[102] = 5.1000000000; fxg[102] = 1.9757000000; feg[102] = 0.0847000000;
					g[103] = 5.1500000000; fxg[103] = 1.9438000000; feg[103] = 0.0832000000;
					g[104] = 5.2000000000; fxg[104] = 1.9128000000; feg[104] = 0.0817000000;
					g[105] = 5.2500000000; fxg[105] = 1.8832000000; feg[105] = 0.0803000000;
					g[106] = 5.3000000000; fxg[106] = 1.8554000000; feg[106] = 0.0789000000;
					g[107] = 5.3500000000; fxg[107] = 1.8301000000; feg[107] = 0.0775000000;
					g[108] = 5.4000000000; fxg[108] = 1.8068000000; feg[108] = 0.0761000000;
					g[109] = 5.4500000000; fxg[109] = 1.7848000000; feg[109] = 0.0748000000;
					g[110] = 5.5000000000; fxg[110] = 1.7628000000; feg[110] = 0.0735000000;
					g[111] = 5.5500000000; fxg[111] = 1.7402000000; feg[111] = 0.0723000000;
					g[112] = 5.6000000000; fxg[112] = 1.7173000000; feg[112] = 0.0711000000;
					g[113] = 5.6500000000; fxg[113] = 1.6946000000; feg[113] = 0.0699000000;
					g[114] = 5.7000000000; fxg[114] = 1.6725000000; feg[114] = 0.0687000000;
					g[115] = 5.7500000000; fxg[115] = 1.6510000000; feg[115] = 0.0676000000;
					g[116] = 5.8000000000; fxg[116] = 1.6302000000; feg[116] = 0.0665000000;
					g[117] = 5.8500000000; fxg[117] = 1.6108000000; feg[117] = 0.0654000000;
					g[118] = 5.9000000000; fxg[118] = 1.5934000000; feg[118] = 0.0644000000;
					g[119] = 5.9500000000; fxg[119] = 1.5780000000; feg[119] = 0.0633000000;
					g[120] = 6.0000000000; fxg[120] = 1.5641000000; feg[120] = 0.0623000000;
					g[121] = 6.0500000000; fxg[121] = 1.5503000000; feg[121] = 0.0613000000;
					g[122] = 6.1000000000; fxg[122] = 1.5356000000; feg[122] = 0.0604000000;
					g[123] = 6.1500000000; fxg[123] = 1.5200000000; feg[123] = 0.0594000000;
					g[124] = 6.2000000000; fxg[124] = 1.5040000000; feg[124] = 0.0585000000;
					g[125] = 6.2500000000; fxg[125] = 1.4885000000; feg[125] = 0.0576000000;
					g[126] = 6.3000000000; fxg[126] = 1.4735000000; feg[126] = 0.0567000000;
					g[127] = 6.3500000000; fxg[127] = 1.4588000000; feg[127] = 0.0559000000;
					g[128] = 6.4000000000; fxg[128] = 1.4443000000; feg[128] = 0.0551000000;
					g[129] = 6.4500000000; fxg[129] = 1.4304000000; feg[129] = 0.0542000000;
					g[130] = 6.5000000000; fxg[130] = 1.4181000000; feg[130] = 0.0534000000;
					g[131] = 6.5500000000; fxg[131] = 1.4076000000; feg[131] = 0.0526000000;
					g[132] = 6.6000000000; fxg[132] = 1.3989000000; feg[132] = 0.0519000000;
					g[133] = 6.6500000000; fxg[133] = 1.3909000000; feg[133] = 0.0511000000;
					g[134] = 6.7000000000; fxg[134] = 1.3822000000; feg[134] = 0.0504000000;
					g[135] = 6.7500000000; fxg[135] = 1.3721000000; feg[135] = 0.0496000000;
					g[136] = 6.8000000000; fxg[136] = 1.3610000000; feg[136] = 0.0489000000;
					g[137] = 6.8500000000; fxg[137] = 1.3496000000; feg[137] = 0.0483000000;
					g[138] = 6.9000000000; fxg[138] = 1.3386000000; feg[138] = 0.0476000000;
					g[139] = 6.9500000000; fxg[139] = 1.3283000000; feg[139] = 0.0469000000;
					g[140] = 7.0000000000; fxg[140] = 1.3181000000; feg[140] = 0.0463000000;
					g[141] = 7.0500000000; fxg[141] = 1.3077000000; feg[141] = 0.0456000000;
					g[142] = 7.1000000000; fxg[142] = 1.2973000000; feg[142] = 0.0450000000;
					g[143] = 7.1500000000; fxg[143] = 1.2875000000; feg[143] = 0.0444000000;
					g[144] = 7.2000000000; fxg[144] = 1.2792000000; feg[144] = 0.0438000000;
					g[145] = 7.2500000000; fxg[145] = 1.2728000000; feg[145] = 0.0432000000;
					g[146] = 7.3000000000; fxg[146] = 1.2678000000; feg[146] = 0.0426000000;
					g[147] = 7.3500000000; fxg[147] = 1.2633000000; feg[147] = 0.0421000000;
					g[148] = 7.4000000000; fxg[148] = 1.2578000000; feg[148] = 0.0415000000;
					g[149] = 7.4500000000; fxg[149] = 1.2508000000; feg[149] = 0.0410000000;
					g[150] = 7.5000000000; fxg[150] = 1.2423000000; feg[150] = 0.0404000000;
					g[151] = 7.5500000000; fxg[151] = 1.2333000000; feg[151] = 0.0399000000;
					g[152] = 7.6000000000; fxg[152] = 1.2248000000; feg[152] = 0.0394000000;
					g[153] = 7.6500000000; fxg[153] = 1.2170000000; feg[153] = 0.0389000000;
					g[154] = 7.7000000000; fxg[154] = 1.2097000000; feg[154] = 0.0384000000;
					g[155] = 7.7500000000; fxg[155] = 1.2022000000; feg[155] = 0.0379000000;
					g[156] = 7.8000000000; fxg[156] = 1.1941000000; feg[156] = 0.0375000000;
					g[157] = 7.8500000000; fxg[157] = 1.1857000000; feg[157] = 0.0370000000;
					g[158] = 7.9000000000; fxg[158] = 1.1777000000; feg[158] = 0.0365000000;
					g[159] = 7.9500000000; fxg[159] = 1.1710000000; feg[159] = 0.0361000000;
					g[160] = 8.0000000000; fxg[160] = 1.1661000000; feg[160] = 0.0357000000;
					g[161] = 8.0500000000; fxg[161] = 1.1628000000; feg[161] = 0.0352000000;
					g[162] = 8.1000000000; fxg[162] = 1.1603000000; feg[162] = 0.0348000000;
					g[163] = 8.1500000000; fxg[163] = 1.1573000000; feg[163] = 0.0344000000;
					g[164] = 8.2000000000; fxg[164] = 1.1527000000; feg[164] = 0.0340000000;
					g[165] = 8.2500000000; fxg[165] = 1.1463000000; feg[165] = 0.0336000000;
					g[166] = 8.3000000000; fxg[166] = 1.1387000000; feg[166] = 0.0332000000;
					g[167] = 8.3500000000; fxg[167] = 1.1309000000; feg[167] = 0.0328000000;
					g[168] = 8.4000000000; fxg[168] = 1.1237000000; feg[168] = 0.0324000000;
					g[169] = 8.4500000000; fxg[169] = 1.1174000000; feg[169] = 0.0320000000;
					g[170] = 8.5000000000; fxg[170] = 1.1116000000; feg[170] = 0.0317000000;
					g[171] = 8.5500000000; fxg[171] = 1.1056000000; feg[171] = 0.0313000000;
					g[172] = 8.6000000000; fxg[172] = 1.0990000000; feg[172] = 0.0309000000;
					g[173] = 8.6500000000; fxg[173] = 1.0917000000; feg[173] = 0.0306000000;
					g[174] = 8.7000000000; fxg[174] = 1.0842000000; feg[174] = 0.0302000000;
					g[175] = 8.7500000000; fxg[175] = 1.0774000000; feg[175] = 0.0299000000;
					g[176] = 8.8000000000; fxg[176] = 1.0720000000; feg[176] = 0.0296000000;
					g[177] = 8.8500000000; fxg[177] = 1.0683000000; feg[177] = 0.0293000000;
					g[178] = 8.9000000000; fxg[178] = 1.0662000000; feg[178] = 0.0289000000;
					g[179] = 8.9500000000; fxg[179] = 1.0648000000; feg[179] = 0.0286000000;
					g[180] = 9.0000000000; fxg[180] = 1.0628000000; feg[180] = 0.0283000000;
					g[181] = 9.0500000000; fxg[181] = 1.0594000000; feg[181] = 0.0280000000;
					g[182] = 9.1000000000; fxg[182] = 1.0540000000; feg[182] = 0.0277000000;
					g[183] = 9.1500000000; fxg[183] = 1.0471000000; feg[183] = 0.0274000000;
					g[184] = 9.2000000000; fxg[184] = 1.0396000000; feg[184] = 0.0271000000;
					g[185] = 9.2500000000; fxg[185] = 1.0323000000; feg[185] = 0.0268000000;
					g[186] = 9.3000000000; fxg[186] = 1.0261000000; feg[186] = 0.0265000000;
					g[187] = 9.3500000000; fxg[187] = 1.0208000000; feg[187] = 0.0263000000;
					g[188] = 9.4000000000; fxg[188] = 1.0158000000; feg[188] = 0.0260000000;
					g[189] = 9.4500000000; fxg[189] = 1.0104000000; feg[189] = 0.0257000000;
					g[190] = 9.5000000000; fxg[190] = 1.0043000000; feg[190] = 0.0255000000;
					g[191] = 9.5500000000; fxg[191] = 0.9975000000; feg[191] = 0.0252000000;
					g[192] = 9.6000000000; fxg[192] = 0.9904000000; feg[192] = 0.0249000000;
					g[193] = 9.6500000000; fxg[193] = 0.9836000000; feg[193] = 0.0247000000;
					g[194] = 9.7000000000; fxg[194] = 0.9778000000; feg[194] = 0.0244000000;
					g[195] = 9.7500000000; fxg[195] = 0.9735000000; feg[195] = 0.0242000000;
					g[196] = 9.8000000000; fxg[196] = 0.9710000000; feg[196] = 0.0240000000;
					g[197] = 9.8500000000; fxg[197] = 0.9699000000; feg[197] = 0.0237000000;
					g[198] = 9.9000000000; fxg[198] = 0.9692000000; feg[198] = 0.0235000000;
					g[199] = 9.9500000000; fxg[199] = 0.9676000000; feg[199] = 0.0232000000;
					g[200] = 10.0000000000; fxg[200] = 0.9646000000; feg[200] = 0.0230000000;
					g[201] = 10.0500000000; fxg[201] = 0.9597000000; feg[201] = 0.0228000000;
					g[202] = 10.1000000000; fxg[202] = 0.9531000000; feg[202] = 0.0226000000;
					g[203] = 10.1500000000; fxg[203] = 0.9457000000; feg[203] = 0.0224000000;
					g[204] = 10.2000000000; fxg[204] = 0.9383000000; feg[204] = 0.0221000000;
					g[205] = 10.2500000000; fxg[205] = 0.9317000000; feg[205] = 0.0219000000;
					g[206] = 10.3000000000; fxg[206] = 0.9263000000; feg[206] = 0.0217000000;
					g[207] = 10.3500000000; fxg[207] = 0.9216000000; feg[207] = 0.0215000000;
					g[208] = 10.4000000000; fxg[208] = 0.9169000000; feg[208] = 0.0213000000;
					g[209] = 10.4500000000; fxg[209] = 0.9116000000; feg[209] = 0.0211000000;
					g[210] = 10.5000000000; fxg[210] = 0.9056000000; feg[210] = 0.0209000000;
					g[211] = 10.5500000000; fxg[211] = 0.8989000000; feg[211] = 0.0207000000;
					g[212] = 10.6000000000; fxg[212] = 0.8921000000; feg[212] = 0.0205000000;
					g[213] = 10.6500000000; fxg[213] = 0.8854000000; feg[213] = 0.0204000000;
					g[214] = 10.7000000000; fxg[214] = 0.8795000000; feg[214] = 0.0202000000;
					g[215] = 10.7500000000; fxg[215] = 0.8747000000; feg[215] = 0.0200000000;
					g[216] = 10.8000000000; fxg[216] = 0.8716000000; feg[216] = 0.0198000000;
					g[217] = 10.8500000000; fxg[217] = 0.8702000000; feg[217] = 0.0196000000;
					g[218] = 10.9000000000; fxg[218] = 0.8699000000; feg[218] = 0.0194000000;
					g[219] = 10.9500000000; fxg[219] = 0.8696000000; feg[219] = 0.0193000000;
					g[220] = 11.0000000000; fxg[220] = 0.8684000000; feg[220] = 0.0191000000;
					g[221] = 11.0500000000; fxg[221] = 0.8657000000; feg[221] = 0.0189000000;
					g[222] = 11.1000000000; fxg[222] = 0.8612000000; feg[222] = 0.0188000000;
					g[223] = 11.1500000000; fxg[223] = 0.8552000000; feg[223] = 0.0186000000;
					g[224] = 11.2000000000; fxg[224] = 0.8481000000; feg[224] = 0.0184000000;
					g[225] = 11.2500000000; fxg[225] = 0.8406000000; feg[225] = 0.0183000000;
					g[226] = 11.3000000000; fxg[226] = 0.8337000000; feg[226] = 0.0181000000;
					g[227] = 11.3500000000; fxg[227] = 0.8277000000; feg[227] = 0.0180000000;
					g[228] = 11.4000000000; fxg[228] = 0.8229000000; feg[228] = 0.0178000000;
					g[229] = 11.4500000000; fxg[229] = 0.8185000000; feg[229] = 0.0177000000;
					g[230] = 11.5000000000; fxg[230] = 0.8138000000; feg[230] = 0.0175000000;
					g[231] = 11.5500000000; fxg[231] = 0.8085000000; feg[231] = 0.0174000000;
					g[232] = 11.6000000000; fxg[232] = 0.8025000000; feg[232] = 0.0172000000;
					g[233] = 11.6500000000; fxg[233] = 0.7960000000; feg[233] = 0.0171000000;
					g[234] = 11.7000000000; fxg[234] = 0.7895000000; feg[234] = 0.0169000000;
					g[235] = 11.7500000000; fxg[235] = 0.7831000000; feg[235] = 0.0168000000;
					g[236] = 11.8000000000; fxg[236] = 0.7771000000; feg[236] = 0.0167000000;
					g[237] = 11.8500000000; fxg[237] = 0.7719000000; feg[237] = 0.0165000000;
					g[238] = 11.9000000000; fxg[238] = 0.7681000000; feg[238] = 0.0164000000;
					g[239] = 11.9500000000; fxg[239] = 0.7660000000; feg[239] = 0.0162000000;
					g[240] = 12.0000000000; fxg[240] = 0.7654000000; feg[240] = 0.0161000000;
					break;
				case 26:
					g[0] = 0.0000000000; fxg[0] = 26.0000000000; feg[0] = 7.1635000000;
					g[1] = 0.0500000000; fxg[1] = 25.8163000000; feg[1] = 7.0352000000;
					g[2] = 0.1000000000; fxg[2] = 25.3023000000; feg[2] = 6.6794000000;
					g[3] = 0.1500000000; fxg[3] = 24.5501000000; feg[3] = 6.1690000000;
					g[4] = 0.2000000000; fxg[4] = 23.6647000000; feg[4] = 5.5892000000;
					g[5] = 0.2500000000; fxg[5] = 22.7293000000; feg[5] = 5.0098000000;
					g[6] = 0.3000000000; fxg[6] = 21.7936000000; feg[6] = 4.4744000000;
					g[7] = 0.3500000000; fxg[7] = 20.8795000000; feg[7] = 4.0017000000;
					g[8] = 0.4000000000; fxg[8] = 19.9924000000; feg[8] = 3.5946000000;
					g[9] = 0.4500000000; fxg[9] = 19.1316000000; feg[9] = 3.2472000000;
					g[10] = 0.5000000000; fxg[10] = 18.2947000000; feg[10] = 2.9507000000;
					g[11] = 0.5500000000; fxg[11] = 17.4810000000; feg[11] = 2.6961000000;
					g[12] = 0.6000000000; fxg[12] = 16.6911000000; feg[12] = 2.4755000000;
					g[13] = 0.6500000000; fxg[13] = 15.9269000000; feg[13] = 2.2825000000;
					g[14] = 0.7000000000; fxg[14] = 15.1910000000; feg[14] = 2.1118000000;
					g[15] = 0.7500000000; fxg[15] = 14.4860000000; feg[15] = 1.9596000000;
					g[16] = 0.8000000000; fxg[16] = 13.8143000000; feg[16] = 1.8228000000;
					g[17] = 0.8500000000; fxg[17] = 13.1778000000; feg[17] = 1.6990000000;
					g[18] = 0.9000000000; fxg[18] = 12.5780000000; feg[18] = 1.5864000000;
					g[19] = 0.9500000000; fxg[19] = 12.0156000000; feg[19] = 1.4834000000;
					g[20] = 1.0000000000; fxg[20] = 11.4907000000; feg[20] = 1.3890000000;
					g[21] = 1.0500000000; fxg[21] = 11.0028000000; feg[21] = 1.3023000000;
					g[22] = 1.1000000000; fxg[22] = 10.5513000000; feg[22] = 1.2223000000;
					g[23] = 1.1500000000; fxg[23] = 10.1347000000; feg[23] = 1.1485000000;
					g[24] = 1.2000000000; fxg[24] = 9.7515000000; feg[24] = 1.0802000000;
					g[25] = 1.2500000000; fxg[25] = 9.3998000000; feg[25] = 1.0171000000;
					g[26] = 1.3000000000; fxg[26] = 9.0778000000; feg[26] = 0.9586000000;
					g[27] = 1.3500000000; fxg[27] = 8.7832000000; feg[27] = 0.9044000000;
					g[28] = 1.4000000000; fxg[28] = 8.5139000000; feg[28] = 0.8541000000;
					g[29] = 1.4500000000; fxg[29] = 8.2678000000; feg[29] = 0.8074000000;
					g[30] = 1.5000000000; fxg[30] = 8.0427000000; feg[30] = 0.7641000000;
					g[31] = 1.5500000000; fxg[31] = 7.8366000000; feg[31] = 0.7238000000;
					g[32] = 1.6000000000; fxg[32] = 7.6475000000; feg[32] = 0.6863000000;
					g[33] = 1.6500000000; fxg[33] = 7.4736000000; feg[33] = 0.6515000000;
					g[34] = 1.7000000000; fxg[34] = 7.3129000000; feg[34] = 0.6190000000;
					g[35] = 1.7500000000; fxg[35] = 7.1640000000; feg[35] = 0.5888000000;
					g[36] = 1.8000000000; fxg[36] = 7.0254000000; feg[36] = 0.5607000000;
					g[37] = 1.8500000000; fxg[37] = 6.8955000000; feg[37] = 0.5344000000;
					g[38] = 1.9000000000; fxg[38] = 6.7733000000; feg[38] = 0.5099000000;
					g[39] = 1.9500000000; fxg[39] = 6.6575000000; feg[39] = 0.4870000000;
					g[40] = 2.0000000000; fxg[40] = 6.5473000000; feg[40] = 0.4656000000;
					g[41] = 2.0500000000; fxg[41] = 6.4416000000; feg[41] = 0.4455000000;
					g[42] = 2.1000000000; fxg[42] = 6.3397000000; feg[42] = 0.4268000000;
					g[43] = 2.1500000000; fxg[43] = 6.2410000000; feg[43] = 0.4092000000;
					g[44] = 2.2000000000; fxg[44] = 6.1449000000; feg[44] = 0.3927000000;
					g[45] = 2.2500000000; fxg[45] = 6.0508000000; feg[45] = 0.3772000000;
					g[46] = 2.3000000000; fxg[46] = 5.9583000000; feg[46] = 0.3627000000;
					g[47] = 2.3500000000; fxg[47] = 5.8670000000; feg[47] = 0.3490000000;
					g[48] = 2.4000000000; fxg[48] = 5.7769000000; feg[48] = 0.3361000000;
					g[49] = 2.4500000000; fxg[49] = 5.6876000000; feg[49] = 0.3240000000;
					g[50] = 2.5000000000; fxg[50] = 5.5988000000; feg[50] = 0.3125000000;
					g[51] = 2.5500000000; fxg[51] = 5.5102000000; feg[51] = 0.3017000000;
					g[52] = 2.6000000000; fxg[52] = 5.4220000000; feg[52] = 0.2914000000;
					g[53] = 2.6500000000; fxg[53] = 5.3343000000; feg[53] = 0.2817000000;
					g[54] = 2.7000000000; fxg[54] = 5.2471000000; feg[54] = 0.2725000000;
					g[55] = 2.7500000000; fxg[55] = 5.1600000000; feg[55] = 0.2638000000;
					g[56] = 2.8000000000; fxg[56] = 5.0727000000; feg[56] = 0.2555000000;
					g[57] = 2.8500000000; fxg[57] = 4.9855000000; feg[57] = 0.2477000000;
					g[58] = 2.9000000000; fxg[58] = 4.8989000000; feg[58] = 0.2402000000;
					g[59] = 2.9500000000; fxg[59] = 4.8131000000; feg[59] = 0.2331000000;
					g[60] = 3.0000000000; fxg[60] = 4.7279000000; feg[60] = 0.2263000000;
					g[61] = 3.0500000000; fxg[61] = 4.6427000000; feg[61] = 0.2198000000;
					g[62] = 3.1000000000; fxg[62] = 4.5576000000; feg[62] = 0.2136000000;
					g[63] = 3.1500000000; fxg[63] = 4.4728000000; feg[63] = 0.2077000000;
					g[64] = 3.2000000000; fxg[64] = 4.3890000000; feg[64] = 0.2020000000;
					g[65] = 3.2500000000; fxg[65] = 4.3067000000; feg[65] = 0.1966000000;
					g[66] = 3.3000000000; fxg[66] = 4.2256000000; feg[66] = 0.1914000000;
					g[67] = 3.3500000000; fxg[67] = 4.1451000000; feg[67] = 0.1864000000;
					g[68] = 3.4000000000; fxg[68] = 4.0648000000; feg[68] = 0.1817000000;
					g[69] = 3.4500000000; fxg[69] = 3.9849000000; feg[69] = 0.1771000000;
					g[70] = 3.5000000000; fxg[70] = 3.9061000000; feg[70] = 0.1727000000;
					g[71] = 3.5500000000; fxg[71] = 3.8291000000; feg[71] = 0.1684000000;
					g[72] = 3.6000000000; fxg[72] = 3.7541000000; feg[72] = 0.1643000000;
					g[73] = 3.6500000000; fxg[73] = 3.6808000000; feg[73] = 0.1604000000;
					g[74] = 3.7000000000; fxg[74] = 3.6084000000; feg[74] = 0.1566000000;
					g[75] = 3.7500000000; fxg[75] = 3.5363000000; feg[75] = 0.1529000000;
					g[76] = 3.8000000000; fxg[76] = 3.4648000000; feg[76] = 0.1494000000;
					g[77] = 3.8500000000; fxg[77] = 3.3945000000; feg[77] = 0.1460000000;
					g[78] = 3.9000000000; fxg[78] = 3.3261000000; feg[78] = 0.1427000000;
					g[79] = 3.9500000000; fxg[79] = 3.2601000000; feg[79] = 0.1395000000;
					g[80] = 4.0000000000; fxg[80] = 3.1964000000; feg[80] = 0.1364000000;
					g[81] = 4.0500000000; fxg[81] = 3.1343000000; feg[81] = 0.1335000000;
					g[82] = 4.1000000000; fxg[82] = 3.0731000000; feg[82] = 0.1306000000;
					g[83] = 4.1500000000; fxg[83] = 3.0122000000; feg[83] = 0.1278000000;
					g[84] = 4.2000000000; fxg[84] = 2.9519000000; feg[84] = 0.1251000000;
					g[85] = 4.2500000000; fxg[85] = 2.8928000000; feg[85] = 0.1225000000;
					g[86] = 4.3000000000; fxg[86] = 2.8357000000; feg[86] = 0.1199000000;
					g[87] = 4.3500000000; fxg[87] = 2.7810000000; feg[87] = 0.1175000000;
					g[88] = 4.4000000000; fxg[88] = 2.7289000000; feg[88] = 0.1151000000;
					g[89] = 4.4500000000; fxg[89] = 2.6788000000; feg[89] = 0.1127000000;
					g[90] = 4.5000000000; fxg[90] = 2.6298000000; feg[90] = 0.1105000000;
					g[91] = 4.5500000000; fxg[91] = 2.5812000000; feg[91] = 0.1083000000;
					g[92] = 4.6000000000; fxg[92] = 2.5328000000; feg[92] = 0.1062000000;
					g[93] = 4.6500000000; fxg[93] = 2.4851000000; feg[93] = 0.1041000000;
					g[94] = 4.7000000000; fxg[94] = 2.4385000000; feg[94] = 0.1021000000;
					g[95] = 4.7500000000; fxg[95] = 2.3937000000; feg[95] = 0.1002000000;
					g[96] = 4.8000000000; fxg[96] = 2.3512000000; feg[96] = 0.0983000000;
					g[97] = 4.8500000000; fxg[97] = 2.3112000000; feg[97] = 0.0964000000;
					g[98] = 4.9000000000; fxg[98] = 2.2734000000; feg[98] = 0.0946000000;
					g[99] = 4.9500000000; fxg[99] = 2.2368000000; feg[99] = 0.0928000000;
					g[100] = 5.0000000000; fxg[100] = 2.2004000000; feg[100] = 0.0911000000;
					g[101] = 5.0500000000; fxg[101] = 2.1640000000; feg[101] = 0.0895000000;
					g[102] = 5.1000000000; fxg[102] = 2.1277000000; feg[102] = 0.0879000000;
					g[103] = 5.1500000000; fxg[103] = 2.0922000000; feg[103] = 0.0863000000;
					g[104] = 5.2000000000; fxg[104] = 2.0576000000; feg[104] = 0.0848000000;
					g[105] = 5.2500000000; fxg[105] = 2.0244000000; feg[105] = 0.0833000000;
					g[106] = 5.3000000000; fxg[106] = 1.9932000000; feg[106] = 0.0818000000;
					g[107] = 5.3500000000; fxg[107] = 1.9643000000; feg[107] = 0.0804000000;
					g[108] = 5.4000000000; fxg[108] = 1.9375000000; feg[108] = 0.0790000000;
					g[109] = 5.4500000000; fxg[109] = 1.9120000000; feg[109] = 0.0776000000;
					g[110] = 5.5000000000; fxg[110] = 1.8866000000; feg[110] = 0.0763000000;
					g[111] = 5.5500000000; fxg[111] = 1.8607000000; feg[111] = 0.0750000000;
					g[112] = 5.6000000000; fxg[112] = 1.8347000000; feg[112] = 0.0738000000;
					g[113] = 5.6500000000; fxg[113] = 1.8089000000; feg[113] = 0.0725000000;
					g[114] = 5.7000000000; fxg[114] = 1.7838000000; feg[114] = 0.0714000000;
					g[115] = 5.7500000000; fxg[115] = 1.7593000000; feg[115] = 0.0702000000;
					g[116] = 5.8000000000; fxg[116] = 1.7358000000; feg[116] = 0.0691000000;
					g[117] = 5.8500000000; fxg[117] = 1.7137000000; feg[117] = 0.0679000000;
					g[118] = 5.9000000000; fxg[118] = 1.6935000000; feg[118] = 0.0668000000;
					g[119] = 5.9500000000; fxg[119] = 1.6755000000; feg[119] = 0.0658000000;
					g[120] = 6.0000000000; fxg[120] = 1.6588000000; feg[120] = 0.0647000000;
					g[121] = 6.0500000000; fxg[121] = 1.6423000000; feg[121] = 0.0637000000;
					g[122] = 6.1000000000; fxg[122] = 1.6252000000; feg[122] = 0.0627000000;
					g[123] = 6.1500000000; fxg[123] = 1.6073000000; feg[123] = 0.0617000000;
					g[124] = 6.2000000000; fxg[124] = 1.5892000000; feg[124] = 0.0608000000;
					g[125] = 6.2500000000; fxg[125] = 1.5715000000; feg[125] = 0.0599000000;
					g[126] = 6.3000000000; fxg[126] = 1.5543000000; feg[126] = 0.0590000000;
					g[127] = 6.3500000000; fxg[127] = 1.5374000000; feg[127] = 0.0581000000;
					g[128] = 6.4000000000; fxg[128] = 1.5210000000; feg[128] = 0.0572000000;
					g[129] = 6.4500000000; fxg[129] = 1.5054000000; feg[129] = 0.0564000000;
					g[130] = 6.5000000000; fxg[130] = 1.4912000000; feg[130] = 0.0555000000;
					g[131] = 6.5500000000; fxg[131] = 1.4790000000; feg[131] = 0.0547000000;
					g[132] = 6.6000000000; fxg[132] = 1.4685000000; feg[132] = 0.0539000000;
					g[133] = 6.6500000000; fxg[133] = 1.4586000000; feg[133] = 0.0531000000;
					g[134] = 6.7000000000; fxg[134] = 1.4482000000; feg[134] = 0.0524000000;
					g[135] = 6.7500000000; fxg[135] = 1.4367000000; feg[135] = 0.0516000000;
					g[136] = 6.8000000000; fxg[136] = 1.4242000000; feg[136] = 0.0509000000;
					g[137] = 6.8500000000; fxg[137] = 1.4115000000; feg[137] = 0.0502000000;
					g[138] = 6.9000000000; fxg[138] = 1.3992000000; feg[138] = 0.0495000000;
					g[139] = 6.9500000000; fxg[139] = 1.3875000000; feg[139] = 0.0488000000;
					g[140] = 7.0000000000; fxg[140] = 1.3759000000; feg[140] = 0.0481000000;
					g[141] = 7.0500000000; fxg[141] = 1.3643000000; feg[141] = 0.0475000000;
					g[142] = 7.1000000000; fxg[142] = 1.3529000000; feg[142] = 0.0468000000;
					g[143] = 7.1500000000; fxg[143] = 1.3421000000; feg[143] = 0.0462000000;
					g[144] = 7.2000000000; fxg[144] = 1.3329000000; feg[144] = 0.0456000000;
					g[145] = 7.2500000000; fxg[145] = 1.3254000000; feg[145] = 0.0449000000;
					g[146] = 7.3000000000; fxg[146] = 1.3194000000; feg[146] = 0.0443000000;
					g[147] = 7.3500000000; fxg[147] = 1.3138000000; feg[147] = 0.0437000000;
					g[148] = 7.4000000000; fxg[148] = 1.3075000000; feg[148] = 0.0432000000;
					g[149] = 7.4500000000; fxg[149] = 1.2996000000; feg[149] = 0.0426000000;
					g[150] = 7.5000000000; fxg[150] = 1.2906000000; feg[150] = 0.0421000000;
					g[151] = 7.5500000000; fxg[151] = 1.2810000000; feg[151] = 0.0415000000;
					g[152] = 7.6000000000; fxg[152] = 1.2718000000; feg[152] = 0.0410000000;
					g[153] = 7.6500000000; fxg[153] = 1.2633000000; feg[153] = 0.0405000000;
					g[154] = 7.7000000000; fxg[154] = 1.2552000000; feg[154] = 0.0400000000;
					g[155] = 7.7500000000; fxg[155] = 1.2470000000; feg[155] = 0.0395000000;
					g[156] = 7.8000000000; fxg[156] = 1.2383000000; feg[156] = 0.0390000000;
					g[157] = 7.8500000000; fxg[157] = 1.2295000000; feg[157] = 0.0385000000;
					g[158] = 7.9000000000; fxg[158] = 1.2212000000; feg[158] = 0.0380000000;
					g[159] = 7.9500000000; fxg[159] = 1.2142000000; feg[159] = 0.0375000000;
					g[160] = 8.0000000000; fxg[160] = 1.2088000000; feg[160] = 0.0371000000;
					g[161] = 8.0500000000; fxg[161] = 1.2051000000; feg[161] = 0.0366000000;
					g[162] = 8.1000000000; fxg[162] = 1.2020000000; feg[162] = 0.0362000000;
					g[163] = 8.1500000000; fxg[163] = 1.1986000000; feg[163] = 0.0357000000;
					g[164] = 8.2000000000; fxg[164] = 1.1937000000; feg[164] = 0.0353000000;
					g[165] = 8.2500000000; fxg[165] = 1.1871000000; feg[165] = 0.0349000000;
					g[166] = 8.3000000000; fxg[166] = 1.1794000000; feg[166] = 0.0345000000;
					g[167] = 8.3500000000; fxg[167] = 1.1715000000; feg[167] = 0.0341000000;
					g[168] = 8.4000000000; fxg[168] = 1.1641000000; feg[168] = 0.0337000000;
					g[169] = 8.4500000000; fxg[169] = 1.1575000000; feg[169] = 0.0333000000;
					g[170] = 8.5000000000; fxg[170] = 1.1514000000; feg[170] = 0.0329000000;
					g[171] = 8.5500000000; fxg[171] = 1.1451000000; feg[171] = 0.0325000000;
					g[172] = 8.6000000000; fxg[172] = 1.1382000000; feg[172] = 0.0322000000;
					g[173] = 8.6500000000; fxg[173] = 1.1308000000; feg[173] = 0.0318000000;
					g[174] = 8.7000000000; fxg[174] = 1.1234000000; feg[174] = 0.0315000000;
					g[175] = 8.7500000000; fxg[175] = 1.1166000000; feg[175] = 0.0311000000;
					g[176] = 8.8000000000; fxg[176] = 1.1111000000; feg[176] = 0.0308000000;
					g[177] = 8.8500000000; fxg[177] = 1.1074000000; feg[177] = 0.0304000000;
					g[178] = 8.9000000000; fxg[178] = 1.1051000000; feg[178] = 0.0301000000;
					g[179] = 8.9500000000; fxg[179] = 1.1035000000; feg[179] = 0.0298000000;
					g[180] = 9.0000000000; fxg[180] = 1.1014000000; feg[180] = 0.0294000000;
					g[181] = 9.0500000000; fxg[181] = 1.0979000000; feg[181] = 0.0291000000;
					g[182] = 9.1000000000; fxg[182] = 1.0926000000; feg[182] = 0.0288000000;
					g[183] = 9.1500000000; fxg[183] = 1.0859000000; feg[183] = 0.0285000000;
					g[184] = 9.2000000000; fxg[184] = 1.0785000000; feg[184] = 0.0282000000;
					g[185] = 9.2500000000; fxg[185] = 1.0713000000; feg[185] = 0.0279000000;
					g[186] = 9.3000000000; fxg[186] = 1.0651000000; feg[186] = 0.0276000000;
					g[187] = 9.3500000000; fxg[187] = 1.0597000000; feg[187] = 0.0273000000;
					g[188] = 9.4000000000; fxg[188] = 1.0546000000; feg[188] = 0.0270000000;
					g[189] = 9.4500000000; fxg[189] = 1.0492000000; feg[189] = 0.0267000000;
					g[190] = 9.5000000000; fxg[190] = 1.0430000000; feg[190] = 0.0265000000;
					g[191] = 9.5500000000; fxg[191] = 1.0363000000; feg[191] = 0.0262000000;
					g[192] = 9.6000000000; fxg[192] = 1.0294000000; feg[192] = 0.0259000000;
					g[193] = 9.6500000000; fxg[193] = 1.0227000000; feg[193] = 0.0257000000;
					g[194] = 9.7000000000; fxg[194] = 1.0171000000; feg[194] = 0.0254000000;
					g[195] = 9.7500000000; fxg[195] = 1.0129000000; feg[195] = 0.0252000000;
					g[196] = 9.8000000000; fxg[196] = 1.0105000000; feg[196] = 0.0249000000;
					g[197] = 9.8500000000; fxg[197] = 1.0093000000; feg[197] = 0.0247000000;
					g[198] = 9.9000000000; fxg[198] = 1.0085000000; feg[198] = 0.0244000000;
					g[199] = 9.9500000000; fxg[199] = 1.0069000000; feg[199] = 0.0242000000;
					g[200] = 10.0000000000; fxg[200] = 1.0039000000; feg[200] = 0.0239000000;
					g[201] = 10.0500000000; fxg[201] = 0.9992000000; feg[201] = 0.0237000000;
					g[202] = 10.1000000000; fxg[202] = 0.9929000000; feg[202] = 0.0235000000;
					g[203] = 10.1500000000; fxg[203] = 0.9857000000; feg[203] = 0.0232000000;
					g[204] = 10.2000000000; fxg[204] = 0.9785000000; feg[204] = 0.0230000000;
					g[205] = 10.2500000000; fxg[205] = 0.9721000000; feg[205] = 0.0228000000;
					g[206] = 10.3000000000; fxg[206] = 0.9667000000; feg[206] = 0.0226000000;
					g[207] = 10.3500000000; fxg[207] = 0.9619000000; feg[207] = 0.0224000000;
					g[208] = 10.4000000000; fxg[208] = 0.9573000000; feg[208] = 0.0222000000;
					g[209] = 10.4500000000; fxg[209] = 0.9521000000; feg[209] = 0.0220000000;
					g[210] = 10.5000000000; fxg[210] = 0.9461000000; feg[210] = 0.0218000000;
					g[211] = 10.5500000000; fxg[211] = 0.9397000000; feg[211] = 0.0216000000;
					g[212] = 10.6000000000; fxg[212] = 0.9330000000; feg[212] = 0.0214000000;
					g[213] = 10.6500000000; fxg[213] = 0.9265000000; feg[213] = 0.0212000000;
					g[214] = 10.7000000000; fxg[214] = 0.9207000000; feg[214] = 0.0210000000;
					g[215] = 10.7500000000; fxg[215] = 0.9161000000; feg[215] = 0.0208000000;
					g[216] = 10.8000000000; fxg[216] = 0.9131000000; feg[216] = 0.0206000000;
					g[217] = 10.8500000000; fxg[217] = 0.9117000000; feg[217] = 0.0204000000;
					g[218] = 10.9000000000; fxg[218] = 0.9113000000; feg[218] = 0.0202000000;
					g[219] = 10.9500000000; fxg[219] = 0.9109000000; feg[219] = 0.0200000000;
					g[220] = 11.0000000000; fxg[220] = 0.9098000000; feg[220] = 0.0199000000;
					g[221] = 11.0500000000; fxg[221] = 0.9071000000; feg[221] = 0.0197000000;
					g[222] = 11.1000000000; fxg[222] = 0.9027000000; feg[222] = 0.0195000000;
					g[223] = 11.1500000000; fxg[223] = 0.8969000000; feg[223] = 0.0193000000;
					g[224] = 11.2000000000; fxg[224] = 0.8900000000; feg[224] = 0.0192000000;
					g[225] = 11.2500000000; fxg[225] = 0.8827000000; feg[225] = 0.0190000000;
					g[226] = 11.3000000000; fxg[226] = 0.8759000000; feg[226] = 0.0188000000;
					g[227] = 11.3500000000; fxg[227] = 0.8701000000; feg[227] = 0.0187000000;
					g[228] = 11.4000000000; fxg[228] = 0.8652000000; feg[228] = 0.0185000000;
					g[229] = 11.4500000000; fxg[229] = 0.8609000000; feg[229] = 0.0184000000;
					g[230] = 11.5000000000; fxg[230] = 0.8563000000; feg[230] = 0.0182000000;
					g[231] = 11.5500000000; fxg[231] = 0.8511000000; feg[231] = 0.0180000000;
					g[232] = 11.6000000000; fxg[232] = 0.8452000000; feg[232] = 0.0179000000;
					g[233] = 11.6500000000; fxg[233] = 0.8389000000; feg[233] = 0.0177000000;
					g[234] = 11.7000000000; fxg[234] = 0.8324000000; feg[234] = 0.0176000000;
					g[235] = 11.7500000000; fxg[235] = 0.8261000000; feg[235] = 0.0175000000;
					g[236] = 11.8000000000; fxg[236] = 0.8202000000; feg[236] = 0.0173000000;
					g[237] = 11.8500000000; fxg[237] = 0.8152000000; feg[237] = 0.0172000000;
					g[238] = 11.9000000000; fxg[238] = 0.8115000000; feg[238] = 0.0170000000;
					g[239] = 11.9500000000; fxg[239] = 0.8094000000; feg[239] = 0.0169000000;
					g[240] = 12.0000000000; fxg[240] = 0.8087000000; feg[240] = 0.0167000000;
					break;
				case 27:
					g[0] = 0.0000000000; fxg[0] = 27.0000000000; feg[0] = 6.8508000000;
					g[1] = 0.0500000000; fxg[1] = 26.8241000000; feg[1] = 6.7363000000;
					g[2] = 0.1000000000; fxg[2] = 26.3297000000; feg[2] = 6.4175000000;
					g[3] = 0.1500000000; fxg[3] = 25.6000000000; feg[3] = 5.9570000000;
					g[4] = 0.2000000000; fxg[4] = 24.7317000000; feg[4] = 5.4289000000;
					g[5] = 0.2500000000; fxg[5] = 23.8040000000; feg[5] = 4.8955000000;
					g[6] = 0.3000000000; fxg[6] = 22.8663000000; feg[6] = 4.3971000000;
					g[7] = 0.3500000000; fxg[7] = 21.9426000000; feg[7] = 3.9524000000;
					g[8] = 0.4000000000; fxg[8] = 21.0407000000; feg[8] = 3.5657000000;
					g[9] = 0.4500000000; fxg[9] = 20.1614000000; feg[9] = 3.2330000000;
					g[10] = 0.5000000000; fxg[10] = 19.3037000000; feg[10] = 2.9472000000;
					g[11] = 0.5500000000; fxg[11] = 18.4672000000; feg[11] = 2.7004000000;
					g[12] = 0.6000000000; fxg[12] = 17.6527000000; feg[12] = 2.4857000000;
					g[13] = 0.6500000000; fxg[13] = 16.8621000000; feg[13] = 2.2972000000;
					g[14] = 0.7000000000; fxg[14] = 16.0978000000; feg[14] = 2.1300000000;
					g[15] = 0.7500000000; fxg[15] = 15.3626000000; feg[15] = 1.9806000000;
					g[16] = 0.8000000000; fxg[16] = 14.6589000000; feg[16] = 1.8460000000;
					g[17] = 0.8500000000; fxg[17] = 13.9889000000; feg[17] = 1.7240000000;
					g[18] = 0.9000000000; fxg[18] = 13.3540000000; feg[18] = 1.6128000000;
					g[19] = 0.9500000000; fxg[19] = 12.7553000000; feg[19] = 1.5110000000;
					g[20] = 1.0000000000; fxg[20] = 12.1933000000; feg[20] = 1.4175000000;
					g[21] = 1.0500000000; fxg[21] = 11.6679000000; feg[21] = 1.3313000000;
					g[22] = 1.1000000000; fxg[22] = 11.1787000000; feg[22] = 1.2518000000;
					g[23] = 1.1500000000; fxg[23] = 10.7246000000; feg[23] = 1.1782000000;
					g[24] = 1.2000000000; fxg[24] = 10.3046000000; feg[24] = 1.1100000000;
					g[25] = 1.2500000000; fxg[25] = 9.9170000000; feg[25] = 1.0467000000;
					g[26] = 1.3000000000; fxg[26] = 9.5601000000; feg[26] = 0.9879000000;
					g[27] = 1.3500000000; fxg[27] = 9.2321000000; feg[27] = 0.9333000000;
					g[28] = 1.4000000000; fxg[28] = 8.9312000000; feg[28] = 0.8826000000;
					g[29] = 1.4500000000; fxg[29] = 8.6551000000; feg[29] = 0.8353000000;
					g[30] = 1.5000000000; fxg[30] = 8.4021000000; feg[30] = 0.7913000000;
					g[31] = 1.5500000000; fxg[31] = 8.1701000000; feg[31] = 0.7503000000;
					g[32] = 1.6000000000; fxg[32] = 7.9572000000; feg[32] = 0.7121000000;
					g[33] = 1.6500000000; fxg[33] = 7.7616000000; feg[33] = 0.6765000000;
					g[34] = 1.7000000000; fxg[34] = 7.5814000000; feg[34] = 0.6433000000;
					g[35] = 1.7500000000; fxg[35] = 7.4151000000; feg[35] = 0.6122000000;
					g[36] = 1.8000000000; fxg[36] = 7.2611000000; feg[36] = 0.5832000000;
					g[37] = 1.8500000000; fxg[37] = 7.1179000000; feg[37] = 0.5561000000;
					g[38] = 1.9000000000; fxg[38] = 6.9841000000; feg[38] = 0.5308000000;
					g[39] = 1.9500000000; fxg[39] = 6.8587000000; feg[39] = 0.5071000000;
					g[40] = 2.0000000000; fxg[40] = 6.7405000000; feg[40] = 0.4849000000;
					g[41] = 2.0500000000; fxg[41] = 6.6284000000; feg[41] = 0.4641000000;
					g[42] = 2.1000000000; fxg[42] = 6.5215000000; feg[42] = 0.4446000000;
					g[43] = 2.1500000000; fxg[43] = 6.4191000000; feg[43] = 0.4262000000;
					g[44] = 2.2000000000; fxg[44] = 6.3206000000; feg[44] = 0.4090000000;
					g[45] = 2.2500000000; fxg[45] = 6.2251000000; feg[45] = 0.3929000000;
					g[46] = 2.3000000000; fxg[46] = 6.1322000000; feg[46] = 0.3777000000;
					g[47] = 2.3500000000; fxg[47] = 6.0413000000; feg[47] = 0.3633000000;
					g[48] = 2.4000000000; fxg[48] = 5.9524000000; feg[48] = 0.3498000000;
					g[49] = 2.4500000000; fxg[49] = 5.8649000000; feg[49] = 0.3371000000;
					g[50] = 2.5000000000; fxg[50] = 5.7783000000; feg[50] = 0.3251000000;
					g[51] = 2.5500000000; fxg[51] = 5.6925000000; feg[51] = 0.3137000000;
					g[52] = 2.6000000000; fxg[52] = 5.6074000000; feg[52] = 0.3030000000;
					g[53] = 2.6500000000; fxg[53] = 5.5230000000; feg[53] = 0.2928000000;
					g[54] = 2.7000000000; fxg[54] = 5.4393000000; feg[54] = 0.2831000000;
					g[55] = 2.7500000000; fxg[55] = 5.3557000000; feg[55] = 0.2740000000;
					g[56] = 2.8000000000; fxg[56] = 5.2721000000; feg[56] = 0.2653000000;
					g[57] = 2.8500000000; fxg[57] = 5.1887000000; feg[57] = 0.2571000000;
					g[58] = 2.9000000000; fxg[58] = 5.1057000000; feg[58] = 0.2492000000;
					g[59] = 2.9500000000; fxg[59] = 5.0234000000; feg[59] = 0.2418000000;
					g[60] = 3.0000000000; fxg[60] = 4.9415000000; feg[60] = 0.2346000000;
					g[61] = 3.0500000000; fxg[61] = 4.8595000000; feg[61] = 0.2279000000;
					g[62] = 3.1000000000; fxg[62] = 4.7774000000; feg[62] = 0.2214000000;
					g[63] = 3.1500000000; fxg[63] = 4.6955000000; feg[63] = 0.2152000000;
					g[64] = 3.2000000000; fxg[64] = 4.6144000000; feg[64] = 0.2093000000;
					g[65] = 3.2500000000; fxg[65] = 4.5343000000; feg[65] = 0.2036000000;
					g[66] = 3.3000000000; fxg[66] = 4.4551000000; feg[66] = 0.1982000000;
					g[67] = 3.3500000000; fxg[67] = 4.3763000000; feg[67] = 0.1930000000;
					g[68] = 3.4000000000; fxg[68] = 4.2975000000; feg[68] = 0.1880000000;
					g[69] = 3.4500000000; fxg[69] = 4.2189000000; feg[69] = 0.1832000000;
					g[70] = 3.5000000000; fxg[70] = 4.1411000000; feg[70] = 0.1786000000;
					g[71] = 3.5500000000; fxg[71] = 4.0647000000; feg[71] = 0.1742000000;
					g[72] = 3.6000000000; fxg[72] = 3.9900000000; feg[72] = 0.1700000000;
					g[73] = 3.6500000000; fxg[73] = 3.9166000000; feg[73] = 0.1659000000;
					g[74] = 3.7000000000; fxg[74] = 3.8439000000; feg[74] = 0.1619000000;
					g[75] = 3.7500000000; fxg[75] = 3.7714000000; feg[75] = 0.1581000000;
					g[76] = 3.8000000000; fxg[76] = 3.6992000000; feg[76] = 0.1545000000;
					g[77] = 3.8500000000; fxg[77] = 3.6280000000; feg[77] = 0.1510000000;
					g[78] = 3.9000000000; fxg[78] = 3.5585000000; feg[78] = 0.1475000000;
					g[79] = 3.9500000000; fxg[79] = 3.4910000000; feg[79] = 0.1442000000;
					g[80] = 4.0000000000; fxg[80] = 3.4256000000; feg[80] = 0.1411000000;
					g[81] = 4.0500000000; fxg[81] = 3.3615000000; feg[81] = 0.1380000000;
					g[82] = 4.1000000000; fxg[82] = 3.2981000000; feg[82] = 0.1350000000;
					g[83] = 4.1500000000; fxg[83] = 3.2351000000; feg[83] = 0.1321000000;
					g[84] = 4.2000000000; fxg[84] = 3.1725000000; feg[84] = 0.1293000000;
					g[85] = 4.2500000000; fxg[85] = 3.1111000000; feg[85] = 0.1266000000;
					g[86] = 4.3000000000; fxg[86] = 3.0513000000; feg[86] = 0.1240000000;
					g[87] = 4.3500000000; fxg[87] = 2.9939000000; feg[87] = 0.1215000000;
					g[88] = 4.4000000000; fxg[88] = 2.9388000000; feg[88] = 0.1190000000;
					g[89] = 4.4500000000; fxg[89] = 2.8855000000; feg[89] = 0.1166000000;
					g[90] = 4.5000000000; fxg[90] = 2.8333000000; feg[90] = 0.1143000000;
					g[91] = 4.5500000000; fxg[91] = 2.7814000000; feg[91] = 0.1120000000;
					g[92] = 4.6000000000; fxg[92] = 2.7298000000; feg[92] = 0.1098000000;
					g[93] = 4.6500000000; fxg[93] = 2.6789000000; feg[93] = 0.1077000000;
					g[94] = 4.7000000000; fxg[94] = 2.6290000000; feg[94] = 0.1056000000;
					g[95] = 4.7500000000; fxg[95] = 2.5809000000; feg[95] = 0.1036000000;
					g[96] = 4.8000000000; fxg[96] = 2.5349000000; feg[96] = 0.1017000000;
					g[97] = 4.8500000000; fxg[97] = 2.4914000000; feg[97] = 0.0997000000;
					g[98] = 4.9000000000; fxg[98] = 2.4499000000; feg[98] = 0.0979000000;
					g[99] = 4.9500000000; fxg[99] = 2.4096000000; feg[99] = 0.0961000000;
					g[100] = 5.0000000000; fxg[100] = 2.3696000000; feg[100] = 0.0943000000;
					g[101] = 5.0500000000; fxg[101] = 2.3297000000; feg[101] = 0.0926000000;
					g[102] = 5.1000000000; fxg[102] = 2.2900000000; feg[102] = 0.0909000000;
					g[103] = 5.1500000000; fxg[103] = 2.2510000000; feg[103] = 0.0893000000;
					g[104] = 5.2000000000; fxg[104] = 2.2130000000; feg[104] = 0.0878000000;
					g[105] = 5.2500000000; fxg[105] = 2.1765000000; feg[105] = 0.0862000000;
					g[106] = 5.3000000000; fxg[106] = 2.1419000000; feg[106] = 0.0847000000;
					g[107] = 5.3500000000; fxg[107] = 2.1095000000; feg[107] = 0.0833000000;
					g[108] = 5.4000000000; fxg[108] = 2.0792000000; feg[108] = 0.0818000000;
					g[109] = 5.4500000000; fxg[109] = 2.0502000000; feg[109] = 0.0804000000;
					g[110] = 5.5000000000; fxg[110] = 2.0214000000; feg[110] = 0.0791000000;
					g[111] = 5.5500000000; fxg[111] = 1.9924000000; feg[111] = 0.0777000000;
					g[112] = 5.6000000000; fxg[112] = 1.9632000000; feg[112] = 0.0764000000;
					g[113] = 5.6500000000; fxg[113] = 1.9343000000; feg[113] = 0.0752000000;
					g[114] = 5.7000000000; fxg[114] = 1.9061000000; feg[114] = 0.0739000000;
					g[115] = 5.7500000000; fxg[115] = 1.8787000000; feg[115] = 0.0727000000;
					g[116] = 5.8000000000; fxg[116] = 1.8523000000; feg[116] = 0.0716000000;
					g[117] = 5.8500000000; fxg[117] = 1.8273000000; feg[117] = 0.0704000000;
					g[118] = 5.9000000000; fxg[118] = 1.8044000000; feg[118] = 0.0693000000;
					g[119] = 5.9500000000; fxg[119] = 1.7835000000; feg[119] = 0.0682000000;
					g[120] = 6.0000000000; fxg[120] = 1.7639000000; feg[120] = 0.0671000000;
					g[121] = 6.0500000000; fxg[121] = 1.7446000000; feg[121] = 0.0661000000;
					g[122] = 6.1000000000; fxg[122] = 1.7249000000; feg[122] = 0.0650000000;
					g[123] = 6.1500000000; fxg[123] = 1.7046000000; feg[123] = 0.0640000000;
					g[124] = 6.2000000000; fxg[124] = 1.6841000000; feg[124] = 0.0630000000;
					g[125] = 6.2500000000; fxg[125] = 1.6640000000; feg[125] = 0.0621000000;
					g[126] = 6.3000000000; fxg[126] = 1.6444000000; feg[126] = 0.0612000000;
					g[127] = 6.3500000000; fxg[127] = 1.6253000000; feg[127] = 0.0602000000;
					g[128] = 6.4000000000; fxg[128] = 1.6067000000; feg[128] = 0.0594000000;
					g[129] = 6.4500000000; fxg[129] = 1.5891000000; feg[129] = 0.0585000000;
					g[130] = 6.5000000000; fxg[130] = 1.5729000000; feg[130] = 0.0576000000;
					g[131] = 6.5500000000; fxg[131] = 1.5587000000; feg[131] = 0.0568000000;
					g[132] = 6.6000000000; fxg[132] = 1.5461000000; feg[132] = 0.0559000000;
					g[133] = 6.6500000000; fxg[133] = 1.5341000000; feg[133] = 0.0551000000;
					g[134] = 6.7000000000; fxg[134] = 1.5219000000; feg[134] = 0.0543000000;
					g[135] = 6.7500000000; fxg[135] = 1.5086000000; feg[135] = 0.0536000000;
					g[136] = 6.8000000000; fxg[136] = 1.4946000000; feg[136] = 0.0528000000;
					g[137] = 6.8500000000; fxg[137] = 1.4803000000; feg[137] = 0.0521000000;
					g[138] = 6.9000000000; fxg[138] = 1.4664000000; feg[138] = 0.0513000000;
					g[139] = 6.9500000000; fxg[139] = 1.4531000000; feg[139] = 0.0506000000;
					g[140] = 7.0000000000; fxg[140] = 1.4400000000; feg[140] = 0.0499000000;
					g[141] = 7.0500000000; fxg[141] = 1.4270000000; feg[141] = 0.0493000000;
					g[142] = 7.1000000000; fxg[142] = 1.4143000000; feg[142] = 0.0486000000;
					g[143] = 7.1500000000; fxg[143] = 1.4024000000; feg[143] = 0.0479000000;
					g[144] = 7.2000000000; fxg[144] = 1.3919000000; feg[144] = 0.0473000000;
					g[145] = 7.2500000000; fxg[145] = 1.3832000000; feg[145] = 0.0467000000;
					g[146] = 7.3000000000; fxg[146] = 1.3759000000; feg[146] = 0.0460000000;
					g[147] = 7.3500000000; fxg[147] = 1.3690000000; feg[147] = 0.0454000000;
					g[148] = 7.4000000000; fxg[148] = 1.3615000000; feg[148] = 0.0448000000;
					g[149] = 7.4500000000; fxg[149] = 1.3527000000; feg[149] = 0.0442000000;
					g[150] = 7.5000000000; fxg[150] = 1.3428000000; feg[150] = 0.0437000000;
					g[151] = 7.5500000000; fxg[151] = 1.3325000000; feg[151] = 0.0431000000;
					g[152] = 7.6000000000; fxg[152] = 1.3224000000; feg[152] = 0.0426000000;
					g[153] = 7.6500000000; fxg[153] = 1.3130000000; feg[153] = 0.0420000000;
					g[154] = 7.7000000000; fxg[154] = 1.3040000000; feg[154] = 0.0415000000;
					g[155] = 7.7500000000; fxg[155] = 1.2949000000; feg[155] = 0.0410000000;
					g[156] = 7.8000000000; fxg[156] = 1.2855000000; feg[156] = 0.0405000000;
					g[157] = 7.8500000000; fxg[157] = 1.2761000000; feg[157] = 0.0400000000;
					g[158] = 7.9000000000; fxg[158] = 1.2673000000; feg[158] = 0.0395000000;
					g[159] = 7.9500000000; fxg[159] = 1.2597000000; feg[159] = 0.0390000000;
					g[160] = 8.0000000000; fxg[160] = 1.2537000000; feg[160] = 0.0385000000;
					g[161] = 8.0500000000; fxg[161] = 1.2493000000; feg[161] = 0.0380000000;
					g[162] = 8.1000000000; fxg[162] = 1.2456000000; feg[162] = 0.0376000000;
					g[163] = 8.1500000000; fxg[163] = 1.2414000000; feg[163] = 0.0371000000;
					g[164] = 8.2000000000; fxg[164] = 1.2361000000; feg[164] = 0.0367000000;
					g[165] = 8.2500000000; fxg[165] = 1.2292000000; feg[165] = 0.0362000000;
					g[166] = 8.3000000000; fxg[166] = 1.2212000000; feg[166] = 0.0358000000;
					g[167] = 8.3500000000; fxg[167] = 1.2130000000; feg[167] = 0.0354000000;
					g[168] = 8.4000000000; fxg[168] = 1.2053000000; feg[168] = 0.0350000000;
					g[169] = 8.4500000000; fxg[169] = 1.1982000000; feg[169] = 0.0346000000;
					g[170] = 8.5000000000; fxg[170] = 1.1917000000; feg[170] = 0.0342000000;
					g[171] = 8.5500000000; fxg[171] = 1.1849000000; feg[171] = 0.0338000000;
					g[172] = 8.6000000000; fxg[172] = 1.1778000000; feg[172] = 0.0334000000;
					g[173] = 8.6500000000; fxg[173] = 1.1702000000; feg[173] = 0.0330000000;
					g[174] = 8.7000000000; fxg[174] = 1.1626000000; feg[174] = 0.0327000000;
					g[175] = 8.7500000000; fxg[175] = 1.1557000000; feg[175] = 0.0323000000;
					g[176] = 8.8000000000; fxg[176] = 1.1501000000; feg[176] = 0.0320000000;
					g[177] = 8.8500000000; fxg[177] = 1.1461000000; feg[177] = 0.0316000000;
					g[178] = 8.9000000000; fxg[178] = 1.1436000000; feg[178] = 0.0313000000;
					g[179] = 8.9500000000; fxg[179] = 1.1417000000; feg[179] = 0.0309000000;
					g[180] = 9.0000000000; fxg[180] = 1.1393000000; feg[180] = 0.0306000000;
					g[181] = 9.0500000000; fxg[181] = 1.1356000000; feg[181] = 0.0302000000;
					g[182] = 9.1000000000; fxg[182] = 1.1303000000; feg[182] = 0.0299000000;
					g[183] = 9.1500000000; fxg[183] = 1.1236000000; feg[183] = 0.0296000000;
					g[184] = 9.2000000000; fxg[184] = 1.1163000000; feg[184] = 0.0293000000;
					g[185] = 9.2500000000; fxg[185] = 1.1092000000; feg[185] = 0.0290000000;
					g[186] = 9.3000000000; fxg[186] = 1.1029000000; feg[186] = 0.0287000000;
					g[187] = 9.3500000000; fxg[187] = 1.0973000000; feg[187] = 0.0284000000;
					g[188] = 9.4000000000; fxg[188] = 1.0921000000; feg[188] = 0.0281000000;
					g[189] = 9.4500000000; fxg[189] = 1.0865000000; feg[189] = 0.0278000000;
					g[190] = 9.5000000000; fxg[190] = 1.0804000000; feg[190] = 0.0275000000;
					g[191] = 9.5500000000; fxg[191] = 1.0737000000; feg[191] = 0.0272000000;
					g[192] = 9.6000000000; fxg[192] = 1.0668000000; feg[192] = 0.0269000000;
					g[193] = 9.6500000000; fxg[193] = 1.0603000000; feg[193] = 0.0267000000;
					g[194] = 9.7000000000; fxg[194] = 1.0547000000; feg[194] = 0.0264000000;
					g[195] = 9.7500000000; fxg[195] = 1.0506000000; feg[195] = 0.0261000000;
					g[196] = 9.8000000000; fxg[196] = 1.0481000000; feg[196] = 0.0259000000;
					g[197] = 9.8500000000; fxg[197] = 1.0469000000; feg[197] = 0.0256000000;
					g[198] = 9.9000000000; fxg[198] = 1.0459000000; feg[198] = 0.0254000000;
					g[199] = 9.9500000000; fxg[199] = 1.0443000000; feg[199] = 0.0251000000;
					g[200] = 10.0000000000; fxg[200] = 1.0413000000; feg[200] = 0.0249000000;
					g[201] = 10.0500000000; fxg[201] = 1.0366000000; feg[201] = 0.0246000000;
					g[202] = 10.1000000000; fxg[202] = 1.0305000000; feg[202] = 0.0244000000;
					g[203] = 10.1500000000; fxg[203] = 1.0235000000; feg[203] = 0.0241000000;
					g[204] = 10.2000000000; fxg[204] = 1.0166000000; feg[204] = 0.0239000000;
					g[205] = 10.2500000000; fxg[205] = 1.0103000000; feg[205] = 0.0237000000;
					g[206] = 10.3000000000; fxg[206] = 1.0049000000; feg[206] = 0.0235000000;
					g[207] = 10.3500000000; fxg[207] = 1.0001000000; feg[207] = 0.0232000000;
					g[208] = 10.4000000000; fxg[208] = 0.9954000000; feg[208] = 0.0230000000;
					g[209] = 10.4500000000; fxg[209] = 0.9903000000; feg[209] = 0.0228000000;
					g[210] = 10.5000000000; fxg[210] = 0.9844000000; feg[210] = 0.0226000000;
					g[211] = 10.5500000000; fxg[211] = 0.9781000000; feg[211] = 0.0224000000;
					g[212] = 10.6000000000; fxg[212] = 0.9715000000; feg[212] = 0.0222000000;
					g[213] = 10.6500000000; fxg[213] = 0.9652000000; feg[213] = 0.0220000000;
					g[214] = 10.7000000000; fxg[214] = 0.9596000000; feg[214] = 0.0218000000;
					g[215] = 10.7500000000; fxg[215] = 0.9551000000; feg[215] = 0.0216000000;
					g[216] = 10.8000000000; fxg[216] = 0.9522000000; feg[216] = 0.0214000000;
					g[217] = 10.8500000000; fxg[217] = 0.9508000000; feg[217] = 0.0212000000;
					g[218] = 10.9000000000; fxg[218] = 0.9503000000; feg[218] = 0.0210000000;
					g[219] = 10.9500000000; fxg[219] = 0.9499000000; feg[219] = 0.0208000000;
					g[220] = 11.0000000000; fxg[220] = 0.9487000000; feg[220] = 0.0206000000;
					g[221] = 11.0500000000; fxg[221] = 0.9461000000; feg[221] = 0.0204000000;
					g[222] = 11.1000000000; fxg[222] = 0.9419000000; feg[222] = 0.0202000000;
					g[223] = 11.1500000000; fxg[223] = 0.9362000000; feg[223] = 0.0201000000;
					g[224] = 11.2000000000; fxg[224] = 0.9295000000; feg[224] = 0.0199000000;
					g[225] = 11.2500000000; fxg[225] = 0.9224000000; feg[225] = 0.0197000000;
					g[226] = 11.3000000000; fxg[226] = 0.9158000000; feg[226] = 0.0196000000;
					g[227] = 11.3500000000; fxg[227] = 0.9101000000; feg[227] = 0.0194000000;
					g[228] = 11.4000000000; fxg[228] = 0.9053000000; feg[228] = 0.0192000000;
					g[229] = 11.4500000000; fxg[229] = 0.9009000000; feg[229] = 0.0191000000;
					g[230] = 11.5000000000; fxg[230] = 0.8964000000; feg[230] = 0.0189000000;
					g[231] = 11.5500000000; fxg[231] = 0.8913000000; feg[231] = 0.0187000000;
					g[232] = 11.6000000000; fxg[232] = 0.8856000000; feg[232] = 0.0186000000;
					g[233] = 11.6500000000; fxg[233] = 0.8794000000; feg[233] = 0.0184000000;
					g[234] = 11.7000000000; fxg[234] = 0.8730000000; feg[234] = 0.0183000000;
					g[235] = 11.7500000000; fxg[235] = 0.8668000000; feg[235] = 0.0181000000;
					g[236] = 11.8000000000; fxg[236] = 0.8611000000; feg[236] = 0.0180000000;
					g[237] = 11.8500000000; fxg[237] = 0.8562000000; feg[237] = 0.0178000000;
					g[238] = 11.9000000000; fxg[238] = 0.8526000000; feg[238] = 0.0177000000;
					g[239] = 11.9500000000; fxg[239] = 0.8505000000; feg[239] = 0.0175000000;
					g[240] = 12.0000000000; fxg[240] = 0.8498000000; feg[240] = 0.0174000000;
					break;
				case 28:
					g[0] = 0.0000000000; fxg[0] = 28.0000000000; feg[0] = 6.5649000000;
					g[1] = 0.0500000000; fxg[1] = 27.8313000000; feg[1] = 6.4621000000;
					g[2] = 0.1000000000; fxg[2] = 27.3550000000; feg[2] = 6.1749000000;
					g[3] = 0.1500000000; fxg[3] = 26.6469000000; feg[3] = 5.7573000000;
					g[4] = 0.2000000000; fxg[4] = 25.7963000000; feg[4] = 5.2744000000;
					g[5] = 0.2500000000; fxg[5] = 24.8781000000; feg[5] = 4.7819000000;
					g[6] = 0.3000000000; fxg[6] = 23.9415000000; feg[6] = 4.3171000000;
					g[7] = 0.3500000000; fxg[7] = 23.0117000000; feg[7] = 3.8984000000;
					g[8] = 0.4000000000; fxg[8] = 22.0985000000; feg[8] = 3.5311000000;
					g[9] = 0.4500000000; fxg[9] = 21.2042000000; feg[9] = 3.2128000000;
					g[10] = 0.5000000000; fxg[10] = 20.3289000000; feg[10] = 2.9376000000;
					g[11] = 0.5500000000; fxg[11] = 19.4726000000; feg[11] = 2.6987000000;
					g[12] = 0.6000000000; fxg[12] = 18.6363000000; feg[12] = 2.4901000000;
					g[13] = 0.6500000000; fxg[13] = 17.8219000000; feg[13] = 2.3063000000;
					g[14] = 0.7000000000; fxg[14] = 17.0320000000; feg[14] = 2.1429000000;
					g[15] = 0.7500000000; fxg[15] = 16.2691000000; feg[15] = 1.9965000000;
					g[16] = 0.8000000000; fxg[16] = 15.5358000000; feg[16] = 1.8645000000;
					g[17] = 0.8500000000; fxg[17] = 14.8344000000; feg[17] = 1.7445000000;
					g[18] = 0.9000000000; fxg[18] = 14.1666000000; feg[18] = 1.6350000000;
					g[19] = 0.9500000000; fxg[19] = 13.5337000000; feg[19] = 1.5345000000;
					g[20] = 1.0000000000; fxg[20] = 12.9364000000; feg[20] = 1.4421000000;
					g[21] = 1.0500000000; fxg[21] = 12.3750000000; feg[21] = 1.3568000000;
					g[22] = 1.1000000000; fxg[22] = 11.8493000000; feg[22] = 1.2778000000;
					g[23] = 1.1500000000; fxg[23] = 11.3587000000; feg[23] = 1.2046000000;
					g[24] = 1.2000000000; fxg[24] = 10.9023000000; feg[24] = 1.1367000000;
					g[25] = 1.2500000000; fxg[25] = 10.4789000000; feg[25] = 1.0735000000;
					g[26] = 1.3000000000; fxg[26] = 10.0871000000; feg[26] = 1.0147000000;
					g[27] = 1.3500000000; fxg[27] = 9.7252000000; feg[27] = 0.9600000000;
					g[28] = 1.4000000000; fxg[28] = 9.3915000000; feg[28] = 0.9089000000;
					g[29] = 1.4500000000; fxg[29] = 9.0843000000; feg[29] = 0.8613000000;
					g[30] = 1.5000000000; fxg[30] = 8.8017000000; feg[30] = 0.8169000000;
					g[31] = 1.5500000000; fxg[31] = 8.5419000000; feg[31] = 0.7754000000;
					g[32] = 1.6000000000; fxg[32] = 8.3030000000; feg[32] = 0.7366000000;
					g[33] = 1.6500000000; fxg[33] = 8.0832000000; feg[33] = 0.7004000000;
					g[34] = 1.7000000000; fxg[34] = 7.8809000000; feg[34] = 0.6665000000;
					g[35] = 1.7500000000; fxg[35] = 7.6944000000; feg[35] = 0.6348000000;
					g[36] = 1.8000000000; fxg[36] = 7.5221000000; feg[36] = 0.6051000000;
					g[37] = 1.8500000000; fxg[37] = 7.3625000000; feg[37] = 0.5773000000;
					g[38] = 1.9000000000; fxg[38] = 7.2143000000; feg[38] = 0.5512000000;
					g[39] = 1.9500000000; fxg[39] = 7.0761000000; feg[39] = 0.5268000000;
					g[40] = 2.0000000000; fxg[40] = 6.9468000000; feg[40] = 0.5039000000;
					g[41] = 2.0500000000; fxg[41] = 6.8253000000; feg[41] = 0.4824000000;
					g[42] = 2.1000000000; fxg[42] = 6.7105000000; feg[42] = 0.4622000000;
					g[43] = 2.1500000000; fxg[43] = 6.6017000000; feg[43] = 0.4432000000;
					g[44] = 2.2000000000; fxg[44] = 6.4980000000; feg[44] = 0.4253000000;
					g[45] = 2.2500000000; fxg[45] = 6.3985000000; feg[45] = 0.4085000000;
					g[46] = 2.3000000000; fxg[46] = 6.3027000000; feg[46] = 0.3927000000;
					g[47] = 2.3500000000; fxg[47] = 6.2101000000; feg[47] = 0.3777000000;
					g[48] = 2.4000000000; fxg[48] = 6.1202000000; feg[48] = 0.3637000000;
					g[49] = 2.4500000000; fxg[49] = 6.0325000000; feg[49] = 0.3504000000;
					g[50] = 2.5000000000; fxg[50] = 5.9465000000; feg[50] = 0.3378000000;
					g[51] = 2.5500000000; fxg[51] = 5.8618000000; feg[51] = 0.3259000000;
					g[52] = 2.6000000000; fxg[52] = 5.7784000000; feg[52] = 0.3147000000;
					g[53] = 2.6500000000; fxg[53] = 5.6961000000; feg[53] = 0.3041000000;
					g[54] = 2.7000000000; fxg[54] = 5.6148000000; feg[54] = 0.2940000000;
					g[55] = 2.7500000000; fxg[55] = 5.5339000000; feg[55] = 0.2844000000;
					g[56] = 2.8000000000; fxg[56] = 5.4533000000; feg[56] = 0.2753000000;
					g[57] = 2.8500000000; fxg[57] = 5.3730000000; feg[57] = 0.2667000000;
					g[58] = 2.9000000000; fxg[58] = 5.2933000000; feg[58] = 0.2585000000;
					g[59] = 2.9500000000; fxg[59] = 5.2142000000; feg[59] = 0.2507000000;
					g[60] = 3.0000000000; fxg[60] = 5.1354000000; feg[60] = 0.2432000000;
					g[61] = 3.0500000000; fxg[61] = 5.0567000000; feg[61] = 0.2361000000;
					g[62] = 3.1000000000; fxg[62] = 4.9778000000; feg[62] = 0.2293000000;
					g[63] = 3.1500000000; fxg[63] = 4.8990000000; feg[63] = 0.2229000000;
					g[64] = 3.2000000000; fxg[64] = 4.8207000000; feg[64] = 0.2167000000;
					g[65] = 3.2500000000; fxg[65] = 4.7434000000; feg[65] = 0.2108000000;
					g[66] = 3.3000000000; fxg[66] = 4.6666000000; feg[66] = 0.2051000000;
					g[67] = 3.3500000000; fxg[67] = 4.5901000000; feg[67] = 0.1997000000;
					g[68] = 3.4000000000; fxg[68] = 4.5134000000; feg[68] = 0.1945000000;
					g[69] = 3.4500000000; fxg[69] = 4.4368000000; feg[69] = 0.1895000000;
					g[70] = 3.5000000000; fxg[70] = 4.3607000000; feg[70] = 0.1847000000;
					g[71] = 3.5500000000; fxg[71] = 4.2858000000; feg[71] = 0.1801000000;
					g[72] = 3.6000000000; fxg[72] = 4.2121000000; feg[72] = 0.1757000000;
					g[73] = 3.6500000000; fxg[73] = 4.1395000000; feg[73] = 0.1715000000;
					g[74] = 3.7000000000; fxg[74] = 4.0674000000; feg[74] = 0.1674000000;
					g[75] = 3.7500000000; fxg[75] = 3.9953000000; feg[75] = 0.1634000000;
					g[76] = 3.8000000000; fxg[76] = 3.9235000000; feg[76] = 0.1596000000;
					g[77] = 3.8500000000; fxg[77] = 3.8524000000; feg[77] = 0.1560000000;
					g[78] = 3.9000000000; fxg[78] = 3.7826000000; feg[78] = 0.1524000000;
					g[79] = 3.9500000000; fxg[79] = 3.7146000000; feg[79] = 0.1490000000;
					g[80] = 4.0000000000; fxg[80] = 3.6483000000; feg[80] = 0.1457000000;
					g[81] = 4.0500000000; fxg[81] = 3.5832000000; feg[81] = 0.1425000000;
					g[82] = 4.1000000000; fxg[82] = 3.5187000000; feg[82] = 0.1394000000;
					g[83] = 4.1500000000; fxg[83] = 3.4543000000; feg[83] = 0.1364000000;
					g[84] = 4.2000000000; fxg[84] = 3.3903000000; feg[84] = 0.1336000000;
					g[85] = 4.2500000000; fxg[85] = 3.3273000000; feg[85] = 0.1308000000;
					g[86] = 4.3000000000; fxg[86] = 3.2658000000; feg[86] = 0.1281000000;
					g[87] = 4.3500000000; fxg[87] = 3.2063000000; feg[87] = 0.1254000000;
					g[88] = 4.4000000000; fxg[88] = 3.1490000000; feg[88] = 0.1229000000;
					g[89] = 4.4500000000; fxg[89] = 3.0934000000; feg[89] = 0.1204000000;
					g[90] = 4.5000000000; fxg[90] = 3.0386000000; feg[90] = 0.1180000000;
					g[91] = 4.5500000000; fxg[91] = 2.9842000000; feg[91] = 0.1157000000;
					g[92] = 4.6000000000; fxg[92] = 2.9301000000; feg[92] = 0.1134000000;
					g[93] = 4.6500000000; fxg[93] = 2.8765000000; feg[93] = 0.1112000000;
					g[94] = 4.7000000000; fxg[94] = 2.8240000000; feg[94] = 0.1091000000;
					g[95] = 4.7500000000; fxg[95] = 2.7730000000; feg[95] = 0.1070000000;
					g[96] = 4.8000000000; fxg[96] = 2.7242000000; feg[96] = 0.1050000000;
					g[97] = 4.8500000000; fxg[97] = 2.6776000000; feg[97] = 0.1031000000;
					g[98] = 4.9000000000; fxg[98] = 2.6329000000; feg[98] = 0.1011000000;
					g[99] = 4.9500000000; fxg[99] = 2.5894000000; feg[99] = 0.0993000000;
					g[100] = 5.0000000000; fxg[100] = 2.5462000000; feg[100] = 0.0975000000;
					g[101] = 5.0500000000; fxg[101] = 2.5031000000; feg[101] = 0.0957000000;
					g[102] = 5.1000000000; fxg[102] = 2.4603000000; feg[102] = 0.0940000000;
					g[103] = 5.1500000000; fxg[103] = 2.4182000000; feg[103] = 0.0923000000;
					g[104] = 5.2000000000; fxg[104] = 2.3771000000; feg[104] = 0.0907000000;
					g[105] = 5.2500000000; fxg[105] = 2.3374000000; feg[105] = 0.0891000000;
					g[106] = 5.3000000000; fxg[106] = 2.2996000000; feg[106] = 0.0876000000;
					g[107] = 5.3500000000; fxg[107] = 2.2641000000; feg[107] = 0.0861000000;
					g[108] = 5.4000000000; fxg[108] = 2.2304000000; feg[108] = 0.0846000000;
					g[109] = 5.4500000000; fxg[109] = 2.1981000000; feg[109] = 0.0832000000;
					g[110] = 5.5000000000; fxg[110] = 2.1661000000; feg[110] = 0.0818000000;
					g[111] = 5.5500000000; fxg[111] = 2.1339000000; feg[111] = 0.0804000000;
					g[112] = 5.6000000000; fxg[112] = 2.1017000000; feg[112] = 0.0791000000;
					g[113] = 5.6500000000; fxg[113] = 2.0698000000; feg[113] = 0.0778000000;
					g[114] = 5.7000000000; fxg[114] = 2.0386000000; feg[114] = 0.0765000000;
					g[115] = 5.7500000000; fxg[115] = 2.0082000000; feg[115] = 0.0753000000;
					g[116] = 5.8000000000; fxg[116] = 1.9789000000; feg[116] = 0.0741000000;
					g[117] = 5.8500000000; fxg[117] = 1.9512000000; feg[117] = 0.0729000000;
					g[118] = 5.9000000000; fxg[118] = 1.9254000000; feg[118] = 0.0717000000;
					g[119] = 5.9500000000; fxg[119] = 1.9015000000; feg[119] = 0.0706000000;
					g[120] = 6.0000000000; fxg[120] = 1.8790000000; feg[120] = 0.0695000000;
					g[121] = 6.0500000000; fxg[121] = 1.8569000000; feg[121] = 0.0684000000;
					g[122] = 6.1000000000; fxg[122] = 1.8345000000; feg[122] = 0.0673000000;
					g[123] = 6.1500000000; fxg[123] = 1.8116000000; feg[123] = 0.0663000000;
					g[124] = 6.2000000000; fxg[124] = 1.7887000000; feg[124] = 0.0653000000;
					g[125] = 6.2500000000; fxg[125] = 1.7661000000; feg[125] = 0.0643000000;
					g[126] = 6.3000000000; fxg[126] = 1.7440000000; feg[126] = 0.0633000000;
					g[127] = 6.3500000000; fxg[127] = 1.7226000000; feg[127] = 0.0624000000;
					g[128] = 6.4000000000; fxg[128] = 1.7017000000; feg[128] = 0.0615000000;
					g[129] = 6.4500000000; fxg[129] = 1.6819000000; feg[129] = 0.0606000000;
					g[130] = 6.5000000000; fxg[130] = 1.6636000000; feg[130] = 0.0597000000;
					g[131] = 6.5500000000; fxg[131] = 1.6471000000; feg[131] = 0.0588000000;
					g[132] = 6.6000000000; fxg[132] = 1.6322000000; feg[132] = 0.0580000000;
					g[133] = 6.6500000000; fxg[133] = 1.6181000000; feg[133] = 0.0571000000;
					g[134] = 6.7000000000; fxg[134] = 1.6037000000; feg[134] = 0.0563000000;
					g[135] = 6.7500000000; fxg[135] = 1.5886000000; feg[135] = 0.0555000000;
					g[136] = 6.8000000000; fxg[136] = 1.5727000000; feg[136] = 0.0547000000;
					g[137] = 6.8500000000; fxg[137] = 1.5567000000; feg[137] = 0.0540000000;
					g[138] = 6.9000000000; fxg[138] = 1.5411000000; feg[138] = 0.0532000000;
					g[139] = 6.9500000000; fxg[139] = 1.5260000000; feg[139] = 0.0525000000;
					g[140] = 7.0000000000; fxg[140] = 1.5112000000; feg[140] = 0.0518000000;
					g[141] = 7.0500000000; fxg[141] = 1.4966000000; feg[141] = 0.0510000000;
					g[142] = 7.1000000000; fxg[142] = 1.4824000000; feg[142] = 0.0504000000;
					g[143] = 7.1500000000; fxg[143] = 1.4690000000; feg[143] = 0.0497000000;
					g[144] = 7.2000000000; fxg[144] = 1.4572000000; feg[144] = 0.0490000000;
					g[145] = 7.2500000000; fxg[145] = 1.4470000000; feg[145] = 0.0484000000;
					g[146] = 7.3000000000; fxg[146] = 1.4382000000; feg[146] = 0.0477000000;
					g[147] = 7.3500000000; fxg[147] = 1.4299000000; feg[147] = 0.0471000000;
					g[148] = 7.4000000000; fxg[148] = 1.4210000000; feg[148] = 0.0465000000;
					g[149] = 7.4500000000; fxg[149] = 1.4111000000; feg[149] = 0.0459000000;
					g[150] = 7.5000000000; fxg[150] = 1.4001000000; feg[150] = 0.0453000000;
					g[151] = 7.5500000000; fxg[151] = 1.3887000000; feg[151] = 0.0447000000;
					g[152] = 7.6000000000; fxg[152] = 1.3776000000; feg[152] = 0.0441000000;
					g[153] = 7.6500000000; fxg[153] = 1.3671000000; feg[153] = 0.0436000000;
					g[154] = 7.7000000000; fxg[154] = 1.3570000000; feg[154] = 0.0430000000;
					g[155] = 7.7500000000; fxg[155] = 1.3469000000; feg[155] = 0.0425000000;
					g[156] = 7.8000000000; fxg[156] = 1.3366000000; feg[156] = 0.0420000000;
					g[157] = 7.8500000000; fxg[157] = 1.3264000000; feg[157] = 0.0414000000;
					g[158] = 7.9000000000; fxg[158] = 1.3168000000; feg[158] = 0.0409000000;
					g[159] = 7.9500000000; fxg[159] = 1.3085000000; feg[159] = 0.0404000000;
					g[160] = 8.0000000000; fxg[160] = 1.3017000000; feg[160] = 0.0399000000;
					g[161] = 8.0500000000; fxg[161] = 1.2965000000; feg[161] = 0.0394000000;
					g[162] = 8.1000000000; fxg[162] = 1.2919000000; feg[162] = 0.0390000000;
					g[163] = 8.1500000000; fxg[163] = 1.2869000000; feg[163] = 0.0385000000;
					g[164] = 8.2000000000; fxg[164] = 1.2809000000; feg[164] = 0.0380000000;
					g[165] = 8.2500000000; fxg[165] = 1.2735000000; feg[165] = 0.0376000000;
					g[166] = 8.3000000000; fxg[166] = 1.2651000000; feg[166] = 0.0372000000;
					g[167] = 8.3500000000; fxg[167] = 1.2564000000; feg[167] = 0.0367000000;
					g[168] = 8.4000000000; fxg[168] = 1.2482000000; feg[168] = 0.0363000000;
					g[169] = 8.4500000000; fxg[169] = 1.2406000000; feg[169] = 0.0359000000;
					g[170] = 8.5000000000; fxg[170] = 1.2335000000; feg[170] = 0.0355000000;
					g[171] = 8.5500000000; fxg[171] = 1.2262000000; feg[171] = 0.0351000000;
					g[172] = 8.6000000000; fxg[172] = 1.2186000000; feg[172] = 0.0347000000;
					g[173] = 8.6500000000; fxg[173] = 1.2107000000; feg[173] = 0.0343000000;
					g[174] = 8.7000000000; fxg[174] = 1.2028000000; feg[174] = 0.0339000000;
					g[175] = 8.7500000000; fxg[175] = 1.1957000000; feg[175] = 0.0335000000;
					g[176] = 8.8000000000; fxg[176] = 1.1898000000; feg[176] = 0.0331000000;
					g[177] = 8.8500000000; fxg[177] = 1.1855000000; feg[177] = 0.0328000000;
					g[178] = 8.9000000000; fxg[178] = 1.1826000000; feg[178] = 0.0324000000;
					g[179] = 8.9500000000; fxg[179] = 1.1802000000; feg[179] = 0.0321000000;
					g[180] = 9.0000000000; fxg[180] = 1.1774000000; feg[180] = 0.0317000000;
					g[181] = 9.0500000000; fxg[181] = 1.1735000000; feg[181] = 0.0314000000;
					g[182] = 9.1000000000; fxg[182] = 1.1680000000; feg[182] = 0.0310000000;
					g[183] = 9.1500000000; fxg[183] = 1.1613000000; feg[183] = 0.0307000000;
					g[184] = 9.2000000000; fxg[184] = 1.1539000000; feg[184] = 0.0304000000;
					g[185] = 9.2500000000; fxg[185] = 1.1467000000; feg[185] = 0.0300000000;
					g[186] = 9.3000000000; fxg[186] = 1.1403000000; feg[186] = 0.0297000000;
					g[187] = 9.3500000000; fxg[187] = 1.1345000000; feg[187] = 0.0294000000;
					g[188] = 9.4000000000; fxg[188] = 1.1290000000; feg[188] = 0.0291000000;
					g[189] = 9.4500000000; fxg[189] = 1.1232000000; feg[189] = 0.0288000000;
					g[190] = 9.5000000000; fxg[190] = 1.1170000000; feg[190] = 0.0285000000;
					g[191] = 9.5500000000; fxg[191] = 1.1102000000; feg[191] = 0.0282000000;
					g[192] = 9.6000000000; fxg[192] = 1.1034000000; feg[192] = 0.0279000000;
					g[193] = 9.6500000000; fxg[193] = 1.0969000000; feg[193] = 0.0277000000;
					g[194] = 9.7000000000; fxg[194] = 1.0914000000; feg[194] = 0.0274000000;
					g[195] = 9.7500000000; fxg[195] = 1.0872000000; feg[195] = 0.0271000000;
					g[196] = 9.8000000000; fxg[196] = 1.0846000000; feg[196] = 0.0268000000;
					g[197] = 9.8500000000; fxg[197] = 1.0832000000; feg[197] = 0.0266000000;
					g[198] = 9.9000000000; fxg[198] = 1.0820000000; feg[198] = 0.0263000000;
					g[199] = 9.9500000000; fxg[199] = 1.0803000000; feg[199] = 0.0260000000;
					g[200] = 10.0000000000; fxg[200] = 1.0772000000; feg[200] = 0.0258000000;
					g[201] = 10.0500000000; fxg[201] = 1.0726000000; feg[201] = 0.0255000000;
					g[202] = 10.1000000000; fxg[202] = 1.0666000000; feg[202] = 0.0253000000;
					g[203] = 10.1500000000; fxg[203] = 1.0598000000; feg[203] = 0.0250000000;
					g[204] = 10.2000000000; fxg[204] = 1.0530000000; feg[204] = 0.0248000000;
					g[205] = 10.2500000000; fxg[205] = 1.0467000000; feg[205] = 0.0246000000;
					g[206] = 10.3000000000; fxg[206] = 1.0414000000; feg[206] = 0.0243000000;
					g[207] = 10.3500000000; fxg[207] = 1.0366000000; feg[207] = 0.0241000000;
					g[208] = 10.4000000000; fxg[208] = 1.0318000000; feg[208] = 0.0239000000;
					g[209] = 10.4500000000; fxg[209] = 1.0267000000; feg[209] = 0.0236000000;
					g[210] = 10.5000000000; fxg[210] = 1.0209000000; feg[210] = 0.0234000000;
					g[211] = 10.5500000000; fxg[211] = 1.0147000000; feg[211] = 0.0232000000;
					g[212] = 10.6000000000; fxg[212] = 1.0082000000; feg[212] = 0.0230000000;
					g[213] = 10.6500000000; fxg[213] = 1.0020000000; feg[213] = 0.0228000000;
					g[214] = 10.7000000000; fxg[214] = 0.9965000000; feg[214] = 0.0226000000;
					g[215] = 10.7500000000; fxg[215] = 0.9922000000; feg[215] = 0.0224000000;
					g[216] = 10.8000000000; fxg[216] = 0.9893000000; feg[216] = 0.0222000000;
					g[217] = 10.8500000000; fxg[217] = 0.9879000000; feg[217] = 0.0220000000;
					g[218] = 10.9000000000; fxg[218] = 0.9873000000; feg[218] = 0.0218000000;
					g[219] = 10.9500000000; fxg[219] = 0.9868000000; feg[219] = 0.0216000000;
					g[220] = 11.0000000000; fxg[220] = 0.9856000000; feg[220] = 0.0214000000;
					g[221] = 11.0500000000; fxg[221] = 0.9830000000; feg[221] = 0.0212000000;
					g[222] = 11.1000000000; fxg[222] = 0.9789000000; feg[222] = 0.0210000000;
					g[223] = 11.1500000000; fxg[223] = 0.9733000000; feg[223] = 0.0208000000;
					g[224] = 11.2000000000; fxg[224] = 0.9668000000; feg[224] = 0.0206000000;
					g[225] = 11.2500000000; fxg[225] = 0.9600000000; feg[225] = 0.0205000000;
					g[226] = 11.3000000000; fxg[226] = 0.9536000000; feg[226] = 0.0203000000;
					g[227] = 11.3500000000; fxg[227] = 0.9480000000; feg[227] = 0.0201000000;
					g[228] = 11.4000000000; fxg[228] = 0.9432000000; feg[228] = 0.0199000000;
					g[229] = 11.4500000000; fxg[229] = 0.9388000000; feg[229] = 0.0198000000;
					g[230] = 11.5000000000; fxg[230] = 0.9344000000; feg[230] = 0.0196000000;
					g[231] = 11.5500000000; fxg[231] = 0.9294000000; feg[231] = 0.0194000000;
					g[232] = 11.6000000000; fxg[232] = 0.9237000000; feg[232] = 0.0193000000;
					g[233] = 11.6500000000; fxg[233] = 0.9177000000; feg[233] = 0.0191000000;
					g[234] = 11.7000000000; fxg[234] = 0.9115000000; feg[234] = 0.0189000000;
					g[235] = 11.7500000000; fxg[235] = 0.9054000000; feg[235] = 0.0188000000;
					g[236] = 11.8000000000; fxg[236] = 0.8998000000; feg[236] = 0.0186000000;
					g[237] = 11.8500000000; fxg[237] = 0.8950000000; feg[237] = 0.0185000000;
					g[238] = 11.9000000000; fxg[238] = 0.8915000000; feg[238] = 0.0183000000;
					g[239] = 11.9500000000; fxg[239] = 0.8895000000; feg[239] = 0.0182000000;
					g[240] = 12.0000000000; fxg[240] = 0.8888000000; feg[240] = 0.0180000000;
					break;
				case 29:
					g[0] = 0.0000000000; fxg[0] = 29.0000000000; feg[0] = 5.6010000000;
					g[1] = 0.0500000000; fxg[1] = 28.8559000000; feg[1] = 5.5176000000;
					g[2] = 0.1000000000; fxg[2] = 28.4477000000; feg[2] = 5.2872000000;
					g[3] = 0.1500000000; fxg[3] = 27.8347000000; feg[3] = 4.9581000000;
					g[4] = 0.2000000000; fxg[4] = 27.0842000000; feg[4] = 4.5851000000;
					g[5] = 0.2500000000; fxg[5] = 26.2507000000; feg[5] = 4.2113000000;
					g[6] = 0.3000000000; fxg[6] = 25.3697000000; feg[6] = 3.8616000000;
					g[7] = 0.3500000000; fxg[7] = 24.4621000000; feg[7] = 3.5464000000;
					g[8] = 0.4000000000; fxg[8] = 23.5402000000; feg[8] = 3.2668000000;
					g[9] = 0.4500000000; fxg[9] = 22.6130000000; feg[9] = 3.0196000000;
					g[10] = 0.5000000000; fxg[10] = 21.6876000000; feg[10] = 2.8002000000;
					g[11] = 0.5500000000; fxg[11] = 20.7710000000; feg[11] = 2.6043000000;
					g[12] = 0.6000000000; fxg[12] = 19.8693000000; feg[12] = 2.4281000000;
					g[13] = 0.6500000000; fxg[13] = 18.9883000000; feg[13] = 2.2686000000;
					g[14] = 0.7000000000; fxg[14] = 18.1327000000; feg[14] = 2.1232000000;
					g[15] = 0.7500000000; fxg[15] = 17.3067000000; feg[15] = 1.9901000000;
					g[16] = 0.8000000000; fxg[16] = 16.5134000000; feg[16] = 1.8678000000;
					g[17] = 0.8500000000; fxg[17] = 15.7553000000; feg[17] = 1.7550000000;
					g[18] = 0.9000000000; fxg[18] = 15.0342000000; feg[18] = 1.6506000000;
					g[19] = 0.9500000000; fxg[19] = 14.3511000000; feg[19] = 1.5539000000;
					g[20] = 1.0000000000; fxg[20] = 13.7064000000; feg[20] = 1.4641000000;
					g[21] = 1.0500000000; fxg[21] = 13.1003000000; feg[21] = 1.3806000000;
					g[22] = 1.1000000000; fxg[22] = 12.5322000000; feg[22] = 1.3029000000;
					g[23] = 1.1500000000; fxg[23] = 12.0013000000; feg[23] = 1.2305000000;
					g[24] = 1.2000000000; fxg[24] = 11.5066000000; feg[24] = 1.1630000000;
					g[25] = 1.2500000000; fxg[25] = 11.0467000000; feg[25] = 1.1000000000;
					g[26] = 1.3000000000; fxg[26] = 10.6202000000; feg[26] = 1.0412000000;
					g[27] = 1.3500000000; fxg[27] = 10.2253000000; feg[27] = 0.9862000000;
					g[28] = 1.4000000000; fxg[28] = 9.8603000000; feg[28] = 0.9349000000;
					g[29] = 1.4500000000; fxg[29] = 9.5233000000; feg[29] = 0.8868000000;
					g[30] = 1.5000000000; fxg[30] = 9.2127000000; feg[30] = 0.8419000000;
					g[31] = 1.5500000000; fxg[31] = 8.9264000000; feg[31] = 0.7999000000;
					g[32] = 1.6000000000; fxg[32] = 8.6627000000; feg[32] = 0.7605000000;
					g[33] = 1.6500000000; fxg[33] = 8.4198000000; feg[33] = 0.7237000000;
					g[34] = 1.7000000000; fxg[34] = 8.1960000000; feg[34] = 0.6892000000;
					g[35] = 1.7500000000; fxg[35] = 7.9896000000; feg[35] = 0.6568000000;
					g[36] = 1.8000000000; fxg[36] = 7.7989000000; feg[36] = 0.6264000000;
					g[37] = 1.8500000000; fxg[37] = 7.6226000000; feg[37] = 0.5980000000;
					g[38] = 1.9000000000; fxg[38] = 7.4591000000; feg[38] = 0.5712000000;
					g[39] = 1.9500000000; fxg[39] = 7.3073000000; feg[39] = 0.5462000000;
					g[40] = 2.0000000000; fxg[40] = 7.1657000000; feg[40] = 0.5226000000;
					g[41] = 2.0500000000; fxg[41] = 7.0333000000; feg[41] = 0.5004000000;
					g[42] = 2.1000000000; fxg[42] = 6.9090000000; feg[42] = 0.4796000000;
					g[43] = 2.1500000000; fxg[43] = 6.7918000000; feg[43] = 0.4599000000;
					g[44] = 2.2000000000; fxg[44] = 6.6810000000; feg[44] = 0.4415000000;
					g[45] = 2.2500000000; fxg[45] = 6.5757000000; feg[45] = 0.4241000000;
					g[46] = 2.3000000000; fxg[46] = 6.4750000000; feg[46] = 0.4076000000;
					g[47] = 2.3500000000; fxg[47] = 6.3784000000; feg[47] = 0.3922000000;
					g[48] = 2.4000000000; fxg[48] = 6.2854000000; feg[48] = 0.3775000000;
					g[49] = 2.4500000000; fxg[49] = 6.1955000000; feg[49] = 0.3637000000;
					g[50] = 2.5000000000; fxg[50] = 6.1081000000; feg[50] = 0.3506000000;
					g[51] = 2.5500000000; fxg[51] = 6.0226000000; feg[51] = 0.3383000000;
					g[52] = 2.6000000000; fxg[52] = 5.9390000000; feg[52] = 0.3266000000;
					g[53] = 2.6500000000; fxg[53] = 5.8571000000; feg[53] = 0.3155000000;
					g[54] = 2.7000000000; fxg[54] = 5.7765000000; feg[54] = 0.3050000000;
					g[55] = 2.7500000000; fxg[55] = 5.6969000000; feg[55] = 0.2950000000;
					g[56] = 2.8000000000; fxg[56] = 5.6179000000; feg[56] = 0.2855000000;
					g[57] = 2.8500000000; fxg[57] = 5.5395000000; feg[57] = 0.2765000000;
					g[58] = 2.9000000000; fxg[58] = 5.4618000000; feg[58] = 0.2679000000;
					g[59] = 2.9500000000; fxg[59] = 5.3849000000; feg[59] = 0.2598000000;
					g[60] = 3.0000000000; fxg[60] = 5.3085000000; feg[60] = 0.2520000000;
					g[61] = 3.0500000000; fxg[61] = 5.2322000000; feg[61] = 0.2446000000;
					g[62] = 3.1000000000; fxg[62] = 5.1559000000; feg[62] = 0.2375000000;
					g[63] = 3.1500000000; fxg[63] = 5.0798000000; feg[63] = 0.2308000000;
					g[64] = 3.2000000000; fxg[64] = 5.0041000000; feg[64] = 0.2243000000;
					g[65] = 3.2500000000; fxg[65] = 4.9291000000; feg[65] = 0.2182000000;
					g[66] = 3.3000000000; fxg[66] = 4.8547000000; feg[66] = 0.2123000000;
					g[67] = 3.3500000000; fxg[67] = 4.7804000000; feg[67] = 0.2066000000;
					g[68] = 3.4000000000; fxg[68] = 4.7060000000; feg[68] = 0.2012000000;
					g[69] = 3.4500000000; fxg[69] = 4.6317000000; feg[69] = 0.1960000000;
					g[70] = 3.5000000000; fxg[70] = 4.5577000000; feg[70] = 0.1910000000;
					g[71] = 3.5500000000; fxg[71] = 4.4845000000; feg[71] = 0.1862000000;
					g[72] = 3.6000000000; fxg[72] = 4.4124000000; feg[72] = 0.1816000000;
					g[73] = 3.6500000000; fxg[73] = 4.3410000000; feg[73] = 0.1772000000;
					g[74] = 3.7000000000; fxg[74] = 4.2700000000; feg[74] = 0.1729000000;
					g[75] = 3.7500000000; fxg[75] = 4.1991000000; feg[75] = 0.1688000000;
					g[76] = 3.8000000000; fxg[76] = 4.1283000000; feg[76] = 0.1649000000;
					g[77] = 3.8500000000; fxg[77] = 4.0582000000; feg[77] = 0.1611000000;
					g[78] = 3.9000000000; fxg[78] = 3.9890000000; feg[78] = 0.1574000000;
					g[79] = 3.9500000000; fxg[79] = 3.9212000000; feg[79] = 0.1539000000;
					g[80] = 4.0000000000; fxg[80] = 3.8548000000; feg[80] = 0.1505000000;
					g[81] = 4.0500000000; fxg[81] = 3.7893000000; feg[81] = 0.1471000000;
					g[82] = 4.1000000000; fxg[82] = 3.7242000000; feg[82] = 0.1439000000;
					g[83] = 4.1500000000; fxg[83] = 3.6595000000; feg[83] = 0.1409000000;
					g[84] = 4.2000000000; fxg[84] = 3.5953000000; feg[84] = 0.1379000000;
					g[85] = 4.2500000000; fxg[85] = 3.5318000000; feg[85] = 0.1350000000;
					g[86] = 4.3000000000; fxg[86] = 3.4696000000; feg[86] = 0.1322000000;
					g[87] = 4.3500000000; fxg[87] = 3.4090000000; feg[87] = 0.1295000000;
					g[88] = 4.4000000000; fxg[88] = 3.3501000000; feg[88] = 0.1268000000;
					g[89] = 4.4500000000; fxg[89] = 3.2926000000; feg[89] = 0.1243000000;
					g[90] = 4.5000000000; fxg[90] = 3.2359000000; feg[90] = 0.1218000000;
					g[91] = 4.5500000000; fxg[91] = 3.1797000000; feg[91] = 0.1194000000;
					g[92] = 4.6000000000; fxg[92] = 3.1240000000; feg[92] = 0.1171000000;
					g[93] = 4.6500000000; fxg[93] = 3.0690000000; feg[93] = 0.1148000000;
					g[94] = 4.7000000000; fxg[94] = 3.0150000000; feg[94] = 0.1126000000;
					g[95] = 4.7500000000; fxg[95] = 2.9623000000; feg[95] = 0.1105000000;
					g[96] = 4.8000000000; fxg[96] = 2.9112000000; feg[96] = 0.1084000000;
					g[97] = 4.8500000000; fxg[97] = 2.8620000000; feg[97] = 0.1064000000;
					g[98] = 4.9000000000; fxg[98] = 2.8144000000; feg[98] = 0.1044000000;
					g[99] = 4.9500000000; fxg[99] = 2.7679000000; feg[99] = 0.1025000000;
					g[100] = 5.0000000000; fxg[100] = 2.7219000000; feg[100] = 0.1006000000;
					g[101] = 5.0500000000; fxg[101] = 2.6763000000; feg[101] = 0.0988000000;
					g[102] = 5.1000000000; fxg[102] = 2.6312000000; feg[102] = 0.0971000000;
					g[103] = 5.1500000000; fxg[103] = 2.5870000000; feg[103] = 0.0953000000;
					g[104] = 5.2000000000; fxg[104] = 2.5438000000; feg[104] = 0.0937000000;
					g[105] = 5.2500000000; fxg[105] = 2.5019000000; feg[105] = 0.0920000000;
					g[106] = 5.3000000000; fxg[106] = 2.4615000000; feg[106] = 0.0904000000;
					g[107] = 5.3500000000; fxg[107] = 2.4228000000; feg[107] = 0.0889000000;
					g[108] = 5.4000000000; fxg[108] = 2.3859000000; feg[108] = 0.0874000000;
					g[109] = 5.4500000000; fxg[109] = 2.3501000000; feg[109] = 0.0859000000;
					g[110] = 5.5000000000; fxg[110] = 2.3147000000; feg[110] = 0.0845000000;
					g[111] = 5.5500000000; fxg[111] = 2.2796000000; feg[111] = 0.0830000000;
					g[112] = 5.6000000000; fxg[112] = 2.2448000000; feg[112] = 0.0817000000;
					g[113] = 5.6500000000; fxg[113] = 2.2106000000; feg[113] = 0.0803000000;
					g[114] = 5.7000000000; fxg[114] = 2.1772000000; feg[114] = 0.0790000000;
					g[115] = 5.7500000000; fxg[115] = 2.1447000000; feg[115] = 0.0778000000;
					g[116] = 5.8000000000; fxg[116] = 2.1131000000; feg[116] = 0.0765000000;
					g[117] = 5.8500000000; fxg[117] = 2.0828000000; feg[117] = 0.0753000000;
					g[118] = 5.9000000000; fxg[118] = 2.0541000000; feg[118] = 0.0741000000;
					g[119] = 5.9500000000; fxg[119] = 2.0270000000; feg[119] = 0.0729000000;
					g[120] = 6.0000000000; fxg[120] = 2.0012000000; feg[120] = 0.0718000000;
					g[121] = 6.0500000000; fxg[121] = 1.9759000000; feg[121] = 0.0707000000;
					g[122] = 6.1000000000; fxg[122] = 1.9505000000; feg[122] = 0.0696000000;
					g[123] = 6.1500000000; fxg[123] = 1.9251000000; feg[123] = 0.0685000000;
					g[124] = 6.2000000000; fxg[124] = 1.8998000000; feg[124] = 0.0675000000;
					g[125] = 6.2500000000; fxg[125] = 1.8752000000; feg[125] = 0.0665000000;
					g[126] = 6.3000000000; fxg[126] = 1.8513000000; feg[126] = 0.0655000000;
					g[127] = 6.3500000000; fxg[127] = 1.8281000000; feg[127] = 0.0645000000;
					g[128] = 6.4000000000; fxg[128] = 1.8054000000; feg[128] = 0.0636000000;
					g[129] = 6.4500000000; fxg[129] = 1.7835000000; feg[129] = 0.0626000000;
					g[130] = 6.5000000000; fxg[130] = 1.7630000000; feg[130] = 0.0617000000;
					g[131] = 6.5500000000; fxg[131] = 1.7439000000; feg[131] = 0.0608000000;
					g[132] = 6.6000000000; fxg[132] = 1.7262000000; feg[132] = 0.0599000000;
					g[133] = 6.6500000000; fxg[133] = 1.7092000000; feg[133] = 0.0591000000;
					g[134] = 6.7000000000; fxg[134] = 1.6922000000; feg[134] = 0.0582000000;
					g[135] = 6.7500000000; fxg[135] = 1.6748000000; feg[135] = 0.0574000000;
					g[136] = 6.8000000000; fxg[136] = 1.6571000000; feg[136] = 0.0566000000;
					g[137] = 6.8500000000; fxg[137] = 1.6394000000; feg[137] = 0.0558000000;
					g[138] = 6.9000000000; fxg[138] = 1.6223000000; feg[138] = 0.0551000000;
					g[139] = 6.9500000000; fxg[139] = 1.6057000000; feg[139] = 0.0543000000;
					g[140] = 7.0000000000; fxg[140] = 1.5896000000; feg[140] = 0.0536000000;
					g[141] = 7.0500000000; fxg[141] = 1.5737000000; feg[141] = 0.0528000000;
					g[142] = 7.1000000000; fxg[142] = 1.5583000000; feg[142] = 0.0521000000;
					g[143] = 7.1500000000; fxg[143] = 1.5436000000; feg[143] = 0.0514000000;
					g[144] = 7.2000000000; fxg[144] = 1.5301000000; feg[144] = 0.0507000000;
					g[145] = 7.2500000000; fxg[145] = 1.5179000000; feg[145] = 0.0501000000;
					g[146] = 7.3000000000; fxg[146] = 1.5069000000; feg[146] = 0.0494000000;
					g[147] = 7.3500000000; fxg[147] = 1.4964000000; feg[147] = 0.0487000000;
					g[148] = 7.4000000000; fxg[148] = 1.4856000000; feg[148] = 0.0481000000;
					g[149] = 7.4500000000; fxg[149] = 1.4740000000; feg[149] = 0.0475000000;
					g[150] = 7.5000000000; fxg[150] = 1.4619000000; feg[150] = 0.0469000000;
					g[151] = 7.5500000000; fxg[151] = 1.4495000000; feg[151] = 0.0463000000;
					g[152] = 7.6000000000; fxg[152] = 1.4375000000; feg[152] = 0.0457000000;
					g[153] = 7.6500000000; fxg[153] = 1.4260000000; feg[153] = 0.0451000000;
					g[154] = 7.7000000000; fxg[154] = 1.4149000000; feg[154] = 0.0445000000;
					g[155] = 7.7500000000; fxg[155] = 1.4039000000; feg[155] = 0.0440000000;
					g[156] = 7.8000000000; fxg[156] = 1.3929000000; feg[156] = 0.0434000000;
					g[157] = 7.8500000000; fxg[157] = 1.3821000000; feg[157] = 0.0429000000;
					g[158] = 7.9000000000; fxg[158] = 1.3719000000; feg[158] = 0.0424000000;
					g[159] = 7.9500000000; fxg[159] = 1.3627000000; feg[159] = 0.0419000000;
					g[160] = 8.0000000000; fxg[160] = 1.3548000000; feg[160] = 0.0414000000;
					g[161] = 8.0500000000; fxg[161] = 1.3479000000; feg[161] = 0.0409000000;
					g[162] = 8.1000000000; fxg[162] = 1.3417000000; feg[162] = 0.0404000000;
					g[163] = 8.1500000000; fxg[163] = 1.3353000000; feg[163] = 0.0399000000;
					g[164] = 8.2000000000; fxg[164] = 1.3282000000; feg[164] = 0.0394000000;
					g[165] = 8.2500000000; fxg[165] = 1.3201000000; feg[165] = 0.0389000000;
					g[166] = 8.3000000000; fxg[166] = 1.3113000000; feg[166] = 0.0385000000;
					g[167] = 8.3500000000; fxg[167] = 1.3023000000; feg[167] = 0.0380000000;
					g[168] = 8.4000000000; fxg[168] = 1.2937000000; feg[168] = 0.0376000000;
					g[169] = 8.4500000000; fxg[169] = 1.2855000000; feg[169] = 0.0372000000;
					g[170] = 8.5000000000; fxg[170] = 1.2776000000; feg[170] = 0.0367000000;
					g[171] = 8.5500000000; fxg[171] = 1.2697000000; feg[171] = 0.0363000000;
					g[172] = 8.6000000000; fxg[172] = 1.2617000000; feg[172] = 0.0359000000;
					g[173] = 8.6500000000; fxg[173] = 1.2536000000; feg[173] = 0.0355000000;
					g[174] = 8.7000000000; fxg[174] = 1.2458000000; feg[174] = 0.0351000000;
					g[175] = 8.7500000000; fxg[175] = 1.2386000000; feg[175] = 0.0347000000;
					g[176] = 8.8000000000; fxg[176] = 1.2324000000; feg[176] = 0.0343000000;
					g[177] = 8.8500000000; fxg[177] = 1.2274000000; feg[177] = 0.0339000000;
					g[178] = 8.9000000000; fxg[178] = 1.2234000000; feg[178] = 0.0336000000;
					g[179] = 8.9500000000; fxg[179] = 1.2198000000; feg[179] = 0.0332000000;
					g[180] = 9.0000000000; fxg[180] = 1.2161000000; feg[180] = 0.0328000000;
					g[181] = 9.0500000000; fxg[181] = 1.2114000000; feg[181] = 0.0325000000;
					g[182] = 9.1000000000; fxg[182] = 1.2058000000; feg[182] = 0.0321000000;
					g[183] = 9.1500000000; fxg[183] = 1.1992000000; feg[183] = 0.0318000000;
					g[184] = 9.2000000000; fxg[184] = 1.1920000000; feg[184] = 0.0315000000;
					g[185] = 9.2500000000; fxg[185] = 1.1849000000; feg[185] = 0.0311000000;
					g[186] = 9.3000000000; fxg[186] = 1.1783000000; feg[186] = 0.0308000000;
					g[187] = 9.3500000000; fxg[187] = 1.1720000000; feg[187] = 0.0305000000;
					g[188] = 9.4000000000; fxg[188] = 1.1659000000; feg[188] = 0.0302000000;
					g[189] = 9.4500000000; fxg[189] = 1.1597000000; feg[189] = 0.0298000000;
					g[190] = 9.5000000000; fxg[190] = 1.1532000000; feg[190] = 0.0295000000;
					g[191] = 9.5500000000; fxg[191] = 1.1466000000; feg[191] = 0.0292000000;
					g[192] = 9.6000000000; fxg[192] = 1.1401000000; feg[192] = 0.0289000000;
					g[193] = 9.6500000000; fxg[193] = 1.1340000000; feg[193] = 0.0286000000;
					g[194] = 9.7000000000; fxg[194] = 1.1288000000; feg[194] = 0.0284000000;
					g[195] = 9.7500000000; fxg[195] = 1.1246000000; feg[195] = 0.0281000000;
					g[196] = 9.8000000000; fxg[196] = 1.1215000000; feg[196] = 0.0278000000;
					g[197] = 9.8500000000; fxg[197] = 1.1192000000; feg[197] = 0.0275000000;
					g[198] = 9.9000000000; fxg[198] = 1.1172000000; feg[198] = 0.0272000000;
					g[199] = 9.9500000000; fxg[199] = 1.1148000000; feg[199] = 0.0270000000;
					g[200] = 10.0000000000; fxg[200] = 1.1115000000; feg[200] = 0.0267000000;
					g[201] = 10.0500000000; fxg[201] = 1.1070000000; feg[201] = 0.0264000000;
					g[202] = 10.1000000000; fxg[202] = 1.1015000000; feg[202] = 0.0262000000;
					g[203] = 10.1500000000; fxg[203] = 1.0953000000; feg[203] = 0.0259000000;
					g[204] = 10.2000000000; fxg[204] = 1.0889000000; feg[204] = 0.0257000000;
					g[205] = 10.2500000000; fxg[205] = 1.0828000000; feg[205] = 0.0254000000;
					g[206] = 10.3000000000; fxg[206] = 1.0771000000; feg[206] = 0.0252000000;
					g[207] = 10.3500000000; fxg[207] = 1.0718000000; feg[207] = 0.0250000000;
					g[208] = 10.4000000000; fxg[208] = 1.0665000000; feg[208] = 0.0247000000;
					g[209] = 10.4500000000; fxg[209] = 1.0609000000; feg[209] = 0.0245000000;
					g[210] = 10.5000000000; fxg[210] = 1.0550000000; feg[210] = 0.0243000000;
					g[211] = 10.5500000000; fxg[211] = 1.0490000000; feg[211] = 0.0240000000;
					g[212] = 10.6000000000; fxg[212] = 1.0431000000; feg[212] = 0.0238000000;
					g[213] = 10.6500000000; fxg[213] = 1.0376000000; feg[213] = 0.0236000000;
					g[214] = 10.7000000000; fxg[214] = 1.0327000000; feg[214] = 0.0234000000;
					g[215] = 10.7500000000; fxg[215] = 1.0287000000; feg[215] = 0.0232000000;
					g[216] = 10.8000000000; fxg[216] = 1.0258000000; feg[216] = 0.0230000000;
					g[217] = 10.8500000000; fxg[217] = 1.0239000000; feg[217] = 0.0228000000;
					g[218] = 10.9000000000; fxg[218] = 1.0227000000; feg[218] = 0.0225000000;
					g[219] = 10.9500000000; fxg[219] = 1.0216000000; feg[219] = 0.0223000000;
					g[220] = 11.0000000000; fxg[220] = 1.0198000000; feg[220] = 0.0221000000;
					g[221] = 11.0500000000; fxg[221] = 1.0171000000; feg[221] = 0.0219000000;
					g[222] = 11.1000000000; fxg[222] = 1.0133000000; feg[222] = 0.0217000000;
					g[223] = 11.1500000000; fxg[223] = 1.0084000000; feg[223] = 0.0216000000;
					g[224] = 11.2000000000; fxg[224] = 1.0027000000; feg[224] = 0.0214000000;
					g[225] = 11.2500000000; fxg[225] = 0.9966000000; feg[225] = 0.0212000000;
					g[226] = 11.3000000000; fxg[226] = 0.9906000000; feg[226] = 0.0210000000;
					g[227] = 11.3500000000; fxg[227] = 0.9849000000; feg[227] = 0.0208000000;
					g[228] = 11.4000000000; fxg[228] = 0.9797000000; feg[228] = 0.0206000000;
					g[229] = 11.4500000000; fxg[229] = 0.9748000000; feg[229] = 0.0205000000;
					g[230] = 11.5000000000; fxg[230] = 0.9697000000; feg[230] = 0.0203000000;
					g[231] = 11.5500000000; fxg[231] = 0.9642000000; feg[231] = 0.0201000000;
					g[232] = 11.6000000000; fxg[232] = 0.9585000000; feg[232] = 0.0200000000;
					g[233] = 11.6500000000; fxg[233] = 0.9526000000; feg[233] = 0.0198000000;
					g[234] = 11.7000000000; fxg[234] = 0.9469000000; feg[234] = 0.0196000000;
					g[235] = 11.7500000000; fxg[235] = 0.9415000000; feg[235] = 0.0195000000;
					g[236] = 11.8000000000; fxg[236] = 0.9366000000; feg[236] = 0.0193000000;
					g[237] = 11.8500000000; fxg[237] = 0.9324000000; feg[237] = 0.0191000000;
					g[238] = 11.9000000000; fxg[238] = 0.9292000000; feg[238] = 0.0190000000;
					g[239] = 11.9500000000; fxg[239] = 0.9271000000; feg[239] = 0.0188000000;
					g[240] = 12.0000000000; fxg[240] = 0.9261000000; feg[240] = 0.0187000000;
					break;
				case 30:
					g[0] = 0.0000000000; fxg[0] = 30.0000000000; feg[0] = 6.0656000000;
					g[1] = 0.0500000000; fxg[1] = 29.8439000000; feg[1] = 5.9787000000;
					g[2] = 0.1000000000; fxg[2] = 29.4009000000; feg[2] = 5.7352000000;
					g[3] = 0.1500000000; fxg[3] = 28.7359000000; feg[3] = 5.3786000000;
					g[4] = 0.2000000000; fxg[4] = 27.9267000000; feg[4] = 4.9622000000;
					g[5] = 0.2500000000; fxg[5] = 27.0406000000; feg[5] = 4.5331000000;
					g[6] = 0.3000000000; fxg[6] = 26.1235000000; feg[6] = 4.1235000000;
					g[7] = 0.3500000000; fxg[7] = 25.2007000000; feg[7] = 3.7507000000;
					g[8] = 0.4000000000; fxg[8] = 24.2834000000; feg[8] = 3.4205000000;
					g[9] = 0.4500000000; fxg[9] = 23.3754000000; feg[9] = 3.1319000000;
					g[10] = 0.5000000000; fxg[10] = 22.4782000000; feg[10] = 2.8804000000;
					g[11] = 0.5500000000; fxg[11] = 21.5926000000; feg[11] = 2.6607000000;
					g[12] = 0.6000000000; fxg[12] = 20.7205000000; feg[12] = 2.4677000000;
					g[13] = 0.6500000000; fxg[13] = 19.8643000000; feg[13] = 2.2967000000;
					g[14] = 0.7000000000; fxg[14] = 19.0269000000; feg[14] = 2.1439000000;
					g[15] = 0.7500000000; fxg[15] = 18.2115000000; feg[15] = 2.0063000000;
					g[16] = 0.8000000000; fxg[16] = 17.4212000000; feg[16] = 1.8816000000;
					g[17] = 0.8500000000; fxg[17] = 16.6586000000; feg[17] = 1.7678000000;
					g[18] = 0.9000000000; fxg[18] = 15.9262000000; feg[18] = 1.6634000000;
					g[19] = 0.9500000000; fxg[19] = 15.2258000000; feg[19] = 1.5672000000;
					g[20] = 1.0000000000; fxg[20] = 14.5587000000; feg[20] = 1.4783000000;
					g[21] = 1.0500000000; fxg[21] = 13.9258000000; feg[21] = 1.3958000000;
					g[22] = 1.1000000000; fxg[22] = 13.3274000000; feg[22] = 1.3191000000;
					g[23] = 1.1500000000; fxg[23] = 12.7637000000; feg[23] = 1.2477000000;
					g[24] = 1.2000000000; fxg[24] = 12.2342000000; feg[24] = 1.1811000000;
					g[25] = 1.2500000000; fxg[25] = 11.7383000000; feg[25] = 1.1189000000;
					g[26] = 1.3000000000; fxg[26] = 11.2750000000; feg[26] = 1.0607000000;
					g[27] = 1.3500000000; fxg[27] = 10.8432000000; feg[27] = 1.0063000000;
					g[28] = 1.4000000000; fxg[28] = 10.4416000000; feg[28] = 0.9553000000;
					g[29] = 1.4500000000; fxg[29] = 10.0688000000; feg[29] = 0.9075000000;
					g[30] = 1.5000000000; fxg[30] = 9.7231000000; feg[30] = 0.8628000000;
					g[31] = 1.5500000000; fxg[31] = 9.4031000000; feg[31] = 0.8207000000;
					g[32] = 1.6000000000; fxg[32] = 9.1072000000; feg[32] = 0.7813000000;
					g[33] = 1.6500000000; fxg[33] = 8.8336000000; feg[33] = 0.7443000000;
					g[34] = 1.7000000000; fxg[34] = 8.5809000000; feg[34] = 0.7095000000;
					g[35] = 1.7500000000; fxg[35] = 8.3474000000; feg[35] = 0.6769000000;
					g[36] = 1.8000000000; fxg[36] = 8.1315000000; feg[36] = 0.6462000000;
					g[37] = 1.8500000000; fxg[37] = 7.9319000000; feg[37] = 0.6173000000;
					g[38] = 1.9000000000; fxg[38] = 7.7471000000; feg[38] = 0.5901000000;
					g[39] = 1.9500000000; fxg[39] = 7.5757000000; feg[39] = 0.5646000000;
					g[40] = 2.0000000000; fxg[40] = 7.4165000000; feg[40] = 0.5405000000;
					g[41] = 2.0500000000; fxg[41] = 7.2683000000; feg[41] = 0.5178000000;
					g[42] = 2.1000000000; fxg[42] = 7.1299000000; feg[42] = 0.4965000000;
					g[43] = 2.1500000000; fxg[43] = 7.0004000000; feg[43] = 0.4763000000;
					g[44] = 2.2000000000; fxg[44] = 6.8787000000; feg[44] = 0.4573000000;
					g[45] = 2.2500000000; fxg[45] = 6.7640000000; feg[45] = 0.4394000000;
					g[46] = 2.3000000000; fxg[46] = 6.6553000000; feg[46] = 0.4225000000;
					g[47] = 2.3500000000; fxg[47] = 6.5521000000; feg[47] = 0.4065000000;
					g[48] = 2.4000000000; fxg[48] = 6.4537000000; feg[48] = 0.3914000000;
					g[49] = 2.4500000000; fxg[49] = 6.3595000000; feg[49] = 0.3770000000;
					g[50] = 2.5000000000; fxg[50] = 6.2687000000; feg[50] = 0.3635000000;
					g[51] = 2.5500000000; fxg[51] = 6.1809000000; feg[51] = 0.3507000000;
					g[52] = 2.6000000000; fxg[52] = 6.0958000000; feg[52] = 0.3385000000;
					g[53] = 2.6500000000; fxg[53] = 6.0131000000; feg[53] = 0.3270000000;
					g[54] = 2.7000000000; fxg[54] = 5.9324000000; feg[54] = 0.3161000000;
					g[55] = 2.7500000000; fxg[55] = 5.8532000000; feg[55] = 0.3057000000;
					g[56] = 2.8000000000; fxg[56] = 5.7752000000; feg[56] = 0.2958000000;
					g[57] = 2.8500000000; fxg[57] = 5.6982000000; feg[57] = 0.2864000000;
					g[58] = 2.9000000000; fxg[58] = 5.6224000000; feg[58] = 0.2775000000;
					g[59] = 2.9500000000; fxg[59] = 5.5476000000; feg[59] = 0.2690000000;
					g[60] = 3.0000000000; fxg[60] = 5.4735000000; feg[60] = 0.2609000000;
					g[61] = 3.0500000000; fxg[61] = 5.3997000000; feg[61] = 0.2532000000;
					g[62] = 3.1000000000; fxg[62] = 5.3261000000; feg[62] = 0.2458000000;
					g[63] = 3.1500000000; fxg[63] = 5.2528000000; feg[63] = 0.2388000000;
					g[64] = 3.2000000000; fxg[64] = 5.1800000000; feg[64] = 0.2320000000;
					g[65] = 3.2500000000; fxg[65] = 5.1079000000; feg[65] = 0.2256000000;
					g[66] = 3.3000000000; fxg[66] = 5.0364000000; feg[66] = 0.2195000000;
					g[67] = 3.3500000000; fxg[67] = 4.9649000000; feg[67] = 0.2136000000;
					g[68] = 3.4000000000; fxg[68] = 4.8932000000; feg[68] = 0.2079000000;
					g[69] = 3.4500000000; fxg[69] = 4.8214000000; feg[69] = 0.2025000000;
					g[70] = 3.5000000000; fxg[70] = 4.7499000000; feg[70] = 0.1973000000;
					g[71] = 3.5500000000; fxg[71] = 4.6792000000; feg[71] = 0.1923000000;
					g[72] = 3.6000000000; fxg[72] = 4.6094000000; feg[72] = 0.1876000000;
					g[73] = 3.6500000000; fxg[73] = 4.5401000000; feg[73] = 0.1830000000;
					g[74] = 3.7000000000; fxg[74] = 4.4710000000; feg[74] = 0.1785000000;
					g[75] = 3.7500000000; fxg[75] = 4.4018000000; feg[75] = 0.1743000000;
					g[76] = 3.8000000000; fxg[76] = 4.3325000000; feg[76] = 0.1702000000;
					g[77] = 3.8500000000; fxg[77] = 4.2635000000; feg[77] = 0.1662000000;
					g[78] = 3.9000000000; fxg[78] = 4.1954000000; feg[78] = 0.1624000000;
					g[79] = 3.9500000000; fxg[79] = 4.1287000000; feg[79] = 0.1587000000;
					g[80] = 4.0000000000; fxg[80] = 4.0631000000; feg[80] = 0.1552000000;
					g[81] = 4.0500000000; fxg[81] = 3.9983000000; feg[81] = 0.1518000000;
					g[82] = 4.1000000000; fxg[82] = 3.9337000000; feg[82] = 0.1485000000;
					g[83] = 4.1500000000; fxg[83] = 3.8690000000; feg[83] = 0.1453000000;
					g[84] = 4.2000000000; fxg[84] = 3.8045000000; feg[84] = 0.1422000000;
					g[85] = 4.2500000000; fxg[85] = 3.7406000000; feg[85] = 0.1392000000;
					g[86] = 4.3000000000; fxg[86] = 3.6779000000; feg[86] = 0.1363000000;
					g[87] = 4.3500000000; fxg[87] = 3.6167000000; feg[87] = 0.1335000000;
					g[88] = 4.4000000000; fxg[88] = 3.5573000000; feg[88] = 0.1308000000;
					g[89] = 4.4500000000; fxg[89] = 3.4991000000; feg[89] = 0.1281000000;
					g[90] = 4.5000000000; fxg[90] = 3.4415000000; feg[90] = 0.1256000000;
					g[91] = 4.5500000000; fxg[91] = 3.3842000000; feg[91] = 0.1231000000;
					g[92] = 4.6000000000; fxg[92] = 3.3269000000; feg[92] = 0.1207000000;
					g[93] = 4.6500000000; fxg[93] = 3.2701000000; feg[93] = 0.1183000000;
					g[94] = 4.7000000000; fxg[94] = 3.2141000000; feg[94] = 0.1161000000;
					g[95] = 4.7500000000; fxg[95] = 3.1594000000; feg[95] = 0.1139000000;
					g[96] = 4.8000000000; fxg[96] = 3.1065000000; feg[96] = 0.1117000000;
					g[97] = 4.8500000000; fxg[97] = 3.0555000000; feg[97] = 0.1097000000;
					g[98] = 4.9000000000; fxg[98] = 3.0062000000; feg[98] = 0.1076000000;
					g[99] = 4.9500000000; fxg[99] = 2.9578000000; feg[99] = 0.1057000000;
					g[100] = 5.0000000000; fxg[100] = 2.9098000000; feg[100] = 0.1037000000;
					g[101] = 5.0500000000; fxg[101] = 2.8619000000; feg[101] = 0.1019000000;
					g[102] = 5.1000000000; fxg[102] = 2.8142000000; feg[102] = 0.1001000000;
					g[103] = 5.1500000000; fxg[103] = 2.7671000000; feg[103] = 0.0983000000;
					g[104] = 5.2000000000; fxg[104] = 2.7210000000; feg[104] = 0.0966000000;
					g[105] = 5.2500000000; fxg[105] = 2.6762000000; feg[105] = 0.0949000000;
					g[106] = 5.3000000000; fxg[106] = 2.6331000000; feg[106] = 0.0933000000;
					g[107] = 5.3500000000; fxg[107] = 2.5920000000; feg[107] = 0.0917000000;
					g[108] = 5.4000000000; fxg[108] = 2.5528000000; feg[108] = 0.0901000000;
					g[109] = 5.4500000000; fxg[109] = 2.5146000000; feg[109] = 0.0886000000;
					g[110] = 5.5000000000; fxg[110] = 2.4769000000; feg[110] = 0.0871000000;
					g[111] = 5.5500000000; fxg[111] = 2.4392000000; feg[111] = 0.0857000000;
					g[112] = 5.6000000000; fxg[112] = 2.4016000000; feg[112] = 0.0843000000;
					g[113] = 5.6500000000; fxg[113] = 2.3643000000; feg[113] = 0.0829000000;
					g[114] = 5.7000000000; fxg[114] = 2.3277000000; feg[114] = 0.0815000000;
					g[115] = 5.7500000000; fxg[115] = 2.2919000000; feg[115] = 0.0802000000;
					g[116] = 5.8000000000; fxg[116] = 2.2572000000; feg[116] = 0.0790000000;
					g[117] = 5.8500000000; fxg[117] = 2.2241000000; feg[117] = 0.0777000000;
					g[118] = 5.9000000000; fxg[118] = 2.1928000000; feg[118] = 0.0765000000;
					g[119] = 5.9500000000; fxg[119] = 2.1634000000; feg[119] = 0.0753000000;
					g[120] = 6.0000000000; fxg[120] = 2.1353000000; feg[120] = 0.0741000000;
					g[121] = 6.0500000000; fxg[121] = 2.1077000000; feg[121] = 0.0730000000;
					g[122] = 6.1000000000; fxg[122] = 2.0800000000; feg[122] = 0.0718000000;
					g[123] = 6.1500000000; fxg[123] = 2.0520000000; feg[123] = 0.0707000000;
					g[124] = 6.2000000000; fxg[124] = 2.0240000000; feg[124] = 0.0697000000;
					g[125] = 6.2500000000; fxg[125] = 1.9965000000; feg[125] = 0.0686000000;
					g[126] = 6.3000000000; fxg[126] = 1.9696000000; feg[126] = 0.0676000000;
					g[127] = 6.3500000000; fxg[127] = 1.9433000000; feg[127] = 0.0666000000;
					g[128] = 6.4000000000; fxg[128] = 1.9178000000; feg[128] = 0.0656000000;
					g[129] = 6.4500000000; fxg[129] = 1.8933000000; feg[129] = 0.0647000000;
					g[130] = 6.5000000000; fxg[130] = 1.8704000000; feg[130] = 0.0637000000;
					g[131] = 6.5500000000; fxg[131] = 1.8493000000; feg[131] = 0.0628000000;
					g[132] = 6.6000000000; fxg[132] = 1.8297000000; feg[132] = 0.0619000000;
					g[133] = 6.6500000000; fxg[133] = 1.8109000000; feg[133] = 0.0610000000;
					g[134] = 6.7000000000; fxg[134] = 1.7920000000; feg[134] = 0.0602000000;
					g[135] = 6.7500000000; fxg[135] = 1.7726000000; feg[135] = 0.0593000000;
					g[136] = 6.8000000000; fxg[136] = 1.7528000000; feg[136] = 0.0585000000;
					g[137] = 6.8500000000; fxg[137] = 1.7329000000; feg[137] = 0.0577000000;
					g[138] = 6.9000000000; fxg[138] = 1.7134000000; feg[138] = 0.0569000000;
					g[139] = 6.9500000000; fxg[139] = 1.6945000000; feg[139] = 0.0561000000;
					g[140] = 7.0000000000; fxg[140] = 1.6761000000; feg[140] = 0.0553000000;
					g[141] = 7.0500000000; fxg[141] = 1.6579000000; feg[141] = 0.0546000000;
					g[142] = 7.1000000000; fxg[142] = 1.6403000000; feg[142] = 0.0539000000;
					g[143] = 7.1500000000; fxg[143] = 1.6236000000; feg[143] = 0.0531000000;
					g[144] = 7.2000000000; fxg[144] = 1.6084000000; feg[144] = 0.0524000000;
					g[145] = 7.2500000000; fxg[145] = 1.5948000000; feg[145] = 0.0517000000;
					g[146] = 7.3000000000; fxg[146] = 1.5826000000; feg[146] = 0.0511000000;
					g[147] = 7.3500000000; fxg[147] = 1.5708000000; feg[147] = 0.0504000000;
					g[148] = 7.4000000000; fxg[148] = 1.5587000000; feg[148] = 0.0497000000;
					g[149] = 7.4500000000; fxg[149] = 1.5458000000; feg[149] = 0.0491000000;
					g[150] = 7.5000000000; fxg[150] = 1.5321000000; feg[150] = 0.0485000000;
					g[151] = 7.5500000000; fxg[151] = 1.5182000000; feg[151] = 0.0478000000;
					g[152] = 7.6000000000; fxg[152] = 1.5045000000; feg[152] = 0.0472000000;
					g[153] = 7.6500000000; fxg[153] = 1.4914000000; feg[153] = 0.0466000000;
					g[154] = 7.7000000000; fxg[154] = 1.4788000000; feg[154] = 0.0461000000;
					g[155] = 7.7500000000; fxg[155] = 1.4663000000; feg[155] = 0.0455000000;
					g[156] = 7.8000000000; fxg[156] = 1.4538000000; feg[156] = 0.0449000000;
					g[157] = 7.8500000000; fxg[157] = 1.4415000000; feg[157] = 0.0444000000;
					g[158] = 7.9000000000; fxg[158] = 1.4298000000; feg[158] = 0.0438000000;
					g[159] = 7.9500000000; fxg[159] = 1.4195000000; feg[159] = 0.0433000000;
					g[160] = 8.0000000000; fxg[160] = 1.4106000000; feg[160] = 0.0428000000;
					g[161] = 8.0500000000; fxg[161] = 1.4031000000; feg[161] = 0.0422000000;
					g[162] = 8.1000000000; fxg[162] = 1.3962000000; feg[162] = 0.0417000000;
					g[163] = 8.1500000000; fxg[163] = 1.3892000000; feg[163] = 0.0412000000;
					g[164] = 8.2000000000; fxg[164] = 1.3813000000; feg[164] = 0.0407000000;
					g[165] = 8.2500000000; fxg[165] = 1.3722000000; feg[165] = 0.0403000000;
					g[166] = 8.3000000000; fxg[166] = 1.3624000000; feg[166] = 0.0398000000;
					g[167] = 8.3500000000; fxg[167] = 1.3524000000; feg[167] = 0.0393000000;
					g[168] = 8.4000000000; fxg[168] = 1.3428000000; feg[168] = 0.0389000000;
					g[169] = 8.4500000000; fxg[169] = 1.3337000000; feg[169] = 0.0384000000;
					g[170] = 8.5000000000; fxg[170] = 1.3251000000; feg[170] = 0.0380000000;
					g[171] = 8.5500000000; fxg[171] = 1.3166000000; feg[171] = 0.0376000000;
					g[172] = 8.6000000000; fxg[172] = 1.3078000000; feg[172] = 0.0371000000;
					g[173] = 8.6500000000; fxg[173] = 1.2988000000; feg[173] = 0.0367000000;
					g[174] = 8.7000000000; fxg[174] = 1.2899000000; feg[174] = 0.0363000000;
					g[175] = 8.7500000000; fxg[175] = 1.2818000000; feg[175] = 0.0359000000;
					g[176] = 8.8000000000; fxg[176] = 1.2749000000; feg[176] = 0.0355000000;
					g[177] = 8.8500000000; fxg[177] = 1.2695000000; feg[177] = 0.0351000000;
					g[178] = 8.9000000000; fxg[178] = 1.2653000000; feg[178] = 0.0347000000;
					g[179] = 8.9500000000; fxg[179] = 1.2617000000; feg[179] = 0.0343000000;
					g[180] = 9.0000000000; fxg[180] = 1.2577000000; feg[180] = 0.0340000000;
					g[181] = 9.0500000000; fxg[181] = 1.2528000000; feg[181] = 0.0336000000;
					g[182] = 9.1000000000; fxg[182] = 1.2466000000; feg[182] = 0.0332000000;
					g[183] = 9.1500000000; fxg[183] = 1.2393000000; feg[183] = 0.0329000000;
					g[184] = 9.2000000000; fxg[184] = 1.2314000000; feg[184] = 0.0325000000;
					g[185] = 9.2500000000; fxg[185] = 1.2238000000; feg[185] = 0.0322000000;
					g[186] = 9.3000000000; fxg[186] = 1.2167000000; feg[186] = 0.0319000000;
					g[187] = 9.3500000000; fxg[187] = 1.2103000000; feg[187] = 0.0315000000;
					g[188] = 9.4000000000; fxg[188] = 1.2042000000; feg[188] = 0.0312000000;
					g[189] = 9.4500000000; fxg[189] = 1.1979000000; feg[189] = 0.0309000000;
					g[190] = 9.5000000000; fxg[190] = 1.1912000000; feg[190] = 0.0306000000;
					g[191] = 9.5500000000; fxg[191] = 1.1841000000; feg[191] = 0.0302000000;
					g[192] = 9.6000000000; fxg[192] = 1.1770000000; feg[192] = 0.0299000000;
					g[193] = 9.6500000000; fxg[193] = 1.1703000000; feg[193] = 0.0296000000;
					g[194] = 9.7000000000; fxg[194] = 1.1645000000; feg[194] = 0.0293000000;
					g[195] = 9.7500000000; fxg[195] = 1.1600000000; feg[195] = 0.0290000000;
					g[196] = 9.8000000000; fxg[196] = 1.1569000000; feg[196] = 0.0288000000;
					g[197] = 9.8500000000; fxg[197] = 1.1548000000; feg[197] = 0.0285000000;
					g[198] = 9.9000000000; fxg[198] = 1.1530000000; feg[198] = 0.0282000000;
					g[199] = 9.9500000000; fxg[199] = 1.1507000000; feg[199] = 0.0279000000;
					g[200] = 10.0000000000; fxg[200] = 1.1473000000; feg[200] = 0.0276000000;
					g[201] = 10.0500000000; fxg[201] = 1.1425000000; feg[201] = 0.0274000000;
					g[202] = 10.1000000000; fxg[202] = 1.1365000000; feg[202] = 0.0271000000;
					g[203] = 10.1500000000; fxg[203] = 1.1297000000; feg[203] = 0.0268000000;
					g[204] = 10.2000000000; fxg[204] = 1.1230000000; feg[204] = 0.0266000000;
					g[205] = 10.2500000000; fxg[205] = 1.1168000000; feg[205] = 0.0263000000;
					g[206] = 10.3000000000; fxg[206] = 1.1113000000; feg[206] = 0.0261000000;
					g[207] = 10.3500000000; fxg[207] = 1.1063000000; feg[207] = 0.0258000000;
					g[208] = 10.4000000000; fxg[208] = 1.1014000000; feg[208] = 0.0256000000;
					g[209] = 10.4500000000; fxg[209] = 1.0962000000; feg[209] = 0.0253000000;
					g[210] = 10.5000000000; fxg[210] = 1.0905000000; feg[210] = 0.0251000000;
					g[211] = 10.5500000000; fxg[211] = 1.0843000000; feg[211] = 0.0249000000;
					g[212] = 10.6000000000; fxg[212] = 1.0780000000; feg[212] = 0.0246000000;
					g[213] = 10.6500000000; fxg[213] = 1.0720000000; feg[213] = 0.0244000000;
					g[214] = 10.7000000000; fxg[214] = 1.0666000000; feg[214] = 0.0242000000;
					g[215] = 10.7500000000; fxg[215] = 1.0623000000; feg[215] = 0.0240000000;
					g[216] = 10.8000000000; fxg[216] = 1.0594000000; feg[216] = 0.0238000000;
					g[217] = 10.8500000000; fxg[217] = 1.0577000000; feg[217] = 0.0235000000;
					g[218] = 10.9000000000; fxg[218] = 1.0568000000; feg[218] = 0.0233000000;
					g[219] = 10.9500000000; fxg[219] = 1.0560000000; feg[219] = 0.0231000000;
					g[220] = 11.0000000000; fxg[220] = 1.0545000000; feg[220] = 0.0229000000;
					g[221] = 11.0500000000; fxg[221] = 1.0519000000; feg[221] = 0.0227000000;
					g[222] = 11.1000000000; fxg[222] = 1.0478000000; feg[222] = 0.0225000000;
					g[223] = 11.1500000000; fxg[223] = 1.0425000000; feg[223] = 0.0223000000;
					g[224] = 11.2000000000; fxg[224] = 1.0363000000; feg[224] = 0.0221000000;
					g[225] = 11.2500000000; fxg[225] = 1.0298000000; feg[225] = 0.0219000000;
					g[226] = 11.3000000000; fxg[226] = 1.0237000000; feg[226] = 0.0217000000;
					g[227] = 11.3500000000; fxg[227] = 1.0183000000; feg[227] = 0.0215000000;
					g[228] = 11.4000000000; fxg[228] = 1.0136000000; feg[228] = 0.0214000000;
					g[229] = 11.4500000000; fxg[229] = 1.0092000000; feg[229] = 0.0212000000;
					g[230] = 11.5000000000; fxg[230] = 1.0048000000; feg[230] = 0.0210000000;
					g[231] = 11.5500000000; fxg[231] = 1.0000000000; feg[231] = 0.0208000000;
					g[232] = 11.6000000000; fxg[232] = 0.9946000000; feg[232] = 0.0206000000;
					g[233] = 11.6500000000; fxg[233] = 0.9888000000; feg[233] = 0.0205000000;
					g[234] = 11.7000000000; fxg[234] = 0.9829000000; feg[234] = 0.0203000000;
					g[235] = 11.7500000000; fxg[235] = 0.9771000000; feg[235] = 0.0201000000;
					g[236] = 11.8000000000; fxg[236] = 0.9718000000; feg[236] = 0.0200000000;
					g[237] = 11.8500000000; fxg[237] = 0.9673000000; feg[237] = 0.0198000000;
					g[238] = 11.9000000000; fxg[238] = 0.9639000000; feg[238] = 0.0196000000;
					g[239] = 11.9500000000; fxg[239] = 0.9618000000; feg[239] = 0.0195000000;
					g[240] = 12.0000000000; fxg[240] = 0.9609000000; feg[240] = 0.0193000000;
					break;
				case 31:
					g[0] = 0.0000000000; fxg[0] = 31.0000000000; feg[0] = 7.1088000000;
					g[1] = 0.0500000000; fxg[1] = 30.8177000000; feg[1] = 6.9809000000;
					g[2] = 0.1000000000; fxg[2] = 30.3076000000; feg[2] = 6.6283000000;
					g[3] = 0.1500000000; fxg[3] = 29.5599000000; feg[3] = 6.1276000000;
					g[4] = 0.2000000000; fxg[4] = 28.6752000000; feg[4] = 5.5640000000;
					g[5] = 0.2500000000; fxg[5] = 27.7333000000; feg[5] = 5.0037000000;
					g[6] = 0.3000000000; fxg[6] = 26.7829000000; feg[6] = 4.4858000000;
					g[7] = 0.3500000000; fxg[7] = 25.8474000000; feg[7] = 4.0268000000;
					g[8] = 0.4000000000; fxg[8] = 24.9346000000; feg[8] = 3.6292000000;
					g[9] = 0.4500000000; fxg[9] = 24.0445000000; feg[9] = 3.2883000000;
					g[10] = 0.5000000000; fxg[10] = 23.1740000000; feg[10] = 2.9969000000;
					g[11] = 0.5500000000; fxg[11] = 22.3203000000; feg[11] = 2.7469000000;
					g[12] = 0.6000000000; fxg[12] = 21.4813000000; feg[12] = 2.5313000000;
					g[13] = 0.6500000000; fxg[13] = 20.6566000000; feg[13] = 2.3437000000;
					g[14] = 0.7000000000; fxg[14] = 19.8467000000; feg[14] = 2.1791000000;
					g[15] = 0.7500000000; fxg[15] = 19.0533000000; feg[15] = 2.0333000000;
					g[16] = 0.8000000000; fxg[16] = 18.2783000000; feg[16] = 1.9030000000;
					g[17] = 0.8500000000; fxg[17] = 17.5243000000; feg[17] = 1.7856000000;
					g[18] = 0.9000000000; fxg[18] = 16.7935000000; feg[18] = 1.6791000000;
					g[19] = 0.9500000000; fxg[19] = 16.0881000000; feg[19] = 1.5818000000;
					g[20] = 1.0000000000; fxg[20] = 15.4100000000; feg[20] = 1.4925000000;
					g[21] = 1.0500000000; fxg[21] = 14.7608000000; feg[21] = 1.4101000000;
					g[22] = 1.1000000000; fxg[22] = 14.1415000000; feg[22] = 1.3338000000;
					g[23] = 1.1500000000; fxg[23] = 13.5530000000; feg[23] = 1.2630000000;
					g[24] = 1.2000000000; fxg[24] = 12.9955000000; feg[24] = 1.1970000000;
					g[25] = 1.2500000000; fxg[25] = 12.4692000000; feg[25] = 1.1354000000;
					g[26] = 1.3000000000; fxg[26] = 11.9737000000; feg[26] = 1.0778000000;
					g[27] = 1.3500000000; fxg[27] = 11.5084000000; feg[27] = 1.0239000000;
					g[28] = 1.4000000000; fxg[28] = 11.0727000000; feg[28] = 0.9733000000;
					g[29] = 1.4500000000; fxg[29] = 10.6655000000; feg[29] = 0.9259000000;
					g[30] = 1.5000000000; fxg[30] = 10.2858000000; feg[30] = 0.8814000000;
					g[31] = 1.5500000000; fxg[31] = 9.9322000000; feg[31] = 0.8395000000;
					g[32] = 1.6000000000; fxg[32] = 9.6035000000; feg[32] = 0.8002000000;
					g[33] = 1.6500000000; fxg[33] = 9.2983000000; feg[33] = 0.7631000000;
					g[34] = 1.7000000000; fxg[34] = 9.0152000000; feg[34] = 0.7283000000;
					g[35] = 1.7500000000; fxg[35] = 8.7527000000; feg[35] = 0.6955000000;
					g[36] = 1.8000000000; fxg[36] = 8.5095000000; feg[36] = 0.6645000000;
					g[37] = 1.8500000000; fxg[37] = 8.2842000000; feg[37] = 0.6354000000;
					g[38] = 1.9000000000; fxg[38] = 8.0753000000; feg[38] = 0.6079000000;
					g[39] = 1.9500000000; fxg[39] = 7.8816000000; feg[39] = 0.5820000000;
					g[40] = 2.0000000000; fxg[40] = 7.7019000000; feg[40] = 0.5576000000;
					g[41] = 2.0500000000; fxg[41] = 7.5349000000; feg[41] = 0.5345000000;
					g[42] = 2.1000000000; fxg[42] = 7.3793000000; feg[42] = 0.5128000000;
					g[43] = 2.1500000000; fxg[43] = 7.2343000000; feg[43] = 0.4922000000;
					g[44] = 2.2000000000; fxg[44] = 7.0988000000; feg[44] = 0.4728000000;
					g[45] = 2.2500000000; fxg[45] = 6.9718000000; feg[45] = 0.4544000000;
					g[46] = 2.3000000000; fxg[46] = 6.8522000000; feg[46] = 0.4370000000;
					g[47] = 2.3500000000; fxg[47] = 6.7395000000; feg[47] = 0.4206000000;
					g[48] = 2.4000000000; fxg[48] = 6.6329000000; feg[48] = 0.4050000000;
					g[49] = 2.4500000000; fxg[49] = 6.5318000000; feg[49] = 0.3902000000;
					g[50] = 2.5000000000; fxg[50] = 6.4353000000; feg[50] = 0.3763000000;
					g[51] = 2.5500000000; fxg[51] = 6.3427000000; feg[51] = 0.3630000000;
					g[52] = 2.6000000000; fxg[52] = 6.2538000000; feg[52] = 0.3505000000;
					g[53] = 2.6500000000; fxg[53] = 6.1682000000; feg[53] = 0.3385000000;
					g[54] = 2.7000000000; fxg[54] = 6.0857000000; feg[54] = 0.3272000000;
					g[55] = 2.7500000000; fxg[55] = 6.0053000000; feg[55] = 0.3164000000;
					g[56] = 2.8000000000; fxg[56] = 5.9265000000; feg[56] = 0.3062000000;
					g[57] = 2.8500000000; fxg[57] = 5.8494000000; feg[57] = 0.2964000000;
					g[58] = 2.9000000000; fxg[58] = 5.7739000000; feg[58] = 0.2872000000;
					g[59] = 2.9500000000; fxg[59] = 5.7001000000; feg[59] = 0.2783000000;
					g[60] = 3.0000000000; fxg[60] = 5.6276000000; feg[60] = 0.2699000000;
					g[61] = 3.0500000000; fxg[61] = 5.5555000000; feg[61] = 0.2619000000;
					g[62] = 3.1000000000; fxg[62] = 5.4837000000; feg[62] = 0.2542000000;
					g[63] = 3.1500000000; fxg[63] = 5.4123000000; feg[63] = 0.2469000000;
					g[64] = 3.2000000000; fxg[64] = 5.3417000000; feg[64] = 0.2399000000;
					g[65] = 3.2500000000; fxg[65] = 5.2722000000; feg[65] = 0.2332000000;
					g[66] = 3.3000000000; fxg[66] = 5.2034000000; feg[66] = 0.2268000000;
					g[67] = 3.3500000000; fxg[67] = 5.1347000000; feg[67] = 0.2206000000;
					g[68] = 3.4000000000; fxg[68] = 5.0656000000; feg[68] = 0.2148000000;
					g[69] = 3.4500000000; fxg[69] = 4.9963000000; feg[69] = 0.2092000000;
					g[70] = 3.5000000000; fxg[70] = 4.9272000000; feg[70] = 0.2038000000;
					g[71] = 3.5500000000; fxg[71] = 4.8589000000; feg[71] = 0.1986000000;
					g[72] = 3.6000000000; fxg[72] = 4.7917000000; feg[72] = 0.1936000000;
					g[73] = 3.6500000000; fxg[73] = 4.7251000000; feg[73] = 0.1888000000;
					g[74] = 3.7000000000; fxg[74] = 4.6584000000; feg[74] = 0.1842000000;
					g[75] = 3.7500000000; fxg[75] = 4.5913000000; feg[75] = 0.1798000000;
					g[76] = 3.8000000000; fxg[76] = 4.5237000000; feg[76] = 0.1755000000;
					g[77] = 3.8500000000; fxg[77] = 4.4563000000; feg[77] = 0.1714000000;
					g[78] = 3.9000000000; fxg[78] = 4.3897000000; feg[78] = 0.1675000000;
					g[79] = 3.9500000000; fxg[79] = 4.3245000000; feg[79] = 0.1637000000;
					g[80] = 4.0000000000; fxg[80] = 4.2606000000; feg[80] = 0.1600000000;
					g[81] = 4.0500000000; fxg[81] = 4.1972000000; feg[81] = 0.1564000000;
					g[82] = 4.1000000000; fxg[82] = 4.1337000000; feg[82] = 0.1530000000;
					g[83] = 4.1500000000; fxg[83] = 4.0698000000; feg[83] = 0.1497000000;
					g[84] = 4.2000000000; fxg[84] = 4.0056000000; feg[84] = 0.1465000000;
					g[85] = 4.2500000000; fxg[85] = 3.9419000000; feg[85] = 0.1434000000;
					g[86] = 4.3000000000; fxg[86] = 3.8792000000; feg[86] = 0.1404000000;
					g[87] = 4.3500000000; fxg[87] = 3.8181000000; feg[87] = 0.1375000000;
					g[88] = 4.4000000000; fxg[88] = 3.7588000000; feg[88] = 0.1347000000;
					g[89] = 4.4500000000; fxg[89] = 3.7008000000; feg[89] = 0.1320000000;
					g[90] = 4.5000000000; fxg[90] = 3.6432000000; feg[90] = 0.1293000000;
					g[91] = 4.5500000000; fxg[91] = 3.5853000000; feg[91] = 0.1268000000;
					g[92] = 4.6000000000; fxg[92] = 3.5271000000; feg[92] = 0.1243000000;
					g[93] = 4.6500000000; fxg[93] = 3.4691000000; feg[93] = 0.1219000000;
					g[94] = 4.7000000000; fxg[94] = 3.4118000000; feg[94] = 0.1196000000;
					g[95] = 4.7500000000; fxg[95] = 3.3558000000; feg[95] = 0.1173000000;
					g[96] = 4.8000000000; fxg[96] = 3.3015000000; feg[96] = 0.1151000000;
					g[97] = 4.8500000000; fxg[97] = 3.2494000000; feg[97] = 0.1129000000;
					g[98] = 4.9000000000; fxg[98] = 3.1990000000; feg[98] = 0.1109000000;
					g[99] = 4.9500000000; fxg[99] = 3.1495000000; feg[99] = 0.1088000000;
					g[100] = 5.0000000000; fxg[100] = 3.0999000000; feg[100] = 0.1068000000;
					g[101] = 5.0500000000; fxg[101] = 3.0500000000; feg[101] = 0.1049000000;
					g[102] = 5.1000000000; fxg[102] = 3.0002000000; feg[102] = 0.1031000000;
					g[103] = 5.1500000000; fxg[103] = 2.9508000000; feg[103] = 0.1012000000;
					g[104] = 5.2000000000; fxg[104] = 2.9023000000; feg[104] = 0.0995000000;
					g[105] = 5.2500000000; fxg[105] = 2.8551000000; feg[105] = 0.0978000000;
					g[106] = 5.3000000000; fxg[106] = 2.8097000000; feg[106] = 0.0961000000;
					g[107] = 5.3500000000; fxg[107] = 2.7665000000; feg[107] = 0.0944000000;
					g[108] = 5.4000000000; fxg[108] = 2.7254000000; feg[108] = 0.0928000000;
					g[109] = 5.4500000000; fxg[109] = 2.6855000000; feg[109] = 0.0913000000;
					g[110] = 5.5000000000; fxg[110] = 2.6457000000; feg[110] = 0.0897000000;
					g[111] = 5.5500000000; fxg[111] = 2.6055000000; feg[111] = 0.0883000000;
					g[112] = 5.6000000000; fxg[112] = 2.5651000000; feg[112] = 0.0868000000;
					g[113] = 5.6500000000; fxg[113] = 2.5251000000; feg[113] = 0.0854000000;
					g[114] = 5.7000000000; fxg[114] = 2.4857000000; feg[114] = 0.0840000000;
					g[115] = 5.7500000000; fxg[115] = 2.4471000000; feg[115] = 0.0827000000;
					g[116] = 5.8000000000; fxg[116] = 2.4095000000; feg[116] = 0.0814000000;
					g[117] = 5.8500000000; fxg[117] = 2.3736000000; feg[117] = 0.0801000000;
					g[118] = 5.9000000000; fxg[118] = 2.3398000000; feg[118] = 0.0788000000;
					g[119] = 5.9500000000; fxg[119] = 2.3082000000; feg[119] = 0.0776000000;
					g[120] = 6.0000000000; fxg[120] = 2.2781000000; feg[120] = 0.0764000000;
					g[121] = 6.0500000000; fxg[121] = 2.2485000000; feg[121] = 0.0752000000;
					g[122] = 6.1000000000; fxg[122] = 2.2184000000; feg[122] = 0.0740000000;
					g[123] = 6.1500000000; fxg[123] = 2.1877000000; feg[123] = 0.0729000000;
					g[124] = 6.2000000000; fxg[124] = 2.1569000000; feg[124] = 0.0718000000;
					g[125] = 6.2500000000; fxg[125] = 2.1266000000; feg[125] = 0.0708000000;
					g[126] = 6.3000000000; fxg[126] = 2.0970000000; feg[126] = 0.0697000000;
					g[127] = 6.3500000000; fxg[127] = 2.0679000000; feg[127] = 0.0687000000;
					g[128] = 6.4000000000; fxg[128] = 2.0396000000; feg[128] = 0.0677000000;
					g[129] = 6.4500000000; fxg[129] = 2.0124000000; feg[129] = 0.0667000000;
					g[130] = 6.5000000000; fxg[130] = 1.9870000000; feg[130] = 0.0657000000;
					g[131] = 6.5500000000; fxg[131] = 1.9637000000; feg[131] = 0.0648000000;
					g[132] = 6.6000000000; fxg[132] = 1.9423000000; feg[132] = 0.0639000000;
					g[133] = 6.6500000000; fxg[133] = 1.9218000000; feg[133] = 0.0629000000;
					g[134] = 6.7000000000; fxg[134] = 1.9012000000; feg[134] = 0.0621000000;
					g[135] = 6.7500000000; fxg[135] = 1.8796000000; feg[135] = 0.0612000000;
					g[136] = 6.8000000000; fxg[136] = 1.8573000000; feg[136] = 0.0603000000;
					g[137] = 6.8500000000; fxg[137] = 1.8350000000; feg[137] = 0.0595000000;
					g[138] = 6.9000000000; fxg[138] = 1.8131000000; feg[138] = 0.0587000000;
					g[139] = 6.9500000000; fxg[139] = 1.7920000000; feg[139] = 0.0579000000;
					g[140] = 7.0000000000; fxg[140] = 1.7712000000; feg[140] = 0.0571000000;
					g[141] = 7.0500000000; fxg[141] = 1.7507000000; feg[141] = 0.0563000000;
					g[142] = 7.1000000000; fxg[142] = 1.7307000000; feg[142] = 0.0556000000;
					g[143] = 7.1500000000; fxg[143] = 1.7118000000; feg[143] = 0.0548000000;
					g[144] = 7.2000000000; fxg[144] = 1.6947000000; feg[144] = 0.0541000000;
					g[145] = 7.2500000000; fxg[145] = 1.6795000000; feg[145] = 0.0534000000;
					g[146] = 7.3000000000; fxg[146] = 1.6660000000; feg[146] = 0.0527000000;
					g[147] = 7.3500000000; fxg[147] = 1.6531000000; feg[147] = 0.0520000000;
					g[148] = 7.4000000000; fxg[148] = 1.6398000000; feg[148] = 0.0513000000;
					g[149] = 7.4500000000; fxg[149] = 1.6252000000; feg[149] = 0.0507000000;
					g[150] = 7.5000000000; fxg[150] = 1.6097000000; feg[150] = 0.0500000000;
					g[151] = 7.5500000000; fxg[151] = 1.5938000000; feg[151] = 0.0494000000;
					g[152] = 7.6000000000; fxg[152] = 1.5784000000; feg[152] = 0.0488000000;
					g[153] = 7.6500000000; fxg[153] = 1.5636000000; feg[153] = 0.0482000000;
					g[154] = 7.7000000000; fxg[154] = 1.5494000000; feg[154] = 0.0476000000;
					g[155] = 7.7500000000; fxg[155] = 1.5353000000; feg[155] = 0.0470000000;
					g[156] = 7.8000000000; fxg[156] = 1.5210000000; feg[156] = 0.0464000000;
					g[157] = 7.8500000000; fxg[157] = 1.5070000000; feg[157] = 0.0458000000;
					g[158] = 7.9000000000; fxg[158] = 1.4937000000; feg[158] = 0.0453000000;
					g[159] = 7.9500000000; fxg[159] = 1.4819000000; feg[159] = 0.0447000000;
					g[160] = 8.0000000000; fxg[160] = 1.4719000000; feg[160] = 0.0442000000;
					g[161] = 8.0500000000; fxg[161] = 1.4636000000; feg[161] = 0.0436000000;
					g[162] = 8.1000000000; fxg[162] = 1.4563000000; feg[162] = 0.0431000000;
					g[163] = 8.1500000000; fxg[163] = 1.4486000000; feg[163] = 0.0426000000;
					g[164] = 8.2000000000; fxg[164] = 1.4398000000; feg[164] = 0.0421000000;
					g[165] = 8.2500000000; fxg[165] = 1.4296000000; feg[165] = 0.0416000000;
					g[166] = 8.3000000000; fxg[166] = 1.4185000000; feg[166] = 0.0411000000;
					g[167] = 8.3500000000; fxg[167] = 1.4071000000; feg[167] = 0.0406000000;
					g[168] = 8.4000000000; fxg[168] = 1.3963000000; feg[168] = 0.0402000000;
					g[169] = 8.4500000000; fxg[169] = 1.3864000000; feg[169] = 0.0397000000;
					g[170] = 8.5000000000; fxg[170] = 1.3769000000; feg[170] = 0.0393000000;
					g[171] = 8.5500000000; fxg[171] = 1.3674000000; feg[171] = 0.0388000000;
					g[172] = 8.6000000000; fxg[172] = 1.3576000000; feg[172] = 0.0384000000;
					g[173] = 8.6500000000; fxg[173] = 1.3474000000; feg[173] = 0.0379000000;
					g[174] = 8.7000000000; fxg[174] = 1.3374000000; feg[174] = 0.0375000000;
					g[175] = 8.7500000000; fxg[175] = 1.3282000000; feg[175] = 0.0371000000;
					g[176] = 8.8000000000; fxg[176] = 1.3205000000; feg[176] = 0.0367000000;
					g[177] = 8.8500000000; fxg[177] = 1.3145000000; feg[177] = 0.0363000000;
					g[178] = 8.9000000000; fxg[178] = 1.3101000000; feg[178] = 0.0359000000;
					g[179] = 8.9500000000; fxg[179] = 1.3063000000; feg[179] = 0.0355000000;
					g[180] = 9.0000000000; fxg[180] = 1.3023000000; feg[180] = 0.0351000000;
					g[181] = 9.0500000000; fxg[181] = 1.2970000000; feg[181] = 0.0347000000;
					g[182] = 9.1000000000; fxg[182] = 1.2901000000; feg[182] = 0.0343000000;
					g[183] = 9.1500000000; fxg[183] = 1.2819000000; feg[183] = 0.0340000000;
					g[184] = 9.2000000000; fxg[184] = 1.2732000000; feg[184] = 0.0336000000;
					g[185] = 9.2500000000; fxg[185] = 1.2648000000; feg[185] = 0.0333000000;
					g[186] = 9.3000000000; fxg[186] = 1.2572000000; feg[186] = 0.0329000000;
					g[187] = 9.3500000000; fxg[187] = 1.2505000000; feg[187] = 0.0326000000;
					g[188] = 9.4000000000; fxg[188] = 1.2442000000; feg[188] = 0.0322000000;
					g[189] = 9.4500000000; fxg[189] = 1.2376000000; feg[189] = 0.0319000000;
					g[190] = 9.5000000000; fxg[190] = 1.2304000000; feg[190] = 0.0316000000;
					g[191] = 9.5500000000; fxg[191] = 1.2227000000; feg[191] = 0.0313000000;
					g[192] = 9.6000000000; fxg[192] = 1.2149000000; feg[192] = 0.0309000000;
					g[193] = 9.6500000000; fxg[193] = 1.2074000000; feg[193] = 0.0306000000;
					g[194] = 9.7000000000; fxg[194] = 1.2010000000; feg[194] = 0.0303000000;
					g[195] = 9.7500000000; fxg[195] = 1.1961000000; feg[195] = 0.0300000000;
					g[196] = 9.8000000000; fxg[196] = 1.1929000000; feg[196] = 0.0297000000;
					g[197] = 9.8500000000; fxg[197] = 1.1909000000; feg[197] = 0.0294000000;
					g[198] = 9.9000000000; fxg[198] = 1.1894000000; feg[198] = 0.0291000000;
					g[199] = 9.9500000000; fxg[199] = 1.1872000000; feg[199] = 0.0288000000;
					g[200] = 10.0000000000; fxg[200] = 1.1837000000; feg[200] = 0.0285000000;
					g[201] = 10.0500000000; fxg[201] = 1.1785000000; feg[201] = 0.0283000000;
					g[202] = 10.1000000000; fxg[202] = 1.1720000000; feg[202] = 0.0280000000;
					g[203] = 10.1500000000; fxg[203] = 1.1646000000; feg[203] = 0.0277000000;
					g[204] = 10.2000000000; fxg[204] = 1.1574000000; feg[204] = 0.0275000000;
					g[205] = 10.2500000000; fxg[205] = 1.1509000000; feg[205] = 0.0272000000;
					g[206] = 10.3000000000; fxg[206] = 1.1454000000; feg[206] = 0.0269000000;
					g[207] = 10.3500000000; fxg[207] = 1.1407000000; feg[207] = 0.0267000000;
					g[208] = 10.4000000000; fxg[208] = 1.1361000000; feg[208] = 0.0264000000;
					g[209] = 10.4500000000; fxg[209] = 1.1310000000; feg[209] = 0.0262000000;
					g[210] = 10.5000000000; fxg[210] = 1.1251000000; feg[210] = 0.0259000000;
					g[211] = 10.5500000000; fxg[211] = 1.1187000000; feg[211] = 0.0257000000;
					g[212] = 10.6000000000; fxg[212] = 1.1121000000; feg[212] = 0.0255000000;
					g[213] = 10.6500000000; fxg[213] = 1.1056000000; feg[213] = 0.0252000000;
					g[214] = 10.7000000000; fxg[214] = 1.0997000000; feg[214] = 0.0250000000;
					g[215] = 10.7500000000; fxg[215] = 1.0951000000; feg[215] = 0.0248000000;
					g[216] = 10.8000000000; fxg[216] = 1.0920000000; feg[216] = 0.0245000000;
					g[217] = 10.8500000000; fxg[217] = 1.0905000000; feg[217] = 0.0243000000;
					g[218] = 10.9000000000; fxg[218] = 1.0900000000; feg[218] = 0.0241000000;
					g[219] = 10.9500000000; fxg[219] = 1.0896000000; feg[219] = 0.0239000000;
					g[220] = 11.0000000000; fxg[220] = 1.0883000000; feg[220] = 0.0237000000;
					g[221] = 11.0500000000; fxg[221] = 1.0856000000; feg[221] = 0.0235000000;
					g[222] = 11.1000000000; fxg[222] = 1.0813000000; feg[222] = 0.0232000000;
					g[223] = 11.1500000000; fxg[223] = 1.0756000000; feg[223] = 0.0230000000;
					g[224] = 11.2000000000; fxg[224] = 1.0690000000; feg[224] = 0.0228000000;
					g[225] = 11.2500000000; fxg[225] = 1.0621000000; feg[225] = 0.0226000000;
					g[226] = 11.3000000000; fxg[226] = 1.0558000000; feg[226] = 0.0225000000;
					g[227] = 11.3500000000; fxg[227] = 1.0505000000; feg[227] = 0.0223000000;
					g[228] = 11.4000000000; fxg[228] = 1.0462000000; feg[228] = 0.0221000000;
					g[229] = 11.4500000000; fxg[229] = 1.0425000000; feg[229] = 0.0219000000;
					g[230] = 11.5000000000; fxg[230] = 1.0387000000; feg[230] = 0.0217000000;
					g[231] = 11.5500000000; fxg[231] = 1.0342000000; feg[231] = 0.0215000000;
					g[232] = 11.6000000000; fxg[232] = 1.0289000000; feg[232] = 0.0213000000;
					g[233] = 11.6500000000; fxg[233] = 1.0231000000; feg[233] = 0.0211000000;
					g[234] = 11.7000000000; fxg[234] = 1.0171000000; feg[234] = 0.0210000000;
					g[235] = 11.7500000000; fxg[235] = 1.0110000000; feg[235] = 0.0208000000;
					g[236] = 11.8000000000; fxg[236] = 1.0053000000; feg[236] = 0.0206000000;
					g[237] = 11.8500000000; fxg[237] = 1.0004000000; feg[237] = 0.0205000000;
					g[238] = 11.9000000000; fxg[238] = 0.9967000000; feg[238] = 0.0203000000;
					g[239] = 11.9500000000; fxg[239] = 0.9946000000; feg[239] = 0.0201000000;
					g[240] = 12.0000000000; fxg[240] = 0.9940000000; feg[240] = 0.0199000000;
					break;
				case 32:
					g[0] = 0.0000000000; fxg[0] = 32.0000000000; feg[0] = 7.4232000000;
					g[1] = 0.0500000000; fxg[1] = 31.8093000000; feg[1] = 7.3043000000;
					g[2] = 0.1000000000; fxg[2] = 31.2718000000; feg[2] = 6.9715000000;
					g[3] = 0.1500000000; fxg[3] = 30.4756000000; feg[3] = 6.4863000000;
					g[4] = 0.2000000000; fxg[4] = 29.5256000000; feg[4] = 5.9221000000;
					g[5] = 0.2500000000; fxg[5] = 28.5120000000; feg[5] = 5.3428000000;
					g[6] = 0.3000000000; fxg[6] = 27.4954000000; feg[6] = 4.7916000000;
					g[7] = 0.3500000000; fxg[7] = 26.5083000000; feg[7] = 4.2918000000;
					g[8] = 0.4000000000; fxg[8] = 25.5625000000; feg[8] = 3.8519000000;
					g[9] = 0.4500000000; fxg[9] = 24.6582000000; feg[9] = 3.4709000000;
					g[10] = 0.5000000000; fxg[10] = 23.7903000000; feg[10] = 3.1438000000;
					g[11] = 0.5500000000; fxg[11] = 22.9519000000; feg[11] = 2.8635000000;
					g[12] = 0.6000000000; fxg[12] = 22.1372000000; feg[12] = 2.6228000000;
					g[13] = 0.6500000000; fxg[13] = 21.3415000000; feg[13] = 2.4151000000;
					g[14] = 0.7000000000; fxg[14] = 20.5621000000; feg[14] = 2.2347000000;
					g[15] = 0.7500000000; fxg[15] = 19.7978000000; feg[15] = 2.0768000000;
					g[16] = 0.8000000000; fxg[16] = 19.0486000000; feg[16] = 1.9373000000;
					g[17] = 0.8500000000; fxg[17] = 18.3155000000; feg[17] = 1.8133000000;
					g[18] = 0.9000000000; fxg[18] = 17.5998000000; feg[18] = 1.7020000000;
					g[19] = 0.9500000000; fxg[19] = 16.9035000000; feg[19] = 1.6014000000;
					g[20] = 1.0000000000; fxg[20] = 16.2282000000; feg[20] = 1.5099000000;
					g[21] = 1.0500000000; fxg[21] = 15.5759000000; feg[21] = 1.4262000000;
					g[22] = 1.1000000000; fxg[22] = 14.9480000000; feg[22] = 1.3491000000;
					g[23] = 1.1500000000; fxg[23] = 14.3458000000; feg[23] = 1.2780000000;
					g[24] = 1.2000000000; fxg[24] = 13.7703000000; feg[24] = 1.2120000000;
					g[25] = 1.2500000000; fxg[25] = 13.2222000000; feg[25] = 1.1505000000;
					g[26] = 1.3000000000; fxg[26] = 12.7018000000; feg[26] = 1.0932000000;
					g[27] = 1.3500000000; fxg[27] = 12.2093000000; feg[27] = 1.0396000000;
					g[28] = 1.4000000000; fxg[28] = 11.7444000000; feg[28] = 0.9894000000;
					g[29] = 1.4500000000; fxg[29] = 11.3068000000; feg[29] = 0.9422000000;
					g[30] = 1.5000000000; fxg[30] = 10.8957000000; feg[30] = 0.8980000000;
					g[31] = 1.5500000000; fxg[31] = 10.5105000000; feg[31] = 0.8563000000;
					g[32] = 1.6000000000; fxg[32] = 10.1501000000; feg[32] = 0.8171000000;
					g[33] = 1.6500000000; fxg[33] = 9.8136000000; feg[33] = 0.7802000000;
					g[34] = 1.7000000000; fxg[34] = 9.4999000000; feg[34] = 0.7453000000;
					g[35] = 1.7500000000; fxg[35] = 9.2077000000; feg[35] = 0.7125000000;
					g[36] = 1.8000000000; fxg[36] = 8.9358000000; feg[36] = 0.6815000000;
					g[37] = 1.8500000000; fxg[37] = 8.6831000000; feg[37] = 0.6522000000;
					g[38] = 1.9000000000; fxg[38] = 8.4482000000; feg[38] = 0.6246000000;
					g[39] = 1.9500000000; fxg[39] = 8.2299000000; feg[39] = 0.5985000000;
					g[40] = 2.0000000000; fxg[40] = 8.0272000000; feg[40] = 0.5738000000;
					g[41] = 2.0500000000; fxg[41] = 7.8386000000; feg[41] = 0.5504000000;
					g[42] = 2.1000000000; fxg[42] = 7.6632000000; feg[42] = 0.5283000000;
					g[43] = 2.1500000000; fxg[43] = 7.4998000000; feg[43] = 0.5074000000;
					g[44] = 2.2000000000; fxg[44] = 7.3475000000; feg[44] = 0.4876000000;
					g[45] = 2.2500000000; fxg[45] = 7.2053000000; feg[45] = 0.4689000000;
					g[46] = 2.3000000000; fxg[46] = 7.0720000000; feg[46] = 0.4511000000;
					g[47] = 2.3500000000; fxg[47] = 6.9470000000; feg[47] = 0.4343000000;
					g[48] = 2.4000000000; fxg[48] = 6.8295000000; feg[48] = 0.4183000000;
					g[49] = 2.4500000000; fxg[49] = 6.7187000000; feg[49] = 0.4032000000;
					g[50] = 2.5000000000; fxg[50] = 6.6138000000; feg[50] = 0.3889000000;
					g[51] = 2.5500000000; fxg[51] = 6.5141000000; feg[51] = 0.3752000000;
					g[52] = 2.6000000000; fxg[52] = 6.4190000000; feg[52] = 0.3623000000;
					g[53] = 2.6500000000; fxg[53] = 6.3284000000; feg[53] = 0.3500000000;
					g[54] = 2.7000000000; fxg[54] = 6.2416000000; feg[54] = 0.3383000000;
					g[55] = 2.7500000000; fxg[55] = 6.1579000000; feg[55] = 0.3271000000;
					g[56] = 2.8000000000; fxg[56] = 6.0767000000; feg[56] = 0.3166000000;
					g[57] = 2.8500000000; fxg[57] = 5.9978000000; feg[57] = 0.3065000000;
					g[58] = 2.9000000000; fxg[58] = 5.9213000000; feg[58] = 0.2969000000;
					g[59] = 2.9500000000; fxg[59] = 5.8470000000; feg[59] = 0.2877000000;
					g[60] = 3.0000000000; fxg[60] = 5.7743000000; feg[60] = 0.2790000000;
					g[61] = 3.0500000000; fxg[61] = 5.7027000000; feg[61] = 0.2706000000;
					g[62] = 3.1000000000; fxg[62] = 5.6318000000; feg[62] = 0.2627000000;
					g[63] = 3.1500000000; fxg[63] = 5.5617000000; feg[63] = 0.2551000000;
					g[64] = 3.2000000000; fxg[64] = 5.4928000000; feg[64] = 0.2478000000;
					g[65] = 3.2500000000; fxg[65] = 5.4250000000; feg[65] = 0.2409000000;
					g[66] = 3.3000000000; fxg[66] = 5.3582000000; feg[66] = 0.2342000000;
					g[67] = 3.3500000000; fxg[67] = 5.2915000000; feg[67] = 0.2278000000;
					g[68] = 3.4000000000; fxg[68] = 5.2247000000; feg[68] = 0.2217000000;
					g[69] = 3.4500000000; fxg[69] = 5.1578000000; feg[69] = 0.2159000000;
					g[70] = 3.5000000000; fxg[70] = 5.0912000000; feg[70] = 0.2103000000;
					g[71] = 3.5500000000; fxg[71] = 5.0254000000; feg[71] = 0.2049000000;
					g[72] = 3.6000000000; fxg[72] = 4.9607000000; feg[72] = 0.1997000000;
					g[73] = 3.6500000000; fxg[73] = 4.8965000000; feg[73] = 0.1948000000;
					g[74] = 3.7000000000; fxg[74] = 4.8321000000; feg[74] = 0.1900000000;
					g[75] = 3.7500000000; fxg[75] = 4.7673000000; feg[75] = 0.1854000000;
					g[76] = 3.8000000000; fxg[76] = 4.7019000000; feg[76] = 0.1810000000;
					g[77] = 3.8500000000; fxg[77] = 4.6367000000; feg[77] = 0.1767000000;
					g[78] = 3.9000000000; fxg[78] = 4.5722000000; feg[78] = 0.1726000000;
					g[79] = 3.9500000000; fxg[79] = 4.5090000000; feg[79] = 0.1687000000;
					g[80] = 4.0000000000; fxg[80] = 4.4468000000; feg[80] = 0.1649000000;
					g[81] = 4.0500000000; fxg[81] = 4.3850000000; feg[81] = 0.1612000000;
					g[82] = 4.1000000000; fxg[82] = 4.3230000000; feg[82] = 0.1576000000;
					g[83] = 4.1500000000; fxg[83] = 4.2604000000; feg[83] = 0.1542000000;
					g[84] = 4.2000000000; fxg[84] = 4.1974000000; feg[84] = 0.1509000000;
					g[85] = 4.2500000000; fxg[85] = 4.1346000000; feg[85] = 0.1477000000;
					g[86] = 4.3000000000; fxg[86] = 4.0728000000; feg[86] = 0.1446000000;
					g[87] = 4.3500000000; fxg[87] = 4.0125000000; feg[87] = 0.1416000000;
					g[88] = 4.4000000000; fxg[88] = 3.9538000000; feg[88] = 0.1387000000;
					g[89] = 4.4500000000; fxg[89] = 3.8962000000; feg[89] = 0.1359000000;
					g[90] = 4.5000000000; fxg[90] = 3.8388000000; feg[90] = 0.1331000000;
					g[91] = 4.5500000000; fxg[91] = 3.7810000000; feg[91] = 0.1305000000;
					g[92] = 4.6000000000; fxg[92] = 3.7227000000; feg[92] = 0.1279000000;
					g[93] = 4.6500000000; fxg[93] = 3.6643000000; feg[93] = 0.1255000000;
					g[94] = 4.7000000000; fxg[94] = 3.6064000000; feg[94] = 0.1231000000;
					g[95] = 4.7500000000; fxg[95] = 3.5498000000; feg[95] = 0.1207000000;
					g[96] = 4.8000000000; fxg[96] = 3.4950000000; feg[96] = 0.1184000000;
					g[97] = 4.8500000000; fxg[97] = 3.4421000000; feg[97] = 0.1162000000;
					g[98] = 4.9000000000; fxg[98] = 3.3910000000; feg[98] = 0.1141000000;
					g[99] = 4.9500000000; fxg[99] = 3.3405000000; feg[99] = 0.1120000000;
					g[100] = 5.0000000000; fxg[100] = 3.2899000000; feg[100] = 0.1099000000;
					g[101] = 5.0500000000; fxg[101] = 3.2387000000; feg[101] = 0.1080000000;
					g[102] = 5.1000000000; fxg[102] = 3.1874000000; feg[102] = 0.1061000000;
					g[103] = 5.1500000000; fxg[103] = 3.1362000000; feg[103] = 0.1042000000;
					g[104] = 5.2000000000; fxg[104] = 3.0859000000; feg[104] = 0.1024000000;
					g[105] = 5.2500000000; fxg[105] = 3.0369000000; feg[105] = 0.1006000000;
					g[106] = 5.3000000000; fxg[106] = 2.9898000000; feg[106] = 0.0989000000;
					g[107] = 5.3500000000; fxg[107] = 2.9450000000; feg[107] = 0.0972000000;
					g[108] = 5.4000000000; fxg[108] = 2.9022000000; feg[108] = 0.0955000000;
					g[109] = 5.4500000000; fxg[109] = 2.8605000000; feg[109] = 0.0939000000;
					g[110] = 5.5000000000; fxg[110] = 2.8189000000; feg[110] = 0.0924000000;
					g[111] = 5.5500000000; fxg[111] = 2.7768000000; feg[111] = 0.0908000000;
					g[112] = 5.6000000000; fxg[112] = 2.7342000000; feg[112] = 0.0893000000;
					g[113] = 5.6500000000; fxg[113] = 2.6917000000; feg[113] = 0.0879000000;
					g[114] = 5.7000000000; fxg[114] = 2.6496000000; feg[114] = 0.0865000000;
					g[115] = 5.7500000000; fxg[115] = 2.6084000000; feg[115] = 0.0851000000;
					g[116] = 5.8000000000; fxg[116] = 2.5684000000; feg[116] = 0.0838000000;
					g[117] = 5.8500000000; fxg[117] = 2.5302000000; feg[117] = 0.0824000000;
					g[118] = 5.9000000000; fxg[118] = 2.4942000000; feg[118] = 0.0811000000;
					g[119] = 5.9500000000; fxg[119] = 2.4606000000; feg[119] = 0.0799000000;
					g[120] = 6.0000000000; fxg[120] = 2.4284000000; feg[120] = 0.0786000000;
					g[121] = 6.0500000000; fxg[121] = 2.3967000000; feg[121] = 0.0774000000;
					g[122] = 6.1000000000; fxg[122] = 2.3645000000; feg[122] = 0.0762000000;
					g[123] = 6.1500000000; fxg[123] = 2.3315000000; feg[123] = 0.0751000000;
					g[124] = 6.2000000000; fxg[124] = 2.2982000000; feg[124] = 0.0740000000;
					g[125] = 6.2500000000; fxg[125] = 2.2651000000; feg[125] = 0.0729000000;
					g[126] = 6.3000000000; fxg[126] = 2.2325000000; feg[126] = 0.0718000000;
					g[127] = 6.3500000000; fxg[127] = 2.2006000000; feg[127] = 0.0708000000;
					g[128] = 6.4000000000; fxg[128] = 2.1696000000; feg[128] = 0.0697000000;
					g[129] = 6.4500000000; fxg[129] = 2.1399000000; feg[129] = 0.0687000000;
					g[130] = 6.5000000000; fxg[130] = 2.1123000000; feg[130] = 0.0677000000;
					g[131] = 6.5500000000; fxg[131] = 2.0871000000; feg[131] = 0.0667000000;
					g[132] = 6.6000000000; fxg[132] = 2.0637000000; feg[132] = 0.0658000000;
					g[133] = 6.6500000000; fxg[133] = 2.0414000000; feg[133] = 0.0649000000;
					g[134] = 6.7000000000; fxg[134] = 2.0188000000; feg[134] = 0.0639000000;
					g[135] = 6.7500000000; fxg[135] = 1.9953000000; feg[135] = 0.0630000000;
					g[136] = 6.8000000000; fxg[136] = 1.9709000000; feg[136] = 0.0622000000;
					g[137] = 6.8500000000; fxg[137] = 1.9462000000; feg[137] = 0.0613000000;
					g[138] = 6.9000000000; fxg[138] = 1.9218000000; feg[138] = 0.0605000000;
					g[139] = 6.9500000000; fxg[139] = 1.8979000000; feg[139] = 0.0597000000;
					g[140] = 7.0000000000; fxg[140] = 1.8744000000; feg[140] = 0.0589000000;
					g[141] = 7.0500000000; fxg[141] = 1.8514000000; feg[141] = 0.0581000000;
					g[142] = 7.1000000000; fxg[142] = 1.8291000000; feg[142] = 0.0573000000;
					g[143] = 7.1500000000; fxg[143] = 1.8082000000; feg[143] = 0.0565000000;
					g[144] = 7.2000000000; fxg[144] = 1.7893000000; feg[144] = 0.0558000000;
					g[145] = 7.2500000000; fxg[145] = 1.7726000000; feg[145] = 0.0551000000;
					g[146] = 7.3000000000; fxg[146] = 1.7576000000; feg[146] = 0.0543000000;
					g[147] = 7.3500000000; fxg[147] = 1.7433000000; feg[147] = 0.0536000000;
					g[148] = 7.4000000000; fxg[148] = 1.7285000000; feg[148] = 0.0529000000;
					g[149] = 7.4500000000; fxg[149] = 1.7125000000; feg[149] = 0.0522000000;
					g[150] = 7.5000000000; fxg[150] = 1.6953000000; feg[150] = 0.0516000000;
					g[151] = 7.5500000000; fxg[151] = 1.6776000000; feg[151] = 0.0509000000;
					g[152] = 7.6000000000; fxg[152] = 1.6602000000; feg[152] = 0.0503000000;
					g[153] = 7.6500000000; fxg[153] = 1.6433000000; feg[153] = 0.0497000000;
					g[154] = 7.7000000000; fxg[154] = 1.6269000000; feg[154] = 0.0490000000;
					g[155] = 7.7500000000; fxg[155] = 1.6107000000; feg[155] = 0.0484000000;
					g[156] = 7.8000000000; fxg[156] = 1.5945000000; feg[156] = 0.0478000000;
					g[157] = 7.8500000000; fxg[157] = 1.5786000000; feg[157] = 0.0473000000;
					g[158] = 7.9000000000; fxg[158] = 1.5638000000; feg[158] = 0.0467000000;
					g[159] = 7.9500000000; fxg[159] = 1.5507000000; feg[159] = 0.0461000000;
					g[160] = 8.0000000000; fxg[160] = 1.5396000000; feg[160] = 0.0456000000;
					g[161] = 8.0500000000; fxg[161] = 1.5305000000; feg[161] = 0.0450000000;
					g[162] = 8.1000000000; fxg[162] = 1.5223000000; feg[162] = 0.0445000000;
					g[163] = 8.1500000000; fxg[163] = 1.5138000000; feg[163] = 0.0439000000;
					g[164] = 8.2000000000; fxg[164] = 1.5041000000; feg[164] = 0.0434000000;
					g[165] = 8.2500000000; fxg[165] = 1.4929000000; feg[165] = 0.0429000000;
					g[166] = 8.3000000000; fxg[166] = 1.4806000000; feg[166] = 0.0424000000;
					g[167] = 8.3500000000; fxg[167] = 1.4680000000; feg[167] = 0.0419000000;
					g[168] = 8.4000000000; fxg[168] = 1.4558000000; feg[168] = 0.0414000000;
					g[169] = 8.4500000000; fxg[169] = 1.4443000000; feg[169] = 0.0410000000;
					g[170] = 8.5000000000; fxg[170] = 1.4334000000; feg[170] = 0.0405000000;
					g[171] = 8.5500000000; fxg[171] = 1.4224000000; feg[171] = 0.0400000000;
					g[172] = 8.6000000000; fxg[172] = 1.4112000000; feg[172] = 0.0396000000;
					g[173] = 8.6500000000; fxg[173] = 1.3997000000; feg[173] = 0.0392000000;
					g[174] = 8.7000000000; fxg[174] = 1.3885000000; feg[174] = 0.0387000000;
					g[175] = 8.7500000000; fxg[175] = 1.3783000000; feg[175] = 0.0383000000;
					g[176] = 8.8000000000; fxg[176] = 1.3698000000; feg[176] = 0.0379000000;
					g[177] = 8.8500000000; fxg[177] = 1.3633000000; feg[177] = 0.0374000000;
					g[178] = 8.9000000000; fxg[178] = 1.3586000000; feg[178] = 0.0370000000;
					g[179] = 8.9500000000; fxg[179] = 1.3546000000; feg[179] = 0.0366000000;
					g[180] = 9.0000000000; fxg[180] = 1.3502000000; feg[180] = 0.0362000000;
					g[181] = 9.0500000000; fxg[181] = 1.3446000000; feg[181] = 0.0358000000;
					g[182] = 9.1000000000; fxg[182] = 1.3372000000; feg[182] = 0.0354000000;
					g[183] = 9.1500000000; fxg[183] = 1.3283000000; feg[183] = 0.0351000000;
					g[184] = 9.2000000000; fxg[184] = 1.3188000000; feg[184] = 0.0347000000;
					g[185] = 9.2500000000; fxg[185] = 1.3096000000; feg[185] = 0.0343000000;
					g[186] = 9.3000000000; fxg[186] = 1.3011000000; feg[186] = 0.0340000000;
					g[187] = 9.3500000000; fxg[187] = 1.2936000000; feg[187] = 0.0336000000;
					g[188] = 9.4000000000; fxg[188] = 1.2864000000; feg[188] = 0.0333000000;
					g[189] = 9.4500000000; fxg[189] = 1.2790000000; feg[189] = 0.0329000000;
					g[190] = 9.5000000000; fxg[190] = 1.2710000000; feg[190] = 0.0326000000;
					g[191] = 9.5500000000; fxg[191] = 1.2625000000; feg[191] = 0.0323000000;
					g[192] = 9.6000000000; fxg[192] = 1.2538000000; feg[192] = 0.0319000000;
					g[193] = 9.6500000000; fxg[193] = 1.2456000000; feg[193] = 0.0316000000;
					g[194] = 9.7000000000; fxg[194] = 1.2387000000; feg[194] = 0.0313000000;
					g[195] = 9.7500000000; fxg[195] = 1.2336000000; feg[195] = 0.0310000000;
					g[196] = 9.8000000000; fxg[196] = 1.2303000000; feg[196] = 0.0307000000;
					g[197] = 9.8500000000; fxg[197] = 1.2285000000; feg[197] = 0.0304000000;
					g[198] = 9.9000000000; fxg[198] = 1.2271000000; feg[198] = 0.0301000000;
					g[199] = 9.9500000000; fxg[199] = 1.2250000000; feg[199] = 0.0298000000;
					g[200] = 10.0000000000; fxg[200] = 1.2214000000; feg[200] = 0.0295000000;
					g[201] = 10.0500000000; fxg[201] = 1.2160000000; feg[201] = 0.0292000000;
					g[202] = 10.1000000000; fxg[202] = 1.2091000000; feg[202] = 0.0289000000;
					g[203] = 10.1500000000; fxg[203] = 1.2013000000; feg[203] = 0.0286000000;
					g[204] = 10.2000000000; fxg[204] = 1.1935000000; feg[204] = 0.0283000000;
					g[205] = 10.2500000000; fxg[205] = 1.1866000000; feg[205] = 0.0281000000;
					g[206] = 10.3000000000; fxg[206] = 1.1808000000; feg[206] = 0.0278000000;
					g[207] = 10.3500000000; fxg[207] = 1.1758000000; feg[207] = 0.0275000000;
					g[208] = 10.4000000000; fxg[208] = 1.1710000000; feg[208] = 0.0273000000;
					g[209] = 10.4500000000; fxg[209] = 1.1656000000; feg[209] = 0.0270000000;
					g[210] = 10.5000000000; fxg[210] = 1.1594000000; feg[210] = 0.0268000000;
					g[211] = 10.5500000000; fxg[211] = 1.1525000000; feg[211] = 0.0265000000;
					g[212] = 10.6000000000; fxg[212] = 1.1453000000; feg[212] = 0.0263000000;
					g[213] = 10.6500000000; fxg[213] = 1.1382000000; feg[213] = 0.0260000000;
					g[214] = 10.7000000000; fxg[214] = 1.1320000000; feg[214] = 0.0258000000;
					g[215] = 10.7500000000; fxg[215] = 1.1272000000; feg[215] = 0.0256000000;
					g[216] = 10.8000000000; fxg[216] = 1.1242000000; feg[216] = 0.0253000000;
					g[217] = 10.8500000000; fxg[217] = 1.1229000000; feg[217] = 0.0251000000;
					g[218] = 10.9000000000; fxg[218] = 1.1228000000; feg[218] = 0.0249000000;
					g[219] = 10.9500000000; fxg[219] = 1.1227000000; feg[219] = 0.0247000000;
					g[220] = 11.0000000000; fxg[220] = 1.1218000000; feg[220] = 0.0244000000;
					g[221] = 11.0500000000; fxg[221] = 1.1192000000; feg[221] = 0.0242000000;
					g[222] = 11.1000000000; fxg[222] = 1.1148000000; feg[222] = 0.0240000000;
					g[223] = 11.1500000000; fxg[223] = 1.1088000000; feg[223] = 0.0238000000;
					g[224] = 11.2000000000; fxg[224] = 1.1018000000; feg[224] = 0.0236000000;
					g[225] = 11.2500000000; fxg[225] = 1.0945000000; feg[225] = 0.0234000000;
					g[226] = 11.3000000000; fxg[226] = 1.0880000000; feg[226] = 0.0232000000;
					g[227] = 11.3500000000; fxg[227] = 1.0827000000; feg[227] = 0.0230000000;
					g[228] = 11.4000000000; fxg[228] = 1.0785000000; feg[228] = 0.0228000000;
					g[229] = 11.4500000000; fxg[229] = 1.0750000000; feg[229] = 0.0226000000;
					g[230] = 11.5000000000; fxg[230] = 1.0713000000; feg[230] = 0.0224000000;
					g[231] = 11.5500000000; fxg[231] = 1.0670000000; feg[231] = 0.0222000000;
					g[232] = 11.6000000000; fxg[232] = 1.0618000000; feg[232] = 0.0220000000;
					g[233] = 11.6500000000; fxg[233] = 1.0558000000; feg[233] = 0.0218000000;
					g[234] = 11.7000000000; fxg[234] = 1.0493000000; feg[234] = 0.0216000000;
					g[235] = 11.7500000000; fxg[235] = 1.0428000000; feg[235] = 0.0215000000;
					g[236] = 11.8000000000; fxg[236] = 1.0367000000; feg[236] = 0.0213000000;
					g[237] = 11.8500000000; fxg[237] = 1.0315000000; feg[237] = 0.0211000000;
					g[238] = 11.9000000000; fxg[238] = 1.0278000000; feg[238] = 0.0209000000;
					g[239] = 11.9500000000; fxg[239] = 1.0259000000; feg[239] = 0.0208000000;
					g[240] = 12.0000000000; fxg[240] = 1.0256000000; feg[240] = 0.0206000000;
					break;
				case 33:
					g[0] = 0.0000000000; fxg[0] = 33.0000000000; feg[0] = 7.4398000000;
					g[1] = 0.0500000000; fxg[1] = 32.8084000000; feg[1] = 7.3382000000;
					g[2] = 0.1000000000; fxg[2] = 32.2636000000; feg[2] = 7.0502000000;
					g[3] = 0.1500000000; fxg[3] = 31.4442000000; feg[3] = 6.6198000000;
					g[4] = 0.2000000000; fxg[4] = 30.4498000000; feg[4] = 6.1035000000;
					g[5] = 0.2500000000; fxg[5] = 29.3736000000; feg[5] = 5.5548000000;
					g[6] = 0.3000000000; fxg[6] = 28.2855000000; feg[6] = 5.0149000000;
					g[7] = 0.3500000000; fxg[7] = 27.2288000000; feg[7] = 4.5102000000;
					g[8] = 0.4000000000; fxg[8] = 26.2244000000; feg[8] = 4.0541000000;
					g[9] = 0.4500000000; fxg[9] = 25.2773000000; feg[9] = 3.6510000000;
					g[10] = 0.5000000000; fxg[10] = 24.3839000000; feg[10] = 3.2994000000;
					g[11] = 0.5500000000; fxg[11] = 23.5366000000; feg[11] = 2.9950000000;
					g[12] = 0.6000000000; fxg[12] = 22.7266000000; feg[12] = 2.7320000000;
					g[13] = 0.6500000000; fxg[13] = 21.9463000000; feg[13] = 2.5047000000;
					g[14] = 0.7000000000; fxg[14] = 21.1892000000; feg[14] = 2.3076000000;
					g[15] = 0.7500000000; fxg[15] = 20.4511000000; feg[15] = 2.1358000000;
					g[16] = 0.8000000000; fxg[16] = 19.7291000000; feg[16] = 1.9851000000;
					g[17] = 0.8500000000; fxg[17] = 19.0219000000; feg[17] = 1.8522000000;
					g[18] = 0.9000000000; fxg[18] = 18.3292000000; feg[18] = 1.7340000000;
					g[19] = 0.9500000000; fxg[19] = 17.6517000000; feg[19] = 1.6281000000;
					g[20] = 1.0000000000; fxg[20] = 16.9904000000; feg[20] = 1.5327000000;
					g[21] = 1.0500000000; fxg[21] = 16.3466000000; feg[21] = 1.4461000000;
					g[22] = 1.1000000000; fxg[22] = 15.7219000000; feg[22] = 1.3670000000;
					g[23] = 1.1500000000; fxg[23] = 15.1176000000; feg[23] = 1.2945000000;
					g[24] = 1.2000000000; fxg[24] = 14.5350000000; feg[24] = 1.2276000000;
					g[25] = 1.2500000000; fxg[25] = 13.9754000000; feg[25] = 1.1656000000;
					g[26] = 1.3000000000; fxg[26] = 13.4394000000; feg[26] = 1.1081000000;
					g[27] = 1.3500000000; fxg[27] = 12.9277000000; feg[27] = 1.0544000000;
					g[28] = 1.4000000000; fxg[28] = 12.4408000000; feg[28] = 1.0042000000;
					g[29] = 1.4500000000; fxg[29] = 11.9787000000; feg[29] = 0.9572000000;
					g[30] = 1.5000000000; fxg[30] = 11.5414000000; feg[30] = 0.9130000000;
					g[31] = 1.5500000000; fxg[31] = 11.1285000000; feg[31] = 0.8715000000;
					g[32] = 1.6000000000; fxg[32] = 10.7396000000; feg[32] = 0.8325000000;
					g[33] = 1.6500000000; fxg[33] = 10.3741000000; feg[33] = 0.7956000000;
					g[34] = 1.7000000000; fxg[34] = 10.0311000000; feg[34] = 0.7609000000;
					g[35] = 1.7500000000; fxg[35] = 9.7099000000; feg[35] = 0.7281000000;
					g[36] = 1.8000000000; fxg[36] = 9.4095000000; feg[36] = 0.6970000000;
					g[37] = 1.8500000000; fxg[37] = 9.1289000000; feg[37] = 0.6677000000;
					g[38] = 1.9000000000; fxg[38] = 8.8671000000; feg[38] = 0.6400000000;
					g[39] = 1.9500000000; fxg[39] = 8.6229000000; feg[39] = 0.6137000000;
					g[40] = 2.0000000000; fxg[40] = 8.3954000000; feg[40] = 0.5889000000;
					g[41] = 2.0500000000; fxg[41] = 8.1834000000; feg[41] = 0.5653000000;
					g[42] = 2.1000000000; fxg[42] = 7.9859000000; feg[42] = 0.5430000000;
					g[43] = 2.1500000000; fxg[43] = 7.8019000000; feg[43] = 0.5219000000;
					g[44] = 2.2000000000; fxg[44] = 7.6303000000; feg[44] = 0.5018000000;
					g[45] = 2.2500000000; fxg[45] = 7.4702000000; feg[45] = 0.4828000000;
					g[46] = 2.3000000000; fxg[46] = 7.3206000000; feg[46] = 0.4647000000;
					g[47] = 2.3500000000; fxg[47] = 7.1806000000; feg[47] = 0.4476000000;
					g[48] = 2.4000000000; fxg[48] = 7.0495000000; feg[48] = 0.4313000000;
					g[49] = 2.4500000000; fxg[49] = 6.9263000000; feg[49] = 0.4159000000;
					g[50] = 2.5000000000; fxg[50] = 6.8104000000; feg[50] = 0.4012000000;
					g[51] = 2.5500000000; fxg[51] = 6.7009000000; feg[51] = 0.3872000000;
					g[52] = 2.6000000000; fxg[52] = 6.5974000000; feg[52] = 0.3739000000;
					g[53] = 2.6500000000; fxg[53] = 6.4992000000; feg[53] = 0.3613000000;
					g[54] = 2.7000000000; fxg[54] = 6.4059000000; feg[54] = 0.3492000000;
					g[55] = 2.7500000000; fxg[55] = 6.3166000000; feg[55] = 0.3378000000;
					g[56] = 2.8000000000; fxg[56] = 6.2309000000; feg[56] = 0.3269000000;
					g[57] = 2.8500000000; fxg[57] = 6.1485000000; feg[57] = 0.3165000000;
					g[58] = 2.9000000000; fxg[58] = 6.0691000000; feg[58] = 0.3066000000;
					g[59] = 2.9500000000; fxg[59] = 5.9925000000; feg[59] = 0.2971000000;
					g[60] = 3.0000000000; fxg[60] = 5.9181000000; feg[60] = 0.2881000000;
					g[61] = 3.0500000000; fxg[61] = 5.8455000000; feg[61] = 0.2795000000;
					g[62] = 3.1000000000; fxg[62] = 5.7742000000; feg[62] = 0.2712000000;
					g[63] = 3.1500000000; fxg[63] = 5.7043000000; feg[63] = 0.2634000000;
					g[64] = 3.2000000000; fxg[64] = 5.6359000000; feg[64] = 0.2558000000;
					g[65] = 3.2500000000; fxg[65] = 5.5689000000; feg[65] = 0.2486000000;
					g[66] = 3.3000000000; fxg[66] = 5.5030000000; feg[66] = 0.2417000000;
					g[67] = 3.3500000000; fxg[67] = 5.4377000000; feg[67] = 0.2351000000;
					g[68] = 3.4000000000; fxg[68] = 5.3726000000; feg[68] = 0.2288000000;
					g[69] = 3.4500000000; fxg[69] = 5.3076000000; feg[69] = 0.2227000000;
					g[70] = 3.5000000000; fxg[70] = 5.2432000000; feg[70] = 0.2169000000;
					g[71] = 3.5500000000; fxg[71] = 5.1796000000; feg[71] = 0.2113000000;
					g[72] = 3.6000000000; fxg[72] = 5.1170000000; feg[72] = 0.2060000000;
					g[73] = 3.6500000000; fxg[73] = 5.0548000000; feg[73] = 0.2008000000;
					g[74] = 3.7000000000; fxg[74] = 4.9927000000; feg[74] = 0.1959000000;
					g[75] = 3.7500000000; fxg[75] = 4.9301000000; feg[75] = 0.1911000000;
					g[76] = 3.8000000000; fxg[76] = 4.8672000000; feg[76] = 0.1865000000;
					g[77] = 3.8500000000; fxg[77] = 4.8044000000; feg[77] = 0.1821000000;
					g[78] = 3.9000000000; fxg[78] = 4.7423000000; feg[78] = 0.1779000000;
					g[79] = 3.9500000000; fxg[79] = 4.6811000000; feg[79] = 0.1738000000;
					g[80] = 4.0000000000; fxg[80] = 4.6208000000; feg[80] = 0.1698000000;
					g[81] = 4.0500000000; fxg[81] = 4.5609000000; feg[81] = 0.1660000000;
					g[82] = 4.1000000000; fxg[82] = 4.5006000000; feg[82] = 0.1623000000;
					g[83] = 4.1500000000; fxg[83] = 4.4397000000; feg[83] = 0.1588000000;
					g[84] = 4.2000000000; fxg[84] = 4.3784000000; feg[84] = 0.1553000000;
					g[85] = 4.2500000000; fxg[85] = 4.3172000000; feg[85] = 0.1520000000;
					g[86] = 4.3000000000; fxg[86] = 4.2569000000; feg[86] = 0.1488000000;
					g[87] = 4.3500000000; fxg[87] = 4.1979000000; feg[87] = 0.1457000000;
					g[88] = 4.4000000000; fxg[88] = 4.1401000000; feg[88] = 0.1427000000;
					g[89] = 4.4500000000; fxg[89] = 4.0833000000; feg[89] = 0.1398000000;
					g[90] = 4.5000000000; fxg[90] = 4.0265000000; feg[90] = 0.1370000000;
					g[91] = 4.5500000000; fxg[91] = 3.9693000000; feg[91] = 0.1342000000;
					g[92] = 4.6000000000; fxg[92] = 3.9115000000; feg[92] = 0.1316000000;
					g[93] = 4.6500000000; fxg[93] = 3.8535000000; feg[93] = 0.1290000000;
					g[94] = 4.7000000000; fxg[94] = 3.7959000000; feg[94] = 0.1266000000;
					g[95] = 4.7500000000; fxg[95] = 3.7394000000; feg[95] = 0.1242000000;
					g[96] = 4.8000000000; fxg[96] = 3.6846000000; feg[96] = 0.1218000000;
					g[97] = 4.8500000000; fxg[97] = 3.6315000000; feg[97] = 0.1195000000;
					g[98] = 4.9000000000; fxg[98] = 3.5799000000; feg[98] = 0.1173000000;
					g[99] = 4.9500000000; fxg[99] = 3.5288000000; feg[99] = 0.1151000000;
					g[100] = 5.0000000000; fxg[100] = 3.4775000000; feg[100] = 0.1131000000;
					g[101] = 5.0500000000; fxg[101] = 3.4257000000; feg[101] = 0.1110000000;
					g[102] = 5.1000000000; fxg[102] = 3.3734000000; feg[102] = 0.1090000000;
					g[103] = 5.1500000000; fxg[103] = 3.3212000000; feg[103] = 0.1071000000;
					g[104] = 5.2000000000; fxg[104] = 3.2698000000; feg[104] = 0.1053000000;
					g[105] = 5.2500000000; fxg[105] = 3.2196000000; feg[105] = 0.1034000000;
					g[106] = 5.3000000000; fxg[106] = 3.1714000000; feg[106] = 0.1017000000;
					g[107] = 5.3500000000; fxg[107] = 3.1253000000; feg[107] = 0.0999000000;
					g[108] = 5.4000000000; fxg[108] = 3.0811000000; feg[108] = 0.0982000000;
					g[109] = 5.4500000000; fxg[109] = 3.0378000000; feg[109] = 0.0966000000;
					g[110] = 5.5000000000; fxg[110] = 2.9947000000; feg[110] = 0.0950000000;
					g[111] = 5.5500000000; fxg[111] = 2.9510000000; feg[111] = 0.0934000000;
					g[112] = 5.6000000000; fxg[112] = 2.9067000000; feg[112] = 0.0919000000;
					g[113] = 5.6500000000; fxg[113] = 2.8622000000; feg[113] = 0.0904000000;
					g[114] = 5.7000000000; fxg[114] = 2.8180000000; feg[114] = 0.0889000000;
					g[115] = 5.7500000000; fxg[115] = 2.7746000000; feg[115] = 0.0875000000;
					g[116] = 5.8000000000; fxg[116] = 2.7326000000; feg[116] = 0.0861000000;
					g[117] = 5.8500000000; fxg[117] = 2.6925000000; feg[117] = 0.0848000000;
					g[118] = 5.9000000000; fxg[118] = 2.6547000000; feg[118] = 0.0835000000;
					g[119] = 5.9500000000; fxg[119] = 2.6191000000; feg[119] = 0.0822000000;
					g[120] = 6.0000000000; fxg[120] = 2.5849000000; feg[120] = 0.0809000000;
					g[121] = 6.0500000000; fxg[121] = 2.5511000000; feg[121] = 0.0796000000;
					g[122] = 6.1000000000; fxg[122] = 2.5168000000; feg[122] = 0.0784000000;
					g[123] = 6.1500000000; fxg[123] = 2.4818000000; feg[123] = 0.0772000000;
					g[124] = 6.2000000000; fxg[124] = 2.4463000000; feg[124] = 0.0761000000;
					g[125] = 6.2500000000; fxg[125] = 2.4107000000; feg[125] = 0.0750000000;
					g[126] = 6.3000000000; fxg[126] = 2.3754000000; feg[126] = 0.0739000000;
					g[127] = 6.3500000000; fxg[127] = 2.3409000000; feg[127] = 0.0728000000;
					g[128] = 6.4000000000; fxg[128] = 2.3074000000; feg[128] = 0.0717000000;
					g[129] = 6.4500000000; fxg[129] = 2.2756000000; feg[129] = 0.0707000000;
					g[130] = 6.5000000000; fxg[130] = 2.2460000000; feg[130] = 0.0697000000;
					g[131] = 6.5500000000; fxg[131] = 2.2187000000; feg[131] = 0.0687000000;
					g[132] = 6.6000000000; fxg[132] = 2.1933000000; feg[132] = 0.0677000000;
					g[133] = 6.6500000000; fxg[133] = 2.1689000000; feg[133] = 0.0667000000;
					g[134] = 6.7000000000; fxg[134] = 2.1443000000; feg[134] = 0.0658000000;
					g[135] = 6.7500000000; fxg[135] = 2.1188000000; feg[135] = 0.0649000000;
					g[136] = 6.8000000000; fxg[136] = 2.0924000000; feg[136] = 0.0640000000;
					g[137] = 6.8500000000; fxg[137] = 2.0655000000; feg[137] = 0.0631000000;
					g[138] = 6.9000000000; fxg[138] = 2.0386000000; feg[138] = 0.0623000000;
					g[139] = 6.9500000000; fxg[139] = 2.0120000000; feg[139] = 0.0614000000;
					g[140] = 7.0000000000; fxg[140] = 1.9858000000; feg[140] = 0.0606000000;
					g[141] = 7.0500000000; fxg[141] = 1.9603000000; feg[141] = 0.0598000000;
					g[142] = 7.1000000000; fxg[142] = 1.9359000000; feg[142] = 0.0590000000;
					g[143] = 7.1500000000; fxg[143] = 1.9131000000; feg[143] = 0.0582000000;
					g[144] = 7.2000000000; fxg[144] = 1.8924000000; feg[144] = 0.0574000000;
					g[145] = 7.2500000000; fxg[145] = 1.8740000000; feg[145] = 0.0567000000;
					g[146] = 7.3000000000; fxg[146] = 1.8574000000; feg[146] = 0.0559000000;
					g[147] = 7.3500000000; fxg[147] = 1.8414000000; feg[147] = 0.0552000000;
					g[148] = 7.4000000000; fxg[148] = 1.8250000000; feg[148] = 0.0545000000;
					g[149] = 7.4500000000; fxg[149] = 1.8074000000; feg[149] = 0.0538000000;
					g[150] = 7.5000000000; fxg[150] = 1.7887000000; feg[150] = 0.0531000000;
					g[151] = 7.5500000000; fxg[151] = 1.7693000000; feg[151] = 0.0525000000;
					g[152] = 7.6000000000; fxg[152] = 1.7498000000; feg[152] = 0.0518000000;
					g[153] = 7.6500000000; fxg[153] = 1.7306000000; feg[153] = 0.0512000000;
					g[154] = 7.7000000000; fxg[154] = 1.7117000000; feg[154] = 0.0505000000;
					g[155] = 7.7500000000; fxg[155] = 1.6932000000; feg[155] = 0.0499000000;
					g[156] = 7.8000000000; fxg[156] = 1.6749000000; feg[156] = 0.0493000000;
					g[157] = 7.8500000000; fxg[157] = 1.6573000000; feg[157] = 0.0487000000;
					g[158] = 7.9000000000; fxg[158] = 1.6410000000; feg[158] = 0.0481000000;
					g[159] = 7.9500000000; fxg[159] = 1.6266000000; feg[159] = 0.0475000000;
					g[160] = 8.0000000000; fxg[160] = 1.6145000000; feg[160] = 0.0469000000;
					g[161] = 8.0500000000; fxg[161] = 1.6042000000; feg[161] = 0.0464000000;
					g[162] = 8.1000000000; fxg[162] = 1.5948000000; feg[162] = 0.0458000000;
					g[163] = 8.1500000000; fxg[163] = 1.5853000000; feg[163] = 0.0453000000;
					g[164] = 8.2000000000; fxg[164] = 1.5746000000; feg[164] = 0.0447000000;
					g[165] = 8.2500000000; fxg[165] = 1.5624000000; feg[165] = 0.0442000000;
					g[166] = 8.3000000000; fxg[166] = 1.5490000000; feg[166] = 0.0437000000;
					g[167] = 8.3500000000; fxg[167] = 1.5351000000; feg[167] = 0.0432000000;
					g[168] = 8.4000000000; fxg[168] = 1.5214000000; feg[168] = 0.0427000000;
					g[169] = 8.4500000000; fxg[169] = 1.5081000000; feg[169] = 0.0422000000;
					g[170] = 8.5000000000; fxg[170] = 1.4952000000; feg[170] = 0.0417000000;
					g[171] = 8.5500000000; fxg[171] = 1.4824000000; feg[171] = 0.0413000000;
					g[172] = 8.6000000000; fxg[172] = 1.4695000000; feg[172] = 0.0408000000;
					g[173] = 8.6500000000; fxg[173] = 1.4566000000; feg[173] = 0.0404000000;
					g[174] = 8.7000000000; fxg[174] = 1.4443000000; feg[174] = 0.0399000000;
					g[175] = 8.7500000000; fxg[175] = 1.4332000000; feg[175] = 0.0395000000;
					g[176] = 8.8000000000; fxg[176] = 1.4240000000; feg[176] = 0.0390000000;
					g[177] = 8.8500000000; fxg[177] = 1.4170000000; feg[177] = 0.0386000000;
					g[178] = 8.9000000000; fxg[178] = 1.4117000000; feg[178] = 0.0382000000;
					g[179] = 8.9500000000; fxg[179] = 1.4071000000; feg[179] = 0.0378000000;
					g[180] = 9.0000000000; fxg[180] = 1.4023000000; feg[180] = 0.0373000000;
					g[181] = 9.0500000000; fxg[181] = 1.3961000000; feg[181] = 0.0369000000;
					g[182] = 9.1000000000; fxg[182] = 1.3883000000; feg[182] = 0.0365000000;
					g[183] = 9.1500000000; fxg[183] = 1.3789000000; feg[183] = 0.0362000000;
					g[184] = 9.2000000000; fxg[184] = 1.3687000000; feg[184] = 0.0358000000;
					g[185] = 9.2500000000; fxg[185] = 1.3586000000; feg[185] = 0.0354000000;
					g[186] = 9.3000000000; fxg[186] = 1.3490000000; feg[186] = 0.0350000000;
					g[187] = 9.3500000000; fxg[187] = 1.3402000000; feg[187] = 0.0347000000;
					g[188] = 9.4000000000; fxg[188] = 1.3317000000; feg[188] = 0.0343000000;
					g[189] = 9.4500000000; fxg[189] = 1.3230000000; feg[189] = 0.0340000000;
					g[190] = 9.5000000000; fxg[190] = 1.3138000000; feg[190] = 0.0336000000;
					g[191] = 9.5500000000; fxg[191] = 1.3043000000; feg[191] = 0.0333000000;
					g[192] = 9.6000000000; fxg[192] = 1.2948000000; feg[192] = 0.0329000000;
					g[193] = 9.6500000000; fxg[193] = 1.2861000000; feg[193] = 0.0326000000;
					g[194] = 9.7000000000; fxg[194] = 1.2788000000; feg[194] = 0.0323000000;
					g[195] = 9.7500000000; fxg[195] = 1.2734000000; feg[195] = 0.0320000000;
					g[196] = 9.8000000000; fxg[196] = 1.2701000000; feg[196] = 0.0316000000;
					g[197] = 9.8500000000; fxg[197] = 1.2682000000; feg[197] = 0.0313000000;
					g[198] = 9.9000000000; fxg[198] = 1.2667000000; feg[198] = 0.0310000000;
					g[199] = 9.9500000000; fxg[199] = 1.2646000000; feg[199] = 0.0307000000;
					g[200] = 10.0000000000; fxg[200] = 1.2610000000; feg[200] = 0.0304000000;
					g[201] = 10.0500000000; fxg[201] = 1.2555000000; feg[201] = 0.0301000000;
					g[202] = 10.1000000000; fxg[202] = 1.2483000000; feg[202] = 0.0298000000;
					g[203] = 10.1500000000; fxg[203] = 1.2402000000; feg[203] = 0.0295000000;
					g[204] = 10.2000000000; fxg[204] = 1.2320000000; feg[204] = 0.0292000000;
					g[205] = 10.2500000000; fxg[205] = 1.2245000000; feg[205] = 0.0290000000;
					g[206] = 10.3000000000; fxg[206] = 1.2180000000; feg[206] = 0.0287000000;
					g[207] = 10.3500000000; fxg[207] = 1.2122000000; feg[207] = 0.0284000000;
					g[208] = 10.4000000000; fxg[208] = 1.2066000000; feg[208] = 0.0281000000;
					g[209] = 10.4500000000; fxg[209] = 1.2005000000; feg[209] = 0.0279000000;
					g[210] = 10.5000000000; fxg[210] = 1.1937000000; feg[210] = 0.0276000000;
					g[211] = 10.5500000000; fxg[211] = 1.1862000000; feg[211] = 0.0274000000;
					g[212] = 10.6000000000; fxg[212] = 1.1784000000; feg[212] = 0.0271000000;
					g[213] = 10.6500000000; fxg[213] = 1.1709000000; feg[213] = 0.0269000000;
					g[214] = 10.7000000000; fxg[214] = 1.1644000000; feg[214] = 0.0266000000;
					g[215] = 10.7500000000; fxg[215] = 1.1596000000; feg[215] = 0.0264000000;
					g[216] = 10.8000000000; fxg[216] = 1.1567000000; feg[216] = 0.0261000000;
					g[217] = 10.8500000000; fxg[217] = 1.1557000000; feg[217] = 0.0259000000;
					g[218] = 10.9000000000; fxg[218] = 1.1558000000; feg[218] = 0.0257000000;
					g[219] = 10.9500000000; fxg[219] = 1.1560000000; feg[219] = 0.0254000000;
					g[220] = 11.0000000000; fxg[220] = 1.1553000000; feg[220] = 0.0252000000;
					g[221] = 11.0500000000; fxg[221] = 1.1529000000; feg[221] = 0.0250000000;
					g[222] = 11.1000000000; fxg[222] = 1.1485000000; feg[222] = 0.0247000000;
					g[223] = 11.1500000000; fxg[223] = 1.1424000000; feg[223] = 0.0245000000;
					g[224] = 11.2000000000; fxg[224] = 1.1352000000; feg[224] = 0.0243000000;
					g[225] = 11.2500000000; fxg[225] = 1.1278000000; feg[225] = 0.0241000000;
					g[226] = 11.3000000000; fxg[226] = 1.1211000000; feg[226] = 0.0239000000;
					g[227] = 11.3500000000; fxg[227] = 1.1154000000; feg[227] = 0.0237000000;
					g[228] = 11.4000000000; fxg[228] = 1.1109000000; feg[228] = 0.0235000000;
					g[229] = 11.4500000000; fxg[229] = 1.1071000000; feg[229] = 0.0233000000;
					g[230] = 11.5000000000; fxg[230] = 1.1032000000; feg[230] = 0.0231000000;
					g[231] = 11.5500000000; fxg[231] = 1.0986000000; feg[231] = 0.0229000000;
					g[232] = 11.6000000000; fxg[232] = 1.0932000000; feg[232] = 0.0227000000;
					g[233] = 11.6500000000; fxg[233] = 1.0869000000; feg[233] = 0.0225000000;
					g[234] = 11.7000000000; fxg[234] = 1.0800000000; feg[234] = 0.0223000000;
					g[235] = 11.7500000000; fxg[235] = 1.0731000000; feg[235] = 0.0221000000;
					g[236] = 11.8000000000; fxg[236] = 1.0667000000; feg[236] = 0.0220000000;
					g[237] = 11.8500000000; fxg[237] = 1.0614000000; feg[237] = 0.0218000000;
					g[238] = 11.9000000000; fxg[238] = 1.0579000000; feg[238] = 0.0216000000;
					g[239] = 11.9500000000; fxg[239] = 1.0563000000; feg[239] = 0.0214000000;
					g[240] = 12.0000000000; fxg[240] = 1.0563000000; feg[240] = 0.0212000000;
					break;
				case 34:
					g[0] = 0.0000000000; fxg[0] = 34.0000000000; feg[0] = 7.3288000000;
					g[1] = 0.0500000000; fxg[1] = 33.8108000000; feg[1] = 7.2434000000;
					g[2] = 0.1000000000; fxg[2] = 33.2689000000; feg[2] = 6.9987000000;
					g[3] = 0.1500000000; fxg[3] = 32.4426000000; feg[3] = 6.6264000000;
					g[4] = 0.2000000000; fxg[4] = 31.4226000000; feg[4] = 6.1686000000;
					g[5] = 0.2500000000; fxg[5] = 30.2997000000; feg[5] = 5.6680000000;
					g[6] = 0.3000000000; fxg[6] = 29.1484000000; feg[6] = 5.1608000000;
					g[7] = 0.3500000000; fxg[7] = 28.0206000000; feg[7] = 4.6729000000;
					g[8] = 0.4000000000; fxg[8] = 26.9464000000; feg[8] = 4.2205000000;
					g[9] = 0.4500000000; fxg[9] = 25.9383000000; feg[9] = 3.8113000000;
					g[10] = 0.5000000000; fxg[10] = 24.9973000000; feg[10] = 3.4475000000;
					g[11] = 0.5500000000; fxg[11] = 24.1177000000; feg[11] = 3.1275000000;
					g[12] = 0.6000000000; fxg[12] = 23.2905000000; feg[12] = 2.8480000000;
					g[13] = 0.6500000000; fxg[13] = 22.5063000000; feg[13] = 2.6044000000;
					g[14] = 0.7000000000; fxg[14] = 21.7564000000; feg[14] = 2.3921000000;
					g[15] = 0.7500000000; fxg[15] = 21.0335000000; feg[15] = 2.2068000000;
					g[16] = 0.8000000000; fxg[16] = 20.3322000000; feg[16] = 2.0445000000;
					g[17] = 0.8500000000; fxg[17] = 19.6484000000; feg[17] = 1.9017000000;
					g[18] = 0.9000000000; fxg[18] = 18.9798000000; feg[18] = 1.7753000000;
					g[19] = 0.9500000000; fxg[19] = 18.3251000000; feg[19] = 1.6627000000;
					g[20] = 1.0000000000; fxg[20] = 17.6840000000; feg[20] = 1.5620000000;
					g[21] = 1.0500000000; fxg[21] = 17.0569000000; feg[21] = 1.4712000000;
					g[22] = 1.1000000000; fxg[22] = 16.4446000000; feg[22] = 1.3890000000;
					g[23] = 1.1500000000; fxg[23] = 15.8482000000; feg[23] = 1.3140000000;
					g[24] = 1.2000000000; fxg[24] = 15.2687000000; feg[24] = 1.2453000000;
					g[25] = 1.2500000000; fxg[25] = 14.7076000000; feg[25] = 1.1821000000;
					g[26] = 1.3000000000; fxg[26] = 14.1657000000; feg[26] = 1.1236000000;
					g[27] = 1.3500000000; fxg[27] = 13.6442000000; feg[27] = 1.0693000000;
					g[28] = 1.4000000000; fxg[28] = 13.1437000000; feg[28] = 1.0187000000;
					g[29] = 1.4500000000; fxg[29] = 12.6648000000; feg[29] = 0.9715000000;
					g[30] = 1.5000000000; fxg[30] = 12.2080000000; feg[30] = 0.9272000000;
					g[31] = 1.5500000000; fxg[31] = 11.7733000000; feg[31] = 0.8857000000;
					g[32] = 1.6000000000; fxg[32] = 11.3608000000; feg[32] = 0.8466000000;
					g[33] = 1.6500000000; fxg[33] = 10.9702000000; feg[33] = 0.8098000000;
					g[34] = 1.7000000000; fxg[34] = 10.6013000000; feg[34] = 0.7751000000;
					g[35] = 1.7500000000; fxg[35] = 10.2535000000; feg[35] = 0.7423000000;
					g[36] = 1.8000000000; fxg[36] = 9.9263000000; feg[36] = 0.7113000000;
					g[37] = 1.8500000000; fxg[37] = 9.6189000000; feg[37] = 0.6820000000;
					g[38] = 1.9000000000; fxg[38] = 9.3305000000; feg[38] = 0.6542000000;
					g[39] = 1.9500000000; fxg[39] = 9.0604000000; feg[39] = 0.6279000000;
					g[40] = 2.0000000000; fxg[40] = 8.8076000000; feg[40] = 0.6029000000;
					g[41] = 2.0500000000; fxg[41] = 8.5712000000; feg[41] = 0.5793000000;
					g[42] = 2.1000000000; fxg[42] = 8.3503000000; feg[42] = 0.5568000000;
					g[43] = 2.1500000000; fxg[43] = 8.1439000000; feg[43] = 0.5355000000;
					g[44] = 2.2000000000; fxg[44] = 7.9512000000; feg[44] = 0.5152000000;
					g[45] = 2.2500000000; fxg[45] = 7.7711000000; feg[45] = 0.4960000000;
					g[46] = 2.3000000000; fxg[46] = 7.6029000000; feg[46] = 0.4777000000;
					g[47] = 2.3500000000; fxg[47] = 7.4455000000; feg[47] = 0.4603000000;
					g[48] = 2.4000000000; fxg[48] = 7.2983000000; feg[48] = 0.4438000000;
					g[49] = 2.4500000000; fxg[49] = 7.1604000000; feg[49] = 0.4281000000;
					g[50] = 2.5000000000; fxg[50] = 7.0310000000; feg[50] = 0.4131000000;
					g[51] = 2.5500000000; fxg[51] = 6.9093000000; feg[51] = 0.3988000000;
					g[52] = 2.6000000000; fxg[52] = 6.7947000000; feg[52] = 0.3853000000;
					g[53] = 2.6500000000; fxg[53] = 6.6866000000; feg[53] = 0.3724000000;
					g[54] = 2.7000000000; fxg[54] = 6.5843000000; feg[54] = 0.3600000000;
					g[55] = 2.7500000000; fxg[55] = 6.4873000000; feg[55] = 0.3483000000;
					g[56] = 2.8000000000; fxg[56] = 6.3949000000; feg[56] = 0.3371000000;
					g[57] = 2.8500000000; fxg[57] = 6.3067000000; feg[57] = 0.3264000000;
					g[58] = 2.9000000000; fxg[58] = 6.2224000000; feg[58] = 0.3162000000;
					g[59] = 2.9500000000; fxg[59] = 6.1415000000; feg[59] = 0.3065000000;
					g[60] = 3.0000000000; fxg[60] = 6.0637000000; feg[60] = 0.2972000000;
					g[61] = 3.0500000000; fxg[61] = 5.9884000000; feg[61] = 0.2883000000;
					g[62] = 3.1000000000; fxg[62] = 5.9152000000; feg[62] = 0.2798000000;
					g[63] = 3.1500000000; fxg[63] = 5.8440000000; feg[63] = 0.2717000000;
					g[64] = 3.2000000000; fxg[64] = 5.7747000000; feg[64] = 0.2639000000;
					g[65] = 3.2500000000; fxg[65] = 5.7072000000; feg[65] = 0.2564000000;
					g[66] = 3.3000000000; fxg[66] = 5.6412000000; feg[66] = 0.2493000000;
					g[67] = 3.3500000000; fxg[67] = 5.5762000000; feg[67] = 0.2425000000;
					g[68] = 3.4000000000; fxg[68] = 5.5118000000; feg[68] = 0.2359000000;
					g[69] = 3.4500000000; fxg[69] = 5.4481000000; feg[69] = 0.2296000000;
					g[70] = 3.5000000000; fxg[70] = 5.3852000000; feg[70] = 0.2236000000;
					g[71] = 3.5500000000; fxg[71] = 5.3232000000; feg[71] = 0.2178000000;
					g[72] = 3.6000000000; fxg[72] = 5.2621000000; feg[72] = 0.2123000000;
					g[73] = 3.6500000000; fxg[73] = 5.2016000000; feg[73] = 0.2069000000;
					g[74] = 3.7000000000; fxg[74] = 5.1412000000; feg[74] = 0.2018000000;
					g[75] = 3.7500000000; fxg[75] = 5.0807000000; feg[75] = 0.1969000000;
					g[76] = 3.8000000000; fxg[76] = 5.0201000000; feg[76] = 0.1921000000;
					g[77] = 3.8500000000; fxg[77] = 4.9597000000; feg[77] = 0.1876000000;
					g[78] = 3.9000000000; fxg[78] = 4.8999000000; feg[78] = 0.1832000000;
					g[79] = 3.9500000000; fxg[79] = 4.8409000000; feg[79] = 0.1789000000;
					g[80] = 4.0000000000; fxg[80] = 4.7825000000; feg[80] = 0.1748000000;
					g[81] = 4.0500000000; fxg[81] = 4.7244000000; feg[81] = 0.1709000000;
					g[82] = 4.1000000000; fxg[82] = 4.6660000000; feg[82] = 0.1671000000;
					g[83] = 4.1500000000; fxg[83] = 4.6071000000; feg[83] = 0.1634000000;
					g[84] = 4.2000000000; fxg[84] = 4.5479000000; feg[84] = 0.1598000000;
					g[85] = 4.2500000000; fxg[85] = 4.4888000000; feg[85] = 0.1564000000;
					g[86] = 4.3000000000; fxg[86] = 4.4303000000; feg[86] = 0.1531000000;
					g[87] = 4.3500000000; fxg[87] = 4.3729000000; feg[87] = 0.1499000000;
					g[88] = 4.4000000000; fxg[88] = 4.3165000000; feg[88] = 0.1468000000;
					g[89] = 4.4500000000; fxg[89] = 4.2607000000; feg[89] = 0.1438000000;
					g[90] = 4.5000000000; fxg[90] = 4.2049000000; feg[90] = 0.1409000000;
					g[91] = 4.5500000000; fxg[91] = 4.1487000000; feg[91] = 0.1380000000;
					g[92] = 4.6000000000; fxg[92] = 4.0919000000; feg[92] = 0.1353000000;
					g[93] = 4.6500000000; fxg[93] = 4.0349000000; feg[93] = 0.1327000000;
					g[94] = 4.7000000000; fxg[94] = 3.9783000000; feg[94] = 0.1301000000;
					g[95] = 4.7500000000; fxg[95] = 3.9225000000; feg[95] = 0.1276000000;
					g[96] = 4.8000000000; fxg[96] = 3.8682000000; feg[96] = 0.1252000000;
					g[97] = 4.8500000000; fxg[97] = 3.8154000000; feg[97] = 0.1228000000;
					g[98] = 4.9000000000; fxg[98] = 3.7637000000; feg[98] = 0.1206000000;
					g[99] = 4.9500000000; fxg[99] = 3.7124000000; feg[99] = 0.1183000000;
					g[100] = 5.0000000000; fxg[100] = 3.6609000000; feg[100] = 0.1162000000;
					g[101] = 5.0500000000; fxg[101] = 3.6088000000; feg[101] = 0.1141000000;
					g[102] = 5.1000000000; fxg[102] = 3.5563000000; feg[102] = 0.1121000000;
					g[103] = 5.1500000000; fxg[103] = 3.5038000000; feg[103] = 0.1101000000;
					g[104] = 5.2000000000; fxg[104] = 3.4519000000; feg[104] = 0.1082000000;
					g[105] = 5.2500000000; fxg[105] = 3.4013000000; feg[105] = 0.1063000000;
					g[106] = 5.3000000000; fxg[106] = 3.3525000000; feg[106] = 0.1045000000;
					g[107] = 5.3500000000; fxg[107] = 3.3055000000; feg[107] = 0.1027000000;
					g[108] = 5.4000000000; fxg[108] = 3.2601000000; feg[108] = 0.1009000000;
					g[109] = 5.4500000000; fxg[109] = 3.2156000000; feg[109] = 0.0992000000;
					g[110] = 5.5000000000; fxg[110] = 3.1711000000; feg[110] = 0.0976000000;
					g[111] = 5.5500000000; fxg[111] = 3.1261000000; feg[111] = 0.0960000000;
					g[112] = 5.6000000000; fxg[112] = 3.0805000000; feg[112] = 0.0944000000;
					g[113] = 5.6500000000; fxg[113] = 3.0347000000; feg[113] = 0.0929000000;
					g[114] = 5.7000000000; fxg[114] = 2.9890000000; feg[114] = 0.0914000000;
					g[115] = 5.7500000000; fxg[115] = 2.9441000000; feg[115] = 0.0899000000;
					g[116] = 5.8000000000; fxg[116] = 2.9006000000; feg[116] = 0.0885000000;
					g[117] = 5.8500000000; fxg[117] = 2.8590000000; feg[117] = 0.0871000000;
					g[118] = 5.9000000000; fxg[118] = 2.8196000000; feg[118] = 0.0858000000;
					g[119] = 5.9500000000; fxg[119] = 2.7821000000; feg[119] = 0.0844000000;
					g[120] = 6.0000000000; fxg[120] = 2.7460000000; feg[120] = 0.0831000000;
					g[121] = 6.0500000000; fxg[121] = 2.7102000000; feg[121] = 0.0818000000;
					g[122] = 6.1000000000; fxg[122] = 2.6740000000; feg[122] = 0.0806000000;
					g[123] = 6.1500000000; fxg[123] = 2.6371000000; feg[123] = 0.0794000000;
					g[124] = 6.2000000000; fxg[124] = 2.5996000000; feg[124] = 0.0782000000;
					g[125] = 6.2500000000; fxg[125] = 2.5619000000; feg[125] = 0.0770000000;
					g[126] = 6.3000000000; fxg[126] = 2.5244000000; feg[126] = 0.0759000000;
					g[127] = 6.3500000000; fxg[127] = 2.4877000000; feg[127] = 0.0748000000;
					g[128] = 6.4000000000; fxg[128] = 2.4522000000; feg[128] = 0.0737000000;
					g[129] = 6.4500000000; fxg[129] = 2.4185000000; feg[129] = 0.0727000000;
					g[130] = 6.5000000000; fxg[130] = 2.3870000000; feg[130] = 0.0716000000;
					g[131] = 6.5500000000; fxg[131] = 2.3577000000; feg[131] = 0.0706000000;
					g[132] = 6.6000000000; fxg[132] = 2.3302000000; feg[132] = 0.0696000000;
					g[133] = 6.6500000000; fxg[133] = 2.3036000000; feg[133] = 0.0686000000;
					g[134] = 6.7000000000; fxg[134] = 2.2769000000; feg[134] = 0.0677000000;
					g[135] = 6.7500000000; fxg[135] = 2.2495000000; feg[135] = 0.0667000000;
					g[136] = 6.8000000000; fxg[136] = 2.2211000000; feg[136] = 0.0658000000;
					g[137] = 6.8500000000; fxg[137] = 2.1921000000; feg[137] = 0.0649000000;
					g[138] = 6.9000000000; fxg[138] = 2.1629000000; feg[138] = 0.0640000000;
					g[139] = 6.9500000000; fxg[139] = 2.1338000000; feg[139] = 0.0632000000;
					g[140] = 7.0000000000; fxg[140] = 2.1052000000; feg[140] = 0.0623000000;
					g[141] = 7.0500000000; fxg[141] = 2.0774000000; feg[141] = 0.0615000000;
					g[142] = 7.1000000000; fxg[142] = 2.0510000000; feg[142] = 0.0607000000;
					g[143] = 7.1500000000; fxg[143] = 2.0263000000; feg[143] = 0.0599000000;
					g[144] = 7.2000000000; fxg[144] = 2.0039000000; feg[144] = 0.0591000000;
					g[145] = 7.2500000000; fxg[145] = 1.9837000000; feg[145] = 0.0583000000;
					g[146] = 7.3000000000; fxg[146] = 1.9652000000; feg[146] = 0.0576000000;
					g[147] = 7.3500000000; fxg[147] = 1.9473000000; feg[147] = 0.0568000000;
					g[148] = 7.4000000000; fxg[148] = 1.9291000000; feg[148] = 0.0561000000;
					g[149] = 7.4500000000; fxg[149] = 1.9099000000; feg[149] = 0.0554000000;
					g[150] = 7.5000000000; fxg[150] = 1.8895000000; feg[150] = 0.0547000000;
					g[151] = 7.5500000000; fxg[151] = 1.8683000000; feg[151] = 0.0540000000;
					g[152] = 7.6000000000; fxg[152] = 1.8468000000; feg[152] = 0.0533000000;
					g[153] = 7.6500000000; fxg[153] = 1.8253000000; feg[153] = 0.0526000000;
					g[154] = 7.7000000000; fxg[154] = 1.8041000000; feg[154] = 0.0520000000;
					g[155] = 7.7500000000; fxg[155] = 1.7832000000; feg[155] = 0.0514000000;
					g[156] = 7.8000000000; fxg[156] = 1.7629000000; feg[156] = 0.0507000000;
					g[157] = 7.8500000000; fxg[157] = 1.7436000000; feg[157] = 0.0501000000;
					g[158] = 7.9000000000; fxg[158] = 1.7258000000; feg[158] = 0.0495000000;
					g[159] = 7.9500000000; fxg[159] = 1.7102000000; feg[159] = 0.0489000000;
					g[160] = 8.0000000000; fxg[160] = 1.6967000000; feg[160] = 0.0483000000;
					g[161] = 8.0500000000; fxg[161] = 1.6850000000; feg[161] = 0.0477000000;
					g[162] = 8.1000000000; fxg[162] = 1.6743000000; feg[162] = 0.0472000000;
					g[163] = 8.1500000000; fxg[163] = 1.6635000000; feg[163] = 0.0466000000;
					g[164] = 8.2000000000; fxg[164] = 1.6516000000; feg[164] = 0.0461000000;
					g[165] = 8.2500000000; fxg[165] = 1.6383000000; feg[165] = 0.0455000000;
					g[166] = 8.3000000000; fxg[166] = 1.6238000000; feg[166] = 0.0450000000;
					g[167] = 8.3500000000; fxg[167] = 1.6085000000; feg[167] = 0.0445000000;
					g[168] = 8.4000000000; fxg[168] = 1.5932000000; feg[168] = 0.0440000000;
					g[169] = 8.4500000000; fxg[169] = 1.5780000000; feg[169] = 0.0435000000;
					g[170] = 8.5000000000; fxg[170] = 1.5630000000; feg[170] = 0.0430000000;
					g[171] = 8.5500000000; fxg[171] = 1.5482000000; feg[171] = 0.0425000000;
					g[172] = 8.6000000000; fxg[172] = 1.5335000000; feg[172] = 0.0420000000;
					g[173] = 8.6500000000; fxg[173] = 1.5192000000; feg[173] = 0.0416000000;
					g[174] = 8.7000000000; fxg[174] = 1.5058000000; feg[174] = 0.0411000000;
					g[175] = 8.7500000000; fxg[175] = 1.4938000000; feg[175] = 0.0406000000;
					g[176] = 8.8000000000; fxg[176] = 1.4839000000; feg[176] = 0.0402000000;
					g[177] = 8.8500000000; fxg[177] = 1.4761000000; feg[177] = 0.0398000000;
					g[178] = 8.9000000000; fxg[178] = 1.4700000000; feg[178] = 0.0393000000;
					g[179] = 8.9500000000; fxg[179] = 1.4647000000; feg[179] = 0.0389000000;
					g[180] = 9.0000000000; fxg[180] = 1.4591000000; feg[180] = 0.0385000000;
					g[181] = 9.0500000000; fxg[181] = 1.4523000000; feg[181] = 0.0380000000;
					g[182] = 9.1000000000; fxg[182] = 1.4439000000; feg[182] = 0.0376000000;
					g[183] = 9.1500000000; fxg[183] = 1.4339000000; feg[183] = 0.0372000000;
					g[184] = 9.2000000000; fxg[184] = 1.4231000000; feg[184] = 0.0368000000;
					g[185] = 9.2500000000; fxg[185] = 1.4120000000; feg[185] = 0.0365000000;
					g[186] = 9.3000000000; fxg[186] = 1.4012000000; feg[186] = 0.0361000000;
					g[187] = 9.3500000000; fxg[187] = 1.3908000000; feg[187] = 0.0357000000;
					g[188] = 9.4000000000; fxg[188] = 1.3806000000; feg[188] = 0.0353000000;
					g[189] = 9.4500000000; fxg[189] = 1.3704000000; feg[189] = 0.0350000000;
					g[190] = 9.5000000000; fxg[190] = 1.3599000000; feg[190] = 0.0346000000;
					g[191] = 9.5500000000; fxg[191] = 1.3493000000; feg[191] = 0.0343000000;
					g[192] = 9.6000000000; fxg[192] = 1.3391000000; feg[192] = 0.0339000000;
					g[193] = 9.6500000000; fxg[193] = 1.3298000000; feg[193] = 0.0336000000;
					g[194] = 9.7000000000; fxg[194] = 1.3222000000; feg[194] = 0.0332000000;
					g[195] = 9.7500000000; fxg[195] = 1.3166000000; feg[195] = 0.0329000000;
					g[196] = 9.8000000000; fxg[196] = 1.3130000000; feg[196] = 0.0326000000;
					g[197] = 9.8500000000; fxg[197] = 1.3108000000; feg[197] = 0.0323000000;
					g[198] = 9.9000000000; fxg[198] = 1.3091000000; feg[198] = 0.0319000000;
					g[199] = 9.9500000000; fxg[199] = 1.3067000000; feg[199] = 0.0316000000;
					g[200] = 10.0000000000; fxg[200] = 1.3029000000; feg[200] = 0.0313000000;
					g[201] = 10.0500000000; fxg[201] = 1.2973000000; feg[201] = 0.0310000000;
					g[202] = 10.1000000000; fxg[202] = 1.2900000000; feg[202] = 0.0307000000;
					g[203] = 10.1500000000; fxg[203] = 1.2817000000; feg[203] = 0.0304000000;
					g[204] = 10.2000000000; fxg[204] = 1.2731000000; feg[204] = 0.0301000000;
					g[205] = 10.2500000000; fxg[205] = 1.2649000000; feg[205] = 0.0298000000;
					g[206] = 10.3000000000; fxg[206] = 1.2574000000; feg[206] = 0.0295000000;
					g[207] = 10.3500000000; fxg[207] = 1.2505000000; feg[207] = 0.0293000000;
					g[208] = 10.4000000000; fxg[208] = 1.2437000000; feg[208] = 0.0290000000;
					g[209] = 10.4500000000; fxg[209] = 1.2366000000; feg[209] = 0.0287000000;
					g[210] = 10.5000000000; fxg[210] = 1.2288000000; feg[210] = 0.0285000000;
					g[211] = 10.5500000000; fxg[211] = 1.2206000000; feg[211] = 0.0282000000;
					g[212] = 10.6000000000; fxg[212] = 1.2123000000; feg[212] = 0.0279000000;
					g[213] = 10.6500000000; fxg[213] = 1.2045000000; feg[213] = 0.0277000000;
					g[214] = 10.7000000000; fxg[214] = 1.1980000000; feg[214] = 0.0274000000;
					g[215] = 10.7500000000; fxg[215] = 1.1932000000; feg[215] = 0.0272000000;
					g[216] = 10.8000000000; fxg[216] = 1.1904000000; feg[216] = 0.0269000000;
					g[217] = 10.8500000000; fxg[217] = 1.1895000000; feg[217] = 0.0267000000;
					g[218] = 10.9000000000; fxg[218] = 1.1896000000; feg[218] = 0.0264000000;
					g[219] = 10.9500000000; fxg[219] = 1.1900000000; feg[219] = 0.0262000000;
					g[220] = 11.0000000000; fxg[220] = 1.1894000000; feg[220] = 0.0260000000;
					g[221] = 11.0500000000; fxg[221] = 1.1871000000; feg[221] = 0.0257000000;
					g[222] = 11.1000000000; fxg[222] = 1.1829000000; feg[222] = 0.0255000000;
					g[223] = 11.1500000000; fxg[223] = 1.1769000000; feg[223] = 0.0253000000;
					g[224] = 11.2000000000; fxg[224] = 1.1698000000; feg[224] = 0.0251000000;
					g[225] = 11.2500000000; fxg[225] = 1.1623000000; feg[225] = 0.0248000000;
					g[226] = 11.3000000000; fxg[226] = 1.1552000000; feg[226] = 0.0246000000;
					g[227] = 11.3500000000; fxg[227] = 1.1491000000; feg[227] = 0.0244000000;
					g[228] = 11.4000000000; fxg[228] = 1.1440000000; feg[228] = 0.0242000000;
					g[229] = 11.4500000000; fxg[229] = 1.1394000000; feg[229] = 0.0240000000;
					g[230] = 11.5000000000; fxg[230] = 1.1348000000; feg[230] = 0.0238000000;
					g[231] = 11.5500000000; fxg[231] = 1.1297000000; feg[231] = 0.0236000000;
					g[232] = 11.6000000000; fxg[232] = 1.1237000000; feg[232] = 0.0234000000;
					g[233] = 11.6500000000; fxg[233] = 1.1169000000; feg[233] = 0.0232000000;
					g[234] = 11.7000000000; fxg[234] = 1.1096000000; feg[234] = 0.0230000000;
					g[235] = 11.7500000000; fxg[235] = 1.1025000000; feg[235] = 0.0228000000;
					g[236] = 11.8000000000; fxg[236] = 1.0960000000; feg[236] = 0.0226000000;
					g[237] = 11.8500000000; fxg[237] = 1.0908000000; feg[237] = 0.0224000000;
					g[238] = 11.9000000000; fxg[238] = 1.0875000000; feg[238] = 0.0223000000;
					g[239] = 11.9500000000; fxg[239] = 1.0862000000; feg[239] = 0.0221000000;
					g[240] = 12.0000000000; fxg[240] = 1.0865000000; feg[240] = 0.0219000000;
					break;
				case 35:
					g[0] = 0.0000000000; fxg[0] = 35.0000000000; feg[0] = 7.1192000000;
					g[1] = 0.0500000000; fxg[1] = 34.8159000000; feg[1] = 7.0489000000;
					g[2] = 0.1000000000; fxg[2] = 34.2849000000; feg[2] = 6.8458000000;
					g[3] = 0.1500000000; fxg[3] = 33.4649000000; feg[3] = 6.5317000000;
					g[4] = 0.2000000000; fxg[4] = 32.4358000000; feg[4] = 6.1371000000;
					g[5] = 0.2500000000; fxg[5] = 31.2823000000; feg[5] = 5.6945000000;
					g[6] = 0.3000000000; fxg[6] = 30.0798000000; feg[6] = 5.2338000000;
					g[7] = 0.3500000000; fxg[7] = 28.8858000000; feg[7] = 4.7783000000;
					g[8] = 0.4000000000; fxg[8] = 27.7386000000; feg[8] = 4.3448000000;
					g[9] = 0.4500000000; fxg[9] = 26.6590000000; feg[9] = 3.9433000000;
					g[10] = 0.5000000000; fxg[10] = 25.6544000000; feg[10] = 3.5788000000;
					g[11] = 0.5500000000; fxg[11] = 24.7233000000; feg[11] = 3.2524000000;
					g[12] = 0.6000000000; fxg[12] = 23.8587000000; feg[12] = 2.9628000000;
					g[13] = 0.6500000000; fxg[13] = 23.0512000000; feg[13] = 2.7075000000;
					g[14] = 0.7000000000; fxg[14] = 22.2911000000; feg[14] = 2.4830000000;
					g[15] = 0.7500000000; fxg[15] = 21.5691000000; feg[15] = 2.2859000000;
					g[16] = 0.8000000000; fxg[16] = 20.8773000000; feg[16] = 2.1126000000;
					g[17] = 0.8500000000; fxg[17] = 20.2093000000; feg[17] = 1.9598000000;
					g[18] = 0.9000000000; fxg[18] = 19.5605000000; feg[18] = 1.8248000000;
					g[19] = 0.9500000000; fxg[19] = 18.9275000000; feg[19] = 1.7049000000;
					g[20] = 1.0000000000; fxg[20] = 18.3082000000; feg[20] = 1.5980000000;
					g[21] = 1.0500000000; fxg[21] = 17.7016000000; feg[21] = 1.5021000000;
					g[22] = 1.1000000000; fxg[22] = 17.1073000000; feg[22] = 1.4157000000;
					g[23] = 1.1500000000; fxg[23] = 16.5257000000; feg[23] = 1.3373000000;
					g[24] = 1.2000000000; fxg[24] = 15.9574000000; feg[24] = 1.2660000000;
					g[25] = 1.2500000000; fxg[25] = 15.4033000000; feg[25] = 1.2007000000;
					g[26] = 1.3000000000; fxg[26] = 14.8644000000; feg[26] = 1.1406000000;
					g[27] = 1.3500000000; fxg[27] = 14.3417000000; feg[27] = 1.0852000000;
					g[28] = 1.4000000000; fxg[28] = 13.8361000000; feg[28] = 1.0337000000;
					g[29] = 1.4500000000; fxg[29] = 13.3485000000; feg[29] = 0.9859000000;
					g[30] = 1.5000000000; fxg[30] = 12.8797000000; feg[30] = 0.9412000000;
					g[31] = 1.5500000000; fxg[31] = 12.4301000000; feg[31] = 0.8994000000;
					g[32] = 1.6000000000; fxg[32] = 12.0001000000; feg[32] = 0.8601000000;
					g[33] = 1.6500000000; fxg[33] = 11.5900000000; feg[33] = 0.8232000000;
					g[34] = 1.7000000000; fxg[34] = 11.1998000000; feg[34] = 0.7884000000;
					g[35] = 1.7500000000; fxg[35] = 10.8293000000; feg[35] = 0.7556000000;
					g[36] = 1.8000000000; fxg[36] = 10.4784000000; feg[36] = 0.7246000000;
					g[37] = 1.8500000000; fxg[37] = 10.1466000000; feg[37] = 0.6952000000;
					g[38] = 1.9000000000; fxg[38] = 9.8336000000; feg[38] = 0.6674000000;
					g[39] = 1.9500000000; fxg[39] = 9.5386000000; feg[39] = 0.6410000000;
					g[40] = 2.0000000000; fxg[40] = 9.2612000000; feg[40] = 0.6160000000;
					g[41] = 2.0500000000; fxg[41] = 9.0005000000; feg[41] = 0.5923000000;
					g[42] = 2.1000000000; fxg[42] = 8.7559000000; feg[42] = 0.5697000000;
					g[43] = 2.1500000000; fxg[43] = 8.5265000000; feg[43] = 0.5483000000;
					g[44] = 2.2000000000; fxg[44] = 8.3116000000; feg[44] = 0.5279000000;
					g[45] = 2.2500000000; fxg[45] = 8.1103000000; feg[45] = 0.5085000000;
					g[46] = 2.3000000000; fxg[46] = 7.9218000000; feg[46] = 0.4900000000;
					g[47] = 2.3500000000; fxg[47] = 7.7454000000; feg[47] = 0.4725000000;
					g[48] = 2.4000000000; fxg[48] = 7.5801000000; feg[48] = 0.4557000000;
					g[49] = 2.4500000000; fxg[49] = 7.4253000000; feg[49] = 0.4398000000;
					g[50] = 2.5000000000; fxg[50] = 7.2802000000; feg[50] = 0.4246000000;
					g[51] = 2.5500000000; fxg[51] = 7.1440000000; feg[51] = 0.4101000000;
					g[52] = 2.6000000000; fxg[52] = 7.0161000000; feg[52] = 0.3963000000;
					g[53] = 2.6500000000; fxg[53] = 6.8957000000; feg[53] = 0.3831000000;
					g[54] = 2.7000000000; fxg[54] = 6.7823000000; feg[54] = 0.3706000000;
					g[55] = 2.7500000000; fxg[55] = 6.6752000000; feg[55] = 0.3586000000;
					g[56] = 2.8000000000; fxg[56] = 6.5739000000; feg[56] = 0.3471000000;
					g[57] = 2.8500000000; fxg[57] = 6.4777000000; feg[57] = 0.3362000000;
					g[58] = 2.9000000000; fxg[58] = 6.3863000000; feg[58] = 0.3257000000;
					g[59] = 2.9500000000; fxg[59] = 6.2993000000; feg[59] = 0.3157000000;
					g[60] = 3.0000000000; fxg[60] = 6.2161000000; feg[60] = 0.3062000000;
					g[61] = 3.0500000000; fxg[61] = 6.1362000000; feg[61] = 0.2970000000;
					g[62] = 3.1000000000; fxg[62] = 6.0593000000; feg[62] = 0.2883000000;
					g[63] = 3.1500000000; fxg[63] = 5.9851000000; feg[63] = 0.2799000000;
					g[64] = 3.2000000000; fxg[64] = 5.9134000000; feg[64] = 0.2719000000;
					g[65] = 3.2500000000; fxg[65] = 5.8440000000; feg[65] = 0.2643000000;
					g[66] = 3.3000000000; fxg[66] = 5.7765000000; feg[66] = 0.2569000000;
					g[67] = 3.3500000000; fxg[67] = 5.7106000000; feg[67] = 0.2499000000;
					g[68] = 3.4000000000; fxg[68] = 5.6459000000; feg[68] = 0.2431000000;
					g[69] = 3.4500000000; fxg[69] = 5.5823000000; feg[69] = 0.2366000000;
					g[70] = 3.5000000000; fxg[70] = 5.5199000000; feg[70] = 0.2304000000;
					g[71] = 3.5500000000; fxg[71] = 5.4586000000; feg[71] = 0.2244000000;
					g[72] = 3.6000000000; fxg[72] = 5.3983000000; feg[72] = 0.2187000000;
					g[73] = 3.6500000000; fxg[73] = 5.3388000000; feg[73] = 0.2131000000;
					g[74] = 3.7000000000; fxg[74] = 5.2798000000; feg[74] = 0.2078000000;
					g[75] = 3.7500000000; fxg[75] = 5.2209000000; feg[75] = 0.2027000000;
					g[76] = 3.8000000000; fxg[76] = 5.1621000000; feg[76] = 0.1978000000;
					g[77] = 3.8500000000; fxg[77] = 5.1038000000; feg[77] = 0.1931000000;
					g[78] = 3.9000000000; fxg[78] = 5.0460000000; feg[78] = 0.1885000000;
					g[79] = 3.9500000000; fxg[79] = 4.9889000000; feg[79] = 0.1841000000;
					g[80] = 4.0000000000; fxg[80] = 4.9324000000; feg[80] = 0.1799000000;
					g[81] = 4.0500000000; fxg[81] = 4.8760000000; feg[81] = 0.1758000000;
					g[82] = 4.1000000000; fxg[82] = 4.8195000000; feg[82] = 0.1719000000;
					g[83] = 4.1500000000; fxg[83] = 4.7627000000; feg[83] = 0.1681000000;
					g[84] = 4.2000000000; fxg[84] = 4.7057000000; feg[84] = 0.1644000000;
					g[85] = 4.2500000000; fxg[85] = 4.6488000000; feg[85] = 0.1609000000;
					g[86] = 4.3000000000; fxg[86] = 4.5925000000; feg[86] = 0.1574000000;
					g[87] = 4.3500000000; fxg[87] = 4.5369000000; feg[87] = 0.1541000000;
					g[88] = 4.4000000000; fxg[88] = 4.4820000000; feg[88] = 0.1509000000;
					g[89] = 4.4500000000; fxg[89] = 4.4276000000; feg[89] = 0.1478000000;
					g[90] = 4.5000000000; fxg[90] = 4.3731000000; feg[90] = 0.1448000000;
					g[91] = 4.5500000000; fxg[91] = 4.3182000000; feg[91] = 0.1419000000;
					g[92] = 4.6000000000; fxg[92] = 4.2629000000; feg[92] = 0.1391000000;
					g[93] = 4.6500000000; fxg[93] = 4.2074000000; feg[93] = 0.1363000000;
					g[94] = 4.7000000000; fxg[94] = 4.1522000000; feg[94] = 0.1337000000;
					g[95] = 4.7500000000; fxg[95] = 4.0977000000; feg[95] = 0.1311000000;
					g[96] = 4.8000000000; fxg[96] = 4.0443000000; feg[96] = 0.1286000000;
					g[97] = 4.8500000000; fxg[97] = 3.9921000000; feg[97] = 0.1262000000;
					g[98] = 4.9000000000; fxg[98] = 3.9407000000; feg[98] = 0.1238000000;
					g[99] = 4.9500000000; fxg[99] = 3.8897000000; feg[99] = 0.1216000000;
					g[100] = 5.0000000000; fxg[100] = 3.8384000000; feg[100] = 0.1193000000;
					g[101] = 5.0500000000; fxg[101] = 3.7866000000; feg[101] = 0.1172000000;
					g[102] = 5.1000000000; fxg[102] = 3.7344000000; feg[102] = 0.1151000000;
					g[103] = 5.1500000000; fxg[103] = 3.6822000000; feg[103] = 0.1130000000;
					g[104] = 5.2000000000; fxg[104] = 3.6305000000; feg[104] = 0.1111000000;
					g[105] = 5.2500000000; fxg[105] = 3.5799000000; feg[105] = 0.1091000000;
					g[106] = 5.3000000000; fxg[106] = 3.5309000000; feg[106] = 0.1073000000;
					g[107] = 5.3500000000; fxg[107] = 3.4834000000; feg[107] = 0.1054000000;
					g[108] = 5.4000000000; fxg[108] = 3.4373000000; feg[108] = 0.1036000000;
					g[109] = 5.4500000000; fxg[109] = 3.3918000000; feg[109] = 0.1019000000;
					g[110] = 5.5000000000; fxg[110] = 3.3463000000; feg[110] = 0.1002000000;
					g[111] = 5.5500000000; fxg[111] = 3.3005000000; feg[111] = 0.0985000000;
					g[112] = 5.6000000000; fxg[112] = 3.2541000000; feg[112] = 0.0969000000;
					g[113] = 5.6500000000; fxg[113] = 3.2073000000; feg[113] = 0.0953000000;
					g[114] = 5.7000000000; fxg[114] = 3.1608000000; feg[114] = 0.0938000000;
					g[115] = 5.7500000000; fxg[115] = 3.1149000000; feg[115] = 0.0923000000;
					g[116] = 5.8000000000; fxg[116] = 3.0705000000; feg[116] = 0.0909000000;
					g[117] = 5.8500000000; fxg[117] = 3.0278000000; feg[117] = 0.0894000000;
					g[118] = 5.9000000000; fxg[118] = 2.9870000000; feg[118] = 0.0880000000;
					g[119] = 5.9500000000; fxg[119] = 2.9479000000; feg[119] = 0.0867000000;
					g[120] = 6.0000000000; fxg[120] = 2.9100000000; feg[120] = 0.0853000000;
					g[121] = 6.0500000000; fxg[121] = 2.8724000000; feg[121] = 0.0840000000;
					g[122] = 6.1000000000; fxg[122] = 2.8346000000; feg[122] = 0.0828000000;
					g[123] = 6.1500000000; fxg[123] = 2.7961000000; feg[123] = 0.0815000000;
					g[124] = 6.2000000000; fxg[124] = 2.7569000000; feg[124] = 0.0803000000;
					g[125] = 6.2500000000; fxg[125] = 2.7175000000; feg[125] = 0.0791000000;
					g[126] = 6.3000000000; fxg[126] = 2.6783000000; feg[126] = 0.0780000000;
					g[127] = 6.3500000000; fxg[127] = 2.6398000000; feg[127] = 0.0768000000;
					g[128] = 6.4000000000; fxg[128] = 2.6027000000; feg[128] = 0.0757000000;
					g[129] = 6.4500000000; fxg[129] = 2.5673000000; feg[129] = 0.0746000000;
					g[130] = 6.5000000000; fxg[130] = 2.5341000000; feg[130] = 0.0736000000;
					g[131] = 6.5500000000; fxg[131] = 2.5029000000; feg[131] = 0.0725000000;
					g[132] = 6.6000000000; fxg[132] = 2.4733000000; feg[132] = 0.0715000000;
					g[133] = 6.6500000000; fxg[133] = 2.4445000000; feg[133] = 0.0705000000;
					g[134] = 6.7000000000; fxg[134] = 2.4158000000; feg[134] = 0.0695000000;
					g[135] = 6.7500000000; fxg[135] = 2.3864000000; feg[135] = 0.0685000000;
					g[136] = 6.8000000000; fxg[136] = 2.3561000000; feg[136] = 0.0676000000;
					g[137] = 6.8500000000; fxg[137] = 2.3252000000; feg[137] = 0.0667000000;
					g[138] = 6.9000000000; fxg[138] = 2.2939000000; feg[138] = 0.0658000000;
					g[139] = 6.9500000000; fxg[139] = 2.2626000000; feg[139] = 0.0649000000;
					g[140] = 7.0000000000; fxg[140] = 2.2318000000; feg[140] = 0.0640000000;
					g[141] = 7.0500000000; fxg[141] = 2.2021000000; feg[141] = 0.0632000000;
					g[142] = 7.1000000000; fxg[142] = 2.1738000000; feg[142] = 0.0623000000;
					g[143] = 7.1500000000; fxg[143] = 2.1474000000; feg[143] = 0.0615000000;
					g[144] = 7.2000000000; fxg[144] = 2.1232000000; feg[144] = 0.0607000000;
					g[145] = 7.2500000000; fxg[145] = 2.1011000000; feg[145] = 0.0599000000;
					g[146] = 7.3000000000; fxg[146] = 2.0806000000; feg[146] = 0.0591000000;
					g[147] = 7.3500000000; fxg[147] = 2.0606000000; feg[147] = 0.0584000000;
					g[148] = 7.4000000000; fxg[148] = 2.0405000000; feg[148] = 0.0576000000;
					g[149] = 7.4500000000; fxg[149] = 2.0195000000; feg[149] = 0.0569000000;
					g[150] = 7.5000000000; fxg[150] = 1.9975000000; feg[150] = 0.0562000000;
					g[151] = 7.5500000000; fxg[151] = 1.9745000000; feg[151] = 0.0555000000;
					g[152] = 7.6000000000; fxg[152] = 1.9510000000; feg[152] = 0.0548000000;
					g[153] = 7.6500000000; fxg[153] = 1.9273000000; feg[153] = 0.0541000000;
					g[154] = 7.7000000000; fxg[154] = 1.9038000000; feg[154] = 0.0534000000;
					g[155] = 7.7500000000; fxg[155] = 1.8808000000; feg[155] = 0.0528000000;
					g[156] = 7.8000000000; fxg[156] = 1.8586000000; feg[156] = 0.0521000000;
					g[157] = 7.8500000000; fxg[157] = 1.8377000000; feg[157] = 0.0515000000;
					g[158] = 7.9000000000; fxg[158] = 1.8185000000; feg[158] = 0.0509000000;
					g[159] = 7.9500000000; fxg[159] = 1.8014000000; feg[159] = 0.0503000000;
					g[160] = 8.0000000000; fxg[160] = 1.7865000000; feg[160] = 0.0497000000;
					g[161] = 8.0500000000; fxg[161] = 1.7732000000; feg[161] = 0.0491000000;
					g[162] = 8.1000000000; fxg[162] = 1.7609000000; feg[162] = 0.0485000000;
					g[163] = 8.1500000000; fxg[163] = 1.7485000000; feg[163] = 0.0479000000;
					g[164] = 8.2000000000; fxg[164] = 1.7352000000; feg[164] = 0.0474000000;
					g[165] = 8.2500000000; fxg[165] = 1.7207000000; feg[165] = 0.0468000000;
					g[166] = 8.3000000000; fxg[166] = 1.7050000000; feg[166] = 0.0463000000;
					g[167] = 8.3500000000; fxg[167] = 1.6883000000; feg[167] = 0.0457000000;
					g[168] = 8.4000000000; fxg[168] = 1.6713000000; feg[168] = 0.0452000000;
					g[169] = 8.4500000000; fxg[169] = 1.6541000000; feg[169] = 0.0447000000;
					g[170] = 8.5000000000; fxg[170] = 1.6371000000; feg[170] = 0.0442000000;
					g[171] = 8.5500000000; fxg[171] = 1.6203000000; feg[171] = 0.0437000000;
					g[172] = 8.6000000000; fxg[172] = 1.6039000000; feg[172] = 0.0432000000;
					g[173] = 8.6500000000; fxg[173] = 1.5882000000; feg[173] = 0.0428000000;
					g[174] = 8.7000000000; fxg[174] = 1.5736000000; feg[174] = 0.0423000000;
					g[175] = 8.7500000000; fxg[175] = 1.5607000000; feg[175] = 0.0418000000;
					g[176] = 8.8000000000; fxg[176] = 1.5499000000; feg[176] = 0.0414000000;
					g[177] = 8.8500000000; fxg[177] = 1.5412000000; feg[177] = 0.0409000000;
					g[178] = 8.9000000000; fxg[178] = 1.5340000000; feg[178] = 0.0404000000;
					g[179] = 8.9500000000; fxg[179] = 1.5277000000; feg[179] = 0.0400000000;
					g[180] = 9.0000000000; fxg[180] = 1.5211000000; feg[180] = 0.0396000000;
					g[181] = 9.0500000000; fxg[181] = 1.5135000000; feg[181] = 0.0391000000;
					g[182] = 9.1000000000; fxg[182] = 1.5044000000; feg[182] = 0.0387000000;
					g[183] = 9.1500000000; fxg[183] = 1.4938000000; feg[183] = 0.0383000000;
					g[184] = 9.2000000000; fxg[184] = 1.4822000000; feg[184] = 0.0379000000;
					g[185] = 9.2500000000; fxg[185] = 1.4701000000; feg[185] = 0.0375000000;
					g[186] = 9.3000000000; fxg[186] = 1.4579000000; feg[186] = 0.0371000000;
					g[187] = 9.3500000000; fxg[187] = 1.4458000000; feg[187] = 0.0367000000;
					g[188] = 9.4000000000; fxg[188] = 1.4339000000; feg[188] = 0.0364000000;
					g[189] = 9.4500000000; fxg[189] = 1.4220000000; feg[189] = 0.0360000000;
					g[190] = 9.5000000000; fxg[190] = 1.4101000000; feg[190] = 0.0356000000;
					g[191] = 9.5500000000; fxg[191] = 1.3985000000; feg[191] = 0.0353000000;
					g[192] = 9.6000000000; fxg[192] = 1.3874000000; feg[192] = 0.0349000000;
					g[193] = 9.6500000000; fxg[193] = 1.3776000000; feg[193] = 0.0346000000;
					g[194] = 9.7000000000; fxg[194] = 1.3696000000; feg[194] = 0.0342000000;
					g[195] = 9.7500000000; fxg[195] = 1.3637000000; feg[195] = 0.0339000000;
					g[196] = 9.8000000000; fxg[196] = 1.3596000000; feg[196] = 0.0335000000;
					g[197] = 9.8500000000; fxg[197] = 1.3570000000; feg[197] = 0.0332000000;
					g[198] = 9.9000000000; fxg[198] = 1.3548000000; feg[198] = 0.0329000000;
					g[199] = 9.9500000000; fxg[199] = 1.3520000000; feg[199] = 0.0325000000;
					g[200] = 10.0000000000; fxg[200] = 1.3479000000; feg[200] = 0.0322000000;
					g[201] = 10.0500000000; fxg[201] = 1.3421000000; feg[201] = 0.0319000000;
					g[202] = 10.1000000000; fxg[202] = 1.3347000000; feg[202] = 0.0316000000;
					g[203] = 10.1500000000; fxg[203] = 1.3261000000; feg[203] = 0.0313000000;
					g[204] = 10.2000000000; fxg[204] = 1.3170000000; feg[204] = 0.0310000000;
					g[205] = 10.2500000000; fxg[205] = 1.3080000000; feg[205] = 0.0307000000;
					g[206] = 10.3000000000; fxg[206] = 1.2994000000; feg[206] = 0.0304000000;
					g[207] = 10.3500000000; fxg[207] = 1.2911000000; feg[207] = 0.0301000000;
					g[208] = 10.4000000000; fxg[208] = 1.2829000000; feg[208] = 0.0298000000;
					g[209] = 10.4500000000; fxg[209] = 1.2745000000; feg[209] = 0.0296000000;
					g[210] = 10.5000000000; fxg[210] = 1.2658000000; feg[210] = 0.0293000000;
					g[211] = 10.5500000000; fxg[211] = 1.2568000000; feg[211] = 0.0290000000;
					g[212] = 10.6000000000; fxg[212] = 1.2480000000; feg[212] = 0.0288000000;
					g[213] = 10.6500000000; fxg[213] = 1.2400000000; feg[213] = 0.0285000000;
					g[214] = 10.7000000000; fxg[214] = 1.2333000000; feg[214] = 0.0282000000;
					g[215] = 10.7500000000; fxg[215] = 1.2286000000; feg[215] = 0.0280000000;
					g[216] = 10.8000000000; fxg[216] = 1.2259000000; feg[216] = 0.0277000000;
					g[217] = 10.8500000000; fxg[217] = 1.2249000000; feg[217] = 0.0275000000;
					g[218] = 10.9000000000; fxg[218] = 1.2250000000; feg[218] = 0.0272000000;
					g[219] = 10.9500000000; fxg[219] = 1.2252000000; feg[219] = 0.0270000000;
					g[220] = 11.0000000000; fxg[220] = 1.2246000000; feg[220] = 0.0267000000;
					g[221] = 11.0500000000; fxg[221] = 1.2225000000; feg[221] = 0.0265000000;
					g[222] = 11.1000000000; fxg[222] = 1.2184000000; feg[222] = 0.0262000000;
					g[223] = 11.1500000000; fxg[223] = 1.2126000000; feg[223] = 0.0260000000;
					g[224] = 11.2000000000; fxg[224] = 1.2056000000; feg[224] = 0.0258000000;
					g[225] = 11.2500000000; fxg[225] = 1.1980000000; feg[225] = 0.0256000000;
					g[226] = 11.3000000000; fxg[226] = 1.1907000000; feg[226] = 0.0253000000;
					g[227] = 11.3500000000; fxg[227] = 1.1839000000; feg[227] = 0.0251000000;
					g[228] = 11.4000000000; fxg[228] = 1.1779000000; feg[228] = 0.0249000000;
					g[229] = 11.4500000000; fxg[229] = 1.1723000000; feg[229] = 0.0247000000;
					g[230] = 11.5000000000; fxg[230] = 1.1667000000; feg[230] = 0.0245000000;
					g[231] = 11.5500000000; fxg[231] = 1.1607000000; feg[231] = 0.0243000000;
					g[232] = 11.6000000000; fxg[232] = 1.1539000000; feg[232] = 0.0241000000;
					g[233] = 11.6500000000; fxg[233] = 1.1466000000; feg[233] = 0.0239000000;
					g[234] = 11.7000000000; fxg[234] = 1.1390000000; feg[234] = 0.0237000000;
					g[235] = 11.7500000000; fxg[235] = 1.1317000000; feg[235] = 0.0235000000;
					g[236] = 11.8000000000; fxg[236] = 1.1252000000; feg[236] = 0.0233000000;
					g[237] = 11.8500000000; fxg[237] = 1.1203000000; feg[237] = 0.0231000000;
					g[238] = 11.9000000000; fxg[238] = 1.1172000000; feg[238] = 0.0229000000;
					g[239] = 11.9500000000; fxg[239] = 1.1162000000; feg[239] = 0.0227000000;
					g[240] = 12.0000000000; fxg[240] = 1.1168000000; feg[240] = 0.0225000000;
					break;
				case 36:
					g[0] = 0.0000000000; fxg[0] = 36.0000000000; feg[0] = 6.8978000000;
					g[1] = 0.0500000000; fxg[1] = 35.8214000000; feg[1] = 6.8393000000;
					g[2] = 0.1000000000; fxg[2] = 35.3033000000; feg[2] = 6.6694000000;
					g[3] = 0.1500000000; fxg[3] = 34.4950000000; feg[3] = 6.4035000000;
					g[4] = 0.2000000000; fxg[4] = 33.4665000000; feg[4] = 6.0637000000;
					g[5] = 0.2500000000; fxg[5] = 32.2953000000; feg[5] = 5.6747000000;
					g[6] = 0.3000000000; fxg[6] = 31.0546000000; feg[6] = 5.2605000000;
					g[7] = 0.3500000000; fxg[7] = 29.8048000000; feg[7] = 4.8416000000;
					g[8] = 0.4000000000; fxg[8] = 28.5900000000; feg[8] = 4.4337000000;
					g[9] = 0.4500000000; fxg[9] = 27.4382000000; feg[9] = 4.0477000000;
					g[10] = 0.5000000000; fxg[10] = 26.3635000000; feg[10] = 3.6902000000;
					g[11] = 0.5500000000; fxg[11] = 25.3696000000; feg[11] = 3.3643000000;
					g[12] = 0.6000000000; fxg[12] = 24.4531000000; feg[12] = 3.0707000000;
					g[13] = 0.6500000000; fxg[13] = 23.6063000000; feg[13] = 2.8083000000;
					g[14] = 0.7000000000; fxg[14] = 22.8197000000; feg[14] = 2.5751000000;
					g[15] = 0.7500000000; fxg[15] = 22.0833000000; feg[15] = 2.3686000000;
					g[16] = 0.8000000000; fxg[16] = 21.3877000000; feg[16] = 2.1858000000;
					g[17] = 0.8500000000; fxg[17] = 20.7247000000; feg[17] = 2.0241000000;
					g[18] = 0.9000000000; fxg[18] = 20.0874000000; feg[18] = 1.8807000000;
					g[19] = 0.9500000000; fxg[19] = 19.4706000000; feg[19] = 1.7534000000;
					g[20] = 1.0000000000; fxg[20] = 18.8703000000; feg[20] = 1.6399000000;
					g[21] = 1.0500000000; fxg[21] = 18.2838000000; feg[21] = 1.5384000000;
					g[22] = 1.1000000000; fxg[22] = 17.7093000000; feg[22] = 1.4472000000;
					g[23] = 1.1500000000; fxg[23] = 17.1460000000; feg[23] = 1.3648000000;
					g[24] = 1.2000000000; fxg[24] = 16.5938000000; feg[24] = 1.2902000000;
					g[25] = 1.2500000000; fxg[25] = 16.0528000000; feg[25] = 1.2222000000;
					g[26] = 1.3000000000; fxg[26] = 15.5236000000; feg[26] = 1.1599000000;
					g[27] = 1.3500000000; fxg[27] = 15.0071000000; feg[27] = 1.1027000000;
					g[28] = 1.4000000000; fxg[28] = 14.5040000000; feg[28] = 1.0500000000;
					g[29] = 1.4500000000; fxg[29] = 14.0154000000; feg[29] = 1.0010000000;
					g[30] = 1.5000000000; fxg[30] = 13.5420000000; feg[30] = 0.9556000000;
					g[31] = 1.5500000000; fxg[31] = 13.0846000000; feg[31] = 0.9131000000;
					g[32] = 1.6000000000; fxg[32] = 12.6438000000; feg[32] = 0.8734000000;
					g[33] = 1.6500000000; fxg[33] = 12.2202000000; feg[33] = 0.8362000000;
					g[34] = 1.7000000000; fxg[34] = 11.8142000000; feg[34] = 0.8012000000;
					g[35] = 1.7500000000; fxg[35] = 11.4260000000; feg[35] = 0.7682000000;
					g[36] = 1.8000000000; fxg[36] = 11.0557000000; feg[36] = 0.7370000000;
					g[37] = 1.8500000000; fxg[37] = 10.7033000000; feg[37] = 0.7076000000;
					g[38] = 1.9000000000; fxg[38] = 10.3685000000; feg[38] = 0.6797000000;
					g[39] = 1.9500000000; fxg[39] = 10.0512000000; feg[39] = 0.6533000000;
					g[40] = 2.0000000000; fxg[40] = 9.7510000000; feg[40] = 0.6282000000;
					g[41] = 2.0500000000; fxg[41] = 9.4673000000; feg[41] = 0.6044000000;
					g[42] = 2.1000000000; fxg[42] = 9.1998000000; feg[42] = 0.5818000000;
					g[43] = 2.1500000000; fxg[43] = 8.9477000000; feg[43] = 0.5603000000;
					g[44] = 2.2000000000; fxg[44] = 8.7105000000; feg[44] = 0.5398000000;
					g[45] = 2.2500000000; fxg[45] = 8.4876000000; feg[45] = 0.5203000000;
					g[46] = 2.3000000000; fxg[46] = 8.2781000000; feg[46] = 0.5017000000;
					g[47] = 2.3500000000; fxg[47] = 8.0815000000; feg[47] = 0.4840000000;
					g[48] = 2.4000000000; fxg[48] = 7.8969000000; feg[48] = 0.4671000000;
					g[49] = 2.4500000000; fxg[49] = 7.7238000000; feg[49] = 0.4510000000;
					g[50] = 2.5000000000; fxg[50] = 7.5613000000; feg[50] = 0.4356000000;
					g[51] = 2.5500000000; fxg[51] = 7.4088000000; feg[51] = 0.4209000000;
					g[52] = 2.6000000000; fxg[52] = 7.2656000000; feg[52] = 0.4069000000;
					g[53] = 2.6500000000; fxg[53] = 7.1310000000; feg[53] = 0.3936000000;
					g[54] = 2.7000000000; fxg[54] = 7.0044000000; feg[54] = 0.3808000000;
					g[55] = 2.7500000000; fxg[55] = 6.8852000000; feg[55] = 0.3686000000;
					g[56] = 2.8000000000; fxg[56] = 6.7727000000; feg[56] = 0.3569000000;
					g[57] = 2.8500000000; fxg[57] = 6.6665000000; feg[57] = 0.3457000000;
					g[58] = 2.9000000000; fxg[58] = 6.5660000000; feg[58] = 0.3351000000;
					g[59] = 2.9500000000; fxg[59] = 6.4707000000; feg[59] = 0.3248000000;
					g[60] = 3.0000000000; fxg[60] = 6.3802000000; feg[60] = 0.3151000000;
					g[61] = 3.0500000000; fxg[61] = 6.2938000000; feg[61] = 0.3057000000;
					g[62] = 3.1000000000; fxg[62] = 6.2113000000; feg[62] = 0.2968000000;
					g[63] = 3.1500000000; fxg[63] = 6.1323000000; feg[63] = 0.2882000000;
					g[64] = 3.2000000000; fxg[64] = 6.0565000000; feg[64] = 0.2799000000;
					g[65] = 3.2500000000; fxg[65] = 5.9836000000; feg[65] = 0.2721000000;
					g[66] = 3.3000000000; fxg[66] = 5.9132000000; feg[66] = 0.2645000000;
					g[67] = 3.3500000000; fxg[67] = 5.8449000000; feg[67] = 0.2572000000;
					g[68] = 3.4000000000; fxg[68] = 5.7785000000; feg[68] = 0.2503000000;
					g[69] = 3.4500000000; fxg[69] = 5.7138000000; feg[69] = 0.2436000000;
					g[70] = 3.5000000000; fxg[70] = 5.6507000000; feg[70] = 0.2372000000;
					g[71] = 3.5500000000; fxg[71] = 5.5890000000; feg[71] = 0.2310000000;
					g[72] = 3.6000000000; fxg[72] = 5.5287000000; feg[72] = 0.2251000000;
					g[73] = 3.6500000000; fxg[73] = 5.4693000000; feg[73] = 0.2194000000;
					g[74] = 3.7000000000; fxg[74] = 5.4108000000; feg[74] = 0.2139000000;
					g[75] = 3.7500000000; fxg[75] = 5.3528000000; feg[75] = 0.2086000000;
					g[76] = 3.8000000000; fxg[76] = 5.2953000000; feg[76] = 0.2036000000;
					g[77] = 3.8500000000; fxg[77] = 5.2384000000; feg[77] = 0.1987000000;
					g[78] = 3.9000000000; fxg[78] = 5.1822000000; feg[78] = 0.1940000000;
					g[79] = 3.9500000000; fxg[79] = 5.1266000000; feg[79] = 0.1894000000;
					g[80] = 4.0000000000; fxg[80] = 5.0716000000; feg[80] = 0.1851000000;
					g[81] = 4.0500000000; fxg[81] = 5.0168000000; feg[81] = 0.1808000000;
					g[82] = 4.1000000000; fxg[82] = 4.9621000000; feg[82] = 0.1768000000;
					g[83] = 4.1500000000; fxg[83] = 4.9072000000; feg[83] = 0.1728000000;
					g[84] = 4.2000000000; fxg[84] = 4.8523000000; feg[84] = 0.1690000000;
					g[85] = 4.2500000000; fxg[85] = 4.7976000000; feg[85] = 0.1654000000;
					g[86] = 4.3000000000; fxg[86] = 4.7433000000; feg[86] = 0.1618000000;
					g[87] = 4.3500000000; fxg[87] = 4.6896000000; feg[87] = 0.1584000000;
					g[88] = 4.4000000000; fxg[88] = 4.6365000000; feg[88] = 0.1551000000;
					g[89] = 4.4500000000; fxg[89] = 4.5835000000; feg[89] = 0.1519000000;
					g[90] = 4.5000000000; fxg[90] = 4.5306000000; feg[90] = 0.1488000000;
					g[91] = 4.5500000000; fxg[91] = 4.4774000000; feg[91] = 0.1458000000;
					g[92] = 4.6000000000; fxg[92] = 4.4238000000; feg[92] = 0.1429000000;
					g[93] = 4.6500000000; fxg[93] = 4.3701000000; feg[93] = 0.1400000000;
					g[94] = 4.7000000000; fxg[94] = 4.3166000000; feg[94] = 0.1373000000;
					g[95] = 4.7500000000; fxg[95] = 4.2637000000; feg[95] = 0.1347000000;
					g[96] = 4.8000000000; fxg[96] = 4.2116000000; feg[96] = 0.1321000000;
					g[97] = 4.8500000000; fxg[97] = 4.1604000000; feg[97] = 0.1296000000;
					g[98] = 4.9000000000; fxg[98] = 4.1097000000; feg[98] = 0.1272000000;
					g[99] = 4.9500000000; fxg[99] = 4.0592000000; feg[99] = 0.1248000000;
					g[100] = 5.0000000000; fxg[100] = 4.0086000000; feg[100] = 0.1225000000;
					g[101] = 5.0500000000; fxg[101] = 3.9575000000; feg[101] = 0.1203000000;
					g[102] = 5.1000000000; fxg[102] = 3.9061000000; feg[102] = 0.1181000000;
					g[103] = 5.1500000000; fxg[103] = 3.8547000000; feg[103] = 0.1160000000;
					g[104] = 5.2000000000; fxg[104] = 3.8037000000; feg[104] = 0.1140000000;
					g[105] = 5.2500000000; fxg[105] = 3.7536000000; feg[105] = 0.1120000000;
					g[106] = 5.3000000000; fxg[106] = 3.7048000000; feg[106] = 0.1101000000;
					g[107] = 5.3500000000; fxg[107] = 3.6573000000; feg[107] = 0.1082000000;
					g[108] = 5.4000000000; fxg[108] = 3.6107000000; feg[108] = 0.1063000000;
					g[109] = 5.4500000000; fxg[109] = 3.5647000000; feg[109] = 0.1045000000;
					g[110] = 5.5000000000; fxg[110] = 3.5188000000; feg[110] = 0.1028000000;
					g[111] = 5.5500000000; fxg[111] = 3.4724000000; feg[111] = 0.1011000000;
					g[112] = 5.6000000000; fxg[112] = 3.4256000000; feg[112] = 0.0994000000;
					g[113] = 5.6500000000; fxg[113] = 3.3785000000; feg[113] = 0.0978000000;
					g[114] = 5.7000000000; fxg[114] = 3.3316000000; feg[114] = 0.0963000000;
					g[115] = 5.7500000000; fxg[115] = 3.2854000000; feg[115] = 0.0947000000;
					g[116] = 5.8000000000; fxg[116] = 3.2403000000; feg[116] = 0.0932000000;
					g[117] = 5.8500000000; fxg[117] = 3.1969000000; feg[117] = 0.0918000000;
					g[118] = 5.9000000000; fxg[118] = 3.1551000000; feg[118] = 0.0903000000;
					g[119] = 5.9500000000; fxg[119] = 3.1147000000; feg[119] = 0.0889000000;
					g[120] = 6.0000000000; fxg[120] = 3.0753000000; feg[120] = 0.0876000000;
					g[121] = 6.0500000000; fxg[121] = 3.0363000000; feg[121] = 0.0862000000;
					g[122] = 6.1000000000; fxg[122] = 2.9970000000; feg[122] = 0.0849000000;
					g[123] = 6.1500000000; fxg[123] = 2.9571000000; feg[123] = 0.0836000000;
					g[124] = 6.2000000000; fxg[124] = 2.9167000000; feg[124] = 0.0824000000;
					g[125] = 6.2500000000; fxg[125] = 2.8760000000; feg[125] = 0.0812000000;
					g[126] = 6.3000000000; fxg[126] = 2.8355000000; feg[126] = 0.0800000000;
					g[127] = 6.3500000000; fxg[127] = 2.7958000000; feg[127] = 0.0788000000;
					g[128] = 6.4000000000; fxg[128] = 2.7573000000; feg[128] = 0.0777000000;
					g[129] = 6.4500000000; fxg[129] = 2.7206000000; feg[129] = 0.0766000000;
					g[130] = 6.5000000000; fxg[130] = 2.6857000000; feg[130] = 0.0755000000;
					g[131] = 6.5500000000; fxg[131] = 2.6528000000; feg[131] = 0.0744000000;
					g[132] = 6.6000000000; fxg[132] = 2.6212000000; feg[132] = 0.0734000000;
					g[133] = 6.6500000000; fxg[133] = 2.5904000000; feg[133] = 0.0723000000;
					g[134] = 6.7000000000; fxg[134] = 2.5597000000; feg[134] = 0.0713000000;
					g[135] = 6.7500000000; fxg[135] = 2.5284000000; feg[135] = 0.0703000000;
					g[136] = 6.8000000000; fxg[136] = 2.4964000000; feg[136] = 0.0694000000;
					g[137] = 6.8500000000; fxg[137] = 2.4637000000; feg[137] = 0.0684000000;
					g[138] = 6.9000000000; fxg[138] = 2.4306000000; feg[138] = 0.0675000000;
					g[139] = 6.9500000000; fxg[139] = 2.3975000000; feg[139] = 0.0666000000;
					g[140] = 7.0000000000; fxg[140] = 2.3649000000; feg[140] = 0.0657000000;
					g[141] = 7.0500000000; fxg[141] = 2.3334000000; feg[141] = 0.0648000000;
					g[142] = 7.1000000000; fxg[142] = 2.3035000000; feg[142] = 0.0640000000;
					g[143] = 7.1500000000; fxg[143] = 2.2754000000; feg[143] = 0.0632000000;
					g[144] = 7.2000000000; fxg[144] = 2.2495000000; feg[144] = 0.0623000000;
					g[145] = 7.2500000000; fxg[145] = 2.2255000000; feg[145] = 0.0615000000;
					g[146] = 7.3000000000; fxg[146] = 2.2028000000; feg[146] = 0.0607000000;
					g[147] = 7.3500000000; fxg[147] = 2.1808000000; feg[147] = 0.0599000000;
					g[148] = 7.4000000000; fxg[148] = 2.1587000000; feg[148] = 0.0592000000;
					g[149] = 7.4500000000; fxg[149] = 2.1358000000; feg[149] = 0.0584000000;
					g[150] = 7.5000000000; fxg[150] = 2.1120000000; feg[150] = 0.0577000000;
					g[151] = 7.5500000000; fxg[151] = 2.0873000000; feg[151] = 0.0570000000;
					g[152] = 7.6000000000; fxg[152] = 2.0619000000; feg[152] = 0.0563000000;
					g[153] = 7.6500000000; fxg[153] = 2.0363000000; feg[153] = 0.0556000000;
					g[154] = 7.7000000000; fxg[154] = 2.0108000000; feg[154] = 0.0549000000;
					g[155] = 7.7500000000; fxg[155] = 1.9859000000; feg[155] = 0.0542000000;
					g[156] = 7.8000000000; fxg[156] = 1.9619000000; feg[156] = 0.0536000000;
					g[157] = 7.8500000000; fxg[157] = 1.9394000000; feg[157] = 0.0529000000;
					g[158] = 7.9000000000; fxg[158] = 1.9187000000; feg[158] = 0.0523000000;
					g[159] = 7.9500000000; fxg[159] = 1.9001000000; feg[159] = 0.0517000000;
					g[160] = 8.0000000000; fxg[160] = 1.8835000000; feg[160] = 0.0510000000;
					g[161] = 8.0500000000; fxg[161] = 1.8686000000; feg[161] = 0.0504000000;
					g[162] = 8.1000000000; fxg[162] = 1.8544000000; feg[162] = 0.0498000000;
					g[163] = 8.1500000000; fxg[163] = 1.8403000000; feg[163] = 0.0492000000;
					g[164] = 8.2000000000; fxg[164] = 1.8255000000; feg[164] = 0.0487000000;
					g[165] = 8.2500000000; fxg[165] = 1.8096000000; feg[165] = 0.0481000000;
					g[166] = 8.3000000000; fxg[166] = 1.7925000000; feg[166] = 0.0475000000;
					g[167] = 8.3500000000; fxg[167] = 1.7744000000; feg[167] = 0.0470000000;
					g[168] = 8.4000000000; fxg[168] = 1.7557000000; feg[168] = 0.0465000000;
					g[169] = 8.4500000000; fxg[169] = 1.7367000000; feg[169] = 0.0459000000;
					g[170] = 8.5000000000; fxg[170] = 1.7177000000; feg[170] = 0.0454000000;
					g[171] = 8.5500000000; fxg[171] = 1.6991000000; feg[171] = 0.0449000000;
					g[172] = 8.6000000000; fxg[172] = 1.6810000000; feg[172] = 0.0444000000;
					g[173] = 8.6500000000; fxg[173] = 1.6638000000; feg[173] = 0.0439000000;
					g[174] = 8.7000000000; fxg[174] = 1.6481000000; feg[174] = 0.0434000000;
					g[175] = 8.7500000000; fxg[175] = 1.6342000000; feg[175] = 0.0430000000;
					g[176] = 8.8000000000; fxg[176] = 1.6224000000; feg[176] = 0.0425000000;
					g[177] = 8.8500000000; fxg[177] = 1.6125000000; feg[177] = 0.0420000000;
					g[178] = 8.9000000000; fxg[178] = 1.6041000000; feg[178] = 0.0416000000;
					g[179] = 8.9500000000; fxg[179] = 1.5965000000; feg[179] = 0.0411000000;
					g[180] = 9.0000000000; fxg[180] = 1.5888000000; feg[180] = 0.0407000000;
					g[181] = 9.0500000000; fxg[181] = 1.5801000000; feg[181] = 0.0402000000;
					g[182] = 9.1000000000; fxg[182] = 1.5701000000; feg[182] = 0.0398000000;
					g[183] = 9.1500000000; fxg[183] = 1.5587000000; feg[183] = 0.0394000000;
					g[184] = 9.2000000000; fxg[184] = 1.5462000000; feg[184] = 0.0390000000;
					g[185] = 9.2500000000; fxg[185] = 1.5329000000; feg[185] = 0.0386000000;
					g[186] = 9.3000000000; fxg[186] = 1.5194000000; feg[186] = 0.0382000000;
					g[187] = 9.3500000000; fxg[187] = 1.5057000000; feg[187] = 0.0378000000;
					g[188] = 9.4000000000; fxg[188] = 1.4920000000; feg[188] = 0.0374000000;
					g[189] = 9.4500000000; fxg[189] = 1.4785000000; feg[189] = 0.0370000000;
					g[190] = 9.5000000000; fxg[190] = 1.4652000000; feg[190] = 0.0366000000;
					g[191] = 9.5500000000; fxg[191] = 1.4525000000; feg[191] = 0.0363000000;
					g[192] = 9.6000000000; fxg[192] = 1.4406000000; feg[192] = 0.0359000000;
					g[193] = 9.6500000000; fxg[193] = 1.4303000000; feg[193] = 0.0355000000;
					g[194] = 9.7000000000; fxg[194] = 1.4217000000; feg[194] = 0.0352000000;
					g[195] = 9.7500000000; fxg[195] = 1.4153000000; feg[195] = 0.0348000000;
					g[196] = 9.8000000000; fxg[196] = 1.4106000000; feg[196] = 0.0345000000;
					g[197] = 9.8500000000; fxg[197] = 1.4072000000; feg[197] = 0.0341000000;
					g[198] = 9.9000000000; fxg[198] = 1.4043000000; feg[198] = 0.0338000000;
					g[199] = 9.9500000000; fxg[199] = 1.4009000000; feg[199] = 0.0335000000;
					g[200] = 10.0000000000; fxg[200] = 1.3964000000; feg[200] = 0.0331000000;
					g[201] = 10.0500000000; fxg[201] = 1.3903000000; feg[201] = 0.0328000000;
					g[202] = 10.1000000000; fxg[202] = 1.3826000000; feg[202] = 0.0325000000;
					g[203] = 10.1500000000; fxg[203] = 1.3736000000; feg[203] = 0.0322000000;
					g[204] = 10.2000000000; fxg[204] = 1.3640000000; feg[204] = 0.0319000000;
					g[205] = 10.2500000000; fxg[205] = 1.3541000000; feg[205] = 0.0316000000;
					g[206] = 10.3000000000; fxg[206] = 1.3443000000; feg[206] = 0.0313000000;
					g[207] = 10.3500000000; fxg[207] = 1.3346000000; feg[207] = 0.0310000000;
					g[208] = 10.4000000000; fxg[208] = 1.3250000000; feg[208] = 0.0307000000;
					g[209] = 10.4500000000; fxg[209] = 1.3152000000; feg[209] = 0.0304000000;
					g[210] = 10.5000000000; fxg[210] = 1.3054000000; feg[210] = 0.0301000000;
					g[211] = 10.5500000000; fxg[211] = 1.2956000000; feg[211] = 0.0299000000;
					g[212] = 10.6000000000; fxg[212] = 1.2863000000; feg[212] = 0.0296000000;
					g[213] = 10.6500000000; fxg[213] = 1.2780000000; feg[213] = 0.0293000000;
					g[214] = 10.7000000000; fxg[214] = 1.2713000000; feg[214] = 0.0290000000;
					g[215] = 10.7500000000; fxg[215] = 1.2665000000; feg[215] = 0.0288000000;
					g[216] = 10.8000000000; fxg[216] = 1.2637000000; feg[216] = 0.0285000000;
					g[217] = 10.8500000000; fxg[217] = 1.2625000000; feg[217] = 0.0282000000;
					g[218] = 10.9000000000; fxg[218] = 1.2624000000; feg[218] = 0.0280000000;
					g[219] = 10.9500000000; fxg[219] = 1.2624000000; feg[219] = 0.0277000000;
					g[220] = 11.0000000000; fxg[220] = 1.2616000000; feg[220] = 0.0275000000;
					g[221] = 11.0500000000; fxg[221] = 1.2594000000; feg[221] = 0.0272000000;
					g[222] = 11.1000000000; fxg[222] = 1.2555000000; feg[222] = 0.0270000000;
					g[223] = 11.1500000000; fxg[223] = 1.2498000000; feg[223] = 0.0268000000;
					g[224] = 11.2000000000; fxg[224] = 1.2429000000; feg[224] = 0.0265000000;
					g[225] = 11.2500000000; fxg[225] = 1.2352000000; feg[225] = 0.0263000000;
					g[226] = 11.3000000000; fxg[226] = 1.2275000000; feg[226] = 0.0261000000;
					g[227] = 11.3500000000; fxg[227] = 1.2200000000; feg[227] = 0.0258000000;
					g[228] = 11.4000000000; fxg[228] = 1.2130000000; feg[228] = 0.0256000000;
					g[229] = 11.4500000000; fxg[229] = 1.2062000000; feg[229] = 0.0254000000;
					g[230] = 11.5000000000; fxg[230] = 1.1995000000; feg[230] = 0.0252000000;
					g[231] = 11.5500000000; fxg[231] = 1.1924000000; feg[231] = 0.0250000000;
					g[232] = 11.6000000000; fxg[232] = 1.1848000000; feg[232] = 0.0248000000;
					g[233] = 11.6500000000; fxg[233] = 1.1769000000; feg[233] = 0.0246000000;
					g[234] = 11.7000000000; fxg[234] = 1.1690000000; feg[234] = 0.0244000000;
					g[235] = 11.7500000000; fxg[235] = 1.1615000000; feg[235] = 0.0242000000;
					g[236] = 11.8000000000; fxg[236] = 1.1552000000; feg[236] = 0.0240000000;
					g[237] = 11.8500000000; fxg[237] = 1.1504000000; feg[237] = 0.0238000000;
					g[238] = 11.9000000000; fxg[238] = 1.1476000000; feg[238] = 0.0236000000;
					g[239] = 11.9500000000; fxg[239] = 1.1468000000; feg[239] = 0.0234000000;
					g[240] = 12.0000000000; fxg[240] = 1.1475000000; feg[240] = 0.0232000000;
					break;
				case 37:
					g[0] = 0.0000000000; fxg[0] = 37.0000000000; feg[0] = 11.7826000000;
					g[1] = 0.0500000000; fxg[1] = 36.7052000000; feg[1] = 11.2893000000;
					g[2] = 0.1000000000; fxg[2] = 35.9478000000; feg[2] = 10.0733000000;
					g[3] = 0.1500000000; fxg[3] = 34.9656000000; feg[3] = 8.6559000000;
					g[4] = 0.2000000000; fxg[4] = 33.9073000000; feg[4] = 7.4020000000;
					g[5] = 0.2500000000; fxg[5] = 32.8115000000; feg[5] = 6.4158000000;
					g[6] = 0.3000000000; fxg[6] = 31.6807000000; feg[6] = 5.6583000000;
					g[7] = 0.3500000000; fxg[7] = 30.5253000000; feg[7] = 5.0600000000;
					g[8] = 0.4000000000; fxg[8] = 29.3682000000; feg[8] = 4.5664000000;
					g[9] = 0.4500000000; fxg[9] = 28.2351000000; feg[9] = 4.1437000000;
					g[10] = 0.5000000000; fxg[10] = 27.1475000000; feg[10] = 3.7729000000;
					g[11] = 0.5500000000; fxg[11] = 26.1196000000; feg[11] = 3.4434000000;
					g[12] = 0.6000000000; fxg[12] = 25.1579000000; feg[12] = 3.1492000000;
					g[13] = 0.6500000000; fxg[13] = 24.2633000000; feg[13] = 2.8860000000;
					g[14] = 0.7000000000; fxg[14] = 23.4321000000; feg[14] = 2.6509000000;
					g[15] = 0.7500000000; fxg[15] = 22.6582000000; feg[15] = 2.4409000000;
					g[16] = 0.8000000000; fxg[16] = 21.9341000000; feg[16] = 2.2536000000;
					g[17] = 0.8500000000; fxg[17] = 21.2522000000; feg[17] = 2.0867000000;
					g[18] = 0.9000000000; fxg[18] = 20.6052000000; feg[18] = 1.9377000000;
					g[19] = 0.9500000000; fxg[19] = 19.9866000000; feg[19] = 1.8047000000;
					g[20] = 1.0000000000; fxg[20] = 19.3910000000; feg[20] = 1.6858000000;
					g[21] = 1.0500000000; fxg[21] = 18.8141000000; feg[21] = 1.5792000000;
					g[22] = 1.1000000000; fxg[22] = 18.2527000000; feg[22] = 1.4833000000;
					g[23] = 1.1500000000; fxg[23] = 17.7042000000; feg[23] = 1.3968000000;
					g[24] = 1.2000000000; fxg[24] = 17.1674000000; feg[24] = 1.3185000000;
					g[25] = 1.2500000000; fxg[25] = 16.6413000000; feg[25] = 1.2474000000;
					g[26] = 1.3000000000; fxg[26] = 16.1255000000; feg[26] = 1.1825000000;
					g[27] = 1.3500000000; fxg[27] = 15.6204000000; feg[27] = 1.1231000000;
					g[28] = 1.4000000000; fxg[28] = 15.1261000000; feg[28] = 1.0684000000;
					g[29] = 1.4500000000; fxg[29] = 14.6434000000; feg[29] = 1.0180000000;
					g[30] = 1.5000000000; fxg[30] = 14.1730000000; feg[30] = 0.9713000000;
					g[31] = 1.5500000000; fxg[31] = 13.7153000000; feg[31] = 0.9278000000;
					g[32] = 1.6000000000; fxg[32] = 13.2713000000; feg[32] = 0.8874000000;
					g[33] = 1.6500000000; fxg[33] = 12.8419000000; feg[33] = 0.8495000000;
					g[34] = 1.7000000000; fxg[34] = 12.4270000000; feg[34] = 0.8140000000;
					g[35] = 1.7500000000; fxg[35] = 12.0273000000; feg[35] = 0.7807000000;
					g[36] = 1.8000000000; fxg[36] = 11.6439000000; feg[36] = 0.7492000000;
					g[37] = 1.8500000000; fxg[37] = 11.2764000000; feg[37] = 0.7195000000;
					g[38] = 1.9000000000; fxg[38] = 10.9242000000; feg[38] = 0.6915000000;
					g[39] = 1.9500000000; fxg[39] = 10.5884000000; feg[39] = 0.6650000000;
					g[40] = 2.0000000000; fxg[40] = 10.2695000000; feg[40] = 0.6398000000;
					g[41] = 2.0500000000; fxg[41] = 9.9661000000; feg[41] = 0.6158000000;
					g[42] = 2.1000000000; fxg[42] = 9.6771000000; feg[42] = 0.5931000000;
					g[43] = 2.1500000000; fxg[43] = 9.4036000000; feg[43] = 0.5715000000;
					g[44] = 2.2000000000; fxg[44] = 9.1461000000; feg[44] = 0.5509000000;
					g[45] = 2.2500000000; fxg[45] = 8.9030000000; feg[45] = 0.5313000000;
					g[46] = 2.3000000000; fxg[46] = 8.6723000000; feg[46] = 0.5127000000;
					g[47] = 2.3500000000; fxg[47] = 8.4542000000; feg[47] = 0.4949000000;
					g[48] = 2.4000000000; fxg[48] = 8.2500000000; feg[48] = 0.4778000000;
					g[49] = 2.4500000000; fxg[49] = 8.0590000000; feg[49] = 0.4616000000;
					g[50] = 2.5000000000; fxg[50] = 7.8787000000; feg[50] = 0.4461000000;
					g[51] = 2.5500000000; fxg[51] = 7.7076000000; feg[51] = 0.4313000000;
					g[52] = 2.6000000000; fxg[52] = 7.5463000000; feg[52] = 0.4171000000;
					g[53] = 2.6500000000; fxg[53] = 7.3959000000; feg[53] = 0.4036000000;
					g[54] = 2.7000000000; fxg[54] = 7.2558000000; feg[54] = 0.3906000000;
					g[55] = 2.7500000000; fxg[55] = 7.1236000000; feg[55] = 0.3782000000;
					g[56] = 2.8000000000; fxg[56] = 6.9975000000; feg[56] = 0.3664000000;
					g[57] = 2.8500000000; fxg[57] = 6.8777000000; feg[57] = 0.3550000000;
					g[58] = 2.9000000000; fxg[58] = 6.7651000000; feg[58] = 0.3442000000;
					g[59] = 2.9500000000; fxg[59] = 6.6604000000; feg[59] = 0.3338000000;
					g[60] = 3.0000000000; fxg[60] = 6.5623000000; feg[60] = 0.3238000000;
					g[61] = 3.0500000000; fxg[61] = 6.4682000000; feg[61] = 0.3142000000;
					g[62] = 3.1000000000; fxg[62] = 6.3773000000; feg[62] = 0.3051000000;
					g[63] = 3.1500000000; fxg[63] = 6.2901000000; feg[63] = 0.2963000000;
					g[64] = 3.2000000000; fxg[64] = 6.2072000000; feg[64] = 0.2879000000;
					g[65] = 3.2500000000; fxg[65] = 6.1294000000; feg[65] = 0.2798000000;
					g[66] = 3.3000000000; fxg[66] = 6.0562000000; feg[66] = 0.2720000000;
					g[67] = 3.3500000000; fxg[67] = 5.9852000000; feg[67] = 0.2646000000;
					g[68] = 3.4000000000; fxg[68] = 5.9151000000; feg[68] = 0.2574000000;
					g[69] = 3.4500000000; fxg[69] = 5.8467000000; feg[69] = 0.2506000000;
					g[70] = 3.5000000000; fxg[70] = 5.7802000000; feg[70] = 0.2440000000;
					g[71] = 3.5500000000; fxg[71] = 5.7159000000; feg[71] = 0.2376000000;
					g[72] = 3.6000000000; fxg[72] = 5.6549000000; feg[72] = 0.2315000000;
					g[73] = 3.6500000000; fxg[73] = 5.5966000000; feg[73] = 0.2257000000;
					g[74] = 3.7000000000; fxg[74] = 5.5386000000; feg[74] = 0.2200000000;
					g[75] = 3.7500000000; fxg[75] = 5.4801000000; feg[75] = 0.2146000000;
					g[76] = 3.8000000000; fxg[76] = 5.4222000000; feg[76] = 0.2094000000;
					g[77] = 3.8500000000; fxg[77] = 5.3651000000; feg[77] = 0.2043000000;
					g[78] = 3.9000000000; fxg[78] = 5.3085000000; feg[78] = 0.1995000000;
					g[79] = 3.9500000000; fxg[79] = 5.2534000000; feg[79] = 0.1948000000;
					g[80] = 4.0000000000; fxg[80] = 5.2007000000; feg[80] = 0.1903000000;
					g[81] = 4.0500000000; fxg[81] = 5.1489000000; feg[81] = 0.1859000000;
					g[82] = 4.1000000000; fxg[82] = 5.0959000000; feg[82] = 0.1817000000;
					g[83] = 4.1500000000; fxg[83] = 5.0418000000; feg[83] = 0.1776000000;
					g[84] = 4.2000000000; fxg[84] = 4.9883000000; feg[84] = 0.1737000000;
					g[85] = 4.2500000000; fxg[85] = 4.9354000000; feg[85] = 0.1699000000;
					g[86] = 4.3000000000; fxg[86] = 4.8821000000; feg[86] = 0.1663000000;
					g[87] = 4.3500000000; fxg[87] = 4.8291000000; feg[87] = 0.1628000000;
					g[88] = 4.4000000000; fxg[88] = 4.7780000000; feg[88] = 0.1593000000;
					g[89] = 4.4500000000; fxg[89] = 4.7286000000; feg[89] = 0.1560000000;
					g[90] = 4.5000000000; fxg[90] = 4.6784000000; feg[90] = 0.1528000000;
					g[91] = 4.5500000000; fxg[91] = 4.6261000000; feg[91] = 0.1497000000;
					g[92] = 4.6000000000; fxg[92] = 4.5735000000; feg[92] = 0.1467000000;
					g[93] = 4.6500000000; fxg[93] = 4.5219000000; feg[93] = 0.1438000000;
					g[94] = 4.7000000000; fxg[94] = 4.4708000000; feg[94] = 0.1410000000;
					g[95] = 4.7500000000; fxg[95] = 4.4189000000; feg[95] = 0.1382000000;
					g[96] = 4.8000000000; fxg[96] = 4.3670000000; feg[96] = 0.1356000000;
					g[97] = 4.8500000000; fxg[97] = 4.3168000000; feg[97] = 0.1330000000;
					g[98] = 4.9000000000; fxg[98] = 4.2688000000; feg[98] = 0.1305000000;
					g[99] = 4.9500000000; fxg[99] = 4.2208000000; feg[99] = 0.1281000000;
					g[100] = 5.0000000000; fxg[100] = 4.1708000000; feg[100] = 0.1257000000;
					g[101] = 5.0500000000; fxg[101] = 4.1194000000; feg[101] = 0.1234000000;
					g[102] = 5.1000000000; fxg[102] = 4.0687000000; feg[102] = 0.1212000000;
					g[103] = 5.1500000000; fxg[103] = 4.0195000000; feg[103] = 0.1190000000;
					g[104] = 5.2000000000; fxg[104] = 3.9706000000; feg[104] = 0.1169000000;
					g[105] = 5.2500000000; fxg[105] = 3.9208000000; feg[105] = 0.1149000000;
					g[106] = 5.3000000000; fxg[106] = 3.8711000000; feg[106] = 0.1129000000;
					g[107] = 5.3500000000; fxg[107] = 3.8231000000; feg[107] = 0.1110000000;
					g[108] = 5.4000000000; fxg[108] = 3.7776000000; feg[108] = 0.1091000000;
					g[109] = 5.4500000000; fxg[109] = 3.7332000000; feg[109] = 0.1072000000;
					g[110] = 5.5000000000; fxg[110] = 3.6875000000; feg[110] = 0.1054000000;
					g[111] = 5.5500000000; fxg[111] = 3.6397000000; feg[111] = 0.1037000000;
					g[112] = 5.6000000000; fxg[112] = 3.5915000000; feg[112] = 0.1020000000;
					g[113] = 5.6500000000; fxg[113] = 3.5448000000; feg[113] = 0.1003000000;
					g[114] = 5.7000000000; fxg[114] = 3.4998000000; feg[114] = 0.0987000000;
					g[115] = 5.7500000000; fxg[115] = 3.4548000000; feg[115] = 0.0971000000;
					g[116] = 5.8000000000; fxg[116] = 3.4092000000; feg[116] = 0.0956000000;
					g[117] = 5.8500000000; fxg[117] = 3.3638000000; feg[117] = 0.0941000000;
					g[118] = 5.9000000000; fxg[118] = 3.3201000000; feg[118] = 0.0926000000;
					g[119] = 5.9500000000; fxg[119] = 3.2791000000; feg[119] = 0.0912000000;
					g[120] = 6.0000000000; fxg[120] = 3.2401000000; feg[120] = 0.0898000000;
					g[121] = 6.0500000000; fxg[121] = 3.2008000000; feg[121] = 0.0884000000;
					g[122] = 6.1000000000; fxg[122] = 3.1597000000; feg[122] = 0.0871000000;
					g[123] = 6.1500000000; fxg[123] = 3.1170000000; feg[123] = 0.0858000000;
					g[124] = 6.2000000000; fxg[124] = 3.0745000000; feg[124] = 0.0845000000;
					g[125] = 6.2500000000; fxg[125] = 3.0339000000; feg[125] = 0.0832000000;
					g[126] = 6.3000000000; fxg[126] = 2.9947000000; feg[126] = 0.0820000000;
					g[127] = 6.3500000000; fxg[127] = 2.9556000000; feg[127] = 0.0808000000;
					g[128] = 6.4000000000; fxg[128] = 2.9161000000; feg[128] = 0.0797000000;
					g[129] = 6.4500000000; fxg[129] = 2.8771000000; feg[129] = 0.0785000000;
					g[130] = 6.5000000000; fxg[130] = 2.8394000000; feg[130] = 0.0774000000;
					g[131] = 6.5500000000; fxg[131] = 2.8042000000; feg[131] = 0.0763000000;
					g[132] = 6.6000000000; fxg[132] = 2.7717000000; feg[132] = 0.0752000000;
					g[133] = 6.6500000000; fxg[133] = 2.7403000000; feg[133] = 0.0742000000;
					g[134] = 6.7000000000; fxg[134] = 2.7080000000; feg[134] = 0.0731000000;
					g[135] = 6.7500000000; fxg[135] = 2.6739000000; feg[135] = 0.0721000000;
					g[136] = 6.8000000000; fxg[136] = 2.6385000000; feg[136] = 0.0711000000;
					g[137] = 6.8500000000; fxg[137] = 2.6031000000; feg[137] = 0.0702000000;
					g[138] = 6.9000000000; fxg[138] = 2.5694000000; feg[138] = 0.0692000000;
					g[139] = 6.9500000000; fxg[139] = 2.5371000000; feg[139] = 0.0683000000;
					g[140] = 7.0000000000; fxg[140] = 2.5049000000; feg[140] = 0.0674000000;
					g[141] = 7.0500000000; fxg[141] = 2.4726000000; feg[141] = 0.0665000000;
					g[142] = 7.1000000000; fxg[142] = 2.4407000000; feg[142] = 0.0656000000;
					g[143] = 7.1500000000; fxg[143] = 2.4099000000; feg[143] = 0.0648000000;
					g[144] = 7.2000000000; fxg[144] = 2.3809000000; feg[144] = 0.0639000000;
					g[145] = 7.2500000000; fxg[145] = 2.3544000000; feg[145] = 0.0631000000;
					g[146] = 7.3000000000; fxg[146] = 2.3305000000; feg[146] = 0.0623000000;
					g[147] = 7.3500000000; fxg[147] = 2.3074000000; feg[147] = 0.0615000000;
					g[148] = 7.4000000000; fxg[148] = 2.2834000000; feg[148] = 0.0607000000;
					g[149] = 7.4500000000; fxg[149] = 2.2577000000; feg[149] = 0.0599000000;
					g[150] = 7.5000000000; fxg[150] = 2.2306000000; feg[150] = 0.0592000000;
					g[151] = 7.5500000000; fxg[151] = 2.2027000000; feg[151] = 0.0584000000;
					g[152] = 7.6000000000; fxg[152] = 2.1757000000; feg[152] = 0.0577000000;
					g[153] = 7.6500000000; fxg[153] = 2.1501000000; feg[153] = 0.0570000000;
					g[154] = 7.7000000000; fxg[154] = 2.1251000000; feg[154] = 0.0563000000;
					g[155] = 7.7500000000; fxg[155] = 2.0997000000; feg[155] = 0.0556000000;
					g[156] = 7.8000000000; fxg[156] = 2.0745000000; feg[156] = 0.0550000000;
					g[157] = 7.8500000000; fxg[157] = 2.0502000000; feg[157] = 0.0543000000;
					g[158] = 7.9000000000; fxg[158] = 2.0273000000; feg[158] = 0.0536000000;
					g[159] = 7.9500000000; fxg[159] = 2.0058000000; feg[159] = 0.0530000000;
					g[160] = 8.0000000000; fxg[160] = 1.9867000000; feg[160] = 0.0524000000;
					g[161] = 8.0500000000; fxg[161] = 1.9701000000; feg[161] = 0.0518000000;
					g[162] = 8.1000000000; fxg[162] = 1.9548000000; feg[162] = 0.0511000000;
					g[163] = 8.1500000000; fxg[163] = 1.9392000000; feg[163] = 0.0505000000;
					g[164] = 8.2000000000; fxg[164] = 1.9222000000; feg[164] = 0.0499000000;
					g[165] = 8.2500000000; fxg[165] = 1.9038000000; feg[165] = 0.0494000000;
					g[166] = 8.3000000000; fxg[166] = 1.8839000000; feg[166] = 0.0488000000;
					g[167] = 8.3500000000; fxg[167] = 1.8632000000; feg[167] = 0.0482000000;
					g[168] = 8.4000000000; fxg[168] = 1.8430000000; feg[168] = 0.0477000000;
					g[169] = 8.4500000000; fxg[169] = 1.8240000000; feg[169] = 0.0472000000;
					g[170] = 8.5000000000; fxg[170] = 1.8053000000; feg[170] = 0.0466000000;
					g[171] = 8.5500000000; fxg[171] = 1.7861000000; feg[171] = 0.0461000000;
					g[172] = 8.6000000000; fxg[172] = 1.7668000000; feg[172] = 0.0456000000;
					g[173] = 8.6500000000; fxg[173] = 1.7485000000; feg[173] = 0.0451000000;
					g[174] = 8.7000000000; fxg[174] = 1.7315000000; feg[174] = 0.0446000000;
					g[175] = 8.7500000000; fxg[175] = 1.7158000000; feg[175] = 0.0441000000;
					g[176] = 8.8000000000; fxg[176] = 1.7016000000; feg[176] = 0.0436000000;
					g[177] = 8.8500000000; fxg[177] = 1.6896000000; feg[177] = 0.0432000000;
					g[178] = 8.9000000000; fxg[178] = 1.6800000000; feg[178] = 0.0427000000;
					g[179] = 8.9500000000; fxg[179] = 1.6715000000; feg[179] = 0.0422000000;
					g[180] = 9.0000000000; fxg[180] = 1.6624000000; feg[180] = 0.0418000000;
					g[181] = 9.0500000000; fxg[181] = 1.6520000000; feg[181] = 0.0413000000;
					g[182] = 9.1000000000; fxg[182] = 1.6404000000; feg[182] = 0.0409000000;
					g[183] = 9.1500000000; fxg[183] = 1.6273000000; feg[183] = 0.0404000000;
					g[184] = 9.2000000000; fxg[184] = 1.6128000000; feg[184] = 0.0400000000;
					g[185] = 9.2500000000; fxg[185] = 1.5977000000; feg[185] = 0.0396000000;
					g[186] = 9.3000000000; fxg[186] = 1.5834000000; feg[186] = 0.0392000000;
					g[187] = 9.3500000000; fxg[187] = 1.5698000000; feg[187] = 0.0388000000;
					g[188] = 9.4000000000; fxg[188] = 1.5561000000; feg[188] = 0.0384000000;
					g[189] = 9.4500000000; fxg[189] = 1.5417000000; feg[189] = 0.0380000000;
					g[190] = 9.5000000000; fxg[190] = 1.5271000000; feg[190] = 0.0376000000;
					g[191] = 9.5500000000; fxg[191] = 1.5134000000; feg[191] = 0.0373000000;
					g[192] = 9.6000000000; fxg[192] = 1.5012000000; feg[192] = 0.0369000000;
					g[193] = 9.6500000000; fxg[193] = 1.4902000000; feg[193] = 0.0365000000;
					g[194] = 9.7000000000; fxg[194] = 1.4802000000; feg[194] = 0.0361000000;
					g[195] = 9.7500000000; fxg[195] = 1.4720000000; feg[195] = 0.0358000000;
					g[196] = 9.8000000000; fxg[196] = 1.4660000000; feg[196] = 0.0354000000;
					g[197] = 9.8500000000; fxg[197] = 1.4619000000; feg[197] = 0.0351000000;
					g[198] = 9.9000000000; fxg[198] = 1.4584000000; feg[198] = 0.0347000000;
					g[199] = 9.9500000000; fxg[199] = 1.4539000000; feg[199] = 0.0344000000;
					g[200] = 10.0000000000; fxg[200] = 1.4480000000; feg[200] = 0.0340000000;
					g[201] = 10.0500000000; fxg[201] = 1.4411000000; feg[201] = 0.0337000000;
					g[202] = 10.1000000000; fxg[202] = 1.4329000000; feg[202] = 0.0334000000;
					g[203] = 10.1500000000; fxg[203] = 1.4230000000; feg[203] = 0.0331000000;
					g[204] = 10.2000000000; fxg[204] = 1.4120000000; feg[204] = 0.0327000000;
					g[205] = 10.2500000000; fxg[205] = 1.4012000000; feg[205] = 0.0324000000;
					g[206] = 10.3000000000; fxg[206] = 1.3911000000; feg[206] = 0.0321000000;
					g[207] = 10.3500000000; fxg[207] = 1.3813000000; feg[207] = 0.0318000000;
					g[208] = 10.4000000000; fxg[208] = 1.3712000000; feg[208] = 0.0315000000;
					g[209] = 10.4500000000; fxg[209] = 1.3602000000; feg[209] = 0.0312000000;
					g[210] = 10.5000000000; fxg[210] = 1.3490000000; feg[210] = 0.0310000000;
					g[211] = 10.5500000000; fxg[211] = 1.3386000000; feg[211] = 0.0307000000;
					g[212] = 10.6000000000; fxg[212] = 1.3296000000; feg[212] = 0.0304000000;
					g[213] = 10.6500000000; fxg[213] = 1.3216000000; feg[213] = 0.0301000000;
					g[214] = 10.7000000000; fxg[214] = 1.3144000000; feg[214] = 0.0298000000;
					g[215] = 10.7500000000; fxg[215] = 1.3086000000; feg[215] = 0.0296000000;
					g[216] = 10.8000000000; fxg[216] = 1.3047000000; feg[216] = 0.0293000000;
					g[217] = 10.8500000000; fxg[217] = 1.3029000000; feg[217] = 0.0290000000;
					g[218] = 10.9000000000; fxg[218] = 1.3024000000; feg[218] = 0.0288000000;
					g[219] = 10.9500000000; fxg[219] = 1.3020000000; feg[219] = 0.0285000000;
					g[220] = 11.0000000000; fxg[220] = 1.3003000000; feg[220] = 0.0282000000;
					g[221] = 11.0500000000; fxg[221] = 1.2972000000; feg[221] = 0.0280000000;
					g[222] = 11.1000000000; fxg[222] = 1.2932000000; feg[222] = 0.0277000000;
					g[223] = 11.1500000000; fxg[223] = 1.2880000000; feg[223] = 0.0275000000;
					g[224] = 11.2000000000; fxg[224] = 1.2811000000; feg[224] = 0.0273000000;
					g[225] = 11.2500000000; fxg[225] = 1.2729000000; feg[225] = 0.0270000000;
					g[226] = 11.3000000000; fxg[226] = 1.2643000000; feg[226] = 0.0268000000;
					g[227] = 11.3500000000; fxg[227] = 1.2565000000; feg[227] = 0.0266000000;
					g[228] = 11.4000000000; fxg[228] = 1.2492000000; feg[228] = 0.0263000000;
					g[229] = 11.4500000000; fxg[229] = 1.2421000000; feg[229] = 0.0261000000;
					g[230] = 11.5000000000; fxg[230] = 1.2344000000; feg[230] = 0.0259000000;
					g[231] = 11.5500000000; fxg[231] = 1.2258000000; feg[231] = 0.0257000000;
					g[232] = 11.6000000000; fxg[232] = 1.2169000000; feg[232] = 0.0255000000;
					g[233] = 11.6500000000; fxg[233] = 1.2084000000; feg[233] = 0.0252000000;
					g[234] = 11.7000000000; fxg[234] = 1.2011000000; feg[234] = 0.0250000000;
					g[235] = 11.7500000000; fxg[235] = 1.1946000000; feg[235] = 0.0248000000;
					g[236] = 11.8000000000; fxg[236] = 1.1887000000; feg[236] = 0.0246000000;
					g[237] = 11.8500000000; fxg[237] = 1.1838000000; feg[237] = 0.0244000000;
					g[238] = 11.9000000000; fxg[238] = 1.1805000000; feg[238] = 0.0242000000;
					g[239] = 11.9500000000; fxg[239] = 1.1791000000; feg[239] = 0.0240000000;
					g[240] = 12.0000000000; fxg[240] = 1.1794000000; feg[240] = 0.0238000000;
					break;
				case 38:
					g[0] = 0.0000000000; fxg[0] = 38.0000000000; feg[0] = 13.1099000000;
					g[1] = 0.0500000000; fxg[1] = 37.6695000000; feg[1] = 12.6570000000;
					g[2] = 0.1000000000; fxg[2] = 36.8013000000; feg[2] = 11.4761000000;
					g[3] = 0.1500000000; fxg[3] = 35.6584000000; feg[3] = 9.9633000000;
					g[4] = 0.2000000000; fxg[4] = 34.4577000000; feg[4] = 8.4780000000;
					g[5] = 0.2500000000; fxg[5] = 33.2929000000; feg[5] = 7.2101000000;
					g[6] = 0.3000000000; fxg[6] = 32.1712000000; feg[6] = 6.2002000000;
					g[7] = 0.3500000000; fxg[7] = 31.0737000000; feg[7] = 5.4130000000;
					g[8] = 0.4000000000; fxg[8] = 29.9877000000; feg[8] = 4.7941000000;
					g[9] = 0.4500000000; fxg[9] = 28.9143000000; feg[9] = 4.2954000000;
					g[10] = 0.5000000000; fxg[10] = 27.8631000000; feg[10] = 3.8818000000;
					g[11] = 0.5500000000; fxg[11] = 26.8462000000; feg[11] = 3.5299000000;
					g[12] = 0.6000000000; fxg[12] = 25.8744000000; feg[12] = 3.2246000000;
					g[13] = 0.6500000000; fxg[13] = 24.9546000000; feg[13] = 2.9560000000;
					g[14] = 0.7000000000; fxg[14] = 24.0900000000; feg[14] = 2.7177000000;
					g[15] = 0.7500000000; fxg[15] = 23.2801000000; feg[15] = 2.5053000000;
					g[16] = 0.8000000000; fxg[16] = 22.5219000000; feg[16] = 2.3153000000;
					g[17] = 0.8500000000; fxg[17] = 21.8107000000; feg[17] = 2.1452000000;
					g[18] = 0.9000000000; fxg[18] = 21.1408000000; feg[18] = 1.9926000000;
					g[19] = 0.9500000000; fxg[19] = 20.5066000000; feg[19] = 1.8557000000;
					g[20] = 1.0000000000; fxg[20] = 19.9023000000; feg[20] = 1.7326000000;
					g[21] = 1.0500000000; fxg[21] = 19.3230000000; feg[21] = 1.6218000000;
					g[22] = 1.1000000000; fxg[22] = 18.7645000000; feg[22] = 1.5219000000;
					g[23] = 1.1500000000; fxg[23] = 18.2231000000; feg[23] = 1.4316000000;
					g[24] = 1.2000000000; fxg[24] = 17.6961000000; feg[24] = 1.3499000000;
					g[25] = 1.2500000000; fxg[25] = 17.1816000000; feg[25] = 1.2755000000;
					g[26] = 1.3000000000; fxg[26] = 16.6782000000; feg[26] = 1.2078000000;
					g[27] = 1.3500000000; fxg[27] = 16.1852000000; feg[27] = 1.1459000000;
					g[28] = 1.4000000000; fxg[28] = 15.7020000000; feg[28] = 1.0891000000;
					g[29] = 1.4500000000; fxg[29] = 15.2288000000; feg[29] = 1.0369000000;
					g[30] = 1.5000000000; fxg[30] = 14.7658000000; feg[30] = 0.9886000000;
					g[31] = 1.5500000000; fxg[31] = 14.3133000000; feg[31] = 0.9439000000;
					g[32] = 1.6000000000; fxg[32] = 13.8720000000; feg[32] = 0.9023000000;
					g[33] = 1.6500000000; fxg[33] = 13.4424000000; feg[33] = 0.8635000000;
					g[34] = 1.7000000000; fxg[34] = 13.0250000000; feg[34] = 0.8273000000;
					g[35] = 1.7500000000; fxg[35] = 12.6203000000; feg[35] = 0.7934000000;
					g[36] = 1.8000000000; fxg[36] = 12.2293000000; feg[36] = 0.7615000000;
					g[37] = 1.8500000000; fxg[37] = 11.8519000000; feg[37] = 0.7314000000;
					g[38] = 1.9000000000; fxg[38] = 11.4882000000; feg[38] = 0.7031000000;
					g[39] = 1.9500000000; fxg[39] = 11.1391000000; feg[39] = 0.6763000000;
					g[40] = 2.0000000000; fxg[40] = 10.8050000000; feg[40] = 0.6509000000;
					g[41] = 2.0500000000; fxg[41] = 10.4851000000; feg[41] = 0.6268000000;
					g[42] = 2.1000000000; fxg[42] = 10.1790000000; feg[42] = 0.6040000000;
					g[43] = 2.1500000000; fxg[43] = 9.8876000000; feg[43] = 0.5822000000;
					g[44] = 2.2000000000; fxg[44] = 9.6112000000; feg[44] = 0.5615000000;
					g[45] = 2.2500000000; fxg[45] = 9.3487000000; feg[45] = 0.5418000000;
					g[46] = 2.3000000000; fxg[46] = 9.0986000000; feg[46] = 0.5230000000;
					g[47] = 2.3500000000; fxg[47] = 8.8614000000; feg[47] = 0.5051000000;
					g[48] = 2.4000000000; fxg[48] = 8.6381000000; feg[48] = 0.4880000000;
					g[49] = 2.4500000000; fxg[49] = 8.4280000000; feg[49] = 0.4716000000;
					g[50] = 2.5000000000; fxg[50] = 8.2290000000; feg[50] = 0.4560000000;
					g[51] = 2.5500000000; fxg[51] = 8.0397000000; feg[51] = 0.4411000000;
					g[52] = 2.6000000000; fxg[52] = 7.8610000000; feg[52] = 0.4268000000;
					g[53] = 2.6500000000; fxg[53] = 7.6939000000; feg[53] = 0.4131000000;
					g[54] = 2.7000000000; fxg[54] = 7.5379000000; feg[54] = 0.4000000000;
					g[55] = 2.7500000000; fxg[55] = 7.3905000000; feg[55] = 0.3875000000;
					g[56] = 2.8000000000; fxg[56] = 7.2497000000; feg[56] = 0.3755000000;
					g[57] = 2.8500000000; fxg[57] = 7.1158000000; feg[57] = 0.3640000000;
					g[58] = 2.9000000000; fxg[58] = 6.9903000000; feg[58] = 0.3530000000;
					g[59] = 2.9500000000; fxg[59] = 6.8740000000; feg[59] = 0.3424000000;
					g[60] = 3.0000000000; fxg[60] = 6.7652000000; feg[60] = 0.3323000000;
					g[61] = 3.0500000000; fxg[61] = 6.6611000000; feg[61] = 0.3225000000;
					g[62] = 3.1000000000; fxg[62] = 6.5604000000; feg[62] = 0.3132000000;
					g[63] = 3.1500000000; fxg[63] = 6.4637000000; feg[63] = 0.3043000000;
					g[64] = 3.2000000000; fxg[64] = 6.3727000000; feg[64] = 0.2957000000;
					g[65] = 3.2500000000; fxg[65] = 6.2884000000; feg[65] = 0.2874000000;
					g[66] = 3.3000000000; fxg[66] = 6.2096000000; feg[66] = 0.2795000000;
					g[67] = 3.3500000000; fxg[67] = 6.1336000000; feg[67] = 0.2718000000;
					g[68] = 3.4000000000; fxg[68] = 6.0587000000; feg[68] = 0.2645000000;
					g[69] = 3.4500000000; fxg[69] = 5.9849000000; feg[69] = 0.2575000000;
					g[70] = 3.5000000000; fxg[70] = 5.9136000000; feg[70] = 0.2508000000;
					g[71] = 3.5500000000; fxg[71] = 5.8461000000; feg[71] = 0.2443000000;
					g[72] = 3.6000000000; fxg[72] = 5.7832000000; feg[72] = 0.2380000000;
					g[73] = 3.6500000000; fxg[73] = 5.7238000000; feg[73] = 0.2319000000;
					g[74] = 3.7000000000; fxg[74] = 5.6651000000; feg[74] = 0.2261000000;
					g[75] = 3.7500000000; fxg[75] = 5.6055000000; feg[75] = 0.2205000000;
					g[76] = 3.8000000000; fxg[76] = 5.5458000000; feg[76] = 0.2152000000;
					g[77] = 3.8500000000; fxg[77] = 5.4867000000; feg[77] = 0.2100000000;
					g[78] = 3.9000000000; fxg[78] = 5.4292000000; feg[78] = 0.2050000000;
					g[79] = 3.9500000000; fxg[79] = 5.3746000000; feg[79] = 0.2002000000;
					g[80] = 4.0000000000; fxg[80] = 5.3233000000; feg[80] = 0.1955000000;
					g[81] = 4.0500000000; fxg[81] = 5.2734000000; feg[81] = 0.1910000000;
					g[82] = 4.1000000000; fxg[82] = 5.2221000000; feg[82] = 0.1867000000;
					g[83] = 4.1500000000; fxg[83] = 5.1692000000; feg[83] = 0.1825000000;
					g[84] = 4.2000000000; fxg[84] = 5.1158000000; feg[84] = 0.1785000000;
					g[85] = 4.2500000000; fxg[85] = 5.0625000000; feg[85] = 0.1746000000;
					g[86] = 4.3000000000; fxg[86] = 5.0096000000; feg[86] = 0.1708000000;
					g[87] = 4.3500000000; fxg[87] = 4.9582000000; feg[87] = 0.1672000000;
					g[88] = 4.4000000000; fxg[88] = 4.9097000000; feg[88] = 0.1636000000;
					g[89] = 4.4500000000; fxg[89] = 4.8630000000; feg[89] = 0.1602000000;
					g[90] = 4.5000000000; fxg[90] = 4.8155000000; feg[90] = 0.1569000000;
					g[91] = 4.5500000000; fxg[91] = 4.7657000000; feg[91] = 0.1537000000;
					g[92] = 4.6000000000; fxg[92] = 4.7146000000; feg[92] = 0.1506000000;
					g[93] = 4.6500000000; fxg[93] = 4.6637000000; feg[93] = 0.1476000000;
					g[94] = 4.7000000000; fxg[94] = 4.6128000000; feg[94] = 0.1447000000;
					g[95] = 4.7500000000; fxg[95] = 4.5616000000; feg[95] = 0.1419000000;
					g[96] = 4.8000000000; fxg[96] = 4.5111000000; feg[96] = 0.1392000000;
					g[97] = 4.8500000000; fxg[97] = 4.4632000000; feg[97] = 0.1365000000;
					g[98] = 4.9000000000; fxg[98] = 4.4177000000; feg[98] = 0.1339000000;
					g[99] = 4.9500000000; fxg[99] = 4.3723000000; feg[99] = 0.1314000000;
					g[100] = 5.0000000000; fxg[100] = 4.3244000000; feg[100] = 0.1290000000;
					g[101] = 5.0500000000; fxg[101] = 4.2746000000; feg[101] = 0.1266000000;
					g[102] = 5.1000000000; fxg[102] = 4.2247000000; feg[102] = 0.1243000000;
					g[103] = 5.1500000000; fxg[103] = 4.1759000000; feg[103] = 0.1221000000;
					g[104] = 5.2000000000; fxg[104] = 4.1271000000; feg[104] = 0.1199000000;
					g[105] = 5.2500000000; fxg[105] = 4.0775000000; feg[105] = 0.1178000000;
					g[106] = 5.3000000000; fxg[106] = 4.0283000000; feg[106] = 0.1158000000;
					g[107] = 5.3500000000; fxg[107] = 3.9814000000; feg[107] = 0.1138000000;
					g[108] = 5.4000000000; fxg[108] = 3.9376000000; feg[108] = 0.1118000000;
					g[109] = 5.4500000000; fxg[109] = 3.8948000000; feg[109] = 0.1099000000;
					g[110] = 5.5000000000; fxg[110] = 3.8502000000; feg[110] = 0.1081000000;
					g[111] = 5.5500000000; fxg[111] = 3.8029000000; feg[111] = 0.1063000000;
					g[112] = 5.6000000000; fxg[112] = 3.7549000000; feg[112] = 0.1045000000;
					g[113] = 5.6500000000; fxg[113] = 3.7082000000; feg[113] = 0.1028000000;
					g[114] = 5.7000000000; fxg[114] = 3.6631000000; feg[114] = 0.1012000000;
					g[115] = 5.7500000000; fxg[115] = 3.6179000000; feg[115] = 0.0996000000;
					g[116] = 5.8000000000; fxg[116] = 3.5718000000; feg[116] = 0.0980000000;
					g[117] = 5.8500000000; fxg[117] = 3.5256000000; feg[117] = 0.0964000000;
					g[118] = 5.9000000000; fxg[118] = 3.4815000000; feg[118] = 0.0949000000;
					g[119] = 5.9500000000; fxg[119] = 3.4408000000; feg[119] = 0.0935000000;
					g[120] = 6.0000000000; fxg[120] = 3.4024000000; feg[120] = 0.0920000000;
					g[121] = 6.0500000000; fxg[121] = 3.3633000000; feg[121] = 0.0906000000;
					g[122] = 6.1000000000; fxg[122] = 3.3216000000; feg[122] = 0.0892000000;
					g[123] = 6.1500000000; fxg[123] = 3.2778000000; feg[123] = 0.0879000000;
					g[124] = 6.2000000000; fxg[124] = 3.2343000000; feg[124] = 0.0866000000;
					g[125] = 6.2500000000; fxg[125] = 3.1930000000; feg[125] = 0.0853000000;
					g[126] = 6.3000000000; fxg[126] = 3.1536000000; feg[126] = 0.0841000000;
					g[127] = 6.3500000000; fxg[127] = 3.1141000000; feg[127] = 0.0828000000;
					g[128] = 6.4000000000; fxg[128] = 3.0736000000; feg[128] = 0.0816000000;
					g[129] = 6.4500000000; fxg[129] = 3.0326000000; feg[129] = 0.0805000000;
					g[130] = 6.5000000000; fxg[130] = 2.9931000000; feg[130] = 0.0793000000;
					g[131] = 6.5500000000; fxg[131] = 2.9568000000; feg[131] = 0.0782000000;
					g[132] = 6.6000000000; fxg[132] = 2.9238000000; feg[132] = 0.0771000000;
					g[133] = 6.6500000000; fxg[133] = 2.8921000000; feg[133] = 0.0760000000;
					g[134] = 6.7000000000; fxg[134] = 2.8589000000; feg[134] = 0.0749000000;
					g[135] = 6.7500000000; fxg[135] = 2.8228000000; feg[135] = 0.0739000000;
					g[136] = 6.8000000000; fxg[136] = 2.7849000000; feg[136] = 0.0729000000;
					g[137] = 6.8500000000; fxg[137] = 2.7477000000; feg[137] = 0.0719000000;
					g[138] = 6.9000000000; fxg[138] = 2.7129000000; feg[138] = 0.0710000000;
					g[139] = 6.9500000000; fxg[139] = 2.6804000000; feg[139] = 0.0700000000;
					g[140] = 7.0000000000; fxg[140] = 2.6481000000; feg[140] = 0.0691000000;
					g[141] = 7.0500000000; fxg[141] = 2.6149000000; feg[141] = 0.0682000000;
					g[142] = 7.1000000000; fxg[142] = 2.5809000000; feg[142] = 0.0673000000;
					g[143] = 7.1500000000; fxg[143] = 2.5473000000; feg[143] = 0.0664000000;
					g[144] = 7.2000000000; fxg[144] = 2.5158000000; feg[144] = 0.0655000000;
					g[145] = 7.2500000000; fxg[145] = 2.4878000000; feg[145] = 0.0647000000;
					g[146] = 7.3000000000; fxg[146] = 2.4629000000; feg[146] = 0.0638000000;
					g[147] = 7.3500000000; fxg[147] = 2.4390000000; feg[147] = 0.0630000000;
					g[148] = 7.4000000000; fxg[148] = 2.4136000000; feg[148] = 0.0622000000;
					g[149] = 7.4500000000; fxg[149] = 2.3854000000; feg[149] = 0.0614000000;
					g[150] = 7.5000000000; fxg[150] = 2.3551000000; feg[150] = 0.0607000000;
					g[151] = 7.5500000000; fxg[151] = 2.3246000000; feg[151] = 0.0599000000;
					g[152] = 7.6000000000; fxg[152] = 2.2959000000; feg[152] = 0.0592000000;
					g[153] = 7.6500000000; fxg[153] = 2.2698000000; feg[153] = 0.0584000000;
					g[154] = 7.7000000000; fxg[154] = 2.2449000000; feg[154] = 0.0577000000;
					g[155] = 7.7500000000; fxg[155] = 2.2196000000; feg[155] = 0.0570000000;
					g[156] = 7.8000000000; fxg[156] = 2.1934000000; feg[156] = 0.0563000000;
					g[157] = 7.8500000000; fxg[157] = 2.1668000000; feg[157] = 0.0557000000;
					g[158] = 7.9000000000; fxg[158] = 2.1407000000; feg[158] = 0.0550000000;
					g[159] = 7.9500000000; fxg[159] = 2.1165000000; feg[159] = 0.0544000000;
					g[160] = 8.0000000000; fxg[160] = 2.0954000000; feg[160] = 0.0537000000;
					g[161] = 8.0500000000; fxg[161] = 2.0776000000; feg[161] = 0.0531000000;
					g[162] = 8.1000000000; fxg[162] = 2.0616000000; feg[162] = 0.0524000000;
					g[163] = 8.1500000000; fxg[163] = 2.0449000000; feg[163] = 0.0518000000;
					g[164] = 8.2000000000; fxg[164] = 2.0261000000; feg[164] = 0.0512000000;
					g[165] = 8.2500000000; fxg[165] = 2.0046000000; feg[165] = 0.0506000000;
					g[166] = 8.3000000000; fxg[166] = 1.9813000000; feg[166] = 0.0501000000;
					g[167] = 8.3500000000; fxg[167] = 1.9580000000; feg[167] = 0.0495000000;
					g[168] = 8.4000000000; fxg[168] = 1.9364000000; feg[168] = 0.0489000000;
					g[169] = 8.4500000000; fxg[169] = 1.9171000000; feg[169] = 0.0484000000;
					g[170] = 8.5000000000; fxg[170] = 1.8988000000; feg[170] = 0.0478000000;
					g[171] = 8.5500000000; fxg[171] = 1.8801000000; feg[171] = 0.0473000000;
					g[172] = 8.6000000000; fxg[172] = 1.8604000000; feg[172] = 0.0468000000;
					g[173] = 8.6500000000; fxg[173] = 1.8405000000; feg[173] = 0.0463000000;
					g[174] = 8.7000000000; fxg[174] = 1.8209000000; feg[174] = 0.0458000000;
					g[175] = 8.7500000000; fxg[175] = 1.8024000000; feg[175] = 0.0453000000;
					g[176] = 8.8000000000; fxg[176] = 1.7859000000; feg[176] = 0.0448000000;
					g[177] = 8.8500000000; fxg[177] = 1.7723000000; feg[177] = 0.0443000000;
					g[178] = 8.9000000000; fxg[178] = 1.7617000000; feg[178] = 0.0438000000;
					g[179] = 8.9500000000; fxg[179] = 1.7526000000; feg[179] = 0.0433000000;
					g[180] = 9.0000000000; fxg[180] = 1.7428000000; feg[180] = 0.0429000000;
					g[181] = 9.0500000000; fxg[181] = 1.7311000000; feg[181] = 0.0424000000;
					g[182] = 9.1000000000; fxg[182] = 1.7171000000; feg[182] = 0.0419000000;
					g[183] = 9.1500000000; fxg[183] = 1.7009000000; feg[183] = 0.0415000000;
					g[184] = 9.2000000000; fxg[184] = 1.6836000000; feg[184] = 0.0411000000;
					g[185] = 9.2500000000; fxg[185] = 1.6668000000; feg[185] = 0.0407000000;
					g[186] = 9.3000000000; fxg[186] = 1.6517000000; feg[186] = 0.0402000000;
					g[187] = 9.3500000000; fxg[187] = 1.6384000000; feg[187] = 0.0398000000;
					g[188] = 9.4000000000; fxg[188] = 1.6253000000; feg[188] = 0.0394000000;
					g[189] = 9.4500000000; fxg[189] = 1.6114000000; feg[189] = 0.0390000000;
					g[190] = 9.5000000000; fxg[190] = 1.5966000000; feg[190] = 0.0386000000;
					g[191] = 9.5500000000; fxg[191] = 1.5818000000; feg[191] = 0.0382000000;
					g[192] = 9.6000000000; fxg[192] = 1.5678000000; feg[192] = 0.0378000000;
					g[193] = 9.6500000000; fxg[193] = 1.5546000000; feg[193] = 0.0375000000;
					g[194] = 9.7000000000; fxg[194] = 1.5426000000; feg[194] = 0.0371000000;
					g[195] = 9.7500000000; fxg[195] = 1.5328000000; feg[195] = 0.0367000000;
					g[196] = 9.8000000000; fxg[196] = 1.5257000000; feg[196] = 0.0364000000;
					g[197] = 9.8500000000; fxg[197] = 1.5212000000; feg[197] = 0.0360000000;
					g[198] = 9.9000000000; fxg[198] = 1.5174000000; feg[198] = 0.0356000000;
					g[199] = 9.9500000000; fxg[199] = 1.5126000000; feg[199] = 0.0353000000;
					g[200] = 10.0000000000; fxg[200] = 1.5059000000; feg[200] = 0.0349000000;
					g[201] = 10.0500000000; fxg[201] = 1.4973000000; feg[201] = 0.0346000000;
					g[202] = 10.1000000000; fxg[202] = 1.4867000000; feg[202] = 0.0343000000;
					g[203] = 10.1500000000; fxg[203] = 1.4745000000; feg[203] = 0.0339000000;
					g[204] = 10.2000000000; fxg[204] = 1.4619000000; feg[204] = 0.0336000000;
					g[205] = 10.2500000000; fxg[205] = 1.4502000000; feg[205] = 0.0333000000;
					g[206] = 10.3000000000; fxg[206] = 1.4401000000; feg[206] = 0.0330000000;
					g[207] = 10.3500000000; fxg[207] = 1.4309000000; feg[207] = 0.0327000000;
					g[208] = 10.4000000000; fxg[208] = 1.4213000000; feg[208] = 0.0324000000;
					g[209] = 10.4500000000; fxg[209] = 1.4105000000; feg[209] = 0.0321000000;
					g[210] = 10.5000000000; fxg[210] = 1.3990000000; feg[210] = 0.0318000000;
					g[211] = 10.5500000000; fxg[211] = 1.3879000000; feg[211] = 0.0315000000;
					g[212] = 10.6000000000; fxg[212] = 1.3779000000; feg[212] = 0.0312000000;
					g[213] = 10.6500000000; fxg[213] = 1.3686000000; feg[213] = 0.0309000000;
					g[214] = 10.7000000000; fxg[214] = 1.3601000000; feg[214] = 0.0306000000;
					g[215] = 10.7500000000; fxg[215] = 1.3529000000; feg[215] = 0.0304000000;
					g[216] = 10.8000000000; fxg[216] = 1.3481000000; feg[216] = 0.0301000000;
					g[217] = 10.8500000000; fxg[217] = 1.3458000000; feg[217] = 0.0298000000;
					g[218] = 10.9000000000; fxg[218] = 1.3453000000; feg[218] = 0.0295000000;
					g[219] = 10.9500000000; fxg[219] = 1.3449000000; feg[219] = 0.0293000000;
					g[220] = 11.0000000000; fxg[220] = 1.3432000000; feg[220] = 0.0290000000;
					g[221] = 11.0500000000; fxg[221] = 1.3397000000; feg[221] = 0.0287000000;
					g[222] = 11.1000000000; fxg[222] = 1.3348000000; feg[222] = 0.0285000000;
					g[223] = 11.1500000000; fxg[223] = 1.3282000000; feg[223] = 0.0282000000;
					g[224] = 11.2000000000; fxg[224] = 1.3199000000; feg[224] = 0.0280000000;
					g[225] = 11.2500000000; fxg[225] = 1.3103000000; feg[225] = 0.0278000000;
					g[226] = 11.3000000000; fxg[226] = 1.3009000000; feg[226] = 0.0275000000;
					g[227] = 11.3500000000; fxg[227] = 1.2928000000; feg[227] = 0.0273000000;
					g[228] = 11.4000000000; fxg[228] = 1.2858000000; feg[228] = 0.0270000000;
					g[229] = 11.4500000000; fxg[229] = 1.2792000000; feg[229] = 0.0268000000;
					g[230] = 11.5000000000; fxg[230] = 1.2717000000; feg[230] = 0.0266000000;
					g[231] = 11.5500000000; fxg[231] = 1.2629000000; feg[231] = 0.0264000000;
					g[232] = 11.6000000000; fxg[232] = 1.2535000000; feg[232] = 0.0261000000;
					g[233] = 11.6500000000; fxg[233] = 1.2446000000; feg[233] = 0.0259000000;
					g[234] = 11.7000000000; fxg[234] = 1.2369000000; feg[234] = 0.0257000000;
					g[235] = 11.7500000000; fxg[235] = 1.2300000000; feg[235] = 0.0255000000;
					g[236] = 11.8000000000; fxg[236] = 1.2236000000; feg[236] = 0.0253000000;
					g[237] = 11.8500000000; fxg[237] = 1.2180000000; feg[237] = 0.0251000000;
					g[238] = 11.9000000000; fxg[238] = 1.2138000000; feg[238] = 0.0249000000;
					g[239] = 11.9500000000; fxg[239] = 1.2119000000; feg[239] = 0.0247000000;
					g[240] = 12.0000000000; fxg[240] = 1.2122000000; feg[240] = 0.0245000000;
					break;
				case 39:
					g[0] = 0.0000000000; fxg[0] = 39.0000000000; feg[0] = 12.6684000000;
					g[1] = 0.0500000000; fxg[1] = 38.6787000000; feg[1] = 12.3042000000;
					g[2] = 0.1000000000; fxg[2] = 37.8162000000; feg[2] = 11.3334000000;
					g[3] = 0.1500000000; fxg[3] = 36.6408000000; feg[3] = 10.0383000000;
					g[4] = 0.2000000000; fxg[4] = 35.3652000000; feg[4] = 8.6994000000;
					g[5] = 0.2500000000; fxg[5] = 34.1086000000; feg[5] = 7.4924000000;
					g[6] = 0.3000000000; fxg[6] = 32.9063000000; feg[6] = 6.4820000000;
					g[7] = 0.3500000000; fxg[7] = 31.7529000000; feg[7] = 5.6637000000;
					g[8] = 0.4000000000; fxg[8] = 30.6355000000; feg[8] = 5.0048000000;
					g[9] = 0.4500000000; fxg[9] = 29.5475000000; feg[9] = 4.4688000000;
					g[10] = 0.5000000000; fxg[10] = 28.4899000000; feg[10] = 4.0247000000;
					g[11] = 0.5500000000; fxg[11] = 27.4681000000; feg[11] = 3.6496000000;
					g[12] = 0.6000000000; fxg[12] = 26.4891000000; feg[12] = 3.3270000000;
					g[13] = 0.6500000000; fxg[13] = 25.5583000000; feg[13] = 3.0458000000;
					g[14] = 0.7000000000; fxg[14] = 24.6793000000; feg[14] = 2.7979000000;
					g[15] = 0.7500000000; fxg[15] = 23.8527000000; feg[15] = 2.5780000000;
					g[16] = 0.8000000000; fxg[16] = 23.0774000000; feg[16] = 2.3818000000;
					g[17] = 0.8500000000; fxg[17] = 22.3500000000; feg[17] = 2.2062000000;
					g[18] = 0.9000000000; fxg[18] = 21.6663000000; feg[18] = 2.0487000000;
					g[19] = 0.9500000000; fxg[19] = 21.0214000000; feg[19] = 1.9071000000;
					g[20] = 1.0000000000; fxg[20] = 20.4102000000; feg[20] = 1.7797000000;
					g[21] = 1.0500000000; fxg[21] = 19.8278000000; feg[21] = 1.6648000000;
					g[22] = 1.1000000000; fxg[22] = 19.2697000000; feg[22] = 1.5611000000;
					g[23] = 1.1500000000; fxg[23] = 18.7319000000; feg[23] = 1.4672000000;
					g[24] = 1.2000000000; fxg[24] = 18.2111000000; feg[24] = 1.3821000000;
					g[25] = 1.2500000000; fxg[25] = 17.7046000000; feg[25] = 1.3048000000;
					g[26] = 1.3000000000; fxg[26] = 17.2105000000; feg[26] = 1.2343000000;
					g[27] = 1.3500000000; fxg[27] = 16.7271000000; feg[27] = 1.1700000000;
					g[28] = 1.4000000000; fxg[28] = 16.2536000000; feg[28] = 1.1110000000;
					g[29] = 1.4500000000; fxg[29] = 15.7893000000; feg[29] = 1.0569000000;
					g[30] = 1.5000000000; fxg[30] = 15.3341000000; feg[30] = 1.0070000000;
					g[31] = 1.5500000000; fxg[31] = 14.8880000000; feg[31] = 0.9608000000;
					g[32] = 1.6000000000; fxg[32] = 14.4512000000; feg[32] = 0.9180000000;
					g[33] = 1.6500000000; fxg[33] = 14.0242000000; feg[33] = 0.8783000000;
					g[34] = 1.7000000000; fxg[34] = 13.6073000000; feg[34] = 0.8412000000;
					g[35] = 1.7500000000; fxg[35] = 13.2011000000; feg[35] = 0.8065000000;
					g[36] = 1.8000000000; fxg[36] = 12.8063000000; feg[36] = 0.7740000000;
					g[37] = 1.8500000000; fxg[37] = 12.4231000000; feg[37] = 0.7434000000;
					g[38] = 1.9000000000; fxg[38] = 12.0518000000; feg[38] = 0.7146000000;
					g[39] = 1.9500000000; fxg[39] = 11.6932000000; feg[39] = 0.6875000000;
					g[40] = 2.0000000000; fxg[40] = 11.3477000000; feg[40] = 0.6618000000;
					g[41] = 2.0500000000; fxg[41] = 11.0151000000; feg[41] = 0.6375000000;
					g[42] = 2.1000000000; fxg[42] = 10.6952000000; feg[42] = 0.6145000000;
					g[43] = 2.1500000000; fxg[43] = 10.3889000000; feg[43] = 0.5926000000;
					g[44] = 2.2000000000; fxg[44] = 10.0964000000; feg[44] = 0.5717000000;
					g[45] = 2.2500000000; fxg[45] = 9.8170000000; feg[45] = 0.5519000000;
					g[46] = 2.3000000000; fxg[46] = 9.5498000000; feg[46] = 0.5330000000;
					g[47] = 2.3500000000; fxg[47] = 9.2953000000; feg[47] = 0.5149000000;
					g[48] = 2.4000000000; fxg[48] = 9.0542000000; feg[48] = 0.4977000000;
					g[49] = 2.4500000000; fxg[49] = 8.8260000000; feg[49] = 0.4812000000;
					g[50] = 2.5000000000; fxg[50] = 8.6090000000; feg[50] = 0.4655000000;
					g[51] = 2.5500000000; fxg[51] = 8.4024000000; feg[51] = 0.4505000000;
					g[52] = 2.6000000000; fxg[52] = 8.2067000000; feg[52] = 0.4361000000;
					g[53] = 2.6500000000; fxg[53] = 8.0228000000; feg[53] = 0.4223000000;
					g[54] = 2.7000000000; fxg[54] = 7.8500000000; feg[54] = 0.4091000000;
					g[55] = 2.7500000000; fxg[55] = 7.6864000000; feg[55] = 0.3964000000;
					g[56] = 2.8000000000; fxg[56] = 7.5305000000; feg[56] = 0.3843000000;
					g[57] = 2.8500000000; fxg[57] = 7.3824000000; feg[57] = 0.3727000000;
					g[58] = 2.9000000000; fxg[58] = 7.2434000000; feg[58] = 0.3615000000;
					g[59] = 2.9500000000; fxg[59] = 7.1137000000; feg[59] = 0.3508000000;
					g[60] = 3.0000000000; fxg[60] = 6.9921000000; feg[60] = 0.3405000000;
					g[61] = 3.0500000000; fxg[61] = 6.8761000000; feg[61] = 0.3306000000;
					g[62] = 3.1000000000; fxg[62] = 6.7646000000; feg[62] = 0.3211000000;
					g[63] = 3.1500000000; fxg[63] = 6.6581000000; feg[63] = 0.3120000000;
					g[64] = 3.2000000000; fxg[64] = 6.5580000000; feg[64] = 0.3033000000;
					g[65] = 3.2500000000; fxg[65] = 6.4650000000; feg[65] = 0.2949000000;
					g[66] = 3.3000000000; fxg[66] = 6.3780000000; feg[66] = 0.2868000000;
					g[67] = 3.3500000000; fxg[67] = 6.2945000000; feg[67] = 0.2790000000;
					g[68] = 3.4000000000; fxg[68] = 6.2130000000; feg[68] = 0.2715000000;
					g[69] = 3.4500000000; fxg[69] = 6.1335000000; feg[69] = 0.2644000000;
					g[70] = 3.5000000000; fxg[70] = 6.0571000000; feg[70] = 0.2575000000;
					g[71] = 3.5500000000; fxg[71] = 5.9851000000; feg[71] = 0.2508000000;
					g[72] = 3.6000000000; fxg[72] = 5.9182000000; feg[72] = 0.2444000000;
					g[73] = 3.6500000000; fxg[73] = 5.8550000000; feg[73] = 0.2382000000;
					g[74] = 3.7000000000; fxg[74] = 5.7932000000; feg[74] = 0.2322000000;
					g[75] = 3.7500000000; fxg[75] = 5.7312000000; feg[75] = 0.2265000000;
					g[76] = 3.8000000000; fxg[76] = 5.6692000000; feg[76] = 0.2210000000;
					g[77] = 3.8500000000; fxg[77] = 5.6083000000; feg[77] = 0.2157000000;
					g[78] = 3.9000000000; fxg[78] = 5.5497000000; feg[78] = 0.2105000000;
					g[79] = 3.9500000000; fxg[79] = 5.4944000000; feg[79] = 0.2056000000;
					g[80] = 4.0000000000; fxg[80] = 5.4425000000; feg[80] = 0.2008000000;
					g[81] = 4.0500000000; fxg[81] = 5.3922000000; feg[81] = 0.1962000000;
					g[82] = 4.1000000000; fxg[82] = 5.3411000000; feg[82] = 0.1917000000;
					g[83] = 4.1500000000; fxg[83] = 5.2885000000; feg[83] = 0.1874000000;
					g[84] = 4.2000000000; fxg[84] = 5.2353000000; feg[84] = 0.1832000000;
					g[85] = 4.2500000000; fxg[85] = 5.1822000000; feg[85] = 0.1792000000;
					g[86] = 4.3000000000; fxg[86] = 5.1300000000; feg[86] = 0.1754000000;
					g[87] = 4.3500000000; fxg[87] = 5.0799000000; feg[87] = 0.1716000000;
					g[88] = 4.4000000000; fxg[88] = 5.0327000000; feg[88] = 0.1680000000;
					g[89] = 4.4500000000; fxg[89] = 4.9873000000; feg[89] = 0.1644000000;
					g[90] = 4.5000000000; fxg[90] = 4.9414000000; feg[90] = 0.1610000000;
					g[91] = 4.5500000000; fxg[91] = 4.8933000000; feg[91] = 0.1577000000;
					g[92] = 4.6000000000; fxg[92] = 4.8438000000; feg[92] = 0.1545000000;
					g[93] = 4.6500000000; fxg[93] = 4.7937000000; feg[93] = 0.1514000000;
					g[94] = 4.7000000000; fxg[94] = 4.7436000000; feg[94] = 0.1485000000;
					g[95] = 4.7500000000; fxg[95] = 4.6938000000; feg[95] = 0.1456000000;
					g[96] = 4.8000000000; fxg[96] = 4.6452000000; feg[96] = 0.1427000000;
					g[97] = 4.8500000000; fxg[97] = 4.5992000000; feg[97] = 0.1400000000;
					g[98] = 4.9000000000; fxg[98] = 4.5555000000; feg[98] = 0.1373000000;
					g[99] = 4.9500000000; fxg[99] = 4.5117000000; feg[99] = 0.1348000000;
					g[100] = 5.0000000000; fxg[100] = 4.4658000000; feg[100] = 0.1322000000;
					g[101] = 5.0500000000; fxg[101] = 4.4179000000; feg[101] = 0.1298000000;
					g[102] = 5.1000000000; fxg[102] = 4.3692000000; feg[102] = 0.1275000000;
					g[103] = 5.1500000000; fxg[103] = 4.3209000000; feg[103] = 0.1252000000;
					g[104] = 5.2000000000; fxg[104] = 4.2725000000; feg[104] = 0.1230000000;
					g[105] = 5.2500000000; fxg[105] = 4.2239000000; feg[105] = 0.1208000000;
					g[106] = 5.3000000000; fxg[106] = 4.1761000000; feg[106] = 0.1187000000;
					g[107] = 5.3500000000; fxg[107] = 4.1308000000; feg[107] = 0.1166000000;
					g[108] = 5.4000000000; fxg[108] = 4.0882000000; feg[108] = 0.1146000000;
					g[109] = 5.4500000000; fxg[109] = 4.0465000000; feg[109] = 0.1127000000;
					g[110] = 5.5000000000; fxg[110] = 4.0031000000; feg[110] = 0.1108000000;
					g[111] = 5.5500000000; fxg[111] = 3.9573000000; feg[111] = 0.1089000000;
					g[112] = 5.6000000000; fxg[112] = 3.9103000000; feg[112] = 0.1071000000;
					g[113] = 5.6500000000; fxg[113] = 3.8638000000; feg[113] = 0.1054000000;
					g[114] = 5.7000000000; fxg[114] = 3.8182000000; feg[114] = 0.1037000000;
					g[115] = 5.7500000000; fxg[115] = 3.7726000000; feg[115] = 0.1020000000;
					g[116] = 5.8000000000; fxg[116] = 3.7265000000; feg[116] = 0.1004000000;
					g[117] = 5.8500000000; fxg[117] = 3.6808000000; feg[117] = 0.0988000000;
					g[118] = 5.9000000000; fxg[118] = 3.6374000000; feg[118] = 0.0973000000;
					g[119] = 5.9500000000; fxg[119] = 3.5971000000; feg[119] = 0.0957000000;
					g[120] = 6.0000000000; fxg[120] = 3.5588000000; feg[120] = 0.0942000000;
					g[121] = 6.0500000000; fxg[121] = 3.5200000000; feg[121] = 0.0928000000;
					g[122] = 6.1000000000; fxg[122] = 3.4786000000; feg[122] = 0.0914000000;
					g[123] = 6.1500000000; fxg[123] = 3.4351000000; feg[123] = 0.0900000000;
					g[124] = 6.2000000000; fxg[124] = 3.3915000000; feg[124] = 0.0887000000;
					g[125] = 6.2500000000; fxg[125] = 3.3495000000; feg[125] = 0.0874000000;
					g[126] = 6.3000000000; fxg[126] = 3.3088000000; feg[126] = 0.0861000000;
					g[127] = 6.3500000000; fxg[127] = 3.2681000000; feg[127] = 0.0848000000;
					g[128] = 6.4000000000; fxg[128] = 3.2266000000; feg[128] = 0.0836000000;
					g[129] = 6.4500000000; fxg[129] = 3.1850000000; feg[129] = 0.0824000000;
					g[130] = 6.5000000000; fxg[130] = 3.1451000000; feg[130] = 0.0812000000;
					g[131] = 6.5500000000; fxg[131] = 3.1084000000; feg[131] = 0.0801000000;
					g[132] = 6.6000000000; fxg[132] = 3.0749000000; feg[132] = 0.0790000000;
					g[133] = 6.6500000000; fxg[133] = 3.0424000000; feg[133] = 0.0778000000;
					g[134] = 6.7000000000; fxg[134] = 3.0085000000; feg[134] = 0.0768000000;
					g[135] = 6.7500000000; fxg[135] = 2.9718000000; feg[135] = 0.0757000000;
					g[136] = 6.8000000000; fxg[136] = 2.9333000000; feg[136] = 0.0747000000;
					g[137] = 6.8500000000; fxg[137] = 2.8952000000; feg[137] = 0.0737000000;
					g[138] = 6.9000000000; fxg[138] = 2.8590000000; feg[138] = 0.0727000000;
					g[139] = 6.9500000000; fxg[139] = 2.8247000000; feg[139] = 0.0717000000;
					g[140] = 7.0000000000; fxg[140] = 2.7907000000; feg[140] = 0.0707000000;
					g[141] = 7.0500000000; fxg[141] = 2.7560000000; feg[141] = 0.0698000000;
					g[142] = 7.1000000000; fxg[142] = 2.7206000000; feg[142] = 0.0689000000;
					g[143] = 7.1500000000; fxg[143] = 2.6857000000; feg[143] = 0.0680000000;
					g[144] = 7.2000000000; fxg[144] = 2.6532000000; feg[144] = 0.0671000000;
					g[145] = 7.2500000000; fxg[145] = 2.6240000000; feg[145] = 0.0663000000;
					g[146] = 7.3000000000; fxg[146] = 2.5980000000; feg[146] = 0.0654000000;
					g[147] = 7.3500000000; fxg[147] = 2.5728000000; feg[147] = 0.0646000000;
					g[148] = 7.4000000000; fxg[148] = 2.5461000000; feg[148] = 0.0637000000;
					g[149] = 7.4500000000; fxg[149] = 2.5166000000; feg[149] = 0.0629000000;
					g[150] = 7.5000000000; fxg[150] = 2.4850000000; feg[150] = 0.0621000000;
					g[151] = 7.5500000000; fxg[151] = 2.4530000000; feg[151] = 0.0614000000;
					g[152] = 7.6000000000; fxg[152] = 2.4228000000; feg[152] = 0.0606000000;
					g[153] = 7.6500000000; fxg[153] = 2.3950000000; feg[153] = 0.0599000000;
					g[154] = 7.7000000000; fxg[154] = 2.3684000000; feg[154] = 0.0591000000;
					g[155] = 7.7500000000; fxg[155] = 2.3415000000; feg[155] = 0.0584000000;
					g[156] = 7.8000000000; fxg[156] = 2.3137000000; feg[156] = 0.0577000000;
					g[157] = 7.8500000000; fxg[157] = 2.2853000000; feg[157] = 0.0570000000;
					g[158] = 7.9000000000; fxg[158] = 2.2576000000; feg[158] = 0.0564000000;
					g[159] = 7.9500000000; fxg[159] = 2.2318000000; feg[159] = 0.0557000000;
					g[160] = 8.0000000000; fxg[160] = 2.2094000000; feg[160] = 0.0550000000;
					g[161] = 8.0500000000; fxg[161] = 2.1903000000; feg[161] = 0.0544000000;
					g[162] = 8.1000000000; fxg[162] = 2.1728000000; feg[162] = 0.0537000000;
					g[163] = 8.1500000000; fxg[163] = 2.1548000000; feg[163] = 0.0531000000;
					g[164] = 8.2000000000; fxg[164] = 2.1344000000; feg[164] = 0.0525000000;
					g[165] = 8.2500000000; fxg[165] = 2.1113000000; feg[165] = 0.0519000000;
					g[166] = 8.3000000000; fxg[166] = 2.0863000000; feg[166] = 0.0513000000;
					g[167] = 8.3500000000; fxg[167] = 2.0614000000; feg[167] = 0.0507000000;
					g[168] = 8.4000000000; fxg[168] = 2.0382000000; feg[168] = 0.0501000000;
					g[169] = 8.4500000000; fxg[169] = 2.0174000000; feg[169] = 0.0496000000;
					g[170] = 8.5000000000; fxg[170] = 1.9977000000; feg[170] = 0.0490000000;
					g[171] = 8.5500000000; fxg[171] = 1.9778000000; feg[171] = 0.0485000000;
					g[172] = 8.6000000000; fxg[172] = 1.9569000000; feg[172] = 0.0479000000;
					g[173] = 8.6500000000; fxg[173] = 1.9353000000; feg[173] = 0.0474000000;
					g[174] = 8.7000000000; fxg[174] = 1.9140000000; feg[174] = 0.0469000000;
					g[175] = 8.7500000000; fxg[175] = 1.8937000000; feg[175] = 0.0464000000;
					g[176] = 8.8000000000; fxg[176] = 1.8757000000; feg[176] = 0.0459000000;
					g[177] = 8.8500000000; fxg[177] = 1.8609000000; feg[177] = 0.0454000000;
					g[178] = 8.9000000000; fxg[178] = 1.8491000000; feg[178] = 0.0449000000;
					g[179] = 8.9500000000; fxg[179] = 1.8389000000; feg[179] = 0.0444000000;
					g[180] = 9.0000000000; fxg[180] = 1.8280000000; feg[180] = 0.0439000000;
					g[181] = 9.0500000000; fxg[181] = 1.8150000000; feg[181] = 0.0435000000;
					g[182] = 9.1000000000; fxg[182] = 1.7993000000; feg[182] = 0.0430000000;
					g[183] = 9.1500000000; fxg[183] = 1.7814000000; feg[183] = 0.0426000000;
					g[184] = 9.2000000000; fxg[184] = 1.7624000000; feg[184] = 0.0421000000;
					g[185] = 9.2500000000; fxg[185] = 1.7441000000; feg[185] = 0.0417000000;
					g[186] = 9.3000000000; fxg[186] = 1.7279000000; feg[186] = 0.0413000000;
					g[187] = 9.3500000000; fxg[187] = 1.7134000000; feg[187] = 0.0408000000;
					g[188] = 9.4000000000; fxg[188] = 1.6995000000; feg[188] = 0.0404000000;
					g[189] = 9.4500000000; fxg[189] = 1.6849000000; feg[189] = 0.0400000000;
					g[190] = 9.5000000000; fxg[190] = 1.6694000000; feg[190] = 0.0396000000;
					g[191] = 9.5500000000; fxg[191] = 1.6534000000; feg[191] = 0.0392000000;
					g[192] = 9.6000000000; fxg[192] = 1.6378000000; feg[192] = 0.0388000000;
					g[193] = 9.6500000000; fxg[193] = 1.6229000000; feg[193] = 0.0384000000;
					g[194] = 9.7000000000; fxg[194] = 1.6095000000; feg[194] = 0.0380000000;
					g[195] = 9.7500000000; fxg[195] = 1.5985000000; feg[195] = 0.0377000000;
					g[196] = 9.8000000000; fxg[196] = 1.5907000000; feg[196] = 0.0373000000;
					g[197] = 9.8500000000; fxg[197] = 1.5854000000; feg[197] = 0.0369000000;
					g[198] = 9.9000000000; fxg[198] = 1.5810000000; feg[198] = 0.0366000000;
					g[199] = 9.9500000000; fxg[199] = 1.5755000000; feg[199] = 0.0362000000;
					g[200] = 10.0000000000; fxg[200] = 1.5679000000; feg[200] = 0.0358000000;
					g[201] = 10.0500000000; fxg[201] = 1.5580000000; feg[201] = 0.0355000000;
					g[202] = 10.1000000000; fxg[202] = 1.5458000000; feg[202] = 0.0352000000;
					g[203] = 10.1500000000; fxg[203] = 1.5320000000; feg[203] = 0.0348000000;
					g[204] = 10.2000000000; fxg[204] = 1.5181000000; feg[204] = 0.0345000000;
					g[205] = 10.2500000000; fxg[205] = 1.5054000000; feg[205] = 0.0342000000;
					g[206] = 10.3000000000; fxg[206] = 1.4946000000; feg[206] = 0.0338000000;
					g[207] = 10.3500000000; fxg[207] = 1.4849000000; feg[207] = 0.0335000000;
					g[208] = 10.4000000000; fxg[208] = 1.4750000000; feg[208] = 0.0332000000;
					g[209] = 10.4500000000; fxg[209] = 1.4640000000; feg[209] = 0.0329000000;
					g[210] = 10.5000000000; fxg[210] = 1.4521000000; feg[210] = 0.0326000000;
					g[211] = 10.5500000000; fxg[211] = 1.4402000000; feg[211] = 0.0323000000;
					g[212] = 10.6000000000; fxg[212] = 1.4288000000; feg[212] = 0.0320000000;
					g[213] = 10.6500000000; fxg[213] = 1.4181000000; feg[213] = 0.0317000000;
					g[214] = 10.7000000000; fxg[214] = 1.4084000000; feg[214] = 0.0314000000;
					g[215] = 10.7500000000; fxg[215] = 1.4004000000; feg[215] = 0.0311000000;
					g[216] = 10.8000000000; fxg[216] = 1.3950000000; feg[216] = 0.0309000000;
					g[217] = 10.8500000000; fxg[217] = 1.3924000000; feg[217] = 0.0306000000;
					g[218] = 10.9000000000; fxg[218] = 1.3916000000; feg[218] = 0.0303000000;
					g[219] = 10.9500000000; fxg[219] = 1.3911000000; feg[219] = 0.0300000000;
					g[220] = 11.0000000000; fxg[220] = 1.3893000000; feg[220] = 0.0298000000;
					g[221] = 11.0500000000; fxg[221] = 1.3854000000; feg[221] = 0.0295000000;
					g[222] = 11.1000000000; fxg[222] = 1.3795000000; feg[222] = 0.0292000000;
					g[223] = 11.1500000000; fxg[223] = 1.3717000000; feg[223] = 0.0290000000;
					g[224] = 11.2000000000; fxg[224] = 1.3620000000; feg[224] = 0.0287000000;
					g[225] = 11.2500000000; fxg[225] = 1.3514000000; feg[225] = 0.0285000000;
					g[226] = 11.3000000000; fxg[226] = 1.3412000000; feg[226] = 0.0282000000;
					g[227] = 11.3500000000; fxg[227] = 1.3325000000; feg[227] = 0.0280000000;
					g[228] = 11.4000000000; fxg[228] = 1.3252000000; feg[228] = 0.0278000000;
					g[229] = 11.4500000000; fxg[229] = 1.3184000000; feg[229] = 0.0275000000;
					g[230] = 11.5000000000; fxg[230] = 1.3110000000; feg[230] = 0.0273000000;
					g[231] = 11.5500000000; fxg[231] = 1.3023000000; feg[231] = 0.0271000000;
					g[232] = 11.6000000000; fxg[232] = 1.2928000000; feg[232] = 0.0268000000;
					g[233] = 11.6500000000; fxg[233] = 1.2834000000; feg[233] = 0.0266000000;
					g[234] = 11.7000000000; fxg[234] = 1.2747000000; feg[234] = 0.0264000000;
					g[235] = 11.7500000000; fxg[235] = 1.2667000000; feg[235] = 0.0262000000;
					g[236] = 11.8000000000; fxg[236] = 1.2594000000; feg[236] = 0.0259000000;
					g[237] = 11.8500000000; fxg[237] = 1.2530000000; feg[237] = 0.0257000000;
					g[238] = 11.9000000000; fxg[238] = 1.2485000000; feg[238] = 0.0255000000;
					g[239] = 11.9500000000; fxg[239] = 1.2464000000; feg[239] = 0.0253000000;
					g[240] = 12.0000000000; fxg[240] = 1.2468000000; feg[240] = 0.0251000000;
					break;
				case 40:
					g[0] = 0.0000000000; fxg[0] = 40.0000000000; feg[0] = 12.1788000000;
					g[1] = 0.0500000000; fxg[1] = 39.6899000000; feg[1] = 11.8756000000;
					g[2] = 0.1000000000; fxg[2] = 38.8451000000; feg[2] = 11.0564000000;
					g[3] = 0.1500000000; fxg[3] = 37.6648000000; feg[3] = 9.9358000000;
					g[4] = 0.2000000000; fxg[4] = 36.3488000000; feg[4] = 8.7386000000;
					g[5] = 0.2500000000; fxg[5] = 35.0255000000; feg[5] = 7.6197000000;
					g[6] = 0.3000000000; fxg[6] = 33.7489000000; feg[6] = 6.6495000000;
					g[7] = 0.3500000000; fxg[7] = 32.5281000000; feg[7] = 5.8393000000;
					g[8] = 0.4000000000; fxg[8] = 31.3569000000; feg[8] = 5.1715000000;
					g[9] = 0.4500000000; fxg[9] = 30.2287000000; feg[9] = 4.6195000000;
					g[10] = 0.5000000000; fxg[10] = 29.1413000000; feg[10] = 4.1582000000;
					g[11] = 0.5500000000; fxg[11] = 28.0963000000; feg[11] = 3.7673000000;
					g[12] = 0.6000000000; fxg[12] = 27.0975000000; feg[12] = 3.4312000000;
					g[13] = 0.6500000000; fxg[13] = 26.1484000000; feg[13] = 3.1387000000;
					g[14] = 0.7000000000; fxg[14] = 25.2514000000; feg[14] = 2.8815000000;
					g[15] = 0.7500000000; fxg[15] = 24.4072000000; feg[15] = 2.6538000000;
					g[16] = 0.8000000000; fxg[16] = 23.6149000000; feg[16] = 2.4510000000;
					g[17] = 0.8500000000; fxg[17] = 22.8720000000; feg[17] = 2.2695000000;
					g[18] = 0.9000000000; fxg[18] = 22.1748000000; feg[18] = 2.1068000000;
					g[19] = 0.9500000000; fxg[19] = 21.5191000000; feg[19] = 1.9604000000;
					g[20] = 1.0000000000; fxg[20] = 20.9000000000; feg[20] = 1.8285000000;
					g[21] = 1.0500000000; fxg[21] = 20.3129000000; feg[21] = 1.7095000000;
					g[22] = 1.1000000000; fxg[22] = 19.7533000000; feg[22] = 1.6019000000;
					g[23] = 1.1500000000; fxg[23] = 19.2169000000; feg[23] = 1.5045000000;
					g[24] = 1.2000000000; fxg[24] = 18.7000000000; feg[24] = 1.4161000000;
					g[25] = 1.2500000000; fxg[25] = 18.1996000000; feg[25] = 1.3357000000;
					g[26] = 1.3000000000; fxg[26] = 17.7131000000; feg[26] = 1.2625000000;
					g[27] = 1.3500000000; fxg[27] = 17.2385000000; feg[27] = 1.1956000000;
					g[28] = 1.4000000000; fxg[28] = 16.7741000000; feg[28] = 1.1344000000;
					g[29] = 1.4500000000; fxg[29] = 16.3191000000; feg[29] = 1.0783000000;
					g[30] = 1.5000000000; fxg[30] = 15.8726000000; feg[30] = 1.0266000000;
					g[31] = 1.5500000000; fxg[31] = 15.4344000000; feg[31] = 0.9789000000;
					g[32] = 1.6000000000; fxg[32] = 15.0043000000; feg[32] = 0.9347000000;
					g[33] = 1.6500000000; fxg[33] = 14.5825000000; feg[33] = 0.8938000000;
					g[34] = 1.7000000000; fxg[34] = 14.1692000000; feg[34] = 0.8557000000;
					g[35] = 1.7500000000; fxg[35] = 13.7647000000; feg[35] = 0.8201000000;
					g[36] = 1.8000000000; fxg[36] = 13.3698000000; feg[36] = 0.7869000000;
					g[37] = 1.8500000000; fxg[37] = 12.9845000000; feg[37] = 0.7557000000;
					g[38] = 1.9000000000; fxg[38] = 12.6095000000; feg[38] = 0.7264000000;
					g[39] = 1.9500000000; fxg[39] = 12.2452000000; feg[39] = 0.6988000000;
					g[40] = 2.0000000000; fxg[40] = 11.8922000000; feg[40] = 0.6727000000;
					g[41] = 2.0500000000; fxg[41] = 11.5506000000; feg[41] = 0.6481000000;
					g[42] = 2.1000000000; fxg[42] = 11.2204000000; feg[42] = 0.6248000000;
					g[43] = 2.1500000000; fxg[43] = 10.9024000000; feg[43] = 0.6026000000;
					g[44] = 2.2000000000; fxg[44] = 10.5968000000; feg[44] = 0.5816000000;
					g[45] = 2.2500000000; fxg[45] = 10.3033000000; feg[45] = 0.5616000000;
					g[46] = 2.3000000000; fxg[46] = 10.0215000000; feg[46] = 0.5425000000;
					g[47] = 2.3500000000; fxg[47] = 9.7518000000; feg[47] = 0.5244000000;
					g[48] = 2.4000000000; fxg[48] = 9.4947000000; feg[48] = 0.5070000000;
					g[49] = 2.4500000000; fxg[49] = 9.2499000000; feg[49] = 0.4904000000;
					g[50] = 2.5000000000; fxg[50] = 9.0163000000; feg[50] = 0.4746000000;
					g[51] = 2.5500000000; fxg[51] = 8.7932000000; feg[51] = 0.4594000000;
					g[52] = 2.6000000000; fxg[52] = 8.5812000000; feg[52] = 0.4450000000;
					g[53] = 2.6500000000; fxg[53] = 8.3808000000; feg[53] = 0.4311000000;
					g[54] = 2.7000000000; fxg[54] = 8.1915000000; feg[54] = 0.4177000000;
					g[55] = 2.7500000000; fxg[55] = 8.0118000000; feg[55] = 0.4049000000;
					g[56] = 2.8000000000; fxg[56] = 7.8404000000; feg[56] = 0.3927000000;
					g[57] = 2.8500000000; fxg[57] = 7.6776000000; feg[57] = 0.3810000000;
					g[58] = 2.9000000000; fxg[58] = 7.5242000000; feg[58] = 0.3697000000;
					g[59] = 2.9500000000; fxg[59] = 7.3804000000; feg[59] = 0.3588000000;
					g[60] = 3.0000000000; fxg[60] = 7.2450000000; feg[60] = 0.3484000000;
					g[61] = 3.0500000000; fxg[61] = 7.1161000000; feg[61] = 0.3384000000;
					g[62] = 3.1000000000; fxg[62] = 6.9927000000; feg[62] = 0.3288000000;
					g[63] = 3.1500000000; fxg[63] = 6.8752000000; feg[63] = 0.3196000000;
					g[64] = 3.2000000000; fxg[64] = 6.7646000000; feg[64] = 0.3107000000;
					g[65] = 3.2500000000; fxg[65] = 6.6614000000; feg[65] = 0.3022000000;
					g[66] = 3.3000000000; fxg[66] = 6.5647000000; feg[66] = 0.2939000000;
					g[67] = 3.3500000000; fxg[67] = 6.4723000000; feg[67] = 0.2860000000;
					g[68] = 3.4000000000; fxg[68] = 6.3828000000; feg[68] = 0.2784000000;
					g[69] = 3.4500000000; fxg[69] = 6.2961000000; feg[69] = 0.2711000000;
					g[70] = 3.5000000000; fxg[70] = 6.2133000000; feg[70] = 0.2640000000;
					g[71] = 3.5500000000; fxg[71] = 6.1354000000; feg[71] = 0.2573000000;
					g[72] = 3.6000000000; fxg[72] = 6.0629000000; feg[72] = 0.2507000000;
					g[73] = 3.6500000000; fxg[73] = 5.9945000000; feg[73] = 0.2444000000;
					g[74] = 3.7000000000; fxg[74] = 5.9280000000; feg[74] = 0.2383000000;
					g[75] = 3.7500000000; fxg[75] = 5.8621000000; feg[75] = 0.2324000000;
					g[76] = 3.8000000000; fxg[76] = 5.7969000000; feg[76] = 0.2268000000;
					g[77] = 3.8500000000; fxg[77] = 5.7333000000; feg[77] = 0.2213000000;
					g[78] = 3.9000000000; fxg[78] = 5.6724000000; feg[78] = 0.2161000000;
					g[79] = 3.9500000000; fxg[79] = 5.6152000000; feg[79] = 0.2110000000;
					g[80] = 4.0000000000; fxg[80] = 5.5615000000; feg[80] = 0.2061000000;
					g[81] = 4.0500000000; fxg[81] = 5.5096000000; feg[81] = 0.2013000000;
					g[82] = 4.1000000000; fxg[82] = 5.4575000000; feg[82] = 0.1967000000;
					g[83] = 4.1500000000; fxg[83] = 5.4043000000; feg[83] = 0.1923000000;
					g[84] = 4.2000000000; fxg[84] = 5.3507000000; feg[84] = 0.1880000000;
					g[85] = 4.2500000000; fxg[85] = 5.2975000000; feg[85] = 0.1839000000;
					g[86] = 4.3000000000; fxg[86] = 5.2455000000; feg[86] = 0.1799000000;
					g[87] = 4.3500000000; fxg[87] = 5.1960000000; feg[87] = 0.1761000000;
					g[88] = 4.4000000000; fxg[88] = 5.1493000000; feg[88] = 0.1723000000;
					g[89] = 4.4500000000; fxg[89] = 5.1044000000; feg[89] = 0.1687000000;
					g[90] = 4.5000000000; fxg[90] = 5.0592000000; feg[90] = 0.1652000000;
					g[91] = 4.5500000000; fxg[91] = 5.0123000000; feg[91] = 0.1618000000;
					g[92] = 4.6000000000; fxg[92] = 4.9639000000; feg[92] = 0.1585000000;
					g[93] = 4.6500000000; fxg[93] = 4.9148000000; feg[93] = 0.1553000000;
					g[94] = 4.7000000000; fxg[94] = 4.8658000000; feg[94] = 0.1523000000;
					g[95] = 4.7500000000; fxg[95] = 4.8172000000; feg[95] = 0.1493000000;
					g[96] = 4.8000000000; fxg[96] = 4.7703000000; feg[96] = 0.1464000000;
					g[97] = 4.8500000000; fxg[97] = 4.7259000000; feg[97] = 0.1436000000;
					g[98] = 4.9000000000; fxg[98] = 4.6835000000; feg[98] = 0.1408000000;
					g[99] = 4.9500000000; fxg[99] = 4.6411000000; feg[99] = 0.1382000000;
					g[100] = 5.0000000000; fxg[100] = 4.5969000000; feg[100] = 0.1356000000;
					g[101] = 5.0500000000; fxg[101] = 4.5506000000; feg[101] = 0.1331000000;
					g[102] = 5.1000000000; fxg[102] = 4.5034000000; feg[102] = 0.1307000000;
					g[103] = 5.1500000000; fxg[103] = 4.4560000000; feg[103] = 0.1283000000;
					g[104] = 5.2000000000; fxg[104] = 4.4086000000; feg[104] = 0.1260000000;
					g[105] = 5.2500000000; fxg[105] = 4.3612000000; feg[105] = 0.1238000000;
					g[106] = 5.3000000000; fxg[106] = 4.3151000000; feg[106] = 0.1216000000;
					g[107] = 5.3500000000; fxg[107] = 4.2713000000; feg[107] = 0.1195000000;
					g[108] = 5.4000000000; fxg[108] = 4.2299000000; feg[108] = 0.1174000000;
					g[109] = 5.4500000000; fxg[109] = 4.1893000000; feg[109] = 0.1154000000;
					g[110] = 5.5000000000; fxg[110] = 4.1472000000; feg[110] = 0.1135000000;
					g[111] = 5.5500000000; fxg[111] = 4.1028000000; feg[111] = 0.1116000000;
					g[112] = 5.6000000000; fxg[112] = 4.0569000000; feg[112] = 0.1097000000;
					g[113] = 5.6500000000; fxg[113] = 4.0111000000; feg[113] = 0.1079000000;
					g[114] = 5.7000000000; fxg[114] = 3.9657000000; feg[114] = 0.1062000000;
					g[115] = 5.7500000000; fxg[115] = 3.9203000000; feg[115] = 0.1045000000;
					g[116] = 5.8000000000; fxg[116] = 3.8747000000; feg[116] = 0.1028000000;
					g[117] = 5.8500000000; fxg[117] = 3.8298000000; feg[117] = 0.1012000000;
					g[118] = 5.9000000000; fxg[118] = 3.7872000000; feg[118] = 0.0996000000;
					g[119] = 5.9500000000; fxg[119] = 3.7475000000; feg[119] = 0.0980000000;
					g[120] = 6.0000000000; fxg[120] = 3.7096000000; feg[120] = 0.0965000000;
					g[121] = 6.0500000000; fxg[121] = 3.6711000000; feg[121] = 0.0950000000;
					g[122] = 6.1000000000; fxg[122] = 3.6303000000; feg[122] = 0.0936000000;
					g[123] = 6.1500000000; fxg[123] = 3.5874000000; feg[123] = 0.0922000000;
					g[124] = 6.2000000000; fxg[124] = 3.5440000000; feg[124] = 0.0908000000;
					g[125] = 6.2500000000; fxg[125] = 3.5015000000; feg[125] = 0.0895000000;
					g[126] = 6.3000000000; fxg[126] = 3.4600000000; feg[126] = 0.0881000000;
					g[127] = 6.3500000000; fxg[127] = 3.4186000000; feg[127] = 0.0869000000;
					g[128] = 6.4000000000; fxg[128] = 3.3766000000; feg[128] = 0.0856000000;
					g[129] = 6.4500000000; fxg[129] = 3.3349000000; feg[129] = 0.0844000000;
					g[130] = 6.5000000000; fxg[130] = 3.2950000000; feg[130] = 0.0832000000;
					g[131] = 6.5500000000; fxg[131] = 3.2582000000; feg[131] = 0.0820000000;
					g[132] = 6.6000000000; fxg[132] = 3.2241000000; feg[132] = 0.0808000000;
					g[133] = 6.6500000000; fxg[133] = 3.1911000000; feg[133] = 0.0797000000;
					g[134] = 6.7000000000; fxg[134] = 3.1567000000; feg[134] = 0.0786000000;
					g[135] = 6.7500000000; fxg[135] = 3.1198000000; feg[135] = 0.0775000000;
					g[136] = 6.8000000000; fxg[136] = 3.0810000000; feg[136] = 0.0764000000;
					g[137] = 6.8500000000; fxg[137] = 3.0423000000; feg[137] = 0.0754000000;
					g[138] = 6.9000000000; fxg[138] = 3.0050000000; feg[138] = 0.0744000000;
					g[139] = 6.9500000000; fxg[139] = 2.9692000000; feg[139] = 0.0734000000;
					g[140] = 7.0000000000; fxg[140] = 2.9337000000; feg[140] = 0.0724000000;
					g[141] = 7.0500000000; fxg[141] = 2.8976000000; feg[141] = 0.0715000000;
					g[142] = 7.1000000000; fxg[142] = 2.8612000000; feg[142] = 0.0705000000;
					g[143] = 7.1500000000; fxg[143] = 2.8255000000; feg[143] = 0.0696000000;
					g[144] = 7.2000000000; fxg[144] = 2.7922000000; feg[144] = 0.0687000000;
					g[145] = 7.2500000000; fxg[145] = 2.7621000000; feg[145] = 0.0678000000;
					g[146] = 7.3000000000; fxg[146] = 2.7349000000; feg[146] = 0.0669000000;
					g[147] = 7.3500000000; fxg[147] = 2.7086000000; feg[147] = 0.0661000000;
					g[148] = 7.4000000000; fxg[148] = 2.6808000000; feg[148] = 0.0652000000;
					g[149] = 7.4500000000; fxg[149] = 2.6503000000; feg[149] = 0.0644000000;
					g[150] = 7.5000000000; fxg[150] = 2.6178000000; feg[150] = 0.0636000000;
					g[151] = 7.5500000000; fxg[151] = 2.5848000000; feg[151] = 0.0628000000;
					g[152] = 7.6000000000; fxg[152] = 2.5533000000; feg[152] = 0.0621000000;
					g[153] = 7.6500000000; fxg[153] = 2.5237000000; feg[153] = 0.0613000000;
					g[154] = 7.7000000000; fxg[154] = 2.4952000000; feg[154] = 0.0606000000;
					g[155] = 7.7500000000; fxg[155] = 2.4666000000; feg[155] = 0.0598000000;
					g[156] = 7.8000000000; fxg[156] = 2.4372000000; feg[156] = 0.0591000000;
					g[157] = 7.8500000000; fxg[157] = 2.4074000000; feg[157] = 0.0584000000;
					g[158] = 7.9000000000; fxg[158] = 2.3783000000; feg[158] = 0.0577000000;
					g[159] = 7.9500000000; fxg[159] = 2.3515000000; feg[159] = 0.0570000000;
					g[160] = 8.0000000000; fxg[160] = 2.3278000000; feg[160] = 0.0564000000;
					g[161] = 8.0500000000; fxg[161] = 2.3073000000; feg[161] = 0.0557000000;
					g[162] = 8.1000000000; fxg[162] = 2.2885000000; feg[162] = 0.0550000000;
					g[163] = 8.1500000000; fxg[163] = 2.2690000000; feg[163] = 0.0544000000;
					g[164] = 8.2000000000; fxg[164] = 2.2473000000; feg[164] = 0.0538000000;
					g[165] = 8.2500000000; fxg[165] = 2.2228000000; feg[165] = 0.0531000000;
					g[166] = 8.3000000000; fxg[166] = 2.1966000000; feg[166] = 0.0525000000;
					g[167] = 8.3500000000; fxg[167] = 2.1704000000; feg[167] = 0.0519000000;
					g[168] = 8.4000000000; fxg[168] = 2.1457000000; feg[168] = 0.0514000000;
					g[169] = 8.4500000000; fxg[169] = 2.1232000000; feg[169] = 0.0508000000;
					g[170] = 8.5000000000; fxg[170] = 2.1018000000; feg[170] = 0.0502000000;
					g[171] = 8.5500000000; fxg[171] = 2.0802000000; feg[171] = 0.0497000000;
					g[172] = 8.6000000000; fxg[172] = 2.0578000000; feg[172] = 0.0491000000;
					g[173] = 8.6500000000; fxg[173] = 2.0348000000; feg[173] = 0.0486000000;
					g[174] = 8.7000000000; fxg[174] = 2.0119000000; feg[174] = 0.0480000000;
					g[175] = 8.7500000000; fxg[175] = 1.9903000000; feg[175] = 0.0475000000;
					g[176] = 8.8000000000; fxg[176] = 1.9710000000; feg[176] = 0.0470000000;
					g[177] = 8.8500000000; fxg[177] = 1.9550000000; feg[177] = 0.0465000000;
					g[178] = 8.9000000000; fxg[178] = 1.9419000000; feg[178] = 0.0460000000;
					g[179] = 8.9500000000; fxg[179] = 1.9304000000; feg[179] = 0.0455000000;
					g[180] = 9.0000000000; fxg[180] = 1.9183000000; feg[180] = 0.0450000000;
					g[181] = 9.0500000000; fxg[181] = 1.9039000000; feg[181] = 0.0445000000;
					g[182] = 9.1000000000; fxg[182] = 1.8869000000; feg[182] = 0.0441000000;
					g[183] = 9.1500000000; fxg[183] = 1.8676000000; feg[183] = 0.0436000000;
					g[184] = 9.2000000000; fxg[184] = 1.8473000000; feg[184] = 0.0432000000;
					g[185] = 9.2500000000; fxg[185] = 1.8277000000; feg[185] = 0.0427000000;
					g[186] = 9.3000000000; fxg[186] = 1.8101000000; feg[186] = 0.0423000000;
					g[187] = 9.3500000000; fxg[187] = 1.7942000000; feg[187] = 0.0418000000;
					g[188] = 9.4000000000; fxg[188] = 1.7790000000; feg[188] = 0.0414000000;
					g[189] = 9.4500000000; fxg[189] = 1.7633000000; feg[189] = 0.0410000000;
					g[190] = 9.5000000000; fxg[190] = 1.7466000000; feg[190] = 0.0406000000;
					g[191] = 9.5500000000; fxg[191] = 1.7294000000; feg[191] = 0.0402000000;
					g[192] = 9.6000000000; fxg[192] = 1.7123000000; feg[192] = 0.0398000000;
					g[193] = 9.6500000000; fxg[193] = 1.6961000000; feg[193] = 0.0394000000;
					g[194] = 9.7000000000; fxg[194] = 1.6815000000; feg[194] = 0.0390000000;
					g[195] = 9.7500000000; fxg[195] = 1.6696000000; feg[195] = 0.0386000000;
					g[196] = 9.8000000000; fxg[196] = 1.6609000000; feg[196] = 0.0382000000;
					g[197] = 9.8500000000; fxg[197] = 1.6546000000; feg[197] = 0.0378000000;
					g[198] = 9.9000000000; fxg[198] = 1.6493000000; feg[198] = 0.0375000000;
					g[199] = 9.9500000000; fxg[199] = 1.6429000000; feg[199] = 0.0371000000;
					g[200] = 10.0000000000; fxg[200] = 1.6343000000; feg[200] = 0.0367000000;
					g[201] = 10.0500000000; fxg[201] = 1.6232000000; feg[201] = 0.0364000000;
					g[202] = 10.1000000000; fxg[202] = 1.6097000000; feg[202] = 0.0360000000;
					g[203] = 10.1500000000; fxg[203] = 1.5947000000; feg[203] = 0.0357000000;
					g[204] = 10.2000000000; fxg[204] = 1.5797000000; feg[204] = 0.0354000000;
					g[205] = 10.2500000000; fxg[205] = 1.5660000000; feg[205] = 0.0350000000;
					g[206] = 10.3000000000; fxg[206] = 1.5542000000; feg[206] = 0.0347000000;
					g[207] = 10.3500000000; fxg[207] = 1.5435000000; feg[207] = 0.0344000000;
					g[208] = 10.4000000000; fxg[208] = 1.5328000000; feg[208] = 0.0340000000;
					g[209] = 10.4500000000; fxg[209] = 1.5212000000; feg[209] = 0.0337000000;
					g[210] = 10.5000000000; fxg[210] = 1.5087000000; feg[210] = 0.0334000000;
					g[211] = 10.5500000000; fxg[211] = 1.4959000000; feg[211] = 0.0331000000;
					g[212] = 10.6000000000; fxg[212] = 1.4833000000; feg[212] = 0.0328000000;
					g[213] = 10.6500000000; fxg[213] = 1.4714000000; feg[213] = 0.0325000000;
					g[214] = 10.7000000000; fxg[214] = 1.4607000000; feg[214] = 0.0322000000;
					g[215] = 10.7500000000; fxg[215] = 1.4520000000; feg[215] = 0.0319000000;
					g[216] = 10.8000000000; fxg[216] = 1.4460000000; feg[216] = 0.0316000000;
					g[217] = 10.8500000000; fxg[217] = 1.4429000000; feg[217] = 0.0314000000;
					g[218] = 10.9000000000; fxg[218] = 1.4417000000; feg[218] = 0.0311000000;
					g[219] = 10.9500000000; fxg[219] = 1.4407000000; feg[219] = 0.0308000000;
					g[220] = 11.0000000000; fxg[220] = 1.4384000000; feg[220] = 0.0305000000;
					g[221] = 11.0500000000; fxg[221] = 1.4340000000; feg[221] = 0.0302000000;
					g[222] = 11.1000000000; fxg[222] = 1.4273000000; feg[222] = 0.0300000000;
					g[223] = 11.1500000000; fxg[223] = 1.4184000000; feg[223] = 0.0297000000;
					g[224] = 11.2000000000; fxg[224] = 1.4077000000; feg[224] = 0.0295000000;
					g[225] = 11.2500000000; fxg[225] = 1.3962000000; feg[225] = 0.0292000000;
					g[226] = 11.3000000000; fxg[226] = 1.3852000000; feg[226] = 0.0290000000;
					g[227] = 11.3500000000; fxg[227] = 1.3758000000; feg[227] = 0.0287000000;
					g[228] = 11.4000000000; fxg[228] = 1.3679000000; feg[228] = 0.0285000000;
					g[229] = 11.4500000000; fxg[229] = 1.3607000000; feg[229] = 0.0282000000;
					g[230] = 11.5000000000; fxg[230] = 1.3529000000; feg[230] = 0.0280000000;
					g[231] = 11.5500000000; fxg[231] = 1.3439000000; feg[231] = 0.0277000000;
					g[232] = 11.6000000000; fxg[232] = 1.3341000000; feg[232] = 0.0275000000;
					g[233] = 11.6500000000; fxg[233] = 1.3241000000; feg[233] = 0.0273000000;
					g[234] = 11.7000000000; fxg[234] = 1.3146000000; feg[234] = 0.0271000000;
					g[235] = 11.7500000000; fxg[235] = 1.3057000000; feg[235] = 0.0268000000;
					g[236] = 11.8000000000; fxg[236] = 1.2976000000; feg[236] = 0.0266000000;
					g[237] = 11.8500000000; fxg[237] = 1.2906000000; feg[237] = 0.0264000000;
					g[238] = 11.9000000000; fxg[238] = 1.2857000000; feg[238] = 0.0262000000;
					g[239] = 11.9500000000; fxg[239] = 1.2835000000; feg[239] = 0.0260000000;
					g[240] = 12.0000000000; fxg[240] = 1.2838000000; feg[240] = 0.0257000000;
					break;
				case 41:
					g[0] = 0.0000000000; fxg[0] = 41.0000000000; feg[0] = 11.1748000000;
					g[1] = 0.0500000000; fxg[1] = 40.7151000000; feg[1] = 10.9118000000;
					g[2] = 0.1000000000; fxg[2] = 39.9337000000; feg[2] = 10.2083000000;
					g[3] = 0.1500000000; fxg[3] = 38.8237000000; feg[3] = 9.2598000000;
					g[4] = 0.2000000000; fxg[4] = 37.5496000000; feg[4] = 8.2582000000;
					g[5] = 0.2500000000; fxg[5] = 36.2189000000; feg[5] = 7.3234000000;
					g[6] = 0.3000000000; fxg[6] = 34.8861000000; feg[6] = 6.5034000000;
					g[7] = 0.3500000000; fxg[7] = 33.5755000000; feg[7] = 5.8023000000;
					g[8] = 0.4000000000; fxg[8] = 32.2997000000; feg[8] = 5.2058000000;
					g[9] = 0.4500000000; fxg[9] = 31.0675000000; feg[9] = 4.6957000000;
					g[10] = 0.5000000000; fxg[10] = 29.8864000000; feg[10] = 4.2558000000;
					g[11] = 0.5500000000; fxg[11] = 28.7627000000; feg[11] = 3.8728000000;
					g[12] = 0.6000000000; fxg[12] = 27.7005000000; feg[12] = 3.5367000000;
					g[13] = 0.6500000000; fxg[13] = 26.7023000000; feg[13] = 3.2397000000;
					g[14] = 0.7000000000; fxg[14] = 25.7683000000; feg[14] = 2.9759000000;
					g[15] = 0.7500000000; fxg[15] = 24.8969000000; feg[15] = 2.7407000000;
					g[16] = 0.8000000000; fxg[16] = 24.0853000000; feg[16] = 2.5302000000;
					g[17] = 0.8500000000; fxg[17] = 23.3292000000; feg[17] = 2.3415000000;
					g[18] = 0.9000000000; fxg[18] = 22.6239000000; feg[18] = 2.1719000000;
					g[19] = 0.9500000000; fxg[19] = 21.9639000000; feg[19] = 2.0193000000;
					g[20] = 1.0000000000; fxg[20] = 21.3440000000; feg[20] = 1.8818000000;
					g[21] = 1.0500000000; fxg[21] = 20.7588000000; feg[21] = 1.7576000000;
					g[22] = 1.1000000000; fxg[22] = 20.2033000000; feg[22] = 1.6454000000;
					g[23] = 1.1500000000; fxg[23] = 19.6730000000; feg[23] = 1.5438000000;
					g[24] = 1.2000000000; fxg[24] = 19.1638000000; feg[24] = 1.4517000000;
					g[25] = 1.2500000000; fxg[25] = 18.6722000000; feg[25] = 1.3680000000;
					g[26] = 1.3000000000; fxg[26] = 18.1953000000; feg[26] = 1.2918000000;
					g[27] = 1.3500000000; fxg[27] = 17.7307000000; feg[27] = 1.2223000000;
					g[28] = 1.4000000000; fxg[28] = 17.2765000000; feg[28] = 1.1588000000;
					g[29] = 1.4500000000; fxg[29] = 16.8314000000; feg[29] = 1.1005000000;
					g[30] = 1.5000000000; fxg[30] = 16.3943000000; feg[30] = 1.0469000000;
					g[31] = 1.5500000000; fxg[31] = 15.9646000000; feg[31] = 0.9976000000;
					g[32] = 1.6000000000; fxg[32] = 15.5420000000; feg[32] = 0.9520000000;
					g[33] = 1.6500000000; fxg[33] = 15.1265000000; feg[33] = 0.9098000000;
					g[34] = 1.7000000000; fxg[34] = 14.7180000000; feg[34] = 0.8706000000;
					g[35] = 1.7500000000; fxg[35] = 14.3169000000; feg[35] = 0.8341000000;
					g[36] = 1.8000000000; fxg[36] = 13.9236000000; feg[36] = 0.8000000000;
					g[37] = 1.8500000000; fxg[37] = 13.5384000000; feg[37] = 0.7682000000;
					g[38] = 1.9000000000; fxg[38] = 13.1617000000; feg[38] = 0.7383000000;
					g[39] = 1.9500000000; fxg[39] = 12.7941000000; feg[39] = 0.7101000000;
					g[40] = 2.0000000000; fxg[40] = 12.4362000000; feg[40] = 0.6836000000;
					g[41] = 2.0500000000; fxg[41] = 12.0882000000; feg[41] = 0.6586000000;
					g[42] = 2.1000000000; fxg[42] = 11.7501000000; feg[42] = 0.6350000000;
					g[43] = 2.1500000000; fxg[43] = 11.4228000000; feg[43] = 0.6126000000;
					g[44] = 2.2000000000; fxg[44] = 11.1068000000; feg[44] = 0.5913000000;
					g[45] = 2.2500000000; fxg[45] = 10.8019000000; feg[45] = 0.5711000000;
					g[46] = 2.3000000000; fxg[46] = 10.5077000000; feg[46] = 0.5518000000;
					g[47] = 2.3500000000; fxg[47] = 10.2246000000; feg[47] = 0.5335000000;
					g[48] = 2.4000000000; fxg[48] = 9.9535000000; feg[48] = 0.5160000000;
					g[49] = 2.4500000000; fxg[49] = 9.6941000000; feg[49] = 0.4993000000;
					g[50] = 2.5000000000; fxg[50] = 9.4455000000; feg[50] = 0.4833000000;
					g[51] = 2.5500000000; fxg[51] = 9.2073000000; feg[51] = 0.4681000000;
					g[52] = 2.6000000000; fxg[52] = 8.9799000000; feg[52] = 0.4535000000;
					g[53] = 2.6500000000; fxg[53] = 8.7638000000; feg[53] = 0.4395000000;
					g[54] = 2.7000000000; fxg[54] = 8.5588000000; feg[54] = 0.4260000000;
					g[55] = 2.7500000000; fxg[55] = 8.3636000000; feg[55] = 0.4131000000;
					g[56] = 2.8000000000; fxg[56] = 8.1772000000; feg[56] = 0.4008000000;
					g[57] = 2.8500000000; fxg[57] = 7.9996000000; feg[57] = 0.3890000000;
					g[58] = 2.9000000000; fxg[58] = 7.8316000000; feg[58] = 0.3776000000;
					g[59] = 2.9500000000; fxg[59] = 7.6735000000; feg[59] = 0.3666000000;
					g[60] = 3.0000000000; fxg[60] = 7.5240000000; feg[60] = 0.3561000000;
					g[61] = 3.0500000000; fxg[61] = 7.3817000000; feg[61] = 0.3460000000;
					g[62] = 3.1000000000; fxg[62] = 7.2458000000; feg[62] = 0.3363000000;
					g[63] = 3.1500000000; fxg[63] = 7.1164000000; feg[63] = 0.3269000000;
					g[64] = 3.2000000000; fxg[64] = 6.9944000000; feg[64] = 0.3179000000;
					g[65] = 3.2500000000; fxg[65] = 6.8800000000; feg[65] = 0.3093000000;
					g[66] = 3.3000000000; fxg[66] = 6.7723000000; feg[66] = 0.3009000000;
					g[67] = 3.3500000000; fxg[67] = 6.6698000000; feg[67] = 0.2929000000;
					g[68] = 3.4000000000; fxg[68] = 6.5712000000; feg[68] = 0.2851000000;
					g[69] = 3.4500000000; fxg[69] = 6.4764000000; feg[69] = 0.2777000000;
					g[70] = 3.5000000000; fxg[70] = 6.3861000000; feg[70] = 0.2705000000;
					g[71] = 3.5500000000; fxg[71] = 6.3010000000; feg[71] = 0.2636000000;
					g[72] = 3.6000000000; fxg[72] = 6.2213000000; feg[72] = 0.2569000000;
					g[73] = 3.6500000000; fxg[73] = 6.1460000000; feg[73] = 0.2505000000;
					g[74] = 3.7000000000; fxg[74] = 6.0733000000; feg[74] = 0.2442000000;
					g[75] = 3.7500000000; fxg[75] = 6.0023000000; feg[75] = 0.2383000000;
					g[76] = 3.8000000000; fxg[76] = 5.9330000000; feg[76] = 0.2325000000;
					g[77] = 3.8500000000; fxg[77] = 5.8659000000; feg[77] = 0.2269000000;
					g[78] = 3.9000000000; fxg[78] = 5.8018000000; feg[78] = 0.2215000000;
					g[79] = 3.9500000000; fxg[79] = 5.7412000000; feg[79] = 0.2163000000;
					g[80] = 4.0000000000; fxg[80] = 5.6840000000; feg[80] = 0.2113000000;
					g[81] = 4.0500000000; fxg[81] = 5.6290000000; feg[81] = 0.2064000000;
					g[82] = 4.1000000000; fxg[82] = 5.5743000000; feg[82] = 0.2018000000;
					g[83] = 4.1500000000; fxg[83] = 5.5196000000; feg[83] = 0.1972000000;
					g[84] = 4.2000000000; fxg[84] = 5.4652000000; feg[84] = 0.1929000000;
					g[85] = 4.2500000000; fxg[85] = 5.4116000000; feg[85] = 0.1886000000;
					g[86] = 4.3000000000; fxg[86] = 5.3595000000; feg[86] = 0.1845000000;
					g[87] = 4.3500000000; fxg[87] = 5.3095000000; feg[87] = 0.1806000000;
					g[88] = 4.4000000000; fxg[88] = 5.2621000000; feg[88] = 0.1767000000;
					g[89] = 4.4500000000; fxg[89] = 5.2164000000; feg[89] = 0.1730000000;
					g[90] = 4.5000000000; fxg[90] = 5.1707000000; feg[90] = 0.1694000000;
					g[91] = 4.5500000000; fxg[91] = 5.1238000000; feg[91] = 0.1659000000;
					g[92] = 4.6000000000; fxg[92] = 5.0761000000; feg[92] = 0.1625000000;
					g[93] = 4.6500000000; fxg[93] = 5.0283000000; feg[93] = 0.1593000000;
					g[94] = 4.7000000000; fxg[94] = 4.9807000000; feg[94] = 0.1561000000;
					g[95] = 4.7500000000; fxg[95] = 4.9336000000; feg[95] = 0.1530000000;
					g[96] = 4.8000000000; fxg[96] = 4.8878000000; feg[96] = 0.1501000000;
					g[97] = 4.8500000000; fxg[97] = 4.8441000000; feg[97] = 0.1472000000;
					g[98] = 4.9000000000; fxg[98] = 4.8022000000; feg[98] = 0.1443000000;
					g[99] = 4.9500000000; fxg[99] = 4.7603000000; feg[99] = 0.1416000000;
					g[100] = 5.0000000000; fxg[100] = 4.7169000000; feg[100] = 0.1389000000;
					g[101] = 5.0500000000; fxg[101] = 4.6719000000; feg[101] = 0.1364000000;
					g[102] = 5.1000000000; fxg[102] = 4.6263000000; feg[102] = 0.1339000000;
					g[103] = 5.1500000000; fxg[103] = 4.5807000000; feg[103] = 0.1315000000;
					g[104] = 5.2000000000; fxg[104] = 4.5350000000; feg[104] = 0.1291000000;
					g[105] = 5.2500000000; fxg[105] = 4.4895000000; feg[105] = 0.1268000000;
					g[106] = 5.3000000000; fxg[106] = 4.4449000000; feg[106] = 0.1246000000;
					g[107] = 5.3500000000; fxg[107] = 4.4022000000; feg[107] = 0.1224000000;
					g[108] = 5.4000000000; fxg[108] = 4.3616000000; feg[108] = 0.1203000000;
					g[109] = 5.4500000000; fxg[109] = 4.3215000000; feg[109] = 0.1182000000;
					g[110] = 5.5000000000; fxg[110] = 4.2801000000; feg[110] = 0.1162000000;
					g[111] = 5.5500000000; fxg[111] = 4.2368000000; feg[111] = 0.1143000000;
					g[112] = 5.6000000000; fxg[112] = 4.1922000000; feg[112] = 0.1124000000;
					g[113] = 5.6500000000; fxg[113] = 4.1477000000; feg[113] = 0.1105000000;
					g[114] = 5.7000000000; fxg[114] = 4.1034000000; feg[114] = 0.1087000000;
					g[115] = 5.7500000000; fxg[115] = 4.0591000000; feg[115] = 0.1070000000;
					g[116] = 5.8000000000; fxg[116] = 4.0148000000; feg[116] = 0.1053000000;
					g[117] = 5.8500000000; fxg[117] = 3.9712000000; feg[117] = 0.1036000000;
					g[118] = 5.9000000000; fxg[118] = 3.9294000000; feg[118] = 0.1020000000;
					g[119] = 5.9500000000; fxg[119] = 3.8901000000; feg[119] = 0.1004000000;
					g[120] = 6.0000000000; fxg[120] = 3.8521000000; feg[120] = 0.0988000000;
					g[121] = 6.0500000000; fxg[121] = 3.8137000000; feg[121] = 0.0973000000;
					g[122] = 6.1000000000; fxg[122] = 3.7733000000; feg[122] = 0.0958000000;
					g[123] = 6.1500000000; fxg[123] = 3.7311000000; feg[123] = 0.0943000000;
					g[124] = 6.2000000000; fxg[124] = 3.6884000000; feg[124] = 0.0929000000;
					g[125] = 6.2500000000; fxg[125] = 3.6462000000; feg[125] = 0.0915000000;
					g[126] = 6.3000000000; fxg[126] = 3.6047000000; feg[126] = 0.0902000000;
					g[127] = 6.3500000000; fxg[127] = 3.5632000000; feg[127] = 0.0889000000;
					g[128] = 6.4000000000; fxg[128] = 3.5215000000; feg[128] = 0.0876000000;
					g[129] = 6.4500000000; fxg[129] = 3.4803000000; feg[129] = 0.0863000000;
					g[130] = 6.5000000000; fxg[130] = 3.4408000000; feg[130] = 0.0851000000;
					g[131] = 6.5500000000; fxg[131] = 3.4038000000; feg[131] = 0.0839000000;
					g[132] = 6.6000000000; fxg[132] = 3.3691000000; feg[132] = 0.0827000000;
					g[133] = 6.6500000000; fxg[133] = 3.3353000000; feg[133] = 0.0815000000;
					g[134] = 6.7000000000; fxg[134] = 3.3004000000; feg[134] = 0.0804000000;
					g[135] = 6.7500000000; fxg[135] = 3.2634000000; feg[135] = 0.0793000000;
					g[136] = 6.8000000000; fxg[136] = 3.2248000000; feg[136] = 0.0782000000;
					g[137] = 6.8500000000; fxg[137] = 3.1859000000; feg[137] = 0.0772000000;
					g[138] = 6.9000000000; fxg[138] = 3.1479000000; feg[138] = 0.0761000000;
					g[139] = 6.9500000000; fxg[139] = 3.1109000000; feg[139] = 0.0751000000;
					g[140] = 7.0000000000; fxg[140] = 3.0743000000; feg[140] = 0.0741000000;
					g[141] = 7.0500000000; fxg[141] = 3.0373000000; feg[141] = 0.0731000000;
					g[142] = 7.1000000000; fxg[142] = 3.0005000000; feg[142] = 0.0722000000;
					g[143] = 7.1500000000; fxg[143] = 2.9647000000; feg[143] = 0.0712000000;
					g[144] = 7.2000000000; fxg[144] = 2.9310000000; feg[144] = 0.0703000000;
					g[145] = 7.2500000000; fxg[145] = 2.9002000000; feg[145] = 0.0694000000;
					g[146] = 7.3000000000; fxg[146] = 2.8716000000; feg[146] = 0.0685000000;
					g[147] = 7.3500000000; fxg[147] = 2.8438000000; feg[147] = 0.0676000000;
					g[148] = 7.4000000000; fxg[148] = 2.8149000000; feg[148] = 0.0668000000;
					g[149] = 7.4500000000; fxg[149] = 2.7839000000; feg[149] = 0.0659000000;
					g[150] = 7.5000000000; fxg[150] = 2.7511000000; feg[150] = 0.0651000000;
					g[151] = 7.5500000000; fxg[151] = 2.7176000000; feg[151] = 0.0643000000;
					g[152] = 7.6000000000; fxg[152] = 2.6850000000; feg[152] = 0.0635000000;
					g[153] = 7.6500000000; fxg[153] = 2.6536000000; feg[153] = 0.0627000000;
					g[154] = 7.7000000000; fxg[154] = 2.6231000000; feg[154] = 0.0620000000;
					g[155] = 7.7500000000; fxg[155] = 2.5925000000; feg[155] = 0.0612000000;
					g[156] = 7.8000000000; fxg[156] = 2.5617000000; feg[156] = 0.0605000000;
					g[157] = 7.8500000000; fxg[157] = 2.5311000000; feg[157] = 0.0598000000;
					g[158] = 7.9000000000; fxg[158] = 2.5015000000; feg[158] = 0.0591000000;
					g[159] = 7.9500000000; fxg[159] = 2.4740000000; feg[159] = 0.0584000000;
					g[160] = 8.0000000000; fxg[160] = 2.4493000000; feg[160] = 0.0577000000;
					g[161] = 8.0500000000; fxg[161] = 2.4273000000; feg[161] = 0.0570000000;
					g[162] = 8.1000000000; fxg[162] = 2.4067000000; feg[162] = 0.0563000000;
					g[163] = 8.1500000000; fxg[163] = 2.3856000000; feg[163] = 0.0557000000;
					g[164] = 8.2000000000; fxg[164] = 2.3627000000; feg[164] = 0.0550000000;
					g[165] = 8.2500000000; fxg[165] = 2.3377000000; feg[165] = 0.0544000000;
					g[166] = 8.3000000000; fxg[166] = 2.3110000000; feg[166] = 0.0538000000;
					g[167] = 8.3500000000; fxg[167] = 2.2840000000; feg[167] = 0.0532000000;
					g[168] = 8.4000000000; fxg[168] = 2.2579000000; feg[168] = 0.0526000000;
					g[169] = 8.4500000000; fxg[169] = 2.2333000000; feg[169] = 0.0520000000;
					g[170] = 8.5000000000; fxg[170] = 2.2094000000; feg[170] = 0.0514000000;
					g[171] = 8.5500000000; fxg[171] = 2.1855000000; feg[171] = 0.0508000000;
					g[172] = 8.6000000000; fxg[172] = 2.1612000000; feg[172] = 0.0503000000;
					g[173] = 8.6500000000; fxg[173] = 2.1370000000; feg[173] = 0.0497000000;
					g[174] = 8.7000000000; fxg[174] = 2.1133000000; feg[174] = 0.0492000000;
					g[175] = 8.7500000000; fxg[175] = 2.0911000000; feg[175] = 0.0487000000;
					g[176] = 8.8000000000; fxg[176] = 2.0711000000; feg[176] = 0.0481000000;
					g[177] = 8.8500000000; fxg[177] = 2.0540000000; feg[177] = 0.0476000000;
					g[178] = 8.9000000000; fxg[178] = 2.0394000000; feg[178] = 0.0471000000;
					g[179] = 8.9500000000; fxg[179] = 2.0261000000; feg[179] = 0.0466000000;
					g[180] = 9.0000000000; fxg[180] = 2.0123000000; feg[180] = 0.0461000000;
					g[181] = 9.0500000000; fxg[181] = 1.9967000000; feg[181] = 0.0456000000;
					g[182] = 9.1000000000; fxg[182] = 1.9790000000; feg[182] = 0.0451000000;
					g[183] = 9.1500000000; fxg[183] = 1.9593000000; feg[183] = 0.0446000000;
					g[184] = 9.2000000000; fxg[184] = 1.9385000000; feg[184] = 0.0442000000;
					g[185] = 9.2500000000; fxg[185] = 1.9180000000; feg[185] = 0.0437000000;
					g[186] = 9.3000000000; fxg[186] = 1.8986000000; feg[186] = 0.0433000000;
					g[187] = 9.3500000000; fxg[187] = 1.8806000000; feg[187] = 0.0428000000;
					g[188] = 9.4000000000; fxg[188] = 1.8630000000; feg[188] = 0.0424000000;
					g[189] = 9.4500000000; fxg[189] = 1.8451000000; feg[189] = 0.0420000000;
					g[190] = 9.5000000000; fxg[190] = 1.8266000000; feg[190] = 0.0416000000;
					g[191] = 9.5500000000; fxg[191] = 1.8082000000; feg[191] = 0.0411000000;
					g[192] = 9.6000000000; fxg[192] = 1.7903000000; feg[192] = 0.0407000000;
					g[193] = 9.6500000000; fxg[193] = 1.7736000000; feg[193] = 0.0403000000;
					g[194] = 9.7000000000; fxg[194] = 1.7585000000; feg[194] = 0.0399000000;
					g[195] = 9.7500000000; fxg[195] = 1.7460000000; feg[195] = 0.0395000000;
					g[196] = 9.8000000000; fxg[196] = 1.7362000000; feg[196] = 0.0391000000;
					g[197] = 9.8500000000; fxg[197] = 1.7286000000; feg[197] = 0.0388000000;
					g[198] = 9.9000000000; fxg[198] = 1.7218000000; feg[198] = 0.0384000000;
					g[199] = 9.9500000000; fxg[199] = 1.7141000000; feg[199] = 0.0380000000;
					g[200] = 10.0000000000; fxg[200] = 1.7045000000; feg[200] = 0.0376000000;
					g[201] = 10.0500000000; fxg[201] = 1.6928000000; feg[201] = 0.0373000000;
					g[202] = 10.1000000000; fxg[202] = 1.6790000000; feg[202] = 0.0369000000;
					g[203] = 10.1500000000; fxg[203] = 1.6638000000; feg[203] = 0.0366000000;
					g[204] = 10.2000000000; fxg[204] = 1.6482000000; feg[204] = 0.0362000000;
					g[205] = 10.2500000000; fxg[205] = 1.6333000000; feg[205] = 0.0359000000;
					g[206] = 10.3000000000; fxg[206] = 1.6198000000; feg[206] = 0.0355000000;
					g[207] = 10.3500000000; fxg[207] = 1.6072000000; feg[207] = 0.0352000000;
					g[208] = 10.4000000000; fxg[208] = 1.5945000000; feg[208] = 0.0349000000;
					g[209] = 10.4500000000; fxg[209] = 1.5812000000; feg[209] = 0.0346000000;
					g[210] = 10.5000000000; fxg[210] = 1.5674000000; feg[210] = 0.0342000000;
					g[211] = 10.5500000000; fxg[211] = 1.5535000000; feg[211] = 0.0339000000;
					g[212] = 10.6000000000; fxg[212] = 1.5403000000; feg[212] = 0.0336000000;
					g[213] = 10.6500000000; fxg[213] = 1.5279000000; feg[213] = 0.0333000000;
					g[214] = 10.7000000000; fxg[214] = 1.5169000000; feg[214] = 0.0330000000;
					g[215] = 10.7500000000; fxg[215] = 1.5079000000; feg[215] = 0.0327000000;
					g[216] = 10.8000000000; fxg[216] = 1.5015000000; feg[216] = 0.0324000000;
					g[217] = 10.8500000000; fxg[217] = 1.4977000000; feg[217] = 0.0321000000;
					g[218] = 10.9000000000; fxg[218] = 1.4955000000; feg[218] = 0.0318000000;
					g[219] = 10.9500000000; fxg[219] = 1.4936000000; feg[219] = 0.0315000000;
					g[220] = 11.0000000000; fxg[220] = 1.4904000000; feg[220] = 0.0313000000;
					g[221] = 11.0500000000; fxg[221] = 1.4854000000; feg[221] = 0.0310000000;
					g[222] = 11.1000000000; fxg[222] = 1.4783000000; feg[222] = 0.0307000000;
					g[223] = 11.1500000000; fxg[223] = 1.4692000000; feg[223] = 0.0304000000;
					g[224] = 11.2000000000; fxg[224] = 1.4584000000; feg[224] = 0.0302000000;
					g[225] = 11.2500000000; fxg[225] = 1.4466000000; feg[225] = 0.0299000000;
					g[226] = 11.3000000000; fxg[226] = 1.4350000000; feg[226] = 0.0297000000;
					g[227] = 11.3500000000; fxg[227] = 1.4246000000; feg[227] = 0.0294000000;
					g[228] = 11.4000000000; fxg[228] = 1.4153000000; feg[228] = 0.0292000000;
					g[229] = 11.4500000000; fxg[229] = 1.4064000000; feg[229] = 0.0289000000;
					g[230] = 11.5000000000; fxg[230] = 1.3972000000; feg[230] = 0.0287000000;
					g[231] = 11.5500000000; fxg[231] = 1.3872000000; feg[231] = 0.0284000000;
					g[232] = 11.6000000000; fxg[232] = 1.3765000000; feg[232] = 0.0282000000;
					g[233] = 11.6500000000; fxg[233] = 1.3658000000; feg[233] = 0.0280000000;
					g[234] = 11.7000000000; fxg[234] = 1.3557000000; feg[234] = 0.0277000000;
					g[235] = 11.7500000000; fxg[235] = 1.3463000000; feg[235] = 0.0275000000;
					g[236] = 11.8000000000; fxg[236] = 1.3378000000; feg[236] = 0.0273000000;
					g[237] = 11.8500000000; fxg[237] = 1.3309000000; feg[237] = 0.0270000000;
					g[238] = 11.9000000000; fxg[238] = 1.3260000000; feg[238] = 0.0268000000;
					g[239] = 11.9500000000; fxg[239] = 1.3236000000; feg[239] = 0.0266000000;
					g[240] = 12.0000000000; fxg[240] = 1.3236000000; feg[240] = 0.0264000000;
					break;
				case 42:
					g[0] = 0.0000000000; fxg[0] = 42.0000000000; feg[0] = 10.8542000000;
					g[1] = 0.0500000000; fxg[1] = 41.7228000000; feg[1] = 10.6163000000;
					g[2] = 0.1000000000; fxg[2] = 40.9578000000; feg[2] = 9.9775000000;
					g[3] = 0.1500000000; fxg[3] = 39.8589000000; feg[3] = 9.1101000000;
					g[4] = 0.2000000000; fxg[4] = 38.5801000000; feg[4] = 8.1850000000;
					g[5] = 0.2500000000; fxg[5] = 37.2270000000; feg[5] = 7.3111000000;
					g[6] = 0.3000000000; fxg[6] = 35.8572000000; feg[6] = 6.5342000000;
					g[7] = 0.3500000000; fxg[7] = 34.5005000000; feg[7] = 5.8609000000;
					g[8] = 0.4000000000; fxg[8] = 33.1744000000; feg[8] = 5.2807000000;
					g[9] = 0.4500000000; fxg[9] = 31.8911000000; feg[9] = 4.7791000000;
					g[10] = 0.5000000000; fxg[10] = 30.6601000000; feg[10] = 4.3425000000;
					g[11] = 0.5500000000; fxg[11] = 29.4888000000; feg[11] = 3.9595000000;
					g[12] = 0.6000000000; fxg[12] = 28.3821000000; feg[12] = 3.6214000000;
					g[13] = 0.6500000000; fxg[13] = 27.3424000000; feg[13] = 3.3213000000;
					g[14] = 0.7000000000; fxg[14] = 26.3704000000; feg[14] = 3.0537000000;
					g[15] = 0.7500000000; fxg[15] = 25.4646000000; feg[15] = 2.8142000000;
					g[16] = 0.8000000000; fxg[16] = 24.6223000000; feg[16] = 2.5995000000;
					g[17] = 0.8500000000; fxg[17] = 23.8394000000; feg[17] = 2.4064000000;
					g[18] = 0.9000000000; fxg[18] = 23.1112000000; feg[18] = 2.2325000000;
					g[19] = 0.9500000000; fxg[19] = 22.4325000000; feg[19] = 2.0757000000;
					g[20] = 1.0000000000; fxg[20] = 21.7979000000; feg[20] = 1.9340000000;
					g[21] = 1.0500000000; fxg[21] = 21.2020000000; feg[21] = 1.8060000000;
					g[22] = 1.1000000000; fxg[22] = 20.6396000000; feg[22] = 1.6900000000;
					g[23] = 1.1500000000; fxg[23] = 20.1060000000; feg[23] = 1.5849000000;
					g[24] = 1.2000000000; fxg[24] = 19.5966000000; feg[24] = 1.4894000000;
					g[25] = 1.2500000000; fxg[25] = 19.1077000000; feg[25] = 1.4026000000;
					g[26] = 1.3000000000; fxg[26] = 18.6358000000; feg[26] = 1.3235000000;
					g[27] = 1.3500000000; fxg[27] = 18.1782000000; feg[27] = 1.2513000000;
					g[28] = 1.4000000000; fxg[28] = 17.7323000000; feg[28] = 1.1853000000;
					g[29] = 1.4500000000; fxg[29] = 17.2965000000; feg[29] = 1.1248000000;
					g[30] = 1.5000000000; fxg[30] = 16.8691000000; feg[30] = 1.0693000000;
					g[31] = 1.5500000000; fxg[31] = 16.4493000000; feg[31] = 1.0181000000;
					g[32] = 1.6000000000; fxg[32] = 16.0363000000; feg[32] = 0.9709000000;
					g[33] = 1.6500000000; fxg[33] = 15.6298000000; feg[33] = 0.9273000000;
					g[34] = 1.7000000000; fxg[34] = 15.2293000000; feg[34] = 0.8868000000;
					g[35] = 1.7500000000; fxg[35] = 14.8351000000; feg[35] = 0.8492000000;
					g[36] = 1.8000000000; fxg[36] = 14.4475000000; feg[36] = 0.8141000000;
					g[37] = 1.8500000000; fxg[37] = 14.0664000000; feg[37] = 0.7814000000;
					g[38] = 1.9000000000; fxg[38] = 13.6923000000; feg[38] = 0.7507000000;
					g[39] = 1.9500000000; fxg[39] = 13.3258000000; feg[39] = 0.7219000000;
					g[40] = 2.0000000000; fxg[40] = 12.9673000000; feg[40] = 0.6949000000;
					g[41] = 2.0500000000; fxg[41] = 12.6170000000; feg[41] = 0.6694000000;
					g[42] = 2.1000000000; fxg[42] = 12.2751000000; feg[42] = 0.6453000000;
					g[43] = 2.1500000000; fxg[43] = 11.9426000000; feg[43] = 0.6225000000;
					g[44] = 2.2000000000; fxg[44] = 11.6199000000; feg[44] = 0.6009000000;
					g[45] = 2.2500000000; fxg[45] = 11.3068000000; feg[45] = 0.5804000000;
					g[46] = 2.3000000000; fxg[46] = 11.0034000000; feg[46] = 0.5610000000;
					g[47] = 2.3500000000; fxg[47] = 10.7101000000; feg[47] = 0.5424000000;
					g[48] = 2.4000000000; fxg[48] = 10.4277000000; feg[48] = 0.5248000000;
					g[49] = 2.4500000000; fxg[49] = 10.1561000000; feg[49] = 0.5079000000;
					g[50] = 2.5000000000; fxg[50] = 9.8946000000; feg[50] = 0.4918000000;
					g[51] = 2.5500000000; fxg[51] = 9.6430000000; feg[51] = 0.4764000000;
					g[52] = 2.6000000000; fxg[52] = 9.4017000000; feg[52] = 0.4617000000;
					g[53] = 2.6500000000; fxg[53] = 9.1714000000; feg[53] = 0.4475000000;
					g[54] = 2.7000000000; fxg[54] = 8.9518000000; feg[54] = 0.4340000000;
					g[55] = 2.7500000000; fxg[55] = 8.7419000000; feg[55] = 0.4210000000;
					g[56] = 2.8000000000; fxg[56] = 8.5408000000; feg[56] = 0.4086000000;
					g[57] = 2.8500000000; fxg[57] = 8.3487000000; feg[57] = 0.3966000000;
					g[58] = 2.9000000000; fxg[58] = 8.1663000000; feg[58] = 0.3851000000;
					g[59] = 2.9500000000; fxg[59] = 7.9937000000; feg[59] = 0.3741000000;
					g[60] = 3.0000000000; fxg[60] = 7.8301000000; feg[60] = 0.3635000000;
					g[61] = 3.0500000000; fxg[61] = 7.6741000000; feg[61] = 0.3533000000;
					g[62] = 3.1000000000; fxg[62] = 7.5249000000; feg[62] = 0.3434000000;
					g[63] = 3.1500000000; fxg[63] = 7.3829000000; feg[63] = 0.3340000000;
					g[64] = 3.2000000000; fxg[64] = 7.2485000000; feg[64] = 0.3249000000;
					g[65] = 3.2500000000; fxg[65] = 7.1221000000; feg[65] = 0.3161000000;
					g[66] = 3.3000000000; fxg[66] = 7.0029000000; feg[66] = 0.3077000000;
					g[67] = 3.3500000000; fxg[67] = 6.8894000000; feg[67] = 0.2995000000;
					g[68] = 3.4000000000; fxg[68] = 6.7805000000; feg[68] = 0.2917000000;
					g[69] = 3.4500000000; fxg[69] = 6.6762000000; feg[69] = 0.2841000000;
					g[70] = 3.5000000000; fxg[70] = 6.5768000000; feg[70] = 0.2768000000;
					g[71] = 3.5500000000; fxg[71] = 6.4832000000; feg[71] = 0.2698000000;
					g[72] = 3.6000000000; fxg[72] = 6.3953000000; feg[72] = 0.2630000000;
					g[73] = 3.6500000000; fxg[73] = 6.3124000000; feg[73] = 0.2564000000;
					g[74] = 3.7000000000; fxg[74] = 6.2327000000; feg[74] = 0.2501000000;
					g[75] = 3.7500000000; fxg[75] = 6.1553000000; feg[75] = 0.2440000000;
					g[76] = 3.8000000000; fxg[76] = 6.0802000000; feg[76] = 0.2381000000;
					g[77] = 3.8500000000; fxg[77] = 6.0080000000; feg[77] = 0.2325000000;
					g[78] = 3.9000000000; fxg[78] = 5.9391000000; feg[78] = 0.2270000000;
					g[79] = 3.9500000000; fxg[79] = 5.8741000000; feg[79] = 0.2217000000;
					g[80] = 4.0000000000; fxg[80] = 5.8129000000; feg[80] = 0.2165000000;
					g[81] = 4.0500000000; fxg[81] = 5.7542000000; feg[81] = 0.2116000000;
					g[82] = 4.1000000000; fxg[82] = 5.6964000000; feg[82] = 0.2068000000;
					g[83] = 4.1500000000; fxg[83] = 5.6390000000; feg[83] = 0.2021000000;
					g[84] = 4.2000000000; fxg[84] = 5.5824000000; feg[84] = 0.1976000000;
					g[85] = 4.2500000000; fxg[85] = 5.5270000000; feg[85] = 0.1933000000;
					g[86] = 4.3000000000; fxg[86] = 5.4734000000; feg[86] = 0.1891000000;
					g[87] = 4.3500000000; fxg[87] = 5.4221000000; feg[87] = 0.1851000000;
					g[88] = 4.4000000000; fxg[88] = 5.3736000000; feg[88] = 0.1811000000;
					g[89] = 4.4500000000; fxg[89] = 5.3269000000; feg[89] = 0.1773000000;
					g[90] = 4.5000000000; fxg[90] = 5.2805000000; feg[90] = 0.1736000000;
					g[91] = 4.5500000000; fxg[91] = 5.2334000000; feg[91] = 0.1700000000;
					g[92] = 4.6000000000; fxg[92] = 5.1857000000; feg[92] = 0.1666000000;
					g[93] = 4.6500000000; fxg[93] = 5.1381000000; feg[93] = 0.1632000000;
					g[94] = 4.7000000000; fxg[94] = 5.0909000000; feg[94] = 0.1600000000;
					g[95] = 4.7500000000; fxg[95] = 5.0444000000; feg[95] = 0.1568000000;
					g[96] = 4.8000000000; fxg[96] = 4.9993000000; feg[96] = 0.1537000000;
					g[97] = 4.8500000000; fxg[97] = 4.9563000000; feg[97] = 0.1508000000;
					g[98] = 4.9000000000; fxg[98] = 4.9149000000; feg[98] = 0.1479000000;
					g[99] = 4.9500000000; fxg[99] = 4.8738000000; feg[99] = 0.1451000000;
					g[100] = 5.0000000000; fxg[100] = 4.8314000000; feg[100] = 0.1423000000;
					g[101] = 5.0500000000; fxg[101] = 4.7875000000; feg[101] = 0.1397000000;
					g[102] = 5.1000000000; fxg[102] = 4.7430000000; feg[102] = 0.1371000000;
					g[103] = 5.1500000000; fxg[103] = 4.6986000000; feg[103] = 0.1346000000;
					g[104] = 5.2000000000; fxg[104] = 4.6542000000; feg[104] = 0.1322000000;
					g[105] = 5.2500000000; fxg[105] = 4.6101000000; feg[105] = 0.1299000000;
					g[106] = 5.3000000000; fxg[106] = 4.5668000000; feg[106] = 0.1276000000;
					g[107] = 5.3500000000; fxg[107] = 4.5254000000; feg[107] = 0.1253000000;
					g[108] = 5.4000000000; fxg[108] = 4.4858000000; feg[108] = 0.1232000000;
					g[109] = 5.4500000000; fxg[109] = 4.4468000000; feg[109] = 0.1210000000;
					g[110] = 5.5000000000; fxg[110] = 4.4066000000; feg[110] = 0.1190000000;
					g[111] = 5.5500000000; fxg[111] = 4.3646000000; feg[111] = 0.1170000000;
					g[112] = 5.6000000000; fxg[112] = 4.3213000000; feg[112] = 0.1150000000;
					g[113] = 5.6500000000; fxg[113] = 4.2779000000; feg[113] = 0.1131000000;
					g[114] = 5.7000000000; fxg[114] = 4.2347000000; feg[114] = 0.1113000000;
					g[115] = 5.7500000000; fxg[115] = 4.1915000000; feg[115] = 0.1095000000;
					g[116] = 5.8000000000; fxg[116] = 4.1483000000; feg[116] = 0.1077000000;
					g[117] = 5.8500000000; fxg[117] = 4.1058000000; feg[117] = 0.1060000000;
					g[118] = 5.9000000000; fxg[118] = 4.0650000000; feg[118] = 0.1043000000;
					g[119] = 5.9500000000; fxg[119] = 4.0264000000; feg[119] = 0.1027000000;
					g[120] = 6.0000000000; fxg[120] = 3.9891000000; feg[120] = 0.1011000000;
					g[121] = 6.0500000000; fxg[121] = 3.9513000000; feg[121] = 0.0995000000;
					g[122] = 6.1000000000; fxg[122] = 3.9117000000; feg[122] = 0.0980000000;
					g[123] = 6.1500000000; fxg[123] = 3.8703000000; feg[123] = 0.0965000000;
					g[124] = 6.2000000000; fxg[124] = 3.8283000000; feg[124] = 0.0951000000;
					g[125] = 6.2500000000; fxg[125] = 3.7866000000; feg[125] = 0.0937000000;
					g[126] = 6.3000000000; fxg[126] = 3.7454000000; feg[126] = 0.0923000000;
					g[127] = 6.3500000000; fxg[127] = 3.7042000000; feg[127] = 0.0909000000;
					g[128] = 6.4000000000; fxg[128] = 3.6629000000; feg[128] = 0.0896000000;
					g[129] = 6.4500000000; fxg[129] = 3.6221000000; feg[129] = 0.0883000000;
					g[130] = 6.5000000000; fxg[130] = 3.5829000000; feg[130] = 0.0870000000;
					g[131] = 6.5500000000; fxg[131] = 3.5461000000; feg[131] = 0.0858000000;
					g[132] = 6.6000000000; fxg[132] = 3.5114000000; feg[132] = 0.0846000000;
					g[133] = 6.6500000000; fxg[133] = 3.4774000000; feg[133] = 0.0834000000;
					g[134] = 6.7000000000; fxg[134] = 3.4424000000; feg[134] = 0.0822000000;
					g[135] = 6.7500000000; fxg[135] = 3.4054000000; feg[135] = 0.0811000000;
					g[136] = 6.8000000000; fxg[136] = 3.3668000000; feg[136] = 0.0800000000;
					g[137] = 6.8500000000; fxg[137] = 3.3278000000; feg[137] = 0.0789000000;
					g[138] = 6.9000000000; fxg[138] = 3.2895000000; feg[138] = 0.0778000000;
					g[139] = 6.9500000000; fxg[139] = 3.2520000000; feg[139] = 0.0768000000;
					g[140] = 7.0000000000; fxg[140] = 3.2148000000; feg[140] = 0.0758000000;
					g[141] = 7.0500000000; fxg[141] = 3.1774000000; feg[141] = 0.0748000000;
					g[142] = 7.1000000000; fxg[142] = 3.1401000000; feg[142] = 0.0738000000;
					g[143] = 7.1500000000; fxg[143] = 3.1040000000; feg[143] = 0.0728000000;
					g[144] = 7.2000000000; fxg[144] = 3.0698000000; feg[144] = 0.0719000000;
					g[145] = 7.2500000000; fxg[145] = 3.0383000000; feg[145] = 0.0710000000;
					g[146] = 7.3000000000; fxg[146] = 3.0090000000; feg[146] = 0.0700000000;
					g[147] = 7.3500000000; fxg[147] = 2.9803000000; feg[147] = 0.0691000000;
					g[148] = 7.4000000000; fxg[148] = 2.9506000000; feg[148] = 0.0683000000;
					g[149] = 7.4500000000; fxg[149] = 2.9189000000; feg[149] = 0.0674000000;
					g[150] = 7.5000000000; fxg[150] = 2.8854000000; feg[150] = 0.0666000000;
					g[151] = 7.5500000000; fxg[151] = 2.8513000000; feg[151] = 0.0657000000;
					g[152] = 7.6000000000; fxg[152] = 2.8178000000; feg[152] = 0.0649000000;
					g[153] = 7.6500000000; fxg[153] = 2.7854000000; feg[153] = 0.0641000000;
					g[154] = 7.7000000000; fxg[154] = 2.7536000000; feg[154] = 0.0634000000;
					g[155] = 7.7500000000; fxg[155] = 2.7219000000; feg[155] = 0.0626000000;
					g[156] = 7.8000000000; fxg[156] = 2.6900000000; feg[156] = 0.0619000000;
					g[157] = 7.8500000000; fxg[157] = 2.6584000000; feg[157] = 0.0611000000;
					g[158] = 7.9000000000; fxg[158] = 2.6280000000; feg[158] = 0.0604000000;
					g[159] = 7.9500000000; fxg[159] = 2.5995000000; feg[159] = 0.0597000000;
					g[160] = 8.0000000000; fxg[160] = 2.5738000000; feg[160] = 0.0590000000;
					g[161] = 8.0500000000; fxg[161] = 2.5505000000; feg[161] = 0.0583000000;
					g[162] = 8.1000000000; fxg[162] = 2.5286000000; feg[162] = 0.0576000000;
					g[163] = 8.1500000000; fxg[163] = 2.5062000000; feg[163] = 0.0569000000;
					g[164] = 8.2000000000; fxg[164] = 2.4822000000; feg[164] = 0.0563000000;
					g[165] = 8.2500000000; fxg[165] = 2.4561000000; feg[165] = 0.0556000000;
					g[166] = 8.3000000000; fxg[166] = 2.4284000000; feg[166] = 0.0550000000;
					g[167] = 8.3500000000; fxg[167] = 2.4003000000; feg[167] = 0.0544000000;
					g[168] = 8.4000000000; fxg[168] = 2.3730000000; feg[168] = 0.0538000000;
					g[169] = 8.4500000000; fxg[169] = 2.3469000000; feg[169] = 0.0532000000;
					g[170] = 8.5000000000; fxg[170] = 2.3216000000; feg[170] = 0.0526000000;
					g[171] = 8.5500000000; fxg[171] = 2.2963000000; feg[171] = 0.0520000000;
					g[172] = 8.6000000000; fxg[172] = 2.2706000000; feg[172] = 0.0514000000;
					g[173] = 8.6500000000; fxg[173] = 2.2451000000; feg[173] = 0.0509000000;
					g[174] = 8.7000000000; fxg[174] = 2.2203000000; feg[174] = 0.0503000000;
					g[175] = 8.7500000000; fxg[175] = 2.1970000000; feg[175] = 0.0498000000;
					g[176] = 8.8000000000; fxg[176] = 2.1759000000; feg[176] = 0.0492000000;
					g[177] = 8.8500000000; fxg[177] = 2.1575000000; feg[177] = 0.0487000000;
					g[178] = 8.9000000000; fxg[178] = 2.1416000000; feg[178] = 0.0482000000;
					g[179] = 8.9500000000; fxg[179] = 2.1268000000; feg[179] = 0.0477000000;
					g[180] = 9.0000000000; fxg[180] = 2.1116000000; feg[180] = 0.0471000000;
					g[181] = 9.0500000000; fxg[181] = 2.0948000000; feg[181] = 0.0466000000;
					g[182] = 9.1000000000; fxg[182] = 2.0759000000; feg[182] = 0.0462000000;
					g[183] = 9.1500000000; fxg[183] = 2.0551000000; feg[183] = 0.0457000000;
					g[184] = 9.2000000000; fxg[184] = 2.0332000000; feg[184] = 0.0452000000;
					g[185] = 9.2500000000; fxg[185] = 2.0115000000; feg[185] = 0.0447000000;
					g[186] = 9.3000000000; fxg[186] = 1.9908000000; feg[186] = 0.0443000000;
					g[187] = 9.3500000000; fxg[187] = 1.9713000000; feg[187] = 0.0438000000;
					g[188] = 9.4000000000; fxg[188] = 1.9523000000; feg[188] = 0.0434000000;
					g[189] = 9.4500000000; fxg[189] = 1.9330000000; feg[189] = 0.0430000000;
					g[190] = 9.5000000000; fxg[190] = 1.9133000000; feg[190] = 0.0425000000;
					g[191] = 9.5500000000; fxg[191] = 1.8936000000; feg[191] = 0.0421000000;
					g[192] = 9.6000000000; fxg[192] = 1.8746000000; feg[192] = 0.0417000000;
					g[193] = 9.6500000000; fxg[193] = 1.8568000000; feg[193] = 0.0413000000;
					g[194] = 9.7000000000; fxg[194] = 1.8408000000; feg[194] = 0.0409000000;
					g[195] = 9.7500000000; fxg[195] = 1.8272000000; feg[195] = 0.0405000000;
					g[196] = 9.8000000000; fxg[196] = 1.8163000000; feg[196] = 0.0401000000;
					g[197] = 9.8500000000; fxg[197] = 1.8075000000; feg[197] = 0.0397000000;
					g[198] = 9.9000000000; fxg[198] = 1.7994000000; feg[198] = 0.0393000000;
					g[199] = 9.9500000000; fxg[199] = 1.7905000000; feg[199] = 0.0389000000;
					g[200] = 10.0000000000; fxg[200] = 1.7798000000; feg[200] = 0.0385000000;
					g[201] = 10.0500000000; fxg[201] = 1.7671000000; feg[201] = 0.0381000000;
					g[202] = 10.1000000000; fxg[202] = 1.7523000000; feg[202] = 0.0378000000;
					g[203] = 10.1500000000; fxg[203] = 1.7361000000; feg[203] = 0.0374000000;
					g[204] = 10.2000000000; fxg[204] = 1.7195000000; feg[204] = 0.0371000000;
					g[205] = 10.2500000000; fxg[205] = 1.7037000000; feg[205] = 0.0367000000;
					g[206] = 10.3000000000; fxg[206] = 1.6890000000; feg[206] = 0.0364000000;
					g[207] = 10.3500000000; fxg[207] = 1.6751000000; feg[207] = 0.0360000000;
					g[208] = 10.4000000000; fxg[208] = 1.6612000000; feg[208] = 0.0357000000;
					g[209] = 10.4500000000; fxg[209] = 1.6468000000; feg[209] = 0.0354000000;
					g[210] = 10.5000000000; fxg[210] = 1.6320000000; feg[210] = 0.0351000000;
					g[211] = 10.5500000000; fxg[211] = 1.6172000000; feg[211] = 0.0347000000;
					g[212] = 10.6000000000; fxg[212] = 1.6030000000; feg[212] = 0.0344000000;
					g[213] = 10.6500000000; fxg[213] = 1.5898000000; feg[213] = 0.0341000000;
					g[214] = 10.7000000000; fxg[214] = 1.5780000000; feg[214] = 0.0338000000;
					g[215] = 10.7500000000; fxg[215] = 1.5683000000; feg[215] = 0.0335000000;
					g[216] = 10.8000000000; fxg[216] = 1.5611000000; feg[216] = 0.0332000000;
					g[217] = 10.8500000000; fxg[217] = 1.5564000000; feg[217] = 0.0329000000;
					g[218] = 10.9000000000; fxg[218] = 1.5534000000; feg[218] = 0.0326000000;
					g[219] = 10.9500000000; fxg[219] = 1.5506000000; feg[219] = 0.0323000000;
					g[220] = 11.0000000000; fxg[220] = 1.5466000000; feg[220] = 0.0320000000;
					g[221] = 11.0500000000; fxg[221] = 1.5408000000; feg[221] = 0.0317000000;
					g[222] = 11.1000000000; fxg[222] = 1.5330000000; feg[222] = 0.0314000000;
					g[223] = 11.1500000000; fxg[223] = 1.5231000000; feg[223] = 0.0312000000;
					g[224] = 11.2000000000; fxg[224] = 1.5116000000; feg[224] = 0.0309000000;
					g[225] = 11.2500000000; fxg[225] = 1.4991000000; feg[225] = 0.0306000000;
					g[226] = 11.3000000000; fxg[226] = 1.4868000000; feg[226] = 0.0304000000;
					g[227] = 11.3500000000; fxg[227] = 1.4755000000; feg[227] = 0.0301000000;
					g[228] = 11.4000000000; fxg[228] = 1.4653000000; feg[228] = 0.0299000000;
					g[229] = 11.4500000000; fxg[229] = 1.4555000000; feg[229] = 0.0296000000;
					g[230] = 11.5000000000; fxg[230] = 1.4454000000; feg[230] = 0.0294000000;
					g[231] = 11.5500000000; fxg[231] = 1.4346000000; feg[231] = 0.0291000000;
					g[232] = 11.6000000000; fxg[232] = 1.4233000000; feg[232] = 0.0289000000;
					g[233] = 11.6500000000; fxg[233] = 1.4119000000; feg[233] = 0.0286000000;
					g[234] = 11.7000000000; fxg[234] = 1.4011000000; feg[234] = 0.0284000000;
					g[235] = 11.7500000000; fxg[235] = 1.3911000000; feg[235] = 0.0282000000;
					g[236] = 11.8000000000; fxg[236] = 1.3821000000; feg[236] = 0.0279000000;
					g[237] = 11.8500000000; fxg[237] = 1.3747000000; feg[237] = 0.0277000000;
					g[238] = 11.9000000000; fxg[238] = 1.3694000000; feg[238] = 0.0275000000;
					g[239] = 11.9500000000; fxg[239] = 1.3666000000; feg[239] = 0.0272000000;
					g[240] = 12.0000000000; fxg[240] = 1.3662000000; feg[240] = 0.0270000000;
					break;
				case 43:
					g[0] = 0.0000000000; fxg[0] = 43.0000000000; feg[0] = 10.5017000000;
					g[1] = 0.0500000000; fxg[1] = 42.7313000000; feg[1] = 10.2878000000;
					g[2] = 0.1000000000; fxg[2] = 41.9856000000; feg[2] = 9.7112000000;
					g[3] = 0.1500000000; fxg[3] = 40.9030000000; feg[3] = 8.9223000000;
					g[4] = 0.2000000000; fxg[4] = 39.6272000000; feg[4] = 8.0723000000;
					g[5] = 0.2500000000; fxg[5] = 38.2603000000; feg[5] = 7.2600000000;
					g[6] = 0.3000000000; fxg[6] = 36.8622000000; feg[6] = 6.5289000000;
					g[7] = 0.3500000000; fxg[7] = 35.4664000000; feg[7] = 5.8875000000;
					g[8] = 0.4000000000; fxg[8] = 34.0945000000; feg[8] = 5.3285000000;
					g[9] = 0.4500000000; fxg[9] = 32.7618000000; feg[9] = 4.8402000000;
					g[10] = 0.5000000000; fxg[10] = 31.4804000000; feg[10] = 4.4113000000;
					g[11] = 0.5500000000; fxg[11] = 30.2591000000; feg[11] = 4.0322000000;
					g[12] = 0.6000000000; fxg[12] = 29.1039000000; feg[12] = 3.6954000000;
					g[13] = 0.6500000000; fxg[13] = 28.0182000000; feg[13] = 3.3947000000;
					g[14] = 0.7000000000; fxg[14] = 27.0030000000; feg[14] = 3.1254000000;
					g[15] = 0.7500000000; fxg[15] = 26.0574000000; feg[15] = 2.8835000000;
					g[16] = 0.8000000000; fxg[16] = 25.1789000000; feg[16] = 2.6658000000;
					g[17] = 0.8500000000; fxg[17] = 24.3638000000; feg[17] = 2.4694000000;
					g[18] = 0.9000000000; fxg[18] = 23.6075000000; feg[18] = 2.2920000000;
					g[19] = 0.9500000000; fxg[19] = 22.9049000000; feg[19] = 2.1316000000;
					g[20] = 1.0000000000; fxg[20] = 22.2507000000; feg[20] = 1.9864000000;
					g[21] = 1.0500000000; fxg[21] = 21.6394000000; feg[21] = 1.8548000000;
					g[22] = 1.1000000000; fxg[22] = 21.0657000000; feg[22] = 1.7354000000;
					g[23] = 1.1500000000; fxg[23] = 20.5245000000; feg[23] = 1.6270000000;
					g[24] = 1.2000000000; fxg[24] = 20.0112000000; feg[24] = 1.5284000000;
					g[25] = 1.2500000000; fxg[25] = 19.5215000000; feg[25] = 1.4385000000;
					g[26] = 1.3000000000; fxg[26] = 19.0516000000; feg[26] = 1.3566000000;
					g[27] = 1.3500000000; fxg[27] = 18.5983000000; feg[27] = 1.2818000000;
					g[28] = 1.4000000000; fxg[28] = 18.1588000000; feg[28] = 1.2133000000;
					g[29] = 1.4500000000; fxg[29] = 17.7308000000; feg[29] = 1.1506000000;
					g[30] = 1.5000000000; fxg[30] = 17.3123000000; feg[30] = 1.0930000000;
					g[31] = 1.5500000000; fxg[31] = 16.9020000000; feg[31] = 1.0400000000;
					g[32] = 1.6000000000; fxg[32] = 16.4987000000; feg[32] = 0.9911000000;
					g[33] = 1.6500000000; fxg[33] = 16.1018000000; feg[33] = 0.9459000000;
					g[34] = 1.7000000000; fxg[34] = 15.7105000000; feg[34] = 0.9040000000;
					g[35] = 1.7500000000; fxg[35] = 15.3248000000; feg[35] = 0.8651000000;
					g[36] = 1.8000000000; fxg[36] = 14.9447000000; feg[36] = 0.8290000000;
					g[37] = 1.8500000000; fxg[37] = 14.5701000000; feg[37] = 0.7952000000;
					g[38] = 1.9000000000; fxg[38] = 14.2012000000; feg[38] = 0.7637000000;
					g[39] = 1.9500000000; fxg[39] = 13.8384000000; feg[39] = 0.7342000000;
					g[40] = 2.0000000000; fxg[40] = 13.4822000000; feg[40] = 0.7065000000;
					g[41] = 2.0500000000; fxg[41] = 13.1327000000; feg[41] = 0.6804000000;
					g[42] = 2.1000000000; fxg[42] = 12.7903000000; feg[42] = 0.6558000000;
					g[43] = 2.1500000000; fxg[43] = 12.4556000000; feg[43] = 0.6326000000;
					g[44] = 2.2000000000; fxg[44] = 12.1293000000; feg[44] = 0.6106000000;
					g[45] = 2.2500000000; fxg[45] = 11.8113000000; feg[45] = 0.5898000000;
					g[46] = 2.3000000000; fxg[46] = 11.5017000000; feg[46] = 0.5700000000;
					g[47] = 2.3500000000; fxg[47] = 11.2010000000; feg[47] = 0.5512000000;
					g[48] = 2.4000000000; fxg[48] = 10.9100000000; feg[48] = 0.5334000000;
					g[49] = 2.4500000000; fxg[49] = 10.6287000000; feg[49] = 0.5163000000;
					g[50] = 2.5000000000; fxg[50] = 10.3567000000; feg[50] = 0.5000000000;
					g[51] = 2.5500000000; fxg[51] = 10.0939000000; feg[51] = 0.4845000000;
					g[52] = 2.6000000000; fxg[52] = 9.8408000000; feg[52] = 0.4696000000;
					g[53] = 2.6500000000; fxg[53] = 9.5979000000; feg[53] = 0.4554000000;
					g[54] = 2.7000000000; fxg[54] = 9.3652000000; feg[54] = 0.4417000000;
					g[55] = 2.7500000000; fxg[55] = 9.1419000000; feg[55] = 0.4286000000;
					g[56] = 2.8000000000; fxg[56] = 8.9273000000; feg[56] = 0.4161000000;
					g[57] = 2.8500000000; fxg[57] = 8.7216000000; feg[57] = 0.4040000000;
					g[58] = 2.9000000000; fxg[58] = 8.5254000000; feg[58] = 0.3924000000;
					g[59] = 2.9500000000; fxg[59] = 8.3390000000; feg[59] = 0.3813000000;
					g[60] = 3.0000000000; fxg[60] = 8.1615000000; feg[60] = 0.3706000000;
					g[61] = 3.0500000000; fxg[61] = 7.9919000000; feg[61] = 0.3603000000;
					g[62] = 3.1000000000; fxg[62] = 7.8295000000; feg[62] = 0.3504000000;
					g[63] = 3.1500000000; fxg[63] = 7.6745000000; feg[63] = 0.3408000000;
					g[64] = 3.2000000000; fxg[64] = 7.5274000000; feg[64] = 0.3316000000;
					g[65] = 3.2500000000; fxg[65] = 7.3886000000; feg[65] = 0.3228000000;
					g[66] = 3.3000000000; fxg[66] = 7.2573000000; feg[66] = 0.3142000000;
					g[67] = 3.3500000000; fxg[67] = 7.1322000000; feg[67] = 0.3060000000;
					g[68] = 3.4000000000; fxg[68] = 7.0123000000; feg[68] = 0.2980000000;
					g[69] = 3.4500000000; fxg[69] = 6.8975000000; feg[69] = 0.2904000000;
					g[70] = 3.5000000000; fxg[70] = 6.7882000000; feg[70] = 0.2830000000;
					g[71] = 3.5500000000; fxg[71] = 6.6850000000; feg[71] = 0.2759000000;
					g[72] = 3.6000000000; fxg[72] = 6.5880000000; feg[72] = 0.2690000000;
					g[73] = 3.6500000000; fxg[73] = 6.4963000000; feg[73] = 0.2623000000;
					g[74] = 3.7000000000; fxg[74] = 6.4085000000; feg[74] = 0.2559000000;
					g[75] = 3.7500000000; fxg[75] = 6.3237000000; feg[75] = 0.2497000000;
					g[76] = 3.8000000000; fxg[76] = 6.2417000000; feg[76] = 0.2437000000;
					g[77] = 3.8500000000; fxg[77] = 6.1631000000; feg[77] = 0.2379000000;
					g[78] = 3.9000000000; fxg[78] = 6.0884000000; feg[78] = 0.2323000000;
					g[79] = 3.9500000000; fxg[79] = 6.0179000000; feg[79] = 0.2269000000;
					g[80] = 4.0000000000; fxg[80] = 5.9515000000; feg[80] = 0.2217000000;
					g[81] = 4.0500000000; fxg[81] = 5.8879000000; feg[81] = 0.2166000000;
					g[82] = 4.1000000000; fxg[82] = 5.8259000000; feg[82] = 0.2117000000;
					g[83] = 4.1500000000; fxg[83] = 5.7648000000; feg[83] = 0.2070000000;
					g[84] = 4.2000000000; fxg[84] = 5.7050000000; feg[84] = 0.2024000000;
					g[85] = 4.2500000000; fxg[85] = 5.6468000000; feg[85] = 0.1980000000;
					g[86] = 4.3000000000; fxg[86] = 5.5908000000; feg[86] = 0.1937000000;
					g[87] = 4.3500000000; fxg[87] = 5.5373000000; feg[87] = 0.1895000000;
					g[88] = 4.4000000000; fxg[88] = 5.4867000000; feg[88] = 0.1855000000;
					g[89] = 4.4500000000; fxg[89] = 5.4382000000; feg[89] = 0.1816000000;
					g[90] = 4.5000000000; fxg[90] = 5.3903000000; feg[90] = 0.1778000000;
					g[91] = 4.5500000000; fxg[91] = 5.3421000000; feg[91] = 0.1741000000;
					g[92] = 4.6000000000; fxg[92] = 5.2937000000; feg[92] = 0.1706000000;
					g[93] = 4.6500000000; fxg[93] = 5.2456000000; feg[93] = 0.1672000000;
					g[94] = 4.7000000000; fxg[94] = 5.1982000000; feg[94] = 0.1638000000;
					g[95] = 4.7500000000; fxg[95] = 5.1517000000; feg[95] = 0.1606000000;
					g[96] = 4.8000000000; fxg[96] = 5.1067000000; feg[96] = 0.1575000000;
					g[97] = 4.8500000000; fxg[97] = 5.0638000000; feg[97] = 0.1544000000;
					g[98] = 4.9000000000; fxg[98] = 5.0226000000; feg[98] = 0.1514000000;
					g[99] = 4.9500000000; fxg[99] = 4.9817000000; feg[99] = 0.1485000000;
					g[100] = 5.0000000000; fxg[100] = 4.9398000000; feg[100] = 0.1457000000;
					g[101] = 5.0500000000; fxg[101] = 4.8968000000; feg[101] = 0.1430000000;
					g[102] = 5.1000000000; fxg[102] = 4.8532000000; feg[102] = 0.1404000000;
					g[103] = 5.1500000000; fxg[103] = 4.8097000000; feg[103] = 0.1379000000;
					g[104] = 5.2000000000; fxg[104] = 4.7664000000; feg[104] = 0.1354000000;
					g[105] = 5.2500000000; fxg[105] = 4.7234000000; feg[105] = 0.1329000000;
					g[106] = 5.3000000000; fxg[106] = 4.6813000000; feg[106] = 0.1306000000;
					g[107] = 5.3500000000; fxg[107] = 4.6410000000; feg[107] = 0.1283000000;
					g[108] = 5.4000000000; fxg[108] = 4.6024000000; feg[108] = 0.1261000000;
					g[109] = 5.4500000000; fxg[109] = 4.5643000000; feg[109] = 0.1239000000;
					g[110] = 5.5000000000; fxg[110] = 4.5251000000; feg[110] = 0.1218000000;
					g[111] = 5.5500000000; fxg[111] = 4.4843000000; feg[111] = 0.1197000000;
					g[112] = 5.6000000000; fxg[112] = 4.4423000000; feg[112] = 0.1177000000;
					g[113] = 5.6500000000; fxg[113] = 4.4001000000; feg[113] = 0.1158000000;
					g[114] = 5.7000000000; fxg[114] = 4.3581000000; feg[114] = 0.1139000000;
					g[115] = 5.7500000000; fxg[115] = 4.3160000000; feg[115] = 0.1120000000;
					g[116] = 5.8000000000; fxg[116] = 4.2740000000; feg[116] = 0.1102000000;
					g[117] = 5.8500000000; fxg[117] = 4.2327000000; feg[117] = 0.1084000000;
					g[118] = 5.9000000000; fxg[118] = 4.1931000000; feg[118] = 0.1067000000;
					g[119] = 5.9500000000; fxg[119] = 4.1554000000; feg[119] = 0.1050000000;
					g[120] = 6.0000000000; fxg[120] = 4.1188000000; feg[120] = 0.1034000000;
					g[121] = 6.0500000000; fxg[121] = 4.0818000000; feg[121] = 0.1018000000;
					g[122] = 6.1000000000; fxg[122] = 4.0430000000; feg[122] = 0.1002000000;
					g[123] = 6.1500000000; fxg[123] = 4.0026000000; feg[123] = 0.0987000000;
					g[124] = 6.2000000000; fxg[124] = 3.9614000000; feg[124] = 0.0972000000;
					g[125] = 6.2500000000; fxg[125] = 3.9204000000; feg[125] = 0.0958000000;
					g[126] = 6.3000000000; fxg[126] = 3.8798000000; feg[126] = 0.0944000000;
					g[127] = 6.3500000000; fxg[127] = 3.8392000000; feg[127] = 0.0930000000;
					g[128] = 6.4000000000; fxg[128] = 3.7986000000; feg[128] = 0.0916000000;
					g[129] = 6.4500000000; fxg[129] = 3.7584000000; feg[129] = 0.0903000000;
					g[130] = 6.5000000000; fxg[130] = 3.7198000000; feg[130] = 0.0890000000;
					g[131] = 6.5500000000; fxg[131] = 3.6833000000; feg[131] = 0.0877000000;
					g[132] = 6.6000000000; fxg[132] = 3.6487000000; feg[132] = 0.0865000000;
					g[133] = 6.6500000000; fxg[133] = 3.6148000000; feg[133] = 0.0853000000;
					g[134] = 6.7000000000; fxg[134] = 3.5799000000; feg[134] = 0.0841000000;
					g[135] = 6.7500000000; fxg[135] = 3.5431000000; feg[135] = 0.0829000000;
					g[136] = 6.8000000000; fxg[136] = 3.5048000000; feg[136] = 0.0818000000;
					g[137] = 6.8500000000; fxg[137] = 3.4659000000; feg[137] = 0.0807000000;
					g[138] = 6.9000000000; fxg[138] = 3.4276000000; feg[138] = 0.0796000000;
					g[139] = 6.9500000000; fxg[139] = 3.3900000000; feg[139] = 0.0785000000;
					g[140] = 7.0000000000; fxg[140] = 3.3525000000; feg[140] = 0.0775000000;
					g[141] = 7.0500000000; fxg[141] = 3.3149000000; feg[141] = 0.0764000000;
					g[142] = 7.1000000000; fxg[142] = 3.2776000000; feg[142] = 0.0754000000;
					g[143] = 7.1500000000; fxg[143] = 3.2413000000; feg[143] = 0.0745000000;
					g[144] = 7.2000000000; fxg[144] = 3.2069000000; feg[144] = 0.0735000000;
					g[145] = 7.2500000000; fxg[145] = 3.1750000000; feg[145] = 0.0725000000;
					g[146] = 7.3000000000; fxg[146] = 3.1450000000; feg[146] = 0.0716000000;
					g[147] = 7.3500000000; fxg[147] = 3.1157000000; feg[147] = 0.0707000000;
					g[148] = 7.4000000000; fxg[148] = 3.0854000000; feg[148] = 0.0698000000;
					g[149] = 7.4500000000; fxg[149] = 3.0532000000; feg[149] = 0.0689000000;
					g[150] = 7.5000000000; fxg[150] = 3.0193000000; feg[150] = 0.0680000000;
					g[151] = 7.5500000000; fxg[151] = 2.9847000000; feg[151] = 0.0672000000;
					g[152] = 7.6000000000; fxg[152] = 2.9505000000; feg[152] = 0.0664000000;
					g[153] = 7.6500000000; fxg[153] = 2.9172000000; feg[153] = 0.0656000000;
					g[154] = 7.7000000000; fxg[154] = 2.8846000000; feg[154] = 0.0648000000;
					g[155] = 7.7500000000; fxg[155] = 2.8520000000; feg[155] = 0.0640000000;
					g[156] = 7.8000000000; fxg[156] = 2.8193000000; feg[156] = 0.0632000000;
					g[157] = 7.8500000000; fxg[157] = 2.7870000000; feg[157] = 0.0625000000;
					g[158] = 7.9000000000; fxg[158] = 2.7558000000; feg[158] = 0.0617000000;
					g[159] = 7.9500000000; fxg[159] = 2.7265000000; feg[159] = 0.0610000000;
					g[160] = 8.0000000000; fxg[160] = 2.6999000000; feg[160] = 0.0603000000;
					g[161] = 8.0500000000; fxg[161] = 2.6755000000; feg[161] = 0.0596000000;
					g[162] = 8.1000000000; fxg[162] = 2.6524000000; feg[162] = 0.0589000000;
					g[163] = 8.1500000000; fxg[163] = 2.6289000000; feg[163] = 0.0582000000;
					g[164] = 8.2000000000; fxg[164] = 2.6038000000; feg[164] = 0.0575000000;
					g[165] = 8.2500000000; fxg[165] = 2.5767000000; feg[165] = 0.0569000000;
					g[166] = 8.3000000000; fxg[166] = 2.5482000000; feg[166] = 0.0562000000;
					g[167] = 8.3500000000; fxg[167] = 2.5192000000; feg[167] = 0.0556000000;
					g[168] = 8.4000000000; fxg[168] = 2.4908000000; feg[168] = 0.0550000000;
					g[169] = 8.4500000000; fxg[169] = 2.4635000000; feg[169] = 0.0544000000;
					g[170] = 8.5000000000; fxg[170] = 2.4368000000; feg[170] = 0.0537000000;
					g[171] = 8.5500000000; fxg[171] = 2.4102000000; feg[171] = 0.0532000000;
					g[172] = 8.6000000000; fxg[172] = 2.3834000000; feg[172] = 0.0526000000;
					g[173] = 8.6500000000; fxg[173] = 2.3568000000; feg[173] = 0.0520000000;
					g[174] = 8.7000000000; fxg[174] = 2.3310000000; feg[174] = 0.0514000000;
					g[175] = 8.7500000000; fxg[175] = 2.3066000000; feg[175] = 0.0509000000;
					g[176] = 8.8000000000; fxg[176] = 2.2844000000; feg[176] = 0.0503000000;
					g[177] = 8.8500000000; fxg[177] = 2.2648000000; feg[177] = 0.0498000000;
					g[178] = 8.9000000000; fxg[178] = 2.2476000000; feg[178] = 0.0493000000;
					g[179] = 8.9500000000; fxg[179] = 2.2314000000; feg[179] = 0.0487000000;
					g[180] = 9.0000000000; fxg[180] = 2.2149000000; feg[180] = 0.0482000000;
					g[181] = 9.0500000000; fxg[181] = 2.1968000000; feg[181] = 0.0477000000;
					g[182] = 9.1000000000; fxg[182] = 2.1768000000; feg[182] = 0.0472000000;
					g[183] = 9.1500000000; fxg[183] = 2.1549000000; feg[183] = 0.0467000000;
					g[184] = 9.2000000000; fxg[184] = 2.1320000000; feg[184] = 0.0462000000;
					g[185] = 9.2500000000; fxg[185] = 2.1092000000; feg[185] = 0.0458000000;
					g[186] = 9.3000000000; fxg[186] = 2.0873000000; feg[186] = 0.0453000000;
					g[187] = 9.3500000000; fxg[187] = 2.0664000000; feg[187] = 0.0448000000;
					g[188] = 9.4000000000; fxg[188] = 2.0460000000; feg[188] = 0.0444000000;
					g[189] = 9.4500000000; fxg[189] = 2.0253000000; feg[189] = 0.0439000000;
					g[190] = 9.5000000000; fxg[190] = 2.0044000000; feg[190] = 0.0435000000;
					g[191] = 9.5500000000; fxg[191] = 1.9837000000; feg[191] = 0.0431000000;
					g[192] = 9.6000000000; fxg[192] = 1.9636000000; feg[192] = 0.0426000000;
					g[193] = 9.6500000000; fxg[193] = 1.9448000000; feg[193] = 0.0422000000;
					g[194] = 9.7000000000; fxg[194] = 1.9277000000; feg[194] = 0.0418000000;
					g[195] = 9.7500000000; fxg[195] = 1.9131000000; feg[195] = 0.0414000000;
					g[196] = 9.8000000000; fxg[196] = 1.9010000000; feg[196] = 0.0410000000;
					g[197] = 9.8500000000; fxg[197] = 1.8909000000; feg[197] = 0.0406000000;
					g[198] = 9.9000000000; fxg[198] = 1.8815000000; feg[198] = 0.0402000000;
					g[199] = 9.9500000000; fxg[199] = 1.8714000000; feg[199] = 0.0398000000;
					g[200] = 10.0000000000; fxg[200] = 1.8596000000; feg[200] = 0.0394000000;
					g[201] = 10.0500000000; fxg[201] = 1.8458000000; feg[201] = 0.0390000000;
					g[202] = 10.1000000000; fxg[202] = 1.8301000000; feg[202] = 0.0386000000;
					g[203] = 10.1500000000; fxg[203] = 1.8130000000; feg[203] = 0.0383000000;
					g[204] = 10.2000000000; fxg[204] = 1.7954000000; feg[204] = 0.0379000000;
					g[205] = 10.2500000000; fxg[205] = 1.7785000000; feg[205] = 0.0376000000;
					g[206] = 10.3000000000; fxg[206] = 1.7626000000; feg[206] = 0.0372000000;
					g[207] = 10.3500000000; fxg[207] = 1.7475000000; feg[207] = 0.0369000000;
					g[208] = 10.4000000000; fxg[208] = 1.7324000000; feg[208] = 0.0365000000;
					g[209] = 10.4500000000; fxg[209] = 1.7169000000; feg[209] = 0.0362000000;
					g[210] = 10.5000000000; fxg[210] = 1.7010000000; feg[210] = 0.0359000000;
					g[211] = 10.5500000000; fxg[211] = 1.6853000000; feg[211] = 0.0355000000;
					g[212] = 10.6000000000; fxg[212] = 1.6702000000; feg[212] = 0.0352000000;
					g[213] = 10.6500000000; fxg[213] = 1.6561000000; feg[213] = 0.0349000000;
					g[214] = 10.7000000000; fxg[214] = 1.6436000000; feg[214] = 0.0346000000;
					g[215] = 10.7500000000; fxg[215] = 1.6331000000; feg[215] = 0.0343000000;
					g[216] = 10.8000000000; fxg[216] = 1.6250000000; feg[216] = 0.0340000000;
					g[217] = 10.8500000000; fxg[217] = 1.6194000000; feg[217] = 0.0337000000;
					g[218] = 10.9000000000; fxg[218] = 1.6154000000; feg[218] = 0.0333000000;
					g[219] = 10.9500000000; fxg[219] = 1.6116000000; feg[219] = 0.0330000000;
					g[220] = 11.0000000000; fxg[220] = 1.6068000000; feg[220] = 0.0328000000;
					g[221] = 11.0500000000; fxg[221] = 1.6001000000; feg[221] = 0.0325000000;
					g[222] = 11.1000000000; fxg[222] = 1.5915000000; feg[222] = 0.0322000000;
					g[223] = 11.1500000000; fxg[223] = 1.5808000000; feg[223] = 0.0319000000;
					g[224] = 11.2000000000; fxg[224] = 1.5686000000; feg[224] = 0.0316000000;
					g[225] = 11.2500000000; fxg[225] = 1.5554000000; feg[225] = 0.0313000000;
					g[226] = 11.3000000000; fxg[226] = 1.5423000000; feg[226] = 0.0311000000;
					g[227] = 11.3500000000; fxg[227] = 1.5302000000; feg[227] = 0.0308000000;
					g[228] = 11.4000000000; fxg[228] = 1.5189000000; feg[228] = 0.0306000000;
					g[229] = 11.4500000000; fxg[229] = 1.5082000000; feg[229] = 0.0303000000;
					g[230] = 11.5000000000; fxg[230] = 1.4972000000; feg[230] = 0.0300000000;
					g[231] = 11.5500000000; fxg[231] = 1.4856000000; feg[231] = 0.0298000000;
					g[232] = 11.6000000000; fxg[232] = 1.4734000000; feg[232] = 0.0295000000;
					g[233] = 11.6500000000; fxg[233] = 1.4614000000; feg[233] = 0.0293000000;
					g[234] = 11.7000000000; fxg[234] = 1.4499000000; feg[234] = 0.0291000000;
					g[235] = 11.7500000000; fxg[235] = 1.4393000000; feg[235] = 0.0288000000;
					g[236] = 11.8000000000; fxg[236] = 1.4298000000; feg[236] = 0.0286000000;
					g[237] = 11.8500000000; fxg[237] = 1.4219000000; feg[237] = 0.0283000000;
					g[238] = 11.9000000000; fxg[238] = 1.4161000000; feg[238] = 0.0281000000;
					g[239] = 11.9500000000; fxg[239] = 1.4129000000; feg[239] = 0.0279000000;
					g[240] = 12.0000000000; fxg[240] = 1.4118000000; feg[240] = 0.0276000000;
					break;
				case 44:
					g[0] = 0.0000000000; fxg[0] = 44.0000000000; feg[0] = 10.1361000000;
					g[1] = 0.0500000000; fxg[1] = 43.7403000000; feg[1] = 9.9443000000;
					g[2] = 0.1000000000; fxg[2] = 43.0155000000; feg[2] = 9.4250000000;
					g[3] = 0.1500000000; fxg[3] = 41.9531000000; feg[3] = 8.7094000000;
					g[4] = 0.2000000000; fxg[4] = 40.6864000000; feg[4] = 7.9307000000;
					g[5] = 0.2500000000; fxg[5] = 39.3135000000; feg[5] = 7.1785000000;
					g[6] = 0.3000000000; fxg[6] = 37.8951000000; feg[6] = 6.4939000000;
					g[7] = 0.3500000000; fxg[7] = 36.4674000000; feg[7] = 5.8867000000;
					g[8] = 0.4000000000; fxg[8] = 35.0551000000; feg[8] = 5.3521000000;
					g[9] = 0.4500000000; fxg[9] = 33.6765000000; feg[9] = 4.8806000000;
					g[10] = 0.5000000000; fxg[10] = 32.3458000000; feg[10] = 4.4629000000;
					g[11] = 0.5500000000; fxg[11] = 31.0738000000; feg[11] = 4.0909000000;
					g[12] = 0.6000000000; fxg[12] = 29.8681000000; feg[12] = 3.7581000000;
					g[13] = 0.6500000000; fxg[13] = 28.7331000000; feg[13] = 3.4593000000;
					g[14] = 0.7000000000; fxg[14] = 27.6708000000; feg[14] = 3.1903000000;
					g[15] = 0.7500000000; fxg[15] = 26.6809000000; feg[15] = 2.9476000000;
					g[16] = 0.8000000000; fxg[16] = 25.7615000000; feg[16] = 2.7282000000;
					g[17] = 0.8500000000; fxg[17] = 24.9092000000; feg[17] = 2.5296000000;
					g[18] = 0.9000000000; fxg[18] = 24.1198000000; feg[18] = 2.3497000000;
					g[19] = 0.9500000000; fxg[19] = 23.3883000000; feg[19] = 2.1864000000;
					g[20] = 1.0000000000; fxg[20] = 22.7095000000; feg[20] = 2.0382000000;
					g[21] = 1.0500000000; fxg[21] = 22.0779000000; feg[21] = 1.9036000000;
					g[22] = 1.1000000000; fxg[22] = 21.4882000000; feg[22] = 1.7811000000;
					g[23] = 1.1500000000; fxg[23] = 20.9350000000; feg[23] = 1.6697000000;
					g[24] = 1.2000000000; fxg[24] = 20.4136000000; feg[24] = 1.5681000000;
					g[25] = 1.2500000000; fxg[25] = 19.9192000000; feg[25] = 1.4754000000;
					g[26] = 1.3000000000; fxg[26] = 19.4479000000; feg[26] = 1.3908000000;
					g[27] = 1.3500000000; fxg[27] = 18.9960000000; feg[27] = 1.3134000000;
					g[28] = 1.4000000000; fxg[28] = 18.5602000000; feg[28] = 1.2426000000;
					g[29] = 1.4500000000; fxg[29] = 18.1378000000; feg[29] = 1.1776000000;
					g[30] = 1.5000000000; fxg[30] = 17.7266000000; feg[30] = 1.1179000000;
					g[31] = 1.5500000000; fxg[31] = 17.3246000000; feg[31] = 1.0630000000;
					g[32] = 1.6000000000; fxg[32] = 16.9305000000; feg[32] = 1.0123000000;
					g[33] = 1.6500000000; fxg[33] = 16.5430000000; feg[33] = 0.9655000000;
					g[34] = 1.7000000000; fxg[34] = 16.1613000000; feg[34] = 0.9222000000;
					g[35] = 1.7500000000; fxg[35] = 15.7849000000; feg[35] = 0.8820000000;
					g[36] = 1.8000000000; fxg[36] = 15.4135000000; feg[36] = 0.8447000000;
					g[37] = 1.8500000000; fxg[37] = 15.0470000000; feg[37] = 0.8099000000;
					g[38] = 1.9000000000; fxg[38] = 14.6851000000; feg[38] = 0.7774000000;
					g[39] = 1.9500000000; fxg[39] = 14.3283000000; feg[39] = 0.7470000000;
					g[40] = 2.0000000000; fxg[40] = 13.9769000000; feg[40] = 0.7186000000;
					g[41] = 2.0500000000; fxg[41] = 13.6309000000; feg[41] = 0.6918000000;
					g[42] = 2.1000000000; fxg[42] = 13.2906000000; feg[42] = 0.6667000000;
					g[43] = 2.1500000000; fxg[43] = 12.9567000000; feg[43] = 0.6429000000;
					g[44] = 2.2000000000; fxg[44] = 12.6297000000; feg[44] = 0.6205000000;
					g[45] = 2.2500000000; fxg[45] = 12.3096000000; feg[45] = 0.5993000000;
					g[46] = 2.3000000000; fxg[46] = 11.9967000000; feg[46] = 0.5792000000;
					g[47] = 2.3500000000; fxg[47] = 11.6914000000; feg[47] = 0.5601000000;
					g[48] = 2.4000000000; fxg[48] = 11.3946000000; feg[48] = 0.5419000000;
					g[49] = 2.4500000000; fxg[49] = 11.1063000000; feg[49] = 0.5246000000;
					g[50] = 2.5000000000; fxg[50] = 10.8264000000; feg[50] = 0.5081000000;
					g[51] = 2.5500000000; fxg[51] = 10.5547000000; feg[51] = 0.4924000000;
					g[52] = 2.6000000000; fxg[52] = 10.2919000000; feg[52] = 0.4774000000;
					g[53] = 2.6500000000; fxg[53] = 10.0386000000; feg[53] = 0.4630000000;
					g[54] = 2.7000000000; fxg[54] = 9.7947000000; feg[54] = 0.4492000000;
					g[55] = 2.7500000000; fxg[55] = 9.5596000000; feg[55] = 0.4360000000;
					g[56] = 2.8000000000; fxg[56] = 9.3329000000; feg[56] = 0.4233000000;
					g[57] = 2.8500000000; fxg[57] = 9.1148000000; feg[57] = 0.4112000000;
					g[58] = 2.9000000000; fxg[58] = 8.9060000000; feg[58] = 0.3995000000;
					g[59] = 2.9500000000; fxg[59] = 8.7066000000; feg[59] = 0.3883000000;
					g[60] = 3.0000000000; fxg[60] = 8.5160000000; feg[60] = 0.3774000000;
					g[61] = 3.0500000000; fxg[61] = 8.3333000000; feg[61] = 0.3671000000;
					g[62] = 3.1000000000; fxg[62] = 8.1580000000; feg[62] = 0.3571000000;
					g[63] = 3.1500000000; fxg[63] = 7.9902000000; feg[63] = 0.3474000000;
					g[64] = 3.2000000000; fxg[64] = 7.8306000000; feg[64] = 0.3382000000;
					g[65] = 3.2500000000; fxg[65] = 7.6792000000; feg[65] = 0.3292000000;
					g[66] = 3.3000000000; fxg[66] = 7.5356000000; feg[66] = 0.3206000000;
					g[67] = 3.3500000000; fxg[67] = 7.3986000000; feg[67] = 0.3122000000;
					g[68] = 3.4000000000; fxg[68] = 7.2672000000; feg[68] = 0.3042000000;
					g[69] = 3.4500000000; fxg[69] = 7.1413000000; feg[69] = 0.2965000000;
					g[70] = 3.5000000000; fxg[70] = 7.0214000000; feg[70] = 0.2890000000;
					g[71] = 3.5500000000; fxg[71] = 6.9080000000; feg[71] = 0.2818000000;
					g[72] = 3.6000000000; fxg[72] = 6.8011000000; feg[72] = 0.2748000000;
					g[73] = 3.6500000000; fxg[73] = 6.6998000000; feg[73] = 0.2680000000;
					g[74] = 3.7000000000; fxg[74] = 6.6030000000; feg[74] = 0.2615000000;
					g[75] = 3.7500000000; fxg[75] = 6.5097000000; feg[75] = 0.2552000000;
					g[76] = 3.8000000000; fxg[76] = 6.4199000000; feg[76] = 0.2491000000;
					g[77] = 3.8500000000; fxg[77] = 6.3339000000; feg[77] = 0.2433000000;
					g[78] = 3.9000000000; fxg[78] = 6.2522000000; feg[78] = 0.2376000000;
					g[79] = 3.9500000000; fxg[79] = 6.1752000000; feg[79] = 0.2321000000;
					g[80] = 4.0000000000; fxg[80] = 6.1025000000; feg[80] = 0.2268000000;
					g[81] = 4.0500000000; fxg[81] = 6.0332000000; feg[81] = 0.2216000000;
					g[82] = 4.1000000000; fxg[82] = 5.9658000000; feg[82] = 0.2166000000;
					g[83] = 4.1500000000; fxg[83] = 5.9000000000; feg[83] = 0.2118000000;
					g[84] = 4.2000000000; fxg[84] = 5.8360000000; feg[84] = 0.2071000000;
					g[85] = 4.2500000000; fxg[85] = 5.7740000000; feg[85] = 0.2026000000;
					g[86] = 4.3000000000; fxg[86] = 5.7144000000; feg[86] = 0.1982000000;
					g[87] = 4.3500000000; fxg[87] = 5.6578000000; feg[87] = 0.1940000000;
					g[88] = 4.4000000000; fxg[88] = 5.6042000000; feg[88] = 0.1899000000;
					g[89] = 4.4500000000; fxg[89] = 5.5530000000; feg[89] = 0.1859000000;
					g[90] = 4.5000000000; fxg[90] = 5.5028000000; feg[90] = 0.1820000000;
					g[91] = 4.5500000000; fxg[91] = 5.4527000000; feg[91] = 0.1783000000;
					g[92] = 4.6000000000; fxg[92] = 5.4028000000; feg[92] = 0.1746000000;
					g[93] = 4.6500000000; fxg[93] = 5.3535000000; feg[93] = 0.1711000000;
					g[94] = 4.7000000000; fxg[94] = 5.3051000000; feg[94] = 0.1677000000;
					g[95] = 4.7500000000; fxg[95] = 5.2578000000; feg[95] = 0.1644000000;
					g[96] = 4.8000000000; fxg[96] = 5.2123000000; feg[96] = 0.1612000000;
					g[97] = 4.8500000000; fxg[97] = 5.1689000000; feg[97] = 0.1580000000;
					g[98] = 4.9000000000; fxg[98] = 5.1273000000; feg[98] = 0.1550000000;
					g[99] = 4.9500000000; fxg[99] = 5.0861000000; feg[99] = 0.1520000000;
					g[100] = 5.0000000000; fxg[100] = 5.0443000000; feg[100] = 0.1492000000;
					g[101] = 5.0500000000; fxg[101] = 5.0015000000; feg[101] = 0.1464000000;
					g[102] = 5.1000000000; fxg[102] = 4.9584000000; feg[102] = 0.1437000000;
					g[103] = 5.1500000000; fxg[103] = 4.9155000000; feg[103] = 0.1411000000;
					g[104] = 5.2000000000; fxg[104] = 4.8729000000; feg[104] = 0.1385000000;
					g[105] = 5.2500000000; fxg[105] = 4.8307000000; feg[105] = 0.1360000000;
					g[106] = 5.3000000000; fxg[106] = 4.7895000000; feg[106] = 0.1336000000;
					g[107] = 5.3500000000; fxg[107] = 4.7500000000; feg[107] = 0.1313000000;
					g[108] = 5.4000000000; fxg[108] = 4.7121000000; feg[108] = 0.1290000000;
					g[109] = 5.4500000000; fxg[109] = 4.6747000000; feg[109] = 0.1267000000;
					g[110] = 5.5000000000; fxg[110] = 4.6365000000; feg[110] = 0.1246000000;
					g[111] = 5.5500000000; fxg[111] = 4.5967000000; feg[111] = 0.1225000000;
					g[112] = 5.6000000000; fxg[112] = 4.5559000000; feg[112] = 0.1204000000;
					g[113] = 5.6500000000; fxg[113] = 4.5149000000; feg[113] = 0.1184000000;
					g[114] = 5.7000000000; fxg[114] = 4.4740000000; feg[114] = 0.1165000000;
					g[115] = 5.7500000000; fxg[115] = 4.4331000000; feg[115] = 0.1146000000;
					g[116] = 5.8000000000; fxg[116] = 4.3923000000; feg[116] = 0.1127000000;
					g[117] = 5.8500000000; fxg[117] = 4.3522000000; feg[117] = 0.1109000000;
					g[118] = 5.9000000000; fxg[118] = 4.3137000000; feg[118] = 0.1091000000;
					g[119] = 5.9500000000; fxg[119] = 4.2769000000; feg[119] = 0.1074000000;
					g[120] = 6.0000000000; fxg[120] = 4.2411000000; feg[120] = 0.1057000000;
					g[121] = 6.0500000000; fxg[121] = 4.2049000000; feg[121] = 0.1041000000;
					g[122] = 6.1000000000; fxg[122] = 4.1671000000; feg[122] = 0.1025000000;
					g[123] = 6.1500000000; fxg[123] = 4.1277000000; feg[123] = 0.1009000000;
					g[124] = 6.2000000000; fxg[124] = 4.0875000000; feg[124] = 0.0994000000;
					g[125] = 6.2500000000; fxg[125] = 4.0474000000; feg[125] = 0.0979000000;
					g[126] = 6.3000000000; fxg[126] = 4.0077000000; feg[126] = 0.0965000000;
					g[127] = 6.3500000000; fxg[127] = 3.9679000000; feg[127] = 0.0950000000;
					g[128] = 6.4000000000; fxg[128] = 3.9280000000; feg[128] = 0.0937000000;
					g[129] = 6.4500000000; fxg[129] = 3.8887000000; feg[129] = 0.0923000000;
					g[130] = 6.5000000000; fxg[130] = 3.8508000000; feg[130] = 0.0910000000;
					g[131] = 6.5500000000; fxg[131] = 3.8148000000; feg[131] = 0.0897000000;
					g[132] = 6.6000000000; fxg[132] = 3.7806000000; feg[132] = 0.0884000000;
					g[133] = 6.6500000000; fxg[133] = 3.7469000000; feg[133] = 0.0871000000;
					g[134] = 6.7000000000; fxg[134] = 3.7123000000; feg[134] = 0.0859000000;
					g[135] = 6.7500000000; fxg[135] = 3.6759000000; feg[135] = 0.0847000000;
					g[136] = 6.8000000000; fxg[136] = 3.6380000000; feg[136] = 0.0836000000;
					g[137] = 6.8500000000; fxg[137] = 3.5996000000; feg[137] = 0.0824000000;
					g[138] = 6.9000000000; fxg[138] = 3.5615000000; feg[138] = 0.0813000000;
					g[139] = 6.9500000000; fxg[139] = 3.5240000000; feg[139] = 0.0802000000;
					g[140] = 7.0000000000; fxg[140] = 3.4866000000; feg[140] = 0.0792000000;
					g[141] = 7.0500000000; fxg[141] = 3.4491000000; feg[141] = 0.0781000000;
					g[142] = 7.1000000000; fxg[142] = 3.4119000000; feg[142] = 0.0771000000;
					g[143] = 7.1500000000; fxg[143] = 3.3757000000; feg[143] = 0.0761000000;
					g[144] = 7.2000000000; fxg[144] = 3.3413000000; feg[144] = 0.0751000000;
					g[145] = 7.2500000000; fxg[145] = 3.3091000000; feg[145] = 0.0741000000;
					g[146] = 7.3000000000; fxg[146] = 3.2788000000; feg[146] = 0.0732000000;
					g[147] = 7.3500000000; fxg[147] = 3.2490000000; feg[147] = 0.0722000000;
					g[148] = 7.4000000000; fxg[148] = 3.2182000000; feg[148] = 0.0713000000;
					g[149] = 7.4500000000; fxg[149] = 3.1857000000; feg[149] = 0.0704000000;
					g[150] = 7.5000000000; fxg[150] = 3.1515000000; feg[150] = 0.0695000000;
					g[151] = 7.5500000000; fxg[151] = 3.1167000000; feg[151] = 0.0687000000;
					g[152] = 7.6000000000; fxg[152] = 3.0821000000; feg[152] = 0.0678000000;
					g[153] = 7.6500000000; fxg[153] = 3.0483000000; feg[153] = 0.0670000000;
					g[154] = 7.7000000000; fxg[154] = 3.0150000000; feg[154] = 0.0662000000;
					g[155] = 7.7500000000; fxg[155] = 2.9818000000; feg[155] = 0.0654000000;
					g[156] = 7.8000000000; fxg[156] = 2.9485000000; feg[156] = 0.0646000000;
					g[157] = 7.8500000000; fxg[157] = 2.9157000000; feg[157] = 0.0638000000;
					g[158] = 7.9000000000; fxg[158] = 2.8839000000; feg[158] = 0.0631000000;
					g[159] = 7.9500000000; fxg[159] = 2.8541000000; feg[159] = 0.0623000000;
					g[160] = 8.0000000000; fxg[160] = 2.8266000000; feg[160] = 0.0616000000;
					g[161] = 8.0500000000; fxg[161] = 2.8013000000; feg[161] = 0.0609000000;
					g[162] = 8.1000000000; fxg[162] = 2.7772000000; feg[162] = 0.0602000000;
					g[163] = 8.1500000000; fxg[163] = 2.7526000000; feg[163] = 0.0594000000;
					g[164] = 8.2000000000; fxg[164] = 2.7266000000; feg[164] = 0.0588000000;
					g[165] = 8.2500000000; fxg[165] = 2.6988000000; feg[165] = 0.0581000000;
					g[166] = 8.3000000000; fxg[166] = 2.6695000000; feg[166] = 0.0574000000;
					g[167] = 8.3500000000; fxg[167] = 2.6397000000; feg[167] = 0.0568000000;
					g[168] = 8.4000000000; fxg[168] = 2.6104000000; feg[168] = 0.0562000000;
					g[169] = 8.4500000000; fxg[169] = 2.5821000000; feg[169] = 0.0555000000;
					g[170] = 8.5000000000; fxg[170] = 2.5543000000; feg[170] = 0.0549000000;
					g[171] = 8.5500000000; fxg[171] = 2.5266000000; feg[171] = 0.0543000000;
					g[172] = 8.6000000000; fxg[172] = 2.4987000000; feg[172] = 0.0537000000;
					g[173] = 8.6500000000; fxg[173] = 2.4712000000; feg[173] = 0.0531000000;
					g[174] = 8.7000000000; fxg[174] = 2.4445000000; feg[174] = 0.0526000000;
					g[175] = 8.7500000000; fxg[175] = 2.4192000000; feg[175] = 0.0520000000;
					g[176] = 8.8000000000; fxg[176] = 2.3960000000; feg[176] = 0.0514000000;
					g[177] = 8.8500000000; fxg[177] = 2.3753000000; feg[177] = 0.0509000000;
					g[178] = 8.9000000000; fxg[178] = 2.3568000000; feg[178] = 0.0503000000;
					g[179] = 8.9500000000; fxg[179] = 2.3393000000; feg[179] = 0.0498000000;
					g[180] = 9.0000000000; fxg[180] = 2.3215000000; feg[180] = 0.0493000000;
					g[181] = 9.0500000000; fxg[181] = 2.3023000000; feg[181] = 0.0487000000;
					g[182] = 9.1000000000; fxg[182] = 2.2811000000; feg[182] = 0.0482000000;
					g[183] = 9.1500000000; fxg[183] = 2.2583000000; feg[183] = 0.0477000000;
					g[184] = 9.2000000000; fxg[184] = 2.2344000000; feg[184] = 0.0472000000;
					g[185] = 9.2500000000; fxg[185] = 2.2106000000; feg[185] = 0.0468000000;
					g[186] = 9.3000000000; fxg[186] = 2.1875000000; feg[186] = 0.0463000000;
					g[187] = 9.3500000000; fxg[187] = 2.1654000000; feg[187] = 0.0458000000;
					g[188] = 9.4000000000; fxg[188] = 2.1436000000; feg[188] = 0.0453000000;
					g[189] = 9.4500000000; fxg[189] = 2.1218000000; feg[189] = 0.0449000000;
					g[190] = 9.5000000000; fxg[190] = 2.0997000000; feg[190] = 0.0444000000;
					g[191] = 9.5500000000; fxg[191] = 2.0779000000; feg[191] = 0.0440000000;
					g[192] = 9.6000000000; fxg[192] = 2.0568000000; feg[192] = 0.0436000000;
					g[193] = 9.6500000000; fxg[193] = 2.0370000000; feg[193] = 0.0431000000;
					g[194] = 9.7000000000; fxg[194] = 2.0190000000; feg[194] = 0.0427000000;
					g[195] = 9.7500000000; fxg[195] = 2.0032000000; feg[195] = 0.0423000000;
					g[196] = 9.8000000000; fxg[196] = 1.9900000000; feg[196] = 0.0419000000;
					g[197] = 9.8500000000; fxg[197] = 1.9786000000; feg[197] = 0.0415000000;
					g[198] = 9.9000000000; fxg[198] = 1.9679000000; feg[198] = 0.0411000000;
					g[199] = 9.9500000000; fxg[199] = 1.9566000000; feg[199] = 0.0407000000;
					g[200] = 10.0000000000; fxg[200] = 1.9436000000; feg[200] = 0.0403000000;
					g[201] = 10.0500000000; fxg[201] = 1.9288000000; feg[201] = 0.0399000000;
					g[202] = 10.1000000000; fxg[202] = 1.9121000000; feg[202] = 0.0395000000;
					g[203] = 10.1500000000; fxg[203] = 1.8941000000; feg[203] = 0.0391000000;
					g[204] = 10.2000000000; fxg[204] = 1.8756000000; feg[204] = 0.0388000000;
					g[205] = 10.2500000000; fxg[205] = 1.8576000000; feg[205] = 0.0384000000;
					g[206] = 10.3000000000; fxg[206] = 1.8406000000; feg[206] = 0.0380000000;
					g[207] = 10.3500000000; fxg[207] = 1.8242000000; feg[207] = 0.0377000000;
					g[208] = 10.4000000000; fxg[208] = 1.8079000000; feg[208] = 0.0373000000;
					g[209] = 10.4500000000; fxg[209] = 1.7913000000; feg[209] = 0.0370000000;
					g[210] = 10.5000000000; fxg[210] = 1.7744000000; feg[210] = 0.0367000000;
					g[211] = 10.5500000000; fxg[211] = 1.7577000000; feg[211] = 0.0363000000;
					g[212] = 10.6000000000; fxg[212] = 1.7417000000; feg[212] = 0.0360000000;
					g[213] = 10.6500000000; fxg[213] = 1.7269000000; feg[213] = 0.0357000000;
					g[214] = 10.7000000000; fxg[214] = 1.7135000000; feg[214] = 0.0354000000;
					g[215] = 10.7500000000; fxg[215] = 1.7022000000; feg[215] = 0.0350000000;
					g[216] = 10.8000000000; fxg[216] = 1.6933000000; feg[216] = 0.0347000000;
					g[217] = 10.8500000000; fxg[217] = 1.6867000000; feg[217] = 0.0344000000;
					g[218] = 10.9000000000; fxg[218] = 1.6816000000; feg[218] = 0.0341000000;
					g[219] = 10.9500000000; fxg[219] = 1.6767000000; feg[219] = 0.0338000000;
					g[220] = 11.0000000000; fxg[220] = 1.6708000000; feg[220] = 0.0335000000;
					g[221] = 11.0500000000; fxg[221] = 1.6633000000; feg[221] = 0.0332000000;
					g[222] = 11.1000000000; fxg[222] = 1.6538000000; feg[222] = 0.0329000000;
					g[223] = 11.1500000000; fxg[223] = 1.6424000000; feg[223] = 0.0326000000;
					g[224] = 11.2000000000; fxg[224] = 1.6294000000; feg[224] = 0.0323000000;
					g[225] = 11.2500000000; fxg[225] = 1.6155000000; feg[225] = 0.0321000000;
					g[226] = 11.3000000000; fxg[226] = 1.6017000000; feg[226] = 0.0318000000;
					g[227] = 11.3500000000; fxg[227] = 1.5886000000; feg[227] = 0.0315000000;
					g[228] = 11.4000000000; fxg[228] = 1.5764000000; feg[228] = 0.0313000000;
					g[229] = 11.4500000000; fxg[229] = 1.5646000000; feg[229] = 0.0310000000;
					g[230] = 11.5000000000; fxg[230] = 1.5527000000; feg[230] = 0.0307000000;
					g[231] = 11.5500000000; fxg[231] = 1.5402000000; feg[231] = 0.0305000000;
					g[232] = 11.6000000000; fxg[232] = 1.5273000000; feg[232] = 0.0302000000;
					g[233] = 11.6500000000; fxg[233] = 1.5145000000; feg[233] = 0.0300000000;
					g[234] = 11.7000000000; fxg[234] = 1.5023000000; feg[234] = 0.0297000000;
					g[235] = 11.7500000000; fxg[235] = 1.4911000000; feg[235] = 0.0295000000;
					g[236] = 11.8000000000; fxg[236] = 1.4811000000; feg[236] = 0.0292000000;
					g[237] = 11.8500000000; fxg[237] = 1.4726000000; feg[237] = 0.0290000000;
					g[238] = 11.9000000000; fxg[238] = 1.4664000000; feg[238] = 0.0288000000;
					g[239] = 11.9500000000; fxg[239] = 1.4625000000; feg[239] = 0.0285000000;
					g[240] = 12.0000000000; fxg[240] = 1.4608000000; feg[240] = 0.0283000000;
					break;
				case 45:
					g[0] = 0.0000000000; fxg[0] = 45.0000000000; feg[0] = 9.7569000000;
					g[1] = 0.0500000000; fxg[1] = 44.7497000000; feg[1] = 9.5857000000;
					g[2] = 0.1000000000; fxg[2] = 44.0473000000; feg[2] = 9.1202000000;
					g[3] = 0.1500000000; fxg[3] = 43.0084000000; feg[3] = 8.4738000000;
					g[4] = 0.2000000000; fxg[4] = 41.7562000000; feg[4] = 7.7637000000;
					g[5] = 0.2500000000; fxg[5] = 40.3841000000; feg[5] = 7.0704000000;
					g[6] = 0.3000000000; fxg[6] = 38.9526000000; feg[6] = 6.4327000000;
					g[7] = 0.3500000000; fxg[7] = 37.4999000000; feg[7] = 5.8614000000;
					g[8] = 0.4000000000; fxg[8] = 36.0529000000; feg[8] = 5.3535000000;
					g[9] = 0.4500000000; fxg[9] = 34.6322000000; feg[9] = 4.9015000000;
					g[10] = 0.5000000000; fxg[10] = 33.2545000000; feg[10] = 4.4978000000;
					g[11] = 0.5500000000; fxg[11] = 31.9325000000; feg[11] = 4.1356000000;
					g[12] = 0.6000000000; fxg[12] = 30.6755000000; feg[12] = 3.8093000000;
					g[13] = 0.6500000000; fxg[13] = 29.4893000000; feg[13] = 3.5146000000;
					g[14] = 0.7000000000; fxg[14] = 28.3770000000; feg[14] = 3.2478000000;
					g[15] = 0.7500000000; fxg[15] = 27.3393000000; feg[15] = 3.0058000000;
					g[16] = 0.8000000000; fxg[16] = 26.3748000000; feg[16] = 2.7861000000;
					g[17] = 0.8500000000; fxg[17] = 25.4810000000; feg[17] = 2.5864000000;
					g[18] = 0.9000000000; fxg[18] = 24.6538000000; feg[18] = 2.4047000000;
					g[19] = 0.9500000000; fxg[19] = 23.8887000000; feg[19] = 2.2394000000;
					g[20] = 1.0000000000; fxg[20] = 23.1805000000; feg[20] = 2.0889000000;
					g[21] = 1.0500000000; fxg[21] = 22.5239000000; feg[21] = 1.9517000000;
					g[22] = 1.1000000000; fxg[22] = 21.9134000000; feg[22] = 1.8266000000;
					g[23] = 1.1500000000; fxg[23] = 21.3438000000; feg[23] = 1.7125000000;
					g[24] = 1.2000000000; fxg[24] = 20.8098000000; feg[24] = 1.6082000000;
					g[25] = 1.2500000000; fxg[25] = 20.3068000000; feg[25] = 1.5130000000;
					g[26] = 1.3000000000; fxg[26] = 19.8302000000; feg[26] = 1.4258000000;
					g[27] = 1.3500000000; fxg[27] = 19.3762000000; feg[27] = 1.3460000000;
					g[28] = 1.4000000000; fxg[28] = 18.9410000000; feg[28] = 1.2728000000;
					g[29] = 1.4500000000; fxg[29] = 18.5217000000; feg[29] = 1.2057000000;
					g[30] = 1.5000000000; fxg[30] = 18.1156000000; feg[30] = 1.1439000000;
					g[31] = 1.5500000000; fxg[31] = 17.7203000000; feg[31] = 1.0870000000;
					g[32] = 1.6000000000; fxg[32] = 17.3340000000; feg[32] = 1.0346000000;
					g[33] = 1.6500000000; fxg[33] = 16.9552000000; feg[33] = 0.9862000000;
					g[34] = 1.7000000000; fxg[34] = 16.5828000000; feg[34] = 0.9414000000;
					g[35] = 1.7500000000; fxg[35] = 16.2158000000; feg[35] = 0.8998000000;
					g[36] = 1.8000000000; fxg[36] = 15.8537000000; feg[36] = 0.8612000000;
					g[37] = 1.8500000000; fxg[37] = 15.4960000000; feg[37] = 0.8253000000;
					g[38] = 1.9000000000; fxg[38] = 15.1425000000; feg[38] = 0.7918000000;
					g[39] = 1.9500000000; fxg[39] = 14.7933000000; feg[39] = 0.7605000000;
					g[40] = 2.0000000000; fxg[40] = 14.4485000000; feg[40] = 0.7312000000;
					g[41] = 2.0500000000; fxg[41] = 14.1080000000; feg[41] = 0.7037000000;
					g[42] = 2.1000000000; fxg[42] = 13.7722000000; feg[42] = 0.6779000000;
					g[43] = 2.1500000000; fxg[43] = 13.4415000000; feg[43] = 0.6536000000;
					g[44] = 2.2000000000; fxg[44] = 13.1163000000; feg[44] = 0.6307000000;
					g[45] = 2.2500000000; fxg[45] = 12.7969000000; feg[45] = 0.6090000000;
					g[46] = 2.3000000000; fxg[46] = 12.4834000000; feg[46] = 0.5885000000;
					g[47] = 2.3500000000; fxg[47] = 12.1762000000; feg[47] = 0.5690000000;
					g[48] = 2.4000000000; fxg[48] = 11.8762000000; feg[48] = 0.5505000000;
					g[49] = 2.4500000000; fxg[49] = 11.5836000000; feg[49] = 0.5330000000;
					g[50] = 2.5000000000; fxg[50] = 11.2983000000; feg[50] = 0.5162000000;
					g[51] = 2.5500000000; fxg[51] = 11.0202000000; feg[51] = 0.5003000000;
					g[52] = 2.6000000000; fxg[52] = 10.7500000000; feg[52] = 0.4850000000;
					g[53] = 2.6500000000; fxg[53] = 10.4884000000; feg[53] = 0.4705000000;
					g[54] = 2.7000000000; fxg[54] = 10.2354000000; feg[54] = 0.4565000000;
					g[55] = 2.7500000000; fxg[55] = 9.9905000000; feg[55] = 0.4432000000;
					g[56] = 2.8000000000; fxg[56] = 9.7534000000; feg[56] = 0.4304000000;
					g[57] = 2.8500000000; fxg[57] = 9.5245000000; feg[57] = 0.4181000000;
					g[58] = 2.9000000000; fxg[58] = 9.3044000000; feg[58] = 0.4063000000;
					g[59] = 2.9500000000; fxg[59] = 9.0932000000; feg[59] = 0.3950000000;
					g[60] = 3.0000000000; fxg[60] = 8.8906000000; feg[60] = 0.3841000000;
					g[61] = 3.0500000000; fxg[61] = 8.6958000000; feg[61] = 0.3736000000;
					g[62] = 3.1000000000; fxg[62] = 8.5082000000; feg[62] = 0.3635000000;
					g[63] = 3.1500000000; fxg[63] = 8.3283000000; feg[63] = 0.3538000000;
					g[64] = 3.2000000000; fxg[64] = 8.1564000000; feg[64] = 0.3445000000;
					g[65] = 3.2500000000; fxg[65] = 7.9928000000; feg[65] = 0.3354000000;
					g[66] = 3.3000000000; fxg[66] = 7.8370000000; feg[66] = 0.3267000000;
					g[67] = 3.3500000000; fxg[67] = 7.6880000000; feg[67] = 0.3183000000;
					g[68] = 3.4000000000; fxg[68] = 7.5449000000; feg[68] = 0.3102000000;
					g[69] = 3.4500000000; fxg[69] = 7.4078000000; feg[69] = 0.3024000000;
					g[70] = 3.5000000000; fxg[70] = 7.2769000000; feg[70] = 0.2948000000;
					g[71] = 3.5500000000; fxg[71] = 7.1528000000; feg[71] = 0.2875000000;
					g[72] = 3.6000000000; fxg[72] = 7.0354000000; feg[72] = 0.2804000000;
					g[73] = 3.6500000000; fxg[73] = 6.9240000000; feg[73] = 0.2736000000;
					g[74] = 3.7000000000; fxg[74] = 6.8174000000; feg[74] = 0.2670000000;
					g[75] = 3.7500000000; fxg[75] = 6.7150000000; feg[75] = 0.2606000000;
					g[76] = 3.8000000000; fxg[76] = 6.6165000000; feg[76] = 0.2545000000;
					g[77] = 3.8500000000; fxg[77] = 6.5223000000; feg[77] = 0.2485000000;
					g[78] = 3.9000000000; fxg[78] = 6.4328000000; feg[78] = 0.2427000000;
					g[79] = 3.9500000000; fxg[79] = 6.3482000000; feg[79] = 0.2372000000;
					g[80] = 4.0000000000; fxg[80] = 6.2684000000; feg[80] = 0.2317000000;
					g[81] = 4.0500000000; fxg[81] = 6.1922000000; feg[81] = 0.2265000000;
					g[82] = 4.1000000000; fxg[82] = 6.1187000000; feg[82] = 0.2214000000;
					g[83] = 4.1500000000; fxg[83] = 6.0472000000; feg[83] = 0.2165000000;
					g[84] = 4.2000000000; fxg[84] = 5.9779000000; feg[84] = 0.2118000000;
					g[85] = 4.2500000000; fxg[85] = 5.9111000000; feg[85] = 0.2072000000;
					g[86] = 4.3000000000; fxg[86] = 5.8471000000; feg[86] = 0.2027000000;
					g[87] = 4.3500000000; fxg[87] = 5.7863000000; feg[87] = 0.1984000000;
					g[88] = 4.4000000000; fxg[88] = 5.7289000000; feg[88] = 0.1942000000;
					g[89] = 4.4500000000; fxg[89] = 5.6740000000; feg[89] = 0.1901000000;
					g[90] = 4.5000000000; fxg[90] = 5.6206000000; feg[90] = 0.1862000000;
					g[91] = 4.5500000000; fxg[91] = 5.5677000000; feg[91] = 0.1823000000;
					g[92] = 4.6000000000; fxg[92] = 5.5154000000; feg[92] = 0.1786000000;
					g[93] = 4.6500000000; fxg[93] = 5.4641000000; feg[93] = 0.1750000000;
					g[94] = 4.7000000000; fxg[94] = 5.4140000000; feg[94] = 0.1716000000;
					g[95] = 4.7500000000; fxg[95] = 5.3653000000; feg[95] = 0.1682000000;
					g[96] = 4.8000000000; fxg[96] = 5.3184000000; feg[96] = 0.1649000000;
					g[97] = 4.8500000000; fxg[97] = 5.2738000000; feg[97] = 0.1617000000;
					g[98] = 4.9000000000; fxg[98] = 5.2311000000; feg[98] = 0.1586000000;
					g[99] = 4.9500000000; fxg[99] = 5.1891000000; feg[99] = 0.1555000000;
					g[100] = 5.0000000000; fxg[100] = 5.1467000000; feg[100] = 0.1526000000;
					g[101] = 5.0500000000; fxg[101] = 5.1037000000; feg[101] = 0.1498000000;
					g[102] = 5.1000000000; fxg[102] = 5.0606000000; feg[102] = 0.1470000000;
					g[103] = 5.1500000000; fxg[103] = 5.0178000000; feg[103] = 0.1443000000;
					g[104] = 5.2000000000; fxg[104] = 4.9754000000; feg[104] = 0.1417000000;
					g[105] = 5.2500000000; fxg[105] = 4.9337000000; feg[105] = 0.1392000000;
					g[106] = 5.3000000000; fxg[106] = 4.8929000000; feg[106] = 0.1367000000;
					g[107] = 5.3500000000; fxg[107] = 4.8539000000; feg[107] = 0.1343000000;
					g[108] = 5.4000000000; fxg[108] = 4.8164000000; feg[108] = 0.1319000000;
					g[109] = 5.4500000000; fxg[109] = 4.7795000000; feg[109] = 0.1296000000;
					g[110] = 5.5000000000; fxg[110] = 4.7418000000; feg[110] = 0.1274000000;
					g[111] = 5.5500000000; fxg[111] = 4.7029000000; feg[111] = 0.1252000000;
					g[112] = 5.6000000000; fxg[112] = 4.6630000000; feg[112] = 0.1231000000;
					g[113] = 5.6500000000; fxg[113] = 4.6230000000; feg[113] = 0.1211000000;
					g[114] = 5.7000000000; fxg[114] = 4.5832000000; feg[114] = 0.1191000000;
					g[115] = 5.7500000000; fxg[115] = 4.5434000000; feg[115] = 0.1171000000;
					g[116] = 5.8000000000; fxg[116] = 4.5037000000; feg[116] = 0.1152000000;
					g[117] = 5.8500000000; fxg[117] = 4.4648000000; feg[117] = 0.1134000000;
					g[118] = 5.9000000000; fxg[118] = 4.4272000000; feg[118] = 0.1116000000;
					g[119] = 5.9500000000; fxg[119] = 4.3913000000; feg[119] = 0.1098000000;
					g[120] = 6.0000000000; fxg[120] = 4.3563000000; feg[120] = 0.1081000000;
					g[121] = 6.0500000000; fxg[121] = 4.3209000000; feg[121] = 0.1064000000;
					g[122] = 6.1000000000; fxg[122] = 4.2840000000; feg[122] = 0.1048000000;
					g[123] = 6.1500000000; fxg[123] = 4.2457000000; feg[123] = 0.1032000000;
					g[124] = 6.2000000000; fxg[124] = 4.2066000000; feg[124] = 0.1016000000;
					g[125] = 6.2500000000; fxg[125] = 4.1675000000; feg[125] = 0.1001000000;
					g[126] = 6.3000000000; fxg[126] = 4.1287000000; feg[126] = 0.0986000000;
					g[127] = 6.3500000000; fxg[127] = 4.0899000000; feg[127] = 0.0971000000;
					g[128] = 6.4000000000; fxg[128] = 4.0510000000; feg[128] = 0.0957000000;
					g[129] = 6.4500000000; fxg[129] = 4.0127000000; feg[129] = 0.0943000000;
					g[130] = 6.5000000000; fxg[130] = 3.9756000000; feg[130] = 0.0930000000;
					g[131] = 6.5500000000; fxg[131] = 3.9403000000; feg[131] = 0.0916000000;
					g[132] = 6.6000000000; fxg[132] = 3.9065000000; feg[132] = 0.0903000000;
					g[133] = 6.6500000000; fxg[133] = 3.8732000000; feg[133] = 0.0890000000;
					g[134] = 6.7000000000; fxg[134] = 3.8390000000; feg[134] = 0.0878000000;
					g[135] = 6.7500000000; fxg[135] = 3.8032000000; feg[135] = 0.0866000000;
					g[136] = 6.8000000000; fxg[136] = 3.7659000000; feg[136] = 0.0854000000;
					g[137] = 6.8500000000; fxg[137] = 3.7280000000; feg[137] = 0.0842000000;
					g[138] = 6.9000000000; fxg[138] = 3.6904000000; feg[138] = 0.0831000000;
					g[139] = 6.9500000000; fxg[139] = 3.6533000000; feg[139] = 0.0819000000;
					g[140] = 7.0000000000; fxg[140] = 3.6162000000; feg[140] = 0.0809000000;
					g[141] = 7.0500000000; fxg[141] = 3.5791000000; feg[141] = 0.0798000000;
					g[142] = 7.1000000000; fxg[142] = 3.5422000000; feg[142] = 0.0787000000;
					g[143] = 7.1500000000; fxg[143] = 3.5063000000; feg[143] = 0.0777000000;
					g[144] = 7.2000000000; fxg[144] = 3.4721000000; feg[144] = 0.0767000000;
					g[145] = 7.2500000000; fxg[145] = 3.4399000000; feg[145] = 0.0757000000;
					g[146] = 7.3000000000; fxg[146] = 3.4093000000; feg[146] = 0.0747000000;
					g[147] = 7.3500000000; fxg[147] = 3.3792000000; feg[147] = 0.0738000000;
					g[148] = 7.4000000000; fxg[148] = 3.3482000000; feg[148] = 0.0728000000;
					g[149] = 7.4500000000; fxg[149] = 3.3156000000; feg[149] = 0.0719000000;
					g[150] = 7.5000000000; fxg[150] = 3.2814000000; feg[150] = 0.0710000000;
					g[151] = 7.5500000000; fxg[151] = 3.2465000000; feg[151] = 0.0701000000;
					g[152] = 7.6000000000; fxg[152] = 3.2117000000; feg[152] = 0.0693000000;
					g[153] = 7.6500000000; fxg[153] = 3.1776000000; feg[153] = 0.0684000000;
					g[154] = 7.7000000000; fxg[154] = 3.1440000000; feg[154] = 0.0676000000;
					g[155] = 7.7500000000; fxg[155] = 3.1104000000; feg[155] = 0.0668000000;
					g[156] = 7.8000000000; fxg[156] = 3.0768000000; feg[156] = 0.0660000000;
					g[157] = 7.8500000000; fxg[157] = 3.0436000000; feg[157] = 0.0652000000;
					g[158] = 7.9000000000; fxg[158] = 3.0116000000; feg[158] = 0.0644000000;
					g[159] = 7.9500000000; fxg[159] = 2.9813000000; feg[159] = 0.0636000000;
					g[160] = 8.0000000000; fxg[160] = 2.9532000000; feg[160] = 0.0629000000;
					g[161] = 8.0500000000; fxg[161] = 2.9271000000; feg[161] = 0.0622000000;
					g[162] = 8.1000000000; fxg[162] = 2.9020000000; feg[162] = 0.0614000000;
					g[163] = 8.1500000000; fxg[163] = 2.8766000000; feg[163] = 0.0607000000;
					g[164] = 8.2000000000; fxg[164] = 2.8499000000; feg[164] = 0.0600000000;
					g[165] = 8.2500000000; fxg[165] = 2.8214000000; feg[165] = 0.0593000000;
					g[166] = 8.3000000000; fxg[166] = 2.7915000000; feg[166] = 0.0587000000;
					g[167] = 8.3500000000; fxg[167] = 2.7611000000; feg[167] = 0.0580000000;
					g[168] = 8.4000000000; fxg[168] = 2.7311000000; feg[168] = 0.0573000000;
					g[169] = 8.4500000000; fxg[169] = 2.7019000000; feg[169] = 0.0567000000;
					g[170] = 8.5000000000; fxg[170] = 2.6732000000; feg[170] = 0.0561000000;
					g[171] = 8.5500000000; fxg[171] = 2.6446000000; feg[171] = 0.0555000000;
					g[172] = 8.6000000000; fxg[172] = 2.6159000000; feg[172] = 0.0549000000;
					g[173] = 8.6500000000; fxg[173] = 2.5876000000; feg[173] = 0.0543000000;
					g[174] = 8.7000000000; fxg[174] = 2.5601000000; feg[174] = 0.0537000000;
					g[175] = 8.7500000000; fxg[175] = 2.5340000000; feg[175] = 0.0531000000;
					g[176] = 8.8000000000; fxg[176] = 2.5100000000; feg[176] = 0.0525000000;
					g[177] = 8.8500000000; fxg[177] = 2.4882000000; feg[177] = 0.0520000000;
					g[178] = 8.9000000000; fxg[178] = 2.4685000000; feg[178] = 0.0514000000;
					g[179] = 8.9500000000; fxg[179] = 2.4498000000; feg[179] = 0.0509000000;
					g[180] = 9.0000000000; fxg[180] = 2.4308000000; feg[180] = 0.0503000000;
					g[181] = 9.0500000000; fxg[181] = 2.4104000000; feg[181] = 0.0498000000;
					g[182] = 9.1000000000; fxg[182] = 2.3883000000; feg[182] = 0.0493000000;
					g[183] = 9.1500000000; fxg[183] = 2.3646000000; feg[183] = 0.0488000000;
					g[184] = 9.2000000000; fxg[184] = 2.3399000000; feg[184] = 0.0483000000;
					g[185] = 9.2500000000; fxg[185] = 2.3151000000; feg[185] = 0.0478000000;
					g[186] = 9.3000000000; fxg[186] = 2.2910000000; feg[186] = 0.0473000000;
					g[187] = 9.3500000000; fxg[187] = 2.2677000000; feg[187] = 0.0468000000;
					g[188] = 9.4000000000; fxg[188] = 2.2447000000; feg[188] = 0.0463000000;
					g[189] = 9.4500000000; fxg[189] = 2.2217000000; feg[189] = 0.0459000000;
					g[190] = 9.5000000000; fxg[190] = 2.1986000000; feg[190] = 0.0454000000;
					g[191] = 9.5500000000; fxg[191] = 2.1758000000; feg[191] = 0.0450000000;
					g[192] = 9.6000000000; fxg[192] = 2.1538000000; feg[192] = 0.0445000000;
					g[193] = 9.6500000000; fxg[193] = 2.1331000000; feg[193] = 0.0441000000;
					g[194] = 9.7000000000; fxg[194] = 2.1141000000; feg[194] = 0.0436000000;
					g[195] = 9.7500000000; fxg[195] = 2.0973000000; feg[195] = 0.0432000000;
					g[196] = 9.8000000000; fxg[196] = 2.0829000000; feg[196] = 0.0428000000;
					g[197] = 9.8500000000; fxg[197] = 2.0703000000; feg[197] = 0.0424000000;
					g[198] = 9.9000000000; fxg[198] = 2.0583000000; feg[198] = 0.0419000000;
					g[199] = 9.9500000000; fxg[199] = 2.0456000000; feg[199] = 0.0415000000;
					g[200] = 10.0000000000; fxg[200] = 2.0316000000; feg[200] = 0.0411000000;
					g[201] = 10.0500000000; fxg[201] = 2.0157000000; feg[201] = 0.0407000000;
					g[202] = 10.1000000000; fxg[202] = 1.9981000000; feg[202] = 0.0404000000;
					g[203] = 10.1500000000; fxg[203] = 1.9792000000; feg[203] = 0.0400000000;
					g[204] = 10.2000000000; fxg[204] = 1.9598000000; feg[204] = 0.0396000000;
					g[205] = 10.2500000000; fxg[205] = 1.9408000000; feg[205] = 0.0392000000;
					g[206] = 10.3000000000; fxg[206] = 1.9226000000; feg[206] = 0.0389000000;
					g[207] = 10.3500000000; fxg[207] = 1.9051000000; feg[207] = 0.0385000000;
					g[208] = 10.4000000000; fxg[208] = 1.8876000000; feg[208] = 0.0382000000;
					g[209] = 10.4500000000; fxg[209] = 1.8699000000; feg[209] = 0.0378000000;
					g[210] = 10.5000000000; fxg[210] = 1.8520000000; feg[210] = 0.0375000000;
					g[211] = 10.5500000000; fxg[211] = 1.8344000000; feg[211] = 0.0371000000;
					g[212] = 10.6000000000; fxg[212] = 1.8176000000; feg[212] = 0.0368000000;
					g[213] = 10.6500000000; fxg[213] = 1.8019000000; feg[213] = 0.0365000000;
					g[214] = 10.7000000000; fxg[214] = 1.7877000000; feg[214] = 0.0361000000;
					g[215] = 10.7500000000; fxg[215] = 1.7755000000; feg[215] = 0.0358000000;
					g[216] = 10.8000000000; fxg[216] = 1.7657000000; feg[216] = 0.0355000000;
					g[217] = 10.8500000000; fxg[217] = 1.7580000000; feg[217] = 0.0352000000;
					g[218] = 10.9000000000; fxg[218] = 1.7518000000; feg[218] = 0.0348000000;
					g[219] = 10.9500000000; fxg[219] = 1.7458000000; feg[219] = 0.0345000000;
					g[220] = 11.0000000000; fxg[220] = 1.7389000000; feg[220] = 0.0342000000;
					g[221] = 11.0500000000; fxg[221] = 1.7304000000; feg[221] = 0.0339000000;
					g[222] = 11.1000000000; fxg[222] = 1.7200000000; feg[222] = 0.0336000000;
					g[223] = 11.1500000000; fxg[223] = 1.7079000000; feg[223] = 0.0333000000;
					g[224] = 11.2000000000; fxg[224] = 1.6942000000; feg[224] = 0.0331000000;
					g[225] = 11.2500000000; fxg[225] = 1.6796000000; feg[225] = 0.0328000000;
					g[226] = 11.3000000000; fxg[226] = 1.6649000000; feg[226] = 0.0325000000;
					g[227] = 11.3500000000; fxg[227] = 1.6510000000; feg[227] = 0.0322000000;
					g[228] = 11.4000000000; fxg[228] = 1.6378000000; feg[228] = 0.0319000000;
					g[229] = 11.4500000000; fxg[229] = 1.6249000000; feg[229] = 0.0317000000;
					g[230] = 11.5000000000; fxg[230] = 1.6120000000; feg[230] = 0.0314000000;
					g[231] = 11.5500000000; fxg[231] = 1.5985000000; feg[231] = 0.0311000000;
					g[232] = 11.6000000000; fxg[232] = 1.5849000000; feg[232] = 0.0309000000;
					g[233] = 11.6500000000; fxg[233] = 1.5714000000; feg[233] = 0.0306000000;
					g[234] = 11.7000000000; fxg[234] = 1.5586000000; feg[234] = 0.0304000000;
					g[235] = 11.7500000000; fxg[235] = 1.5467000000; feg[235] = 0.0301000000;
					g[236] = 11.8000000000; fxg[236] = 1.5361000000; feg[236] = 0.0299000000;
					g[237] = 11.8500000000; fxg[237] = 1.5271000000; feg[237] = 0.0296000000;
					g[238] = 11.9000000000; fxg[238] = 1.5203000000; feg[238] = 0.0294000000;
					g[239] = 11.9500000000; fxg[239] = 1.5157000000; feg[239] = 0.0292000000;
					g[240] = 12.0000000000; fxg[240] = 1.5132000000; feg[240] = 0.0289000000;
					break;
				case 46:
					g[0] = 0.0000000000; fxg[0] = 46.0000000000; feg[0] = 7.5816000000;
					g[1] = 0.0500000000; fxg[1] = 45.8035000000; feg[1] = 7.5234000000;
					g[2] = 0.1000000000; fxg[2] = 45.2317000000; feg[2] = 7.3555000000;
					g[3] = 0.1500000000; fxg[3] = 44.3325000000; feg[3] = 7.0952000000;
					g[4] = 0.2000000000; fxg[4] = 43.1729000000; feg[4] = 6.7664000000;
					g[5] = 0.2500000000; fxg[5] = 41.8257000000; feg[5] = 6.3940000000;
					g[6] = 0.3000000000; fxg[6] = 40.3593000000; feg[6] = 6.0001000000;
					g[7] = 0.3500000000; fxg[7] = 38.8319000000; feg[7] = 5.6020000000;
					g[8] = 0.4000000000; fxg[8] = 37.2894000000; feg[8] = 5.2119000000;
					g[9] = 0.4500000000; fxg[9] = 35.7667000000; feg[9] = 4.8379000000;
					g[10] = 0.5000000000; fxg[10] = 34.2887000000; feg[10] = 4.4847000000;
					g[11] = 0.5500000000; fxg[11] = 32.8728000000; feg[11] = 4.1545000000;
					g[12] = 0.6000000000; fxg[12] = 31.5298000000; feg[12] = 3.8480000000;
					g[13] = 0.6500000000; fxg[13] = 30.2665000000; feg[13] = 3.5651000000;
					g[14] = 0.7000000000; fxg[14] = 29.0855000000; feg[14] = 3.3047000000;
					g[15] = 0.7500000000; fxg[15] = 27.9872000000; feg[15] = 3.0657000000;
					g[16] = 0.8000000000; fxg[16] = 26.9696000000; feg[16] = 2.8467000000;
					g[17] = 0.8500000000; fxg[17] = 26.0295000000; feg[17] = 2.6462000000;
					g[18] = 0.9000000000; fxg[18] = 25.1624000000; feg[18] = 2.4628000000;
					g[19] = 0.9500000000; fxg[19] = 24.3631000000; feg[19] = 2.2952000000;
					g[20] = 1.0000000000; fxg[20] = 23.6262000000; feg[20] = 2.1419000000;
					g[21] = 1.0500000000; fxg[21] = 22.9458000000; feg[21] = 2.0019000000;
					g[22] = 1.1000000000; fxg[22] = 22.3162000000; feg[22] = 1.8739000000;
					g[23] = 1.1500000000; fxg[23] = 21.7316000000; feg[23] = 1.7568000000;
					g[24] = 1.2000000000; fxg[24] = 21.1867000000; feg[24] = 1.6497000000;
					g[25] = 1.2500000000; fxg[25] = 20.6761000000; feg[25] = 1.5516000000;
					g[26] = 1.3000000000; fxg[26] = 20.1952000000; feg[26] = 1.4618000000;
					g[27] = 1.3500000000; fxg[27] = 19.7397000000; feg[27] = 1.3794000000;
					g[28] = 1.4000000000; fxg[28] = 19.3056000000; feg[28] = 1.3039000000;
					g[29] = 1.4500000000; fxg[29] = 18.8894000000; feg[29] = 1.2344000000;
					g[30] = 1.5000000000; fxg[30] = 18.4882000000; feg[30] = 1.1706000000;
					g[31] = 1.5500000000; fxg[31] = 18.0993000000; feg[31] = 1.1118000000;
					g[32] = 1.6000000000; fxg[32] = 17.7206000000; feg[32] = 1.0575000000;
					g[33] = 1.6500000000; fxg[33] = 17.3502000000; feg[33] = 1.0074000000;
					g[34] = 1.7000000000; fxg[34] = 16.9867000000; feg[34] = 0.9611000000;
					g[35] = 1.7500000000; fxg[35] = 16.6289000000; feg[35] = 0.9181000000;
					g[36] = 1.8000000000; fxg[36] = 16.2760000000; feg[36] = 0.8783000000;
					g[37] = 1.8500000000; fxg[37] = 15.9274000000; feg[37] = 0.8412000000;
					g[38] = 1.9000000000; fxg[38] = 15.5826000000; feg[38] = 0.8066000000;
					g[39] = 1.9500000000; fxg[39] = 15.2414000000; feg[39] = 0.7744000000;
					g[40] = 2.0000000000; fxg[40] = 14.9038000000; feg[40] = 0.7442000000;
					g[41] = 2.0500000000; fxg[41] = 14.5698000000; feg[41] = 0.7160000000;
					g[42] = 2.1000000000; fxg[42] = 14.2396000000; feg[42] = 0.6895000000;
					g[43] = 2.1500000000; fxg[43] = 13.9133000000; feg[43] = 0.6645000000;
					g[44] = 2.2000000000; fxg[44] = 13.5914000000; feg[44] = 0.6410000000;
					g[45] = 2.2500000000; fxg[45] = 13.2741000000; feg[45] = 0.6189000000;
					g[46] = 2.3000000000; fxg[46] = 12.9617000000; feg[46] = 0.5979000000;
					g[47] = 2.3500000000; fxg[47] = 12.6546000000; feg[47] = 0.5781000000;
					g[48] = 2.4000000000; fxg[48] = 12.3533000000; feg[48] = 0.5592000000;
					g[49] = 2.4500000000; fxg[49] = 12.0580000000; feg[49] = 0.5413000000;
					g[50] = 2.5000000000; fxg[50] = 11.7690000000; feg[50] = 0.5243000000;
					g[51] = 2.5500000000; fxg[51] = 11.4867000000; feg[51] = 0.5081000000;
					g[52] = 2.6000000000; fxg[52] = 11.2114000000; feg[52] = 0.4927000000;
					g[53] = 2.6500000000; fxg[53] = 10.9433000000; feg[53] = 0.4779000000;
					g[54] = 2.7000000000; fxg[54] = 10.6826000000; feg[54] = 0.4638000000;
					g[55] = 2.7500000000; fxg[55] = 10.4294000000; feg[55] = 0.4503000000;
					g[56] = 2.8000000000; fxg[56] = 10.1839000000; feg[56] = 0.4374000000;
					g[57] = 2.8500000000; fxg[57] = 9.9462000000; feg[57] = 0.4249000000;
					g[58] = 2.9000000000; fxg[58] = 9.7164000000; feg[58] = 0.4130000000;
					g[59] = 2.9500000000; fxg[59] = 9.4946000000; feg[59] = 0.4016000000;
					g[60] = 3.0000000000; fxg[60] = 9.2807000000; feg[60] = 0.3906000000;
					g[61] = 3.0500000000; fxg[61] = 9.0745000000; feg[61] = 0.3800000000;
					g[62] = 3.1000000000; fxg[62] = 8.8761000000; feg[62] = 0.3698000000;
					g[63] = 3.1500000000; fxg[63] = 8.6853000000; feg[63] = 0.3600000000;
					g[64] = 3.2000000000; fxg[64] = 8.5023000000; feg[64] = 0.3506000000;
					g[65] = 3.2500000000; fxg[65] = 8.3268000000; feg[65] = 0.3415000000;
					g[66] = 3.3000000000; fxg[66] = 8.1586000000; feg[66] = 0.3327000000;
					g[67] = 3.3500000000; fxg[67] = 7.9975000000; feg[67] = 0.3242000000;
					g[68] = 3.4000000000; fxg[68] = 7.8431000000; feg[68] = 0.3160000000;
					g[69] = 3.4500000000; fxg[69] = 7.6954000000; feg[69] = 0.3081000000;
					g[70] = 3.5000000000; fxg[70] = 7.5542000000; feg[70] = 0.3005000000;
					g[71] = 3.5500000000; fxg[71] = 7.4194000000; feg[71] = 0.2931000000;
					g[72] = 3.6000000000; fxg[72] = 7.2909000000; feg[72] = 0.2859000000;
					g[73] = 3.6500000000; fxg[73] = 7.1683000000; feg[73] = 0.2790000000;
					g[74] = 3.7000000000; fxg[74] = 7.0511000000; feg[74] = 0.2724000000;
					g[75] = 3.7500000000; fxg[75] = 6.9391000000; feg[75] = 0.2659000000;
					g[76] = 3.8000000000; fxg[76] = 6.8319000000; feg[76] = 0.2597000000;
					g[77] = 3.8500000000; fxg[77] = 6.7296000000; feg[77] = 0.2536000000;
					g[78] = 3.9000000000; fxg[78] = 6.6321000000; feg[78] = 0.2478000000;
					g[79] = 3.9500000000; fxg[79] = 6.5393000000; feg[79] = 0.2421000000;
					g[80] = 4.0000000000; fxg[80] = 6.4509000000; feg[80] = 0.2366000000;
					g[81] = 4.0500000000; fxg[81] = 6.3664000000; feg[81] = 0.2313000000;
					g[82] = 4.1000000000; fxg[82] = 6.2853000000; feg[82] = 0.2262000000;
					g[83] = 4.1500000000; fxg[83] = 6.2075000000; feg[83] = 0.2212000000;
					g[84] = 4.2000000000; fxg[84] = 6.1326000000; feg[84] = 0.2164000000;
					g[85] = 4.2500000000; fxg[85] = 6.0608000000; feg[85] = 0.2117000000;
					g[86] = 4.3000000000; fxg[86] = 5.9921000000; feg[86] = 0.2071000000;
					g[87] = 4.3500000000; fxg[87] = 5.9264000000; feg[87] = 0.2027000000;
					g[88] = 4.4000000000; fxg[88] = 5.8637000000; feg[88] = 0.1985000000;
					g[89] = 4.4500000000; fxg[89] = 5.8035000000; feg[89] = 0.1943000000;
					g[90] = 4.5000000000; fxg[90] = 5.7453000000; feg[90] = 0.1903000000;
					g[91] = 4.5500000000; fxg[91] = 5.6887000000; feg[91] = 0.1864000000;
					g[92] = 4.6000000000; fxg[92] = 5.6335000000; feg[92] = 0.1826000000;
					g[93] = 4.6500000000; fxg[93] = 5.5797000000; feg[93] = 0.1790000000;
					g[94] = 4.7000000000; fxg[94] = 5.5275000000; feg[94] = 0.1754000000;
					g[95] = 4.7500000000; fxg[95] = 5.4771000000; feg[95] = 0.1719000000;
					g[96] = 4.8000000000; fxg[96] = 5.4285000000; feg[96] = 0.1686000000;
					g[97] = 4.8500000000; fxg[97] = 5.3817000000; feg[97] = 0.1653000000;
					g[98] = 4.9000000000; fxg[98] = 5.3364000000; feg[98] = 0.1621000000;
					g[99] = 4.9500000000; fxg[99] = 5.2920000000; feg[99] = 0.1591000000;
					g[100] = 5.0000000000; fxg[100] = 5.2481000000; feg[100] = 0.1561000000;
					g[101] = 5.0500000000; fxg[101] = 5.2044000000; feg[101] = 0.1531000000;
					g[102] = 5.1000000000; fxg[102] = 5.1610000000; feg[102] = 0.1503000000;
					g[103] = 5.1500000000; fxg[103] = 5.1180000000; feg[103] = 0.1476000000;
					g[104] = 5.2000000000; fxg[104] = 5.0756000000; feg[104] = 0.1449000000;
					g[105] = 5.2500000000; fxg[105] = 5.0342000000; feg[105] = 0.1423000000;
					g[106] = 5.3000000000; fxg[106] = 4.9939000000; feg[106] = 0.1398000000;
					g[107] = 5.3500000000; fxg[107] = 4.9548000000; feg[107] = 0.1373000000;
					g[108] = 5.4000000000; fxg[108] = 4.9166000000; feg[108] = 0.1349000000;
					g[109] = 5.4500000000; fxg[109] = 4.8788000000; feg[109] = 0.1325000000;
					g[110] = 5.5000000000; fxg[110] = 4.8410000000; feg[110] = 0.1303000000;
					g[111] = 5.5500000000; fxg[111] = 4.8028000000; feg[111] = 0.1280000000;
					g[112] = 5.6000000000; fxg[112] = 4.7640000000; feg[112] = 0.1259000000;
					g[113] = 5.6500000000; fxg[113] = 4.7249000000; feg[113] = 0.1238000000;
					g[114] = 5.7000000000; fxg[114] = 4.6857000000; feg[114] = 0.1217000000;
					g[115] = 5.7500000000; fxg[115] = 4.6468000000; feg[115] = 0.1197000000;
					g[116] = 5.8000000000; fxg[116] = 4.6085000000; feg[116] = 0.1178000000;
					g[117] = 5.8500000000; fxg[117] = 4.5711000000; feg[117] = 0.1159000000;
					g[118] = 5.9000000000; fxg[118] = 4.5347000000; feg[118] = 0.1140000000;
					g[119] = 5.9500000000; fxg[119] = 4.4990000000; feg[119] = 0.1122000000;
					g[120] = 6.0000000000; fxg[120] = 4.4638000000; feg[120] = 0.1105000000;
					g[121] = 6.0500000000; fxg[121] = 4.4285000000; feg[121] = 0.1087000000;
					g[122] = 6.1000000000; fxg[122] = 4.3925000000; feg[122] = 0.1070000000;
					g[123] = 6.1500000000; fxg[123] = 4.3557000000; feg[123] = 0.1054000000;
					g[124] = 6.2000000000; fxg[124] = 4.3182000000; feg[124] = 0.1038000000;
					g[125] = 6.2500000000; fxg[125] = 4.2801000000; feg[125] = 0.1022000000;
					g[126] = 6.3000000000; fxg[126] = 4.2419000000; feg[126] = 0.1007000000;
					g[127] = 6.3500000000; fxg[127] = 4.2038000000; feg[127] = 0.0992000000;
					g[128] = 6.4000000000; fxg[128] = 4.1662000000; feg[128] = 0.0978000000;
					g[129] = 6.4500000000; fxg[129] = 4.1295000000; feg[129] = 0.0964000000;
					g[130] = 6.5000000000; fxg[130] = 4.0938000000; feg[130] = 0.0950000000;
					g[131] = 6.5500000000; fxg[131] = 4.0593000000; feg[131] = 0.0936000000;
					g[132] = 6.6000000000; fxg[132] = 4.0254000000; feg[132] = 0.0923000000;
					g[133] = 6.6500000000; fxg[133] = 3.9918000000; feg[133] = 0.0909000000;
					g[134] = 6.7000000000; fxg[134] = 3.9577000000; feg[134] = 0.0897000000;
					g[135] = 6.7500000000; fxg[135] = 3.9229000000; feg[135] = 0.0884000000;
					g[136] = 6.8000000000; fxg[136] = 3.8871000000; feg[136] = 0.0872000000;
					g[137] = 6.8500000000; fxg[137] = 3.8505000000; feg[137] = 0.0860000000;
					g[138] = 6.9000000000; fxg[138] = 3.8134000000; feg[138] = 0.0848000000;
					g[139] = 6.9500000000; fxg[139] = 3.7761000000; feg[139] = 0.0837000000;
					g[140] = 7.0000000000; fxg[140] = 3.7390000000; feg[140] = 0.0826000000;
					g[141] = 7.0500000000; fxg[141] = 3.7023000000; feg[141] = 0.0815000000;
					g[142] = 7.1000000000; fxg[142] = 3.6664000000; feg[142] = 0.0804000000;
					g[143] = 7.1500000000; fxg[143] = 3.6317000000; feg[143] = 0.0793000000;
					g[144] = 7.2000000000; fxg[144] = 3.5984000000; feg[144] = 0.0783000000;
					g[145] = 7.2500000000; fxg[145] = 3.5663000000; feg[145] = 0.0773000000;
					g[146] = 7.3000000000; fxg[146] = 3.5351000000; feg[146] = 0.0763000000;
					g[147] = 7.3500000000; fxg[147] = 3.5041000000; feg[147] = 0.0753000000;
					g[148] = 7.4000000000; fxg[148] = 3.4727000000; feg[148] = 0.0743000000;
					g[149] = 7.4500000000; fxg[149] = 3.4405000000; feg[149] = 0.0734000000;
					g[150] = 7.5000000000; fxg[150] = 3.4073000000; feg[150] = 0.0725000000;
					g[151] = 7.5500000000; fxg[151] = 3.3732000000; feg[151] = 0.0716000000;
					g[152] = 7.6000000000; fxg[152] = 3.3386000000; feg[152] = 0.0707000000;
					g[153] = 7.6500000000; fxg[153] = 3.3038000000; feg[153] = 0.0698000000;
					g[154] = 7.7000000000; fxg[154] = 3.2691000000; feg[154] = 0.0690000000;
					g[155] = 7.7500000000; fxg[155] = 3.2347000000; feg[155] = 0.0682000000;
					g[156] = 7.8000000000; fxg[156] = 3.2010000000; feg[156] = 0.0673000000;
					g[157] = 7.8500000000; fxg[157] = 3.1682000000; feg[157] = 0.0665000000;
					g[158] = 7.9000000000; fxg[158] = 3.1367000000; feg[158] = 0.0658000000;
					g[159] = 7.9500000000; fxg[159] = 3.1068000000; feg[159] = 0.0650000000;
					g[160] = 8.0000000000; fxg[160] = 3.0785000000; feg[160] = 0.0642000000;
					g[161] = 8.0500000000; fxg[161] = 3.0514000000; feg[161] = 0.0634000000;
					g[162] = 8.1000000000; fxg[162] = 3.0249000000; feg[162] = 0.0627000000;
					g[163] = 8.1500000000; fxg[163] = 2.9983000000; feg[163] = 0.0620000000;
					g[164] = 8.2000000000; fxg[164] = 2.9710000000; feg[164] = 0.0613000000;
					g[165] = 8.2500000000; fxg[165] = 2.9426000000; feg[165] = 0.0606000000;
					g[166] = 8.3000000000; fxg[166] = 2.9132000000; feg[166] = 0.0599000000;
					g[167] = 8.3500000000; fxg[167] = 2.8831000000; feg[167] = 0.0592000000;
					g[168] = 8.4000000000; fxg[168] = 2.8525000000; feg[168] = 0.0585000000;
					g[169] = 8.4500000000; fxg[169] = 2.8219000000; feg[169] = 0.0579000000;
					g[170] = 8.5000000000; fxg[170] = 2.7915000000; feg[170] = 0.0573000000;
					g[171] = 8.5500000000; fxg[171] = 2.7614000000; feg[171] = 0.0566000000;
					g[172] = 8.6000000000; fxg[172] = 2.7318000000; feg[172] = 0.0560000000;
					g[173] = 8.6500000000; fxg[173] = 2.7030000000; feg[173] = 0.0554000000;
					g[174] = 8.7000000000; fxg[174] = 2.6754000000; feg[174] = 0.0548000000;
					g[175] = 8.7500000000; fxg[175] = 2.6494000000; feg[175] = 0.0542000000;
					g[176] = 8.8000000000; fxg[176] = 2.6252000000; feg[176] = 0.0536000000;
					g[177] = 8.8500000000; fxg[177] = 2.6027000000; feg[177] = 0.0530000000;
					g[178] = 8.9000000000; fxg[178] = 2.5816000000; feg[178] = 0.0525000000;
					g[179] = 8.9500000000; fxg[179] = 2.5612000000; feg[179] = 0.0519000000;
					g[180] = 9.0000000000; fxg[180] = 2.5407000000; feg[180] = 0.0514000000;
					g[181] = 9.0500000000; fxg[181] = 2.5193000000; feg[181] = 0.0508000000;
					g[182] = 9.1000000000; fxg[182] = 2.4968000000; feg[182] = 0.0503000000;
					g[183] = 9.1500000000; fxg[183] = 2.4731000000; feg[183] = 0.0498000000;
					g[184] = 9.2000000000; fxg[184] = 2.4484000000; feg[184] = 0.0493000000;
					g[185] = 9.2500000000; fxg[185] = 2.4232000000; feg[185] = 0.0488000000;
					g[186] = 9.3000000000; fxg[186] = 2.3979000000; feg[186] = 0.0483000000;
					g[187] = 9.3500000000; fxg[187] = 2.3726000000; feg[187] = 0.0478000000;
					g[188] = 9.4000000000; fxg[188] = 2.3476000000; feg[188] = 0.0473000000;
					g[189] = 9.4500000000; fxg[189] = 2.3228000000; feg[189] = 0.0468000000;
					g[190] = 9.5000000000; fxg[190] = 2.2985000000; feg[190] = 0.0464000000;
					g[191] = 9.5500000000; fxg[191] = 2.2749000000; feg[191] = 0.0459000000;
					g[192] = 9.6000000000; fxg[192] = 2.2523000000; feg[192] = 0.0454000000;
					g[193] = 9.6500000000; fxg[193] = 2.2313000000; feg[193] = 0.0450000000;
					g[194] = 9.7000000000; fxg[194] = 2.2120000000; feg[194] = 0.0446000000;
					g[195] = 9.7500000000; fxg[195] = 2.1948000000; feg[195] = 0.0441000000;
					g[196] = 9.8000000000; fxg[196] = 2.1793000000; feg[196] = 0.0437000000;
					g[197] = 9.8500000000; fxg[197] = 2.1651000000; feg[197] = 0.0433000000;
					g[198] = 9.9000000000; fxg[198] = 2.1513000000; feg[198] = 0.0428000000;
					g[199] = 9.9500000000; fxg[199] = 2.1373000000; feg[199] = 0.0424000000;
					g[200] = 10.0000000000; fxg[200] = 2.1222000000; feg[200] = 0.0420000000;
					g[201] = 10.0500000000; fxg[201] = 2.1058000000; feg[201] = 0.0416000000;
					g[202] = 10.1000000000; fxg[202] = 2.0879000000; feg[202] = 0.0412000000;
					g[203] = 10.1500000000; fxg[203] = 2.0689000000; feg[203] = 0.0408000000;
					g[204] = 10.2000000000; fxg[204] = 2.0492000000; feg[204] = 0.0404000000;
					g[205] = 10.2500000000; fxg[205] = 2.0292000000; feg[205] = 0.0401000000;
					g[206] = 10.3000000000; fxg[206] = 2.0093000000; feg[206] = 0.0397000000;
					g[207] = 10.3500000000; fxg[207] = 1.9897000000; feg[207] = 0.0393000000;
					g[208] = 10.4000000000; fxg[208] = 1.9702000000; feg[208] = 0.0390000000;
					g[209] = 10.4500000000; fxg[209] = 1.9509000000; feg[209] = 0.0386000000;
					g[210] = 10.5000000000; fxg[210] = 1.9319000000; feg[210] = 0.0383000000;
					g[211] = 10.5500000000; fxg[211] = 1.9134000000; feg[211] = 0.0379000000;
					g[212] = 10.6000000000; fxg[212] = 1.8958000000; feg[212] = 0.0376000000;
					g[213] = 10.6500000000; fxg[213] = 1.8795000000; feg[213] = 0.0372000000;
					g[214] = 10.7000000000; fxg[214] = 1.8651000000; feg[214] = 0.0369000000;
					g[215] = 10.7500000000; fxg[215] = 1.8526000000; feg[215] = 0.0366000000;
					g[216] = 10.8000000000; fxg[216] = 1.8421000000; feg[216] = 0.0362000000;
					g[217] = 10.8500000000; fxg[217] = 1.8334000000; feg[217] = 0.0359000000;
					g[218] = 10.9000000000; fxg[218] = 1.8257000000; feg[218] = 0.0356000000;
					g[219] = 10.9500000000; fxg[219] = 1.8183000000; feg[219] = 0.0353000000;
					g[220] = 11.0000000000; fxg[220] = 1.8103000000; feg[220] = 0.0350000000;
					g[221] = 11.0500000000; fxg[221] = 1.8010000000; feg[221] = 0.0347000000;
					g[222] = 11.1000000000; fxg[222] = 1.7901000000; feg[222] = 0.0344000000;
					g[223] = 11.1500000000; fxg[223] = 1.7775000000; feg[223] = 0.0341000000;
					g[224] = 11.2000000000; fxg[224] = 1.7636000000; feg[224] = 0.0338000000;
					g[225] = 11.2500000000; fxg[225] = 1.7488000000; feg[225] = 0.0335000000;
					g[226] = 11.3000000000; fxg[226] = 1.7337000000; feg[226] = 0.0332000000;
					g[227] = 11.3500000000; fxg[227] = 1.7185000000; feg[227] = 0.0329000000;
					g[228] = 11.4000000000; fxg[228] = 1.7036000000; feg[228] = 0.0326000000;
					g[229] = 11.4500000000; fxg[229] = 1.6888000000; feg[229] = 0.0324000000;
					g[230] = 11.5000000000; fxg[230] = 1.6742000000; feg[230] = 0.0321000000;
					g[231] = 11.5500000000; fxg[231] = 1.6595000000; feg[231] = 0.0318000000;
					g[232] = 11.6000000000; fxg[232] = 1.6450000000; feg[232] = 0.0316000000;
					g[233] = 11.6500000000; fxg[233] = 1.6307000000; feg[233] = 0.0313000000;
					g[234] = 11.7000000000; fxg[234] = 1.6171000000; feg[234] = 0.0310000000;
					g[235] = 11.7500000000; fxg[235] = 1.6046000000; feg[235] = 0.0308000000;
					g[236] = 11.8000000000; fxg[236] = 1.5936000000; feg[236] = 0.0305000000;
					g[237] = 11.8500000000; fxg[237] = 1.5845000000; feg[237] = 0.0303000000;
					g[238] = 11.9000000000; fxg[238] = 1.5775000000; feg[238] = 0.0300000000;
					g[239] = 11.9500000000; fxg[239] = 1.5725000000; feg[239] = 0.0298000000;
					g[240] = 12.0000000000; fxg[240] = 1.5692000000; feg[240] = 0.0295000000;
					break;
				case 47:
					g[0] = 0.0000000000; fxg[0] = 47.0000000000; feg[0] = 8.6710000000;
					g[1] = 0.0500000000; fxg[1] = 46.7765000000; feg[1] = 8.5577000000;
					g[2] = 0.1000000000; fxg[2] = 46.1390000000; feg[2] = 8.2431000000;
					g[3] = 0.1500000000; fxg[3] = 45.1693000000; feg[3] = 7.7895000000;
					g[4] = 0.2000000000; fxg[4] = 43.9637000000; feg[4] = 7.2669000000;
					g[5] = 0.2500000000; fxg[5] = 42.6057000000; feg[5] = 6.7309000000;
					g[6] = 0.3000000000; fxg[6] = 41.1574000000; feg[6] = 6.2149000000;
					g[7] = 0.3500000000; fxg[7] = 39.6629000000; feg[7] = 5.7340000000;
					g[8] = 0.4000000000; fxg[8] = 38.1546000000; feg[8] = 5.2926000000;
					g[9] = 0.4500000000; fxg[9] = 36.6577000000; feg[9] = 4.8895000000;
					g[10] = 0.5000000000; fxg[10] = 35.1923000000; feg[10] = 4.5216000000;
					g[11] = 0.5500000000; fxg[11] = 33.7743000000; feg[11] = 4.1856000000;
					g[12] = 0.6000000000; fxg[12] = 32.4159000000; feg[12] = 3.8783000000;
					g[13] = 0.6500000000; fxg[13] = 31.1257000000; feg[13] = 3.5970000000;
					g[14] = 0.7000000000; fxg[14] = 29.9092000000; feg[14] = 3.3392000000;
					g[15] = 0.7500000000; fxg[15] = 28.7691000000; feg[15] = 3.1028000000;
					g[16] = 0.8000000000; fxg[16] = 27.7061000000; feg[16] = 2.8861000000;
					g[17] = 0.8500000000; fxg[17] = 26.7188000000; feg[17] = 2.6874000000;
					g[18] = 0.9000000000; fxg[18] = 25.8046000000; feg[18] = 2.5051000000;
					g[19] = 0.9500000000; fxg[19] = 24.9598000000; feg[19] = 2.3380000000;
					g[20] = 1.0000000000; fxg[20] = 24.1799000000; feg[20] = 2.1847000000;
					g[21] = 1.0500000000; fxg[21] = 23.4599000000; feg[21] = 2.0441000000;
					g[22] = 1.1000000000; fxg[22] = 22.7946000000; feg[22] = 1.9151000000;
					g[23] = 1.1500000000; fxg[23] = 22.1786000000; feg[23] = 1.7968000000;
					g[24] = 1.2000000000; fxg[24] = 21.6066000000; feg[24] = 1.6882000000;
					g[25] = 1.2500000000; fxg[25] = 21.0735000000; feg[25] = 1.5885000000;
					g[26] = 1.3000000000; fxg[26] = 20.5746000000; feg[26] = 1.4969000000;
					g[27] = 1.3500000000; fxg[27] = 20.1052000000; feg[27] = 1.4128000000;
					g[28] = 1.4000000000; fxg[28] = 19.6612000000; feg[28] = 1.3353000000;
					g[29] = 1.4500000000; fxg[29] = 19.2387000000; feg[29] = 1.2641000000;
					g[30] = 1.5000000000; fxg[30] = 18.8345000000; feg[30] = 1.1984000000;
					g[31] = 1.5500000000; fxg[31] = 18.4455000000; feg[31] = 1.1378000000;
					g[32] = 1.6000000000; fxg[32] = 18.0692000000; feg[32] = 1.0819000000;
					g[33] = 1.6500000000; fxg[33] = 17.7034000000; feg[33] = 1.0302000000;
					g[34] = 1.7000000000; fxg[34] = 17.3461000000; feg[34] = 0.9823000000;
					g[35] = 1.7500000000; fxg[35] = 16.9959000000; feg[35] = 0.9379000000;
					g[36] = 1.8000000000; fxg[36] = 16.6515000000; feg[36] = 0.8967000000;
					g[37] = 1.8500000000; fxg[37] = 16.3120000000; feg[37] = 0.8584000000;
					g[38] = 1.9000000000; fxg[38] = 15.9766000000; feg[38] = 0.8227000000;
					g[39] = 1.9500000000; fxg[39] = 15.6450000000; feg[39] = 0.7894000000;
					g[40] = 2.0000000000; fxg[40] = 15.3167000000; feg[40] = 0.7583000000;
					g[41] = 2.0500000000; fxg[41] = 14.9915000000; feg[41] = 0.7292000000;
					g[42] = 2.1000000000; fxg[42] = 14.6695000000; feg[42] = 0.7018000000;
					g[43] = 2.1500000000; fxg[43] = 14.3507000000; feg[43] = 0.6762000000;
					g[44] = 2.2000000000; fxg[44] = 14.0354000000; feg[44] = 0.6520000000;
					g[45] = 2.2500000000; fxg[45] = 13.7237000000; feg[45] = 0.6293000000;
					g[46] = 2.3000000000; fxg[46] = 13.4158000000; feg[46] = 0.6078000000;
					g[47] = 2.3500000000; fxg[47] = 13.1120000000; feg[47] = 0.5875000000;
					g[48] = 2.4000000000; fxg[48] = 12.8129000000; feg[48] = 0.5682000000;
					g[49] = 2.4500000000; fxg[49] = 12.5189000000; feg[49] = 0.5499000000;
					g[50] = 2.5000000000; fxg[50] = 12.2298000000; feg[50] = 0.5326000000;
					g[51] = 2.5500000000; fxg[51] = 11.9462000000; feg[51] = 0.5161000000;
					g[52] = 2.6000000000; fxg[52] = 11.6683000000; feg[52] = 0.5004000000;
					g[53] = 2.6500000000; fxg[53] = 11.3969000000; feg[53] = 0.4854000000;
					g[54] = 2.7000000000; fxg[54] = 11.1320000000; feg[54] = 0.4710000000;
					g[55] = 2.7500000000; fxg[55] = 10.8736000000; feg[55] = 0.4573000000;
					g[56] = 2.8000000000; fxg[56] = 10.6217000000; feg[56] = 0.4442000000;
					g[57] = 2.8500000000; fxg[57] = 10.3767000000; feg[57] = 0.4317000000;
					g[58] = 2.9000000000; fxg[58] = 10.1391000000; feg[58] = 0.4196000000;
					g[59] = 2.9500000000; fxg[59] = 9.9090000000; feg[59] = 0.4080000000;
					g[60] = 3.0000000000; fxg[60] = 9.6864000000; feg[60] = 0.3969000000;
					g[61] = 3.0500000000; fxg[61] = 9.4709000000; feg[61] = 0.3862000000;
					g[62] = 3.1000000000; fxg[62] = 9.2623000000; feg[62] = 0.3759000000;
					g[63] = 3.1500000000; fxg[63] = 9.0608000000; feg[63] = 0.3660000000;
					g[64] = 3.2000000000; fxg[64] = 8.8670000000; feg[64] = 0.3565000000;
					g[65] = 3.2500000000; fxg[65] = 8.6808000000; feg[65] = 0.3473000000;
					g[66] = 3.3000000000; fxg[66] = 8.5021000000; feg[66] = 0.3384000000;
					g[67] = 3.3500000000; fxg[67] = 8.3302000000; feg[67] = 0.3299000000;
					g[68] = 3.4000000000; fxg[68] = 8.1647000000; feg[68] = 0.3216000000;
					g[69] = 3.4500000000; fxg[69] = 8.0054000000; feg[69] = 0.3136000000;
					g[70] = 3.5000000000; fxg[70] = 7.8528000000; feg[70] = 0.3059000000;
					g[71] = 3.5500000000; fxg[71] = 7.7069000000; feg[71] = 0.2985000000;
					g[72] = 3.6000000000; fxg[72] = 7.5679000000; feg[72] = 0.2913000000;
					g[73] = 3.6500000000; fxg[73] = 7.4353000000; feg[73] = 0.2843000000;
					g[74] = 3.7000000000; fxg[74] = 7.3081000000; feg[74] = 0.2776000000;
					g[75] = 3.7500000000; fxg[75] = 7.1859000000; feg[75] = 0.2710000000;
					g[76] = 3.8000000000; fxg[76] = 7.0686000000; feg[76] = 0.2647000000;
					g[77] = 3.8500000000; fxg[77] = 6.9562000000; feg[77] = 0.2586000000;
					g[78] = 3.9000000000; fxg[78] = 6.8492000000; feg[78] = 0.2527000000;
					g[79] = 3.9500000000; fxg[79] = 6.7475000000; feg[79] = 0.2470000000;
					g[80] = 4.0000000000; fxg[80] = 6.6511000000; feg[80] = 0.2414000000;
					g[81] = 4.0500000000; fxg[81] = 6.5590000000; feg[81] = 0.2360000000;
					g[82] = 4.1000000000; fxg[82] = 6.4705000000; feg[82] = 0.2308000000;
					g[83] = 4.1500000000; fxg[83] = 6.3851000000; feg[83] = 0.2258000000;
					g[84] = 4.2000000000; fxg[84] = 6.3029000000; feg[84] = 0.2209000000;
					g[85] = 4.2500000000; fxg[85] = 6.2239000000; feg[85] = 0.2161000000;
					g[86] = 4.3000000000; fxg[86] = 6.1485000000; feg[86] = 0.2115000000;
					g[87] = 4.3500000000; fxg[87] = 6.0769000000; feg[87] = 0.2070000000;
					g[88] = 4.4000000000; fxg[88] = 6.0090000000; feg[88] = 0.2027000000;
					g[89] = 4.4500000000; fxg[89] = 5.9442000000; feg[89] = 0.1985000000;
					g[90] = 4.5000000000; fxg[90] = 5.8816000000; feg[90] = 0.1944000000;
					g[91] = 4.5500000000; fxg[91] = 5.8207000000; feg[91] = 0.1904000000;
					g[92] = 4.6000000000; fxg[92] = 5.7612000000; feg[92] = 0.1866000000;
					g[93] = 4.6500000000; fxg[93] = 5.7033000000; feg[93] = 0.1828000000;
					g[94] = 4.7000000000; fxg[94] = 5.6472000000; feg[94] = 0.1792000000;
					g[95] = 4.7500000000; fxg[95] = 5.5933000000; feg[95] = 0.1757000000;
					g[96] = 4.8000000000; fxg[96] = 5.5416000000; feg[96] = 0.1723000000;
					g[97] = 4.8500000000; fxg[97] = 5.4924000000; feg[97] = 0.1689000000;
					g[98] = 4.9000000000; fxg[98] = 5.4453000000; feg[98] = 0.1657000000;
					g[99] = 4.9500000000; fxg[99] = 5.3994000000; feg[99] = 0.1625000000;
					g[100] = 5.0000000000; fxg[100] = 5.3540000000; feg[100] = 0.1595000000;
					g[101] = 5.0500000000; fxg[101] = 5.3086000000; feg[101] = 0.1565000000;
					g[102] = 5.1000000000; fxg[102] = 5.2637000000; feg[102] = 0.1536000000;
					g[103] = 5.1500000000; fxg[103] = 5.2194000000; feg[103] = 0.1508000000;
					g[104] = 5.2000000000; fxg[104] = 5.1759000000; feg[104] = 0.1481000000;
					g[105] = 5.2500000000; fxg[105] = 5.1334000000; feg[105] = 0.1454000000;
					g[106] = 5.3000000000; fxg[106] = 5.0923000000; feg[106] = 0.1428000000;
					g[107] = 5.3500000000; fxg[107] = 5.0528000000; feg[107] = 0.1403000000;
					g[108] = 5.4000000000; fxg[108] = 5.0148000000; feg[108] = 0.1378000000;
					g[109] = 5.4500000000; fxg[109] = 4.9775000000; feg[109] = 0.1354000000;
					g[110] = 5.5000000000; fxg[110] = 4.9399000000; feg[110] = 0.1331000000;
					g[111] = 5.5500000000; fxg[111] = 4.9017000000; feg[111] = 0.1308000000;
					g[112] = 5.6000000000; fxg[112] = 4.8630000000; feg[112] = 0.1286000000;
					g[113] = 5.6500000000; fxg[113] = 4.8242000000; feg[113] = 0.1265000000;
					g[114] = 5.7000000000; fxg[114] = 4.7855000000; feg[114] = 0.1244000000;
					g[115] = 5.7500000000; fxg[115] = 4.7472000000; feg[115] = 0.1223000000;
					g[116] = 5.8000000000; fxg[116] = 4.7092000000; feg[116] = 0.1204000000;
					g[117] = 5.8500000000; fxg[117] = 4.6720000000; feg[117] = 0.1184000000;
					g[118] = 5.9000000000; fxg[118] = 4.6362000000; feg[118] = 0.1165000000;
					g[119] = 5.9500000000; fxg[119] = 4.6015000000; feg[119] = 0.1147000000;
					g[120] = 6.0000000000; fxg[120] = 4.5676000000; feg[120] = 0.1128000000;
					g[121] = 6.0500000000; fxg[121] = 4.5335000000; feg[121] = 0.1111000000;
					g[122] = 6.1000000000; fxg[122] = 4.4983000000; feg[122] = 0.1093000000;
					g[123] = 6.1500000000; fxg[123] = 4.4621000000; feg[123] = 0.1077000000;
					g[124] = 6.2000000000; fxg[124] = 4.4252000000; feg[124] = 0.1060000000;
					g[125] = 6.2500000000; fxg[125] = 4.3882000000; feg[125] = 0.1044000000;
					g[126] = 6.3000000000; fxg[126] = 4.3512000000; feg[126] = 0.1029000000;
					g[127] = 6.3500000000; fxg[127] = 4.3143000000; feg[127] = 0.1013000000;
					g[128] = 6.4000000000; fxg[128] = 4.2775000000; feg[128] = 0.0999000000;
					g[129] = 6.4500000000; fxg[129] = 4.2413000000; feg[129] = 0.0984000000;
					g[130] = 6.5000000000; fxg[130] = 4.2061000000; feg[130] = 0.0970000000;
					g[131] = 6.5500000000; fxg[131] = 4.1724000000; feg[131] = 0.0956000000;
					g[132] = 6.6000000000; fxg[132] = 4.1397000000; feg[132] = 0.0942000000;
					g[133] = 6.6500000000; fxg[133] = 4.1073000000; feg[133] = 0.0929000000;
					g[134] = 6.7000000000; fxg[134] = 4.0743000000; feg[134] = 0.0915000000;
					g[135] = 6.7500000000; fxg[135] = 4.0399000000; feg[135] = 0.0903000000;
					g[136] = 6.8000000000; fxg[136] = 4.0044000000; feg[136] = 0.0890000000;
					g[137] = 6.8500000000; fxg[137] = 3.9682000000; feg[137] = 0.0878000000;
					g[138] = 6.9000000000; fxg[138] = 3.9320000000; feg[138] = 0.0866000000;
					g[139] = 6.9500000000; fxg[139] = 3.8960000000; feg[139] = 0.0854000000;
					g[140] = 7.0000000000; fxg[140] = 3.8600000000; feg[140] = 0.0843000000;
					g[141] = 7.0500000000; fxg[141] = 3.8241000000; feg[141] = 0.0832000000;
					g[142] = 7.1000000000; fxg[142] = 3.7885000000; feg[142] = 0.0821000000;
					g[143] = 7.1500000000; fxg[143] = 3.7538000000; feg[143] = 0.0810000000;
					g[144] = 7.2000000000; fxg[144] = 3.7205000000; feg[144] = 0.0799000000;
					g[145] = 7.2500000000; fxg[145] = 3.6888000000; feg[145] = 0.0789000000;
					g[146] = 7.3000000000; fxg[146] = 3.6582000000; feg[146] = 0.0779000000;
					g[147] = 7.3500000000; fxg[147] = 3.6279000000; feg[147] = 0.0769000000;
					g[148] = 7.4000000000; fxg[148] = 3.5970000000; feg[148] = 0.0759000000;
					g[149] = 7.4500000000; fxg[149] = 3.5647000000; feg[149] = 0.0749000000;
					g[150] = 7.5000000000; fxg[150] = 3.5310000000; feg[150] = 0.0740000000;
					g[151] = 7.5500000000; fxg[151] = 3.4967000000; feg[151] = 0.0731000000;
					g[152] = 7.6000000000; fxg[152] = 3.4623000000; feg[152] = 0.0722000000;
					g[153] = 7.6500000000; fxg[153] = 3.4282000000; feg[153] = 0.0713000000;
					g[154] = 7.7000000000; fxg[154] = 3.3943000000; feg[154] = 0.0704000000;
					g[155] = 7.7500000000; fxg[155] = 3.3605000000; feg[155] = 0.0696000000;
					g[156] = 7.8000000000; fxg[156] = 3.3269000000; feg[156] = 0.0687000000;
					g[157] = 7.8500000000; fxg[157] = 3.2938000000; feg[157] = 0.0679000000;
					g[158] = 7.9000000000; fxg[158] = 3.2617000000; feg[158] = 0.0671000000;
					g[159] = 7.9500000000; fxg[159] = 3.2311000000; feg[159] = 0.0663000000;
					g[160] = 8.0000000000; fxg[160] = 3.2024000000; feg[160] = 0.0655000000;
					g[161] = 8.0500000000; fxg[161] = 3.1751000000; feg[161] = 0.0647000000;
					g[162] = 8.1000000000; fxg[162] = 3.1487000000; feg[162] = 0.0640000000;
					g[163] = 8.1500000000; fxg[163] = 3.1220000000; feg[163] = 0.0632000000;
					g[164] = 8.2000000000; fxg[164] = 3.0942000000; feg[164] = 0.0625000000;
					g[165] = 8.2500000000; fxg[165] = 3.0649000000; feg[165] = 0.0618000000;
					g[166] = 8.3000000000; fxg[166] = 3.0345000000; feg[166] = 0.0611000000;
					g[167] = 8.3500000000; fxg[167] = 3.0035000000; feg[167] = 0.0604000000;
					g[168] = 8.4000000000; fxg[168] = 2.9726000000; feg[168] = 0.0597000000;
					g[169] = 8.4500000000; fxg[169] = 2.9421000000; feg[169] = 0.0591000000;
					g[170] = 8.5000000000; fxg[170] = 2.9121000000; feg[170] = 0.0584000000;
					g[171] = 8.5500000000; fxg[171] = 2.8822000000; feg[171] = 0.0578000000;
					g[172] = 8.6000000000; fxg[172] = 2.8524000000; feg[172] = 0.0571000000;
					g[173] = 8.6500000000; fxg[173] = 2.8230000000; feg[173] = 0.0565000000;
					g[174] = 8.7000000000; fxg[174] = 2.7944000000; feg[174] = 0.0559000000;
					g[175] = 8.7500000000; fxg[175] = 2.7672000000; feg[175] = 0.0553000000;
					g[176] = 8.8000000000; fxg[176] = 2.7418000000; feg[176] = 0.0547000000;
					g[177] = 8.8500000000; fxg[177] = 2.7184000000; feg[177] = 0.0541000000;
					g[178] = 8.9000000000; fxg[178] = 2.6967000000; feg[178] = 0.0535000000;
					g[179] = 8.9500000000; fxg[179] = 2.6757000000; feg[179] = 0.0530000000;
					g[180] = 9.0000000000; fxg[180] = 2.6545000000; feg[180] = 0.0524000000;
					g[181] = 9.0500000000; fxg[181] = 2.6322000000; feg[181] = 0.0519000000;
					g[182] = 9.1000000000; fxg[182] = 2.6085000000; feg[182] = 0.0513000000;
					g[183] = 9.1500000000; fxg[183] = 2.5833000000; feg[183] = 0.0508000000;
					g[184] = 9.2000000000; fxg[184] = 2.5573000000; feg[184] = 0.0503000000;
					g[185] = 9.2500000000; fxg[185] = 2.5310000000; feg[185] = 0.0498000000;
					g[186] = 9.3000000000; fxg[186] = 2.5052000000; feg[186] = 0.0493000000;
					g[187] = 9.3500000000; fxg[187] = 2.4798000000; feg[187] = 0.0488000000;
					g[188] = 9.4000000000; fxg[188] = 2.4548000000; feg[188] = 0.0483000000;
					g[189] = 9.4500000000; fxg[189] = 2.4299000000; feg[189] = 0.0478000000;
					g[190] = 9.5000000000; fxg[190] = 2.4051000000; feg[190] = 0.0473000000;
					g[191] = 9.5500000000; fxg[191] = 2.3806000000; feg[191] = 0.0468000000;
					g[192] = 9.6000000000; fxg[192] = 2.3570000000; feg[192] = 0.0464000000;
					g[193] = 9.6500000000; fxg[193] = 2.3346000000; feg[193] = 0.0459000000;
					g[194] = 9.7000000000; fxg[194] = 2.3140000000; feg[194] = 0.0455000000;
					g[195] = 9.7500000000; fxg[195] = 2.2953000000; feg[195] = 0.0450000000;
					g[196] = 9.8000000000; fxg[196] = 2.2787000000; feg[196] = 0.0446000000;
					g[197] = 9.8500000000; fxg[197] = 2.2635000000; feg[197] = 0.0441000000;
					g[198] = 9.9000000000; fxg[198] = 2.2489000000; feg[198] = 0.0437000000;
					g[199] = 9.9500000000; fxg[199] = 2.2339000000; feg[199] = 0.0433000000;
					g[200] = 10.0000000000; fxg[200] = 2.2177000000; feg[200] = 0.0429000000;
					g[201] = 10.0500000000; fxg[201] = 2.1998000000; feg[201] = 0.0425000000;
					g[202] = 10.1000000000; fxg[202] = 2.1805000000; feg[202] = 0.0421000000;
					g[203] = 10.1500000000; fxg[203] = 2.1600000000; feg[203] = 0.0417000000;
					g[204] = 10.2000000000; fxg[204] = 2.1390000000; feg[204] = 0.0413000000;
					g[205] = 10.2500000000; fxg[205] = 2.1182000000; feg[205] = 0.0409000000;
					g[206] = 10.3000000000; fxg[206] = 2.0979000000; feg[206] = 0.0405000000;
					g[207] = 10.3500000000; fxg[207] = 2.0780000000; feg[207] = 0.0401000000;
					g[208] = 10.4000000000; fxg[208] = 2.0583000000; feg[208] = 0.0398000000;
					g[209] = 10.4500000000; fxg[209] = 2.0386000000; feg[209] = 0.0394000000;
					g[210] = 10.5000000000; fxg[210] = 2.0189000000; feg[210] = 0.0391000000;
					g[211] = 10.5500000000; fxg[211] = 1.9996000000; feg[211] = 0.0387000000;
					g[212] = 10.6000000000; fxg[212] = 1.9811000000; feg[212] = 0.0384000000;
					g[213] = 10.6500000000; fxg[213] = 1.9638000000; feg[213] = 0.0380000000;
					g[214] = 10.7000000000; fxg[214] = 1.9480000000; feg[214] = 0.0377000000;
					g[215] = 10.7500000000; fxg[215] = 1.9341000000; feg[215] = 0.0373000000;
					g[216] = 10.8000000000; fxg[216] = 1.9224000000; feg[216] = 0.0370000000;
					g[217] = 10.8500000000; fxg[217] = 1.9125000000; feg[217] = 0.0367000000;
					g[218] = 10.9000000000; fxg[218] = 1.9039000000; feg[218] = 0.0363000000;
					g[219] = 10.9500000000; fxg[219] = 1.8955000000; feg[219] = 0.0360000000;
					g[220] = 11.0000000000; fxg[220] = 1.8864000000; feg[220] = 0.0357000000;
					g[221] = 11.0500000000; fxg[221] = 1.8760000000; feg[221] = 0.0354000000;
					g[222] = 11.1000000000; fxg[222] = 1.8639000000; feg[222] = 0.0351000000;
					g[223] = 11.1500000000; fxg[223] = 1.8501000000; feg[223] = 0.0348000000;
					g[224] = 11.2000000000; fxg[224] = 1.8349000000; feg[224] = 0.0345000000;
					g[225] = 11.2500000000; fxg[225] = 1.8189000000; feg[225] = 0.0342000000;
					g[226] = 11.3000000000; fxg[226] = 1.8028000000; feg[226] = 0.0339000000;
					g[227] = 11.3500000000; fxg[227] = 1.7870000000; feg[227] = 0.0336000000;
					g[228] = 11.4000000000; fxg[228] = 1.7718000000; feg[228] = 0.0333000000;
					g[229] = 11.4500000000; fxg[229] = 1.7568000000; feg[229] = 0.0330000000;
					g[230] = 11.5000000000; fxg[230] = 1.7419000000; feg[230] = 0.0328000000;
					g[231] = 11.5500000000; fxg[231] = 1.7267000000; feg[231] = 0.0325000000;
					g[232] = 11.6000000000; fxg[232] = 1.7115000000; feg[232] = 0.0322000000;
					g[233] = 11.6500000000; fxg[233] = 1.6966000000; feg[233] = 0.0320000000;
					g[234] = 11.7000000000; fxg[234] = 1.6823000000; feg[234] = 0.0317000000;
					g[235] = 11.7500000000; fxg[235] = 1.6691000000; feg[235] = 0.0314000000;
					g[236] = 11.8000000000; fxg[236] = 1.6573000000; feg[236] = 0.0312000000;
					g[237] = 11.8500000000; fxg[237] = 1.6471000000; feg[237] = 0.0309000000;
					g[238] = 11.9000000000; fxg[238] = 1.6390000000; feg[238] = 0.0307000000;
					g[239] = 11.9500000000; fxg[239] = 1.6329000000; feg[239] = 0.0304000000;
					g[240] = 12.0000000000; fxg[240] = 1.6287000000; feg[240] = 0.0302000000;
					break;
				case 48:
					g[0] = 0.0000000000; fxg[0] = 48.0000000000; feg[0] = 9.2345000000;
					g[1] = 0.0500000000; fxg[1] = 47.7621000000; feg[1] = 9.1109000000;
					g[2] = 0.1000000000; fxg[2] = 47.0845000000; feg[2] = 8.7647000000;
					g[3] = 0.1500000000; fxg[3] = 46.0591000000; feg[3] = 8.2582000000;
					g[4] = 0.2000000000; fxg[4] = 44.7968000000; feg[4] = 7.6665000000;
					g[5] = 0.2500000000; fxg[5] = 43.3948000000; feg[5] = 7.0541000000;
					g[6] = 0.3000000000; fxg[6] = 41.9230000000; feg[6] = 6.4642000000;
					g[7] = 0.3500000000; fxg[7] = 40.4258000000; feg[7] = 5.9193000000;
					g[8] = 0.4000000000; fxg[8] = 38.9300000000; feg[8] = 5.4270000000;
					g[9] = 0.4500000000; fxg[9] = 37.4529000000; feg[9] = 4.9863000000;
					g[10] = 0.5000000000; fxg[10] = 36.0074000000; feg[10] = 4.5924000000;
					g[11] = 0.5500000000; fxg[11] = 34.6038000000; feg[11] = 4.2396000000;
					g[12] = 0.6000000000; fxg[12] = 33.2509000000; feg[12] = 3.9222000000;
					g[13] = 0.6500000000; fxg[13] = 31.9561000000; feg[13] = 3.6354000000;
					g[14] = 0.7000000000; fxg[14] = 30.7250000000; feg[14] = 3.3751000000;
					g[15] = 0.7500000000; fxg[15] = 29.5615000000; feg[15] = 3.1381000000;
					g[16] = 0.8000000000; fxg[16] = 28.4678000000; feg[16] = 2.9217000000;
					g[17] = 0.8500000000; fxg[17] = 27.4446000000; feg[17] = 2.7237000000;
					g[18] = 0.9000000000; fxg[18] = 26.4909000000; feg[18] = 2.5422000000;
					g[19] = 0.9500000000; fxg[19] = 25.6048000000; feg[19] = 2.3756000000;
					g[20] = 1.0000000000; fxg[20] = 24.7833000000; feg[20] = 2.2226000000;
					g[21] = 1.0500000000; fxg[21] = 24.0227000000; feg[21] = 2.0820000000;
					g[22] = 1.1000000000; fxg[22] = 23.3188000000; feg[22] = 1.9528000000;
					g[23] = 1.1500000000; fxg[23] = 22.6671000000; feg[23] = 1.8338000000;
					g[24] = 1.2000000000; fxg[24] = 22.0628000000; feg[24] = 1.7244000000;
					g[25] = 1.2500000000; fxg[25] = 21.5012000000; feg[25] = 1.6236000000;
					g[26] = 1.3000000000; fxg[26] = 20.9776000000; feg[26] = 1.5308000000;
					g[27] = 1.3500000000; fxg[27] = 20.4877000000; feg[27] = 1.4452000000;
					g[28] = 1.4000000000; fxg[28] = 20.0272000000; feg[28] = 1.3663000000;
					g[29] = 1.4500000000; fxg[29] = 19.5921000000; feg[29] = 1.2935000000;
					g[30] = 1.5000000000; fxg[30] = 19.1789000000; feg[30] = 1.2263000000;
					g[31] = 1.5500000000; fxg[31] = 18.7843000000; feg[31] = 1.1642000000;
					g[32] = 1.6000000000; fxg[32] = 18.4054000000; feg[32] = 1.1067000000;
					g[33] = 1.6500000000; fxg[33] = 18.0395000000; feg[33] = 1.0535000000;
					g[34] = 1.7000000000; fxg[34] = 17.6846000000; feg[34] = 1.0042000000;
					g[35] = 1.7500000000; fxg[35] = 17.3387000000; feg[35] = 0.9585000000;
					g[36] = 1.8000000000; fxg[36] = 17.0002000000; feg[36] = 0.9160000000;
					g[37] = 1.8500000000; fxg[37] = 16.6679000000; feg[37] = 0.8764000000;
					g[38] = 1.9000000000; fxg[38] = 16.3406000000; feg[38] = 0.8396000000;
					g[39] = 1.9500000000; fxg[39] = 16.0175000000; feg[39] = 0.8052000000;
					g[40] = 2.0000000000; fxg[40] = 15.6982000000; feg[40] = 0.7731000000;
					g[41] = 2.0500000000; fxg[41] = 15.3821000000; feg[41] = 0.7431000000;
					g[42] = 2.1000000000; fxg[42] = 15.0689000000; feg[42] = 0.7149000000;
					g[43] = 2.1500000000; fxg[43] = 14.7586000000; feg[43] = 0.6884000000;
					g[44] = 2.2000000000; fxg[44] = 14.4511000000; feg[44] = 0.6636000000;
					g[45] = 2.2500000000; fxg[45] = 14.1466000000; feg[45] = 0.6402000000;
					g[46] = 2.3000000000; fxg[46] = 13.8451000000; feg[46] = 0.6181000000;
					g[47] = 2.3500000000; fxg[47] = 13.5468000000; feg[47] = 0.5973000000;
					g[48] = 2.4000000000; fxg[48] = 13.2523000000; feg[48] = 0.5775000000;
					g[49] = 2.4500000000; fxg[49] = 12.9616000000; feg[49] = 0.5588000000;
					g[50] = 2.5000000000; fxg[50] = 12.6749000000; feg[50] = 0.5411000000;
					g[51] = 2.5500000000; fxg[51] = 12.3926000000; feg[51] = 0.5242000000;
					g[52] = 2.6000000000; fxg[52] = 12.1150000000; feg[52] = 0.5082000000;
					g[53] = 2.6500000000; fxg[53] = 11.8427000000; feg[53] = 0.4929000000;
					g[54] = 2.7000000000; fxg[54] = 11.5760000000; feg[54] = 0.4783000000;
					g[55] = 2.7500000000; fxg[55] = 11.3147000000; feg[55] = 0.4644000000;
					g[56] = 2.8000000000; fxg[56] = 11.0590000000; feg[56] = 0.4511000000;
					g[57] = 2.8500000000; fxg[57] = 10.8092000000; feg[57] = 0.4383000000;
					g[58] = 2.9000000000; fxg[58] = 10.5660000000; feg[58] = 0.4261000000;
					g[59] = 2.9500000000; fxg[59] = 10.3296000000; feg[59] = 0.4144000000;
					g[60] = 3.0000000000; fxg[60] = 10.1000000000; feg[60] = 0.4031000000;
					g[61] = 3.0500000000; fxg[61] = 9.8768000000; feg[61] = 0.3923000000;
					g[62] = 3.1000000000; fxg[62] = 9.6598000000; feg[62] = 0.3819000000;
					g[63] = 3.1500000000; fxg[63] = 9.4496000000; feg[63] = 0.3719000000;
					g[64] = 3.2000000000; fxg[64] = 9.2465000000; feg[64] = 0.3623000000;
					g[65] = 3.2500000000; fxg[65] = 9.0508000000; feg[65] = 0.3530000000;
					g[66] = 3.3000000000; fxg[66] = 8.8623000000; feg[66] = 0.3441000000;
					g[67] = 3.3500000000; fxg[67] = 8.6803000000; feg[67] = 0.3354000000;
					g[68] = 3.4000000000; fxg[68] = 8.5044000000; feg[68] = 0.3271000000;
					g[69] = 3.4500000000; fxg[69] = 8.3346000000; feg[69] = 0.3190000000;
					g[70] = 3.5000000000; fxg[70] = 8.1713000000; feg[70] = 0.3113000000;
					g[71] = 3.5500000000; fxg[71] = 8.0150000000; feg[71] = 0.3037000000;
					g[72] = 3.6000000000; fxg[72] = 7.8656000000; feg[72] = 0.2965000000;
					g[73] = 3.6500000000; fxg[73] = 7.7227000000; feg[73] = 0.2894000000;
					g[74] = 3.7000000000; fxg[74] = 7.5854000000; feg[74] = 0.2826000000;
					g[75] = 3.7500000000; fxg[75] = 7.4530000000; feg[75] = 0.2760000000;
					g[76] = 3.8000000000; fxg[76] = 7.3254000000; feg[76] = 0.2697000000;
					g[77] = 3.8500000000; fxg[77] = 7.2031000000; feg[77] = 0.2635000000;
					g[78] = 3.9000000000; fxg[78] = 7.0864000000; feg[78] = 0.2575000000;
					g[79] = 3.9500000000; fxg[79] = 6.9756000000; feg[79] = 0.2517000000;
					g[80] = 4.0000000000; fxg[80] = 6.8704000000; feg[80] = 0.2461000000;
					g[81] = 4.0500000000; fxg[81] = 6.7700000000; feg[81] = 0.2406000000;
					g[82] = 4.1000000000; fxg[82] = 6.6733000000; feg[82] = 0.2354000000;
					g[83] = 4.1500000000; fxg[83] = 6.5798000000; feg[83] = 0.2302000000;
					g[84] = 4.2000000000; fxg[84] = 6.4896000000; feg[84] = 0.2253000000;
					g[85] = 4.2500000000; fxg[85] = 6.4029000000; feg[85] = 0.2205000000;
					g[86] = 4.3000000000; fxg[86] = 6.3202000000; feg[86] = 0.2158000000;
					g[87] = 4.3500000000; fxg[87] = 6.2420000000; feg[87] = 0.2113000000;
					g[88] = 4.4000000000; fxg[88] = 6.1681000000; feg[88] = 0.2069000000;
					g[89] = 4.4500000000; fxg[89] = 6.0977000000; feg[89] = 0.2026000000;
					g[90] = 4.5000000000; fxg[90] = 6.0299000000; feg[90] = 0.1984000000;
					g[91] = 4.5500000000; fxg[91] = 5.9638000000; feg[91] = 0.1944000000;
					g[92] = 4.6000000000; fxg[92] = 5.8993000000; feg[92] = 0.1905000000;
					g[93] = 4.6500000000; fxg[93] = 5.8364000000; feg[93] = 0.1867000000;
					g[94] = 4.7000000000; fxg[94] = 5.7756000000; feg[94] = 0.1830000000;
					g[95] = 4.7500000000; fxg[95] = 5.7174000000; feg[95] = 0.1794000000;
					g[96] = 4.8000000000; fxg[96] = 5.6621000000; feg[96] = 0.1759000000;
					g[97] = 4.8500000000; fxg[97] = 5.6099000000; feg[97] = 0.1725000000;
					g[98] = 4.9000000000; fxg[98] = 5.5601000000; feg[98] = 0.1692000000;
					g[99] = 4.9500000000; fxg[99] = 5.5119000000; feg[99] = 0.1660000000;
					g[100] = 5.0000000000; fxg[100] = 5.4642000000; feg[100] = 0.1629000000;
					g[101] = 5.0500000000; fxg[101] = 5.4167000000; feg[101] = 0.1599000000;
					g[102] = 5.1000000000; fxg[102] = 5.3695000000; feg[102] = 0.1569000000;
					g[103] = 5.1500000000; fxg[103] = 5.3230000000; feg[103] = 0.1540000000;
					g[104] = 5.2000000000; fxg[104] = 5.2775000000; feg[104] = 0.1513000000;
					g[105] = 5.2500000000; fxg[105] = 5.2334000000; feg[105] = 0.1485000000;
					g[106] = 5.3000000000; fxg[106] = 5.1911000000; feg[106] = 0.1459000000;
					g[107] = 5.3500000000; fxg[107] = 5.1509000000; feg[107] = 0.1433000000;
					g[108] = 5.4000000000; fxg[108] = 5.1125000000; feg[108] = 0.1408000000;
					g[109] = 5.4500000000; fxg[109] = 5.0751000000; feg[109] = 0.1384000000;
					g[110] = 5.5000000000; fxg[110] = 5.0375000000; feg[110] = 0.1360000000;
					g[111] = 5.5500000000; fxg[111] = 4.9992000000; feg[111] = 0.1336000000;
					g[112] = 5.6000000000; fxg[112] = 4.9603000000; feg[112] = 0.1314000000;
					g[113] = 5.6500000000; fxg[113] = 4.9212000000; feg[113] = 0.1292000000;
					g[114] = 5.7000000000; fxg[114] = 4.8822000000; feg[114] = 0.1271000000;
					g[115] = 5.7500000000; fxg[115] = 4.8435000000; feg[115] = 0.1250000000;
					g[116] = 5.8000000000; fxg[116] = 4.8055000000; feg[116] = 0.1229000000;
					g[117] = 5.8500000000; fxg[117] = 4.7686000000; feg[117] = 0.1209000000;
					g[118] = 5.9000000000; fxg[118] = 4.7333000000; feg[118] = 0.1190000000;
					g[119] = 5.9500000000; fxg[119] = 4.6996000000; feg[119] = 0.1171000000;
					g[120] = 6.0000000000; fxg[120] = 4.6668000000; feg[120] = 0.1152000000;
					g[121] = 6.0500000000; fxg[121] = 4.6337000000; feg[121] = 0.1134000000;
					g[122] = 6.1000000000; fxg[122] = 4.5995000000; feg[122] = 0.1117000000;
					g[123] = 6.1500000000; fxg[123] = 4.5641000000; feg[123] = 0.1099000000;
					g[124] = 6.2000000000; fxg[124] = 4.5279000000; feg[124] = 0.1083000000;
					g[125] = 6.2500000000; fxg[125] = 4.4914000000; feg[125] = 0.1066000000;
					g[126] = 6.3000000000; fxg[126] = 4.4550000000; feg[126] = 0.1050000000;
					g[127] = 6.3500000000; fxg[127] = 4.4185000000; feg[127] = 0.1035000000;
					g[128] = 6.4000000000; fxg[128] = 4.3823000000; feg[128] = 0.1019000000;
					g[129] = 6.4500000000; fxg[129] = 4.3468000000; feg[129] = 0.1005000000;
					g[130] = 6.5000000000; fxg[130] = 4.3125000000; feg[130] = 0.0990000000;
					g[131] = 6.5500000000; fxg[131] = 4.2798000000; feg[131] = 0.0976000000;
					g[132] = 6.6000000000; fxg[132] = 4.2484000000; feg[132] = 0.0962000000;
					g[133] = 6.6500000000; fxg[133] = 4.2173000000; feg[133] = 0.0948000000;
					g[134] = 6.7000000000; fxg[134] = 4.1854000000; feg[134] = 0.0934000000;
					g[135] = 6.7500000000; fxg[135] = 4.1520000000; feg[135] = 0.0921000000;
					g[136] = 6.8000000000; fxg[136] = 4.1173000000; feg[136] = 0.0909000000;
					g[137] = 6.8500000000; fxg[137] = 4.0818000000; feg[137] = 0.0896000000;
					g[138] = 6.9000000000; fxg[138] = 4.0462000000; feg[138] = 0.0884000000;
					g[139] = 6.9500000000; fxg[139] = 4.0108000000; feg[139] = 0.0872000000;
					g[140] = 7.0000000000; fxg[140] = 3.9755000000; feg[140] = 0.0860000000;
					g[141] = 7.0500000000; fxg[141] = 3.9400000000; feg[141] = 0.0849000000;
					g[142] = 7.1000000000; fxg[142] = 3.9049000000; feg[142] = 0.0837000000;
					g[143] = 7.1500000000; fxg[143] = 3.8705000000; feg[143] = 0.0826000000;
					g[144] = 7.2000000000; fxg[144] = 3.8378000000; feg[144] = 0.0816000000;
					g[145] = 7.2500000000; fxg[145] = 3.8067000000; feg[145] = 0.0805000000;
					g[146] = 7.3000000000; fxg[146] = 3.7771000000; feg[146] = 0.0794000000;
					g[147] = 7.3500000000; fxg[147] = 3.7476000000; feg[147] = 0.0784000000;
					g[148] = 7.4000000000; fxg[148] = 3.7173000000; feg[148] = 0.0774000000;
					g[149] = 7.4500000000; fxg[149] = 3.6854000000; feg[149] = 0.0764000000;
					g[150] = 7.5000000000; fxg[150] = 3.6521000000; feg[150] = 0.0755000000;
					g[151] = 7.5500000000; fxg[151] = 3.6179000000; feg[151] = 0.0745000000;
					g[152] = 7.6000000000; fxg[152] = 3.5837000000; feg[152] = 0.0736000000;
					g[153] = 7.6500000000; fxg[153] = 3.5499000000; feg[153] = 0.0727000000;
					g[154] = 7.7000000000; fxg[154] = 3.5164000000; feg[154] = 0.0718000000;
					g[155] = 7.7500000000; fxg[155] = 3.4829000000; feg[155] = 0.0710000000;
					g[156] = 7.8000000000; fxg[156] = 3.4494000000; feg[156] = 0.0701000000;
					g[157] = 7.8500000000; fxg[157] = 3.4161000000; feg[157] = 0.0693000000;
					g[158] = 7.9000000000; fxg[158] = 3.3837000000; feg[158] = 0.0684000000;
					g[159] = 7.9500000000; fxg[159] = 3.3529000000; feg[159] = 0.0676000000;
					g[160] = 8.0000000000; fxg[160] = 3.3241000000; feg[160] = 0.0668000000;
					g[161] = 8.0500000000; fxg[161] = 3.2971000000; feg[161] = 0.0660000000;
					g[162] = 8.1000000000; fxg[162] = 3.2709000000; feg[162] = 0.0653000000;
					g[163] = 8.1500000000; fxg[163] = 3.2443000000; feg[163] = 0.0645000000;
					g[164] = 8.2000000000; fxg[164] = 3.2163000000; feg[164] = 0.0638000000;
					g[165] = 8.2500000000; fxg[165] = 3.1866000000; feg[165] = 0.0630000000;
					g[166] = 8.3000000000; fxg[166] = 3.1556000000; feg[166] = 0.0623000000;
					g[167] = 8.3500000000; fxg[167] = 3.1241000000; feg[167] = 0.0616000000;
					g[168] = 8.4000000000; fxg[168] = 3.0929000000; feg[168] = 0.0609000000;
					g[169] = 8.4500000000; fxg[169] = 3.0624000000; feg[169] = 0.0603000000;
					g[170] = 8.5000000000; fxg[170] = 3.0324000000; feg[170] = 0.0596000000;
					g[171] = 8.5500000000; fxg[171] = 3.0025000000; feg[171] = 0.0589000000;
					g[172] = 8.6000000000; fxg[172] = 2.9725000000; feg[172] = 0.0583000000;
					g[173] = 8.6500000000; fxg[173] = 2.9425000000; feg[173] = 0.0577000000;
					g[174] = 8.7000000000; fxg[174] = 2.9131000000; feg[174] = 0.0570000000;
					g[175] = 8.7500000000; fxg[175] = 2.8849000000; feg[175] = 0.0564000000;
					g[176] = 8.8000000000; fxg[176] = 2.8587000000; feg[176] = 0.0558000000;
					g[177] = 8.8500000000; fxg[177] = 2.8347000000; feg[177] = 0.0552000000;
					g[178] = 8.9000000000; fxg[178] = 2.8125000000; feg[178] = 0.0546000000;
					g[179] = 8.9500000000; fxg[179] = 2.7913000000; feg[179] = 0.0540000000;
					g[180] = 9.0000000000; fxg[180] = 2.7696000000; feg[180] = 0.0535000000;
					g[181] = 9.0500000000; fxg[181] = 2.7467000000; feg[181] = 0.0529000000;
					g[182] = 9.1000000000; fxg[182] = 2.7219000000; feg[182] = 0.0523000000;
					g[183] = 9.1500000000; fxg[183] = 2.6956000000; feg[183] = 0.0518000000;
					g[184] = 9.2000000000; fxg[184] = 2.6684000000; feg[184] = 0.0513000000;
					g[185] = 9.2500000000; fxg[185] = 2.6413000000; feg[185] = 0.0508000000;
					g[186] = 9.3000000000; fxg[186] = 2.6149000000; feg[186] = 0.0502000000;
					g[187] = 9.3500000000; fxg[187] = 2.5893000000; feg[187] = 0.0497000000;
					g[188] = 9.4000000000; fxg[188] = 2.5642000000; feg[188] = 0.0492000000;
					g[189] = 9.4500000000; fxg[189] = 2.5391000000; feg[189] = 0.0487000000;
					g[190] = 9.5000000000; fxg[190] = 2.5138000000; feg[190] = 0.0483000000;
					g[191] = 9.5500000000; fxg[191] = 2.4885000000; feg[191] = 0.0478000000;
					g[192] = 9.6000000000; fxg[192] = 2.4637000000; feg[192] = 0.0473000000;
					g[193] = 9.6500000000; fxg[193] = 2.4400000000; feg[193] = 0.0468000000;
					g[194] = 9.7000000000; fxg[194] = 2.4181000000; feg[194] = 0.0464000000;
					g[195] = 9.7500000000; fxg[195] = 2.3983000000; feg[195] = 0.0459000000;
					g[196] = 9.8000000000; fxg[196] = 2.3807000000; feg[196] = 0.0455000000;
					g[197] = 9.8500000000; fxg[197] = 2.3649000000; feg[197] = 0.0450000000;
					g[198] = 9.9000000000; fxg[198] = 2.3496000000; feg[198] = 0.0446000000;
					g[199] = 9.9500000000; fxg[199] = 2.3338000000; feg[199] = 0.0442000000;
					g[200] = 10.0000000000; fxg[200] = 2.3165000000; feg[200] = 0.0437000000;
					g[201] = 10.0500000000; fxg[201] = 2.2974000000; feg[201] = 0.0433000000;
					g[202] = 10.1000000000; fxg[202] = 2.2766000000; feg[202] = 0.0429000000;
					g[203] = 10.1500000000; fxg[203] = 2.2546000000; feg[203] = 0.0425000000;
					g[204] = 10.2000000000; fxg[204] = 2.2324000000; feg[204] = 0.0421000000;
					g[205] = 10.2500000000; fxg[205] = 2.2107000000; feg[205] = 0.0417000000;
					g[206] = 10.3000000000; fxg[206] = 2.1900000000; feg[206] = 0.0413000000;
					g[207] = 10.3500000000; fxg[207] = 2.1699000000; feg[207] = 0.0410000000;
					g[208] = 10.4000000000; fxg[208] = 2.1501000000; feg[208] = 0.0406000000;
					g[209] = 10.4500000000; fxg[209] = 2.1301000000; feg[209] = 0.0402000000;
					g[210] = 10.5000000000; fxg[210] = 2.1099000000; feg[210] = 0.0398000000;
					g[211] = 10.5500000000; fxg[211] = 2.0898000000; feg[211] = 0.0395000000;
					g[212] = 10.6000000000; fxg[212] = 2.0701000000; feg[212] = 0.0391000000;
					g[213] = 10.6500000000; fxg[213] = 2.0514000000; feg[213] = 0.0388000000;
					g[214] = 10.7000000000; fxg[214] = 2.0341000000; feg[214] = 0.0384000000;
					g[215] = 10.7500000000; fxg[215] = 2.0190000000; feg[215] = 0.0381000000;
					g[216] = 10.8000000000; fxg[216] = 2.0061000000; feg[216] = 0.0378000000;
					g[217] = 10.8500000000; fxg[217] = 1.9953000000; feg[217] = 0.0374000000;
					g[218] = 10.9000000000; fxg[218] = 1.9859000000; feg[218] = 0.0371000000;
					g[219] = 10.9500000000; fxg[219] = 1.9767000000; feg[219] = 0.0367000000;
					g[220] = 11.0000000000; fxg[220] = 1.9668000000; feg[220] = 0.0364000000;
					g[221] = 11.0500000000; fxg[221] = 1.9553000000; feg[221] = 0.0361000000;
					g[222] = 11.1000000000; fxg[222] = 1.9418000000; feg[222] = 0.0358000000;
					g[223] = 11.1500000000; fxg[223] = 1.9266000000; feg[223] = 0.0355000000;
					g[224] = 11.2000000000; fxg[224] = 1.9099000000; feg[224] = 0.0352000000;
					g[225] = 11.2500000000; fxg[225] = 1.8926000000; feg[225] = 0.0349000000;
					g[226] = 11.3000000000; fxg[226] = 1.8754000000; feg[226] = 0.0346000000;
					g[227] = 11.3500000000; fxg[227] = 1.8591000000; feg[227] = 0.0343000000;
					g[228] = 11.4000000000; fxg[228] = 1.8436000000; feg[228] = 0.0340000000;
					g[229] = 11.4500000000; fxg[229] = 1.8286000000; feg[229] = 0.0337000000;
					g[230] = 11.5000000000; fxg[230] = 1.8136000000; feg[230] = 0.0334000000;
					g[231] = 11.5500000000; fxg[231] = 1.7982000000; feg[231] = 0.0332000000;
					g[232] = 11.6000000000; fxg[232] = 1.7826000000; feg[232] = 0.0329000000;
					g[233] = 11.6500000000; fxg[233] = 1.7670000000; feg[233] = 0.0326000000;
					g[234] = 11.7000000000; fxg[234] = 1.7519000000; feg[234] = 0.0323000000;
					g[235] = 11.7500000000; fxg[235] = 1.7375000000; feg[235] = 0.0321000000;
					g[236] = 11.8000000000; fxg[236] = 1.7244000000; feg[236] = 0.0318000000;
					g[237] = 11.8500000000; fxg[237] = 1.7130000000; feg[237] = 0.0316000000;
					g[238] = 11.9000000000; fxg[238] = 1.7037000000; feg[238] = 0.0313000000;
					g[239] = 11.9500000000; fxg[239] = 1.6967000000; feg[239] = 0.0310000000;
					g[240] = 12.0000000000; fxg[240] = 1.6917000000; feg[240] = 0.0308000000;
					break;
				case 49:
					g[0] = 0.0000000000; fxg[0] = 49.0000000000; feg[0] = 10.4348000000;
					g[1] = 0.0500000000; fxg[1] = 48.7322000000; feg[1] = 10.2569000000;
					g[2] = 0.1000000000; fxg[2] = 47.9797000000; feg[2] = 9.7678000000;
					g[3] = 0.1500000000; fxg[3] = 46.8671000000; feg[3] = 9.0750000000;
					g[4] = 0.2000000000; fxg[4] = 45.5334000000; feg[4] = 8.2969000000;
					g[5] = 0.2500000000; fxg[5] = 44.0885000000; feg[5] = 7.5232000000;
					g[6] = 0.3000000000; fxg[6] = 42.6024000000; feg[6] = 6.8053000000;
					g[7] = 0.3500000000; fxg[7] = 41.1130000000; feg[7] = 6.1638000000;
					g[8] = 0.4000000000; fxg[8] = 39.6393000000; feg[8] = 5.6009000000;
					g[9] = 0.4500000000; fxg[9] = 38.1910000000; feg[9] = 5.1101000000;
					g[10] = 0.5000000000; fxg[10] = 36.7745000000; feg[10] = 4.6816000000;
					g[11] = 0.5500000000; fxg[11] = 35.3954000000; feg[11] = 4.3055000000;
					g[12] = 0.6000000000; fxg[12] = 34.0593000000; feg[12] = 3.9732000000;
					g[13] = 0.6500000000; fxg[13] = 32.7715000000; feg[13] = 3.6772000000;
					g[14] = 0.7000000000; fxg[14] = 31.5374000000; feg[14] = 3.4118000000;
					g[15] = 0.7500000000; fxg[15] = 30.3613000000; feg[15] = 3.1722000000;
					g[16] = 0.8000000000; fxg[16] = 29.2465000000; feg[16] = 2.9548000000;
					g[17] = 0.8500000000; fxg[17] = 28.1950000000; feg[17] = 2.7568000000;
					g[18] = 0.9000000000; fxg[18] = 27.2078000000; feg[18] = 2.5756000000;
					g[19] = 0.9500000000; fxg[19] = 26.2845000000; feg[19] = 2.4096000000;
					g[20] = 1.0000000000; fxg[20] = 25.4237000000; feg[20] = 2.2571000000;
					g[21] = 1.0500000000; fxg[21] = 24.6232000000; feg[21] = 2.1167000000;
					g[22] = 1.1000000000; fxg[22] = 23.8799000000; feg[22] = 1.9875000000;
					g[23] = 1.1500000000; fxg[23] = 23.1904000000; feg[23] = 1.8683000000;
					g[24] = 1.2000000000; fxg[24] = 22.5508000000; feg[24] = 1.7584000000;
					g[25] = 1.2500000000; fxg[25] = 21.9569000000; feg[25] = 1.6569000000;
					g[26] = 1.3000000000; fxg[26] = 21.4045000000; feg[26] = 1.5632000000;
					g[27] = 1.3500000000; fxg[27] = 20.8894000000; feg[27] = 1.4766000000;
					g[28] = 1.4000000000; fxg[28] = 20.4074000000; feg[28] = 1.3966000000;
					g[29] = 1.4500000000; fxg[29] = 19.9547000000; feg[29] = 1.3225000000;
					g[30] = 1.5000000000; fxg[30] = 19.5276000000; feg[30] = 1.2540000000;
					g[31] = 1.5500000000; fxg[31] = 19.1226000000; feg[31] = 1.1906000000;
					g[32] = 1.6000000000; fxg[32] = 18.7365000000; feg[32] = 1.1317000000;
					g[33] = 1.6500000000; fxg[33] = 18.3666000000; feg[33] = 1.0772000000;
					g[34] = 1.7000000000; fxg[34] = 18.0102000000; feg[34] = 1.0266000000;
					g[35] = 1.7500000000; fxg[35] = 17.6652000000; feg[35] = 0.9795000000;
					g[36] = 1.8000000000; fxg[36] = 17.3297000000; feg[36] = 0.9358000000;
					g[37] = 1.8500000000; fxg[37] = 17.0021000000; feg[37] = 0.8951000000;
					g[38] = 1.9000000000; fxg[38] = 16.6808000000; feg[38] = 0.8571000000;
					g[39] = 1.9500000000; fxg[39] = 16.3648000000; feg[39] = 0.8216000000;
					g[40] = 2.0000000000; fxg[40] = 16.0534000000; feg[40] = 0.7885000000;
					g[41] = 2.0500000000; fxg[41] = 15.7456000000; feg[41] = 0.7575000000;
					g[42] = 2.1000000000; fxg[42] = 15.4409000000; feg[42] = 0.7285000000;
					g[43] = 2.1500000000; fxg[43] = 15.1392000000; feg[43] = 0.7013000000;
					g[44] = 2.2000000000; fxg[44] = 14.8402000000; feg[44] = 0.6757000000;
					g[45] = 2.2500000000; fxg[45] = 14.5438000000; feg[45] = 0.6516000000;
					g[46] = 2.3000000000; fxg[46] = 14.2496000000; feg[46] = 0.6289000000;
					g[47] = 2.3500000000; fxg[47] = 13.9581000000; feg[47] = 0.6075000000;
					g[48] = 2.4000000000; fxg[48] = 13.6696000000; feg[48] = 0.5872000000;
					g[49] = 2.4500000000; fxg[49] = 13.3843000000; feg[49] = 0.5680000000;
					g[50] = 2.5000000000; fxg[50] = 13.1020000000; feg[50] = 0.5499000000;
					g[51] = 2.5500000000; fxg[51] = 12.8228000000; feg[51] = 0.5326000000;
					g[52] = 2.6000000000; fxg[52] = 12.5475000000; feg[52] = 0.5162000000;
					g[53] = 2.6500000000; fxg[53] = 12.2766000000; feg[53] = 0.5006000000;
					g[54] = 2.7000000000; fxg[54] = 12.0103000000; feg[54] = 0.4858000000;
					g[55] = 2.7500000000; fxg[55] = 11.7485000000; feg[55] = 0.4716000000;
					g[56] = 2.8000000000; fxg[56] = 11.4911000000; feg[56] = 0.4580000000;
					g[57] = 2.8500000000; fxg[57] = 11.2386000000; feg[57] = 0.4451000000;
					g[58] = 2.9000000000; fxg[58] = 10.9919000000; feg[58] = 0.4327000000;
					g[59] = 2.9500000000; fxg[59] = 10.7514000000; feg[59] = 0.4208000000;
					g[60] = 3.0000000000; fxg[60] = 10.5169000000; feg[60] = 0.4094000000;
					g[61] = 3.0500000000; fxg[61] = 10.2880000000; feg[61] = 0.3984000000;
					g[62] = 3.1000000000; fxg[62] = 10.0644000000; feg[62] = 0.3879000000;
					g[63] = 3.1500000000; fxg[63] = 9.8468000000; feg[63] = 0.3778000000;
					g[64] = 3.2000000000; fxg[64] = 9.6359000000; feg[64] = 0.3680000000;
					g[65] = 3.2500000000; fxg[65] = 9.4323000000; feg[65] = 0.3586000000;
					g[66] = 3.3000000000; fxg[66] = 9.2355000000; feg[66] = 0.3496000000;
					g[67] = 3.3500000000; fxg[67] = 9.0448000000; feg[67] = 0.3408000000;
					g[68] = 3.4000000000; fxg[68] = 8.8596000000; feg[68] = 0.3324000000;
					g[69] = 3.4500000000; fxg[69] = 8.6800000000; feg[69] = 0.3243000000;
					g[70] = 3.5000000000; fxg[70] = 8.5067000000; feg[70] = 0.3165000000;
					g[71] = 3.5500000000; fxg[71] = 8.3405000000; feg[71] = 0.3089000000;
					g[72] = 3.6000000000; fxg[72] = 8.1815000000; feg[72] = 0.3015000000;
					g[73] = 3.6500000000; fxg[73] = 8.0290000000; feg[73] = 0.2944000000;
					g[74] = 3.7000000000; fxg[74] = 7.8819000000; feg[74] = 0.2875000000;
					g[75] = 3.7500000000; fxg[75] = 7.7396000000; feg[75] = 0.2809000000;
					g[76] = 3.8000000000; fxg[76] = 7.6019000000; feg[76] = 0.2745000000;
					g[77] = 3.8500000000; fxg[77] = 7.4695000000; feg[77] = 0.2682000000;
					g[78] = 3.9000000000; fxg[78] = 7.3430000000; feg[78] = 0.2622000000;
					g[79] = 3.9500000000; fxg[79] = 7.2229000000; feg[79] = 0.2563000000;
					g[80] = 4.0000000000; fxg[80] = 7.1089000000; feg[80] = 0.2507000000;
					g[81] = 4.0500000000; fxg[81] = 6.9999000000; feg[81] = 0.2451000000;
					g[82] = 4.1000000000; fxg[82] = 6.8947000000; feg[82] = 0.2398000000;
					g[83] = 4.1500000000; fxg[83] = 6.7927000000; feg[83] = 0.2346000000;
					g[84] = 4.2000000000; fxg[84] = 6.6939000000; feg[84] = 0.2296000000;
					g[85] = 4.2500000000; fxg[85] = 6.5990000000; feg[85] = 0.2247000000;
					g[86] = 4.3000000000; fxg[86] = 6.5085000000; feg[86] = 0.2200000000;
					g[87] = 4.3500000000; fxg[87] = 6.4229000000; feg[87] = 0.2154000000;
					g[88] = 4.4000000000; fxg[88] = 6.3424000000; feg[88] = 0.2109000000;
					g[89] = 4.4500000000; fxg[89] = 6.2660000000; feg[89] = 0.2066000000;
					g[90] = 4.5000000000; fxg[90] = 6.1923000000; feg[90] = 0.2024000000;
					g[91] = 4.5500000000; fxg[91] = 6.1203000000; feg[91] = 0.1983000000;
					g[92] = 4.6000000000; fxg[92] = 6.0498000000; feg[92] = 0.1943000000;
					g[93] = 4.6500000000; fxg[93] = 5.9813000000; feg[93] = 0.1905000000;
					g[94] = 4.7000000000; fxg[94] = 5.9151000000; feg[94] = 0.1867000000;
					g[95] = 4.7500000000; fxg[95] = 5.8518000000; feg[95] = 0.1831000000;
					g[96] = 4.8000000000; fxg[96] = 5.7920000000; feg[96] = 0.1795000000;
					g[97] = 4.8500000000; fxg[97] = 5.7359000000; feg[97] = 0.1761000000;
					g[98] = 4.9000000000; fxg[98] = 5.6829000000; feg[98] = 0.1727000000;
					g[99] = 4.9500000000; fxg[99] = 5.6318000000; feg[99] = 0.1694000000;
					g[100] = 5.0000000000; fxg[100] = 5.5812000000; feg[100] = 0.1663000000;
					g[101] = 5.0500000000; fxg[101] = 5.5306000000; feg[101] = 0.1632000000;
					g[102] = 5.1000000000; fxg[102] = 5.4804000000; feg[102] = 0.1602000000;
					g[103] = 5.1500000000; fxg[103] = 5.4311000000; feg[103] = 0.1573000000;
					g[104] = 5.2000000000; fxg[104] = 5.3830000000; feg[104] = 0.1544000000;
					g[105] = 5.2500000000; fxg[105] = 5.3365000000; feg[105] = 0.1517000000;
					g[106] = 5.3000000000; fxg[106] = 5.2922000000; feg[106] = 0.1490000000;
					g[107] = 5.3500000000; fxg[107] = 5.2507000000; feg[107] = 0.1463000000;
					g[108] = 5.4000000000; fxg[108] = 5.2116000000; feg[108] = 0.1438000000;
					g[109] = 5.4500000000; fxg[109] = 5.1737000000; feg[109] = 0.1413000000;
					g[110] = 5.5000000000; fxg[110] = 5.1356000000; feg[110] = 0.1388000000;
					g[111] = 5.5500000000; fxg[111] = 5.0965000000; feg[111] = 0.1365000000;
					g[112] = 5.6000000000; fxg[112] = 5.0566000000; feg[112] = 0.1341000000;
					g[113] = 5.6500000000; fxg[113] = 5.0167000000; feg[113] = 0.1319000000;
					g[114] = 5.7000000000; fxg[114] = 4.9772000000; feg[114] = 0.1297000000;
					g[115] = 5.7500000000; fxg[115] = 4.9380000000; feg[115] = 0.1276000000;
					g[116] = 5.8000000000; fxg[116] = 4.8995000000; feg[116] = 0.1255000000;
					g[117] = 5.8500000000; fxg[117] = 4.8623000000; feg[117] = 0.1235000000;
					g[118] = 5.9000000000; fxg[118] = 4.8271000000; feg[118] = 0.1215000000;
					g[119] = 5.9500000000; fxg[119] = 4.7941000000; feg[119] = 0.1195000000;
					g[120] = 6.0000000000; fxg[120] = 4.7623000000; feg[120] = 0.1176000000;
					g[121] = 6.0500000000; fxg[121] = 4.7302000000; feg[121] = 0.1158000000;
					g[122] = 6.1000000000; fxg[122] = 4.6967000000; feg[122] = 0.1140000000;
					g[123] = 6.1500000000; fxg[123] = 4.6616000000; feg[123] = 0.1122000000;
					g[124] = 6.2000000000; fxg[124] = 4.6256000000; feg[124] = 0.1105000000;
					g[125] = 6.2500000000; fxg[125] = 4.5896000000; feg[125] = 0.1088000000;
					g[126] = 6.3000000000; fxg[126] = 4.5537000000; feg[126] = 0.1072000000;
					g[127] = 6.3500000000; fxg[127] = 4.5179000000; feg[127] = 0.1056000000;
					g[128] = 6.4000000000; fxg[128] = 4.4820000000; feg[128] = 0.1041000000;
					g[129] = 6.4500000000; fxg[129] = 4.4468000000; feg[129] = 0.1025000000;
					g[130] = 6.5000000000; fxg[130] = 4.4131000000; feg[130] = 0.1010000000;
					g[131] = 6.5500000000; fxg[131] = 4.3814000000; feg[131] = 0.0996000000;
					g[132] = 6.6000000000; fxg[132] = 4.3514000000; feg[132] = 0.0981000000;
					g[133] = 6.6500000000; fxg[133] = 4.3218000000; feg[133] = 0.0967000000;
					g[134] = 6.7000000000; fxg[134] = 4.2912000000; feg[134] = 0.0953000000;
					g[135] = 6.7500000000; fxg[135] = 4.2587000000; feg[135] = 0.0940000000;
					g[136] = 6.8000000000; fxg[136] = 4.2245000000; feg[136] = 0.0927000000;
					g[137] = 6.8500000000; fxg[137] = 4.1895000000; feg[137] = 0.0914000000;
					g[138] = 6.9000000000; fxg[138] = 4.1547000000; feg[138] = 0.0902000000;
					g[139] = 6.9500000000; fxg[139] = 4.1202000000; feg[139] = 0.0890000000;
					g[140] = 7.0000000000; fxg[140] = 4.0856000000; feg[140] = 0.0878000000;
					g[141] = 7.0500000000; fxg[141] = 4.0507000000; feg[141] = 0.0866000000;
					g[142] = 7.1000000000; fxg[142] = 4.0159000000; feg[142] = 0.0854000000;
					g[143] = 7.1500000000; fxg[143] = 3.9819000000; feg[143] = 0.0843000000;
					g[144] = 7.2000000000; fxg[144] = 3.9496000000; feg[144] = 0.0832000000;
					g[145] = 7.2500000000; fxg[145] = 3.9194000000; feg[145] = 0.0821000000;
					g[146] = 7.3000000000; fxg[146] = 3.8909000000; feg[146] = 0.0810000000;
					g[147] = 7.3500000000; fxg[147] = 3.8627000000; feg[147] = 0.0800000000;
					g[148] = 7.4000000000; fxg[148] = 3.8334000000; feg[148] = 0.0790000000;
					g[149] = 7.4500000000; fxg[149] = 3.8020000000; feg[149] = 0.0780000000;
					g[150] = 7.5000000000; fxg[150] = 3.7688000000; feg[150] = 0.0770000000;
					g[151] = 7.5500000000; fxg[151] = 3.7347000000; feg[151] = 0.0760000000;
					g[152] = 7.6000000000; fxg[152] = 3.7008000000; feg[152] = 0.0751000000;
					g[153] = 7.6500000000; fxg[153] = 3.6676000000; feg[153] = 0.0742000000;
					g[154] = 7.7000000000; fxg[154] = 3.6348000000; feg[154] = 0.0733000000;
					g[155] = 7.7500000000; fxg[155] = 3.6018000000; feg[155] = 0.0724000000;
					g[156] = 7.8000000000; fxg[156] = 3.5684000000; feg[156] = 0.0715000000;
					g[157] = 7.8500000000; fxg[157] = 3.5349000000; feg[157] = 0.0706000000;
					g[158] = 7.9000000000; fxg[158] = 3.5023000000; feg[158] = 0.0698000000;
					g[159] = 7.9500000000; fxg[159] = 3.4714000000; feg[159] = 0.0690000000;
					g[160] = 8.0000000000; fxg[160] = 3.4428000000; feg[160] = 0.0681000000;
					g[161] = 8.0500000000; fxg[161] = 3.4162000000; feg[161] = 0.0673000000;
					g[162] = 8.1000000000; fxg[162] = 3.3906000000; feg[162] = 0.0666000000;
					g[163] = 8.1500000000; fxg[163] = 3.3645000000; feg[163] = 0.0658000000;
					g[164] = 8.2000000000; fxg[164] = 3.3366000000; feg[164] = 0.0650000000;
					g[165] = 8.2500000000; fxg[165] = 3.3066000000; feg[165] = 0.0643000000;
					g[166] = 8.3000000000; fxg[166] = 3.2750000000; feg[166] = 0.0635000000;
					g[167] = 8.3500000000; fxg[167] = 3.2431000000; feg[167] = 0.0628000000;
					g[168] = 8.4000000000; fxg[168] = 3.2118000000; feg[168] = 0.0621000000;
					g[169] = 8.4500000000; fxg[169] = 3.1814000000; feg[169] = 0.0614000000;
					g[170] = 8.5000000000; fxg[170] = 3.1517000000; feg[170] = 0.0608000000;
					g[171] = 8.5500000000; fxg[171] = 3.1220000000; feg[171] = 0.0601000000;
					g[172] = 8.6000000000; fxg[172] = 3.0917000000; feg[172] = 0.0594000000;
					g[173] = 8.6500000000; fxg[173] = 3.0613000000; feg[173] = 0.0588000000;
					g[174] = 8.7000000000; fxg[174] = 3.0311000000; feg[174] = 0.0581000000;
					g[175] = 8.7500000000; fxg[175] = 3.0022000000; feg[175] = 0.0575000000;
					g[176] = 8.8000000000; fxg[176] = 2.9752000000; feg[176] = 0.0569000000;
					g[177] = 8.8500000000; fxg[177] = 2.9507000000; feg[177] = 0.0563000000;
					g[178] = 8.9000000000; fxg[178] = 2.9284000000; feg[178] = 0.0557000000;
					g[179] = 8.9500000000; fxg[179] = 2.9071000000; feg[179] = 0.0551000000;
					g[180] = 9.0000000000; fxg[180] = 2.8853000000; feg[180] = 0.0545000000;
					g[181] = 9.0500000000; fxg[181] = 2.8618000000; feg[181] = 0.0539000000;
					g[182] = 9.1000000000; fxg[182] = 2.8362000000; feg[182] = 0.0534000000;
					g[183] = 9.1500000000; fxg[183] = 2.8088000000; feg[183] = 0.0528000000;
					g[184] = 9.2000000000; fxg[184] = 2.7806000000; feg[184] = 0.0523000000;
					g[185] = 9.2500000000; fxg[185] = 2.7526000000; feg[185] = 0.0517000000;
					g[186] = 9.3000000000; fxg[186] = 2.7258000000; feg[186] = 0.0512000000;
					g[187] = 9.3500000000; fxg[187] = 2.7002000000; feg[187] = 0.0507000000;
					g[188] = 9.4000000000; fxg[188] = 2.6751000000; feg[188] = 0.0502000000;
					g[189] = 9.4500000000; fxg[189] = 2.6499000000; feg[189] = 0.0497000000;
					g[190] = 9.5000000000; fxg[190] = 2.6241000000; feg[190] = 0.0492000000;
					g[191] = 9.5500000000; fxg[191] = 2.5981000000; feg[191] = 0.0487000000;
					g[192] = 9.6000000000; fxg[192] = 2.5723000000; feg[192] = 0.0482000000;
					g[193] = 9.6500000000; fxg[193] = 2.5474000000; feg[193] = 0.0478000000;
					g[194] = 9.7000000000; fxg[194] = 2.5242000000; feg[194] = 0.0473000000;
					g[195] = 9.7500000000; fxg[195] = 2.5033000000; feg[195] = 0.0468000000;
					g[196] = 9.8000000000; fxg[196] = 2.4849000000; feg[196] = 0.0464000000;
					g[197] = 9.8500000000; fxg[197] = 2.4685000000; feg[197] = 0.0459000000;
					g[198] = 9.9000000000; fxg[198] = 2.4528000000; feg[198] = 0.0455000000;
					g[199] = 9.9500000000; fxg[199] = 2.4363000000; feg[199] = 0.0450000000;
					g[200] = 10.0000000000; fxg[200] = 2.4181000000; feg[200] = 0.0446000000;
					g[201] = 10.0500000000; fxg[201] = 2.3977000000; feg[201] = 0.0442000000;
					g[202] = 10.1000000000; fxg[202] = 2.3755000000; feg[202] = 0.0438000000;
					g[203] = 10.1500000000; fxg[203] = 2.3521000000; feg[203] = 0.0433000000;
					g[204] = 10.2000000000; fxg[204] = 2.3287000000; feg[204] = 0.0429000000;
					g[205] = 10.2500000000; fxg[205] = 2.3062000000; feg[205] = 0.0425000000;
					g[206] = 10.3000000000; fxg[206] = 2.2851000000; feg[206] = 0.0422000000;
					g[207] = 10.3500000000; fxg[207] = 2.2651000000; feg[207] = 0.0418000000;
					g[208] = 10.4000000000; fxg[208] = 2.2452000000; feg[208] = 0.0414000000;
					g[209] = 10.4500000000; fxg[209] = 2.2250000000; feg[209] = 0.0410000000;
					g[210] = 10.5000000000; fxg[210] = 2.2042000000; feg[210] = 0.0406000000;
					g[211] = 10.5500000000; fxg[211] = 2.1832000000; feg[211] = 0.0403000000;
					g[212] = 10.6000000000; fxg[212] = 2.1625000000; feg[212] = 0.0399000000;
					g[213] = 10.6500000000; fxg[213] = 2.1425000000; feg[213] = 0.0396000000;
					g[214] = 10.7000000000; fxg[214] = 2.1239000000; feg[214] = 0.0392000000;
					g[215] = 10.7500000000; fxg[215] = 2.1073000000; feg[215] = 0.0388000000;
					g[216] = 10.8000000000; fxg[216] = 2.0932000000; feg[216] = 0.0385000000;
					g[217] = 10.8500000000; fxg[217] = 2.0815000000; feg[217] = 0.0382000000;
					g[218] = 10.9000000000; fxg[218] = 2.0714000000; feg[218] = 0.0378000000;
					g[219] = 10.9500000000; fxg[219] = 2.0616000000; feg[219] = 0.0375000000;
					g[220] = 11.0000000000; fxg[220] = 2.0508000000; feg[220] = 0.0371000000;
					g[221] = 11.0500000000; fxg[221] = 2.0382000000; feg[221] = 0.0368000000;
					g[222] = 11.1000000000; fxg[222] = 2.0234000000; feg[222] = 0.0365000000;
					g[223] = 11.1500000000; fxg[223] = 2.0067000000; feg[223] = 0.0362000000;
					g[224] = 11.2000000000; fxg[224] = 1.9886000000; feg[224] = 0.0359000000;
					g[225] = 11.2500000000; fxg[225] = 1.9699000000; feg[225] = 0.0356000000;
					g[226] = 11.3000000000; fxg[226] = 1.9517000000; feg[226] = 0.0353000000;
					g[227] = 11.3500000000; fxg[227] = 1.9348000000; feg[227] = 0.0350000000;
					g[228] = 11.4000000000; fxg[228] = 1.9192000000; feg[228] = 0.0347000000;
					g[229] = 11.4500000000; fxg[229] = 1.9043000000; feg[229] = 0.0344000000;
					g[230] = 11.5000000000; fxg[230] = 1.8893000000; feg[230] = 0.0341000000;
					g[231] = 11.5500000000; fxg[231] = 1.8737000000; feg[231] = 0.0338000000;
					g[232] = 11.6000000000; fxg[232] = 1.8576000000; feg[232] = 0.0335000000;
					g[233] = 11.6500000000; fxg[233] = 1.8414000000; feg[233] = 0.0333000000;
					g[234] = 11.7000000000; fxg[234] = 1.8253000000; feg[234] = 0.0330000000;
					g[235] = 11.7500000000; fxg[235] = 1.8099000000; feg[235] = 0.0327000000;
					g[236] = 11.8000000000; fxg[236] = 1.7956000000; feg[236] = 0.0325000000;
					g[237] = 11.8500000000; fxg[237] = 1.7829000000; feg[237] = 0.0322000000;
					g[238] = 11.9000000000; fxg[238] = 1.7723000000; feg[238] = 0.0319000000;
					g[239] = 11.9500000000; fxg[239] = 1.7642000000; feg[239] = 0.0317000000;
					g[240] = 12.0000000000; fxg[240] = 1.7584000000; feg[240] = 0.0314000000;
					break;
				case 50:
					g[0] = 0.0000000000; fxg[0] = 50.0000000000; feg[0] = 11.0024000000;
					g[1] = 0.0500000000; fxg[1] = 49.7174000000; feg[1] = 10.8214000000;
					g[2] = 0.1000000000; fxg[2] = 48.9222000000; feg[2] = 10.3186000000;
					g[3] = 0.1500000000; fxg[3] = 47.7451000000; feg[3] = 9.5942000000;
					g[4] = 0.2000000000; fxg[4] = 46.3380000000; feg[4] = 8.7644000000;
					g[5] = 0.2500000000; fxg[5] = 44.8262000000; feg[5] = 7.9250000000;
					g[6] = 0.3000000000; fxg[6] = 43.2910000000; feg[6] = 7.1365000000;
					g[7] = 0.3500000000; fxg[7] = 41.7752000000; feg[7] = 6.4277000000;
					g[8] = 0.4000000000; fxg[8] = 40.2966000000; feg[8] = 5.8060000000;
					g[9] = 0.4500000000; fxg[9] = 38.8599000000; feg[9] = 5.2666000000;
					g[10] = 0.5000000000; fxg[10] = 37.4651000000; feg[10] = 4.8001000000;
					g[11] = 0.5500000000; fxg[11] = 36.1116000000; feg[11] = 4.3954000000;
					g[12] = 0.6000000000; fxg[12] = 34.7998000000; feg[12] = 4.0422000000;
					g[13] = 0.6500000000; fxg[13] = 33.5312000000; feg[13] = 3.7317000000;
					g[14] = 0.7000000000; fxg[14] = 32.3087000000; feg[14] = 3.4565000000;
					g[15] = 0.7500000000; fxg[15] = 31.1353000000; feg[15] = 3.2107000000;
					g[16] = 0.8000000000; fxg[16] = 30.0144000000; feg[16] = 2.9896000000;
					g[17] = 0.8500000000; fxg[17] = 28.9485000000; feg[17] = 2.7894000000;
					g[18] = 0.9000000000; fxg[18] = 27.9396000000; feg[18] = 2.6073000000;
					g[19] = 0.9500000000; fxg[19] = 26.9887000000; feg[19] = 2.4410000000;
					g[20] = 1.0000000000; fxg[20] = 26.0958000000; feg[20] = 2.2885000000;
					g[21] = 1.0500000000; fxg[21] = 25.2604000000; feg[21] = 2.1482000000;
					g[22] = 1.1000000000; fxg[22] = 24.4806000000; feg[22] = 2.0191000000;
					g[23] = 1.1500000000; fxg[23] = 23.7542000000; feg[23] = 1.8999000000;
					g[24] = 1.2000000000; fxg[24] = 23.0785000000; feg[24] = 1.7898000000;
					g[25] = 1.2500000000; fxg[25] = 22.4501000000; feg[25] = 1.6880000000;
					g[26] = 1.3000000000; fxg[26] = 21.8656000000; feg[26] = 1.5938000000;
					g[27] = 1.3500000000; fxg[27] = 21.3212000000; feg[27] = 1.5065000000;
					g[28] = 1.4000000000; fxg[28] = 20.8131000000; feg[28] = 1.4256000000;
					g[29] = 1.4500000000; fxg[29] = 20.3377000000; feg[29] = 1.3506000000;
					g[30] = 1.5000000000; fxg[30] = 19.8914000000; feg[30] = 1.2811000000;
					g[31] = 1.5500000000; fxg[31] = 19.4707000000; feg[31] = 1.2165000000;
					g[32] = 1.6000000000; fxg[32] = 19.0723000000; feg[32] = 1.1566000000;
					g[33] = 1.6500000000; fxg[33] = 18.6933000000; feg[33] = 1.1009000000;
					g[34] = 1.7000000000; fxg[34] = 18.3308000000; feg[34] = 1.0491000000;
					g[35] = 1.7500000000; fxg[35] = 17.9825000000; feg[35] = 1.0009000000;
					g[36] = 1.8000000000; fxg[36] = 17.6461000000; feg[36] = 0.9560000000;
					g[37] = 1.8500000000; fxg[37] = 17.3197000000; feg[37] = 0.9141000000;
					g[38] = 1.9000000000; fxg[38] = 17.0015000000; feg[38] = 0.8751000000;
					g[39] = 1.9500000000; fxg[39] = 16.6902000000; feg[39] = 0.8386000000;
					g[40] = 2.0000000000; fxg[40] = 16.3846000000; feg[40] = 0.8045000000;
					g[41] = 2.0500000000; fxg[41] = 16.0837000000; feg[41] = 0.7726000000;
					g[42] = 2.1000000000; fxg[42] = 15.7865000000; feg[42] = 0.7427000000;
					g[43] = 2.1500000000; fxg[43] = 15.4928000000; feg[43] = 0.7147000000;
					g[44] = 2.2000000000; fxg[44] = 15.2020000000; feg[44] = 0.6883000000;
					g[45] = 2.2500000000; fxg[45] = 14.9137000000; feg[45] = 0.6635000000;
					g[46] = 2.3000000000; fxg[46] = 14.6275000000; feg[46] = 0.6401000000;
					g[47] = 2.3500000000; fxg[47] = 14.3437000000; feg[47] = 0.6181000000;
					g[48] = 2.4000000000; fxg[48] = 14.0624000000; feg[48] = 0.5973000000;
					g[49] = 2.4500000000; fxg[49] = 13.7835000000; feg[49] = 0.5776000000;
					g[50] = 2.5000000000; fxg[50] = 13.5070000000; feg[50] = 0.5590000000;
					g[51] = 2.5500000000; fxg[51] = 13.2330000000; feg[51] = 0.5413000000;
					g[52] = 2.6000000000; fxg[52] = 12.9618000000; feg[52] = 0.5245000000;
					g[53] = 2.6500000000; fxg[53] = 12.6942000000; feg[53] = 0.5086000000;
					g[54] = 2.7000000000; fxg[54] = 12.4304000000; feg[54] = 0.4934000000;
					g[55] = 2.7500000000; fxg[55] = 12.1700000000; feg[55] = 0.4789000000;
					g[56] = 2.8000000000; fxg[56] = 11.9131000000; feg[56] = 0.4651000000;
					g[57] = 2.8500000000; fxg[57] = 11.6603000000; feg[57] = 0.4519000000;
					g[58] = 2.9000000000; fxg[58] = 11.4123000000; feg[58] = 0.4393000000;
					g[59] = 2.9500000000; fxg[59] = 11.1696000000; feg[59] = 0.4272000000;
					g[60] = 3.0000000000; fxg[60] = 10.9322000000; feg[60] = 0.4156000000;
					g[61] = 3.0500000000; fxg[61] = 10.6994000000; feg[61] = 0.4045000000;
					g[62] = 3.1000000000; fxg[62] = 10.4713000000; feg[62] = 0.3938000000;
					g[63] = 3.1500000000; fxg[63] = 10.2484000000; feg[63] = 0.3835000000;
					g[64] = 3.2000000000; fxg[64] = 10.0317000000; feg[64] = 0.3737000000;
					g[65] = 3.2500000000; fxg[65] = 9.8216000000; feg[65] = 0.3642000000;
					g[66] = 3.3000000000; fxg[66] = 9.6178000000; feg[66] = 0.3550000000;
					g[67] = 3.3500000000; fxg[67] = 9.4196000000; feg[67] = 0.3462000000;
					g[68] = 3.4000000000; fxg[68] = 9.2264000000; feg[68] = 0.3377000000;
					g[69] = 3.4500000000; fxg[69] = 9.0385000000; feg[69] = 0.3295000000;
					g[70] = 3.5000000000; fxg[70] = 8.8565000000; feg[70] = 0.3215000000;
					g[71] = 3.5500000000; fxg[71] = 8.6814000000; feg[71] = 0.3139000000;
					g[72] = 3.6000000000; fxg[72] = 8.5134000000; feg[72] = 0.3065000000;
					g[73] = 3.6500000000; fxg[73] = 8.3517000000; feg[73] = 0.2993000000;
					g[74] = 3.7000000000; fxg[74] = 8.1954000000; feg[74] = 0.2923000000;
					g[75] = 3.7500000000; fxg[75] = 8.0436000000; feg[75] = 0.2856000000;
					g[76] = 3.8000000000; fxg[76] = 7.8963000000; feg[76] = 0.2791000000;
					g[77] = 3.8500000000; fxg[77] = 7.7543000000; feg[77] = 0.2729000000;
					g[78] = 3.9000000000; fxg[78] = 7.6184000000; feg[78] = 0.2668000000;
					g[79] = 3.9500000000; fxg[79] = 7.4891000000; feg[79] = 0.2608000000;
					g[80] = 4.0000000000; fxg[80] = 7.3661000000; feg[80] = 0.2551000000;
					g[81] = 4.0500000000; fxg[81] = 7.2483000000; feg[81] = 0.2495000000;
					g[82] = 4.1000000000; fxg[82] = 7.1343000000; feg[82] = 0.2441000000;
					g[83] = 4.1500000000; fxg[83] = 7.0235000000; feg[83] = 0.2389000000;
					g[84] = 4.2000000000; fxg[84] = 6.9161000000; feg[84] = 0.2338000000;
					g[85] = 4.2500000000; fxg[85] = 6.8127000000; feg[85] = 0.2289000000;
					g[86] = 4.3000000000; fxg[86] = 6.7140000000; feg[86] = 0.2241000000;
					g[87] = 4.3500000000; fxg[87] = 6.6208000000; feg[87] = 0.2195000000;
					g[88] = 4.4000000000; fxg[88] = 6.5331000000; feg[88] = 0.2149000000;
					g[89] = 4.4500000000; fxg[89] = 6.4498000000; feg[89] = 0.2105000000;
					g[90] = 4.5000000000; fxg[90] = 6.3694000000; feg[90] = 0.2063000000;
					g[91] = 4.5500000000; fxg[91] = 6.2910000000; feg[91] = 0.2021000000;
					g[92] = 4.6000000000; fxg[92] = 6.2141000000; feg[92] = 0.1981000000;
					g[93] = 4.6500000000; fxg[93] = 6.1392000000; feg[93] = 0.1942000000;
					g[94] = 4.7000000000; fxg[94] = 6.0670000000; feg[94] = 0.1904000000;
					g[95] = 4.7500000000; fxg[95] = 5.9981000000; feg[95] = 0.1867000000;
					g[96] = 4.8000000000; fxg[96] = 5.9333000000; feg[96] = 0.1831000000;
					g[97] = 4.8500000000; fxg[97] = 5.8727000000; feg[97] = 0.1796000000;
					g[98] = 4.9000000000; fxg[98] = 5.8156000000; feg[98] = 0.1762000000;
					g[99] = 4.9500000000; fxg[99] = 5.7606000000; feg[99] = 0.1728000000;
					g[100] = 5.0000000000; fxg[100] = 5.7063000000; feg[100] = 0.1696000000;
					g[101] = 5.0500000000; fxg[101] = 5.6521000000; feg[101] = 0.1665000000;
					g[102] = 5.1000000000; fxg[102] = 5.5983000000; feg[102] = 0.1634000000;
					g[103] = 5.1500000000; fxg[103] = 5.5454000000; feg[103] = 0.1605000000;
					g[104] = 5.2000000000; fxg[104] = 5.4940000000; feg[104] = 0.1576000000;
					g[105] = 5.2500000000; fxg[105] = 5.4446000000; feg[105] = 0.1548000000;
					g[106] = 5.3000000000; fxg[106] = 5.3980000000; feg[106] = 0.1520000000;
					g[107] = 5.3500000000; fxg[107] = 5.3545000000; feg[107] = 0.1493000000;
					g[108] = 5.4000000000; fxg[108] = 5.3139000000; feg[108] = 0.1467000000;
					g[109] = 5.4500000000; fxg[109] = 5.2748000000; feg[109] = 0.1442000000;
					g[110] = 5.5000000000; fxg[110] = 5.2355000000; feg[110] = 0.1417000000;
					g[111] = 5.5500000000; fxg[111] = 5.1953000000; feg[111] = 0.1393000000;
					g[112] = 5.6000000000; fxg[112] = 5.1542000000; feg[112] = 0.1369000000;
					g[113] = 5.6500000000; fxg[113] = 5.1130000000; feg[113] = 0.1346000000;
					g[114] = 5.7000000000; fxg[114] = 5.0720000000; feg[114] = 0.1324000000;
					g[115] = 5.7500000000; fxg[115] = 5.0317000000; feg[115] = 0.1302000000;
					g[116] = 5.8000000000; fxg[116] = 4.9923000000; feg[116] = 0.1281000000;
					g[117] = 5.8500000000; fxg[117] = 4.9546000000; feg[117] = 0.1260000000;
					g[118] = 5.9000000000; fxg[118] = 4.9194000000; feg[118] = 0.1240000000;
					g[119] = 5.9500000000; fxg[119] = 4.8867000000; feg[119] = 0.1220000000;
					g[120] = 6.0000000000; fxg[120] = 4.8554000000; feg[120] = 0.1201000000;
					g[121] = 6.0500000000; fxg[121] = 4.8239000000; feg[121] = 0.1182000000;
					g[122] = 6.1000000000; fxg[122] = 4.7909000000; feg[122] = 0.1163000000;
					g[123] = 6.1500000000; fxg[123] = 4.7562000000; feg[123] = 0.1145000000;
					g[124] = 6.2000000000; fxg[124] = 4.7204000000; feg[124] = 0.1128000000;
					g[125] = 6.2500000000; fxg[125] = 4.6844000000; feg[125] = 0.1111000000;
					g[126] = 6.3000000000; fxg[126] = 4.6484000000; feg[126] = 0.1094000000;
					g[127] = 6.3500000000; fxg[127] = 4.6125000000; feg[127] = 0.1078000000;
					g[128] = 6.4000000000; fxg[128] = 4.5768000000; feg[128] = 0.1062000000;
					g[129] = 6.4500000000; fxg[129] = 4.5420000000; feg[129] = 0.1046000000;
					g[130] = 6.5000000000; fxg[130] = 4.5090000000; feg[130] = 0.1031000000;
					g[131] = 6.5500000000; fxg[131] = 4.4784000000; feg[131] = 0.1016000000;
					g[132] = 6.6000000000; fxg[132] = 4.4496000000; feg[132] = 0.1001000000;
					g[133] = 6.6500000000; fxg[133] = 4.4214000000; feg[133] = 0.0987000000;
					g[134] = 6.7000000000; fxg[134] = 4.3920000000; feg[134] = 0.0973000000;
					g[135] = 6.7500000000; fxg[135] = 4.3606000000; feg[135] = 0.0959000000;
					g[136] = 6.8000000000; fxg[136] = 4.3272000000; feg[136] = 0.0946000000;
					g[137] = 6.8500000000; fxg[137] = 4.2929000000; feg[137] = 0.0933000000;
					g[138] = 6.9000000000; fxg[138] = 4.2585000000; feg[138] = 0.0920000000;
					g[139] = 6.9500000000; fxg[139] = 4.2243000000; feg[139] = 0.0907000000;
					g[140] = 7.0000000000; fxg[140] = 4.1901000000; feg[140] = 0.0895000000;
					g[141] = 7.0500000000; fxg[141] = 4.1556000000; feg[141] = 0.0883000000;
					g[142] = 7.1000000000; fxg[142] = 4.1211000000; feg[142] = 0.0871000000;
					g[143] = 7.1500000000; fxg[143] = 4.0877000000; feg[143] = 0.0860000000;
					g[144] = 7.2000000000; fxg[144] = 4.0563000000; feg[144] = 0.0848000000;
					g[145] = 7.2500000000; fxg[145] = 4.0272000000; feg[145] = 0.0837000000;
					g[146] = 7.3000000000; fxg[146] = 3.9999000000; feg[146] = 0.0826000000;
					g[147] = 7.3500000000; fxg[147] = 3.9730000000; feg[147] = 0.0816000000;
					g[148] = 7.4000000000; fxg[148] = 3.9448000000; feg[148] = 0.0805000000;
					g[149] = 7.4500000000; fxg[149] = 3.9143000000; feg[149] = 0.0795000000;
					g[150] = 7.5000000000; fxg[150] = 3.8817000000; feg[150] = 0.0785000000;
					g[151] = 7.5500000000; fxg[151] = 3.8481000000; feg[151] = 0.0775000000;
					g[152] = 7.6000000000; fxg[152] = 3.8145000000; feg[152] = 0.0766000000;
					g[153] = 7.6500000000; fxg[153] = 3.7816000000; feg[153] = 0.0756000000;
					g[154] = 7.7000000000; fxg[154] = 3.7490000000; feg[154] = 0.0747000000;
					g[155] = 7.7500000000; fxg[155] = 3.7162000000; feg[155] = 0.0738000000;
					g[156] = 7.8000000000; fxg[156] = 3.6828000000; feg[156] = 0.0729000000;
					g[157] = 7.8500000000; fxg[157] = 3.6494000000; feg[157] = 0.0720000000;
					g[158] = 7.9000000000; fxg[158] = 3.6169000000; feg[158] = 0.0712000000;
					g[159] = 7.9500000000; fxg[159] = 3.5863000000; feg[159] = 0.0703000000;
					g[160] = 8.0000000000; fxg[160] = 3.5582000000; feg[160] = 0.0695000000;
					g[161] = 8.0500000000; fxg[161] = 3.5323000000; feg[161] = 0.0686000000;
					g[162] = 8.1000000000; fxg[162] = 3.5075000000; feg[162] = 0.0678000000;
					g[163] = 8.1500000000; fxg[163] = 3.4820000000; feg[163] = 0.0670000000;
					g[164] = 8.2000000000; fxg[164] = 3.4545000000; feg[164] = 0.0663000000;
					g[165] = 8.2500000000; fxg[165] = 3.4246000000; feg[165] = 0.0655000000;
					g[166] = 8.3000000000; fxg[166] = 3.3930000000; feg[166] = 0.0648000000;
					g[167] = 8.3500000000; fxg[167] = 3.3609000000; feg[167] = 0.0640000000;
					g[168] = 8.4000000000; fxg[168] = 3.3295000000; feg[168] = 0.0633000000;
					g[169] = 8.4500000000; fxg[169] = 3.2991000000; feg[169] = 0.0626000000;
					g[170] = 8.5000000000; fxg[170] = 3.2694000000; feg[170] = 0.0619000000;
					g[171] = 8.5500000000; fxg[171] = 3.2395000000; feg[171] = 0.0612000000;
					g[172] = 8.6000000000; fxg[172] = 3.2090000000; feg[172] = 0.0606000000;
					g[173] = 8.6500000000; fxg[173] = 3.1781000000; feg[173] = 0.0599000000;
					g[174] = 8.7000000000; fxg[174] = 3.1474000000; feg[174] = 0.0593000000;
					g[175] = 8.7500000000; fxg[175] = 3.1179000000; feg[175] = 0.0586000000;
					g[176] = 8.8000000000; fxg[176] = 3.0906000000; feg[176] = 0.0580000000;
					g[177] = 8.8500000000; fxg[177] = 3.0660000000; feg[177] = 0.0574000000;
					g[178] = 8.9000000000; fxg[178] = 3.0438000000; feg[178] = 0.0568000000;
					g[179] = 8.9500000000; fxg[179] = 3.0226000000; feg[179] = 0.0561000000;
					g[180] = 9.0000000000; fxg[180] = 3.0008000000; feg[180] = 0.0555000000;
					g[181] = 9.0500000000; fxg[181] = 2.9771000000; feg[181] = 0.0550000000;
					g[182] = 9.1000000000; fxg[182] = 2.9510000000; feg[182] = 0.0544000000;
					g[183] = 9.1500000000; fxg[183] = 2.9230000000; feg[183] = 0.0538000000;
					g[184] = 9.2000000000; fxg[184] = 2.8940000000; feg[184] = 0.0533000000;
					g[185] = 9.2500000000; fxg[185] = 2.8654000000; feg[185] = 0.0527000000;
					g[186] = 9.3000000000; fxg[186] = 2.8382000000; feg[186] = 0.0522000000;
					g[187] = 9.3500000000; fxg[187] = 2.8122000000; feg[187] = 0.0517000000;
					g[188] = 9.4000000000; fxg[188] = 2.7869000000; feg[188] = 0.0512000000;
					g[189] = 9.4500000000; fxg[189] = 2.7614000000; feg[189] = 0.0506000000;
					g[190] = 9.5000000000; fxg[190] = 2.7352000000; feg[190] = 0.0501000000;
					g[191] = 9.5500000000; fxg[191] = 2.7083000000; feg[191] = 0.0496000000;
					g[192] = 9.6000000000; fxg[192] = 2.6815000000; feg[192] = 0.0492000000;
					g[193] = 9.6500000000; fxg[193] = 2.6555000000; feg[193] = 0.0487000000;
					g[194] = 9.7000000000; fxg[194] = 2.6313000000; feg[194] = 0.0482000000;
					g[195] = 9.7500000000; fxg[195] = 2.6097000000; feg[195] = 0.0477000000;
					g[196] = 9.8000000000; fxg[196] = 2.5908000000; feg[196] = 0.0473000000;
					g[197] = 9.8500000000; fxg[197] = 2.5740000000; feg[197] = 0.0468000000;
					g[198] = 9.9000000000; fxg[198] = 2.5579000000; feg[198] = 0.0463000000;
					g[199] = 9.9500000000; fxg[199] = 2.5410000000; feg[199] = 0.0459000000;
					g[200] = 10.0000000000; fxg[200] = 2.5221000000; feg[200] = 0.0455000000;
					g[201] = 10.0500000000; fxg[201] = 2.5007000000; feg[201] = 0.0450000000;
					g[202] = 10.1000000000; fxg[202] = 2.4773000000; feg[202] = 0.0446000000;
					g[203] = 10.1500000000; fxg[203] = 2.4527000000; feg[203] = 0.0442000000;
					g[204] = 10.2000000000; fxg[204] = 2.4282000000; feg[204] = 0.0438000000;
					g[205] = 10.2500000000; fxg[205] = 2.4050000000; feg[205] = 0.0434000000;
					g[206] = 10.3000000000; fxg[206] = 2.3834000000; feg[206] = 0.0430000000;
					g[207] = 10.3500000000; fxg[207] = 2.3631000000; feg[207] = 0.0426000000;
					g[208] = 10.4000000000; fxg[208] = 2.3431000000; feg[208] = 0.0422000000;
					g[209] = 10.4500000000; fxg[209] = 2.3225000000; feg[209] = 0.0418000000;
					g[210] = 10.5000000000; fxg[210] = 2.3012000000; feg[210] = 0.0414000000;
					g[211] = 10.5500000000; fxg[211] = 2.2793000000; feg[211] = 0.0410000000;
					g[212] = 10.6000000000; fxg[212] = 2.2574000000; feg[212] = 0.0407000000;
					g[213] = 10.6500000000; fxg[213] = 2.2360000000; feg[213] = 0.0403000000;
					g[214] = 10.7000000000; fxg[214] = 2.2161000000; feg[214] = 0.0400000000;
					g[215] = 10.7500000000; fxg[215] = 2.1983000000; feg[215] = 0.0396000000;
					g[216] = 10.8000000000; fxg[216] = 2.1833000000; feg[216] = 0.0392000000;
					g[217] = 10.8500000000; fxg[217] = 2.1709000000; feg[217] = 0.0389000000;
					g[218] = 10.9000000000; fxg[218] = 2.1602000000; feg[218] = 0.0385000000;
					g[219] = 10.9500000000; fxg[219] = 2.1499000000; feg[219] = 0.0382000000;
					g[220] = 11.0000000000; fxg[220] = 2.1384000000; feg[220] = 0.0379000000;
					g[221] = 11.0500000000; fxg[221] = 2.1248000000; feg[221] = 0.0375000000;
					g[222] = 11.1000000000; fxg[222] = 2.1088000000; feg[222] = 0.0372000000;
					g[223] = 11.1500000000; fxg[223] = 2.0907000000; feg[223] = 0.0369000000;
					g[224] = 11.2000000000; fxg[224] = 2.0710000000; feg[224] = 0.0366000000;
					g[225] = 11.2500000000; fxg[225] = 2.0511000000; feg[225] = 0.0363000000;
					g[226] = 11.3000000000; fxg[226] = 2.0320000000; feg[226] = 0.0360000000;
					g[227] = 11.3500000000; fxg[227] = 2.0144000000; feg[227] = 0.0357000000;
					g[228] = 11.4000000000; fxg[228] = 1.9985000000; feg[228] = 0.0354000000;
					g[229] = 11.4500000000; fxg[229] = 1.9836000000; feg[229] = 0.0351000000;
					g[230] = 11.5000000000; fxg[230] = 1.9686000000; feg[230] = 0.0348000000;
					g[231] = 11.5500000000; fxg[231] = 1.9529000000; feg[231] = 0.0345000000;
					g[232] = 11.6000000000; fxg[232] = 1.9364000000; feg[232] = 0.0342000000;
					g[233] = 11.6500000000; fxg[233] = 1.9194000000; feg[233] = 0.0339000000;
					g[234] = 11.7000000000; fxg[234] = 1.9023000000; feg[234] = 0.0336000000;
					g[235] = 11.7500000000; fxg[235] = 1.8856000000; feg[235] = 0.0334000000;
					g[236] = 11.8000000000; fxg[236] = 1.8699000000; feg[236] = 0.0331000000;
					g[237] = 11.8500000000; fxg[237] = 1.8558000000; feg[237] = 0.0328000000;
					g[238] = 11.9000000000; fxg[238] = 1.8441000000; feg[238] = 0.0326000000;
					g[239] = 11.9500000000; fxg[239] = 1.8351000000; feg[239] = 0.0323000000;
					g[240] = 12.0000000000; fxg[240] = 1.8286000000; feg[240] = 0.0320000000;
					break;
				case 51:
					g[0] = 0.0000000000; fxg[0] = 51.0000000000; feg[0] = 11.1835000000;
					g[1] = 0.0500000000; fxg[1] = 50.7123000000; feg[1] = 11.0181000000;
					g[2] = 0.1000000000; fxg[2] = 49.8977000000; feg[2] = 10.5529000000;
					g[3] = 0.1500000000; fxg[3] = 48.6808000000; feg[3] = 9.8680000000;
					g[4] = 0.2000000000; fxg[4] = 47.2136000000; feg[4] = 9.0622000000;
					g[5] = 0.2500000000; fxg[5] = 45.6309000000; feg[5] = 8.2241000000;
					g[6] = 0.3000000000; fxg[6] = 44.0277000000; feg[6] = 7.4166000000;
					g[7] = 0.3500000000; fxg[7] = 42.4579000000; feg[7] = 6.6757000000;
					g[8] = 0.4000000000; fxg[8] = 40.9450000000; feg[8] = 6.0163000000;
					g[9] = 0.4500000000; fxg[9] = 39.4943000000; feg[9] = 5.4395000000;
					g[10] = 0.5000000000; fxg[10] = 38.1025000000; feg[10] = 4.9390000000;
					g[11] = 0.5500000000; fxg[11] = 36.7637000000; feg[11] = 4.5055000000;
					g[12] = 0.6000000000; fxg[12] = 35.4727000000; feg[12] = 4.1292000000;
					g[13] = 0.6500000000; fxg[13] = 34.2263000000; feg[13] = 3.8008000000;
					g[14] = 0.7000000000; fxg[14] = 33.0232000000; feg[14] = 3.5123000000;
					g[15] = 0.7500000000; fxg[15] = 31.8639000000; feg[15] = 3.2569000000;
					g[16] = 0.8000000000; fxg[16] = 30.7498000000; feg[16] = 3.0291000000;
					g[17] = 0.8500000000; fxg[17] = 29.6829000000; feg[17] = 2.8246000000;
					g[18] = 0.9000000000; fxg[18] = 28.6654000000; feg[18] = 2.6398000000;
					g[19] = 0.9500000000; fxg[19] = 27.6987000000; feg[19] = 2.4717000000;
					g[20] = 1.0000000000; fxg[20] = 26.7840000000; feg[20] = 2.3183000000;
					g[21] = 1.0500000000; fxg[21] = 25.9218000000; feg[21] = 2.1776000000;
					g[22] = 1.1000000000; fxg[22] = 25.1118000000; feg[22] = 2.0483000000;
					g[23] = 1.1500000000; fxg[23] = 24.3528000000; feg[23] = 1.9290000000;
					g[24] = 1.2000000000; fxg[24] = 23.6433000000; feg[24] = 1.8187000000;
					g[25] = 1.2500000000; fxg[25] = 22.9811000000; feg[25] = 1.7167000000;
					g[26] = 1.3000000000; fxg[26] = 22.3636000000; feg[26] = 1.6222000000;
					g[27] = 1.3500000000; fxg[27] = 21.7878000000; feg[27] = 1.5345000000;
					g[28] = 1.4000000000; fxg[28] = 21.2506000000; feg[28] = 1.4531000000;
					g[29] = 1.4500000000; fxg[29] = 20.7487000000; feg[29] = 1.3775000000;
					g[30] = 1.5000000000; fxg[30] = 20.2788000000; feg[30] = 1.3071000000;
					g[31] = 1.5500000000; fxg[31] = 19.8376000000; feg[31] = 1.2418000000;
					g[32] = 1.6000000000; fxg[32] = 19.4220000000; feg[32] = 1.1809000000;
					g[33] = 1.6500000000; fxg[33] = 19.0290000000; feg[33] = 1.1242000000;
					g[34] = 1.7000000000; fxg[34] = 18.6556000000; feg[34] = 1.0714000000;
					g[35] = 1.7500000000; fxg[35] = 18.2992000000; feg[35] = 1.0222000000;
					g[36] = 1.8000000000; fxg[36] = 17.9576000000; feg[36] = 0.9763000000;
					g[37] = 1.8500000000; fxg[37] = 17.6283000000; feg[37] = 0.9335000000;
					g[38] = 1.9000000000; fxg[38] = 17.3096000000; feg[38] = 0.8934000000;
					g[39] = 1.9500000000; fxg[39] = 16.9998000000; feg[39] = 0.8560000000;
					g[40] = 2.0000000000; fxg[40] = 16.6972000000; feg[40] = 0.8210000000;
					g[41] = 2.0500000000; fxg[41] = 16.4008000000; feg[41] = 0.7882000000;
					g[42] = 2.1000000000; fxg[42] = 16.1094000000; feg[42] = 0.7574000000;
					g[43] = 2.1500000000; fxg[43] = 15.8221000000; feg[43] = 0.7286000000;
					g[44] = 2.2000000000; fxg[44] = 15.5385000000; feg[44] = 0.7014000000;
					g[45] = 2.2500000000; fxg[45] = 15.2577000000; feg[45] = 0.6759000000;
					g[46] = 2.3000000000; fxg[46] = 14.9793000000; feg[46] = 0.6519000000;
					g[47] = 2.3500000000; fxg[47] = 14.7033000000; feg[47] = 0.6292000000;
					g[48] = 2.4000000000; fxg[48] = 14.4296000000; feg[48] = 0.6078000000;
					g[49] = 2.4500000000; fxg[49] = 14.1579000000; feg[49] = 0.5876000000;
					g[50] = 2.5000000000; fxg[50] = 13.8882000000; feg[50] = 0.5685000000;
					g[51] = 2.5500000000; fxg[51] = 13.6205000000; feg[51] = 0.5503000000;
					g[52] = 2.6000000000; fxg[52] = 13.3551000000; feg[52] = 0.5331000000;
					g[53] = 2.6500000000; fxg[53] = 13.0924000000; feg[53] = 0.5168000000;
					g[54] = 2.7000000000; fxg[54] = 12.8325000000; feg[54] = 0.5012000000;
					g[55] = 2.7500000000; fxg[55] = 12.5754000000; feg[55] = 0.4864000000;
					g[56] = 2.8000000000; fxg[56] = 12.3210000000; feg[56] = 0.4723000000;
					g[57] = 2.8500000000; fxg[57] = 12.0699000000; feg[57] = 0.4588000000;
					g[58] = 2.9000000000; fxg[58] = 11.8227000000; feg[58] = 0.4460000000;
					g[59] = 2.9500000000; fxg[59] = 11.5798000000; feg[59] = 0.4337000000;
					g[60] = 3.0000000000; fxg[60] = 11.3412000000; feg[60] = 0.4219000000;
					g[61] = 3.0500000000; fxg[61] = 11.1066000000; feg[61] = 0.4106000000;
					g[62] = 3.1000000000; fxg[62] = 10.8760000000; feg[62] = 0.3997000000;
					g[63] = 3.1500000000; fxg[63] = 10.6499000000; feg[63] = 0.3893000000;
					g[64] = 3.2000000000; fxg[64] = 10.4292000000; feg[64] = 0.3793000000;
					g[65] = 3.2500000000; fxg[65] = 10.2143000000; feg[65] = 0.3697000000;
					g[66] = 3.3000000000; fxg[66] = 10.0051000000; feg[66] = 0.3604000000;
					g[67] = 3.3500000000; fxg[67] = 9.8008000000; feg[67] = 0.3515000000;
					g[68] = 3.4000000000; fxg[68] = 9.6012000000; feg[68] = 0.3428000000;
					g[69] = 3.4500000000; fxg[69] = 9.4064000000; feg[69] = 0.3345000000;
					g[70] = 3.5000000000; fxg[70] = 9.2173000000; feg[70] = 0.3265000000;
					g[71] = 3.5500000000; fxg[71] = 9.0346000000; feg[71] = 0.3188000000;
					g[72] = 3.6000000000; fxg[72] = 8.8584000000; feg[72] = 0.3113000000;
					g[73] = 3.6500000000; fxg[73] = 8.6884000000; feg[73] = 0.3040000000;
					g[74] = 3.7000000000; fxg[74] = 8.5234000000; feg[74] = 0.2970000000;
					g[75] = 3.7500000000; fxg[75] = 8.3629000000; feg[75] = 0.2903000000;
					g[76] = 3.8000000000; fxg[76] = 8.2069000000; feg[76] = 0.2837000000;
					g[77] = 3.8500000000; fxg[77] = 8.0560000000; feg[77] = 0.2774000000;
					g[78] = 3.9000000000; fxg[78] = 7.9113000000; feg[78] = 0.2712000000;
					g[79] = 3.9500000000; fxg[79] = 7.7731000000; feg[79] = 0.2652000000;
					g[80] = 4.0000000000; fxg[80] = 7.6411000000; feg[80] = 0.2594000000;
					g[81] = 4.0500000000; fxg[81] = 7.5142000000; feg[81] = 0.2538000000;
					g[82] = 4.1000000000; fxg[82] = 7.3914000000; feg[82] = 0.2484000000;
					g[83] = 4.1500000000; fxg[83] = 7.2719000000; feg[83] = 0.2431000000;
					g[84] = 4.2000000000; fxg[84] = 7.1559000000; feg[84] = 0.2379000000;
					g[85] = 4.2500000000; fxg[85] = 7.0441000000; feg[85] = 0.2330000000;
					g[86] = 4.3000000000; fxg[86] = 6.9373000000; feg[86] = 0.2281000000;
					g[87] = 4.3500000000; fxg[87] = 6.8363000000; feg[87] = 0.2234000000;
					g[88] = 4.4000000000; fxg[88] = 6.7408000000; feg[88] = 0.2189000000;
					g[89] = 4.4500000000; fxg[89] = 6.6499000000; feg[89] = 0.2144000000;
					g[90] = 4.5000000000; fxg[90] = 6.5623000000; feg[90] = 0.2101000000;
					g[91] = 4.5500000000; fxg[91] = 6.4768000000; feg[91] = 0.2059000000;
					g[92] = 4.6000000000; fxg[92] = 6.3931000000; feg[92] = 0.2018000000;
					g[93] = 4.6500000000; fxg[93] = 6.3115000000; feg[93] = 0.1979000000;
					g[94] = 4.7000000000; fxg[94] = 6.2329000000; feg[94] = 0.1940000000;
					g[95] = 4.7500000000; fxg[95] = 6.1580000000; feg[95] = 0.1903000000;
					g[96] = 4.8000000000; fxg[96] = 6.0876000000; feg[96] = 0.1866000000;
					g[97] = 4.8500000000; fxg[97] = 6.0218000000; feg[97] = 0.1831000000;
					g[98] = 4.9000000000; fxg[98] = 5.9597000000; feg[98] = 0.1796000000;
					g[99] = 4.9500000000; fxg[99] = 5.9000000000; feg[99] = 0.1762000000;
					g[100] = 5.0000000000; fxg[100] = 5.8412000000; feg[100] = 0.1729000000;
					g[101] = 5.0500000000; fxg[101] = 5.7828000000; feg[101] = 0.1697000000;
					g[102] = 5.1000000000; fxg[102] = 5.7247000000; feg[102] = 0.1666000000;
					g[103] = 5.1500000000; fxg[103] = 5.6678000000; feg[103] = 0.1636000000;
					g[104] = 5.2000000000; fxg[104] = 5.6125000000; feg[104] = 0.1607000000;
					g[105] = 5.2500000000; fxg[105] = 5.5598000000; feg[105] = 0.1578000000;
					g[106] = 5.3000000000; fxg[106] = 5.5102000000; feg[106] = 0.1550000000;
					g[107] = 5.3500000000; fxg[107] = 5.4643000000; feg[107] = 0.1523000000;
					g[108] = 5.4000000000; fxg[108] = 5.4213000000; feg[108] = 0.1496000000;
					g[109] = 5.4500000000; fxg[109] = 5.3801000000; feg[109] = 0.1470000000;
					g[110] = 5.5000000000; fxg[110] = 5.3390000000; feg[110] = 0.1445000000;
					g[111] = 5.5500000000; fxg[111] = 5.2971000000; feg[111] = 0.1420000000;
					g[112] = 5.6000000000; fxg[112] = 5.2543000000; feg[112] = 0.1397000000;
					g[113] = 5.6500000000; fxg[113] = 5.2112000000; feg[113] = 0.1373000000;
					g[114] = 5.7000000000; fxg[114] = 5.1684000000; feg[114] = 0.1350000000;
					g[115] = 5.7500000000; fxg[115] = 5.1264000000; feg[115] = 0.1328000000;
					g[116] = 5.8000000000; fxg[116] = 5.0858000000; feg[116] = 0.1307000000;
					g[117] = 5.8500000000; fxg[117] = 5.0474000000; feg[117] = 0.1285000000;
					g[118] = 5.9000000000; fxg[118] = 5.0118000000; feg[118] = 0.1265000000;
					g[119] = 5.9500000000; fxg[119] = 4.9788000000; feg[119] = 0.1244000000;
					g[120] = 6.0000000000; fxg[120] = 4.9474000000; feg[120] = 0.1225000000;
					g[121] = 6.0500000000; fxg[121] = 4.9160000000; feg[121] = 0.1205000000;
					g[122] = 6.1000000000; fxg[122] = 4.8832000000; feg[122] = 0.1187000000;
					g[123] = 6.1500000000; fxg[123] = 4.8486000000; feg[123] = 0.1168000000;
					g[124] = 6.2000000000; fxg[124] = 4.8128000000; feg[124] = 0.1150000000;
					g[125] = 6.2500000000; fxg[125] = 4.7764000000; feg[125] = 0.1133000000;
					g[126] = 6.3000000000; fxg[126] = 4.7399000000; feg[126] = 0.1116000000;
					g[127] = 6.3500000000; fxg[127] = 4.7037000000; feg[127] = 0.1099000000;
					g[128] = 6.4000000000; fxg[128] = 4.6679000000; feg[128] = 0.1083000000;
					g[129] = 6.4500000000; fxg[129] = 4.6335000000; feg[129] = 0.1067000000;
					g[130] = 6.5000000000; fxg[130] = 4.6012000000; feg[130] = 0.1051000000;
					g[131] = 6.5500000000; fxg[131] = 4.5715000000; feg[131] = 0.1036000000;
					g[132] = 6.6000000000; fxg[132] = 4.5438000000; feg[132] = 0.1021000000;
					g[133] = 6.6500000000; fxg[133] = 4.5165000000; feg[133] = 0.1006000000;
					g[134] = 6.7000000000; fxg[134] = 4.4882000000; feg[134] = 0.0992000000;
					g[135] = 6.7500000000; fxg[135] = 4.4579000000; feg[135] = 0.0978000000;
					g[136] = 6.8000000000; fxg[136] = 4.4255000000; feg[136] = 0.0964000000;
					g[137] = 6.8500000000; fxg[137] = 4.3918000000; feg[137] = 0.0951000000;
					g[138] = 6.9000000000; fxg[138] = 4.3577000000; feg[138] = 0.0938000000;
					g[139] = 6.9500000000; fxg[139] = 4.3236000000; feg[139] = 0.0925000000;
					g[140] = 7.0000000000; fxg[140] = 4.2893000000; feg[140] = 0.0913000000;
					g[141] = 7.0500000000; fxg[141] = 4.2550000000; feg[141] = 0.0900000000;
					g[142] = 7.1000000000; fxg[142] = 4.2211000000; feg[142] = 0.0888000000;
					g[143] = 7.1500000000; fxg[143] = 4.1885000000; feg[143] = 0.0877000000;
					g[144] = 7.2000000000; fxg[144] = 4.1581000000; feg[144] = 0.0865000000;
					g[145] = 7.2500000000; fxg[145] = 4.1302000000; feg[145] = 0.0854000000;
					g[146] = 7.3000000000; fxg[146] = 4.1041000000; feg[146] = 0.0842000000;
					g[147] = 7.3500000000; fxg[147] = 4.0784000000; feg[147] = 0.0832000000;
					g[148] = 7.4000000000; fxg[148] = 4.0513000000; feg[148] = 0.0821000000;
					g[149] = 7.4500000000; fxg[149] = 4.0220000000; feg[149] = 0.0810000000;
					g[150] = 7.5000000000; fxg[150] = 3.9904000000; feg[150] = 0.0800000000;
					g[151] = 7.5500000000; fxg[151] = 3.9575000000; feg[151] = 0.0790000000;
					g[152] = 7.6000000000; fxg[152] = 3.9243000000; feg[152] = 0.0780000000;
					g[153] = 7.6500000000; fxg[153] = 3.8914000000; feg[153] = 0.0771000000;
					g[154] = 7.7000000000; fxg[154] = 3.8587000000; feg[154] = 0.0761000000;
					g[155] = 7.7500000000; fxg[155] = 3.8258000000; feg[155] = 0.0752000000;
					g[156] = 7.8000000000; fxg[156] = 3.7925000000; feg[156] = 0.0743000000;
					g[157] = 7.8500000000; fxg[157] = 3.7593000000; feg[157] = 0.0734000000;
					g[158] = 7.9000000000; fxg[158] = 3.7272000000; feg[158] = 0.0725000000;
					g[159] = 7.9500000000; fxg[159] = 3.6973000000; feg[159] = 0.0717000000;
					g[160] = 8.0000000000; fxg[160] = 3.6699000000; feg[160] = 0.0708000000;
					g[161] = 8.0500000000; fxg[161] = 3.6449000000; feg[161] = 0.0700000000;
					g[162] = 8.1000000000; fxg[162] = 3.6209000000; feg[162] = 0.0691000000;
					g[163] = 8.1500000000; fxg[163] = 3.5962000000; feg[163] = 0.0683000000;
					g[164] = 8.2000000000; fxg[164] = 3.5694000000; feg[164] = 0.0675000000;
					g[165] = 8.2500000000; fxg[165] = 3.5401000000; feg[165] = 0.0668000000;
					g[166] = 8.3000000000; fxg[166] = 3.5089000000; feg[166] = 0.0660000000;
					g[167] = 8.3500000000; fxg[167] = 3.4770000000; feg[167] = 0.0653000000;
					g[168] = 8.4000000000; fxg[168] = 3.4455000000; feg[168] = 0.0645000000;
					g[169] = 8.4500000000; fxg[169] = 3.4148000000; feg[169] = 0.0638000000;
					g[170] = 8.5000000000; fxg[170] = 3.3847000000; feg[170] = 0.0631000000;
					g[171] = 8.5500000000; fxg[171] = 3.3544000000; feg[171] = 0.0624000000;
					g[172] = 8.6000000000; fxg[172] = 3.3235000000; feg[172] = 0.0617000000;
					g[173] = 8.6500000000; fxg[173] = 3.2922000000; feg[173] = 0.0610000000;
					g[174] = 8.7000000000; fxg[174] = 3.2612000000; feg[174] = 0.0604000000;
					g[175] = 8.7500000000; fxg[175] = 3.2317000000; feg[175] = 0.0597000000;
					g[176] = 8.8000000000; fxg[176] = 3.2044000000; feg[176] = 0.0591000000;
					g[177] = 8.8500000000; fxg[177] = 3.1801000000; feg[177] = 0.0585000000;
					g[178] = 8.9000000000; fxg[178] = 3.1581000000; feg[178] = 0.0578000000;
					g[179] = 8.9500000000; fxg[179] = 3.1371000000; feg[179] = 0.0572000000;
					g[180] = 9.0000000000; fxg[180] = 3.1155000000; feg[180] = 0.0566000000;
					g[181] = 9.0500000000; fxg[181] = 3.0919000000; feg[181] = 0.0560000000;
					g[182] = 9.1000000000; fxg[182] = 3.0658000000; feg[182] = 0.0554000000;
					g[183] = 9.1500000000; fxg[183] = 3.0375000000; feg[183] = 0.0548000000;
					g[184] = 9.2000000000; fxg[184] = 3.0082000000; feg[184] = 0.0543000000;
					g[185] = 9.2500000000; fxg[185] = 2.9792000000; feg[185] = 0.0537000000;
					g[186] = 9.3000000000; fxg[186] = 2.9514000000; feg[186] = 0.0532000000;
					g[187] = 9.3500000000; fxg[187] = 2.9249000000; feg[187] = 0.0526000000;
					g[188] = 9.4000000000; fxg[188] = 2.8990000000; feg[188] = 0.0521000000;
					g[189] = 9.4500000000; fxg[189] = 2.8728000000; feg[189] = 0.0516000000;
					g[190] = 9.5000000000; fxg[190] = 2.8459000000; feg[190] = 0.0511000000;
					g[191] = 9.5500000000; fxg[191] = 2.8183000000; feg[191] = 0.0506000000;
					g[192] = 9.6000000000; fxg[192] = 2.7907000000; feg[192] = 0.0501000000;
					g[193] = 9.6500000000; fxg[193] = 2.7639000000; feg[193] = 0.0496000000;
					g[194] = 9.7000000000; fxg[194] = 2.7391000000; feg[194] = 0.0491000000;
					g[195] = 9.7500000000; fxg[195] = 2.7170000000; feg[195] = 0.0486000000;
					g[196] = 9.8000000000; fxg[196] = 2.6978000000; feg[196] = 0.0481000000;
					g[197] = 9.8500000000; fxg[197] = 2.6808000000; feg[197] = 0.0477000000;
					g[198] = 9.9000000000; fxg[198] = 2.6644000000; feg[198] = 0.0472000000;
					g[199] = 9.9500000000; fxg[199] = 2.6472000000; feg[199] = 0.0468000000;
					g[200] = 10.0000000000; fxg[200] = 2.6279000000; feg[200] = 0.0463000000;
					g[201] = 10.0500000000; fxg[201] = 2.6059000000; feg[201] = 0.0459000000;
					g[202] = 10.1000000000; fxg[202] = 2.5816000000; feg[202] = 0.0454000000;
					g[203] = 10.1500000000; fxg[203] = 2.5562000000; feg[203] = 0.0450000000;
					g[204] = 10.2000000000; fxg[204] = 2.5309000000; feg[204] = 0.0446000000;
					g[205] = 10.2500000000; fxg[205] = 2.5069000000; feg[205] = 0.0442000000;
					g[206] = 10.3000000000; fxg[206] = 2.4846000000; feg[206] = 0.0438000000;
					g[207] = 10.3500000000; fxg[207] = 2.4637000000; feg[207] = 0.0434000000;
					g[208] = 10.4000000000; fxg[208] = 2.4431000000; feg[208] = 0.0430000000;
					g[209] = 10.4500000000; fxg[209] = 2.4220000000; feg[209] = 0.0426000000;
					g[210] = 10.5000000000; fxg[210] = 2.4000000000; feg[210] = 0.0422000000;
					g[211] = 10.5500000000; fxg[211] = 2.3771000000; feg[211] = 0.0418000000;
					g[212] = 10.6000000000; fxg[212] = 2.3541000000; feg[212] = 0.0414000000;
					g[213] = 10.6500000000; fxg[213] = 2.3315000000; feg[213] = 0.0411000000;
					g[214] = 10.7000000000; fxg[214] = 2.3105000000; feg[214] = 0.0407000000;
					g[215] = 10.7500000000; fxg[215] = 2.2918000000; feg[215] = 0.0404000000;
					g[216] = 10.8000000000; fxg[216] = 2.2761000000; feg[216] = 0.0400000000;
					g[217] = 10.8500000000; fxg[217] = 2.2631000000; feg[217] = 0.0396000000;
					g[218] = 10.9000000000; fxg[218] = 2.2519000000; feg[218] = 0.0393000000;
					g[219] = 10.9500000000; fxg[219] = 2.2411000000; feg[219] = 0.0389000000;
					g[220] = 11.0000000000; fxg[220] = 2.2290000000; feg[220] = 0.0386000000;
					g[221] = 11.0500000000; fxg[221] = 2.2146000000; feg[221] = 0.0383000000;
					g[222] = 11.1000000000; fxg[222] = 2.1976000000; feg[222] = 0.0379000000;
					g[223] = 11.1500000000; fxg[223] = 2.1783000000; feg[223] = 0.0376000000;
					g[224] = 11.2000000000; fxg[224] = 2.1575000000; feg[224] = 0.0373000000;
					g[225] = 11.2500000000; fxg[225] = 2.1364000000; feg[225] = 0.0370000000;
					g[226] = 11.3000000000; fxg[226] = 2.1164000000; feg[226] = 0.0367000000;
					g[227] = 11.3500000000; fxg[227] = 2.0982000000; feg[227] = 0.0363000000;
					g[228] = 11.4000000000; fxg[228] = 2.0818000000; feg[228] = 0.0360000000;
					g[229] = 11.4500000000; fxg[229] = 2.0665000000; feg[229] = 0.0357000000;
					g[230] = 11.5000000000; fxg[230] = 2.0512000000; feg[230] = 0.0354000000;
					g[231] = 11.5500000000; fxg[231] = 2.0352000000; feg[231] = 0.0351000000;
					g[232] = 11.6000000000; fxg[232] = 2.0182000000; feg[232] = 0.0348000000;
					g[233] = 11.6500000000; fxg[233] = 2.0003000000; feg[233] = 0.0346000000;
					g[234] = 11.7000000000; fxg[234] = 1.9821000000; feg[234] = 0.0343000000;
					g[235] = 11.7500000000; fxg[235] = 1.9641000000; feg[235] = 0.0340000000;
					g[236] = 11.8000000000; fxg[236] = 1.9471000000; feg[236] = 0.0337000000;
					g[237] = 11.8500000000; fxg[237] = 1.9319000000; feg[237] = 0.0335000000;
					g[238] = 11.9000000000; fxg[238] = 1.9192000000; feg[238] = 0.0332000000;
					g[239] = 11.9500000000; fxg[239] = 1.9094000000; feg[239] = 0.0329000000;
					g[240] = 12.0000000000; fxg[240] = 1.9022000000; feg[240] = 0.0326000000;
					break;
				case 52:
					g[0] = 0.0000000000; fxg[0] = 52.0000000000; feg[0] = 11.1540000000;
					g[1] = 0.0500000000; fxg[1] = 51.7125000000; feg[1] = 11.0079000000;
					g[2] = 0.1000000000; fxg[2] = 50.8935000000; feg[2] = 10.5930000000;
					g[3] = 0.1500000000; fxg[3] = 49.6566000000; feg[3] = 9.9709000000;
					g[4] = 0.2000000000; fxg[4] = 48.1471000000; feg[4] = 9.2213000000;
					g[5] = 0.2500000000; fxg[5] = 46.5025000000; feg[5] = 8.4209000000;
					g[6] = 0.3000000000; fxg[6] = 44.8277000000; feg[6] = 7.6293000000;
					g[7] = 0.3500000000; fxg[7] = 43.1890000000; feg[7] = 6.8859000000;
					g[8] = 0.4000000000; fxg[8] = 41.6197000000; feg[8] = 6.2109000000;
					g[9] = 0.4500000000; fxg[9] = 40.1303000000; feg[9] = 5.6115000000;
					g[10] = 0.5000000000; fxg[10] = 38.7183000000; feg[10] = 5.0861000000;
					g[11] = 0.5500000000; fxg[11] = 37.3756000000; feg[11] = 4.6283000000;
					g[12] = 0.6000000000; fxg[12] = 36.0928000000; feg[12] = 4.2302000000;
					g[13] = 0.6500000000; fxg[13] = 34.8621000000; feg[13] = 3.8833000000;
					g[14] = 0.7000000000; fxg[14] = 33.6779000000; feg[14] = 3.5797000000;
					g[15] = 0.7500000000; fxg[15] = 32.5368000000; feg[15] = 3.3125000000;
					g[16] = 0.8000000000; fxg[16] = 31.4375000000; feg[16] = 3.0759000000;
					g[17] = 0.8500000000; fxg[17] = 30.3800000000; feg[17] = 2.8648000000;
					g[18] = 0.9000000000; fxg[18] = 29.3653000000; feg[18] = 2.6752000000;
					g[19] = 0.9500000000; fxg[19] = 28.3948000000; feg[19] = 2.5040000000;
					g[20] = 1.0000000000; fxg[20] = 27.4697000000; feg[20] = 2.3484000000;
					g[21] = 1.0500000000; fxg[21] = 26.5911000000; feg[21] = 2.2064000000;
					g[22] = 1.1000000000; fxg[22] = 25.7596000000; feg[22] = 2.0761000000;
					g[23] = 1.1500000000; fxg[23] = 24.9751000000; feg[23] = 1.9563000000;
					g[24] = 1.2000000000; fxg[24] = 24.2373000000; feg[24] = 1.8457000000;
					g[25] = 1.2500000000; fxg[25] = 23.5449000000; feg[25] = 1.7434000000;
					g[26] = 1.3000000000; fxg[26] = 22.8964000000; feg[26] = 1.6487000000;
					g[27] = 1.3500000000; fxg[27] = 22.2898000000; feg[27] = 1.5607000000;
					g[28] = 1.4000000000; fxg[28] = 21.7226000000; feg[28] = 1.4789000000;
					g[29] = 1.4500000000; fxg[29] = 21.1922000000; feg[29] = 1.4028000000;
					g[30] = 1.5000000000; fxg[30] = 20.6959000000; feg[30] = 1.3319000000;
					g[31] = 1.5500000000; fxg[31] = 20.2308000000; feg[31] = 1.2659000000;
					g[32] = 1.6000000000; fxg[32] = 19.7939000000; feg[32] = 1.2044000000;
					g[33] = 1.6500000000; fxg[33] = 19.3824000000; feg[33] = 1.1470000000;
					g[34] = 1.7000000000; fxg[34] = 18.9935000000; feg[34] = 1.0934000000;
					g[35] = 1.7500000000; fxg[35] = 18.6245000000; feg[35] = 1.0433000000;
					g[36] = 1.8000000000; fxg[36] = 18.2730000000; feg[36] = 0.9966000000;
					g[37] = 1.8500000000; fxg[37] = 17.9365000000; feg[37] = 0.9528000000;
					g[38] = 1.9000000000; fxg[38] = 17.6131000000; feg[38] = 0.9119000000;
					g[39] = 1.9500000000; fxg[39] = 17.3009000000; feg[39] = 0.8736000000;
					g[40] = 2.0000000000; fxg[40] = 16.9980000000; feg[40] = 0.8377000000;
					g[41] = 2.0500000000; fxg[41] = 16.7029000000; feg[41] = 0.8041000000;
					g[42] = 2.1000000000; fxg[42] = 16.4145000000; feg[42] = 0.7725000000;
					g[43] = 2.1500000000; fxg[43] = 16.1315000000; feg[43] = 0.7429000000;
					g[44] = 2.2000000000; fxg[44] = 15.8532000000; feg[44] = 0.7150000000;
					g[45] = 2.2500000000; fxg[45] = 15.5785000000; feg[45] = 0.6888000000;
					g[46] = 2.3000000000; fxg[46] = 15.3069000000; feg[46] = 0.6640000000;
					g[47] = 2.3500000000; fxg[47] = 15.0381000000; feg[47] = 0.6407000000;
					g[48] = 2.4000000000; fxg[48] = 14.7716000000; feg[48] = 0.6188000000;
					g[49] = 2.4500000000; fxg[49] = 14.5072000000; feg[49] = 0.5980000000;
					g[50] = 2.5000000000; fxg[50] = 14.2447000000; feg[50] = 0.5783000000;
					g[51] = 2.5500000000; fxg[51] = 13.9840000000; feg[51] = 0.5597000000;
					g[52] = 2.6000000000; fxg[52] = 13.7252000000; feg[52] = 0.5420000000;
					g[53] = 2.6500000000; fxg[53] = 13.4685000000; feg[53] = 0.5253000000;
					g[54] = 2.7000000000; fxg[54] = 13.2139000000; feg[54] = 0.5094000000;
					g[55] = 2.7500000000; fxg[55] = 12.9615000000; feg[55] = 0.4942000000;
					g[56] = 2.8000000000; fxg[56] = 12.7112000000; feg[56] = 0.4798000000;
					g[57] = 2.8500000000; fxg[57] = 12.4636000000; feg[57] = 0.4660000000;
					g[58] = 2.9000000000; fxg[58] = 12.2190000000; feg[58] = 0.4528000000;
					g[59] = 2.9500000000; fxg[59] = 11.9777000000; feg[59] = 0.4403000000;
					g[60] = 3.0000000000; fxg[60] = 11.7399000000; feg[60] = 0.4283000000;
					g[61] = 3.0500000000; fxg[61] = 11.5053000000; feg[61] = 0.4167000000;
					g[62] = 3.1000000000; fxg[62] = 11.2741000000; feg[62] = 0.4057000000;
					g[63] = 3.1500000000; fxg[63] = 11.0468000000; feg[63] = 0.3951000000;
					g[64] = 3.2000000000; fxg[64] = 10.8240000000; feg[64] = 0.3850000000;
					g[65] = 3.2500000000; fxg[65] = 10.6062000000; feg[65] = 0.3752000000;
					g[66] = 3.3000000000; fxg[66] = 10.3931000000; feg[66] = 0.3658000000;
					g[67] = 3.3500000000; fxg[67] = 10.1845000000; feg[67] = 0.3567000000;
					g[68] = 3.4000000000; fxg[68] = 9.9801000000; feg[68] = 0.3480000000;
					g[69] = 3.4500000000; fxg[69] = 9.7801000000; feg[69] = 0.3396000000;
					g[70] = 3.5000000000; fxg[70] = 9.5854000000; feg[70] = 0.3315000000;
					g[71] = 3.5500000000; fxg[71] = 9.3964000000; feg[71] = 0.3236000000;
					g[72] = 3.6000000000; fxg[72] = 9.2134000000; feg[72] = 0.3161000000;
					g[73] = 3.6500000000; fxg[73] = 9.0359000000; feg[73] = 0.3087000000;
					g[74] = 3.7000000000; fxg[74] = 8.8633000000; feg[74] = 0.3017000000;
					g[75] = 3.7500000000; fxg[75] = 8.6950000000; feg[75] = 0.2948000000;
					g[76] = 3.8000000000; fxg[76] = 8.5312000000; feg[76] = 0.2882000000;
					g[77] = 3.8500000000; fxg[77] = 8.3725000000; feg[77] = 0.2818000000;
					g[78] = 3.9000000000; fxg[78] = 8.2196000000; feg[78] = 0.2756000000;
					g[79] = 3.9500000000; fxg[79] = 8.0730000000; feg[79] = 0.2695000000;
					g[80] = 4.0000000000; fxg[80] = 7.9323000000; feg[80] = 0.2637000000;
					g[81] = 4.0500000000; fxg[81] = 7.7967000000; feg[81] = 0.2580000000;
					g[82] = 4.1000000000; fxg[82] = 7.6652000000; feg[82] = 0.2525000000;
					g[83] = 4.1500000000; fxg[83] = 7.5373000000; feg[83] = 0.2472000000;
					g[84] = 4.2000000000; fxg[84] = 7.4130000000; feg[84] = 0.2420000000;
					g[85] = 4.2500000000; fxg[85] = 7.2930000000; feg[85] = 0.2370000000;
					g[86] = 4.3000000000; fxg[86] = 7.1782000000; feg[86] = 0.2321000000;
					g[87] = 4.3500000000; fxg[87] = 7.0691000000; feg[87] = 0.2273000000;
					g[88] = 4.4000000000; fxg[88] = 6.9656000000; feg[88] = 0.2227000000;
					g[89] = 4.4500000000; fxg[89] = 6.8667000000; feg[89] = 0.2182000000;
					g[90] = 4.5000000000; fxg[90] = 6.7713000000; feg[90] = 0.2138000000;
					g[91] = 4.5500000000; fxg[91] = 6.6784000000; feg[91] = 0.2096000000;
					g[92] = 4.6000000000; fxg[92] = 6.5876000000; feg[92] = 0.2055000000;
					g[93] = 4.6500000000; fxg[93] = 6.4991000000; feg[93] = 0.2015000000;
					g[94] = 4.7000000000; fxg[94] = 6.4139000000; feg[94] = 0.1976000000;
					g[95] = 4.7500000000; fxg[95] = 6.3328000000; feg[95] = 0.1938000000;
					g[96] = 4.8000000000; fxg[96] = 6.2563000000; feg[96] = 0.1901000000;
					g[97] = 4.8500000000; fxg[97] = 6.1845000000; feg[97] = 0.1865000000;
					g[98] = 4.9000000000; fxg[98] = 6.1166000000; feg[98] = 0.1829000000;
					g[99] = 4.9500000000; fxg[99] = 6.0514000000; feg[99] = 0.1795000000;
					g[100] = 5.0000000000; fxg[100] = 5.9874000000; feg[100] = 0.1762000000;
					g[101] = 5.0500000000; fxg[101] = 5.9241000000; feg[101] = 0.1730000000;
					g[102] = 5.1000000000; fxg[102] = 5.8614000000; feg[102] = 0.1698000000;
					g[103] = 5.1500000000; fxg[103] = 5.7999000000; feg[103] = 0.1668000000;
					g[104] = 5.2000000000; fxg[104] = 5.7405000000; feg[104] = 0.1638000000;
					g[105] = 5.2500000000; fxg[105] = 5.6839000000; feg[105] = 0.1609000000;
					g[106] = 5.3000000000; fxg[106] = 5.6309000000; feg[106] = 0.1580000000;
					g[107] = 5.3500000000; fxg[107] = 5.5817000000; feg[107] = 0.1553000000;
					g[108] = 5.4000000000; fxg[108] = 5.5356000000; feg[108] = 0.1525000000;
					g[109] = 5.4500000000; fxg[109] = 5.4914000000; feg[109] = 0.1499000000;
					g[110] = 5.5000000000; fxg[110] = 5.4477000000; feg[110] = 0.1473000000;
					g[111] = 5.5500000000; fxg[111] = 5.4034000000; feg[111] = 0.1448000000;
					g[112] = 5.6000000000; fxg[112] = 5.3584000000; feg[112] = 0.1424000000;
					g[113] = 5.6500000000; fxg[113] = 5.3130000000; feg[113] = 0.1400000000;
					g[114] = 5.7000000000; fxg[114] = 5.2680000000; feg[114] = 0.1377000000;
					g[115] = 5.7500000000; fxg[115] = 5.2240000000; feg[115] = 0.1354000000;
					g[116] = 5.8000000000; fxg[116] = 5.1819000000; feg[116] = 0.1332000000;
					g[117] = 5.8500000000; fxg[117] = 5.1423000000; feg[117] = 0.1311000000;
					g[118] = 5.9000000000; fxg[118] = 5.1058000000; feg[118] = 0.1290000000;
					g[119] = 5.9500000000; fxg[119] = 5.0720000000; feg[119] = 0.1269000000;
					g[120] = 6.0000000000; fxg[120] = 5.0398000000; feg[120] = 0.1249000000;
					g[121] = 6.0500000000; fxg[121] = 5.0078000000; feg[121] = 0.1229000000;
					g[122] = 6.1000000000; fxg[122] = 4.9746000000; feg[122] = 0.1210000000;
					g[123] = 6.1500000000; fxg[123] = 4.9398000000; feg[123] = 0.1191000000;
					g[124] = 6.2000000000; fxg[124] = 4.9036000000; feg[124] = 0.1173000000;
					g[125] = 6.2500000000; fxg[125] = 4.8666000000; feg[125] = 0.1155000000;
					g[126] = 6.3000000000; fxg[126] = 4.8294000000; feg[126] = 0.1138000000;
					g[127] = 6.3500000000; fxg[127] = 4.7926000000; feg[127] = 0.1121000000;
					g[128] = 6.4000000000; fxg[128] = 4.7567000000; feg[128] = 0.1104000000;
					g[129] = 6.4500000000; fxg[129] = 4.7226000000; feg[129] = 0.1088000000;
					g[130] = 6.5000000000; fxg[130] = 4.6908000000; feg[130] = 0.1072000000;
					g[131] = 6.5500000000; fxg[131] = 4.6617000000; feg[131] = 0.1056000000;
					g[132] = 6.6000000000; fxg[132] = 4.6345000000; feg[132] = 0.1041000000;
					g[133] = 6.6500000000; fxg[133] = 4.6080000000; feg[133] = 0.1026000000;
					g[134] = 6.7000000000; fxg[134] = 4.5804000000; feg[134] = 0.1011000000;
					g[135] = 6.7500000000; fxg[135] = 4.5509000000; feg[135] = 0.0997000000;
					g[136] = 6.8000000000; fxg[136] = 4.5194000000; feg[136] = 0.0983000000;
					g[137] = 6.8500000000; fxg[137] = 4.4862000000; feg[137] = 0.0969000000;
					g[138] = 6.9000000000; fxg[138] = 4.4523000000; feg[138] = 0.0956000000;
					g[139] = 6.9500000000; fxg[139] = 4.4181000000; feg[139] = 0.0943000000;
					g[140] = 7.0000000000; fxg[140] = 4.3838000000; feg[140] = 0.0930000000;
					g[141] = 7.0500000000; fxg[141] = 4.3497000000; feg[141] = 0.0918000000;
					g[142] = 7.1000000000; fxg[142] = 4.3164000000; feg[142] = 0.0906000000;
					g[143] = 7.1500000000; fxg[143] = 4.2847000000; feg[143] = 0.0894000000;
					g[144] = 7.2000000000; fxg[144] = 4.2554000000; feg[144] = 0.0882000000;
					g[145] = 7.2500000000; fxg[145] = 4.2286000000; feg[145] = 0.0870000000;
					g[146] = 7.3000000000; fxg[146] = 4.2036000000; feg[146] = 0.0859000000;
					g[147] = 7.3500000000; fxg[147] = 4.1789000000; feg[147] = 0.0847000000;
					g[148] = 7.4000000000; fxg[148] = 4.1530000000; feg[148] = 0.0836000000;
					g[149] = 7.4500000000; fxg[149] = 4.1248000000; feg[149] = 0.0826000000;
					g[150] = 7.5000000000; fxg[150] = 4.0943000000; feg[150] = 0.0815000000;
					g[151] = 7.5500000000; fxg[151] = 4.0623000000; feg[151] = 0.0805000000;
					g[152] = 7.6000000000; fxg[152] = 4.0295000000; feg[152] = 0.0795000000;
					g[153] = 7.6500000000; fxg[153] = 3.9966000000; feg[153] = 0.0785000000;
					g[154] = 7.7000000000; fxg[154] = 3.9637000000; feg[154] = 0.0776000000;
					g[155] = 7.7500000000; fxg[155] = 3.9306000000; feg[155] = 0.0766000000;
					g[156] = 7.8000000000; fxg[156] = 3.8974000000; feg[156] = 0.0757000000;
					g[157] = 7.8500000000; fxg[157] = 3.8647000000; feg[157] = 0.0748000000;
					g[158] = 7.9000000000; fxg[158] = 3.8333000000; feg[158] = 0.0739000000;
					g[159] = 7.9500000000; fxg[159] = 3.8043000000; feg[159] = 0.0730000000;
					g[160] = 8.0000000000; fxg[160] = 3.7779000000; feg[160] = 0.0721000000;
					g[161] = 8.0500000000; fxg[161] = 3.7538000000; feg[161] = 0.0713000000;
					g[162] = 8.1000000000; fxg[162] = 3.7306000000; feg[162] = 0.0704000000;
					g[163] = 8.1500000000; fxg[163] = 3.7067000000; feg[163] = 0.0696000000;
					g[164] = 8.2000000000; fxg[164] = 3.6808000000; feg[164] = 0.0688000000;
					g[165] = 8.2500000000; fxg[165] = 3.6524000000; feg[165] = 0.0680000000;
					g[166] = 8.3000000000; fxg[166] = 3.6219000000; feg[166] = 0.0672000000;
					g[167] = 8.3500000000; fxg[167] = 3.5904000000; feg[167] = 0.0665000000;
					g[168] = 8.4000000000; fxg[168] = 3.5589000000; feg[168] = 0.0657000000;
					g[169] = 8.4500000000; fxg[169] = 3.5279000000; feg[169] = 0.0650000000;
					g[170] = 8.5000000000; fxg[170] = 3.4971000000; feg[170] = 0.0643000000;
					g[171] = 8.5500000000; fxg[171] = 3.4663000000; feg[171] = 0.0636000000;
					g[172] = 8.6000000000; fxg[172] = 3.4350000000; feg[172] = 0.0629000000;
					g[173] = 8.6500000000; fxg[173] = 3.4034000000; feg[173] = 0.0622000000;
					g[174] = 8.7000000000; fxg[174] = 3.3725000000; feg[174] = 0.0615000000;
					g[175] = 8.7500000000; fxg[175] = 3.3432000000; feg[175] = 0.0608000000;
					g[176] = 8.8000000000; fxg[176] = 3.3163000000; feg[176] = 0.0602000000;
					g[177] = 8.8500000000; fxg[177] = 3.2924000000; feg[177] = 0.0595000000;
					g[178] = 8.9000000000; fxg[178] = 3.2707000000; feg[178] = 0.0589000000;
					g[179] = 8.9500000000; fxg[179] = 3.2501000000; feg[179] = 0.0583000000;
					g[180] = 9.0000000000; fxg[180] = 3.2289000000; feg[180] = 0.0576000000;
					g[181] = 9.0500000000; fxg[181] = 3.2056000000; feg[181] = 0.0570000000;
					g[182] = 9.1000000000; fxg[182] = 3.1797000000; feg[182] = 0.0564000000;
					g[183] = 9.1500000000; fxg[183] = 3.1516000000; feg[183] = 0.0559000000;
					g[184] = 9.2000000000; fxg[184] = 3.1223000000; feg[184] = 0.0553000000;
					g[185] = 9.2500000000; fxg[185] = 3.0931000000; feg[185] = 0.0547000000;
					g[186] = 9.3000000000; fxg[186] = 3.0648000000; feg[186] = 0.0542000000;
					g[187] = 9.3500000000; fxg[187] = 3.0374000000; feg[187] = 0.0536000000;
					g[188] = 9.4000000000; fxg[188] = 3.0106000000; feg[188] = 0.0531000000;
					g[189] = 9.4500000000; fxg[189] = 2.9836000000; feg[189] = 0.0525000000;
					g[190] = 9.5000000000; fxg[190] = 2.9559000000; feg[190] = 0.0520000000;
					g[191] = 9.5500000000; fxg[191] = 2.9276000000; feg[191] = 0.0515000000;
					g[192] = 9.6000000000; fxg[192] = 2.8993000000; feg[192] = 0.0510000000;
					g[193] = 9.6500000000; fxg[193] = 2.8721000000; feg[193] = 0.0505000000;
					g[194] = 9.7000000000; fxg[194] = 2.8470000000; feg[194] = 0.0500000000;
					g[195] = 9.7500000000; fxg[195] = 2.8248000000; feg[195] = 0.0495000000;
					g[196] = 9.8000000000; fxg[196] = 2.8055000000; feg[196] = 0.0490000000;
					g[197] = 9.8500000000; fxg[197] = 2.7883000000; feg[197] = 0.0486000000;
					g[198] = 9.9000000000; fxg[198] = 2.7718000000; feg[198] = 0.0481000000;
					g[199] = 9.9500000000; fxg[199] = 2.7544000000; feg[199] = 0.0476000000;
					g[200] = 10.0000000000; fxg[200] = 2.7348000000; feg[200] = 0.0472000000;
					g[201] = 10.0500000000; fxg[201] = 2.7125000000; feg[201] = 0.0467000000;
					g[202] = 10.1000000000; fxg[202] = 2.6879000000; feg[202] = 0.0463000000;
					g[203] = 10.1500000000; fxg[203] = 2.6620000000; feg[203] = 0.0458000000;
					g[204] = 10.2000000000; fxg[204] = 2.6362000000; feg[204] = 0.0454000000;
					g[205] = 10.2500000000; fxg[205] = 2.6115000000; feg[205] = 0.0450000000;
					g[206] = 10.3000000000; fxg[206] = 2.5883000000; feg[206] = 0.0446000000;
					g[207] = 10.3500000000; fxg[207] = 2.5664000000; feg[207] = 0.0442000000;
					g[208] = 10.4000000000; fxg[208] = 2.5449000000; feg[208] = 0.0438000000;
					g[209] = 10.4500000000; fxg[209] = 2.5229000000; feg[209] = 0.0434000000;
					g[210] = 10.5000000000; fxg[210] = 2.4999000000; feg[210] = 0.0430000000;
					g[211] = 10.5500000000; fxg[211] = 2.4762000000; feg[211] = 0.0426000000;
					g[212] = 10.6000000000; fxg[212] = 2.4521000000; feg[212] = 0.0422000000;
					g[213] = 10.6500000000; fxg[213] = 2.4286000000; feg[213] = 0.0418000000;
					g[214] = 10.7000000000; fxg[214] = 2.4068000000; feg[214] = 0.0415000000;
					g[215] = 10.7500000000; fxg[215] = 2.3875000000; feg[215] = 0.0411000000;
					g[216] = 10.8000000000; fxg[216] = 2.3713000000; feg[216] = 0.0407000000;
					g[217] = 10.8500000000; fxg[217] = 2.3579000000; feg[217] = 0.0404000000;
					g[218] = 10.9000000000; fxg[218] = 2.3462000000; feg[218] = 0.0400000000;
					g[219] = 10.9500000000; fxg[219] = 2.3349000000; feg[219] = 0.0397000000;
					g[220] = 11.0000000000; fxg[220] = 2.3223000000; feg[220] = 0.0393000000;
					g[221] = 11.0500000000; fxg[221] = 2.3073000000; feg[221] = 0.0390000000;
					g[222] = 11.1000000000; fxg[222] = 2.2896000000; feg[222] = 0.0386000000;
					g[223] = 11.1500000000; fxg[223] = 2.2694000000; feg[223] = 0.0383000000;
					g[224] = 11.2000000000; fxg[224] = 2.2478000000; feg[224] = 0.0380000000;
					g[225] = 11.2500000000; fxg[225] = 2.2259000000; feg[225] = 0.0377000000;
					g[226] = 11.3000000000; fxg[226] = 2.2050000000; feg[226] = 0.0373000000;
					g[227] = 11.3500000000; fxg[227] = 2.1860000000; feg[227] = 0.0370000000;
					g[228] = 11.4000000000; fxg[228] = 2.1688000000; feg[228] = 0.0367000000;
					g[229] = 11.4500000000; fxg[229] = 2.1528000000; feg[229] = 0.0364000000;
					g[230] = 11.5000000000; fxg[230] = 2.1368000000; feg[230] = 0.0361000000;
					g[231] = 11.5500000000; fxg[231] = 2.1202000000; feg[231] = 0.0358000000;
					g[232] = 11.6000000000; fxg[232] = 2.1025000000; feg[232] = 0.0355000000;
					g[233] = 11.6500000000; fxg[233] = 2.0837000000; feg[233] = 0.0352000000;
					g[234] = 11.7000000000; fxg[234] = 2.0644000000; feg[234] = 0.0349000000;
					g[235] = 11.7500000000; fxg[235] = 2.0452000000; feg[235] = 0.0346000000;
					g[236] = 11.8000000000; fxg[236] = 2.0271000000; feg[236] = 0.0344000000;
					g[237] = 11.8500000000; fxg[237] = 2.0109000000; feg[237] = 0.0341000000;
					g[238] = 11.9000000000; fxg[238] = 1.9975000000; feg[238] = 0.0338000000;
					g[239] = 11.9500000000; fxg[239] = 1.9870000000; feg[239] = 0.0335000000;
					g[240] = 12.0000000000; fxg[240] = 1.9793000000; feg[240] = 0.0333000000;
					break;
				case 53:
					g[0] = 0.0000000000; fxg[0] = 53.0000000000; feg[0] = 10.9838000000;
					g[1] = 0.0500000000; fxg[1] = 52.7165000000; feg[1] = 10.8580000000;
					g[2] = 0.1000000000; fxg[2] = 51.9035000000; feg[2] = 10.4974000000;
					g[3] = 0.1500000000; fxg[3] = 50.6620000000; feg[3] = 9.9478000000;
					g[4] = 0.2000000000; fxg[4] = 49.1265000000; feg[4] = 9.2708000000;
					g[5] = 0.2500000000; fxg[5] = 47.4316000000; feg[5] = 8.5294000000;
					g[6] = 0.3000000000; fxg[6] = 45.6886000000; feg[6] = 7.7773000000;
					g[7] = 0.3500000000; fxg[7] = 43.9749000000; feg[7] = 7.0532000000;
					g[8] = 0.4000000000; fxg[8] = 42.3351000000; feg[8] = 6.3813000000;
					g[9] = 0.4500000000; fxg[9] = 40.7878000000; feg[9] = 5.7735000000;
					g[10] = 0.5000000000; fxg[10] = 39.3351000000; feg[10] = 5.2328000000;
					g[11] = 0.5500000000; fxg[11] = 37.9693000000; feg[11] = 4.7569000000;
					g[12] = 0.6000000000; fxg[12] = 36.6791000000; feg[12] = 4.3402000000;
					g[13] = 0.6500000000; fxg[13] = 35.4533000000; feg[13] = 3.9759000000;
					g[14] = 0.7000000000; fxg[14] = 34.2819000000; feg[14] = 3.6571000000;
					g[15] = 0.7500000000; fxg[15] = 33.1577000000; feg[15] = 3.3771000000;
					g[16] = 0.8000000000; fxg[16] = 32.0757000000; feg[16] = 3.1300000000;
					g[17] = 0.8500000000; fxg[17] = 31.0334000000; feg[17] = 2.9107000000;
					g[18] = 0.9000000000; fxg[18] = 30.0297000000; feg[18] = 2.7149000000;
					g[19] = 0.9500000000; fxg[19] = 29.0647000000; feg[19] = 2.5390000000;
					g[20] = 1.0000000000; fxg[20] = 28.1391000000; feg[20] = 2.3800000000;
					g[21] = 1.0500000000; fxg[21] = 27.2541000000; feg[21] = 2.2356000000;
					g[22] = 1.1000000000; fxg[22] = 26.4104000000; feg[22] = 2.1038000000;
					g[23] = 1.1500000000; fxg[23] = 25.6088000000; feg[23] = 1.9828000000;
					g[24] = 1.2000000000; fxg[24] = 24.8496000000; feg[24] = 1.8715000000;
					g[25] = 1.2500000000; fxg[25] = 24.1326000000; feg[25] = 1.7687000000;
					g[26] = 1.3000000000; fxg[26] = 23.4573000000; feg[26] = 1.6735000000;
					g[27] = 1.3500000000; fxg[27] = 22.8224000000; feg[27] = 1.5852000000;
					g[28] = 1.4000000000; fxg[28] = 22.2266000000; feg[28] = 1.5031000000;
					g[29] = 1.4500000000; fxg[29] = 21.6679000000; feg[29] = 1.4267000000;
					g[30] = 1.5000000000; fxg[30] = 21.1441000000; feg[30] = 1.3554000000;
					g[31] = 1.5500000000; fxg[31] = 20.6531000000; feg[31] = 1.2890000000;
					g[32] = 1.6000000000; fxg[32] = 20.1922000000; feg[32] = 1.2269000000;
					g[33] = 1.6500000000; fxg[33] = 19.7589000000; feg[33] = 1.1689000000;
					g[34] = 1.7000000000; fxg[34] = 19.3508000000; feg[34] = 1.1147000000;
					g[35] = 1.7500000000; fxg[35] = 18.9651000000; feg[35] = 1.0639000000;
					g[36] = 1.8000000000; fxg[36] = 18.5996000000; feg[36] = 1.0165000000;
					g[37] = 1.8500000000; fxg[37] = 18.2518000000; feg[37] = 0.9720000000;
					g[38] = 1.9000000000; fxg[38] = 17.9196000000; feg[38] = 0.9303000000;
					g[39] = 1.9500000000; fxg[39] = 17.6010000000; feg[39] = 0.8912000000;
					g[40] = 2.0000000000; fxg[40] = 17.2939000000; feg[40] = 0.8546000000;
					g[41] = 2.0500000000; fxg[41] = 16.9969000000; feg[41] = 0.8202000000;
					g[42] = 2.1000000000; fxg[42] = 16.7083000000; feg[42] = 0.7878000000;
					g[43] = 2.1500000000; fxg[43] = 16.4268000000; feg[43] = 0.7575000000;
					g[44] = 2.2000000000; fxg[44] = 16.1512000000; feg[44] = 0.7289000000;
					g[45] = 2.2500000000; fxg[45] = 15.8806000000; feg[45] = 0.7019000000;
					g[46] = 2.3000000000; fxg[46] = 15.6141000000; feg[46] = 0.6766000000;
					g[47] = 2.3500000000; fxg[47] = 15.3511000000; feg[47] = 0.6527000000;
					g[48] = 2.4000000000; fxg[48] = 15.0910000000; feg[48] = 0.6301000000;
					g[49] = 2.4500000000; fxg[49] = 14.8333000000; feg[49] = 0.6087000000;
					g[50] = 2.5000000000; fxg[50] = 14.5777000000; feg[50] = 0.5885000000;
					g[51] = 2.5500000000; fxg[51] = 14.3239000000; feg[51] = 0.5694000000;
					g[52] = 2.6000000000; fxg[52] = 14.0720000000; feg[52] = 0.5513000000;
					g[53] = 2.6500000000; fxg[53] = 13.8218000000; feg[53] = 0.5341000000;
					g[54] = 2.7000000000; fxg[54] = 13.5734000000; feg[54] = 0.5178000000;
					g[55] = 2.7500000000; fxg[55] = 13.3267000000; feg[55] = 0.5022000000;
					g[56] = 2.8000000000; fxg[56] = 13.0818000000; feg[56] = 0.4874000000;
					g[57] = 2.8500000000; fxg[57] = 12.8389000000; feg[57] = 0.4734000000;
					g[58] = 2.9000000000; fxg[58] = 12.5983000000; feg[58] = 0.4599000000;
					g[59] = 2.9500000000; fxg[59] = 12.3603000000; feg[59] = 0.4471000000;
					g[60] = 3.0000000000; fxg[60] = 12.1249000000; feg[60] = 0.4348000000;
					g[61] = 3.0500000000; fxg[61] = 11.8921000000; feg[61] = 0.4231000000;
					g[62] = 3.1000000000; fxg[62] = 11.6621000000; feg[62] = 0.4118000000;
					g[63] = 3.1500000000; fxg[63] = 11.4353000000; feg[63] = 0.4010000000;
					g[64] = 3.2000000000; fxg[64] = 11.2122000000; feg[64] = 0.3907000000;
					g[65] = 3.2500000000; fxg[65] = 10.9931000000; feg[65] = 0.3807000000;
					g[66] = 3.3000000000; fxg[66] = 10.7781000000; feg[66] = 0.3712000000;
					g[67] = 3.3500000000; fxg[67] = 10.5668000000; feg[67] = 0.3620000000;
					g[68] = 3.4000000000; fxg[68] = 10.3593000000; feg[68] = 0.3531000000;
					g[69] = 3.4500000000; fxg[69] = 10.1558000000; feg[69] = 0.3446000000;
					g[70] = 3.5000000000; fxg[70] = 9.9569000000; feg[70] = 0.3364000000;
					g[71] = 3.5500000000; fxg[71] = 9.7631000000; feg[71] = 0.3284000000;
					g[72] = 3.6000000000; fxg[72] = 9.5746000000; feg[72] = 0.3208000000;
					g[73] = 3.6500000000; fxg[73] = 9.3910000000; feg[73] = 0.3134000000;
					g[74] = 3.7000000000; fxg[74] = 9.2120000000; feg[74] = 0.3062000000;
					g[75] = 3.7500000000; fxg[75] = 9.0371000000; feg[75] = 0.2993000000;
					g[76] = 3.8000000000; fxg[76] = 8.8666000000; feg[76] = 0.2926000000;
					g[77] = 3.8500000000; fxg[77] = 8.7010000000; feg[77] = 0.2861000000;
					g[78] = 3.9000000000; fxg[78] = 8.5409000000; feg[78] = 0.2798000000;
					g[79] = 3.9500000000; fxg[79] = 8.3865000000; feg[79] = 0.2737000000;
					g[80] = 4.0000000000; fxg[80] = 8.2378000000; feg[80] = 0.2678000000;
					g[81] = 4.0500000000; fxg[81] = 8.0939000000; feg[81] = 0.2621000000;
					g[82] = 4.1000000000; fxg[82] = 7.9542000000; feg[82] = 0.2565000000;
					g[83] = 4.1500000000; fxg[83] = 7.8182000000; feg[83] = 0.2512000000;
					g[84] = 4.2000000000; fxg[84] = 7.6860000000; feg[84] = 0.2459000000;
					g[85] = 4.2500000000; fxg[85] = 7.5583000000; feg[85] = 0.2408000000;
					g[86] = 4.3000000000; fxg[86] = 7.4357000000; feg[86] = 0.2359000000;
					g[87] = 4.3500000000; fxg[87] = 7.3186000000; feg[87] = 0.2311000000;
					g[88] = 4.4000000000; fxg[88] = 7.2070000000; feg[88] = 0.2264000000;
					g[89] = 4.4500000000; fxg[89] = 7.1000000000; feg[89] = 0.2219000000;
					g[90] = 4.5000000000; fxg[90] = 6.9967000000; feg[90] = 0.2175000000;
					g[91] = 4.5500000000; fxg[91] = 6.8961000000; feg[91] = 0.2132000000;
					g[92] = 4.6000000000; fxg[92] = 6.7979000000; feg[92] = 0.2090000000;
					g[93] = 4.6500000000; fxg[93] = 6.7025000000; feg[93] = 0.2050000000;
					g[94] = 4.7000000000; fxg[94] = 6.6106000000; feg[94] = 0.2010000000;
					g[95] = 4.7500000000; fxg[95] = 6.5229000000; feg[95] = 0.1972000000;
					g[96] = 4.8000000000; fxg[96] = 6.4399000000; feg[96] = 0.1935000000;
					g[97] = 4.8500000000; fxg[97] = 6.3617000000; feg[97] = 0.1898000000;
					g[98] = 4.9000000000; fxg[98] = 6.2874000000; feg[98] = 0.1863000000;
					g[99] = 4.9500000000; fxg[99] = 6.2160000000; feg[99] = 0.1828000000;
					g[100] = 5.0000000000; fxg[100] = 6.1462000000; feg[100] = 0.1794000000;
					g[101] = 5.0500000000; fxg[101] = 6.0774000000; feg[101] = 0.1761000000;
					g[102] = 5.1000000000; fxg[102] = 6.0096000000; feg[102] = 0.1730000000;
					g[103] = 5.1500000000; fxg[103] = 5.9433000000; feg[103] = 0.1699000000;
					g[104] = 5.2000000000; fxg[104] = 5.8793000000; feg[104] = 0.1668000000;
					g[105] = 5.2500000000; fxg[105] = 5.8185000000; feg[105] = 0.1639000000;
					g[106] = 5.3000000000; fxg[106] = 5.7614000000; feg[106] = 0.1610000000;
					g[107] = 5.3500000000; fxg[107] = 5.7083000000; feg[107] = 0.1582000000;
					g[108] = 5.4000000000; fxg[108] = 5.6583000000; feg[108] = 0.1554000000;
					g[109] = 5.4500000000; fxg[109] = 5.6104000000; feg[109] = 0.1527000000;
					g[110] = 5.5000000000; fxg[110] = 5.5633000000; feg[110] = 0.1501000000;
					g[111] = 5.5500000000; fxg[111] = 5.5159000000; feg[111] = 0.1476000000;
					g[112] = 5.6000000000; fxg[112] = 5.4680000000; feg[112] = 0.1451000000;
					g[113] = 5.6500000000; fxg[113] = 5.4200000000; feg[113] = 0.1427000000;
					g[114] = 5.7000000000; fxg[114] = 5.3725000000; feg[114] = 0.1403000000;
					g[115] = 5.7500000000; fxg[115] = 5.3263000000; feg[115] = 0.1380000000;
					g[116] = 5.8000000000; fxg[116] = 5.2822000000; feg[116] = 0.1358000000;
					g[117] = 5.8500000000; fxg[117] = 5.2410000000; feg[117] = 0.1336000000;
					g[118] = 5.9000000000; fxg[118] = 5.2029000000; feg[118] = 0.1315000000;
					g[119] = 5.9500000000; fxg[119] = 5.1677000000; feg[119] = 0.1293000000;
					g[120] = 6.0000000000; fxg[120] = 5.1341000000; feg[120] = 0.1273000000;
					g[121] = 6.0500000000; fxg[121] = 5.1008000000; feg[121] = 0.1253000000;
					g[122] = 6.1000000000; fxg[122] = 5.0667000000; feg[122] = 0.1233000000;
					g[123] = 6.1500000000; fxg[123] = 5.0311000000; feg[123] = 0.1214000000;
					g[124] = 6.2000000000; fxg[124] = 4.9941000000; feg[124] = 0.1196000000;
					g[125] = 6.2500000000; fxg[125] = 4.9563000000; feg[125] = 0.1177000000;
					g[126] = 6.3000000000; fxg[126] = 4.9183000000; feg[126] = 0.1160000000;
					g[127] = 6.3500000000; fxg[127] = 4.8808000000; feg[127] = 0.1142000000;
					g[128] = 6.4000000000; fxg[128] = 4.8445000000; feg[128] = 0.1126000000;
					g[129] = 6.4500000000; fxg[129] = 4.8104000000; feg[129] = 0.1109000000;
					g[130] = 6.5000000000; fxg[130] = 4.7788000000; feg[130] = 0.1093000000;
					g[131] = 6.5500000000; fxg[131] = 4.7499000000; feg[131] = 0.1077000000;
					g[132] = 6.6000000000; fxg[132] = 4.7229000000; feg[132] = 0.1061000000;
					g[133] = 6.6500000000; fxg[133] = 4.6966000000; feg[133] = 0.1046000000;
					g[134] = 6.7000000000; fxg[134] = 4.6695000000; feg[134] = 0.1031000000;
					g[135] = 6.7500000000; fxg[135] = 4.6405000000; feg[135] = 0.1016000000;
					g[136] = 6.8000000000; fxg[136] = 4.6095000000; feg[136] = 0.1002000000;
					g[137] = 6.8500000000; fxg[137] = 4.5768000000; feg[137] = 0.0988000000;
					g[138] = 6.9000000000; fxg[138] = 4.5430000000; feg[138] = 0.0974000000;
					g[139] = 6.9500000000; fxg[139] = 4.5087000000; feg[139] = 0.0961000000;
					g[140] = 7.0000000000; fxg[140] = 4.4743000000; feg[140] = 0.0948000000;
					g[141] = 7.0500000000; fxg[141] = 4.4404000000; feg[141] = 0.0935000000;
					g[142] = 7.1000000000; fxg[142] = 4.4076000000; feg[142] = 0.0923000000;
					g[143] = 7.1500000000; fxg[143] = 4.3768000000; feg[143] = 0.0911000000;
					g[144] = 7.2000000000; fxg[144] = 4.3486000000; feg[144] = 0.0898000000;
					g[145] = 7.2500000000; fxg[145] = 4.3228000000; feg[145] = 0.0887000000;
					g[146] = 7.3000000000; fxg[146] = 4.2987000000; feg[146] = 0.0875000000;
					g[147] = 7.3500000000; fxg[147] = 4.2749000000; feg[147] = 0.0863000000;
					g[148] = 7.4000000000; fxg[148] = 4.2500000000; feg[148] = 0.0852000000;
					g[149] = 7.4500000000; fxg[149] = 4.2229000000; feg[149] = 0.0841000000;
					g[150] = 7.5000000000; fxg[150] = 4.1935000000; feg[150] = 0.0831000000;
					g[151] = 7.5500000000; fxg[151] = 4.1623000000; feg[151] = 0.0820000000;
					g[152] = 7.6000000000; fxg[152] = 4.1300000000; feg[152] = 0.0810000000;
					g[153] = 7.6500000000; fxg[153] = 4.0971000000; feg[153] = 0.0800000000;
					g[154] = 7.7000000000; fxg[154] = 4.0640000000; feg[154] = 0.0790000000;
					g[155] = 7.7500000000; fxg[155] = 4.0308000000; feg[155] = 0.0781000000;
					g[156] = 7.8000000000; fxg[156] = 3.9979000000; feg[156] = 0.0771000000;
					g[157] = 7.8500000000; fxg[157] = 3.9657000000; feg[157] = 0.0762000000;
					g[158] = 7.9000000000; fxg[158] = 3.9352000000; feg[158] = 0.0753000000;
					g[159] = 7.9500000000; fxg[159] = 3.9072000000; feg[159] = 0.0744000000;
					g[160] = 8.0000000000; fxg[160] = 3.8818000000; feg[160] = 0.0735000000;
					g[161] = 8.0500000000; fxg[161] = 3.8586000000; feg[161] = 0.0726000000;
					g[162] = 8.1000000000; fxg[162] = 3.8362000000; feg[162] = 0.0717000000;
					g[163] = 8.1500000000; fxg[163] = 3.8132000000; feg[163] = 0.0709000000;
					g[164] = 8.2000000000; fxg[164] = 3.7883000000; feg[164] = 0.0701000000;
					g[165] = 8.2500000000; fxg[165] = 3.7609000000; feg[165] = 0.0693000000;
					g[166] = 8.3000000000; fxg[166] = 3.7313000000; feg[166] = 0.0685000000;
					g[167] = 8.3500000000; fxg[167] = 3.7004000000; feg[167] = 0.0677000000;
					g[168] = 8.4000000000; fxg[168] = 3.6690000000; feg[168] = 0.0669000000;
					g[169] = 8.4500000000; fxg[169] = 3.6376000000; feg[169] = 0.0662000000;
					g[170] = 8.5000000000; fxg[170] = 3.6063000000; feg[170] = 0.0654000000;
					g[171] = 8.5500000000; fxg[171] = 3.5748000000; feg[171] = 0.0647000000;
					g[172] = 8.6000000000; fxg[172] = 3.5431000000; feg[172] = 0.0640000000;
					g[173] = 8.6500000000; fxg[173] = 3.5115000000; feg[173] = 0.0633000000;
					g[174] = 8.7000000000; fxg[174] = 3.4809000000; feg[174] = 0.0626000000;
					g[175] = 8.7500000000; fxg[175] = 3.4521000000; feg[175] = 0.0620000000;
					g[176] = 8.8000000000; fxg[176] = 3.4259000000; feg[176] = 0.0613000000;
					g[177] = 8.8500000000; fxg[177] = 3.4025000000; feg[177] = 0.0606000000;
					g[178] = 8.9000000000; fxg[178] = 3.3813000000; feg[178] = 0.0600000000;
					g[179] = 8.9500000000; fxg[179] = 3.3611000000; feg[179] = 0.0593000000;
					g[180] = 9.0000000000; fxg[180] = 3.3403000000; feg[180] = 0.0587000000;
					g[181] = 9.0500000000; fxg[181] = 3.3175000000; feg[181] = 0.0581000000;
					g[182] = 9.1000000000; fxg[182] = 3.2922000000; feg[182] = 0.0575000000;
					g[183] = 9.1500000000; fxg[183] = 3.2646000000; feg[183] = 0.0569000000;
					g[184] = 9.2000000000; fxg[184] = 3.2356000000; feg[184] = 0.0563000000;
					g[185] = 9.2500000000; fxg[185] = 3.2063000000; feg[185] = 0.0557000000;
					g[186] = 9.3000000000; fxg[186] = 3.1774000000; feg[186] = 0.0551000000;
					g[187] = 9.3500000000; fxg[187] = 3.1492000000; feg[187] = 0.0546000000;
					g[188] = 9.4000000000; fxg[188] = 3.1213000000; feg[188] = 0.0540000000;
					g[189] = 9.4500000000; fxg[189] = 3.0932000000; feg[189] = 0.0535000000;
					g[190] = 9.5000000000; fxg[190] = 3.0646000000; feg[190] = 0.0530000000;
					g[191] = 9.5500000000; fxg[191] = 3.0357000000; feg[191] = 0.0524000000;
					g[192] = 9.6000000000; fxg[192] = 3.0071000000; feg[192] = 0.0519000000;
					g[193] = 9.6500000000; fxg[193] = 2.9798000000; feg[193] = 0.0514000000;
					g[194] = 9.7000000000; fxg[194] = 2.9548000000; feg[194] = 0.0509000000;
					g[195] = 9.7500000000; fxg[195] = 2.9326000000; feg[195] = 0.0504000000;
					g[196] = 9.8000000000; fxg[196] = 2.9133000000; feg[196] = 0.0499000000;
					g[197] = 9.8500000000; fxg[197] = 2.8961000000; feg[197] = 0.0494000000;
					g[198] = 9.9000000000; fxg[198] = 2.8796000000; feg[198] = 0.0490000000;
					g[199] = 9.9500000000; fxg[199] = 2.8621000000; feg[199] = 0.0485000000;
					g[200] = 10.0000000000; fxg[200] = 2.8425000000; feg[200] = 0.0480000000;
					g[201] = 10.0500000000; fxg[201] = 2.8202000000; feg[201] = 0.0476000000;
					g[202] = 10.1000000000; fxg[202] = 2.7955000000; feg[202] = 0.0471000000;
					g[203] = 10.1500000000; fxg[203] = 2.7695000000; feg[203] = 0.0467000000;
					g[204] = 10.2000000000; fxg[204] = 2.7433000000; feg[204] = 0.0462000000;
					g[205] = 10.2500000000; fxg[205] = 2.7179000000; feg[205] = 0.0458000000;
					g[206] = 10.3000000000; fxg[206] = 2.6938000000; feg[206] = 0.0454000000;
					g[207] = 10.3500000000; fxg[207] = 2.6707000000; feg[207] = 0.0450000000;
					g[208] = 10.4000000000; fxg[208] = 2.6479000000; feg[208] = 0.0446000000;
					g[209] = 10.4500000000; fxg[209] = 2.6247000000; feg[209] = 0.0442000000;
					g[210] = 10.5000000000; fxg[210] = 2.6007000000; feg[210] = 0.0438000000;
					g[211] = 10.5500000000; fxg[211] = 2.5760000000; feg[211] = 0.0434000000;
					g[212] = 10.6000000000; fxg[212] = 2.5511000000; feg[212] = 0.0430000000;
					g[213] = 10.6500000000; fxg[213] = 2.5270000000; feg[213] = 0.0426000000;
					g[214] = 10.7000000000; fxg[214] = 2.5047000000; feg[214] = 0.0422000000;
					g[215] = 10.7500000000; fxg[215] = 2.4851000000; feg[215] = 0.0418000000;
					g[216] = 10.8000000000; fxg[216] = 2.4685000000; feg[216] = 0.0415000000;
					g[217] = 10.8500000000; fxg[217] = 2.4547000000; feg[217] = 0.0411000000;
					g[218] = 10.9000000000; fxg[218] = 2.4427000000; feg[218] = 0.0407000000;
					g[219] = 10.9500000000; fxg[219] = 2.4309000000; feg[219] = 0.0404000000;
					g[220] = 11.0000000000; fxg[220] = 2.4179000000; feg[220] = 0.0400000000;
					g[221] = 11.0500000000; fxg[221] = 2.4025000000; feg[221] = 0.0397000000;
					g[222] = 11.1000000000; fxg[222] = 2.3843000000; feg[222] = 0.0393000000;
					g[223] = 11.1500000000; fxg[223] = 2.3637000000; feg[223] = 0.0390000000;
					g[224] = 11.2000000000; fxg[224] = 2.3415000000; feg[224] = 0.0387000000;
					g[225] = 11.2500000000; fxg[225] = 2.3190000000; feg[225] = 0.0383000000;
					g[226] = 11.3000000000; fxg[226] = 2.2974000000; feg[226] = 0.0380000000;
					g[227] = 11.3500000000; fxg[227] = 2.2775000000; feg[227] = 0.0377000000;
					g[228] = 11.4000000000; fxg[228] = 2.2593000000; feg[228] = 0.0374000000;
					g[229] = 11.4500000000; fxg[229] = 2.2421000000; feg[229] = 0.0371000000;
					g[230] = 11.5000000000; fxg[230] = 2.2252000000; feg[230] = 0.0368000000;
					g[231] = 11.5500000000; fxg[231] = 2.2076000000; feg[231] = 0.0365000000;
					g[232] = 11.6000000000; fxg[232] = 2.1889000000; feg[232] = 0.0362000000;
					g[233] = 11.6500000000; fxg[233] = 2.1691000000; feg[233] = 0.0359000000;
					g[234] = 11.7000000000; fxg[234] = 2.1488000000; feg[234] = 0.0356000000;
					g[235] = 11.7500000000; fxg[235] = 2.1286000000; feg[235] = 0.0353000000;
					g[236] = 11.8000000000; fxg[236] = 2.1096000000; feg[236] = 0.0350000000;
					g[237] = 11.8500000000; fxg[237] = 2.0927000000; feg[237] = 0.0347000000;
					g[238] = 11.9000000000; fxg[238] = 2.0787000000; feg[238] = 0.0344000000;
					g[239] = 11.9500000000; fxg[239] = 2.0678000000; feg[239] = 0.0341000000;
					g[240] = 12.0000000000; fxg[240] = 2.0595000000; feg[240] = 0.0339000000;
					break;
				case 54:
					g[0] = 0.0000000000; fxg[0] = 54.0000000000; feg[0] = 10.7951000000;
					g[1] = 0.0500000000; fxg[1] = 53.7210000000; feg[1] = 10.6858000000;
					g[2] = 0.1000000000; fxg[2] = 52.9167000000; feg[2] = 10.3707000000;
					g[3] = 0.1500000000; fxg[3] = 51.6770000000; feg[3] = 9.8841000000;
					g[4] = 0.2000000000; fxg[4] = 50.1251000000; feg[4] = 9.2740000000;
					g[5] = 0.2500000000; fxg[5] = 48.3909000000; feg[5] = 8.5918000000;
					g[6] = 0.3000000000; fxg[6] = 46.5880000000; feg[6] = 7.8843000000;
					g[7] = 0.3500000000; fxg[7] = 44.8021000000; feg[7] = 7.1883000000;
					g[8] = 0.4000000000; fxg[8] = 43.0878000000; feg[8] = 6.5292000000;
					g[9] = 0.4500000000; fxg[9] = 41.4732000000; feg[9] = 5.9222000000;
					g[10] = 0.5000000000; fxg[10] = 39.9663000000; feg[10] = 5.3740000000;
					g[11] = 0.5500000000; fxg[11] = 38.5626000000; feg[11] = 4.8856000000;
					g[12] = 0.6000000000; fxg[12] = 37.2507000000; feg[12] = 4.4541000000;
					g[13] = 0.6500000000; fxg[13] = 36.0175000000; feg[13] = 4.0747000000;
					g[14] = 0.7000000000; fxg[14] = 34.8499000000; feg[14] = 3.7415000000;
					g[15] = 0.7500000000; fxg[15] = 33.7371000000; feg[15] = 3.4486000000;
					g[16] = 0.8000000000; fxg[16] = 32.6707000000; feg[16] = 3.1905000000;
					g[17] = 0.8500000000; fxg[17] = 31.6449000000; feg[17] = 2.9622000000;
					g[18] = 0.9000000000; fxg[18] = 30.6562000000; feg[18] = 2.7590000000;
					g[19] = 0.9500000000; fxg[19] = 29.7028000000; feg[19] = 2.5774000000;
					g[20] = 1.0000000000; fxg[20] = 28.7842000000; feg[20] = 2.4140000000;
					g[21] = 1.0500000000; fxg[21] = 27.9007000000; feg[21] = 2.2663000000;
					g[22] = 1.1000000000; fxg[22] = 27.0531000000; feg[22] = 2.1320000000;
					g[23] = 1.1500000000; fxg[23] = 26.2424000000; feg[23] = 2.0094000000;
					g[24] = 1.2000000000; fxg[24] = 25.4692000000; feg[24] = 1.8968000000;
					g[25] = 1.2500000000; fxg[25] = 24.7341000000; feg[25] = 1.7931000000;
					g[26] = 1.3000000000; fxg[26] = 24.0372000000; feg[26] = 1.6973000000;
					g[27] = 1.3500000000; fxg[27] = 23.3783000000; feg[27] = 1.6085000000;
					g[28] = 1.4000000000; fxg[28] = 22.7567000000; feg[28] = 1.5261000000;
					g[29] = 1.4500000000; fxg[29] = 22.1714000000; feg[29] = 1.4493000000;
					g[30] = 1.5000000000; fxg[30] = 21.6209000000; feg[30] = 1.3777000000;
					g[31] = 1.5500000000; fxg[31] = 21.1037000000; feg[31] = 1.3109000000;
					g[32] = 1.6000000000; fxg[32] = 20.6176000000; feg[32] = 1.2484000000;
					g[33] = 1.6500000000; fxg[33] = 20.1607000000; feg[33] = 1.1899000000;
					g[34] = 1.7000000000; fxg[34] = 19.7307000000; feg[34] = 1.1352000000;
					g[35] = 1.7500000000; fxg[35] = 19.3254000000; feg[35] = 1.0839000000;
					g[36] = 1.8000000000; fxg[36] = 18.9426000000; feg[36] = 1.0359000000;
					g[37] = 1.8500000000; fxg[37] = 18.5799000000; feg[37] = 0.9908000000;
					g[38] = 1.9000000000; fxg[38] = 18.2352000000; feg[38] = 0.9485000000;
					g[39] = 1.9500000000; fxg[39] = 17.9064000000; feg[39] = 0.9087000000;
					g[40] = 2.0000000000; fxg[40] = 17.5916000000; feg[40] = 0.8714000000;
					g[41] = 2.0500000000; fxg[41] = 17.2890000000; feg[41] = 0.8363000000;
					g[42] = 2.1000000000; fxg[42] = 16.9969000000; feg[42] = 0.8033000000;
					g[43] = 2.1500000000; fxg[43] = 16.7137000000; feg[43] = 0.7722000000;
					g[44] = 2.2000000000; fxg[44] = 16.4383000000; feg[44] = 0.7430000000;
					g[45] = 2.2500000000; fxg[45] = 16.1693000000; feg[45] = 0.7154000000;
					g[46] = 2.3000000000; fxg[46] = 15.9056000000; feg[46] = 0.6894000000;
					g[47] = 2.3500000000; fxg[47] = 15.6466000000; feg[47] = 0.6649000000;
					g[48] = 2.4000000000; fxg[48] = 15.3913000000; feg[48] = 0.6417000000;
					g[49] = 2.4500000000; fxg[49] = 15.1391000000; feg[49] = 0.6198000000;
					g[50] = 2.5000000000; fxg[50] = 14.8895000000; feg[50] = 0.5991000000;
					g[51] = 2.5500000000; fxg[51] = 14.6422000000; feg[51] = 0.5795000000;
					g[52] = 2.6000000000; fxg[52] = 14.3968000000; feg[52] = 0.5609000000;
					g[53] = 2.6500000000; fxg[53] = 14.1532000000; feg[53] = 0.5432000000;
					g[54] = 2.7000000000; fxg[54] = 13.9113000000; feg[54] = 0.5265000000;
					g[55] = 2.7500000000; fxg[55] = 13.6709000000; feg[55] = 0.5105000000;
					g[56] = 2.8000000000; fxg[56] = 13.4319000000; feg[56] = 0.4954000000;
					g[57] = 2.8500000000; fxg[57] = 13.1946000000; feg[57] = 0.4809000000;
					g[58] = 2.9000000000; fxg[58] = 12.9591000000; feg[58] = 0.4672000000;
					g[59] = 2.9500000000; fxg[59] = 12.7255000000; feg[59] = 0.4541000000;
					g[60] = 3.0000000000; fxg[60] = 12.4939000000; feg[60] = 0.4415000000;
					g[61] = 3.0500000000; fxg[61] = 12.2644000000; feg[61] = 0.4295000000;
					g[62] = 3.1000000000; fxg[62] = 12.0370000000; feg[62] = 0.4180000000;
					g[63] = 3.1500000000; fxg[63] = 11.8123000000; feg[63] = 0.4070000000;
					g[64] = 3.2000000000; fxg[64] = 11.5904000000; feg[64] = 0.3965000000;
					g[65] = 3.2500000000; fxg[65] = 11.3718000000; feg[65] = 0.3864000000;
					g[66] = 3.3000000000; fxg[66] = 11.1564000000; feg[66] = 0.3766000000;
					g[67] = 3.3500000000; fxg[67] = 10.9441000000; feg[67] = 0.3673000000;
					g[68] = 3.4000000000; fxg[68] = 10.7351000000; feg[68] = 0.3583000000;
					g[69] = 3.4500000000; fxg[69] = 10.5296000000; feg[69] = 0.3496000000;
					g[70] = 3.5000000000; fxg[70] = 10.3281000000; feg[70] = 0.3413000000;
					g[71] = 3.5500000000; fxg[71] = 10.1310000000; feg[71] = 0.3333000000;
					g[72] = 3.6000000000; fxg[72] = 9.9384000000; feg[72] = 0.3255000000;
					g[73] = 3.6500000000; fxg[73] = 9.7502000000; feg[73] = 0.3180000000;
					g[74] = 3.7000000000; fxg[74] = 9.5661000000; feg[74] = 0.3107000000;
					g[75] = 3.7500000000; fxg[75] = 9.3859000000; feg[75] = 0.3037000000;
					g[76] = 3.8000000000; fxg[76] = 9.2099000000; feg[76] = 0.2970000000;
					g[77] = 3.8500000000; fxg[77] = 9.0384000000; feg[77] = 0.2904000000;
					g[78] = 3.9000000000; fxg[78] = 8.8720000000; feg[78] = 0.2840000000;
					g[79] = 3.9500000000; fxg[79] = 8.7109000000; feg[79] = 0.2779000000;
					g[80] = 4.0000000000; fxg[80] = 8.5549000000; feg[80] = 0.2719000000;
					g[81] = 4.0500000000; fxg[81] = 8.4036000000; feg[81] = 0.2661000000;
					g[82] = 4.1000000000; fxg[82] = 8.2563000000; feg[82] = 0.2605000000;
					g[83] = 4.1500000000; fxg[83] = 8.1129000000; feg[83] = 0.2551000000;
					g[84] = 4.2000000000; fxg[84] = 7.9734000000; feg[84] = 0.2498000000;
					g[85] = 4.2500000000; fxg[85] = 7.8383000000; feg[85] = 0.2447000000;
					g[86] = 4.3000000000; fxg[86] = 7.7082000000; feg[86] = 0.2397000000;
					g[87] = 4.3500000000; fxg[87] = 7.5835000000; feg[87] = 0.2348000000;
					g[88] = 4.4000000000; fxg[88] = 7.4639000000; feg[88] = 0.2301000000;
					g[89] = 4.4500000000; fxg[89] = 7.3489000000; feg[89] = 0.2255000000;
					g[90] = 4.5000000000; fxg[90] = 7.2376000000; feg[90] = 0.2211000000;
					g[91] = 4.5500000000; fxg[91] = 7.1294000000; feg[91] = 0.2167000000;
					g[92] = 4.6000000000; fxg[92] = 7.0239000000; feg[92] = 0.2125000000;
					g[93] = 4.6500000000; fxg[93] = 6.9215000000; feg[93] = 0.2084000000;
					g[94] = 4.7000000000; fxg[94] = 6.8227000000; feg[94] = 0.2045000000;
					g[95] = 4.7500000000; fxg[95] = 6.7283000000; feg[95] = 0.2006000000;
					g[96] = 4.8000000000; fxg[96] = 6.6386000000; feg[96] = 0.1968000000;
					g[97] = 4.8500000000; fxg[97] = 6.5536000000; feg[97] = 0.1931000000;
					g[98] = 4.9000000000; fxg[98] = 6.4725000000; feg[98] = 0.1895000000;
					g[99] = 4.9500000000; fxg[99] = 6.3944000000; feg[99] = 0.1860000000;
					g[100] = 5.0000000000; fxg[100] = 6.3183000000; feg[100] = 0.1826000000;
					g[101] = 5.0500000000; fxg[101] = 6.2437000000; feg[101] = 0.1793000000;
					g[102] = 5.1000000000; fxg[102] = 6.1704000000; feg[102] = 0.1760000000;
					g[103] = 5.1500000000; fxg[103] = 6.0989000000; feg[103] = 0.1729000000;
					g[104] = 5.2000000000; fxg[104] = 6.0300000000; feg[104] = 0.1698000000;
					g[105] = 5.2500000000; fxg[105] = 5.9645000000; feg[105] = 0.1668000000;
					g[106] = 5.3000000000; fxg[106] = 5.9029000000; feg[106] = 0.1639000000;
					g[107] = 5.3500000000; fxg[107] = 5.8452000000; feg[107] = 0.1611000000;
					g[108] = 5.4000000000; fxg[108] = 5.7907000000; feg[108] = 0.1583000000;
					g[109] = 5.4500000000; fxg[109] = 5.7384000000; feg[109] = 0.1556000000;
					g[110] = 5.5000000000; fxg[110] = 5.6872000000; feg[110] = 0.1529000000;
					g[111] = 5.5500000000; fxg[111] = 5.6362000000; feg[111] = 0.1503000000;
					g[112] = 5.6000000000; fxg[112] = 5.5849000000; feg[112] = 0.1478000000;
					g[113] = 5.6500000000; fxg[113] = 5.5338000000; feg[113] = 0.1453000000;
					g[114] = 5.7000000000; fxg[114] = 5.4834000000; feg[114] = 0.1430000000;
					g[115] = 5.7500000000; fxg[115] = 5.4346000000; feg[115] = 0.1406000000;
					g[116] = 5.8000000000; fxg[116] = 5.3882000000; feg[116] = 0.1383000000;
					g[117] = 5.8500000000; fxg[117] = 5.3448000000; feg[117] = 0.1361000000;
					g[118] = 5.9000000000; fxg[118] = 5.3046000000; feg[118] = 0.1339000000;
					g[119] = 5.9500000000; fxg[119] = 5.2673000000; feg[119] = 0.1318000000;
					g[120] = 6.0000000000; fxg[120] = 5.2317000000; feg[120] = 0.1297000000;
					g[121] = 6.0500000000; fxg[121] = 5.1966000000; feg[121] = 0.1276000000;
					g[122] = 6.1000000000; fxg[122] = 5.1609000000; feg[122] = 0.1257000000;
					g[123] = 6.1500000000; fxg[123] = 5.1240000000; feg[123] = 0.1237000000;
					g[124] = 6.2000000000; fxg[124] = 5.0858000000; feg[124] = 0.1218000000;
					g[125] = 6.2500000000; fxg[125] = 5.0469000000; feg[125] = 0.1200000000;
					g[126] = 6.3000000000; fxg[126] = 5.0078000000; feg[126] = 0.1182000000;
					g[127] = 6.3500000000; fxg[127] = 4.9695000000; feg[127] = 0.1164000000;
					g[128] = 6.4000000000; fxg[128] = 4.9327000000; feg[128] = 0.1147000000;
					g[129] = 6.4500000000; fxg[129] = 4.8982000000; feg[129] = 0.1130000000;
					g[130] = 6.5000000000; fxg[130] = 4.8664000000; feg[130] = 0.1113000000;
					g[131] = 6.5500000000; fxg[131] = 4.8373000000; feg[131] = 0.1097000000;
					g[132] = 6.6000000000; fxg[132] = 4.8100000000; feg[132] = 0.1081000000;
					g[133] = 6.6500000000; fxg[133] = 4.7835000000; feg[133] = 0.1065000000;
					g[134] = 6.7000000000; fxg[134] = 4.7564000000; feg[134] = 0.1050000000;
					g[135] = 6.7500000000; fxg[135] = 4.7276000000; feg[135] = 0.1035000000;
					g[136] = 6.8000000000; fxg[136] = 4.6968000000; feg[136] = 0.1021000000;
					g[137] = 6.8500000000; fxg[137] = 4.6643000000; feg[137] = 0.1007000000;
					g[138] = 6.9000000000; fxg[138] = 4.6305000000; feg[138] = 0.0993000000;
					g[139] = 6.9500000000; fxg[139] = 4.5961000000; feg[139] = 0.0979000000;
					g[140] = 7.0000000000; fxg[140] = 4.5617000000; feg[140] = 0.0966000000;
					g[141] = 7.0500000000; fxg[141] = 4.5280000000; feg[141] = 0.0953000000;
					g[142] = 7.1000000000; fxg[142] = 4.4957000000; feg[142] = 0.0940000000;
					g[143] = 7.1500000000; fxg[143] = 4.4657000000; feg[143] = 0.0928000000;
					g[144] = 7.2000000000; fxg[144] = 4.4382000000; feg[144] = 0.0915000000;
					g[145] = 7.2500000000; fxg[145] = 4.4132000000; feg[145] = 0.0903000000;
					g[146] = 7.3000000000; fxg[146] = 4.3898000000; feg[146] = 0.0891000000;
					g[147] = 7.3500000000; fxg[147] = 4.3667000000; feg[147] = 0.0880000000;
					g[148] = 7.4000000000; fxg[148] = 4.3426000000; feg[148] = 0.0868000000;
					g[149] = 7.4500000000; fxg[149] = 4.3165000000; feg[149] = 0.0857000000;
					g[150] = 7.5000000000; fxg[150] = 4.2880000000; feg[150] = 0.0846000000;
					g[151] = 7.5500000000; fxg[151] = 4.2576000000; feg[151] = 0.0835000000;
					g[152] = 7.6000000000; fxg[152] = 4.2257000000; feg[152] = 0.0825000000;
					g[153] = 7.6500000000; fxg[153] = 4.1930000000; feg[153] = 0.0815000000;
					g[154] = 7.7000000000; fxg[154] = 4.1599000000; feg[154] = 0.0805000000;
					g[155] = 7.7500000000; fxg[155] = 4.1267000000; feg[155] = 0.0795000000;
					g[156] = 7.8000000000; fxg[156] = 4.0941000000; feg[156] = 0.0785000000;
					g[157] = 7.8500000000; fxg[157] = 4.0626000000; feg[157] = 0.0776000000;
					g[158] = 7.9000000000; fxg[158] = 4.0331000000; feg[158] = 0.0766000000;
					g[159] = 7.9500000000; fxg[159] = 4.0061000000; feg[159] = 0.0757000000;
					g[160] = 8.0000000000; fxg[160] = 3.9817000000; feg[160] = 0.0748000000;
					g[161] = 8.0500000000; fxg[161] = 3.9593000000; feg[161] = 0.0739000000;
					g[162] = 8.1000000000; fxg[162] = 3.9378000000; feg[162] = 0.0730000000;
					g[163] = 8.1500000000; fxg[163] = 3.9156000000; feg[163] = 0.0722000000;
					g[164] = 8.2000000000; fxg[164] = 3.8916000000; feg[164] = 0.0713000000;
					g[165] = 8.2500000000; fxg[165] = 3.8653000000; feg[165] = 0.0705000000;
					g[166] = 8.3000000000; fxg[166] = 3.8367000000; feg[166] = 0.0697000000;
					g[167] = 8.3500000000; fxg[167] = 3.8064000000; feg[167] = 0.0689000000;
					g[168] = 8.4000000000; fxg[168] = 3.7752000000; feg[168] = 0.0681000000;
					g[169] = 8.4500000000; fxg[169] = 3.7436000000; feg[169] = 0.0674000000;
					g[170] = 8.5000000000; fxg[170] = 3.7117000000; feg[170] = 0.0666000000;
					g[171] = 8.5500000000; fxg[171] = 3.6798000000; feg[171] = 0.0659000000;
					g[172] = 8.6000000000; fxg[172] = 3.6479000000; feg[172] = 0.0652000000;
					g[173] = 8.6500000000; fxg[173] = 3.6165000000; feg[173] = 0.0645000000;
					g[174] = 8.7000000000; fxg[174] = 3.5863000000; feg[174] = 0.0638000000;
					g[175] = 8.7500000000; fxg[175] = 3.5581000000; feg[175] = 0.0631000000;
					g[176] = 8.8000000000; fxg[176] = 3.5327000000; feg[176] = 0.0624000000;
					g[177] = 8.8500000000; fxg[177] = 3.5100000000; feg[177] = 0.0617000000;
					g[178] = 8.9000000000; fxg[178] = 3.4894000000; feg[178] = 0.0610000000;
					g[179] = 8.9500000000; fxg[179] = 3.4696000000; feg[179] = 0.0604000000;
					g[180] = 9.0000000000; fxg[180] = 3.4493000000; feg[180] = 0.0597000000;
					g[181] = 9.0500000000; fxg[181] = 3.4271000000; feg[181] = 0.0591000000;
					g[182] = 9.1000000000; fxg[182] = 3.4025000000; feg[182] = 0.0585000000;
					g[183] = 9.1500000000; fxg[183] = 3.3756000000; feg[183] = 0.0579000000;
					g[184] = 9.2000000000; fxg[184] = 3.3470000000; feg[184] = 0.0573000000;
					g[185] = 9.2500000000; fxg[185] = 3.3177000000; feg[185] = 0.0567000000;
					g[186] = 9.3000000000; fxg[186] = 3.2884000000; feg[186] = 0.0561000000;
					g[187] = 9.3500000000; fxg[187] = 3.2593000000; feg[187] = 0.0556000000;
					g[188] = 9.4000000000; fxg[188] = 3.2304000000; feg[188] = 0.0550000000;
					g[189] = 9.4500000000; fxg[189] = 3.2013000000; feg[189] = 0.0545000000;
					g[190] = 9.5000000000; fxg[190] = 3.1720000000; feg[190] = 0.0539000000;
					g[191] = 9.5500000000; fxg[191] = 3.1426000000; feg[191] = 0.0534000000;
					g[192] = 9.6000000000; fxg[192] = 3.1138000000; feg[192] = 0.0529000000;
					g[193] = 9.6500000000; fxg[193] = 3.0866000000; feg[193] = 0.0523000000;
					g[194] = 9.7000000000; fxg[194] = 3.0618000000; feg[194] = 0.0518000000;
					g[195] = 9.7500000000; fxg[195] = 3.0399000000; feg[195] = 0.0513000000;
					g[196] = 9.8000000000; fxg[196] = 3.0208000000; feg[196] = 0.0508000000;
					g[197] = 9.8500000000; fxg[197] = 3.0037000000; feg[197] = 0.0503000000;
					g[198] = 9.9000000000; fxg[198] = 2.9871000000; feg[198] = 0.0498000000;
					g[199] = 9.9500000000; fxg[199] = 2.9697000000; feg[199] = 0.0493000000;
					g[200] = 10.0000000000; fxg[200] = 2.9502000000; feg[200] = 0.0489000000;
					g[201] = 10.0500000000; fxg[201] = 2.9281000000; feg[201] = 0.0484000000;
					g[202] = 10.1000000000; fxg[202] = 2.9037000000; feg[202] = 0.0480000000;
					g[203] = 10.1500000000; fxg[203] = 2.8777000000; feg[203] = 0.0475000000;
					g[204] = 10.2000000000; fxg[204] = 2.8513000000; feg[204] = 0.0471000000;
					g[205] = 10.2500000000; fxg[205] = 2.8253000000; feg[205] = 0.0466000000;
					g[206] = 10.3000000000; fxg[206] = 2.8002000000; feg[206] = 0.0462000000;
					g[207] = 10.3500000000; fxg[207] = 2.7758000000; feg[207] = 0.0458000000;
					g[208] = 10.4000000000; fxg[208] = 2.7516000000; feg[208] = 0.0454000000;
					g[209] = 10.4500000000; fxg[209] = 2.7272000000; feg[209] = 0.0449000000;
					g[210] = 10.5000000000; fxg[210] = 2.7021000000; feg[210] = 0.0445000000;
					g[211] = 10.5500000000; fxg[211] = 2.6765000000; feg[211] = 0.0441000000;
					g[212] = 10.6000000000; fxg[212] = 2.6510000000; feg[212] = 0.0438000000;
					g[213] = 10.6500000000; fxg[213] = 2.6264000000; feg[213] = 0.0434000000;
					g[214] = 10.7000000000; fxg[214] = 2.6038000000; feg[214] = 0.0430000000;
					g[215] = 10.7500000000; fxg[215] = 2.5840000000; feg[215] = 0.0426000000;
					g[216] = 10.8000000000; fxg[216] = 2.5673000000; feg[216] = 0.0422000000;
					g[217] = 10.8500000000; fxg[217] = 2.5532000000; feg[217] = 0.0418000000;
					g[218] = 10.9000000000; fxg[218] = 2.5408000000; feg[218] = 0.0415000000;
					g[219] = 10.9500000000; fxg[219] = 2.5287000000; feg[219] = 0.0411000000;
					g[220] = 11.0000000000; fxg[220] = 2.5153000000; feg[220] = 0.0407000000;
					g[221] = 11.0500000000; fxg[221] = 2.4997000000; feg[221] = 0.0404000000;
					g[222] = 11.1000000000; fxg[222] = 2.4813000000; feg[222] = 0.0400000000;
					g[223] = 11.1500000000; fxg[223] = 2.4604000000; feg[223] = 0.0397000000;
					g[224] = 11.2000000000; fxg[224] = 2.4380000000; feg[224] = 0.0394000000;
					g[225] = 11.2500000000; fxg[225] = 2.4151000000; feg[225] = 0.0390000000;
					g[226] = 11.3000000000; fxg[226] = 2.3929000000; feg[226] = 0.0387000000;
					g[227] = 11.3500000000; fxg[227] = 2.3720000000; feg[227] = 0.0384000000;
					g[228] = 11.4000000000; fxg[228] = 2.3526000000; feg[228] = 0.0380000000;
					g[229] = 11.4500000000; fxg[229] = 2.3341000000; feg[229] = 0.0377000000;
					g[230] = 11.5000000000; fxg[230] = 2.3159000000; feg[230] = 0.0374000000;
					g[231] = 11.5500000000; fxg[231] = 2.2970000000; feg[231] = 0.0371000000;
					g[232] = 11.6000000000; fxg[232] = 2.2772000000; feg[232] = 0.0368000000;
					g[233] = 11.6500000000; fxg[233] = 2.2564000000; feg[233] = 0.0365000000;
					g[234] = 11.7000000000; fxg[234] = 2.2352000000; feg[234] = 0.0362000000;
					g[235] = 11.7500000000; fxg[235] = 2.2142000000; feg[235] = 0.0359000000;
					g[236] = 11.8000000000; fxg[236] = 2.1946000000; feg[236] = 0.0356000000;
					g[237] = 11.8500000000; fxg[237] = 2.1772000000; feg[237] = 0.0353000000;
					g[238] = 11.9000000000; fxg[238] = 2.1627000000; feg[238] = 0.0350000000;
					g[239] = 11.9500000000; fxg[239] = 2.1513000000; feg[239] = 0.0348000000;
					g[240] = 12.0000000000; fxg[240] = 2.1426000000; feg[240] = 0.0345000000;
					break;
				case 55:
					g[0] = 0.0000000000; fxg[0] = 55.0000000000; feg[0] = 16.5115000000;
					g[1] = 0.0500000000; fxg[1] = 54.5872000000; feg[1] = 15.8069000000;
					g[2] = 0.1000000000; fxg[2] = 53.5266000000; feg[2] = 14.1057000000;
					g[3] = 0.1500000000; fxg[3] = 52.1365000000; feg[3] = 12.1839000000;
					g[4] = 0.2000000000; fxg[4] = 50.6024000000; feg[4] = 10.5252000000;
					g[5] = 0.2500000000; fxg[5] = 48.9784000000; feg[5] = 9.2237000000;
					g[6] = 0.3000000000; fxg[6] = 47.2904000000; feg[6] = 8.2008000000;
					g[7] = 0.3500000000; fxg[7] = 45.5783000000; feg[7] = 7.3631000000;
					g[8] = 0.4000000000; fxg[8] = 43.8880000000; feg[8] = 6.6488000000;
					g[9] = 0.4500000000; fxg[9] = 42.2580000000; feg[9] = 6.0240000000;
					g[10] = 0.5000000000; fxg[10] = 40.7121000000; feg[10] = 5.4714000000;
					g[11] = 0.5500000000; fxg[11] = 39.2607000000; feg[11] = 4.9812000000;
					g[12] = 0.6000000000; fxg[12] = 37.9032000000; feg[12] = 4.5465000000;
					g[13] = 0.6500000000; fxg[13] = 36.6329000000; feg[13] = 4.1618000000;
					g[14] = 0.7000000000; fxg[14] = 35.4395000000; feg[14] = 3.8217000000;
					g[15] = 0.7500000000; fxg[15] = 34.3123000000; feg[15] = 3.5209000000;
					g[16] = 0.8000000000; fxg[16] = 33.2412000000; feg[16] = 3.2548000000;
					g[17] = 0.8500000000; fxg[17] = 32.2179000000; feg[17] = 3.0187000000;
					g[18] = 0.9000000000; fxg[18] = 31.2363000000; feg[18] = 2.8087000000;
					g[19] = 0.9500000000; fxg[19] = 30.2918000000; feg[19] = 2.6210000000;
					g[20] = 1.0000000000; fxg[20] = 29.3818000000; feg[20] = 2.4525000000;
					g[21] = 1.0500000000; fxg[21] = 28.5050000000; feg[21] = 2.3007000000;
					g[22] = 1.1000000000; fxg[22] = 27.6608000000; feg[22] = 2.1631000000;
					g[23] = 1.1500000000; fxg[23] = 26.8495000000; feg[23] = 2.0378000000;
					g[24] = 1.2000000000; fxg[24] = 26.0715000000; feg[24] = 1.9232000000;
					g[25] = 1.2500000000; fxg[25] = 25.3273000000; feg[25] = 1.8181000000;
					g[26] = 1.3000000000; fxg[26] = 24.6175000000; feg[26] = 1.7211000000;
					g[27] = 1.3500000000; fxg[27] = 23.9423000000; feg[27] = 1.6314000000;
					g[28] = 1.4000000000; fxg[28] = 23.3015000000; feg[28] = 1.5483000000;
					g[29] = 1.4500000000; fxg[29] = 22.6948000000; feg[29] = 1.4710000000;
					g[30] = 1.5000000000; fxg[30] = 22.1218000000; feg[30] = 1.3989000000;
					g[31] = 1.5500000000; fxg[31] = 21.5807000000; feg[31] = 1.3317000000;
					g[32] = 1.6000000000; fxg[32] = 21.0709000000; feg[32] = 1.2688000000;
					g[33] = 1.6500000000; fxg[33] = 20.5911000000; feg[33] = 1.2100000000;
					g[34] = 1.7000000000; fxg[34] = 20.1385000000; feg[34] = 1.1548000000;
					g[35] = 1.7500000000; fxg[35] = 19.7116000000; feg[35] = 1.1031000000;
					g[36] = 1.8000000000; fxg[36] = 19.3097000000; feg[36] = 1.0546000000;
					g[37] = 1.8500000000; fxg[37] = 18.9297000000; feg[37] = 1.0090000000;
					g[38] = 1.9000000000; fxg[38] = 18.5686000000; feg[38] = 0.9661000000;
					g[39] = 1.9500000000; fxg[39] = 18.2259000000; feg[39] = 0.9259000000;
					g[40] = 2.0000000000; fxg[40] = 17.9006000000; feg[40] = 0.8879000000;
					g[41] = 2.0500000000; fxg[41] = 17.5892000000; feg[41] = 0.8522000000;
					g[42] = 2.1000000000; fxg[42] = 17.2888000000; feg[42] = 0.8187000000;
					g[43] = 2.1500000000; fxg[43] = 16.9998000000; feg[43] = 0.7870000000;
					g[44] = 2.2000000000; fxg[44] = 16.7220000000; feg[44] = 0.7571000000;
					g[45] = 2.2500000000; fxg[45] = 16.4524000000; feg[45] = 0.7290000000;
					g[46] = 2.3000000000; fxg[46] = 16.1880000000; feg[46] = 0.7024000000;
					g[47] = 2.3500000000; fxg[47] = 15.9288000000; feg[47] = 0.6773000000;
					g[48] = 2.4000000000; fxg[48] = 15.6760000000; feg[48] = 0.6536000000;
					g[49] = 2.4500000000; fxg[49] = 15.4290000000; feg[49] = 0.6311000000;
					g[50] = 2.5000000000; fxg[50] = 15.1846000000; feg[50] = 0.6099000000;
					g[51] = 2.5500000000; fxg[51] = 14.9412000000; feg[51] = 0.5898000000;
					g[52] = 2.6000000000; fxg[52] = 14.6998000000; feg[52] = 0.5707000000;
					g[53] = 2.6500000000; fxg[53] = 14.4620000000; feg[53] = 0.5526000000;
					g[54] = 2.7000000000; fxg[54] = 14.2279000000; feg[54] = 0.5354000000;
					g[55] = 2.7500000000; fxg[55] = 13.9948000000; feg[55] = 0.5191000000;
					g[56] = 2.8000000000; fxg[56] = 13.7613000000; feg[56] = 0.5036000000;
					g[57] = 2.8500000000; fxg[57] = 13.5283000000; feg[57] = 0.4888000000;
					g[58] = 2.9000000000; fxg[58] = 13.2972000000; feg[58] = 0.4747000000;
					g[59] = 2.9500000000; fxg[59] = 13.0697000000; feg[59] = 0.4613000000;
					g[60] = 3.0000000000; fxg[60] = 12.8450000000; feg[60] = 0.4484000000;
					g[61] = 3.0500000000; fxg[61] = 12.6205000000; feg[61] = 0.4361000000;
					g[62] = 3.1000000000; fxg[62] = 12.3962000000; feg[62] = 0.4244000000;
					g[63] = 3.1500000000; fxg[63] = 12.1733000000; feg[63] = 0.4132000000;
					g[64] = 3.2000000000; fxg[64] = 11.9529000000; feg[64] = 0.4025000000;
					g[65] = 3.2500000000; fxg[65] = 11.7365000000; feg[65] = 0.3921000000;
					g[66] = 3.3000000000; fxg[66] = 11.5244000000; feg[66] = 0.3822000000;
					g[67] = 3.3500000000; fxg[67] = 11.3140000000; feg[67] = 0.3727000000;
					g[68] = 3.4000000000; fxg[68] = 11.1045000000; feg[68] = 0.3635000000;
					g[69] = 3.4500000000; fxg[69] = 10.8978000000; feg[69] = 0.3547000000;
					g[70] = 3.5000000000; fxg[70] = 10.6942000000; feg[70] = 0.3463000000;
					g[71] = 3.5500000000; fxg[71] = 10.4942000000; feg[71] = 0.3381000000;
					g[72] = 3.6000000000; fxg[72] = 10.2996000000; feg[72] = 0.3302000000;
					g[73] = 3.6500000000; fxg[73] = 10.1103000000; feg[73] = 0.3226000000;
					g[74] = 3.7000000000; fxg[74] = 9.9235000000; feg[74] = 0.3152000000;
					g[75] = 3.7500000000; fxg[75] = 9.7387000000; feg[75] = 0.3081000000;
					g[76] = 3.8000000000; fxg[76] = 9.5580000000; feg[76] = 0.3013000000;
					g[77] = 3.8500000000; fxg[77] = 9.3816000000; feg[77] = 0.2946000000;
					g[78] = 3.9000000000; fxg[78] = 9.2089000000; feg[78] = 0.2882000000;
					g[79] = 3.9500000000; fxg[79] = 9.0413000000; feg[79] = 0.2820000000;
					g[80] = 4.0000000000; fxg[80] = 8.8804000000; feg[80] = 0.2760000000;
					g[81] = 4.0500000000; fxg[81] = 8.7245000000; feg[81] = 0.2701000000;
					g[82] = 4.1000000000; fxg[82] = 8.5706000000; feg[82] = 0.2644000000;
					g[83] = 4.1500000000; fxg[83] = 8.4194000000; feg[83] = 0.2589000000;
					g[84] = 4.2000000000; fxg[84] = 8.2733000000; feg[84] = 0.2536000000;
					g[85] = 4.2500000000; fxg[85] = 8.1321000000; feg[85] = 0.2484000000;
					g[86] = 4.3000000000; fxg[86] = 7.9943000000; feg[86] = 0.2434000000;
					g[87] = 4.3500000000; fxg[87] = 7.8608000000; feg[87] = 0.2385000000;
					g[88] = 4.4000000000; fxg[88] = 7.7339000000; feg[88] = 0.2337000000;
					g[89] = 4.4500000000; fxg[89] = 7.6131000000; feg[89] = 0.2291000000;
					g[90] = 4.5000000000; fxg[90] = 7.4950000000; feg[90] = 0.2246000000;
					g[91] = 4.5500000000; fxg[91] = 7.3781000000; feg[91] = 0.2202000000;
					g[92] = 4.6000000000; fxg[92] = 7.2644000000; feg[92] = 0.2160000000;
					g[93] = 4.6500000000; fxg[93] = 7.1560000000; feg[93] = 0.2118000000;
					g[94] = 4.7000000000; fxg[94] = 7.0517000000; feg[94] = 0.2078000000;
					g[95] = 4.7500000000; fxg[95] = 6.9500000000; feg[95] = 0.2039000000;
					g[96] = 4.8000000000; fxg[96] = 6.8517000000; feg[96] = 0.2001000000;
					g[97] = 4.8500000000; fxg[97] = 6.7590000000; feg[97] = 0.1963000000;
					g[98] = 4.9000000000; fxg[98] = 6.6723000000; feg[98] = 0.1927000000;
					g[99] = 4.9500000000; fxg[99] = 6.5888000000; feg[99] = 0.1891000000;
					g[100] = 5.0000000000; fxg[100] = 6.5054000000; feg[100] = 0.1857000000;
					g[101] = 5.0500000000; fxg[101] = 6.4226000000; feg[101] = 0.1824000000;
					g[102] = 5.1000000000; fxg[102] = 6.3432000000; feg[102] = 0.1791000000;
					g[103] = 5.1500000000; fxg[103] = 6.2681000000; feg[103] = 0.1759000000;
					g[104] = 5.2000000000; fxg[104] = 6.1957000000; feg[104] = 0.1728000000;
					g[105] = 5.2500000000; fxg[105] = 6.1248000000; feg[105] = 0.1698000000;
					g[106] = 5.3000000000; fxg[106] = 6.0564000000; feg[106] = 0.1668000000;
					g[107] = 5.3500000000; fxg[107] = 5.9924000000; feg[107] = 0.1639000000;
					g[108] = 5.4000000000; fxg[108] = 5.9336000000; feg[108] = 0.1611000000;
					g[109] = 5.4500000000; fxg[109] = 5.8779000000; feg[109] = 0.1583000000;
					g[110] = 5.5000000000; fxg[110] = 5.8220000000; feg[110] = 0.1556000000;
					g[111] = 5.5500000000; fxg[111] = 5.7649000000; feg[111] = 0.1530000000;
					g[112] = 5.6000000000; fxg[112] = 5.7081000000; feg[112] = 0.1505000000;
					g[113] = 5.6500000000; fxg[113] = 5.6541000000; feg[113] = 0.1480000000;
					g[114] = 5.7000000000; fxg[114] = 5.6030000000; feg[114] = 0.1456000000;
					g[115] = 5.7500000000; fxg[115] = 5.5529000000; feg[115] = 0.1432000000;
					g[116] = 5.8000000000; fxg[116] = 5.5036000000; feg[116] = 0.1409000000;
					g[117] = 5.8500000000; fxg[117] = 5.4560000000; feg[117] = 0.1386000000;
					g[118] = 5.9000000000; fxg[118] = 5.4115000000; feg[118] = 0.1364000000;
					g[119] = 5.9500000000; fxg[119] = 5.3714000000; feg[119] = 0.1342000000;
					g[120] = 6.0000000000; fxg[120] = 5.3344000000; feg[120] = 0.1321000000;
					g[121] = 6.0500000000; fxg[121] = 5.2976000000; feg[121] = 0.1300000000;
					g[122] = 6.1000000000; fxg[122] = 5.2587000000; feg[122] = 0.1280000000;
					g[123] = 6.1500000000; fxg[123] = 5.2178000000; feg[123] = 0.1260000000;
					g[124] = 6.2000000000; fxg[124] = 5.1768000000; feg[124] = 0.1241000000;
					g[125] = 6.2500000000; fxg[125] = 5.1377000000; feg[125] = 0.1222000000;
					g[126] = 6.3000000000; fxg[126] = 5.1000000000; feg[126] = 0.1204000000;
					g[127] = 6.3500000000; fxg[127] = 5.0625000000; feg[127] = 0.1186000000;
					g[128] = 6.4000000000; fxg[128] = 5.0251000000; feg[128] = 0.1168000000;
					g[129] = 6.4500000000; fxg[129] = 4.9889000000; feg[129] = 0.1151000000;
					g[130] = 6.5000000000; fxg[130] = 4.9548000000; feg[130] = 0.1134000000;
					g[131] = 6.5500000000; fxg[131] = 4.9240000000; feg[131] = 0.1117000000;
					g[132] = 6.6000000000; fxg[132] = 4.8966000000; feg[132] = 0.1101000000;
					g[133] = 6.6500000000; fxg[133] = 4.8704000000; feg[133] = 0.1085000000;
					g[134] = 6.7000000000; fxg[134] = 4.8427000000; feg[134] = 0.1070000000;
					g[135] = 6.7500000000; fxg[135] = 4.8124000000; feg[135] = 0.1055000000;
					g[136] = 6.8000000000; fxg[136] = 4.7796000000; feg[136] = 0.1040000000;
					g[137] = 6.8500000000; fxg[137] = 4.7459000000; feg[137] = 0.1025000000;
					g[138] = 6.9000000000; fxg[138] = 4.7130000000; feg[138] = 0.1011000000;
					g[139] = 6.9500000000; fxg[139] = 4.6810000000; feg[139] = 0.0997000000;
					g[140] = 7.0000000000; fxg[140] = 4.6486000000; feg[140] = 0.0984000000;
					g[141] = 7.0500000000; fxg[141] = 4.6157000000; feg[141] = 0.0970000000;
					g[142] = 7.1000000000; fxg[142] = 4.5838000000; feg[142] = 0.0957000000;
					g[143] = 7.1500000000; fxg[143] = 4.5534000000; feg[143] = 0.0945000000;
					g[144] = 7.2000000000; fxg[144] = 4.5250000000; feg[144] = 0.0932000000;
					g[145] = 7.2500000000; fxg[145] = 4.4997000000; feg[145] = 0.0920000000;
					g[146] = 7.3000000000; fxg[146] = 4.4771000000; feg[146] = 0.0908000000;
					g[147] = 7.3500000000; fxg[147] = 4.4552000000; feg[147] = 0.0896000000;
					g[148] = 7.4000000000; fxg[148] = 4.4314000000; feg[148] = 0.0884000000;
					g[149] = 7.4500000000; fxg[149] = 4.4051000000; feg[149] = 0.0873000000;
					g[150] = 7.5000000000; fxg[150] = 4.3760000000; feg[150] = 0.0862000000;
					g[151] = 7.5500000000; fxg[151] = 4.3449000000; feg[151] = 0.0851000000;
					g[152] = 7.6000000000; fxg[152] = 4.3136000000; feg[152] = 0.0840000000;
					g[153] = 7.6500000000; fxg[153] = 4.2829000000; feg[153] = 0.0830000000;
					g[154] = 7.7000000000; fxg[154] = 4.2521000000; feg[154] = 0.0819000000;
					g[155] = 7.7500000000; fxg[155] = 4.2203000000; feg[155] = 0.0809000000;
					g[156] = 7.8000000000; fxg[156] = 4.1884000000; feg[156] = 0.0800000000;
					g[157] = 7.8500000000; fxg[157] = 4.1578000000; feg[157] = 0.0790000000;
					g[158] = 7.9000000000; fxg[158] = 4.1288000000; feg[158] = 0.0780000000;
					g[159] = 7.9500000000; fxg[159] = 4.1016000000; feg[159] = 0.0771000000;
					g[160] = 8.0000000000; fxg[160] = 4.0771000000; feg[160] = 0.0762000000;
					g[161] = 8.0500000000; fxg[161] = 4.0555000000; feg[161] = 0.0753000000;
					g[162] = 8.1000000000; fxg[162] = 4.0352000000; feg[162] = 0.0744000000;
					g[163] = 8.1500000000; fxg[163] = 4.0137000000; feg[163] = 0.0735000000;
					g[164] = 8.2000000000; fxg[164] = 3.9901000000; feg[164] = 0.0726000000;
					g[165] = 8.2500000000; fxg[165] = 3.9641000000; feg[165] = 0.0718000000;
					g[166] = 8.3000000000; fxg[166] = 3.9354000000; feg[166] = 0.0710000000;
					g[167] = 8.3500000000; fxg[167] = 3.9049000000; feg[167] = 0.0702000000;
					g[168] = 8.4000000000; fxg[168] = 3.8741000000; feg[168] = 0.0694000000;
					g[169] = 8.4500000000; fxg[169] = 3.8440000000; feg[169] = 0.0686000000;
					g[170] = 8.5000000000; fxg[170] = 3.8136000000; feg[170] = 0.0678000000;
					g[171] = 8.5500000000; fxg[171] = 3.7822000000; feg[171] = 0.0671000000;
					g[172] = 8.6000000000; fxg[172] = 3.7504000000; feg[172] = 0.0663000000;
					g[173] = 8.6500000000; fxg[173] = 3.7195000000; feg[173] = 0.0656000000;
					g[174] = 8.7000000000; fxg[174] = 3.6904000000; feg[174] = 0.0649000000;
					g[175] = 8.7500000000; fxg[175] = 3.6629000000; feg[175] = 0.0642000000;
					g[176] = 8.8000000000; fxg[176] = 3.6372000000; feg[176] = 0.0635000000;
					g[177] = 8.8500000000; fxg[177] = 3.6143000000; feg[177] = 0.0628000000;
					g[178] = 8.9000000000; fxg[178] = 3.5941000000; feg[178] = 0.0621000000;
					g[179] = 8.9500000000; fxg[179] = 3.5752000000; feg[179] = 0.0615000000;
					g[180] = 9.0000000000; fxg[180] = 3.5551000000; feg[180] = 0.0608000000;
					g[181] = 9.0500000000; fxg[181] = 3.5329000000; feg[181] = 0.0602000000;
					g[182] = 9.1000000000; fxg[182] = 3.5089000000; feg[182] = 0.0595000000;
					g[183] = 9.1500000000; fxg[183] = 3.4826000000; feg[183] = 0.0589000000;
					g[184] = 9.2000000000; fxg[184] = 3.4539000000; feg[184] = 0.0583000000;
					g[185] = 9.2500000000; fxg[185] = 3.4243000000; feg[185] = 0.0577000000;
					g[186] = 9.3000000000; fxg[186] = 3.3952000000; feg[186] = 0.0571000000;
					g[187] = 9.3500000000; fxg[187] = 3.3667000000; feg[187] = 0.0565000000;
					g[188] = 9.4000000000; fxg[188] = 3.3379000000; feg[188] = 0.0560000000;
					g[189] = 9.4500000000; fxg[189] = 3.3081000000; feg[189] = 0.0554000000;
					g[190] = 9.5000000000; fxg[190] = 3.2777000000; feg[190] = 0.0549000000;
					g[191] = 9.5500000000; fxg[191] = 3.2483000000; feg[191] = 0.0543000000;
					g[192] = 9.6000000000; fxg[192] = 3.2206000000; feg[192] = 0.0538000000;
					g[193] = 9.6500000000; fxg[193] = 3.1942000000; feg[193] = 0.0533000000;
					g[194] = 9.7000000000; fxg[194] = 3.1693000000; feg[194] = 0.0527000000;
					g[195] = 9.7500000000; fxg[195] = 3.1469000000; feg[195] = 0.0522000000;
					g[196] = 9.8000000000; fxg[196] = 3.1274000000; feg[196] = 0.0517000000;
					g[197] = 9.8500000000; fxg[197] = 3.1103000000; feg[197] = 0.0512000000;
					g[198] = 9.9000000000; fxg[198] = 3.0938000000; feg[198] = 0.0507000000;
					g[199] = 9.9500000000; fxg[199] = 3.0758000000; feg[199] = 0.0502000000;
					g[200] = 10.0000000000; fxg[200] = 3.0558000000; feg[200] = 0.0497000000;
					g[201] = 10.0500000000; fxg[201] = 3.0343000000; feg[201] = 0.0493000000;
					g[202] = 10.1000000000; fxg[202] = 3.0108000000; feg[202] = 0.0488000000;
					g[203] = 10.1500000000; fxg[203] = 2.9851000000; feg[203] = 0.0483000000;
					g[204] = 10.2000000000; fxg[204] = 2.9581000000; feg[204] = 0.0479000000;
					g[205] = 10.2500000000; fxg[205] = 2.9315000000; feg[205] = 0.0474000000;
					g[206] = 10.3000000000; fxg[206] = 2.9061000000; feg[206] = 0.0470000000;
					g[207] = 10.3500000000; fxg[207] = 2.8813000000; feg[207] = 0.0466000000;
					g[208] = 10.4000000000; fxg[208] = 2.8560000000; feg[208] = 0.0462000000;
					g[209] = 10.4500000000; fxg[209] = 2.8297000000; feg[209] = 0.0457000000;
					g[210] = 10.5000000000; fxg[210] = 2.8028000000; feg[210] = 0.0453000000;
					g[211] = 10.5500000000; fxg[211] = 2.7767000000; feg[211] = 0.0449000000;
					g[212] = 10.6000000000; fxg[212] = 2.7519000000; feg[212] = 0.0445000000;
					g[213] = 10.6500000000; fxg[213] = 2.7282000000; feg[213] = 0.0441000000;
					g[214] = 10.7000000000; fxg[214] = 2.7058000000; feg[214] = 0.0437000000;
					g[215] = 10.7500000000; fxg[215] = 2.6854000000; feg[215] = 0.0433000000;
					g[216] = 10.8000000000; fxg[216] = 2.6678000000; feg[216] = 0.0430000000;
					g[217] = 10.8500000000; fxg[217] = 2.6530000000; feg[217] = 0.0426000000;
					g[218] = 10.9000000000; fxg[218] = 2.6402000000; feg[218] = 0.0422000000;
					g[219] = 10.9500000000; fxg[219] = 2.6275000000; feg[219] = 0.0418000000;
					g[220] = 11.0000000000; fxg[220] = 2.6130000000; feg[220] = 0.0414000000;
					g[221] = 11.0500000000; fxg[221] = 2.5963000000; feg[221] = 0.0411000000;
					g[222] = 11.1000000000; fxg[222] = 2.5782000000; feg[222] = 0.0407000000;
					g[223] = 11.1500000000; fxg[223] = 2.5585000000; feg[223] = 0.0404000000;
					g[224] = 11.2000000000; fxg[224] = 2.5366000000; feg[224] = 0.0400000000;
					g[225] = 11.2500000000; fxg[225] = 2.5134000000; feg[225] = 0.0397000000;
					g[226] = 11.3000000000; fxg[226] = 2.4903000000; feg[226] = 0.0394000000;
					g[227] = 11.3500000000; fxg[227] = 2.4687000000; feg[227] = 0.0390000000;
					g[228] = 11.4000000000; fxg[228] = 2.4485000000; feg[228] = 0.0387000000;
					g[229] = 11.4500000000; fxg[229] = 2.4287000000; feg[229] = 0.0384000000;
					g[230] = 11.5000000000; fxg[230] = 2.4087000000; feg[230] = 0.0381000000;
					g[231] = 11.5500000000; fxg[231] = 2.3876000000; feg[231] = 0.0378000000;
					g[232] = 11.6000000000; fxg[232] = 2.3656000000; feg[232] = 0.0374000000;
					g[233] = 11.6500000000; fxg[233] = 2.3439000000; feg[233] = 0.0371000000;
					g[234] = 11.7000000000; fxg[234] = 2.3230000000; feg[234] = 0.0368000000;
					g[235] = 11.7500000000; fxg[235] = 2.3029000000; feg[235] = 0.0365000000;
					g[236] = 11.8000000000; fxg[236] = 2.2835000000; feg[236] = 0.0362000000;
					g[237] = 11.8500000000; fxg[237] = 2.2658000000; feg[237] = 0.0360000000;
					g[238] = 11.9000000000; fxg[238] = 2.2506000000; feg[238] = 0.0357000000;
					g[239] = 11.9500000000; fxg[239] = 2.2382000000; feg[239] = 0.0354000000;
					g[240] = 12.0000000000; fxg[240] = 2.2285000000; feg[240] = 0.0351000000;
					break;
				case 56:
					g[0] = 0.0000000000; fxg[0] = 56.0000000000; feg[0] = 18.2696000000;
					g[1] = 0.0500000000; fxg[1] = 55.5406000000; feg[1] = 17.5904000000;
					g[2] = 0.1000000000; fxg[2] = 54.3439000000; feg[2] = 15.8546000000;
					g[3] = 0.1500000000; fxg[3] = 52.7788000000; feg[3] = 13.7056000000;
					g[4] = 0.2000000000; fxg[4] = 51.1217000000; feg[4] = 11.6757000000;
					g[5] = 0.2500000000; fxg[5] = 49.4733000000; feg[5] = 9.9972000000;
					g[6] = 0.3000000000; fxg[6] = 47.8384000000; feg[6] = 8.6817000000;
					g[7] = 0.3500000000; fxg[7] = 46.2070000000; feg[7] = 7.6533000000;
					g[8] = 0.4000000000; fxg[8] = 44.5858000000; feg[8] = 6.8296000000;
					g[9] = 0.4500000000; fxg[9] = 42.9944000000; feg[9] = 6.1486000000;
					g[10] = 0.5000000000; fxg[10] = 41.4553000000; feg[10] = 5.5697000000;
					g[11] = 0.5500000000; fxg[11] = 39.9862000000; feg[11] = 5.0680000000;
					g[12] = 0.6000000000; fxg[12] = 38.5971000000; feg[12] = 4.6279000000;
					g[13] = 0.6500000000; fxg[13] = 37.2904000000; feg[13] = 4.2394000000;
					g[14] = 0.7000000000; fxg[14] = 36.0630000000; feg[14] = 3.8952000000;
					g[15] = 0.7500000000; fxg[15] = 34.9081000000; feg[15] = 3.5897000000;
					g[16] = 0.8000000000; fxg[16] = 33.8177000000; feg[16] = 3.3182000000;
					g[17] = 0.8500000000; fxg[17] = 32.7833000000; feg[17] = 3.0763000000;
					g[18] = 0.9000000000; fxg[18] = 31.7975000000; feg[18] = 2.8605000000;
					g[19] = 0.9500000000; fxg[19] = 30.8541000000; feg[19] = 2.6674000000;
					g[20] = 1.0000000000; fxg[20] = 29.9483000000; feg[20] = 2.4940000000;
					g[21] = 1.0500000000; fxg[21] = 29.0768000000; feg[21] = 2.3379000000;
					g[22] = 1.1000000000; fxg[22] = 28.2376000000; feg[22] = 2.1966000000;
					g[23] = 1.1500000000; fxg[23] = 27.4293000000; feg[23] = 2.0682000000;
					g[24] = 1.2000000000; fxg[24] = 26.6517000000; feg[24] = 1.9511000000;
					g[25] = 1.2500000000; fxg[25] = 25.9047000000; feg[25] = 1.8439000000;
					g[26] = 1.3000000000; fxg[26] = 25.1886000000; feg[26] = 1.7454000000;
					g[27] = 1.3500000000; fxg[27] = 24.5037000000; feg[27] = 1.6545000000;
					g[28] = 1.4000000000; fxg[28] = 23.8500000000; feg[28] = 1.5703000000;
					g[29] = 1.4500000000; fxg[29] = 23.2277000000; feg[29] = 1.4922000000;
					g[30] = 1.5000000000; fxg[30] = 22.6366000000; feg[30] = 1.4196000000;
					g[31] = 1.5500000000; fxg[31] = 22.0760000000; feg[31] = 1.3518000000;
					g[32] = 1.6000000000; fxg[32] = 21.5455000000; feg[32] = 1.2885000000;
					g[33] = 1.6500000000; fxg[33] = 21.0441000000; feg[33] = 1.2292000000;
					g[34] = 1.7000000000; fxg[34] = 20.5701000000; feg[34] = 1.1737000000;
					g[35] = 1.7500000000; fxg[35] = 20.1225000000; feg[35] = 1.1215000000;
					g[36] = 1.8000000000; fxg[36] = 19.7002000000; feg[36] = 1.0726000000;
					g[37] = 1.8500000000; fxg[37] = 19.3010000000; feg[37] = 1.0265000000;
					g[38] = 1.9000000000; fxg[38] = 18.9225000000; feg[38] = 0.9833000000;
					g[39] = 1.9500000000; fxg[39] = 18.5640000000; feg[39] = 0.9425000000;
					g[40] = 2.0000000000; fxg[40] = 18.2244000000; feg[40] = 0.9041000000;
					g[41] = 2.0500000000; fxg[41] = 17.9006000000; feg[41] = 0.8679000000;
					g[42] = 2.1000000000; fxg[42] = 17.5900000000; feg[42] = 0.8338000000;
					g[43] = 2.1500000000; fxg[43] = 17.2927000000; feg[43] = 0.8017000000;
					g[44] = 2.2000000000; fxg[44] = 17.0084000000; feg[44] = 0.7712000000;
					g[45] = 2.2500000000; fxg[45] = 16.7340000000; feg[45] = 0.7425000000;
					g[46] = 2.3000000000; fxg[46] = 16.4663000000; feg[46] = 0.7155000000;
					g[47] = 2.3500000000; fxg[47] = 16.2056000000; feg[47] = 0.6899000000;
					g[48] = 2.4000000000; fxg[48] = 15.9529000000; feg[48] = 0.6656000000;
					g[49] = 2.4500000000; fxg[49] = 15.7073000000; feg[49] = 0.6426000000;
					g[50] = 2.5000000000; fxg[50] = 15.4652000000; feg[50] = 0.6209000000;
					g[51] = 2.5500000000; fxg[51] = 15.2246000000; feg[51] = 0.6003000000;
					g[52] = 2.6000000000; fxg[52] = 14.9868000000; feg[52] = 0.5808000000;
					g[53] = 2.6500000000; fxg[53] = 14.7539000000; feg[53] = 0.5623000000;
					g[54] = 2.7000000000; fxg[54] = 14.5255000000; feg[54] = 0.5447000000;
					g[55] = 2.7500000000; fxg[55] = 14.2982000000; feg[55] = 0.5279000000;
					g[56] = 2.8000000000; fxg[56] = 14.0700000000; feg[56] = 0.5120000000;
					g[57] = 2.8500000000; fxg[57] = 13.8418000000; feg[57] = 0.4969000000;
					g[58] = 2.9000000000; fxg[58] = 13.6161000000; feg[58] = 0.4825000000;
					g[59] = 2.9500000000; fxg[59] = 13.3948000000; feg[59] = 0.4687000000;
					g[60] = 3.0000000000; fxg[60] = 13.1763000000; feg[60] = 0.4555000000;
					g[61] = 3.0500000000; fxg[61] = 12.9574000000; feg[61] = 0.4430000000;
					g[62] = 3.1000000000; fxg[62] = 12.7372000000; feg[62] = 0.4310000000;
					g[63] = 3.1500000000; fxg[63] = 12.5171000000; feg[63] = 0.4195000000;
					g[64] = 3.2000000000; fxg[64] = 12.2998000000; feg[64] = 0.4086000000;
					g[65] = 3.2500000000; fxg[65] = 12.0873000000; feg[65] = 0.3980000000;
					g[66] = 3.3000000000; fxg[66] = 11.8790000000; feg[66] = 0.3879000000;
					g[67] = 3.3500000000; fxg[67] = 11.6717000000; feg[67] = 0.3781000000;
					g[68] = 3.4000000000; fxg[68] = 11.4639000000; feg[68] = 0.3688000000;
					g[69] = 3.4500000000; fxg[69] = 11.2566000000; feg[69] = 0.3599000000;
					g[70] = 3.5000000000; fxg[70] = 11.0517000000; feg[70] = 0.3513000000;
					g[71] = 3.5500000000; fxg[71] = 10.8510000000; feg[71] = 0.3430000000;
					g[72] = 3.6000000000; fxg[72] = 10.6565000000; feg[72] = 0.3349000000;
					g[73] = 3.6500000000; fxg[73] = 10.4670000000; feg[73] = 0.3272000000;
					g[74] = 3.7000000000; fxg[74] = 10.2794000000; feg[74] = 0.3197000000;
					g[75] = 3.7500000000; fxg[75] = 10.0924000000; feg[75] = 0.3125000000;
					g[76] = 3.8000000000; fxg[76] = 9.9075000000; feg[76] = 0.3056000000;
					g[77] = 3.8500000000; fxg[77] = 9.7258000000; feg[77] = 0.2989000000;
					g[78] = 3.9000000000; fxg[78] = 9.5481000000; feg[78] = 0.2924000000;
					g[79] = 3.9500000000; fxg[79] = 9.3764000000; feg[79] = 0.2861000000;
					g[80] = 4.0000000000; fxg[80] = 9.2119000000; feg[80] = 0.2800000000;
					g[81] = 4.0500000000; fxg[81] = 9.0521000000; feg[81] = 0.2740000000;
					g[82] = 4.1000000000; fxg[82] = 8.8938000000; feg[82] = 0.2683000000;
					g[83] = 4.1500000000; fxg[83] = 8.7370000000; feg[83] = 0.2627000000;
					g[84] = 4.2000000000; fxg[84] = 8.5839000000; feg[84] = 0.2573000000;
					g[85] = 4.2500000000; fxg[85] = 8.4348000000; feg[85] = 0.2521000000;
					g[86] = 4.3000000000; fxg[86] = 8.2895000000; feg[86] = 0.2470000000;
					g[87] = 4.3500000000; fxg[87] = 8.1494000000; feg[87] = 0.2421000000;
					g[88] = 4.4000000000; fxg[88] = 8.0165000000; feg[88] = 0.2373000000;
					g[89] = 4.4500000000; fxg[89] = 7.8900000000; feg[89] = 0.2326000000;
					g[90] = 4.5000000000; fxg[90] = 7.7660000000; feg[90] = 0.2280000000;
					g[91] = 4.5500000000; fxg[91] = 7.6426000000; feg[91] = 0.2236000000;
					g[92] = 4.6000000000; fxg[92] = 7.5218000000; feg[92] = 0.2193000000;
					g[93] = 4.6500000000; fxg[93] = 7.4056000000; feg[93] = 0.2152000000;
					g[94] = 4.7000000000; fxg[94] = 7.2933000000; feg[94] = 0.2111000000;
					g[95] = 4.7500000000; fxg[95] = 7.1838000000; feg[95] = 0.2071000000;
					g[96] = 4.8000000000; fxg[96] = 7.0782000000; feg[96] = 0.2033000000;
					g[97] = 4.8500000000; fxg[97] = 6.9791000000; feg[97] = 0.1995000000;
					g[98] = 4.9000000000; fxg[98] = 6.8867000000; feg[98] = 0.1958000000;
					g[99] = 4.9500000000; fxg[99] = 6.7973000000; feg[99] = 0.1922000000;
					g[100] = 5.0000000000; fxg[100] = 6.7078000000; feg[100] = 0.1888000000;
					g[101] = 5.0500000000; fxg[101] = 6.6185000000; feg[101] = 0.1854000000;
					g[102] = 5.1000000000; fxg[102] = 6.5326000000; feg[102] = 0.1821000000;
					g[103] = 5.1500000000; fxg[103] = 6.4514000000; feg[103] = 0.1788000000;
					g[104] = 5.2000000000; fxg[104] = 6.3730000000; feg[104] = 0.1757000000;
					g[105] = 5.2500000000; fxg[105] = 6.2958000000; feg[105] = 0.1726000000;
					g[106] = 5.3000000000; fxg[106] = 6.2211000000; feg[106] = 0.1697000000;
					g[107] = 5.3500000000; fxg[107] = 6.1516000000; feg[107] = 0.1667000000;
					g[108] = 5.4000000000; fxg[108] = 6.0884000000; feg[108] = 0.1639000000;
					g[109] = 5.4500000000; fxg[109] = 6.0286000000; feg[109] = 0.1611000000;
					g[110] = 5.5000000000; fxg[110] = 5.9681000000; feg[110] = 0.1583000000;
					g[111] = 5.5500000000; fxg[111] = 5.9058000000; feg[111] = 0.1557000000;
					g[112] = 5.6000000000; fxg[112] = 5.8441000000; feg[112] = 0.1531000000;
					g[113] = 5.6500000000; fxg[113] = 5.7861000000; feg[113] = 0.1506000000;
					g[114] = 5.7000000000; fxg[114] = 5.7317000000; feg[114] = 0.1481000000;
					g[115] = 5.7500000000; fxg[115] = 5.6787000000; feg[115] = 0.1457000000;
					g[116] = 5.8000000000; fxg[116] = 5.6255000000; feg[116] = 0.1434000000;
					g[117] = 5.8500000000; fxg[117] = 5.5735000000; feg[117] = 0.1411000000;
					g[118] = 5.9000000000; fxg[118] = 5.5252000000; feg[118] = 0.1388000000;
					g[119] = 5.9500000000; fxg[119] = 5.4823000000; feg[119] = 0.1366000000;
					g[120] = 6.0000000000; fxg[120] = 5.4433000000; feg[120] = 0.1344000000;
					g[121] = 6.0500000000; fxg[121] = 5.4043000000; feg[121] = 0.1323000000;
					g[122] = 6.1000000000; fxg[122] = 5.3622000000; feg[122] = 0.1303000000;
					g[123] = 6.1500000000; fxg[123] = 5.3177000000; feg[123] = 0.1283000000;
					g[124] = 6.2000000000; fxg[124] = 5.2740000000; feg[124] = 0.1263000000;
					g[125] = 6.2500000000; fxg[125] = 5.2335000000; feg[125] = 0.1244000000;
					g[126] = 6.3000000000; fxg[126] = 5.1957000000; feg[126] = 0.1225000000;
					g[127] = 6.3500000000; fxg[127] = 5.1580000000; feg[127] = 0.1207000000;
					g[128] = 6.4000000000; fxg[128] = 5.1194000000; feg[128] = 0.1189000000;
					g[129] = 6.4500000000; fxg[129] = 5.0807000000; feg[129] = 0.1172000000;
					g[130] = 6.5000000000; fxg[130] = 5.0442000000; feg[130] = 0.1155000000;
					g[131] = 6.5500000000; fxg[131] = 5.0119000000; feg[131] = 0.1138000000;
					g[132] = 6.6000000000; fxg[132] = 4.9841000000; feg[132] = 0.1121000000;
					g[133] = 6.6500000000; fxg[133] = 4.9579000000; feg[133] = 0.1105000000;
					g[134] = 6.7000000000; fxg[134] = 4.9296000000; feg[134] = 0.1089000000;
					g[135] = 6.7500000000; fxg[135] = 4.8974000000; feg[135] = 0.1074000000;
					g[136] = 6.8000000000; fxg[136] = 4.8623000000; feg[136] = 0.1059000000;
					g[137] = 6.8500000000; fxg[137] = 4.8273000000; feg[137] = 0.1044000000;
					g[138] = 6.9000000000; fxg[138] = 4.7949000000; feg[138] = 0.1030000000;
					g[139] = 6.9500000000; fxg[139] = 4.7645000000; feg[139] = 0.1015000000;
					g[140] = 7.0000000000; fxg[140] = 4.7341000000; feg[140] = 0.1002000000;
					g[141] = 7.0500000000; fxg[141] = 4.7023000000; feg[141] = 0.0988000000;
					g[142] = 7.1000000000; fxg[142] = 4.6698000000; feg[142] = 0.0975000000;
					g[143] = 7.1500000000; fxg[143] = 4.6380000000; feg[143] = 0.0962000000;
					g[144] = 7.2000000000; fxg[144] = 4.6086000000; feg[144] = 0.0949000000;
					g[145] = 7.2500000000; fxg[145] = 4.5833000000; feg[145] = 0.0936000000;
					g[146] = 7.3000000000; fxg[146] = 4.5616000000; feg[146] = 0.0924000000;
					g[147] = 7.3500000000; fxg[147] = 4.5409000000; feg[147] = 0.0912000000;
					g[148] = 7.4000000000; fxg[148] = 4.5177000000; feg[148] = 0.0900000000;
					g[149] = 7.4500000000; fxg[149] = 4.4906000000; feg[149] = 0.0888000000;
					g[150] = 7.5000000000; fxg[150] = 4.4599000000; feg[150] = 0.0877000000;
					g[151] = 7.5500000000; fxg[151] = 4.4278000000; feg[151] = 0.0866000000;
					g[152] = 7.6000000000; fxg[152] = 4.3970000000; feg[152] = 0.0855000000;
					g[153] = 7.6500000000; fxg[153] = 4.3683000000; feg[153] = 0.0845000000;
					g[154] = 7.7000000000; fxg[154] = 4.3402000000; feg[154] = 0.0834000000;
					g[155] = 7.7500000000; fxg[155] = 4.3109000000; feg[155] = 0.0824000000;
					g[156] = 7.8000000000; fxg[156] = 4.2804000000; feg[156] = 0.0814000000;
					g[157] = 7.8500000000; fxg[157] = 4.2497000000; feg[157] = 0.0804000000;
					g[158] = 7.9000000000; fxg[158] = 4.2199000000; feg[158] = 0.0794000000;
					g[159] = 7.9500000000; fxg[159] = 4.1922000000; feg[159] = 0.0785000000;
					g[160] = 8.0000000000; fxg[160] = 4.1678000000; feg[160] = 0.0775000000;
					g[161] = 8.0500000000; fxg[161] = 4.1473000000; feg[161] = 0.0766000000;
					g[162] = 8.1000000000; fxg[162] = 4.1286000000; feg[162] = 0.0757000000;
					g[163] = 8.1500000000; fxg[163] = 4.1086000000; feg[163] = 0.0748000000;
					g[164] = 8.2000000000; fxg[164] = 4.0854000000; feg[164] = 0.0739000000;
					g[165] = 8.2500000000; fxg[165] = 4.0586000000; feg[165] = 0.0731000000;
					g[166] = 8.3000000000; fxg[166] = 4.0286000000; feg[166] = 0.0722000000;
					g[167] = 8.3500000000; fxg[167] = 3.9975000000; feg[167] = 0.0714000000;
					g[168] = 8.4000000000; fxg[168] = 3.9673000000; feg[168] = 0.0706000000;
					g[169] = 8.4500000000; fxg[169] = 3.9390000000; feg[169] = 0.0698000000;
					g[170] = 8.5000000000; fxg[170] = 3.9111000000; feg[170] = 0.0690000000;
					g[171] = 8.5500000000; fxg[171] = 3.8819000000; feg[171] = 0.0683000000;
					g[172] = 8.6000000000; fxg[172] = 3.8514000000; feg[172] = 0.0675000000;
					g[173] = 8.6500000000; fxg[173] = 3.8210000000; feg[173] = 0.0668000000;
					g[174] = 8.7000000000; fxg[174] = 3.7915000000; feg[174] = 0.0660000000;
					g[175] = 8.7500000000; fxg[175] = 3.7632000000; feg[175] = 0.0653000000;
					g[176] = 8.8000000000; fxg[176] = 3.7371000000; feg[176] = 0.0646000000;
					g[177] = 8.8500000000; fxg[177] = 3.7144000000; feg[177] = 0.0639000000;
					g[178] = 8.9000000000; fxg[178] = 3.6953000000; feg[178] = 0.0632000000;
					g[179] = 8.9500000000; fxg[179] = 3.6777000000; feg[179] = 0.0625000000;
					g[180] = 9.0000000000; fxg[180] = 3.6589000000; feg[180] = 0.0619000000;
					g[181] = 9.0500000000; fxg[181] = 3.6373000000; feg[181] = 0.0612000000;
					g[182] = 9.1000000000; fxg[182] = 3.6129000000; feg[182] = 0.0606000000;
					g[183] = 9.1500000000; fxg[183] = 3.5854000000; feg[183] = 0.0599000000;
					g[184] = 9.2000000000; fxg[184] = 3.5558000000; feg[184] = 0.0593000000;
					g[185] = 9.2500000000; fxg[185] = 3.5258000000; feg[185] = 0.0587000000;
					g[186] = 9.3000000000; fxg[186] = 3.4972000000; feg[186] = 0.0581000000;
					g[187] = 9.3500000000; fxg[187] = 3.4701000000; feg[187] = 0.0575000000;
					g[188] = 9.4000000000; fxg[188] = 3.4428000000; feg[188] = 0.0569000000;
					g[189] = 9.4500000000; fxg[189] = 3.4139000000; feg[189] = 0.0564000000;
					g[190] = 9.5000000000; fxg[190] = 3.3840000000; feg[190] = 0.0558000000;
					g[191] = 9.5500000000; fxg[191] = 3.3546000000; feg[191] = 0.0553000000;
					g[192] = 9.6000000000; fxg[192] = 3.3265000000; feg[192] = 0.0547000000;
					g[193] = 9.6500000000; fxg[193] = 3.2996000000; feg[193] = 0.0542000000;
					g[194] = 9.7000000000; fxg[194] = 3.2741000000; feg[194] = 0.0536000000;
					g[195] = 9.7500000000; fxg[195] = 3.2512000000; feg[195] = 0.0531000000;
					g[196] = 9.8000000000; fxg[196] = 3.2317000000; feg[196] = 0.0526000000;
					g[197] = 9.8500000000; fxg[197] = 3.2152000000; feg[197] = 0.0521000000;
					g[198] = 9.9000000000; fxg[198] = 3.1995000000; feg[198] = 0.0516000000;
					g[199] = 9.9500000000; fxg[199] = 3.1822000000; feg[199] = 0.0511000000;
					g[200] = 10.0000000000; fxg[200] = 3.1625000000; feg[200] = 0.0506000000;
					g[201] = 10.0500000000; fxg[201] = 3.1406000000; feg[201] = 0.0501000000;
					g[202] = 10.1000000000; fxg[202] = 3.1164000000; feg[202] = 0.0496000000;
					g[203] = 10.1500000000; fxg[203] = 3.0897000000; feg[203] = 0.0492000000;
					g[204] = 10.2000000000; fxg[204] = 3.0618000000; feg[204] = 0.0487000000;
					g[205] = 10.2500000000; fxg[205] = 3.0349000000; feg[205] = 0.0483000000;
					g[206] = 10.3000000000; fxg[206] = 3.0097000000; feg[206] = 0.0478000000;
					g[207] = 10.3500000000; fxg[207] = 2.9854000000; feg[207] = 0.0474000000;
					g[208] = 10.4000000000; fxg[208] = 2.9603000000; feg[208] = 0.0469000000;
					g[209] = 10.4500000000; fxg[209] = 2.9336000000; feg[209] = 0.0465000000;
					g[210] = 10.5000000000; fxg[210] = 2.9061000000; feg[210] = 0.0461000000;
					g[211] = 10.5500000000; fxg[211] = 2.8794000000; feg[211] = 0.0457000000;
					g[212] = 10.6000000000; fxg[212] = 2.8543000000; feg[212] = 0.0453000000;
					g[213] = 10.6500000000; fxg[213] = 2.8303000000; feg[213] = 0.0449000000;
					g[214] = 10.7000000000; fxg[214] = 2.8073000000; feg[214] = 0.0445000000;
					g[215] = 10.7500000000; fxg[215] = 2.7861000000; feg[215] = 0.0441000000;
					g[216] = 10.8000000000; fxg[216] = 2.7678000000; feg[216] = 0.0437000000;
					g[217] = 10.8500000000; fxg[217] = 2.7528000000; feg[217] = 0.0433000000;
					g[218] = 10.9000000000; fxg[218] = 2.7402000000; feg[218] = 0.0429000000;
					g[219] = 10.9500000000; fxg[219] = 2.7275000000; feg[219] = 0.0425000000;
					g[220] = 11.0000000000; fxg[220] = 2.7129000000; feg[220] = 0.0422000000;
					g[221] = 11.0500000000; fxg[221] = 2.6961000000; feg[221] = 0.0418000000;
					g[222] = 11.1000000000; fxg[222] = 2.6778000000; feg[222] = 0.0414000000;
					g[223] = 11.1500000000; fxg[223] = 2.6577000000; feg[223] = 0.0411000000;
					g[224] = 11.2000000000; fxg[224] = 2.6352000000; feg[224] = 0.0407000000;
					g[225] = 11.2500000000; fxg[225] = 2.6111000000; feg[225] = 0.0404000000;
					g[226] = 11.3000000000; fxg[226] = 2.5872000000; feg[226] = 0.0400000000;
					g[227] = 11.3500000000; fxg[227] = 2.5651000000; feg[227] = 0.0397000000;
					g[228] = 11.4000000000; fxg[228] = 2.5446000000; feg[228] = 0.0394000000;
					g[229] = 11.4500000000; fxg[229] = 2.5246000000; feg[229] = 0.0390000000;
					g[230] = 11.5000000000; fxg[230] = 2.5036000000; feg[230] = 0.0387000000;
					g[231] = 11.5500000000; fxg[231] = 2.4811000000; feg[231] = 0.0384000000;
					g[232] = 11.6000000000; fxg[232] = 2.4577000000; feg[232] = 0.0381000000;
					g[233] = 11.6500000000; fxg[233] = 2.4350000000; feg[233] = 0.0378000000;
					g[234] = 11.7000000000; fxg[234] = 2.4138000000; feg[234] = 0.0375000000;
					g[235] = 11.7500000000; fxg[235] = 2.3937000000; feg[235] = 0.0372000000;
					g[236] = 11.8000000000; fxg[236] = 2.3742000000; feg[236] = 0.0369000000;
					g[237] = 11.8500000000; fxg[237] = 2.3558000000; feg[237] = 0.0366000000;
					g[238] = 11.9000000000; fxg[238] = 2.3396000000; feg[238] = 0.0363000000;
					g[239] = 11.9500000000; fxg[239] = 2.3263000000; feg[239] = 0.0360000000;
					g[240] = 12.0000000000; fxg[240] = 2.3161000000; feg[240] = 0.0357000000;
					break;
				case 57:
					g[0] = 0.0000000000; fxg[0] = 57.0000000000; feg[0] = 17.8058000000;
					g[1] = 0.0500000000; fxg[1] = 56.5496000000; feg[1] = 17.2474000000;
					g[2] = 0.1000000000; fxg[2] = 55.3511000000; feg[2] = 15.7857000000;
					g[3] = 0.1500000000; fxg[3] = 53.7342000000; feg[3] = 13.8957000000;
					g[4] = 0.2000000000; fxg[4] = 51.9815000000; feg[4] = 12.0111000000;
					g[5] = 0.2500000000; fxg[5] = 50.2326000000; feg[5] = 10.3660000000;
					g[6] = 0.3000000000; fxg[6] = 48.5224000000; feg[6] = 9.0177000000;
					g[7] = 0.3500000000; fxg[7] = 46.8491000000; feg[7] = 7.9330000000;
					g[8] = 0.4000000000; fxg[8] = 45.2111000000; feg[8] = 7.0538000000;
					g[9] = 0.4500000000; fxg[9] = 43.6162000000; feg[9] = 6.3274000000;
					g[10] = 0.5000000000; fxg[10] = 42.0771000000; feg[10] = 5.7146000000;
					g[11] = 0.5500000000; fxg[11] = 40.6060000000; feg[11] = 5.1884000000;
					g[12] = 0.6000000000; fxg[12] = 39.2112000000; feg[12] = 4.7306000000;
					g[13] = 0.6500000000; fxg[13] = 37.8959000000; feg[13] = 4.3288000000;
					g[14] = 0.7000000000; fxg[14] = 36.6586000000; feg[14] = 3.9742000000;
					g[15] = 0.7500000000; fxg[15] = 35.4944000000; feg[15] = 3.6601000000;
					g[16] = 0.8000000000; fxg[16] = 34.3965000000; feg[16] = 3.3812000000;
					g[17] = 0.8500000000; fxg[17] = 33.3573000000; feg[17] = 3.1328000000;
					g[18] = 0.9000000000; fxg[18] = 32.3694000000; feg[18] = 2.9111000000;
					g[19] = 0.9500000000; fxg[19] = 31.4262000000; feg[19] = 2.7128000000;
					g[20] = 1.0000000000; fxg[20] = 30.5222000000; feg[20] = 2.5348000000;
					g[21] = 1.0500000000; fxg[21] = 29.6530000000; feg[21] = 2.3747000000;
					g[22] = 1.1000000000; fxg[22] = 28.8159000000; feg[22] = 2.2299000000;
					g[23] = 1.1500000000; fxg[23] = 28.0086000000; feg[23] = 2.0987000000;
					g[24] = 1.2000000000; fxg[24] = 27.2302000000; feg[24] = 1.9792000000;
					g[25] = 1.2500000000; fxg[25] = 26.4801000000; feg[25] = 1.8700000000;
					g[26] = 1.3000000000; fxg[26] = 25.7582000000; feg[26] = 1.7698000000;
					g[27] = 1.3500000000; fxg[27] = 25.0648000000; feg[27] = 1.6775000000;
					g[28] = 1.4000000000; fxg[28] = 24.4001000000; feg[28] = 1.5923000000;
					g[29] = 1.4500000000; fxg[29] = 23.7643000000; feg[29] = 1.5133000000;
					g[30] = 1.5000000000; fxg[30] = 23.1575000000; feg[30] = 1.4400000000;
					g[31] = 1.5500000000; fxg[31] = 22.5795000000; feg[31] = 1.3716000000;
					g[32] = 1.6000000000; fxg[32] = 22.0302000000; feg[32] = 1.3077000000;
					g[33] = 1.6500000000; fxg[33] = 21.5091000000; feg[33] = 1.2480000000;
					g[34] = 1.7000000000; fxg[34] = 21.0151000000; feg[34] = 1.1920000000;
					g[35] = 1.7500000000; fxg[35] = 20.5474000000; feg[35] = 1.1395000000;
					g[36] = 1.8000000000; fxg[36] = 20.1053000000; feg[36] = 1.0902000000;
					g[37] = 1.8500000000; fxg[37] = 19.6870000000; feg[37] = 1.0437000000;
					g[38] = 1.9000000000; fxg[38] = 19.2906000000; feg[38] = 1.0000000000;
					g[39] = 1.9500000000; fxg[39] = 18.9154000000; feg[39] = 0.9588000000;
					g[40] = 2.0000000000; fxg[40] = 18.5602000000; feg[40] = 0.9200000000;
					g[41] = 2.0500000000; fxg[41] = 18.2224000000; feg[41] = 0.8834000000;
					g[42] = 2.1000000000; fxg[42] = 17.9000000000; feg[42] = 0.8488000000;
					g[43] = 2.1500000000; fxg[43] = 17.5926000000; feg[43] = 0.8162000000;
					g[44] = 2.2000000000; fxg[44] = 17.2994000000; feg[44] = 0.7853000000;
					g[45] = 2.2500000000; fxg[45] = 17.0177000000; feg[45] = 0.7561000000;
					g[46] = 2.3000000000; fxg[46] = 16.7449000000; feg[46] = 0.7285000000;
					g[47] = 2.3500000000; fxg[47] = 16.4808000000; feg[47] = 0.7024000000;
					g[48] = 2.4000000000; fxg[48] = 16.2260000000; feg[48] = 0.6777000000;
					g[49] = 2.4500000000; fxg[49] = 15.9790000000; feg[49] = 0.6542000000;
					g[50] = 2.5000000000; fxg[50] = 15.7370000000; feg[50] = 0.6320000000;
					g[51] = 2.5500000000; fxg[51] = 15.4982000000; feg[51] = 0.6110000000;
					g[52] = 2.6000000000; fxg[52] = 15.2632000000; feg[52] = 0.5911000000;
					g[53] = 2.6500000000; fxg[53] = 15.0336000000; feg[53] = 0.5721000000;
					g[54] = 2.7000000000; fxg[54] = 14.8087000000; feg[54] = 0.5541000000;
					g[55] = 2.7500000000; fxg[55] = 14.5855000000; feg[55] = 0.5369000000;
					g[56] = 2.8000000000; fxg[56] = 14.3622000000; feg[56] = 0.5207000000;
					g[57] = 2.8500000000; fxg[57] = 14.1395000000; feg[57] = 0.5052000000;
					g[58] = 2.9000000000; fxg[58] = 13.9195000000; feg[58] = 0.4904000000;
					g[59] = 2.9500000000; fxg[59] = 13.7035000000; feg[59] = 0.4763000000;
					g[60] = 3.0000000000; fxg[60] = 13.4899000000; feg[60] = 0.4628000000;
					g[61] = 3.0500000000; fxg[61] = 13.2761000000; feg[61] = 0.4500000000;
					g[62] = 3.1000000000; fxg[62] = 13.0609000000; feg[62] = 0.4377000000;
					g[63] = 3.1500000000; fxg[63] = 12.8457000000; feg[63] = 0.4260000000;
					g[64] = 3.2000000000; fxg[64] = 12.6330000000; feg[64] = 0.4148000000;
					g[65] = 3.2500000000; fxg[65] = 12.4245000000; feg[65] = 0.4040000000;
					g[66] = 3.3000000000; fxg[66] = 12.2195000000; feg[66] = 0.3937000000;
					g[67] = 3.3500000000; fxg[67] = 12.0152000000; feg[67] = 0.3837000000;
					g[68] = 3.4000000000; fxg[68] = 11.8099000000; feg[68] = 0.3742000000;
					g[69] = 3.4500000000; fxg[69] = 11.6045000000; feg[69] = 0.3651000000;
					g[70] = 3.5000000000; fxg[70] = 11.4010000000; feg[70] = 0.3564000000;
					g[71] = 3.5500000000; fxg[71] = 11.2015000000; feg[71] = 0.3479000000;
					g[72] = 3.6000000000; fxg[72] = 11.0074000000; feg[72] = 0.3397000000;
					g[73] = 3.6500000000; fxg[73] = 10.8178000000; feg[73] = 0.3319000000;
					g[74] = 3.7000000000; fxg[74] = 10.6296000000; feg[74] = 0.3243000000;
					g[75] = 3.7500000000; fxg[75] = 10.4414000000; feg[75] = 0.3170000000;
					g[76] = 3.8000000000; fxg[76] = 10.2544000000; feg[76] = 0.3099000000;
					g[77] = 3.8500000000; fxg[77] = 10.0700000000; feg[77] = 0.3031000000;
					g[78] = 3.9000000000; fxg[78] = 9.8895000000; feg[78] = 0.2965000000;
					g[79] = 3.9500000000; fxg[79] = 9.7150000000; feg[79] = 0.2901000000;
					g[80] = 4.0000000000; fxg[80] = 9.5470000000; feg[80] = 0.2839000000;
					g[81] = 4.0500000000; fxg[81] = 9.3833000000; feg[81] = 0.2779000000;
					g[82] = 4.1000000000; fxg[82] = 9.2210000000; feg[82] = 0.2721000000;
					g[83] = 4.1500000000; fxg[83] = 9.0597000000; feg[83] = 0.2665000000;
					g[84] = 4.2000000000; fxg[84] = 8.9010000000; feg[84] = 0.2610000000;
					g[85] = 4.2500000000; fxg[85] =