# coding: utf-8

"""
    API REST FactPulse

     API REST pour la facturation électronique en France : Factur-X, AFNOR PDP/PA, signatures électroniques.  ## 🎯 Fonctionnalités principales  ### 📄 Génération de factures Factur-X - **Formats** : XML seul ou PDF/A-3 avec XML embarqué - **Profils** : MINIMUM, BASIC, EN16931, EXTENDED - **Normes** : EN 16931 (directive UE 2014/55), ISO 19005-3 (PDF/A-3), CII (UN/CEFACT) - **🆕 Format simplifié** : Génération à partir de SIRET + auto-enrichissement (API Chorus Pro + Recherche Entreprises)  ### ✅ Validation et conformité - **Validation XML** : Schematron (45 à 210+ règles selon profil) - **Validation PDF** : PDF/A-3, métadonnées XMP Factur-X, signatures électroniques - **VeraPDF** : Validation stricte PDF/A (146+ règles ISO 19005-3) - **Traitement asynchrone** : Support Celery pour validations lourdes (VeraPDF)  ### 📡 Intégration AFNOR PDP/PA (XP Z12-013) - **Soumission de flux** : Envoi de factures vers Plateformes de Dématérialisation Partenaires - **Recherche de flux** : Consultation des factures soumises - **Téléchargement** : Récupération des PDF/A-3 avec XML - **Directory Service** : Recherche d'entreprises (SIREN/SIRET) - **Multi-client** : Support de plusieurs configs PDP par utilisateur (stored credentials ou zero-storage)  ### ✍️ Signature électronique PDF - **Standards** : PAdES-B-B, PAdES-B-T (horodatage RFC 3161), PAdES-B-LT (archivage long terme) - **Niveaux eIDAS** : SES (auto-signé), AdES (CA commerciale), QES (PSCO) - **Validation** : Vérification intégrité cryptographique et certificats - **Génération de certificats** : Certificats X.509 auto-signés pour tests  ### 🔄 Traitement asynchrone - **Celery** : Génération, validation et signature asynchrones - **Polling** : Suivi d'état via `/taches/{id_tache}/statut` - **Pas de timeout** : Idéal pour gros fichiers ou validations lourdes  ## 🔒 Authentification  Toutes les requêtes nécessitent un **token JWT** dans le header Authorization : ``` Authorization: Bearer YOUR_JWT_TOKEN ```  ### Comment obtenir un token JWT ?  #### 🔑 Méthode 1 : API `/api/token/` (Recommandée)  **URL :** `https://www.factpulse.fr/api/token/`  Cette méthode est **recommandée** pour l'intégration dans vos applications et workflows CI/CD.  **Prérequis :** Avoir défini un mot de passe sur votre compte  **Pour les utilisateurs inscrits via email/password :** - Vous avez déjà un mot de passe, utilisez-le directement  **Pour les utilisateurs inscrits via OAuth (Google/GitHub) :** - Vous devez d'abord définir un mot de passe sur : https://www.factpulse.fr/accounts/password/set/ - Une fois le mot de passe créé, vous pourrez utiliser l'API  **Exemple de requête :** ```bash curl -X POST https://www.factpulse.fr/api/token/ \\   -H \"Content-Type: application/json\" \\   -d '{     \"username\": \"votre_email@example.com\",     \"password\": \"votre_mot_de_passe\"   }' ```  **Réponse :** ```json {   \"access\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\",  // Token d'accès (validité: 30 min)   \"refresh\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\"  // Token de rafraîchissement (validité: 7 jours) } ```  **Avantages :** - ✅ Automatisation complète (CI/CD, scripts) - ✅ Gestion programmatique des tokens - ✅ Support du refresh token pour renouveler automatiquement l'accès - ✅ Intégration facile dans n'importe quel langage/outil  #### 🖥️ Méthode 2 : Génération via Dashboard (Alternative)  **URL :** https://www.factpulse.fr/dashboard/  Cette méthode convient pour des tests rapides ou une utilisation occasionnelle via l'interface graphique.  **Fonctionnement :** - Connectez-vous au dashboard - Utilisez les boutons \"Generate Test Token\" ou \"Generate Production Token\" - Fonctionne pour **tous** les utilisateurs (OAuth et email/password), sans nécessiter de mot de passe  **Types de tokens :** - **Token Test** : Validité 24h, quota 1000 appels/jour (gratuit) - **Token Production** : Validité 7 jours, quota selon votre forfait  **Avantages :** - ✅ Rapide pour tester l'API - ✅ Aucun mot de passe requis - ✅ Interface visuelle simple  **Inconvénients :** - ❌ Nécessite une action manuelle - ❌ Pas de refresh token - ❌ Moins adapté pour l'automatisation  ### 📚 Documentation complète  Pour plus d'informations sur l'authentification et l'utilisation de l'API : https://www.factpulse.fr/documentation-api/     

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from factpulse.models.categorie_tva import CategorieTVA
from factpulse.models.code_raison_reduction import CodeRaisonReduction
from factpulse.models.ligne_de_poste_montant_remise_ht import LigneDePosteMontantRemiseHt
from factpulse.models.ligne_de_poste_montant_total_ligne_ht import LigneDePosteMontantTotalLigneHt
from factpulse.models.ligne_de_poste_taux_tva_manuel import LigneDePosteTauxTvaManuel
from factpulse.models.montantunitaireht import Montantunitaireht
from factpulse.models.quantite import Quantite
from factpulse.models.unite import Unite
from typing import Optional, Set
from typing_extensions import Self

class LigneDePoste(BaseModel):
    """
    Représente une ligne de détail dans une facture.
    """ # noqa: E501
    numero: StrictInt
    reference: Optional[StrictStr] = None
    denomination: StrictStr
    quantite: Quantite
    unite: Unite
    montant_unitaire_ht: Montantunitaireht = Field(alias="montantUnitaireHt")
    montant_remise_ht: Optional[LigneDePosteMontantRemiseHt] = Field(default=None, alias="montantRemiseHt")
    montant_total_ligne_ht: Optional[LigneDePosteMontantTotalLigneHt] = Field(default=None, alias="montantTotalLigneHt")
    taux_tva: Optional[StrictStr] = Field(default=None, alias="tauxTva")
    taux_tva_manuel: Optional[LigneDePosteTauxTvaManuel] = Field(default=None, alias="tauxTvaManuel")
    categorie_tva: Optional[CategorieTVA] = Field(default=None, alias="categorieTva")
    date_debut_periode: Optional[StrictStr] = Field(default=None, alias="dateDebutPeriode")
    date_fin_periode: Optional[StrictStr] = Field(default=None, alias="dateFinPeriode")
    code_raison_reduction: Optional[CodeRaisonReduction] = Field(default=None, alias="codeRaisonReduction")
    raison_reduction: Optional[StrictStr] = Field(default=None, alias="raisonReduction")
    __properties: ClassVar[List[str]] = ["numero", "reference", "denomination", "quantite", "unite", "montantUnitaireHt", "montantRemiseHt", "montantTotalLigneHt", "tauxTva", "tauxTvaManuel", "categorieTva", "dateDebutPeriode", "dateFinPeriode", "codeRaisonReduction", "raisonReduction"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LigneDePoste from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of quantite
        if self.quantite:
            _dict['quantite'] = self.quantite.to_dict()
        # override the default output from pydantic by calling `to_dict()` of montant_unitaire_ht
        if self.montant_unitaire_ht:
            _dict['montantUnitaireHt'] = self.montant_unitaire_ht.to_dict()
        # override the default output from pydantic by calling `to_dict()` of montant_remise_ht
        if self.montant_remise_ht:
            _dict['montantRemiseHt'] = self.montant_remise_ht.to_dict()
        # override the default output from pydantic by calling `to_dict()` of montant_total_ligne_ht
        if self.montant_total_ligne_ht:
            _dict['montantTotalLigneHt'] = self.montant_total_ligne_ht.to_dict()
        # override the default output from pydantic by calling `to_dict()` of taux_tva_manuel
        if self.taux_tva_manuel:
            _dict['tauxTvaManuel'] = self.taux_tva_manuel.to_dict()
        # set to None if reference (nullable) is None
        # and model_fields_set contains the field
        if self.reference is None and "reference" in self.model_fields_set:
            _dict['reference'] = None

        # set to None if montant_remise_ht (nullable) is None
        # and model_fields_set contains the field
        if self.montant_remise_ht is None and "montant_remise_ht" in self.model_fields_set:
            _dict['montantRemiseHt'] = None

        # set to None if montant_total_ligne_ht (nullable) is None
        # and model_fields_set contains the field
        if self.montant_total_ligne_ht is None and "montant_total_ligne_ht" in self.model_fields_set:
            _dict['montantTotalLigneHt'] = None

        # set to None if taux_tva (nullable) is None
        # and model_fields_set contains the field
        if self.taux_tva is None and "taux_tva" in self.model_fields_set:
            _dict['tauxTva'] = None

        # set to None if taux_tva_manuel (nullable) is None
        # and model_fields_set contains the field
        if self.taux_tva_manuel is None and "taux_tva_manuel" in self.model_fields_set:
            _dict['tauxTvaManuel'] = None

        # set to None if categorie_tva (nullable) is None
        # and model_fields_set contains the field
        if self.categorie_tva is None and "categorie_tva" in self.model_fields_set:
            _dict['categorieTva'] = None

        # set to None if date_debut_periode (nullable) is None
        # and model_fields_set contains the field
        if self.date_debut_periode is None and "date_debut_periode" in self.model_fields_set:
            _dict['dateDebutPeriode'] = None

        # set to None if date_fin_periode (nullable) is None
        # and model_fields_set contains the field
        if self.date_fin_periode is None and "date_fin_periode" in self.model_fields_set:
            _dict['dateFinPeriode'] = None

        # set to None if code_raison_reduction (nullable) is None
        # and model_fields_set contains the field
        if self.code_raison_reduction is None and "code_raison_reduction" in self.model_fields_set:
            _dict['codeRaisonReduction'] = None

        # set to None if raison_reduction (nullable) is None
        # and model_fields_set contains the field
        if self.raison_reduction is None and "raison_reduction" in self.model_fields_set:
            _dict['raisonReduction'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LigneDePoste from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "numero": obj.get("numero"),
            "reference": obj.get("reference"),
            "denomination": obj.get("denomination"),
            "quantite": Quantite.from_dict(obj["quantite"]) if obj.get("quantite") is not None else None,
            "unite": obj.get("unite"),
            "montantUnitaireHt": Montantunitaireht.from_dict(obj["montantUnitaireHt"]) if obj.get("montantUnitaireHt") is not None else None,
            "montantRemiseHt": LigneDePosteMontantRemiseHt.from_dict(obj["montantRemiseHt"]) if obj.get("montantRemiseHt") is not None else None,
            "montantTotalLigneHt": LigneDePosteMontantTotalLigneHt.from_dict(obj["montantTotalLigneHt"]) if obj.get("montantTotalLigneHt") is not None else None,
            "tauxTva": obj.get("tauxTva"),
            "tauxTvaManuel": LigneDePosteTauxTvaManuel.from_dict(obj["tauxTvaManuel"]) if obj.get("tauxTvaManuel") is not None else None,
            "categorieTva": obj.get("categorieTva"),
            "dateDebutPeriode": obj.get("dateDebutPeriode"),
            "dateFinPeriode": obj.get("dateFinPeriode"),
            "codeRaisonReduction": obj.get("codeRaisonReduction"),
            "raisonReduction": obj.get("raisonReduction")
        })
        return _obj


