# coding: utf-8

"""
    API REST FactPulse

     API REST pour la facturation électronique en France : Factur-X, AFNOR PDP/PA, signatures électroniques.  ## 🎯 Fonctionnalités principales  ### 📄 Génération de factures Factur-X - **Formats** : XML seul ou PDF/A-3 avec XML embarqué - **Profils** : MINIMUM, BASIC, EN16931, EXTENDED - **Normes** : EN 16931 (directive UE 2014/55), ISO 19005-3 (PDF/A-3), CII (UN/CEFACT) - **🆕 Format simplifié** : Génération à partir de SIRET + auto-enrichissement (API Chorus Pro + Recherche Entreprises)  ### ✅ Validation et conformité - **Validation XML** : Schematron (45 à 210+ règles selon profil) - **Validation PDF** : PDF/A-3, métadonnées XMP Factur-X, signatures électroniques - **VeraPDF** : Validation stricte PDF/A (146+ règles ISO 19005-3) - **Traitement asynchrone** : Support Celery pour validations lourdes (VeraPDF)  ### 📡 Intégration AFNOR PDP/PA (XP Z12-013) - **Soumission de flux** : Envoi de factures vers Plateformes de Dématérialisation Partenaires - **Recherche de flux** : Consultation des factures soumises - **Téléchargement** : Récupération des PDF/A-3 avec XML - **Directory Service** : Recherche d'entreprises (SIREN/SIRET) - **Multi-client** : Support de plusieurs configs PDP par utilisateur (stored credentials ou zero-storage)  ### ✍️ Signature électronique PDF - **Standards** : PAdES-B-B, PAdES-B-T (horodatage RFC 3161), PAdES-B-LT (archivage long terme) - **Niveaux eIDAS** : SES (auto-signé), AdES (CA commerciale), QES (PSCO) - **Validation** : Vérification intégrité cryptographique et certificats - **Génération de certificats** : Certificats X.509 auto-signés pour tests  ### 🔄 Traitement asynchrone - **Celery** : Génération, validation et signature asynchrones - **Polling** : Suivi d'état via `/taches/{id_tache}/statut` - **Pas de timeout** : Idéal pour gros fichiers ou validations lourdes  ## 🔒 Authentification  Toutes les requêtes nécessitent un **token JWT** dans le header Authorization : ``` Authorization: Bearer YOUR_JWT_TOKEN ```  ### Comment obtenir un token JWT ?  #### 🔑 Méthode 1 : API `/api/token/` (Recommandée)  **URL :** `https://www.factpulse.fr/api/token/`  Cette méthode est **recommandée** pour l'intégration dans vos applications et workflows CI/CD.  **Prérequis :** Avoir défini un mot de passe sur votre compte  **Pour les utilisateurs inscrits via email/password :** - Vous avez déjà un mot de passe, utilisez-le directement  **Pour les utilisateurs inscrits via OAuth (Google/GitHub) :** - Vous devez d'abord définir un mot de passe sur : https://www.factpulse.fr/accounts/password/set/ - Une fois le mot de passe créé, vous pourrez utiliser l'API  **Exemple de requête :** ```bash curl -X POST https://www.factpulse.fr/api/token/ \\   -H \"Content-Type: application/json\" \\   -d '{     \"username\": \"votre_email@example.com\",     \"password\": \"votre_mot_de_passe\"   }' ```  **Réponse :** ```json {   \"access\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\",  // Token d'accès (validité: 30 min)   \"refresh\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\"  // Token de rafraîchissement (validité: 7 jours) } ```  **Avantages :** - ✅ Automatisation complète (CI/CD, scripts) - ✅ Gestion programmatique des tokens - ✅ Support du refresh token pour renouveler automatiquement l'accès - ✅ Intégration facile dans n'importe quel langage/outil  #### 🖥️ Méthode 2 : Génération via Dashboard (Alternative)  **URL :** https://www.factpulse.fr/dashboard/  Cette méthode convient pour des tests rapides ou une utilisation occasionnelle via l'interface graphique.  **Fonctionnement :** - Connectez-vous au dashboard - Utilisez les boutons \"Generate Test Token\" ou \"Generate Production Token\" - Fonctionne pour **tous** les utilisateurs (OAuth et email/password), sans nécessiter de mot de passe  **Types de tokens :** - **Token Test** : Validité 24h, quota 1000 appels/jour (gratuit) - **Token Production** : Validité 7 jours, quota selon votre forfait  **Avantages :** - ✅ Rapide pour tester l'API - ✅ Aucun mot de passe requis - ✅ Interface visuelle simple  **Inconvénients :** - ❌ Nécessite une action manuelle - ❌ Pas de refresh token - ❌ Moins adapté pour l'automatisation  ### 📚 Documentation complète  Pour plus d'informations sur l'authentification et l'utilisation de l'API : https://www.factpulse.fr/documentation-api/     

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from factpulse.models.facture_enrichie_info_output import FactureEnrichieInfoOutput
from factpulse.models.pdf_factur_x_info import PDFFacturXInfo
from factpulse.models.resultat_afnor import ResultatAFNOR
from factpulse.models.resultat_chorus_pro import ResultatChorusPro
from factpulse.models.signature_info import SignatureInfo
from typing import Optional, Set
from typing_extensions import Self

class SoumettreFactureCompleteResponse(BaseModel):
    """
    Réponse complète après soumission automatisée.
    """ # noqa: E501
    succes: StrictBool = Field(description="La facture a été soumise avec succès")
    destination_type: StrictStr = Field(description="Type de destination")
    resultat_chorus: Optional[ResultatChorusPro] = None
    resultat_afnor: Optional[ResultatAFNOR] = None
    facture_enrichie: FactureEnrichieInfoOutput = Field(description="Données de la facture enrichie")
    pdf_facturx: PDFFacturXInfo = Field(description="Informations sur le PDF généré")
    signature: Optional[SignatureInfo] = None
    pdf_base64: StrictStr = Field(description="PDF Factur-X généré (et signé si demandé) encodé en base64")
    message: StrictStr = Field(description="Message de retour")
    __properties: ClassVar[List[str]] = ["succes", "destination_type", "resultat_chorus", "resultat_afnor", "facture_enrichie", "pdf_facturx", "signature", "pdf_base64", "message"]

    @field_validator('destination_type')
    def destination_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['chorus_pro', 'afnor']):
            raise ValueError("must be one of enum values ('chorus_pro', 'afnor')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SoumettreFactureCompleteResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resultat_chorus
        if self.resultat_chorus:
            _dict['resultat_chorus'] = self.resultat_chorus.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resultat_afnor
        if self.resultat_afnor:
            _dict['resultat_afnor'] = self.resultat_afnor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of facture_enrichie
        if self.facture_enrichie:
            _dict['facture_enrichie'] = self.facture_enrichie.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pdf_facturx
        if self.pdf_facturx:
            _dict['pdf_facturx'] = self.pdf_facturx.to_dict()
        # override the default output from pydantic by calling `to_dict()` of signature
        if self.signature:
            _dict['signature'] = self.signature.to_dict()
        # set to None if resultat_chorus (nullable) is None
        # and model_fields_set contains the field
        if self.resultat_chorus is None and "resultat_chorus" in self.model_fields_set:
            _dict['resultat_chorus'] = None

        # set to None if resultat_afnor (nullable) is None
        # and model_fields_set contains the field
        if self.resultat_afnor is None and "resultat_afnor" in self.model_fields_set:
            _dict['resultat_afnor'] = None

        # set to None if signature (nullable) is None
        # and model_fields_set contains the field
        if self.signature is None and "signature" in self.model_fields_set:
            _dict['signature'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SoumettreFactureCompleteResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "succes": obj.get("succes"),
            "destination_type": obj.get("destination_type"),
            "resultat_chorus": ResultatChorusPro.from_dict(obj["resultat_chorus"]) if obj.get("resultat_chorus") is not None else None,
            "resultat_afnor": ResultatAFNOR.from_dict(obj["resultat_afnor"]) if obj.get("resultat_afnor") is not None else None,
            "facture_enrichie": FactureEnrichieInfoOutput.from_dict(obj["facture_enrichie"]) if obj.get("facture_enrichie") is not None else None,
            "pdf_facturx": PDFFacturXInfo.from_dict(obj["pdf_facturx"]) if obj.get("pdf_facturx") is not None else None,
            "signature": SignatureInfo.from_dict(obj["signature"]) if obj.get("signature") is not None else None,
            "pdf_base64": obj.get("pdf_base64"),
            "message": obj.get("message")
        })
        return _obj


