# ABSESpy: Agent-Based Modeling Framework for Social-Ecological Systems

![ABSES_banner](https://songshgeo-picgo-1302043007.cos.ap-beijing.myqcloud.com/uPic/CleanShot%202023-10-19%20at%2019.08.12@2x.png)

<div align="center"><p>
    <!-- JOSS badge -->
    <!-- <a href="https://joss.theoj.org/papers/b6f6440bc05648fa7945bec1ae901e52">
        <img alt="Latest release" src="https://joss.theoj.org/papers/b6f6440bc05648fa7945bec1ae901e52/status.svg?style=for-the-badge&logo=probot&color=C9CBFF&logoColor=D9E0EE&labelColor=302D41" />
    </a> -->
    <a href="#contributors-">
        <img alt="Latest release" src="https://img.shields.io/badge/all_contributors-1-orange.svg?style=for-the-badge&logo=probot&color=C9CBFF&logoColor=D9E0EE&labelColor=302D41" />
    </a>
    <a href="https://github.com/absespy/ABSESpy/releases/latest">
        <img alt="Latest release" src="https://img.shields.io/github/v/release/absespy/ABSESpy?style=for-the-badge&logo=probot&color=C9CBFF&logoColor=D9E0EE&labelColor=302D41" />
    </a>
    <a href="https://github.com/absespy/ABSESpy/pulse">
        <img alt="Last commit" src="https://img.shields.io/github/last-commit/absespy/ABSESpy?style=for-the-badge&logo=probot&color=8bd5ca&logoColor=D9E0EE&labelColor=302D41"/>
    </a>
    <a href="https://github.com/absespy/ABSESpy/blob/main/LICENSE">
        <img alt="License" src="https://img.shields.io/github/license/absespy/ABSESpy?style=for-the-badge&logo=probot&color=ee999f&logoColor=D9E0EE&labelColor=302D41" />
    </a>
    <a href="https://github.com/absespy/ABSESpy/stargazers">
        <img alt="Stars" src="https://img.shields.io/github/stars/absespy/ABSESpy?style=for-the-badge&logo=probot&color=c69ff5&logoColor=D9E0EE&labelColor=302D41" />
    </a>
    <a href="https://github.com/absespy/ABSESpy/issues">
        <img alt="Issues" src="https://img.shields.io/github/issues/absespy/ABSESpy?style=for-the-badge&logo=probot&color=F5E0DC&logoColor=D9E0EE&labelColor=302D41" />
    </a>
    <a href="https://github.com/absespy/ABSESpy">
        <img alt="Repo Size" src="https://img.shields.io/github/repo-size/absespy/ABSESpy?color=%23DDB6F2&label=SIZE&logo=codesandbox&style=for-the-badge&logoColor=D9E0EE&labelColor=302D41" />
    </a>

<a href="https://twitter.com/intent/follow?screen_name=shuangsong11">
    <img alt="follow on Twitter" src="https://img.shields.io/twitter/follow/shuangsong11?style=for-the-badge&logo=twitter&color=8aadf3&logoColor=D9E0EE&labelColor=302D41" />
</a>

<!-- Website Badge -->
<a href="https://cv.songshgeo.com/">
    <img src="https://img.shields.io/badge/Website-SongshGeo-brightgreen.svg?style=for-the-badge&logo=twitter&color=8aadf3&logoColor=D9E0EE&labelColor=302D41" alt="github">
</a>

  <!-- <p align="center">
    <img src="https://stars.medv.io/absespy/ABSESpy.svg", title="commits"/>
  </p> -->

---
Language: [English Readme] | [简体中文]

**[<kbd> <br> Install <br> </kbd>][Install]**
**[<kbd> <br> Getting started <br> </kbd>][Getting Started]**
**[<kbd> <br> Tutorials <br> </kbd>][Tutorials]**
**[<kbd> <br> Contribute <br> </kbd>][Contribute]**

</div>

`ABSESpy` is a novel agent-based modeling (ABM) framework that facilitates socio-ecological systems (SES) research. It serves as an extension package of [Mesa], the most popular ABM framework, and further enhances agents' interactions with other components, especially grid-like spaces. With a configuration file for managing parameters and an improved data Input/Output system, `ABSESpy`'s modularity and low-coupling design enable elegant maintenance of large modeling projects. In addition, `ABSESpy` includes a schedule that aligns models' tick with the calendar time. These innovations position `ABSESpy` as a valuable tool in fostering more ABMs for real-world SES issues. Its ultimate aim is to become the go-to choice for ABM when working with a human-involved changing world.

## Features

<img src="https://songshgeo-picgo-1302043007.cos.ap-beijing.myqcloud.com/uPic/ABSESpy%20API.jpg" alt="ABSESpy API structure" style="max-width:400px;max-height:400px;width:auto;height:auto;">


- 🌍 Modeling social-ecological system with geo-data.
- 🤖 Managing and manipulating agents with ease of cake.
- 🕙 Make your model coherent with real-world time.
- 📁 Handling complex models with a configuration file.
- 🙋 and more...

  [Mesa]: https://github.com/projectmesa/mesa
  [Contribute]: https://absespy.github.io/ABSESpy/home/contribution/
  [Getting Started]: https://absespy.github.io/ABSESpy/home/get_started/
  [Install]: https://absespy.github.io/ABSESpy/home/Installation/
  [Tutorials]: https://absespy.github.io/ABSESpy/tutorial/tutorial/
  [简体中文]: README.zh-cn.md
  [English Readme]: README.md

## Contributors ✨

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://cv.songshgeo.com"><img src="https://avatars.githubusercontent.com/u/45836839?v=4?s=100" width="100px;" alt="Shuang Song"/><br /><sub><b>Shuang Song</b></sub></a><br /><a href="https://github.com/ABSESpy/ABSESpy/commits?author=SongshGeo" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ekmanib"><img src="https://avatars.githubusercontent.com/u/94269701?v=4?s=100" width="100px;" alt="Elías José Mantilla Ibarra"/><br /><sub><b>Elías José Mantilla Ibarra</b></sub></a><br /><a href="https://github.com/ABSESpy/ABSESpy/commits?author=ekmanib" title="Documentation">📖</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->
<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!