#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by Grako.
#
#    https://pypi.python.org/pypi/grako/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import absolute_import, division, print_function, unicode_literals

from grako.buffering import Buffer
from grako.parsing import Parser, graken
from grako.util import RE_FLAGS, generic_main, re  # noqa

KEYWORDS = {}


class WktBuffer(Buffer):
    def __init__(
        self,
        text,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=None,
        namechars="",
        **kwargs,
    ):
        super(WktBuffer, self).__init__(
            text,
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,  # type: ignore
            namechars=namechars,
            **kwargs,
        )


class WktParser(Parser):
    def __init__(
        self,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=None,
        left_recursion=False,
        parseinfo=True,
        keywords=None,
        namechars="",
        buffer_class=WktBuffer,
        **kwargs,
    ):
        if keywords is None:
            keywords = KEYWORDS
        super(WktParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,  # type: ignore
            left_recursion=left_recursion,
            parseinfo=parseinfo,
            keywords=keywords,
            namechars=namechars,
            buffer_class=buffer_class,
            **kwargs,
        )

    @graken()
    def _wkt_representation_(self):
        with self._choice():
            with self._option():
                self._point_text_representation_()
            with self._option():
                self._curve_text_representation_()
            with self._option():
                self._surface_text_representation_()
            with self._option():
                self._collection_text_representation_()
            self._error("no available options")

    @graken()
    def _point_text_representation_(self):
        self._token("POINT")
        with self._optional():
            self._z_m_()
        self._point_text_()

    @graken()
    def _curve_text_representation_(self):
        with self._choice():
            with self._option():
                self._linestring_text_representation_()
            with self._option():
                self._circularstring_text_representation_()
            with self._option():
                self._compoundcurve_text_representation_()
            self._error("no available options")

    @graken()
    def _linestring_text_representation_(self):
        self._token("LINESTRING")
        with self._optional():
            self._z_m_()
        self._linestring_text_body_()

    @graken()
    def _circularstring_text_representation_(self):
        self._token("CIRCULARSTRING")
        with self._optional():
            self._z_m_()
        self._circularstring_text_()

    @graken()
    def _compoundcurve_text_representation_(self):
        self._token("COMPOUNDCURVE")
        with self._optional():
            self._z_m_()
        self._compoundcurve_text_()

    @graken()
    def _surface_text_representation_(self):
        self._curvepolygon_text_representation_()

    @graken()
    def _curvepolygon_text_representation_(self):
        with self._choice():
            with self._option():
                self._token("CURVEPOLYGON")
                with self._optional():
                    self._z_m_()
                self._curvepolygon_text_body_()
            with self._option():
                self._polygon_text_representation_()
            with self._option():
                self._triangle_text_representation_()
            self._error("no available options")

    @graken()
    def _polygon_text_representation_(self):
        self._token("POLYGON")
        with self._optional():
            self._z_m_()
        self._polygon_text_body_()

    @graken()
    def _triangle_text_representation_(self):
        self._token("TRIANGLE")
        with self._optional():
            self._z_m_()
        self._triangle_text_body_()

    @graken()
    def _collection_text_representation_(self):
        with self._choice():
            with self._option():
                self._multipoint_text_representation_()
            with self._option():
                self._multicurve_text_representation_()
            with self._option():
                self._multisurface_text_representation_()
            with self._option():
                self._geometrycollection_text_representation_()
            self._error("no available options")

    @graken()
    def _multipoint_text_representation_(self):
        self._token("MULTIPOINT")
        with self._optional():
            self._z_m_()
        self._multipoint_text_()

    @graken()
    def _multicurve_text_representation_(self):
        with self._choice():
            with self._option():
                self._token("MULTICURVE")
                with self._optional():
                    self._z_m_()
                self._multicurve_text_()
            with self._option():
                self._multilinestring_text_representation_()
            self._error("no available options")

    @graken()
    def _multilinestring_text_representation_(self):
        self._token("MULTILINESTRING")
        with self._optional():
            self._z_m_()
        self._multilinestring_text_()

    @graken()
    def _multisurface_text_representation_(self):
        with self._choice():
            with self._option():
                self._token("MULTISURFACE")
                with self._optional():
                    self._z_m_()
                self._multisurface_text_()
            with self._option():
                self._multipolygon_text_representation_()
            with self._option():
                self._polyhedralsurface_text_representation_()
            with self._option():
                self._tin_text_representation_()
            self._error("no available options")

    @graken()
    def _multipolygon_text_representation_(self):
        self._token("MULTIPOLYGON")
        with self._optional():
            self._z_m_()
        self._multipolygon_text_()

    @graken()
    def _polyhedralsurface_text_representation_(self):
        self._token("POLYHEDRALSURFACE")
        with self._optional():
            self._z_m_()
        self._polyhedralsurface_text_()

    @graken()
    def _tin_text_representation_(self):
        self._token("TIN")
        with self._optional():
            self._z_m_()
        self._tin_text_()

    @graken()
    def _geometrycollection_text_representation_(self):
        self._token("GEOMETRYCOLLECTION")
        with self._optional():
            self._z_m_()
        self._geometrycollection_text_()

    @graken()
    def _linestring_text_body_(self):
        self._linestring_text_()

    @graken()
    def _curvepolygon_text_body_(self):
        self._curvepolygon_text_()

    @graken()
    def _polygon_text_body_(self):
        self._polygon_text_()

    @graken()
    def _triangle_text_body_(self):
        self._triangle_text_()

    @graken()
    def _point_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._point_()
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _point_(self):
        self._x_()
        self._y_()
        with self._optional():
            self._z_()
        with self._optional():
            self._m_()

    @graken()
    def _x_(self):
        self._number_()

    @graken()
    def _y_(self):
        self._number_()

    @graken()
    def _z_(self):
        self._number_()

    @graken()
    def _m_(self):
        self._number_()

    @graken()
    def _linestring_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._point_()

                def block0():
                    self._comma_()
                    self._point_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _circularstring_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._point_()

                def block0():
                    self._comma_()
                    self._point_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _compoundcurve_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._single_curve_text_()

                def block0():
                    self._comma_()
                    self._single_curve_text_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _single_curve_text_(self):
        with self._choice():
            with self._option():
                self._linestring_text_body_()
            with self._option():
                self._circularstring_text_representation_()
            self._error("no available options")

    @graken()
    def _curve_text_(self):
        with self._choice():
            with self._option():
                self._linestring_text_body_()
            with self._option():
                self._circularstring_text_representation_()
            with self._option():
                self._compoundcurve_text_representation_()
            self._error("no available options")

    @graken()
    def _ring_text_(self):
        with self._choice():
            with self._option():
                self._linestring_text_body_()
            with self._option():
                self._circularstring_text_representation_()
            with self._option():
                self._compoundcurve_text_representation_()
            self._error("no available options")

    @graken()
    def _surface_text_(self):
        with self._choice():
            with self._option():
                self._token("CURVEPOLYGON")
                self._curvepolygon_text_body_()
            with self._option():
                self._polygon_text_body_()
            self._error("no available options")

    @graken()
    def _curvepolygon_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._ring_text_()

                def block0():
                    self._comma_()
                    self._ring_text_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _polygon_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._linestring_text_()

                def block0():
                    self._comma_()
                    self._linestring_text_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _triangle_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._linestring_text_()
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _multipoint_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._point_text_()

                def block0():
                    self._comma_()
                    self._point_text_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _multicurve_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._curve_text_()

                def block0():
                    self._comma_()
                    self._curve_text_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _multilinestring_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._linestring_text_body_()

                def block0():
                    self._comma_()
                    self._linestring_text_body_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _multisurface_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._surface_text_()

                def block0():
                    self._comma_()
                    self._surface_text_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _multipolygon_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._polygon_text_body_()

                def block0():
                    self._comma_()
                    self._polygon_text_body_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _polyhedralsurface_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._polygon_text_body_()

                def block0():
                    self._comma_()
                    self._polygon_text_body_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _tin_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._triangle_text_body_()

                def block0():
                    self._comma_()
                    self._triangle_text_body_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _geometrycollection_text_(self):
        with self._choice():
            with self._option():
                self._empty_set_()
            with self._option():
                self._left_paren_()
                self._wkt_representation_()

                def block0():
                    self._comma_()
                    self._wkt_representation_()

                self._closure(block0)
                self._right_paren_()
            self._error("no available options")

    @graken()
    def _empty_set_(self):
        self._token("EMPTY")

    @graken()
    def _z_m_(self):
        with self._choice():
            with self._option():
                self._token("ZM")
            with self._option():
                self._token("Z")
            with self._option():
                self._token("M")
            self._error("expecting one of: M Z ZM")

    @graken()
    def _left_paren_(self):
        self._token("(")

    @graken()
    def _right_paren_(self):
        self._token(")")

    @graken()
    def _comma_(self):
        self._token(",")

    @graken()
    def _number_(self):
        self._pattern(r"[+-]?([0-9]+(\.[0-9]*)?|\.[0-9]+)([eE][+-]?[0-9]+)?")


class WktSemantics(object):
    def wkt_representation(self, ast):
        return ast

    def point_text_representation(self, ast):
        return ast

    def curve_text_representation(self, ast):
        return ast

    def linestring_text_representation(self, ast):
        return ast

    def circularstring_text_representation(self, ast):
        return ast

    def compoundcurve_text_representation(self, ast):
        return ast

    def surface_text_representation(self, ast):
        return ast

    def curvepolygon_text_representation(self, ast):
        return ast

    def polygon_text_representation(self, ast):
        return ast

    def triangle_text_representation(self, ast):
        return ast

    def collection_text_representation(self, ast):
        return ast

    def multipoint_text_representation(self, ast):
        return ast

    def multicurve_text_representation(self, ast):
        return ast

    def multilinestring_text_representation(self, ast):
        return ast

    def multisurface_text_representation(self, ast):
        return ast

    def multipolygon_text_representation(self, ast):
        return ast

    def polyhedralsurface_text_representation(self, ast):
        return ast

    def tin_text_representation(self, ast):
        return ast

    def geometrycollection_text_representation(self, ast):
        return ast

    def linestring_text_body(self, ast):
        return ast

    def curvepolygon_text_body(self, ast):
        return ast

    def polygon_text_body(self, ast):
        return ast

    def triangle_text_body(self, ast):
        return ast

    def point_text(self, ast):
        return ast

    def point(self, ast):
        return ast

    def x(self, ast):
        return ast

    def y(self, ast):
        return ast

    def z(self, ast):
        return ast

    def m(self, ast):
        return ast

    def linestring_text(self, ast):
        return ast

    def circularstring_text(self, ast):
        return ast

    def compoundcurve_text(self, ast):
        return ast

    def single_curve_text(self, ast):
        return ast

    def curve_text(self, ast):
        return ast

    def ring_text(self, ast):
        return ast

    def surface_text(self, ast):
        return ast

    def curvepolygon_text(self, ast):
        return ast

    def polygon_text(self, ast):
        return ast

    def triangle_text(self, ast):
        return ast

    def multipoint_text(self, ast):
        return ast

    def multicurve_text(self, ast):
        return ast

    def multilinestring_text(self, ast):
        return ast

    def multisurface_text(self, ast):
        return ast

    def multipolygon_text(self, ast):
        return ast

    def polyhedralsurface_text(self, ast):
        return ast

    def tin_text(self, ast):
        return ast

    def geometrycollection_text(self, ast):
        return ast

    def empty_set(self, ast):
        return ast

    def z_m(self, ast):
        return ast

    def left_paren(self, ast):
        return ast

    def right_paren(self, ast):
        return ast

    def comma(self, ast):
        return ast

    def number(self, ast):
        return ast


def main(filename, startrule, **kwargs):
    with open(filename) as f:
        text = f.read()
    parser = WktParser()
    return parser.parse(text, startrule, filename=filename, **kwargs)


if __name__ == "__main__":
    import json

    from grako.util import asjson

    ast = generic_main(main, WktParser, name="Wkt")
    print("AST:")
    print(ast)
    print()
    print("JSON:")
    print(json.dumps(asjson(ast), indent=2))
    print()
