# BioLM JupyterLab Extension

[![PyPI version](https://badge.fury.io/py/jupyterlab-biolm.svg)](https://badge.fury.io/py/jupyterlab-biolm)
[![PyPI downloads](https://img.shields.io/pypi/dm/jupyterlab-biolm.svg)](https://pypi.org/project/jupyterlab-biolm/)
[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)
[![Python](https://img.shields.io/badge/python-3.8%2B-blue.svg)](https://www.python.org/downloads/)
[![JupyterLab](https://img.shields.io/badge/JupyterLab-4.0%2B-orange.svg)](https://jupyterlab.readthedocs.io/)
[![CI](https://github.com/BioLM/jupyterlab-biolm/actions/workflows/ci.yml/badge.svg)](https://github.com/BioLM/jupyterlab-biolm/actions/workflows/ci.yml)

A JupyterLab extension that provides a graphical interface for browsing BioLM models, inserting SDK code snippets, and managing authentication - all from within JupyterLab's sidebar.

## Features

### 🧠 Models Tab
- Browse all available BioLM models
- Search and filter models by name, description, or tags
- Click tags to insert code snippets with model + action pre-filled
- Copy model IDs to clipboard
- Expandable model descriptions

### ⚙️ Operations Tab
- Quick access to common SDK operation examples
- Searchable list of operations (Generate, Predict, Embed, etc.)
- One-click code insertion into notebook cells
- Organized by category

### 🔑 Settings Tab
- Manage multiple API key profiles
- Test API key connections
- Set default model and action preferences
- Respects `BIOLM_API_KEY` environment variable

## Installation

### From PyPI (when available)

```bash
pip install jupyterlab-biolm
```

### From Source

```bash
# Clone the repository
git clone https://github.com/yourusername/jupyterlab-biolm.git
cd jupyterlab-biolm

# Install the extension
pip install -e .

# Build the extension
jlpm install
jlpm build

# Rebuild JupyterLab
jupyter lab build
```

## Usage

1. **Open the Extension**: The BioLM sidebar will appear in JupyterLab's left sidebar. If not visible, use the command palette (`Cmd/Ctrl + Shift + C`) and search for "Open BioLM".

2. **Configure API Key**:
   - Go to the Settings tab
   - Add a new profile with your API key
   - Or use the `BIOLM_API_KEY` environment variable

3. **Browse Models**:
   - Switch to the Models tab
   - Search or filter by tags
   - Click a tag button to insert code for that model + action

4. **Use Operations**:
   - Switch to the Operations tab
   - Browse common SDK operations
   - Click "Insert" to add code to your active notebook cell

## Development

### Prerequisites

- Node.js >= 16
- Python >= 3.8
- JupyterLab >= 4.0.0

### Setup

```bash
# Install dependencies
jlpm install

# Build TypeScript
jlpm build:lib

# Build extension in development mode
jlpm build:labextension:dev

# Watch for changes
jlpm watch
```

### Project Structure

```
jupyterlab-biolm/
├── src/                    # TypeScript source
│   ├── index.ts           # Extension entry point
│   ├── widget.tsx         # Main sidebar widget
│   ├── api/               # API client
│   ├── components/        # React components
│   ├── services/          # Business logic
│   └── data/              # Static data
├── style/                  # CSS styles
├── schema/                 # Settings schema
└── jupyterlab_biolm/       # Python package
```

## Configuration

### User Settings

The extension stores settings in JupyterLab's settings system. You can configure:

- **API Key Profiles**: Multiple named profiles with different API keys
- **Active Profile**: Which profile to use (or environment variable)
- **Default Model**: Default model ID for code generation
- **Default Action**: Default action (predict, generate, etc.)

### Environment Variables

The extension supports several environment variables for deployment-level configuration:

#### `BIOLM_USE_PROXY` (default: `true`)

Controls whether to use the server-side proxy for API requests or make direct API calls from the browser.

- `true` (default): Use server proxy to avoid CORS issues. Recommended for most deployments.
- `false`: Make direct API calls from the browser. Only use when CORS is properly configured on the API server.

```bash
# Use proxy (default, recommended)
export BIOLM_USE_PROXY=true

# Use direct API calls (requires CORS configuration)
export BIOLM_USE_PROXY=false
```

#### `BIOLM_API_BASE_URL` (default: `https://biolm.ai/api/ui/community-api-models/`)

Sets the base URL for the BioLM API. Useful for:
- Testing against staging environments
- Using self-hosted BioLM instances
- API version changes

```bash
# Use default production API
export BIOLM_API_BASE_URL=https://biolm.ai/api/ui/community-api-models/

# Use staging environment
export BIOLM_API_BASE_URL=https://staging.biolm.ai/api/ui/community-api-models/
```

**Note**: The URL should end with a trailing slash. If not provided, one will be added automatically.

#### `BIOLM_REQUEST_TIMEOUT` (default: `10`)

Sets the timeout (in seconds) for API requests made by the server extension.

```bash
# Use default 10 second timeout
export BIOLM_REQUEST_TIMEOUT=10

# Increase timeout for slow networks
export BIOLM_REQUEST_TIMEOUT=30
```

#### `BIOLM_CACHE_TTL` (default: `300000`)

Sets the cache time-to-live in milliseconds for model metadata. The default is 5 minutes (300000 ms).

```bash
# Use default 5 minute cache
export BIOLM_CACHE_TTL=300000

# Disable caching (0) or set custom duration
export BIOLM_CACHE_TTL=600000  # 10 minutes
```

#### `BIOLM_API_KEY` (optional)

Sets the default API key to use if no profile is selected in the UI. This is a user-facing setting that can also be configured in the Settings tab.

```bash
export BIOLM_API_KEY=your_api_key_here
```

### Example: Docker Deployment

```dockerfile
FROM jupyter/scipy-notebook

# Install extension
RUN pip install jupyterlab-biolm

# Configure environment variables
ENV BIOLM_USE_PROXY=true
ENV BIOLM_API_BASE_URL=https://biolm.ai/api/ui/community-api-models/
ENV BIOLM_REQUEST_TIMEOUT=10
ENV BIOLM_CACHE_TTL=300000
```

### Example: Codespaces / Cloud Deployment

Set environment variables in your deployment configuration:

```yaml
# .github/workflows/deploy.yml or similar
env:
  BIOLM_USE_PROXY: "false"  # If CORS is configured
  BIOLM_API_BASE_URL: "https://biolm.ai/api/ui/community-api-models/"
  BIOLM_REQUEST_TIMEOUT: "15"
```

## API Integration

The extension fetches model metadata from `https://api.biolm.ai/models`. Models are cached for 5 minutes to reduce API calls.

## Requirements

- JupyterLab >= 4.0.0
- React >= 18.0.0

## License

BSD-3-Clause

## Support

For issues and feature requests, please visit the [GitHub repository](https://github.com/yourusername/jupyterlab-biolm).

