## Changes

Describe the changes you made.

## Related issues

Link to every issue from the issue tracker (if any) you addressed in this PR.

## Checklist

- [ ] Tests are included for relevant behavior changes.
- [ ] Documentation is added in the [flatland-book](https://github.com/flatland-association/flatland-book) repo for relevant behavior changes.
- [ ] If you made important user-facing changes, describe them under the `[Unreleased]` tag in `CHANGELOG.md`.
- [ ] New package dependencies are declared in the `pyproject.toml` file.
  Requirement files have been updated by running `tox -e requirements`.
- [ ] Code works with all supported Python versions (3.10, 3.11, 3.12 and 3.13). Checks run with all supported version and are
  required to run successfully.
- [ ] Code is formatted according to PEP 8 (an IDE like PyCharm can do this for you).
- [ ] Technical guidelines listed in `CONTRIBUTING.md` are followed.
