🚂 Flatland
========

![Flatland](https://i.imgur.com/0rnbSLY.gif)

[![Main](https://github.com/flatland-association/flatland-rl/actions/workflows/main.yml/badge.svg)](https://github.com/flatland-association/flatland-rl/actions/workflows/main.yml)

Flatland is an open-source toolkit for developing and comparing Multi-Agent Reinforcement Learning algorithms in little
(or ridiculously large!) gridworlds.

[The official documentation](https://flatland-association.github.io/flatland-book/intro.html) contains full details about the environment and problem
statement.

Flatland is tested with Python 3.10, 3.11, 3.12 and 3.13 on modern versions of macOS, Linux and Windows. You may encounter
problems with graphical rendering if you use WSL.

🏆 Challenges
---

This library was developed specifically for the
AIcrowd [Flatland challenges](http://flatland.aicrowd.com/research/top-challenge-solutions.html) in which we strongly
encourage you to take part in!

- [Flatland 3 Challenge](https://www.aicrowd.com/challenges/flatland-3)
- [AMLD 2021 Challenge](https://www.aicrowd.com/challenges/flatland)
- [NeurIPS 2020 Challenge](https://www.aicrowd.com/challenges/neurips-2020-flatland-challenge/)
- [2019 Challenge](https://www.aicrowd.com/challenges/flatland-challenge)

📦 Setup
---

### Setup virtual environment

Set up a virtual environment using your preferred method (we suggest the built-in `venv`) and activate it.
You can use your IDE to do this or by using the command line:

```shell
python -m venv .venv
source .venv/bin/activate
```

### Stable release

Install Flatland using pip:

```shell
python -m pip install flatland-rl
```

This is the preferred method to install Flatland, as it will always install the most recent stable release.

👥 Credits
---

This library was initially developed
by [SBB](https://www.sbb.ch/en/), [Deutsche Bahn](https://www.deutschebahn.com/), [SNCF](https://www.sncf.com/en),
[AIcrowd](https://www.aicrowd.com/) and [numerous contributors](https://flatland-association.github.io/flatland-book/misc/credits.html) from the
flatland community. It is now developed by the [Flatland Association](https://flatland-association.org) and the [Flatland Community](https://flatland.cloud).

➕ Contributions
---
Please follow the [Contribution Guidelines](./CONTRIBUTING.md) for more details on how you can successfully contribute
to the project. We enthusiastically look forward to your contributions!

💬 Communication
---

* [Issue Tracker](https://github.com/flatland-association/flatland-rl/issues/)

🔗 Partners
---
<a href="https://sbb.ch" target="_blank" style="margin-right:30px"><img src="https://flatland-association.org/members/sbb-cff-ffs-logo.svg" alt="SBB" height="60"/></a>
&nbsp;
<a href="https://www.deutschebahn.com/" target="_blank" style="margin-right:30px"><img src="https://i.imgur.com/pjTki15.png" alt="DB"  height="60"/></a>
&nbsp;
<a href="https://www.sncf.com/en" target="_blank" style="margin-right:30px"><img src="https://iconape.com/wp-content/png_logo_vector/logo-sncf.png" alt="SNCF"  height="60"/></a>
&nbsp;
<a href="https://www.aicrowd.com" target="_blank"><img src="https://i.imgur.com/kBZQGI9.png" alt="AIcrowd"  height="60"/></a>
&nbsp;
<a href="https://flatland.cloud" target="_blank"><img src="https://flatland-association.org/members/flatland-community-logo.svg" alt="Flatland Community"  height="60"/></a>
