# coding: utf-8

"""
    APIFlask

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing_extensions import Annotated
from typing_extensions import Self

from flatland.integrations.interactiveai.event_api.models.metadata_schema_railway import MetadataSchemaRailway


class EventIn(BaseModel):
    """
    EventIn
    """  # noqa: E501
    criticality: StrictStr
    data: Optional[MetadataSchemaRailway] = None
    description: Annotated[str, Field(min_length=1, strict=True, max_length=255)]
    end_date: Optional[datetime] = None
    is_active: Optional[StrictBool] = None
    parent_event_id: Optional[StrictStr] = None
    start_date: Optional[datetime] = None
    title: Annotated[str, Field(min_length=1, strict=True, max_length=255)]
    use_case: Annotated[str, Field(min_length=1, strict=True, max_length=255)]
    __properties: ClassVar[List[str]] = ["criticality", "data", "description", "end_date", "is_active", "parent_event_id", "start_date", "title", "use_case"]

    @field_validator('criticality')
    def criticality_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ND', 'HIGH', 'MEDIUM', 'LOW', 'ROUTINE']):
            raise ValueError("must be one of enum values ('ND', 'HIGH', 'MEDIUM', 'LOW', 'ROUTINE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventIn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['end_date'] = None

        # set to None if parent_event_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_event_id is None and "parent_event_id" in self.model_fields_set:
            _dict['parent_event_id'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['start_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventIn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "criticality": obj.get("criticality"),
            "data": MetadataSchemaRailway.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "description": obj.get("description"),
            "end_date": obj.get("end_date"),
            "is_active": obj.get("is_active"),
            "parent_event_id": obj.get("parent_event_id"),
            "start_date": obj.get("start_date"),
            "title": obj.get("title"),
            "use_case": obj.get("use_case")
        })
        return _obj
