<p align="center">
  <a href="https://nitric.io">
    <img src="docs/assets/nitric-logo.svg" width="120" alt="Nitric Logo"/>
  </a>
</p>

<h2 align="center">
  Build <a href="https://nitric.io">nitric</a> applications with Python
</h2>

<p align="center">
  <a href="https://actions-badge.atrox.dev/nitrictech/python-sdk/goto?ref=main"><img alt="Build Status" src="https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fnitrictech%2Fpython-sdk%2Fbadge%3Fref%3Dmain&style=for-the-badge" /></a>
  <a href="https://codecov.io/gh/nitrictech/python-sdk">
    <img alt="Codecov" src="https://img.shields.io/codecov/c/gh/nitrictech/python-sdk?style=for-the-badge&token=SBFRNSZ4ZF">
  </a>
  <a href="https://npmjs.org/package/@nitric/sdk">
    <img alt="Version" src="https://img.shields.io/pypi/v/nitric?style=for-the-badge">
  </a>
  <a href="https://pypi.org/project/nitric">
    <img alt="Downloads/week" src="https://img.shields.io/pypi/dw/nitric?style=for-the-badge">
  </a>
  <a href="https://discord.gg/Webemece5C"><img alt="Discord" src="https://img.shields.io/discord/955259353043173427?label=discord&style=for-the-badge"></a>
</p>

The Python SDK supports the use of the [Nitric](https://nitric.io) framework with Python 3.10+. For more information check out the main [Nitric repo](https://github.com/nitrictech/nitric).

Python SDKs provide an infrastructure-from-code style that lets you define resources in code. You can also write the functions that support the logic behind APIs, subscribers and schedules.

You can request the type of access you need to resources such as publishing for topics, without dealing directly with IAM or policy documents.

## Status

The SDK is in early stage development and APIs and interfaces are still subject to breaking changes. We’d love your feedback as we build additional functionality!

## Get in touch

- Ask questions in [GitHub discussions](https://github.com/nitrictech/nitric/discussions)

- Join us on [Discord](https://discord.gg/Webemece5C)

- Find us on [Twitter](https://twitter.com/nitric_io)

- Send us an [email](mailto:maintainers@nitric.io)

## Getting Started

### Using the [Nitric CLI](https://github.com/nitrictech/cli)

> nitric is included in all python related projects by default

```bash
nitric new
```

Follow the prompts and select `official/Python - Starter` as your template

### Adding to an existing project

**pip**

```bash
# Install the Nitric SDK
pip3 install nitric
```

**pipenv**
```
pipenv install nitric
```

## Usage
[Nitric Documentation](https://nitric.io/docs)