#
# Copyright (c) 2021 Nitric Technologies Pty Ltd.
#
# This file is part of Nitric Python 3 SDK.
# See https://github.com/nitrictech/python-sdk for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/error/v1/error.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict

import betterproto


@dataclass(eq=False, repr=False)
class ErrorScope(betterproto.Message):
    service: str = betterproto.string_field(1)
    """The API service invoked, e.g. 'Service.Method'."""

    plugin: str = betterproto.string_field(2)
    """The plugin method invoked, e.g. 'PluginService.Method'."""

    args: Dict[str, str] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    The plugin method arguments, ensure only non-sensitive data is specified.
    """


@dataclass(eq=False, repr=False)
class ErrorDetails(betterproto.Message):
    message: str = betterproto.string_field(1)
    """
    The developer error message, explaining the error and ideally solution.
    """

    cause: str = betterproto.string_field(2)
    """The error root cause."""

    scope: "ErrorScope" = betterproto.message_field(3)
    """The scope of the error."""
