#
# Copyright (c) 2021 Nitric Technologies Pty Ltd.
#
# This file is part of Nitric Python 3 SDK.
# See https://github.com/nitrictech/python-sdk for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/event/v1/event.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class EventPublishRequest(betterproto.Message):
    """Request to publish an event to a topic"""

    topic: str = betterproto.string_field(1)
    """The name of the topic to publish the event to"""

    event: "NitricEvent" = betterproto.message_field(2)
    """The event to be published"""

    delay: int = betterproto.uint32_field(3)
    """An optional delay specified in seconds (minimum 10 seconds)"""


@dataclass(eq=False, repr=False)
class EventPublishResponse(betterproto.Message):
    """Result of publishing an event"""

    id: str = betterproto.string_field(1)
    """
    The id of the published message When an id was not supplied one should be
    automatically generated
    """


@dataclass(eq=False, repr=False)
class TopicListRequest(betterproto.Message):
    """Request for the Topic List method"""

    pass


@dataclass(eq=False, repr=False)
class TopicListResponse(betterproto.Message):
    """Topic List Response"""

    topics: List["NitricTopic"] = betterproto.message_field(1)
    """The list of found topics"""


@dataclass(eq=False, repr=False)
class NitricTopic(betterproto.Message):
    """Represents an event topic"""

    name: str = betterproto.string_field(1)
    """The Nitric name for the topic"""


@dataclass(eq=False, repr=False)
class NitricEvent(betterproto.Message):
    """Nitric Event Model"""

    id: str = betterproto.string_field(1)
    """A Unique ID for the Nitric Event"""

    payload_type: str = betterproto.string_field(2)
    """A content hint for the events payload"""

    payload: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(3)
    """The payload of the event"""


class EventServiceStub(betterproto.ServiceStub):
    async def publish(
        self,
        event_publish_request: "EventPublishRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EventPublishResponse":
        return await self._unary_unary(
            "/nitric.event.v1.EventService/Publish",
            event_publish_request,
            EventPublishResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class TopicServiceStub(betterproto.ServiceStub):
    async def list(
        self,
        topic_list_request: "TopicListRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "TopicListResponse":
        return await self._unary_unary(
            "/nitric.event.v1.TopicService/List",
            topic_list_request,
            TopicListResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class EventServiceBase(ServiceBase):
    async def publish(
        self, event_publish_request: "EventPublishRequest"
    ) -> "EventPublishResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_publish(
        self, stream: "grpclib.server.Stream[EventPublishRequest, EventPublishResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.publish(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.event.v1.EventService/Publish": grpclib.const.Handler(
                self.__rpc_publish,
                grpclib.const.Cardinality.UNARY_UNARY,
                EventPublishRequest,
                EventPublishResponse,
            ),
        }


class TopicServiceBase(ServiceBase):
    async def list(self, topic_list_request: "TopicListRequest") -> "TopicListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_list(
        self, stream: "grpclib.server.Stream[TopicListRequest, TopicListResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.list(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.event.v1.TopicService/List": grpclib.const.Handler(
                self.__rpc_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                TopicListRequest,
                TopicListResponse,
            ),
        }
