#
# Copyright (c) 2021 Nitric Technologies Pty Ltd.
#
# This file is part of Nitric Python 3 SDK.
# See https://github.com/nitrictech/python-sdk for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/secret/v1/secret.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class SecretPutRequest(betterproto.Message):
    """Request to put a secret to a Secret Store"""

    secret: "Secret" = betterproto.message_field(1)
    """The Secret to put to the Secret store"""

    value: bytes = betterproto.bytes_field(2)
    """The value to assign to that secret"""


@dataclass(eq=False, repr=False)
class SecretPutResponse(betterproto.Message):
    """Result from putting the secret to a Secret Store"""

    secret_version: "SecretVersion" = betterproto.message_field(1)
    """The id of the secret"""


@dataclass(eq=False, repr=False)
class SecretAccessRequest(betterproto.Message):
    """Request to get a secret from a Secret Store"""

    secret_version: "SecretVersion" = betterproto.message_field(1)
    """The id of the secret"""


@dataclass(eq=False, repr=False)
class SecretAccessResponse(betterproto.Message):
    """The secret response"""

    secret_version: "SecretVersion" = betterproto.message_field(1)
    """The version of the secret that was requested"""

    value: bytes = betterproto.bytes_field(2)
    """The value of the secret"""


@dataclass(eq=False, repr=False)
class Secret(betterproto.Message):
    """The secret container"""

    name: str = betterproto.string_field(1)
    """The secret name"""


@dataclass(eq=False, repr=False)
class SecretVersion(betterproto.Message):
    """A version of a secret"""

    secret: "Secret" = betterproto.message_field(1)
    """Reference to the secret container"""

    version: str = betterproto.string_field(2)
    """The secret version"""


class SecretServiceStub(betterproto.ServiceStub):
    async def put(
        self,
        secret_put_request: "SecretPutRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SecretPutResponse":
        return await self._unary_unary(
            "/nitric.secret.v1.SecretService/Put",
            secret_put_request,
            SecretPutResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def access(
        self,
        secret_access_request: "SecretAccessRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SecretAccessResponse":
        return await self._unary_unary(
            "/nitric.secret.v1.SecretService/Access",
            secret_access_request,
            SecretAccessResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class SecretServiceBase(ServiceBase):
    async def put(self, secret_put_request: "SecretPutRequest") -> "SecretPutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def access(
        self, secret_access_request: "SecretAccessRequest"
    ) -> "SecretAccessResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_put(
        self, stream: "grpclib.server.Stream[SecretPutRequest, SecretPutResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.put(request)
        await stream.send_message(response)

    async def __rpc_access(
        self, stream: "grpclib.server.Stream[SecretAccessRequest, SecretAccessResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.access(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.secret.v1.SecretService/Put": grpclib.const.Handler(
                self.__rpc_put,
                grpclib.const.Cardinality.UNARY_UNARY,
                SecretPutRequest,
                SecretPutResponse,
            ),
            "/nitric.secret.v1.SecretService/Access": grpclib.const.Handler(
                self.__rpc_access,
                grpclib.const.Cardinality.UNARY_UNARY,
                SecretAccessRequest,
                SecretAccessResponse,
            ),
        }
