#
# Copyright (c) 2021 Nitric Technologies Pty Ltd.
#
# This file is part of Nitric Python 3 SDK.
# See https://github.com/nitrictech/python-sdk for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/storage/v1/storage.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class StoragePreSignUrlRequestOperation(betterproto.Enum):
    """Operation"""

    READ = 0
    WRITE = 1


@dataclass(eq=False, repr=False)
class StorageWriteRequest(betterproto.Message):
    """Request to put (create/update) a storage item"""

    bucket_name: str = betterproto.string_field(1)
    """
    Nitric name of the bucket to store in  this will be automatically resolved
    to the provider specific bucket identifier.
    """

    key: str = betterproto.string_field(2)
    """Key to store the item under"""

    body: bytes = betterproto.bytes_field(3)
    """bytes array to store"""


@dataclass(eq=False, repr=False)
class StorageWriteResponse(betterproto.Message):
    """Result of putting a storage item"""

    pass


@dataclass(eq=False, repr=False)
class StorageReadRequest(betterproto.Message):
    """Request to retrieve a storage item"""

    bucket_name: str = betterproto.string_field(1)
    """
    Nitric name of the bucket to retrieve from  this will be automatically
    resolved to the provider specific bucket identifier.
    """

    key: str = betterproto.string_field(2)
    """Key of item to retrieve"""


@dataclass(eq=False, repr=False)
class StorageReadResponse(betterproto.Message):
    """Returned storage item"""

    body: bytes = betterproto.bytes_field(1)
    """The body bytes of the retrieved storage item"""


@dataclass(eq=False, repr=False)
class StorageDeleteRequest(betterproto.Message):
    """Request to delete a storage item"""

    bucket_name: str = betterproto.string_field(1)
    """Name of the bucket to delete from"""

    key: str = betterproto.string_field(2)
    """Key of item to delete"""


@dataclass(eq=False, repr=False)
class StorageDeleteResponse(betterproto.Message):
    """Result of deleting a storage item"""

    pass


@dataclass(eq=False, repr=False)
class StoragePreSignUrlRequest(betterproto.Message):
    """
    Request to generate a pre-signed URL for a file to perform a specific
    operation, such as read or write.
    """

    bucket_name: str = betterproto.string_field(1)
    """
    Nitric name of the bucket to retrieve from  this will be automatically
    resolved to the provider specific bucket identifier.
    """

    key: str = betterproto.string_field(2)
    """
    Key of item to generate the signed URL for. The URL and the token it
    contains will only be valid for operations on this resource specifically.
    """

    operation: "StoragePreSignUrlRequestOperation" = betterproto.enum_field(3)
    expiry: int = betterproto.uint32_field(4)
    """
    Expiry time in seconds for the token included in the signed URL.  Time
    starts from when the access token is generated, not when this request is
    made.  e.g. time.Now().Add(expiry * time.Second) on the server
    """


@dataclass(eq=False, repr=False)
class StoragePreSignUrlResponse(betterproto.Message):
    url: str = betterproto.string_field(1)
    """
    The pre-signed url, restricted to the operation, resource and expiry time
    specified in the request.
    """


@dataclass(eq=False, repr=False)
class StorageListFilesRequest(betterproto.Message):
    bucket_name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class File(betterproto.Message):
    key: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class StorageListFilesResponse(betterproto.Message):
    files: List["File"] = betterproto.message_field(1)
    """keys of the files in the bucket"""


class StorageServiceStub(betterproto.ServiceStub):
    async def read(
        self,
        storage_read_request: "StorageReadRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StorageReadResponse":
        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/Read",
            storage_read_request,
            StorageReadResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def write(
        self,
        storage_write_request: "StorageWriteRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StorageWriteResponse":
        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/Write",
            storage_write_request,
            StorageWriteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete(
        self,
        storage_delete_request: "StorageDeleteRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StorageDeleteResponse":
        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/Delete",
            storage_delete_request,
            StorageDeleteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def pre_sign_url(
        self,
        storage_pre_sign_url_request: "StoragePreSignUrlRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StoragePreSignUrlResponse":
        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/PreSignUrl",
            storage_pre_sign_url_request,
            StoragePreSignUrlResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list_files(
        self,
        storage_list_files_request: "StorageListFilesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StorageListFilesResponse":
        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/ListFiles",
            storage_list_files_request,
            StorageListFilesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class StorageServiceBase(ServiceBase):
    async def read(
        self, storage_read_request: "StorageReadRequest"
    ) -> "StorageReadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def write(
        self, storage_write_request: "StorageWriteRequest"
    ) -> "StorageWriteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete(
        self, storage_delete_request: "StorageDeleteRequest"
    ) -> "StorageDeleteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pre_sign_url(
        self, storage_pre_sign_url_request: "StoragePreSignUrlRequest"
    ) -> "StoragePreSignUrlResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_files(
        self, storage_list_files_request: "StorageListFilesRequest"
    ) -> "StorageListFilesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_read(
        self, stream: "grpclib.server.Stream[StorageReadRequest, StorageReadResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.read(request)
        await stream.send_message(response)

    async def __rpc_write(
        self, stream: "grpclib.server.Stream[StorageWriteRequest, StorageWriteResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.write(request)
        await stream.send_message(response)

    async def __rpc_delete(
        self,
        stream: "grpclib.server.Stream[StorageDeleteRequest, StorageDeleteResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete(request)
        await stream.send_message(response)

    async def __rpc_pre_sign_url(
        self,
        stream: "grpclib.server.Stream[StoragePreSignUrlRequest, StoragePreSignUrlResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.pre_sign_url(request)
        await stream.send_message(response)

    async def __rpc_list_files(
        self,
        stream: "grpclib.server.Stream[StorageListFilesRequest, StorageListFilesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.list_files(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.storage.v1.StorageService/Read": grpclib.const.Handler(
                self.__rpc_read,
                grpclib.const.Cardinality.UNARY_UNARY,
                StorageReadRequest,
                StorageReadResponse,
            ),
            "/nitric.storage.v1.StorageService/Write": grpclib.const.Handler(
                self.__rpc_write,
                grpclib.const.Cardinality.UNARY_UNARY,
                StorageWriteRequest,
                StorageWriteResponse,
            ),
            "/nitric.storage.v1.StorageService/Delete": grpclib.const.Handler(
                self.__rpc_delete,
                grpclib.const.Cardinality.UNARY_UNARY,
                StorageDeleteRequest,
                StorageDeleteResponse,
            ),
            "/nitric.storage.v1.StorageService/PreSignUrl": grpclib.const.Handler(
                self.__rpc_pre_sign_url,
                grpclib.const.Cardinality.UNARY_UNARY,
                StoragePreSignUrlRequest,
                StoragePreSignUrlResponse,
            ),
            "/nitric.storage.v1.StorageService/ListFiles": grpclib.const.Handler(
                self.__rpc_list_files,
                grpclib.const.Cardinality.UNARY_UNARY,
                StorageListFilesRequest,
                StorageListFilesResponse,
            ),
        }
